#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.Features.Transforms._FourierTransformFFTW3MPI import _FourierTransformFFTW3MPI
import operator
from xpdeint.Geometry.UniformDimensionRepresentation import UniformDimensionRepresentation
from xpdeint.Geometry.SplitUniformDimensionRepresentation import SplitUniformDimensionRepresentation
from xpdeint.Utilities import permutations

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.6.post2'
__CHEETAH_versionTuple__ = (3, 2, 6, 'post', 2)
__CHEETAH_genTime__ = 1634954792.9485748
__CHEETAH_genTimestamp__ = 'Sat Oct 23 13:06:32 2021'
__CHEETAH_src__ = '/home/mattias/xmds-3.0.0/admin/staging/xmds-3.1.0/xpdeint/Features/Transforms/FourierTransformFFTW3MPI.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class FourierTransformFFTW3MPI(_FourierTransformFFTW3MPI):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(FourierTransformFFTW3MPI, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: FFTW3 with MPI at line 31, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''FFTW3 with MPI''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def includes(self, **KWS):



        ## CHEETAH: generated from @def includes at line 34, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(FourierTransformFFTW3MPI, self).includes()
        if _v is not None: write(_filter(_v))
        # 
        write('''#include <fftw3-mpi.h>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def globals(self, **KWS):



        ## CHEETAH: generated from @def globals at line 41, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(FourierTransformFFTW3MPI, self).globals()
        if _v is not None: write(_filter(_v))
        # 
        for dimRep in [dimRep for dim in self.mpiDimensions for dimRep in dim.representations if dimRep.hasLocalOffset]: # generated from line 45, col 3
            write('''ptrdiff_t _block_size_''')
            _v = VFFSL(SL,"dimRep.name",True) # '${dimRep.name}' on line 46, col 23
            if _v is not None: write(_filter(_v, rawExpr='${dimRep.name}')) # from line 46, col 23.
            write(''' = FFTW_MPI_DEFAULT_BLOCK;
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def setLocalLatticeAndOffsetVariables(self, **KWS):



        ## CHEETAH: generated from @def setLocalLatticeAndOffsetVariables at line 51, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''// First work out the local lattice and offset for the geometry
ptrdiff_t _sizes[''')
        _v = VFFSL(SL,"len",False)(VFFSL(SL,"geometry.dimensions",True)) # '${len($geometry.dimensions)}' on line 54, col 18
        if _v is not None: write(_filter(_v, rawExpr='${len($geometry.dimensions)}')) # from line 54, col 18.
        write('''];
''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 55, col 1
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 55, col 1.
        write('''_mpi_init();
''')
        for firstMPIDimRep, secondMPIDimRep in permutations(*[dim.representations for dim in self.mpiDimensions]): # generated from line 56, col 3
            if not (firstMPIDimRep.hasLocalOffset and secondMPIDimRep.hasLocalOffset): # generated from line 57, col 5
                continue
            write('''_sizes[0] = ''')
            _v = VFFSL(SL,"firstMPIDimRep.globalLattice",True) # '${firstMPIDimRep.globalLattice}' on line 60, col 13
            if _v is not None: write(_filter(_v, rawExpr='${firstMPIDimRep.globalLattice}')) # from line 60, col 13.
            write('''; _sizes[1] = ''')
            _v = VFFSL(SL,"secondMPIDimRep.globalLattice",True) # '${secondMPIDimRep.globalLattice}' on line 60, col 58
            if _v is not None: write(_filter(_v, rawExpr='${secondMPIDimRep.globalLattice}')) # from line 60, col 58.
            write(''';
''')
            _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 61, col 1
            if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 61, col 1.
            write('''_mpi_local_size_many_transposed(
  2, _sizes, 1, _block_size_''')
            _v = VFFSL(SL,"firstMPIDimRep.name",True) # '${firstMPIDimRep.name}' on line 62, col 29
            if _v is not None: write(_filter(_v, rawExpr='${firstMPIDimRep.name}')) # from line 62, col 29.
            write(''', _block_size_''')
            _v = VFFSL(SL,"secondMPIDimRep.name",True) # '${secondMPIDimRep.name}' on line 62, col 65
            if _v is not None: write(_filter(_v, rawExpr='${secondMPIDimRep.name}')) # from line 62, col 65.
            write(''', MPI_COMM_WORLD,
  &''')
            _v = VFFSL(SL,"firstMPIDimRep.localLattice",True) # '${firstMPIDimRep.localLattice}' on line 63, col 4
            if _v is not None: write(_filter(_v, rawExpr='${firstMPIDimRep.localLattice}')) # from line 63, col 4.
            write(''', &''')
            _v = VFFSL(SL,"firstMPIDimRep.localOffset",True) # '${firstMPIDimRep.localOffset}' on line 63, col 37
            if _v is not None: write(_filter(_v, rawExpr='${firstMPIDimRep.localOffset}')) # from line 63, col 37.
            write(''',
  &''')
            _v = VFFSL(SL,"secondMPIDimRep.localLattice",True) # '${secondMPIDimRep.localLattice}' on line 64, col 4
            if _v is not None: write(_filter(_v, rawExpr='${secondMPIDimRep.localLattice}')) # from line 64, col 4.
            write(''', &''')
            _v = VFFSL(SL,"secondMPIDimRep.localOffset",True) # '${secondMPIDimRep.localOffset}' on line 64, col 38
            if _v is not None: write(_filter(_v, rawExpr='${secondMPIDimRep.localOffset}')) # from line 64, col 38.
            write('''
);

if (_rank == 0) {
  _block_size_''')
            _v = VFFSL(SL,"firstMPIDimRep.name",True) # '${firstMPIDimRep.name}' on line 68, col 15
            if _v is not None: write(_filter(_v, rawExpr='${firstMPIDimRep.name}')) # from line 68, col 15.
            write(''' = ''')
            _v = VFFSL(SL,"firstMPIDimRep.localLattice",True) # '${firstMPIDimRep.localLattice}' on line 68, col 40
            if _v is not None: write(_filter(_v, rawExpr='${firstMPIDimRep.localLattice}')) # from line 68, col 40.
            write(''';
  _block_size_''')
            _v = VFFSL(SL,"secondMPIDimRep.name",True) # '${secondMPIDimRep.name}' on line 69, col 15
            if _v is not None: write(_filter(_v, rawExpr='${secondMPIDimRep.name}')) # from line 69, col 15.
            write(''' = ''')
            _v = VFFSL(SL,"secondMPIDimRep.localLattice",True) # '${secondMPIDimRep.localLattice}' on line 69, col 41
            if _v is not None: write(_filter(_v, rawExpr='${secondMPIDimRep.localLattice}')) # from line 69, col 41.
            write(''';
}
MPI_Bcast(&_block_size_''')
            _v = VFFSL(SL,"firstMPIDimRep.name",True) # '${firstMPIDimRep.name}' on line 71, col 24
            if _v is not None: write(_filter(_v, rawExpr='${firstMPIDimRep.name}')) # from line 71, col 24.
            write(''', sizeof(ptrdiff_t), MPI_BYTE, 0, MPI_COMM_WORLD);
MPI_Bcast(&_block_size_''')
            _v = VFFSL(SL,"secondMPIDimRep.name",True) # '${secondMPIDimRep.name}' on line 72, col 24
            if _v is not None: write(_filter(_v, rawExpr='${secondMPIDimRep.name}')) # from line 72, col 24.
            write(''', sizeof(ptrdiff_t), MPI_BYTE, 0, MPI_COMM_WORLD);

''')
        # 
        firstMPIDim, secondMPIDim = VFFSL(SL,"mpiDimensions",True)
        for field in VFFSL(SL,"fields",True): # generated from line 77, col 3
            if field.name == 'geometry' or not field.isDistributed: # generated from line 78, col 5
                continue
            # 
            #  Set the local_lattice and local_offset variables based on the
            #  values for the geometry's version of these
            fieldMPIDim1 = field.dimensionWithName(firstMPIDim.name)
            fieldMPIDim2 = field.dimensionWithName(secondMPIDim.name)
            for fieldDim, geometryDim in [(fieldMPIDim1, firstMPIDim), (fieldMPIDim2, secondMPIDim)]: # generated from line 86, col 5
                for fieldRep, geometryRep in zip(fieldDim.representations, geometryDim.representations): # generated from line 87, col 7
                    if (not fieldRep) or (not fieldRep.hasLocalOffset) or (not fieldRep.parent is fieldDim): # generated from line 88, col 9
                        continue
                    write("""// Set the local lattice and offset variables for the '""")
                    _v = VFFSL(SL,"field.name",True) # '${field.name}' on line 91, col 56
                    if _v is not None: write(_filter(_v, rawExpr='${field.name}')) # from line 91, col 56.
                    write("""' field
""")
                    if fieldRep == geometryRep: # generated from line 92, col 9
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 93, col 1
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 93, col 1.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 93, col 28
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 93, col 28.
                        write(''';
''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 94, col 1
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 94, col 1.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 94, col 27
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 94, col 27.
                        write(''';
''')
                    elif fieldRep.reductionMethod == fieldRep.ReductionMethod.fixedRange: # generated from line 95, col 9
                        #  In this case we are in 'x' space and are subdividing a distributed dimension
                        #  fixedRange reduction method means we take every nth point.
                        write('''ptrdiff_t _''')
                        _v = VFFSL(SL,"field.name",True) # '${field.name}' on line 98, col 12
                        if _v is not None: write(_filter(_v, rawExpr='${field.name}')) # from line 98, col 12.
                        write('''_''')
                        _v = VFFSL(SL,"fieldRep.name",True) # '${fieldRep.name}' on line 98, col 26
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.name}')) # from line 98, col 26.
                        write('''_skip_size = ''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # '${geometryRep.globalLattice}' on line 98, col 55
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.globalLattice}')) # from line 98, col 55.
                        write('''/''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 98, col 84
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 98, col 84.
                        write(''';
if (_rank == 0) {
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 100, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 100, col 3.
                        write('''  = 0;
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 101, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 101, col 3.
                        write(''' = (''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 101, col 31
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 101, col 31.
                        write('''-1)/_''')
                        _v = VFFSL(SL,"field.name",True) # '${field.name}' on line 101, col 63
                        if _v is not None: write(_filter(_v, rawExpr='${field.name}')) # from line 101, col 63.
                        write('''_''')
                        _v = VFFSL(SL,"fieldRep.name",True) # '${fieldRep.name}' on line 101, col 77
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.name}')) # from line 101, col 77.
                        write('''_skip_size + 1;
} else {
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 103, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 103, col 3.
                        write('''  = (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 103, col 31
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 103, col 31.
                        write('''-1)/_''')
                        _v = VFFSL(SL,"field.name",True) # '${field.name}' on line 103, col 62
                        if _v is not None: write(_filter(_v, rawExpr='${field.name}')) # from line 103, col 62.
                        write('''_''')
                        _v = VFFSL(SL,"fieldRep.name",True) # '${fieldRep.name}' on line 103, col 76
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.name}')) # from line 103, col 76.
                        write('''_skip_size + 1;
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 104, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 104, col 3.
                        write(''' = (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 104, col 31
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 104, col 31.
                        write(''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 104, col 60
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 104, col 60.
                        write(''' - 1)/_''')
                        _v = VFFSL(SL,"field.name",True) # '${field.name}' on line 104, col 94
                        if _v is not None: write(_filter(_v, rawExpr='${field.name}')) # from line 104, col 94.
                        write('''_''')
                        _v = VFFSL(SL,"fieldRep.name",True) # '${fieldRep.name}' on line 104, col 108
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.name}')) # from line 104, col 108.
                        write('''_skip_size
                             + 1 - ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 105, col 36
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 105, col 36.
                        write(''';
}
''')
                    elif isinstance(fieldRep, UniformDimensionRepresentation): # generated from line 107, col 9
                        #  In this case, we are in 'k' space and may be subdividing a UniformDimensionRepresentation (dct/dst)
                        #  Note that this is a fixedStep reduction method
                        write('''if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 110, col 5
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 110, col 5.
                        write(''' >= ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 110, col 35
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 110, col 35.
                        write(''') {
  // No points here
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 112, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 112, col 3.
                        write(''' = 0;
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 113, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 113, col 3.
                        write(''' = 0;
} else if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 114, col 12
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 114, col 12.
                        write(''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 114, col 41
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 114, col 41.
                        write(''' > ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 114, col 71
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 114, col 71.
                        write('''){
  // The upper edge is here
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 116, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 116, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 116, col 29
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 116, col 29.
                        write(''';
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 117, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 117, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 117, col 30
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 117, col 30.
                        write(''' - ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 117, col 58
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 117, col 58.
                        write(''';
} else {
  // somewhere near the start
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 120, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 120, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 120, col 29
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 120, col 29.
                        write(''';
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 121, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 121, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 121, col 30
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 121, col 30.
                        write(''';
}
''')
                    elif isinstance(fieldRep, SplitUniformDimensionRepresentation): # generated from line 123, col 9
                        #  In this case, we are in 'k' space and may be subdividing a SplitUniformDimensionRepresentation (dft)
                        #  Note that this is a fixedStep reduction method
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 126, col 1
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 126, col 1.
                        write(''' = -1;
if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 127, col 5
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 127, col 5.
                        write(''' >= (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 127, col 36
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 127, col 36.
                        write("""+1)/2) {
  // No points due to positive 'k' values.
} else if (""")
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 129, col 12
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 129, col 12.
                        write(''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 129, col 41
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 129, col 41.
                        write(''' > (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 129, col 72
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 129, col 72.
                        write('''+1)/2) {
  // the upper edge of the positive values are here
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 131, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 131, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 131, col 29
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 131, col 29.
                        write(''';
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 132, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 132, col 3.
                        write(''' = (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 132, col 31
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 132, col 31.
                        write('''+1)/2 - ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 132, col 64
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 132, col 64.
                        write(''';
} else if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 133, col 12
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 133, col 12.
                        write(''' < (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 133, col 42
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 133, col 42.
                        write('''+1)/2) {
  // somewhere near the start of the positive values
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 135, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 135, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 135, col 29
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 135, col 29.
                        write(''';
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 136, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 136, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 136, col 30
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 136, col 30.
                        write(''';
}

if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 139, col 5
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 139, col 5.
                        write(''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 139, col 34
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 139, col 34.
                        write(''' <= ''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # '${geometryRep.globalLattice}' on line 139, col 65
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.globalLattice}')) # from line 139, col 65.
                        write(''' - ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 139, col 96
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 139, col 96.
                        write("""/2) {
  // No points due to negative 'k' values.
} else if (""")
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 141, col 12
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 141, col 12.
                        write(''' < ''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # '${geometryRep.globalLattice}' on line 141, col 41
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.globalLattice}')) # from line 141, col 41.
                        write(''' - ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 141, col 72
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 141, col 72.
                        write('''/2) {
  // the lower edge of the negative values are here
  if (''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 143, col 7
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 143, col 7.
                        write(''' == -1)
    ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 144, col 5
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 144, col 5.
                        write(''' = (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 144, col 32
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 144, col 32.
                        write('''+1)/2;
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 145, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 145, col 3.
                        write(''' += ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 145, col 31
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 145, col 31.
                        write(''' - (''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # '${geometryRep.globalLattice}' on line 145, col 62
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.globalLattice}')) # from line 145, col 62.
                        write('''-''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 145, col 91
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 145, col 91.
                        write('''/2-''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 145, col 119
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 145, col 119.
                        write(''');
} else if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 146, col 12
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 146, col 12.
                        write(''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 146, col 41
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 146, col 41.
                        write(''' > ''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # '${geometryRep.globalLattice}' on line 146, col 71
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.globalLattice}')) # from line 146, col 71.
                        write(''' - ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 146, col 102
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 146, col 102.
                        write('''/2) {
  // somewhere near the end of the negative values
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # '${fieldRep.localOffset}' on line 148, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localOffset}')) # from line 148, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # '${geometryRep.localOffset}' on line 148, col 29
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localOffset}')) # from line 148, col 29.
                        write(''' - (''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # '${geometryRep.globalLattice}' on line 148, col 59
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.globalLattice}')) # from line 148, col 59.
                        write('''-''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # '${fieldRep.globalLattice}' on line 148, col 88
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.globalLattice}')) # from line 148, col 88.
                        write(''');
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # '${fieldRep.localLattice}' on line 149, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldRep.localLattice}')) # from line 149, col 3.
                        write(''' = ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # '${geometryRep.localLattice}' on line 149, col 30
                        if _v is not None: write(_filter(_v, rawExpr='${geometryRep.localLattice}')) # from line 149, col 30.
                        write(''';
}
''')
                    else: # generated from line 151, col 9
                        assert False
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def setVectorAllocSizes(self, vectors, **KWS):



        ## CHEETAH: generated from @def setVectorAllocSizes($vectors) at line 160, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''ptrdiff_t _local_alloc_size, _tmp;
''')
        for tID, transformation in self.transformations: # generated from line 163, col 3
            if not transformation.get('distributedTransform', False): # generated from line 164, col 5
                continue
            untransformedDimRepBasis, transformedDimRepBasis = transformation['transformPair']
            for dimNum, dimRep in enumerate(untransformedDimRepBasis): # generated from line 168, col 5
                write('''_sizes[''')
                _v = VFFSL(SL,"dimNum",True) # '${dimNum}' on line 169, col 8
                if _v is not None: write(_filter(_v, rawExpr='${dimNum}')) # from line 169, col 8.
                write('''] = ''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # '${dimRep.globalLattice}' on line 169, col 21
                if _v is not None: write(_filter(_v, rawExpr='${dimRep.globalLattice}')) # from line 169, col 21.
                write(''';
''')
            write('''_local_alloc_size = ''')
            _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 171, col 21
            if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 171, col 21.
            write('''_mpi_local_size_many_transposed(
  ''')
            _v = VFFSL(SL,"len",False)(untransformedDimRepBasis) # '${len(untransformedDimRepBasis)}' on line 172, col 3
            if _v is not None: write(_filter(_v, rawExpr='${len(untransformedDimRepBasis)}')) # from line 172, col 3.
            write(''', _sizes,
  (ptrdiff_t)''')
            _v = VFFSL(SL,"transformation",True)['postfixLatticeString'] # "${transformation['postfixLatticeString']}" on line 173, col 14
            if _v is not None: write(_filter(_v, rawExpr="${transformation['postfixLatticeString']}")) # from line 173, col 14.
            write(''',
  _block_size_''')
            _v = VFN(VFFSL(SL,"untransformedDimRepBasis",True)[0],"name",True) # '${untransformedDimRepBasis[0].name}' on line 174, col 15
            if _v is not None: write(_filter(_v, rawExpr='${untransformedDimRepBasis[0].name}')) # from line 174, col 15.
            write(''', _block_size_''')
            _v = VFN(VFFSL(SL,"transformedDimRepBasis",True)[0],"name",True) # '${transformedDimRepBasis[0].name}' on line 174, col 64
            if _v is not None: write(_filter(_v, rawExpr='${transformedDimRepBasis[0].name}')) # from line 174, col 64.
            write(''',
  MPI_COMM_WORLD,
  &_tmp, &_tmp, &_tmp, &_tmp /* Local lattices and offsets were obtained above */
);
''')
            for vector in transformation['vectors']: # generated from line 178, col 5
                _v = VFFSL(SL,"vector.allocSize",True) # '${vector.allocSize}' on line 179, col 1
                if _v is not None: write(_filter(_v, rawExpr='${vector.allocSize}')) # from line 179, col 1.
                write(''' = MAX(''')
                _v = VFFSL(SL,"vector.allocSize",True) # '${vector.allocSize}' on line 179, col 27
                if _v is not None: write(_filter(_v, rawExpr='${vector.allocSize}')) # from line 179, col 27.
                write(''', (_local_alloc_size''')
                _v = '+1) / 2' if vector.type == 'complex' and transformation.get('transformType', 'real') == 'real' else ')' # "${'+1) / 2' if vector.type == 'complex' and transformation.get('transformType', 'real') == 'real' else ')'}" on line 179, col 66
                if _v is not None: write(_filter(_v, rawExpr="${'+1) / 2' if vector.type == 'complex' and transformation.get('transformType', 'real') == 'real' else ')'}")) # from line 179, col 66.
                write(''');
''')
            write('''
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transposeTransformFunction(self, transformID, transformDict, function, **KWS):



        ## CHEETAH: generated from @def transposeTransformFunction(transformID, transformDict, function) at line 186, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        runtimePrefix, prefixLattice, postfixLattice, runtimePostfix = transformDict['transformSpecifier']
        flags = ' | FFTW_MPI_TRANSPOSED_IN | FFTW_MPI_TRANSPOSED_OUT' if transformDict['transposedOrder'] else ''
        flags += ' | FFTW_DESTROY_INPUT' if transformDict.get('outOfPlace', False) else ''
        write('''// _prefix_lattice should be ''')
        _v = VFFSL(SL,"prefixLattice",True) # '${prefixLattice}' on line 191, col 30
        if _v is not None: write(_filter(_v, rawExpr='${prefixLattice}')) # from line 191, col 30.
        write('''
// _postfix_lattice should be ''')
        _v = VFFSL(SL,"postfixLattice",True) # '${postfixLattice}' on line 192, col 31
        if _v is not None: write(_filter(_v, rawExpr='${postfixLattice}')) # from line 192, col 31.
        write('''
static ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 193, col 8
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 193, col 8.
        write('''_plan _fftw_forward_plan = NULL;
static ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 194, col 8
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 194, col 8.
        write('''_plan _fftw_backward_plan = NULL;

if (!_fftw_forward_plan) {
  _LOG(_SIMULATION_LOG_LEVEL, "Planning for ''')
        _v = VFFSL(SL,"function.description",True) # '${function.description}' on line 197, col 45
        if _v is not None: write(_filter(_v, rawExpr='${function.description}')) # from line 197, col 45.
        write('''...");
''')
        transformPair = transformDict['transformPair']
        if transformDict['transposedOrder']: # generated from line 199, col 3
            #  Reverse the order
            transformPair = transformPair[::-1]
        dataOut = '_data_out' if transformDict.get('outOfPlace', False) else '_data_in'
        write('''  
  _fftw_forward_plan = ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 205, col 24
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 205, col 24.
        write('''_mpi_plan_many_transpose(
    ''')
        _v = ', '.join(dr.globalLattice for dr in transformPair[0]) # "${', '.join(dr.globalLattice for dr in transformPair[0])}" on line 206, col 5
        if _v is not None: write(_filter(_v, rawExpr="${', '.join(dr.globalLattice for dr in transformPair[0])}")) # from line 206, col 5.
        write(''',
    _postfix_lattice, _block_size_''')
        _v = VFN(VFFSL(SL,"transformPair",True)[0][0],"name",True) # '${transformPair[0][0].name}' on line 207, col 35
        if _v is not None: write(_filter(_v, rawExpr='${transformPair[0][0].name}')) # from line 207, col 35.
        write(''', _block_size_''')
        _v = VFN(VFFSL(SL,"transformPair",True)[1][0],"name",True) # '${transformPair[1][0].name}' on line 207, col 76
        if _v is not None: write(_filter(_v, rawExpr='${transformPair[1][0].name}')) # from line 207, col 76.
        write(''',
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # '$dataOut' on line 209, col 29
        if _v is not None: write(_filter(_v, rawExpr='$dataOut')) # from line 209, col 29.
        write('''),
    MPI_COMM_WORLD, ''')
        _v = VFFSL(SL,"planType",True) # '${planType}' on line 210, col 21
        if _v is not None: write(_filter(_v, rawExpr='${planType}')) # from line 210, col 21.
        _v = VFFSL(SL,"flags",True) # '${flags}' on line 210, col 32
        if _v is not None: write(_filter(_v, rawExpr='${flags}')) # from line 210, col 32.
        write('''
  );
  
  if (!_fftw_forward_plan)
    _LOG(_ERROR_LOG_LEVEL, "(%s: %i) Unable to create forward mpi transform plan.\\n", __FILE__, __LINE__);
  
  _fftw_backward_plan = ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 216, col 25
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 216, col 25.
        write('''_mpi_plan_many_transpose(
    ''')
        _v = ', '.join(dr.globalLattice for dr in transformPair[1]) # "${', '.join(dr.globalLattice for dr in transformPair[1])}" on line 217, col 5
        if _v is not None: write(_filter(_v, rawExpr="${', '.join(dr.globalLattice for dr in transformPair[1])}")) # from line 217, col 5.
        write(''',
    _postfix_lattice, _block_size_''')
        _v = VFN(VFFSL(SL,"transformPair",True)[1][0],"name",True) # '${transformPair[1][0].name}' on line 218, col 35
        if _v is not None: write(_filter(_v, rawExpr='${transformPair[1][0].name}')) # from line 218, col 35.
        write(''', _block_size_''')
        _v = VFN(VFFSL(SL,"transformPair",True)[0][0],"name",True) # '${transformPair[0][0].name}' on line 218, col 76
        if _v is not None: write(_filter(_v, rawExpr='${transformPair[0][0].name}')) # from line 218, col 76.
        write(''',
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # '$dataOut' on line 220, col 29
        if _v is not None: write(_filter(_v, rawExpr='$dataOut')) # from line 220, col 29.
        write('''),
    MPI_COMM_WORLD, ''')
        _v = VFFSL(SL,"planType",True) # '${planType}' on line 221, col 21
        if _v is not None: write(_filter(_v, rawExpr='${planType}')) # from line 221, col 21.
        _v = VFFSL(SL,"flags",True) # '${flags}' on line 221, col 32
        if _v is not None: write(_filter(_v, rawExpr='${flags}')) # from line 221, col 32.
        write('''
  );
  
  if (!_fftw_backward_plan)
    _LOG(_ERROR_LOG_LEVEL, "(%s: %i) Unable to create backward mpi transform plan.\\n", __FILE__, __LINE__);
  
  // Save wisdom
  #if CFG_OSAPI == CFG_OSAPI_POSIX
  ''')
        _v = VFFSL(SL,"saveWisdom",True) # '${saveWisdom, autoIndent=True}' on line 229, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr='${saveWisdom, autoIndent=True}')) # from line 229, col 3.
        write('''  #endif // POSIX
  
  _LOG(_SIMULATION_LOG_LEVEL, " done.\\n");
}

if (_forward) {
  ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 236, col 3
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 236, col 3.
        write('''_execute_r2r(
    _fftw_forward_plan,
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # '${dataOut}' on line 239, col 29
        if _v is not None: write(_filter(_v, rawExpr='${dataOut}')) # from line 239, col 29.
        write(''')
  );
} else {
  ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 242, col 3
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 242, col 3.
        write('''_execute_r2r(
    _fftw_backward_plan,
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # '${dataOut}' on line 245, col 29
        if _v is not None: write(_filter(_v, rawExpr='${dataOut}')) # from line 245, col 29.
        write(''')
  );
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def distributedTransformFunction(self, transformID, transformDict, function, **KWS):



        ## CHEETAH: generated from @def distributedTransformFunction(transformID, transformDict, function) at line 251, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        runtimePrefix, prefixLattice, postfixLattice, runtimePostfix = transformDict['transformSpecifier']
        write('''// _prefix_lattice should be ''')
        _v = VFFSL(SL,"prefixLattice",True) # '${prefixLattice}' on line 254, col 30
        if _v is not None: write(_filter(_v, rawExpr='${prefixLattice}')) # from line 254, col 30.
        _v = ''.join([' * ' + runtimeLattice for runtimeLattice in runtimePrefix]) # "${''.join([' * ' + runtimeLattice for runtimeLattice in runtimePrefix])}" on line 254, col 46
        if _v is not None: write(_filter(_v, rawExpr="${''.join([' * ' + runtimeLattice for runtimeLattice in runtimePrefix])}")) # from line 254, col 46.
        write('''
// _postfix_lattice should be ''')
        _v = VFFSL(SL,"postfixLattice",True) # '${postfixLattice}' on line 255, col 31
        if _v is not None: write(_filter(_v, rawExpr='${postfixLattice}')) # from line 255, col 31.
        _v = ''.join([' * ' + runtimeLattice for runtimeLattice in runtimePostfix]) # "${''.join([' * ' + runtimeLattice for runtimeLattice in runtimePostfix])}" on line 255, col 48
        if _v is not None: write(_filter(_v, rawExpr="${''.join([' * ' + runtimeLattice for runtimeLattice in runtimePostfix])}")) # from line 255, col 48.
        write('''
static ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 256, col 8
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 256, col 8.
        write('''_plan _fftw_forward_plan = NULL;
static ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 257, col 8
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 257, col 8.
        write('''_plan _fftw_backward_plan = NULL;

if (!_fftw_forward_plan) {
  _LOG(_SIMULATION_LOG_LEVEL, "Planning for ''')
        _v = VFFSL(SL,"function.description",True) # '${function.description}' on line 260, col 45
        if _v is not None: write(_filter(_v, rawExpr='${function.description}')) # from line 260, col 45.
        write('''...");
''')
        transformPair = transformDict['transformPair']
        dimensionsBeingTransformed = len(transformPair[0])
        transformType = transformDict['transformType']
        dataOut = '_data_out' if transformDict.get('outOfPlace', False) else '_data_in'
        flags = ' | FFTW_DESTROY_INPUT' if transformDict.get('outOfPlace', False) else ''
        write('''  ptrdiff_t _transform_sizes[''')
        _v = VFFSL(SL,"dimensionsBeingTransformed",True) # '${dimensionsBeingTransformed}' on line 266, col 30
        if _v is not None: write(_filter(_v, rawExpr='${dimensionsBeingTransformed}')) # from line 266, col 30.
        write('''];
''')
        if transformType == 'real': # generated from line 267, col 3
            write('''  ''')
            _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 268, col 3
            if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 268, col 3.
            write('''_r2r_kind _r2r_kinds[''')
            _v = VFFSL(SL,"dimensionsBeingTransformed",True) # '${dimensionsBeingTransformed}' on line 268, col 37
            if _v is not None: write(_filter(_v, rawExpr='${dimensionsBeingTransformed}')) # from line 268, col 37.
            write('''];
''')
        write('''  
  int _transform_sizes_index = 0;
  
''')
        # 
        for dimID, dimRep in enumerate(transformPair[0]): # generated from line 274, col 3
            write('''  _transform_sizes[_transform_sizes_index++] = ''')
            _v = VFFSL(SL,"dimRep.globalLattice",True) # '${dimRep.globalLattice}' on line 275, col 48
            if _v is not None: write(_filter(_v, rawExpr='${dimRep.globalLattice}')) # from line 275, col 48.
            write(''';
''')
        write('''  
''')
        if transformType == 'complex': # generated from line 278, col 3
            guruPlanFunction = self.createGuruMPIDFTPlanInDirection
        else: # generated from line 280, col 3
            guruPlanFunction = self.createGuruMPIR2RPlanInDirection
        # 
        write('''  ''')
        _v = VFFSL(SL,"guruPlanFunction",False)(
      transformDict, 'forward', dataOut,
      '_block_size_' + transformPair[0][0].name, '_block_size_' + transformPair[1][0].name, 'FFTW_MPI_TRANSPOSED_OUT', flags
    )
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${guruPlanFunction(\n      transformDict, 'forward', dataOut,\n      '_block_size_' + transformPair[0][0].name, '_block_size_' + transformPair[1][0].name, 'FFTW_MPI_TRANSPOSED_OUT', flags\n    ), autoIndent=True}")) # from line 284, col 3.
        write('''  ''')
        _v = VFFSL(SL,"guruPlanFunction",False)(
      transformDict, 'backward', dataOut,
      '_block_size_' + transformPair[1][0].name, '_block_size_' + transformPair[0][0].name, 'FFTW_MPI_TRANSPOSED_IN', flags
    )
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${guruPlanFunction(\n      transformDict, 'backward', dataOut,\n      '_block_size_' + transformPair[1][0].name, '_block_size_' + transformPair[0][0].name, 'FFTW_MPI_TRANSPOSED_IN', flags\n    ), autoIndent=True}")) # from line 288, col 3.
        write('''  
  // Save wisdom
  #if CFG_OSAPI == CFG_OSAPI_POSIX
  ''')
        _v = VFFSL(SL,"saveWisdom",True) # '${saveWisdom, autoIndent=True}' on line 295, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr='${saveWisdom, autoIndent=True}')) # from line 295, col 3.
        write('''  #endif // POSIX
  
  _LOG(_SIMULATION_LOG_LEVEL, " done.\\n");
}

if (_forward) {
  ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 302, col 3
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 302, col 3.
        write('''_execute_r2r(
    _fftw_forward_plan,
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # '${dataOut}' on line 305, col 29
        if _v is not None: write(_filter(_v, rawExpr='${dataOut}')) # from line 305, col 29.
        write(''')
  );
} else {
  ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 308, col 3
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 308, col 3.
        write('''_execute_r2r(
    _fftw_backward_plan,
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # '${dataOut}' on line 311, col 29
        if _v is not None: write(_filter(_v, rawExpr='${dataOut}')) # from line 311, col 29.
        write(''')
  );
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def createGuruMPIDFTPlanInDirection(self, transformDict, direction, dataOut, inBlockSize, outBlockSize, transposedState, flags, **KWS):



        ## CHEETAH: generated from @def createGuruMPIDFTPlanInDirection($transformDict, $direction, $dataOut, $inBlockSize, $outBlockSize, $transposedState, $flags) at line 317, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''_fftw_''')
        _v = VFFSL(SL,"direction",True) # '${direction}' on line 319, col 7
        if _v is not None: write(_filter(_v, rawExpr='${direction}')) # from line 319, col 7.
        write('''_plan = ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 319, col 27
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 319, col 27.
        write('''_mpi_plan_many_dft(
  _transform_sizes_index, _transform_sizes, _postfix_lattice,
  ''')
        _v = VFFSL(SL,"inBlockSize",True) # '${inBlockSize}' on line 321, col 3
        if _v is not None: write(_filter(_v, rawExpr='${inBlockSize}')) # from line 321, col 3.
        write(''', ''')
        _v = VFFSL(SL,"outBlockSize",True) # '${outBlockSize}' on line 321, col 19
        if _v is not None: write(_filter(_v, rawExpr='${outBlockSize}')) # from line 321, col 19.
        write(''',
  reinterpret_cast<''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 322, col 20
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 322, col 20.
        write('''_complex*>(_data_in),
  reinterpret_cast<''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 323, col 20
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 323, col 20.
        write('''_complex*>(''')
        _v = VFFSL(SL,"dataOut",True) # '${dataOut}' on line 323, col 44
        if _v is not None: write(_filter(_v, rawExpr='${dataOut}')) # from line 323, col 44.
        write('''),
  MPI_COMM_WORLD, FFTW_''')
        _v = VFN(VFFSL(SL,"direction",True),"upper",False)() # '${direction.upper()}' on line 324, col 24
        if _v is not None: write(_filter(_v, rawExpr='${direction.upper()}')) # from line 324, col 24.
        write(''', ''')
        _v = VFFSL(SL,"planType",True) # '${planType}' on line 324, col 46
        if _v is not None: write(_filter(_v, rawExpr='${planType}')) # from line 324, col 46.
        write(''' | ''')
        _v = VFFSL(SL,"transposedState",True) # '${transposedState}' on line 324, col 60
        if _v is not None: write(_filter(_v, rawExpr='${transposedState}')) # from line 324, col 60.
        _v = VFFSL(SL,"flags",True) # '${flags}' on line 324, col 78
        if _v is not None: write(_filter(_v, rawExpr='${flags}')) # from line 324, col 78.
        write('''
);
if (!_fftw_''')
        _v = VFFSL(SL,"direction",True) # '${direction}' on line 326, col 12
        if _v is not None: write(_filter(_v, rawExpr='${direction}')) # from line 326, col 12.
        write('''_plan)
  _LOG(_ERROR_LOG_LEVEL, "(%s: %i) Unable to create ''')
        _v = VFFSL(SL,"direction",True) # '${direction}' on line 327, col 53
        if _v is not None: write(_filter(_v, rawExpr='${direction}')) # from line 327, col 53.
        write(''' mpi dft plan.\\n", __FILE__, __LINE__);

''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def createGuruMPIR2RPlanInDirection(self, transformDict, direction, dataOut, inBlockSize, outBlockSize, transposedState, flags, **KWS):



        ## CHEETAH: generated from @def createGuruMPIR2RPlanInDirection($transformDict, $direction, $dataOut, $inBlockSize, $outBlockSize, $transposedState, $flags) at line 332, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        for idx, dimRep in enumerate(transformDict['transformPair'][0]): # generated from line 334, col 3
            write('''_r2r_kinds[''')
            _v = VFFSL(SL,"idx",True) # '${idx}' on line 335, col 12
            if _v is not None: write(_filter(_v, rawExpr='${idx}')) # from line 335, col 12.
            write('''] = ''')
            _v = VFFSL(SL,"r2rKindForDimensionAndDirection",False)(dimRep.name, direction) # '${r2rKindForDimensionAndDirection(dimRep.name, direction)}' on line 335, col 22
            if _v is not None: write(_filter(_v, rawExpr='${r2rKindForDimensionAndDirection(dimRep.name, direction)}')) # from line 335, col 22.
            write(''';
''')
        write('''
_fftw_''')
        _v = VFFSL(SL,"direction",True) # '${direction}' on line 338, col 7
        if _v is not None: write(_filter(_v, rawExpr='${direction}')) # from line 338, col 7.
        write('''_plan = ''')
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 338, col 27
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 338, col 27.
        write('''_mpi_plan_many_r2r(
  _transform_sizes_index, _transform_sizes, _postfix_lattice,
  ''')
        _v = VFFSL(SL,"inBlockSize",True) # '${inBlockSize}' on line 340, col 3
        if _v is not None: write(_filter(_v, rawExpr='${inBlockSize}')) # from line 340, col 3.
        write(''', ''')
        _v = VFFSL(SL,"outBlockSize",True) # '${outBlockSize}' on line 340, col 19
        if _v is not None: write(_filter(_v, rawExpr='${outBlockSize}')) # from line 340, col 19.
        write(''',
  reinterpret_cast<real*>(_data_in),
  reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # '${dataOut}' on line 342, col 27
        if _v is not None: write(_filter(_v, rawExpr='${dataOut}')) # from line 342, col 27.
        write('''),
  MPI_COMM_WORLD, _r2r_kinds, ''')
        _v = VFFSL(SL,"planType",True) # '${planType}' on line 343, col 31
        if _v is not None: write(_filter(_v, rawExpr='${planType}')) # from line 343, col 31.
        write(''' | ''')
        _v = VFFSL(SL,"transposedState",True) # '${transposedState}' on line 343, col 45
        if _v is not None: write(_filter(_v, rawExpr='${transposedState}')) # from line 343, col 45.
        _v = VFFSL(SL,"flags",True) # '${flags}' on line 343, col 63
        if _v is not None: write(_filter(_v, rawExpr='${flags}')) # from line 343, col 63.
        write('''
);

if (!_fftw_''')
        _v = VFFSL(SL,"direction",True) # '${direction}' on line 346, col 12
        if _v is not None: write(_filter(_v, rawExpr='${direction}')) # from line 346, col 12.
        write('''_plan)
  _LOG(_ERROR_LOG_LEVEL, "(%s: %i) Unable to create ''')
        _v = VFFSL(SL,"direction",True) # '${direction}' on line 347, col 53
        if _v is not None: write(_filter(_v, rawExpr='${direction}')) # from line 347, col 53.
        write(''' mpi r2r plan.\\n", __FILE__, __LINE__);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loadWisdom(self, **KWS):



        ## CHEETAH: generated from @def loadWisdom at line 352, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(FourierTransformFFTW3MPI, self).loadWisdom()
        if _v is not None: write(_filter(_v))
        # 
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 356, col 1
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 356, col 1.
        write('''_mpi_broadcast_wisdom(MPI_COMM_WORLD);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def saveWisdom(self, **KWS):



        ## CHEETAH: generated from @def saveWisdom at line 360, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = VFFSL(SL,"fftwPrefix",True) # '${fftwPrefix}' on line 362, col 1
        if _v is not None: write(_filter(_v, rawExpr='${fftwPrefix}')) # from line 362, col 1.
        write('''_mpi_gather_wisdom(MPI_COMM_WORLD);
''')
        # 
        _v = super(FourierTransformFFTW3MPI, self).saveWisdom()
        if _v is not None: write(_filter(_v))
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # FourierTransformFFTW3MPI.tmpl
        # 
        # Created by Graham Dennis on 2008-06-06.
        # 
        # Copyright (c) 2008-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''












''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    fftwSuffix = 'mpi'

    _mainCheetahMethod_for_FourierTransformFFTW3MPI = 'writeBody'

## END CLASS DEFINITION

if not hasattr(FourierTransformFFTW3MPI, '_initCheetahAttributes'):
    templateAPIClass = getattr(FourierTransformFFTW3MPI,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(FourierTransformFFTW3MPI)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=FourierTransformFFTW3MPI()).run()


