/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_filter.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_filter.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_FILTER_H
#define XMDS_FILTER_H

#include <xmds_segment.h>
#include <xmds_sequence.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsFilter
// *****************************************************************************
// *****************************************************************************

//! xmds filter class
class xmdsFilter : public xmdsSegment {

  public :

    //! Constructor for xmdsFilter object
    xmdsFilter(
         const xmdsSimulation *const yourSimulation,
         const bool& yourVerboseMode);

  //! Destructor
  ~xmdsFilter();

  //! Processes filter element
  void processElement(
                      const Element *const yourElement);

  //! Whether or not the segment needs to run when the simulation is in overtime
  bool runsInOvertime() const;

 protected:

  //! Returns the code element list
  list<XMLString>* codeElementList();

  //! Returns the code element list
  const list<XMLString>* codeElementList() const;

  //! Returns number of non-loop propagation elements
  long unsigned int numNonLoopPropagation() const;

  //! Returns the non-loop propagation code list
  list<XMLString>* nonLoopPropagationCodeList();

  //! Returns the non-loop propagation code list
  const list<XMLString>* nonLoopPropagationCodeList() const;

  //! Returns number of integrate moment groups
  long unsigned int numIntegrateMomentGroups() const;

  //! Returns the integrate moment group list
  list<integrateMomentGroup>* integrateMomentGroupList();

  //! Returns the integrate moment group list
  const list<integrateMomentGroup>* integrateMomentGroupList() const;


  private :

    list<XMLString>             myVectorNamesList;              //!< List of vector names
  unsigned long               mySpace;                        //!< Space of filter (x-space or k-space)
  XMLString                   myCode;                         //!< The filter code
  list<XMLString>             myCodeElementList;              //!< Names of code elements
  long                        myNumIntegrateMomentGroups;     //!< Number of non-loop propagation elements
  list<integrateMomentGroup>  myIntegrateMomentGroupList;     //!< The list of integrate moment group elements
  long                        myNumNonLoopPropagation;        //!< Number of non-loop propagation elements
  list<XMLString>             myNonLoopPropagationCodeList;   //!< The list of non-loop propagation codes
  bool              myNonoises;           //!< Flag for turning off noise generation

  //! Write the filter prototypes to file
  void writePrototypes(
                       FILE *const outfile) const;

  //! Write the filter routines to file
  void writeRoutines(
                     FILE *const outfile) const;

  //! Determine the space at index (buh?)
  bool space(
             const long unsigned int& index) const;
};


#endif // XMDS_FILTER_H
