/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_arg_element.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_arg_element.h
  @brief Headers for the xmdsArgElement class

  More detailed explanation...
*/

#ifndef XMDS_ARG_ELEMENT_H
#define XMDS_ARG_ELEMENT_H

#include <xmds_arg.h>
#include <xmds_element.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsArgElement
// *****************************************************************************
// *****************************************************************************

//! xmds arg element class
/*!
  The class that handles individual elements of an argument.  These are the
  name of the argument, its type and its default value.
*/
class xmdsArgElement :  public xmdsArg,
                        public xmdsElement {

  public :

    //! Constructor for the xmdsArgElement object
    xmdsArgElement(
       const xmdsSimulation *const yourSimulation,
       const bool& yourVerboseMode,
       const xmdsArgv *const yourArgv);

  //! Destructor
  ~xmdsArgElement();

  //! Processes an element of an xmds vector element
  void processElement(
                      const Element *const yourElement);

  private :

    //   void writeArgDeclaration(
    //                        FILE *const outfile) const;

    //   void writeArgCode(
    //                FILE *const outfile) const;

    //   list<XMLString> myArgNamesList;

};

#endif // XMDS_ARG_ELEMENT_H
