1. INLEDNING

Wine r ett program som gr det mjligt att kra Windows-program
(inkluderat DOS, Windows 3.x, Win32 och Win64) i Unix. Det bestr av en
programstartare som startar och kr Windows-programfiler, samt ett
bibliotek (kallat Winelib) som implementerar Windows API-anrop med hjlp
av deras Unix- eller X11-motsvarigheter. Biblioteket kan ocks anvndas
till att porta Windows-kod till vanliga Unix-program.

Wine r fri programvara, utgett under villkoren i GNU LGPL; se
filen LICENSE fr detaljer.


2. KOM IGNG

Nr du bygger Wine frn kllkod s rekommenderas du anvnda Wines
installationsprogram. Kr fljande i rotkatalogen fr Wines kllkod:

./tools/wineinstall

Kr program med "wine [val] program". Se resten av denna fil,
Wines man-sidor samt sist men inte minst http://www.winehq.org/ fr mer
information och tips om hur problem kan lsas.


3. SYSTEMKRAV

Fr att kompilera och kra Wine krvs ett av fljande:

  Linux version 2.0.36 eller senare
  FreeBSD 8.0 eller senare
  Solaris x86 9 eller senare
  NetBSD-current
  Mac OS X 10.5 eller senare

Wine krver std fr trdar p kernelniv, och drfr r det bara
operativsystemen ovan som stds. Andra operativsystem som
stder kerneltrdar kommer eventuellt att stdjas i framtiden.

Information fr FreeBSD:
  Wine kommer i regel inte att fungera p FreeBSD-versioner ldre n 8.0.
  Se http://wiki.freebsd.org/Wine fr mer information.

Information fr Solaris:
  Wine mste antagligen byggas med GNU toolchain (gcc, gas etc.).
  Varning: ven om gas installeras s r det inte skert att det anvnds av
  gcc. Det sgs att det r ndvndigt att antingen bygga gcc p nytt, eller
  skapa symboliska lnkar frn "cc", "as" och "ld" till GNU toolchain.

Information fr NetBSD:
  USER_LDT, SYSVSHM, SYSVSEM och SYSVMSG mste vara aktiverade i kerneln.

Information fr Mac OS X:
  Du behver Xcode 2.4 eller senare fr att korrekt kunna bygga Wine p x86.
  Mac-drivrutinen krver OS X 10.6 eller senare och kommer inte att byggas p 10.5.


Stdda filsystem:
  Wine kan kra p de flesta filsystem, men det har rapporterats problem vad
  gller kompatibilitet d samba anvnds fr att ansluta till filer. NTFS
  tillhandahller inte heller alla filsystemsfunktioner som behvs av alla
  program. Det rekommenderas att anvnda ett riktigt Unix-filsystem.

Grundlggande krav:
  Utvecklingsfilerna fr X11 mste vara installerade (de kallas xlib6g-dev i
  Debian och XFree86-devel i Red Hat).

  Du mste givetvis ocks ha "make" (mest troligt "GNU make").

  Det r ocks ndvndigt att ha flex 2.5.33 eller senare samt bison.

Valfria stdbibliotek:
  configure-skriptet visar varningar nr valfria bibliotek inte hittats.
  Se http://wiki.winehq.org/Recommended_Packages fr information om
  vilka paket du br installera.

  P 64 bit-system mste du skerstlla att 32 bit-versionerna av
  ovannmnda bibliotek installerats; se http://wiki.winehq.org/WineOn64bit
  fr nrmare detaljer. Om du vill ha ett sant 64-bit Wine (eller en mixad
  32- och 64-bit Wine-installation), se http://wiki.winehq.org/Wine64 fr
  detaljer.

4. KOMPILERING

Kr fljande kommandon fr att bygga Wine om du inte anvnder wineinstall:

./configure
make

Detta bygger programmet "wine" och diverse stdbibliotek/programfiler.
Programfilen "wine" laddar och kr Windows-program.
Biblioteket "libwine" ("Winelib") kan anvndas till att bygga och lnka
Windows-kllkod i Unix.

Kr './configure --help' fr att se instllningar och val vid kompilering.

5. INSTALLATION

Nr Wine r byggt kan du kra "make install" fr att installera det;
detta installerar ocks man-sidorna och ngra fler ndvndiga filer.

Glm inte att frst avinstallera gamla Wine-versioner. Prva antingen
"dpkg -r wine", "rpm -e wine" eller "make uninstall" fre installationen.

Nr Wine r installerat kan du anvnda instllningsprogrammet "winecfg".
Se hjlpavdelningen p http://www.winehq.org/ fr tips om instllningar.


6. KRNING AV PROGRAM

Nr du anvnder Wine kan du uppge hela skvgen till programfilen, eller
enbart ett filnamn.

Exempel: fr att kra Notepad:

        wine notepad               (anvnder skvgen angiven i Wines
        wine notepad.exe            konfigurationsfil fr att finna filen)

        wine c:\\windows\\notepad.exe  (anvndning av DOS-filnamnssyntax)

        wine ~/.wine/drive_c/windows/notepad.exe  (anvndning av Unix-filvgar)

        wine notepad.exe readme.txt  (kra program med parametrar)

Wine r inte perfekt, s det r mjligt att vissa program kraschar.
I s fall fr du en kraschlogg som du br bifoga till din rapport d du
rapporterar ett fel.


7. MER INFORMATION

Internet:  Mycket information om Wine finns samlat p WineHQ p
           http://www.winehq.org/ : diverse guider, en programdatabas samt
           felsprning. Detta r antagligen det bsta stllet att brja.

Frgor:    Frgor och svar om Wine finns samlade p http://www.winehq.org/FAQ

Wiki:      Wines Wiki finns p http://wiki.winehq.org

E-postlistor:
           Det finns flera e-postlistor fr Wine-anvndare och -utvecklare; se
           http://www.winehq.org/forums fr mer information.

Fel:       Rapportera fel till Wines Bugzilla p http://bugs.winehq.org
           Sk i Bugzilla-databasen fr att se om problemet redan finns
           rapporterat innan du snder en felrapport.

IRC:       Hjlp finns tillgnglig online p kanalen #WineHQ p
           irc.freenode.net.

Git:       Wines nuvarande utvecklingsversion finns tillgnglig genom Git.
           G till http://www.winehq.org/git fr mer information.

Om du lgger till ngot eller fixar ett fel, r det bra om du snder
en patch (frslagsvis med git-format-patch) till listan wine-patches@winehq.org
fr inkludering i nsta utgva av Wine.

--
Originalet till denna fil skrevs av
Alexandre Julliard
julliard@winehq.org

versatt till svenska av
Anders Jonsson
anders.jonsson@norsjonet.se
