/*
 * NodeTimeSensor.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_TIMESENSOR_H
#define _NODE_TIMESENSOR_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoTimeSensor : public Proto {
public:
                    ProtoTimeSensor(Scene *scene);
    virtual Node   *create(Scene *scene);

    virtual int     getType() const { return VRML_TIME_SENSOR; }

    FieldIndex cycleInterval;
    FieldIndex enabled;
    FieldIndex loop;
    FieldIndex pauseTime;
    FieldIndex resumeTime;
    FieldIndex startTime;
    FieldIndex stopTime;

    // not fields but eventIn/eventOut
    FieldIndex fraction_changed;
    FieldIndex time;
};

class NodeTimeSensor : public Node {
public:
                    NodeTimeSensor(Scene *scene, Proto *proto);

    virtual int     getProfile(void) const;
    virtual int     getComponentLevel(void) const;
    virtual const char *getComponentName(void) const;
    virtual Node   *copy() const { return new NodeTimeSensor(*this); }

    virtual void    preDraw();
    void            setTime(double t);
    void            start(double t);
    void            updateStart(int field, FieldValue *value, double t);
    void            checkStart(bool loop, double startTime, double stopTime, 
                               double time);

    fieldMacros(SFTime, cycleInterval, ProtoTimeSensor)
    fieldMacros(SFBool, enabled,       ProtoTimeSensor)
    fieldMacros(SFBool, loop,          ProtoTimeSensor)
    fieldMacros(SFTime, pauseTime,     ProtoTimeSensor)
    fieldMacros(SFTime, resumeTime,    ProtoTimeSensor)
    fieldMacros(SFTime, startTime,     ProtoTimeSensor)
    fieldMacros(SFTime, stopTime,      ProtoTimeSensor)

    fieldMacros(SFFloat, fraction_changed, ProtoTimeSensor)
    fieldMacros(SFTime,  time,             ProtoTimeSensor)

protected:
    bool            _active;
    double          _startTime;
    double          _stopTime;
};

#endif // _NODE_TIMESENSOR_H
