"""
"""

import common_gen

def generate_headers_for(func_descriptions):
    func_decls = []
    for func_description in [func_description for func_description in func_descriptions if func_description['type'] == 'func_decl']:
        func_decls.append(_generate_header_for(func_description))
    return '\n'.join (func_decls)


def _generate_header_for(func_description):
    return """
NPVariant
%s%s (NPP instance
         , NPObject * npobject
         , const NPVariant *args
         , uint32_t argCount);
""" % (common_gen.get_binding_function_prefix (), func_description['name'][1].replace(common_gen.get_unity_webapps_function_prefix(), ''))



