/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2014 Martin Brehm
                  2012-2014 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef LTSPEC_H
#define LTSPEC_H


#include "xobject.h"
#include "df.h"


class CLTSpec : public CxObject
{
public:
	CLTSpec();
	~CLTSpec();
	void Parse(int res);
	void ComputeSpectrum(const char *pre1, const char *post1, const char *post2, const char *post3, CDF *df);

	double m_fLSpecMinExp;
	double m_fLSpecMaxExp;
	int m_iLSpecPoints;
	int m_iLSpecData;
	int m_iMaxLMIter;
	bool m_bLSpecDataLin;
	double m_fLSpecZeroWeight;
	bool m_bEvolve;
};

#endif
