# -*- coding: utf-8 -*-
#
# Apache Traffic Server documentation build configuration file, created by
# sphinx-quickstart on Mon Mar  4 06:23:15 2013.
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

from sphinx.writers import manpage
from docutils.transforms import frontmatter
from docutils.utils import unescape
from docutils.utils import punctuation_chars
from docutils.parsers.rst import states
from docutils import nodes
import re
import sys
import os
from datetime import date
from sphinx import version_info

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath('ext'))
sys.path.insert(0, os.path.abspath('.'))

# -- General configuration -----------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    'sphinx.ext.graphviz',
    'sphinx.ext.intersphinx',
    'sphinx.ext.autodoc',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.viewcode',
    'sphinxcontrib.plantuml',
    'traffic-server',
]

# Contains values that are dependent on configure.ac.
LOCAL_CONFIG = os.path.join(os.environ['PWD'], "ext", "local-config.py")
with open(LOCAL_CONFIG) as f:
    exec(compile(f.read(), LOCAL_CONFIG, 'exec'))

if version_info >= (1, 4):
    extensions.append('sphinx.ext.imgmath')
else:
    extensions.append('sphinx.ext.pngmath')

# XXX Disabling docxygen for now, since it make RTD documentation builds time
# out, eg. https://readthedocs.org/projects/trafficserver/builds/3525976/
# extensions += [
#   'doxygen',
# ]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'Apache Traffic Server'
copyright = f'{date.today().year}, dev@trafficserver.apache.org'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.

# Extract the version from the configure.ac file with regex so as to
# work identically when building with Autotools (e.g. $ make html)
# and without (e.g. on Read the Docs)


contents = open('../configure.ac').read()
match = re.compile(r'm4_define\(\[TS_VERSION_S],\[(.*?)]\)').search(contents)

# The full version, including alpha/beta/rc tags.
release = match.group(1)
# The short X.Y version.
version = '.'.join(release.split('.', 2)[:2])

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None
locale_dirs = ['locale/']
gettext_compact = False

# HACK for Read-the-Docs
# Generate .mo files just in time
if os.environ.get('READTHEDOCS') == 'True':
    import polib
    print("Generating .mo files"),
    for locale_dir in locale_dirs:
        for path, dummy, filenames in os.walk(locale_dir):
            for filename in filenames:
                po_file = os.path.join(path, filename)
                base, ext = os.path.splitext(po_file)
                if ext == ".po":
                    mo_file = base + ".mo"
                    po = polib.pofile(po_file)
                    po.save_as_mofile(fpath=mo_file)
    print("done")
else:
    # On RedHat-based distributions, install the python-sphinx_rtd_theme package
    # to get an end result tht looks more like readthedoc.org.
    try:
        import sphinx_rtd_theme
        html_theme = 'sphinx_rtd_theme'
        html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
    except Exception:
        pass
# End of HACK

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = []

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'default'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

nitpicky = True
nitpick_ignore = [('c:type', 'int64_t'),
                  ('c:type', 'bool'),
                  ('c:type', 'sockaddr'),
                  ('cpp:identifier', 'T'),  # template arg
                  ('cpp:identifier', 'F'),  # template arg
                  ('cpp:identifier', 'Args'),  # variadic template arg
                  ('cpp:identifier', 'Rest'),  # variadic template arg
                  ('c:type', 'uint64_t'),
                  ('c:type', 'uint8_t'),
                  ('c:type', 'int32_t')
                  ]

# Autolink issue references.
# See Customizing the Parser in the docutils.parsers.rst module.


# Customize parser.inliner in the only way that Sphinx supports.
# docutils.parsers.rst.Parser takes an instance of states.Inliner or a
# subclass, but Sphinx initializes the parser without any arguments,
# in SphinxStandaloneReader.set_parser('restructuredtext'),
# which is called from Publisher.set_components().

# states.Inliner isn't a new-style class, so super() isn't an option.
BaseInliner = states.Inliner


class Inliner(states.Inliner):
    def init_customizations(self, settings):
        self.__class__ = BaseInliner
        BaseInliner.init_customizations(self, settings)
        self.__class__ = Inliner

        # Copied from states.Inliner.init_customizations().
        # In Docutils 0.13 these are locals.
        if not hasattr(self, 'start_string_prefix'):
            self.start_string_prefix = (u'(^|(?<=\\s|[%s%s]))' %
                                        (punctuation_chars.openers,
                                         punctuation_chars.delimiters))
        if not hasattr(self, 'end_string_suffix'):
            self.end_string_suffix = (u'($|(?=\\s|[\x00%s%s%s]))' %
                                      (punctuation_chars.closing_delimiters,
                                       punctuation_chars.delimiters,
                                       punctuation_chars.closers))

        issue = re.compile(
            r'''
      {start_string_prefix}
      TS-\d+
      {end_string_suffix}'''.format(
                start_string_prefix=self.start_string_prefix,
                end_string_suffix=self.end_string_suffix),
            re.VERBOSE | re.UNICODE)

        self.implicit_dispatch.append((issue, self.issue_reference))

    def issue_reference(self, match, lineno):
        text = match.group(0)

        rawsource = unescape(text, True)
        text = unescape(text, False)

        refuri = 'https://issues.apache.org/jira/browse/' + text

        return [nodes.reference(rawsource, text, refuri=refuri)]


states.Inliner = Inliner

# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#html_theme = 'agogo'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = 'static/images/trans_logo_tm_380x69.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = 'static/images/favicon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['static']

# Include a stylesheet that overrides default table styling, to provide
# content wrapping.
html_context = {
    'css_files': [
        '_static/override.css'
    ]
}
if os.environ.get('READTHEDOCS', None) == 'True':
    html_context = {
        'css_files': [
            'https://media.readthedocs.org/css/sphinx_rtd_theme.css',
            'https://media.readthedocs.org/css/readthedocs-doc-embed.css',
            '_static/override.css'
        ]
    }

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = 'ApacheTrafficServerdoc'

# -- Options for LaTeX output --------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    # 'preamble': '',
}

if 'latex_a4' in tags:
    latex_elements['papersize'] = 'a4paper'
elif 'latex_paper' in tags:
    latex_elements['papersiize'] = 'letterpaper'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
    ('index', 'ApacheTrafficServer.tex', u'Apache Traffic Server Documentation',
     u'dev@trafficserver.apache.org', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# If true, show page references after internal links.
#latex_show_pagerefs = False

# If true, show URL addresses after external links.
#latex_show_urls = False

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_domain_indices = True

# -- Options for manual page output --------------------------------------------

# The global "man_pages" is imported from ts/manpages.py

# If true, show URL addresses after external links.
#man_show_urls = False

# Get the manual page description from the reStructuredText document.
# This keeps the list of manual pages consistent with the source
# documents and includes the same brief description in both the HTML
# and manual page outputs.


# Override ManualPageWriter and ManualPageTranslator in the only way
# that Sphinx supports

BaseWriter = manpage.ManualPageWriter


class ManualPageWriter(BaseWriter):
    def translate(self):
        transform = frontmatter.DocTitle(self.document)

        section, index = transform.candidate_index(self.document)
        if index:

            # A sentence after the title is the manual page description
            if len(section) > 1 and isinstance(section[1], nodes.paragraph):

                description = section.pop(1).astext()
                description = description[:1].lower() + description[1:]
                description = description.rstrip('.')

                self.document.settings.subtitle = description

            # Instead of section_level = -1, use the standard Docutils
            # DocTitle transform to hide the top level title
            transform.promote_title(self.document)

        # The title is the manual page name
        transform.set_metadata()

        BaseWriter.translate(self)


manpage.ManualPageWriter = ManualPageWriter

BaseTranslator = manpage.ManualPageTranslator


class ManualPageTranslator(BaseTranslator):
    def __init__(self, builder, *args, **kwds):
        BaseTranslator.__init__(self, builder, *args, **kwds)

        # Instead of section_level = -1, use the standard Docutils
        # DocTitle transform to hide the top level title
        self.section_level = 0


manpage.ManualPageTranslator = ManualPageTranslator

# -- Options for Texinfo output ------------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    ('index', 'ApacheTrafficServer', u'Apache Traffic Server Documentation',
     u'dev@trafficserver.apache.org', 'ApacheTrafficServer', 'One line description of project.',
     'Miscellaneous'),
]

# Documents to append as an appendix to all manuals.
#texinfo_appendices = []

# If false, no module index is generated.
#texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#texinfo_show_urls = 'footnote'

# -- Options for Epub output ---------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = u'Apache Traffic Server'
epub_author = u'dev@trafficserver.apache.org'
epub_publisher = u'dev@trafficserver.apache.org'
epub_copyright = u'2013, dev@trafficserver.apache.org'

# The language of the text. It defaults to the language option
# or en if the language is not set.
#epub_language = ''

# The scheme of the identifier. Typical schemes are ISBN or URL.
#epub_scheme = ''

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#epub_identifier = ''

# A unique identification for the text.
#epub_uid = ''

# A tuple containing the cover image and cover page html template filenames.
#epub_cover = ()

# HTML files that should be inserted before the pages created by sphinx.
# The format is a list of tuples containing the path and title.
#epub_pre_files = []

# HTML files shat should be inserted after the pages created by sphinx.
# The format is a list of tuples containing the path and title.
#epub_post_files = []

# A list of files that should not be packed into the epub file.
#epub_exclude_files = []

# The depth of the table of contents in toc.ncx.
#epub_tocdepth = 3

# Allow duplicate toc entries.
#epub_tocdup = True
#mathjax_path = 'https://docs.trafficserver.apache.org/__RTD/MathJax.js'

# Enabling marking bit fields as 'bitfield_N`.
# Currently parameterized fields don't work. When they do, we should change to
# 'bitfield(N)'.
cpp_id_attributes = ['bitfield_1', 'bitfield_3', 'bitfield_24']
