/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.sf;

import java.io.IOException;
import net.tinyos.sf.SFConsoleRenderer;
import net.tinyos.sf.SFListen;
import net.tinyos.sf.SFNullRenderer;
import net.tinyos.sf.SFRenderer;
import net.tinyos.sf.SFWindow;
import net.tinyos.util.Messenger;

public class SerialForwarder
implements Messenger {
    public static final int DEFAULT_PORT = 9002;
    public SFRenderer renderer;
    public SFListen listenServer;
    public String motecom = "serial@com1:57600";
    public boolean logDB;
    public int serverPort = 9002;
    private boolean displayHelp = false;
    private int nClients = 0;
    private int nPacketsRead = 0;
    private int nPacketsWritten = 0;
    private SFListen listener = null;
    SFMessenger verbose = new SFMessenger(true);
    SFMessenger debug = new SFMessenger(false);

    public static void main(String[] stringArray) throws IOException {
        new SerialForwarder(stringArray);
    }

    public SerialForwarder(String[] stringArray) throws IOException {
        this.ProcessCommandLineArgs(stringArray);
        if (this.displayHelp) {
            SerialForwarder.printHelp();
            System.exit(2);
        }
        if (this.renderer == null) {
            this.renderer = SFWindow.createGui(this, "TinyOS 2.x Serial Forwarder");
        }
        this.startListenServer();
    }

    private void ProcessCommandLineArgs(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            this.debug.message(stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-no-gui") && this.renderer == null) {
                this.renderer = new SFConsoleRenderer();
                continue;
            }
            if (stringArray[n].equals("-no-output") && this.renderer == null) {
                this.renderer = new SFNullRenderer();
                continue;
            }
            if (stringArray[n].equals("-comm")) {
                if (++n < stringArray.length) {
                    this.motecom = stringArray[n];
                    continue;
                }
                this.displayHelp = true;
                continue;
            }
            if (stringArray[n].equals("-port")) {
                if (++n < stringArray.length) {
                    this.serverPort = Integer.parseInt(stringArray[n]);
                    continue;
                }
                this.displayHelp = true;
                continue;
            }
            if (stringArray[n].equals("-log")) {
                this.logDB = true;
                continue;
            }
            if (stringArray[n].equals("-quiet")) {
                this.verbose.on = false;
                continue;
            }
            if (stringArray[n].equals("-debug")) {
                this.debug.on = true;
                continue;
            }
            this.displayHelp = true;
        }
    }

    private static void printHelp() {
        System.err.println("optional arguments:");
        System.err.println("-port [server port] (default 9002)");
        System.err.println("-comm [motecom spec] (default serial@com1:57600)");
        System.err.println("-packetsize [size] (default 36)");
        System.err.println("-no-gui      = do not display graphic interface");
        System.err.println("-no-output");
        System.err.println("-quiet       = non-verbose mode");
        System.err.println("-debug       = display debug messages");
        System.err.println("-log         = log to database");
    }

    private void createGui() {
        this.renderer = SFWindow.createGui(this, "SerialForwarder");
    }

    public void message(String string) {
        this.renderer.message(string);
    }

    public synchronized void incrementPacketsRead() {
        ++this.nPacketsRead;
        this.renderer.updatePacketsRead(this.nPacketsRead);
    }

    public synchronized void incrementPacketsWritten() {
        ++this.nPacketsWritten;
        this.renderer.updatePacketsWritten(this.nPacketsWritten);
    }

    public synchronized void incrementClients() {
        ++this.nClients;
        this.renderer.updateNumClients(this.nClients);
    }

    public synchronized void decrementClients() {
        --this.nClients;
        this.renderer.updateNumClients(this.nClients);
    }

    public synchronized void clearCounts() {
        this.nPacketsWritten = 0;
        this.nPacketsRead = 0;
        this.renderer.updatePacketsWritten(this.nPacketsWritten);
        this.renderer.updatePacketsRead(this.nPacketsRead);
    }

    public synchronized void startListenServer() {
        if (this.listenServer == null) {
            this.nClients = 0;
            this.listenServer = new SFListen(this);
            this.listenServer.start();
        }
        this.renderer.updateListenServerStatus(true);
        this.renderer.updateNumClients(this.nClients);
        this.clearCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListenServer() {
        SFListen sFListen;
        SerialForwarder serialForwarder = this;
        synchronized (serialForwarder) {
            sFListen = this.listenServer;
            if (sFListen != null) {
                this.listenServer.shutdown();
            }
        }
        if (sFListen != null) {
            try {
                sFListen.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void listenServerStopped() {
        this.listenServer = null;
        this.renderer.updateListenServerStatus(false);
    }

    class SFMessenger
    implements Messenger {
        boolean on;

        SFMessenger(boolean bl) {
            this.on = bl;
        }

        public void message(String string) {
            if (this.on) {
                SerialForwarder.this.message(string);
            }
        }
    }
}

