from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


toQImage = _Mock()



class QwtDoubleInterval(_Mock):
  pass
  ExcludeBorders = 3
  ExcludeMaximum = 2
  ExcludeMinimum = 1
  IncludeBorders = 0

class QwtLinearColorMap(_Mock):
  pass
  FixedColors = 0
  Indexed = 1
  RGB = 0
  ScaledColors = 1

class QwtLinearScaleEngine(_Mock):
  pass
  Floating = 4
  IncludeReference = 1
  Inverted = 8
  NoAttribute = 0
  Symmetric = 2

class QwtLog10ScaleEngine(_Mock):
  pass
  Floating = 4
  IncludeReference = 1
  Inverted = 8
  NoAttribute = 0
  Symmetric = 2

class QwtPlot(_Mock):
  pass
  BottomLegend = 2
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  ExternalLegend = 4
  HLine = 4
  IgnoreMask = 4
  LeftLegend = 0
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RightLegend = 1
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  TopLegend = 3
  VLine = 5
  WinPanel = 3
  axisCnt = 4
  xBottom = 2
  xTop = 3
  yLeft = 0
  yRight = 1

class QwtPlotCanvas(_Mock):
  pass
  Box = 1
  CanvasFocusIndicator = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  ItemFocusIndicator = 2
  NoFocusIndicator = 0
  NoFrame = 0
  PaintCached = 1
  PaintPacked = 2
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class QwtPlotCurve(_Mock):
  pass
  AutoScale = 2
  ClipPolygons = 2
  Dots = 4
  Fitted = 2
  Inverted = 1
  Legend = 1
  Lines = 1
  NoCurve = 0
  PaintFiltered = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  Steps = 3
  Sticks = 2
  UserCurve = 100
  Xfy = 1
  Yfx = 0

class QwtPlotGrid(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000

class QwtPlotItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000

class QwtPlotMarker(_Mock):
  pass
  AutoScale = 2
  Cross = 3
  HLine = 1
  Legend = 1
  NoLine = 0
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  VLine = 2

class QwtPlotPrintFilter(_Mock):
  pass
  AxisScale = 9
  AxisTitle = 10
  CanvasBackground = 8
  Curve = 2
  CurveSymbol = 3
  Legend = 1
  MajorGrid = 6
  Marker = 4
  MarkerSymbol = 5
  MinorGrid = 7
  PrintAll = -33
  PrintBackground = 16
  PrintFrameWithScales = 32
  PrintGrid = 8
  PrintLegend = 4
  PrintMargin = 1
  PrintTitle = 2
  Title = 0
  WidgetBackground = 11

class QwtScaleMap(_Mock):
  pass
  LogMax = 1e+150
  LogMin = 1e-150

class QwtSymbol(_Mock):
  pass
  Cross = 8
  DTriangle = 4
  Diamond = 2
  Ellipse = 0
  HLine = 10
  Hexagon = 14
  LTriangle = 6
  NoSymbol = -1
  RTriangle = 7
  Rect = 1
  Star1 = 12
  Star2 = 13
  StyleCnt = 15
  Triangle = 3
  UTriangle = 5
  VLine = 11
  XCross = 9

class QwtText(_Mock):
  pass
  AutoText = 0
  MathMLText = 3
  MinimumLayout = 1
  OtherFormat = 100
  PaintBackground = 4
  PaintUsingTextColor = 2
  PaintUsingTextFont = 1
  PlainText = 1
  RichText = 2
  TeXText = 4

