/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "f2c_syrthes.h"
# include "tree.h"
# include "abs.h"
# include "interfaces.h"


int ss_tria[4][3] = { {0,3,5},
	              {1,4,3},
	              {2,5,4},
	              {3,4,5} };
int nsp;
double taille_boite,taille_seg;


/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | cfdf3d                                                               |
  |         Gestion du calcul des facteurs de forme en dimension 3       |
  |======================================================================| */

proc(void cfdf3d,void CFDF3D) 
             (int *ndim,int *nelray,int *npoinr,int *nodray,
              double *cooray,double *sufray,double *fdf,
              int *nplasy,double *plasym,
	      int *nperay, double *perray,int *ndecoup_max,
	      int *nrfray, double *pvinter,int *numgu,int *ngumax,int *nblblr)

{
       
    int i,n2;
    int faces_cachees ;
    double Pi ;
    int *nod2,nel2,npoin2;
    double *coo2,*xnf2,xmult,*xnfray;
    int *grconv, *grconv2;
    int imult;

    dimension_3d(*ndim,*nelray,*npoinr,nodray,cooray,
		 &taille_boite,&taille_seg);
    imult = 0;
    xmult = 1.;
    if(taille_seg < 0.01 || taille_seg > 10)
      {
        imult = 1;
	if (taille_seg < 0.01) xmult = 0.1/taille_seg;
	if (taille_seg > 10  ) xmult =   1/taille_seg;
        if(*nblblr >= 10) printf("Facteur multiplicatif interne xmult= %f \n",xmult);
	for (i=0;i< *npoinr* *ndim ;i++) *(cooray+i) *=  xmult ;
        taille_boite *= xmult;
        taille_seg   *= xmult;
        for(i=0;i<3**ngumax;i++) *(pvinter+i)*=xmult;
        for(i=0;i<3;i++) *(perray+i)*=xmult;
	for(i=0;i<*nplasy;i++) plasym[i*4+3]*=xmult;
      }
    
    grconv = (int *)malloc( *nelray * sizeof(int) );
    if (grconv==NULL) 
      {printf(" ERREUR cfdf3d : probleme d'allocation memoire\n");
       exit(0);}
    orie3d(nodray,*nelray,*npoinr,nrfray,cooray,pvinter,*numgu,*ndim,*nblblr,
	   grconv);
     
    Pi = 3.141592653589793;  
    

    verif_coor_3d(*ndim,*nelray,*npoinr,nodray,cooray,*nplasy,plasym,
		  *nperay,perray,*nblblr,taille_seg);


    surface_tria (*nelray,*npoinr,nodray,cooray,sufray);
    
    xnfray=(double*)malloc(*nelray * 3 * sizeof(double));
    if (xnfray==NULL) 
      {printf(" ERREUR cfdf3d : probleme d'allocation memoire\n");
       exit(0);}
    cnor_3d(*ndim,*nelray,*npoinr,nodray,cooray,xnfray);

    if (*nplasy != 0 && *nperay == 0) 
      {
	n2=1;
	if (*nplasy==1){n2=2;}
	else if (*nplasy==2){n2=4;}
	else if (*nplasy==3){n2=8;}
	nod2=(int*)malloc(n2 * *nelray * 3 * sizeof(int));
	coo2=(double*)malloc(n2 * *npoinr * 3 * sizeof(double));
	xnf2=(double*)malloc(n2 * *nelray * 3 * sizeof(double));
	grconv2=(int*)malloc(n2 * *nelray * sizeof(int));
	if (n2==0 || nod2==NULL || coo2==NULL || xnf2==NULL || grconv2==NULL ) 
	  {printf(" ERREUR cfdf3d : probleme d'allocation memoire\n");
	   exit(0);}
        dupliq3d_sym(*nplasy,plasym,
		     *npoinr,*nelray,nodray,cooray,xnfray,
		     &nel2,&npoin2,nod2,coo2,xnf2,grconv,grconv2);    
      }
    else if (*nperay > 0)
      {
	n2=1;
	if (*nplasy==0){n2=*nperay;}
	else if (*nplasy==1){n2=*nperay*2;}
	else if (*nplasy==2){n2=*nperay*4;}
	else if (*nplasy==3){n2=*nperay*8;}
	nod2=(int*)malloc(n2 * *nelray * 3 * sizeof(int));
	coo2=(double*)malloc(n2 * *npoinr * 3 * sizeof(double));
	xnf2=(double*)malloc(n2 * *nelray * 3 * sizeof(double));
 	grconv2=(int*)malloc(n2 * *nelray * sizeof(int));
	if (n2==0 || nod2==NULL || coo2==NULL || xnf2==NULL || grconv2==NULL ) 
	  {printf(" ERREUR cfdf3d : probleme d'allocation memoire\n");
	   exit(0);}
	dupliq3d_per(*nplasy,plasym,*nperay,perray,
		     *npoinr,*nelray,nodray,cooray,xnfray,
		     &nel2,&npoin2,nod2,coo2,xnf2,grconv,grconv2);    
      }


    if ( *nperay == 0 )
      {
	if (*nplasy==0) nsp=1; 
	else if (*nplasy==1) nsp=2;
	else if (*nplasy==2) nsp=4;
	else if (*nplasy==3) nsp=8;
      }
     else
      {
	if (*nplasy==0) nsp=*nperay; 
	else if (*nplasy==1) nsp=*nperay*2;
	else if (*nplasy==2) nsp=*nperay*4;
	else if (*nplasy==3) nsp=*nperay*8;
      }



    if (*nplasy == 0 && *nperay == 0) 
      facecache_3d(*ndim,*npoinr,*nelray,*nelray,nodray,cooray,xnfray,&faces_cachees,
		   *nplasy,*nperay) ;
    else
      facecache_3d(*ndim,npoin2,nel2,*nelray,nod2,coo2,xnf2,&faces_cachees,
		   *nplasy,*nperay) ;

    if (*nplasy == 0 && *nperay == 0)
      {
	coo2=(double*)malloc(*npoinr * 3 * sizeof(double));
	if (coo2==NULL) 
	  {printf(" ERREUR cfdf3d : probleme d'allocation memoire\n");
	   exit(0);}
	for (i=0;i<*npoinr;i++)
	  {
	    *(coo2+i)           = *(cooray+i);
	    *(coo2+i+*npoinr)   = *(cooray+i+*npoinr);
	    *(coo2+i+*npoinr*2) = *(cooray+i+*npoinr*2);
	  }
      }

    if (faces_cachees)
      {
	if (*nplasy == 0 && *nperay == 0) 
	  {
	    box_3d(*npoinr,coo2); 
	    cnor_3d(*ndim,*nelray,*npoinr,nodray,coo2,xnfray); 
	  }
	else
	  {
/*	  box_3d(npoin2,coo2); */
	  cnor_3d(*ndim,nel2,npoin2,nod2,coo2,xnf2); 
	}
      }
	   
    printf("\n *** CFDF3D : calcul des facteurs de forme\n");
    if (*nplasy == 0 && *nperay == 0) 
      if (!faces_cachees)
	facforme_3d(*ndim,*npoinr,*nelray,*nelray,nodray,cooray,xnfray,fdf,sufray,
		    &faces_cachees,*nplasy,*nperay,*ndecoup_max,grconv,*nblblr);
      else
	facforme_3d(*ndim,*npoinr,*nelray,*nelray,nodray,coo2,xnfray,fdf,sufray,
		    &faces_cachees,*nplasy,*nperay,*ndecoup_max,grconv,*nblblr);
    else
        facforme_3d(*ndim,npoin2,nel2,*nelray,nod2,coo2,xnf2,fdf,sufray,
		    &faces_cachees,*nplasy,*nperay,*ndecoup_max,grconv2,*nblblr);
    
    
    free(xnfray);
    if (*nplasy != 0 || *nperay != 0) {free(coo2); free(nod2); free(xnf2);free(grconv2); }
    if (*nplasy == 0 && *nperay == 0 && faces_cachees) free(coo2);

    if(imult)
      {
	for (i=0;i< *npoinr* *ndim ;i++) *(cooray+i) /=  xmult ;
	xmult *= xmult ;
	for (i=0;i< *nelray ;i++) *(sufray+i) /=  xmult;
	for (i=0 ; i<*nelray*(*nelray+1)/2 ; i++ ) *(fdf+i) /=  xmult;
      }
    
}



/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | facforme_3d                                                          |
  |           calcul des facteurs de forme en dimension 3                |
  |======================================================================| */

void facforme_3d(int ndim, int npoin,int nel2,int nel,
		 int *nod,double *coord,double *xnf,double *fdf,double *sufray,
		 int *faces_cachees,int nplasy,int nperay,int ndecoup_max,
		 int *grconv,int nblblr)
{
    
    int i,j,k,l,npoin2,id,ns,ideb;
    int noeud[6],prem,ndecoup;
    int *voir;
    int codem10,code0,code1,codem1,code2,codem2,code3,code4,code5,codem5,codem6;
    int nbfcoplanaire,code_decoupe;
    double xi[6],yi[6],zi[6],fforme,xp[6],yp[6],zp[6],xq[6],yq[6],zq[6];
    double xii[6],yii[6],zii[6],xt[3],yt[3],zt[3],*pland;
    double xn1,yn1,zn1,x,y,z,size_min,dim_boite[6],dsign[6],xn2,yn2,zn2;
    double Pi,tiers;
    struct node *arbre;
    double xg1,yg1,zg1,xg2,yg2,zg2;
    double titi1, titi2;
    int ncomplique,pasok;
    double total_fac,pourcent,pourcent_ecrit;


    /* Initialisations 
       --------------- */

    Pi = 3.141592653589793;  
    tiers=1./3.;
    npoin2 = npoin*2;
    nbfcoplanaire = 0 ;
    codem10  = 0;    code0    = 0;
    code1    = 0;    codem1   = 0;
    code2    = 0;    codem2   = 0;
    code3    = 0;    code4    = 0;
    code5    = 0;    codem5   = 0;
    codem6   = 0;
    ncomplique = 0;

    pland = (double*)malloc( nel2 * sizeof(double));
    if (pland==NULL) 
      {printf(" ERREUR facforme_3d : probleme d'allocation memoire\n");
       exit(0);}
    for (i=0 ; i<nel2 ; i++)
       {
          xn1 = xnf[i];
          yn1 = xnf[i+ nel2];
          zn1 = xnf[i+ nel2*2];
          x  = coord[nod[i]-1];
          y  = coord[nod[i]-1+npoin];
          z  = coord[nod[i]-1+npoin2];
          pland[i]=-x*xn1-y*yn1-z*zn1;
        }

    for (i=0 ; i<nel*(nel+1)/2 ; i++ ) *(fdf+i) = 0.; 

    if (*faces_cachees)
	{ 
            voir = (int *)malloc((npoin+1)*npoin/2*(sizeof(int))); 
	    if (voir==NULL) 
	      {printf(" ERREUR facforme_3d : probleme d'allocation memoire\n");
	       exit(0);}
	    for (i=0 ; i<npoin*(npoin+1)/2 ; i++ ) *(voir+i) = -1 ; 
	    for (i=0 ; i<npoin ; i++) voir[i*npoin-i*(i+1)/2+i]=0;
            
	    boite(ndim,npoin,coord,dim_boite);
	    size_min = 1.E8;
	    arbre= (struct node *)malloc(sizeof(struct node));
	    if (arbre==NULL) 
	      {printf(" ERREUR facforme_3d : probleme d'allocation memoire\n");
	       exit(0);}
	    build_octree (arbre,ndim,npoin,nel2,nod,coord,&size_min,dim_boite);
	}
	    
    titi1 =0;
    titi2 =0;
    ideb = -nel;
    total_fac=nsp*nel;
    pourcent_ecrit=0.1;

       for (ns=0 ; ns < nsp ; ns++ ) 
      /*--------------------------*/
      {
	ideb += nel;

     	for (i=0 ; i<nel ; i++ )        
/*     	for (i=0 ; i<1 ; i++ )        */
        /*---------------------*/
	
	  {
            if(nblblr >=10) printf(" *** FACFORME_3D : ns=%d   facette i=%d \n",ns+1,i+1);
            pourcent=(ns+1)*i/total_fac;
            if (pourcent>pourcent_ecrit)
	      {
		printf("              %5.2f %% du calcul effectue\n",pourcent_ecrit*100);
		pourcent_ecrit += 0.1;
	      }

	    xn1 = xnf[i];
	    yn1 = xnf[i+ nel2];
	    zn1 = xnf[i+ nel2*2];
	    noeud[0] = nod[i];
	    noeud[1] = nod[i+ nel2];
	    noeud[2] = nod[i+ nel2 *2];

  	    for  (j=ideb+i ; j<ideb+nel ; j++ )   
           /*--------------------------------*/

	      {
		if (grconv[i]!=grconv[j]) continue;
		xn2 = xnf[j];
		yn2 = xnf[j+ nel2];
		zn2 = xnf[j+ nel2*2];

	    fforme = coplanaire_3d(xn1,yn1,zn1,xn2,yn2,zn2);
	    if (fforme>-0.1)
	      { nbfcoplanaire += 1; /* printf(" >>> calfdf : %d %d sont coplanaires\n",i+1,j+1);*/ }

            /* les faces ne sont pas coplanaires */
	    if (fforme<-1.)  
		{
	         noeud[3] = nod[j];
	         noeud[4] = nod[j+ nel2];
	         noeud[5] = nod[j+ nel2*2];

	         for (k=0;k<6;k++)
		   { 
		     xi[k] = coord[noeud[k]-1];
		     yi[k] = coord[noeud[k]-1+ npoin];
		     zi[k] = coord[noeud[k]-1+ npoin2]; 
		   }
		 fforme=0.;

		 if (!*faces_cachees)	
		   proc(contou,CONTOU)(xi,yi,zi,&fforme);

		 else
		   {
		     derriere_3d(nel2,i,j,xnf,pland,xi,yi,zi,dsign,&code_decoupe) ;  

		     if (code_decoupe==0) 
		       prem=1;
		     else
		       prem=0;

                     fforme=0; ndecoup=0;
		     
		     if (code_decoupe == -10)    /* les faces sont derrieres */  
		       { 
			 codem10 += 1;
			 fforme = 0;
		       } 
		     else if (code_decoupe == 0)       /* les faces se voient potentiellement */  
		       { 
			 code0   += 1;
                         if (bary_cache_3d(xi,yi,zi,xn1,yn1,zn1))
			   fforme=0;
			 else
                          {
                           xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
                           xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
                           xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
                           xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
                           xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
                           xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
                           xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
                           xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;
			   triafdf (arbre,size_min,dim_boite,&prem,xi,yi,zi,xii,yii,zii,
				    noeud,voir,nel2,npoin,nod,coord,
				    &ndecoup,&fforme,&ncomplique,ndecoup_max);
                          }
		       } 
		     
		     else if (abs(code_decoupe) == 1)  /* intersection To-Td ou Td-To */
		       { 
			 if (code_decoupe==1) code1   += 1;
			 else codem1  += 1;
			 decoupe_totd(nel2,i,j,xnf,pland,xi,yi,zi,dsign,code_decoupe);

                         if (code_decoupe==1)
			   pasok=bary_cache_3d(xi,yi,zi,xn1,yn1,zn1);
			 else
			   pasok=bary_cache_3d(xi,yi,zi,xn2,yn2,zn2);
			 
			 if(pasok)
			   fforme=0;
			 else
                          {
                           xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
                           xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
                           xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
                           xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
                           xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
                           xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
                           xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
                           xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;
			   triafdf (arbre,size_min,dim_boite,&prem,xi,yi,zi,xii,yii,zii,
				    noeud,voir,nel2,npoin,nod,coord,
				    &ndecoup,&fforme,&ncomplique,ndecoup_max);
                          }
		       } 
		     
		     else if (abs(code_decoupe) == 2 ) /* intersection To-Qd ou Qd-To */ 
		       { 
			 if (code_decoupe==2) code2   += 1;
			 else codem2  += 1;
			 decoupe_toqd (nel2,i,j,xnf,pland,xi,yi,zi,xp,yp,zp,
				       dsign,code_decoupe);
			 xi[3]=xp[0]; yi[3]=yp[0]; zi[3]=zp[0];
			 xi[4]=xp[1]; yi[4]=yp[1]; zi[4]=zp[1];
			 xi[5]=xp[2]; yi[5]=yp[2]; zi[5]=zp[2];

			 if (code_decoupe==2)
			   pasok=bary_cache_3d(xi,yi,zi,xn1,yn1,zn1);
			 else
			   pasok=bary_cache_3d(xi,yi,zi,xn2,yn2,zn2);
				  
			 if (pasok)
			   fforme=0;
			 else
                          {
                           xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
                           xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
                           xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
                           xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
                           xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
                           xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
                           xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
                           xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;
			   triafdf (arbre,size_min,dim_boite,&prem,xi,yi,zi,xii,yii,zii,
				    noeud,voir,nel2,npoin,nod,coord,
				    &ndecoup,&fforme,&ncomplique,ndecoup_max);
                          }

			 if (code_decoupe==2)  id=0;
			 else id=3;
			 for (k=0;k<3;k++)  /* on recharche les xi originaux */
			   { 
			     xi[k] = coord[noeud[k+id]-1];
			     yi[k] = coord[noeud[k+id]-1+ npoin];
			     zi[k] = coord[noeud[k+id]-1+ npoin2]; 
			   }
			 xi[3]=xp[0]; yi[3]=yp[0]; zi[3]=zp[0];
			 xi[4]=xp[2]; yi[4]=yp[2]; zi[4]=zp[2];
			 xi[5]=xp[3]; yi[5]=yp[3]; zi[5]=zp[3];

			 if (code_decoupe==2)
			   pasok=bary_cache_3d(xi,yi,zi,xn1,yn1,zn1);
			 else
			   pasok=bary_cache_3d(xi,yi,zi,xn2,yn2,zn2);
				  
			 if (pasok)
			   fforme=0;
			 else
                          {
                           xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
                           xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
                           xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
                           xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
                           xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
                           xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
                           xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
                           xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;
			   triafdf (arbre,size_min,dim_boite,&prem,xi,yi,zi,xii,yii,zii,
				    noeud,voir,nel2,npoin,nod,coord,
				    &ndecoup,&fforme,&ncomplique,ndecoup_max);
                          }
		       } 
		     
		     else if (code_decoupe == 3)    /* intersection Td-Td */ 
		       { 
			 code3   += 1;
			 decoupe_tdtd (nel2,i,j,xnf,pland,xi,yi,zi,
				       dsign,code_decoupe);
			 if(bary_cache_3d(xi,yi,zi,xn1,yn1,zn1))
			   fforme=0;
			 else
                          {
                           xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
                           xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
                           xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
                           xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
                           xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
                           xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
                           xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
                           xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;
			   triafdf (arbre,size_min,dim_boite,&prem,xi,yi,zi,xii,yii,zii,
				    noeud,voir,nel2,npoin,nod,coord,
				    &ndecoup,&fforme,&ncomplique,ndecoup_max);
                          }
		       } 
		     else if (code_decoupe == 4)   /* intersection Qd-Qd */ 
		       { 
			 code4   += 1;
			 decoupe_qdqd (nel2,i,j,xnf,pland,xi,yi,zi,
				       xp,yp,zp,xq,yq,zq,dsign,code_decoupe);
			 for (k=0;k<2;k++)
			   { 
			     xi[0]=xp[0];    yi[0]=yp[0];    zi[0]=zp[0];
			     xi[1]=xp[1+k];  yi[1]=yp[1+k];  zi[1]=zp[1+k];
			     xi[2]=xp[2+k];  yi[2]=yp[2+k];  zi[2]=zp[2+k];
			     for (l=0;l<2;l++)
			       {
				 xi[3]=xq[0];    yi[3]=yq[0];    zi[3]=zq[0];
				 xi[4]=xq[1+l];  yi[4]=yq[1+l];  zi[4]=zq[1+l];
				 xi[5]=xq[2+l];  yi[5]=yq[2+l];  zi[5]=zq[2+l];
				 if(bary_cache_3d(xi,yi,zi,xn1,yn1,zn1))
				   fforme=0;
				 else
                                   {
                                    xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
                                    xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
				    xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
				    xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
				    xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
				    xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
				    xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
				    xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;
				   triafdf (arbre,size_min,dim_boite,&prem,xi,yi,zi,xii,yii,zii,
					    noeud,voir,nel2,npoin,nod,coord,
					    &ndecoup,&fforme,&ncomplique,ndecoup_max);
                                   }
			       }
			   }
		       }
		     
		     else if (abs(code_decoupe) == 5 )   /* intersection Td-Qd */ 
		       { 
			 if (code_decoupe == 5) code5 += 1;
			 else codem5 += 1;
			 decoupe_tdqd (nel2,i,j,xnf,pland,xi,yi,zi,xt,yt,zt,xp,yp,zp,
				       dsign,code_decoupe);
			 xi[0]=xt[0]; yi[0]=yt[0]; zi[0]=zt[0];
			 xi[1]=xt[1]; yi[1]=yt[1]; zi[1]=zt[1];
			 xi[2]=xt[2]; yi[2]=yt[2]; zi[2]=zt[2];
			 xi[3]=xp[0]; yi[3]=yp[0]; zi[3]=zp[0];
			 xi[4]=xp[1]; yi[4]=yp[1]; zi[4]=zp[1];
			 xi[5]=xp[2]; yi[5]=yp[2]; zi[5]=zp[2];

			 if  (code_decoupe == 5)
			   pasok=bary_cache_3d(xi,yi,zi,xn1,yn1,zn1);
			 else
			   pasok=bary_cache_3d(xi,yi,zi,xn2,yn2,zn2);

			 if (pasok)
			   fforme=0;
			 else
                          {
                           xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
                           xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
                           xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
                           xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
                           xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
                           xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
                           xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
                           xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;
			   triafdf (arbre,size_min,dim_boite,&prem,xi,yi,zi,xii,yii,zii,
				    noeud,voir,nel2,npoin,nod,coord,
				    &ndecoup,&fforme,&ncomplique,ndecoup_max);

                          }

			 xi[0]=xt[0]; yi[0]=yt[0]; zi[0]=zt[0];
			 xi[1]=xt[1]; yi[1]=yt[1]; zi[1]=zt[1];
			 xi[2]=xt[2]; yi[2]=yt[2]; zi[2]=zt[2];
			 xi[3]=xp[0]; yi[3]=yp[0]; zi[3]=zp[0];
			 xi[4]=xp[2]; yi[4]=yp[2]; zi[4]=zp[2];
			 xi[5]=xp[3]; yi[5]=yp[3]; zi[5]=zp[3];

			 if  (code_decoupe == 5)
			   pasok=bary_cache_3d(xi,yi,zi,xn1,yn1,zn1);
			 else
			   pasok=bary_cache_3d(xi,yi,zi,xn2,yn2,zn2);

			 if (pasok)
			   fforme=0;
			 else
                          {
                           xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
                           xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
                           xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
                           xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
                           xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
                           xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
                           xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
                           xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;
			   triafdf (arbre,size_min,dim_boite,&prem,xi,yi,zi,xii,yii,zii,
				    noeud,voir,nel2,npoin,nod,coord,
				    &ndecoup,&fforme,&ncomplique,ndecoup_max);
                          }
		       }

		     
		     else if ( code_decoupe == -6 ) 
		       { 
			 codem6  += 1;fforme=0;
		       }

		   } /* else faces_cachees */

	       } /* if (fforme<-1.)  les faces ne sont pas coplanaires  */

		if(fforme < 0.) 
		  {
		    if (nblblr >= 11)
		      printf(" fforme negatif ns%d i %d j %d  fdf= %f\n",ns,i+1,j+1,1e6*fforme);
		  }
		else
		    fdf[i*nel-(i+1)*i/2+j%nel] += fforme; 


	/*	 titi1 += fforme ;printf(" ns %d i %d,j %d,fforme %f \n",ns,i+1,j+1-ns*nel,1.e6*fforme); */


	      }  /* for  (j=ideb+i ; j<ideb+nel ; j++ ) */
      
	  } /*  for (i=0 ; i<nel ; i++ )  */

      } /*  for (ns=0 ; ns<2^nplasy ; ns++ )  */

    /*     printf(" titi1 %f \n",titi1*1.e6);*/

    /* liberation de l'espace memoire */
    if (*faces_cachees) 
	{
	    free(voir);
	    tuer_tree(arbre,8);
	}
}
/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | dupliq3d_sym                                                         |
  |          Dupliquer le maillage pour le traitement des symtries       |
  |======================================================================| */

void dupliq3d_sym(int nplasy,double *plasym,
		  int npoinr,int nelray,int *nodray,
		  double *cooray,double *xnfray,
		  int *nel2,int *npoin2,int *nod2,double *coo2,double *xnf2,
		  int *grconv, int *grconv2)

{
	
    int i,j,i1,i2,idebnel,idebnp,numsym,inverse;
    double a,b,c,d,e,t[4][4],t1[4][4],t2[4][4];

    if (nplasy==1)
      {
	*nel2=2*nelray;
	*npoin2=2*npoinr;
      }
    else if (nplasy==2)
      {
	*nel2=4*nelray;
	*npoin2=4*npoinr;     
      }
    else if (nplasy==3)
      {
	*nel2=8*nelray;
	*npoin2=8*npoinr;     
      }

    for (i=0;i<nelray;i++)
    {
        *(nod2+i)         = *(nodray+i);
        *(nod2+i+*nel2)   = *(nodray+i+nelray);
        *(nod2+i+*nel2*2) = *(nodray+i+nelray*2);
        *(xnf2+i)         = *(xnfray+i);
        *(xnf2+i+*nel2)   = *(xnfray+i+nelray);
        *(xnf2+i+*nel2*2) = *(xnfray+i+nelray*2);

	*(grconv2+i)      = *(grconv+i);
    }

    for (i=0;i<npoinr;i++)
    {
       *(coo2+i)           = *(cooray+i);
       *(coo2+i+*npoin2)   = *(cooray+i+npoinr);
       *(coo2+i+*npoin2*2) = *(cooray+i+npoinr*2);
    }

    
    numsym=0;

    for (i=0;i<nplasy;i++)
      {
        a=plasym[i*4];
	b=plasym[i*4+1];
        c=plasym[i*4+2];
	d=plasym[i*4+3];
	e=-2./(a*a+b*b+c*c);
	t[0][0] = 1.+ a*a*e;
	t[1][1] = 1.+ b*b*e;
	t[2][2] = 1.+ c*c*e;
	t[0][1] = t[1][0] = a*b*e;
	t[0][2] = t[2][0] = a*c*e;
	t[1][2] = t[2][1] = b*c*e;
        t[0][3] = a*d*e; t[1][3] = b*d*e; t[2][3] = c*d*e;
	t[3][0]=t[3][1]=t[3][2]=0; t[3][3]=1;
	
	for (j=i;j<nplasy;j++)
	  {
	    inverse = -1;
	    if (i!=j)
	      {
		inverse = 1;
		a=plasym[j*4];
		b=plasym[j*4+1];
		c=plasym[j*4+2];
		d=plasym[j*4+3];
		e=-2./(a*a+b*b+c*c);
		t1[0][0] = 1.+ a*a*e;
		t1[1][1] = 1.+ b*b*e;
		t1[2][2] = 1.+ c*c*e;
		t1[0][1] = t1[1][0] = a*b*e;
		t1[0][2] = t1[2][0] = a*c*e;
		t1[1][2] = t1[2][1] = b*c*e;
		t1[0][3] = a*d*e; t1[1][3] = b*d*e; t1[2][3] = c*d*e;
		t1[3][0]=t1[3][1]=t1[3][2]=0; t1[3][3]=1;
		
		t2[0][0]= t[0][0]*t1[0][0]+t[0][1]*t1[1][0]+t[0][2]*t1[2][0]+t[0][3]*t1[3][0];
		t2[0][1]= t[0][0]*t1[0][1]+t[0][1]*t1[1][1]+t[0][2]*t1[2][1]+t[0][3]*t1[3][1];
		t2[0][2]= t[0][0]*t1[0][2]+t[0][1]*t1[1][2]+t[0][2]*t1[2][2]+t[0][3]*t1[3][2];
		t2[0][3]= t[0][0]*t1[0][3]+t[0][1]*t1[1][3]+t[0][2]*t1[2][3]+t[0][3]*t1[3][3];

		t2[1][1]= t[1][0]*t1[0][1]+t[1][1]*t1[1][1]+t[1][2]*t1[2][1]+t[1][3]*t1[3][1];
		t2[1][2]= t[1][0]*t1[0][2]+t[1][1]*t1[1][2]+t[1][2]*t1[2][2]+t[1][3]*t1[3][2];
		t2[1][3]= t[1][0]*t1[0][3]+t[1][1]*t1[1][3]+t[1][2]*t1[2][3]+t[1][3]*t1[3][3];

		t2[2][2]= t[2][0]*t1[0][2]+t[2][1]*t1[1][2]+t[2][2]*t1[2][2]+t[2][3]*t1[3][2];
		t2[2][3]= t[2][0]*t1[0][3]+t[2][1]*t1[1][3]+t[2][2]*t1[2][3]+t[2][3]*t1[3][3];

		t2[1][0]=t2[0][1];
		t2[2][0]=t2[0][2]; t2[2][1]=t2[1][2];
	      }
	    else
	      for (i1=0;i1<4;i1++)
		for (i2=0;i2<4;i2++)
		  t2[i1][i2]=t[i1][i2];

	    numsym +=1;
	    idebnel = numsym*nelray;	
	    idebnp  = numsym*npoinr;  
	    sym3d(t2,numsym,inverse,npoinr,nelray,nodray,cooray,xnfray,
		  *nel2,*npoin2,nod2,coo2,xnf2,idebnel,idebnp,grconv,grconv2);

	  }
      }


	if (nplasy==3)
	  {
	    inverse = -1;
	    i=0;
	    a=plasym[i*4];
	    b=plasym[i*4+1];
	    c=plasym[i*4+2];
	    d=plasym[i*4+3];
	    e=-2./(a*a+b*b+c*c);
	    t[0][0] = 1.+ a*a*e;
	    t[1][1] = 1.+ b*b*e;
	    t[2][2] = 1.+ c*c*e;
	    t[0][1] = t[1][0] = a*b*e;
	    t[0][2] = t[2][0] = a*c*e;
	    t[1][2] = t[2][1] = b*c*e;
	    t[0][3] = a*d*e; t[1][3] = b*d*e; t[2][3] = c*d*e;
	    t[3][0]=t[3][1]=t[3][2]=0; t[3][3]=1;

	    j=1;
	    a=plasym[j*4];
	    b=plasym[j*4+1];
	    c=plasym[j*4+2];
	    d=plasym[j*4+3];
	    e=-2./(a*a+b*b+c*c);
	    t1[0][0] = 1.+ a*a*e;
	    t1[1][1] = 1.+ b*b*e;
	    t1[2][2] = 1.+ c*c*e;
	    t1[0][1] = t1[1][0] = a*b*e;
	    t1[0][2] = t1[2][0] = a*c*e;
	    t1[1][2] = t1[2][1] = b*c*e;
	    t1[0][3] = a*d*e; t1[1][3] = b*d*e; t1[2][3] = c*d*e;
	    t1[3][0]=t1[3][1]=t1[3][2]=0; t1[3][3]=1;
	    
	    t2[0][0]= t[0][0]*t1[0][0]+t[0][1]*t1[1][0]+t[0][2]*t1[2][0]+t[0][3]*t1[3][0];
	    t2[0][1]= t[0][0]*t1[0][1]+t[0][1]*t1[1][1]+t[0][2]*t1[2][1]+t[0][3]*t1[3][1];
	    t2[0][2]= t[0][0]*t1[0][2]+t[0][1]*t1[1][2]+t[0][2]*t1[2][2]+t[0][3]*t1[3][2];
	    t2[0][3]= t[0][0]*t1[0][3]+t[0][1]*t1[1][3]+t[0][2]*t1[2][3]+t[0][3]*t1[3][3];
	    
	    t2[1][1]= t[1][0]*t1[0][1]+t[1][1]*t1[1][1]+t[1][2]*t1[2][1]+t[1][3]*t1[3][1];
	    t2[1][2]= t[1][0]*t1[0][2]+t[1][1]*t1[1][2]+t[1][2]*t1[2][2]+t[1][3]*t1[3][2];
	    t2[1][3]= t[1][0]*t1[0][3]+t[1][1]*t1[1][3]+t[1][2]*t1[2][3]+t[1][3]*t1[3][3];
	    
	    t2[2][2]= t[2][0]*t1[0][2]+t[2][1]*t1[1][2]+t[2][2]*t1[2][2]+t[2][3]*t1[3][2];
	    t2[2][3]= t[2][0]*t1[0][3]+t[2][1]*t1[1][3]+t[2][2]*t1[2][3]+t[2][3]*t1[3][3];
	    
	    t2[1][0]=t2[0][1];
	    t2[2][0]=t2[0][2]; t2[2][1]=t2[1][2];

	    j=2;
	    a=plasym[j*4];
	    b=plasym[j*4+1];
	    c=plasym[j*4+2];
	    d=plasym[j*4+3];
	    e=-2./(a*a+b*b+c*c);
	    t1[0][0] = 1.+ a*a*e;
	    t1[1][1] = 1.+ b*b*e;
	    t1[2][2] = 1.+ c*c*e;
	    t1[0][1] = t1[1][0] = a*b*e;
	    t1[0][2] = t1[2][0] = a*c*e;
	    t1[1][2] = t1[2][1] = b*c*e;
	    t1[0][3] = a*d*e; t1[1][3] = b*d*e; t1[2][3] = c*d*e;
	    t1[3][0]=t1[3][1]=t1[3][2]=0; t1[3][3]=1;

	    t[0][0]= t2[0][0]*t1[0][0]+t2[0][1]*t1[1][0]+t2[0][2]*t1[2][0]+t2[0][3]*t1[3][0];
	    t[0][1]= t2[0][0]*t1[0][1]+t2[0][1]*t1[1][1]+t2[0][2]*t1[2][1]+t2[0][3]*t1[3][1];
	    t[0][2]= t2[0][0]*t1[0][2]+t2[0][1]*t1[1][2]+t2[0][2]*t1[2][2]+t2[0][3]*t1[3][2];
	    t[0][3]= t2[0][0]*t1[0][3]+t2[0][1]*t1[1][3]+t2[0][2]*t1[2][3]+t2[0][3]*t1[3][3];
	    
	    t[1][1]= t2[1][0]*t1[0][1]+t2[1][1]*t1[1][1]+t2[1][2]*t1[2][1]+t2[1][3]*t1[3][1];
	    t[1][2]= t2[1][0]*t1[0][2]+t2[1][1]*t1[1][2]+t2[1][2]*t1[2][2]+t2[1][3]*t1[3][2];
	    t[1][3]= t2[1][0]*t1[0][3]+t2[1][1]*t1[1][3]+t2[1][2]*t1[2][3]+t2[1][3]*t1[3][3];
	    
	    t[2][2]= t2[2][0]*t1[0][2]+t2[2][1]*t1[1][2]+t2[2][2]*t1[2][2]+t2[2][3]*t1[3][2];
	    t[2][3]= t2[2][0]*t1[0][3]+t2[2][1]*t1[1][3]+t2[2][2]*t1[2][3]+t2[2][3]*t1[3][3];
	    
	    t[1][0]=t[0][1];
	    t[2][0]=t[0][2]; t[2][1]=t[1][2];

	    numsym +=1;
	    idebnel = numsym*nelray;	
	    idebnp  = numsym*npoinr;  
	    sym3d(t,numsym,inverse,npoinr,nelray,nodray,cooray,xnfray,
		  *nel2,*npoin2,nod2,coo2,xnf2,idebnel,idebnp,grconv,grconv2);
	  }
    
    /* impressions de controle */
/*        printf(" coordonnees\n ");	    
        for (n=0;n<*npoin2;n++) 
         printf(" point %d : %f %f %f \n",n,
		coo2[n],coo2[n+ *npoin2],coo2[n+ *npoin2*2]);
    
        printf(" normale \n");	    
        for (n=0;n<*nel2;n++) 
         printf(" face %d : %f %f %f \n",n,
		xnf2[n],xnf2[n+ *nel2],xnf2[n+ *nel2*2]);
    
        printf(" connectivite \n");	    
        for (n=0;n<*nel2;n++) 
         printf(" face %d : %d %d %d \n",n,
		nod2[n],nod2[n+ *nel2],nod2[n+ *nel2*2]);  */
	
}

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | sym3d                                                                |
  |          Calculer le symetrique d'un maillage                        |
  |======================================================================| */
void sym3d(double t[4][4],int numsym,int inverse,
	   int npoinr,int nelray,int *nodray,double *cooray,double *xnfray,
	   int nel2,int npoin2,int *nod2,double *coo2,double *xnf2,
	   int idebnel,int idebnp,int *grconv, int *grconv2)
{
  int n;
  double x,y,z;
      


  for (n=0;n<nelray;n++)
    {
      x  = xnfray[n];
      y  = xnfray[n+ nelray];
      z  = xnfray[n+ nelray*2];
      xnf2[idebnel+n]        = t[0][0]*x+t[0][1]*y+t[0][2]*z;
      xnf2[idebnel+n+nel2]   = t[1][0]*x+t[1][1]*y+t[1][2]*z;
      xnf2[idebnel+n+nel2*2] = t[2][0]*x+t[2][1]*y+t[2][2]*z;

      grconv2[idebnel+n]     = grconv[n];
    }  


  if (inverse==-1)
    for (n=0;n<nelray;n++)
      {
	nod2[idebnel+n]       = nodray[n] + numsym*npoinr; 
	nod2[idebnel+n+nel2]  = nodray[n+nelray*2] + numsym*npoinr; 
	nod2[idebnel+n+nel2*2]= nodray[n+nelray]   + numsym*npoinr;
      }
  else
    for (n=0;n<nelray;n++)
      {
	nod2[idebnel+n]       = nodray[n] + numsym*npoinr; 
	nod2[idebnel+n+nel2]  = nodray[n+nelray]   + numsym*npoinr;
	nod2[idebnel+n+nel2*2]= nodray[n+nelray*2] + numsym*npoinr;
      }


  for (n=0;n<npoinr;n++)
    {	
      x  = cooray[n];
      y  = cooray[n+ npoinr];
      z  = cooray[n+ npoinr*2];
      coo2[idebnp+n]           = t[0][0]*x+t[0][1]*y+t[0][2]*z + t[0][3]; 
      coo2[idebnp+n+ npoin2]   = t[1][0]*x+t[1][1]*y+t[1][2]*z + t[1][3]; 
      coo2[idebnp+n+ npoin2*2] = t[2][0]*x+t[2][1]*y+t[2][2]*z + t[2][3];
    } 
}

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | indvoir                                                              |
  |           calcul d'adresse dans le tableau voir (facforme_3d)        |
  |======================================================================| */
int indvoir(int i,int j, int n)
{
     return(i*n-i*(i+1)/2+j); 
}

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | surface_tria                                                         |
  |           calcul de la surface des triangles                         |
  |======================================================================| */

void surface_tria (int nel,int npoin,int *nod,double *coord,double *sufray)

{
    int i,k,noeud[3];
    double x01,y01,z01,x02,y02,z02;
    double xi[3],yi[3],zi[3];
    

    for (i=0 ; i<nel ; i++ )   
    {

       noeud[0] = nod[i];
       noeud[1] = nod[i+ nel];
       noeud[2] = nod[i+ nel *2];
       for (k=0;k<3;k++)
	 { 
	   xi[k] = coord[noeud[k]-1];
	   yi[k] = coord[noeud[k]-1+ npoin];
	   zi[k] = coord[noeud[k]-1+ npoin*2]; 
          }
       x01 = xi[1]-xi[0];
       y01 = yi[1]-yi[0];
       z01 = zi[1]-zi[0];
       x02 = xi[2]-xi[0];
       y02 = yi[2]-yi[0];
       z02 = zi[2]-zi[0];
      sufray[i] = 0.5 * sqrt ((x01*y02-y01*x02)*(x01*y02-y01*x02)
                            + (y01*z02-z01*y02)*(y01*z02-z01*y02)
                            + (x01*z02-z01*x02)*(x01*z02-z01*x02) );

   }
}


/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | coplanaire_3d                                                        |
  |           retourne 0 si les faces sont coplanaires, -1000 sinon      |
  |======================================================================| */

double coplanaire_3d (double xn1,double yn1,double zn1,
		   double xn2,double yn2,double zn2)
{
    double dnx,dny,dnz,xn,epscop;
    
    epscop = 5.E-3;
    dnx = xn1 - xn2;
    dny = yn1 - yn2;
    dnz = zn1 - zn2;

    xn = sqrt(dnx*dnx + dny*dny + dnz*dnz);
	
    if (xn<epscop) 
	return(0);
    else if ( abs(dnx)<epscop && abs(dny)<epscop && abs(dnz)<epscop)
	return(0);
    else
	return(-1000);
}


/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | triafdf                                                              |
  |        organisation du calcul du facteur de forme entre 2 triangles  |
  |======================================================================| */

void triafdf (struct node *arbre,double size_min,double dim_boite[],int *prem,
	      double xi[],double yi[],double zi[],double xii[],double yii[],double zii[],
	      int noeud[],int voir[],int nel2,int npoin,int *nod, double *coord,
	      int *ndecoup,double *fforme,int *ncomplique,int ndecoup_max)
 
{

    int i,ok,k,l,ik,il,ii,intersect,arrivee,nd;
    double xp[6],yp[6],zp[6],xq[6],yq[6],zq[6],ro[3],rd[3],pt_arr[3],fdf,epsff;
    double xg1,yg1,zg1,xg2,yg2,zg2,tiers;
    int vu[3][3],dans_prem;
    struct node *noeud_dep,*noeud_arr;



    epsff=1.E-10;
    tiers=1./3.;
    ok=0; 
    i=-1;
    dans_prem=0;

    for (k=0;k<3;k++)
      for (l=0;l<3;l++)
	{
	 vu[k][l]=0;
	}
        



    if (*prem)
      {
	*prem=0;
        dans_prem=1;
	for (k=0;k<3;k++)
	  for (l=3;l<6;l++)
	    {
	      ik = noeud[k]-1;  il = noeud[l]-1;
              if (il<ik) {ii=ik; ik=il; il=ii;}

	      if (voir[indvoir(ik,il,npoin)]<0)
		{
		  intersect=0;  
		  ro[0]=xi[k]; ro[1]=yi[k]; ro[2]=zi[k];
		  pt_arr[0]=xi[l];pt_arr[1]=yi[l]; pt_arr[2]=zi[l];
		  rd[0]=pt_arr[0]-ro[0];
		  rd[1]=pt_arr[1]-ro[1];
		  rd[2]=pt_arr[2]-ro[2];
		  noeud_dep=arbre; noeud_arr=arbre;
		  find_node_3d (&noeud_dep,ro[0],ro[1],ro[2]);
		  find_node_3d (&noeud_arr,pt_arr[0],pt_arr[1],pt_arr[2]);
		  arrivee = 0;
		  ivoitj_3d(arbre,noeud_dep,noeud_arr,ro,rd,pt_arr,
			    &intersect,size_min,
			    nel2,npoin,nod,coord,&arrivee,dim_boite);
		  voir[indvoir(ik,il,npoin)] = intersect;
                  vu[k][l-3]= intersect;
		}
	      else
		{
		  intersect=voir[indvoir(ik,il,npoin)];
		}
	    
	      if (!intersect) ok += 1;
/*	      printf(">> facforme_3d : k l intersect %d %d %d\n",ik+1,il+1,intersect);  */
	    }
      }
  
    
    else

      for (k=0;k<3;k++)
	for (l=3;l<6;l++) 
	  {
	    intersect=0;  
	    ro[0]=xii[k]; ro[1]=yii[k]; ro[2]=zii[k];
	    pt_arr[0]=xii[l];pt_arr[1]=yii[l]; pt_arr[2]=zii[l];
	    rd[0]=pt_arr[0]-ro[0];
	    rd[1]=pt_arr[1]-ro[1];
	    rd[2]=pt_arr[2]-ro[2];
	    noeud_dep=arbre; noeud_arr=arbre;
	    find_node_3d (&noeud_dep,ro[0],ro[1],ro[2]);
	    find_node_3d (&noeud_arr,pt_arr[0],pt_arr[1],pt_arr[2]);
	    arrivee = 0;

/*	    printf(" \n noeud depart %d noeud arrivee %d\n",noeud_dep->name,noeud_arr->name); */
	    ivoitj_3d(arbre,noeud_dep,noeud_arr,ro,rd,pt_arr,
		      &intersect,size_min,
		      nel2,npoin,nod,coord,&arrivee,dim_boite);
/*	    printf(">> facforme_3d (2): k l intersect %d %d %d\n",ik+1,il+1,intersect);*/
	    if (!intersect) ok += 1;
	  }
	  




    if ( 0 < ok && ok < 9 && dans_prem) 
      {
	*ncomplique += 1;
        ok=0;
	for (k=0;k<3;k++)
	  for (l=3;l<6;l++) 
	    if (vu[k][l-3]==0)
	      {
		ro[0]=xii[k]; ro[1]=yii[k]; ro[2]=zii[k];
		pt_arr[0]=xii[l];pt_arr[1]=yii[l]; pt_arr[2]=zii[l];
		rd[0]=pt_arr[0]-ro[0];
		rd[1]=pt_arr[1]-ro[1];
		rd[2]=pt_arr[2]-ro[2];
		noeud_dep=arbre; noeud_arr=arbre;
		find_node_3d (&noeud_dep,ro[0],ro[1],ro[2]);
		find_node_3d (&noeud_arr,pt_arr[0],pt_arr[1],pt_arr[2]);
		arrivee = 0;

		/*	    printf(" \n noeud depart %d noeud arrivee %d\n",noeud_dep->name,noeud_arr->name); */
		ivoitj_3d(arbre,noeud_dep,noeud_arr,ro,rd,pt_arr,
			  &intersect,size_min,
			  nel2,npoin,nod,coord,&arrivee,dim_boite);
		/*	    printf(">> facforme_3d (2): k l intersect %d %d %d\n",ik+1,il+1,intersect);*/
		if (!intersect) ok += 1;
	      }
      }
	
 
    /*   printf(">> facforme_3d : ok final =%d\n",ok);  */
    if (ok!=0)
      {
	proc(contou,CONTOU)(xi,yi,zi,&fdf); 
        /* printf(">> facforme_3d : estimation fdf =%f, ok=%d\n",fdf*1.E6,ok); */


	if (ok==9)
	  {*fforme += fdf;  }

	/*	else if (*ndecoup>=ndecoup_max || fdf<epsff) */
	else if (*ndecoup>=ndecoup_max)
	    {  *fforme = *fforme + (fdf*ok/9.); 
	      /* if (ok>4) *fforme = *fforme + fdf; */
	    }

	else
	  {
	    nd=*ndecoup+1;
	    xp[0]=xi[0]; yp[0]=yi[0]; zp[0]=zi[0];
	    xp[1]=xi[1]; yp[1]=yi[1]; zp[1]=zi[1];
	    xp[2]=xi[2]; yp[2]=yi[2]; zp[2]=zi[2];
	    xp[3]=(xi[0]+xi[1])/2.; yp[3]=(yi[0]+yi[1])/2.;zp[3]=(zi[0]+zi[1])/2.; 
	    xp[4]=(xi[2]+xi[1])/2.; yp[4]=(yi[2]+yi[1])/2.;zp[4]=(zi[2]+zi[1])/2.; 
	    xp[5]=(xi[0]+xi[2])/2.; yp[5]=(yi[0]+yi[2])/2.;zp[5]=(zi[0]+zi[2])/2.; 
	    
	    xq[0]=xi[3]; yq[0]=yi[3]; zq[0]=zi[3];
	    xq[1]=xi[4]; yq[1]=yi[4]; zq[1]=zi[4];
	    xq[2]=xi[5]; yq[2]=yi[5]; zq[2]=zi[5];
	    xq[3]=(xi[3]+xi[4])/2.; yq[3]=(yi[3]+yi[4])/2.;zq[3]=(zi[3]+zi[4])/2.; 
	    xq[4]=(xi[5]+xi[4])/2.; yq[4]=(yi[5]+yi[4])/2.;zq[4]=(zi[5]+zi[4])/2.; 
	    xq[5]=(xi[3]+xi[5])/2.; yq[5]=(yi[3]+yi[5])/2.;zq[5]=(zi[3]+zi[5])/2.; 
	    
	    for (k=0;k<4;k++)
	      for (l=0;l<4;l++)
		{
		  xi[0]=xp[ss_tria[k][0]]; yi[0]=yp[ss_tria[k][0]]; zi[0]=zp[ss_tria[k][0]];
		  xi[1]=xp[ss_tria[k][1]]; yi[1]=yp[ss_tria[k][1]]; zi[1]=zp[ss_tria[k][1]];
		  xi[2]=xp[ss_tria[k][2]]; yi[2]=yp[ss_tria[k][2]]; zi[2]=zp[ss_tria[k][2]];
		  xi[3]=xq[ss_tria[l][0]]; yi[3]=yq[ss_tria[l][0]]; zi[3]=zq[ss_tria[l][0]];
		  xi[4]=xq[ss_tria[l][1]]; yi[4]=yq[ss_tria[l][1]]; zi[4]=zq[ss_tria[l][1]];
		  xi[5]=xq[ss_tria[l][2]]; yi[5]=yq[ss_tria[l][2]]; zi[5]=zq[ss_tria[l][2]];
		
		  xg1=(xi[0]+xi[1]+xi[2])*tiers; yg1=(yi[0]+yi[1]+yi[2])*tiers; zg1=(zi[0]+zi[1]+zi[2])*tiers;
		  xg2=(xi[3]+xi[4]+xi[5])*tiers; yg2=(yi[3]+yi[4]+yi[5])*tiers; zg2=(zi[3]+zi[4]+zi[5])*tiers;
		  xii[0]=xi[0]+(xg1-xi[0])*0.001; yii[0]=yi[0]+(yg1-yi[0])*0.001; zii[0]=zi[0]+(zg1-zi[0])*0.001;
		  xii[1]=xi[1]+(xg1-xi[1])*0.001; yii[1]=yi[1]+(yg1-yi[1])*0.001; zii[1]=zi[1]+(zg1-zi[1])*0.001;
		  xii[2]=xi[2]+(xg1-xi[2])*0.001; yii[2]=yi[2]+(yg1-yi[2])*0.001; zii[2]=zi[2]+(zg1-zi[2])*0.001;
		  xii[3]=xi[3]+(xg2-xi[3])*0.001; yii[3]=yi[3]+(yg2-yi[3])*0.001; zii[3]=zi[3]+(zg2-zi[3])*0.001;
		  xii[4]=xi[4]+(xg2-xi[4])*0.001; yii[4]=yi[4]+(yg2-yi[4])*0.001; zii[4]=zi[4]+(zg2-zi[4])*0.001;
		  xii[5]=xi[5]+(xg2-xi[5])*0.001; yii[5]=yi[5]+(yg2-yi[5])*0.001; zii[5]=zi[5]+(zg2-zi[5])*0.001;

		  triafdf (arbre,size_min,dim_boite,prem,xi,yi,zi,xii,yii,zii,
			   noeud,voir,nel2,npoin,nod,coord,
			   &nd,fforme,ncomplique,ndecoup_max);
		}
	    (*ndecoup)++;
	  }
      }        


	    

}


/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | dupliq3d_per                                                         |
  |          Dupliquer le maillage pour le traitement de la periodicite  |
  |          avec eventuellement un plan de symetrie orthogonal a l'axe  |
  |          definissant la periodicite de rotation                      |
  |======================================================================| */

void dupliq3d_per(int nplasy,double *plasym,int nperay,double *perray,
		  int npoinr,int nelray,int *nodray,
		  double *cooray,double *xnfray,
		  int *nel2,int *npoin2,int *nod2,double *coo2,double *xnf2,
		  int *grconv, int *grconv2)


{
	
    int i,idebnel,idebnp,numper,npersym,inverse;
    double sa,sb,sc,sd,se,t[4][4],t1[4][4],t2[4][4];
    double Pi;
    double phi,theta,c,s,c2,s2,an,aa,bb,cc,dd,ee,ff,gg,hh,ii;
    double px,py,pz,ax,ay,az,alfa,angle,eps=1.e-6;
    

    Pi = 3.141592653589793;  	
    /**nel2 = (int)(nperay*pow(2,nplasy)+0.1)*nelray;
    *npoin2 = (int)(nperay*pow(2,nplasy)+0.1)*npoinr;*/
    if (nplasy==0)
      {
	*nel2=nperay*nelray;
	*npoin2=nperay*npoinr;
      }
    else if (nplasy==1)
      {
	*nel2=nperay*2*nelray;
	*npoin2=nperay*2*npoinr;
      }
    else if (nplasy==2)
      {
	*nel2=nperay*4*nelray;
	*npoin2=nperay*4*npoinr;     
      }
    else if (nplasy==3)
      {
	*nel2=nperay*8*nelray;
	*npoin2=nperay*8*npoinr;     
      }

    for (i=0;i<nelray;i++)
    {
        *(nod2+i)         = *(nodray+i);
        *(nod2+i+*nel2)   = *(nodray+i+nelray);
        *(nod2+i+*nel2*2) = *(nodray+i+nelray*2);
        *(xnf2+i)         = *(xnfray+i);
        *(xnf2+i+*nel2)   = *(xnfray+i+nelray);
        *(xnf2+i+*nel2*2) = *(xnfray+i+nelray*2);

	*(grconv2+i)      = *(grconv+i);
    }

    for (i=0;i<npoinr;i++)
    {
       *(coo2+i)           = *(cooray+i);
       *(coo2+i+*npoin2)   = *(cooray+i+npoinr);
       *(coo2+i+*npoin2*2) = *(cooray+i+npoinr*2);
    }

    if (nplasy == 1)
      {
	inverse = -1;
	sa=plasym[0];
	sb=plasym[1];
	sc=plasym[2];
	sd=plasym[3];
	se=-2./(sa*sa+sb*sb+sc*sc);
	t1[0][0] = 1.+ sa*sa*se;
	t1[1][1] = 1.+ sb*sb*se;
	t1[2][2] = 1.+ sc*sc*se;
	t1[0][1] = t1[1][0] = sa*sb*se;
	t1[0][2] = t1[2][0] = sa*sc*se;
	t1[1][2] = t1[2][1] = sb*sc*se;
	t1[0][3] = sa*sd*se; t1[1][3] = sb*sd*se; t1[2][3] = sc*sd*se;
	t1[3][0]=t1[3][1]=t1[3][2]=0; t1[3][3]=1;

	npersym = nperay ;
	idebnel = npersym*nelray;	
	idebnp  = npersym*npoinr;  
	persym3d(t1,npersym,inverse,npoinr,nelray,nodray,cooray,xnfray,
		 *nel2,*npoin2,nod2,coo2,xnf2,idebnel,idebnp,grconv,grconv2);  
      }


    numper=0;
    px = perray[0];
    py = perray[1];
    pz = perray[2];
    ax = perray[3];
    ay = perray[4];
    az = perray[5];
    alfa = perray[6]*2*Pi/360.;

    for (i=0;i<nperay-1;i++)
      {
        angle = alfa*(i+1);
	if (abs(ax) >  eps)
	  {
	    an = sqrt(ax*ax+ay*ay);
	    phi = atan2(ay,ax); theta = atan2(az,an) ;
	    c = cos(phi) ; s   = sin(phi) ; c2 = cos(theta) ; s2 = sin(theta);
	  }
	else if (abs(ay) >  eps)
	  {
	    an = sqrt(ax*ax+ay*ay);
	    theta = atan2(az,an) ; c = 0. ; s = 1. ; c2 = cos(theta) ; s2 = sin(theta) ;
	  }
	else
	  {
	    c =1 ; s = 0 ; c2 = 0 ; s2 = 1 ;
	  }

	aa =  c2*c ;
	bb = -c2*s ;
	cc =  s2 ;
	dd =  cos(angle)*s+sin(angle)*s2*c ;
	ee =  cos(angle)*c-sin(angle)*s*s2 ;
	ff =  -sin(angle)*c2 ;
	gg =  sin(angle)*s-cos(angle)*s2*c ;
	hh =  sin(angle)*c+cos(angle)*s*s2 ;
	ii =  cos(angle)*c2 ;

	t[0][0] = aa*aa+s*dd-c*s2*gg;
	t[1][1] = -s*c2*bb+c*ee+s*s2*hh;
	t[2][2] = s2*cc+c2*ii;
	t[1][0] = -s*c2*aa+c*dd+s*s2*gg;
	t[0][1] = aa*bb+s*ee-c*s2*hh;
	t[2][0] = s2*aa+c2*gg;
	t[0][2] = aa*cc+s*ff-c*s2*ii;
	t[2][1] = s2*bb+c2*hh;
	t[1][2] = -s*c2*cc+c*ff+s*s2*ii;
        t[3][0] = t[3][1] = t[3][2] = 0.;
	t[0][3]= px ; t[1][3]= py ; t[2][3]= pz ; t[3][3]=1;
	
	numper +=1;
	inverse = 1 ;
	idebnel = (numper)*nelray;	
	idebnp  = (numper)*npoinr;  
	persym3d(t,numper,inverse,npoinr,nelray,nodray,cooray,xnfray,
		 *nel2,*npoin2,nod2,coo2,xnf2,idebnel,idebnp,grconv,grconv2);  

	if (nplasy == 1)
	  {
	    inverse = -1;
	    sa=plasym[0];
	    sb=plasym[1];
	    sc=plasym[2];
	    sd=plasym[3];
	    se=-2./(sa*sa+sb*sb+sc*sc);
	    t1[0][0] = 1.+ sa*sa*se;
	    t1[1][1] = 1.+ sb*sb*se;
	    t1[2][2] = 1.+ sc*sc*se;
	    t1[0][1] = t1[1][0] = sa*sb*se;
	    t1[0][2] = t1[2][0] = sa*sc*se;
	    t1[1][2] = t1[2][1] = sb*sc*se;
	    t1[0][3] = sa*sd*se; t1[1][3] = sb*sd*se; t1[2][3] = sc*sd*se;
	    t1[3][0]=t1[3][1]=t1[3][2]=0; t1[3][3]=1;
		
	    t2[0][0]= t[0][0]*t1[0][0]+t[0][1]*t1[1][0]+t[0][2]*t1[2][0]+t[0][3]*t1[3][0];
	    t2[0][1]= t[0][0]*t1[0][1]+t[0][1]*t1[1][1]+t[0][2]*t1[2][1]+t[0][3]*t1[3][1];
	    t2[0][2]= t[0][0]*t1[0][2]+t[0][1]*t1[1][2]+t[0][2]*t1[2][2]+t[0][3]*t1[3][2];
	    t2[0][3]= t[0][0]*t1[0][3]+t[0][1]*t1[1][3]+t[0][2]*t1[2][3]+t[0][3]*t1[3][3];

	    t2[1][0]= t[1][0]*t1[0][0]+t[1][1]*t1[1][0]+t[1][2]*t1[2][0]+t[1][3]*t1[3][0];
	    t2[1][1]= t[1][0]*t1[0][1]+t[1][1]*t1[1][1]+t[1][2]*t1[2][1]+t[1][3]*t1[3][1];
	    t2[1][2]= t[1][0]*t1[0][2]+t[1][1]*t1[1][2]+t[1][2]*t1[2][2]+t[1][3]*t1[3][2];
	    t2[1][3]= t[1][0]*t1[0][3]+t[1][1]*t1[1][3]+t[1][2]*t1[2][3]+t[1][3]*t1[3][3];

	    t2[2][0]= t[2][0]*t1[0][0]+t[2][1]*t1[1][0]+t[2][2]*t1[2][0]+t[2][3]*t1[3][0];
	    t2[2][1]= t[2][0]*t1[0][1]+t[2][1]*t1[1][1]+t[2][2]*t1[2][1]+t[2][3]*t1[3][1];
	    t2[2][2]= t[2][0]*t1[0][2]+t[2][1]*t1[1][2]+t[2][2]*t1[2][2]+t[2][3]*t1[3][2];
	    t2[2][3]= t[2][0]*t1[0][3]+t[2][1]*t1[1][3]+t[2][2]*t1[2][3]+t[2][3]*t1[3][3];

	    t2[3][0]= t[3][0]*t1[0][0]+t[3][1]*t1[1][0]+t[3][2]*t1[2][0]+t[3][3]*t1[3][0];
	    t2[3][1]= t[3][0]*t1[0][1]+t[3][1]*t1[1][1]+t[3][2]*t1[2][1]+t[3][3]*t1[3][1];
	    t2[3][2]= t[3][0]*t1[0][2]+t[3][1]*t1[1][2]+t[3][2]*t1[2][2]+t[3][3]*t1[3][2];
	    t2[3][3]= t[3][0]*t1[0][3]+t[3][1]*t1[1][3]+t[3][2]*t1[2][3]+t[3][3]*t1[3][3];

	    npersym = numper+nperay ;
	    idebnel = npersym*nelray;	
	    idebnp  = npersym*npoinr;  
	    persym3d(t2,npersym,inverse,npoinr,nelray,nodray,cooray,xnfray,
		     *nel2,*npoin2,nod2,coo2,xnf2,idebnel,idebnp,grconv,grconv2);  

	  }

      }                     


   
    /* impressions de controle */
    /*        printf(" coordonnees\n ");	    
        for (n=0;n<*npoin2;n++) 
         printf(" point %d : %f %f %f \n",n,
		coo2[n],coo2[n+ *npoin2],coo2[n+ *npoin2*2]);
    
        printf(" normale \n");	    
        for (n=0;n<*nel2;n++) 
         printf(" face %d : %f %f %f \n",n,
		xnf2[n],xnf2[n+ *nel2],xnf2[n+ *nel2*2]);
    
        printf(" connectivite \n");	    
        for (n=0;n<*nel2;n++) 
         printf(" face %d : %d %d %d \n",n,
		nod2[n],nod2[n+ *nel2],nod2[n+ *nel2*2]);  
		*/	
}



/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | persym3d                                                             |
  |          Calculer le periodique d'un maillage                        |
  |          et eventuellement son periodique et symetrique              |
  |======================================================================| */
void persym3d(double t[4][4],int numsym,int inverse,
              int npoinr,int nelray,int *nodray,double *cooray,double *xnfray,
              int nel2,int npoin2,int *nod2,double *coo2,double *xnf2,
              int idebnel,int idebnp,int *grconv, int *grconv2)
{
  int n;
  double x,y,z;
      
  for (n=0;n<nelray;n++)
    {
      x  = xnfray[n];
      y  = xnfray[n+ nelray];
      z  = xnfray[n+ nelray*2];
      xnf2[idebnel+n]        = t[0][0]*x+t[0][1]*y+t[0][2]*z;
      xnf2[idebnel+n+nel2]   = t[1][0]*x+t[1][1]*y+t[1][2]*z;
      xnf2[idebnel+n+nel2*2] = t[2][0]*x+t[2][1]*y+t[2][2]*z;

      *(grconv2+n+idebnel)   = *(grconv+n);
    }  


  if (inverse==-1)
    for (n=0;n<nelray;n++)
      {
	nod2[idebnel+n]       = nodray[n] + numsym*npoinr; 
	nod2[idebnel+n+nel2]  = nodray[n+nelray*2] + numsym*npoinr; 
	nod2[idebnel+n+nel2*2]= nodray[n+nelray]   + numsym*npoinr;
      }
  else
    for (n=0;n<nelray;n++)
      {
	nod2[idebnel+n]       = nodray[n] + numsym*npoinr; 
	nod2[idebnel+n+nel2]  = nodray[n+nelray]   + numsym*npoinr;
	nod2[idebnel+n+nel2*2]= nodray[n+nelray*2] + numsym*npoinr;
      }


  for (n=0;n<npoinr;n++)
    {	
      x  = cooray[n];
      y  = cooray[n+ npoinr];
      z  = cooray[n+ npoinr*2];
      coo2[idebnp+n]           = t[0][0]*(x-t[0][3])+t[0][1]*(y-t[1][3])+t[0][2]*(z-t[2][3])+ t[0][3]; 
      coo2[idebnp+n+ npoin2]   = t[1][0]*(x-t[0][3])+t[1][1]*(y-t[1][3])+t[1][2]*(z-t[2][3])+ t[1][3]; 
      coo2[idebnp+n+ npoin2*2] = t[2][0]*(x-t[0][3])+t[2][1]*(y-t[1][3])+t[2][2]*(z-t[2][3])+ t[2][3];
    } 
}


/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | facecache_3d                                                         |
  |          Algorithme de detection rapide de presence de face cachees  |
  |======================================================================| */
void facecache_3d(int ndim, int npoin2,int nel2,int nel,
		  int *nod,double *coord,double *xnf,
		  int *faces_cachees,int nplasy,int nperay)

{

  int i,j,k,ns;
  int noeud[6];
  int nbfcoplanaire,code_decoupe,nbfca;
  int ideb,npoin22;
  double xi[6],yi[6],zi[6],*pland,dsign[6];
  double xn1,yn1,zn1,x,y,z,fforme;


  pland = (double*)malloc( nel2 * sizeof(double));
  if (pland==NULL) 
    {printf(" ERREUR facecache_3d : probleme d'allocation memoire\n");
     exit(0);}

  nbfca = 0 ;
  nbfcoplanaire = 0 ;
  npoin22 = 2*npoin2 ;

  for (i=0 ; i<nel2 ; i++)
    {
      xn1 = xnf[i];
      yn1 = xnf[i+ nel2];
      zn1 = xnf[i+ nel2*2];
      x  = coord[nod[i]-1];
      y  = coord[nod[i]-1+npoin2];
      z  = coord[nod[i]-1+npoin22];
      pland[i]=-x*xn1-y*yn1-z*zn1;
    }


  ideb = -nel;
  for (ns=0 ; ns < nsp ; ns++ ) 
    {
      ideb += nel;
      for (i=0 ; i<nel ; i++ ) 
/*      for (i=463 ; i<464 ; i++ ) */
	{
	  xn1 = xnf[i];
	  yn1 = xnf[i+ nel2];
	  zn1 = xnf[i+ nel2*2];
	  noeud[0] = nod[i];
	  noeud[1] = nod[i+ nel2];
	  noeud[2] = nod[i+ nel2 *2];

	  for  (j=ideb+i ; j<ideb+nel ; j++ )   
/*	  for  (j=558 ; j<559 ; j++ )   */
	    {
	      fforme = coplanaire_3d(xn1,yn1,zn1,xnf[j],xnf[j+nel2],xnf[j+nel2*2]);
	      if (fforme<-1.)  /* les faces ne sont pas coplanaires */
		{
		  noeud[3] = nod[j];
		  noeud[4] = nod[j+ nel2];
		  noeud[5] = nod[j+ nel2*2];
		    
		  for (k=0;k<6;k++)
		    { 
		      xi[k] = coord[noeud[k]-1];
		      yi[k] = coord[noeud[k]-1+ npoin2];
		      zi[k] = coord[noeud[k]-1+ npoin22]; 
		    }
		  
		  derriere_3d(nel2,i,j,xnf,pland,xi,yi,zi,dsign,&code_decoupe) ;  
		  if ( code_decoupe != 0 ) nbfca += 1 ;
	/*	  printf(" code_decoupe %d \n",code_decoupe); */
		}
	    }
	}

    }
  if (nbfca != 0 ) 
    {
      *faces_cachees = 1 ;
      printf("\n *** FACECACHE_3D : Le maillage comporte des faces cachees (nbre=%d) \n",nbfca ) ;
    }
  else
    {
      *faces_cachees = 0 ;
      printf("\n *** FACECACHE_3D : Le maillage ne comporte a priori pas de faces cachees \n" ) ;
    }

}
/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | dimension_3d                                                         |
  |           dimensions caracteristiques du probleme                    |
  |======================================================================| */
void dimension_3d(int ndim,int nelray,int npoinr,int *nodray,double *cooray,
		  double *taille_boite,double *taille_seg)
{

    int i,npoin2,nelray2,na,nb,nc;
    double xmin,xmax,ymin,ymax,zmin,zmax;
    double xa,ya,za,xb,yb,zb,xc,yc,zc,ds;

    npoin2=2*npoinr;
    nelray2=2*nelray;

    xmin =  1.E10; ymin=  1.E6 ; zmin=  1.E6;
    xmax = -1.E10; ymax= -1.E6 ; zmax= -1.E6;

    for (i=0;i<npoinr;i++)
    {
       xmin = min(*(cooray+i),xmin);
       ymin = min(*(cooray+i+npoinr),ymin);
       zmin = min(*(cooray+i+npoin2),zmin);
       xmax = max(*(cooray+i),xmax);
       ymax = max(*(cooray+i+npoinr),ymax);
       zmax = max(*(cooray+i+npoin2),zmax);
    }

    *taille_boite=0.;
    *taille_boite=max(*taille_boite,(xmax-xmin));
    *taille_boite=max(*taille_boite,(ymax-ymin));
    *taille_boite=max(*taille_boite,(zmax-zmin));


    *taille_seg=1.E8;

    for (i=0;i<nelray;i++)
    {
      na=nodray[i]-1; nb=nodray[i+nelray]-1; nc=nodray[i+nelray2]-1;
      xa=*(cooray+na); ya=*(cooray+na+npoinr); za=*(cooray+na+npoin2);
      xb=*(cooray+nb); yb=*(cooray+nb+npoinr); zb=*(cooray+nb+npoin2);
      xc=*(cooray+nc); yc=*(cooray+nc+npoinr); zc=*(cooray+nc+npoin2);
      ds=sqrt((xb-xa)*(xb-xa)+(yb-ya)*(yb-ya)+(zb-za)*(zb-za));
      *taille_seg=min(*taille_seg,ds);
      ds=sqrt((xc-xa)*(xc-xa)+(yc-ya)*(yc-ya)+(zc-za)*(zc-za));
      *taille_seg=min(*taille_seg,ds);
      ds=sqrt((xb-xc)*(xb-xc)+(yb-yc)*(yb-yc)+(zb-zc)*(zb-zc));
      *taille_seg=min(*taille_seg,ds);
    }

    printf("\n *** DIMENSION_3D : dimensions caracteristiques :\n"); 
    printf("                    encombrement    = %f \n",*taille_boite); 
    printf("                    + petit segment = %f \n",*taille_seg); 
  }




/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | boite : calcul de la boite englobante                                |
  |                                                                      |
  |======================================================================| */

void boite(int ndim,int npoins,double *coords,double dim_boite[])
{
  int i,npoins2;
  double xmin,xmax,ymin,ymax,zmin,zmax,dx,dy,dz;

  npoins2 = 2*npoins;

  xmin =  1.E10; ymin=  1.E6 ; zmin=  1.E6;
  xmax = -1.E10; ymax= -1.E6 ; zmax= -1.E6;
    
  for (i=0;i<npoins;i++)
    {
      xmin = min(*(coords+i),xmin);
      ymin = min(*(coords+i+npoins),ymin);
      zmin = min(*(coords+i+npoins2),zmin);
      xmax = max(*(coords+i),xmax);
      ymax = max(*(coords+i+npoins),ymax);
      zmax = max(*(coords+i+npoins2),zmax);
    }
  
  dx = xmax-xmin; dy=ymax-ymin; dz=zmax-zmin;
  xmin -= (dx*0.01); ymin -= (dy*0.01); zmin -= (dz*0.01);
  xmax += (dx*0.01); ymax += (dy*0.01); zmax += (dz*0.01); 
  
  
  dx = xmax-xmin; dy=ymax-ymin; dz=zmax-zmin;
  if (dx<1.e-10) xmax+=1.e-4;
  if (dy<1.e-10) ymax+=1.e-4;
  if (dz<1.e-10) zmax+=1.e-4;
  
  xmin -= (dx*0.01); ymin -= (dy*0.01); zmin -= (dz*0.01);
  xmax += (dx*0.01); ymax += (dy*0.01); zmax += (dz*0.01); 
  
  dim_boite[0]=xmin; dim_boite[1]=xmax; 
  dim_boite[2]=ymin; dim_boite[3]=ymax; 
  dim_boite[4]=zmin; dim_boite[5]=zmax; 
  
}
