; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10,CHECK-LE,CHECK-P10-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10,CHECK-BE,CHECK-P10-BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P9,CHECK-LE,CHECK-P9-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P9,CHECK-BE,CHECK-P9-BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P8,CHECK-LE,CHECK-P8-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P8,CHECK-BE,CHECK-P8-BE

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_0_int8_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_0_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align16_int8_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 8(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align32_int8_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align64_int8_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_reg_int8_t_uint8_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbzx r3, r3, r4
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_or_int8_t_uint8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint16_int8_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align16_int8_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lbz r3, 24(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 8
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint32_int8_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align32_int8_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_int8_t_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lbzx r3, r3, r4
; CHECK-P9-NEXT:    extsb r3, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_int8_t_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 16
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint64_int8_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align64_int8_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 4096
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align16_int8_t_uint8_t() {
; CHECK-LABEL: ld_cst_align16_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 4080(0)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 4080 to ptr), align 16
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align32_int8_t_uint8_t() {
; CHECK-LABEL: ld_cst_align32_int8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lbz r3, -27108(r3)
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 9999900 to ptr), align 4
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align64_int8_t_uint8_t() {
; CHECK-P10-LABEL: ld_cst_align64_int8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    extsb r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    extsb r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_0_int8_t_uint16_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_0_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_0_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align16_int8_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-LE-LABEL: ld_align16_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 8(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_align16_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 9(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align32_int8_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align32_int8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align32_int8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    plbz r3, 99999001(r3), 0
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align32_int8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 1525
; CHECK-P9-LE-NEXT:    ori r4, r4, 56600
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align32_int8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, 1525
; CHECK-P9-BE-NEXT:    ori r4, r4, 56601
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align32_int8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1525
; CHECK-P8-LE-NEXT:    ori r4, r4, 56600
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align32_int8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1525
; CHECK-P8-BE-NEXT:    ori r4, r4, 56601
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align64_int8_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align64_int8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align64_int8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align64_int8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align64_int8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align64_int8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align64_int8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_reg_int8_t_uint16_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LE-LABEL: ld_reg_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbzx r3, r3, r4
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_reg_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    add r3, r3, r4
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_or_int8_t_uint16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LE-LABEL: ld_or_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    or r3, r4, r3
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_or_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    or r3, r4, r3
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv1 = trunc i16 %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint16_int8_t_uint16_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint16_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 6
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint16_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 6
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align16_int8_t_uint16_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_disjoint_align16_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-LE-NEXT:    lbz r3, 24(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_disjoint_align16_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-BE-NEXT:    lbz r3, 25(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 8
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint32_int8_t_uint16_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint32_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 34463
; CHECK-LE-NEXT:    oris r3, r3, 1
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint32_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 34463
; CHECK-BE-NEXT:    oris r3, r3, 1
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align32_int8_t_uint16_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align32_int8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    lis r4, -15264
; CHECK-P10-LE-NEXT:    and r3, r3, r4
; CHECK-P10-LE-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align32_int8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    lis r4, -15264
; CHECK-P10-BE-NEXT:    and r3, r3, r4
; CHECK-P10-BE-NEXT:    plbz r3, 999990001(r3), 0
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align32_int8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, -15264
; CHECK-P9-LE-NEXT:    and r3, r3, r4
; CHECK-P9-LE-NEXT:    lis r4, 15258
; CHECK-P9-LE-NEXT:    ori r4, r4, 41712
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align32_int8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, -15264
; CHECK-P9-BE-NEXT:    and r3, r3, r4
; CHECK-P9-BE-NEXT:    lis r4, 15258
; CHECK-P9-BE-NEXT:    ori r4, r4, 41713
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align32_int8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, -15264
; CHECK-P8-LE-NEXT:    lis r5, 15258
; CHECK-P8-LE-NEXT:    and r3, r3, r4
; CHECK-P8-LE-NEXT:    ori r4, r5, 41712
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align32_int8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, -15264
; CHECK-P8-BE-NEXT:    lis r5, 15258
; CHECK-P8-BE-NEXT:    and r3, r3, r4
; CHECK-P8-BE-NEXT:    ori r4, r5, 41713
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 16
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint64_int8_t_uint16_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_not_disjoint64_int8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    or r3, r3, r5
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_not_disjoint64_int8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    or r3, r3, r5
; CHECK-P10-BE-NEXT:    lbz r3, 1(r3)
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_not_disjoint64_int8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    or r3, r3, r4
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_not_disjoint64_int8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    or r3, r3, r4
; CHECK-P9-BE-NEXT:    lbz r3, 1(r3)
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint64_int8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    or r3, r3, r4
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint64_int8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    or r3, r3, r4
; CHECK-P8-BE-NEXT:    lbz r3, 1(r3)
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align64_int8_t_uint16_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align64_int8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align64_int8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align64_int8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align64_int8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align64_int8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align64_int8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 4096
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align16_int8_t_uint16_t() {
; CHECK-LE-LABEL: ld_cst_align16_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 4080(0)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align16_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 4081(0)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align32_int8_t_uint16_t() {
; CHECK-LE-LABEL: ld_cst_align32_int8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lis r3, 153
; CHECK-LE-NEXT:    lbz r3, -27108(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align32_int8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lis r3, 153
; CHECK-BE-NEXT:    lbz r3, -27107(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align64_int8_t_uint16_t() {
; CHECK-P10-LE-LABEL: ld_cst_align64_int8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 244140625
; CHECK-P10-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_align64_int8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_align64_int8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r3, 3725
; CHECK-P9-LE-NEXT:    ori r3, r3, 19025
; CHECK-P9-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_align64_int8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4097
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align64_int8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 3725
; CHECK-P8-LE-NEXT:    ori r3, r3, 19025
; CHECK-P8-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align64_int8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4097
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_0_int8_t_uint32_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_0_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_0_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align16_int8_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-LE-LABEL: ld_align16_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 8(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_align16_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 11(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align32_int8_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align32_int8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align32_int8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    plbz r3, 99999003(r3), 0
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align32_int8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 1525
; CHECK-P9-LE-NEXT:    ori r4, r4, 56600
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align32_int8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, 1525
; CHECK-P9-BE-NEXT:    ori r4, r4, 56603
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align32_int8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1525
; CHECK-P8-LE-NEXT:    ori r4, r4, 56600
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align32_int8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1525
; CHECK-P8-BE-NEXT:    ori r4, r4, 56603
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align64_int8_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align64_int8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align64_int8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587331
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align64_int8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align64_int8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4099
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align64_int8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align64_int8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4099
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_reg_int8_t_uint32_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LE-LABEL: ld_reg_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbzx r3, r3, r4
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_reg_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    add r3, r3, r4
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_or_int8_t_uint32_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LE-LABEL: ld_or_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    or r3, r4, r3
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_or_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    or r3, r4, r3
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv1 = trunc i32 %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint16_int8_t_uint32_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint16_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 6
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint16_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 6
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align16_int8_t_uint32_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_disjoint_align16_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-LE-NEXT:    lbz r3, 24(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_disjoint_align16_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-BE-NEXT:    lbz r3, 27(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 8
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint32_int8_t_uint32_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint32_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 34463
; CHECK-LE-NEXT:    oris r3, r3, 1
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint32_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 34463
; CHECK-BE-NEXT:    oris r3, r3, 1
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align32_int8_t_uint32_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align32_int8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    lis r4, -15264
; CHECK-P10-LE-NEXT:    and r3, r3, r4
; CHECK-P10-LE-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align32_int8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    lis r4, -15264
; CHECK-P10-BE-NEXT:    and r3, r3, r4
; CHECK-P10-BE-NEXT:    plbz r3, 999990003(r3), 0
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align32_int8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, -15264
; CHECK-P9-LE-NEXT:    and r3, r3, r4
; CHECK-P9-LE-NEXT:    lis r4, 15258
; CHECK-P9-LE-NEXT:    ori r4, r4, 41712
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align32_int8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, -15264
; CHECK-P9-BE-NEXT:    and r3, r3, r4
; CHECK-P9-BE-NEXT:    lis r4, 15258
; CHECK-P9-BE-NEXT:    ori r4, r4, 41715
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align32_int8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, -15264
; CHECK-P8-LE-NEXT:    lis r5, 15258
; CHECK-P8-LE-NEXT:    and r3, r3, r4
; CHECK-P8-LE-NEXT:    ori r4, r5, 41712
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align32_int8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, -15264
; CHECK-P8-BE-NEXT:    lis r5, 15258
; CHECK-P8-BE-NEXT:    and r3, r3, r4
; CHECK-P8-BE-NEXT:    ori r4, r5, 41715
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 16
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint64_int8_t_uint32_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_not_disjoint64_int8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    or r3, r3, r5
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_not_disjoint64_int8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    or r3, r3, r5
; CHECK-P10-BE-NEXT:    lbz r3, 3(r3)
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_not_disjoint64_int8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    or r3, r3, r4
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_not_disjoint64_int8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    or r3, r3, r4
; CHECK-P9-BE-NEXT:    lbz r3, 3(r3)
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint64_int8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    or r3, r3, r4
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint64_int8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    or r3, r3, r4
; CHECK-P8-BE-NEXT:    lbz r3, 3(r3)
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align64_int8_t_uint32_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align64_int8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align64_int8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587331
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align64_int8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align64_int8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4099
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align64_int8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align64_int8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4099
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4096
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align16_int8_t_uint32_t() {
; CHECK-LE-LABEL: ld_cst_align16_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 4080(0)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align16_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 4083(0)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align32_int8_t_uint32_t() {
; CHECK-LE-LABEL: ld_cst_align32_int8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lis r3, 153
; CHECK-LE-NEXT:    lbz r3, -27108(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align32_int8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lis r3, 153
; CHECK-BE-NEXT:    lbz r3, -27105(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align64_int8_t_uint32_t() {
; CHECK-P10-LE-LABEL: ld_cst_align64_int8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 244140625
; CHECK-P10-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_align64_int8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587331
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_align64_int8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r3, 3725
; CHECK-P9-LE-NEXT:    ori r3, r3, 19025
; CHECK-P9-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_align64_int8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4099
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align64_int8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 3725
; CHECK-P8-LE-NEXT:    ori r3, r3, 19025
; CHECK-P8-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align64_int8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4099
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_0_int8_t_uint64_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_0_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_0_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align16_int8_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-LE-LABEL: ld_align16_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 8(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_align16_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 15(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align32_int8_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align32_int8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align32_int8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    plbz r3, 99999007(r3), 0
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align32_int8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 1525
; CHECK-P9-LE-NEXT:    ori r4, r4, 56600
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align32_int8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, 1525
; CHECK-P9-BE-NEXT:    ori r4, r4, 56607
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align32_int8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1525
; CHECK-P8-LE-NEXT:    ori r4, r4, 56600
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align32_int8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1525
; CHECK-P8-BE-NEXT:    ori r4, r4, 56607
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align64_int8_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align64_int8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align64_int8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587335
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align64_int8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align64_int8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4103
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align64_int8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align64_int8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4103
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_reg_int8_t_uint64_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LE-LABEL: ld_reg_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbzx r3, r3, r4
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_reg_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    add r3, r3, r4
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_or_int8_t_uint64_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LE-LABEL: ld_or_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    or r3, r4, r3
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_or_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    or r3, r4, r3
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv1 = trunc i64 %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint16_int8_t_uint64_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint16_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 6
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint16_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 6
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align16_int8_t_uint64_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_disjoint_align16_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-LE-NEXT:    lbz r3, 24(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_disjoint_align16_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-BE-NEXT:    lbz r3, 31(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint32_int8_t_uint64_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint32_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 34463
; CHECK-LE-NEXT:    oris r3, r3, 1
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint32_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 34463
; CHECK-BE-NEXT:    oris r3, r3, 1
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align32_int8_t_uint64_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align32_int8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    lis r4, -15264
; CHECK-P10-LE-NEXT:    and r3, r3, r4
; CHECK-P10-LE-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align32_int8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    lis r4, -15264
; CHECK-P10-BE-NEXT:    and r3, r3, r4
; CHECK-P10-BE-NEXT:    plbz r3, 999990007(r3), 0
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align32_int8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, -15264
; CHECK-P9-LE-NEXT:    and r3, r3, r4
; CHECK-P9-LE-NEXT:    lis r4, 15258
; CHECK-P9-LE-NEXT:    ori r4, r4, 41712
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align32_int8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, -15264
; CHECK-P9-BE-NEXT:    and r3, r3, r4
; CHECK-P9-BE-NEXT:    lis r4, 15258
; CHECK-P9-BE-NEXT:    ori r4, r4, 41719
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align32_int8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, -15264
; CHECK-P8-LE-NEXT:    lis r5, 15258
; CHECK-P8-LE-NEXT:    and r3, r3, r4
; CHECK-P8-LE-NEXT:    ori r4, r5, 41712
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align32_int8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, -15264
; CHECK-P8-BE-NEXT:    lis r5, 15258
; CHECK-P8-BE-NEXT:    and r3, r3, r4
; CHECK-P8-BE-NEXT:    ori r4, r5, 41719
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 16
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint64_int8_t_uint64_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_not_disjoint64_int8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    or r3, r3, r5
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_not_disjoint64_int8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    or r3, r3, r5
; CHECK-P10-BE-NEXT:    lbz r3, 7(r3)
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_not_disjoint64_int8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    or r3, r3, r4
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_not_disjoint64_int8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    or r3, r3, r4
; CHECK-P9-BE-NEXT:    lbz r3, 7(r3)
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint64_int8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    or r3, r3, r4
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint64_int8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    or r3, r3, r4
; CHECK-P8-BE-NEXT:    lbz r3, 7(r3)
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align64_int8_t_uint64_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align64_int8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align64_int8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587335
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align64_int8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align64_int8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4103
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align64_int8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align64_int8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4103
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 4096
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align16_int8_t_uint64_t() {
; CHECK-LE-LABEL: ld_cst_align16_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 4080(0)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align16_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 4087(0)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align32_int8_t_uint64_t() {
; CHECK-LE-LABEL: ld_cst_align32_int8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lis r3, 153
; CHECK-LE-NEXT:    lbz r3, -27108(r3)
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align32_int8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lis r3, 153
; CHECK-BE-NEXT:    lbz r3, -27101(r3)
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 9999900 to ptr), align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align64_int8_t_uint64_t() {
; CHECK-P10-LE-LABEL: ld_cst_align64_int8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 244140625
; CHECK-P10-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    extsb r3, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_align64_int8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587335
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    extsb r3, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_align64_int8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r3, 3725
; CHECK-P9-LE-NEXT:    ori r3, r3, 19025
; CHECK-P9-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    extsb r3, r3
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_align64_int8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4103
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    extsb r3, r3
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align64_int8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 3725
; CHECK-P8-LE-NEXT:    ori r3, r3, 19025
; CHECK-P8-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    extsb r3, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align64_int8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4103
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    extsb r3, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_0_int8_t_float(i64 %ptr) {
; CHECK-LABEL: ld_0_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptosi float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align16_int8_t_float(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f0, 8(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptosi float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align32_int8_t_float(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plfs f0, 99999000(r3), 0
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfsx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptosi float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align64_int8_t_float(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfsx f0, r3, r4
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfsx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptosi float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_reg_int8_t_float(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfsx f0, r3, r4
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptosi float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_or_int8_t_float(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfs f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv1 = fptosi float %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint16_int8_t_float(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfs f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptosi float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align16_int8_t_float(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfs f0, 24(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 8
  %conv = fptosi float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint32_int8_t_float(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfs f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptosi float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align32_int8_t_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plfs f0, 999990000(r3), 0
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_int8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfsx f0, r3, r4
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mffprwz r3, f0
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_int8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfsx f0, r3, r4
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    extsw r3, r3
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 16
  %conv = fptosi float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint64_int8_t_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfs f0, 0(r3)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfs f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptosi float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align64_int8_t_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfsx f0, r3, r4
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfsx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4096
  %conv = fptosi float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align16_int8_t_float() {
; CHECK-LABEL: ld_cst_align16_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f0, 4080(0)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = fptosi float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align32_int8_t_float() {
; CHECK-LABEL: ld_cst_align32_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfs f0, -27108(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = fptosi float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align64_int8_t_float() {
; CHECK-P10-LABEL: ld_cst_align64_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfs f0, 0(r3)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfs f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = fptosi float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_0_int8_t_double(i64 %ptr) {
; CHECK-LABEL: ld_0_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptosi double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align16_int8_t_double(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 8(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptosi double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align32_int8_t_double(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plfd f0, 99999000(r3), 0
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_int8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptosi double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_align64_int8_t_double(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_int8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptosi double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_reg_int8_t_double(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfdx f0, r3, r4
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptosi double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_or_int8_t_double(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv1 = fptosi double %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint16_int8_t_double(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptosi double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align16_int8_t_double(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfd f0, 24(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptosi double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint32_int8_t_double(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptosi double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align32_int8_t_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plfd f0, 999990000(r3), 0
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_int8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfdx f0, r3, r4
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mffprwz r3, f0
; CHECK-P9-NEXT:    extsw r3, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_int8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfdx f0, r3, r4
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    extsw r3, r3
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 16
  %conv = fptosi double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_not_disjoint64_int8_t_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_int8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptosi double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_disjoint_align64_int8_t_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_int8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 4096
  %conv = fptosi double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align16_int8_t_double() {
; CHECK-LABEL: ld_cst_align16_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 4080(0)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = fptosi double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align32_int8_t_double() {
; CHECK-LABEL: ld_cst_align32_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfd f0, -27108(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 9999900 to ptr), align 8
  %conv = fptosi double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local signext i8 @ld_cst_align64_int8_t_double() {
; CHECK-P10-LABEL: ld_cst_align64_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    extsw r3, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_int8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    extsw r3, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = fptosi double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_0_uint8_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_0_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align16_uint8_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align32_uint8_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_unalign64_uint8_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lbzx r3, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_unalign64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000001
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align64_uint8_t_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_reg_uint8_t_uint8_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbzx r3, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i8, ptr %add.ptr, align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_or_uint8_t_uint8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint16_uint8_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align16_uint8_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lbz r3, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 8
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint32_uint8_t_uint8_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lbz r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align32_uint8_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_uint8_t_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lbzx r3, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_uint8_t_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 16
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint64_uint8_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_unalign64_uint8_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lbzx r3, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_unalign64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align64_uint8_t_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lbzx r3, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lbzx r3, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 4096
  ret i8 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align16_uint8_t_uint8_t() {
; CHECK-LABEL: ld_cst_align16_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lbz r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 4080 to ptr), align 16
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align32_uint8_t_uint8_t() {
; CHECK-LABEL: ld_cst_align32_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lbz r3, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 9999900 to ptr), align 4
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_unalign64_uint8_t_uint8_t() {
; CHECK-P10-LABEL: ld_cst_unalign64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 232
; CHECK-P10-NEXT:    pli r4, 3567587329
; CHECK-P10-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-NEXT:    lbz r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_unalign64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r3, 29
; CHECK-PREP10-NEXT:    rldic r3, r3, 35, 24
; CHECK-PREP10-NEXT:    oris r3, r3, 54437
; CHECK-PREP10-NEXT:    ori r3, r3, 4097
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 1000000000001 to ptr), align 1
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align64_uint8_t_uint8_t() {
; CHECK-P10-LABEL: ld_cst_align64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lbz r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lbz r3, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret i8 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_0_uint8_t_uint16_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_0_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_0_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align16_uint8_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-LE-LABEL: ld_align16_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 8(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_align16_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 9(r3)
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align32_uint8_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align32_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align32_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    plbz r3, 99999001(r3), 0
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align32_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 1525
; CHECK-P9-LE-NEXT:    ori r4, r4, 56600
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align32_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, 1525
; CHECK-P9-BE-NEXT:    ori r4, r4, 56601
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align32_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1525
; CHECK-P8-LE-NEXT:    ori r4, r4, 56600
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align32_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1525
; CHECK-P8-BE-NEXT:    ori r4, r4, 56601
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_unalign64_uint8_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_unalign64_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_unalign64_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587330
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_unalign64_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_unalign64_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4098
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_unalign64_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_unalign64_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4098
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000001
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align64_uint8_t_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align64_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align64_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align64_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align64_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align64_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align64_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_reg_uint8_t_uint16_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LE-LABEL: ld_reg_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbzx r3, r3, r4
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_reg_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    add r3, r3, r4
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i16, ptr %add.ptr, align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_or_uint8_t_uint16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LE-LABEL: ld_or_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    or r3, r4, r3
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_or_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    or r3, r4, r3
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv1 = trunc i16 %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint16_uint8_t_uint16_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint16_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 6
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint16_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 6
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align16_uint8_t_uint16_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_disjoint_align16_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-LE-NEXT:    lbz r3, 24(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_disjoint_align16_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-BE-NEXT:    lbz r3, 25(r3)
; CHECK-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 8
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint32_uint8_t_uint16_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint32_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 34463
; CHECK-LE-NEXT:    oris r3, r3, 1
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint32_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 34463
; CHECK-BE-NEXT:    oris r3, r3, 1
; CHECK-BE-NEXT:    lbz r3, 1(r3)
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align32_uint8_t_uint16_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align32_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    lis r4, -15264
; CHECK-P10-LE-NEXT:    and r3, r3, r4
; CHECK-P10-LE-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align32_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    lis r4, -15264
; CHECK-P10-BE-NEXT:    and r3, r3, r4
; CHECK-P10-BE-NEXT:    plbz r3, 999990001(r3), 0
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align32_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, -15264
; CHECK-P9-LE-NEXT:    and r3, r3, r4
; CHECK-P9-LE-NEXT:    lis r4, 15258
; CHECK-P9-LE-NEXT:    ori r4, r4, 41712
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align32_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, -15264
; CHECK-P9-BE-NEXT:    and r3, r3, r4
; CHECK-P9-BE-NEXT:    lis r4, 15258
; CHECK-P9-BE-NEXT:    ori r4, r4, 41713
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align32_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, -15264
; CHECK-P8-LE-NEXT:    lis r5, 15258
; CHECK-P8-LE-NEXT:    and r3, r3, r4
; CHECK-P8-LE-NEXT:    ori r4, r5, 41712
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align32_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, -15264
; CHECK-P8-BE-NEXT:    lis r5, 15258
; CHECK-P8-BE-NEXT:    and r3, r3, r4
; CHECK-P8-BE-NEXT:    ori r4, r5, 41713
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 16
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint64_uint8_t_uint16_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_not_disjoint64_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    or r3, r3, r5
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_not_disjoint64_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    or r3, r3, r5
; CHECK-P10-BE-NEXT:    lbz r3, 1(r3)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_not_disjoint64_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    or r3, r3, r4
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_not_disjoint64_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    or r3, r3, r4
; CHECK-P9-BE-NEXT:    lbz r3, 1(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint64_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    or r3, r3, r4
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint64_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    or r3, r3, r4
; CHECK-P8-BE-NEXT:    lbz r3, 1(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_unalign64_uint8_t_uint16_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587330
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4098
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4098
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align64_uint8_t_uint16_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align64_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align64_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align64_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align64_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align64_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align64_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 4096
  %conv = trunc i16 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align16_uint8_t_uint16_t() {
; CHECK-LE-LABEL: ld_cst_align16_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 4080(0)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align16_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 4081(0)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align32_uint8_t_uint16_t() {
; CHECK-LE-LABEL: ld_cst_align32_uint8_t_uint16_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lis r3, 153
; CHECK-LE-NEXT:    lbz r3, -27108(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align32_uint8_t_uint16_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lis r3, 153
; CHECK-BE-NEXT:    lbz r3, -27107(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_unalign64_uint8_t_uint16_t() {
; CHECK-P10-LE-LABEL: ld_cst_unalign64_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 232
; CHECK-P10-LE-NEXT:    pli r4, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-LE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_unalign64_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587330
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_unalign64_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r3, 29
; CHECK-P9-LE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-LE-NEXT:    oris r3, r3, 54437
; CHECK-P9-LE-NEXT:    ori r3, r3, 4097
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_unalign64_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4098
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_unalign64_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 29
; CHECK-P8-LE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-LE-NEXT:    oris r3, r3, 54437
; CHECK-P8-LE-NEXT:    ori r3, r3, 4097
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_unalign64_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4098
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 1000000000001 to ptr), align 2
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align64_uint8_t_uint16_t() {
; CHECK-P10-LE-LABEL: ld_cst_align64_uint8_t_uint16_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 244140625
; CHECK-P10-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_align64_uint8_t_uint16_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_align64_uint8_t_uint16_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r3, 3725
; CHECK-P9-LE-NEXT:    ori r3, r3, 19025
; CHECK-P9-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_align64_uint8_t_uint16_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4097
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align64_uint8_t_uint16_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 3725
; CHECK-P8-LE-NEXT:    ori r3, r3, 19025
; CHECK-P8-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align64_uint8_t_uint16_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4097
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = trunc i16 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_0_uint8_t_uint32_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_0_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_0_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align16_uint8_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-LE-LABEL: ld_align16_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 8(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_align16_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 11(r3)
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align32_uint8_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align32_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align32_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    plbz r3, 99999003(r3), 0
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align32_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 1525
; CHECK-P9-LE-NEXT:    ori r4, r4, 56600
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align32_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, 1525
; CHECK-P9-BE-NEXT:    ori r4, r4, 56603
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align32_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1525
; CHECK-P8-LE-NEXT:    ori r4, r4, 56600
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align32_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1525
; CHECK-P8-BE-NEXT:    ori r4, r4, 56603
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_unalign64_uint8_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_unalign64_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_unalign64_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587332
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_unalign64_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_unalign64_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4100
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_unalign64_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_unalign64_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4100
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000001
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align64_uint8_t_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align64_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align64_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587331
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align64_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align64_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4099
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align64_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align64_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4099
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_reg_uint8_t_uint32_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LE-LABEL: ld_reg_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbzx r3, r3, r4
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_reg_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    add r3, r3, r4
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i32, ptr %add.ptr, align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_or_uint8_t_uint32_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LE-LABEL: ld_or_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    or r3, r4, r3
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_or_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    or r3, r4, r3
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv1 = trunc i32 %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint16_uint8_t_uint32_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint16_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 6
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint16_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 6
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align16_uint8_t_uint32_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_disjoint_align16_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-LE-NEXT:    lbz r3, 24(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_disjoint_align16_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-BE-NEXT:    lbz r3, 27(r3)
; CHECK-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 8
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint32_uint8_t_uint32_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint32_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 34463
; CHECK-LE-NEXT:    oris r3, r3, 1
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint32_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 34463
; CHECK-BE-NEXT:    oris r3, r3, 1
; CHECK-BE-NEXT:    lbz r3, 3(r3)
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align32_uint8_t_uint32_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align32_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    lis r4, -15264
; CHECK-P10-LE-NEXT:    and r3, r3, r4
; CHECK-P10-LE-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align32_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    lis r4, -15264
; CHECK-P10-BE-NEXT:    and r3, r3, r4
; CHECK-P10-BE-NEXT:    plbz r3, 999990003(r3), 0
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align32_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, -15264
; CHECK-P9-LE-NEXT:    and r3, r3, r4
; CHECK-P9-LE-NEXT:    lis r4, 15258
; CHECK-P9-LE-NEXT:    ori r4, r4, 41712
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align32_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, -15264
; CHECK-P9-BE-NEXT:    and r3, r3, r4
; CHECK-P9-BE-NEXT:    lis r4, 15258
; CHECK-P9-BE-NEXT:    ori r4, r4, 41715
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align32_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, -15264
; CHECK-P8-LE-NEXT:    lis r5, 15258
; CHECK-P8-LE-NEXT:    and r3, r3, r4
; CHECK-P8-LE-NEXT:    ori r4, r5, 41712
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align32_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, -15264
; CHECK-P8-BE-NEXT:    lis r5, 15258
; CHECK-P8-BE-NEXT:    and r3, r3, r4
; CHECK-P8-BE-NEXT:    ori r4, r5, 41715
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 16
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint64_uint8_t_uint32_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_not_disjoint64_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    or r3, r3, r5
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_not_disjoint64_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    or r3, r3, r5
; CHECK-P10-BE-NEXT:    lbz r3, 3(r3)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_not_disjoint64_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    or r3, r3, r4
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_not_disjoint64_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    or r3, r3, r4
; CHECK-P9-BE-NEXT:    lbz r3, 3(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint64_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    or r3, r3, r4
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint64_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    or r3, r3, r4
; CHECK-P8-BE-NEXT:    lbz r3, 3(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_unalign64_uint8_t_uint32_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587332
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4100
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4100
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align64_uint8_t_uint32_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align64_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align64_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587331
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align64_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align64_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4099
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align64_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align64_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4099
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4096
  %conv = trunc i32 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align16_uint8_t_uint32_t() {
; CHECK-LE-LABEL: ld_cst_align16_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 4080(0)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align16_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 4083(0)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align32_uint8_t_uint32_t() {
; CHECK-LE-LABEL: ld_cst_align32_uint8_t_uint32_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lis r3, 153
; CHECK-LE-NEXT:    lbz r3, -27108(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align32_uint8_t_uint32_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lis r3, 153
; CHECK-BE-NEXT:    lbz r3, -27105(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_unalign64_uint8_t_uint32_t() {
; CHECK-P10-LE-LABEL: ld_cst_unalign64_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 232
; CHECK-P10-LE-NEXT:    pli r4, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-LE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_unalign64_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587332
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_unalign64_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r3, 29
; CHECK-P9-LE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-LE-NEXT:    oris r3, r3, 54437
; CHECK-P9-LE-NEXT:    ori r3, r3, 4097
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_unalign64_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4100
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_unalign64_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 29
; CHECK-P8-LE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-LE-NEXT:    oris r3, r3, 54437
; CHECK-P8-LE-NEXT:    ori r3, r3, 4097
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_unalign64_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4100
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 1000000000001 to ptr), align 4
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align64_uint8_t_uint32_t() {
; CHECK-P10-LE-LABEL: ld_cst_align64_uint8_t_uint32_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 244140625
; CHECK-P10-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_align64_uint8_t_uint32_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587331
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_align64_uint8_t_uint32_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r3, 3725
; CHECK-P9-LE-NEXT:    ori r3, r3, 19025
; CHECK-P9-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_align64_uint8_t_uint32_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4099
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align64_uint8_t_uint32_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 3725
; CHECK-P8-LE-NEXT:    ori r3, r3, 19025
; CHECK-P8-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align64_uint8_t_uint32_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4099
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = trunc i32 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_0_uint8_t_uint64_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_0_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_0_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align16_uint8_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-LE-LABEL: ld_align16_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 8(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_align16_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 15(r3)
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align32_uint8_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align32_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, 99999000(r3), 0
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align32_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    plbz r3, 99999007(r3), 0
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align32_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 1525
; CHECK-P9-LE-NEXT:    ori r4, r4, 56600
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align32_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, 1525
; CHECK-P9-BE-NEXT:    ori r4, r4, 56607
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align32_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1525
; CHECK-P8-LE-NEXT:    ori r4, r4, 56600
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align32_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1525
; CHECK-P8-BE-NEXT:    ori r4, r4, 56607
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_unalign64_uint8_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_unalign64_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_unalign64_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587336
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_unalign64_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_unalign64_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4104
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_unalign64_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_unalign64_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4104
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000001
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align64_uint8_t_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LE-LABEL: ld_align64_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_align64_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587335
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_align64_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_align64_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4103
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align64_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align64_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4103
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_reg_uint8_t_uint64_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LE-LABEL: ld_reg_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbzx r3, r3, r4
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_reg_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    add r3, r3, r4
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i64, ptr %add.ptr, align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_or_uint8_t_uint64_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LE-LABEL: ld_or_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    or r3, r4, r3
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_or_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    or r3, r4, r3
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv1 = trunc i64 %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint16_uint8_t_uint64_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint16_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 6
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint16_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 6
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align16_uint8_t_uint64_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_disjoint_align16_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-LE-NEXT:    lbz r3, 24(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_disjoint_align16_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-BE-NEXT:    lbz r3, 31(r3)
; CHECK-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint32_uint8_t_uint64_t(i64 %ptr) {
; CHECK-LE-LABEL: ld_not_disjoint32_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    ori r3, r3, 34463
; CHECK-LE-NEXT:    oris r3, r3, 1
; CHECK-LE-NEXT:    lbz r3, 0(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_not_disjoint32_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    ori r3, r3, 34463
; CHECK-BE-NEXT:    oris r3, r3, 1
; CHECK-BE-NEXT:    lbz r3, 7(r3)
; CHECK-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align32_uint8_t_uint64_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align32_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    lis r4, -15264
; CHECK-P10-LE-NEXT:    and r3, r3, r4
; CHECK-P10-LE-NEXT:    plbz r3, 999990000(r3), 0
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align32_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    lis r4, -15264
; CHECK-P10-BE-NEXT:    and r3, r3, r4
; CHECK-P10-BE-NEXT:    plbz r3, 999990007(r3), 0
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align32_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, -15264
; CHECK-P9-LE-NEXT:    and r3, r3, r4
; CHECK-P9-LE-NEXT:    lis r4, 15258
; CHECK-P9-LE-NEXT:    ori r4, r4, 41712
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align32_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    lis r4, -15264
; CHECK-P9-BE-NEXT:    and r3, r3, r4
; CHECK-P9-BE-NEXT:    lis r4, 15258
; CHECK-P9-BE-NEXT:    ori r4, r4, 41719
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align32_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, -15264
; CHECK-P8-LE-NEXT:    lis r5, 15258
; CHECK-P8-LE-NEXT:    and r3, r3, r4
; CHECK-P8-LE-NEXT:    ori r4, r5, 41712
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align32_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, -15264
; CHECK-P8-BE-NEXT:    lis r5, 15258
; CHECK-P8-BE-NEXT:    and r3, r3, r4
; CHECK-P8-BE-NEXT:    ori r4, r5, 41719
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 16
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint64_uint8_t_uint64_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_not_disjoint64_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    or r3, r3, r5
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_not_disjoint64_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587329
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    or r3, r3, r5
; CHECK-P10-BE-NEXT:    lbz r3, 7(r3)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_not_disjoint64_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    or r3, r3, r4
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_not_disjoint64_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4097
; CHECK-P9-BE-NEXT:    or r3, r3, r4
; CHECK-P9-BE-NEXT:    lbz r3, 7(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint64_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    or r3, r3, r4
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint64_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    or r3, r3, r4
; CHECK-P8-BE-NEXT:    lbz r3, 7(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_unalign64_uint8_t_uint64_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 232
; CHECK-P10-LE-NEXT:    pli r5, 3567587329
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587336
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r4, 29
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-LE-NEXT:    oris r4, r4, 54437
; CHECK-P9-LE-NEXT:    ori r4, r4, 4097
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4104
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_unalign64_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_unalign64_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4104
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align64_uint8_t_uint64_t(i64 %ptr) {
; CHECK-P10-LE-LABEL: ld_disjoint_align64_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r4, 244140625
; CHECK-P10-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_disjoint_align64_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r4, 232
; CHECK-P10-BE-NEXT:    pli r5, 3567587335
; CHECK-P10-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-BE-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-BE-NEXT:    lbzx r3, r3, r5
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_disjoint_align64_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r4, 3725
; CHECK-P9-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-LE-NEXT:    ori r4, r4, 19025
; CHECK-P9-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_disjoint_align64_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r4, 29
; CHECK-P9-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-BE-NEXT:    oris r4, r4, 54437
; CHECK-P9-BE-NEXT:    ori r4, r4, 4103
; CHECK-P9-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align64_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align64_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4103
; CHECK-P8-BE-NEXT:    lbzx r3, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 4096
  %conv = trunc i64 %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align16_uint8_t_uint64_t() {
; CHECK-LE-LABEL: ld_cst_align16_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lbz r3, 4080(0)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align16_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lbz r3, 4087(0)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align32_uint8_t_uint64_t() {
; CHECK-LE-LABEL: ld_cst_align32_uint8_t_uint64_t:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    lis r3, 153
; CHECK-LE-NEXT:    lbz r3, -27108(r3)
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: ld_cst_align32_uint8_t_uint64_t:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lis r3, 153
; CHECK-BE-NEXT:    lbz r3, -27101(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 9999900 to ptr), align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_unalign64_uint8_t_uint64_t() {
; CHECK-P10-LE-LABEL: ld_cst_unalign64_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 232
; CHECK-P10-LE-NEXT:    pli r4, 3567587329
; CHECK-P10-LE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-LE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_unalign64_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587336
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_unalign64_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    li r3, 29
; CHECK-P9-LE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-LE-NEXT:    oris r3, r3, 54437
; CHECK-P9-LE-NEXT:    ori r3, r3, 4097
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_unalign64_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4104
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_unalign64_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 29
; CHECK-P8-LE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-LE-NEXT:    oris r3, r3, 54437
; CHECK-P8-LE-NEXT:    ori r3, r3, 4097
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_unalign64_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4104
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 1000000000001 to ptr), align 8
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align64_uint8_t_uint64_t() {
; CHECK-P10-LE-LABEL: ld_cst_align64_uint8_t_uint64_t:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pli r3, 244140625
; CHECK-P10-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: ld_cst_align64_uint8_t_uint64_t:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    pli r3, 232
; CHECK-P10-BE-NEXT:    pli r4, 3567587335
; CHECK-P10-BE-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-BE-NEXT:    lbz r3, 0(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LE-LABEL: ld_cst_align64_uint8_t_uint64_t:
; CHECK-P9-LE:       # %bb.0: # %entry
; CHECK-P9-LE-NEXT:    lis r3, 3725
; CHECK-P9-LE-NEXT:    ori r3, r3, 19025
; CHECK-P9-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-LE-NEXT:    blr
;
; CHECK-P9-BE-LABEL: ld_cst_align64_uint8_t_uint64_t:
; CHECK-P9-BE:       # %bb.0: # %entry
; CHECK-P9-BE-NEXT:    li r3, 29
; CHECK-P9-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-BE-NEXT:    oris r3, r3, 54437
; CHECK-P9-BE-NEXT:    ori r3, r3, 4103
; CHECK-P9-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P9-BE-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align64_uint8_t_uint64_t:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 3725
; CHECK-P8-LE-NEXT:    ori r3, r3, 19025
; CHECK-P8-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-LE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align64_uint8_t_uint64_t:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4103
; CHECK-P8-BE-NEXT:    lbz r3, 0(r3)
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = trunc i64 %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_0_uint8_t_float(i64 %ptr) {
; CHECK-LABEL: ld_0_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptoui float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align16_uint8_t_float(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f0, 8(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align32_uint8_t_float(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plfs f0, 99999000(r3), 0
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfsx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_unalign64_uint8_t_float(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lfsx f0, r3, r5
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_unalign64_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    lfsx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000001
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align64_uint8_t_float(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfsx f0, r3, r4
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfsx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_reg_uint8_t_float(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfsx f0, r3, r4
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load float, ptr %add.ptr, align 4
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_or_uint8_t_float(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfs f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv1 = fptoui float %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint16_uint8_t_float(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfs f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptoui float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align16_uint8_t_float(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfs f0, 24(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 8
  %conv = fptoui float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint32_uint8_t_float(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfs f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptoui float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align32_uint8_t_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plfs f0, 999990000(r3), 0
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_uint8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfsx f0, r3, r4
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mffprwz r3, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_uint8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfsx f0, r3, r4
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 16
  %conv = fptoui float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint64_uint8_t_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfs f0, 0(r3)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfs f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptoui float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_unalign64_uint8_t_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lfsx f0, r3, r5
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_unalign64_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    lfsx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  %conv = fptoui float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align64_uint8_t_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfsx f0, r3, r4
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfsx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4096
  %conv = fptoui float %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align16_uint8_t_float() {
; CHECK-LABEL: ld_cst_align16_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f0, 4080(0)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align32_uint8_t_float() {
; CHECK-LABEL: ld_cst_align32_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfs f0, -27108(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_unalign64_uint8_t_float() {
; CHECK-P10-LABEL: ld_cst_unalign64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 232
; CHECK-P10-NEXT:    pli r4, 3567587329
; CHECK-P10-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-NEXT:    lfs f0, 0(r4)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_unalign64_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r3, 29
; CHECK-PREP10-NEXT:    rldic r3, r3, 35, 24
; CHECK-PREP10-NEXT:    oris r3, r3, 54437
; CHECK-PREP10-NEXT:    ori r3, r3, 4097
; CHECK-PREP10-NEXT:    lfs f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 1000000000001 to ptr), align 4
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align64_uint8_t_float() {
; CHECK-P10-LABEL: ld_cst_align64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfs f0, 0(r3)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfs f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = fptoui float %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_0_uint8_t_double(i64 %ptr) {
; CHECK-LABEL: ld_0_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptoui double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align16_uint8_t_double(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 8(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align32_uint8_t_double(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plfd f0, 99999000(r3), 0
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_unalign64_uint8_t_double(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lfdx f0, r3, r5
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_unalign64_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000001
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_align64_uint8_t_double(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_reg_uint8_t_double(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfdx f0, r3, r4
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_or_uint8_t_double(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv1 = fptoui double %1 to i8
  ret i8 %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint16_uint8_t_double(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptoui double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align16_uint8_t_double(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfd f0, 24(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptoui double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint32_uint8_t_double(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptoui double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align32_uint8_t_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plfd f0, 999990000(r3), 0
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_uint8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfdx f0, r3, r4
; CHECK-P9-NEXT:    xscvdpsxws f0, f0
; CHECK-P9-NEXT:    mffprwz r3, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_uint8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfdx f0, r3, r4
; CHECK-P8-NEXT:    xscvdpsxws f0, f0
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 16
  %conv = fptoui double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_not_disjoint64_uint8_t_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptoui double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_unalign64_uint8_t_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lfdx f0, r3, r5
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_unalign64_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptoui double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_disjoint_align64_uint8_t_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 4096
  %conv = fptoui double %1 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align16_uint8_t_double() {
; CHECK-LABEL: ld_cst_align16_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 4080(0)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align32_uint8_t_double() {
; CHECK-LABEL: ld_cst_align32_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfd f0, -27108(r3)
; CHECK-NEXT:    xscvdpsxws f0, f0
; CHECK-NEXT:    mffprwz r3, f0
; CHECK-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 9999900 to ptr), align 8
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_unalign64_uint8_t_double() {
; CHECK-P10-LABEL: ld_cst_unalign64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 232
; CHECK-P10-NEXT:    pli r4, 3567587329
; CHECK-P10-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-NEXT:    lfd f0, 0(r4)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_unalign64_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r3, 29
; CHECK-PREP10-NEXT:    rldic r3, r3, 35, 24
; CHECK-PREP10-NEXT:    oris r3, r3, 54437
; CHECK-PREP10-NEXT:    ori r3, r3, 4097
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 1000000000001 to ptr), align 8
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local zeroext i8 @ld_cst_align64_uint8_t_double() {
; CHECK-P10-LABEL: ld_cst_align64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvdpsxws f0, f0
; CHECK-P10-NEXT:    mffprwz r3, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f0
; CHECK-PREP10-NEXT:    mffprwz r3, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = fptoui double %0 to i8
  ret i8 %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_uint8_t_uint8_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_0_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stb r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  store i8 %str, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_uint8_t_uint8_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_align16_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stb r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i8 %str, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_uint8_t_uint8_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstb r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stbx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i8 %str, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_uint8_t_uint8_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stbx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stbx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i8 %str, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_uint8_t_uint8_t(ptr nocapture %ptr, i64 %off, i8 zeroext %str) {
; CHECK-LABEL: st_reg_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stbx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i8 %str, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_uint8_t_uint8_t(i64 %ptr, i8 zeroext %off, i8 zeroext %str) {
; CHECK-LABEL: st_or1_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stb r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  store i8 %str, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_uint8_t_uint8_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stb r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i8 %str, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_uint8_t_uint8_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stb r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i8 %str, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_uint8_t_uint8_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint32_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stb r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i8 %str, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_uint8_t_uint8_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstb r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_uint8_t_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    lis r5, 15258
; CHECK-P9-NEXT:    ori r5, r5, 41712
; CHECK-P9-NEXT:    stbx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_uint8_t_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r5, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r5
; CHECK-P8-NEXT:    ori r5, r6, 41712
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i8 %str, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_uint8_t_uint8_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    stb r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    stb r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i8 %str, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_uint8_t_uint8_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stbx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stbx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i8 %str, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_uint8_t_uint8_t(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stb r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  store i8 %str, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_uint8_t_uint8_t(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint8_t_uint8_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    stb r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  store i8 %str, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_uint8_t_uint8_t(i8 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint8_t_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stb r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_uint8_t_uint8_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stb r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  store i8 %str, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_uint8_t_uint16_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_0_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %0 = inttoptr i64 %ptr to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_uint8_t_uint16_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_align16_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_uint8_t_uint16_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    psth r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_uint8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_uint8_t_uint16_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    sthx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_uint8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_uint8_t_uint16_t(ptr nocapture %ptr, i64 %off, i8 zeroext %str) {
; CHECK-LABEL: st_reg_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sthx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_uint8_t_uint16_t(i64 %ptr, i8 zeroext %off, i8 zeroext %str) {
; CHECK-LABEL: st_or1_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    sth r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_uint8_t_uint16_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_uint8_t_uint16_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    sth r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %str to i16
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_uint8_t_uint16_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint32_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_uint8_t_uint16_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    psth r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_uint8_t_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    lis r5, 15258
; CHECK-P9-NEXT:    ori r5, r5, 41712
; CHECK-P9-NEXT:    sthx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_uint8_t_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r5, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r5
; CHECK-P8-NEXT:    ori r5, r6, 41712
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = zext i8 %str to i16
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_uint8_t_uint16_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    sth r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    sth r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_uint8_t_uint16_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    sthx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_uint8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = zext i8 %str to i16
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_uint8_t_uint16_t(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  store i16 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_uint8_t_uint16_t(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    sth r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  store i16 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_uint8_t_uint16_t(i8 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    sth r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_uint8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    sth r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i16
  store i16 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_uint8_t_uint32_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_0_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %0 = inttoptr i64 %ptr to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_uint8_t_uint32_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_align16_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_uint8_t_uint32_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstw r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_uint8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_uint8_t_uint32_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stwx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_uint8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_uint8_t_uint32_t(ptr nocapture %ptr, i64 %off, i8 zeroext %str) {
; CHECK-LABEL: st_reg_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stwx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_uint8_t_uint32_t(i64 %ptr, i8 zeroext %off, i8 zeroext %str) {
; CHECK-LABEL: st_or1_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stw r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_uint8_t_uint32_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_uint8_t_uint32_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stw r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %str to i32
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_uint8_t_uint32_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint32_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_uint8_t_uint32_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstw r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_uint8_t_uint32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    lis r5, 15258
; CHECK-P9-NEXT:    ori r5, r5, 41712
; CHECK-P9-NEXT:    stwx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_uint8_t_uint32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r5, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r5
; CHECK-P8-NEXT:    ori r5, r6, 41712
; CHECK-P8-NEXT:    stwx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = zext i8 %str to i32
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_uint8_t_uint32_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    stw r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    stw r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_uint8_t_uint32_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stwx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_uint8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = zext i8 %str to i32
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_uint8_t_uint32_t(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  store i32 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_uint8_t_uint32_t(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    stw r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  store i32 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_uint8_t_uint32_t(i8 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stw r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_uint8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stw r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i32
  store i32 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_uint8_t_uint64_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_0_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %0 = inttoptr i64 %ptr to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_uint8_t_uint64_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_align16_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_uint8_t_uint64_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstd r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_uint8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_uint8_t_uint64_t(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_uint8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_uint8_t_uint64_t(ptr nocapture %ptr, i64 %off, i8 zeroext %str) {
; CHECK-LABEL: st_reg_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stdx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_uint8_t_uint64_t(i64 %ptr, i8 zeroext %off, i8 zeroext %str) {
; CHECK-LABEL: st_or1_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    std r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_uint8_t_uint64_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_uint8_t_uint64_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    std r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %str to i64
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_uint8_t_uint64_t(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint32_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_uint8_t_uint64_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstd r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_uint8_t_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    lis r5, 15258
; CHECK-P9-NEXT:    ori r5, r5, 41712
; CHECK-P9-NEXT:    stdx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_uint8_t_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r5, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r5
; CHECK-P8-NEXT:    ori r5, r6, 41712
; CHECK-P8-NEXT:    stdx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = zext i8 %str to i64
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_uint8_t_uint64_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    std r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    std r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_uint8_t_uint64_t(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_uint8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = zext i8 %str to i64
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_uint8_t_uint64_t(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  store i64 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_uint8_t_uint64_t(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    std r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  store i64 %conv, ptr inttoptr (i64 9999900 to ptr), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_uint8_t_uint64_t(i8 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    std r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_uint8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    std r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = zext i8 %str to i64
  store i64 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_uint8_t_float(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_0_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r4
; CHECK-NEXT:    xscvuxdsp f0, f0
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %0 = inttoptr i64 %ptr to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_uint8_t_float(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_align16_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r4
; CHECK-NEXT:    xscvuxdsp f0, f0
; CHECK-NEXT:    stfs f0, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store float %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_uint8_t_float(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    xscvuxdsp f0, f0
; CHECK-P10-NEXT:    pstfs f0, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_uint8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    xscvuxdsp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_uint8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    xscvuxdsp f0, f0
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store float %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_uint8_t_float(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    xscvuxdsp f0, f0
; CHECK-P10-NEXT:    stfsx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_uint8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    xscvuxdsp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_uint8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    xscvuxdsp f0, f0
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store float %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_uint8_t_float(ptr nocapture %ptr, i64 %off, i8 zeroext %str) {
; CHECK-LABEL: st_reg_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r5
; CHECK-NEXT:    xscvuxdsp f0, f0
; CHECK-NEXT:    stfsx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store float %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_uint8_t_float(i64 %ptr, i8 zeroext %off, i8 zeroext %str) {
; CHECK-LABEL: st_or1_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r5
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    xscvuxdsp f0, f0
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_uint8_t_float(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r4
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    xscvuxdsp f0, f0
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_uint8_t_float(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r4
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    xscvuxdsp f0, f0
; CHECK-NEXT:    stfs f0, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = uitofp i8 %str to float
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_uint8_t_float(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint32_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    ori r3, r3, 34463
; CHECK-P10-NEXT:    oris r3, r3, 1
; CHECK-P10-NEXT:    xscvuxdsp f0, f0
; CHECK-P10-NEXT:    stfs f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint32_uint8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    ori r3, r3, 34463
; CHECK-P9-NEXT:    xscvuxdsp f0, f0
; CHECK-P9-NEXT:    oris r3, r3, 1
; CHECK-P9-NEXT:    stfs f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_uint8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    xscvuxdsp f0, f0
; CHECK-P8-NEXT:    stfs f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_uint8_t_float(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    xscvuxdsp f0, f0
; CHECK-P10-NEXT:    pstfs f0, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_uint8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    xscvuxdsp f0, f0
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_uint8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    xscvuxdsp f0, f0
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = uitofp i8 %str to float
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_uint8_t_float(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    xscvuxdsp f0, f0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfs f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    mtfprwz f0, r4
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    xscvuxdsp f0, f0
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfs f0, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_uint8_t_float(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    xscvuxdsp f0, f0
; CHECK-P10-NEXT:    stfsx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_uint8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    xscvuxdsp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_uint8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r5, 19025
; CHECK-P8-NEXT:    xscvuxdsp f0, f0
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = uitofp i8 %str to float
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_uint8_t_float(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r3
; CHECK-NEXT:    xscvuxdsp f0, f0
; CHECK-NEXT:    stfs f0, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  store float %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_uint8_t_float(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r3
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    xscvuxdsp f0, f0
; CHECK-NEXT:    stfs f0, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  store float %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_uint8_t_float(i8 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r3
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    xscvuxdsp f0, f0
; CHECK-P10-NEXT:    stfs f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_uint8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r3
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    xscvuxdsp f0, f0
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stfs f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_uint8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    xscvuxdsp f0, f0
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    stfs f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = uitofp i8 %str to float
  store float %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_uint8_t_double(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_0_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r4
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %0 = inttoptr i64 %ptr to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_uint8_t_double(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_align16_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r4
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfd f0, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_uint8_t_double(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align32_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    xscvuxddp f0, f0
; CHECK-P10-NEXT:    pstfd f0, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_uint8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    xscvuxddp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stfdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_uint8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    xscvuxddp f0, f0
; CHECK-P8-NEXT:    stfdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_uint8_t_double(ptr nocapture %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_align64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    xscvuxddp f0, f0
; CHECK-P10-NEXT:    stfdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_uint8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    xscvuxddp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stfdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_uint8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    xscvuxddp f0, f0
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    stfdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_uint8_t_double(ptr nocapture %ptr, i64 %off, i8 zeroext %str) {
; CHECK-LABEL: st_reg_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r5
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfdx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_uint8_t_double(i64 %ptr, i8 zeroext %off, i8 zeroext %str) {
; CHECK-LABEL: st_or1_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r5
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_uint8_t_double(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_not_disjoint16_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r4
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_uint8_t_double(i64 %ptr, i8 zeroext %str) {
; CHECK-LABEL: st_disjoint_align16_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r4
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfd f0, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = uitofp i8 %str to double
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_uint8_t_double(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint32_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    ori r3, r3, 34463
; CHECK-P10-NEXT:    oris r3, r3, 1
; CHECK-P10-NEXT:    xscvuxddp f0, f0
; CHECK-P10-NEXT:    stfd f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint32_uint8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    ori r3, r3, 34463
; CHECK-P9-NEXT:    xscvuxddp f0, f0
; CHECK-P9-NEXT:    oris r3, r3, 1
; CHECK-P9-NEXT:    stfd f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_uint8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    xscvuxddp f0, f0
; CHECK-P8-NEXT:    stfd f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_uint8_t_double(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    xscvuxddp f0, f0
; CHECK-P10-NEXT:    pstfd f0, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_uint8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    xscvuxddp f0, f0
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_uint8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    xscvuxddp f0, f0
; CHECK-P8-NEXT:    stfdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = uitofp i8 %str to double
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_uint8_t_double(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    xscvuxddp f0, f0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfd f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_uint8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    mtfprwz f0, r4
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    xscvuxddp f0, f0
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfd f0, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_uint8_t_double(i64 %ptr, i8 zeroext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r4
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    xscvuxddp f0, f0
; CHECK-P10-NEXT:    stfdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_uint8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r4
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    xscvuxddp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stfdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_uint8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r5, 19025
; CHECK-P8-NEXT:    xscvuxddp f0, f0
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    stfdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = uitofp i8 %str to double
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_uint8_t_double(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align16_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r3
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfd f0, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  store double %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_uint8_t_double(i8 zeroext %str) {
; CHECK-LABEL: st_cst_align32_uint8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwz f0, r3
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfd f0, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  store double %conv, ptr inttoptr (i64 9999900 to ptr), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_uint8_t_double(i8 zeroext %str) {
; CHECK-P10-LABEL: st_cst_align64_uint8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwz f0, r3
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    xscvuxddp f0, f0
; CHECK-P10-NEXT:    stfd f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_uint8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwz f0, r3
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    xscvuxddp f0, f0
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stfd f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_uint8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    xscvuxddp f0, f0
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    stfd f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = uitofp i8 %str to double
  store double %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_int8_t_uint16_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_0_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %0 = inttoptr i64 %ptr to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_int8_t_uint16_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-LABEL: st_align16_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_int8_t_uint16_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align32_int8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    psth r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_int8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_int8_t_uint16_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align64_int8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    sthx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_int8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_int8_t_uint16_t(ptr nocapture %ptr, i64 %off, i8 signext %str) {
; CHECK-LABEL: st_reg_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sthx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_int8_t_uint16_t(i64 %ptr, i8 zeroext %off, i8 signext %str) {
; CHECK-LABEL: st_or1_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    sth r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_int8_t_uint16_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_not_disjoint16_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_int8_t_uint16_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_disjoint_align16_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    sth r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = sext i8 %str to i16
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_int8_t_uint16_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_not_disjoint32_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    sth r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_int8_t_uint16_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_int8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    psth r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_int8_t_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    lis r5, 15258
; CHECK-P9-NEXT:    ori r5, r5, 41712
; CHECK-P9-NEXT:    sthx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_int8_t_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r5, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r5
; CHECK-P8-NEXT:    ori r5, r6, 41712
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = sext i8 %str to i16
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_int8_t_uint16_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_int8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    sth r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_int8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    sth r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_int8_t_uint16_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_int8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    sthx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_int8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    sthx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = sext i8 %str to i16
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_int8_t_uint16_t(i8 signext %str) {
; CHECK-LABEL: st_cst_align16_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sth r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  store i16 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_int8_t_uint16_t(i8 signext %str) {
; CHECK-LABEL: st_cst_align32_int8_t_uint16_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    sth r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  store i16 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_int8_t_uint16_t(i8 signext %str) {
; CHECK-P10-LABEL: st_cst_align64_int8_t_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    sth r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_int8_t_uint16_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    sth r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i16
  store i16 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_int8_t_uint32_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_0_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %0 = inttoptr i64 %ptr to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_int8_t_uint32_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-LABEL: st_align16_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_int8_t_uint32_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align32_int8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstw r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_int8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_int8_t_uint32_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align64_int8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stwx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_int8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_int8_t_uint32_t(ptr nocapture %ptr, i64 %off, i8 signext %str) {
; CHECK-LABEL: st_reg_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stwx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_int8_t_uint32_t(i64 %ptr, i8 zeroext %off, i8 signext %str) {
; CHECK-LABEL: st_or1_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stw r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_int8_t_uint32_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_not_disjoint16_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_int8_t_uint32_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_disjoint_align16_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stw r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = sext i8 %str to i32
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_int8_t_uint32_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_not_disjoint32_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stw r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_int8_t_uint32_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_int8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstw r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_int8_t_uint32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    lis r5, 15258
; CHECK-P9-NEXT:    ori r5, r5, 41712
; CHECK-P9-NEXT:    stwx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_int8_t_uint32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r5, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r5
; CHECK-P8-NEXT:    ori r5, r6, 41712
; CHECK-P8-NEXT:    stwx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = sext i8 %str to i32
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_int8_t_uint32_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_int8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    stw r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_int8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    stw r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_int8_t_uint32_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_int8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stwx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_int8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stwx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = sext i8 %str to i32
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_int8_t_uint32_t(i8 signext %str) {
; CHECK-LABEL: st_cst_align16_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  store i32 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_int8_t_uint32_t(i8 signext %str) {
; CHECK-LABEL: st_cst_align32_int8_t_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    stw r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  store i32 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_int8_t_uint32_t(i8 signext %str) {
; CHECK-P10-LABEL: st_cst_align64_int8_t_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stw r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_int8_t_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stw r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i32
  store i32 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_int8_t_uint64_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_0_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %0 = inttoptr i64 %ptr to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_int8_t_uint64_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-LABEL: st_align16_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_int8_t_uint64_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align32_int8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstd r4, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_int8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 1525
; CHECK-PREP10-NEXT:    ori r5, r5, 56600
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_int8_t_uint64_t(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align64_int8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_int8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_int8_t_uint64_t(ptr nocapture %ptr, i64 %off, i8 signext %str) {
; CHECK-LABEL: st_reg_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stdx r5, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_int8_t_uint64_t(i64 %ptr, i8 zeroext %off, i8 signext %str) {
; CHECK-LABEL: st_or1_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    std r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_int8_t_uint64_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_not_disjoint16_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_int8_t_uint64_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_disjoint_align16_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    std r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = sext i8 %str to i64
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_int8_t_uint64_t(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_not_disjoint32_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_int8_t_uint64_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_int8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    pstd r4, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_int8_t_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    lis r5, 15258
; CHECK-P9-NEXT:    ori r5, r5, 41712
; CHECK-P9-NEXT:    stdx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_int8_t_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r5, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r5
; CHECK-P8-NEXT:    ori r5, r6, 41712
; CHECK-P8-NEXT:    stdx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = sext i8 %str to i64
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_int8_t_uint64_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_int8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587329
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r6
; CHECK-P10-NEXT:    std r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_int8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r5, 29
; CHECK-PREP10-NEXT:    rldic r5, r5, 35, 24
; CHECK-PREP10-NEXT:    oris r5, r5, 54437
; CHECK-PREP10-NEXT:    ori r5, r5, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r5
; CHECK-PREP10-NEXT:    std r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_int8_t_uint64_t(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_int8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_int8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r5, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r5, r5, 19025
; CHECK-PREP10-NEXT:    rldic r5, r5, 12, 24
; CHECK-PREP10-NEXT:    stdx r4, r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = sext i8 %str to i64
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_int8_t_uint64_t(i8 signext %str) {
; CHECK-LABEL: st_cst_align16_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  store i64 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_int8_t_uint64_t(i8 signext %str) {
; CHECK-LABEL: st_cst_align32_int8_t_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    std r3, -27108(r4)
; CHECK-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  store i64 %conv, ptr inttoptr (i64 9999900 to ptr), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_int8_t_uint64_t(i8 signext %str) {
; CHECK-P10-LABEL: st_cst_align64_int8_t_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    std r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_int8_t_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    std r3, 0(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sext i8 %str to i64
  store i64 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_int8_t_float(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_0_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r4
; CHECK-NEXT:    xscvsxdsp f0, f0
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %0 = inttoptr i64 %ptr to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_int8_t_float(ptr nocapture %ptr, i8 signext %str) {
; CHECK-LABEL: st_align16_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r4
; CHECK-NEXT:    xscvsxdsp f0, f0
; CHECK-NEXT:    stfs f0, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store float %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_int8_t_float(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align32_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    xscvsxdsp f0, f0
; CHECK-P10-NEXT:    pstfs f0, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_int8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    xscvsxdsp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_int8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    xscvsxdsp f0, f0
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store float %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_int8_t_float(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align64_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    xscvsxdsp f0, f0
; CHECK-P10-NEXT:    stfsx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_int8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    xscvsxdsp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_int8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    xscvsxdsp f0, f0
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store float %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_int8_t_float(ptr nocapture %ptr, i64 %off, i8 signext %str) {
; CHECK-LABEL: st_reg_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r5
; CHECK-NEXT:    xscvsxdsp f0, f0
; CHECK-NEXT:    stfsx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store float %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_int8_t_float(i64 %ptr, i8 zeroext %off, i8 signext %str) {
; CHECK-LABEL: st_or1_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r5
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    xscvsxdsp f0, f0
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_int8_t_float(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_not_disjoint16_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r4
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    xscvsxdsp f0, f0
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_int8_t_float(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_disjoint_align16_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r4
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    xscvsxdsp f0, f0
; CHECK-NEXT:    stfs f0, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = sitofp i8 %str to float
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_int8_t_float(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_not_disjoint32_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    ori r3, r3, 34463
; CHECK-P10-NEXT:    oris r3, r3, 1
; CHECK-P10-NEXT:    xscvsxdsp f0, f0
; CHECK-P10-NEXT:    stfs f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint32_int8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    ori r3, r3, 34463
; CHECK-P9-NEXT:    xscvsxdsp f0, f0
; CHECK-P9-NEXT:    oris r3, r3, 1
; CHECK-P9-NEXT:    stfs f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_int8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    xscvsxdsp f0, f0
; CHECK-P8-NEXT:    stfs f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_int8_t_float(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    xscvsxdsp f0, f0
; CHECK-P10-NEXT:    pstfs f0, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_int8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    xscvsxdsp f0, f0
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_int8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    xscvsxdsp f0, f0
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = sitofp i8 %str to float
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_int8_t_float(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    xscvsxdsp f0, f0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfs f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_int8_t_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    mtfprwa f0, r4
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    xscvsxdsp f0, f0
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfs f0, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_int8_t_float(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    xscvsxdsp f0, f0
; CHECK-P10-NEXT:    stfsx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_int8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    xscvsxdsp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_int8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r5, 19025
; CHECK-P8-NEXT:    xscvsxdsp f0, f0
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = sitofp i8 %str to float
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store float %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_int8_t_float(i8 signext %str) {
; CHECK-LABEL: st_cst_align16_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r3
; CHECK-NEXT:    xscvsxdsp f0, f0
; CHECK-NEXT:    stfs f0, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  store float %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_int8_t_float(i8 signext %str) {
; CHECK-LABEL: st_cst_align32_int8_t_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r3
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    xscvsxdsp f0, f0
; CHECK-NEXT:    stfs f0, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  store float %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_int8_t_float(i8 signext %str) {
; CHECK-P10-LABEL: st_cst_align64_int8_t_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r3
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    xscvsxdsp f0, f0
; CHECK-P10-NEXT:    stfs f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_int8_t_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r3
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    xscvsxdsp f0, f0
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stfs f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_int8_t_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    xscvsxdsp f0, f0
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    stfs f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = sitofp i8 %str to float
  store float %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_int8_t_double(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_0_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r4
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %0 = inttoptr i64 %ptr to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_int8_t_double(ptr nocapture %ptr, i8 signext %str) {
; CHECK-LABEL: st_align16_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r4
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfd f0, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_int8_t_double(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align32_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    xscvsxddp f0, f0
; CHECK-P10-NEXT:    pstfd f0, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_int8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    xscvsxddp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stfdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_int8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    xscvsxddp f0, f0
; CHECK-P8-NEXT:    stfdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_int8_t_double(ptr nocapture %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_align64_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    xscvsxddp f0, f0
; CHECK-P10-NEXT:    stfdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_int8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    xscvsxddp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stfdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_int8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    xscvsxddp f0, f0
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    stfdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_int8_t_double(ptr nocapture %ptr, i64 %off, i8 signext %str) {
; CHECK-LABEL: st_reg_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r5
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfdx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_int8_t_double(i64 %ptr, i8 zeroext %off, i8 signext %str) {
; CHECK-LABEL: st_or1_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r5
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_int8_t_double(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_not_disjoint16_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r4
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_int8_t_double(i64 %ptr, i8 signext %str) {
; CHECK-LABEL: st_disjoint_align16_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r4
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfd f0, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = sitofp i8 %str to double
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_int8_t_double(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_not_disjoint32_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    ori r3, r3, 34463
; CHECK-P10-NEXT:    oris r3, r3, 1
; CHECK-P10-NEXT:    xscvsxddp f0, f0
; CHECK-P10-NEXT:    stfd f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint32_int8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    ori r3, r3, 34463
; CHECK-P9-NEXT:    xscvsxddp f0, f0
; CHECK-P9-NEXT:    oris r3, r3, 1
; CHECK-P9-NEXT:    stfd f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_int8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    xscvsxddp f0, f0
; CHECK-P8-NEXT:    stfd f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_int8_t_double(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align32_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    lis r5, -15264
; CHECK-P10-NEXT:    and r3, r3, r5
; CHECK-P10-NEXT:    xscvsxddp f0, f0
; CHECK-P10-NEXT:    pstfd f0, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_int8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    lis r5, -15264
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    xscvsxddp f0, f0
; CHECK-P9-NEXT:    and r3, r3, r5
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_int8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    xscvsxddp f0, f0
; CHECK-P8-NEXT:    stfdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = sitofp i8 %str to double
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_int8_t_double(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_not_disjoint64_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    xscvsxddp f0, f0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfd f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_int8_t_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    mtfprwa f0, r4
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    xscvsxddp f0, f0
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfd f0, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_int8_t_double(i64 %ptr, i8 signext %str) {
; CHECK-P10-LABEL: st_disjoint_align64_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r4
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    xscvsxddp f0, f0
; CHECK-P10-NEXT:    stfdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_int8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r4
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    xscvsxddp f0, f0
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stfdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_int8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r4
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r5, 19025
; CHECK-P8-NEXT:    xscvsxddp f0, f0
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    stfdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = sitofp i8 %str to double
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_int8_t_double(i8 signext %str) {
; CHECK-LABEL: st_cst_align16_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r3
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfd f0, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  store double %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_int8_t_double(i8 signext %str) {
; CHECK-LABEL: st_cst_align32_int8_t_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprwa f0, r3
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfd f0, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  store double %conv, ptr inttoptr (i64 9999900 to ptr), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_int8_t_double(i8 signext %str) {
; CHECK-P10-LABEL: st_cst_align64_int8_t_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    mtfprwa f0, r3
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    xscvsxddp f0, f0
; CHECK-P10-NEXT:    stfd f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_int8_t_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtfprwa f0, r3
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    xscvsxddp f0, f0
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stfd f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_int8_t_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    xscvsxddp f0, f0
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    stfd f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = sitofp i8 %str to double
  store double %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}
