//  SuperTux
//  Copyright (C) 2008 Matthias Braun <matze@braunis.de>
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef HEADER_SUPERTUX_SUPERTUX_TILE_MANAGER_HPP
#define HEADER_SUPERTUX_SUPERTUX_TILE_MANAGER_HPP

#include <map>
#include <memory>
#include <string>

#include "util/currenton.hpp"
#include "util/reader_fwd.hpp"

class TileSet;

class TileManager : public Currenton<TileManager>
{
private:
  typedef std::map<std::string, std::unique_ptr<TileSet> > TileSets;
  TileSets tilesets;

public:
  TileManager();
  ~TileManager();

  TileSet* get_tileset(const std::string &filename);

  std::unique_ptr<TileSet> parse_tileset_definition(const Reader& reader);
};

#endif

/* EOF */
