/*
 * Decompiled with CFR 0.152.
 */
package adql.search;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.search.IReplaceHandler;
import adql.search.SimpleSearchHandler;
import java.util.Stack;

public abstract class SimpleReplaceHandler
extends SimpleSearchHandler
implements IReplaceHandler {
    protected int nbReplacement = 0;

    public SimpleReplaceHandler() {
    }

    public SimpleReplaceHandler(boolean recursive) {
        super(recursive);
    }

    public SimpleReplaceHandler(boolean recursive, boolean onlyFirstMatch) {
        super(recursive, onlyFirstMatch);
    }

    @Override
    public int getNbReplacement() {
        return this.nbReplacement;
    }

    @Override
    protected void reset() {
        super.reset();
        this.nbReplacement = 0;
    }

    protected ADQLObject addMatchAndReplace(ADQLObject matchObj, ADQLIterator it) {
        super.addMatch(matchObj, it);
        if (it != null) {
            try {
                ADQLObject replacer = this.getReplacer(matchObj);
                if (replacer == null) {
                    it.remove();
                } else {
                    it.replace(replacer);
                }
                ++this.nbReplacement;
                return replacer;
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return matchObj;
    }

    @Override
    public void searchAndReplace(ADQLObject startObj) {
        this.reset();
        if (startObj == null) {
            return;
        }
        if (this.match(startObj)) {
            this.addMatch(startObj, null);
        }
        Stack<ADQLIterator> stackIt = new Stack<ADQLIterator>();
        Stack<ADQLObject> stackObj = new Stack<ADQLObject>();
        ADQLObject obj = null;
        ADQLIterator it = startObj.adqlIterator();
        while (!this.isFinished()) {
            do {
                if (it != null && it.hasNext()) {
                    obj = (ADQLObject)it.next();
                    if (obj == null || !this.goInto(obj)) continue;
                    stackIt.push(it);
                    stackObj.push(obj);
                    it = obj.adqlIterator();
                    obj = null;
                    continue;
                }
                if (!stackIt.isEmpty()) {
                    it = (ADQLIterator)stackIt.pop();
                    obj = (ADQLObject)stackObj.pop();
                    continue;
                }
                return;
            } while (obj == null);
            if (this.match(obj)) {
                this.addMatchAndReplace(obj, it);
            }
            obj = null;
        }
    }

    protected abstract ADQLObject getReplacer(ADQLObject var1) throws UnsupportedOperationException;
}

