/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;

public class InUnitFunction
extends ADQLFunction {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adql-unit", "IN_UNIT", true, "Convert the given value (1st argument) into the given VO-Unit (2nd argument).");
    protected final String FCT_NAME = "IN_UNIT";
    protected ADQLOperand value;
    protected ADQLOperand targetUnit;

    public InUnitFunction(ADQLOperand value, ADQLOperand targetUnit) throws NullPointerException, IllegalArgumentException {
        this.setValue(value);
        this.setTargetUnit(targetUnit);
    }

    public final ADQLOperand getValue() {
        return this.value;
    }

    public final void setValue(ADQLOperand value) throws NullPointerException, IllegalArgumentException {
        if (value == null) {
            throw new NullPointerException("The 1st argument of the ADQL function IN_UNIT (i.e. the value to convert) must be non-NULL!");
        }
        if (!value.isNumeric()) {
            throw new IllegalArgumentException("The 1st argument of the ADQL function IN_UNIT (i.e. the value to convert) must be a numeric!");
        }
        this.value = value;
    }

    public final ADQLOperand getTargetUnit() {
        return this.targetUnit;
    }

    public final void setTargetUnit(ADQLOperand targetUnit) throws NullPointerException, IllegalArgumentException {
        if (targetUnit == null) {
            throw new NullPointerException("The 2nd argument of the ADQL function IN_UNIT (i.e. target unit) must be non-NULL!");
        }
        if (!targetUnit.isString()) {
            throw new IllegalArgumentException("The 2nd argument of the ADQL function IN_UNIT (i.e. target unit) must be of type VARCHAR (i.e. a string)!");
        }
        this.targetUnit = targetUnit;
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public String getName() {
        return "IN_UNIT";
    }

    @Override
    public LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new InUnitFunction((ADQLOperand)this.value.getCopy(), (ADQLOperand)this.targetUnit.getCopy());
    }

    @Override
    public int getNbParameters() {
        return 2;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.value, this.targetUnit};
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + "IN_UNIT" + "\" (nb required params = " + this.getNbParameters() + ")!");
        }
        switch (index) {
            case 0: {
                return this.value;
            }
            case 1: {
                return this.targetUnit;
            }
        }
        return null;
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index < 0 || index >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + "IN_UNIT" + "\" (nb required params = " + this.getNbParameters() + ")!");
        }
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove any parameter from the IN_UNIT function! All parameters are required!");
        }
        ADQLOperand replaced = null;
        switch (index) {
            case 0: {
                replaced = this.value;
                this.setValue(replacer);
                this.setPosition(null);
                break;
            }
            case 1: {
                replaced = this.targetUnit;
                this.setTargetUnit(replacer);
                this.setPosition(null);
            }
        }
        return replaced;
    }
}

