/*

Copyright (c) 2007 Carl Byington - 510 Software Group, released under
the GPL version 3 or any later version at your choice available at
http://www.gnu.org/licenses/gpl-3.0.txt

*/
#ifndef smarchive_include
#define smarchive_include

extern int debug_syslog;

////////////////////////////////////////////////
// mail filter private data, held for us by sendmail
//
struct mlfiPriv
{
    // connection specific data
    CONFIG  *pc;            // global filtering configuration
    // message specific data
    const char  *mailaddr;  // envelope from value
    const char  *queueid;   // sendmail queue id
    string_set  targets;    // targets to add at eom, strings are owned by the config
    string_set  removal;    // targets to remove at eom, strings are owned here
    mlfiPriv();
    ~mlfiPriv();
    void reset(bool final = false); // for a new message
};

void my_syslog(mlfiPriv *priv, const char *text);
void my_syslog(const char *text);

#endif
