//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `trace!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn trace() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = 3); // DEBUG:trace,ntp,-,-,-,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3); // DEBUG:trace,ntp,-,p,-,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = 3, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = 3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = 3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = 3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = false); // DEBUG:trace,ntp,-,-,-,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false); // DEBUG:trace,ntp,-,p,-,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = false, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = false, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = false }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = false }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?3); // DEBUG:trace,ntp,-,-,-,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3); // DEBUG:trace,ntp,-,p,-,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?3, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %3); // DEBUG:trace,ntp,-,-,-,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3); // DEBUG:trace,ntp,-,p,-,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %3, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?deb); // DEBUG:trace,ntp,-,-,-,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb); // DEBUG:trace,ntp,-,p,-,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?deb, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?deb, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %disp); // DEBUG:trace,ntp,-,-,-,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp); // DEBUG:trace,ntp,-,p,-,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %disp, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %disp, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %disp }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %disp }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field); // DEBUG:trace,ntp,-,-,-,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field); // DEBUG:trace,ntp,-,p,-,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %sub.field); // DEBUG:trace,ntp,-,-,-,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field); // DEBUG:trace,ntp,-,p,-,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb)); // DEBUG:trace,ntp,-,-,-,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb)); // DEBUG:trace,ntp,-,p,-,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = display(&disp)); // DEBUG:trace,ntp,-,-,-,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp)); // DEBUG:trace,ntp,-,p,-,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty); // DEBUG:trace,ntp,-,-,-,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty); // DEBUG:trace,ntp,-,p,-,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,f,-,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,pf,-,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,-,m,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,p,m,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3); // DEBUG:trace,ntp,-,-,-,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3); // DEBUG:trace,ntp,-,p,-,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = 3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = false); // DEBUG:trace,ntp,-,-,-,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false); // DEBUG:trace,ntp,-,p,-,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = false }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3); // DEBUG:trace,ntp,-,-,-,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3); // DEBUG:trace,ntp,-,p,-,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3); // DEBUG:trace,ntp,-,-,-,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3); // DEBUG:trace,ntp,-,p,-,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb); // DEBUG:trace,ntp,-,-,-,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb); // DEBUG:trace,ntp,-,p,-,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp); // DEBUG:trace,ntp,-,-,-,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp); // DEBUG:trace,ntp,-,p,-,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %disp }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field); // DEBUG:trace,ntp,-,-,-,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field); // DEBUG:trace,ntp,-,p,-,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field); // DEBUG:trace,ntp,-,-,-,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field); // DEBUG:trace,ntp,-,p,-,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb)); // DEBUG:trace,ntp,-,-,-,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb)); // DEBUG:trace,ntp,-,p,-,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp)); // DEBUG:trace,ntp,-,-,-,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp)); // DEBUG:trace,ntp,-,p,-,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty); // DEBUG:trace,ntp,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:trace,ntp,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = 3); // DEBUG:trace,ntp,-,-,-,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3); // DEBUG:trace,ntp,-,p,-,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = 3, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = 3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = 3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = false); // DEBUG:trace,ntp,-,-,-,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false); // DEBUG:trace,ntp,-,p,-,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = false, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = false, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = false }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = false }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?3); // DEBUG:trace,ntp,-,-,-,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3); // DEBUG:trace,ntp,-,p,-,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %3); // DEBUG:trace,ntp,-,-,-,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3); // DEBUG:trace,ntp,-,p,-,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %3, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb); // DEBUG:trace,ntp,-,-,-,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb); // DEBUG:trace,ntp,-,p,-,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %disp); // DEBUG:trace,ntp,-,-,-,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp); // DEBUG:trace,ntp,-,p,-,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %disp }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field); // DEBUG:trace,ntp,-,-,-,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field); // DEBUG:trace,ntp,-,p,-,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field); // DEBUG:trace,ntp,-,-,-,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field); // DEBUG:trace,ntp,-,p,-,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb)); // DEBUG:trace,ntp,-,-,-,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb)); // DEBUG:trace,ntp,-,p,-,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp)); // DEBUG:trace,ntp,-,-,-,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp)); // DEBUG:trace,ntp,-,p,-,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty); // DEBUG:trace,ntp,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty); // DEBUG:trace,ntp,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = false }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb)); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp)); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty); // DEBUG:trace,ntp,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:trace,ntp,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = 3); // DEBUG:trace,ntp,-,-,-,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3); // DEBUG:trace,ntp,-,p,-,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = 3, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = 3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = 3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = false); // DEBUG:trace,ntp,-,-,-,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false); // DEBUG:trace,ntp,-,p,-,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = false, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = false, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = false }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = false }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","false"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?3); // DEBUG:trace,ntp,-,-,-,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3); // DEBUG:trace,ntp,-,p,-,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?3, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","?3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %3); // DEBUG:trace,ntp,-,-,-,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3); // DEBUG:trace,ntp,-,p,-,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %3, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %3, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %3 }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","%3"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?deb); // DEBUG:trace,ntp,-,-,-,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb); // DEBUG:trace,ntp,-,p,-,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %disp); // DEBUG:trace,ntp,-,-,-,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp); // DEBUG:trace,ntp,-,p,-,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %disp, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %disp, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %disp }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field); // DEBUG:trace,ntp,-,-,-,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field); // DEBUG:trace,ntp,-,p,-,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field); // DEBUG:trace,ntp,-,-,-,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field); // DEBUG:trace,ntp,-,p,-,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb)); // DEBUG:trace,ntp,-,-,-,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb)); // DEBUG:trace,ntp,-,p,-,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","debug(&deb)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp)); // DEBUG:trace,ntp,-,-,-,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp)); // DEBUG:trace,ntp,-,p,-,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","display(&disp)"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty); // DEBUG:trace,ntp,-,-,-,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty); // DEBUG:trace,ntp,-,p,-,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,f,-,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:trace,ntp,-,pf,-,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,-,m,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:trace,ntp,-,p,m,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},-,m,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:trace,ntp,{},p,m,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, var); // DEBUG:trace,ntp,-,-,-,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, var); // DEBUG:trace,ntp,-,p,-,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, var, qux = 3); // DEBUG:trace,ntp,-,f,-,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, var, qux = 3); // DEBUG:trace,ntp,-,pf,-,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, var, "msg without args"); // DEBUG:trace,ntp,-,-,m,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, var, "msg without args"); // DEBUG:trace,ntp,-,p,m,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, var, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, var, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { var }, "msg without args"); // DEBUG:trace,ntp,{},-,m,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, var }, "msg without args"); // DEBUG:trace,ntp,{},p,m,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { var, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, var, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { var }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,-,"var"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, sub.field); // DEBUG:trace,ntp,-,-,-,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field); // DEBUG:trace,ntp,-,p,-,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,-,"sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %disp); // DEBUG:trace,ntp,-,-,-,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %disp); // DEBUG:trace,ntp,-,p,-,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %disp, qux = 3); // DEBUG:trace,ntp,-,f,-,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, qux = 3); // DEBUG:trace,ntp,-,pf,-,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %disp, "msg without args"); // DEBUG:trace,ntp,-,-,m,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, "msg without args"); // DEBUG:trace,ntp,-,p,m,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { %disp }, "msg without args"); // DEBUG:trace,ntp,{},-,m,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, %disp }, "msg without args"); // DEBUG:trace,ntp,{},p,m,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,-,"%disp"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?deb); // DEBUG:trace,ntp,-,-,-,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb); // DEBUG:trace,ntp,-,p,-,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?deb, qux = 3); // DEBUG:trace,ntp,-,f,-,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, qux = 3); // DEBUG:trace,ntp,-,pf,-,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?deb, "msg without args"); // DEBUG:trace,ntp,-,-,m,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, "msg without args"); // DEBUG:trace,ntp,-,p,m,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ?deb }, "msg without args"); // DEBUG:trace,ntp,{},-,m,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ?deb }, "msg without args"); // DEBUG:trace,ntp,{},p,m,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,-,"?deb"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %sub.field); // DEBUG:trace,ntp,-,-,-,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field); // DEBUG:trace,ntp,-,p,-,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, %sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,-,"%sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?sub.field); // DEBUG:trace,ntp,-,-,-,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field); // DEBUG:trace,ntp,-,p,-,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?sub.field, qux = 3); // DEBUG:trace,ntp,-,f,-,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, qux = 3); // DEBUG:trace,ntp,-,pf,-,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,-,m,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, "msg without args"); // DEBUG:trace,ntp,-,p,m,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,f,m,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:trace,ntp,-,pf,m,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},-,m,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ?sub.field }, "msg without args"); // DEBUG:trace,ntp,{},p,m,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},f,m,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:trace,ntp,{},pf,m,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,-,ma,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,p,ma,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,f,ma,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,-,pf,ma,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},-,ma,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},p,ma,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},f,ma,-,"?sub.field"
    tracing::trace!(name: "mog", target: "my::module", parent: ::core::option::Option::None, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:trace,ntp,{},pf,ma,-,"?sub.field"
}
