//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `event!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn event() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3); // DEBUG:event,p,-,-,-,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3); // DEBUG:event,p,-,p,-,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3); // DEBUG:event,p,-,f,-,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3); // DEBUG:event,p,-,pf,-,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, "msg without args"); // DEBUG:event,p,-,-,m,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, "msg without args"); // DEBUG:event,p,-,p,m,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3 }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3 }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = false); // DEBUG:event,p,-,-,-,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false); // DEBUG:event,p,-,p,-,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3); // DEBUG:event,p,-,f,-,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3); // DEBUG:event,p,-,pf,-,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, "msg without args"); // DEBUG:event,p,-,-,m,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, "msg without args"); // DEBUG:event,p,-,p,m,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3); // DEBUG:event,p,-,-,-,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3); // DEBUG:event,p,-,p,-,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3); // DEBUG:event,p,-,f,-,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3); // DEBUG:event,p,-,pf,-,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, "msg without args"); // DEBUG:event,p,-,-,m,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, "msg without args"); // DEBUG:event,p,-,p,m,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3 }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3); // DEBUG:event,p,-,-,-,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3); // DEBUG:event,p,-,p,-,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3); // DEBUG:event,p,-,f,-,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3); // DEBUG:event,p,-,pf,-,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, "msg without args"); // DEBUG:event,p,-,-,m,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, "msg without args"); // DEBUG:event,p,-,p,m,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3 }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3 }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb); // DEBUG:event,p,-,-,-,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb); // DEBUG:event,p,-,p,-,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3); // DEBUG:event,p,-,f,-,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3); // DEBUG:event,p,-,pf,-,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, "msg without args"); // DEBUG:event,p,-,-,m,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, "msg without args"); // DEBUG:event,p,-,p,m,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp); // DEBUG:event,p,-,-,-,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp); // DEBUG:event,p,-,p,-,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3); // DEBUG:event,p,-,f,-,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3); // DEBUG:event,p,-,pf,-,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, "msg without args"); // DEBUG:event,p,-,-,m,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, "msg without args"); // DEBUG:event,p,-,p,m,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field); // DEBUG:event,p,-,-,-,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field); // DEBUG:event,p,-,p,-,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3); // DEBUG:event,p,-,f,-,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field); // DEBUG:event,p,-,-,-,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field); // DEBUG:event,p,-,p,-,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3); // DEBUG:event,p,-,f,-,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb)); // DEBUG:event,p,-,-,-,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb)); // DEBUG:event,p,-,p,-,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3); // DEBUG:event,p,-,f,-,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3); // DEBUG:event,p,-,pf,-,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), "msg without args"); // DEBUG:event,p,-,-,m,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:event,p,-,p,m,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp)); // DEBUG:event,p,-,-,-,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp)); // DEBUG:event,p,-,p,-,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3); // DEBUG:event,p,-,f,-,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3); // DEBUG:event,p,-,pf,-,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), "msg without args"); // DEBUG:event,p,-,-,m,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), "msg without args"); // DEBUG:event,p,-,p,m,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp) }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty); // DEBUG:event,p,-,-,-,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty); // DEBUG:event,p,-,p,-,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,f,-,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,pf,-,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,-,m,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,p,m,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},-,m,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},p,m,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3); // DEBUG:event,p,-,-,-,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3); // DEBUG:event,p,-,p,-,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3 }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false); // DEBUG:event,p,-,-,-,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false); // DEBUG:event,p,-,p,-,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3); // DEBUG:event,p,-,-,-,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3); // DEBUG:event,p,-,p,-,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3 }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3); // DEBUG:event,p,-,-,-,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3); // DEBUG:event,p,-,p,-,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3 }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb); // DEBUG:event,p,-,-,-,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb); // DEBUG:event,p,-,p,-,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp); // DEBUG:event,p,-,-,-,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp); // DEBUG:event,p,-,p,-,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field); // DEBUG:event,p,-,-,-,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field); // DEBUG:event,p,-,p,-,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field); // DEBUG:event,p,-,-,-,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field); // DEBUG:event,p,-,p,-,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb)); // DEBUG:event,p,-,-,-,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb)); // DEBUG:event,p,-,p,-,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp)); // DEBUG:event,p,-,-,-,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp)); // DEBUG:event,p,-,p,-,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty); // DEBUG:event,p,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:event,p,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3); // DEBUG:event,p,-,-,-,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3); // DEBUG:event,p,-,p,-,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3 }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false); // DEBUG:event,p,-,-,-,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false); // DEBUG:event,p,-,p,-,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3); // DEBUG:event,p,-,-,-,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3); // DEBUG:event,p,-,p,-,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3 }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3); // DEBUG:event,p,-,-,-,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3); // DEBUG:event,p,-,p,-,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3 }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb); // DEBUG:event,p,-,-,-,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb); // DEBUG:event,p,-,p,-,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp); // DEBUG:event,p,-,-,-,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp); // DEBUG:event,p,-,p,-,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field); // DEBUG:event,p,-,-,-,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field); // DEBUG:event,p,-,p,-,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field); // DEBUG:event,p,-,-,-,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field); // DEBUG:event,p,-,p,-,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb)); // DEBUG:event,p,-,-,-,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb)); // DEBUG:event,p,-,p,-,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp)); // DEBUG:event,p,-,-,-,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp)); // DEBUG:event,p,-,p,-,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp) }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty); // DEBUG:event,p,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty); // DEBUG:event,p,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb)); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp)); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,p,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,p,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3); // DEBUG:event,p,-,-,-,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3); // DEBUG:event,p,-,p,-,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3); // DEBUG:event,p,-,f,-,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3 }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false); // DEBUG:event,p,-,-,-,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false); // DEBUG:event,p,-,p,-,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3); // DEBUG:event,p,-,f,-,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","false"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3); // DEBUG:event,p,-,-,-,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3); // DEBUG:event,p,-,p,-,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3); // DEBUG:event,p,-,f,-,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3 }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","?3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3); // DEBUG:event,p,-,-,-,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3); // DEBUG:event,p,-,p,-,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3); // DEBUG:event,p,-,f,-,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3 }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","%3"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb); // DEBUG:event,p,-,-,-,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb); // DEBUG:event,p,-,p,-,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3); // DEBUG:event,p,-,f,-,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp); // DEBUG:event,p,-,-,-,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp); // DEBUG:event,p,-,p,-,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3); // DEBUG:event,p,-,f,-,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field); // DEBUG:event,p,-,-,-,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field); // DEBUG:event,p,-,p,-,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3); // DEBUG:event,p,-,f,-,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field); // DEBUG:event,p,-,-,-,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field); // DEBUG:event,p,-,p,-,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3); // DEBUG:event,p,-,f,-,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb)); // DEBUG:event,p,-,-,-,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb)); // DEBUG:event,p,-,p,-,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3); // DEBUG:event,p,-,f,-,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:event,p,-,pf,-,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), "msg without args"); // DEBUG:event,p,-,-,m,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:event,p,-,p,m,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","debug(&deb)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp)); // DEBUG:event,p,-,-,-,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp)); // DEBUG:event,p,-,p,-,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3); // DEBUG:event,p,-,f,-,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3); // DEBUG:event,p,-,pf,-,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), "msg without args"); // DEBUG:event,p,-,-,m,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:event,p,-,p,m,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp) }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","display(&disp)"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty); // DEBUG:event,p,-,-,-,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty); // DEBUG:event,p,-,p,-,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,f,-,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,p,-,pf,-,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,-,m,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,p,-,p,m,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},-,m,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,p,{},p,m,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, var); // DEBUG:event,p,-,-,-,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var); // DEBUG:event,p,-,p,-,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3); // DEBUG:event,p,-,f,-,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3); // DEBUG:event,p,-,pf,-,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, var, "msg without args"); // DEBUG:event,p,-,-,m,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, "msg without args"); // DEBUG:event,p,-,p,m,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { var }, "msg without args"); // DEBUG:event,p,{},-,m,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var }, "msg without args"); // DEBUG:event,p,{},p,m,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { var, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, var, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { var }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,-,"var"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, sub.field); // DEBUG:event,p,-,-,-,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field); // DEBUG:event,p,-,p,-,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3); // DEBUG:event,p,-,f,-,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3); // DEBUG:event,p,-,pf,-,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, "msg without args"); // DEBUG:event,p,-,-,m,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, "msg without args"); // DEBUG:event,p,-,p,m,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,-,"sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %disp); // DEBUG:event,p,-,-,-,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp); // DEBUG:event,p,-,p,-,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3); // DEBUG:event,p,-,f,-,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3); // DEBUG:event,p,-,pf,-,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %disp, "msg without args"); // DEBUG:event,p,-,-,m,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, "msg without args"); // DEBUG:event,p,-,p,m,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { %disp }, "msg without args"); // DEBUG:event,p,{},-,m,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp }, "msg without args"); // DEBUG:event,p,{},p,m,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,-,"%disp"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?deb); // DEBUG:event,p,-,-,-,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb); // DEBUG:event,p,-,p,-,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3); // DEBUG:event,p,-,f,-,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3); // DEBUG:event,p,-,pf,-,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, "msg without args"); // DEBUG:event,p,-,-,m,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, "msg without args"); // DEBUG:event,p,-,p,m,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb }, "msg without args"); // DEBUG:event,p,{},-,m,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb }, "msg without args"); // DEBUG:event,p,{},p,m,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,-,"?deb"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field); // DEBUG:event,p,-,-,-,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field); // DEBUG:event,p,-,p,-,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3); // DEBUG:event,p,-,f,-,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3); // DEBUG:event,p,-,pf,-,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, "msg without args"); // DEBUG:event,p,-,-,m,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, "msg without args"); // DEBUG:event,p,-,p,m,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,-,"%sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field); // DEBUG:event,p,-,-,-,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field); // DEBUG:event,p,-,p,-,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3); // DEBUG:event,p,-,f,-,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3); // DEBUG:event,p,-,pf,-,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, "msg without args"); // DEBUG:event,p,-,-,m,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, "msg without args"); // DEBUG:event,p,-,p,m,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,f,m,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,p,-,pf,m,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field }, "msg without args"); // DEBUG:event,p,{},-,m,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field }, "msg without args"); // DEBUG:event,p,{},p,m,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},f,m,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,p,{},pf,m,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,-,ma,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,p,-,p,ma,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,f,ma,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,p,-,pf,ma,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},-,ma,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},p,ma,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},f,ma,-,"?sub.field"
    tracing::event!(parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,p,{},pf,ma,-,"?sub.field"
}
