//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `debug!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn debug() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::debug!(name: "mog", target: "my::module", ident = 3); // DEBUG:debug,nt,-,-,-,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = 3); // DEBUG:debug,nt,-,p,-,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", ident = 3, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = 3, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", ident = 3, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = 3, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", ident = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", { ident = 3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = 3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", { ident = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", ident = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","3"
    tracing::debug!(name: "mog", target: "my::module", ident = false); // DEBUG:debug,nt,-,-,-,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = false); // DEBUG:debug,nt,-,p,-,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", ident = false, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = false, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", ident = false, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = false, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", ident = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", { ident = false }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = false }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", { ident = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", ident = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", { ident = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","false"
    tracing::debug!(name: "mog", target: "my::module", ident = ?3); // DEBUG:debug,nt,-,-,-,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?3); // DEBUG:debug,nt,-,p,-,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", ident = ?3, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?3, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", ident = ?3, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?3, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", ident = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", ident = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","?3"
    tracing::debug!(name: "mog", target: "my::module", ident = %3); // DEBUG:debug,nt,-,-,-,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %3); // DEBUG:debug,nt,-,p,-,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", ident = %3, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %3, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", ident = %3, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %3, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", ident = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { ident = %3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { ident = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", ident = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","%3"
    tracing::debug!(name: "mog", target: "my::module", ident = ?deb); // DEBUG:debug,nt,-,-,-,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?deb); // DEBUG:debug,nt,-,p,-,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", ident = ?deb, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?deb, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", ident = ?deb, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?deb, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", ident = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?deb }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?deb }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", ident = %disp); // DEBUG:debug,nt,-,-,-,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %disp); // DEBUG:debug,nt,-,p,-,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", ident = %disp, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %disp, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", ident = %disp, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %disp, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", ident = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { ident = %disp }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %disp }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", ident = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", ident = ?sub.field); // DEBUG:debug,nt,-,-,-,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?sub.field); // DEBUG:debug,nt,-,p,-,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = ?sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = %sub.field); // DEBUG:debug,nt,-,-,-,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %sub.field); // DEBUG:debug,nt,-,p,-,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = %sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = %sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ident = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", ident = debug(&deb)); // DEBUG:debug,nt,-,-,-,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = debug(&deb)); // DEBUG:debug,nt,-,p,-,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", ident = debug(&deb), qux = 3); // DEBUG:debug,nt,-,f,-,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", ident = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { ident = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", ident = display(&disp)); // DEBUG:debug,nt,-,-,-,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = display(&disp)); // DEBUG:debug,nt,-,p,-,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", ident = display(&disp), qux = 3); // DEBUG:debug,nt,-,f,-,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = display(&disp), qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", ident = display(&disp), "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = display(&disp), "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", ident = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { ident = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", ident = tracing::field::Empty); // DEBUG:debug,nt,-,-,-,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty); // DEBUG:debug,nt,-,p,-,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", ident = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,f,-,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,pf,-,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", ident = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,-,m,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,p,m,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { ident = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},-,m,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},p,m,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = 3); // DEBUG:debug,nt,-,-,-,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = 3); // DEBUG:debug,nt,-,p,-,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = 3, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = 3, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = 3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = false); // DEBUG:debug,nt,-,-,-,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = false); // DEBUG:debug,nt,-,p,-,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = false, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = false, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = false, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = false, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = false }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","false"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?3); // DEBUG:debug,nt,-,-,-,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3); // DEBUG:debug,nt,-,p,-,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?3, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?3, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","?3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %3); // DEBUG:debug,nt,-,-,-,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %3); // DEBUG:debug,nt,-,p,-,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %3, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %3, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","%3"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?deb); // DEBUG:debug,nt,-,-,-,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb); // DEBUG:debug,nt,-,p,-,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?deb, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?deb, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?deb }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","?deb"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %disp); // DEBUG:debug,nt,-,-,-,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp); // DEBUG:debug,nt,-,p,-,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %disp, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %disp, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %disp }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","%disp"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?sub.field); // DEBUG:debug,nt,-,-,-,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field); // DEBUG:debug,nt,-,p,-,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %sub.field); // DEBUG:debug,nt,-,-,-,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field); // DEBUG:debug,nt,-,p,-,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = debug(&deb)); // DEBUG:debug,nt,-,-,-,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb)); // DEBUG:debug,nt,-,p,-,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = debug(&deb), qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = display(&disp)); // DEBUG:debug,nt,-,-,-,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp)); // DEBUG:debug,nt,-,p,-,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = display(&disp), qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = display(&disp), "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty); // DEBUG:debug,nt,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty); // DEBUG:debug,nt,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", "literal" = 3); // DEBUG:debug,nt,-,-,-,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = 3); // DEBUG:debug,nt,-,p,-,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = 3, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = 3, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = 3, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = 3, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = 3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = false); // DEBUG:debug,nt,-,-,-,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = false); // DEBUG:debug,nt,-,p,-,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", "literal" = false, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = false, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", "literal" = false, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = false, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", "literal" = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = false }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = false }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", "literal" = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","false"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?3); // DEBUG:debug,nt,-,-,-,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?3); // DEBUG:debug,nt,-,p,-,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?3, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?3, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?3, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?3, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","?3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %3); // DEBUG:debug,nt,-,-,-,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %3); // DEBUG:debug,nt,-,p,-,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %3, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %3, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %3, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %3, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","%3"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?deb); // DEBUG:debug,nt,-,-,-,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?deb); // DEBUG:debug,nt,-,p,-,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?deb, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?deb, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?deb }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","?deb"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %disp); // DEBUG:debug,nt,-,-,-,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %disp); // DEBUG:debug,nt,-,p,-,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %disp, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %disp, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %disp, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %disp, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %disp }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","%disp"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?sub.field); // DEBUG:debug,nt,-,-,-,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field); // DEBUG:debug,nt,-,p,-,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %sub.field); // DEBUG:debug,nt,-,-,-,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field); // DEBUG:debug,nt,-,p,-,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", "literal" = debug(&deb)); // DEBUG:debug,nt,-,-,-,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb)); // DEBUG:debug,nt,-,p,-,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = debug(&deb), qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = display(&disp)); // DEBUG:debug,nt,-,-,-,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp)); // DEBUG:debug,nt,-,p,-,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = display(&disp), qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = display(&disp), "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", "literal" = tracing::field::Empty); // DEBUG:debug,nt,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty); // DEBUG:debug,nt,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = 3); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = 3, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = 3, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = false); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = false, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = false, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = false }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","false"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?3); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?3, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?3, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %3); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %3, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %3, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?deb); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %disp); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %disp, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %disp, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb)); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp)); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp)); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty); // DEBUG:debug,nt,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:debug,nt,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", r#type = 3); // DEBUG:debug,nt,-,-,-,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = 3); // DEBUG:debug,nt,-,p,-,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", r#type = 3, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = 3, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", r#type = 3, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = 3, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", r#type = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = 3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = 3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", r#type = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","3"
    tracing::debug!(name: "mog", target: "my::module", r#type = false); // DEBUG:debug,nt,-,-,-,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = false); // DEBUG:debug,nt,-,p,-,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", r#type = false, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = false, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", r#type = false, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = false, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", r#type = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", { r#type = false }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = false }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", { r#type = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", r#type = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","false"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?3); // DEBUG:debug,nt,-,-,-,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?3); // DEBUG:debug,nt,-,p,-,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?3, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?3, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?3, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?3, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","?3"
    tracing::debug!(name: "mog", target: "my::module", r#type = %3); // DEBUG:debug,nt,-,-,-,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %3); // DEBUG:debug,nt,-,p,-,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", r#type = %3, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %3, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", r#type = %3, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %3, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", r#type = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %3 }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %3 }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", r#type = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","%3"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?deb); // DEBUG:debug,nt,-,-,-,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?deb); // DEBUG:debug,nt,-,p,-,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?deb, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?deb, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?deb, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?deb, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?deb }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","?deb"
    tracing::debug!(name: "mog", target: "my::module", r#type = %disp); // DEBUG:debug,nt,-,-,-,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %disp); // DEBUG:debug,nt,-,p,-,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", r#type = %disp, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %disp, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", r#type = %disp, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %disp, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", r#type = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %disp }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %disp }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","%disp"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?sub.field); // DEBUG:debug,nt,-,-,-,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field); // DEBUG:debug,nt,-,p,-,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","?sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = %sub.field); // DEBUG:debug,nt,-,-,-,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %sub.field); // DEBUG:debug,nt,-,p,-,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = %sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = %sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","%sub.field"
    tracing::debug!(name: "mog", target: "my::module", r#type = debug(&deb)); // DEBUG:debug,nt,-,-,-,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb)); // DEBUG:debug,nt,-,p,-,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", r#type = debug(&deb), qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", r#type = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { r#type = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","debug(&deb)"
    tracing::debug!(name: "mog", target: "my::module", r#type = display(&disp)); // DEBUG:debug,nt,-,-,-,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = display(&disp)); // DEBUG:debug,nt,-,p,-,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", r#type = display(&disp), qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", r#type = display(&disp), "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { r#type = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","display(&disp)"
    tracing::debug!(name: "mog", target: "my::module", r#type = tracing::field::Empty); // DEBUG:debug,nt,-,-,-,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty); // DEBUG:debug,nt,-,p,-,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", r#type = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,f,-,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:debug,nt,-,pf,-,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", r#type = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,-,m,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:debug,nt,-,p,m,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},-,m,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:debug,nt,{},p,m,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::debug!(name: "mog", target: "my::module", var); // DEBUG:debug,nt,-,-,-,-,"var"
    tracing::debug!(name: "mog", target: "my::module", foo = true, var); // DEBUG:debug,nt,-,p,-,-,"var"
    tracing::debug!(name: "mog", target: "my::module", var, qux = 3); // DEBUG:debug,nt,-,f,-,-,"var"
    tracing::debug!(name: "mog", target: "my::module", foo = true, var, qux = 3); // DEBUG:debug,nt,-,pf,-,-,"var"
    tracing::debug!(name: "mog", target: "my::module", var, "msg without args"); // DEBUG:debug,nt,-,-,m,-,"var"
    tracing::debug!(name: "mog", target: "my::module", foo = true, var, "msg without args"); // DEBUG:debug,nt,-,p,m,-,"var"
    tracing::debug!(name: "mog", target: "my::module", var, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,-,"var"
    tracing::debug!(name: "mog", target: "my::module", foo = true, var, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,-,"var"
    tracing::debug!(name: "mog", target: "my::module", { var }, "msg without args"); // DEBUG:debug,nt,{},-,m,-,"var"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, var }, "msg without args"); // DEBUG:debug,nt,{},p,m,-,"var"
    tracing::debug!(name: "mog", target: "my::module", { var, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,-,"var"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,-,"var"
    tracing::debug!(name: "mog", target: "my::module", var, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,-,"var"
    tracing::debug!(name: "mog", target: "my::module", foo = true, var, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,-,"var"
    tracing::debug!(name: "mog", target: "my::module", var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,-,"var"
    tracing::debug!(name: "mog", target: "my::module", foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,-,"var"
    tracing::debug!(name: "mog", target: "my::module", { var }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,-,"var"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,-,"var"
    tracing::debug!(name: "mog", target: "my::module", { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,-,"var"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,-,"var"
    tracing::debug!(name: "mog", target: "my::module", sub.field); // DEBUG:debug,nt,-,-,-,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, sub.field); // DEBUG:debug,nt,-,p,-,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", { sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", { sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", { sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,-,"sub.field"
    tracing::debug!(name: "mog", target: "my::module", %disp); // DEBUG:debug,nt,-,-,-,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %disp); // DEBUG:debug,nt,-,p,-,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", %disp, qux = 3); // DEBUG:debug,nt,-,f,-,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %disp, qux = 3); // DEBUG:debug,nt,-,pf,-,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", %disp, "msg without args"); // DEBUG:debug,nt,-,-,m,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %disp, "msg without args"); // DEBUG:debug,nt,-,p,m,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %disp, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", { %disp }, "msg without args"); // DEBUG:debug,nt,{},-,m,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, %disp }, "msg without args"); // DEBUG:debug,nt,{},p,m,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", { %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", { %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,-,"%disp"
    tracing::debug!(name: "mog", target: "my::module", ?deb); // DEBUG:debug,nt,-,-,-,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?deb); // DEBUG:debug,nt,-,p,-,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", ?deb, qux = 3); // DEBUG:debug,nt,-,f,-,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?deb, qux = 3); // DEBUG:debug,nt,-,pf,-,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", ?deb, "msg without args"); // DEBUG:debug,nt,-,-,m,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?deb, "msg without args"); // DEBUG:debug,nt,-,p,m,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", { ?deb }, "msg without args"); // DEBUG:debug,nt,{},-,m,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ?deb }, "msg without args"); // DEBUG:debug,nt,{},p,m,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", { ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", { ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,-,"?deb"
    tracing::debug!(name: "mog", target: "my::module", %sub.field); // DEBUG:debug,nt,-,-,-,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %sub.field); // DEBUG:debug,nt,-,p,-,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", %sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", %sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { %sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, %sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,-,"%sub.field"
    tracing::debug!(name: "mog", target: "my::module", ?sub.field); // DEBUG:debug,nt,-,-,-,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?sub.field); // DEBUG:debug,nt,-,p,-,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ?sub.field, qux = 3); // DEBUG:debug,nt,-,f,-,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?sub.field, qux = 3); // DEBUG:debug,nt,-,pf,-,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ?sub.field, "msg without args"); // DEBUG:debug,nt,-,-,m,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?sub.field, "msg without args"); // DEBUG:debug,nt,-,p,m,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,f,m,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:debug,nt,-,pf,m,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},-,m,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ?sub.field }, "msg without args"); // DEBUG:debug,nt,{},p,m,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},f,m,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:debug,nt,{},pf,m,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,-,ma,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,p,ma,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,f,ma,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:debug,nt,-,pf,ma,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},-,ma,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},p,ma,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},f,ma,-,"?sub.field"
    tracing::debug!(name: "mog", target: "my::module", { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:debug,nt,{},pf,ma,-,"?sub.field"
}
