
/*log.c - general work with log-file*/

/*
 * (c) Stanislav Ievlev inger@linux.ru.net
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pwd.h>

#include "rklogd-viewer.h"

#define RSBAC_IDENT_STR "rsbac_adf_request(): request"

/*external data*/
extern char *logname;
extern void exit_logger (char *str);
extern char *enterline_win (char *head, char *val_name, char *old_value);
extern FILE *logfile;

/*filter*/
log_info filter_log = { "", "", 0, "", "", "", "", "", 0, "", "", 0 };	/*filter */

int
in_filter (log_info tmp_log)
{
	if ((filter_log.username[0]) &&
	    (strstr (tmp_log.username, filter_log.username) == NULL))
		return 1;

	if ((filter_log.request[0]) &&
	    (strstr (tmp_log.request, filter_log.request) == NULL))
		return 1;

	if ((filter_log.progname[0]) &&
	    (strstr (tmp_log.progname, filter_log.progname) == NULL))
		return 1;

	if ((filter_log.target_type[0]) &&
	    (strstr (tmp_log.target_type, filter_log.target_type) == NULL))
		return 1;

	if ((filter_log.tid[0]) &&
	    (strstr (tmp_log.tid, filter_log.tid) == NULL))
		return 1;

	if ((filter_log.attr[0]) &&
	    (strstr (tmp_log.attr, filter_log.attr) == NULL))
		return 1;

	if ((filter_log.result[0]) &&
	    (strstr (tmp_log.result, filter_log.result) == NULL))
		return 1;

	return 0;
}

/*open log file*/
int
open_log ()
{
	int     do_exit = 0;

	do
	{
		logfile = fopen (logname, "r");

		if (!logfile)
		{
			strncpy (logname,
				 enterline_win ("Correct file name",
						"File name", logname),
				 MAX_NAME);
			fprintf (stderr, "\a");
			do_exit = 1;
		} else
		{
			do_exit = 0;
		}
	} while (do_exit);

	return 0;
}

/*finish work with log-file*/
int
close_log ()
{
	fclose (logfile);
	return 0;
}

/*read next line from log file*/
log_info
read_log ()
{
	log_info tmp_log;
	char    tmp[MAX_LINE];
	char    tmp1[MAX_LINE];
	char   *find_point, *find1_point;

	int     i, count;
	struct passwd *mypasswd;

	static char parse_list[COUNT_DATA][MAX_NAME] = { "request ",
		"pid ",
		"prog_name ",
		"uid",
		"target_type",
		"tid",
		"attr",
		"value",
		"result"
			/*by */
	};

	static char stop_list[COUNT_DATA][MAX_NAME] = { ",",
		",",
		",",
		",",
		",",
		",",
		",",
		",",
		"by"
			/*by */
	};

	/*bad value by default */
	tmp_log.res = -2;

	/*already end of file */
	if (feof (logfile))
	{
		return tmp_log;
	}

	/*read line until success */
	while (!feof (logfile))
	{
		/*exit if done */
		if (!fgets (tmp, MAX_LINE, logfile))
			return tmp_log;

		/*check for identification string */
		if (strstr (tmp, RSBAC_IDENT_STR) != NULL)
			break;
	}

	tmp_log.res = 0;

	/*get date *//*!!!FIXME!!! */
	find_point = strstr (tmp, "<6>");

	if (find_point == NULL)
	{
		find_point = strstr (tmp, "rsbac");
		if (find_point == NULL)
		{
			tmp_log.res = -1;
			return tmp_log;
		} else
		{
			strncpy (tmp_log.time, tmp, (int) (find_point - tmp));
			tmp_log.time[(int) (find_point - tmp)] = 0;
		}
	} else
	{
		strncpy (tmp_log.time, tmp, (int) (find_point - tmp) - 2);
		tmp_log.time[(int) (find_point - tmp) - 2] = 0;
	}

	/*Parse data */
	find_point = tmp;
	for (count = 0; count < COUNT_DATA; count++)
	{

		find_point = strstr (find_point, parse_list[count]);
		if (!(find_point))
		{
			tmp_log.res = -1;
			return tmp_log;
		}

		for (i = 0; i < strlen (parse_list[count]); i++)
			find_point++;

		find1_point = strstr (find_point, stop_list[count]);
		if (!(find1_point))
		{
			tmp_log.res = -1;
			return tmp_log;
		}

		switch (count)
		{
			case 0:
				strncpy (tmp_log.request, find_point,
					 (int) (find1_point - find_point));
				tmp_log.request[(int)
						(find1_point - find_point)] =
					0;
				break;
			case 1:
				strncpy (tmp1, find_point,
					 (int) (find1_point - find_point));
				tmp1[(int) (find1_point - find_point)] = 0;
				tmp_log.pid = atoi (tmp1);
				break;
			case 2:
				strncpy (tmp_log.progname, find_point,
					 (int) (find1_point - find_point));
				tmp_log.progname[(int)
						 (find1_point - find_point)] =
					0;
				break;
			case 3:
				strncpy (tmp1, find_point,
					 (int) (find1_point - find_point));
				tmp1[(int) (find1_point - find_point)] = 0;
				mypasswd = getpwuid (atoi (tmp1));
				if (mypasswd)
				{
					strncpy (tmp_log.username,
						 mypasswd->pw_name, MAX_NAME);
				} else
				{
					snprintf (tmp_log.username, MAX_NAME,
						  "user#%d", atoi (tmp1));
				}
				break;
			case 4:
				strncpy (tmp_log.target_type, ++find_point,
					 (int) (find1_point - find_point));
				tmp_log.target_type[(int)
						    (find1_point -
						     find_point)] = 0;
				break;
			case 5:
				strncpy (tmp_log.tid, ++find_point,
					 (int) (find1_point - find_point));
				tmp_log.tid[(int) (find1_point - find_point)]
					= 0;
				break;
			case 6:
				strncpy (tmp_log.attr, ++find_point,
					 (int) (find1_point - find_point));
				tmp_log.attr[(int) (find1_point - find_point)]
					= 0;
				break;
			case 7:
				strncpy (tmp1, find_point,
					 (int) (find1_point - find_point));
				tmp1[(int) (find1_point - find_point)] = 0;
				tmp_log.value = atoi (tmp1);
				break;
			case 8:
				strncpy (tmp_log.result, ++find_point,
					 (int) (find1_point - find_point));
				tmp_log.result[(int)
					       (find1_point - find_point)] =
					0;
				break;
			default:
				break;
		}

	}
	/*End Parse data */

	/*Filter results */
	if (in_filter (tmp_log))
	{
		tmp_log.res = -3;
	}

	return tmp_log;
}
