/* Copyright (C) 2004 Marc Rehmsmeier, Peter Steffen, Matthias Hoechsmann */

/* This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

#include "energy.h"

void init_constants()
{
  e = 2.718281828459;
  t = 273.15;
  temp = t + 37.0;
  r = 8.3143;

  wkn = 0.83;

  npp = 0.2;
  pbp = 0.1 * wkn;

  mloop_close = 4.6;
  free_base_penalty = 0.4;
  helix_penalty = 0.1;
}


#define compl(I,J) canPair[I][J]


double sr_energy(int i, int j){
  return(stack_dg_ar[inpx(i)][inpx(i+1)][inpy(j+1)][inpy(j)]);
}


double dr_energy(int i, int j){
  return(dr_dangle_dg_ar[inpx(i)][inpy(j)][inpy(j-1)]);
}

double dli_energy(int i, int j){
  return(dr_dangle_dg_ar[inpy(j)][inpx(i)][inpx(i+1)]);
}

double dl_energy(int i, int j){
  return(dl_dangle_dg_ar[inpx(i-1)][inpx(i)][inpy(j)]);
}

double dri_energy(int i, int j){
  return(dl_dangle_dg_ar[inpy(j+1)][inpy(j)][inpx(i)]);
}

 
double dangles (int i, int j, int i2, int j2, int k, int l, int k2,int l2) {
  return((dli_energy(j,k+1)+dri_energy(j2,k2+1))*wkn);
}

double sspenalty(int a){
  return(npp*a);
}

double log_interp(int size){
  return(1.079*log(((double)size)/30.0));
}


double hl_ent(int size){
  return (size<=30 ? hl_ent_ar[size] : hl_ent_ar[30] + log_interp(size));
}

double bl_ent(int size){
  return (size<=30 ? bl_ent_ar[size] : bl_ent_ar[30] + log_interp(size));
}

#define il_ent(size) ((size)<=30 ? il_ent_ar[(size)] : il_ent_ar[30] + log_interp((size)))

int lengthOf(int i, int j){
  return(j-i);
}


void init_il_asym_ar()
{
  int i, j;

  for (i=1; i<=15; i++)
    for (j=1; j<=15; j++)
      il_asym_ar[i][j] = min(3.0, abs(i-j)*0.3);
}


/* double il_asym (int sl, int sr){ */
/*   return(min(3.0, abs(sl-sr)*0.3)); */
/* } */


double bl_stacking (int t, int b, int i, int j){
  if ((t==0) && (b==1)) return(stack_dg_ar[inpx(i)][inpx(i+1)][inpy(j+2)][inpy(j)]);
  else if ((t==1) && (b==0)) return(stack_dg_ar[inpx(i)][inpx(i+2)][inpy(j+1)][inpy(j)]);
  else return(0);
}




double int_special(int i, int j, int t, int b)
{
  if ((t==1) && (b==1)) return(int11_ar[inpx(i)][inpy(j)][inpx(i+1)][inpy(j+1)][inpx(i+2)][inpy(j+2)]);
  else if ((t==1) && (b==2)) return(int21_ar[inpx(i)][inpy(j)][inpx(i+1)][inpy(j+1)][inpy(j+2)][inpx(i+2)][inpy(j+3)]);
  else if ((t==2) && (b==1)) return(int21_ar[inpy(j+2)][inpx(i+3)][inpy(j+1)][inpx(i+2)][inpx(i+1)][inpy(j)][inpx(i)]);
  else if ((t==2) && (b==2)) return(int22_ar[inpx(i)][inpy(j)][inpx(i+1)][inpx(i+2)][inpy(j+1)][inpy(j+2)][inpx(i+3)][inpy(j+3)]);
}


double do_il_special(int i, int j, int k, int l, int u, int v, double e)
{
  return(e+int_special(i,j,l-k,v-u));
}


/* double do_il(int i, int j, int k, int l, int u, int v, double e){ */
/*   return(e+ il_stack_close (l+1,v+1) + il_ent (l-k+v-u) + il_asym (l-k,v-u)); */
/* } */


void init_hl_ent_ar()
{

  int i;
  for(i=0;i<=2;i++) hl_ent_ar[i] = 0;

  hl_ent_ar[ 3] = 5.7000;
  hl_ent_ar[ 4] = 5.6000;
  hl_ent_ar[ 5] = 5.6000;
  hl_ent_ar[ 6] = 5.4000;
  hl_ent_ar[ 7] = 5.9000;
  hl_ent_ar[ 8] = 5.6000;
  hl_ent_ar[ 9] = 6.4000;
  hl_ent_ar[10] = 6.5000;
  hl_ent_ar[11] = 6.6000;
  hl_ent_ar[12] = 6.7000;
  hl_ent_ar[13] = 6.7800;
  hl_ent_ar[14] = 6.8600;
  hl_ent_ar[15] = 6.9400;
  hl_ent_ar[16] = 7.0100;
  hl_ent_ar[17] = 7.0700;
  hl_ent_ar[18] = 7.1300;
  hl_ent_ar[19] = 7.1900;
  hl_ent_ar[20] = 7.2500;
  hl_ent_ar[21] = 7.3000;
  hl_ent_ar[22] = 7.3500;
  hl_ent_ar[23] = 7.4000;
  hl_ent_ar[24] = 7.4400;
  hl_ent_ar[25] = 7.4900;
  hl_ent_ar[26] = 7.5300;
  hl_ent_ar[27] = 7.5700;
  hl_ent_ar[28] = 7.6100;
  hl_ent_ar[29] = 7.6500;
  hl_ent_ar[30] = 7.6900;
}

void init_stack_dg_ar()
{

  int i,j,k,l;
  for(i=0;i<ALPHASIZE;i++) for(j=0;j<ALPHASIZE;j++) for(k=0;k<ALPHASIZE;k++) for(l=0;l<ALPHASIZE;l++) stack_dg_ar[i][j][k][l] = 0;

  stack_dg_ar[A][A][U][U] = -0.900;
  stack_dg_ar[A][C][G][U] = -2.200;
  stack_dg_ar[A][G][C][U] = -2.100;
  stack_dg_ar[A][G][U][U] = -0.600;
  stack_dg_ar[A][U][A][U] = -1.100;
  stack_dg_ar[A][U][G][U] = -1.400;
  stack_dg_ar[C][A][U][G] = -2.100;
  stack_dg_ar[C][C][G][G] = -3.300;
  stack_dg_ar[C][G][C][G] = -2.400;
  stack_dg_ar[C][G][U][G] = -1.400;
  stack_dg_ar[C][U][A][G] = -2.100;
  stack_dg_ar[C][U][G][G] = -2.100;
  stack_dg_ar[G][A][U][C] = -2.400;
  stack_dg_ar[G][A][U][U] = -1.300;
  stack_dg_ar[G][C][G][C] = -3.400;
  stack_dg_ar[G][C][G][U] = -2.500;
  stack_dg_ar[G][G][C][C] = -3.300;
  stack_dg_ar[G][G][C][U] = -2.100;
  stack_dg_ar[G][G][U][C] = -1.500;
  stack_dg_ar[G][G][U][U] = -0.500;
  stack_dg_ar[G][U][A][C] = -2.200;
  stack_dg_ar[G][U][A][U] = -1.400;
  stack_dg_ar[G][U][G][C] = -2.500;
  stack_dg_ar[G][U][G][U] =  1.300;
  stack_dg_ar[U][A][U][A] = -1.300;
  stack_dg_ar[U][A][U][G] = -1.000;
  stack_dg_ar[U][C][G][A] = -2.400;
  stack_dg_ar[U][C][G][G] = -1.500;
  stack_dg_ar[U][G][C][A] = -2.100;
  stack_dg_ar[U][G][C][G] = -1.400;
  stack_dg_ar[U][G][U][A] = -1.000;
  stack_dg_ar[U][G][U][G] =  0.300;
  stack_dg_ar[U][U][A][A] = -0.900;
  stack_dg_ar[U][U][A][G] = -0.600;
  stack_dg_ar[U][U][G][A] = -1.300;
  stack_dg_ar[U][U][G][G] = -0.500;
}

void init_tstackh_dg_ar()
{

  int i,j,k,l;
  for(i=0;i<ALPHASIZE;i++) for(j=0;j<ALPHASIZE;j++) for(k=0;k<ALPHASIZE;k++) for(l=0;l<ALPHASIZE;l++) tstackh_dg_ar[i][j][k][l] = 0;

  tstackh_dg_ar[A][A][A][U] = -0.300;
  tstackh_dg_ar[A][A][C][U] = -0.500;
  tstackh_dg_ar[A][A][G][U] = -0.300;
  tstackh_dg_ar[A][A][U][U] = -0.300;
  tstackh_dg_ar[A][C][A][U] = -0.100;
  tstackh_dg_ar[A][C][C][U] = -0.200;
  tstackh_dg_ar[A][C][G][U] = -1.500;
  tstackh_dg_ar[A][C][U][U] = -0.200;
  tstackh_dg_ar[A][G][A][U] = -1.100;
  tstackh_dg_ar[A][G][C][U] = -1.200;
  tstackh_dg_ar[A][G][G][U] = -0.200;
  tstackh_dg_ar[A][G][U][U] =  0.200;
  tstackh_dg_ar[A][U][A][U] = -0.300;
  tstackh_dg_ar[A][U][C][U] = -0.300;
  tstackh_dg_ar[A][U][G][U] = -0.600;
  tstackh_dg_ar[A][U][U][U] = -1.100;
  tstackh_dg_ar[C][A][A][G] = -1.500;
  tstackh_dg_ar[C][A][C][G] = -1.500;
  tstackh_dg_ar[C][A][G][G] = -1.400;
  tstackh_dg_ar[C][A][U][G] = -1.800;
  tstackh_dg_ar[C][C][A][G] = -1.000;
  tstackh_dg_ar[C][C][C][G] = -0.900;
  tstackh_dg_ar[C][C][G][G] = -2.900;
  tstackh_dg_ar[C][C][U][G] = -0.800;
  tstackh_dg_ar[C][G][A][G] = -2.200;
  tstackh_dg_ar[C][G][C][G] = -2.000;
  tstackh_dg_ar[C][G][G][G] = -1.600;
  tstackh_dg_ar[C][G][U][G] = -1.100;
  tstackh_dg_ar[C][U][A][G] = -1.700;
  tstackh_dg_ar[C][U][C][G] = -1.400;
  tstackh_dg_ar[C][U][G][G] = -1.800;
  tstackh_dg_ar[C][U][U][G] = -2.000;
  tstackh_dg_ar[G][A][A][C] = -1.100;
  tstackh_dg_ar[G][A][A][U] =  0.200;
  tstackh_dg_ar[G][A][C][C] = -1.500;
  tstackh_dg_ar[G][A][C][U] = -0.500;
  tstackh_dg_ar[G][A][G][C] = -1.300;
  tstackh_dg_ar[G][A][G][U] = -0.300;
  tstackh_dg_ar[G][A][U][C] = -2.100;
  tstackh_dg_ar[G][A][U][U] = -0.300;
  tstackh_dg_ar[G][C][A][C] = -1.100;
  tstackh_dg_ar[G][C][A][U] = -0.100;
  tstackh_dg_ar[G][C][C][C] = -0.700;
  tstackh_dg_ar[G][C][C][U] = -0.200;
  tstackh_dg_ar[G][C][G][C] = -2.400;
  tstackh_dg_ar[G][C][G][U] = -1.500;
  tstackh_dg_ar[G][C][U][C] = -0.500;
  tstackh_dg_ar[G][C][U][U] = -0.200;
  tstackh_dg_ar[G][G][A][C] = -2.400;
  tstackh_dg_ar[G][G][A][U] = -0.900;
  tstackh_dg_ar[G][G][C][C] = -2.900;
  tstackh_dg_ar[G][G][C][U] = -1.100;
  tstackh_dg_ar[G][G][G][C] = -1.400;
  tstackh_dg_ar[G][G][G][U] = -0.300;
  tstackh_dg_ar[G][G][U][C] = -1.200;
  tstackh_dg_ar[G][G][U][U] =  0.000;
  tstackh_dg_ar[G][U][A][C] = -1.900;
  tstackh_dg_ar[G][U][A][U] = -0.300;
  tstackh_dg_ar[G][U][C][C] = -1.000;
  tstackh_dg_ar[G][U][C][U] = -0.300;
  tstackh_dg_ar[G][U][G][C] = -2.200;
  tstackh_dg_ar[G][U][G][U] = -0.400;
  tstackh_dg_ar[G][U][U][C] = -1.500;
  tstackh_dg_ar[G][U][U][U] = -1.100;
  tstackh_dg_ar[U][A][A][A] = -0.500;
  tstackh_dg_ar[U][A][A][G] = -0.500;
  tstackh_dg_ar[U][A][C][A] = -0.300;
  tstackh_dg_ar[U][A][C][G] = -0.300;
  tstackh_dg_ar[U][A][G][A] = -0.600;
  tstackh_dg_ar[U][A][G][G] = -0.600;
  tstackh_dg_ar[U][A][U][A] = -0.500;
  tstackh_dg_ar[U][A][U][G] = -0.500;
  tstackh_dg_ar[U][C][A][A] = -0.200;
  tstackh_dg_ar[U][C][A][G] = -0.200;
  tstackh_dg_ar[U][C][C][A] = -0.100;
  tstackh_dg_ar[U][C][C][G] = -0.100;
  tstackh_dg_ar[U][C][G][A] = -1.200;
  tstackh_dg_ar[U][C][G][G] = -1.700;
  tstackh_dg_ar[U][C][U][A] =  0.000;
  tstackh_dg_ar[U][C][U][G] =  0.000;
  tstackh_dg_ar[U][G][A][A] = -1.400;
  tstackh_dg_ar[U][G][A][G] = -0.800;
  tstackh_dg_ar[U][G][C][A] = -1.200;
  tstackh_dg_ar[U][G][C][G] = -1.200;
  tstackh_dg_ar[U][G][G][A] = -0.700;
  tstackh_dg_ar[U][G][G][G] = -0.300;
  tstackh_dg_ar[U][G][U][A] = -0.200;
  tstackh_dg_ar[U][G][U][G] = -0.700;
  tstackh_dg_ar[U][U][A][A] = -0.300;
  tstackh_dg_ar[U][U][A][G] = -0.600;
  tstackh_dg_ar[U][U][C][A] = -0.100;
  tstackh_dg_ar[U][U][C][G] = -0.100;
  tstackh_dg_ar[U][U][G][A] = -0.500;
  tstackh_dg_ar[U][U][G][G] = -0.600;
  tstackh_dg_ar[U][U][U][A] = -0.800;
  tstackh_dg_ar[U][U][U][G] = -0.800;

}

void init_hl_tetra_ar()
{
  int k1,k2,k3,k4,k5,k6;

  for (k1=0;k1<ALPHASIZE;k1++)
    for (k2=0;k2<ALPHASIZE;k2++)
      for (k3=0;k3<ALPHASIZE;k3++)
         for (k4=0;k4<ALPHASIZE;k4++)
            for (k5=0;k5<ALPHASIZE;k5++)
               for (k6=0;k6<ALPHASIZE;k6++)
                  hl_tetra_ar[k1][k2][k3][k4][k5][k6]=0.0;

  hl_tetra_ar[G][G][G][G][A][C] = -3.000;
  hl_tetra_ar[G][G][U][G][A][C] = -3.000;
  hl_tetra_ar[C][G][A][A][A][G] = -3.000;
  hl_tetra_ar[G][G][A][G][A][C] = -3.000;
  hl_tetra_ar[C][G][C][A][A][G] = -3.000;
  hl_tetra_ar[G][G][A][A][A][C] = -3.000;
  hl_tetra_ar[C][G][G][A][A][G] = -3.000;
  hl_tetra_ar[C][U][U][C][G][G] = -3.000;
  hl_tetra_ar[C][G][U][G][A][G] = -3.000;
  hl_tetra_ar[C][G][A][A][G][G] = -2.500;
  hl_tetra_ar[C][U][A][C][G][G] = -2.500;
  hl_tetra_ar[G][G][C][A][A][C] = -2.500;
  hl_tetra_ar[C][G][C][G][A][G] = -2.500;
  hl_tetra_ar[U][G][A][G][A][G] = -2.500;
  hl_tetra_ar[C][G][A][G][A][G] = -2.000;
  hl_tetra_ar[A][G][A][A][A][U] = -2.000;
  hl_tetra_ar[C][G][U][A][A][G] = -2.000;
  hl_tetra_ar[C][U][A][A][C][G] = -2.000;
  hl_tetra_ar[U][G][A][A][A][G] = -2.000;
  hl_tetra_ar[G][G][A][A][G][C] = -1.500;
  hl_tetra_ar[G][G][G][A][A][C] = -1.500;
  hl_tetra_ar[U][G][A][A][A][A] = -1.500;
  hl_tetra_ar[A][G][C][A][A][U] = -1.500;
  hl_tetra_ar[A][G][U][A][A][U] = -1.500;
  hl_tetra_ar[C][G][G][G][A][G] = -1.500;
  hl_tetra_ar[A][G][U][G][A][U] = -1.500;
  hl_tetra_ar[G][G][C][G][A][C] = -1.500;
  hl_tetra_ar[G][G][G][A][G][C] = -1.500;
  hl_tetra_ar[G][U][G][A][A][C] = -1.500;
  hl_tetra_ar[U][G][G][A][A][A] = -1.500;

}

void init_bl_ent_ar()
{

  bl_ent_ar[ 0] = 0.0;
  bl_ent_ar[ 1] = 3.8000;
  bl_ent_ar[ 2] = 2.8000;
  bl_ent_ar[ 3] = 3.2000;
  bl_ent_ar[ 4] = 3.6000;
  bl_ent_ar[ 5] = 4.0000;
  bl_ent_ar[ 6] = 4.4000;
  bl_ent_ar[ 7] = 4.5900;
  bl_ent_ar[ 8] = 4.7000;
  bl_ent_ar[ 9] = 4.8000;
  bl_ent_ar[10] = 4.9000;
  bl_ent_ar[11] = 5.0000;
  bl_ent_ar[12] = 5.1000;
  bl_ent_ar[13] = 5.1900;
  bl_ent_ar[14] = 5.2700;
  bl_ent_ar[15] = 5.3400;
  bl_ent_ar[16] = 5.4100;
  bl_ent_ar[17] = 5.4800;
  bl_ent_ar[18] = 5.5400;
  bl_ent_ar[19] = 5.6000;
  bl_ent_ar[20] = 5.6500;
  bl_ent_ar[21] = 5.7100;
  bl_ent_ar[22] = 5.7600;
  bl_ent_ar[23] = 5.8000;
  bl_ent_ar[24] = 5.8500;
  bl_ent_ar[25] = 5.8900;
  bl_ent_ar[26] = 5.9400;
  bl_ent_ar[27] = 5.9800;
  bl_ent_ar[28] = 6.0200;
  bl_ent_ar[29] = 6.0500;
  bl_ent_ar[30] = 6.0900;

}

void init_il_ent_ar()
{

  il_ent_ar[ 0] = 0.0;
  il_ent_ar[ 1] = 0.0;
  il_ent_ar[ 2] = 4.1000;
  il_ent_ar[ 3] = 5.1000;
  il_ent_ar[ 4] = 1.7000;
  il_ent_ar[ 5] = 1.8000;
  il_ent_ar[ 6] = 2.0000;
  il_ent_ar[ 7] = 2.2000;
  il_ent_ar[ 8] = 2.3000;
  il_ent_ar[ 9] = 2.4000;
  il_ent_ar[10] = 2.5000;
  il_ent_ar[11] = 2.6000;
  il_ent_ar[12] = 2.7000;
  il_ent_ar[13] = 2.7800;
  il_ent_ar[14] = 2.8600;
  il_ent_ar[15] = 2.9400;
  il_ent_ar[16] = 3.0100;
  il_ent_ar[17] = 3.0700;
  il_ent_ar[18] = 3.1300;
  il_ent_ar[19] = 3.1900;
  il_ent_ar[20] = 3.2500;
  il_ent_ar[21] = 3.3000;
  il_ent_ar[22] = 3.3500;
  il_ent_ar[23] = 3.4000;
  il_ent_ar[24] = 3.4500;
  il_ent_ar[25] = 3.4900;
  il_ent_ar[26] = 3.5300;
  il_ent_ar[27] = 3.5700;
  il_ent_ar[28] = 3.6100;
  il_ent_ar[29] = 3.6500;
  il_ent_ar[30] = 3.6900;



}

void init_tstacki_dg_ar()
{

  int i,j,k,l;
  for(i=0;i<ALPHASIZE;i++) for(j=0;j<ALPHASIZE;j++) for(k=0;k<ALPHASIZE;k++) for(l=0;l<ALPHASIZE;l++) tstacki_dg_ar[i][j][k][l] = 0;

  tstacki_dg_ar[A][A][A][U] =  0.700;
  tstacki_dg_ar[A][A][C][U] =  0.700;
  tstacki_dg_ar[A][A][G][U] = -0.400;
  tstacki_dg_ar[A][A][U][U] =  0.700;
  tstacki_dg_ar[A][C][A][U] =  0.700;
  tstacki_dg_ar[A][C][C][U] =  0.700;
  tstacki_dg_ar[A][C][G][U] =  0.700;
  tstacki_dg_ar[A][C][U][U] =  0.700;
  tstacki_dg_ar[A][G][A][U] = -0.400;
  tstacki_dg_ar[A][G][C][U] =  0.700;
  tstacki_dg_ar[A][G][G][U] =  0.700;
  tstacki_dg_ar[A][G][U][U] =  0.700;
  tstacki_dg_ar[A][U][A][U] =  0.700;
  tstacki_dg_ar[A][U][C][U] =  0.700;
  tstacki_dg_ar[A][U][G][U] =  0.700;
  tstacki_dg_ar[A][U][U][U] =  0.000;
  tstacki_dg_ar[C][A][A][G] =  0.000;
  tstacki_dg_ar[C][A][C][G] =  0.000;
  tstacki_dg_ar[C][A][G][G] = -1.100;
  tstacki_dg_ar[C][A][U][G] =  0.000;
  tstacki_dg_ar[C][C][A][G] =  0.000;
  tstacki_dg_ar[C][C][C][G] =  0.000;
  tstacki_dg_ar[C][C][G][G] =  0.000;
  tstacki_dg_ar[C][C][U][G] =  0.000;
  tstacki_dg_ar[C][G][A][G] = -1.100;
  tstacki_dg_ar[C][G][C][G] =  0.000;
  tstacki_dg_ar[C][G][G][G] =  0.000;
  tstacki_dg_ar[C][G][U][G] =  0.000;
  tstacki_dg_ar[C][U][A][G] =  0.000;
  tstacki_dg_ar[C][U][C][G] =  0.000;
  tstacki_dg_ar[C][U][G][G] =  0.000;
  tstacki_dg_ar[C][U][U][G] = -0.700;
  tstacki_dg_ar[G][A][A][C] =  0.000;
  tstacki_dg_ar[G][A][A][U] =  0.700;
  tstacki_dg_ar[G][A][C][C] =  0.000;
  tstacki_dg_ar[G][A][C][U] =  0.700;
  tstacki_dg_ar[G][A][G][C] = -1.100;
  tstacki_dg_ar[G][A][G][U] = -0.400;
  tstacki_dg_ar[G][A][U][C] =  0.000;
  tstacki_dg_ar[G][A][U][U] =  0.700;
  tstacki_dg_ar[G][C][A][C] =  0.000;
  tstacki_dg_ar[G][C][A][U] =  0.700;
  tstacki_dg_ar[G][C][C][C] =  0.000;
  tstacki_dg_ar[G][C][C][U] =  0.700;
  tstacki_dg_ar[G][C][G][C] =  0.000;
  tstacki_dg_ar[G][C][G][U] =  0.700;
  tstacki_dg_ar[G][C][U][C] =  0.000;
  tstacki_dg_ar[G][C][U][U] =  0.700;
  tstacki_dg_ar[G][G][A][C] = -1.100;
  tstacki_dg_ar[G][G][A][U] = -0.400;
  tstacki_dg_ar[G][G][C][C] =  0.000;
  tstacki_dg_ar[G][G][C][U] =  0.700;
  tstacki_dg_ar[G][G][G][C] =  0.000;
  tstacki_dg_ar[G][G][G][U] =  0.700;
  tstacki_dg_ar[G][G][U][C] =  0.000;
  tstacki_dg_ar[G][G][U][U] =  0.700;
  tstacki_dg_ar[G][U][A][C] =  0.000;
  tstacki_dg_ar[G][U][A][U] =  0.700;
  tstacki_dg_ar[G][U][C][C] =  0.000;
  tstacki_dg_ar[G][U][C][U] =  0.700;
  tstacki_dg_ar[G][U][G][C] =  0.000;
  tstacki_dg_ar[G][U][G][U] =  0.700;
  tstacki_dg_ar[G][U][U][C] = -0.700;
  tstacki_dg_ar[G][U][U][U] =  0.000;
  tstacki_dg_ar[U][A][A][A] =  0.700;
  tstacki_dg_ar[U][A][A][G] =  0.700;
  tstacki_dg_ar[U][A][C][A] =  0.700;
  tstacki_dg_ar[U][A][C][G] =  0.700;
  tstacki_dg_ar[U][A][G][A] = -0.400;
  tstacki_dg_ar[U][A][G][G] = -0.400;
  tstacki_dg_ar[U][A][U][A] =  0.700;
  tstacki_dg_ar[U][A][U][G] =  0.700;
  tstacki_dg_ar[U][C][A][A] =  0.700;
  tstacki_dg_ar[U][C][A][G] =  0.700;
  tstacki_dg_ar[U][C][C][A] =  0.700;
  tstacki_dg_ar[U][C][C][G] =  0.700;
  tstacki_dg_ar[U][C][G][A] =  0.700;
  tstacki_dg_ar[U][C][G][G] =  0.700;
  tstacki_dg_ar[U][C][U][A] =  0.700;
  tstacki_dg_ar[U][C][U][G] =  0.700;
  tstacki_dg_ar[U][G][A][A] = -0.400;
  tstacki_dg_ar[U][G][A][G] = -0.400;
  tstacki_dg_ar[U][G][C][A] =  0.700;
  tstacki_dg_ar[U][G][C][G] =  0.700;
  tstacki_dg_ar[U][G][G][A] =  0.700;
  tstacki_dg_ar[U][G][G][G] =  0.700;
  tstacki_dg_ar[U][G][U][A] =  0.700;
  tstacki_dg_ar[U][G][U][G] =  0.700;
  tstacki_dg_ar[U][U][A][A] =  0.700;
  tstacki_dg_ar[U][U][A][G] =  0.700;
  tstacki_dg_ar[U][U][C][A] =  0.700;
  tstacki_dg_ar[U][U][C][G] =  0.700;
  tstacki_dg_ar[U][U][G][A] =  0.700;
  tstacki_dg_ar[U][U][G][G] =  0.700;
  tstacki_dg_ar[U][U][U][A] =  0.000;
  tstacki_dg_ar[U][U][U][G] =  0.000;
}

void init_dr_dangle_dg_ar()
{
  int i,j,k;
  for(i=0;i<ALPHASIZE;i++) for(j=0;j<ALPHASIZE;j++) for(k=0;k<=ALPHASIZE;k++) dr_dangle_dg_ar[i][j][k] = 0;

  dr_dangle_dg_ar[A][U][A] = -0.700;
  dr_dangle_dg_ar[A][U][C] = -0.100;
  dr_dangle_dg_ar[A][U][G] = -0.700;
  dr_dangle_dg_ar[A][U][U] = -0.100;
  dr_dangle_dg_ar[C][G][A] = -1.100;
  dr_dangle_dg_ar[C][G][C] = -0.400;
  dr_dangle_dg_ar[C][G][G] = -1.300;
  dr_dangle_dg_ar[C][G][U] = -0.600;
  dr_dangle_dg_ar[G][C][A] = -1.700;
  dr_dangle_dg_ar[G][C][C] = -0.800;
  dr_dangle_dg_ar[G][C][G] = -1.700;
  dr_dangle_dg_ar[G][C][U] = -1.200;
  dr_dangle_dg_ar[G][U][A] = -0.700;
  dr_dangle_dg_ar[G][U][C] = -0.100;
  dr_dangle_dg_ar[G][U][G] = -0.700;
  dr_dangle_dg_ar[G][U][U] = -0.100;
  dr_dangle_dg_ar[U][A][A] = -0.800;
  dr_dangle_dg_ar[U][A][C] = -0.500;
  dr_dangle_dg_ar[U][A][G] = -0.800;
  dr_dangle_dg_ar[U][A][U] = -0.600;
  dr_dangle_dg_ar[U][G][A] = -0.800;
  dr_dangle_dg_ar[U][G][C] = -0.500;
  dr_dangle_dg_ar[U][G][G] = -0.800;
  dr_dangle_dg_ar[U][G][U] = -0.600;

}

void init_dl_dangle_dg_ar()
{
  int i,j,k;
  for(i=0;i<=ALPHASIZE;i++) for(j=0;j<ALPHASIZE;j++) for(k=0;k<ALPHASIZE;k++) dl_dangle_dg_ar[i][j][k] = 0;

  dl_dangle_dg_ar[A][A][U] = -0.300;
  dl_dangle_dg_ar[C][A][U] = -0.300;
  dl_dangle_dg_ar[G][A][U] = -0.400;
  dl_dangle_dg_ar[U][A][U] = -0.200;
  dl_dangle_dg_ar[A][C][G] = -0.500;
  dl_dangle_dg_ar[C][C][G] = -0.300;
  dl_dangle_dg_ar[G][C][G] = -0.200;
  dl_dangle_dg_ar[U][C][G] = -0.100;
  dl_dangle_dg_ar[A][G][C] = -0.200;
  dl_dangle_dg_ar[C][G][C] = -0.300;
  dl_dangle_dg_ar[G][G][C] =  0.000;
  dl_dangle_dg_ar[U][G][C] =  0.000;
  dl_dangle_dg_ar[A][G][U] = -0.300;
  dl_dangle_dg_ar[C][G][U] = -0.300;
  dl_dangle_dg_ar[G][G][U] = -0.400;
  dl_dangle_dg_ar[U][G][U] = -0.200;
  dl_dangle_dg_ar[A][U][A] = -0.300;
  dl_dangle_dg_ar[C][U][A] = -0.100;
  dl_dangle_dg_ar[G][U][A] = -0.200;
  dl_dangle_dg_ar[U][U][A] = -0.200;
  dl_dangle_dg_ar[A][U][G] = -0.300;
  dl_dangle_dg_ar[C][U][G] = -0.100;
  dl_dangle_dg_ar[G][U][G] = -0.200;
  dl_dangle_dg_ar[U][U][G] = -0.200;

}

void init_int11_ar()
{
  int k1,k2,k3,k4,k5,k6;

  for (k1=0;k1<ALPHASIZE;k1++)
    for (k2=0;k2<ALPHASIZE;k2++)
      for (k3=0;k3<ALPHASIZE;k3++)
         for (k4=0;k4<ALPHASIZE;k4++)
            for (k5=0;k5<ALPHASIZE;k5++)
               for (k6=0;k6<ALPHASIZE;k6++)
                  int11_ar[k1][k2][k3][k4][k5][k6]=0.0;

 int11_ar[A][U][A][A][A][U] =  1.700;
 int11_ar[A][U][A][C][A][U] =  1.700;
 int11_ar[A][U][A][G][A][U] =  1.700;
 int11_ar[A][U][A][U][A][U] =  1.700;
 int11_ar[A][U][C][A][A][U] =  1.700;
 int11_ar[A][U][C][C][A][U] =  1.700;
 int11_ar[A][U][C][G][A][U] =  1.700;
 int11_ar[A][U][C][U][A][U] =  1.700;
 int11_ar[A][U][G][A][A][U] =  1.700;
 int11_ar[A][U][G][C][A][U] =  1.700;
 int11_ar[A][U][G][G][A][U] = -0.400;
 int11_ar[A][U][G][U][A][U] =  1.700;
 int11_ar[A][U][U][A][A][U] =  1.700;
 int11_ar[A][U][U][C][A][U] =  1.700;
 int11_ar[A][U][U][G][A][U] =  1.700;
 int11_ar[A][U][U][U][A][U] =  1.200;
 int11_ar[A][U][A][A][C][G] =  1.100;
 int11_ar[A][U][A][C][C][G] =  1.100;
 int11_ar[A][U][A][G][C][G] =  1.100;
 int11_ar[A][U][A][U][C][G] =  1.100;
 int11_ar[A][U][C][A][C][G] =  1.100;
 int11_ar[A][U][C][C][C][G] =  1.100;
 int11_ar[A][U][C][G][C][G] =  1.100;
 int11_ar[A][U][C][U][C][G] =  1.100;
 int11_ar[A][U][G][A][C][G] =  1.100;
 int11_ar[A][U][G][C][C][G] =  1.100;
 int11_ar[A][U][G][G][C][G] = -1.000;
 int11_ar[A][U][G][U][C][G] =  1.100;
 int11_ar[A][U][U][A][C][G] =  1.100;
 int11_ar[A][U][U][C][C][G] =  1.100;
 int11_ar[A][U][U][G][C][G] =  1.100;
 int11_ar[A][U][U][U][C][G] =  1.100;
 int11_ar[A][U][A][A][G][C] =  1.100;
 int11_ar[A][U][A][C][G][C] =  1.100;
 int11_ar[A][U][A][G][G][C] =  1.100;
 int11_ar[A][U][A][U][G][C] =  1.100;
 int11_ar[A][U][C][A][G][C] =  1.100;
 int11_ar[A][U][C][C][G][C] =  1.100;
 int11_ar[A][U][C][G][G][C] =  1.100;
 int11_ar[A][U][C][U][G][C] =  1.100;
 int11_ar[A][U][G][A][G][C] =  1.100;
 int11_ar[A][U][G][C][G][C] =  1.100;
 int11_ar[A][U][G][G][G][C] = -1.000;
 int11_ar[A][U][G][U][G][C] =  1.100;
 int11_ar[A][U][U][A][G][C] =  1.100;
 int11_ar[A][U][U][C][G][C] =  1.100;
 int11_ar[A][U][U][G][G][C] =  1.100;
 int11_ar[A][U][U][U][G][C] =  1.000;
 int11_ar[A][U][A][A][G][U] =  1.700;
 int11_ar[A][U][A][C][G][U] =  1.700;
 int11_ar[A][U][A][G][G][U] =  1.700;
 int11_ar[A][U][A][U][G][U] =  1.700;
 int11_ar[A][U][C][A][G][U] =  1.700;
 int11_ar[A][U][C][C][G][U] =  1.700;
 int11_ar[A][U][C][G][G][U] =  1.700;
 int11_ar[A][U][C][U][G][U] =  1.700;
 int11_ar[A][U][G][A][G][U] =  1.700;
 int11_ar[A][U][G][C][G][U] =  1.700;
 int11_ar[A][U][G][G][G][U] = -0.400;
 int11_ar[A][U][G][U][G][U] =  1.700;
 int11_ar[A][U][U][A][G][U] =  1.700;
 int11_ar[A][U][U][C][G][U] =  1.700;
 int11_ar[A][U][U][G][G][U] =  1.700;
 int11_ar[A][U][U][U][G][U] =  1.700;
 int11_ar[A][U][A][A][U][A] =  1.700;
 int11_ar[A][U][A][C][U][A] =  1.700;
 int11_ar[A][U][A][G][U][A] =  1.700;
 int11_ar[A][U][A][U][U][A] =  1.700;
 int11_ar[A][U][C][A][U][A] =  1.700;
 int11_ar[A][U][C][C][U][A] =  1.700;
 int11_ar[A][U][C][G][U][A] =  1.700;
 int11_ar[A][U][C][U][U][A] =  1.700;
 int11_ar[A][U][G][A][U][A] =  1.700;
 int11_ar[A][U][G][C][U][A] =  1.700;
 int11_ar[A][U][G][G][U][A] = -0.400;
 int11_ar[A][U][G][U][U][A] =  1.700;
 int11_ar[A][U][U][A][U][A] =  1.700;
 int11_ar[A][U][U][C][U][A] =  1.700;
 int11_ar[A][U][U][G][U][A] =  1.700;
 int11_ar[A][U][U][U][U][A] =  1.500;
 int11_ar[A][U][A][A][U][G] =  1.700;
 int11_ar[A][U][A][C][U][G] =  1.700;
 int11_ar[A][U][A][G][U][G] =  1.700;
 int11_ar[A][U][A][U][U][G] =  1.700;
 int11_ar[A][U][C][A][U][G] =  1.700;
 int11_ar[A][U][C][C][U][G] =  1.700;
 int11_ar[A][U][C][G][U][G] =  1.700;
 int11_ar[A][U][C][U][U][G] =  1.700;
 int11_ar[A][U][G][A][U][G] =  1.700;
 int11_ar[A][U][G][C][U][G] =  1.700;
 int11_ar[A][U][G][G][U][G] = -0.400;
 int11_ar[A][U][G][U][U][G] =  1.700;
 int11_ar[A][U][U][A][U][G] =  1.700;
 int11_ar[A][U][U][C][U][G] =  1.700;
 int11_ar[A][U][U][G][U][G] =  1.700;
 int11_ar[A][U][U][U][U][G] =  1.700;
 int11_ar[C][G][A][A][A][U] =  1.100;
 int11_ar[C][G][A][C][A][U] =  1.100;
 int11_ar[C][G][A][G][A][U] =  1.100;
 int11_ar[C][G][A][U][A][U] =  1.100;
 int11_ar[C][G][C][A][A][U] =  1.100;
 int11_ar[C][G][C][C][A][U] =  1.100;
 int11_ar[C][G][C][G][A][U] =  1.100;
 int11_ar[C][G][C][U][A][U] =  1.100;
 int11_ar[C][G][G][A][A][U] =  1.100;
 int11_ar[C][G][G][C][A][U] =  1.100;
 int11_ar[C][G][G][G][A][U] = -1.000;
 int11_ar[C][G][G][U][A][U] =  1.100;
 int11_ar[C][G][U][A][A][U] =  1.100;
 int11_ar[C][G][U][C][A][U] =  1.100;
 int11_ar[C][G][U][G][A][U] =  1.100;
 int11_ar[C][G][U][U][A][U] =  1.100;
 int11_ar[C][G][A][A][C][G] =  1.100;
 int11_ar[C][G][A][C][C][G] =  0.400;
 int11_ar[C][G][A][G][C][G] =  0.400;
 int11_ar[C][G][A][U][C][G] =  0.400;
 int11_ar[C][G][C][A][C][G] =  0.400;
 int11_ar[C][G][C][C][C][G] =  0.400;
 int11_ar[C][G][C][G][C][G] =  0.400;
 int11_ar[C][G][C][U][C][G] =  0.400;
 int11_ar[C][G][G][A][C][G] =  0.400;
 int11_ar[C][G][G][C][C][G] =  0.400;
 int11_ar[C][G][G][G][C][G] = -1.400;
 int11_ar[C][G][G][U][C][G] =  0.400;
 int11_ar[C][G][U][A][C][G] =  0.400;
 int11_ar[C][G][U][C][C][G] =  0.400;
 int11_ar[C][G][U][G][C][G] =  0.400;
 int11_ar[C][G][U][U][C][G] =  0.400;
 int11_ar[C][G][A][A][G][C] =  0.400;
 int11_ar[C][G][A][C][G][C] = -0.400;
 int11_ar[C][G][A][G][G][C] =  0.400;
 int11_ar[C][G][A][U][G][C] =  0.400;
 int11_ar[C][G][C][A][G][C] =  0.300;
 int11_ar[C][G][C][C][G][C] =  0.500;
 int11_ar[C][G][C][G][G][C] =  0.400;
 int11_ar[C][G][C][U][G][C] =  0.500;
 int11_ar[C][G][G][A][G][C] = -0.100;
 int11_ar[C][G][G][C][G][C] =  0.400;
 int11_ar[C][G][G][G][G][C] = -1.700;
 int11_ar[C][G][G][U][G][C] =  0.400;
 int11_ar[C][G][U][A][G][C] =  0.400;
 int11_ar[C][G][U][C][G][C] =  0.000;
 int11_ar[C][G][U][G][G][C] =  0.400;
 int11_ar[C][G][U][U][G][C] = -0.300;
 int11_ar[C][G][A][A][G][U] =  1.100;
 int11_ar[C][G][A][C][G][U] =  1.100;
 int11_ar[C][G][A][G][G][U] =  1.100;
 int11_ar[C][G][A][U][G][U] =  1.100;
 int11_ar[C][G][C][A][G][U] =  1.100;
 int11_ar[C][G][C][C][G][U] =  1.100;
 int11_ar[C][G][C][G][G][U] =  1.100;
 int11_ar[C][G][C][U][G][U] =  1.100;
 int11_ar[C][G][G][A][G][U] =  1.100;
 int11_ar[C][G][G][C][G][U] =  1.100;
 int11_ar[C][G][G][G][G][U] = -1.000;
 int11_ar[C][G][G][U][G][U] =  1.100;
 int11_ar[C][G][U][A][G][U] =  1.100;
 int11_ar[C][G][U][C][G][U] =  1.100;
 int11_ar[C][G][U][G][G][U] =  1.100;
 int11_ar[C][G][U][U][G][U] =  1.100;
 int11_ar[C][G][A][A][U][A] =  1.100;
 int11_ar[C][G][A][C][U][A] =  1.100;
 int11_ar[C][G][A][G][U][A] =  1.100;
 int11_ar[C][G][A][U][U][A] =  1.100;
 int11_ar[C][G][C][A][U][A] =  1.100;
 int11_ar[C][G][C][C][U][A] =  1.100;
 int11_ar[C][G][C][G][U][A] =  1.100;
 int11_ar[C][G][C][U][U][A] =  1.100;
 int11_ar[C][G][G][A][U][A] =  1.100;
 int11_ar[C][G][G][C][U][A] =  1.100;
 int11_ar[C][G][G][G][U][A] = -1.000;
 int11_ar[C][G][G][U][U][A] =  1.100;
 int11_ar[C][G][U][A][U][A] =  1.100;
 int11_ar[C][G][U][C][U][A] =  1.100;
 int11_ar[C][G][U][G][U][A] =  1.100;
 int11_ar[C][G][U][U][U][A] =  1.100;
 int11_ar[C][G][A][A][U][G] =  1.100;
 int11_ar[C][G][A][C][U][G] =  1.100;
 int11_ar[C][G][A][G][U][G] =  1.100;
 int11_ar[C][G][A][U][U][G] =  1.100;
 int11_ar[C][G][C][A][U][G] =  1.100;
 int11_ar[C][G][C][C][U][G] =  1.100;
 int11_ar[C][G][C][G][U][G] =  1.100;
 int11_ar[C][G][C][U][U][G] =  1.100;
 int11_ar[C][G][G][A][U][G] =  1.100;
 int11_ar[C][G][G][C][U][G] =  1.100;
 int11_ar[C][G][G][G][U][G] = -1.000;
 int11_ar[C][G][G][U][U][G] =  1.100;
 int11_ar[C][G][U][A][U][G] =  1.100;
 int11_ar[C][G][U][C][U][G] =  1.100;
 int11_ar[C][G][U][G][U][G] =  1.100;
 int11_ar[C][G][U][U][U][G] =  1.100;
 int11_ar[G][C][A][A][A][U] =  1.100;
 int11_ar[G][C][A][C][A][U] =  1.100;
 int11_ar[G][C][A][G][A][U] =  1.100;
 int11_ar[G][C][A][U][A][U] =  1.100;
 int11_ar[G][C][C][A][A][U] =  1.100;
 int11_ar[G][C][C][C][A][U] =  1.100;
 int11_ar[G][C][C][G][A][U] =  1.100;
 int11_ar[G][C][C][U][A][U] =  1.100;
 int11_ar[G][C][G][A][A][U] =  1.100;
 int11_ar[G][C][G][C][A][U] =  1.100;
 int11_ar[G][C][G][G][A][U] = -1.000;
 int11_ar[G][C][G][U][A][U] =  1.100;
 int11_ar[G][C][U][A][A][U] =  1.100;
 int11_ar[G][C][U][C][A][U] =  1.100;
 int11_ar[G][C][U][G][A][U] =  1.100;
 int11_ar[G][C][U][U][A][U] =  1.000;
 int11_ar[G][C][A][A][C][G] =  0.400;
 int11_ar[G][C][A][C][C][G] =  0.300;
 int11_ar[G][C][A][G][C][G] = -0.100;
 int11_ar[G][C][A][U][C][G] =  0.400;
 int11_ar[G][C][C][A][C][G] = -0.400;
 int11_ar[G][C][C][C][C][G] =  0.500;
 int11_ar[G][C][C][G][C][G] =  0.400;
 int11_ar[G][C][C][U][C][G] =  0.000;
 int11_ar[G][C][G][A][C][G] =  0.400;
 int11_ar[G][C][G][C][C][G] =  0.400;
 int11_ar[G][C][G][G][C][G] = -1.700;
 int11_ar[G][C][G][U][C][G] =  0.400;
 int11_ar[G][C][U][A][C][G] =  0.400;
 int11_ar[G][C][U][C][C][G] =  0.500;
 int11_ar[G][C][U][G][C][G] =  0.400;
 int11_ar[G][C][U][U][C][G] = -0.300;
 int11_ar[G][C][A][A][G][C] =  0.800;
 int11_ar[G][C][A][C][G][C] =  0.400;
 int11_ar[G][C][A][G][G][C] =  0.400;
 int11_ar[G][C][A][U][G][C] =  0.400;
 int11_ar[G][C][C][A][G][C] =  0.400;
 int11_ar[G][C][C][C][G][C] =  0.400;
 int11_ar[G][C][C][G][G][C] =  0.400;
 int11_ar[G][C][C][U][G][C] =  0.400;
 int11_ar[G][C][G][A][G][C] =  0.400;
 int11_ar[G][C][G][C][G][C] =  0.400;
 int11_ar[G][C][G][G][G][C] = -2.100;
 int11_ar[G][C][G][U][G][C] =  0.400;
 int11_ar[G][C][U][A][G][C] =  0.400;
 int11_ar[G][C][U][C][G][C] =  0.400;
 int11_ar[G][C][U][G][G][C] =  0.400;
 int11_ar[G][C][U][U][G][C] = -0.700;
 int11_ar[G][C][A][A][G][U] =  1.100;
 int11_ar[G][C][A][C][G][U] =  1.100;
 int11_ar[G][C][A][G][G][U] =  1.100;
 int11_ar[G][C][A][U][G][U] =  1.100;
 int11_ar[G][C][C][A][G][U] =  1.100;
 int11_ar[G][C][C][C][G][U] =  1.100;
 int11_ar[G][C][C][G][G][U] =  1.100;
 int11_ar[G][C][C][U][G][U] =  1.100;
 int11_ar[G][C][G][A][G][U] =  1.100;
 int11_ar[G][C][G][C][G][U] =  1.100;
 int11_ar[G][C][G][G][G][U] = -1.000;
 int11_ar[G][C][G][U][G][U] =  1.100;
 int11_ar[G][C][U][A][G][U] =  1.100;
 int11_ar[G][C][U][C][G][U] =  1.100;
 int11_ar[G][C][U][G][G][U] =  1.100;
 int11_ar[G][C][U][U][G][U] =  1.100;
 int11_ar[G][C][A][A][U][A] =  1.100;
 int11_ar[G][C][A][C][U][A] =  1.100;
 int11_ar[G][C][A][G][U][A] =  1.100;
 int11_ar[G][C][A][U][U][A] =  1.100;
 int11_ar[G][C][C][A][U][A] =  1.100;
 int11_ar[G][C][C][C][U][A] =  1.100;
 int11_ar[G][C][C][G][U][A] =  1.100;
 int11_ar[G][C][C][U][U][A] =  1.100;
 int11_ar[G][C][G][A][U][A] =  1.100;
 int11_ar[G][C][G][C][U][A] =  1.100;
 int11_ar[G][C][G][G][U][A] = -1.000;
 int11_ar[G][C][G][U][U][A] =  1.100;
 int11_ar[G][C][U][A][U][A] =  1.100;
 int11_ar[G][C][U][C][U][A] =  1.100;
 int11_ar[G][C][U][G][U][A] =  1.100;
 int11_ar[G][C][U][U][U][A] =  1.100;
 int11_ar[G][C][A][A][U][G] =  1.100;
 int11_ar[G][C][A][C][U][G] =  1.100;
 int11_ar[G][C][A][G][U][G] =  1.100;
 int11_ar[G][C][A][U][U][G] =  1.100;
 int11_ar[G][C][C][A][U][G] =  1.100;
 int11_ar[G][C][C][C][U][G] =  1.100;
 int11_ar[G][C][C][G][U][G] =  1.100;
 int11_ar[G][C][C][U][U][G] =  1.100;
 int11_ar[G][C][G][A][U][G] =  1.100;
 int11_ar[G][C][G][C][U][G] =  1.100;
 int11_ar[G][C][G][G][U][G] = -1.000;
 int11_ar[G][C][G][U][U][G] =  1.100;
 int11_ar[G][C][U][A][U][G] =  1.100;
 int11_ar[G][C][U][C][U][G] =  1.100;
 int11_ar[G][C][U][G][U][G] =  1.100;
 int11_ar[G][C][U][U][U][G] =  1.100;
 int11_ar[G][U][A][A][A][U] =  1.700;
 int11_ar[G][U][A][C][A][U] =  1.700;
 int11_ar[G][U][A][G][A][U] =  1.700;
 int11_ar[G][U][A][U][A][U] =  1.700;
 int11_ar[G][U][C][A][A][U] =  1.700;
 int11_ar[G][U][C][C][A][U] =  1.700;
 int11_ar[G][U][C][G][A][U] =  1.700;
 int11_ar[G][U][C][U][A][U] =  1.700;
 int11_ar[G][U][G][A][A][U] =  1.700;
 int11_ar[G][U][G][C][A][U] =  1.700;
 int11_ar[G][U][G][G][A][U] = -0.400;
 int11_ar[G][U][G][U][A][U] =  1.700;
 int11_ar[G][U][U][A][A][U] =  1.700;
 int11_ar[G][U][U][C][A][U] =  1.700;
 int11_ar[G][U][U][G][A][U] =  1.700;
 int11_ar[G][U][U][U][A][U] =  1.700;
 int11_ar[G][U][A][A][C][G] =  1.100;
 int11_ar[G][U][A][C][C][G] =  1.100;
 int11_ar[G][U][A][G][C][G] =  1.100;
 int11_ar[G][U][A][U][C][G] =  1.100;
 int11_ar[G][U][C][A][C][G] =  1.100;
 int11_ar[G][U][C][C][C][G] =  1.100;
 int11_ar[G][U][C][G][C][G] =  1.100;
 int11_ar[G][U][C][U][C][G] =  1.100;
 int11_ar[G][U][G][A][C][G] =  1.100;
 int11_ar[G][U][G][C][C][G] =  1.100;
 int11_ar[G][U][G][G][C][G] = -1.000;
 int11_ar[G][U][G][U][C][G] =  1.100;
 int11_ar[G][U][U][A][C][G] =  1.100;
 int11_ar[G][U][U][C][C][G] =  1.100;
 int11_ar[G][U][U][G][C][G] =  1.100;
 int11_ar[G][U][U][U][C][G] =  1.100;
 int11_ar[G][U][A][A][G][C] =  1.100;
 int11_ar[G][U][A][C][G][C] =  1.100;
 int11_ar[G][U][A][G][G][C] =  1.100;
 int11_ar[G][U][A][U][G][C] =  1.100;
 int11_ar[G][U][C][A][G][C] =  1.100;
 int11_ar[G][U][C][C][G][C] =  1.100;
 int11_ar[G][U][C][G][G][C] =  1.100;
 int11_ar[G][U][C][U][G][C] =  1.100;
 int11_ar[G][U][G][A][G][C] =  1.100;
 int11_ar[G][U][G][C][G][C] =  1.100;
 int11_ar[G][U][G][G][G][C] = -1.000;
 int11_ar[G][U][G][U][G][C] =  1.100;
 int11_ar[G][U][U][A][G][C] =  1.100;
 int11_ar[G][U][U][C][G][C] =  1.100;
 int11_ar[G][U][U][G][G][C] =  1.100;
 int11_ar[G][U][U][U][G][C] =  1.100;
 int11_ar[G][U][A][A][G][U] =  1.700;
 int11_ar[G][U][A][C][G][U] =  1.700;
 int11_ar[G][U][A][G][G][U] =  1.700;
 int11_ar[G][U][A][U][G][U] =  1.700;
 int11_ar[G][U][C][A][G][U] =  1.700;
 int11_ar[G][U][C][C][G][U] =  1.700;
 int11_ar[G][U][C][G][G][U] =  1.700;
 int11_ar[G][U][C][U][G][U] =  1.700;
 int11_ar[G][U][G][A][G][U] =  1.700;
 int11_ar[G][U][G][C][G][U] =  1.700;
 int11_ar[G][U][G][G][G][U] = -0.400;
 int11_ar[G][U][G][U][G][U] =  1.700;
 int11_ar[G][U][U][A][G][U] =  1.700;
 int11_ar[G][U][U][C][G][U] =  1.700;
 int11_ar[G][U][U][G][G][U] =  1.700;
 int11_ar[G][U][U][U][G][U] =  1.700;
 int11_ar[G][U][A][A][U][A] =  1.700;
 int11_ar[G][U][A][C][U][A] =  1.700;
 int11_ar[G][U][A][G][U][A] =  1.700;
 int11_ar[G][U][A][U][U][A] =  1.700;
 int11_ar[G][U][C][A][U][A] =  1.700;
 int11_ar[G][U][C][C][U][A] =  1.700;
 int11_ar[G][U][C][G][U][A] =  1.700;
 int11_ar[G][U][C][U][U][A] =  1.700;
 int11_ar[G][U][G][A][U][A] =  1.700;
 int11_ar[G][U][G][C][U][A] =  1.700;
 int11_ar[G][U][G][G][U][A] = -0.400;
 int11_ar[G][U][G][U][U][A] =  1.700;
 int11_ar[G][U][U][A][U][A] =  1.700;
 int11_ar[G][U][U][C][U][A] =  1.700;
 int11_ar[G][U][U][G][U][A] =  1.700;
 int11_ar[G][U][U][U][U][A] =  1.700;
 int11_ar[G][U][A][A][U][G] =  1.700;
 int11_ar[G][U][A][C][U][G] =  1.700;
 int11_ar[G][U][A][G][U][G] =  1.700;
 int11_ar[G][U][A][U][U][G] =  1.700;
 int11_ar[G][U][C][A][U][G] =  1.700;
 int11_ar[G][U][C][C][U][G] =  1.700;
 int11_ar[G][U][C][G][U][G] =  1.700;
 int11_ar[G][U][C][U][U][G] =  1.700;
 int11_ar[G][U][G][A][U][G] =  1.700;
 int11_ar[G][U][G][C][U][G] =  1.700;
 int11_ar[G][U][G][G][U][G] = -0.400;
 int11_ar[G][U][G][U][U][G] =  1.700;
 int11_ar[G][U][U][A][U][G] =  1.700;
 int11_ar[G][U][U][C][U][G] =  1.700;
 int11_ar[G][U][U][G][U][G] =  1.700;
 int11_ar[G][U][U][U][U][G] =  1.700;
 int11_ar[U][A][A][A][A][U] =  1.700;
 int11_ar[U][A][A][C][A][U] =  1.700;
 int11_ar[U][A][A][G][A][U] =  1.700;
 int11_ar[U][A][A][U][A][U] =  1.700;
 int11_ar[U][A][C][A][A][U] =  1.700;
 int11_ar[U][A][C][C][A][U] =  1.700;
 int11_ar[U][A][C][G][A][U] =  1.700;
 int11_ar[U][A][C][U][A][U] =  1.700;
 int11_ar[U][A][G][A][A][U] =  1.700;
 int11_ar[U][A][G][C][A][U] =  1.700;
 int11_ar[U][A][G][G][A][U] = -0.400;
 int11_ar[U][A][G][U][A][U] =  1.700;
 int11_ar[U][A][U][A][A][U] =  1.700;
 int11_ar[U][A][U][C][A][U] =  1.700;
 int11_ar[U][A][U][G][A][U] =  1.700;
 int11_ar[U][A][U][U][A][U] =  1.500;
 int11_ar[U][A][A][A][C][G] =  1.100;
 int11_ar[U][A][A][C][C][G] =  1.100;
 int11_ar[U][A][A][G][C][G] =  1.100;
 int11_ar[U][A][A][U][C][G] =  1.100;
 int11_ar[U][A][C][A][C][G] =  1.100;
 int11_ar[U][A][C][C][C][G] =  1.100;
 int11_ar[U][A][C][G][C][G] =  1.100;
 int11_ar[U][A][C][U][C][G] =  1.100;
 int11_ar[U][A][G][A][C][G] =  1.100;
 int11_ar[U][A][G][C][C][G] =  1.100;
 int11_ar[U][A][G][G][C][G] = -1.000;
 int11_ar[U][A][G][U][C][G] =  1.100;
 int11_ar[U][A][U][A][C][G] =  1.100;
 int11_ar[U][A][U][C][C][G] =  1.100;
 int11_ar[U][A][U][G][C][G] =  1.100;
 int11_ar[U][A][U][U][C][G] =  1.100;
 int11_ar[U][A][A][A][G][C] =  1.100;
 int11_ar[U][A][A][C][G][C] =  1.100;
 int11_ar[U][A][A][G][G][C] =  1.100;
 int11_ar[U][A][A][U][G][C] =  1.100;
 int11_ar[U][A][C][A][G][C] =  1.100;
 int11_ar[U][A][C][C][G][C] =  1.100;
 int11_ar[U][A][C][G][G][C] =  1.100;
 int11_ar[U][A][C][U][G][C] =  1.100;
 int11_ar[U][A][G][A][G][C] =  1.100;
 int11_ar[U][A][G][C][G][C] =  1.100;
 int11_ar[U][A][G][G][G][C] = -1.000;
 int11_ar[U][A][G][U][G][C] =  1.100;
 int11_ar[U][A][U][A][G][C] =  1.100;
 int11_ar[U][A][U][C][G][C] =  1.100;
 int11_ar[U][A][U][G][G][C] =  1.100;
 int11_ar[U][A][U][U][G][C] =  1.100;
 int11_ar[U][A][A][A][G][U] =  1.700;
 int11_ar[U][A][A][C][G][U] =  1.700;
 int11_ar[U][A][A][G][G][U] =  1.700;
 int11_ar[U][A][A][U][G][U] =  1.700;
 int11_ar[U][A][C][A][G][U] =  1.700;
 int11_ar[U][A][C][C][G][U] =  1.700;
 int11_ar[U][A][C][G][G][U] =  1.700;
 int11_ar[U][A][C][U][G][U] =  1.700;
 int11_ar[U][A][G][A][G][U] =  1.700;
 int11_ar[U][A][G][C][G][U] =  1.700;
 int11_ar[U][A][G][G][G][U] = -0.400;
 int11_ar[U][A][G][U][G][U] =  1.700;
 int11_ar[U][A][U][A][G][U] =  1.700;
 int11_ar[U][A][U][C][G][U] =  1.700;
 int11_ar[U][A][U][G][G][U] =  1.700;
 int11_ar[U][A][U][U][G][U] =  1.700;
 int11_ar[U][A][A][A][U][A] =  1.700;
 int11_ar[U][A][A][C][U][A] =  1.700;
 int11_ar[U][A][A][G][U][A] =  1.700;
 int11_ar[U][A][A][U][U][A] =  1.700;
 int11_ar[U][A][C][A][U][A] =  1.700;
 int11_ar[U][A][C][C][U][A] =  1.700;
 int11_ar[U][A][C][G][U][A] =  1.700;
 int11_ar[U][A][C][U][U][A] =  1.700;
 int11_ar[U][A][G][A][U][A] =  1.700;
 int11_ar[U][A][G][C][U][A] =  1.700;
 int11_ar[U][A][G][G][U][A] = -0.400;
 int11_ar[U][A][G][U][U][A] =  1.700;
 int11_ar[U][A][U][A][U][A] =  1.700;
 int11_ar[U][A][U][C][U][A] =  1.700;
 int11_ar[U][A][U][G][U][A] =  1.700;
 int11_ar[U][A][U][U][U][A] =  1.800;
 int11_ar[U][A][A][A][U][G] =  1.700;
 int11_ar[U][A][A][C][U][G] =  1.700;
 int11_ar[U][A][A][G][U][G] =  1.700;
 int11_ar[U][A][A][U][U][G] =  1.700;
 int11_ar[U][A][C][A][U][G] =  1.700;
 int11_ar[U][A][C][C][U][G] =  1.700;
 int11_ar[U][A][C][G][U][G] =  1.700;
 int11_ar[U][A][C][U][U][G] =  1.700;
 int11_ar[U][A][G][A][U][G] =  1.700;
 int11_ar[U][A][G][C][U][G] =  1.700;
 int11_ar[U][A][G][G][U][G] = -0.400;
 int11_ar[U][A][G][U][U][G] =  1.700;
 int11_ar[U][A][U][A][U][G] =  1.700;
 int11_ar[U][A][U][C][U][G] =  1.700;
 int11_ar[U][A][U][G][U][G] =  1.700;
 int11_ar[U][A][U][U][U][G] =  1.700;
 int11_ar[U][G][A][A][A][U] =  1.700;
 int11_ar[U][G][A][C][A][U] =  1.700;
 int11_ar[U][G][A][G][A][U] =  1.700;
 int11_ar[U][G][A][U][A][U] =  1.700;
 int11_ar[U][G][C][A][A][U] =  1.700;
 int11_ar[U][G][C][C][A][U] =  1.700;
 int11_ar[U][G][C][G][A][U] =  1.700;
 int11_ar[U][G][C][U][A][U] =  1.700;
 int11_ar[U][G][G][A][A][U] =  1.700;
 int11_ar[U][G][G][C][A][U] =  1.700;
 int11_ar[U][G][G][G][A][U] = -0.400;
 int11_ar[U][G][G][U][A][U] =  1.700;
 int11_ar[U][G][U][A][A][U] =  1.700;
 int11_ar[U][G][U][C][A][U] =  1.700;
 int11_ar[U][G][U][G][A][U] =  1.700;
 int11_ar[U][G][U][U][A][U] =  1.700;
 int11_ar[U][G][A][A][C][G] =  1.100;
 int11_ar[U][G][A][C][C][G] =  1.100;
 int11_ar[U][G][A][G][C][G] =  1.100;
 int11_ar[U][G][A][U][C][G] =  1.100;
 int11_ar[U][G][C][A][C][G] =  1.100;
 int11_ar[U][G][C][C][C][G] =  1.100;
 int11_ar[U][G][C][G][C][G] =  1.100;
 int11_ar[U][G][C][U][C][G] =  1.100;
 int11_ar[U][G][G][A][C][G] =  1.100;
 int11_ar[U][G][G][C][C][G] =  1.100;
 int11_ar[U][G][G][G][C][G] = -1.000;
 int11_ar[U][G][G][U][C][G] =  1.100;
 int11_ar[U][G][U][A][C][G] =  1.100;
 int11_ar[U][G][U][C][C][G] =  1.100;
 int11_ar[U][G][U][G][C][G] =  1.100;
 int11_ar[U][G][U][U][C][G] =  1.100;
 int11_ar[U][G][A][A][G][C] =  1.100;
 int11_ar[U][G][A][C][G][C] =  1.100;
 int11_ar[U][G][A][G][G][C] =  1.100;
 int11_ar[U][G][A][U][G][C] =  1.100;
 int11_ar[U][G][C][A][G][C] =  1.100;
 int11_ar[U][G][C][C][G][C] =  1.100;
 int11_ar[U][G][C][G][G][C] =  1.100;
 int11_ar[U][G][C][U][G][C] =  1.100;
 int11_ar[U][G][G][A][G][C] =  1.100;
 int11_ar[U][G][G][C][G][C] =  1.100;
 int11_ar[U][G][G][G][G][C] = -1.000;
 int11_ar[U][G][G][U][G][C] =  1.100;
 int11_ar[U][G][U][A][G][C] =  1.100;
 int11_ar[U][G][U][C][G][C] =  1.100;
 int11_ar[U][G][U][G][G][C] =  1.100;
 int11_ar[U][G][U][U][G][C] =  1.100;
 int11_ar[U][G][A][A][G][U] =  1.700;
 int11_ar[U][G][A][C][G][U] =  1.700;
 int11_ar[U][G][A][G][G][U] =  1.700;
 int11_ar[U][G][A][U][G][U] =  1.700;
 int11_ar[U][G][C][A][G][U] =  1.700;
 int11_ar[U][G][C][C][G][U] =  1.700;
 int11_ar[U][G][C][G][G][U] =  1.700;
 int11_ar[U][G][C][U][G][U] =  1.700;
 int11_ar[U][G][G][A][G][U] =  1.700;
 int11_ar[U][G][G][C][G][U] =  1.700;
 int11_ar[U][G][G][G][G][U] = -0.400;
 int11_ar[U][G][G][U][G][U] =  1.700;
 int11_ar[U][G][U][A][G][U] =  1.700;
 int11_ar[U][G][U][C][G][U] =  1.700;
 int11_ar[U][G][U][G][G][U] =  1.700;
 int11_ar[U][G][U][U][G][U] =  1.700;
 int11_ar[U][G][A][A][U][A] =  1.700;
 int11_ar[U][G][A][C][U][A] =  1.700;
 int11_ar[U][G][A][G][U][A] =  1.700;
 int11_ar[U][G][A][U][U][A] =  1.700;
 int11_ar[U][G][C][A][U][A] =  1.700;
 int11_ar[U][G][C][C][U][A] =  1.700;
 int11_ar[U][G][C][G][U][A] =  1.700;
 int11_ar[U][G][C][U][U][A] =  1.700;
 int11_ar[U][G][G][A][U][A] =  1.700;
 int11_ar[U][G][G][C][U][A] =  1.700;
 int11_ar[U][G][G][G][U][A] = -0.400;
 int11_ar[U][G][G][U][U][A] =  1.700;
 int11_ar[U][G][U][A][U][A] =  1.700;
 int11_ar[U][G][U][C][U][A] =  1.700;
 int11_ar[U][G][U][G][U][A] =  1.700;
 int11_ar[U][G][U][U][U][A] =  1.700;
 int11_ar[U][G][A][A][U][G] =  1.700;
 int11_ar[U][G][A][C][U][G] =  1.700;
 int11_ar[U][G][A][G][U][G] =  1.700;
 int11_ar[U][G][A][U][U][G] =  1.700;
 int11_ar[U][G][C][A][U][G] =  1.700;
 int11_ar[U][G][C][C][U][G] =  1.700;
 int11_ar[U][G][C][G][U][G] =  1.700;
 int11_ar[U][G][C][U][U][G] =  1.700;
 int11_ar[U][G][G][A][U][G] =  1.700;
 int11_ar[U][G][G][C][U][G] =  1.700;
 int11_ar[U][G][G][G][U][G] = -0.400;
 int11_ar[U][G][G][U][U][G] =  1.700;
 int11_ar[U][G][U][A][U][G] =  1.700;
 int11_ar[U][G][U][C][U][G] =  1.700;
 int11_ar[U][G][U][G][U][G] =  1.700;
 int11_ar[U][G][U][U][U][G] =  1.700;
}

void init_int21_ar()
{
  int k1,k2,k3,k4,k5,k6,k7;

  for (k1=0;k1<ALPHASIZE;k1++)
    for (k2=0;k2<ALPHASIZE;k2++)
      for (k3=0;k3<ALPHASIZE;k3++)
         for (k4=0;k4<ALPHASIZE;k4++)
            for (k5=0;k5<ALPHASIZE;k5++)
               for (k6=0;k6<ALPHASIZE;k6++)
                 for (k7=0;k7<ALPHASIZE;k7++)
                    int21_ar[k1][k2][k3][k4][k5][k6][k7]=0.0;

 int21_ar[A][U][A][A][A][A][U] =  3.900;
 int21_ar[A][U][A][A][C][A][U] =  3.700;
 int21_ar[A][U][A][A][G][A][U] =  3.100;
 int21_ar[A][U][A][A][U][A][U] =  5.500;
 int21_ar[A][U][A][C][A][A][U] =  3.600;
 int21_ar[A][U][A][C][C][A][U] =  3.200;
 int21_ar[A][U][A][C][G][A][U] =  3.100;
 int21_ar[A][U][A][C][U][A][U] =  5.500;
 int21_ar[A][U][A][G][A][A][U] =  2.500;
 int21_ar[A][U][A][G][C][A][U] =  2.100;
 int21_ar[A][U][A][G][G][A][U] =  1.900;
 int21_ar[A][U][A][G][U][A][U] =  5.500;
 int21_ar[A][U][A][U][A][A][U] =  5.500;
 int21_ar[A][U][A][U][C][A][U] =  5.500;
 int21_ar[A][U][A][U][G][A][U] =  5.500;
 int21_ar[A][U][A][U][U][A][U] =  5.500;
 int21_ar[A][U][C][A][A][A][U] =  3.800;
 int21_ar[A][U][C][A][C][A][U] =  3.700;
 int21_ar[A][U][C][A][G][A][U] =  5.500;
 int21_ar[A][U][C][A][U][A][U] =  3.700;
 int21_ar[A][U][C][C][A][A][U] =  3.700;
 int21_ar[A][U][C][C][C][A][U] =  4.000;
 int21_ar[A][U][C][C][G][A][U] =  5.500;
 int21_ar[A][U][C][C][U][A][U] =  3.700;
 int21_ar[A][U][C][G][A][A][U] =  5.500;
 int21_ar[A][U][C][G][C][A][U] =  5.500;
 int21_ar[A][U][C][G][G][A][U] =  5.500;
 int21_ar[A][U][C][G][U][A][U] =  5.500;
 int21_ar[A][U][C][U][A][A][U] =  4.000;
 int21_ar[A][U][C][U][C][A][U] =  3.400;
 int21_ar[A][U][C][U][G][A][U] =  5.500;
 int21_ar[A][U][C][U][U][A][U] =  3.700;
 int21_ar[A][U][G][A][A][A][U] =  3.200;
 int21_ar[A][U][G][A][C][A][U] =  5.500;
 int21_ar[A][U][G][A][G][A][U] =  2.300;
 int21_ar[A][U][G][A][U][A][U] =  5.500;
 int21_ar[A][U][G][C][A][A][U] =  5.500;
 int21_ar[A][U][G][C][C][A][U] =  5.500;
 int21_ar[A][U][G][C][G][A][U] =  5.500;
 int21_ar[A][U][G][C][U][A][U] =  5.500;
 int21_ar[A][U][G][G][A][A][U] =  2.300;
 int21_ar[A][U][G][G][C][A][U] =  5.500;
 int21_ar[A][U][G][G][G][A][U] =  3.700;
 int21_ar[A][U][G][G][U][A][U] =  5.500;
 int21_ar[A][U][G][U][A][A][U] =  5.500;
 int21_ar[A][U][G][U][C][A][U] =  5.500;
 int21_ar[A][U][G][U][G][A][U] =  5.500;
 int21_ar[A][U][G][U][U][A][U] =  5.500;
 int21_ar[A][U][U][A][A][A][U] =  5.500;
 int21_ar[A][U][U][A][C][A][U] =  5.500;
 int21_ar[A][U][U][A][G][A][U] =  5.500;
 int21_ar[A][U][U][A][U][A][U] =  5.500;
 int21_ar[A][U][U][C][A][A][U] =  5.500;
 int21_ar[A][U][U][C][C][A][U] =  3.700;
 int21_ar[A][U][U][C][G][A][U] =  5.500;
 int21_ar[A][U][U][C][U][A][U] =  2.800;
 int21_ar[A][U][U][G][A][A][U] =  5.500;
 int21_ar[A][U][U][G][C][A][U] =  5.500;
 int21_ar[A][U][U][G][G][A][U] =  5.500;
 int21_ar[A][U][U][G][U][A][U] =  5.500;
 int21_ar[A][U][U][U][A][A][U] =  5.500;
 int21_ar[A][U][U][U][C][A][U] =  3.200;
 int21_ar[A][U][U][U][G][A][U] =  5.500;
 int21_ar[A][U][U][U][U][A][U] =  2.700;
 int21_ar[A][U][A][A][A][C][G] =  3.200;
 int21_ar[A][U][A][A][C][C][G] =  3.000;
 int21_ar[A][U][A][A][G][C][G] =  2.400;
 int21_ar[A][U][A][A][U][C][G] =  4.800;
 int21_ar[A][U][A][C][A][C][G] =  2.900;
 int21_ar[A][U][A][C][C][C][G] =  2.500;
 int21_ar[A][U][A][C][G][C][G] =  2.400;
 int21_ar[A][U][A][C][U][C][G] =  4.800;
 int21_ar[A][U][A][G][A][C][G] =  1.800;
 int21_ar[A][U][A][G][C][C][G] =  1.400;
 int21_ar[A][U][A][G][G][C][G] =  1.200;
 int21_ar[A][U][A][G][U][C][G] =  4.800;
 int21_ar[A][U][A][U][A][C][G] =  4.800;
 int21_ar[A][U][A][U][C][C][G] =  4.800;
 int21_ar[A][U][A][U][G][C][G] =  4.800;
 int21_ar[A][U][A][U][U][C][G] =  4.800;
 int21_ar[A][U][C][A][A][C][G] =  3.100;
 int21_ar[A][U][C][A][C][C][G] =  3.000;
 int21_ar[A][U][C][A][G][C][G] =  4.800;
 int21_ar[A][U][C][A][U][C][G] =  3.000;
 int21_ar[A][U][C][C][A][C][G] =  3.000;
 int21_ar[A][U][C][C][C][C][G] =  3.300;
 int21_ar[A][U][C][C][G][C][G] =  4.800;
 int21_ar[A][U][C][C][U][C][G] =  3.000;
 int21_ar[A][U][C][G][A][C][G] =  4.800;
 int21_ar[A][U][C][G][C][C][G] =  4.800;
 int21_ar[A][U][C][G][G][C][G] =  4.800;
 int21_ar[A][U][C][G][U][C][G] =  4.800;
 int21_ar[A][U][C][U][A][C][G] =  3.300;
 int21_ar[A][U][C][U][C][C][G] =  2.700;
 int21_ar[A][U][C][U][G][C][G] =  4.800;
 int21_ar[A][U][C][U][U][C][G] =  3.000;
 int21_ar[A][U][G][A][A][C][G] =  2.500;
 int21_ar[A][U][G][A][C][C][G] =  4.800;
 int21_ar[A][U][G][A][G][C][G] =  1.600;
 int21_ar[A][U][G][A][U][C][G] =  4.800;
 int21_ar[A][U][G][C][A][C][G] =  4.800;
 int21_ar[A][U][G][C][C][C][G] =  4.800;
 int21_ar[A][U][G][C][G][C][G] =  4.800;
 int21_ar[A][U][G][C][U][C][G] =  4.800;
 int21_ar[A][U][G][G][A][C][G] =  1.600;
 int21_ar[A][U][G][G][C][C][G] =  4.800;
 int21_ar[A][U][G][G][G][C][G] =  3.000;
 int21_ar[A][U][G][G][U][C][G] =  4.800;
 int21_ar[A][U][G][U][A][C][G] =  4.800;
 int21_ar[A][U][G][U][C][C][G] =  4.800;
 int21_ar[A][U][G][U][G][C][G] =  4.800;
 int21_ar[A][U][G][U][U][C][G] =  4.800;
 int21_ar[A][U][U][A][A][C][G] =  4.800;
 int21_ar[A][U][U][A][C][C][G] =  4.800;
 int21_ar[A][U][U][A][G][C][G] =  4.800;
 int21_ar[A][U][U][A][U][C][G] =  4.800;
 int21_ar[A][U][U][C][A][C][G] =  4.800;
 int21_ar[A][U][U][C][C][C][G] =  3.000;
 int21_ar[A][U][U][C][G][C][G] =  4.800;
 int21_ar[A][U][U][C][U][C][G] =  2.100;
 int21_ar[A][U][U][G][A][C][G] =  4.800;
 int21_ar[A][U][U][G][C][C][G] =  4.800;
 int21_ar[A][U][U][G][G][C][G] =  4.800;
 int21_ar[A][U][U][G][U][C][G] =  4.800;
 int21_ar[A][U][U][U][A][C][G] =  4.800;
 int21_ar[A][U][U][U][C][C][G] =  2.500;
 int21_ar[A][U][U][U][G][C][G] =  4.800;
 int21_ar[A][U][U][U][U][C][G] =  2.000;
 int21_ar[A][U][A][A][A][G][C] =  3.200;
 int21_ar[A][U][A][A][C][G][C] =  3.000;
 int21_ar[A][U][A][A][G][G][C] =  2.400;
 int21_ar[A][U][A][A][U][G][C] =  4.800;
 int21_ar[A][U][A][C][A][G][C] =  2.900;
 int21_ar[A][U][A][C][C][G][C] =  2.500;
 int21_ar[A][U][A][C][G][G][C] =  2.400;
 int21_ar[A][U][A][C][U][G][C] =  4.800;
 int21_ar[A][U][A][G][A][G][C] =  1.800;
 int21_ar[A][U][A][G][C][G][C] =  1.400;
 int21_ar[A][U][A][G][G][G][C] =  1.200;
 int21_ar[A][U][A][G][U][G][C] =  4.800;
 int21_ar[A][U][A][U][A][G][C] =  4.800;
 int21_ar[A][U][A][U][C][G][C] =  4.800;
 int21_ar[A][U][A][U][G][G][C] =  4.800;
 int21_ar[A][U][A][U][U][G][C] =  4.800;
 int21_ar[A][U][C][A][A][G][C] =  3.100;
 int21_ar[A][U][C][A][C][G][C] =  3.000;
 int21_ar[A][U][C][A][G][G][C] =  4.800;
 int21_ar[A][U][C][A][U][G][C] =  3.000;
 int21_ar[A][U][C][C][A][G][C] =  3.000;
 int21_ar[A][U][C][C][C][G][C] =  3.300;
 int21_ar[A][U][C][C][G][G][C] =  4.800;
 int21_ar[A][U][C][C][U][G][C] =  3.000;
 int21_ar[A][U][C][G][A][G][C] =  4.800;
 int21_ar[A][U][C][G][C][G][C] =  4.800;
 int21_ar[A][U][C][G][G][G][C] =  4.800;
 int21_ar[A][U][C][G][U][G][C] =  4.800;
 int21_ar[A][U][C][U][A][G][C] =  3.300;
 int21_ar[A][U][C][U][C][G][C] =  2.700;
 int21_ar[A][U][C][U][G][G][C] =  4.800;
 int21_ar[A][U][C][U][U][G][C] =  3.000;
 int21_ar[A][U][G][A][A][G][C] =  2.500;
 int21_ar[A][U][G][A][C][G][C] =  4.800;
 int21_ar[A][U][G][A][G][G][C] =  1.600;
 int21_ar[A][U][G][A][U][G][C] =  4.800;
 int21_ar[A][U][G][C][A][G][C] =  4.800;
 int21_ar[A][U][G][C][C][G][C] =  4.800;
 int21_ar[A][U][G][C][G][G][C] =  4.800;
 int21_ar[A][U][G][C][U][G][C] =  4.800;
 int21_ar[A][U][G][G][A][G][C] =  1.600;
 int21_ar[A][U][G][G][C][G][C] =  4.800;
 int21_ar[A][U][G][G][G][G][C] =  3.000;
 int21_ar[A][U][G][G][U][G][C] =  4.800;
 int21_ar[A][U][G][U][A][G][C] =  4.800;
 int21_ar[A][U][G][U][C][G][C] =  4.800;
 int21_ar[A][U][G][U][G][G][C] =  4.800;
 int21_ar[A][U][G][U][U][G][C] =  4.800;
 int21_ar[A][U][U][A][A][G][C] =  4.800;
 int21_ar[A][U][U][A][C][G][C] =  4.800;
 int21_ar[A][U][U][A][G][G][C] =  4.800;
 int21_ar[A][U][U][A][U][G][C] =  4.800;
 int21_ar[A][U][U][C][A][G][C] =  4.800;
 int21_ar[A][U][U][C][C][G][C] =  3.000;
 int21_ar[A][U][U][C][G][G][C] =  4.800;
 int21_ar[A][U][U][C][U][G][C] =  2.100;
 int21_ar[A][U][U][G][A][G][C] =  4.800;
 int21_ar[A][U][U][G][C][G][C] =  4.800;
 int21_ar[A][U][U][G][G][G][C] =  4.800;
 int21_ar[A][U][U][G][U][G][C] =  4.800;
 int21_ar[A][U][U][U][A][G][C] =  4.800;
 int21_ar[A][U][U][U][C][G][C] =  2.500;
 int21_ar[A][U][U][U][G][G][C] =  4.800;
 int21_ar[A][U][U][U][U][G][C] =  2.000;
 int21_ar[A][U][A][A][A][G][U] =  3.900;
 int21_ar[A][U][A][A][C][G][U] =  3.700;
 int21_ar[A][U][A][A][G][G][U] =  3.100;
 int21_ar[A][U][A][A][U][G][U] =  5.500;
 int21_ar[A][U][A][C][A][G][U] =  3.600;
 int21_ar[A][U][A][C][C][G][U] =  3.200;
 int21_ar[A][U][A][C][G][G][U] =  3.100;
 int21_ar[A][U][A][C][U][G][U] =  5.500;
 int21_ar[A][U][A][G][A][G][U] =  2.500;
 int21_ar[A][U][A][G][C][G][U] =  2.100;
 int21_ar[A][U][A][G][G][G][U] =  1.900;
 int21_ar[A][U][A][G][U][G][U] =  5.500;
 int21_ar[A][U][A][U][A][G][U] =  5.500;
 int21_ar[A][U][A][U][C][G][U] =  5.500;
 int21_ar[A][U][A][U][G][G][U] =  5.500;
 int21_ar[A][U][A][U][U][G][U] =  5.500;
 int21_ar[A][U][C][A][A][G][U] =  3.800;
 int21_ar[A][U][C][A][C][G][U] =  3.700;
 int21_ar[A][U][C][A][G][G][U] =  5.500;
 int21_ar[A][U][C][A][U][G][U] =  3.700;
 int21_ar[A][U][C][C][A][G][U] =  3.700;
 int21_ar[A][U][C][C][C][G][U] =  4.000;
 int21_ar[A][U][C][C][G][G][U] =  5.500;
 int21_ar[A][U][C][C][U][G][U] =  3.700;
 int21_ar[A][U][C][G][A][G][U] =  5.500;
 int21_ar[A][U][C][G][C][G][U] =  5.500;
 int21_ar[A][U][C][G][G][G][U] =  5.500;
 int21_ar[A][U][C][G][U][G][U] =  5.500;
 int21_ar[A][U][C][U][A][G][U] =  4.000;
 int21_ar[A][U][C][U][C][G][U] =  3.400;
 int21_ar[A][U][C][U][G][G][U] =  5.500;
 int21_ar[A][U][C][U][U][G][U] =  3.700;
 int21_ar[A][U][G][A][A][G][U] =  3.200;
 int21_ar[A][U][G][A][C][G][U] =  5.500;
 int21_ar[A][U][G][A][G][G][U] =  2.300;
 int21_ar[A][U][G][A][U][G][U] =  5.500;
 int21_ar[A][U][G][C][A][G][U] =  5.500;
 int21_ar[A][U][G][C][C][G][U] =  5.500;
 int21_ar[A][U][G][C][G][G][U] =  5.500;
 int21_ar[A][U][G][C][U][G][U] =  5.500;
 int21_ar[A][U][G][G][A][G][U] =  2.300;
 int21_ar[A][U][G][G][C][G][U] =  5.500;
 int21_ar[A][U][G][G][G][G][U] =  3.700;
 int21_ar[A][U][G][G][U][G][U] =  5.500;
 int21_ar[A][U][G][U][A][G][U] =  5.500;
 int21_ar[A][U][G][U][C][G][U] =  5.500;
 int21_ar[A][U][G][U][G][G][U] =  5.500;
 int21_ar[A][U][G][U][U][G][U] =  5.500;
 int21_ar[A][U][U][A][A][G][U] =  5.500;
 int21_ar[A][U][U][A][C][G][U] =  5.500;
 int21_ar[A][U][U][A][G][G][U] =  5.500;
 int21_ar[A][U][U][A][U][G][U] =  5.500;
 int21_ar[A][U][U][C][A][G][U] =  5.500;
 int21_ar[A][U][U][C][C][G][U] =  3.700;
 int21_ar[A][U][U][C][G][G][U] =  5.500;
 int21_ar[A][U][U][C][U][G][U] =  2.800;
 int21_ar[A][U][U][G][A][G][U] =  5.500;
 int21_ar[A][U][U][G][C][G][U] =  5.500;
 int21_ar[A][U][U][G][G][G][U] =  5.500;
 int21_ar[A][U][U][G][U][G][U] =  5.500;
 int21_ar[A][U][U][U][A][G][U] =  5.500;
 int21_ar[A][U][U][U][C][G][U] =  3.200;
 int21_ar[A][U][U][U][G][G][U] =  5.500;
 int21_ar[A][U][U][U][U][G][U] =  2.700;
 int21_ar[A][U][A][A][A][U][A] =  3.900;
 int21_ar[A][U][A][A][C][U][A] =  3.700;
 int21_ar[A][U][A][A][G][U][A] =  3.100;
 int21_ar[A][U][A][A][U][U][A] =  5.500;
 int21_ar[A][U][A][C][A][U][A] =  3.600;
 int21_ar[A][U][A][C][C][U][A] =  3.200;
 int21_ar[A][U][A][C][G][U][A] =  3.100;
 int21_ar[A][U][A][C][U][U][A] =  5.500;
 int21_ar[A][U][A][G][A][U][A] =  2.500;
 int21_ar[A][U][A][G][C][U][A] =  2.100;
 int21_ar[A][U][A][G][G][U][A] =  1.900;
 int21_ar[A][U][A][G][U][U][A] =  5.500;
 int21_ar[A][U][A][U][A][U][A] =  5.500;
 int21_ar[A][U][A][U][C][U][A] =  5.500;
 int21_ar[A][U][A][U][G][U][A] =  5.500;
 int21_ar[A][U][A][U][U][U][A] =  5.500;
 int21_ar[A][U][C][A][A][U][A] =  3.800;
 int21_ar[A][U][C][A][C][U][A] =  3.700;
 int21_ar[A][U][C][A][G][U][A] =  5.500;
 int21_ar[A][U][C][A][U][U][A] =  3.700;
 int21_ar[A][U][C][C][A][U][A] =  3.700;
 int21_ar[A][U][C][C][C][U][A] =  4.000;
 int21_ar[A][U][C][C][G][U][A] =  5.500;
 int21_ar[A][U][C][C][U][U][A] =  3.700;
 int21_ar[A][U][C][G][A][U][A] =  5.500;
 int21_ar[A][U][C][G][C][U][A] =  5.500;
 int21_ar[A][U][C][G][G][U][A] =  5.500;
 int21_ar[A][U][C][G][U][U][A] =  5.500;
 int21_ar[A][U][C][U][A][U][A] =  4.000;
 int21_ar[A][U][C][U][C][U][A] =  3.400;
 int21_ar[A][U][C][U][G][U][A] =  5.500;
 int21_ar[A][U][C][U][U][U][A] =  3.700;
 int21_ar[A][U][G][A][A][U][A] =  3.200;
 int21_ar[A][U][G][A][C][U][A] =  5.500;
 int21_ar[A][U][G][A][G][U][A] =  2.300;
 int21_ar[A][U][G][A][U][U][A] =  5.500;
 int21_ar[A][U][G][C][A][U][A] =  5.500;
 int21_ar[A][U][G][C][C][U][A] =  5.500;
 int21_ar[A][U][G][C][G][U][A] =  5.500;
 int21_ar[A][U][G][C][U][U][A] =  5.500;
 int21_ar[A][U][G][G][A][U][A] =  2.300;
 int21_ar[A][U][G][G][C][U][A] =  5.500;
 int21_ar[A][U][G][G][G][U][A] =  3.700;
 int21_ar[A][U][G][G][U][U][A] =  5.500;
 int21_ar[A][U][G][U][A][U][A] =  5.500;
 int21_ar[A][U][G][U][C][U][A] =  5.500;
 int21_ar[A][U][G][U][G][U][A] =  5.500;
 int21_ar[A][U][G][U][U][U][A] =  5.500;
 int21_ar[A][U][U][A][A][U][A] =  5.500;
 int21_ar[A][U][U][A][C][U][A] =  5.500;
 int21_ar[A][U][U][A][G][U][A] =  5.500;
 int21_ar[A][U][U][A][U][U][A] =  5.500;
 int21_ar[A][U][U][C][A][U][A] =  5.500;
 int21_ar[A][U][U][C][C][U][A] =  3.700;
 int21_ar[A][U][U][C][G][U][A] =  5.500;
 int21_ar[A][U][U][C][U][U][A] =  2.800;
 int21_ar[A][U][U][G][A][U][A] =  5.500;
 int21_ar[A][U][U][G][C][U][A] =  5.500;
 int21_ar[A][U][U][G][G][U][A] =  5.500;
 int21_ar[A][U][U][G][U][U][A] =  5.500;
 int21_ar[A][U][U][U][A][U][A] =  5.500;
 int21_ar[A][U][U][U][C][U][A] =  3.200;
 int21_ar[A][U][U][U][G][U][A] =  5.500;
 int21_ar[A][U][U][U][U][U][A] =  2.700;
 int21_ar[A][U][A][A][A][U][G] =  3.900;
 int21_ar[A][U][A][A][C][U][G] =  3.700;
 int21_ar[A][U][A][A][G][U][G] =  3.100;
 int21_ar[A][U][A][A][U][U][G] =  5.500;
 int21_ar[A][U][A][C][A][U][G] =  3.600;
 int21_ar[A][U][A][C][C][U][G] =  3.200;
 int21_ar[A][U][A][C][G][U][G] =  3.100;
 int21_ar[A][U][A][C][U][U][G] =  5.500;
 int21_ar[A][U][A][G][A][U][G] =  2.500;
 int21_ar[A][U][A][G][C][U][G] =  2.100;
 int21_ar[A][U][A][G][G][U][G] =  1.900;
 int21_ar[A][U][A][G][U][U][G] =  5.500;
 int21_ar[A][U][A][U][A][U][G] =  5.500;
 int21_ar[A][U][A][U][C][U][G] =  5.500;
 int21_ar[A][U][A][U][G][U][G] =  5.500;
 int21_ar[A][U][A][U][U][U][G] =  5.500;
 int21_ar[A][U][C][A][A][U][G] =  3.800;
 int21_ar[A][U][C][A][C][U][G] =  3.700;
 int21_ar[A][U][C][A][G][U][G] =  5.500;
 int21_ar[A][U][C][A][U][U][G] =  3.700;
 int21_ar[A][U][C][C][A][U][G] =  3.700;
 int21_ar[A][U][C][C][C][U][G] =  4.000;
 int21_ar[A][U][C][C][G][U][G] =  5.500;
 int21_ar[A][U][C][C][U][U][G] =  3.700;
 int21_ar[A][U][C][G][A][U][G] =  5.500;
 int21_ar[A][U][C][G][C][U][G] =  5.500;
 int21_ar[A][U][C][G][G][U][G] =  5.500;
 int21_ar[A][U][C][G][U][U][G] =  5.500;
 int21_ar[A][U][C][U][A][U][G] =  4.000;
 int21_ar[A][U][C][U][C][U][G] =  3.400;
 int21_ar[A][U][C][U][G][U][G] =  5.500;
 int21_ar[A][U][C][U][U][U][G] =  3.700;
 int21_ar[A][U][G][A][A][U][G] =  3.200;
 int21_ar[A][U][G][A][C][U][G] =  5.500;
 int21_ar[A][U][G][A][G][U][G] =  2.300;
 int21_ar[A][U][G][A][U][U][G] =  5.500;
 int21_ar[A][U][G][C][A][U][G] =  5.500;
 int21_ar[A][U][G][C][C][U][G] =  5.500;
 int21_ar[A][U][G][C][G][U][G] =  5.500;
 int21_ar[A][U][G][C][U][U][G] =  5.500;
 int21_ar[A][U][G][G][A][U][G] =  2.300;
 int21_ar[A][U][G][G][C][U][G] =  5.500;
 int21_ar[A][U][G][G][G][U][G] =  3.700;
 int21_ar[A][U][G][G][U][U][G] =  5.500;
 int21_ar[A][U][G][U][A][U][G] =  5.500;
 int21_ar[A][U][G][U][C][U][G] =  5.500;
 int21_ar[A][U][G][U][G][U][G] =  5.500;
 int21_ar[A][U][G][U][U][U][G] =  5.500;
 int21_ar[A][U][U][A][A][U][G] =  5.500;
 int21_ar[A][U][U][A][C][U][G] =  5.500;
 int21_ar[A][U][U][A][G][U][G] =  5.500;
 int21_ar[A][U][U][A][U][U][G] =  5.500;
 int21_ar[A][U][U][C][A][U][G] =  5.500;
 int21_ar[A][U][U][C][C][U][G] =  3.700;
 int21_ar[A][U][U][C][G][U][G] =  5.500;
 int21_ar[A][U][U][C][U][U][G] =  2.800;
 int21_ar[A][U][U][G][A][U][G] =  5.500;
 int21_ar[A][U][U][G][C][U][G] =  5.500;
 int21_ar[A][U][U][G][G][U][G] =  5.500;
 int21_ar[A][U][U][G][U][U][G] =  5.500;
 int21_ar[A][U][U][U][A][U][G] =  5.500;
 int21_ar[A][U][U][U][C][U][G] =  3.200;
 int21_ar[A][U][U][U][G][U][G] =  5.500;
 int21_ar[A][U][U][U][U][U][G] =  2.700;
 int21_ar[C][G][A][A][A][A][U] =  3.200;
 int21_ar[C][G][A][A][C][A][U] =  3.000;
 int21_ar[C][G][A][A][G][A][U] =  2.400;
 int21_ar[C][G][A][A][U][A][U] =  4.800;
 int21_ar[C][G][A][C][A][A][U] =  2.900;
 int21_ar[C][G][A][C][C][A][U] =  2.500;
 int21_ar[C][G][A][C][G][A][U] =  2.400;
 int21_ar[C][G][A][C][U][A][U] =  4.800;
 int21_ar[C][G][A][G][A][A][U] =  1.800;
 int21_ar[C][G][A][G][C][A][U] =  1.400;
 int21_ar[C][G][A][G][G][A][U] =  1.200;
 int21_ar[C][G][A][G][U][A][U] =  4.800;
 int21_ar[C][G][A][U][A][A][U] =  4.800;
 int21_ar[C][G][A][U][C][A][U] =  4.800;
 int21_ar[C][G][A][U][G][A][U] =  4.800;
 int21_ar[C][G][A][U][U][A][U] =  4.800;
 int21_ar[C][G][C][A][A][A][U] =  3.100;
 int21_ar[C][G][C][A][C][A][U] =  3.000;
 int21_ar[C][G][C][A][G][A][U] =  4.800;
 int21_ar[C][G][C][A][U][A][U] =  3.000;
 int21_ar[C][G][C][C][A][A][U] =  3.000;
 int21_ar[C][G][C][C][C][A][U] =  3.300;
 int21_ar[C][G][C][C][G][A][U] =  4.800;
 int21_ar[C][G][C][C][U][A][U] =  3.000;
 int21_ar[C][G][C][G][A][A][U] =  4.800;
 int21_ar[C][G][C][G][C][A][U] =  4.800;
 int21_ar[C][G][C][G][G][A][U] =  4.800;
 int21_ar[C][G][C][G][U][A][U] =  4.800;
 int21_ar[C][G][C][U][A][A][U] =  3.300;
 int21_ar[C][G][C][U][C][A][U] =  2.700;
 int21_ar[C][G][C][U][G][A][U] =  4.800;
 int21_ar[C][G][C][U][U][A][U] =  3.000;
 int21_ar[C][G][G][A][A][A][U] =  2.500;
 int21_ar[C][G][G][A][C][A][U] =  4.800;
 int21_ar[C][G][G][A][G][A][U] =  1.600;
 int21_ar[C][G][G][A][U][A][U] =  4.800;
 int21_ar[C][G][G][C][A][A][U] =  4.800;
 int21_ar[C][G][G][C][C][A][U] =  4.800;
 int21_ar[C][G][G][C][G][A][U] =  4.800;
 int21_ar[C][G][G][C][U][A][U] =  4.800;
 int21_ar[C][G][G][G][A][A][U] =  1.600;
 int21_ar[C][G][G][G][C][A][U] =  4.800;
 int21_ar[C][G][G][G][G][A][U] =  3.000;
 int21_ar[C][G][G][G][U][A][U] =  4.800;
 int21_ar[C][G][G][U][A][A][U] =  4.800;
 int21_ar[C][G][G][U][C][A][U] =  4.800;
 int21_ar[C][G][G][U][G][A][U] =  4.800;
 int21_ar[C][G][G][U][U][A][U] =  4.800;
 int21_ar[C][G][U][A][A][A][U] =  4.800;
 int21_ar[C][G][U][A][C][A][U] =  4.800;
 int21_ar[C][G][U][A][G][A][U] =  4.800;
 int21_ar[C][G][U][A][U][A][U] =  4.800;
 int21_ar[C][G][U][C][A][A][U] =  4.800;
 int21_ar[C][G][U][C][C][A][U] =  3.000;
 int21_ar[C][G][U][C][G][A][U] =  4.800;
 int21_ar[C][G][U][C][U][A][U] =  2.100;
 int21_ar[C][G][U][G][A][A][U] =  4.800;
 int21_ar[C][G][U][G][C][A][U] =  4.800;
 int21_ar[C][G][U][G][G][A][U] =  4.800;
 int21_ar[C][G][U][G][U][A][U] =  4.800;
 int21_ar[C][G][U][U][A][A][U] =  4.800;
 int21_ar[C][G][U][U][C][A][U] =  2.500;
 int21_ar[C][G][U][U][G][A][U] =  4.800;
 int21_ar[C][G][U][U][U][A][U] =  2.000;
 int21_ar[C][G][A][A][A][C][G] =  2.400;
 int21_ar[C][G][A][A][C][C][G] =  2.200;
 int21_ar[C][G][A][A][G][C][G] =  1.600;
 int21_ar[C][G][A][A][U][C][G] =  4.000;
 int21_ar[C][G][A][C][A][C][G] =  2.100;
 int21_ar[C][G][A][C][C][C][G] =  1.700;
 int21_ar[C][G][A][C][G][C][G] =  1.600;
 int21_ar[C][G][A][C][U][C][G] =  4.000;
 int21_ar[C][G][A][G][A][C][G] =  1.000;
 int21_ar[C][G][A][G][C][C][G] =  0.600;
 int21_ar[C][G][A][G][G][C][G] =  0.400;
 int21_ar[C][G][A][G][U][C][G] =  4.000;
 int21_ar[C][G][A][U][A][C][G] =  4.000;
 int21_ar[C][G][A][U][C][C][G] =  4.000;
 int21_ar[C][G][A][U][G][C][G] =  4.000;
 int21_ar[C][G][A][U][U][C][G] =  4.000;
 int21_ar[C][G][C][A][A][C][G] =  2.300;
 int21_ar[C][G][C][A][C][C][G] =  2.200;
 int21_ar[C][G][C][A][G][C][G] =  4.000;
 int21_ar[C][G][C][A][U][C][G] =  2.200;
 int21_ar[C][G][C][C][A][C][G] =  2.200;
 int21_ar[C][G][C][C][C][C][G] =  2.500;
 int21_ar[C][G][C][C][G][C][G] =  4.000;
 int21_ar[C][G][C][C][U][C][G] =  2.200;
 int21_ar[C][G][C][G][A][C][G] =  4.000;
 int21_ar[C][G][C][G][C][C][G] =  4.000;
 int21_ar[C][G][C][G][G][C][G] =  4.000;
 int21_ar[C][G][C][G][U][C][G] =  4.000;
 int21_ar[C][G][C][U][A][C][G] =  2.500;
 int21_ar[C][G][C][U][C][C][G] =  1.900;
 int21_ar[C][G][C][U][G][C][G] =  4.000;
 int21_ar[C][G][C][U][U][C][G] =  2.200;
 int21_ar[C][G][G][A][A][C][G] =  1.700;
 int21_ar[C][G][G][A][C][C][G] =  4.000;
 int21_ar[C][G][G][A][G][C][G] =  0.800;
 int21_ar[C][G][G][A][U][C][G] =  4.000;
 int21_ar[C][G][G][C][A][C][G] =  4.000;
 int21_ar[C][G][G][C][C][C][G] =  4.000;
 int21_ar[C][G][G][C][G][C][G] =  4.000;
 int21_ar[C][G][G][C][U][C][G] =  4.000;
 int21_ar[C][G][G][G][A][C][G] =  0.800;
 int21_ar[C][G][G][G][C][C][G] =  4.000;
 int21_ar[C][G][G][G][G][C][G] =  2.200;
 int21_ar[C][G][G][G][U][C][G] =  4.000;
 int21_ar[C][G][G][U][A][C][G] =  4.000;
 int21_ar[C][G][G][U][C][C][G] =  4.000;
 int21_ar[C][G][G][U][G][C][G] =  4.000;
 int21_ar[C][G][G][U][U][C][G] =  4.000;
 int21_ar[C][G][U][A][A][C][G] =  4.000;
 int21_ar[C][G][U][A][C][C][G] =  4.000;
 int21_ar[C][G][U][A][G][C][G] =  4.000;
 int21_ar[C][G][U][A][U][C][G] =  4.000;
 int21_ar[C][G][U][C][A][C][G] =  4.000;
 int21_ar[C][G][U][C][C][C][G] =  2.200;
 int21_ar[C][G][U][C][G][C][G] =  4.000;
 int21_ar[C][G][U][C][U][C][G] =  1.300;
 int21_ar[C][G][U][G][A][C][G] =  4.000;
 int21_ar[C][G][U][G][C][C][G] =  4.000;
 int21_ar[C][G][U][G][G][C][G] =  4.000;
 int21_ar[C][G][U][G][U][C][G] =  4.000;
 int21_ar[C][G][U][U][A][C][G] =  4.000;
 int21_ar[C][G][U][U][C][C][G] =  1.700;
 int21_ar[C][G][U][U][G][C][G] =  4.000;
 int21_ar[C][G][U][U][U][C][G] =  1.200;
 int21_ar[C][G][A][A][A][G][C] =  2.300;
 int21_ar[C][G][A][A][C][G][C] =  2.200;
 int21_ar[C][G][A][A][G][G][C] =  1.100;
 int21_ar[C][G][A][A][U][G][C] =  4.000;
 int21_ar[C][G][A][C][A][G][C] =  2.100;
 int21_ar[C][G][A][C][C][G][C] =  1.700;
 int21_ar[C][G][A][C][G][G][C] =  1.600;
 int21_ar[C][G][A][C][U][G][C] =  4.000;
 int21_ar[C][G][A][G][A][G][C] =  0.800;
 int21_ar[C][G][A][G][C][G][C] =  0.600;
 int21_ar[C][G][A][G][G][G][C] =  0.400;
 int21_ar[C][G][A][G][U][G][C] =  4.000;
 int21_ar[C][G][A][U][A][G][C] =  4.000;
 int21_ar[C][G][A][U][C][G][C] =  4.000;
 int21_ar[C][G][A][U][G][G][C] =  4.000;
 int21_ar[C][G][A][U][U][G][C] =  4.000;
 int21_ar[C][G][C][A][A][G][C] =  2.300;
 int21_ar[C][G][C][A][C][G][C] =  2.200;
 int21_ar[C][G][C][A][G][G][C] =  4.000;
 int21_ar[C][G][C][A][U][G][C] =  2.200;
 int21_ar[C][G][C][C][A][G][C] =  2.200;
 int21_ar[C][G][C][C][C][G][C] =  2.500;
 int21_ar[C][G][C][C][G][G][C] =  4.000;
 int21_ar[C][G][C][C][U][G][C] =  2.200;
 int21_ar[C][G][C][G][A][G][C] =  4.000;
 int21_ar[C][G][C][G][C][G][C] =  4.000;
 int21_ar[C][G][C][G][G][G][C] =  4.000;
 int21_ar[C][G][C][G][U][G][C] =  4.000;
 int21_ar[C][G][C][U][A][G][C] =  2.500;
 int21_ar[C][G][C][U][C][G][C] =  1.900;
 int21_ar[C][G][C][U][G][G][C] =  4.000;
 int21_ar[C][G][C][U][U][G][C] =  2.200;
 int21_ar[C][G][G][A][A][G][C] =  1.700;
 int21_ar[C][G][G][A][C][G][C] =  4.000;
 int21_ar[C][G][G][A][G][G][C] =  0.800;
 int21_ar[C][G][G][A][U][G][C] =  4.000;
 int21_ar[C][G][G][C][A][G][C] =  4.000;
 int21_ar[C][G][G][C][C][G][C] =  4.000;
 int21_ar[C][G][G][C][G][G][C] =  4.000;
 int21_ar[C][G][G][C][U][G][C] =  4.000;
 int21_ar[C][G][G][G][A][G][C] =  0.800;
 int21_ar[C][G][G][G][C][G][C] =  4.000;
 int21_ar[C][G][G][G][G][G][C] =  2.200;
 int21_ar[C][G][G][G][U][G][C] =  4.000;
 int21_ar[C][G][G][U][A][G][C] =  4.000;
 int21_ar[C][G][G][U][C][G][C] =  4.000;
 int21_ar[C][G][G][U][G][G][C] =  4.000;
 int21_ar[C][G][G][U][U][G][C] =  4.000;
 int21_ar[C][G][U][A][A][G][C] =  4.000;
 int21_ar[C][G][U][A][C][G][C] =  4.000;
 int21_ar[C][G][U][A][G][G][C] =  4.000;
 int21_ar[C][G][U][A][U][G][C] =  4.000;
 int21_ar[C][G][U][C][A][G][C] =  4.000;
 int21_ar[C][G][U][C][C][G][C] =  2.200;
 int21_ar[C][G][U][C][G][G][C] =  4.000;
 int21_ar[C][G][U][C][U][G][C] =  1.500;
 int21_ar[C][G][U][G][A][G][C] =  4.000;
 int21_ar[C][G][U][G][C][G][C] =  4.000;
 int21_ar[C][G][U][G][G][G][C] =  4.000;
 int21_ar[C][G][U][G][U][G][C] =  4.000;
 int21_ar[C][G][U][U][A][G][C] =  4.000;
 int21_ar[C][G][U][U][C][G][C] =  1.700;
 int21_ar[C][G][U][U][G][G][C] =  4.000;
 int21_ar[C][G][U][U][U][G][C] =  1.200;
 int21_ar[C][G][A][A][A][G][U] =  3.200;
 int21_ar[C][G][A][A][C][G][U] =  3.000;
 int21_ar[C][G][A][A][G][G][U] =  2.400;
 int21_ar[C][G][A][A][U][G][U] =  4.800;
 int21_ar[C][G][A][C][A][G][U] =  2.900;
 int21_ar[C][G][A][C][C][G][U] =  2.500;
 int21_ar[C][G][A][C][G][G][U] =  2.400;
 int21_ar[C][G][A][C][U][G][U] =  4.800;
 int21_ar[C][G][A][G][A][G][U] =  1.800;
 int21_ar[C][G][A][G][C][G][U] =  1.400;
 int21_ar[C][G][A][G][G][G][U] =  1.200;
 int21_ar[C][G][A][G][U][G][U] =  4.800;
 int21_ar[C][G][A][U][A][G][U] =  4.800;
 int21_ar[C][G][A][U][C][G][U] =  4.800;
 int21_ar[C][G][A][U][G][G][U] =  4.800;
 int21_ar[C][G][A][U][U][G][U] =  4.800;
 int21_ar[C][G][C][A][A][G][U] =  3.100;
 int21_ar[C][G][C][A][C][G][U] =  3.000;
 int21_ar[C][G][C][A][G][G][U] =  4.800;
 int21_ar[C][G][C][A][U][G][U] =  3.000;
 int21_ar[C][G][C][C][A][G][U] =  3.000;
 int21_ar[C][G][C][C][C][G][U] =  3.300;
 int21_ar[C][G][C][C][G][G][U] =  4.800;
 int21_ar[C][G][C][C][U][G][U] =  3.000;
 int21_ar[C][G][C][G][A][G][U] =  4.800;
 int21_ar[C][G][C][G][C][G][U] =  4.800;
 int21_ar[C][G][C][G][G][G][U] =  4.800;
 int21_ar[C][G][C][G][U][G][U] =  4.800;
 int21_ar[C][G][C][U][A][G][U] =  3.300;
 int21_ar[C][G][C][U][C][G][U] =  2.700;
 int21_ar[C][G][C][U][G][G][U] =  4.800;
 int21_ar[C][G][C][U][U][G][U] =  3.000;
 int21_ar[C][G][G][A][A][G][U] =  2.500;
 int21_ar[C][G][G][A][C][G][U] =  4.800;
 int21_ar[C][G][G][A][G][G][U] =  1.600;
 int21_ar[C][G][G][A][U][G][U] =  4.800;
 int21_ar[C][G][G][C][A][G][U] =  4.800;
 int21_ar[C][G][G][C][C][G][U] =  4.800;
 int21_ar[C][G][G][C][G][G][U] =  4.800;
 int21_ar[C][G][G][C][U][G][U] =  4.800;
 int21_ar[C][G][G][G][A][G][U] =  1.600;
 int21_ar[C][G][G][G][C][G][U] =  4.800;
 int21_ar[C][G][G][G][G][G][U] =  3.000;
 int21_ar[C][G][G][G][U][G][U] =  4.800;
 int21_ar[C][G][G][U][A][G][U] =  4.800;
 int21_ar[C][G][G][U][C][G][U] =  4.800;
 int21_ar[C][G][G][U][G][G][U] =  4.800;
 int21_ar[C][G][G][U][U][G][U] =  4.800;
 int21_ar[C][G][U][A][A][G][U] =  4.800;
 int21_ar[C][G][U][A][C][G][U] =  4.800;
 int21_ar[C][G][U][A][G][G][U] =  4.800;
 int21_ar[C][G][U][A][U][G][U] =  4.800;
 int21_ar[C][G][U][C][A][G][U] =  4.800;
 int21_ar[C][G][U][C][C][G][U] =  3.000;
 int21_ar[C][G][U][C][G][G][U] =  4.800;
 int21_ar[C][G][U][C][U][G][U] =  2.100;
 int21_ar[C][G][U][G][A][G][U] =  4.800;
 int21_ar[C][G][U][G][C][G][U] =  4.800;
 int21_ar[C][G][U][G][G][G][U] =  4.800;
 int21_ar[C][G][U][G][U][G][U] =  4.800;
 int21_ar[C][G][U][U][A][G][U] =  4.800;
 int21_ar[C][G][U][U][C][G][U] =  2.500;
 int21_ar[C][G][U][U][G][G][U] =  4.800;
 int21_ar[C][G][U][U][U][G][U] =  2.000;
 int21_ar[C][G][A][A][A][U][A] =  3.200;
 int21_ar[C][G][A][A][C][U][A] =  3.000;
 int21_ar[C][G][A][A][G][U][A] =  2.400;
 int21_ar[C][G][A][A][U][U][A] =  4.800;
 int21_ar[C][G][A][C][A][U][A] =  2.900;
 int21_ar[C][G][A][C][C][U][A] =  2.500;
 int21_ar[C][G][A][C][G][U][A] =  2.400;
 int21_ar[C][G][A][C][U][U][A] =  4.800;
 int21_ar[C][G][A][G][A][U][A] =  1.800;
 int21_ar[C][G][A][G][C][U][A] =  1.400;
 int21_ar[C][G][A][G][G][U][A] =  1.200;
 int21_ar[C][G][A][G][U][U][A] =  4.800;
 int21_ar[C][G][A][U][A][U][A] =  4.800;
 int21_ar[C][G][A][U][C][U][A] =  4.800;
 int21_ar[C][G][A][U][G][U][A] =  4.800;
 int21_ar[C][G][A][U][U][U][A] =  4.800;
 int21_ar[C][G][C][A][A][U][A] =  3.100;
 int21_ar[C][G][C][A][C][U][A] =  3.000;
 int21_ar[C][G][C][A][G][U][A] =  4.800;
 int21_ar[C][G][C][A][U][U][A] =  3.000;
 int21_ar[C][G][C][C][A][U][A] =  3.000;
 int21_ar[C][G][C][C][C][U][A] =  3.300;
 int21_ar[C][G][C][C][G][U][A] =  4.800;
 int21_ar[C][G][C][C][U][U][A] =  3.000;
 int21_ar[C][G][C][G][A][U][A] =  4.800;
 int21_ar[C][G][C][G][C][U][A] =  4.800;
 int21_ar[C][G][C][G][G][U][A] =  4.800;
 int21_ar[C][G][C][G][U][U][A] =  4.800;
 int21_ar[C][G][C][U][A][U][A] =  3.300;
 int21_ar[C][G][C][U][C][U][A] =  2.700;
 int21_ar[C][G][C][U][G][U][A] =  4.800;
 int21_ar[C][G][C][U][U][U][A] =  3.000;
 int21_ar[C][G][G][A][A][U][A] =  2.500;
 int21_ar[C][G][G][A][C][U][A] =  4.800;
 int21_ar[C][G][G][A][G][U][A] =  1.600;
 int21_ar[C][G][G][A][U][U][A] =  4.800;
 int21_ar[C][G][G][C][A][U][A] =  4.800;
 int21_ar[C][G][G][C][C][U][A] =  4.800;
 int21_ar[C][G][G][C][G][U][A] =  4.800;
 int21_ar[C][G][G][C][U][U][A] =  4.800;
 int21_ar[C][G][G][G][A][U][A] =  1.600;
 int21_ar[C][G][G][G][C][U][A] =  4.800;
 int21_ar[C][G][G][G][G][U][A] =  3.000;
 int21_ar[C][G][G][G][U][U][A] =  4.800;
 int21_ar[C][G][G][U][A][U][A] =  4.800;
 int21_ar[C][G][G][U][C][U][A] =  4.800;
 int21_ar[C][G][G][U][G][U][A] =  4.800;
 int21_ar[C][G][G][U][U][U][A] =  4.800;
 int21_ar[C][G][U][A][A][U][A] =  4.800;
 int21_ar[C][G][U][A][C][U][A] =  4.800;
 int21_ar[C][G][U][A][G][U][A] =  4.800;
 int21_ar[C][G][U][A][U][U][A] =  4.800;
 int21_ar[C][G][U][C][A][U][A] =  4.800;
 int21_ar[C][G][U][C][C][U][A] =  3.000;
 int21_ar[C][G][U][C][G][U][A] =  4.800;
 int21_ar[C][G][U][C][U][U][A] =  2.100;
 int21_ar[C][G][U][G][A][U][A] =  4.800;
 int21_ar[C][G][U][G][C][U][A] =  4.800;
 int21_ar[C][G][U][G][G][U][A] =  4.800;
 int21_ar[C][G][U][G][U][U][A] =  4.800;
 int21_ar[C][G][U][U][A][U][A] =  4.800;
 int21_ar[C][G][U][U][C][U][A] =  2.500;
 int21_ar[C][G][U][U][G][U][A] =  4.800;
 int21_ar[C][G][U][U][U][U][A] =  2.000;
 int21_ar[C][G][A][A][A][U][G] =  3.200;
 int21_ar[C][G][A][A][C][U][G] =  3.000;
 int21_ar[C][G][A][A][G][U][G] =  2.400;
 int21_ar[C][G][A][A][U][U][G] =  4.800;
 int21_ar[C][G][A][C][A][U][G] =  2.900;
 int21_ar[C][G][A][C][C][U][G] =  2.500;
 int21_ar[C][G][A][C][G][U][G] =  2.400;
 int21_ar[C][G][A][C][U][U][G] =  4.800;
 int21_ar[C][G][A][G][A][U][G] =  1.800;
 int21_ar[C][G][A][G][C][U][G] =  1.400;
 int21_ar[C][G][A][G][G][U][G] =  1.200;
 int21_ar[C][G][A][G][U][U][G] =  4.800;
 int21_ar[C][G][A][U][A][U][G] =  4.800;
 int21_ar[C][G][A][U][C][U][G] =  4.800;
 int21_ar[C][G][A][U][G][U][G] =  4.800;
 int21_ar[C][G][A][U][U][U][G] =  4.800;
 int21_ar[C][G][C][A][A][U][G] =  3.100;
 int21_ar[C][G][C][A][C][U][G] =  3.000;
 int21_ar[C][G][C][A][G][U][G] =  4.800;
 int21_ar[C][G][C][A][U][U][G] =  3.000;
 int21_ar[C][G][C][C][A][U][G] =  3.000;
 int21_ar[C][G][C][C][C][U][G] =  3.300;
 int21_ar[C][G][C][C][G][U][G] =  4.800;
 int21_ar[C][G][C][C][U][U][G] =  3.000;
 int21_ar[C][G][C][G][A][U][G] =  4.800;
 int21_ar[C][G][C][G][C][U][G] =  4.800;
 int21_ar[C][G][C][G][G][U][G] =  4.800;
 int21_ar[C][G][C][G][U][U][G] =  4.800;
 int21_ar[C][G][C][U][A][U][G] =  3.300;
 int21_ar[C][G][C][U][C][U][G] =  2.700;
 int21_ar[C][G][C][U][G][U][G] =  4.800;
 int21_ar[C][G][C][U][U][U][G] =  3.000;
 int21_ar[C][G][G][A][A][U][G] =  2.500;
 int21_ar[C][G][G][A][C][U][G] =  4.800;
 int21_ar[C][G][G][A][G][U][G] =  1.600;
 int21_ar[C][G][G][A][U][U][G] =  4.800;
 int21_ar[C][G][G][C][A][U][G] =  4.800;
 int21_ar[C][G][G][C][C][U][G] =  4.800;
 int21_ar[C][G][G][C][G][U][G] =  4.800;
 int21_ar[C][G][G][C][U][U][G] =  4.800;
 int21_ar[C][G][G][G][A][U][G] =  1.600;
 int21_ar[C][G][G][G][C][U][G] =  4.800;
 int21_ar[C][G][G][G][G][U][G] =  3.000;
 int21_ar[C][G][G][G][U][U][G] =  4.800;
 int21_ar[C][G][G][U][A][U][G] =  4.800;
 int21_ar[C][G][G][U][C][U][G] =  4.800;
 int21_ar[C][G][G][U][G][U][G] =  4.800;
 int21_ar[C][G][G][U][U][U][G] =  4.800;
 int21_ar[C][G][U][A][A][U][G] =  4.800;
 int21_ar[C][G][U][A][C][U][G] =  4.800;
 int21_ar[C][G][U][A][G][U][G] =  4.800;
 int21_ar[C][G][U][A][U][U][G] =  4.800;
 int21_ar[C][G][U][C][A][U][G] =  4.800;
 int21_ar[C][G][U][C][C][U][G] =  3.000;
 int21_ar[C][G][U][C][G][U][G] =  4.800;
 int21_ar[C][G][U][C][U][U][G] =  2.100;
 int21_ar[C][G][U][G][A][U][G] =  4.800;
 int21_ar[C][G][U][G][C][U][G] =  4.800;
 int21_ar[C][G][U][G][G][U][G] =  4.800;
 int21_ar[C][G][U][G][U][U][G] =  4.800;
 int21_ar[C][G][U][U][A][U][G] =  4.800;
 int21_ar[C][G][U][U][C][U][G] =  2.500;
 int21_ar[C][G][U][U][G][U][G] =  4.800;
 int21_ar[C][G][U][U][U][U][G] =  2.000;
 int21_ar[G][C][A][A][A][A][U] =  3.200;
 int21_ar[G][C][A][A][C][A][U] =  3.000;
 int21_ar[G][C][A][A][G][A][U] =  2.400;
 int21_ar[G][C][A][A][U][A][U] =  4.800;
 int21_ar[G][C][A][C][A][A][U] =  2.900;
 int21_ar[G][C][A][C][C][A][U] =  2.500;
 int21_ar[G][C][A][C][G][A][U] =  2.400;
 int21_ar[G][C][A][C][U][A][U] =  4.800;
 int21_ar[G][C][A][G][A][A][U] =  1.800;
 int21_ar[G][C][A][G][C][A][U] =  1.400;
 int21_ar[G][C][A][G][G][A][U] =  1.200;
 int21_ar[G][C][A][G][U][A][U] =  4.800;
 int21_ar[G][C][A][U][A][A][U] =  4.800;
 int21_ar[G][C][A][U][C][A][U] =  4.800;
 int21_ar[G][C][A][U][G][A][U] =  4.800;
 int21_ar[G][C][A][U][U][A][U] =  4.800;
 int21_ar[G][C][C][A][A][A][U] =  3.100;
 int21_ar[G][C][C][A][C][A][U] =  3.000;
 int21_ar[G][C][C][A][G][A][U] =  4.800;
 int21_ar[G][C][C][A][U][A][U] =  3.000;
 int21_ar[G][C][C][C][A][A][U] =  3.000;
 int21_ar[G][C][C][C][C][A][U] =  3.300;
 int21_ar[G][C][C][C][G][A][U] =  4.800;
 int21_ar[G][C][C][C][U][A][U] =  3.000;
 int21_ar[G][C][C][G][A][A][U] =  4.800;
 int21_ar[G][C][C][G][C][A][U] =  4.800;
 int21_ar[G][C][C][G][G][A][U] =  4.800;
 int21_ar[G][C][C][G][U][A][U] =  4.800;
 int21_ar[G][C][C][U][A][A][U] =  3.300;
 int21_ar[G][C][C][U][C][A][U] =  2.700;
 int21_ar[G][C][C][U][G][A][U] =  4.800;
 int21_ar[G][C][C][U][U][A][U] =  3.000;
 int21_ar[G][C][G][A][A][A][U] =  2.500;
 int21_ar[G][C][G][A][C][A][U] =  4.800;
 int21_ar[G][C][G][A][G][A][U] =  1.600;
 int21_ar[G][C][G][A][U][A][U] =  4.800;
 int21_ar[G][C][G][C][A][A][U] =  4.800;
 int21_ar[G][C][G][C][C][A][U] =  4.800;
 int21_ar[G][C][G][C][G][A][U] =  4.800;
 int21_ar[G][C][G][C][U][A][U] =  4.800;
 int21_ar[G][C][G][G][A][A][U] =  1.600;
 int21_ar[G][C][G][G][C][A][U] =  4.800;
 int21_ar[G][C][G][G][G][A][U] =  3.000;
 int21_ar[G][C][G][G][U][A][U] =  4.800;
 int21_ar[G][C][G][U][A][A][U] =  4.800;
 int21_ar[G][C][G][U][C][A][U] =  4.800;
 int21_ar[G][C][G][U][G][A][U] =  4.800;
 int21_ar[G][C][G][U][U][A][U] =  4.800;
 int21_ar[G][C][U][A][A][A][U] =  4.800;
 int21_ar[G][C][U][A][C][A][U] =  4.800;
 int21_ar[G][C][U][A][G][A][U] =  4.800;
 int21_ar[G][C][U][A][U][A][U] =  4.800;
 int21_ar[G][C][U][C][A][A][U] =  4.800;
 int21_ar[G][C][U][C][C][A][U] =  3.000;
 int21_ar[G][C][U][C][G][A][U] =  4.800;
 int21_ar[G][C][U][C][U][A][U] =  2.100;
 int21_ar[G][C][U][G][A][A][U] =  4.800;
 int21_ar[G][C][U][G][C][A][U] =  4.800;
 int21_ar[G][C][U][G][G][A][U] =  4.800;
 int21_ar[G][C][U][G][U][A][U] =  4.800;
 int21_ar[G][C][U][U][A][A][U] =  4.800;
 int21_ar[G][C][U][U][C][A][U] =  2.500;
 int21_ar[G][C][U][U][G][A][U] =  4.800;
 int21_ar[G][C][U][U][U][A][U] =  2.000;
 int21_ar[G][C][A][A][A][C][G] =  2.500;
 int21_ar[G][C][A][A][C][C][G] =  2.200;
 int21_ar[G][C][A][A][G][C][G] =  2.100;
 int21_ar[G][C][A][A][U][C][G] =  4.000;
 int21_ar[G][C][A][C][A][C][G] =  2.100;
 int21_ar[G][C][A][C][C][C][G] =  1.700;
 int21_ar[G][C][A][C][G][C][G] =  1.600;
 int21_ar[G][C][A][C][U][C][G] =  4.000;
 int21_ar[G][C][A][G][A][C][G] =  1.200;
 int21_ar[G][C][A][G][C][C][G] =  0.600;
 int21_ar[G][C][A][G][G][C][G] =  0.400;
 int21_ar[G][C][A][G][U][C][G] =  4.000;
 int21_ar[G][C][A][U][A][C][G] =  4.000;
 int21_ar[G][C][A][U][C][C][G] =  4.000;
 int21_ar[G][C][A][U][G][C][G] =  4.000;
 int21_ar[G][C][A][U][U][C][G] =  4.000;
 int21_ar[G][C][C][A][A][C][G] =  2.300;
 int21_ar[G][C][C][A][C][C][G] =  2.200;
 int21_ar[G][C][C][A][G][C][G] =  4.000;
 int21_ar[G][C][C][A][U][C][G] =  2.200;
 int21_ar[G][C][C][C][A][C][G] =  2.200;
 int21_ar[G][C][C][C][C][C][G] =  2.500;
 int21_ar[G][C][C][C][G][C][G] =  4.000;
 int21_ar[G][C][C][C][U][C][G] =  2.200;
 int21_ar[G][C][C][G][A][C][G] =  4.000;
 int21_ar[G][C][C][G][C][C][G] =  4.000;
 int21_ar[G][C][C][G][G][C][G] =  4.000;
 int21_ar[G][C][C][G][U][C][G] =  4.000;
 int21_ar[G][C][C][U][A][C][G] =  2.500;
 int21_ar[G][C][C][U][C][C][G] =  1.900;
 int21_ar[G][C][C][U][G][C][G] =  4.000;
 int21_ar[G][C][C][U][U][C][G] =  2.200;
 int21_ar[G][C][G][A][A][C][G] =  1.700;
 int21_ar[G][C][G][A][C][C][G] =  4.000;
 int21_ar[G][C][G][A][G][C][G] =  0.800;
 int21_ar[G][C][G][A][U][C][G] =  4.000;
 int21_ar[G][C][G][C][A][C][G] =  4.000;
 int21_ar[G][C][G][C][C][C][G] =  4.000;
 int21_ar[G][C][G][C][G][C][G] =  4.000;
 int21_ar[G][C][G][C][U][C][G] =  4.000;
 int21_ar[G][C][G][G][A][C][G] =  0.800;
 int21_ar[G][C][G][G][C][C][G] =  4.000;
 int21_ar[G][C][G][G][G][C][G] =  2.200;
 int21_ar[G][C][G][G][U][C][G] =  4.000;
 int21_ar[G][C][G][U][A][C][G] =  4.000;
 int21_ar[G][C][G][U][C][C][G] =  4.000;
 int21_ar[G][C][G][U][G][C][G] =  4.000;
 int21_ar[G][C][G][U][U][C][G] =  4.000;
 int21_ar[G][C][U][A][A][C][G] =  4.000;
 int21_ar[G][C][U][A][C][C][G] =  4.000;
 int21_ar[G][C][U][A][G][C][G] =  4.000;
 int21_ar[G][C][U][A][U][C][G] =  4.000;
 int21_ar[G][C][U][C][A][C][G] =  4.000;
 int21_ar[G][C][U][C][C][C][G] =  2.200;
 int21_ar[G][C][U][C][G][C][G] =  4.000;
 int21_ar[G][C][U][C][U][C][G] =  1.200;
 int21_ar[G][C][U][G][A][C][G] =  4.000;
 int21_ar[G][C][U][G][C][C][G] =  4.000;
 int21_ar[G][C][U][G][G][C][G] =  4.000;
 int21_ar[G][C][U][G][U][C][G] =  4.000;
 int21_ar[G][C][U][U][A][C][G] =  4.000;
 int21_ar[G][C][U][U][C][C][G] =  1.700;
 int21_ar[G][C][U][U][G][C][G] =  4.000;
 int21_ar[G][C][U][U][U][C][G] =  1.200;
 int21_ar[G][C][A][A][A][G][C] =  2.400;
 int21_ar[G][C][A][A][C][G][C] =  2.200;
 int21_ar[G][C][A][A][G][G][C] =  1.600;
 int21_ar[G][C][A][A][U][G][C] =  4.000;
 int21_ar[G][C][A][C][A][G][C] =  2.100;
 int21_ar[G][C][A][C][C][G][C] =  1.700;
 int21_ar[G][C][A][C][G][G][C] =  1.600;
 int21_ar[G][C][A][C][U][G][C] =  4.000;
 int21_ar[G][C][A][G][A][G][C] =  1.000;
 int21_ar[G][C][A][G][C][G][C] =  0.600;
 int21_ar[G][C][A][G][G][G][C] =  0.400;
 int21_ar[G][C][A][G][U][G][C] =  4.000;
 int21_ar[G][C][A][U][A][G][C] =  4.000;
 int21_ar[G][C][A][U][C][G][C] =  4.000;
 int21_ar[G][C][A][U][G][G][C] =  4.000;
 int21_ar[G][C][A][U][U][G][C] =  4.000;
 int21_ar[G][C][C][A][A][G][C] =  2.300;
 int21_ar[G][C][C][A][C][G][C] =  2.200;
 int21_ar[G][C][C][A][G][G][C] =  4.000;
 int21_ar[G][C][C][A][U][G][C] =  2.200;
 int21_ar[G][C][C][C][A][G][C] =  2.200;
 int21_ar[G][C][C][C][C][G][C] =  2.500;
 int21_ar[G][C][C][C][G][G][C] =  4.000;
 int21_ar[G][C][C][C][U][G][C] =  2.200;
 int21_ar[G][C][C][G][A][G][C] =  4.000;
 int21_ar[G][C][C][G][C][G][C] =  4.000;
 int21_ar[G][C][C][G][G][G][C] =  4.000;
 int21_ar[G][C][C][G][U][G][C] =  4.000;
 int21_ar[G][C][C][U][A][G][C] =  2.500;
 int21_ar[G][C][C][U][C][G][C] =  1.900;
 int21_ar[G][C][C][U][G][G][C] =  4.000;
 int21_ar[G][C][C][U][U][G][C] =  2.200;
 int21_ar[G][C][G][A][A][G][C] =  1.700;
 int21_ar[G][C][G][A][C][G][C] =  4.000;
 int21_ar[G][C][G][A][G][G][C] =  0.800;
 int21_ar[G][C][G][A][U][G][C] =  4.000;
 int21_ar[G][C][G][C][A][G][C] =  4.000;
 int21_ar[G][C][G][C][C][G][C] =  4.000;
 int21_ar[G][C][G][C][G][G][C] =  4.000;
 int21_ar[G][C][G][C][U][G][C] =  4.000;
 int21_ar[G][C][G][G][A][G][C] =  0.800;
 int21_ar[G][C][G][G][C][G][C] =  4.000;
 int21_ar[G][C][G][G][G][G][C] =  2.200;
 int21_ar[G][C][G][G][U][G][C] =  4.000;
 int21_ar[G][C][G][U][A][G][C] =  4.000;
 int21_ar[G][C][G][U][C][G][C] =  4.000;
 int21_ar[G][C][G][U][G][G][C] =  4.000;
 int21_ar[G][C][G][U][U][G][C] =  4.000;
 int21_ar[G][C][U][A][A][G][C] =  4.000;
 int21_ar[G][C][U][A][C][G][C] =  4.000;
 int21_ar[G][C][U][A][G][G][C] =  4.000;
 int21_ar[G][C][U][A][U][G][C] =  4.000;
 int21_ar[G][C][U][C][A][G][C] =  4.000;
 int21_ar[G][C][U][C][C][G][C] =  2.200;
 int21_ar[G][C][U][C][G][G][C] =  4.000;
 int21_ar[G][C][U][C][U][G][C] =  1.300;
 int21_ar[G][C][U][G][A][G][C] =  4.000;
 int21_ar[G][C][U][G][C][G][C] =  4.000;
 int21_ar[G][C][U][G][G][G][C] =  4.000;
 int21_ar[G][C][U][G][U][G][C] =  4.000;
 int21_ar[G][C][U][U][A][G][C] =  4.000;
 int21_ar[G][C][U][U][C][G][C] =  1.700;
 int21_ar[G][C][U][U][G][G][C] =  4.000;
 int21_ar[G][C][U][U][U][G][C] =  1.200;
 int21_ar[G][C][A][A][A][G][U] =  3.200;
 int21_ar[G][C][A][A][C][G][U] =  3.000;
 int21_ar[G][C][A][A][G][G][U] =  2.400;
 int21_ar[G][C][A][A][U][G][U] =  4.800;
 int21_ar[G][C][A][C][A][G][U] =  2.900;
 int21_ar[G][C][A][C][C][G][U] =  2.500;
 int21_ar[G][C][A][C][G][G][U] =  2.400;
 int21_ar[G][C][A][C][U][G][U] =  4.800;
 int21_ar[G][C][A][G][A][G][U] =  1.800;
 int21_ar[G][C][A][G][C][G][U] =  1.400;
 int21_ar[G][C][A][G][G][G][U] =  1.200;
 int21_ar[G][C][A][G][U][G][U] =  4.800;
 int21_ar[G][C][A][U][A][G][U] =  4.800;
 int21_ar[G][C][A][U][C][G][U] =  4.800;
 int21_ar[G][C][A][U][G][G][U] =  4.800;
 int21_ar[G][C][A][U][U][G][U] =  4.800;
 int21_ar[G][C][C][A][A][G][U] =  3.100;
 int21_ar[G][C][C][A][C][G][U] =  3.000;
 int21_ar[G][C][C][A][G][G][U] =  4.800;
 int21_ar[G][C][C][A][U][G][U] =  3.000;
 int21_ar[G][C][C][C][A][G][U] =  3.000;
 int21_ar[G][C][C][C][C][G][U] =  3.300;
 int21_ar[G][C][C][C][G][G][U] =  4.800;
 int21_ar[G][C][C][C][U][G][U] =  3.000;
 int21_ar[G][C][C][G][A][G][U] =  4.800;
 int21_ar[G][C][C][G][C][G][U] =  4.800;
 int21_ar[G][C][C][G][G][G][U] =  4.800;
 int21_ar[G][C][C][G][U][G][U] =  4.800;
 int21_ar[G][C][C][U][A][G][U] =  3.300;
 int21_ar[G][C][C][U][C][G][U] =  2.700;
 int21_ar[G][C][C][U][G][G][U] =  4.800;
 int21_ar[G][C][C][U][U][G][U] =  3.000;
 int21_ar[G][C][G][A][A][G][U] =  2.500;
 int21_ar[G][C][G][A][C][G][U] =  4.800;
 int21_ar[G][C][G][A][G][G][U] =  1.600;
 int21_ar[G][C][G][A][U][G][U] =  4.800;
 int21_ar[G][C][G][C][A][G][U] =  4.800;
 int21_ar[G][C][G][C][C][G][U] =  4.800;
 int21_ar[G][C][G][C][G][G][U] =  4.800;
 int21_ar[G][C][G][C][U][G][U] =  4.800;
 int21_ar[G][C][G][G][A][G][U] =  1.600;
 int21_ar[G][C][G][G][C][G][U] =  4.800;
 int21_ar[G][C][G][G][G][G][U] =  3.000;
 int21_ar[G][C][G][G][U][G][U] =  4.800;
 int21_ar[G][C][G][U][A][G][U] =  4.800;
 int21_ar[G][C][G][U][C][G][U] =  4.800;
 int21_ar[G][C][G][U][G][G][U] =  4.800;
 int21_ar[G][C][G][U][U][G][U] =  4.800;
 int21_ar[G][C][U][A][A][G][U] =  4.800;
 int21_ar[G][C][U][A][C][G][U] =  4.800;
 int21_ar[G][C][U][A][G][G][U] =  4.800;
 int21_ar[G][C][U][A][U][G][U] =  4.800;
 int21_ar[G][C][U][C][A][G][U] =  4.800;
 int21_ar[G][C][U][C][C][G][U] =  3.000;
 int21_ar[G][C][U][C][G][G][U] =  4.800;
 int21_ar[G][C][U][C][U][G][U] =  2.100;
 int21_ar[G][C][U][G][A][G][U] =  4.800;
 int21_ar[G][C][U][G][C][G][U] =  4.800;
 int21_ar[G][C][U][G][G][G][U] =  4.800;
 int21_ar[G][C][U][G][U][G][U] =  4.800;
 int21_ar[G][C][U][U][A][G][U] =  4.800;
 int21_ar[G][C][U][U][C][G][U] =  2.500;
 int21_ar[G][C][U][U][G][G][U] =  4.800;
 int21_ar[G][C][U][U][U][G][U] =  2.000;
 int21_ar[G][C][A][A][A][U][A] =  3.200;
 int21_ar[G][C][A][A][C][U][A] =  3.000;
 int21_ar[G][C][A][A][G][U][A] =  2.400;
 int21_ar[G][C][A][A][U][U][A] =  4.800;
 int21_ar[G][C][A][C][A][U][A] =  2.900;
 int21_ar[G][C][A][C][C][U][A] =  2.500;
 int21_ar[G][C][A][C][G][U][A] =  2.400;
 int21_ar[G][C][A][C][U][U][A] =  4.800;
 int21_ar[G][C][A][G][A][U][A] =  1.800;
 int21_ar[G][C][A][G][C][U][A] =  1.400;
 int21_ar[G][C][A][G][G][U][A] =  1.200;
 int21_ar[G][C][A][G][U][U][A] =  4.800;
 int21_ar[G][C][A][U][A][U][A] =  4.800;
 int21_ar[G][C][A][U][C][U][A] =  4.800;
 int21_ar[G][C][A][U][G][U][A] =  4.800;
 int21_ar[G][C][A][U][U][U][A] =  4.800;
 int21_ar[G][C][C][A][A][U][A] =  3.100;
 int21_ar[G][C][C][A][C][U][A] =  3.000;
 int21_ar[G][C][C][A][G][U][A] =  4.800;
 int21_ar[G][C][C][A][U][U][A] =  3.000;
 int21_ar[G][C][C][C][A][U][A] =  3.000;
 int21_ar[G][C][C][C][C][U][A] =  3.300;
 int21_ar[G][C][C][C][G][U][A] =  4.800;
 int21_ar[G][C][C][C][U][U][A] =  3.000;
 int21_ar[G][C][C][G][A][U][A] =  4.800;
 int21_ar[G][C][C][G][C][U][A] =  4.800;
 int21_ar[G][C][C][G][G][U][A] =  4.800;
 int21_ar[G][C][C][G][U][U][A] =  4.800;
 int21_ar[G][C][C][U][A][U][A] =  3.300;
 int21_ar[G][C][C][U][C][U][A] =  2.700;
 int21_ar[G][C][C][U][G][U][A] =  4.800;
 int21_ar[G][C][C][U][U][U][A] =  3.000;
 int21_ar[G][C][G][A][A][U][A] =  2.500;
 int21_ar[G][C][G][A][C][U][A] =  4.800;
 int21_ar[G][C][G][A][G][U][A] =  1.600;
 int21_ar[G][C][G][A][U][U][A] =  4.800;
 int21_ar[G][C][G][C][A][U][A] =  4.800;
 int21_ar[G][C][G][C][C][U][A] =  4.800;
 int21_ar[G][C][G][C][G][U][A] =  4.800;
 int21_ar[G][C][G][C][U][U][A] =  4.800;
 int21_ar[G][C][G][G][A][U][A] =  1.600;
 int21_ar[G][C][G][G][C][U][A] =  4.800;
 int21_ar[G][C][G][G][G][U][A] =  3.000;
 int21_ar[G][C][G][G][U][U][A] =  4.800;
 int21_ar[G][C][G][U][A][U][A] =  4.800;
 int21_ar[G][C][G][U][C][U][A] =  4.800;
 int21_ar[G][C][G][U][G][U][A] =  4.800;
 int21_ar[G][C][G][U][U][U][A] =  4.800;
 int21_ar[G][C][U][A][A][U][A] =  4.800;
 int21_ar[G][C][U][A][C][U][A] =  4.800;
 int21_ar[G][C][U][A][G][U][A] =  4.800;
 int21_ar[G][C][U][A][U][U][A] =  4.800;
 int21_ar[G][C][U][C][A][U][A] =  4.800;
 int21_ar[G][C][U][C][C][U][A] =  3.000;
 int21_ar[G][C][U][C][G][U][A] =  4.800;
 int21_ar[G][C][U][C][U][U][A] =  2.100;
 int21_ar[G][C][U][G][A][U][A] =  4.800;
 int21_ar[G][C][U][G][C][U][A] =  4.800;
 int21_ar[G][C][U][G][G][U][A] =  4.800;
 int21_ar[G][C][U][G][U][U][A] =  4.800;
 int21_ar[G][C][U][U][A][U][A] =  4.800;
 int21_ar[G][C][U][U][C][U][A] =  2.500;
 int21_ar[G][C][U][U][G][U][A] =  4.800;
 int21_ar[G][C][U][U][U][U][A] =  2.000;
 int21_ar[G][C][A][A][A][U][G] =  3.200;
 int21_ar[G][C][A][A][C][U][G] =  3.000;
 int21_ar[G][C][A][A][G][U][G] =  2.400;
 int21_ar[G][C][A][A][U][U][G] =  4.800;
 int21_ar[G][C][A][C][A][U][G] =  2.900;
 int21_ar[G][C][A][C][C][U][G] =  2.500;
 int21_ar[G][C][A][C][G][U][G] =  2.400;
 int21_ar[G][C][A][C][U][U][G] =  4.800;
 int21_ar[G][C][A][G][A][U][G] =  1.800;
 int21_ar[G][C][A][G][C][U][G] =  1.400;
 int21_ar[G][C][A][G][G][U][G] =  1.200;
 int21_ar[G][C][A][G][U][U][G] =  4.800;
 int21_ar[G][C][A][U][A][U][G] =  4.800;
 int21_ar[G][C][A][U][C][U][G] =  4.800;
 int21_ar[G][C][A][U][G][U][G] =  4.800;
 int21_ar[G][C][A][U][U][U][G] =  4.800;
 int21_ar[G][C][C][A][A][U][G] =  3.100;
 int21_ar[G][C][C][A][C][U][G] =  3.000;
 int21_ar[G][C][C][A][G][U][G] =  4.800;
 int21_ar[G][C][C][A][U][U][G] =  3.000;
 int21_ar[G][C][C][C][A][U][G] =  3.000;
 int21_ar[G][C][C][C][C][U][G] =  3.300;
 int21_ar[G][C][C][C][G][U][G] =  4.800;
 int21_ar[G][C][C][C][U][U][G] =  3.000;
 int21_ar[G][C][C][G][A][U][G] =  4.800;
 int21_ar[G][C][C][G][C][U][G] =  4.800;
 int21_ar[G][C][C][G][G][U][G] =  4.800;
 int21_ar[G][C][C][G][U][U][G] =  4.800;
 int21_ar[G][C][C][U][A][U][G] =  3.300;
 int21_ar[G][C][C][U][C][U][G] =  2.700;
 int21_ar[G][C][C][U][G][U][G] =  4.800;
 int21_ar[G][C][C][U][U][U][G] =  3.000;
 int21_ar[G][C][G][A][A][U][G] =  2.500;
 int21_ar[G][C][G][A][C][U][G] =  4.800;
 int21_ar[G][C][G][A][G][U][G] =  1.600;
 int21_ar[G][C][G][A][U][U][G] =  4.800;
 int21_ar[G][C][G][C][A][U][G] =  4.800;
 int21_ar[G][C][G][C][C][U][G] =  4.800;
 int21_ar[G][C][G][C][G][U][G] =  4.800;
 int21_ar[G][C][G][C][U][U][G] =  4.800;
 int21_ar[G][C][G][G][A][U][G] =  1.600;
 int21_ar[G][C][G][G][C][U][G] =  4.800;
 int21_ar[G][C][G][G][G][U][G] =  3.000;
 int21_ar[G][C][G][G][U][U][G] =  4.800;
 int21_ar[G][C][G][U][A][U][G] =  4.800;
 int21_ar[G][C][G][U][C][U][G] =  4.800;
 int21_ar[G][C][G][U][G][U][G] =  4.800;
 int21_ar[G][C][G][U][U][U][G] =  4.800;
 int21_ar[G][C][U][A][A][U][G] =  4.800;
 int21_ar[G][C][U][A][C][U][G] =  4.800;
 int21_ar[G][C][U][A][G][U][G] =  4.800;
 int21_ar[G][C][U][A][U][U][G] =  4.800;
 int21_ar[G][C][U][C][A][U][G] =  4.800;
 int21_ar[G][C][U][C][C][U][G] =  3.000;
 int21_ar[G][C][U][C][G][U][G] =  4.800;
 int21_ar[G][C][U][C][U][U][G] =  2.100;
 int21_ar[G][C][U][G][A][U][G] =  4.800;
 int21_ar[G][C][U][G][C][U][G] =  4.800;
 int21_ar[G][C][U][G][G][U][G] =  4.800;
 int21_ar[G][C][U][G][U][U][G] =  4.800;
 int21_ar[G][C][U][U][A][U][G] =  4.800;
 int21_ar[G][C][U][U][C][U][G] =  2.500;
 int21_ar[G][C][U][U][G][U][G] =  4.800;
 int21_ar[G][C][U][U][U][U][G] =  2.000;
 int21_ar[G][U][A][A][A][A][U] =  3.900;
 int21_ar[G][U][A][A][C][A][U] =  3.700;
 int21_ar[G][U][A][A][G][A][U] =  3.100;
 int21_ar[G][U][A][A][U][A][U] =  5.500;
 int21_ar[G][U][A][C][A][A][U] =  3.600;
 int21_ar[G][U][A][C][C][A][U] =  3.200;
 int21_ar[G][U][A][C][G][A][U] =  3.100;
 int21_ar[G][U][A][C][U][A][U] =  5.500;
 int21_ar[G][U][A][G][A][A][U] =  2.500;
 int21_ar[G][U][A][G][C][A][U] =  2.100;
 int21_ar[G][U][A][G][G][A][U] =  1.900;
 int21_ar[G][U][A][G][U][A][U] =  5.500;
 int21_ar[G][U][A][U][A][A][U] =  5.500;
 int21_ar[G][U][A][U][C][A][U] =  5.500;
 int21_ar[G][U][A][U][G][A][U] =  5.500;
 int21_ar[G][U][A][U][U][A][U] =  5.500;
 int21_ar[G][U][C][A][A][A][U] =  3.800;
 int21_ar[G][U][C][A][C][A][U] =  3.700;
 int21_ar[G][U][C][A][G][A][U] =  5.500;
 int21_ar[G][U][C][A][U][A][U] =  3.700;
 int21_ar[G][U][C][C][A][A][U] =  3.700;
 int21_ar[G][U][C][C][C][A][U] =  4.000;
 int21_ar[G][U][C][C][G][A][U] =  5.500;
 int21_ar[G][U][C][C][U][A][U] =  3.700;
 int21_ar[G][U][C][G][A][A][U] =  5.500;
 int21_ar[G][U][C][G][C][A][U] =  5.500;
 int21_ar[G][U][C][G][G][A][U] =  5.500;
 int21_ar[G][U][C][G][U][A][U] =  5.500;
 int21_ar[G][U][C][U][A][A][U] =  4.000;
 int21_ar[G][U][C][U][C][A][U] =  3.400;
 int21_ar[G][U][C][U][G][A][U] =  5.500;
 int21_ar[G][U][C][U][U][A][U] =  3.700;
 int21_ar[G][U][G][A][A][A][U] =  3.200;
 int21_ar[G][U][G][A][C][A][U] =  5.500;
 int21_ar[G][U][G][A][G][A][U] =  2.300;
 int21_ar[G][U][G][A][U][A][U] =  5.500;
 int21_ar[G][U][G][C][A][A][U] =  5.500;
 int21_ar[G][U][G][C][C][A][U] =  5.500;
 int21_ar[G][U][G][C][G][A][U] =  5.500;
 int21_ar[G][U][G][C][U][A][U] =  5.500;
 int21_ar[G][U][G][G][A][A][U] =  2.300;
 int21_ar[G][U][G][G][C][A][U] =  5.500;
 int21_ar[G][U][G][G][G][A][U] =  3.700;
 int21_ar[G][U][G][G][U][A][U] =  5.500;
 int21_ar[G][U][G][U][A][A][U] =  5.500;
 int21_ar[G][U][G][U][C][A][U] =  5.500;
 int21_ar[G][U][G][U][G][A][U] =  5.500;
 int21_ar[G][U][G][U][U][A][U] =  5.500;
 int21_ar[G][U][U][A][A][A][U] =  5.500;
 int21_ar[G][U][U][A][C][A][U] =  5.500;
 int21_ar[G][U][U][A][G][A][U] =  5.500;
 int21_ar[G][U][U][A][U][A][U] =  5.500;
 int21_ar[G][U][U][C][A][A][U] =  5.500;
 int21_ar[G][U][U][C][C][A][U] =  3.700;
 int21_ar[G][U][U][C][G][A][U] =  5.500;
 int21_ar[G][U][U][C][U][A][U] =  2.800;
 int21_ar[G][U][U][G][A][A][U] =  5.500;
 int21_ar[G][U][U][G][C][A][U] =  5.500;
 int21_ar[G][U][U][G][G][A][U] =  5.500;
 int21_ar[G][U][U][G][U][A][U] =  5.500;
 int21_ar[G][U][U][U][A][A][U] =  5.500;
 int21_ar[G][U][U][U][C][A][U] =  3.200;
 int21_ar[G][U][U][U][G][A][U] =  5.500;
 int21_ar[G][U][U][U][U][A][U] =  2.700;
 int21_ar[G][U][A][A][A][C][G] =  3.200;
 int21_ar[G][U][A][A][C][C][G] =  3.000;
 int21_ar[G][U][A][A][G][C][G] =  2.400;
 int21_ar[G][U][A][A][U][C][G] =  4.800;
 int21_ar[G][U][A][C][A][C][G] =  2.900;
 int21_ar[G][U][A][C][C][C][G] =  2.500;
 int21_ar[G][U][A][C][G][C][G] =  2.400;
 int21_ar[G][U][A][C][U][C][G] =  4.800;
 int21_ar[G][U][A][G][A][C][G] =  1.800;
 int21_ar[G][U][A][G][C][C][G] =  1.400;
 int21_ar[G][U][A][G][G][C][G] =  1.200;
 int21_ar[G][U][A][G][U][C][G] =  4.800;
 int21_ar[G][U][A][U][A][C][G] =  4.800;
 int21_ar[G][U][A][U][C][C][G] =  4.800;
 int21_ar[G][U][A][U][G][C][G] =  4.800;
 int21_ar[G][U][A][U][U][C][G] =  4.800;
 int21_ar[G][U][C][A][A][C][G] =  3.100;
 int21_ar[G][U][C][A][C][C][G] =  3.000;
 int21_ar[G][U][C][A][G][C][G] =  4.800;
 int21_ar[G][U][C][A][U][C][G] =  3.000;
 int21_ar[G][U][C][C][A][C][G] =  3.000;
 int21_ar[G][U][C][C][C][C][G] =  3.300;
 int21_ar[G][U][C][C][G][C][G] =  4.800;
 int21_ar[G][U][C][C][U][C][G] =  3.000;
 int21_ar[G][U][C][G][A][C][G] =  4.800;
 int21_ar[G][U][C][G][C][C][G] =  4.800;
 int21_ar[G][U][C][G][G][C][G] =  4.800;
 int21_ar[G][U][C][G][U][C][G] =  4.800;
 int21_ar[G][U][C][U][A][C][G] =  3.300;
 int21_ar[G][U][C][U][C][C][G] =  2.700;
 int21_ar[G][U][C][U][G][C][G] =  4.800;
 int21_ar[G][U][C][U][U][C][G] =  3.000;
 int21_ar[G][U][G][A][A][C][G] =  2.500;
 int21_ar[G][U][G][A][C][C][G] =  4.800;
 int21_ar[G][U][G][A][G][C][G] =  1.600;
 int21_ar[G][U][G][A][U][C][G] =  4.800;
 int21_ar[G][U][G][C][A][C][G] =  4.800;
 int21_ar[G][U][G][C][C][C][G] =  4.800;
 int21_ar[G][U][G][C][G][C][G] =  4.800;
 int21_ar[G][U][G][C][U][C][G] =  4.800;
 int21_ar[G][U][G][G][A][C][G] =  1.600;
 int21_ar[G][U][G][G][C][C][G] =  4.800;
 int21_ar[G][U][G][G][G][C][G] =  3.000;
 int21_ar[G][U][G][G][U][C][G] =  4.800;
 int21_ar[G][U][G][U][A][C][G] =  4.800;
 int21_ar[G][U][G][U][C][C][G] =  4.800;
 int21_ar[G][U][G][U][G][C][G] =  4.800;
 int21_ar[G][U][G][U][U][C][G] =  4.800;
 int21_ar[G][U][U][A][A][C][G] =  4.800;
 int21_ar[G][U][U][A][C][C][G] =  4.800;
 int21_ar[G][U][U][A][G][C][G] =  4.800;
 int21_ar[G][U][U][A][U][C][G] =  4.800;
 int21_ar[G][U][U][C][A][C][G] =  4.800;
 int21_ar[G][U][U][C][C][C][G] =  3.000;
 int21_ar[G][U][U][C][G][C][G] =  4.800;
 int21_ar[G][U][U][C][U][C][G] =  2.100;
 int21_ar[G][U][U][G][A][C][G] =  4.800;
 int21_ar[G][U][U][G][C][C][G] =  4.800;
 int21_ar[G][U][U][G][G][C][G] =  4.800;
 int21_ar[G][U][U][G][U][C][G] =  4.800;
 int21_ar[G][U][U][U][A][C][G] =  4.800;
 int21_ar[G][U][U][U][C][C][G] =  2.500;
 int21_ar[G][U][U][U][G][C][G] =  4.800;
 int21_ar[G][U][U][U][U][C][G] =  2.000;
 int21_ar[G][U][A][A][A][G][C] =  3.200;
 int21_ar[G][U][A][A][C][G][C] =  3.000;
 int21_ar[G][U][A][A][G][G][C] =  2.400;
 int21_ar[G][U][A][A][U][G][C] =  4.800;
 int21_ar[G][U][A][C][A][G][C] =  2.900;
 int21_ar[G][U][A][C][C][G][C] =  2.500;
 int21_ar[G][U][A][C][G][G][C] =  2.400;
 int21_ar[G][U][A][C][U][G][C] =  4.800;
 int21_ar[G][U][A][G][A][G][C] =  1.800;
 int21_ar[G][U][A][G][C][G][C] =  1.400;
 int21_ar[G][U][A][G][G][G][C] =  1.200;
 int21_ar[G][U][A][G][U][G][C] =  4.800;
 int21_ar[G][U][A][U][A][G][C] =  4.800;
 int21_ar[G][U][A][U][C][G][C] =  4.800;
 int21_ar[G][U][A][U][G][G][C] =  4.800;
 int21_ar[G][U][A][U][U][G][C] =  4.800;
 int21_ar[G][U][C][A][A][G][C] =  3.100;
 int21_ar[G][U][C][A][C][G][C] =  3.000;
 int21_ar[G][U][C][A][G][G][C] =  4.800;
 int21_ar[G][U][C][A][U][G][C] =  3.000;
 int21_ar[G][U][C][C][A][G][C] =  3.000;
 int21_ar[G][U][C][C][C][G][C] =  3.300;
 int21_ar[G][U][C][C][G][G][C] =  4.800;
 int21_ar[G][U][C][C][U][G][C] =  3.000;
 int21_ar[G][U][C][G][A][G][C] =  4.800;
 int21_ar[G][U][C][G][C][G][C] =  4.800;
 int21_ar[G][U][C][G][G][G][C] =  4.800;
 int21_ar[G][U][C][G][U][G][C] =  4.800;
 int21_ar[G][U][C][U][A][G][C] =  3.300;
 int21_ar[G][U][C][U][C][G][C] =  2.700;
 int21_ar[G][U][C][U][G][G][C] =  4.800;
 int21_ar[G][U][C][U][U][G][C] =  3.000;
 int21_ar[G][U][G][A][A][G][C] =  2.500;
 int21_ar[G][U][G][A][C][G][C] =  4.800;
 int21_ar[G][U][G][A][G][G][C] =  1.600;
 int21_ar[G][U][G][A][U][G][C] =  4.800;
 int21_ar[G][U][G][C][A][G][C] =  4.800;
 int21_ar[G][U][G][C][C][G][C] =  4.800;
 int21_ar[G][U][G][C][G][G][C] =  4.800;
 int21_ar[G][U][G][C][U][G][C] =  4.800;
 int21_ar[G][U][G][G][A][G][C] =  1.600;
 int21_ar[G][U][G][G][C][G][C] =  4.800;
 int21_ar[G][U][G][G][G][G][C] =  3.000;
 int21_ar[G][U][G][G][U][G][C] =  4.800;
 int21_ar[G][U][G][U][A][G][C] =  4.800;
 int21_ar[G][U][G][U][C][G][C] =  4.800;
 int21_ar[G][U][G][U][G][G][C] =  4.800;
 int21_ar[G][U][G][U][U][G][C] =  4.800;
 int21_ar[G][U][U][A][A][G][C] =  4.800;
 int21_ar[G][U][U][A][C][G][C] =  4.800;
 int21_ar[G][U][U][A][G][G][C] =  4.800;
 int21_ar[G][U][U][A][U][G][C] =  4.800;
 int21_ar[G][U][U][C][A][G][C] =  4.800;
 int21_ar[G][U][U][C][C][G][C] =  3.000;
 int21_ar[G][U][U][C][G][G][C] =  4.800;
 int21_ar[G][U][U][C][U][G][C] =  2.100;
 int21_ar[G][U][U][G][A][G][C] =  4.800;
 int21_ar[G][U][U][G][C][G][C] =  4.800;
 int21_ar[G][U][U][G][G][G][C] =  4.800;
 int21_ar[G][U][U][G][U][G][C] =  4.800;
 int21_ar[G][U][U][U][A][G][C] =  4.800;
 int21_ar[G][U][U][U][C][G][C] =  2.500;
 int21_ar[G][U][U][U][G][G][C] =  4.800;
 int21_ar[G][U][U][U][U][G][C] =  2.000;
 int21_ar[G][U][A][A][A][G][U] =  3.900;
 int21_ar[G][U][A][A][C][G][U] =  3.700;
 int21_ar[G][U][A][A][G][G][U] =  3.100;
 int21_ar[G][U][A][A][U][G][U] =  5.500;
 int21_ar[G][U][A][C][A][G][U] =  3.600;
 int21_ar[G][U][A][C][C][G][U] =  3.200;
 int21_ar[G][U][A][C][G][G][U] =  3.100;
 int21_ar[G][U][A][C][U][G][U] =  5.500;
 int21_ar[G][U][A][G][A][G][U] =  2.500;
 int21_ar[G][U][A][G][C][G][U] =  2.100;
 int21_ar[G][U][A][G][G][G][U] =  1.900;
 int21_ar[G][U][A][G][U][G][U] =  5.500;
 int21_ar[G][U][A][U][A][G][U] =  5.500;
 int21_ar[G][U][A][U][C][G][U] =  5.500;
 int21_ar[G][U][A][U][G][G][U] =  5.500;
 int21_ar[G][U][A][U][U][G][U] =  5.500;
 int21_ar[G][U][C][A][A][G][U] =  3.800;
 int21_ar[G][U][C][A][C][G][U] =  3.700;
 int21_ar[G][U][C][A][G][G][U] =  5.500;
 int21_ar[G][U][C][A][U][G][U] =  3.700;
 int21_ar[G][U][C][C][A][G][U] =  3.700;
 int21_ar[G][U][C][C][C][G][U] =  4.000;
 int21_ar[G][U][C][C][G][G][U] =  5.500;
 int21_ar[G][U][C][C][U][G][U] =  3.700;
 int21_ar[G][U][C][G][A][G][U] =  5.500;
 int21_ar[G][U][C][G][C][G][U] =  5.500;
 int21_ar[G][U][C][G][G][G][U] =  5.500;
 int21_ar[G][U][C][G][U][G][U] =  5.500;
 int21_ar[G][U][C][U][A][G][U] =  4.000;
 int21_ar[G][U][C][U][C][G][U] =  3.400;
 int21_ar[G][U][C][U][G][G][U] =  5.500;
 int21_ar[G][U][C][U][U][G][U] =  3.700;
 int21_ar[G][U][G][A][A][G][U] =  3.200;
 int21_ar[G][U][G][A][C][G][U] =  5.500;
 int21_ar[G][U][G][A][G][G][U] =  2.300;
 int21_ar[G][U][G][A][U][G][U] =  5.500;
 int21_ar[G][U][G][C][A][G][U] =  5.500;
 int21_ar[G][U][G][C][C][G][U] =  5.500;
 int21_ar[G][U][G][C][G][G][U] =  5.500;
 int21_ar[G][U][G][C][U][G][U] =  5.500;
 int21_ar[G][U][G][G][A][G][U] =  2.300;
 int21_ar[G][U][G][G][C][G][U] =  5.500;
 int21_ar[G][U][G][G][G][G][U] =  3.700;
 int21_ar[G][U][G][G][U][G][U] =  5.500;
 int21_ar[G][U][G][U][A][G][U] =  5.500;
 int21_ar[G][U][G][U][C][G][U] =  5.500;
 int21_ar[G][U][G][U][G][G][U] =  5.500;
 int21_ar[G][U][G][U][U][G][U] =  5.500;
 int21_ar[G][U][U][A][A][G][U] =  5.500;
 int21_ar[G][U][U][A][C][G][U] =  5.500;
 int21_ar[G][U][U][A][G][G][U] =  5.500;
 int21_ar[G][U][U][A][U][G][U] =  5.500;
 int21_ar[G][U][U][C][A][G][U] =  5.500;
 int21_ar[G][U][U][C][C][G][U] =  3.700;
 int21_ar[G][U][U][C][G][G][U] =  5.500;
 int21_ar[G][U][U][C][U][G][U] =  2.800;
 int21_ar[G][U][U][G][A][G][U] =  5.500;
 int21_ar[G][U][U][G][C][G][U] =  5.500;
 int21_ar[G][U][U][G][G][G][U] =  5.500;
 int21_ar[G][U][U][G][U][G][U] =  5.500;
 int21_ar[G][U][U][U][A][G][U] =  5.500;
 int21_ar[G][U][U][U][C][G][U] =  3.200;
 int21_ar[G][U][U][U][G][G][U] =  5.500;
 int21_ar[G][U][U][U][U][G][U] =  2.700;
 int21_ar[G][U][A][A][A][U][A] =  3.900;
 int21_ar[G][U][A][A][C][U][A] =  3.700;
 int21_ar[G][U][A][A][G][U][A] =  3.100;
 int21_ar[G][U][A][A][U][U][A] =  5.500;
 int21_ar[G][U][A][C][A][U][A] =  3.600;
 int21_ar[G][U][A][C][C][U][A] =  3.200;
 int21_ar[G][U][A][C][G][U][A] =  3.100;
 int21_ar[G][U][A][C][U][U][A] =  5.500;
 int21_ar[G][U][A][G][A][U][A] =  2.500;
 int21_ar[G][U][A][G][C][U][A] =  2.100;
 int21_ar[G][U][A][G][G][U][A] =  1.900;
 int21_ar[G][U][A][G][U][U][A] =  5.500;
 int21_ar[G][U][A][U][A][U][A] =  5.500;
 int21_ar[G][U][A][U][C][U][A] =  5.500;
 int21_ar[G][U][A][U][G][U][A] =  5.500;
 int21_ar[G][U][A][U][U][U][A] =  5.500;
 int21_ar[G][U][C][A][A][U][A] =  3.800;
 int21_ar[G][U][C][A][C][U][A] =  3.700;
 int21_ar[G][U][C][A][G][U][A] =  5.500;
 int21_ar[G][U][C][A][U][U][A] =  3.700;
 int21_ar[G][U][C][C][A][U][A] =  3.700;
 int21_ar[G][U][C][C][C][U][A] =  4.000;
 int21_ar[G][U][C][C][G][U][A] =  5.500;
 int21_ar[G][U][C][C][U][U][A] =  3.700;
 int21_ar[G][U][C][G][A][U][A] =  5.500;
 int21_ar[G][U][C][G][C][U][A] =  5.500;
 int21_ar[G][U][C][G][G][U][A] =  5.500;
 int21_ar[G][U][C][G][U][U][A] =  5.500;
 int21_ar[G][U][C][U][A][U][A] =  4.000;
 int21_ar[G][U][C][U][C][U][A] =  3.400;
 int21_ar[G][U][C][U][G][U][A] =  5.500;
 int21_ar[G][U][C][U][U][U][A] =  3.700;
 int21_ar[G][U][G][A][A][U][A] =  3.200;
 int21_ar[G][U][G][A][C][U][A] =  5.500;
 int21_ar[G][U][G][A][G][U][A] =  2.300;
 int21_ar[G][U][G][A][U][U][A] =  5.500;
 int21_ar[G][U][G][C][A][U][A] =  5.500;
 int21_ar[G][U][G][C][C][U][A] =  5.500;
 int21_ar[G][U][G][C][G][U][A] =  5.500;
 int21_ar[G][U][G][C][U][U][A] =  5.500;
 int21_ar[G][U][G][G][A][U][A] =  2.300;
 int21_ar[G][U][G][G][C][U][A] =  5.500;
 int21_ar[G][U][G][G][G][U][A] =  3.700;
 int21_ar[G][U][G][G][U][U][A] =  5.500;
 int21_ar[G][U][G][U][A][U][A] =  5.500;
 int21_ar[G][U][G][U][C][U][A] =  5.500;
 int21_ar[G][U][G][U][G][U][A] =  5.500;
 int21_ar[G][U][G][U][U][U][A] =  5.500;
 int21_ar[G][U][U][A][A][U][A] =  5.500;
 int21_ar[G][U][U][A][C][U][A] =  5.500;
 int21_ar[G][U][U][A][G][U][A] =  5.500;
 int21_ar[G][U][U][A][U][U][A] =  5.500;
 int21_ar[G][U][U][C][A][U][A] =  5.500;
 int21_ar[G][U][U][C][C][U][A] =  3.700;
 int21_ar[G][U][U][C][G][U][A] =  5.500;
 int21_ar[G][U][U][C][U][U][A] =  2.800;
 int21_ar[G][U][U][G][A][U][A] =  5.500;
 int21_ar[G][U][U][G][C][U][A] =  5.500;
 int21_ar[G][U][U][G][G][U][A] =  5.500;
 int21_ar[G][U][U][G][U][U][A] =  5.500;
 int21_ar[G][U][U][U][A][U][A] =  5.500;
 int21_ar[G][U][U][U][C][U][A] =  3.200;
 int21_ar[G][U][U][U][G][U][A] =  5.500;
 int21_ar[G][U][U][U][U][U][A] =  2.700;
 int21_ar[G][U][A][A][A][U][G] =  3.900;
 int21_ar[G][U][A][A][C][U][G] =  3.700;
 int21_ar[G][U][A][A][G][U][G] =  3.100;
 int21_ar[G][U][A][A][U][U][G] =  5.500;
 int21_ar[G][U][A][C][A][U][G] =  3.600;
 int21_ar[G][U][A][C][C][U][G] =  3.200;
 int21_ar[G][U][A][C][G][U][G] =  3.100;
 int21_ar[G][U][A][C][U][U][G] =  5.500;
 int21_ar[G][U][A][G][A][U][G] =  2.500;
 int21_ar[G][U][A][G][C][U][G] =  2.100;
 int21_ar[G][U][A][G][G][U][G] =  1.900;
 int21_ar[G][U][A][G][U][U][G] =  5.500;
 int21_ar[G][U][A][U][A][U][G] =  5.500;
 int21_ar[G][U][A][U][C][U][G] =  5.500;
 int21_ar[G][U][A][U][G][U][G] =  5.500;
 int21_ar[G][U][A][U][U][U][G] =  5.500;
 int21_ar[G][U][C][A][A][U][G] =  3.800;
 int21_ar[G][U][C][A][C][U][G] =  3.700;
 int21_ar[G][U][C][A][G][U][G] =  5.500;
 int21_ar[G][U][C][A][U][U][G] =  3.700;
 int21_ar[G][U][C][C][A][U][G] =  3.700;
 int21_ar[G][U][C][C][C][U][G] =  4.000;
 int21_ar[G][U][C][C][G][U][G] =  5.500;
 int21_ar[G][U][C][C][U][U][G] =  3.700;
 int21_ar[G][U][C][G][A][U][G] =  5.500;
 int21_ar[G][U][C][G][C][U][G] =  5.500;
 int21_ar[G][U][C][G][G][U][G] =  5.500;
 int21_ar[G][U][C][G][U][U][G] =  5.500;
 int21_ar[G][U][C][U][A][U][G] =  4.000;
 int21_ar[G][U][C][U][C][U][G] =  3.400;
 int21_ar[G][U][C][U][G][U][G] =  5.500;
 int21_ar[G][U][C][U][U][U][G] =  3.700;
 int21_ar[G][U][G][A][A][U][G] =  3.200;
 int21_ar[G][U][G][A][C][U][G] =  5.500;
 int21_ar[G][U][G][A][G][U][G] =  2.300;
 int21_ar[G][U][G][A][U][U][G] =  5.500;
 int21_ar[G][U][G][C][A][U][G] =  5.500;
 int21_ar[G][U][G][C][C][U][G] =  5.500;
 int21_ar[G][U][G][C][G][U][G] =  5.500;
 int21_ar[G][U][G][C][U][U][G] =  5.500;
 int21_ar[G][U][G][G][A][U][G] =  2.300;
 int21_ar[G][U][G][G][C][U][G] =  5.500;
 int21_ar[G][U][G][G][G][U][G] =  3.700;
 int21_ar[G][U][G][G][U][U][G] =  5.500;
 int21_ar[G][U][G][U][A][U][G] =  5.500;
 int21_ar[G][U][G][U][C][U][G] =  5.500;
 int21_ar[G][U][G][U][G][U][G] =  5.500;
 int21_ar[G][U][G][U][U][U][G] =  5.500;
 int21_ar[G][U][U][A][A][U][G] =  5.500;
 int21_ar[G][U][U][A][C][U][G] =  5.500;
 int21_ar[G][U][U][A][G][U][G] =  5.500;
 int21_ar[G][U][U][A][U][U][G] =  5.500;
 int21_ar[G][U][U][C][A][U][G] =  5.500;
 int21_ar[G][U][U][C][C][U][G] =  3.700;
 int21_ar[G][U][U][C][G][U][G] =  5.500;
 int21_ar[G][U][U][C][U][U][G] =  2.800;
 int21_ar[G][U][U][G][A][U][G] =  5.500;
 int21_ar[G][U][U][G][C][U][G] =  5.500;
 int21_ar[G][U][U][G][G][U][G] =  5.500;
 int21_ar[G][U][U][G][U][U][G] =  5.500;
 int21_ar[G][U][U][U][A][U][G] =  5.500;
 int21_ar[G][U][U][U][C][U][G] =  3.200;
 int21_ar[G][U][U][U][G][U][G] =  5.500;
 int21_ar[G][U][U][U][U][U][G] =  2.700;
 int21_ar[U][A][A][A][A][A][U] =  3.900;
 int21_ar[U][A][A][A][C][A][U] =  3.700;
 int21_ar[U][A][A][A][G][A][U] =  3.100;
 int21_ar[U][A][A][A][U][A][U] =  5.500;
 int21_ar[U][A][A][C][A][A][U] =  3.600;
 int21_ar[U][A][A][C][C][A][U] =  3.200;
 int21_ar[U][A][A][C][G][A][U] =  3.100;
 int21_ar[U][A][A][C][U][A][U] =  5.500;
 int21_ar[U][A][A][G][A][A][U] =  2.500;
 int21_ar[U][A][A][G][C][A][U] =  2.100;
 int21_ar[U][A][A][G][G][A][U] =  1.900;
 int21_ar[U][A][A][G][U][A][U] =  5.500;
 int21_ar[U][A][A][U][A][A][U] =  5.500;
 int21_ar[U][A][A][U][C][A][U] =  5.500;
 int21_ar[U][A][A][U][G][A][U] =  5.500;
 int21_ar[U][A][A][U][U][A][U] =  5.500;
 int21_ar[U][A][C][A][A][A][U] =  3.800;
 int21_ar[U][A][C][A][C][A][U] =  3.700;
 int21_ar[U][A][C][A][G][A][U] =  5.500;
 int21_ar[U][A][C][A][U][A][U] =  3.700;
 int21_ar[U][A][C][C][A][A][U] =  3.700;
 int21_ar[U][A][C][C][C][A][U] =  4.000;
 int21_ar[U][A][C][C][G][A][U] =  5.500;
 int21_ar[U][A][C][C][U][A][U] =  3.700;
 int21_ar[U][A][C][G][A][A][U] =  5.500;
 int21_ar[U][A][C][G][C][A][U] =  5.500;
 int21_ar[U][A][C][G][G][A][U] =  5.500;
 int21_ar[U][A][C][G][U][A][U] =  5.500;
 int21_ar[U][A][C][U][A][A][U] =  4.000;
 int21_ar[U][A][C][U][C][A][U] =  3.400;
 int21_ar[U][A][C][U][G][A][U] =  5.500;
 int21_ar[U][A][C][U][U][A][U] =  3.700;
 int21_ar[U][A][G][A][A][A][U] =  3.200;
 int21_ar[U][A][G][A][C][A][U] =  5.500;
 int21_ar[U][A][G][A][G][A][U] =  2.300;
 int21_ar[U][A][G][A][U][A][U] =  5.500;
 int21_ar[U][A][G][C][A][A][U] =  5.500;
 int21_ar[U][A][G][C][C][A][U] =  5.500;
 int21_ar[U][A][G][C][G][A][U] =  5.500;
 int21_ar[U][A][G][C][U][A][U] =  5.500;
 int21_ar[U][A][G][G][A][A][U] =  2.300;
 int21_ar[U][A][G][G][C][A][U] =  5.500;
 int21_ar[U][A][G][G][G][A][U] =  3.700;
 int21_ar[U][A][G][G][U][A][U] =  5.500;
 int21_ar[U][A][G][U][A][A][U] =  5.500;
 int21_ar[U][A][G][U][C][A][U] =  5.500;
 int21_ar[U][A][G][U][G][A][U] =  5.500;
 int21_ar[U][A][G][U][U][A][U] =  5.500;
 int21_ar[U][A][U][A][A][A][U] =  5.500;
 int21_ar[U][A][U][A][C][A][U] =  5.500;
 int21_ar[U][A][U][A][G][A][U] =  5.500;
 int21_ar[U][A][U][A][U][A][U] =  5.500;
 int21_ar[U][A][U][C][A][A][U] =  5.500;
 int21_ar[U][A][U][C][C][A][U] =  3.700;
 int21_ar[U][A][U][C][G][A][U] =  5.500;
 int21_ar[U][A][U][C][U][A][U] =  2.800;
 int21_ar[U][A][U][G][A][A][U] =  5.500;
 int21_ar[U][A][U][G][C][A][U] =  5.500;
 int21_ar[U][A][U][G][G][A][U] =  5.500;
 int21_ar[U][A][U][G][U][A][U] =  5.500;
 int21_ar[U][A][U][U][A][A][U] =  5.500;
 int21_ar[U][A][U][U][C][A][U] =  3.200;
 int21_ar[U][A][U][U][G][A][U] =  5.500;
 int21_ar[U][A][U][U][U][A][U] =  2.700;
 int21_ar[U][A][A][A][A][C][G] =  3.200;
 int21_ar[U][A][A][A][C][C][G] =  3.000;
 int21_ar[U][A][A][A][G][C][G] =  2.400;
 int21_ar[U][A][A][A][U][C][G] =  4.800;
 int21_ar[U][A][A][C][A][C][G] =  2.900;
 int21_ar[U][A][A][C][C][C][G] =  2.500;
 int21_ar[U][A][A][C][G][C][G] =  2.400;
 int21_ar[U][A][A][C][U][C][G] =  4.800;
 int21_ar[U][A][A][G][A][C][G] =  1.800;
 int21_ar[U][A][A][G][C][C][G] =  1.400;
 int21_ar[U][A][A][G][G][C][G] =  1.200;
 int21_ar[U][A][A][G][U][C][G] =  4.800;
 int21_ar[U][A][A][U][A][C][G] =  4.800;
 int21_ar[U][A][A][U][C][C][G] =  4.800;
 int21_ar[U][A][A][U][G][C][G] =  4.800;
 int21_ar[U][A][A][U][U][C][G] =  4.800;
 int21_ar[U][A][C][A][A][C][G] =  3.100;
 int21_ar[U][A][C][A][C][C][G] =  3.000;
 int21_ar[U][A][C][A][G][C][G] =  4.800;
 int21_ar[U][A][C][A][U][C][G] =  3.000;
 int21_ar[U][A][C][C][A][C][G] =  3.000;
 int21_ar[U][A][C][C][C][C][G] =  3.300;
 int21_ar[U][A][C][C][G][C][G] =  4.800;
 int21_ar[U][A][C][C][U][C][G] =  3.000;
 int21_ar[U][A][C][G][A][C][G] =  4.800;
 int21_ar[U][A][C][G][C][C][G] =  4.800;
 int21_ar[U][A][C][G][G][C][G] =  4.800;
 int21_ar[U][A][C][G][U][C][G] =  4.800;
 int21_ar[U][A][C][U][A][C][G] =  3.300;
 int21_ar[U][A][C][U][C][C][G] =  2.700;
 int21_ar[U][A][C][U][G][C][G] =  4.800;
 int21_ar[U][A][C][U][U][C][G] =  3.000;
 int21_ar[U][A][G][A][A][C][G] =  2.500;
 int21_ar[U][A][G][A][C][C][G] =  4.800;
 int21_ar[U][A][G][A][G][C][G] =  1.600;
 int21_ar[U][A][G][A][U][C][G] =  4.800;
 int21_ar[U][A][G][C][A][C][G] =  4.800;
 int21_ar[U][A][G][C][C][C][G] =  4.800;
 int21_ar[U][A][G][C][G][C][G] =  4.800;
 int21_ar[U][A][G][C][U][C][G] =  4.800;
 int21_ar[U][A][G][G][A][C][G] =  1.600;
 int21_ar[U][A][G][G][C][C][G] =  4.800;
 int21_ar[U][A][G][G][G][C][G] =  3.000;
 int21_ar[U][A][G][G][U][C][G] =  4.800;
 int21_ar[U][A][G][U][A][C][G] =  4.800;
 int21_ar[U][A][G][U][C][C][G] =  4.800;
 int21_ar[U][A][G][U][G][C][G] =  4.800;
 int21_ar[U][A][G][U][U][C][G] =  4.800;
 int21_ar[U][A][U][A][A][C][G] =  4.800;
 int21_ar[U][A][U][A][C][C][G] =  4.800;
 int21_ar[U][A][U][A][G][C][G] =  4.800;
 int21_ar[U][A][U][A][U][C][G] =  4.800;
 int21_ar[U][A][U][C][A][C][G] =  4.800;
 int21_ar[U][A][U][C][C][C][G] =  3.000;
 int21_ar[U][A][U][C][G][C][G] =  4.800;
 int21_ar[U][A][U][C][U][C][G] =  2.100;
 int21_ar[U][A][U][G][A][C][G] =  4.800;
 int21_ar[U][A][U][G][C][C][G] =  4.800;
 int21_ar[U][A][U][G][G][C][G] =  4.800;
 int21_ar[U][A][U][G][U][C][G] =  4.800;
 int21_ar[U][A][U][U][A][C][G] =  4.800;
 int21_ar[U][A][U][U][C][C][G] =  2.500;
 int21_ar[U][A][U][U][G][C][G] =  4.800;
 int21_ar[U][A][U][U][U][C][G] =  2.000;
 int21_ar[U][A][A][A][A][G][C] =  3.200;
 int21_ar[U][A][A][A][C][G][C] =  3.000;
 int21_ar[U][A][A][A][G][G][C] =  2.400;
 int21_ar[U][A][A][A][U][G][C] =  4.800;
 int21_ar[U][A][A][C][A][G][C] =  2.900;
 int21_ar[U][A][A][C][C][G][C] =  2.500;
 int21_ar[U][A][A][C][G][G][C] =  2.400;
 int21_ar[U][A][A][C][U][G][C] =  4.800;
 int21_ar[U][A][A][G][A][G][C] =  1.800;
 int21_ar[U][A][A][G][C][G][C] =  1.400;
 int21_ar[U][A][A][G][G][G][C] =  1.200;
 int21_ar[U][A][A][G][U][G][C] =  4.800;
 int21_ar[U][A][A][U][A][G][C] =  4.800;
 int21_ar[U][A][A][U][C][G][C] =  4.800;
 int21_ar[U][A][A][U][G][G][C] =  4.800;
 int21_ar[U][A][A][U][U][G][C] =  4.800;
 int21_ar[U][A][C][A][A][G][C] =  3.100;
 int21_ar[U][A][C][A][C][G][C] =  3.000;
 int21_ar[U][A][C][A][G][G][C] =  4.800;
 int21_ar[U][A][C][A][U][G][C] =  3.000;
 int21_ar[U][A][C][C][A][G][C] =  3.000;
 int21_ar[U][A][C][C][C][G][C] =  3.300;
 int21_ar[U][A][C][C][G][G][C] =  4.800;
 int21_ar[U][A][C][C][U][G][C] =  3.000;
 int21_ar[U][A][C][G][A][G][C] =  4.800;
 int21_ar[U][A][C][G][C][G][C] =  4.800;
 int21_ar[U][A][C][G][G][G][C] =  4.800;
 int21_ar[U][A][C][G][U][G][C] =  4.800;
 int21_ar[U][A][C][U][A][G][C] =  3.300;
 int21_ar[U][A][C][U][C][G][C] =  2.700;
 int21_ar[U][A][C][U][G][G][C] =  4.800;
 int21_ar[U][A][C][U][U][G][C] =  3.000;
 int21_ar[U][A][G][A][A][G][C] =  2.500;
 int21_ar[U][A][G][A][C][G][C] =  4.800;
 int21_ar[U][A][G][A][G][G][C] =  1.600;
 int21_ar[U][A][G][A][U][G][C] =  4.800;
 int21_ar[U][A][G][C][A][G][C] =  4.800;
 int21_ar[U][A][G][C][C][G][C] =  4.800;
 int21_ar[U][A][G][C][G][G][C] =  4.800;
 int21_ar[U][A][G][C][U][G][C] =  4.800;
 int21_ar[U][A][G][G][A][G][C] =  1.600;
 int21_ar[U][A][G][G][C][G][C] =  4.800;
 int21_ar[U][A][G][G][G][G][C] =  3.000;
 int21_ar[U][A][G][G][U][G][C] =  4.800;
 int21_ar[U][A][G][U][A][G][C] =  4.800;
 int21_ar[U][A][G][U][C][G][C] =  4.800;
 int21_ar[U][A][G][U][G][G][C] =  4.800;
 int21_ar[U][A][G][U][U][G][C] =  4.800;
 int21_ar[U][A][U][A][A][G][C] =  4.800;
 int21_ar[U][A][U][A][C][G][C] =  4.800;
 int21_ar[U][A][U][A][G][G][C] =  4.800;
 int21_ar[U][A][U][A][U][G][C] =  4.800;
 int21_ar[U][A][U][C][A][G][C] =  4.800;
 int21_ar[U][A][U][C][C][G][C] =  3.000;
 int21_ar[U][A][U][C][G][G][C] =  4.800;
 int21_ar[U][A][U][C][U][G][C] =  2.100;
 int21_ar[U][A][U][G][A][G][C] =  4.800;
 int21_ar[U][A][U][G][C][G][C] =  4.800;
 int21_ar[U][A][U][G][G][G][C] =  4.800;
 int21_ar[U][A][U][G][U][G][C] =  4.800;
 int21_ar[U][A][U][U][A][G][C] =  4.800;
 int21_ar[U][A][U][U][C][G][C] =  2.500;
 int21_ar[U][A][U][U][G][G][C] =  4.800;
 int21_ar[U][A][U][U][U][G][C] =  2.000;
 int21_ar[U][A][A][A][A][G][U] =  3.900;
 int21_ar[U][A][A][A][C][G][U] =  3.700;
 int21_ar[U][A][A][A][G][G][U] =  3.100;
 int21_ar[U][A][A][A][U][G][U] =  5.500;
 int21_ar[U][A][A][C][A][G][U] =  3.600;
 int21_ar[U][A][A][C][C][G][U] =  3.200;
 int21_ar[U][A][A][C][G][G][U] =  3.100;
 int21_ar[U][A][A][C][U][G][U] =  5.500;
 int21_ar[U][A][A][G][A][G][U] =  2.500;
 int21_ar[U][A][A][G][C][G][U] =  2.100;
 int21_ar[U][A][A][G][G][G][U] =  1.900;
 int21_ar[U][A][A][G][U][G][U] =  5.500;
 int21_ar[U][A][A][U][A][G][U] =  5.500;
 int21_ar[U][A][A][U][C][G][U] =  5.500;
 int21_ar[U][A][A][U][G][G][U] =  5.500;
 int21_ar[U][A][A][U][U][G][U] =  5.500;
 int21_ar[U][A][C][A][A][G][U] =  3.800;
 int21_ar[U][A][C][A][C][G][U] =  3.700;
 int21_ar[U][A][C][A][G][G][U] =  5.500;
 int21_ar[U][A][C][A][U][G][U] =  3.700;
 int21_ar[U][A][C][C][A][G][U] =  3.700;
 int21_ar[U][A][C][C][C][G][U] =  4.000;
 int21_ar[U][A][C][C][G][G][U] =  5.500;
 int21_ar[U][A][C][C][U][G][U] =  3.700;
 int21_ar[U][A][C][G][A][G][U] =  5.500;
 int21_ar[U][A][C][G][C][G][U] =  5.500;
 int21_ar[U][A][C][G][G][G][U] =  5.500;
 int21_ar[U][A][C][G][U][G][U] =  5.500;
 int21_ar[U][A][C][U][A][G][U] =  4.000;
 int21_ar[U][A][C][U][C][G][U] =  3.400;
 int21_ar[U][A][C][U][G][G][U] =  5.500;
 int21_ar[U][A][C][U][U][G][U] =  3.700;
 int21_ar[U][A][G][A][A][G][U] =  3.200;
 int21_ar[U][A][G][A][C][G][U] =  5.500;
 int21_ar[U][A][G][A][G][G][U] =  2.300;
 int21_ar[U][A][G][A][U][G][U] =  5.500;
 int21_ar[U][A][G][C][A][G][U] =  5.500;
 int21_ar[U][A][G][C][C][G][U] =  5.500;
 int21_ar[U][A][G][C][G][G][U] =  5.500;
 int21_ar[U][A][G][C][U][G][U] =  5.500;
 int21_ar[U][A][G][G][A][G][U] =  2.300;
 int21_ar[U][A][G][G][C][G][U] =  5.500;
 int21_ar[U][A][G][G][G][G][U] =  3.700;
 int21_ar[U][A][G][G][U][G][U] =  5.500;
 int21_ar[U][A][G][U][A][G][U] =  5.500;
 int21_ar[U][A][G][U][C][G][U] =  5.500;
 int21_ar[U][A][G][U][G][G][U] =  5.500;
 int21_ar[U][A][G][U][U][G][U] =  5.500;
 int21_ar[U][A][U][A][A][G][U] =  5.500;
 int21_ar[U][A][U][A][C][G][U] =  5.500;
 int21_ar[U][A][U][A][G][G][U] =  5.500;
 int21_ar[U][A][U][A][U][G][U] =  5.500;
 int21_ar[U][A][U][C][A][G][U] =  5.500;
 int21_ar[U][A][U][C][C][G][U] =  3.700;
 int21_ar[U][A][U][C][G][G][U] =  5.500;
 int21_ar[U][A][U][C][U][G][U] =  2.800;
 int21_ar[U][A][U][G][A][G][U] =  5.500;
 int21_ar[U][A][U][G][C][G][U] =  5.500;
 int21_ar[U][A][U][G][G][G][U] =  5.500;
 int21_ar[U][A][U][G][U][G][U] =  5.500;
 int21_ar[U][A][U][U][A][G][U] =  5.500;
 int21_ar[U][A][U][U][C][G][U] =  3.200;
 int21_ar[U][A][U][U][G][G][U] =  5.500;
 int21_ar[U][A][U][U][U][G][U] =  2.700;
 int21_ar[U][A][A][A][A][U][A] =  3.900;
 int21_ar[U][A][A][A][C][U][A] =  3.700;
 int21_ar[U][A][A][A][G][U][A] =  3.100;
 int21_ar[U][A][A][A][U][U][A] =  5.500;
 int21_ar[U][A][A][C][A][U][A] =  3.600;
 int21_ar[U][A][A][C][C][U][A] =  3.200;
 int21_ar[U][A][A][C][G][U][A] =  3.100;
 int21_ar[U][A][A][C][U][U][A] =  5.500;
 int21_ar[U][A][A][G][A][U][A] =  2.500;
 int21_ar[U][A][A][G][C][U][A] =  2.100;
 int21_ar[U][A][A][G][G][U][A] =  1.900;
 int21_ar[U][A][A][G][U][U][A] =  5.500;
 int21_ar[U][A][A][U][A][U][A] =  5.500;
 int21_ar[U][A][A][U][C][U][A] =  5.500;
 int21_ar[U][A][A][U][G][U][A] =  5.500;
 int21_ar[U][A][A][U][U][U][A] =  5.500;
 int21_ar[U][A][C][A][A][U][A] =  3.800;
 int21_ar[U][A][C][A][C][U][A] =  3.700;
 int21_ar[U][A][C][A][G][U][A] =  5.500;
 int21_ar[U][A][C][A][U][U][A] =  3.700;
 int21_ar[U][A][C][C][A][U][A] =  3.700;
 int21_ar[U][A][C][C][C][U][A] =  4.000;
 int21_ar[U][A][C][C][G][U][A] =  5.500;
 int21_ar[U][A][C][C][U][U][A] =  3.700;
 int21_ar[U][A][C][G][A][U][A] =  5.500;
 int21_ar[U][A][C][G][C][U][A] =  5.500;
 int21_ar[U][A][C][G][G][U][A] =  5.500;
 int21_ar[U][A][C][G][U][U][A] =  5.500;
 int21_ar[U][A][C][U][A][U][A] =  4.000;
 int21_ar[U][A][C][U][C][U][A] =  3.400;
 int21_ar[U][A][C][U][G][U][A] =  5.500;
 int21_ar[U][A][C][U][U][U][A] =  3.700;
 int21_ar[U][A][G][A][A][U][A] =  3.200;
 int21_ar[U][A][G][A][C][U][A] =  5.500;
 int21_ar[U][A][G][A][G][U][A] =  2.300;
 int21_ar[U][A][G][A][U][U][A] =  5.500;
 int21_ar[U][A][G][C][A][U][A] =  5.500;
 int21_ar[U][A][G][C][C][U][A] =  5.500;
 int21_ar[U][A][G][C][G][U][A] =  5.500;
 int21_ar[U][A][G][C][U][U][A] =  5.500;
 int21_ar[U][A][G][G][A][U][A] =  2.300;
 int21_ar[U][A][G][G][C][U][A] =  5.500;
 int21_ar[U][A][G][G][G][U][A] =  3.700;
 int21_ar[U][A][G][G][U][U][A] =  5.500;
 int21_ar[U][A][G][U][A][U][A] =  5.500;
 int21_ar[U][A][G][U][C][U][A] =  5.500;
 int21_ar[U][A][G][U][G][U][A] =  5.500;
 int21_ar[U][A][G][U][U][U][A] =  5.500;
 int21_ar[U][A][U][A][A][U][A] =  5.500;
 int21_ar[U][A][U][A][C][U][A] =  5.500;
 int21_ar[U][A][U][A][G][U][A] =  5.500;
 int21_ar[U][A][U][A][U][U][A] =  5.500;
 int21_ar[U][A][U][C][A][U][A] =  5.500;
 int21_ar[U][A][U][C][C][U][A] =  3.700;
 int21_ar[U][A][U][C][G][U][A] =  5.500;
 int21_ar[U][A][U][C][U][U][A] =  2.800;
 int21_ar[U][A][U][G][A][U][A] =  5.500;
 int21_ar[U][A][U][G][C][U][A] =  5.500;
 int21_ar[U][A][U][G][G][U][A] =  5.500;
 int21_ar[U][A][U][G][U][U][A] =  5.500;
 int21_ar[U][A][U][U][A][U][A] =  5.500;
 int21_ar[U][A][U][U][C][U][A] =  3.200;
 int21_ar[U][A][U][U][G][U][A] =  5.500;
 int21_ar[U][A][U][U][U][U][A] =  2.700;
 int21_ar[U][A][A][A][A][U][G] =  3.900;
 int21_ar[U][A][A][A][C][U][G] =  3.700;
 int21_ar[U][A][A][A][G][U][G] =  3.100;
 int21_ar[U][A][A][A][U][U][G] =  5.500;
 int21_ar[U][A][A][C][A][U][G] =  3.600;
 int21_ar[U][A][A][C][C][U][G] =  3.200;
 int21_ar[U][A][A][C][G][U][G] =  3.100;
 int21_ar[U][A][A][C][U][U][G] =  5.500;
 int21_ar[U][A][A][G][A][U][G] =  2.500;
 int21_ar[U][A][A][G][C][U][G] =  2.100;
 int21_ar[U][A][A][G][G][U][G] =  1.900;
 int21_ar[U][A][A][G][U][U][G] =  5.500;
 int21_ar[U][A][A][U][A][U][G] =  5.500;
 int21_ar[U][A][A][U][C][U][G] =  5.500;
 int21_ar[U][A][A][U][G][U][G] =  5.500;
 int21_ar[U][A][A][U][U][U][G] =  5.500;
 int21_ar[U][A][C][A][A][U][G] =  3.800;
 int21_ar[U][A][C][A][C][U][G] =  3.700;
 int21_ar[U][A][C][A][G][U][G] =  5.500;
 int21_ar[U][A][C][A][U][U][G] =  3.700;
 int21_ar[U][A][C][C][A][U][G] =  3.700;
 int21_ar[U][A][C][C][C][U][G] =  4.000;
 int21_ar[U][A][C][C][G][U][G] =  5.500;
 int21_ar[U][A][C][C][U][U][G] =  3.700;
 int21_ar[U][A][C][G][A][U][G] =  5.500;
 int21_ar[U][A][C][G][C][U][G] =  5.500;
 int21_ar[U][A][C][G][G][U][G] =  5.500;
 int21_ar[U][A][C][G][U][U][G] =  5.500;
 int21_ar[U][A][C][U][A][U][G] =  4.000;
 int21_ar[U][A][C][U][C][U][G] =  3.400;
 int21_ar[U][A][C][U][G][U][G] =  5.500;
 int21_ar[U][A][C][U][U][U][G] =  3.700;
 int21_ar[U][A][G][A][A][U][G] =  3.200;
 int21_ar[U][A][G][A][C][U][G] =  5.500;
 int21_ar[U][A][G][A][G][U][G] =  2.300;
 int21_ar[U][A][G][A][U][U][G] =  5.500;
 int21_ar[U][A][G][C][A][U][G] =  5.500;
 int21_ar[U][A][G][C][C][U][G] =  5.500;
 int21_ar[U][A][G][C][G][U][G] =  5.500;
 int21_ar[U][A][G][C][U][U][G] =  5.500;
 int21_ar[U][A][G][G][A][U][G] =  2.300;
 int21_ar[U][A][G][G][C][U][G] =  5.500;
 int21_ar[U][A][G][G][G][U][G] =  3.700;
 int21_ar[U][A][G][G][U][U][G] =  5.500;
 int21_ar[U][A][G][U][A][U][G] =  5.500;
 int21_ar[U][A][G][U][C][U][G] =  5.500;
 int21_ar[U][A][G][U][G][U][G] =  5.500;
 int21_ar[U][A][G][U][U][U][G] =  5.500;
 int21_ar[U][A][U][A][A][U][G] =  5.500;
 int21_ar[U][A][U][A][C][U][G] =  5.500;
 int21_ar[U][A][U][A][G][U][G] =  5.500;
 int21_ar[U][A][U][A][U][U][G] =  5.500;
 int21_ar[U][A][U][C][A][U][G] =  5.500;
 int21_ar[U][A][U][C][C][U][G] =  3.700;
 int21_ar[U][A][U][C][G][U][G] =  5.500;
 int21_ar[U][A][U][C][U][U][G] =  2.800;
 int21_ar[U][A][U][G][A][U][G] =  5.500;
 int21_ar[U][A][U][G][C][U][G] =  5.500;
 int21_ar[U][A][U][G][G][U][G] =  5.500;
 int21_ar[U][A][U][G][U][U][G] =  5.500;
 int21_ar[U][A][U][U][A][U][G] =  5.500;
 int21_ar[U][A][U][U][C][U][G] =  3.200;
 int21_ar[U][A][U][U][G][U][G] =  5.500;
 int21_ar[U][A][U][U][U][U][G] =  2.700;
 int21_ar[U][G][A][A][A][A][U] =  3.900;
 int21_ar[U][G][A][A][C][A][U] =  3.700;
 int21_ar[U][G][A][A][G][A][U] =  3.100;
 int21_ar[U][G][A][A][U][A][U] =  5.500;
 int21_ar[U][G][A][C][A][A][U] =  3.600;
 int21_ar[U][G][A][C][C][A][U] =  3.200;
 int21_ar[U][G][A][C][G][A][U] =  3.100;
 int21_ar[U][G][A][C][U][A][U] =  5.500;
 int21_ar[U][G][A][G][A][A][U] =  2.500;
 int21_ar[U][G][A][G][C][A][U] =  2.100;
 int21_ar[U][G][A][G][G][A][U] =  1.900;
 int21_ar[U][G][A][G][U][A][U] =  5.500;
 int21_ar[U][G][A][U][A][A][U] =  5.500;
 int21_ar[U][G][A][U][C][A][U] =  5.500;
 int21_ar[U][G][A][U][G][A][U] =  5.500;
 int21_ar[U][G][A][U][U][A][U] =  5.500;
 int21_ar[U][G][C][A][A][A][U] =  3.800;
 int21_ar[U][G][C][A][C][A][U] =  3.700;
 int21_ar[U][G][C][A][G][A][U] =  5.500;
 int21_ar[U][G][C][A][U][A][U] =  3.700;
 int21_ar[U][G][C][C][A][A][U] =  3.700;
 int21_ar[U][G][C][C][C][A][U] =  4.000;
 int21_ar[U][G][C][C][G][A][U] =  5.500;
 int21_ar[U][G][C][C][U][A][U] =  3.700;
 int21_ar[U][G][C][G][A][A][U] =  5.500;
 int21_ar[U][G][C][G][C][A][U] =  5.500;
 int21_ar[U][G][C][G][G][A][U] =  5.500;
 int21_ar[U][G][C][G][U][A][U] =  5.500;
 int21_ar[U][G][C][U][A][A][U] =  4.000;
 int21_ar[U][G][C][U][C][A][U] =  3.400;
 int21_ar[U][G][C][U][G][A][U] =  5.500;
 int21_ar[U][G][C][U][U][A][U] =  3.700;
 int21_ar[U][G][G][A][A][A][U] =  3.200;
 int21_ar[U][G][G][A][C][A][U] =  5.500;
 int21_ar[U][G][G][A][G][A][U] =  2.300;
 int21_ar[U][G][G][A][U][A][U] =  5.500;
 int21_ar[U][G][G][C][A][A][U] =  5.500;
 int21_ar[U][G][G][C][C][A][U] =  5.500;
 int21_ar[U][G][G][C][G][A][U] =  5.500;
 int21_ar[U][G][G][C][U][A][U] =  5.500;
 int21_ar[U][G][G][G][A][A][U] =  2.300;
 int21_ar[U][G][G][G][C][A][U] =  5.500;
 int21_ar[U][G][G][G][G][A][U] =  3.700;
 int21_ar[U][G][G][G][U][A][U] =  5.500;
 int21_ar[U][G][G][U][A][A][U] =  5.500;
 int21_ar[U][G][G][U][C][A][U] =  5.500;
 int21_ar[U][G][G][U][G][A][U] =  5.500;
 int21_ar[U][G][G][U][U][A][U] =  5.500;
 int21_ar[U][G][U][A][A][A][U] =  5.500;
 int21_ar[U][G][U][A][C][A][U] =  5.500;
 int21_ar[U][G][U][A][G][A][U] =  5.500;
 int21_ar[U][G][U][A][U][A][U] =  5.500;
 int21_ar[U][G][U][C][A][A][U] =  5.500;
 int21_ar[U][G][U][C][C][A][U] =  3.700;
 int21_ar[U][G][U][C][G][A][U] =  5.500;
 int21_ar[U][G][U][C][U][A][U] =  2.800;
 int21_ar[U][G][U][G][A][A][U] =  5.500;
 int21_ar[U][G][U][G][C][A][U] =  5.500;
 int21_ar[U][G][U][G][G][A][U] =  5.500;
 int21_ar[U][G][U][G][U][A][U] =  5.500;
 int21_ar[U][G][U][U][A][A][U] =  5.500;
 int21_ar[U][G][U][U][C][A][U] =  3.200;
 int21_ar[U][G][U][U][G][A][U] =  5.500;
 int21_ar[U][G][U][U][U][A][U] =  2.700;
 int21_ar[U][G][A][A][A][C][G] =  3.200;
 int21_ar[U][G][A][A][C][C][G] =  3.000;
 int21_ar[U][G][A][A][G][C][G] =  2.400;
 int21_ar[U][G][A][A][U][C][G] =  4.800;
 int21_ar[U][G][A][C][A][C][G] =  2.900;
 int21_ar[U][G][A][C][C][C][G] =  2.500;
 int21_ar[U][G][A][C][G][C][G] =  2.400;
 int21_ar[U][G][A][C][U][C][G] =  4.800;
 int21_ar[U][G][A][G][A][C][G] =  1.800;
 int21_ar[U][G][A][G][C][C][G] =  1.400;
 int21_ar[U][G][A][G][G][C][G] =  1.200;
 int21_ar[U][G][A][G][U][C][G] =  4.800;
 int21_ar[U][G][A][U][A][C][G] =  4.800;
 int21_ar[U][G][A][U][C][C][G] =  4.800;
 int21_ar[U][G][A][U][G][C][G] =  4.800;
 int21_ar[U][G][A][U][U][C][G] =  4.800;
 int21_ar[U][G][C][A][A][C][G] =  3.100;
 int21_ar[U][G][C][A][C][C][G] =  3.000;
 int21_ar[U][G][C][A][G][C][G] =  4.800;
 int21_ar[U][G][C][A][U][C][G] =  3.000;
 int21_ar[U][G][C][C][A][C][G] =  3.000;
 int21_ar[U][G][C][C][C][C][G] =  3.300;
 int21_ar[U][G][C][C][G][C][G] =  4.800;
 int21_ar[U][G][C][C][U][C][G] =  3.000;
 int21_ar[U][G][C][G][A][C][G] =  4.800;
 int21_ar[U][G][C][G][C][C][G] =  4.800;
 int21_ar[U][G][C][G][G][C][G] =  4.800;
 int21_ar[U][G][C][G][U][C][G] =  4.800;
 int21_ar[U][G][C][U][A][C][G] =  3.300;
 int21_ar[U][G][C][U][C][C][G] =  2.700;
 int21_ar[U][G][C][U][G][C][G] =  4.800;
 int21_ar[U][G][C][U][U][C][G] =  3.000;
 int21_ar[U][G][G][A][A][C][G] =  2.500;
 int21_ar[U][G][G][A][C][C][G] =  4.800;
 int21_ar[U][G][G][A][G][C][G] =  1.600;
 int21_ar[U][G][G][A][U][C][G] =  4.800;
 int21_ar[U][G][G][C][A][C][G] =  4.800;
 int21_ar[U][G][G][C][C][C][G] =  4.800;
 int21_ar[U][G][G][C][G][C][G] =  4.800;
 int21_ar[U][G][G][C][U][C][G] =  4.800;
 int21_ar[U][G][G][G][A][C][G] =  1.600;
 int21_ar[U][G][G][G][C][C][G] =  4.800;
 int21_ar[U][G][G][G][G][C][G] =  3.000;
 int21_ar[U][G][G][G][U][C][G] =  4.800;
 int21_ar[U][G][G][U][A][C][G] =  4.800;
 int21_ar[U][G][G][U][C][C][G] =  4.800;
 int21_ar[U][G][G][U][G][C][G] =  4.800;
 int21_ar[U][G][G][U][U][C][G] =  4.800;
 int21_ar[U][G][U][A][A][C][G] =  4.800;
 int21_ar[U][G][U][A][C][C][G] =  4.800;
 int21_ar[U][G][U][A][G][C][G] =  4.800;
 int21_ar[U][G][U][A][U][C][G] =  4.800;
 int21_ar[U][G][U][C][A][C][G] =  4.800;
 int21_ar[U][G][U][C][C][C][G] =  3.000;
 int21_ar[U][G][U][C][G][C][G] =  4.800;
 int21_ar[U][G][U][C][U][C][G] =  2.100;
 int21_ar[U][G][U][G][A][C][G] =  4.800;
 int21_ar[U][G][U][G][C][C][G] =  4.800;
 int21_ar[U][G][U][G][G][C][G] =  4.800;
 int21_ar[U][G][U][G][U][C][G] =  4.800;
 int21_ar[U][G][U][U][A][C][G] =  4.800;
 int21_ar[U][G][U][U][C][C][G] =  2.500;
 int21_ar[U][G][U][U][G][C][G] =  4.800;
 int21_ar[U][G][U][U][U][C][G] =  2.000;
 int21_ar[U][G][A][A][A][G][C] =  3.200;
 int21_ar[U][G][A][A][C][G][C] =  3.000;
 int21_ar[U][G][A][A][G][G][C] =  2.400;
 int21_ar[U][G][A][A][U][G][C] =  4.800;
 int21_ar[U][G][A][C][A][G][C] =  2.900;
 int21_ar[U][G][A][C][C][G][C] =  2.500;
 int21_ar[U][G][A][C][G][G][C] =  2.400;
 int21_ar[U][G][A][C][U][G][C] =  4.800;
 int21_ar[U][G][A][G][A][G][C] =  1.800;
 int21_ar[U][G][A][G][C][G][C] =  1.400;
 int21_ar[U][G][A][G][G][G][C] =  1.200;
 int21_ar[U][G][A][G][U][G][C] =  4.800;
 int21_ar[U][G][A][U][A][G][C] =  4.800;
 int21_ar[U][G][A][U][C][G][C] =  4.800;
 int21_ar[U][G][A][U][G][G][C] =  4.800;
 int21_ar[U][G][A][U][U][G][C] =  4.800;
 int21_ar[U][G][C][A][A][G][C] =  3.100;
 int21_ar[U][G][C][A][C][G][C] =  3.000;
 int21_ar[U][G][C][A][G][G][C] =  4.800;
 int21_ar[U][G][C][A][U][G][C] =  3.000;
 int21_ar[U][G][C][C][A][G][C] =  3.000;
 int21_ar[U][G][C][C][C][G][C] =  3.300;
 int21_ar[U][G][C][C][G][G][C] =  4.800;
 int21_ar[U][G][C][C][U][G][C] =  3.000;
 int21_ar[U][G][C][G][A][G][C] =  4.800;
 int21_ar[U][G][C][G][C][G][C] =  4.800;
 int21_ar[U][G][C][G][G][G][C] =  4.800;
 int21_ar[U][G][C][G][U][G][C] =  4.800;
 int21_ar[U][G][C][U][A][G][C] =  3.300;
 int21_ar[U][G][C][U][C][G][C] =  2.700;
 int21_ar[U][G][C][U][G][G][C] =  4.800;
 int21_ar[U][G][C][U][U][G][C] =  3.000;
 int21_ar[U][G][G][A][A][G][C] =  2.500;
 int21_ar[U][G][G][A][C][G][C] =  4.800;
 int21_ar[U][G][G][A][G][G][C] =  1.600;
 int21_ar[U][G][G][A][U][G][C] =  4.800;
 int21_ar[U][G][G][C][A][G][C] =  4.800;
 int21_ar[U][G][G][C][C][G][C] =  4.800;
 int21_ar[U][G][G][C][G][G][C] =  4.800;
 int21_ar[U][G][G][C][U][G][C] =  4.800;
 int21_ar[U][G][G][G][A][G][C] =  1.600;
 int21_ar[U][G][G][G][C][G][C] =  4.800;
 int21_ar[U][G][G][G][G][G][C] =  3.000;
 int21_ar[U][G][G][G][U][G][C] =  4.800;
 int21_ar[U][G][G][U][A][G][C] =  4.800;
 int21_ar[U][G][G][U][C][G][C] =  4.800;
 int21_ar[U][G][G][U][G][G][C] =  4.800;
 int21_ar[U][G][G][U][U][G][C] =  4.800;
 int21_ar[U][G][U][A][A][G][C] =  4.800;
 int21_ar[U][G][U][A][C][G][C] =  4.800;
 int21_ar[U][G][U][A][G][G][C] =  4.800;
 int21_ar[U][G][U][A][U][G][C] =  4.800;
 int21_ar[U][G][U][C][A][G][C] =  4.800;
 int21_ar[U][G][U][C][C][G][C] =  3.000;
 int21_ar[U][G][U][C][G][G][C] =  4.800;
 int21_ar[U][G][U][C][U][G][C] =  2.100;
 int21_ar[U][G][U][G][A][G][C] =  4.800;
 int21_ar[U][G][U][G][C][G][C] =  4.800;
 int21_ar[U][G][U][G][G][G][C] =  4.800;
 int21_ar[U][G][U][G][U][G][C] =  4.800;
 int21_ar[U][G][U][U][A][G][C] =  4.800;
 int21_ar[U][G][U][U][C][G][C] =  2.500;
 int21_ar[U][G][U][U][G][G][C] =  4.800;
 int21_ar[U][G][U][U][U][G][C] =  2.000;
 int21_ar[U][G][A][A][A][G][U] =  3.900;
 int21_ar[U][G][A][A][C][G][U] =  3.700;
 int21_ar[U][G][A][A][G][G][U] =  3.100;
 int21_ar[U][G][A][A][U][G][U] =  5.500;
 int21_ar[U][G][A][C][A][G][U] =  3.600;
 int21_ar[U][G][A][C][C][G][U] =  3.200;
 int21_ar[U][G][A][C][G][G][U] =  3.100;
 int21_ar[U][G][A][C][U][G][U] =  5.500;
 int21_ar[U][G][A][G][A][G][U] =  2.500;
 int21_ar[U][G][A][G][C][G][U] =  2.100;
 int21_ar[U][G][A][G][G][G][U] =  1.900;
 int21_ar[U][G][A][G][U][G][U] =  5.500;
 int21_ar[U][G][A][U][A][G][U] =  5.500;
 int21_ar[U][G][A][U][C][G][U] =  5.500;
 int21_ar[U][G][A][U][G][G][U] =  5.500;
 int21_ar[U][G][A][U][U][G][U] =  5.500;
 int21_ar[U][G][C][A][A][G][U] =  3.800;
 int21_ar[U][G][C][A][C][G][U] =  3.700;
 int21_ar[U][G][C][A][G][G][U] =  5.500;
 int21_ar[U][G][C][A][U][G][U] =  3.700;
 int21_ar[U][G][C][C][A][G][U] =  3.700;
 int21_ar[U][G][C][C][C][G][U] =  4.000;
 int21_ar[U][G][C][C][G][G][U] =  5.500;
 int21_ar[U][G][C][C][U][G][U] =  3.700;
 int21_ar[U][G][C][G][A][G][U] =  5.500;
 int21_ar[U][G][C][G][C][G][U] =  5.500;
 int21_ar[U][G][C][G][G][G][U] =  5.500;
 int21_ar[U][G][C][G][U][G][U] =  5.500;
 int21_ar[U][G][C][U][A][G][U] =  4.000;
 int21_ar[U][G][C][U][C][G][U] =  3.400;
 int21_ar[U][G][C][U][G][G][U] =  5.500;
 int21_ar[U][G][C][U][U][G][U] =  3.700;
 int21_ar[U][G][G][A][A][G][U] =  3.200;
 int21_ar[U][G][G][A][C][G][U] =  5.500;
 int21_ar[U][G][G][A][G][G][U] =  2.300;
 int21_ar[U][G][G][A][U][G][U] =  5.500;
 int21_ar[U][G][G][C][A][G][U] =  5.500;
 int21_ar[U][G][G][C][C][G][U] =  5.500;
 int21_ar[U][G][G][C][G][G][U] =  5.500;
 int21_ar[U][G][G][C][U][G][U] =  5.500;
 int21_ar[U][G][G][G][A][G][U] =  2.300;
 int21_ar[U][G][G][G][C][G][U] =  5.500;
 int21_ar[U][G][G][G][G][G][U] =  3.700;
 int21_ar[U][G][G][G][U][G][U] =  5.500;
 int21_ar[U][G][G][U][A][G][U] =  5.500;
 int21_ar[U][G][G][U][C][G][U] =  5.500;
 int21_ar[U][G][G][U][G][G][U] =  5.500;
 int21_ar[U][G][G][U][U][G][U] =  5.500;
 int21_ar[U][G][U][A][A][G][U] =  5.500;
 int21_ar[U][G][U][A][C][G][U] =  5.500;
 int21_ar[U][G][U][A][G][G][U] =  5.500;
 int21_ar[U][G][U][A][U][G][U] =  5.500;
 int21_ar[U][G][U][C][A][G][U] =  5.500;
 int21_ar[U][G][U][C][C][G][U] =  3.700;
 int21_ar[U][G][U][C][G][G][U] =  5.500;
 int21_ar[U][G][U][C][U][G][U] =  2.800;
 int21_ar[U][G][U][G][A][G][U] =  5.500;
 int21_ar[U][G][U][G][C][G][U] =  5.500;
 int21_ar[U][G][U][G][G][G][U] =  5.500;
 int21_ar[U][G][U][G][U][G][U] =  5.500;
 int21_ar[U][G][U][U][A][G][U] =  5.500;
 int21_ar[U][G][U][U][C][G][U] =  3.200;
 int21_ar[U][G][U][U][G][G][U] =  5.500;
 int21_ar[U][G][U][U][U][G][U] =  2.700;
 int21_ar[U][G][A][A][A][U][A] =  3.900;
 int21_ar[U][G][A][A][C][U][A] =  3.700;
 int21_ar[U][G][A][A][G][U][A] =  3.100;
 int21_ar[U][G][A][A][U][U][A] =  5.500;
 int21_ar[U][G][A][C][A][U][A] =  3.600;
 int21_ar[U][G][A][C][C][U][A] =  3.200;
 int21_ar[U][G][A][C][G][U][A] =  3.100;
 int21_ar[U][G][A][C][U][U][A] =  5.500;
 int21_ar[U][G][A][G][A][U][A] =  2.500;
 int21_ar[U][G][A][G][C][U][A] =  2.100;
 int21_ar[U][G][A][G][G][U][A] =  1.900;
 int21_ar[U][G][A][G][U][U][A] =  5.500;
 int21_ar[U][G][A][U][A][U][A] =  5.500;
 int21_ar[U][G][A][U][C][U][A] =  5.500;
 int21_ar[U][G][A][U][G][U][A] =  5.500;
 int21_ar[U][G][A][U][U][U][A] =  5.500;
 int21_ar[U][G][C][A][A][U][A] =  3.800;
 int21_ar[U][G][C][A][C][U][A] =  3.700;
 int21_ar[U][G][C][A][G][U][A] =  5.500;
 int21_ar[U][G][C][A][U][U][A] =  3.700;
 int21_ar[U][G][C][C][A][U][A] =  3.700;
 int21_ar[U][G][C][C][C][U][A] =  4.000;
 int21_ar[U][G][C][C][G][U][A] =  5.500;
 int21_ar[U][G][C][C][U][U][A] =  3.700;
 int21_ar[U][G][C][G][A][U][A] =  5.500;
 int21_ar[U][G][C][G][C][U][A] =  5.500;
 int21_ar[U][G][C][G][G][U][A] =  5.500;
 int21_ar[U][G][C][G][U][U][A] =  5.500;
 int21_ar[U][G][C][U][A][U][A] =  4.000;
 int21_ar[U][G][C][U][C][U][A] =  3.400;
 int21_ar[U][G][C][U][G][U][A] =  5.500;
 int21_ar[U][G][C][U][U][U][A] =  3.700;
 int21_ar[U][G][G][A][A][U][A] =  3.200;
 int21_ar[U][G][G][A][C][U][A] =  5.500;
 int21_ar[U][G][G][A][G][U][A] =  2.300;
 int21_ar[U][G][G][A][U][U][A] =  5.500;
 int21_ar[U][G][G][C][A][U][A] =  5.500;
 int21_ar[U][G][G][C][C][U][A] =  5.500;
 int21_ar[U][G][G][C][G][U][A] =  5.500;
 int21_ar[U][G][G][C][U][U][A] =  5.500;
 int21_ar[U][G][G][G][A][U][A] =  2.300;
 int21_ar[U][G][G][G][C][U][A] =  5.500;
 int21_ar[U][G][G][G][G][U][A] =  3.700;
 int21_ar[U][G][G][G][U][U][A] =  5.500;
 int21_ar[U][G][G][U][A][U][A] =  5.500;
 int21_ar[U][G][G][U][C][U][A] =  5.500;
 int21_ar[U][G][G][U][G][U][A] =  5.500;
 int21_ar[U][G][G][U][U][U][A] =  5.500;
 int21_ar[U][G][U][A][A][U][A] =  5.500;
 int21_ar[U][G][U][A][C][U][A] =  5.500;
 int21_ar[U][G][U][A][G][U][A] =  5.500;
 int21_ar[U][G][U][A][U][U][A] =  5.500;
 int21_ar[U][G][U][C][A][U][A] =  5.500;
 int21_ar[U][G][U][C][C][U][A] =  3.700;
 int21_ar[U][G][U][C][G][U][A] =  5.500;
 int21_ar[U][G][U][C][U][U][A] =  2.800;
 int21_ar[U][G][U][G][A][U][A] =  5.500;
 int21_ar[U][G][U][G][C][U][A] =  5.500;
 int21_ar[U][G][U][G][G][U][A] =  5.500;
 int21_ar[U][G][U][G][U][U][A] =  5.500;
 int21_ar[U][G][U][U][A][U][A] =  5.500;
 int21_ar[U][G][U][U][C][U][A] =  3.200;
 int21_ar[U][G][U][U][G][U][A] =  5.500;
 int21_ar[U][G][U][U][U][U][A] =  2.700;
 int21_ar[U][G][A][A][A][U][G] =  3.900;
 int21_ar[U][G][A][A][C][U][G] =  3.700;
 int21_ar[U][G][A][A][G][U][G] =  3.100;
 int21_ar[U][G][A][A][U][U][G] =  5.500;
 int21_ar[U][G][A][C][A][U][G] =  3.600;
 int21_ar[U][G][A][C][C][U][G] =  3.200;
 int21_ar[U][G][A][C][G][U][G] =  3.100;
 int21_ar[U][G][A][C][U][U][G] =  5.500;
 int21_ar[U][G][A][G][A][U][G] =  2.500;
 int21_ar[U][G][A][G][C][U][G] =  2.100;
 int21_ar[U][G][A][G][G][U][G] =  1.900;
 int21_ar[U][G][A][G][U][U][G] =  5.500;
 int21_ar[U][G][A][U][A][U][G] =  5.500;
 int21_ar[U][G][A][U][C][U][G] =  5.500;
 int21_ar[U][G][A][U][G][U][G] =  5.500;
 int21_ar[U][G][A][U][U][U][G] =  5.500;
 int21_ar[U][G][C][A][A][U][G] =  3.800;
 int21_ar[U][G][C][A][C][U][G] =  3.700;
 int21_ar[U][G][C][A][G][U][G] =  5.500;
 int21_ar[U][G][C][A][U][U][G] =  3.700;
 int21_ar[U][G][C][C][A][U][G] =  3.700;
 int21_ar[U][G][C][C][C][U][G] =  4.000;
 int21_ar[U][G][C][C][G][U][G] =  5.500;
 int21_ar[U][G][C][C][U][U][G] =  3.700;
 int21_ar[U][G][C][G][A][U][G] =  5.500;
 int21_ar[U][G][C][G][C][U][G] =  5.500;
 int21_ar[U][G][C][G][G][U][G] =  5.500;
 int21_ar[U][G][C][G][U][U][G] =  5.500;
 int21_ar[U][G][C][U][A][U][G] =  4.000;
 int21_ar[U][G][C][U][C][U][G] =  3.400;
 int21_ar[U][G][C][U][G][U][G] =  5.500;
 int21_ar[U][G][C][U][U][U][G] =  3.700;
 int21_ar[U][G][G][A][A][U][G] =  3.200;
 int21_ar[U][G][G][A][C][U][G] =  5.500;
 int21_ar[U][G][G][A][G][U][G] =  2.300;
 int21_ar[U][G][G][A][U][U][G] =  5.500;
 int21_ar[U][G][G][C][A][U][G] =  5.500;
 int21_ar[U][G][G][C][C][U][G] =  5.500;
 int21_ar[U][G][G][C][G][U][G] =  5.500;
 int21_ar[U][G][G][C][U][U][G] =  5.500;
 int21_ar[U][G][G][G][A][U][G] =  2.300;
 int21_ar[U][G][G][G][C][U][G] =  5.500;
 int21_ar[U][G][G][G][G][U][G] =  3.700;
 int21_ar[U][G][G][G][U][U][G] =  5.500;
 int21_ar[U][G][G][U][A][U][G] =  5.500;
 int21_ar[U][G][G][U][C][U][G] =  5.500;
 int21_ar[U][G][G][U][G][U][G] =  5.500;
 int21_ar[U][G][G][U][U][U][G] =  5.500;
 int21_ar[U][G][U][A][A][U][G] =  5.500;
 int21_ar[U][G][U][A][C][U][G] =  5.500;
 int21_ar[U][G][U][A][G][U][G] =  5.500;
 int21_ar[U][G][U][A][U][U][G] =  5.500;
 int21_ar[U][G][U][C][A][U][G] =  5.500;
 int21_ar[U][G][U][C][C][U][G] =  3.700;
 int21_ar[U][G][U][C][G][U][G] =  5.500;
 int21_ar[U][G][U][C][U][U][G] =  2.800;
 int21_ar[U][G][U][G][A][U][G] =  5.500;
 int21_ar[U][G][U][G][C][U][G] =  5.500;
 int21_ar[U][G][U][G][G][U][G] =  5.500;
 int21_ar[U][G][U][G][U][U][G] =  5.500;
 int21_ar[U][G][U][U][A][U][G] =  5.500;
 int21_ar[U][G][U][U][C][U][G] =  3.200;
 int21_ar[U][G][U][U][G][U][G] =  5.500;
 int21_ar[U][G][U][U][U][U][G] =  2.700;
}

void init_int22_ar()
{
  int k1,k2,k3,k4,k5,k6,k7,k8;

  for (k1=0;k1<ALPHASIZE;k1++)
    for (k2=0;k2<ALPHASIZE;k2++)
      for (k3=0;k3<ALPHASIZE;k3++)
         for (k4=0;k4<ALPHASIZE;k4++)
            for (k5=0;k5<ALPHASIZE;k5++)
               for (k6=0;k6<ALPHASIZE;k6++)
                 for (k7=0;k7<ALPHASIZE;k7++)
                   for (k8=0;k8<ALPHASIZE;k8++)
                     int22_ar[k1][k2][k3][k4][k5][k6][k7][k8]=0.0;

 int22_ar[A][U][A][A][A][A][A][U] =  2.800;
 int22_ar[A][U][A][A][A][C][A][U] =  2.600;
 int22_ar[A][U][A][A][A][G][A][U] =  1.500;
 int22_ar[A][U][A][A][A][U][A][U] =  2.000;
 int22_ar[A][U][A][A][C][A][A][U] =  2.500;
 int22_ar[A][U][A][A][C][C][A][U] =  2.400;
 int22_ar[A][U][A][A][C][G][A][U] =  1.300;
 int22_ar[A][U][A][A][C][U][A][U] =  2.000;
 int22_ar[A][U][A][A][G][A][A][U] =  1.500;
 int22_ar[A][U][A][A][G][C][A][U] =  1.400;
 int22_ar[A][U][A][A][G][G][A][U] =  0.300;
 int22_ar[A][U][A][A][G][U][A][U] =  2.000;
 int22_ar[A][U][A][A][U][A][A][U] =  2.000;
 int22_ar[A][U][A][A][U][C][A][U] =  2.000;
 int22_ar[A][U][A][A][U][G][A][U] =  2.000;
 int22_ar[A][U][A][A][U][U][A][U] =  2.000;
 int22_ar[A][U][A][C][A][A][A][U] =  2.600;
 int22_ar[A][U][A][C][A][C][A][U] =  2.500;
 int22_ar[A][U][A][C][A][G][A][U] =  1.400;
 int22_ar[A][U][A][C][A][U][A][U] =  2.000;
 int22_ar[A][U][A][C][C][A][A][U] =  3.100;
 int22_ar[A][U][A][C][C][C][A][U] =  2.300;
 int22_ar[A][U][A][C][C][G][A][U] =  2.200;
 int22_ar[A][U][A][C][C][U][A][U] =  2.000;
 int22_ar[A][U][A][C][G][A][A][U] =  2.000;
 int22_ar[A][U][A][C][G][C][A][U] =  2.000;
 int22_ar[A][U][A][C][G][G][A][U] =  2.000;
 int22_ar[A][U][A][C][G][U][A][U] =  2.000;
 int22_ar[A][U][A][C][U][A][A][U] =  3.100;
 int22_ar[A][U][A][C][U][C][A][U] =  2.300;
 int22_ar[A][U][A][C][U][G][A][U] =  2.200;
 int22_ar[A][U][A][C][U][U][A][U] =  2.000;
 int22_ar[A][U][A][G][A][A][A][U] =  1.500;
 int22_ar[A][U][A][G][A][C][A][U] =  1.400;
 int22_ar[A][U][A][G][A][G][A][U] =  0.300;
 int22_ar[A][U][A][G][A][U][A][U] =  2.000;
 int22_ar[A][U][A][G][C][A][A][U] =  2.000;
 int22_ar[A][U][A][G][C][C][A][U] =  2.000;
 int22_ar[A][U][A][G][C][G][A][U] =  2.000;
 int22_ar[A][U][A][G][C][U][A][U] =  2.000;
 int22_ar[A][U][A][G][G][A][A][U] =  2.100;
 int22_ar[A][U][A][G][G][C][A][U] =  1.900;
 int22_ar[A][U][A][G][G][G][A][U] =  0.800;
 int22_ar[A][U][A][G][G][U][A][U] =  2.000;
 int22_ar[A][U][A][G][U][A][A][U] =  1.300;
 int22_ar[A][U][A][G][U][C][A][U] =  0.200;
 int22_ar[A][U][A][G][U][G][A][U] =  0.900;
 int22_ar[A][U][A][G][U][U][A][U] =  2.000;
 int22_ar[A][U][A][U][A][A][A][U] =  2.000;
 int22_ar[A][U][A][U][A][C][A][U] =  2.000;
 int22_ar[A][U][A][U][A][G][A][U] =  2.000;
 int22_ar[A][U][A][U][A][U][A][U] =  2.000;
 int22_ar[A][U][A][U][C][A][A][U] =  3.100;
 int22_ar[A][U][A][U][C][C][A][U] =  2.300;
 int22_ar[A][U][A][U][C][G][A][U] =  2.200;
 int22_ar[A][U][A][U][C][U][A][U] =  2.000;
 int22_ar[A][U][A][U][G][A][A][U] =  2.300;
 int22_ar[A][U][A][U][G][C][A][U] =  1.200;
 int22_ar[A][U][A][U][G][G][A][U] =  1.900;
 int22_ar[A][U][A][U][G][U][A][U] =  2.000;
 int22_ar[A][U][A][U][U][A][A][U] =  2.700;
 int22_ar[A][U][A][U][U][C][A][U] =  1.500;
 int22_ar[A][U][A][U][U][G][A][U] =  2.200;
 int22_ar[A][U][A][U][U][U][A][U] =  2.000;
 int22_ar[A][U][C][A][A][A][A][U] =  2.500;
 int22_ar[A][U][C][A][A][C][A][U] =  3.100;
 int22_ar[A][U][C][A][A][G][A][U] =  2.000;
 int22_ar[A][U][C][A][A][U][A][U] =  3.100;
 int22_ar[A][U][C][A][C][A][A][U] =  2.300;
 int22_ar[A][U][C][A][C][C][A][U] =  2.200;
 int22_ar[A][U][C][A][C][G][A][U] =  2.000;
 int22_ar[A][U][C][A][C][U][A][U] =  2.200;
 int22_ar[A][U][C][A][G][A][A][U] =  1.300;
 int22_ar[A][U][C][A][G][C][A][U] =  2.200;
 int22_ar[A][U][C][A][G][G][A][U] =  2.000;
 int22_ar[A][U][C][A][G][U][A][U] =  2.200;
 int22_ar[A][U][C][A][U][A][A][U] =  2.000;
 int22_ar[A][U][C][A][U][C][A][U] =  2.000;
 int22_ar[A][U][C][A][U][G][A][U] =  2.000;
 int22_ar[A][U][C][A][U][U][A][U] =  2.000;
 int22_ar[A][U][C][C][A][A][A][U] =  2.400;
 int22_ar[A][U][C][C][A][C][A][U] =  2.300;
 int22_ar[A][U][C][C][A][G][A][U] =  2.000;
 int22_ar[A][U][C][C][A][U][A][U] =  2.300;
 int22_ar[A][U][C][C][C][A][A][U] =  2.200;
 int22_ar[A][U][C][C][C][C][A][U] =  2.200;
 int22_ar[A][U][C][C][C][G][A][U] =  2.000;
 int22_ar[A][U][C][C][C][U][A][U] =  2.200;
 int22_ar[A][U][C][C][G][A][A][U] =  2.000;
 int22_ar[A][U][C][C][G][C][A][U] =  2.000;
 int22_ar[A][U][C][C][G][G][A][U] =  2.000;
 int22_ar[A][U][C][C][G][U][A][U] =  2.000;
 int22_ar[A][U][C][C][U][A][A][U] =  2.200;
 int22_ar[A][U][C][C][U][C][A][U] =  2.200;
 int22_ar[A][U][C][C][U][G][A][U] =  2.000;
 int22_ar[A][U][C][C][U][U][A][U] =  2.200;
 int22_ar[A][U][C][G][A][A][A][U] =  1.300;
 int22_ar[A][U][C][G][A][C][A][U] =  2.200;
 int22_ar[A][U][C][G][A][G][A][U] =  2.000;
 int22_ar[A][U][C][G][A][U][A][U] =  2.200;
 int22_ar[A][U][C][G][C][A][A][U] =  2.000;
 int22_ar[A][U][C][G][C][C][A][U] =  2.000;
 int22_ar[A][U][C][G][C][G][A][U] =  2.000;
 int22_ar[A][U][C][G][C][U][A][U] =  2.000;
 int22_ar[A][U][C][G][G][A][A][U] =  1.800;
 int22_ar[A][U][C][G][G][C][A][U] =  2.400;
 int22_ar[A][U][C][G][G][G][A][U] =  2.000;
 int22_ar[A][U][C][G][G][U][A][U] =  2.400;
 int22_ar[A][U][C][G][U][A][A][U] =  0.100;
 int22_ar[A][U][C][G][U][C][A][U] =  1.000;
 int22_ar[A][U][C][G][U][G][A][U] =  2.000;
 int22_ar[A][U][C][G][U][U][A][U] =  1.000;
 int22_ar[A][U][C][U][A][A][A][U] =  2.000;
 int22_ar[A][U][C][U][A][C][A][U] =  2.000;
 int22_ar[A][U][C][U][A][G][A][U] =  2.000;
 int22_ar[A][U][C][U][A][U][A][U] =  2.000;
 int22_ar[A][U][C][U][C][A][A][U] =  2.200;
 int22_ar[A][U][C][U][C][C][A][U] =  2.200;
 int22_ar[A][U][C][U][C][G][A][U] =  2.000;
 int22_ar[A][U][C][U][C][U][A][U] =  2.200;
 int22_ar[A][U][C][U][G][A][A][U] =  1.100;
 int22_ar[A][U][C][U][G][C][A][U] =  2.000;
 int22_ar[A][U][C][U][G][G][A][U] =  2.000;
 int22_ar[A][U][C][U][G][U][A][U] =  2.000;
 int22_ar[A][U][C][U][U][A][A][U] =  1.400;
 int22_ar[A][U][C][U][U][C][A][U] =  1.400;
 int22_ar[A][U][C][U][U][G][A][U] =  2.000;
 int22_ar[A][U][C][U][U][U][A][U] =  1.400;
 int22_ar[A][U][G][A][A][A][A][U] =  1.500;
 int22_ar[A][U][G][A][A][C][A][U] =  2.000;
 int22_ar[A][U][G][A][A][G][A][U] =  2.100;
 int22_ar[A][U][G][A][A][U][A][U] =  2.300;
 int22_ar[A][U][G][A][C][A][A][U] =  1.300;
 int22_ar[A][U][G][A][C][C][A][U] =  2.000;
 int22_ar[A][U][G][A][C][G][A][U] =  1.800;
 int22_ar[A][U][G][A][C][U][A][U] =  1.100;
 int22_ar[A][U][G][A][G][A][A][U] =  0.300;
 int22_ar[A][U][G][A][G][C][A][U] =  2.000;
 int22_ar[A][U][G][A][G][G][A][U] =  0.800;
 int22_ar[A][U][G][A][G][U][A][U] =  1.900;
 int22_ar[A][U][G][A][U][A][A][U] =  2.000;
 int22_ar[A][U][G][A][U][C][A][U] =  2.000;
 int22_ar[A][U][G][A][U][G][A][U] =  2.000;
 int22_ar[A][U][G][A][U][U][A][U] =  2.000;
 int22_ar[A][U][G][C][A][A][A][U] =  1.400;
 int22_ar[A][U][G][C][A][C][A][U] =  2.000;
 int22_ar[A][U][G][C][A][G][A][U] =  1.900;
 int22_ar[A][U][G][C][A][U][A][U] =  1.200;
 int22_ar[A][U][G][C][C][A][A][U] =  2.200;
 int22_ar[A][U][G][C][C][C][A][U] =  2.000;
 int22_ar[A][U][G][C][C][G][A][U] =  2.400;
 int22_ar[A][U][G][C][C][U][A][U] =  2.000;
 int22_ar[A][U][G][C][G][A][A][U] =  2.000;
 int22_ar[A][U][G][C][G][C][A][U] =  2.000;
 int22_ar[A][U][G][C][G][G][A][U] =  2.000;
 int22_ar[A][U][G][C][G][U][A][U] =  2.000;
 int22_ar[A][U][G][C][U][A][A][U] =  2.200;
 int22_ar[A][U][G][C][U][C][A][U] =  2.000;
 int22_ar[A][U][G][C][U][G][A][U] =  2.400;
 int22_ar[A][U][G][C][U][U][A][U] =  2.000;
 int22_ar[A][U][G][G][A][A][A][U] =  0.300;
 int22_ar[A][U][G][G][A][C][A][U] =  2.000;
 int22_ar[A][U][G][G][A][G][A][U] =  0.800;
 int22_ar[A][U][G][G][A][U][A][U] =  1.900;
 int22_ar[A][U][G][G][C][A][A][U] =  2.000;
 int22_ar[A][U][G][G][C][C][A][U] =  2.000;
 int22_ar[A][U][G][G][C][G][A][U] =  2.000;
 int22_ar[A][U][G][G][C][U][A][U] =  2.000;
 int22_ar[A][U][G][G][G][A][A][U] =  0.800;
 int22_ar[A][U][G][G][G][C][A][U] =  2.000;
 int22_ar[A][U][G][G][G][G][A][U] =  1.400;
 int22_ar[A][U][G][G][G][U][A][U] =  1.600;
 int22_ar[A][U][G][G][U][A][A][U] =  0.900;
 int22_ar[A][U][G][G][U][C][A][U] =  2.000;
 int22_ar[A][U][G][G][U][G][A][U] =  0.700;
 int22_ar[A][U][G][G][U][U][A][U] = -1.100;
 int22_ar[A][U][G][U][A][A][A][U] =  2.000;
 int22_ar[A][U][G][U][A][C][A][U] =  2.000;
 int22_ar[A][U][G][U][A][G][A][U] =  2.000;
 int22_ar[A][U][G][U][A][U][A][U] =  2.000;
 int22_ar[A][U][G][U][C][A][A][U] =  2.200;
 int22_ar[A][U][G][U][C][C][A][U] =  2.000;
 int22_ar[A][U][G][U][C][G][A][U] =  2.400;
 int22_ar[A][U][G][U][C][U][A][U] =  2.000;
 int22_ar[A][U][G][U][G][A][A][U] =  1.900;
 int22_ar[A][U][G][U][G][C][A][U] =  2.000;
 int22_ar[A][U][G][U][G][G][A][U] =  1.600;
 int22_ar[A][U][G][U][G][U][A][U] = -0.100;
 int22_ar[A][U][G][U][U][A][A][U] =  2.200;
 int22_ar[A][U][G][U][U][C][A][U] =  2.000;
 int22_ar[A][U][G][U][U][G][A][U] =  2.000;
 int22_ar[A][U][G][U][U][U][A][U] =  2.000;
 int22_ar[A][U][U][A][A][A][A][U] =  2.000;
 int22_ar[A][U][U][A][A][C][A][U] =  3.100;
 int22_ar[A][U][U][A][A][G][A][U] =  1.300;
 int22_ar[A][U][U][A][A][U][A][U] =  2.700;
 int22_ar[A][U][U][A][C][A][A][U] =  2.000;
 int22_ar[A][U][U][A][C][C][A][U] =  2.200;
 int22_ar[A][U][U][A][C][G][A][U] =  0.100;
 int22_ar[A][U][U][A][C][U][A][U] =  1.400;
 int22_ar[A][U][U][A][G][A][A][U] =  2.000;
 int22_ar[A][U][U][A][G][C][A][U] =  2.200;
 int22_ar[A][U][U][A][G][G][A][U] =  0.900;
 int22_ar[A][U][U][A][G][U][A][U] =  2.200;
 int22_ar[A][U][U][A][U][A][A][U] =  2.000;
 int22_ar[A][U][U][A][U][C][A][U] =  2.000;
 int22_ar[A][U][U][A][U][G][A][U] =  2.000;
 int22_ar[A][U][U][A][U][U][A][U] =  2.000;
 int22_ar[A][U][U][C][A][A][A][U] =  2.000;
 int22_ar[A][U][U][C][A][C][A][U] =  2.300;
 int22_ar[A][U][U][C][A][G][A][U] =  0.200;
 int22_ar[A][U][U][C][A][U][A][U] =  1.500;
 int22_ar[A][U][U][C][C][A][A][U] =  2.000;
 int22_ar[A][U][U][C][C][C][A][U] =  2.200;
 int22_ar[A][U][U][C][C][G][A][U] =  1.000;
 int22_ar[A][U][U][C][C][U][A][U] =  1.400;
 int22_ar[A][U][U][C][G][A][A][U] =  2.000;
 int22_ar[A][U][U][C][G][C][A][U] =  2.000;
 int22_ar[A][U][U][C][G][G][A][U] =  2.000;
 int22_ar[A][U][U][C][G][U][A][U] =  2.000;
 int22_ar[A][U][U][C][U][A][A][U] =  2.000;
 int22_ar[A][U][U][C][U][C][A][U] =  2.200;
 int22_ar[A][U][U][C][U][G][A][U] =  1.000;
 int22_ar[A][U][U][C][U][U][A][U] =  1.400;
 int22_ar[A][U][U][G][A][A][A][U] =  2.000;
 int22_ar[A][U][U][G][A][C][A][U] =  2.200;
 int22_ar[A][U][U][G][A][G][A][U] =  0.900;
 int22_ar[A][U][U][G][A][U][A][U] =  2.200;
 int22_ar[A][U][U][G][C][A][A][U] =  2.000;
 int22_ar[A][U][U][G][C][C][A][U] =  2.000;
 int22_ar[A][U][U][G][C][G][A][U] =  2.000;
 int22_ar[A][U][U][G][C][U][A][U] =  2.000;
 int22_ar[A][U][U][G][G][A][A][U] =  2.000;
 int22_ar[A][U][U][G][G][C][A][U] =  2.400;
 int22_ar[A][U][U][G][G][G][A][U] =  0.700;
 int22_ar[A][U][U][G][G][U][A][U] =  2.000;
 int22_ar[A][U][U][G][U][A][A][U] =  2.000;
 int22_ar[A][U][U][G][U][C][A][U] =  1.000;
 int22_ar[A][U][U][G][U][G][A][U] = -2.100;
 int22_ar[A][U][U][G][U][U][A][U] =  1.100;
 int22_ar[A][U][U][U][A][A][A][U] =  2.000;
 int22_ar[A][U][U][U][A][C][A][U] =  2.000;
 int22_ar[A][U][U][U][A][G][A][U] =  2.000;
 int22_ar[A][U][U][U][A][U][A][U] =  2.000;
 int22_ar[A][U][U][U][C][A][A][U] =  2.000;
 int22_ar[A][U][U][U][C][C][A][U] =  2.200;
 int22_ar[A][U][U][U][C][G][A][U] =  1.000;
 int22_ar[A][U][U][U][C][U][A][U] =  1.400;
 int22_ar[A][U][U][U][G][A][A][U] =  2.000;
 int22_ar[A][U][U][U][G][C][A][U] =  2.000;
 int22_ar[A][U][U][U][G][G][A][U] = -1.100;
 int22_ar[A][U][U][U][G][U][A][U] =  2.000;
 int22_ar[A][U][U][U][U][A][A][U] =  2.000;
 int22_ar[A][U][U][U][U][C][A][U] =  1.400;
 int22_ar[A][U][U][U][U][G][A][U] =  1.100;
 int22_ar[A][U][U][U][U][U][A][U] =  0.600;
 int22_ar[A][U][A][A][A][A][C][G] =  2.000;
 int22_ar[A][U][A][A][A][C][C][G] =  1.900;
 int22_ar[A][U][A][A][A][G][C][G] =  0.800;
 int22_ar[A][U][A][A][A][U][C][G] =  2.000;
 int22_ar[A][U][A][A][C][A][C][G] =  1.900;
 int22_ar[A][U][A][A][C][C][C][G] =  1.800;
 int22_ar[A][U][A][A][C][G][C][G] =  0.700;
 int22_ar[A][U][A][A][C][U][C][G] =  2.000;
 int22_ar[A][U][A][A][G][A][C][G] =  1.000;
 int22_ar[A][U][A][A][G][C][C][G] =  0.900;
 int22_ar[A][U][A][A][G][G][C][G] = -0.200;
 int22_ar[A][U][A][A][G][U][C][G] =  2.000;
 int22_ar[A][U][A][A][U][A][C][G] =  2.000;
 int22_ar[A][U][A][A][U][C][C][G] =  2.000;
 int22_ar[A][U][A][A][U][G][C][G] =  2.000;
 int22_ar[A][U][A][A][U][U][C][G] =  2.000;
 int22_ar[A][U][A][C][A][A][C][G] =  2.400;
 int22_ar[A][U][A][C][A][C][C][G] =  2.200;
 int22_ar[A][U][A][C][A][G][C][G] =  1.100;
 int22_ar[A][U][A][C][A][U][C][G] =  2.000;
 int22_ar[A][U][A][C][C][A][C][G] =  2.800;
 int22_ar[A][U][A][C][C][C][C][G] =  2.100;
 int22_ar[A][U][A][C][C][G][C][G] =  2.000;
 int22_ar[A][U][A][C][C][U][C][G] =  2.000;
 int22_ar[A][U][A][C][G][A][C][G] =  2.000;
 int22_ar[A][U][A][C][G][C][C][G] =  2.000;
 int22_ar[A][U][A][C][G][G][C][G] =  2.000;
 int22_ar[A][U][A][C][G][U][C][G] =  2.000;
 int22_ar[A][U][A][C][U][A][C][G] =  2.700;
 int22_ar[A][U][A][C][U][C][C][G] =  1.900;
 int22_ar[A][U][A][C][U][G][C][G] =  1.800;
 int22_ar[A][U][A][C][U][U][C][G] =  2.000;
 int22_ar[A][U][A][G][A][A][C][G] =  1.000;
 int22_ar[A][U][A][G][A][C][C][G] =  0.900;
 int22_ar[A][U][A][G][A][G][C][G] = -0.200;
 int22_ar[A][U][A][G][A][U][C][G] =  2.000;
 int22_ar[A][U][A][G][C][A][C][G] =  2.000;
 int22_ar[A][U][A][G][C][C][C][G] =  2.000;
 int22_ar[A][U][A][G][C][G][C][G] =  2.000;
 int22_ar[A][U][A][G][C][U][C][G] =  2.000;
 int22_ar[A][U][A][G][G][A][C][G] =  1.800;
 int22_ar[A][U][A][G][G][C][C][G] =  1.600;
 int22_ar[A][U][A][G][G][G][C][G] =  0.500;
 int22_ar[A][U][A][G][G][U][C][G] =  2.000;
 int22_ar[A][U][A][G][U][A][C][G] =  0.300;
 int22_ar[A][U][A][G][U][C][C][G] = -0.800;
 int22_ar[A][U][A][G][U][G][C][G] = -0.100;
 int22_ar[A][U][A][G][U][U][C][G] =  2.000;
 int22_ar[A][U][A][U][A][A][C][G] =  2.000;
 int22_ar[A][U][A][U][A][C][C][G] =  2.000;
 int22_ar[A][U][A][U][A][G][C][G] =  2.000;
 int22_ar[A][U][A][U][A][U][C][G] =  2.000;
 int22_ar[A][U][A][U][C][A][C][G] =  2.700;
 int22_ar[A][U][A][U][C][C][C][G] =  1.900;
 int22_ar[A][U][A][U][C][G][C][G] =  1.800;
 int22_ar[A][U][A][U][C][U][C][G] =  2.000;
 int22_ar[A][U][A][U][G][A][C][G] =  1.800;
 int22_ar[A][U][A][U][G][C][C][G] =  0.700;
 int22_ar[A][U][A][U][G][G][C][G] =  1.400;
 int22_ar[A][U][A][U][G][U][C][G] =  2.000;
 int22_ar[A][U][A][U][U][A][C][G] =  2.200;
 int22_ar[A][U][A][U][U][C][C][G] =  1.000;
 int22_ar[A][U][A][U][U][G][C][G] =  1.800;
 int22_ar[A][U][A][U][U][U][C][G] =  2.000;
 int22_ar[A][U][C][A][A][A][C][G] =  1.800;
 int22_ar[A][U][C][A][A][C][C][G] =  2.300;
 int22_ar[A][U][C][A][A][G][C][G] =  2.000;
 int22_ar[A][U][C][A][A][U][C][G] =  2.300;
 int22_ar[A][U][C][A][C][A][C][G] =  1.700;
 int22_ar[A][U][C][A][C][C][C][G] =  1.600;
 int22_ar[A][U][C][A][C][G][C][G] =  2.000;
 int22_ar[A][U][C][A][C][U][C][G] =  1.600;
 int22_ar[A][U][C][A][G][A][C][G] =  0.800;
 int22_ar[A][U][C][A][G][C][C][G] =  1.700;
 int22_ar[A][U][C][A][G][G][C][G] =  2.000;
 int22_ar[A][U][C][A][G][U][C][G] =  1.700;
 int22_ar[A][U][C][A][U][A][C][G] =  2.000;
 int22_ar[A][U][C][A][U][C][C][G] =  2.000;
 int22_ar[A][U][C][A][U][G][C][G] =  2.000;
 int22_ar[A][U][C][A][U][U][C][G] =  2.000;
 int22_ar[A][U][C][C][A][A][C][G] =  2.100;
 int22_ar[A][U][C][C][A][C][C][G] =  2.100;
 int22_ar[A][U][C][C][A][G][C][G] =  2.000;
 int22_ar[A][U][C][C][A][U][C][G] =  2.100;
 int22_ar[A][U][C][C][C][A][C][G] =  2.000;
 int22_ar[A][U][C][C][C][C][C][G] =  1.900;
 int22_ar[A][U][C][C][C][G][C][G] =  2.000;
 int22_ar[A][U][C][C][C][U][C][G] =  1.900;
 int22_ar[A][U][C][C][G][A][C][G] =  2.000;
 int22_ar[A][U][C][C][G][C][C][G] =  2.000;
 int22_ar[A][U][C][C][G][G][C][G] =  2.000;
 int22_ar[A][U][C][C][G][U][C][G] =  2.000;
 int22_ar[A][U][C][C][U][A][C][G] =  1.800;
 int22_ar[A][U][C][C][U][C][C][G] =  1.800;
 int22_ar[A][U][C][C][U][G][C][G] =  2.000;
 int22_ar[A][U][C][C][U][U][C][G] =  1.800;
 int22_ar[A][U][C][G][A][A][C][G] =  0.800;
 int22_ar[A][U][C][G][A][C][C][G] =  1.700;
 int22_ar[A][U][C][G][A][G][C][G] =  2.000;
 int22_ar[A][U][C][G][A][U][C][G] =  1.700;
 int22_ar[A][U][C][G][C][A][C][G] =  2.000;
 int22_ar[A][U][C][G][C][C][C][G] =  2.000;
 int22_ar[A][U][C][G][C][G][C][G] =  2.000;
 int22_ar[A][U][C][G][C][U][C][G] =  2.000;
 int22_ar[A][U][C][G][G][A][C][G] =  1.500;
 int22_ar[A][U][C][G][G][C][C][G] =  2.100;
 int22_ar[A][U][C][G][G][G][C][G] =  2.000;
 int22_ar[A][U][C][G][G][U][C][G] =  2.100;
 int22_ar[A][U][C][G][U][A][C][G] = -0.900;
 int22_ar[A][U][C][G][U][C][C][G] =  0.000;
 int22_ar[A][U][C][G][U][G][C][G] =  2.000;
 int22_ar[A][U][C][G][U][U][C][G] =  0.000;
 int22_ar[A][U][C][U][A][A][C][G] =  2.000;
 int22_ar[A][U][C][U][A][C][C][G] =  2.000;
 int22_ar[A][U][C][U][A][G][C][G] =  2.000;
 int22_ar[A][U][C][U][A][U][C][G] =  2.000;
 int22_ar[A][U][C][U][C][A][C][G] =  1.800;
 int22_ar[A][U][C][U][C][C][C][G] =  1.800;
 int22_ar[A][U][C][U][C][G][C][G] =  2.000;
 int22_ar[A][U][C][U][C][U][C][G] =  1.800;
 int22_ar[A][U][C][U][G][A][C][G] =  0.600;
 int22_ar[A][U][C][U][G][C][C][G] =  1.500;
 int22_ar[A][U][C][U][G][G][C][G] =  2.000;
 int22_ar[A][U][C][U][G][U][C][G] =  1.500;
 int22_ar[A][U][C][U][U][A][C][G] =  0.900;
 int22_ar[A][U][C][U][U][C][C][G] =  0.900;
 int22_ar[A][U][C][U][U][G][C][G] =  2.000;
 int22_ar[A][U][C][U][U][U][C][G] =  0.900;
 int22_ar[A][U][G][A][A][A][C][G] =  0.800;
 int22_ar[A][U][G][A][A][C][C][G] =  2.000;
 int22_ar[A][U][G][A][A][G][C][G] =  1.300;
 int22_ar[A][U][G][A][A][U][C][G] =  1.600;
 int22_ar[A][U][G][A][C][A][C][G] =  0.700;
 int22_ar[A][U][G][A][C][C][C][G] =  2.000;
 int22_ar[A][U][G][A][C][G][C][G] =  1.200;
 int22_ar[A][U][G][A][C][U][C][G] =  0.500;
 int22_ar[A][U][G][A][G][A][C][G] = -0.200;
 int22_ar[A][U][G][A][G][C][C][G] =  2.000;
 int22_ar[A][U][G][A][G][G][C][G] =  0.300;
 int22_ar[A][U][G][A][G][U][C][G] =  1.400;
 int22_ar[A][U][G][A][U][A][C][G] =  2.000;
 int22_ar[A][U][G][A][U][C][C][G] =  2.000;
 int22_ar[A][U][G][A][U][G][C][G] =  2.000;
 int22_ar[A][U][G][A][U][U][C][G] =  2.000;
 int22_ar[A][U][G][C][A][A][C][G] =  1.100;
 int22_ar[A][U][G][C][A][C][C][G] =  2.000;
 int22_ar[A][U][G][C][A][G][C][G] =  1.700;
 int22_ar[A][U][G][C][A][U][C][G] =  0.900;
 int22_ar[A][U][G][C][C][A][C][G] =  2.000;
 int22_ar[A][U][G][C][C][C][C][G] =  2.000;
 int22_ar[A][U][G][C][C][G][C][G] =  2.100;
 int22_ar[A][U][G][C][C][U][C][G] =  1.800;
 int22_ar[A][U][G][C][G][A][C][G] =  2.000;
 int22_ar[A][U][G][C][G][C][C][G] =  2.000;
 int22_ar[A][U][G][C][G][G][C][G] =  2.000;
 int22_ar[A][U][G][C][G][U][C][G] =  2.000;
 int22_ar[A][U][G][C][U][A][C][G] =  1.800;
 int22_ar[A][U][G][C][U][C][C][G] =  2.000;
 int22_ar[A][U][G][C][U][G][C][G] =  2.000;
 int22_ar[A][U][G][C][U][U][C][G] =  1.600;
 int22_ar[A][U][G][G][A][A][C][G] = -0.200;
 int22_ar[A][U][G][G][A][C][C][G] =  2.000;
 int22_ar[A][U][G][G][A][G][C][G] =  0.300;
 int22_ar[A][U][G][G][A][U][C][G] =  1.400;
 int22_ar[A][U][G][G][C][A][C][G] =  2.000;
 int22_ar[A][U][G][G][C][C][C][G] =  2.000;
 int22_ar[A][U][G][G][C][G][C][G] =  2.000;
 int22_ar[A][U][G][G][C][U][C][G] =  2.000;
 int22_ar[A][U][G][G][G][A][C][G] =  0.500;
 int22_ar[A][U][G][G][G][C][C][G] =  2.000;
 int22_ar[A][U][G][G][G][G][C][G] =  1.100;
 int22_ar[A][U][G][G][G][U][C][G] =  1.300;
 int22_ar[A][U][G][G][U][A][C][G] = -0.100;
 int22_ar[A][U][G][G][U][C][C][G] =  2.000;
 int22_ar[A][U][G][G][U][G][C][G] = -0.400;
 int22_ar[A][U][G][G][U][U][C][G] = -2.100;
 int22_ar[A][U][G][U][A][A][C][G] =  2.000;
 int22_ar[A][U][G][U][A][C][C][G] =  2.000;
 int22_ar[A][U][G][U][A][G][C][G] =  2.000;
 int22_ar[A][U][G][U][A][U][C][G] =  2.000;
 int22_ar[A][U][G][U][C][A][C][G] =  1.800;
 int22_ar[A][U][G][U][C][C][C][G] =  2.000;
 int22_ar[A][U][G][U][C][G][C][G] =  2.000;
 int22_ar[A][U][G][U][C][U][C][G] =  1.600;
 int22_ar[A][U][G][U][G][A][C][G] =  1.400;
 int22_ar[A][U][G][U][G][C][C][G] =  2.000;
 int22_ar[A][U][G][U][G][G][C][G] =  1.100;
 int22_ar[A][U][G][U][G][U][C][G] = -0.600;
 int22_ar[A][U][G][U][U][A][C][G] =  1.800;
 int22_ar[A][U][G][U][U][C][C][G] =  2.000;
 int22_ar[A][U][G][U][U][G][C][G] =  1.500;
 int22_ar[A][U][G][U][U][U][C][G] =  1.600;
 int22_ar[A][U][U][A][A][A][C][G] =  2.000;
 int22_ar[A][U][U][A][A][C][C][G] =  2.300;
 int22_ar[A][U][U][A][A][G][C][G] =  0.600;
 int22_ar[A][U][U][A][A][U][C][G] =  1.900;
 int22_ar[A][U][U][A][C][A][C][G] =  2.000;
 int22_ar[A][U][U][A][C][C][C][G] =  1.600;
 int22_ar[A][U][U][A][C][G][C][G] = -0.500;
 int22_ar[A][U][U][A][C][U][C][G] =  0.800;
 int22_ar[A][U][U][A][G][A][C][G] =  2.000;
 int22_ar[A][U][U][A][G][C][C][G] =  1.700;
 int22_ar[A][U][U][A][G][G][C][G] =  0.400;
 int22_ar[A][U][U][A][G][U][C][G] =  1.800;
 int22_ar[A][U][U][A][U][A][C][G] =  2.000;
 int22_ar[A][U][U][A][U][C][C][G] =  2.000;
 int22_ar[A][U][U][A][U][G][C][G] =  2.000;
 int22_ar[A][U][U][A][U][U][C][G] =  2.000;
 int22_ar[A][U][U][C][A][A][C][G] =  2.000;
 int22_ar[A][U][U][C][A][C][C][G] =  2.100;
 int22_ar[A][U][U][C][A][G][C][G] =  0.000;
 int22_ar[A][U][U][C][A][U][C][G] =  1.300;
 int22_ar[A][U][U][C][C][A][C][G] =  2.000;
 int22_ar[A][U][U][C][C][C][C][G] =  1.900;
 int22_ar[A][U][U][C][C][G][C][G] =  0.800;
 int22_ar[A][U][U][C][C][U][C][G] =  1.100;
 int22_ar[A][U][U][C][G][A][C][G] =  2.000;
 int22_ar[A][U][U][C][G][C][C][G] =  2.000;
 int22_ar[A][U][U][C][G][G][C][G] =  2.000;
 int22_ar[A][U][U][C][G][U][C][G] =  2.000;
 int22_ar[A][U][U][C][U][A][C][G] =  2.000;
 int22_ar[A][U][U][C][U][C][C][G] =  1.800;
 int22_ar[A][U][U][C][U][G][C][G] =  0.700;
 int22_ar[A][U][U][C][U][U][C][G] =  1.000;
 int22_ar[A][U][U][G][A][A][C][G] =  2.000;
 int22_ar[A][U][U][G][A][C][C][G] =  1.700;
 int22_ar[A][U][U][G][A][G][C][G] =  0.400;
 int22_ar[A][U][U][G][A][U][C][G] =  1.800;
 int22_ar[A][U][U][G][C][A][C][G] =  2.000;
 int22_ar[A][U][U][G][C][C][C][G] =  2.000;
 int22_ar[A][U][U][G][C][G][C][G] =  2.000;
 int22_ar[A][U][U][G][C][U][C][G] =  2.000;
 int22_ar[A][U][U][G][G][A][C][G] =  2.000;
 int22_ar[A][U][U][G][G][C][C][G] =  2.100;
 int22_ar[A][U][U][G][G][G][C][G] =  0.400;
 int22_ar[A][U][U][G][G][U][C][G] =  1.700;
 int22_ar[A][U][U][G][U][A][C][G] =  2.000;
 int22_ar[A][U][U][G][U][C][C][G] =  0.000;
 int22_ar[A][U][U][G][U][G][C][G] = -3.100;
 int22_ar[A][U][U][G][U][U][C][G] =  0.000;
 int22_ar[A][U][U][U][A][A][C][G] =  2.000;
 int22_ar[A][U][U][U][A][C][C][G] =  2.000;
 int22_ar[A][U][U][U][A][G][C][G] =  2.000;
 int22_ar[A][U][U][U][A][U][C][G] =  2.000;
 int22_ar[A][U][U][U][C][A][C][G] =  2.000;
 int22_ar[A][U][U][U][C][C][C][G] =  1.800;
 int22_ar[A][U][U][U][C][G][C][G] =  0.700;
 int22_ar[A][U][U][U][C][U][C][G] =  1.000;
 int22_ar[A][U][U][U][G][A][C][G] =  2.000;
 int22_ar[A][U][U][U][G][C][C][G] =  1.500;
 int22_ar[A][U][U][U][G][G][C][G] = -1.600;
 int22_ar[A][U][U][U][G][U][C][G] =  1.600;
 int22_ar[A][U][U][U][U][A][C][G] =  2.000;
 int22_ar[A][U][U][U][U][C][C][G] =  0.900;
 int22_ar[A][U][U][U][U][G][C][G] =  0.600;
 int22_ar[A][U][U][U][U][U][C][G] =  0.100;
 int22_ar[A][U][A][A][A][A][G][C] =  2.100;
 int22_ar[A][U][A][A][A][C][G][C] =  2.000;
 int22_ar[A][U][A][A][A][G][G][C] =  0.900;
 int22_ar[A][U][A][A][A][U][G][C] =  2.000;
 int22_ar[A][U][A][A][C][A][G][C] =  1.900;
 int22_ar[A][U][A][A][C][C][G][C] =  1.700;
 int22_ar[A][U][A][A][C][G][G][C] =  0.600;
 int22_ar[A][U][A][A][C][U][G][C] =  2.000;
 int22_ar[A][U][A][A][G][A][G][C] =  0.100;
 int22_ar[A][U][A][A][G][C][G][C] =  0.000;
 int22_ar[A][U][A][A][G][G][G][C] = -1.100;
 int22_ar[A][U][A][A][G][U][G][C] =  2.000;
 int22_ar[A][U][A][A][U][A][G][C] =  2.000;
 int22_ar[A][U][A][A][U][C][G][C] =  2.000;
 int22_ar[A][U][A][A][U][G][G][C] =  2.000;
 int22_ar[A][U][A][A][U][U][G][C] =  2.000;
 int22_ar[A][U][A][C][A][A][G][C] =  1.800;
 int22_ar[A][U][A][C][A][C][G][C] =  1.700;
 int22_ar[A][U][A][C][A][G][G][C] =  0.600;
 int22_ar[A][U][A][C][A][U][G][C] =  2.000;
 int22_ar[A][U][A][C][C][A][G][C] =  2.500;
 int22_ar[A][U][A][C][C][C][G][C] =  1.700;
 int22_ar[A][U][A][C][C][G][G][C] =  1.600;
 int22_ar[A][U][A][C][C][U][G][C] =  2.000;
 int22_ar[A][U][A][C][G][A][G][C] =  2.000;
 int22_ar[A][U][A][C][G][C][G][C] =  2.000;
 int22_ar[A][U][A][C][G][G][G][C] =  2.000;
 int22_ar[A][U][A][C][G][U][G][C] =  2.000;
 int22_ar[A][U][A][C][U][A][G][C] =  1.500;
 int22_ar[A][U][A][C][U][C][G][C] =  0.700;
 int22_ar[A][U][A][C][U][G][G][C] =  0.700;
 int22_ar[A][U][A][C][U][U][G][C] =  2.000;
 int22_ar[A][U][A][G][A][A][G][C] =  0.700;
 int22_ar[A][U][A][G][A][C][G][C] =  0.600;
 int22_ar[A][U][A][G][A][G][G][C] = -0.500;
 int22_ar[A][U][A][G][A][U][G][C] =  2.000;
 int22_ar[A][U][A][G][C][A][G][C] =  2.000;
 int22_ar[A][U][A][G][C][C][G][C] =  2.000;
 int22_ar[A][U][A][G][C][G][G][C] =  2.000;
 int22_ar[A][U][A][G][C][U][G][C] =  2.000;
 int22_ar[A][U][A][G][G][A][G][C] =  1.800;
 int22_ar[A][U][A][G][G][C][G][C] =  1.600;
 int22_ar[A][U][A][G][G][G][G][C] =  0.500;
 int22_ar[A][U][A][G][G][U][G][C] =  2.000;
 int22_ar[A][U][A][G][U][A][G][C] =  0.000;
 int22_ar[A][U][A][G][U][C][G][C] = -1.200;
 int22_ar[A][U][A][G][U][G][G][C] = -0.500;
 int22_ar[A][U][A][G][U][U][G][C] =  2.000;
 int22_ar[A][U][A][U][A][A][G][C] =  2.000;
 int22_ar[A][U][A][U][A][C][G][C] =  2.000;
 int22_ar[A][U][A][U][A][G][G][C] =  2.000;
 int22_ar[A][U][A][U][A][U][G][C] =  2.000;
 int22_ar[A][U][A][U][C][A][G][C] =  2.500;
 int22_ar[A][U][A][U][C][C][G][C] =  1.800;
 int22_ar[A][U][A][U][C][G][G][C] =  1.700;
 int22_ar[A][U][A][U][C][U][G][C] =  2.000;
 int22_ar[A][U][A][U][G][A][G][C] =  0.400;
 int22_ar[A][U][A][U][G][C][G][C] = -0.800;
 int22_ar[A][U][A][U][G][G][G][C] = -0.100;
 int22_ar[A][U][A][U][G][U][G][C] =  2.000;
 int22_ar[A][U][A][U][U][A][G][C] =  2.100;
 int22_ar[A][U][A][U][U][C][G][C] =  1.000;
 int22_ar[A][U][A][U][U][G][G][C] =  1.700;
 int22_ar[A][U][A][U][U][U][G][C] =  2.000;
 int22_ar[A][U][C][A][A][A][G][C] =  1.900;
 int22_ar[A][U][C][A][A][C][G][C] =  2.400;
 int22_ar[A][U][C][A][A][G][G][C] =  2.000;
 int22_ar[A][U][C][A][A][U][G][C] =  2.400;
 int22_ar[A][U][C][A][C][A][G][C] =  1.600;
 int22_ar[A][U][C][A][C][C][G][C] =  1.600;
 int22_ar[A][U][C][A][C][G][G][C] =  2.000;
 int22_ar[A][U][C][A][C][U][G][C] =  1.600;
 int22_ar[A][U][C][A][G][A][G][C] = -0.100;
 int22_ar[A][U][C][A][G][C][G][C] =  0.800;
 int22_ar[A][U][C][A][G][G][G][C] =  2.000;
 int22_ar[A][U][C][A][G][U][G][C] =  0.800;
 int22_ar[A][U][C][A][U][A][G][C] =  2.000;
 int22_ar[A][U][C][A][U][C][G][C] =  2.000;
 int22_ar[A][U][C][A][U][G][G][C] =  2.000;
 int22_ar[A][U][C][A][U][U][G][C] =  2.000;
 int22_ar[A][U][C][C][A][A][G][C] =  1.600;
 int22_ar[A][U][C][C][A][C][G][C] =  1.500;
 int22_ar[A][U][C][C][A][G][G][C] =  2.000;
 int22_ar[A][U][C][C][A][U][G][C] =  1.500;
 int22_ar[A][U][C][C][C][A][G][C] =  1.600;
 int22_ar[A][U][C][C][C][C][G][C] =  1.600;
 int22_ar[A][U][C][C][C][G][G][C] =  2.000;
 int22_ar[A][U][C][C][C][U][G][C] =  1.600;
 int22_ar[A][U][C][C][G][A][G][C] =  2.000;
 int22_ar[A][U][C][C][G][C][G][C] =  2.000;
 int22_ar[A][U][C][C][G][G][G][C] =  2.000;
 int22_ar[A][U][C][C][G][U][G][C] =  2.000;
 int22_ar[A][U][C][C][U][A][G][C] =  0.600;
 int22_ar[A][U][C][C][U][C][G][C] =  0.600;
 int22_ar[A][U][C][C][U][G][G][C] =  2.000;
 int22_ar[A][U][C][C][U][U][G][C] =  0.600;
 int22_ar[A][U][C][G][A][A][G][C] =  0.500;
 int22_ar[A][U][C][G][A][C][G][C] =  1.400;
 int22_ar[A][U][C][G][A][G][G][C] =  2.000;
 int22_ar[A][U][C][G][A][U][G][C] =  1.400;
 int22_ar[A][U][C][G][C][A][G][C] =  2.000;
 int22_ar[A][U][C][G][C][C][G][C] =  2.000;
 int22_ar[A][U][C][G][C][G][G][C] =  2.000;
 int22_ar[A][U][C][G][C][U][G][C] =  2.000;
 int22_ar[A][U][C][G][G][A][G][C] =  1.500;
 int22_ar[A][U][C][G][G][C][G][C] =  2.100;
 int22_ar[A][U][C][G][G][G][G][C] =  2.000;
 int22_ar[A][U][C][G][G][U][G][C] =  2.100;
 int22_ar[A][U][C][G][U][A][G][C] = -1.300;
 int22_ar[A][U][C][G][U][C][G][C] = -0.300;
 int22_ar[A][U][C][G][U][G][G][C] =  2.000;
 int22_ar[A][U][C][G][U][U][G][C] = -0.300;
 int22_ar[A][U][C][U][A][A][G][C] =  2.000;
 int22_ar[A][U][C][U][A][C][G][C] =  2.000;
 int22_ar[A][U][C][U][A][G][G][C] =  2.000;
 int22_ar[A][U][C][U][A][U][G][C] =  2.000;
 int22_ar[A][U][C][U][C][A][G][C] =  1.700;
 int22_ar[A][U][C][U][C][C][G][C] =  1.600;
 int22_ar[A][U][C][U][C][G][G][C] =  2.000;
 int22_ar[A][U][C][U][C][U][G][C] =  1.600;
 int22_ar[A][U][C][U][G][A][G][C] = -0.900;
 int22_ar[A][U][C][U][G][C][G][C] =  0.100;
 int22_ar[A][U][C][U][G][G][G][C] =  2.000;
 int22_ar[A][U][C][U][G][U][G][C] =  0.100;
 int22_ar[A][U][C][U][U][A][G][C] =  0.900;
 int22_ar[A][U][C][U][U][C][G][C] =  0.800;
 int22_ar[A][U][C][U][U][G][G][C] =  2.000;
 int22_ar[A][U][C][U][U][U][G][C] =  0.800;
 int22_ar[A][U][G][A][A][A][G][C] =  0.900;
 int22_ar[A][U][G][A][A][C][G][C] =  2.000;
 int22_ar[A][U][G][A][A][G][G][C] =  1.400;
 int22_ar[A][U][G][A][A][U][G][C] =  1.700;
 int22_ar[A][U][G][A][C][A][G][C] =  0.600;
 int22_ar[A][U][G][A][C][C][G][C] =  2.000;
 int22_ar[A][U][G][A][C][G][G][C] =  1.200;
 int22_ar[A][U][G][A][C][U][G][C] =  0.400;
 int22_ar[A][U][G][A][G][A][G][C] = -1.100;
 int22_ar[A][U][G][A][G][C][G][C] =  2.000;
 int22_ar[A][U][G][A][G][G][G][C] = -0.600;
 int22_ar[A][U][G][A][G][U][G][C] =  0.500;
 int22_ar[A][U][G][A][U][A][G][C] =  2.000;
 int22_ar[A][U][G][A][U][C][G][C] =  2.000;
 int22_ar[A][U][G][A][U][G][G][C] =  2.000;
 int22_ar[A][U][G][A][U][U][G][C] =  2.000;
 int22_ar[A][U][G][C][A][A][G][C] =  0.600;
 int22_ar[A][U][G][C][A][C][G][C] =  2.000;
 int22_ar[A][U][G][C][A][G][G][C] =  1.100;
 int22_ar[A][U][G][C][A][U][G][C] =  0.400;
 int22_ar[A][U][G][C][C][A][G][C] =  1.600;
 int22_ar[A][U][G][C][C][C][G][C] =  2.000;
 int22_ar[A][U][G][C][C][G][G][C] =  1.800;
 int22_ar[A][U][G][C][C][U][G][C] =  1.400;
 int22_ar[A][U][G][C][G][A][G][C] =  2.000;
 int22_ar[A][U][G][C][G][C][G][C] =  2.000;
 int22_ar[A][U][G][C][G][G][G][C] =  2.000;
 int22_ar[A][U][G][C][G][U][G][C] =  2.000;
 int22_ar[A][U][G][C][U][A][G][C] =  0.700;
 int22_ar[A][U][G][C][U][C][G][C] =  2.000;
 int22_ar[A][U][G][C][U][G][G][C] =  0.800;
 int22_ar[A][U][G][C][U][U][G][C] =  0.500;
 int22_ar[A][U][G][G][A][A][G][C] = -0.500;
 int22_ar[A][U][G][G][A][C][G][C] =  2.000;
 int22_ar[A][U][G][G][A][G][G][C] =  0.000;
 int22_ar[A][U][G][G][A][U][G][C] =  1.100;
 int22_ar[A][U][G][G][C][A][G][C] =  2.000;
 int22_ar[A][U][G][G][C][C][G][C] =  2.000;
 int22_ar[A][U][G][G][C][G][G][C] =  2.000;
 int22_ar[A][U][G][G][C][U][G][C] =  2.000;
 int22_ar[A][U][G][G][G][A][G][C] =  0.500;
 int22_ar[A][U][G][G][G][C][G][C] =  2.000;
 int22_ar[A][U][G][G][G][G][G][C] =  1.100;
 int22_ar[A][U][G][G][G][U][G][C] =  1.300;
 int22_ar[A][U][G][G][U][A][G][C] = -0.500;
 int22_ar[A][U][G][G][U][C][G][C] =  2.000;
 int22_ar[A][U][G][G][U][G][G][C] = -0.700;
 int22_ar[A][U][G][G][U][U][G][C] = -2.500;
 int22_ar[A][U][G][U][A][A][G][C] =  2.000;
 int22_ar[A][U][G][U][A][C][G][C] =  2.000;
 int22_ar[A][U][G][U][A][G][G][C] =  2.000;
 int22_ar[A][U][G][U][A][U][G][C] =  2.000;
 int22_ar[A][U][G][U][C][A][G][C] =  1.700;
 int22_ar[A][U][G][U][C][C][G][C] =  2.000;
 int22_ar[A][U][G][U][C][G][G][C] =  1.800;
 int22_ar[A][U][G][U][C][U][G][C] =  1.500;
 int22_ar[A][U][G][U][G][A][G][C] = -0.100;
 int22_ar[A][U][G][U][G][C][G][C] =  2.000;
 int22_ar[A][U][G][U][G][G][G][C] = -0.300;
 int22_ar[A][U][G][U][G][U][G][C] = -2.100;
 int22_ar[A][U][G][U][U][A][G][C] =  1.700;
 int22_ar[A][U][G][U][U][C][G][C] =  2.000;
 int22_ar[A][U][G][U][U][G][G][C] =  1.400;
 int22_ar[A][U][G][U][U][U][G][C] =  1.500;
 int22_ar[A][U][U][A][A][A][G][C] =  2.000;
 int22_ar[A][U][U][A][A][C][G][C] =  2.400;
 int22_ar[A][U][U][A][A][G][G][C] =  0.700;
 int22_ar[A][U][U][A][A][U][G][C] =  2.000;
 int22_ar[A][U][U][A][C][A][G][C] =  2.000;
 int22_ar[A][U][U][A][C][C][G][C] =  1.600;
 int22_ar[A][U][U][A][C][G][G][C] = -0.500;
 int22_ar[A][U][U][A][C][U][G][C] =  0.800;
 int22_ar[A][U][U][A][G][A][G][C] =  2.000;
 int22_ar[A][U][U][A][G][C][G][C] =  0.800;
 int22_ar[A][U][U][A][G][G][G][C] = -0.500;
 int22_ar[A][U][U][A][G][U][G][C] =  0.800;
 int22_ar[A][U][U][A][U][A][G][C] =  2.000;
 int22_ar[A][U][U][A][U][C][G][C] =  2.000;
 int22_ar[A][U][U][A][U][G][G][C] =  2.000;
 int22_ar[A][U][U][A][U][U][G][C] =  2.000;
 int22_ar[A][U][U][C][A][A][G][C] =  2.000;
 int22_ar[A][U][U][C][A][C][G][C] =  1.500;
 int22_ar[A][U][U][C][A][G][G][C] = -0.600;
 int22_ar[A][U][U][C][A][U][G][C] =  0.700;
 int22_ar[A][U][U][C][C][A][G][C] =  2.000;
 int22_ar[A][U][U][C][C][C][G][C] =  1.600;
 int22_ar[A][U][U][C][C][G][G][C] =  0.500;
 int22_ar[A][U][U][C][C][U][G][C] =  0.800;
 int22_ar[A][U][U][C][G][A][G][C] =  2.000;
 int22_ar[A][U][U][C][G][C][G][C] =  2.000;
 int22_ar[A][U][U][C][G][G][G][C] =  2.000;
 int22_ar[A][U][U][C][G][U][G][C] =  2.000;
 int22_ar[A][U][U][C][U][A][G][C] =  2.000;
 int22_ar[A][U][U][C][U][C][G][C] =  0.600;
 int22_ar[A][U][U][C][U][G][G][C] = -0.500;
 int22_ar[A][U][U][C][U][U][G][C] = -0.200;
 int22_ar[A][U][U][G][A][A][G][C] =  2.000;
 int22_ar[A][U][U][G][A][C][G][C] =  1.400;
 int22_ar[A][U][U][G][A][G][G][C] =  0.100;
 int22_ar[A][U][U][G][A][U][G][C] =  1.500;
 int22_ar[A][U][U][G][C][A][G][C] =  2.000;
 int22_ar[A][U][U][G][C][C][G][C] =  2.000;
 int22_ar[A][U][U][G][C][G][G][C] =  2.000;
 int22_ar[A][U][U][G][C][U][G][C] =  2.000;
 int22_ar[A][U][U][G][G][A][G][C] =  2.000;
 int22_ar[A][U][U][G][G][C][G][C] =  2.100;
 int22_ar[A][U][U][G][G][G][G][C] =  0.400;
 int22_ar[A][U][U][G][G][U][G][C] =  1.700;
 int22_ar[A][U][U][G][U][A][G][C] =  2.000;
 int22_ar[A][U][U][G][U][C][G][C] = -0.300;
 int22_ar[A][U][U][G][U][G][G][C] = -3.500;
 int22_ar[A][U][U][G][U][U][G][C] = -0.300;
 int22_ar[A][U][U][U][A][A][G][C] =  2.000;
 int22_ar[A][U][U][U][A][C][G][C] =  2.000;
 int22_ar[A][U][U][U][A][G][G][C] =  2.000;
 int22_ar[A][U][U][U][A][U][G][C] =  2.000;
 int22_ar[A][U][U][U][C][A][G][C] =  2.000;
 int22_ar[A][U][U][U][C][C][G][C] =  1.600;
 int22_ar[A][U][U][U][C][G][G][C] =  0.500;
 int22_ar[A][U][U][U][C][U][G][C] =  0.800;
 int22_ar[A][U][U][U][G][A][G][C] =  2.000;
 int22_ar[A][U][U][U][G][C][G][C] =  0.100;
 int22_ar[A][U][U][U][G][G][G][C] = -3.100;
 int22_ar[A][U][U][U][G][U][G][C] =  0.100;
 int22_ar[A][U][U][U][U][A][G][C] =  2.000;
 int22_ar[A][U][U][U][U][C][G][C] =  0.800;
 int22_ar[A][U][U][U][U][G][G][C] =  0.500;
 int22_ar[A][U][U][U][U][U][G][C] =  0.000;
 int22_ar[A][U][A][A][A][A][G][U] =  2.800;
 int22_ar[A][U][A][A][A][C][G][U] =  2.600;
 int22_ar[A][U][A][A][A][G][G][U] =  1.500;
 int22_ar[A][U][A][A][A][U][G][U] =  2.000;
 int22_ar[A][U][A][A][C][A][G][U] =  2.500;
 int22_ar[A][U][A][A][C][C][G][U] =  2.400;
 int22_ar[A][U][A][A][C][G][G][U] =  1.300;
 int22_ar[A][U][A][A][C][U][G][U] =  2.000;
 int22_ar[A][U][A][A][G][A][G][U] =  1.500;
 int22_ar[A][U][A][A][G][C][G][U] =  1.400;
 int22_ar[A][U][A][A][G][G][G][U] =  0.300;
 int22_ar[A][U][A][A][G][U][G][U] =  2.000;
 int22_ar[A][U][A][A][U][A][G][U] =  2.000;
 int22_ar[A][U][A][A][U][C][G][U] =  2.000;
 int22_ar[A][U][A][A][U][G][G][U] =  2.000;
 int22_ar[A][U][A][A][U][U][G][U] =  2.000;
 int22_ar[A][U][A][C][A][A][G][U] =  2.600;
 int22_ar[A][U][A][C][A][C][G][U] =  2.500;
 int22_ar[A][U][A][C][A][G][G][U] =  1.400;
 int22_ar[A][U][A][C][A][U][G][U] =  2.000;
 int22_ar[A][U][A][C][C][A][G][U] =  3.100;
 int22_ar[A][U][A][C][C][C][G][U] =  2.300;
 int22_ar[A][U][A][C][C][G][G][U] =  2.200;
 int22_ar[A][U][A][C][C][U][G][U] =  2.000;
 int22_ar[A][U][A][C][G][A][G][U] =  2.000;
 int22_ar[A][U][A][C][G][C][G][U] =  2.000;
 int22_ar[A][U][A][C][G][G][G][U] =  2.000;
 int22_ar[A][U][A][C][G][U][G][U] =  2.000;
 int22_ar[A][U][A][C][U][A][G][U] =  3.100;
 int22_ar[A][U][A][C][U][C][G][U] =  2.300;
 int22_ar[A][U][A][C][U][G][G][U] =  2.200;
 int22_ar[A][U][A][C][U][U][G][U] =  2.000;
 int22_ar[A][U][A][G][A][A][G][U] =  1.500;
 int22_ar[A][U][A][G][A][C][G][U] =  1.400;
 int22_ar[A][U][A][G][A][G][G][U] =  0.300;
 int22_ar[A][U][A][G][A][U][G][U] =  2.000;
 int22_ar[A][U][A][G][C][A][G][U] =  2.000;
 int22_ar[A][U][A][G][C][C][G][U] =  2.000;
 int22_ar[A][U][A][G][C][G][G][U] =  2.000;
 int22_ar[A][U][A][G][C][U][G][U] =  2.000;
 int22_ar[A][U][A][G][G][A][G][U] =  2.100;
 int22_ar[A][U][A][G][G][C][G][U] =  1.900;
 int22_ar[A][U][A][G][G][G][G][U] =  0.800;
 int22_ar[A][U][A][G][G][U][G][U] =  2.000;
 int22_ar[A][U][A][G][U][A][G][U] =  1.300;
 int22_ar[A][U][A][G][U][C][G][U] =  0.200;
 int22_ar[A][U][A][G][U][G][G][U] =  0.900;
 int22_ar[A][U][A][G][U][U][G][U] =  2.000;
 int22_ar[A][U][A][U][A][A][G][U] =  2.000;
 int22_ar[A][U][A][U][A][C][G][U] =  2.000;
 int22_ar[A][U][A][U][A][G][G][U] =  2.000;
 int22_ar[A][U][A][U][A][U][G][U] =  2.000;
 int22_ar[A][U][A][U][C][A][G][U] =  3.100;
 int22_ar[A][U][A][U][C][C][G][U] =  2.300;
 int22_ar[A][U][A][U][C][G][G][U] =  2.200;
 int22_ar[A][U][A][U][C][U][G][U] =  2.000;
 int22_ar[A][U][A][U][G][A][G][U] =  2.300;
 int22_ar[A][U][A][U][G][C][G][U] =  1.200;
 int22_ar[A][U][A][U][G][G][G][U] =  1.900;
 int22_ar[A][U][A][U][G][U][G][U] =  2.000;
 int22_ar[A][U][A][U][U][A][G][U] =  2.700;
 int22_ar[A][U][A][U][U][C][G][U] =  1.500;
 int22_ar[A][U][A][U][U][G][G][U] =  2.200;
 int22_ar[A][U][A][U][U][U][G][U] =  2.000;
 int22_ar[A][U][C][A][A][A][G][U] =  2.500;
 int22_ar[A][U][C][A][A][C][G][U] =  3.100;
 int22_ar[A][U][C][A][A][G][G][U] =  2.000;
 int22_ar[A][U][C][A][A][U][G][U] =  3.100;
 int22_ar[A][U][C][A][C][A][G][U] =  2.300;
 int22_ar[A][U][C][A][C][C][G][U] =  2.200;
 int22_ar[A][U][C][A][C][G][G][U] =  2.000;
 int22_ar[A][U][C][A][C][U][G][U] =  2.200;
 int22_ar[A][U][C][A][G][A][G][U] =  1.300;
 int22_ar[A][U][C][A][G][C][G][U] =  2.200;
 int22_ar[A][U][C][A][G][G][G][U] =  2.000;
 int22_ar[A][U][C][A][G][U][G][U] =  2.200;
 int22_ar[A][U][C][A][U][A][G][U] =  2.000;
 int22_ar[A][U][C][A][U][C][G][U] =  2.000;
 int22_ar[A][U][C][A][U][G][G][U] =  2.000;
 int22_ar[A][U][C][A][U][U][G][U] =  2.000;
 int22_ar[A][U][C][C][A][A][G][U] =  2.400;
 int22_ar[A][U][C][C][A][C][G][U] =  2.300;
 int22_ar[A][U][C][C][A][G][G][U] =  2.000;
 int22_ar[A][U][C][C][A][U][G][U] =  2.300;
 int22_ar[A][U][C][C][C][A][G][U] =  2.200;
 int22_ar[A][U][C][C][C][C][G][U] =  2.200;
 int22_ar[A][U][C][C][C][G][G][U] =  2.000;
 int22_ar[A][U][C][C][C][U][G][U] =  2.200;
 int22_ar[A][U][C][C][G][A][G][U] =  2.000;
 int22_ar[A][U][C][C][G][C][G][U] =  2.000;
 int22_ar[A][U][C][C][G][G][G][U] =  2.000;
 int22_ar[A][U][C][C][G][U][G][U] =  2.000;
 int22_ar[A][U][C][C][U][A][G][U] =  2.200;
 int22_ar[A][U][C][C][U][C][G][U] =  2.200;
 int22_ar[A][U][C][C][U][G][G][U] =  2.000;
 int22_ar[A][U][C][C][U][U][G][U] =  2.200;
 int22_ar[A][U][C][G][A][A][G][U] =  1.300;
 int22_ar[A][U][C][G][A][C][G][U] =  2.200;
 int22_ar[A][U][C][G][A][G][G][U] =  2.000;
 int22_ar[A][U][C][G][A][U][G][U] =  2.200;
 int22_ar[A][U][C][G][C][A][G][U] =  2.000;
 int22_ar[A][U][C][G][C][C][G][U] =  2.000;
 int22_ar[A][U][C][G][C][G][G][U] =  2.000;
 int22_ar[A][U][C][G][C][U][G][U] =  2.000;
 int22_ar[A][U][C][G][G][A][G][U] =  1.800;
 int22_ar[A][U][C][G][G][C][G][U] =  2.400;
 int22_ar[A][U][C][G][G][G][G][U] =  2.000;
 int22_ar[A][U][C][G][G][U][G][U] =  2.400;
 int22_ar[A][U][C][G][U][A][G][U] =  0.100;
 int22_ar[A][U][C][G][U][C][G][U] =  1.000;
 int22_ar[A][U][C][G][U][G][G][U] =  2.000;
 int22_ar[A][U][C][G][U][U][G][U] =  1.000;
 int22_ar[A][U][C][U][A][A][G][U] =  2.000;
 int22_ar[A][U][C][U][A][C][G][U] =  2.000;
 int22_ar[A][U][C][U][A][G][G][U] =  2.000;
 int22_ar[A][U][C][U][A][U][G][U] =  2.000;
 int22_ar[A][U][C][U][C][A][G][U] =  2.200;
 int22_ar[A][U][C][U][C][C][G][U] =  2.200;
 int22_ar[A][U][C][U][C][G][G][U] =  2.000;
 int22_ar[A][U][C][U][C][U][G][U] =  2.200;
 int22_ar[A][U][C][U][G][A][G][U] =  1.100;
 int22_ar[A][U][C][U][G][C][G][U] =  2.000;
 int22_ar[A][U][C][U][G][G][G][U] =  2.000;
 int22_ar[A][U][C][U][G][U][G][U] =  2.000;
 int22_ar[A][U][C][U][U][A][G][U] =  1.400;
 int22_ar[A][U][C][U][U][C][G][U] =  1.400;
 int22_ar[A][U][C][U][U][G][G][U] =  2.000;
 int22_ar[A][U][C][U][U][U][G][U] =  1.400;
 int22_ar[A][U][G][A][A][A][G][U] =  1.500;
 int22_ar[A][U][G][A][A][C][G][U] =  2.000;
 int22_ar[A][U][G][A][A][G][G][U] =  2.100;
 int22_ar[A][U][G][A][A][U][G][U] =  2.300;
 int22_ar[A][U][G][A][C][A][G][U] =  1.300;
 int22_ar[A][U][G][A][C][C][G][U] =  2.000;
 int22_ar[A][U][G][A][C][G][G][U] =  1.800;
 int22_ar[A][U][G][A][C][U][G][U] =  1.100;
 int22_ar[A][U][G][A][G][A][G][U] =  0.300;
 int22_ar[A][U][G][A][G][C][G][U] =  2.000;
 int22_ar[A][U][G][A][G][G][G][U] =  0.800;
 int22_ar[A][U][G][A][G][U][G][U] =  1.900;
 int22_ar[A][U][G][A][U][A][G][U] =  2.000;
 int22_ar[A][U][G][A][U][C][G][U] =  2.000;
 int22_ar[A][U][G][A][U][G][G][U] =  2.000;
 int22_ar[A][U][G][A][U][U][G][U] =  2.000;
 int22_ar[A][U][G][C][A][A][G][U] =  1.400;
 int22_ar[A][U][G][C][A][C][G][U] =  2.000;
 int22_ar[A][U][G][C][A][G][G][U] =  1.900;
 int22_ar[A][U][G][C][A][U][G][U] =  1.200;
 int22_ar[A][U][G][C][C][A][G][U] =  2.200;
 int22_ar[A][U][G][C][C][C][G][U] =  2.000;
 int22_ar[A][U][G][C][C][G][G][U] =  2.400;
 int22_ar[A][U][G][C][C][U][G][U] =  2.000;
 int22_ar[A][U][G][C][G][A][G][U] =  2.000;
 int22_ar[A][U][G][C][G][C][G][U] =  2.000;
 int22_ar[A][U][G][C][G][G][G][U] =  2.000;
 int22_ar[A][U][G][C][G][U][G][U] =  2.000;
 int22_ar[A][U][G][C][U][A][G][U] =  2.200;
 int22_ar[A][U][G][C][U][C][G][U] =  2.000;
 int22_ar[A][U][G][C][U][G][G][U] =  2.400;
 int22_ar[A][U][G][C][U][U][G][U] =  2.000;
 int22_ar[A][U][G][G][A][A][G][U] =  0.300;
 int22_ar[A][U][G][G][A][C][G][U] =  2.000;
 int22_ar[A][U][G][G][A][G][G][U] =  0.800;
 int22_ar[A][U][G][G][A][U][G][U] =  1.900;
 int22_ar[A][U][G][G][C][A][G][U] =  2.000;
 int22_ar[A][U][G][G][C][C][G][U] =  2.000;
 int22_ar[A][U][G][G][C][G][G][U] =  2.000;
 int22_ar[A][U][G][G][C][U][G][U] =  2.000;
 int22_ar[A][U][G][G][G][A][G][U] =  0.800;
 int22_ar[A][U][G][G][G][C][G][U] =  2.000;
 int22_ar[A][U][G][G][G][G][G][U] =  1.400;
 int22_ar[A][U][G][G][G][U][G][U] =  1.600;
 int22_ar[A][U][G][G][U][A][G][U] =  0.900;
 int22_ar[A][U][G][G][U][C][G][U] =  2.000;
 int22_ar[A][U][G][G][U][G][G][U] =  0.700;
 int22_ar[A][U][G][G][U][U][G][U] = -1.100;
 int22_ar[A][U][G][U][A][A][G][U] =  2.000;
 int22_ar[A][U][G][U][A][C][G][U] =  2.000;
 int22_ar[A][U][G][U][A][G][G][U] =  2.000;
 int22_ar[A][U][G][U][A][U][G][U] =  2.000;
 int22_ar[A][U][G][U][C][A][G][U] =  2.200;
 int22_ar[A][U][G][U][C][C][G][U] =  2.000;
 int22_ar[A][U][G][U][C][G][G][U] =  2.400;
 int22_ar[A][U][G][U][C][U][G][U] =  2.000;
 int22_ar[A][U][G][U][G][A][G][U] =  1.900;
 int22_ar[A][U][G][U][G][C][G][U] =  2.000;
 int22_ar[A][U][G][U][G][G][G][U] =  1.600;
 int22_ar[A][U][G][U][G][U][G][U] = -0.100;
 int22_ar[A][U][G][U][U][A][G][U] =  2.200;
 int22_ar[A][U][G][U][U][C][G][U] =  2.000;
 int22_ar[A][U][G][U][U][G][G][U] =  2.000;
 int22_ar[A][U][G][U][U][U][G][U] =  2.000;
 int22_ar[A][U][U][A][A][A][G][U] =  2.000;
 int22_ar[A][U][U][A][A][C][G][U] =  3.100;
 int22_ar[A][U][U][A][A][G][G][U] =  1.300;
 int22_ar[A][U][U][A][A][U][G][U] =  2.700;
 int22_ar[A][U][U][A][C][A][G][U] =  2.000;
 int22_ar[A][U][U][A][C][C][G][U] =  2.200;
 int22_ar[A][U][U][A][C][G][G][U] =  0.100;
 int22_ar[A][U][U][A][C][U][G][U] =  1.400;
 int22_ar[A][U][U][A][G][A][G][U] =  2.000;
 int22_ar[A][U][U][A][G][C][G][U] =  2.200;
 int22_ar[A][U][U][A][G][G][G][U] =  0.900;
 int22_ar[A][U][U][A][G][U][G][U] =  2.200;
 int22_ar[A][U][U][A][U][A][G][U] =  2.000;
 int22_ar[A][U][U][A][U][C][G][U] =  2.000;
 int22_ar[A][U][U][A][U][G][G][U] =  2.000;
 int22_ar[A][U][U][A][U][U][G][U] =  2.000;
 int22_ar[A][U][U][C][A][A][G][U] =  2.000;
 int22_ar[A][U][U][C][A][C][G][U] =  2.300;
 int22_ar[A][U][U][C][A][G][G][U] =  0.200;
 int22_ar[A][U][U][C][A][U][G][U] =  1.500;
 int22_ar[A][U][U][C][C][A][G][U] =  2.000;
 int22_ar[A][U][U][C][C][C][G][U] =  2.200;
 int22_ar[A][U][U][C][C][G][G][U] =  1.000;
 int22_ar[A][U][U][C][C][U][G][U] =  1.400;
 int22_ar[A][U][U][C][G][A][G][U] =  2.000;
 int22_ar[A][U][U][C][G][C][G][U] =  2.000;
 int22_ar[A][U][U][C][G][G][G][U] =  2.000;
 int22_ar[A][U][U][C][G][U][G][U] =  2.000;
 int22_ar[A][U][U][C][U][A][G][U] =  2.000;
 int22_ar[A][U][U][C][U][C][G][U] =  2.200;
 int22_ar[A][U][U][C][U][G][G][U] =  1.000;
 int22_ar[A][U][U][C][U][U][G][U] =  1.400;
 int22_ar[A][U][U][G][A][A][G][U] =  2.000;
 int22_ar[A][U][U][G][A][C][G][U] =  2.200;
 int22_ar[A][U][U][G][A][G][G][U] =  0.900;
 int22_ar[A][U][U][G][A][U][G][U] =  2.200;
 int22_ar[A][U][U][G][C][A][G][U] =  2.000;
 int22_ar[A][U][U][G][C][C][G][U] =  2.000;
 int22_ar[A][U][U][G][C][G][G][U] =  2.000;
 int22_ar[A][U][U][G][C][U][G][U] =  2.000;
 int22_ar[A][U][U][G][G][A][G][U] =  2.000;
 int22_ar[A][U][U][G][G][C][G][U] =  2.400;
 int22_ar[A][U][U][G][G][G][G][U] =  0.700;
 int22_ar[A][U][U][G][G][U][G][U] =  2.000;
 int22_ar[A][U][U][G][U][A][G][U] =  2.000;
 int22_ar[A][U][U][G][U][C][G][U] =  1.000;
 int22_ar[A][U][U][G][U][G][G][U] = -2.100;
 int22_ar[A][U][U][G][U][U][G][U] =  1.100;
 int22_ar[A][U][U][U][A][A][G][U] =  2.000;
 int22_ar[A][U][U][U][A][C][G][U] =  2.000;
 int22_ar[A][U][U][U][A][G][G][U] =  2.000;
 int22_ar[A][U][U][U][A][U][G][U] =  2.000;
 int22_ar[A][U][U][U][C][A][G][U] =  2.000;
 int22_ar[A][U][U][U][C][C][G][U] =  2.200;
 int22_ar[A][U][U][U][C][G][G][U] =  1.000;
 int22_ar[A][U][U][U][C][U][G][U] =  1.400;
 int22_ar[A][U][U][U][G][A][G][U] =  2.000;
 int22_ar[A][U][U][U][G][C][G][U] =  2.000;
 int22_ar[A][U][U][U][G][G][G][U] = -1.100;
 int22_ar[A][U][U][U][G][U][G][U] =  2.000;
 int22_ar[A][U][U][U][U][A][G][U] =  2.000;
 int22_ar[A][U][U][U][U][C][G][U] =  1.400;
 int22_ar[A][U][U][U][U][G][G][U] =  1.100;
 int22_ar[A][U][U][U][U][U][G][U] =  0.600;
 int22_ar[A][U][A][A][A][A][U][A] =  2.800;
 int22_ar[A][U][A][A][A][C][U][A] =  2.600;
 int22_ar[A][U][A][A][A][G][U][A] =  1.500;
 int22_ar[A][U][A][A][A][U][U][A] =  2.000;
 int22_ar[A][U][A][A][C][A][U][A] =  2.300;
 int22_ar[A][U][A][A][C][C][U][A] =  2.200;
 int22_ar[A][U][A][A][C][G][U][A] =  1.100;
 int22_ar[A][U][A][A][C][U][U][A] =  2.000;
 int22_ar[A][U][A][A][G][A][U][A] =  1.700;
 int22_ar[A][U][A][A][G][C][U][A] =  1.600;
 int22_ar[A][U][A][A][G][G][U][A] =  0.500;
 int22_ar[A][U][A][A][G][U][U][A] =  2.000;
 int22_ar[A][U][A][A][U][A][U][A] =  2.000;
 int22_ar[A][U][A][A][U][C][U][A] =  2.000;
 int22_ar[A][U][A][A][U][G][U][A] =  2.000;
 int22_ar[A][U][A][A][U][U][U][A] =  2.000;
 int22_ar[A][U][A][C][A][A][U][A] =  2.800;
 int22_ar[A][U][A][C][A][C][U][A] =  2.600;
 int22_ar[A][U][A][C][A][G][U][A] =  1.500;
 int22_ar[A][U][A][C][A][U][U][A] =  2.000;
 int22_ar[A][U][A][C][C][A][U][A] =  3.400;
 int22_ar[A][U][A][C][C][C][U][A] =  2.600;
 int22_ar[A][U][A][C][C][G][U][A] =  2.500;
 int22_ar[A][U][A][C][C][U][U][A] =  2.000;
 int22_ar[A][U][A][C][G][A][U][A] =  2.000;
 int22_ar[A][U][A][C][G][C][U][A] =  2.000;
 int22_ar[A][U][A][C][G][G][U][A] =  2.000;
 int22_ar[A][U][A][C][G][U][U][A] =  2.000;
 int22_ar[A][U][A][C][U][A][U][A] =  3.400;
 int22_ar[A][U][A][C][U][C][U][A] =  2.600;
 int22_ar[A][U][A][C][U][G][U][A] =  2.500;
 int22_ar[A][U][A][C][U][U][U][A] =  2.000;
 int22_ar[A][U][A][G][A][A][U][A] =  1.700;
 int22_ar[A][U][A][G][A][C][U][A] =  1.600;
 int22_ar[A][U][A][G][A][G][U][A] =  0.500;
 int22_ar[A][U][A][G][A][U][U][A] =  2.000;
 int22_ar[A][U][A][G][C][A][U][A] =  2.000;
 int22_ar[A][U][A][G][C][C][U][A] =  2.000;
 int22_ar[A][U][A][G][C][G][U][A] =  2.000;
 int22_ar[A][U][A][G][C][U][U][A] =  2.000;
 int22_ar[A][U][A][G][G][A][U][A] =  2.100;
 int22_ar[A][U][A][G][G][C][U][A] =  2.000;
 int22_ar[A][U][A][G][G][G][U][A] =  0.900;
 int22_ar[A][U][A][G][G][U][U][A] =  2.000;
 int22_ar[A][U][A][G][U][A][U][A] =  1.000;
 int22_ar[A][U][A][G][U][C][U][A] = -0.200;
 int22_ar[A][U][A][G][U][G][U][A] =  0.500;
 int22_ar[A][U][A][G][U][U][U][A] =  2.000;
 int22_ar[A][U][A][U][A][A][U][A] =  2.000;
 int22_ar[A][U][A][U][A][C][U][A] =  2.000;
 int22_ar[A][U][A][U][A][G][U][A] =  2.000;
 int22_ar[A][U][A][U][A][U][U][A] =  2.000;
 int22_ar[A][U][A][U][C][A][U][A] =  3.100;
 int22_ar[A][U][A][U][C][C][U][A] =  2.300;
 int22_ar[A][U][A][U][C][G][U][A] =  2.200;
 int22_ar[A][U][A][U][C][U][U][A] =  2.000;
 int22_ar[A][U][A][U][G][A][U][A] =  2.200;
 int22_ar[A][U][A][U][G][C][U][A] =  1.100;
 int22_ar[A][U][A][U][G][G][U][A] =  1.800;
 int22_ar[A][U][A][U][G][U][U][A] =  2.000;
 int22_ar[A][U][A][U][U][A][U][A] =  2.900;
 int22_ar[A][U][A][U][U][C][U][A] =  1.800;
 int22_ar[A][U][A][U][U][G][U][A] =  2.500;
 int22_ar[A][U][A][U][U][U][U][A] =  2.000;
 int22_ar[A][U][C][A][A][A][U][A] =  2.500;
 int22_ar[A][U][C][A][A][C][U][A] =  3.100;
 int22_ar[A][U][C][A][A][G][U][A] =  2.000;
 int22_ar[A][U][C][A][A][U][U][A] =  3.100;
 int22_ar[A][U][C][A][C][A][U][A] =  2.100;
 int22_ar[A][U][C][A][C][C][U][A] =  2.000;
 int22_ar[A][U][C][A][C][G][U][A] =  2.000;
 int22_ar[A][U][C][A][C][U][U][A] =  2.000;
 int22_ar[A][U][C][A][G][A][U][A] =  1.500;
 int22_ar[A][U][C][A][G][C][U][A] =  2.400;
 int22_ar[A][U][C][A][G][G][U][A] =  2.000;
 int22_ar[A][U][C][A][G][U][U][A] =  2.400;
 int22_ar[A][U][C][A][U][A][U][A] =  2.000;
 int22_ar[A][U][C][A][U][C][U][A] =  2.000;
 int22_ar[A][U][C][A][U][G][U][A] =  2.000;
 int22_ar[A][U][C][A][U][U][U][A] =  2.000;
 int22_ar[A][U][C][C][A][A][U][A] =  2.500;
 int22_ar[A][U][C][C][A][C][U][A] =  2.500;
 int22_ar[A][U][C][C][A][G][U][A] =  2.000;
 int22_ar[A][U][C][C][A][U][U][A] =  2.500;
 int22_ar[A][U][C][C][C][A][U][A] =  2.500;
 int22_ar[A][U][C][C][C][C][U][A] =  2.500;
 int22_ar[A][U][C][C][C][G][U][A] =  2.000;
 int22_ar[A][U][C][C][C][U][U][A] =  2.500;
 int22_ar[A][U][C][C][G][A][U][A] =  2.000;
 int22_ar[A][U][C][C][G][C][U][A] =  2.000;
 int22_ar[A][U][C][C][G][G][U][A] =  2.000;
 int22_ar[A][U][C][C][G][U][U][A] =  2.000;
 int22_ar[A][U][C][C][U][A][U][A] =  2.500;
 int22_ar[A][U][C][C][U][C][U][A] =  2.500;
 int22_ar[A][U][C][C][U][G][U][A] =  2.000;
 int22_ar[A][U][C][C][U][U][U][A] =  2.500;
 int22_ar[A][U][C][G][A][A][U][A] =  1.500;
 int22_ar[A][U][C][G][A][C][U][A] =  2.400;
 int22_ar[A][U][C][G][A][G][U][A] =  2.000;
 int22_ar[A][U][C][G][A][U][U][A] =  2.400;
 int22_ar[A][U][C][G][C][A][U][A] =  2.000;
 int22_ar[A][U][C][G][C][C][U][A] =  2.000;
 int22_ar[A][U][C][G][C][G][U][A] =  2.000;
 int22_ar[A][U][C][G][C][U][U][A] =  2.000;
 int22_ar[A][U][C][G][G][A][U][A] =  1.900;
 int22_ar[A][U][C][G][G][C][U][A] =  2.400;
 int22_ar[A][U][C][G][G][G][U][A] =  2.000;
 int22_ar[A][U][C][G][G][U][U][A] =  2.400;
 int22_ar[A][U][C][G][U][A][U][A] = -0.300;
 int22_ar[A][U][C][G][U][C][U][A] =  0.700;
 int22_ar[A][U][C][G][U][G][U][A] =  2.000;
 int22_ar[A][U][C][G][U][U][U][A] =  0.700;
 int22_ar[A][U][C][U][A][A][U][A] =  2.000;
 int22_ar[A][U][C][U][A][C][U][A] =  2.000;
 int22_ar[A][U][C][U][A][G][U][A] =  2.000;
 int22_ar[A][U][C][U][A][U][U][A] =  2.000;
 int22_ar[A][U][C][U][C][A][U][A] =  2.200;
 int22_ar[A][U][C][U][C][C][U][A] =  2.200;
 int22_ar[A][U][C][U][C][G][U][A] =  2.000;
 int22_ar[A][U][C][U][C][U][U][A] =  2.200;
 int22_ar[A][U][C][U][G][A][U][A] =  1.000;
 int22_ar[A][U][C][U][G][C][U][A] =  1.900;
 int22_ar[A][U][C][U][G][G][U][A] =  2.000;
 int22_ar[A][U][C][U][G][U][U][A] =  1.900;
 int22_ar[A][U][C][U][U][A][U][A] =  1.700;
 int22_ar[A][U][C][U][U][C][U][A] =  1.600;
 int22_ar[A][U][C][U][U][G][U][A] =  2.000;
 int22_ar[A][U][C][U][U][U][U][A] =  1.600;
 int22_ar[A][U][G][A][A][A][U][A] =  1.500;
 int22_ar[A][U][G][A][A][C][U][A] =  2.000;
 int22_ar[A][U][G][A][A][G][U][A] =  2.100;
 int22_ar[A][U][G][A][A][U][U][A] =  2.300;
 int22_ar[A][U][G][A][C][A][U][A] =  1.100;
 int22_ar[A][U][G][A][C][C][U][A] =  2.000;
 int22_ar[A][U][G][A][C][G][U][A] =  1.600;
 int22_ar[A][U][G][A][C][U][U][A] =  0.900;
 int22_ar[A][U][G][A][G][A][U][A] =  0.500;
 int22_ar[A][U][G][A][G][C][U][A] =  2.000;
 int22_ar[A][U][G][A][G][G][U][A] =  1.000;
 int22_ar[A][U][G][A][G][U][U][A] =  2.100;
 int22_ar[A][U][G][A][U][A][U][A] =  2.000;
 int22_ar[A][U][G][A][U][C][U][A] =  2.000;
 int22_ar[A][U][G][A][U][G][U][A] =  2.000;
 int22_ar[A][U][G][A][U][U][U][A] =  2.000;
 int22_ar[A][U][G][C][A][A][U][A] =  1.500;
 int22_ar[A][U][G][C][A][C][U][A] =  2.000;
 int22_ar[A][U][G][C][A][G][U][A] =  2.100;
 int22_ar[A][U][G][C][A][U][U][A] =  1.300;
 int22_ar[A][U][G][C][C][A][U][A] =  2.500;
 int22_ar[A][U][G][C][C][C][U][A] =  2.000;
 int22_ar[A][U][G][C][C][G][U][A] =  2.700;
 int22_ar[A][U][G][C][C][U][U][A] =  2.300;
 int22_ar[A][U][G][C][G][A][U][A] =  2.000;
 int22_ar[A][U][G][C][G][C][U][A] =  2.000;
 int22_ar[A][U][G][C][G][G][U][A] =  2.000;
 int22_ar[A][U][G][C][G][U][U][A] =  2.000;
 int22_ar[A][U][G][C][U][A][U][A] =  2.500;
 int22_ar[A][U][G][C][U][C][U][A] =  2.000;
 int22_ar[A][U][G][C][U][G][U][A] =  2.700;
 int22_ar[A][U][G][C][U][U][U][A] =  2.300;
 int22_ar[A][U][G][G][A][A][U][A] =  0.500;
 int22_ar[A][U][G][G][A][C][U][A] =  2.000;
 int22_ar[A][U][G][G][A][G][U][A] =  1.000;
 int22_ar[A][U][G][G][A][U][U][A] =  2.100;
 int22_ar[A][U][G][G][C][A][U][A] =  2.000;
 int22_ar[A][U][G][G][C][C][U][A] =  2.000;
 int22_ar[A][U][G][G][C][G][U][A] =  2.000;
 int22_ar[A][U][G][G][C][U][U][A] =  2.000;
 int22_ar[A][U][G][G][G][A][U][A] =  0.900;
 int22_ar[A][U][G][G][G][C][U][A] =  2.000;
 int22_ar[A][U][G][G][G][G][U][A] =  1.400;
 int22_ar[A][U][G][G][G][U][U][A] =  1.700;
 int22_ar[A][U][G][G][U][A][U][A] =  0.500;
 int22_ar[A][U][G][G][U][C][U][A] =  2.000;
 int22_ar[A][U][G][G][U][G][U][A] =  0.300;
 int22_ar[A][U][G][G][U][U][U][A] = -1.500;
 int22_ar[A][U][G][U][A][A][U][A] =  2.000;
 int22_ar[A][U][G][U][A][C][U][A] =  2.000;
 int22_ar[A][U][G][U][A][G][U][A] =  2.000;
 int22_ar[A][U][G][U][A][U][U][A] =  2.000;
 int22_ar[A][U][G][U][C][A][U][A] =  2.200;
 int22_ar[A][U][G][U][C][C][U][A] =  2.000;
 int22_ar[A][U][G][U][C][G][U][A] =  2.400;
 int22_ar[A][U][G][U][C][U][U][A] =  2.000;
 int22_ar[A][U][G][U][G][A][U][A] =  1.800;
 int22_ar[A][U][G][U][G][C][U][A] =  2.000;
 int22_ar[A][U][G][U][G][G][U][A] =  1.500;
 int22_ar[A][U][G][U][G][U][U][A] = -0.200;
 int22_ar[A][U][G][U][U][A][U][A] =  2.500;
 int22_ar[A][U][G][U][U][C][U][A] =  2.000;
 int22_ar[A][U][G][U][U][G][U][A] =  2.200;
 int22_ar[A][U][G][U][U][U][U][A] =  2.300;
 int22_ar[A][U][U][A][A][A][U][A] =  2.000;
 int22_ar[A][U][U][A][A][C][U][A] =  3.100;
 int22_ar[A][U][U][A][A][G][U][A] =  1.300;
 int22_ar[A][U][U][A][A][U][U][A] =  2.700;
 int22_ar[A][U][U][A][C][A][U][A] =  2.000;
 int22_ar[A][U][U][A][C][C][U][A] =  2.000;
 int22_ar[A][U][U][A][C][G][U][A] = -0.100;
 int22_ar[A][U][U][A][C][U][U][A] =  1.200;
 int22_ar[A][U][U][A][G][A][U][A] =  2.000;
 int22_ar[A][U][U][A][G][C][U][A] =  2.400;
 int22_ar[A][U][U][A][G][G][U][A] =  1.100;
 int22_ar[A][U][U][A][G][U][U][A] =  2.400;
 int22_ar[A][U][U][A][U][A][U][A] =  2.000;
 int22_ar[A][U][U][A][U][C][U][A] =  2.000;
 int22_ar[A][U][U][A][U][G][U][A] =  2.000;
 int22_ar[A][U][U][A][U][U][U][A] =  2.000;
 int22_ar[A][U][U][C][A][A][U][A] =  2.000;
 int22_ar[A][U][U][C][A][C][U][A] =  2.500;
 int22_ar[A][U][U][C][A][G][U][A] =  0.300;
 int22_ar[A][U][U][C][A][U][U][A] =  1.700;
 int22_ar[A][U][U][C][C][A][U][A] =  2.000;
 int22_ar[A][U][U][C][C][C][U][A] =  2.500;
 int22_ar[A][U][U][C][C][G][U][A] =  1.300;
 int22_ar[A][U][U][C][C][U][U][A] =  1.700;
 int22_ar[A][U][U][C][G][A][U][A] =  2.000;
 int22_ar[A][U][U][C][G][C][U][A] =  2.000;
 int22_ar[A][U][U][C][G][G][U][A] =  2.000;
 int22_ar[A][U][U][C][G][U][U][A] =  2.000;
 int22_ar[A][U][U][C][U][A][U][A] =  2.000;
 int22_ar[A][U][U][C][U][C][U][A] =  2.500;
 int22_ar[A][U][U][C][U][G][U][A] =  1.300;
 int22_ar[A][U][U][C][U][U][U][A] =  1.700;
 int22_ar[A][U][U][G][A][A][U][A] =  2.000;
 int22_ar[A][U][U][G][A][C][U][A] =  2.400;
 int22_ar[A][U][U][G][A][G][U][A] =  1.100;
 int22_ar[A][U][U][G][A][U][U][A] =  2.400;
 int22_ar[A][U][U][G][C][A][U][A] =  2.000;
 int22_ar[A][U][U][G][C][C][U][A] =  2.000;
 int22_ar[A][U][U][G][C][G][U][A] =  2.000;
 int22_ar[A][U][U][G][C][U][U][A] =  2.000;
 int22_ar[A][U][U][G][G][A][U][A] =  2.000;
 int22_ar[A][U][U][G][G][C][U][A] =  2.400;
 int22_ar[A][U][U][G][G][G][U][A] =  0.700;
 int22_ar[A][U][U][G][G][U][U][A] =  2.000;
 int22_ar[A][U][U][G][U][A][U][A] =  2.000;
 int22_ar[A][U][U][G][U][C][U][A] =  0.700;
 int22_ar[A][U][U][G][U][G][U][A] = -2.500;
 int22_ar[A][U][U][G][U][U][U][A] =  0.700;
 int22_ar[A][U][U][U][A][A][U][A] =  2.000;
 int22_ar[A][U][U][U][A][C][U][A] =  2.000;
 int22_ar[A][U][U][U][A][G][U][A] =  2.000;
 int22_ar[A][U][U][U][A][U][U][A] =  2.000;
 int22_ar[A][U][U][U][C][A][U][A] =  2.000;
 int22_ar[A][U][U][U][C][C][U][A] =  2.200;
 int22_ar[A][U][U][U][C][G][U][A] =  1.000;
 int22_ar[A][U][U][U][C][U][U][A] =  1.400;
 int22_ar[A][U][U][U][G][A][U][A] =  2.000;
 int22_ar[A][U][U][U][G][C][U][A] =  1.900;
 int22_ar[A][U][U][U][G][G][U][A] = -1.200;
 int22_ar[A][U][U][U][G][U][U][A] =  1.900;
 int22_ar[A][U][U][U][U][A][U][A] =  2.000;
 int22_ar[A][U][U][U][U][C][U][A] =  1.600;
 int22_ar[A][U][U][U][U][G][U][A] =  1.300;
 int22_ar[A][U][U][U][U][U][U][A] =  0.800;
 int22_ar[A][U][A][A][A][A][U][G] =  2.800;
 int22_ar[A][U][A][A][A][C][U][G] =  2.600;
 int22_ar[A][U][A][A][A][G][U][G] =  1.500;
 int22_ar[A][U][A][A][A][U][U][G] =  2.000;
 int22_ar[A][U][A][A][C][A][U][G] =  2.300;
 int22_ar[A][U][A][A][C][C][U][G] =  2.200;
 int22_ar[A][U][A][A][C][G][U][G] =  1.100;
 int22_ar[A][U][A][A][C][U][U][G] =  2.000;
 int22_ar[A][U][A][A][G][A][U][G] =  1.700;
 int22_ar[A][U][A][A][G][C][U][G] =  1.600;
 int22_ar[A][U][A][A][G][G][U][G] =  0.500;
 int22_ar[A][U][A][A][G][U][U][G] =  2.000;
 int22_ar[A][U][A][A][U][A][U][G] =  2.000;
 int22_ar[A][U][A][A][U][C][U][G] =  2.000;
 int22_ar[A][U][A][A][U][G][U][G] =  2.000;
 int22_ar[A][U][A][A][U][U][U][G] =  2.000;
 int22_ar[A][U][A][C][A][A][U][G] =  2.800;
 int22_ar[A][U][A][C][A][C][U][G] =  2.600;
 int22_ar[A][U][A][C][A][G][U][G] =  1.500;
 int22_ar[A][U][A][C][A][U][U][G] =  2.000;
 int22_ar[A][U][A][C][C][A][U][G] =  3.400;
 int22_ar[A][U][A][C][C][C][U][G] =  2.600;
 int22_ar[A][U][A][C][C][G][U][G] =  2.500;
 int22_ar[A][U][A][C][C][U][U][G] =  2.000;
 int22_ar[A][U][A][C][G][A][U][G] =  2.000;
 int22_ar[A][U][A][C][G][C][U][G] =  2.000;
 int22_ar[A][U][A][C][G][G][U][G] =  2.000;
 int22_ar[A][U][A][C][G][U][U][G] =  2.000;
 int22_ar[A][U][A][C][U][A][U][G] =  3.400;
 int22_ar[A][U][A][C][U][C][U][G] =  2.600;
 int22_ar[A][U][A][C][U][G][U][G] =  2.500;
 int22_ar[A][U][A][C][U][U][U][G] =  2.000;
 int22_ar[A][U][A][G][A][A][U][G] =  1.700;
 int22_ar[A][U][A][G][A][C][U][G] =  1.600;
 int22_ar[A][U][A][G][A][G][U][G] =  0.500;
 int22_ar[A][U][A][G][A][U][U][G] =  2.000;
 int22_ar[A][U][A][G][C][A][U][G] =  2.000;
 int22_ar[A][U][A][G][C][C][U][G] =  2.000;
 int22_ar[A][U][A][G][C][G][U][G] =  2.000;
 int22_ar[A][U][A][G][C][U][U][G] =  2.000;
 int22_ar[A][U][A][G][G][A][U][G] =  2.100;
 int22_ar[A][U][A][G][G][C][U][G] =  2.000;
 int22_ar[A][U][A][G][G][G][U][G] =  0.900;
 int22_ar[A][U][A][G][G][U][U][G] =  2.000;
 int22_ar[A][U][A][G][U][A][U][G] =  1.000;
 int22_ar[A][U][A][G][U][C][U][G] = -0.200;
 int22_ar[A][U][A][G][U][G][U][G] =  0.500;
 int22_ar[A][U][A][G][U][U][U][G] =  2.000;
 int22_ar[A][U][A][U][A][A][U][G] =  2.000;
 int22_ar[A][U][A][U][A][C][U][G] =  2.000;
 int22_ar[A][U][A][U][A][G][U][G] =  2.000;
 int22_ar[A][U][A][U][A][U][U][G] =  2.000;
 int22_ar[A][U][A][U][C][A][U][G] =  3.100;
 int22_ar[A][U][A][U][C][C][U][G] =  2.300;
 int22_ar[A][U][A][U][C][G][U][G] =  2.200;
 int22_ar[A][U][A][U][C][U][U][G] =  2.000;
 int22_ar[A][U][A][U][G][A][U][G] =  2.200;
 int22_ar[A][U][A][U][G][C][U][G] =  1.100;
 int22_ar[A][U][A][U][G][G][U][G] =  1.800;
 int22_ar[A][U][A][U][G][U][U][G] =  2.000;
 int22_ar[A][U][A][U][U][A][U][G] =  2.900;
 int22_ar[A][U][A][U][U][C][U][G] =  1.800;
 int22_ar[A][U][A][U][U][G][U][G] =  2.500;
 int22_ar[A][U][A][U][U][U][U][G] =  2.000;
 int22_ar[A][U][C][A][A][A][U][G] =  2.500;
 int22_ar[A][U][C][A][A][C][U][G] =  3.100;
 int22_ar[A][U][C][A][A][G][U][G] =  2.000;
 int22_ar[A][U][C][A][A][U][U][G] =  3.100;
 int22_ar[A][U][C][A][C][A][U][G] =  2.100;
 int22_ar[A][U][C][A][C][C][U][G] =  2.000;
 int22_ar[A][U][C][A][C][G][U][G] =  2.000;
 int22_ar[A][U][C][A][C][U][U][G] =  2.000;
 int22_ar[A][U][C][A][G][A][U][G] =  1.500;
 int22_ar[A][U][C][A][G][C][U][G] =  2.400;
 int22_ar[A][U][C][A][G][G][U][G] =  2.000;
 int22_ar[A][U][C][A][G][U][U][G] =  2.400;
 int22_ar[A][U][C][A][U][A][U][G] =  2.000;
 int22_ar[A][U][C][A][U][C][U][G] =  2.000;
 int22_ar[A][U][C][A][U][G][U][G] =  2.000;
 int22_ar[A][U][C][A][U][U][U][G] =  2.000;
 int22_ar[A][U][C][C][A][A][U][G] =  2.500;
 int22_ar[A][U][C][C][A][C][U][G] =  2.500;
 int22_ar[A][U][C][C][A][G][U][G] =  2.000;
 int22_ar[A][U][C][C][A][U][U][G] =  2.500;
 int22_ar[A][U][C][C][C][A][U][G] =  2.500;
 int22_ar[A][U][C][C][C][C][U][G] =  2.500;
 int22_ar[A][U][C][C][C][G][U][G] =  2.000;
 int22_ar[A][U][C][C][C][U][U][G] =  2.500;
 int22_ar[A][U][C][C][G][A][U][G] =  2.000;
 int22_ar[A][U][C][C][G][C][U][G] =  2.000;
 int22_ar[A][U][C][C][G][G][U][G] =  2.000;
 int22_ar[A][U][C][C][G][U][U][G] =  2.000;
 int22_ar[A][U][C][C][U][A][U][G] =  2.500;
 int22_ar[A][U][C][C][U][C][U][G] =  2.500;
 int22_ar[A][U][C][C][U][G][U][G] =  2.000;
 int22_ar[A][U][C][C][U][U][U][G] =  2.500;
 int22_ar[A][U][C][G][A][A][U][G] =  1.500;
 int22_ar[A][U][C][G][A][C][U][G] =  2.400;
 int22_ar[A][U][C][G][A][G][U][G] =  2.000;
 int22_ar[A][U][C][G][A][U][U][G] =  2.400;
 int22_ar[A][U][C][G][C][A][U][G] =  2.000;
 int22_ar[A][U][C][G][C][C][U][G] =  2.000;
 int22_ar[A][U][C][G][C][G][U][G] =  2.000;
 int22_ar[A][U][C][G][C][U][U][G] =  2.000;
 int22_ar[A][U][C][G][G][A][U][G] =  1.900;
 int22_ar[A][U][C][G][G][C][U][G] =  2.400;
 int22_ar[A][U][C][G][G][G][U][G] =  2.000;
 int22_ar[A][U][C][G][G][U][U][G] =  2.400;
 int22_ar[A][U][C][G][U][A][U][G] = -0.300;
 int22_ar[A][U][C][G][U][C][U][G] =  0.700;
 int22_ar[A][U][C][G][U][G][U][G] =  2.000;
 int22_ar[A][U][C][G][U][U][U][G] =  0.700;
 int22_ar[A][U][C][U][A][A][U][G] =  2.000;
 int22_ar[A][U][C][U][A][C][U][G] =  2.000;
 int22_ar[A][U][C][U][A][G][U][G] =  2.000;
 int22_ar[A][U][C][U][A][U][U][G] =  2.000;
 int22_ar[A][U][C][U][C][A][U][G] =  2.200;
 int22_ar[A][U][C][U][C][C][U][G] =  2.200;
 int22_ar[A][U][C][U][C][G][U][G] =  2.000;
 int22_ar[A][U][C][U][C][U][U][G] =  2.200;
 int22_ar[A][U][C][U][G][A][U][G] =  1.000;
 int22_ar[A][U][C][U][G][C][U][G] =  1.900;
 int22_ar[A][U][C][U][G][G][U][G] =  2.000;
 int22_ar[A][U][C][U][G][U][U][G] =  1.900;
 int22_ar[A][U][C][U][U][A][U][G] =  1.700;
 int22_ar[A][U][C][U][U][C][U][G] =  1.600;
 int22_ar[A][U][C][U][U][G][U][G] =  2.000;
 int22_ar[A][U][C][U][U][U][U][G] =  1.600;
 int22_ar[A][U][G][A][A][A][U][G] =  1.500;
 int22_ar[A][U][G][A][A][C][U][G] =  2.000;
 int22_ar[A][U][G][A][A][G][U][G] =  2.100;
 int22_ar[A][U][G][A][A][U][U][G] =  2.300;
 int22_ar[A][U][G][A][C][A][U][G] =  1.100;
 int22_ar[A][U][G][A][C][C][U][G] =  2.000;
 int22_ar[A][U][G][A][C][G][U][G] =  1.600;
 int22_ar[A][U][G][A][C][U][U][G] =  0.900;
 int22_ar[A][U][G][A][G][A][U][G] =  0.500;
 int22_ar[A][U][G][A][G][C][U][G] =  2.000;
 int22_ar[A][U][G][A][G][G][U][G] =  1.000;
 int22_ar[A][U][G][A][G][U][U][G] =  2.100;
 int22_ar[A][U][G][A][U][A][U][G] =  2.000;
 int22_ar[A][U][G][A][U][C][U][G] =  2.000;
 int22_ar[A][U][G][A][U][G][U][G] =  2.000;
 int22_ar[A][U][G][A][U][U][U][G] =  2.000;
 int22_ar[A][U][G][C][A][A][U][G] =  1.500;
 int22_ar[A][U][G][C][A][C][U][G] =  2.000;
 int22_ar[A][U][G][C][A][G][U][G] =  2.100;
 int22_ar[A][U][G][C][A][U][U][G] =  1.300;
 int22_ar[A][U][G][C][C][A][U][G] =  2.500;
 int22_ar[A][U][G][C][C][C][U][G] =  2.000;
 int22_ar[A][U][G][C][C][G][U][G] =  2.700;
 int22_ar[A][U][G][C][C][U][U][G] =  2.300;
 int22_ar[A][U][G][C][G][A][U][G] =  2.000;
 int22_ar[A][U][G][C][G][C][U][G] =  2.000;
 int22_ar[A][U][G][C][G][G][U][G] =  2.000;
 int22_ar[A][U][G][C][G][U][U][G] =  2.000;
 int22_ar[A][U][G][C][U][A][U][G] =  2.500;
 int22_ar[A][U][G][C][U][C][U][G] =  2.000;
 int22_ar[A][U][G][C][U][G][U][G] =  2.700;
 int22_ar[A][U][G][C][U][U][U][G] =  2.300;
 int22_ar[A][U][G][G][A][A][U][G] =  0.500;
 int22_ar[A][U][G][G][A][C][U][G] =  2.000;
 int22_ar[A][U][G][G][A][G][U][G] =  1.000;
 int22_ar[A][U][G][G][A][U][U][G] =  2.100;
 int22_ar[A][U][G][G][C][A][U][G] =  2.000;
 int22_ar[A][U][G][G][C][C][U][G] =  2.000;
 int22_ar[A][U][G][G][C][G][U][G] =  2.000;
 int22_ar[A][U][G][G][C][U][U][G] =  2.000;
 int22_ar[A][U][G][G][G][A][U][G] =  0.900;
 int22_ar[A][U][G][G][G][C][U][G] =  2.000;
 int22_ar[A][U][G][G][G][G][U][G] =  1.400;
 int22_ar[A][U][G][G][G][U][U][G] =  1.700;
 int22_ar[A][U][G][G][U][A][U][G] =  0.500;
 int22_ar[A][U][G][G][U][C][U][G] =  2.000;
 int22_ar[A][U][G][G][U][G][U][G] =  0.300;
 int22_ar[A][U][G][G][U][U][U][G] = -1.500;
 int22_ar[A][U][G][U][A][A][U][G] =  2.000;
 int22_ar[A][U][G][U][A][C][U][G] =  2.000;
 int22_ar[A][U][G][U][A][G][U][G] =  2.000;
 int22_ar[A][U][G][U][A][U][U][G] =  2.000;
 int22_ar[A][U][G][U][C][A][U][G] =  2.200;
 int22_ar[A][U][G][U][C][C][U][G] =  2.000;
 int22_ar[A][U][G][U][C][G][U][G] =  2.400;
 int22_ar[A][U][G][U][C][U][U][G] =  2.000;
 int22_ar[A][U][G][U][G][A][U][G] =  1.800;
 int22_ar[A][U][G][U][G][C][U][G] =  2.000;
 int22_ar[A][U][G][U][G][G][U][G] =  1.500;
 int22_ar[A][U][G][U][G][U][U][G] = -0.200;
 int22_ar[A][U][G][U][U][A][U][G] =  2.500;
 int22_ar[A][U][G][U][U][C][U][G] =  2.000;
 int22_ar[A][U][G][U][U][G][U][G] =  2.200;
 int22_ar[A][U][G][U][U][U][U][G] =  2.300;
 int22_ar[A][U][U][A][A][A][U][G] =  2.000;
 int22_ar[A][U][U][A][A][C][U][G] =  3.100;
 int22_ar[A][U][U][A][A][G][U][G] =  1.300;
 int22_ar[A][U][U][A][A][U][U][G] =  2.700;
 int22_ar[A][U][U][A][C][A][U][G] =  2.000;
 int22_ar[A][U][U][A][C][C][U][G] =  2.000;
 int22_ar[A][U][U][A][C][G][U][G] = -0.100;
 int22_ar[A][U][U][A][C][U][U][G] =  1.200;
 int22_ar[A][U][U][A][G][A][U][G] =  2.000;
 int22_ar[A][U][U][A][G][C][U][G] =  2.400;
 int22_ar[A][U][U][A][G][G][U][G] =  1.100;
 int22_ar[A][U][U][A][G][U][U][G] =  2.400;
 int22_ar[A][U][U][A][U][A][U][G] =  2.000;
 int22_ar[A][U][U][A][U][C][U][G] =  2.000;
 int22_ar[A][U][U][A][U][G][U][G] =  2.000;
 int22_ar[A][U][U][A][U][U][U][G] =  2.000;
 int22_ar[A][U][U][C][A][A][U][G] =  2.000;
 int22_ar[A][U][U][C][A][C][U][G] =  2.500;
 int22_ar[A][U][U][C][A][G][U][G] =  0.300;
 int22_ar[A][U][U][C][A][U][U][G] =  1.700;
 int22_ar[A][U][U][C][C][A][U][G] =  2.000;
 int22_ar[A][U][U][C][C][C][U][G] =  2.500;
 int22_ar[A][U][U][C][C][G][U][G] =  1.300;
 int22_ar[A][U][U][C][C][U][U][G] =  1.700;
 int22_ar[A][U][U][C][G][A][U][G] =  2.000;
 int22_ar[A][U][U][C][G][C][U][G] =  2.000;
 int22_ar[A][U][U][C][G][G][U][G] =  2.000;
 int22_ar[A][U][U][C][G][U][U][G] =  2.000;
 int22_ar[A][U][U][C][U][A][U][G] =  2.000;
 int22_ar[A][U][U][C][U][C][U][G] =  2.500;
 int22_ar[A][U][U][C][U][G][U][G] =  1.300;
 int22_ar[A][U][U][C][U][U][U][G] =  1.700;
 int22_ar[A][U][U][G][A][A][U][G] =  2.000;
 int22_ar[A][U][U][G][A][C][U][G] =  2.400;
 int22_ar[A][U][U][G][A][G][U][G] =  1.100;
 int22_ar[A][U][U][G][A][U][U][G] =  2.400;
 int22_ar[A][U][U][G][C][A][U][G] =  2.000;
 int22_ar[A][U][U][G][C][C][U][G] =  2.000;
 int22_ar[A][U][U][G][C][G][U][G] =  2.000;
 int22_ar[A][U][U][G][C][U][U][G] =  2.000;
 int22_ar[A][U][U][G][G][A][U][G] =  2.000;
 int22_ar[A][U][U][G][G][C][U][G] =  2.400;
 int22_ar[A][U][U][G][G][G][U][G] =  0.700;
 int22_ar[A][U][U][G][G][U][U][G] =  2.000;
 int22_ar[A][U][U][G][U][A][U][G] =  2.000;
 int22_ar[A][U][U][G][U][C][U][G] =  0.700;
 int22_ar[A][U][U][G][U][G][U][G] = -2.500;
 int22_ar[A][U][U][G][U][U][U][G] =  0.700;
 int22_ar[A][U][U][U][A][A][U][G] =  2.000;
 int22_ar[A][U][U][U][A][C][U][G] =  2.000;
 int22_ar[A][U][U][U][A][G][U][G] =  2.000;
 int22_ar[A][U][U][U][A][U][U][G] =  2.000;
 int22_ar[A][U][U][U][C][A][U][G] =  2.000;
 int22_ar[A][U][U][U][C][C][U][G] =  2.200;
 int22_ar[A][U][U][U][C][G][U][G] =  1.000;
 int22_ar[A][U][U][U][C][U][U][G] =  1.400;
 int22_ar[A][U][U][U][G][A][U][G] =  2.000;
 int22_ar[A][U][U][U][G][C][U][G] =  1.900;
 int22_ar[A][U][U][U][G][G][U][G] = -1.200;
 int22_ar[A][U][U][U][G][U][U][G] =  1.900;
 int22_ar[A][U][U][U][U][A][U][G] =  2.000;
 int22_ar[A][U][U][U][U][C][U][G] =  1.600;
 int22_ar[A][U][U][U][U][G][U][G] =  1.300;
 int22_ar[A][U][U][U][U][U][U][G] =  0.800;
 int22_ar[C][G][A][A][A][A][A][U] =  2.000;
 int22_ar[C][G][A][A][A][C][A][U] =  2.400;
 int22_ar[C][G][A][A][A][G][A][U] =  1.000;
 int22_ar[C][G][A][A][A][U][A][U] =  2.000;
 int22_ar[C][G][A][A][C][A][A][U] =  1.800;
 int22_ar[C][G][A][A][C][C][A][U] =  2.100;
 int22_ar[C][G][A][A][C][G][A][U] =  0.800;
 int22_ar[C][G][A][A][C][U][A][U] =  2.000;
 int22_ar[C][G][A][A][G][A][A][U] =  0.800;
 int22_ar[C][G][A][A][G][C][A][U] =  1.100;
 int22_ar[C][G][A][A][G][G][A][U] = -0.200;
 int22_ar[C][G][A][A][G][U][A][U] =  2.000;
 int22_ar[C][G][A][A][U][A][A][U] =  2.000;
 int22_ar[C][G][A][A][U][C][A][U] =  2.000;
 int22_ar[C][G][A][A][U][G][A][U] =  2.000;
 int22_ar[C][G][A][A][U][U][A][U] =  2.000;
 int22_ar[C][G][A][C][A][A][A][U] =  1.900;
 int22_ar[C][G][A][C][A][C][A][U] =  2.200;
 int22_ar[C][G][A][C][A][G][A][U] =  0.900;
 int22_ar[C][G][A][C][A][U][A][U] =  2.000;
 int22_ar[C][G][A][C][C][A][A][U] =  2.300;
 int22_ar[C][G][A][C][C][C][A][U] =  2.100;
 int22_ar[C][G][A][C][C][G][A][U] =  1.700;
 int22_ar[C][G][A][C][C][U][A][U] =  2.000;
 int22_ar[C][G][A][C][G][A][A][U] =  2.000;
 int22_ar[C][G][A][C][G][C][A][U] =  2.000;
 int22_ar[C][G][A][C][G][G][A][U] =  2.000;
 int22_ar[C][G][A][C][G][U][A][U] =  2.000;
 int22_ar[C][G][A][C][U][A][A][U] =  2.300;
 int22_ar[C][G][A][C][U][C][A][U] =  2.100;
 int22_ar[C][G][A][C][U][G][A][U] =  1.700;
 int22_ar[C][G][A][C][U][U][A][U] =  2.000;
 int22_ar[C][G][A][G][A][A][A][U] =  0.800;
 int22_ar[C][G][A][G][A][C][A][U] =  1.100;
 int22_ar[C][G][A][G][A][G][A][U] = -0.200;
 int22_ar[C][G][A][G][A][U][A][U] =  2.000;
 int22_ar[C][G][A][G][C][A][A][U] =  2.000;
 int22_ar[C][G][A][G][C][C][A][U] =  2.000;
 int22_ar[C][G][A][G][C][G][A][U] =  2.000;
 int22_ar[C][G][A][G][C][U][A][U] =  2.000;
 int22_ar[C][G][A][G][G][A][A][U] =  1.300;
 int22_ar[C][G][A][G][G][C][A][U] =  1.700;
 int22_ar[C][G][A][G][G][G][A][U] =  0.300;
 int22_ar[C][G][A][G][G][U][A][U] =  2.000;
 int22_ar[C][G][A][G][U][A][A][U] =  0.600;
 int22_ar[C][G][A][G][U][C][A][U] =  0.000;
 int22_ar[C][G][A][G][U][G][A][U] =  0.400;
 int22_ar[C][G][A][G][U][U][A][U] =  2.000;
 int22_ar[C][G][A][U][A][A][A][U] =  2.000;
 int22_ar[C][G][A][U][A][C][A][U] =  2.000;
 int22_ar[C][G][A][U][A][G][A][U] =  2.000;
 int22_ar[C][G][A][U][A][U][A][U] =  2.000;
 int22_ar[C][G][A][U][C][A][A][U] =  2.300;
 int22_ar[C][G][A][U][C][C][A][U] =  2.100;
 int22_ar[C][G][A][U][C][G][A][U] =  1.700;
 int22_ar[C][G][A][U][C][U][A][U] =  2.000;
 int22_ar[C][G][A][U][G][A][A][U] =  1.600;
 int22_ar[C][G][A][U][G][C][A][U] =  0.900;
 int22_ar[C][G][A][U][G][G][A][U] =  1.400;
 int22_ar[C][G][A][U][G][U][A][U] =  2.000;
 int22_ar[C][G][A][U][U][A][A][U] =  1.900;
 int22_ar[C][G][A][U][U][C][A][U] =  1.300;
 int22_ar[C][G][A][U][U][G][A][U] =  1.800;
 int22_ar[C][G][A][U][U][U][A][U] =  2.000;
 int22_ar[C][G][C][A][A][A][A][U] =  1.900;
 int22_ar[C][G][C][A][A][C][A][U] =  2.800;
 int22_ar[C][G][C][A][A][G][A][U] =  2.000;
 int22_ar[C][G][C][A][A][U][A][U] =  2.700;
 int22_ar[C][G][C][A][C][A][A][U] =  1.700;
 int22_ar[C][G][C][A][C][C][A][U] =  2.000;
 int22_ar[C][G][C][A][C][G][A][U] =  2.000;
 int22_ar[C][G][C][A][C][U][A][U] =  1.800;
 int22_ar[C][G][C][A][G][A][A][U] =  0.700;
 int22_ar[C][G][C][A][G][C][A][U] =  2.000;
 int22_ar[C][G][C][A][G][G][A][U] =  2.000;
 int22_ar[C][G][C][A][G][U][A][U] =  1.800;
 int22_ar[C][G][C][A][U][A][A][U] =  2.000;
 int22_ar[C][G][C][A][U][C][A][U] =  2.000;
 int22_ar[C][G][C][A][U][G][A][U] =  2.000;
 int22_ar[C][G][C][A][U][U][A][U] =  2.000;
 int22_ar[C][G][C][C][A][A][A][U] =  1.800;
 int22_ar[C][G][C][C][A][C][A][U] =  2.100;
 int22_ar[C][G][C][C][A][G][A][U] =  2.000;
 int22_ar[C][G][C][C][A][U][A][U] =  1.900;
 int22_ar[C][G][C][C][C][A][A][U] =  1.600;
 int22_ar[C][G][C][C][C][C][A][U] =  1.900;
 int22_ar[C][G][C][C][C][G][A][U] =  2.000;
 int22_ar[C][G][C][C][C][U][A][U] =  1.800;
 int22_ar[C][G][C][C][G][A][A][U] =  2.000;
 int22_ar[C][G][C][C][G][C][A][U] =  2.000;
 int22_ar[C][G][C][C][G][G][A][U] =  2.000;
 int22_ar[C][G][C][C][G][U][A][U] =  2.000;
 int22_ar[C][G][C][C][U][A][A][U] =  1.600;
 int22_ar[C][G][C][C][U][C][A][U] =  1.900;
 int22_ar[C][G][C][C][U][G][A][U] =  2.000;
 int22_ar[C][G][C][C][U][U][A][U] =  1.800;
 int22_ar[C][G][C][G][A][A][A][U] =  0.700;
 int22_ar[C][G][C][G][A][C][A][U] =  2.000;
 int22_ar[C][G][C][G][A][G][A][U] =  2.000;
 int22_ar[C][G][C][G][A][U][A][U] =  1.800;
 int22_ar[C][G][C][G][C][A][A][U] =  2.000;
 int22_ar[C][G][C][G][C][C][A][U] =  2.000;
 int22_ar[C][G][C][G][C][G][A][U] =  2.000;
 int22_ar[C][G][C][G][C][U][A][U] =  2.000;
 int22_ar[C][G][C][G][G][A][A][U] =  1.200;
 int22_ar[C][G][C][G][G][C][A][U] =  2.100;
 int22_ar[C][G][C][G][G][G][A][U] =  2.000;
 int22_ar[C][G][C][G][G][U][A][U] =  2.000;
 int22_ar[C][G][C][G][U][A][A][U] = -0.500;
 int22_ar[C][G][C][G][U][C][A][U] =  0.800;
 int22_ar[C][G][C][G][U][G][A][U] =  2.000;
 int22_ar[C][G][C][G][U][U][A][U] =  0.700;
 int22_ar[C][G][C][U][A][A][A][U] =  2.000;
 int22_ar[C][G][C][U][A][C][A][U] =  2.000;
 int22_ar[C][G][C][U][A][G][A][U] =  2.000;
 int22_ar[C][G][C][U][A][U][A][U] =  2.000;
 int22_ar[C][G][C][U][C][A][A][U] =  1.600;
 int22_ar[C][G][C][U][C][C][A][U] =  1.900;
 int22_ar[C][G][C][U][C][G][A][U] =  2.000;
 int22_ar[C][G][C][U][C][U][A][U] =  1.800;
 int22_ar[C][G][C][U][G][A][A][U] =  0.500;
 int22_ar[C][G][C][U][G][C][A][U] =  1.800;
 int22_ar[C][G][C][U][G][G][A][U] =  2.000;
 int22_ar[C][G][C][U][G][U][A][U] =  1.600;
 int22_ar[C][G][C][U][U][A][A][U] =  0.800;
 int22_ar[C][G][C][U][U][C][A][U] =  1.100;
 int22_ar[C][G][C][U][U][G][A][U] =  2.000;
 int22_ar[C][G][C][U][U][U][A][U] =  1.000;
 int22_ar[C][G][G][A][A][A][A][U] =  1.000;
 int22_ar[C][G][G][A][A][C][A][U] =  2.000;
 int22_ar[C][G][G][A][A][G][A][U] =  1.800;
 int22_ar[C][G][G][A][A][U][A][U] =  1.800;
 int22_ar[C][G][G][A][C][A][A][U] =  0.800;
 int22_ar[C][G][G][A][C][C][A][U] =  2.000;
 int22_ar[C][G][G][A][C][G][A][U] =  1.500;
 int22_ar[C][G][G][A][C][U][A][U] =  0.600;
 int22_ar[C][G][G][A][G][A][A][U] = -0.200;
 int22_ar[C][G][G][A][G][C][A][U] =  2.000;
 int22_ar[C][G][G][A][G][G][A][U] =  0.500;
 int22_ar[C][G][G][A][G][U][A][U] =  1.400;
 int22_ar[C][G][G][A][U][A][A][U] =  2.000;
 int22_ar[C][G][G][A][U][C][A][U] =  2.000;
 int22_ar[C][G][G][A][U][G][A][U] =  2.000;
 int22_ar[C][G][G][A][U][U][A][U] =  2.000;
 int22_ar[C][G][G][C][A][A][A][U] =  0.900;
 int22_ar[C][G][G][C][A][C][A][U] =  2.000;
 int22_ar[C][G][G][C][A][G][A][U] =  1.600;
 int22_ar[C][G][G][C][A][U][A][U] =  0.700;
 int22_ar[C][G][G][C][C][A][A][U] =  1.700;
 int22_ar[C][G][G][C][C][C][A][U] =  2.000;
 int22_ar[C][G][G][C][C][G][A][U] =  2.100;
 int22_ar[C][G][G][C][C][U][A][U] =  1.500;
 int22_ar[C][G][G][C][G][A][A][U] =  2.000;
 int22_ar[C][G][G][C][G][C][A][U] =  2.000;
 int22_ar[C][G][G][C][G][G][A][U] =  2.000;
 int22_ar[C][G][G][C][G][U][A][U] =  2.000;
 int22_ar[C][G][G][C][U][A][A][U] =  1.700;
 int22_ar[C][G][G][C][U][C][A][U] =  2.000;
 int22_ar[C][G][G][C][U][G][A][U] =  2.100;
 int22_ar[C][G][G][C][U][U][A][U] =  1.500;
 int22_ar[C][G][G][G][A][A][A][U] = -0.200;
 int22_ar[C][G][G][G][A][C][A][U] =  2.000;
 int22_ar[C][G][G][G][A][G][A][U] =  0.500;
 int22_ar[C][G][G][G][A][U][A][U] =  1.400;
 int22_ar[C][G][G][G][C][A][A][U] =  2.000;
 int22_ar[C][G][G][G][C][C][A][U] =  2.000;
 int22_ar[C][G][G][G][C][G][A][U] =  2.000;
 int22_ar[C][G][G][G][C][U][A][U] =  2.000;
 int22_ar[C][G][G][G][G][A][A][U] =  0.300;
 int22_ar[C][G][G][G][G][C][A][U] =  2.000;
 int22_ar[C][G][G][G][G][G][A][U] =  1.100;
 int22_ar[C][G][G][G][G][U][A][U] =  1.100;
 int22_ar[C][G][G][G][U][A][A][U] =  0.400;
 int22_ar[C][G][G][G][U][C][A][U] =  2.000;
 int22_ar[C][G][G][G][U][G][A][U] =  0.400;
 int22_ar[C][G][G][G][U][U][A][U] = -1.600;
 int22_ar[C][G][G][U][A][A][A][U] =  2.000;
 int22_ar[C][G][G][U][A][C][A][U] =  2.000;
 int22_ar[C][G][G][U][A][G][A][U] =  2.000;
 int22_ar[C][G][G][U][A][U][A][U] =  2.000;
 int22_ar[C][G][G][U][C][A][A][U] =  1.700;
 int22_ar[C][G][G][U][C][C][A][U] =  2.000;
 int22_ar[C][G][G][U][C][G][A][U] =  2.100;
 int22_ar[C][G][G][U][C][U][A][U] =  1.500;
 int22_ar[C][G][G][U][G][A][A][U] =  1.400;
 int22_ar[C][G][G][U][G][C][A][U] =  2.000;
 int22_ar[C][G][G][U][G][G][A][U] =  1.300;
 int22_ar[C][G][G][U][G][U][A][U] = -0.600;
 int22_ar[C][G][G][U][U][A][A][U] =  1.800;
 int22_ar[C][G][G][U][U][C][A][U] =  2.000;
 int22_ar[C][G][G][U][U][G][A][U] =  1.700;
 int22_ar[C][G][G][U][U][U][A][U] =  1.600;
 int22_ar[C][G][U][A][A][A][A][U] =  2.000;
 int22_ar[C][G][U][A][A][C][A][U] =  2.700;
 int22_ar[C][G][U][A][A][G][A][U] =  0.300;
 int22_ar[C][G][U][A][A][U][A][U] =  2.200;
 int22_ar[C][G][U][A][C][A][A][U] =  2.000;
 int22_ar[C][G][U][A][C][C][A][U] =  1.800;
 int22_ar[C][G][U][A][C][G][A][U] = -0.900;
 int22_ar[C][G][U][A][C][U][A][U] =  0.900;
 int22_ar[C][G][U][A][G][A][A][U] =  2.000;
 int22_ar[C][G][U][A][G][C][A][U] =  1.800;
 int22_ar[C][G][U][A][G][G][A][U] = -0.100;
 int22_ar[C][G][U][A][G][U][A][U] =  1.800;
 int22_ar[C][G][U][A][U][A][A][U] =  2.000;
 int22_ar[C][G][U][A][U][C][A][U] =  2.000;
 int22_ar[C][G][U][A][U][G][A][U] =  2.000;
 int22_ar[C][G][U][A][U][U][A][U] =  2.000;
 int22_ar[C][G][U][C][A][A][A][U] =  2.000;
 int22_ar[C][G][U][C][A][C][A][U] =  1.900;
 int22_ar[C][G][U][C][A][G][A][U] = -0.800;
 int22_ar[C][G][U][C][A][U][A][U] =  1.000;
 int22_ar[C][G][U][C][C][A][A][U] =  2.000;
 int22_ar[C][G][U][C][C][C][A][U] =  1.800;
 int22_ar[C][G][U][C][C][G][A][U] =  0.000;
 int22_ar[C][G][U][C][C][U][A][U] =  0.900;
 int22_ar[C][G][U][C][G][A][A][U] =  2.000;
 int22_ar[C][G][U][C][G][C][A][U] =  2.000;
 int22_ar[C][G][U][C][G][G][A][U] =  2.000;
 int22_ar[C][G][U][C][G][U][A][U] =  2.000;
 int22_ar[C][G][U][C][U][A][A][U] =  2.000;
 int22_ar[C][G][U][C][U][C][A][U] =  1.800;
 int22_ar[C][G][U][C][U][G][A][U] =  0.000;
 int22_ar[C][G][U][C][U][U][A][U] =  0.900;
 int22_ar[C][G][U][G][A][A][A][U] =  2.000;
 int22_ar[C][G][U][G][A][C][A][U] =  1.800;
 int22_ar[C][G][U][G][A][G][A][U] = -0.100;
 int22_ar[C][G][U][G][A][U][A][U] =  1.800;
 int22_ar[C][G][U][G][C][A][A][U] =  2.000;
 int22_ar[C][G][U][G][C][C][A][U] =  2.000;
 int22_ar[C][G][U][G][C][G][A][U] =  2.000;
 int22_ar[C][G][U][G][C][U][A][U] =  2.000;
 int22_ar[C][G][U][G][G][A][A][U] =  2.000;
 int22_ar[C][G][U][G][G][C][A][U] =  2.000;
 int22_ar[C][G][U][G][G][G][A][U] = -0.400;
 int22_ar[C][G][U][G][G][U][A][U] =  1.500;
 int22_ar[C][G][U][G][U][A][A][U] =  2.000;
 int22_ar[C][G][U][G][U][C][A][U] =  0.700;
 int22_ar[C][G][U][G][U][G][A][U] = -3.100;
 int22_ar[C][G][U][G][U][U][A][U] =  0.600;
 int22_ar[C][G][U][U][A][A][A][U] =  2.000;
 int22_ar[C][G][U][U][A][C][A][U] =  2.000;
 int22_ar[C][G][U][U][A][G][A][U] =  2.000;
 int22_ar[C][G][U][U][A][U][A][U] =  2.000;
 int22_ar[C][G][U][U][C][A][A][U] =  2.000;
 int22_ar[C][G][U][U][C][C][A][U] =  1.800;
 int22_ar[C][G][U][U][C][G][A][U] =  0.000;
 int22_ar[C][G][U][U][C][U][A][U] =  0.900;
 int22_ar[C][G][U][U][G][A][A][U] =  2.000;
 int22_ar[C][G][U][U][G][C][A][U] =  1.600;
 int22_ar[C][G][U][U][G][G][A][U] = -2.100;
 int22_ar[C][G][U][U][G][U][A][U] =  1.600;
 int22_ar[C][G][U][U][U][A][A][U] =  2.000;
 int22_ar[C][G][U][U][U][C][A][U] =  1.000;
 int22_ar[C][G][U][U][U][G][A][U] =  0.000;
 int22_ar[C][G][U][U][U][U][A][U] =  0.100;
 int22_ar[C][G][A][A][A][A][C][G] =  1.300;
 int22_ar[C][G][A][A][A][C][C][G] =  1.600;
 int22_ar[C][G][A][A][A][G][C][G] =  0.300;
 int22_ar[C][G][A][A][A][U][C][G] =  2.000;
 int22_ar[C][G][A][A][C][A][C][G] =  1.200;
 int22_ar[C][G][A][A][C][C][C][G] =  1.500;
 int22_ar[C][G][A][A][C][G][C][G] =  0.200;
 int22_ar[C][G][A][A][C][U][C][G] =  2.000;
 int22_ar[C][G][A][A][G][A][C][G] =  0.300;
 int22_ar[C][G][A][A][G][C][C][G] =  0.600;
 int22_ar[C][G][A][A][G][G][C][G] = -0.700;
 int22_ar[C][G][A][A][G][U][C][G] =  2.000;
 int22_ar[C][G][A][A][U][A][C][G] =  2.000;
 int22_ar[C][G][A][A][U][C][C][G] =  2.000;
 int22_ar[C][G][A][A][U][G][C][G] =  2.000;
 int22_ar[C][G][A][A][U][U][C][G] =  2.000;
 int22_ar[C][G][A][C][A][A][C][G] =  1.600;
 int22_ar[C][G][A][C][A][C][C][G] =  2.000;
 int22_ar[C][G][A][C][A][G][C][G] =  0.600;
 int22_ar[C][G][A][C][A][U][C][G] =  2.000;
 int22_ar[C][G][A][C][C][A][C][G] =  2.100;
 int22_ar[C][G][A][C][C][C][C][G] =  1.800;
 int22_ar[C][G][A][C][C][G][C][G] =  1.500;
 int22_ar[C][G][A][C][C][U][C][G] =  2.000;
 int22_ar[C][G][A][C][G][A][C][G] =  2.000;
 int22_ar[C][G][A][C][G][C][C][G] =  2.000;
 int22_ar[C][G][A][C][G][G][C][G] =  2.000;
 int22_ar[C][G][A][C][G][U][C][G] =  2.000;
 int22_ar[C][G][A][C][U][A][C][G] =  1.900;
 int22_ar[C][G][A][C][U][C][C][G] =  1.700;
 int22_ar[C][G][A][C][U][G][C][G] =  1.300;
 int22_ar[C][G][A][C][U][U][C][G] =  2.000;
 int22_ar[C][G][A][G][A][A][C][G] =  0.300;
 int22_ar[C][G][A][G][A][C][C][G] =  0.600;
 int22_ar[C][G][A][G][A][G][C][G] = -0.700;
 int22_ar[C][G][A][G][A][U][C][G] =  2.000;
 int22_ar[C][G][A][G][C][A][C][G] =  2.000;
 int22_ar[C][G][A][G][C][C][C][G] =  2.000;
 int22_ar[C][G][A][G][C][G][C][G] =  2.000;
 int22_ar[C][G][A][G][C][U][C][G] =  2.000;
 int22_ar[C][G][A][G][G][A][C][G] =  1.000;
 int22_ar[C][G][A][G][G][C][C][G] =  1.400;
 int22_ar[C][G][A][G][G][G][C][G] =  0.000;
 int22_ar[C][G][A][G][G][U][C][G] =  2.000;
 int22_ar[C][G][A][G][U][A][C][G] = -0.400;
 int22_ar[C][G][A][G][U][C][C][G] = -1.100;
 int22_ar[C][G][A][G][U][G][C][G] = -0.600;
 int22_ar[C][G][A][G][U][U][C][G] =  2.000;
 int22_ar[C][G][A][U][A][A][C][G] =  2.000;
 int22_ar[C][G][A][U][A][C][C][G] =  2.000;
 int22_ar[C][G][A][U][A][G][C][G] =  2.000;
 int22_ar[C][G][A][U][A][U][C][G] =  2.000;
 int22_ar[C][G][A][U][C][A][C][G] =  1.900;
 int22_ar[C][G][A][U][C][C][C][G] =  1.700;
 int22_ar[C][G][A][U][C][G][C][G] =  1.300;
 int22_ar[C][G][A][U][C][U][C][G] =  2.000;
 int22_ar[C][G][A][U][G][A][C][G] =  1.100;
 int22_ar[C][G][A][U][G][C][C][G] =  0.400;
 int22_ar[C][G][A][U][G][G][C][G] =  0.900;
 int22_ar[C][G][A][U][G][U][C][G] =  2.000;
 int22_ar[C][G][A][U][U][A][C][G] =  1.400;
 int22_ar[C][G][A][U][U][C][C][G] =  0.800;
 int22_ar[C][G][A][U][U][G][C][G] =  1.300;
 int22_ar[C][G][A][U][U][U][C][G] =  2.000;
 int22_ar[C][G][C][A][A][A][C][G] =  1.200;
 int22_ar[C][G][C][A][A][C][C][G] =  2.100;
 int22_ar[C][G][C][A][A][G][C][G] =  2.000;
 int22_ar[C][G][C][A][A][U][C][G] =  1.900;
 int22_ar[C][G][C][A][C][A][C][G] =  1.100;
 int22_ar[C][G][C][A][C][C][C][G] =  1.400;
 int22_ar[C][G][C][A][C][G][C][G] =  2.000;
 int22_ar[C][G][C][A][C][U][C][G] =  1.200;
 int22_ar[C][G][C][A][G][A][C][G] =  0.200;
 int22_ar[C][G][C][A][G][C][C][G] =  1.500;
 int22_ar[C][G][C][A][G][G][C][G] =  2.000;
 int22_ar[C][G][C][A][G][U][C][G] =  1.300;
 int22_ar[C][G][C][A][U][A][C][G] =  2.000;
 int22_ar[C][G][C][A][U][C][C][G] =  2.000;
 int22_ar[C][G][C][A][U][G][C][G] =  2.000;
 int22_ar[C][G][C][A][U][U][C][G] =  2.000;
 int22_ar[C][G][C][C][A][A][C][G] =  1.500;
 int22_ar[C][G][C][C][A][C][C][G] =  1.800;
 int22_ar[C][G][C][C][A][G][C][G] =  2.000;
 int22_ar[C][G][C][C][A][U][C][G] =  1.700;
 int22_ar[C][G][C][C][C][A][C][G] =  1.400;
 int22_ar[C][G][C][C][C][C][C][G] =  1.700;
 int22_ar[C][G][C][C][C][G][C][G] =  2.000;
 int22_ar[C][G][C][C][C][U][C][G] =  1.500;
 int22_ar[C][G][C][C][G][A][C][G] =  2.000;
 int22_ar[C][G][C][C][G][C][C][G] =  2.000;
 int22_ar[C][G][C][C][G][G][C][G] =  2.000;
 int22_ar[C][G][C][C][G][U][C][G] =  2.000;
 int22_ar[C][G][C][C][U][A][C][G] =  1.200;
 int22_ar[C][G][C][C][U][C][C][G] =  1.500;
 int22_ar[C][G][C][C][U][G][C][G] =  2.000;
 int22_ar[C][G][C][C][U][U][C][G] =  1.400;
 int22_ar[C][G][C][G][A][A][C][G] =  0.200;
 int22_ar[C][G][C][G][A][C][C][G] =  1.500;
 int22_ar[C][G][C][G][A][G][C][G] =  2.000;
 int22_ar[C][G][C][G][A][U][C][G] =  1.300;
 int22_ar[C][G][C][G][C][A][C][G] =  2.000;
 int22_ar[C][G][C][G][C][C][C][G] =  2.000;
 int22_ar[C][G][C][G][C][G][C][G] =  2.000;
 int22_ar[C][G][C][G][C][U][C][G] =  2.000;
 int22_ar[C][G][C][G][G][A][C][G] =  0.900;
 int22_ar[C][G][C][G][G][C][C][G] =  1.800;
 int22_ar[C][G][C][G][G][G][C][G] =  2.000;
 int22_ar[C][G][C][G][G][U][C][G] =  1.700;
 int22_ar[C][G][C][G][U][A][C][G] = -1.500;
 int22_ar[C][G][C][G][U][C][C][G] = -0.200;
 int22_ar[C][G][C][G][U][G][C][G] =  2.000;
 int22_ar[C][G][C][G][U][U][C][G] = -0.400;
 int22_ar[C][G][C][U][A][A][C][G] =  2.000;
 int22_ar[C][G][C][U][A][C][C][G] =  2.000;
 int22_ar[C][G][C][U][A][G][C][G] =  2.000;
 int22_ar[C][G][C][U][A][U][C][G] =  2.000;
 int22_ar[C][G][C][U][C][A][C][G] =  1.200;
 int22_ar[C][G][C][U][C][C][C][G] =  1.500;
 int22_ar[C][G][C][U][C][G][C][G] =  2.000;
 int22_ar[C][G][C][U][C][U][C][G] =  1.400;
 int22_ar[C][G][C][U][G][A][C][G] =  0.000;
 int22_ar[C][G][C][U][G][C][C][G] =  1.300;
 int22_ar[C][G][C][U][G][G][C][G] =  2.000;
 int22_ar[C][G][C][U][G][U][C][G] =  1.100;
 int22_ar[C][G][C][U][U][A][C][G] =  0.300;
 int22_ar[C][G][C][U][U][C][C][G] =  0.600;
 int22_ar[C][G][C][U][U][G][C][G] =  2.000;
 int22_ar[C][G][C][U][U][U][C][G] =  0.500;
 int22_ar[C][G][G][A][A][A][C][G] =  0.300;
 int22_ar[C][G][G][A][A][C][C][G] =  2.000;
 int22_ar[C][G][G][A][A][G][C][G] =  1.000;
 int22_ar[C][G][G][A][A][U][C][G] =  1.100;
 int22_ar[C][G][G][A][C][A][C][G] =  0.200;
 int22_ar[C][G][G][A][C][C][C][G] =  2.000;
 int22_ar[C][G][G][A][C][G][C][G] =  0.900;
 int22_ar[C][G][G][A][C][U][C][G] =  0.000;
 int22_ar[C][G][G][A][G][A][C][G] = -0.700;
 int22_ar[C][G][G][A][G][C][C][G] =  2.000;
 int22_ar[C][G][G][A][G][G][C][G] =  0.000;
 int22_ar[C][G][G][A][G][U][C][G] =  0.900;
 int22_ar[C][G][G][A][U][A][C][G] =  2.000;
 int22_ar[C][G][G][A][U][C][C][G] =  2.000;
 int22_ar[C][G][G][A][U][G][C][G] =  2.000;
 int22_ar[C][G][G][A][U][U][C][G] =  2.000;
 int22_ar[C][G][G][C][A][A][C][G] =  0.600;
 int22_ar[C][G][G][C][A][C][C][G] =  2.000;
 int22_ar[C][G][G][C][A][G][C][G] =  1.400;
 int22_ar[C][G][G][C][A][U][C][G] =  0.400;
 int22_ar[C][G][G][C][C][A][C][G] =  1.500;
 int22_ar[C][G][G][C][C][C][C][G] =  2.000;
 int22_ar[C][G][G][C][C][G][C][G] =  1.800;
 int22_ar[C][G][G][C][C][U][C][G] =  1.300;
 int22_ar[C][G][G][C][G][A][C][G] =  2.000;
 int22_ar[C][G][G][C][G][C][C][G] =  2.000;
 int22_ar[C][G][G][C][G][G][C][G] =  2.000;
 int22_ar[C][G][G][C][G][U][C][G] =  2.000;
 int22_ar[C][G][G][C][U][A][C][G] =  1.300;
 int22_ar[C][G][G][C][U][C][C][G] =  2.000;
 int22_ar[C][G][G][C][U][G][C][G] =  1.700;
 int22_ar[C][G][G][C][U][U][C][G] =  1.100;
 int22_ar[C][G][G][G][A][A][C][G] = -0.700;
 int22_ar[C][G][G][G][A][C][C][G] =  2.000;
 int22_ar[C][G][G][G][A][G][C][G] =  0.000;
 int22_ar[C][G][G][G][A][U][C][G] =  0.900;
 int22_ar[C][G][G][G][C][A][C][G] =  2.000;
 int22_ar[C][G][G][G][C][C][C][G] =  2.000;
 int22_ar[C][G][G][G][C][G][C][G] =  2.000;
 int22_ar[C][G][G][G][C][U][C][G] =  2.000;
 int22_ar[C][G][G][G][G][A][C][G] =  0.000;
 int22_ar[C][G][G][G][G][C][C][G] =  2.000;
 int22_ar[C][G][G][G][G][G][C][G] =  0.800;
 int22_ar[C][G][G][G][G][U][C][G] =  0.900;
 int22_ar[C][G][G][G][U][A][C][G] = -0.600;
 int22_ar[C][G][G][G][U][C][C][G] =  2.000;
 int22_ar[C][G][G][G][U][G][C][G] = -0.700;
 int22_ar[C][G][G][G][U][U][C][G] = -2.600;
 int22_ar[C][G][G][U][A][A][C][G] =  2.000;
 int22_ar[C][G][G][U][A][C][C][G] =  2.000;
 int22_ar[C][G][G][U][A][G][C][G] =  2.000;
 int22_ar[C][G][G][U][A][U][C][G] =  2.000;
 int22_ar[C][G][G][U][C][A][C][G] =  1.300;
 int22_ar[C][G][G][U][C][C][C][G] =  2.000;
 int22_ar[C][G][G][U][C][G][C][G] =  1.700;
 int22_ar[C][G][G][U][C][U][C][G] =  1.100;
 int22_ar[C][G][G][U][G][A][C][G] =  0.900;
 int22_ar[C][G][G][U][G][C][C][G] =  2.000;
 int22_ar[C][G][G][U][G][G][C][G] =  0.900;
 int22_ar[C][G][G][U][G][U][C][G] = -1.100;
 int22_ar[C][G][G][U][U][A][C][G] =  1.300;
 int22_ar[C][G][G][U][U][C][C][G] =  2.000;
 int22_ar[C][G][G][U][U][G][C][G] =  1.200;
 int22_ar[C][G][G][U][U][U][C][G] =  1.100;
 int22_ar[C][G][U][A][A][A][C][G] =  2.000;
 int22_ar[C][G][U][A][A][C][C][G] =  1.900;
 int22_ar[C][G][U][A][A][G][C][G] = -0.400;
 int22_ar[C][G][U][A][A][U][C][G] =  1.400;
 int22_ar[C][G][U][A][C][A][C][G] =  2.000;
 int22_ar[C][G][U][A][C][C][C][G] =  1.200;
 int22_ar[C][G][U][A][C][G][C][G] = -1.500;
 int22_ar[C][G][U][A][C][U][C][G] =  0.300;
 int22_ar[C][G][U][A][G][A][C][G] =  2.000;
 int22_ar[C][G][U][A][G][C][C][G] =  1.300;
 int22_ar[C][G][U][A][G][G][C][G] = -0.600;
 int22_ar[C][G][U][A][G][U][C][G] =  1.300;
 int22_ar[C][G][U][A][U][A][C][G] =  2.000;
 int22_ar[C][G][U][A][U][C][C][G] =  2.000;
 int22_ar[C][G][U][A][U][G][C][G] =  2.000;
 int22_ar[C][G][U][A][U][U][C][G] =  2.000;
 int22_ar[C][G][U][C][A][A][C][G] =  2.000;
 int22_ar[C][G][U][C][A][C][C][G] =  1.700;
 int22_ar[C][G][U][C][A][G][C][G] = -1.100;
 int22_ar[C][G][U][C][A][U][C][G] =  0.800;
 int22_ar[C][G][U][C][C][A][C][G] =  2.000;
 int22_ar[C][G][U][C][C][C][C][G] =  1.500;
 int22_ar[C][G][U][C][C][G][C][G] = -0.200;
 int22_ar[C][G][U][C][C][U][C][G] =  0.600;
 int22_ar[C][G][U][C][G][A][C][G] =  2.000;
 int22_ar[C][G][U][C][G][C][C][G] =  2.000;
 int22_ar[C][G][U][C][G][G][C][G] =  2.000;
 int22_ar[C][G][U][C][G][U][C][G] =  2.000;
 int22_ar[C][G][U][C][U][A][C][G] =  2.000;
 int22_ar[C][G][U][C][U][C][C][G] =  1.400;
 int22_ar[C][G][U][C][U][G][C][G] = -0.400;
 int22_ar[C][G][U][C][U][U][C][G] =  0.500;
 int22_ar[C][G][U][G][A][A][C][G] =  2.000;
 int22_ar[C][G][U][G][A][C][C][G] =  1.300;
 int22_ar[C][G][U][G][A][G][C][G] = -0.600;
 int22_ar[C][G][U][G][A][U][C][G] =  1.300;
 int22_ar[C][G][U][G][C][A][C][G] =  2.000;
 int22_ar[C][G][U][G][C][C][C][G] =  2.000;
 int22_ar[C][G][U][G][C][G][C][G] =  2.000;
 int22_ar[C][G][U][G][C][U][C][G] =  2.000;
 int22_ar[C][G][U][G][G][A][C][G] =  2.000;
 int22_ar[C][G][U][G][G][C][C][G] =  1.700;
 int22_ar[C][G][U][G][G][G][C][G] = -0.700;
 int22_ar[C][G][U][G][G][U][C][G] =  1.200;
 int22_ar[C][G][U][G][U][A][C][G] =  2.000;
 int22_ar[C][G][U][G][U][C][C][G] = -0.400;
 int22_ar[C][G][U][G][U][G][C][G] = -4.200;
 int22_ar[C][G][U][G][U][U][C][G] = -0.500;
 int22_ar[C][G][U][U][A][A][C][G] =  2.000;
 int22_ar[C][G][U][U][A][C][C][G] =  2.000;
 int22_ar[C][G][U][U][A][G][C][G] =  2.000;
 int22_ar[C][G][U][U][A][U][C][G] =  2.000;
 int22_ar[C][G][U][U][C][A][C][G] =  2.000;
 int22_ar[C][G][U][U][C][C][C][G] =  1.400;
 int22_ar[C][G][U][U][C][G][C][G] = -0.400;
 int22_ar[C][G][U][U][C][U][C][G] =  0.500;
 int22_ar[C][G][U][U][G][A][C][G] =  2.000;
 int22_ar[C][G][U][U][G][C][C][G] =  1.100;
 int22_ar[C][G][U][U][G][G][C][G] = -2.600;
 int22_ar[C][G][U][U][G][U][C][G] =  1.100;
 int22_ar[C][G][U][U][U][A][C][G] =  2.000;
 int22_ar[C][G][U][U][U][C][C][G] =  0.500;
 int22_ar[C][G][U][U][U][G][C][G] = -0.500;
 int22_ar[C][G][U][U][U][U][C][G] = -0.400;
 int22_ar[C][G][A][A][A][A][G][C] =  0.500;
 int22_ar[C][G][A][A][A][C][G][C] =  0.600;
 int22_ar[C][G][A][A][A][G][G][C] =  0.000;
 int22_ar[C][G][A][A][A][U][G][C] =  2.000;
 int22_ar[C][G][A][A][C][A][G][C] =  1.100;
 int22_ar[C][G][A][A][C][C][G][C] =  1.500;
 int22_ar[C][G][A][A][C][G][G][C] = -0.700;
 int22_ar[C][G][A][A][C][U][G][C] =  2.000;
 int22_ar[C][G][A][A][G][A][G][C] = -0.300;
 int22_ar[C][G][A][A][G][C][G][C] =  0.100;
 int22_ar[C][G][A][A][G][G][G][C] = -1.600;
 int22_ar[C][G][A][A][G][U][G][C] =  2.000;
 int22_ar[C][G][A][A][U][A][G][C] =  2.000;
 int22_ar[C][G][A][A][U][C][G][C] =  2.000;
 int22_ar[C][G][A][A][U][G][G][C] =  2.000;
 int22_ar[C][G][A][A][U][U][G][C] =  2.000;
 int22_ar[C][G][A][C][A][A][G][C] =  1.100;
 int22_ar[C][G][A][C][A][C][G][C] =  1.100;
 int22_ar[C][G][A][C][A][G][G][C] = -1.000;
 int22_ar[C][G][A][C][A][U][G][C] =  2.000;
 int22_ar[C][G][A][C][C][A][G][C] =  1.700;
 int22_ar[C][G][A][C][C][C][G][C] =  1.500;
 int22_ar[C][G][A][C][C][G][G][C] = -0.600;
 int22_ar[C][G][A][C][C][U][G][C] =  2.000;
 int22_ar[C][G][A][C][G][A][G][C] =  2.000;
 int22_ar[C][G][A][C][G][C][G][C] =  2.000;
 int22_ar[C][G][A][C][G][G][G][C] =  2.000;
 int22_ar[C][G][A][C][G][U][G][C] =  2.000;
 int22_ar[C][G][A][C][U][A][G][C] =  0.700;
 int22_ar[C][G][A][C][U][C][G][C] =  0.500;
 int22_ar[C][G][A][C][U][G][G][C] =  0.200;
 int22_ar[C][G][A][C][U][U][G][C] =  2.000;
 int22_ar[C][G][A][G][A][A][G][C] =  0.400;
 int22_ar[C][G][A][G][A][C][G][C] =  0.500;
 int22_ar[C][G][A][G][A][G][G][C] = -0.700;
 int22_ar[C][G][A][G][A][U][G][C] =  2.000;
 int22_ar[C][G][A][G][C][A][G][C] =  2.000;
 int22_ar[C][G][A][G][C][C][G][C] =  2.000;
 int22_ar[C][G][A][G][C][G][G][C] =  2.000;
 int22_ar[C][G][A][G][C][U][G][C] =  2.000;
 int22_ar[C][G][A][G][G][A][G][C] =  1.000;
 int22_ar[C][G][A][G][G][C][G][C] =  1.400;
 int22_ar[C][G][A][G][G][G][G][C] =  0.000;
 int22_ar[C][G][A][G][G][U][G][C] =  2.000;
 int22_ar[C][G][A][G][U][A][G][C] =  0.100;
 int22_ar[C][G][A][G][U][C][G][C] = -0.700;
 int22_ar[C][G][A][G][U][G][G][C] = -0.800;
 int22_ar[C][G][A][G][U][U][G][C] =  2.000;
 int22_ar[C][G][A][U][A][A][G][C] =  2.000;
 int22_ar[C][G][A][U][A][C][G][C] =  2.000;
 int22_ar[C][G][A][U][A][G][G][C] =  2.000;
 int22_ar[C][G][A][U][A][U][G][C] =  2.000;
 int22_ar[C][G][A][U][C][A][G][C] =  1.800;
 int22_ar[C][G][A][U][C][C][G][C] =  1.500;
 int22_ar[C][G][A][U][C][G][G][C] =  1.200;
 int22_ar[C][G][A][U][C][U][G][C] =  2.000;
 int22_ar[C][G][A][U][G][A][G][C] = -0.500;
 int22_ar[C][G][A][U][G][C][G][C] = -0.600;
 int22_ar[C][G][A][U][G][G][G][C] = -0.600;
 int22_ar[C][G][A][U][G][U][G][C] =  2.000;
 int22_ar[C][G][A][U][U][A][G][C] =  1.500;
 int22_ar[C][G][A][U][U][C][G][C] =  0.000;
 int22_ar[C][G][A][U][U][G][G][C] =  0.900;
 int22_ar[C][G][A][U][U][U][G][C] =  2.000;
 int22_ar[C][G][C][A][A][A][G][C] =  1.300;
 int22_ar[C][G][C][A][A][C][G][C] =  2.200;
 int22_ar[C][G][C][A][A][G][G][C] =  2.000;
 int22_ar[C][G][C][A][A][U][G][C] =  2.000;
 int22_ar[C][G][C][A][C][A][G][C] =  1.000;
 int22_ar[C][G][C][A][C][C][G][C] =  1.300;
 int22_ar[C][G][C][A][C][G][G][C] =  2.000;
 int22_ar[C][G][C][A][C][U][G][C] =  1.200;
 int22_ar[C][G][C][A][G][A][G][C] = -0.700;
 int22_ar[C][G][C][A][G][C][G][C] =  0.700;
 int22_ar[C][G][C][A][G][G][G][C] =  2.000;
 int22_ar[C][G][C][A][G][U][G][C] =  0.400;
 int22_ar[C][G][C][A][U][A][G][C] =  2.000;
 int22_ar[C][G][C][A][U][C][G][C] =  2.000;
 int22_ar[C][G][C][A][U][G][G][C] =  2.000;
 int22_ar[C][G][C][A][U][U][G][C] =  2.000;
 int22_ar[C][G][C][C][A][A][G][C] =  1.000;
 int22_ar[C][G][C][C][A][C][G][C] =  1.900;
 int22_ar[C][G][C][C][A][G][G][C] =  2.000;
 int22_ar[C][G][C][C][A][U][G][C] =  1.100;
 int22_ar[C][G][C][C][C][A][G][C] =  1.000;
 int22_ar[C][G][C][C][C][C][G][C] =  1.300;
 int22_ar[C][G][C][C][C][G][G][C] =  2.000;
 int22_ar[C][G][C][C][C][U][G][C] =  1.200;
 int22_ar[C][G][C][C][G][A][G][C] =  2.000;
 int22_ar[C][G][C][C][G][C][G][C] =  2.000;
 int22_ar[C][G][C][C][G][G][G][C] =  2.000;
 int22_ar[C][G][C][C][G][U][G][C] =  2.000;
 int22_ar[C][G][C][C][U][A][G][C] =  0.000;
 int22_ar[C][G][C][C][U][C][G][C] =  0.300;
 int22_ar[C][G][C][C][U][G][G][C] =  2.000;
 int22_ar[C][G][C][C][U][U][G][C] =  1.700;
 int22_ar[C][G][C][G][A][A][G][C] =  0.700;
 int22_ar[C][G][C][G][A][C][G][C] =  0.700;
 int22_ar[C][G][C][G][A][G][G][C] =  2.000;
 int22_ar[C][G][C][G][A][U][G][C] =  1.000;
 int22_ar[C][G][C][G][C][A][G][C] =  2.000;
 int22_ar[C][G][C][G][C][C][G][C] =  2.000;
 int22_ar[C][G][C][G][C][G][G][C] =  2.000;
 int22_ar[C][G][C][G][C][U][G][C] =  2.000;
 int22_ar[C][G][C][G][G][A][G][C] =  0.900;
 int22_ar[C][G][C][G][G][C][G][C] =  1.800;
 int22_ar[C][G][C][G][G][G][G][C] =  2.000;
 int22_ar[C][G][C][G][G][U][G][C] =  1.700;
 int22_ar[C][G][C][G][U][A][G][C] = -1.900;
 int22_ar[C][G][C][G][U][C][G][C] = -0.300;
 int22_ar[C][G][C][G][U][G][G][C] =  2.000;
 int22_ar[C][G][C][G][U][U][G][C] = -0.700;
 int22_ar[C][G][C][U][A][A][G][C] =  2.000;
 int22_ar[C][G][C][U][A][C][G][C] =  2.000;
 int22_ar[C][G][C][U][A][G][G][C] =  2.000;
 int22_ar[C][G][C][U][A][U][G][C] =  2.000;
 int22_ar[C][G][C][U][C][A][G][C] =  1.100;
 int22_ar[C][G][C][U][C][C][G][C] =  1.400;
 int22_ar[C][G][C][U][C][G][G][C] =  2.000;
 int22_ar[C][G][C][U][C][U][G][C] =  1.200;
 int22_ar[C][G][C][U][G][A][G][C] = -1.500;
 int22_ar[C][G][C][U][G][C][G][C] = -0.200;
 int22_ar[C][G][C][U][G][G][G][C] =  2.000;
 int22_ar[C][G][C][U][G][U][G][C] = -0.300;
 int22_ar[C][G][C][U][U][A][G][C] = -0.200;
 int22_ar[C][G][C][U][U][C][G][C] = -0.100;
 int22_ar[C][G][C][U][U][G][G][C] =  2.000;
 int22_ar[C][G][C][U][U][U][G][C] =  0.200;
 int22_ar[C][G][G][A][A][A][G][C] = -0.200;
 int22_ar[C][G][G][A][A][C][G][C] =  2.000;
 int22_ar[C][G][G][A][A][G][G][C] =  1.100;
 int22_ar[C][G][G][A][A][U][G][C] =  0.900;
 int22_ar[C][G][G][A][C][A][G][C] = -0.400;
 int22_ar[C][G][G][A][C][C][G][C] =  2.000;
 int22_ar[C][G][G][A][C][G][G][C] =  0.900;
 int22_ar[C][G][G][A][C][U][G][C] =  0.000;
 int22_ar[C][G][G][A][G][A][G][C] = -1.700;
 int22_ar[C][G][G][A][G][C][G][C] =  2.000;
 int22_ar[C][G][G][A][G][G][G][C] = -0.900;
 int22_ar[C][G][G][A][G][U][G][C] =  0.300;
 int22_ar[C][G][G][A][U][A][G][C] =  2.000;
 int22_ar[C][G][G][A][U][C][G][C] =  2.000;
 int22_ar[C][G][G][A][U][G][G][C] =  2.000;
 int22_ar[C][G][G][A][U][U][G][C] =  2.000;
 int22_ar[C][G][G][C][A][A][G][C] =  0.700;
 int22_ar[C][G][G][C][A][C][G][C] =  2.000;
 int22_ar[C][G][G][C][A][G][G][C] =  0.800;
 int22_ar[C][G][G][C][A][U][G][C] = -0.100;
 int22_ar[C][G][G][C][C][A][G][C] =  1.100;
 int22_ar[C][G][G][C][C][C][G][C] =  2.000;
 int22_ar[C][G][G][C][C][G][G][C] =  1.500;
 int22_ar[C][G][G][C][C][U][G][C] =  1.000;
 int22_ar[C][G][G][C][G][A][G][C] =  2.000;
 int22_ar[C][G][G][C][G][C][G][C] =  2.000;
 int22_ar[C][G][G][C][G][G][G][C] =  2.000;
 int22_ar[C][G][G][C][G][U][G][C] =  2.000;
 int22_ar[C][G][G][C][U][A][G][C] =  0.200;
 int22_ar[C][G][G][C][U][C][G][C] =  2.000;
 int22_ar[C][G][G][C][U][G][G][C] =  0.500;
 int22_ar[C][G][G][C][U][U][G][C] =  0.000;
 int22_ar[C][G][G][G][A][A][G][C] = -0.500;
 int22_ar[C][G][G][G][A][C][G][C] =  2.000;
 int22_ar[C][G][G][G][A][G][G][C] = -0.200;
 int22_ar[C][G][G][G][A][U][G][C] =  0.600;
 int22_ar[C][G][G][G][C][A][G][C] =  2.000;
 int22_ar[C][G][G][G][C][C][G][C] =  2.000;
 int22_ar[C][G][G][G][C][G][G][C] =  2.000;
 int22_ar[C][G][G][G][C][U][G][C] =  2.000;
 int22_ar[C][G][G][G][G][A][G][C] =  0.000;
 int22_ar[C][G][G][G][G][C][G][C] =  2.000;
 int22_ar[C][G][G][G][G][G][G][C] =  0.800;
 int22_ar[C][G][G][G][G][U][G][C] =  0.900;
 int22_ar[C][G][G][G][U][A][G][C] = -0.900;
 int22_ar[C][G][G][G][U][C][G][C] =  2.000;
 int22_ar[C][G][G][G][U][G][G][C] = -1.000;
 int22_ar[C][G][G][G][U][U][G][C] = -3.000;
 int22_ar[C][G][G][U][A][A][G][C] =  2.000;
 int22_ar[C][G][G][U][A][C][G][C] =  2.000;
 int22_ar[C][G][G][U][A][G][G][C] =  2.000;
 int22_ar[C][G][G][U][A][U][G][C] =  2.000;
 int22_ar[C][G][G][U][C][A][G][C] =  1.200;
 int22_ar[C][G][G][U][C][C][G][C] =  2.000;
 int22_ar[C][G][G][U][C][G][G][C] =  1.500;
 int22_ar[C][G][G][U][C][U][G][C] =  1.000;
 int22_ar[C][G][G][U][G][A][G][C] = -1.300;
 int22_ar[C][G][G][U][G][C][G][C] =  2.000;
 int22_ar[C][G][G][U][G][G][G][C] = -0.600;
 int22_ar[C][G][G][U][G][U][G][C] = -2.400;
 int22_ar[C][G][G][U][U][A][G][C] =  0.900;
 int22_ar[C][G][G][U][U][C][G][C] =  2.000;
 int22_ar[C][G][G][U][U][G][G][C] =  1.100;
 int22_ar[C][G][G][U][U][U][G][C] =  0.600;
 int22_ar[C][G][U][A][A][A][G][C] =  2.000;
 int22_ar[C][G][U][A][A][C][G][C] =  2.000;
 int22_ar[C][G][U][A][A][G][G][C] = -0.100;
 int22_ar[C][G][U][A][A][U][G][C] =  1.400;
 int22_ar[C][G][U][A][C][A][G][C] =  2.000;
 int22_ar[C][G][U][A][C][C][G][C] =  1.200;
 int22_ar[C][G][U][A][C][G][G][C] = -1.600;
 int22_ar[C][G][U][A][C][U][G][C] =  0.300;
 int22_ar[C][G][U][A][G][A][G][C] =  2.000;
 int22_ar[C][G][U][A][G][C][G][C] =  0.400;
 int22_ar[C][G][U][A][G][G][G][C] = -1.600;
 int22_ar[C][G][U][A][G][U][G][C] =  0.500;
 int22_ar[C][G][U][A][U][A][G][C] =  2.000;
 int22_ar[C][G][U][A][U][C][G][C] =  2.000;
 int22_ar[C][G][U][A][U][G][G][C] =  2.000;
 int22_ar[C][G][U][A][U][U][G][C] =  2.000;
 int22_ar[C][G][U][C][A][A][G][C] =  2.000;
 int22_ar[C][G][U][C][A][C][G][C] =  1.100;
 int22_ar[C][G][U][C][A][G][G][C] = -1.600;
 int22_ar[C][G][U][C][A][U][G][C] =  0.300;
 int22_ar[C][G][U][C][C][A][G][C] =  2.000;
 int22_ar[C][G][U][C][C][C][G][C] =  1.200;
 int22_ar[C][G][U][C][C][G][G][C] = -0.600;
 int22_ar[C][G][U][C][C][U][G][C] =  0.300;
 int22_ar[C][G][U][C][G][A][G][C] =  2.000;
 int22_ar[C][G][U][C][G][C][G][C] =  2.000;
 int22_ar[C][G][U][C][G][G][G][C] =  2.000;
 int22_ar[C][G][U][C][G][U][G][C] =  2.000;
 int22_ar[C][G][U][C][U][A][G][C] =  2.000;
 int22_ar[C][G][U][C][U][C][G][C] =  0.200;
 int22_ar[C][G][U][C][U][G][G][C] = -1.600;
 int22_ar[C][G][U][C][U][U][G][C] =  0.100;
 int22_ar[C][G][U][G][A][A][G][C] =  2.000;
 int22_ar[C][G][U][G][A][C][G][C] =  0.500;
 int22_ar[C][G][U][G][A][G][G][C] = -0.600;
 int22_ar[C][G][U][G][A][U][G][C] =  1.400;
 int22_ar[C][G][U][G][C][A][G][C] =  2.000;
 int22_ar[C][G][U][G][C][C][G][C] =  2.000;
 int22_ar[C][G][U][G][C][G][G][C] =  2.000;
 int22_ar[C][G][U][G][C][U][G][C] =  2.000;
 int22_ar[C][G][U][G][G][A][G][C] =  2.000;
 int22_ar[C][G][U][G][G][C][G][C] =  1.700;
 int22_ar[C][G][U][G][G][G][G][C] = -0.700;
 int22_ar[C][G][U][G][G][U][G][C] =  1.200;
 int22_ar[C][G][U][G][U][A][G][C] =  2.000;
 int22_ar[C][G][U][G][U][C][G][C] = -0.700;
 int22_ar[C][G][U][G][U][G][G][C] = -4.400;
 int22_ar[C][G][U][G][U][U][G][C] = -1.000;
 int22_ar[C][G][U][U][A][A][G][C] =  2.000;
 int22_ar[C][G][U][U][A][C][G][C] =  2.000;
 int22_ar[C][G][U][U][A][G][G][C] =  2.000;
 int22_ar[C][G][U][U][A][U][G][C] =  2.000;
 int22_ar[C][G][U][U][C][A][G][C] =  2.000;
 int22_ar[C][G][U][U][C][C][G][C] =  1.200;
 int22_ar[C][G][U][U][C][G][G][C] = -0.500;
 int22_ar[C][G][U][U][C][U][G][C] =  0.300;
 int22_ar[C][G][U][U][G][A][G][C] =  2.000;
 int22_ar[C][G][U][U][G][C][G][C] = -0.100;
 int22_ar[C][G][U][U][G][G][G][C] = -4.100;
 int22_ar[C][G][U][U][G][U][G][C] =  0.100;
 int22_ar[C][G][U][U][U][A][G][C] =  2.000;
 int22_ar[C][G][U][U][U][C][G][C] =  0.400;
 int22_ar[C][G][U][U][U][G][G][C] = -1.000;
 int22_ar[C][G][U][U][U][U][G][C] =  0.600;
 int22_ar[C][G][A][A][A][A][G][U] =  2.000;
 int22_ar[C][G][A][A][A][C][G][U] =  2.400;
 int22_ar[C][G][A][A][A][G][G][U] =  1.000;
 int22_ar[C][G][A][A][A][U][G][U] =  2.000;
 int22_ar[C][G][A][A][C][A][G][U] =  1.800;
 int22_ar[C][G][A][A][C][C][G][U] =  2.100;
 int22_ar[C][G][A][A][C][G][G][U] =  0.800;
 int22_ar[C][G][A][A][C][U][G][U] =  2.000;
 int22_ar[C][G][A][A][G][A][G][U] =  0.800;
 int22_ar[C][G][A][A][G][C][G][U] =  1.100;
 int22_ar[C][G][A][A][G][G][G][U] = -0.200;
 int22_ar[C][G][A][A][G][U][G][U] =  2.000;
 int22_ar[C][G][A][A][U][A][G][U] =  2.000;
 int22_ar[C][G][A][A][U][C][G][U] =  2.000;
 int22_ar[C][G][A][A][U][G][G][U] =  2.000;
 int22_ar[C][G][A][A][U][U][G][U] =  2.000;
 int22_ar[C][G][A][C][A][A][G][U] =  1.900;
 int22_ar[C][G][A][C][A][C][G][U] =  2.200;
 int22_ar[C][G][A][C][A][G][G][U] =  0.900;
 int22_ar[C][G][A][C][A][U][G][U] =  2.000;
 int22_ar[C][G][A][C][C][A][G][U] =  2.300;
 int22_ar[C][G][A][C][C][C][G][U] =  2.100;
 int22_ar[C][G][A][C][C][G][G][U] =  1.700;
 int22_ar[C][G][A][C][C][U][G][U] =  2.000;
 int22_ar[C][G][A][C][G][A][G][U] =  2.000;
 int22_ar[C][G][A][C][G][C][G][U] =  2.000;
 int22_ar[C][G][A][C][G][G][G][U] =  2.000;
 int22_ar[C][G][A][C][G][U][G][U] =  2.000;
 int22_ar[C][G][A][C][U][A][G][U] =  2.300;
 int22_ar[C][G][A][C][U][C][G][U] =  2.100;
 int22_ar[C][G][A][C][U][G][G][U] =  1.700;
 int22_ar[C][G][A][C][U][U][G][U] =  2.000;
 int22_ar[C][G][A][G][A][A][G][U] =  0.800;
 int22_ar[C][G][A][G][A][C][G][U] =  1.100;
 int22_ar[C][G][A][G][A][G][G][U] = -0.200;
 int22_ar[C][G][A][G][A][U][G][U] =  2.000;
 int22_ar[C][G][A][G][C][A][G][U] =  2.000;
 int22_ar[C][G][A][G][C][C][G][U] =  2.000;
 int22_ar[C][G][A][G][C][G][G][U] =  2.000;
 int22_ar[C][G][A][G][C][U][G][U] =  2.000;
 int22_ar[C][G][A][G][G][A][G][U] =  1.300;
 int22_ar[C][G][A][G][G][C][G][U] =  1.700;
 int22_ar[C][G][A][G][G][G][G][U] =  0.300;
 int22_ar[C][G][A][G][G][U][G][U] =  2.000;
 int22_ar[C][G][A][G][U][A][G][U] =  0.600;
 int22_ar[C][G][A][G][U][C][G][U] =  0.000;
 int22_ar[C][G][A][G][U][G][G][U] =  0.400;
 int22_ar[C][G][A][G][U][U][G][U] =  2.000;
 int22_ar[C][G][A][U][A][A][G][U] =  2.000;
 int22_ar[C][G][A][U][A][C][G][U] =  2.000;
 int22_ar[C][G][A][U][A][G][G][U] =  2.000;
 int22_ar[C][G][A][U][A][U][G][U] =  2.000;
 int22_ar[C][G][A][U][C][A][G][U] =  2.300;
 int22_ar[C][G][A][U][C][C][G][U] =  2.100;
 int22_ar[C][G][A][U][C][G][G][U] =  1.700;
 int22_ar[C][G][A][U][C][U][G][U] =  2.000;
 int22_ar[C][G][A][U][G][A][G][U] =  1.600;
 int22_ar[C][G][A][U][G][C][G][U] =  0.900;
 int22_ar[C][G][A][U][G][G][G][U] =  1.400;
 int22_ar[C][G][A][U][G][U][G][U] =  2.000;
 int22_ar[C][G][A][U][U][A][G][U] =  1.900;
 int22_ar[C][G][A][U][U][C][G][U] =  1.300;
 int22_ar[C][G][A][U][U][G][G][U] =  1.800;
 int22_ar[C][G][A][U][U][U][G][U] =  2.000;
 int22_ar[C][G][C][A][A][A][G][U] =  1.900;
 int22_ar[C][G][C][A][A][C][G][U] =  2.800;
 int22_ar[C][G][C][A][A][G][G][U] =  2.000;
 int22_ar[C][G][C][A][A][U][G][U] =  2.700;
 int22_ar[C][G][C][A][C][A][G][U] =  1.700;
 int22_ar[C][G][C][A][C][C][G][U] =  2.000;
 int22_ar[C][G][C][A][C][G][G][U] =  2.000;
 int22_ar[C][G][C][A][C][U][G][U] =  1.800;
 int22_ar[C][G][C][A][G][A][G][U] =  0.700;
 int22_ar[C][G][C][A][G][C][G][U] =  2.000;
 int22_ar[C][G][C][A][G][G][G][U] =  2.000;
 int22_ar[C][G][C][A][G][U][G][U] =  1.800;
 int22_ar[C][G][C][A][U][A][G][U] =  2.000;
 int22_ar[C][G][C][A][U][C][G][U] =  2.000;
 int22_ar[C][G][C][A][U][G][G][U] =  2.000;
 int22_ar[C][G][C][A][U][U][G][U] =  2.000;
 int22_ar[C][G][C][C][A][A][G][U] =  1.800;
 int22_ar[C][G][C][C][A][C][G][U] =  2.100;
 int22_ar[C][G][C][C][A][G][G][U] =  2.000;
 int22_ar[C][G][C][C][A][U][G][U] =  1.900;
 int22_ar[C][G][C][C][C][A][G][U] =  1.600;
 int22_ar[C][G][C][C][C][C][G][U] =  1.900;
 int22_ar[C][G][C][C][C][G][G][U] =  2.000;
 int22_ar[C][G][C][C][C][U][G][U] =  1.800;
 int22_ar[C][G][C][C][G][A][G][U] =  2.000;
 int22_ar[C][G][C][C][G][C][G][U] =  2.000;
 int22_ar[C][G][C][C][G][G][G][U] =  2.000;
 int22_ar[C][G][C][C][G][U][G][U] =  2.000;
 int22_ar[C][G][C][C][U][A][G][U] =  1.600;
 int22_ar[C][G][C][C][U][C][G][U] =  1.900;
 int22_ar[C][G][C][C][U][G][G][U] =  2.000;
 int22_ar[C][G][C][C][U][U][G][U] =  1.800;
 int22_ar[C][G][C][G][A][A][G][U] =  0.700;
 int22_ar[C][G][C][G][A][C][G][U] =  2.000;
 int22_ar[C][G][C][G][A][G][G][U] =  2.000;
 int22_ar[C][G][C][G][A][U][G][U] =  1.800;
 int22_ar[C][G][C][G][C][A][G][U] =  2.000;
 int22_ar[C][G][C][G][C][C][G][U] =  2.000;
 int22_ar[C][G][C][G][C][G][G][U] =  2.000;
 int22_ar[C][G][C][G][C][U][G][U] =  2.000;
 int22_ar[C][G][C][G][G][A][G][U] =  1.200;
 int22_ar[C][G][C][G][G][C][G][U] =  2.100;
 int22_ar[C][G][C][G][G][G][G][U] =  2.000;
 int22_ar[C][G][C][G][G][U][G][U] =  2.000;
 int22_ar[C][G][C][G][U][A][G][U] = -0.500;
 int22_ar[C][G][C][G][U][C][G][U] =  0.800;
 int22_ar[C][G][C][G][U][G][G][U] =  2.000;
 int22_ar[C][G][C][G][U][U][G][U] =  0.700;
 int22_ar[C][G][C][U][A][A][G][U] =  2.000;
 int22_ar[C][G][C][U][A][C][G][U] =  2.000;
 int22_ar[C][G][C][U][A][G][G][U] =  2.000;
 int22_ar[C][G][C][U][A][U][G][U] =  2.000;
 int22_ar[C][G][C][U][C][A][G][U] =  1.600;
 int22_ar[C][G][C][U][C][C][G][U] =  1.900;
 int22_ar[C][G][C][U][C][G][G][U] =  2.000;
 int22_ar[C][G][C][U][C][U][G][U] =  1.800;
 int22_ar[C][G][C][U][G][A][G][U] =  0.500;
 int22_ar[C][G][C][U][G][C][G][U] =  1.800;
 int22_ar[C][G][C][U][G][G][G][U] =  2.000;
 int22_ar[C][G][C][U][G][U][G][U] =  1.600;
 int22_ar[C][G][C][U][U][A][G][U] =  0.800;
 int22_ar[C][G][C][U][U][C][G][U] =  1.100;
 int22_ar[C][G][C][U][U][G][G][U] =  2.000;
 int22_ar[C][G][C][U][U][U][G][U] =  1.000;
 int22_ar[C][G][G][A][A][A][G][U] =  1.000;
 int22_ar[C][G][G][A][A][C][G][U] =  2.000;
 int22_ar[C][G][G][A][A][G][G][U] =  1.800;
 int22_ar[C][G][G][A][A][U][G][U] =  1.800;
 int22_ar[C][G][G][A][C][A][G][U] =  0.800;
 int22_ar[C][G][G][A][C][C][G][U] =  2.000;
 int22_ar[C][G][G][A][C][G][G][U] =  1.500;
 int22_ar[C][G][G][A][C][U][G][U] =  0.600;
 int22_ar[C][G][G][A][G][A][G][U] = -0.200;
 int22_ar[C][G][G][A][G][C][G][U] =  2.000;
 int22_ar[C][G][G][A][G][G][G][U] =  0.500;
 int22_ar[C][G][G][A][G][U][G][U] =  1.400;
 int22_ar[C][G][G][A][U][A][G][U] =  2.000;
 int22_ar[C][G][G][A][U][C][G][U] =  2.000;
 int22_ar[C][G][G][A][U][G][G][U] =  2.000;
 int22_ar[C][G][G][A][U][U][G][U] =  2.000;
 int22_ar[C][G][G][C][A][A][G][U] =  0.900;
 int22_ar[C][G][G][C][A][C][G][U] =  2.000;
 int22_ar[C][G][G][C][A][G][G][U] =  1.600;
 int22_ar[C][G][G][C][A][U][G][U] =  0.700;
 int22_ar[C][G][G][C][C][A][G][U] =  1.700;
 int22_ar[C][G][G][C][C][C][G][U] =  2.000;
 int22_ar[C][G][G][C][C][G][G][U] =  2.100;
 int22_ar[C][G][G][C][C][U][G][U] =  1.500;
 int22_ar[C][G][G][C][G][A][G][U] =  2.000;
 int22_ar[C][G][G][C][G][C][G][U] =  2.000;
 int22_ar[C][G][G][C][G][G][G][U] =  2.000;
 int22_ar[C][G][G][C][G][U][G][U] =  2.000;
 int22_ar[C][G][G][C][U][A][G][U] =  1.700;
 int22_ar[C][G][G][C][U][C][G][U] =  2.000;
 int22_ar[C][G][G][C][U][G][G][U] =  2.100;
 int22_ar[C][G][G][C][U][U][G][U] =  1.500;
 int22_ar[C][G][G][G][A][A][G][U] = -0.200;
 int22_ar[C][G][G][G][A][C][G][U] =  2.000;
 int22_ar[C][G][G][G][A][G][G][U] =  0.500;
 int22_ar[C][G][G][G][A][U][G][U] =  1.400;
 int22_ar[C][G][G][G][C][A][G][U] =  2.000;
 int22_ar[C][G][G][G][C][C][G][U] =  2.000;
 int22_ar[C][G][G][G][C][G][G][U] =  2.000;
 int22_ar[C][G][G][G][C][U][G][U] =  2.000;
 int22_ar[C][G][G][G][G][A][G][U] =  0.300;
 int22_ar[C][G][G][G][G][C][G][U] =  2.000;
 int22_ar[C][G][G][G][G][G][G][U] =  1.100;
 int22_ar[C][G][G][G][G][U][G][U] =  1.100;
 int22_ar[C][G][G][G][U][A][G][U] =  0.400;
 int22_ar[C][G][G][G][U][C][G][U] =  2.000;
 int22_ar[C][G][G][G][U][G][G][U] =  0.400;
 int22_ar[C][G][G][G][U][U][G][U] = -1.600;
 int22_ar[C][G][G][U][A][A][G][U] =  2.000;
 int22_ar[C][G][G][U][A][C][G][U] =  2.000;
 int22_ar[C][G][G][U][A][G][G][U] =  2.000;
 int22_ar[C][G][G][U][A][U][G][U] =  2.000;
 int22_ar[C][G][G][U][C][A][G][U] =  1.700;
 int22_ar[C][G][G][U][C][C][G][U] =  2.000;
 int22_ar[C][G][G][U][C][G][G][U] =  2.100;
 int22_ar[C][G][G][U][C][U][G][U] =  1.500;
 int22_ar[C][G][G][U][G][A][G][U] =  1.400;
 int22_ar[C][G][G][U][G][C][G][U] =  2.000;
 int22_ar[C][G][G][U][G][G][G][U] =  1.300;
 int22_ar[C][G][G][U][G][U][G][U] = -0.600;
 int22_ar[C][G][G][U][U][A][G][U] =  1.800;
 int22_ar[C][G][G][U][U][C][G][U] =  2.000;
 int22_ar[C][G][G][U][U][G][G][U] =  1.700;
 int22_ar[C][G][G][U][U][U][G][U] =  1.600;
 int22_ar[C][G][U][A][A][A][G][U] =  2.000;
 int22_ar[C][G][U][A][A][C][G][U] =  2.700;
 int22_ar[C][G][U][A][A][G][G][U] =  0.300;
 int22_ar[C][G][U][A][A][U][G][U] =  2.200;
 int22_ar[C][G][U][A][C][A][G][U] =  2.000;
 int22_ar[C][G][U][A][C][C][G][U] =  1.800;
 int22_ar[C][G][U][A][C][G][G][U] = -0.900;
 int22_ar[C][G][U][A][C][U][G][U] =  0.900;
 int22_ar[C][G][U][A][G][A][G][U] =  2.000;
 int22_ar[C][G][U][A][G][C][G][U] =  1.800;
 int22_ar[C][G][U][A][G][G][G][U] = -0.100;
 int22_ar[C][G][U][A][G][U][G][U] =  1.800;
 int22_ar[C][G][U][A][U][A][G][U] =  2.000;
 int22_ar[C][G][U][A][U][C][G][U] =  2.000;
 int22_ar[C][G][U][A][U][G][G][U] =  2.000;
 int22_ar[C][G][U][A][U][U][G][U] =  2.000;
 int22_ar[C][G][U][C][A][A][G][U] =  2.000;
 int22_ar[C][G][U][C][A][C][G][U] =  1.900;
 int22_ar[C][G][U][C][A][G][G][U] = -0.800;
 int22_ar[C][G][U][C][A][U][G][U] =  1.000;
 int22_ar[C][G][U][C][C][A][G][U] =  2.000;
 int22_ar[C][G][U][C][C][C][G][U] =  1.800;
 int22_ar[C][G][U][C][C][G][G][U] =  0.000;
 int22_ar[C][G][U][C][C][U][G][U] =  0.900;
 int22_ar[C][G][U][C][G][A][G][U] =  2.000;
 int22_ar[C][G][U][C][G][C][G][U] =  2.000;
 int22_ar[C][G][U][C][G][G][G][U] =  2.000;
 int22_ar[C][G][U][C][G][U][G][U] =  2.000;
 int22_ar[C][G][U][C][U][A][G][U] =  2.000;
 int22_ar[C][G][U][C][U][C][G][U] =  1.800;
 int22_ar[C][G][U][C][U][G][G][U] =  0.000;
 int22_ar[C][G][U][C][U][U][G][U] =  0.900;
 int22_ar[C][G][U][G][A][A][G][U] =  2.000;
 int22_ar[C][G][U][G][A][C][G][U] =  1.800;
 int22_ar[C][G][U][G][A][G][G][U] = -0.100;
 int22_ar[C][G][U][G][A][U][G][U] =  1.800;
 int22_ar[C][G][U][G][C][A][G][U] =  2.000;
 int22_ar[C][G][U][G][C][C][G][U] =  2.000;
 int22_ar[C][G][U][G][C][G][G][U] =  2.000;
 int22_ar[C][G][U][G][C][U][G][U] =  2.000;
 int22_ar[C][G][U][G][G][A][G][U] =  2.000;
 int22_ar[C][G][U][G][G][C][G][U] =  2.000;
 int22_ar[C][G][U][G][G][G][G][U] = -0.400;
 int22_ar[C][G][U][G][G][U][G][U] =  1.500;
 int22_ar[C][G][U][G][U][A][G][U] =  2.000;
 int22_ar[C][G][U][G][U][C][G][U] =  0.700;
 int22_ar[C][G][U][G][U][G][G][U] = -3.100;
 int22_ar[C][G][U][G][U][U][G][U] =  0.600;
 int22_ar[C][G][U][U][A][A][G][U] =  2.000;
 int22_ar[C][G][U][U][A][C][G][U] =  2.000;
 int22_ar[C][G][U][U][A][G][G][U] =  2.000;
 int22_ar[C][G][U][U][A][U][G][U] =  2.000;
 int22_ar[C][G][U][U][C][A][G][U] =  2.000;
 int22_ar[C][G][U][U][C][C][G][U] =  1.800;
 int22_ar[C][G][U][U][C][G][G][U] =  0.000;
 int22_ar[C][G][U][U][C][U][G][U] =  0.900;
 int22_ar[C][G][U][U][G][A][G][U] =  2.000;
 int22_ar[C][G][U][U][G][C][G][U] =  1.600;
 int22_ar[C][G][U][U][G][G][G][U] = -2.100;
 int22_ar[C][G][U][U][G][U][G][U] =  1.600;
 int22_ar[C][G][U][U][U][A][G][U] =  2.000;
 int22_ar[C][G][U][U][U][C][G][U] =  1.000;
 int22_ar[C][G][U][U][U][G][G][U] =  0.000;
 int22_ar[C][G][U][U][U][U][G][U] =  0.100;
 int22_ar[C][G][A][A][A][A][U][A] =  2.000;
 int22_ar[C][G][A][A][A][C][U][A] =  2.400;
 int22_ar[C][G][A][A][A][G][U][A] =  1.000;
 int22_ar[C][G][A][A][A][U][U][A] =  2.000;
 int22_ar[C][G][A][A][C][A][U][A] =  1.600;
 int22_ar[C][G][A][A][C][C][U][A] =  1.900;
 int22_ar[C][G][A][A][C][G][U][A] =  0.600;
 int22_ar[C][G][A][A][C][U][U][A] =  2.000;
 int22_ar[C][G][A][A][G][A][U][A] =  1.000;
 int22_ar[C][G][A][A][G][C][U][A] =  1.300;
 int22_ar[C][G][A][A][G][G][U][A] =  0.000;
 int22_ar[C][G][A][A][G][U][U][A] =  2.000;
 int22_ar[C][G][A][A][U][A][U][A] =  2.000;
 int22_ar[C][G][A][A][U][C][U][A] =  2.000;
 int22_ar[C][G][A][A][U][G][U][A] =  2.000;
 int22_ar[C][G][A][A][U][U][U][A] =  2.000;
 int22_ar[C][G][A][C][A][A][U][A] =  2.000;
 int22_ar[C][G][A][C][A][C][U][A] =  2.400;
 int22_ar[C][G][A][C][A][G][U][A] =  1.000;
 int22_ar[C][G][A][C][A][U][U][A] =  2.000;
 int22_ar[C][G][A][C][C][A][U][A] =  2.600;
 int22_ar[C][G][A][C][C][C][U][A] =  2.400;
 int22_ar[C][G][A][C][C][G][U][A] =  2.000;
 int22_ar[C][G][A][C][C][U][U][A] =  2.000;
 int22_ar[C][G][A][C][G][A][U][A] =  2.000;
 int22_ar[C][G][A][C][G][C][U][A] =  2.000;
 int22_ar[C][G][A][C][G][G][U][A] =  2.000;
 int22_ar[C][G][A][C][G][U][U][A] =  2.000;
 int22_ar[C][G][A][C][U][A][U][A] =  2.600;
 int22_ar[C][G][A][C][U][C][U][A] =  2.400;
 int22_ar[C][G][A][C][U][G][U][A] =  2.000;
 int22_ar[C][G][A][C][U][U][U][A] =  2.000;
 int22_ar[C][G][A][G][A][A][U][A] =  1.000;
 int22_ar[C][G][A][G][A][C][U][A] =  1.300;
 int22_ar[C][G][A][G][A][G][U][A] =  0.000;
 int22_ar[C][G][A][G][A][U][U][A] =  2.000;
 int22_ar[C][G][A][G][C][A][U][A] =  2.000;
 int22_ar[C][G][A][G][C][C][U][A] =  2.000;
 int22_ar[C][G][A][G][C][G][U][A] =  2.000;
 int22_ar[C][G][A][G][C][U][U][A] =  2.000;
 int22_ar[C][G][A][G][G][A][U][A] =  1.400;
 int22_ar[C][G][A][G][G][C][U][A] =  1.700;
 int22_ar[C][G][A][G][G][G][U][A] =  0.400;
 int22_ar[C][G][A][G][G][U][U][A] =  2.000;
 int22_ar[C][G][A][G][U][A][U][A] =  0.200;
 int22_ar[C][G][A][G][U][C][U][A] = -0.400;
 int22_ar[C][G][A][G][U][G][U][A] =  0.000;
 int22_ar[C][G][A][G][U][U][U][A] =  2.000;
 int22_ar[C][G][A][U][A][A][U][A] =  2.000;
 int22_ar[C][G][A][U][A][C][U][A] =  2.000;
 int22_ar[C][G][A][U][A][G][U][A] =  2.000;
 int22_ar[C][G][A][U][A][U][U][A] =  2.000;
 int22_ar[C][G][A][U][C][A][U][A] =  2.300;
 int22_ar[C][G][A][U][C][C][U][A] =  2.100;
 int22_ar[C][G][A][U][C][G][U][A] =  1.700;
 int22_ar[C][G][A][U][C][U][U][A] =  2.000;
 int22_ar[C][G][A][U][G][A][U][A] =  1.500;
 int22_ar[C][G][A][U][G][C][U][A] =  0.800;
 int22_ar[C][G][A][U][G][G][U][A] =  1.300;
 int22_ar[C][G][A][U][G][U][U][A] =  2.000;
 int22_ar[C][G][A][U][U][A][U][A] =  2.200;
 int22_ar[C][G][A][U][U][C][U][A] =  1.500;
 int22_ar[C][G][A][U][U][G][U][A] =  2.000;
 int22_ar[C][G][A][U][U][U][U][A] =  2.000;
 int22_ar[C][G][C][A][A][A][U][A] =  1.900;
 int22_ar[C][G][C][A][A][C][U][A] =  2.800;
 int22_ar[C][G][C][A][A][G][U][A] =  2.000;
 int22_ar[C][G][C][A][A][U][U][A] =  2.700;
 int22_ar[C][G][C][A][C][A][U][A] =  1.500;
 int22_ar[C][G][C][A][C][C][U][A] =  1.800;
 int22_ar[C][G][C][A][C][G][U][A] =  2.000;
 int22_ar[C][G][C][A][C][U][U][A] =  1.600;
 int22_ar[C][G][C][A][G][A][U][A] =  0.900;
 int22_ar[C][G][C][A][G][C][U][A] =  2.200;
 int22_ar[C][G][C][A][G][G][U][A] =  2.000;
 int22_ar[C][G][C][A][G][U][U][A] =  2.000;
 int22_ar[C][G][C][A][U][A][U][A] =  2.000;
 int22_ar[C][G][C][A][U][C][U][A] =  2.000;
 int22_ar[C][G][C][A][U][G][U][A] =  2.000;
 int22_ar[C][G][C][A][U][U][U][A] =  2.000;
 int22_ar[C][G][C][C][A][A][U][A] =  1.900;
 int22_ar[C][G][C][C][A][C][U][A] =  2.200;
 int22_ar[C][G][C][C][A][G][U][A] =  2.000;
 int22_ar[C][G][C][C][A][U][U][A] =  2.100;
 int22_ar[C][G][C][C][C][A][U][A] =  1.900;
 int22_ar[C][G][C][C][C][C][U][A] =  2.200;
 int22_ar[C][G][C][C][C][G][U][A] =  2.000;
 int22_ar[C][G][C][C][C][U][U][A] =  2.100;
 int22_ar[C][G][C][C][G][A][U][A] =  2.000;
 int22_ar[C][G][C][C][G][C][U][A] =  2.000;
 int22_ar[C][G][C][C][G][G][U][A] =  2.000;
 int22_ar[C][G][C][C][G][U][U][A] =  2.000;
 int22_ar[C][G][C][C][U][A][U][A] =  1.900;
 int22_ar[C][G][C][C][U][C][U][A] =  2.200;
 int22_ar[C][G][C][C][U][G][U][A] =  2.000;
 int22_ar[C][G][C][C][U][U][U][A] =  2.100;
 int22_ar[C][G][C][G][A][A][U][A] =  0.900;
 int22_ar[C][G][C][G][A][C][U][A] =  2.200;
 int22_ar[C][G][C][G][A][G][U][A] =  2.000;
 int22_ar[C][G][C][G][A][U][U][A] =  2.000;
 int22_ar[C][G][C][G][C][A][U][A] =  2.000;
 int22_ar[C][G][C][G][C][C][U][A] =  2.000;
 int22_ar[C][G][C][G][C][G][U][A] =  2.000;
 int22_ar[C][G][C][G][C][U][U][A] =  2.000;
 int22_ar[C][G][C][G][G][A][U][A] =  1.300;
 int22_ar[C][G][C][G][G][C][U][A] =  2.200;
 int22_ar[C][G][C][G][G][G][U][A] =  2.000;
 int22_ar[C][G][C][G][G][U][U][A] =  2.000;
 int22_ar[C][G][C][G][U][A][U][A] = -0.900;
 int22_ar[C][G][C][G][U][C][U][A] =  0.400;
 int22_ar[C][G][C][G][U][G][U][A] =  2.000;
 int22_ar[C][G][C][G][U][U][U][A] =  0.300;
 int22_ar[C][G][C][U][A][A][U][A] =  2.000;
 int22_ar[C][G][C][U][A][C][U][A] =  2.000;
 int22_ar[C][G][C][U][A][G][U][A] =  2.000;
 int22_ar[C][G][C][U][A][U][U][A] =  2.000;
 int22_ar[C][G][C][U][C][A][U][A] =  1.600;
 int22_ar[C][G][C][U][C][C][U][A] =  1.900;
 int22_ar[C][G][C][U][C][G][U][A] =  2.000;
 int22_ar[C][G][C][U][C][U][U][A] =  1.800;
 int22_ar[C][G][C][U][G][A][U][A] =  0.400;
 int22_ar[C][G][C][U][G][C][U][A] =  1.700;
 int22_ar[C][G][C][U][G][G][U][A] =  2.000;
 int22_ar[C][G][C][U][G][U][U][A] =  1.500;
 int22_ar[C][G][C][U][U][A][U][A] =  1.100;
 int22_ar[C][G][C][U][U][C][U][A] =  1.400;
 int22_ar[C][G][C][U][U][G][U][A] =  2.000;
 int22_ar[C][G][C][U][U][U][U][A] =  1.200;
 int22_ar[C][G][G][A][A][A][U][A] =  1.000;
 int22_ar[C][G][G][A][A][C][U][A] =  2.000;
 int22_ar[C][G][G][A][A][G][U][A] =  1.800;
 int22_ar[C][G][G][A][A][U][U][A] =  1.800;
 int22_ar[C][G][G][A][C][A][U][A] =  0.600;
 int22_ar[C][G][G][A][C][C][U][A] =  2.000;
 int22_ar[C][G][G][A][C][G][U][A] =  1.300;
 int22_ar[C][G][G][A][C][U][U][A] =  0.400;
 int22_ar[C][G][G][A][G][A][U][A] =  0.000;
 int22_ar[C][G][G][A][G][C][U][A] =  2.000;
 int22_ar[C][G][G][A][G][G][U][A] =  0.700;
 int22_ar[C][G][G][A][G][U][U][A] =  1.600;
 int22_ar[C][G][G][A][U][A][U][A] =  2.000;
 int22_ar[C][G][G][A][U][C][U][A] =  2.000;
 int22_ar[C][G][G][A][U][G][U][A] =  2.000;
 int22_ar[C][G][G][A][U][U][U][A] =  2.000;
 int22_ar[C][G][G][C][A][A][U][A] =  1.000;
 int22_ar[C][G][G][C][A][C][U][A] =  2.000;
 int22_ar[C][G][G][C][A][G][U][A] =  1.800;
 int22_ar[C][G][G][C][A][U][U][A] =  0.800;
 int22_ar[C][G][G][C][C][A][U][A] =  2.000;
 int22_ar[C][G][G][C][C][C][U][A] =  2.000;
 int22_ar[C][G][G][C][C][G][U][A] =  2.400;
 int22_ar[C][G][G][C][C][U][U][A] =  1.800;
 int22_ar[C][G][G][C][G][A][U][A] =  2.000;
 int22_ar[C][G][G][C][G][C][U][A] =  2.000;
 int22_ar[C][G][G][C][G][G][U][A] =  2.000;
 int22_ar[C][G][G][C][G][U][U][A] =  2.000;
 int22_ar[C][G][G][C][U][A][U][A] =  2.000;
 int22_ar[C][G][G][C][U][C][U][A] =  2.000;
 int22_ar[C][G][G][C][U][G][U][A] =  2.400;
 int22_ar[C][G][G][C][U][U][U][A] =  1.800;
 int22_ar[C][G][G][G][A][A][U][A] =  0.000;
 int22_ar[C][G][G][G][A][C][U][A] =  2.000;
 int22_ar[C][G][G][G][A][G][U][A] =  0.700;
 int22_ar[C][G][G][G][A][U][U][A] =  1.600;
 int22_ar[C][G][G][G][C][A][U][A] =  2.000;
 int22_ar[C][G][G][G][C][C][U][A] =  2.000;
 int22_ar[C][G][G][G][C][G][U][A] =  2.000;
 int22_ar[C][G][G][G][C][U][U][A] =  2.000;
 int22_ar[C][G][G][G][G][A][U][A] =  0.400;
 int22_ar[C][G][G][G][G][C][U][A] =  2.000;
 int22_ar[C][G][G][G][G][G][U][A] =  1.100;
 int22_ar[C][G][G][G][G][U][U][A] =  1.200;
 int22_ar[C][G][G][G][U][A][U][A] =  0.000;
 int22_ar[C][G][G][G][U][C][U][A] =  2.000;
 int22_ar[C][G][G][G][U][G][U][A] =  0.000;
 int22_ar[C][G][G][G][U][U][U][A] = -2.000;
 int22_ar[C][G][G][U][A][A][U][A] =  2.000;
 int22_ar[C][G][G][U][A][C][U][A] =  2.000;
 int22_ar[C][G][G][U][A][G][U][A] =  2.000;
 int22_ar[C][G][G][U][A][U][U][A] =  2.000;
 int22_ar[C][G][G][U][C][A][U][A] =  1.700;
 int22_ar[C][G][G][U][C][C][U][A] =  2.000;
 int22_ar[C][G][G][U][C][G][U][A] =  2.100;
 int22_ar[C][G][G][U][C][U][U][A] =  1.500;
 int22_ar[C][G][G][U][G][A][U][A] =  1.300;
 int22_ar[C][G][G][U][G][C][U][A] =  2.000;
 int22_ar[C][G][G][U][G][G][U][A] =  1.200;
 int22_ar[C][G][G][U][G][U][U][A] = -0.700;
 int22_ar[C][G][G][U][U][A][U][A] =  2.000;
 int22_ar[C][G][G][U][U][C][U][A] =  2.000;
 int22_ar[C][G][G][U][U][G][U][A] =  1.900;
 int22_ar[C][G][G][U][U][U][U][A] =  1.800;
 int22_ar[C][G][U][A][A][A][U][A] =  2.000;
 int22_ar[C][G][U][A][A][C][U][A] =  2.700;
 int22_ar[C][G][U][A][A][G][U][A] =  0.300;
 int22_ar[C][G][U][A][A][U][U][A] =  2.200;
 int22_ar[C][G][U][A][C][A][U][A] =  2.000;
 int22_ar[C][G][U][A][C][C][U][A] =  1.600;
 int22_ar[C][G][U][A][C][G][U][A] = -1.100;
 int22_ar[C][G][U][A][C][U][U][A] =  0.700;
 int22_ar[C][G][U][A][G][A][U][A] =  2.000;
 int22_ar[C][G][U][A][G][C][U][A] =  2.000;
 int22_ar[C][G][U][A][G][G][U][A] =  0.100;
 int22_ar[C][G][U][A][G][U][U][A] =  1.900;
 int22_ar[C][G][U][A][U][A][U][A] =  2.000;
 int22_ar[C][G][U][A][U][C][U][A] =  2.000;
 int22_ar[C][G][U][A][U][G][U][A] =  2.000;
 int22_ar[C][G][U][A][U][U][U][A] =  2.000;
 int22_ar[C][G][U][C][A][A][U][A] =  2.000;
 int22_ar[C][G][U][C][A][C][U][A] =  2.100;
 int22_ar[C][G][U][C][A][G][U][A] = -0.700;
 int22_ar[C][G][U][C][A][U][U][A] =  1.200;
 int22_ar[C][G][U][C][C][A][U][A] =  2.000;
 int22_ar[C][G][U][C][C][C][U][A] =  2.100;
 int22_ar[C][G][U][C][C][G][U][A] =  0.300;
 int22_ar[C][G][U][C][C][U][U][A] =  1.200;
 int22_ar[C][G][U][C][G][A][U][A] =  2.000;
 int22_ar[C][G][U][C][G][C][U][A] =  2.000;
 int22_ar[C][G][U][C][G][G][U][A] =  2.000;
 int22_ar[C][G][U][C][G][U][U][A] =  2.000;
 int22_ar[C][G][U][C][U][A][U][A] =  2.000;
 int22_ar[C][G][U][C][U][C][U][A] =  2.100;
 int22_ar[C][G][U][C][U][G][U][A] =  0.300;
 int22_ar[C][G][U][C][U][U][U][A] =  1.200;
 int22_ar[C][G][U][G][A][A][U][A] =  2.000;
 int22_ar[C][G][U][G][A][C][U][A] =  2.000;
 int22_ar[C][G][U][G][A][G][U][A] =  0.100;
 int22_ar[C][G][U][G][A][U][U][A] =  1.900;
 int22_ar[C][G][U][G][C][A][U][A] =  2.000;
 int22_ar[C][G][U][G][C][C][U][A] =  2.000;
 int22_ar[C][G][U][G][C][G][U][A] =  2.000;
 int22_ar[C][G][U][G][C][U][U][A] =  2.000;
 int22_ar[C][G][U][G][G][A][U][A] =  2.000;
 int22_ar[C][G][U][G][G][C][U][A] =  2.000;
 int22_ar[C][G][U][G][G][G][U][A] = -0.300;
 int22_ar[C][G][U][G][G][U][U][A] =  1.500;
 int22_ar[C][G][U][G][U][A][U][A] =  2.000;
 int22_ar[C][G][U][G][U][C][U][A] =  0.300;
 int22_ar[C][G][U][G][U][G][U][A] = -3.500;
 int22_ar[C][G][U][G][U][U][U][A] =  0.200;
 int22_ar[C][G][U][U][A][A][U][A] =  2.000;
 int22_ar[C][G][U][U][A][C][U][A] =  2.000;
 int22_ar[C][G][U][U][A][G][U][A] =  2.000;
 int22_ar[C][G][U][U][A][U][U][A] =  2.000;
 int22_ar[C][G][U][U][C][A][U][A] =  2.000;
 int22_ar[C][G][U][U][C][C][U][A] =  1.800;
 int22_ar[C][G][U][U][C][G][U][A] =  0.000;
 int22_ar[C][G][U][U][C][U][U][A] =  0.900;
 int22_ar[C][G][U][U][G][A][U][A] =  2.000;
 int22_ar[C][G][U][U][G][C][U][A] =  1.500;
 int22_ar[C][G][U][U][G][G][U][A] = -2.200;
 int22_ar[C][G][U][U][G][U][U][A] =  1.500;
 int22_ar[C][G][U][U][U][A][U][A] =  2.000;
 int22_ar[C][G][U][U][U][C][U][A] =  1.200;
 int22_ar[C][G][U][U][U][G][U][A] =  0.300;
 int22_ar[C][G][U][U][U][U][U][A] =  0.300;
 int22_ar[C][G][A][A][A][A][U][G] =  2.000;
 int22_ar[C][G][A][A][A][C][U][G] =  2.400;
 int22_ar[C][G][A][A][A][G][U][G] =  1.000;
 int22_ar[C][G][A][A][A][U][U][G] =  2.000;
 int22_ar[C][G][A][A][C][A][U][G] =  1.600;
 int22_ar[C][G][A][A][C][C][U][G] =  1.900;
 int22_ar[C][G][A][A][C][G][U][G] =  0.600;
 int22_ar[C][G][A][A][C][U][U][G] =  2.000;
 int22_ar[C][G][A][A][G][A][U][G] =  1.000;
 int22_ar[C][G][A][A][G][C][U][G] =  1.300;
 int22_ar[C][G][A][A][G][G][U][G] =  0.000;
 int22_ar[C][G][A][A][G][U][U][G] =  2.000;
 int22_ar[C][G][A][A][U][A][U][G] =  2.000;
 int22_ar[C][G][A][A][U][C][U][G] =  2.000;
 int22_ar[C][G][A][A][U][G][U][G] =  2.000;
 int22_ar[C][G][A][A][U][U][U][G] =  2.000;
 int22_ar[C][G][A][C][A][A][U][G] =  2.000;
 int22_ar[C][G][A][C][A][C][U][G] =  2.400;
 int22_ar[C][G][A][C][A][G][U][G] =  1.000;
 int22_ar[C][G][A][C][A][U][U][G] =  2.000;
 int22_ar[C][G][A][C][C][A][U][G] =  2.600;
 int22_ar[C][G][A][C][C][C][U][G] =  2.400;
 int22_ar[C][G][A][C][C][G][U][G] =  2.000;
 int22_ar[C][G][A][C][C][U][U][G] =  2.000;
 int22_ar[C][G][A][C][G][A][U][G] =  2.000;
 int22_ar[C][G][A][C][G][C][U][G] =  2.000;
 int22_ar[C][G][A][C][G][G][U][G] =  2.000;
 int22_ar[C][G][A][C][G][U][U][G] =  2.000;
 int22_ar[C][G][A][C][U][A][U][G] =  2.600;
 int22_ar[C][G][A][C][U][C][U][G] =  2.400;
 int22_ar[C][G][A][C][U][G][U][G] =  2.000;
 int22_ar[C][G][A][C][U][U][U][G] =  2.000;
 int22_ar[C][G][A][G][A][A][U][G] =  1.000;
 int22_ar[C][G][A][G][A][C][U][G] =  1.300;
 int22_ar[C][G][A][G][A][G][U][G] =  0.000;
 int22_ar[C][G][A][G][A][U][U][G] =  2.000;
 int22_ar[C][G][A][G][C][A][U][G] =  2.000;
 int22_ar[C][G][A][G][C][C][U][G] =  2.000;
 int22_ar[C][G][A][G][C][G][U][G] =  2.000;
 int22_ar[C][G][A][G][C][U][U][G] =  2.000;
 int22_ar[C][G][A][G][G][A][U][G] =  1.400;
 int22_ar[C][G][A][G][G][C][U][G] =  1.700;
 int22_ar[C][G][A][G][G][G][U][G] =  0.400;
 int22_ar[C][G][A][G][G][U][U][G] =  2.000;
 int22_ar[C][G][A][G][U][A][U][G] =  0.200;
 int22_ar[C][G][A][G][U][C][U][G] = -0.400;
 int22_ar[C][G][A][G][U][G][U][G] =  0.000;
 int22_ar[C][G][A][G][U][U][U][G] =  2.000;
 int22_ar[C][G][A][U][A][A][U][G] =  2.000;
 int22_ar[C][G][A][U][A][C][U][G] =  2.000;
 int22_ar[C][G][A][U][A][G][U][G] =  2.000;
 int22_ar[C][G][A][U][A][U][U][G] =  2.000;
 int22_ar[C][G][A][U][C][A][U][G] =  2.300;
 int22_ar[C][G][A][U][C][C][U][G] =  2.100;
 int22_ar[C][G][A][U][C][G][U][G] =  1.700;
 int22_ar[C][G][A][U][C][U][U][G] =  2.000;
 int22_ar[C][G][A][U][G][A][U][G] =  1.500;
 int22_ar[C][G][A][U][G][C][U][G] =  0.800;
 int22_ar[C][G][A][U][G][G][U][G] =  1.300;
 int22_ar[C][G][A][U][G][U][U][G] =  2.000;
 int22_ar[C][G][A][U][U][A][U][G] =  2.200;
 int22_ar[C][G][A][U][U][C][U][G] =  1.500;
 int22_ar[C][G][A][U][U][G][U][G] =  2.000;
 int22_ar[C][G][A][U][U][U][U][G] =  2.000;
 int22_ar[C][G][C][A][A][A][U][G] =  1.900;
 int22_ar[C][G][C][A][A][C][U][G] =  2.800;
 int22_ar[C][G][C][A][A][G][U][G] =  2.000;
 int22_ar[C][G][C][A][A][U][U][G] =  2.700;
 int22_ar[C][G][C][A][C][A][U][G] =  1.500;
 int22_ar[C][G][C][A][C][C][U][G] =  1.800;
 int22_ar[C][G][C][A][C][G][U][G] =  2.000;
 int22_ar[C][G][C][A][C][U][U][G] =  1.600;
 int22_ar[C][G][C][A][G][A][U][G] =  0.900;
 int22_ar[C][G][C][A][G][C][U][G] =  2.200;
 int22_ar[C][G][C][A][G][G][U][G] =  2.000;
 int22_ar[C][G][C][A][G][U][U][G] =  2.000;
 int22_ar[C][G][C][A][U][A][U][G] =  2.000;
 int22_ar[C][G][C][A][U][C][U][G] =  2.000;
 int22_ar[C][G][C][A][U][G][U][G] =  2.000;
 int22_ar[C][G][C][A][U][U][U][G] =  2.000;
 int22_ar[C][G][C][C][A][A][U][G] =  1.900;
 int22_ar[C][G][C][C][A][C][U][G] =  2.200;
 int22_ar[C][G][C][C][A][G][U][G] =  2.000;
 int22_ar[C][G][C][C][A][U][U][G] =  2.100;
 int22_ar[C][G][C][C][C][A][U][G] =  1.900;
 int22_ar[C][G][C][C][C][C][U][G] =  2.200;
 int22_ar[C][G][C][C][C][G][U][G] =  2.000;
 int22_ar[C][G][C][C][C][U][U][G] =  2.100;
 int22_ar[C][G][C][C][G][A][U][G] =  2.000;
 int22_ar[C][G][C][C][G][C][U][G] =  2.000;
 int22_ar[C][G][C][C][G][G][U][G] =  2.000;
 int22_ar[C][G][C][C][G][U][U][G] =  2.000;
 int22_ar[C][G][C][C][U][A][U][G] =  1.900;
 int22_ar[C][G][C][C][U][C][U][G] =  2.200;
 int22_ar[C][G][C][C][U][G][U][G] =  2.000;
 int22_ar[C][G][C][C][U][U][U][G] =  2.100;
 int22_ar[C][G][C][G][A][A][U][G] =  0.900;
 int22_ar[C][G][C][G][A][C][U][G] =  2.200;
 int22_ar[C][G][C][G][A][G][U][G] =  2.000;
 int22_ar[C][G][C][G][A][U][U][G] =  2.000;
 int22_ar[C][G][C][G][C][A][U][G] =  2.000;
 int22_ar[C][G][C][G][C][C][U][G] =  2.000;
 int22_ar[C][G][C][G][C][G][U][G] =  2.000;
 int22_ar[C][G][C][G][C][U][U][G] =  2.000;
 int22_ar[C][G][C][G][G][A][U][G] =  1.300;
 int22_ar[C][G][C][G][G][C][U][G] =  2.200;
 int22_ar[C][G][C][G][G][G][U][G] =  2.000;
 int22_ar[C][G][C][G][G][U][U][G] =  2.000;
 int22_ar[C][G][C][G][U][A][U][G] = -0.900;
 int22_ar[C][G][C][G][U][C][U][G] =  0.400;
 int22_ar[C][G][C][G][U][G][U][G] =  2.000;
 int22_ar[C][G][C][G][U][U][U][G] =  0.300;
 int22_ar[C][G][C][U][A][A][U][G] =  2.000;
 int22_ar[C][G][C][U][A][C][U][G] =  2.000;
 int22_ar[C][G][C][U][A][G][U][G] =  2.000;
 int22_ar[C][G][C][U][A][U][U][G] =  2.000;
 int22_ar[C][G][C][U][C][A][U][G] =  1.600;
 int22_ar[C][G][C][U][C][C][U][G] =  1.900;
 int22_ar[C][G][C][U][C][G][U][G] =  2.000;
 int22_ar[C][G][C][U][C][U][U][G] =  1.800;
 int22_ar[C][G][C][U][G][A][U][G] =  0.400;
 int22_ar[C][G][C][U][G][C][U][G] =  1.700;
 int22_ar[C][G][C][U][G][G][U][G] =  2.000;
 int22_ar[C][G][C][U][G][U][U][G] =  1.500;
 int22_ar[C][G][C][U][U][A][U][G] =  1.100;
 int22_ar[C][G][C][U][U][C][U][G] =  1.400;
 int22_ar[C][G][C][U][U][G][U][G] =  2.000;
 int22_ar[C][G][C][U][U][U][U][G] =  1.200;
 int22_ar[C][G][G][A][A][A][U][G] =  1.000;
 int22_ar[C][G][G][A][A][C][U][G] =  2.000;
 int22_ar[C][G][G][A][A][G][U][G] =  1.800;
 int22_ar[C][G][G][A][A][U][U][G] =  1.800;
 int22_ar[C][G][G][A][C][A][U][G] =  0.600;
 int22_ar[C][G][G][A][C][C][U][G] =  2.000;
 int22_ar[C][G][G][A][C][G][U][G] =  1.300;
 int22_ar[C][G][G][A][C][U][U][G] =  0.400;
 int22_ar[C][G][G][A][G][A][U][G] =  0.000;
 int22_ar[C][G][G][A][G][C][U][G] =  2.000;
 int22_ar[C][G][G][A][G][G][U][G] =  0.700;
 int22_ar[C][G][G][A][G][U][U][G] =  1.600;
 int22_ar[C][G][G][A][U][A][U][G] =  2.000;
 int22_ar[C][G][G][A][U][C][U][G] =  2.000;
 int22_ar[C][G][G][A][U][G][U][G] =  2.000;
 int22_ar[C][G][G][A][U][U][U][G] =  2.000;
 int22_ar[C][G][G][C][A][A][U][G] =  1.000;
 int22_ar[C][G][G][C][A][C][U][G] =  2.000;
 int22_ar[C][G][G][C][A][G][U][G] =  1.800;
 int22_ar[C][G][G][C][A][U][U][G] =  0.800;
 int22_ar[C][G][G][C][C][A][U][G] =  2.000;
 int22_ar[C][G][G][C][C][C][U][G] =  2.000;
 int22_ar[C][G][G][C][C][G][U][G] =  2.400;
 int22_ar[C][G][G][C][C][U][U][G] =  1.800;
 int22_ar[C][G][G][C][G][A][U][G] =  2.000;
 int22_ar[C][G][G][C][G][C][U][G] =  2.000;
 int22_ar[C][G][G][C][G][G][U][G] =  2.000;
 int22_ar[C][G][G][C][G][U][U][G] =  2.000;
 int22_ar[C][G][G][C][U][A][U][G] =  2.000;
 int22_ar[C][G][G][C][U][C][U][G] =  2.000;
 int22_ar[C][G][G][C][U][G][U][G] =  2.400;
 int22_ar[C][G][G][C][U][U][U][G] =  1.800;
 int22_ar[C][G][G][G][A][A][U][G] =  0.000;
 int22_ar[C][G][G][G][A][C][U][G] =  2.000;
 int22_ar[C][G][G][G][A][G][U][G] =  0.700;
 int22_ar[C][G][G][G][A][U][U][G] =  1.600;
 int22_ar[C][G][G][G][C][A][U][G] =  2.000;
 int22_ar[C][G][G][G][C][C][U][G] =  2.000;
 int22_ar[C][G][G][G][C][G][U][G] =  2.000;
 int22_ar[C][G][G][G][C][U][U][G] =  2.000;
 int22_ar[C][G][G][G][G][A][U][G] =  0.400;
 int22_ar[C][G][G][G][G][C][U][G] =  2.000;
 int22_ar[C][G][G][G][G][G][U][G] =  1.100;
 int22_ar[C][G][G][G][G][U][U][G] =  1.200;
 int22_ar[C][G][G][G][U][A][U][G] =  0.000;
 int22_ar[C][G][G][G][U][C][U][G] =  2.000;
 int22_ar[C][G][G][G][U][G][U][G] =  0.000;
 int22_ar[C][G][G][G][U][U][U][G] = -2.000;
 int22_ar[C][G][G][U][A][A][U][G] =  2.000;
 int22_ar[C][G][G][U][A][C][U][G] =  2.000;
 int22_ar[C][G][G][U][A][G][U][G] =  2.000;
 int22_ar[C][G][G][U][A][U][U][G] =  2.000;
 int22_ar[C][G][G][U][C][A][U][G] =  1.700;
 int22_ar[C][G][G][U][C][C][U][G] =  2.000;
 int22_ar[C][G][G][U][C][G][U][G] =  2.100;
 int22_ar[C][G][G][U][C][U][U][G] =  1.500;
 int22_ar[C][G][G][U][G][A][U][G] =  1.300;
 int22_ar[C][G][G][U][G][C][U][G] =  2.000;
 int22_ar[C][G][G][U][G][G][U][G] =  1.200;
 int22_ar[C][G][G][U][G][U][U][G] = -0.700;
 int22_ar[C][G][G][U][U][A][U][G] =  2.000;
 int22_ar[C][G][G][U][U][C][U][G] =  2.000;
 int22_ar[C][G][G][U][U][G][U][G] =  1.900;
 int22_ar[C][G][G][U][U][U][U][G] =  1.800;
 int22_ar[C][G][U][A][A][A][U][G] =  2.000;
 int22_ar[C][G][U][A][A][C][U][G] =  2.700;
 int22_ar[C][G][U][A][A][G][U][G] =  0.300;
 int22_ar[C][G][U][A][A][U][U][G] =  2.200;
 int22_ar[C][G][U][A][C][A][U][G] =  2.000;
 int22_ar[C][G][U][A][C][C][U][G] =  1.600;
 int22_ar[C][G][U][A][C][G][U][G] = -1.100;
 int22_ar[C][G][U][A][C][U][U][G] =  0.700;
 int22_ar[C][G][U][A][G][A][U][G] =  2.000;
 int22_ar[C][G][U][A][G][C][U][G] =  2.000;
 int22_ar[C][G][U][A][G][G][U][G] =  0.100;
 int22_ar[C][G][U][A][G][U][U][G] =  1.900;
 int22_ar[C][G][U][A][U][A][U][G] =  2.000;
 int22_ar[C][G][U][A][U][C][U][G] =  2.000;
 int22_ar[C][G][U][A][U][G][U][G] =  2.000;
 int22_ar[C][G][U][A][U][U][U][G] =  2.000;
 int22_ar[C][G][U][C][A][A][U][G] =  2.000;
 int22_ar[C][G][U][C][A][C][U][G] =  2.100;
 int22_ar[C][G][U][C][A][G][U][G] = -0.700;
 int22_ar[C][G][U][C][A][U][U][G] =  1.200;
 int22_ar[C][G][U][C][C][A][U][G] =  2.000;
 int22_ar[C][G][U][C][C][C][U][G] =  2.100;
 int22_ar[C][G][U][C][C][G][U][G] =  0.300;
 int22_ar[C][G][U][C][C][U][U][G] =  1.200;
 int22_ar[C][G][U][C][G][A][U][G] =  2.000;
 int22_ar[C][G][U][C][G][C][U][G] =  2.000;
 int22_ar[C][G][U][C][G][G][U][G] =  2.000;
 int22_ar[C][G][U][C][G][U][U][G] =  2.000;
 int22_ar[C][G][U][C][U][A][U][G] =  2.000;
 int22_ar[C][G][U][C][U][C][U][G] =  2.100;
 int22_ar[C][G][U][C][U][G][U][G] =  0.300;
 int22_ar[C][G][U][C][U][U][U][G] =  1.200;
 int22_ar[C][G][U][G][A][A][U][G] =  2.000;
 int22_ar[C][G][U][G][A][C][U][G] =  2.000;
 int22_ar[C][G][U][G][A][G][U][G] =  0.100;
 int22_ar[C][G][U][G][A][U][U][G] =  1.900;
 int22_ar[C][G][U][G][C][A][U][G] =  2.000;
 int22_ar[C][G][U][G][C][C][U][G] =  2.000;
 int22_ar[C][G][U][G][C][G][U][G] =  2.000;
 int22_ar[C][G][U][G][C][U][U][G] =  2.000;
 int22_ar[C][G][U][G][G][A][U][G] =  2.000;
 int22_ar[C][G][U][G][G][C][U][G] =  2.000;
 int22_ar[C][G][U][G][G][G][U][G] = -0.300;
 int22_ar[C][G][U][G][G][U][U][G] =  1.500;
 int22_ar[C][G][U][G][U][A][U][G] =  2.000;
 int22_ar[C][G][U][G][U][C][U][G] =  0.300;
 int22_ar[C][G][U][G][U][G][U][G] = -3.500;
 int22_ar[C][G][U][G][U][U][U][G] =  0.200;
 int22_ar[C][G][U][U][A][A][U][G] =  2.000;
 int22_ar[C][G][U][U][A][C][U][G] =  2.000;
 int22_ar[C][G][U][U][A][G][U][G] =  2.000;
 int22_ar[C][G][U][U][A][U][U][G] =  2.000;
 int22_ar[C][G][U][U][C][A][U][G] =  2.000;
 int22_ar[C][G][U][U][C][C][U][G] =  1.800;
 int22_ar[C][G][U][U][C][G][U][G] =  0.000;
 int22_ar[C][G][U][U][C][U][U][G] =  0.900;
 int22_ar[C][G][U][U][G][A][U][G] =  2.000;
 int22_ar[C][G][U][U][G][C][U][G] =  1.500;
 int22_ar[C][G][U][U][G][G][U][G] = -2.200;
 int22_ar[C][G][U][U][G][U][U][G] =  1.500;
 int22_ar[C][G][U][U][U][A][U][G] =  2.000;
 int22_ar[C][G][U][U][U][C][U][G] =  1.200;
 int22_ar[C][G][U][U][U][G][U][G] =  0.300;
 int22_ar[C][G][U][U][U][U][U][G] =  0.300;
 int22_ar[G][C][A][A][A][A][A][U] =  2.100;
 int22_ar[G][C][A][A][A][C][A][U] =  1.800;
 int22_ar[G][C][A][A][A][G][A][U] =  0.700;
 int22_ar[G][C][A][A][A][U][A][U] =  2.000;
 int22_ar[G][C][A][A][C][A][A][U] =  1.900;
 int22_ar[G][C][A][A][C][C][A][U] =  1.600;
 int22_ar[G][C][A][A][C][G][A][U] =  0.500;
 int22_ar[G][C][A][A][C][U][A][U] =  2.000;
 int22_ar[G][C][A][A][G][A][A][U] =  0.900;
 int22_ar[G][C][A][A][G][C][A][U] =  0.600;
 int22_ar[G][C][A][A][G][G][A][U] = -0.500;
 int22_ar[G][C][A][A][G][U][A][U] =  2.000;
 int22_ar[G][C][A][A][U][A][A][U] =  2.000;
 int22_ar[G][C][A][A][U][C][A][U] =  2.000;
 int22_ar[G][C][A][A][U][G][A][U] =  2.000;
 int22_ar[G][C][A][A][U][U][A][U] =  2.000;
 int22_ar[G][C][A][C][A][A][A][U] =  2.000;
 int22_ar[G][C][A][C][A][C][A][U] =  1.700;
 int22_ar[G][C][A][C][A][G][A][U] =  0.600;
 int22_ar[G][C][A][C][A][U][A][U] =  2.000;
 int22_ar[G][C][A][C][C][A][A][U] =  2.400;
 int22_ar[G][C][A][C][C][C][A][U] =  1.500;
 int22_ar[G][C][A][C][C][G][A][U] =  1.400;
 int22_ar[G][C][A][C][C][U][A][U] =  2.000;
 int22_ar[G][C][A][C][G][A][A][U] =  2.000;
 int22_ar[G][C][A][C][G][C][A][U] =  2.000;
 int22_ar[G][C][A][C][G][G][A][U] =  2.000;
 int22_ar[G][C][A][C][G][U][A][U] =  2.000;
 int22_ar[G][C][A][C][U][A][A][U] =  2.400;
 int22_ar[G][C][A][C][U][C][A][U] =  1.500;
 int22_ar[G][C][A][C][U][G][A][U] =  1.400;
 int22_ar[G][C][A][C][U][U][A][U] =  2.000;
 int22_ar[G][C][A][G][A][A][A][U] =  0.900;
 int22_ar[G][C][A][G][A][C][A][U] =  0.600;
 int22_ar[G][C][A][G][A][G][A][U] = -0.500;
 int22_ar[G][C][A][G][A][U][A][U] =  2.000;
 int22_ar[G][C][A][G][C][A][A][U] =  2.000;
 int22_ar[G][C][A][G][C][C][A][U] =  2.000;
 int22_ar[G][C][A][G][C][G][A][U] =  2.000;
 int22_ar[G][C][A][G][C][U][A][U] =  2.000;
 int22_ar[G][C][A][G][G][A][A][U] =  1.400;
 int22_ar[G][C][A][G][G][C][A][U] =  1.100;
 int22_ar[G][C][A][G][G][G][A][U] =  0.000;
 int22_ar[G][C][A][G][G][U][A][U] =  2.000;
 int22_ar[G][C][A][G][U][A][A][U] =  0.700;
 int22_ar[G][C][A][G][U][C][A][U] = -0.600;
 int22_ar[G][C][A][G][U][G][A][U] =  0.100;
 int22_ar[G][C][A][G][U][U][A][U] =  2.000;
 int22_ar[G][C][A][U][A][A][A][U] =  2.000;
 int22_ar[G][C][A][U][A][C][A][U] =  2.000;
 int22_ar[G][C][A][U][A][G][A][U] =  2.000;
 int22_ar[G][C][A][U][A][U][A][U] =  2.000;
 int22_ar[G][C][A][U][C][A][A][U] =  2.400;
 int22_ar[G][C][A][U][C][C][A][U] =  1.500;
 int22_ar[G][C][A][U][C][G][A][U] =  1.400;
 int22_ar[G][C][A][U][C][U][A][U] =  2.000;
 int22_ar[G][C][A][U][G][A][A][U] =  1.700;
 int22_ar[G][C][A][U][G][C][A][U] =  0.400;
 int22_ar[G][C][A][U][G][G][A][U] =  1.100;
 int22_ar[G][C][A][U][G][U][A][U] =  2.000;
 int22_ar[G][C][A][U][U][A][A][U] =  2.000;
 int22_ar[G][C][A][U][U][C][A][U] =  0.700;
 int22_ar[G][C][A][U][U][G][A][U] =  1.500;
 int22_ar[G][C][A][U][U][U][A][U] =  2.000;
 int22_ar[G][C][C][A][A][A][A][U] =  1.900;
 int22_ar[G][C][C][A][A][C][A][U] =  2.500;
 int22_ar[G][C][C][A][A][G][A][U] =  2.000;
 int22_ar[G][C][C][A][A][U][A][U] =  2.500;
 int22_ar[G][C][C][A][C][A][A][U] =  1.600;
 int22_ar[G][C][C][A][C][C][A][U] =  1.600;
 int22_ar[G][C][C][A][C][G][A][U] =  2.000;
 int22_ar[G][C][C][A][C][U][A][U] =  1.700;
 int22_ar[G][C][C][A][G][A][A][U] =  0.600;
 int22_ar[G][C][C][A][G][C][A][U] =  1.600;
 int22_ar[G][C][C][A][G][G][A][U] =  2.000;
 int22_ar[G][C][C][A][G][U][A][U] =  1.700;
 int22_ar[G][C][C][A][U][A][A][U] =  2.000;
 int22_ar[G][C][C][A][U][C][A][U] =  2.000;
 int22_ar[G][C][C][A][U][G][A][U] =  2.000;
 int22_ar[G][C][C][A][U][U][A][U] =  2.000;
 int22_ar[G][C][C][C][A][A][A][U] =  1.700;
 int22_ar[G][C][C][C][A][C][A][U] =  1.700;
 int22_ar[G][C][C][C][A][G][A][U] =  2.000;
 int22_ar[G][C][C][C][A][U][A][U] =  1.800;
 int22_ar[G][C][C][C][C][A][A][U] =  1.600;
 int22_ar[G][C][C][C][C][C][A][U] =  1.600;
 int22_ar[G][C][C][C][C][G][A][U] =  2.000;
 int22_ar[G][C][C][C][C][U][A][U] =  1.600;
 int22_ar[G][C][C][C][G][A][A][U] =  2.000;
 int22_ar[G][C][C][C][G][C][A][U] =  2.000;
 int22_ar[G][C][C][C][G][G][A][U] =  2.000;
 int22_ar[G][C][C][C][G][U][A][U] =  2.000;
 int22_ar[G][C][C][C][U][A][A][U] =  1.600;
 int22_ar[G][C][C][C][U][C][A][U] =  1.600;
 int22_ar[G][C][C][C][U][G][A][U] =  2.000;
 int22_ar[G][C][C][C][U][U][A][U] =  1.600;
 int22_ar[G][C][C][G][A][A][A][U] =  0.600;
 int22_ar[G][C][C][G][A][C][A][U] =  1.600;
 int22_ar[G][C][C][G][A][G][A][U] =  2.000;
 int22_ar[G][C][C][G][A][U][A][U] =  1.700;
 int22_ar[G][C][C][G][C][A][A][U] =  2.000;
 int22_ar[G][C][C][G][C][C][A][U] =  2.000;
 int22_ar[G][C][C][G][C][G][A][U] =  2.000;
 int22_ar[G][C][C][G][C][U][A][U] =  2.000;
 int22_ar[G][C][C][G][G][A][A][U] =  1.200;
 int22_ar[G][C][C][G][G][C][A][U] =  1.800;
 int22_ar[G][C][C][G][G][G][A][U] =  2.000;
 int22_ar[G][C][C][G][G][U][A][U] =  1.800;
 int22_ar[G][C][C][G][U][A][A][U] = -0.500;
 int22_ar[G][C][C][G][U][C][A][U] =  0.500;
 int22_ar[G][C][C][G][U][G][A][U] =  2.000;
 int22_ar[G][C][C][G][U][U][A][U] =  0.500;
 int22_ar[G][C][C][U][A][A][A][U] =  2.000;
 int22_ar[G][C][C][U][A][C][A][U] =  2.000;
 int22_ar[G][C][C][U][A][G][A][U] =  2.000;
 int22_ar[G][C][C][U][A][U][A][U] =  2.000;
 int22_ar[G][C][C][U][C][A][A][U] =  1.600;
 int22_ar[G][C][C][U][C][C][A][U] =  1.600;
 int22_ar[G][C][C][U][C][G][A][U] =  2.000;
 int22_ar[G][C][C][U][C][U][A][U] =  1.600;
 int22_ar[G][C][C][U][G][A][A][U] =  0.400;
 int22_ar[G][C][C][U][G][C][A][U] =  1.400;
 int22_ar[G][C][C][U][G][G][A][U] =  2.000;
 int22_ar[G][C][C][U][G][U][A][U] =  1.500;
 int22_ar[G][C][C][U][U][A][A][U] =  0.800;
 int22_ar[G][C][C][U][U][C][A][U] =  0.800;
 int22_ar[G][C][C][U][U][G][A][U] =  2.000;
 int22_ar[G][C][C][U][U][U][A][U] =  0.800;
 int22_ar[G][C][G][A][A][A][A][U] =  0.100;
 int22_ar[G][C][G][A][A][C][A][U] =  2.000;
 int22_ar[G][C][G][A][A][G][A][U] =  1.800;
 int22_ar[G][C][G][A][A][U][A][U] =  0.400;
 int22_ar[G][C][G][A][C][A][A][U] = -0.100;
 int22_ar[G][C][G][A][C][C][A][U] =  2.000;
 int22_ar[G][C][G][A][C][G][A][U] =  1.500;
 int22_ar[G][C][G][A][C][U][A][U] = -0.900;
 int22_ar[G][C][G][A][G][A][A][U] = -1.100;
 int22_ar[G][C][G][A][G][C][A][U] =  2.000;
 int22_ar[G][C][G][A][G][G][A][U] =  0.500;
 int22_ar[G][C][G][A][G][U][A][U] = -0.100;
 int22_ar[G][C][G][A][U][A][A][U] =  2.000;
 int22_ar[G][C][G][A][U][C][A][U] =  2.000;
 int22_ar[G][C][G][A][U][G][A][U] =  2.000;
 int22_ar[G][C][G][A][U][U][A][U] =  2.000;
 int22_ar[G][C][G][C][A][A][A][U] =  0.000;
 int22_ar[G][C][G][C][A][C][A][U] =  2.000;
 int22_ar[G][C][G][C][A][G][A][U] =  1.600;
 int22_ar[G][C][G][C][A][U][A][U] = -0.800;
 int22_ar[G][C][G][C][C][A][A][U] =  0.800;
 int22_ar[G][C][G][C][C][C][A][U] =  2.000;
 int22_ar[G][C][G][C][C][G][A][U] =  2.100;
 int22_ar[G][C][G][C][C][U][A][U] =  0.100;
 int22_ar[G][C][G][C][G][A][A][U] =  2.000;
 int22_ar[G][C][G][C][G][C][A][U] =  2.000;
 int22_ar[G][C][G][C][G][G][A][U] =  2.000;
 int22_ar[G][C][G][C][G][U][A][U] =  2.000;
 int22_ar[G][C][G][C][U][A][A][U] =  0.800;
 int22_ar[G][C][G][C][U][C][A][U] =  2.000;
 int22_ar[G][C][G][C][U][G][A][U] =  2.100;
 int22_ar[G][C][G][C][U][U][A][U] =  0.100;
 int22_ar[G][C][G][G][A][A][A][U] = -1.100;
 int22_ar[G][C][G][G][A][C][A][U] =  2.000;
 int22_ar[G][C][G][G][A][G][A][U] =  0.500;
 int22_ar[G][C][G][G][A][U][A][U] = -0.100;
 int22_ar[G][C][G][G][C][A][A][U] =  2.000;
 int22_ar[G][C][G][G][C][C][A][U] =  2.000;
 int22_ar[G][C][G][G][C][G][A][U] =  2.000;
 int22_ar[G][C][G][G][C][U][A][U] =  2.000;
 int22_ar[G][C][G][G][G][A][A][U] = -0.600;
 int22_ar[G][C][G][G][G][C][A][U] =  2.000;
 int22_ar[G][C][G][G][G][G][A][U] =  1.100;
 int22_ar[G][C][G][G][G][U][A][U] = -0.300;
 int22_ar[G][C][G][G][U][A][A][U] = -0.500;
 int22_ar[G][C][G][G][U][C][A][U] =  2.000;
 int22_ar[G][C][G][G][U][G][A][U] =  0.400;
 int22_ar[G][C][G][G][U][U][A][U] = -3.100;
 int22_ar[G][C][G][U][A][A][A][U] =  2.000;
 int22_ar[G][C][G][U][A][C][A][U] =  2.000;
 int22_ar[G][C][G][U][A][G][A][U] =  2.000;
 int22_ar[G][C][G][U][A][U][A][U] =  2.000;
 int22_ar[G][C][G][U][C][A][A][U] =  0.800;
 int22_ar[G][C][G][U][C][C][A][U] =  2.000;
 int22_ar[G][C][G][U][C][G][A][U] =  2.100;
 int22_ar[G][C][G][U][C][U][A][U] =  0.100;
 int22_ar[G][C][G][U][G][A][A][U] =  0.500;
 int22_ar[G][C][G][U][G][C][A][U] =  2.000;
 int22_ar[G][C][G][U][G][G][A][U] =  1.300;
 int22_ar[G][C][G][U][G][U][A][U] = -2.100;
 int22_ar[G][C][G][U][U][A][A][U] =  0.800;
 int22_ar[G][C][G][U][U][C][A][U] =  2.000;
 int22_ar[G][C][G][U][U][G][A][U] =  1.700;
 int22_ar[G][C][G][U][U][U][A][U] =  0.100;
 int22_ar[G][C][U][A][A][A][A][U] =  2.000;
 int22_ar[G][C][U][A][A][C][A][U] =  1.500;
 int22_ar[G][C][U][A][A][G][A][U] =  0.000;
 int22_ar[G][C][U][A][A][U][A][U] =  2.100;
 int22_ar[G][C][U][A][C][A][A][U] =  2.000;
 int22_ar[G][C][U][A][C][C][A][U] =  0.600;
 int22_ar[G][C][U][A][C][G][A][U] = -1.300;
 int22_ar[G][C][U][A][C][U][A][U] =  0.900;
 int22_ar[G][C][U][A][G][A][A][U] =  2.000;
 int22_ar[G][C][U][A][G][C][A][U] =  0.700;
 int22_ar[G][C][U][A][G][G][A][U] = -0.500;
 int22_ar[G][C][U][A][G][U][A][U] =  1.700;
 int22_ar[G][C][U][A][U][A][A][U] =  2.000;
 int22_ar[G][C][U][A][U][C][A][U] =  2.000;
 int22_ar[G][C][U][A][U][G][A][U] =  2.000;
 int22_ar[G][C][U][A][U][U][A][U] =  2.000;
 int22_ar[G][C][U][C][A][A][A][U] =  2.000;
 int22_ar[G][C][U][C][A][C][A][U] =  0.700;
 int22_ar[G][C][U][C][A][G][A][U] = -1.200;
 int22_ar[G][C][U][C][A][U][A][U] =  1.000;
 int22_ar[G][C][U][C][C][A][A][U] =  2.000;
 int22_ar[G][C][U][C][C][C][A][U] =  0.600;
 int22_ar[G][C][U][C][C][G][A][U] = -0.300;
 int22_ar[G][C][U][C][C][U][A][U] =  0.800;
 int22_ar[G][C][U][C][G][A][A][U] =  2.000;
 int22_ar[G][C][U][C][G][C][A][U] =  2.000;
 int22_ar[G][C][U][C][G][G][A][U] =  2.000;
 int22_ar[G][C][U][C][G][U][A][U] =  2.000;
 int22_ar[G][C][U][C][U][A][A][U] =  2.000;
 int22_ar[G][C][U][C][U][C][A][U] =  0.600;
 int22_ar[G][C][U][C][U][G][A][U] = -0.300;
 int22_ar[G][C][U][C][U][U][A][U] =  0.800;
 int22_ar[G][C][U][G][A][A][A][U] =  2.000;
 int22_ar[G][C][U][G][A][C][A][U] =  0.700;
 int22_ar[G][C][U][G][A][G][A][U] = -0.500;
 int22_ar[G][C][U][G][A][U][A][U] =  1.700;
 int22_ar[G][C][U][G][C][A][A][U] =  2.000;
 int22_ar[G][C][U][G][C][C][A][U] =  2.000;
 int22_ar[G][C][U][G][C][G][A][U] =  2.000;
 int22_ar[G][C][U][G][C][U][A][U] =  2.000;
 int22_ar[G][C][U][G][G][A][A][U] =  2.000;
 int22_ar[G][C][U][G][G][C][A][U] =  0.800;
 int22_ar[G][C][U][G][G][G][A][U] = -0.700;
 int22_ar[G][C][U][G][G][U][A][U] =  1.400;
 int22_ar[G][C][U][G][U][A][A][U] =  2.000;
 int22_ar[G][C][U][G][U][C][A][U] = -0.500;
 int22_ar[G][C][U][G][U][G][A][U] = -3.500;
 int22_ar[G][C][U][G][U][U][A][U] =  0.500;
 int22_ar[G][C][U][U][A][A][A][U] =  2.000;
 int22_ar[G][C][U][U][A][C][A][U] =  2.000;
 int22_ar[G][C][U][U][A][G][A][U] =  2.000;
 int22_ar[G][C][U][U][A][U][A][U] =  2.000;
 int22_ar[G][C][U][U][C][A][A][U] =  2.000;
 int22_ar[G][C][U][U][C][C][A][U] =  0.600;
 int22_ar[G][C][U][U][C][G][A][U] = -0.300;
 int22_ar[G][C][U][U][C][U][A][U] =  0.800;
 int22_ar[G][C][U][U][G][A][A][U] =  2.000;
 int22_ar[G][C][U][U][G][C][A][U] =  0.500;
 int22_ar[G][C][U][U][G][G][A][U] = -2.500;
 int22_ar[G][C][U][U][G][U][A][U] =  1.500;
 int22_ar[G][C][U][U][U][A][A][U] =  2.000;
 int22_ar[G][C][U][U][U][C][A][U] = -0.200;
 int22_ar[G][C][U][U][U][G][A][U] = -0.300;
 int22_ar[G][C][U][U][U][U][A][U] =  0.000;
 int22_ar[G][C][A][A][A][A][C][G] =  0.500;
 int22_ar[G][C][A][A][A][C][C][G] =  1.100;
 int22_ar[G][C][A][A][A][G][C][G] =  0.400;
 int22_ar[G][C][A][A][A][U][C][G] =  2.000;
 int22_ar[G][C][A][A][C][A][C][G] =  1.300;
 int22_ar[G][C][A][A][C][C][C][G] =  1.000;
 int22_ar[G][C][A][A][C][G][C][G] =  0.700;
 int22_ar[G][C][A][A][C][U][C][G] =  2.000;
 int22_ar[G][C][A][A][G][A][C][G] = -0.200;
 int22_ar[G][C][A][A][G][C][C][G] =  0.700;
 int22_ar[G][C][A][A][G][G][C][G] = -0.500;
 int22_ar[G][C][A][A][G][U][C][G] =  2.000;
 int22_ar[G][C][A][A][U][A][C][G] =  2.000;
 int22_ar[G][C][A][A][U][C][C][G] =  2.000;
 int22_ar[G][C][A][A][U][G][C][G] =  2.000;
 int22_ar[G][C][A][A][U][U][C][G] =  2.000;
 int22_ar[G][C][A][C][A][A][C][G] =  0.600;
 int22_ar[G][C][A][C][A][C][C][G] =  1.100;
 int22_ar[G][C][A][C][A][G][C][G] =  0.500;
 int22_ar[G][C][A][C][A][U][C][G] =  2.000;
 int22_ar[G][C][A][C][C][A][C][G] =  2.200;
 int22_ar[G][C][A][C][C][C][C][G] =  1.900;
 int22_ar[G][C][A][C][C][G][C][G] =  0.700;
 int22_ar[G][C][A][C][C][U][C][G] =  2.000;
 int22_ar[G][C][A][C][G][A][C][G] =  2.000;
 int22_ar[G][C][A][C][G][C][C][G] =  2.000;
 int22_ar[G][C][A][C][G][G][C][G] =  2.000;
 int22_ar[G][C][A][C][G][U][C][G] =  2.000;
 int22_ar[G][C][A][C][U][A][C][G] =  2.000;
 int22_ar[G][C][A][C][U][C][C][G] =  1.100;
 int22_ar[G][C][A][C][U][G][C][G] =  0.500;
 int22_ar[G][C][A][C][U][U][C][G] =  2.000;
 int22_ar[G][C][A][G][A][A][C][G] =  0.000;
 int22_ar[G][C][A][G][A][C][C][G] = -1.000;
 int22_ar[G][C][A][G][A][G][C][G] = -0.700;
 int22_ar[G][C][A][G][A][U][C][G] =  2.000;
 int22_ar[G][C][A][G][C][A][C][G] =  2.000;
 int22_ar[G][C][A][G][C][C][C][G] =  2.000;
 int22_ar[G][C][A][G][C][G][C][G] =  2.000;
 int22_ar[G][C][A][G][C][U][C][G] =  2.000;
 int22_ar[G][C][A][G][G][A][C][G] =  1.100;
 int22_ar[G][C][A][G][G][C][C][G] =  0.800;
 int22_ar[G][C][A][G][G][G][C][G] = -0.200;
 int22_ar[G][C][A][G][G][U][C][G] =  2.000;
 int22_ar[G][C][A][G][U][A][C][G] = -0.100;
 int22_ar[G][C][A][G][U][C][C][G] = -1.600;
 int22_ar[G][C][A][G][U][G][C][G] = -0.600;
 int22_ar[G][C][A][G][U][U][C][G] =  2.000;
 int22_ar[G][C][A][U][A][A][C][G] =  2.000;
 int22_ar[G][C][A][U][A][C][C][G] =  2.000;
 int22_ar[G][C][A][U][A][G][C][G] =  2.000;
 int22_ar[G][C][A][U][A][U][C][G] =  2.000;
 int22_ar[G][C][A][U][C][A][C][G] =  2.000;
 int22_ar[G][C][A][U][C][C][C][G] =  1.100;
 int22_ar[G][C][A][U][C][G][C][G] =  1.000;
 int22_ar[G][C][A][U][C][U][C][G] =  2.000;
 int22_ar[G][C][A][U][G][A][C][G] =  0.900;
 int22_ar[G][C][A][U][G][C][C][G] = -0.100;
 int22_ar[G][C][A][U][G][G][C][G] =  0.600;
 int22_ar[G][C][A][U][G][U][C][G] =  2.000;
 int22_ar[G][C][A][U][U][A][C][G] =  1.400;
 int22_ar[G][C][A][U][U][C][C][G] =  0.300;
 int22_ar[G][C][A][U][U][G][C][G] =  1.400;
 int22_ar[G][C][A][U][U][U][C][G] =  2.000;
 int22_ar[G][C][C][A][A][A][C][G] =  1.100;
 int22_ar[G][C][C][A][A][C][C][G] =  1.700;
 int22_ar[G][C][C][A][A][G][C][G] =  2.000;
 int22_ar[G][C][C][A][A][U][C][G] =  1.800;
 int22_ar[G][C][C][A][C][A][C][G] =  1.000;
 int22_ar[G][C][C][A][C][C][C][G] =  1.000;
 int22_ar[G][C][C][A][C][G][C][G] =  2.000;
 int22_ar[G][C][C][A][C][U][C][G] =  1.100;
 int22_ar[G][C][C][A][G][A][C][G] = -0.400;
 int22_ar[G][C][C][A][G][C][C][G] =  1.100;
 int22_ar[G][C][C][A][G][G][C][G] =  2.000;
 int22_ar[G][C][C][A][G][U][C][G] =  1.200;
 int22_ar[G][C][C][A][U][A][C][G] =  2.000;
 int22_ar[G][C][C][A][U][C][C][G] =  2.000;
 int22_ar[G][C][C][A][U][G][C][G] =  2.000;
 int22_ar[G][C][C][A][U][U][C][G] =  2.000;
 int22_ar[G][C][C][C][A][A][C][G] =  1.500;
 int22_ar[G][C][C][C][A][C][C][G] =  1.500;
 int22_ar[G][C][C][C][A][G][C][G] =  2.000;
 int22_ar[G][C][C][C][A][U][C][G] =  1.500;
 int22_ar[G][C][C][C][C][A][C][G] =  1.300;
 int22_ar[G][C][C][C][C][C][C][G] =  1.300;
 int22_ar[G][C][C][C][C][G][C][G] =  2.000;
 int22_ar[G][C][C][C][C][U][C][G] =  1.400;
 int22_ar[G][C][C][C][G][A][C][G] =  2.000;
 int22_ar[G][C][C][C][G][C][C][G] =  2.000;
 int22_ar[G][C][C][C][G][G][C][G] =  2.000;
 int22_ar[G][C][C][C][G][U][C][G] =  2.000;
 int22_ar[G][C][C][C][U][A][C][G] =  1.200;
 int22_ar[G][C][C][C][U][C][C][G] =  1.200;
 int22_ar[G][C][C][C][U][G][C][G] =  2.000;
 int22_ar[G][C][C][C][U][U][C][G] =  1.200;
 int22_ar[G][C][C][G][A][A][C][G] = -0.700;
 int22_ar[G][C][C][G][A][C][C][G] = -0.600;
 int22_ar[G][C][C][G][A][G][C][G] =  2.000;
 int22_ar[G][C][C][G][A][U][C][G] =  1.200;
 int22_ar[G][C][C][G][C][A][C][G] =  2.000;
 int22_ar[G][C][C][G][C][C][C][G] =  2.000;
 int22_ar[G][C][C][G][C][G][C][G] =  2.000;
 int22_ar[G][C][C][G][C][U][C][G] =  2.000;
 int22_ar[G][C][C][G][G][A][C][G] =  0.900;
 int22_ar[G][C][C][G][G][C][C][G] =  1.500;
 int22_ar[G][C][C][G][G][G][C][G] =  2.000;
 int22_ar[G][C][C][G][G][U][C][G] =  1.500;
 int22_ar[G][C][C][G][U][A][C][G] = -1.600;
 int22_ar[G][C][C][G][U][C][C][G] = -0.600;
 int22_ar[G][C][C][G][U][G][C][G] =  2.000;
 int22_ar[G][C][C][G][U][U][C][G] = -0.500;
 int22_ar[G][C][C][U][A][A][C][G] =  2.000;
 int22_ar[G][C][C][U][A][C][C][G] =  2.000;
 int22_ar[G][C][C][U][A][G][C][G] =  2.000;
 int22_ar[G][C][C][U][A][U][C][G] =  2.000;
 int22_ar[G][C][C][U][C][A][C][G] =  1.200;
 int22_ar[G][C][C][U][C][C][C][G] =  1.200;
 int22_ar[G][C][C][U][C][G][C][G] =  2.000;
 int22_ar[G][C][C][U][C][U][C][G] =  1.200;
 int22_ar[G][C][C][U][G][A][C][G] =  0.000;
 int22_ar[G][C][C][U][G][C][C][G] =  1.000;
 int22_ar[G][C][C][U][G][G][C][G] =  2.000;
 int22_ar[G][C][C][U][G][U][C][G] =  1.000;
 int22_ar[G][C][C][U][U][A][C][G] =  0.300;
 int22_ar[G][C][C][U][U][C][C][G] =  0.300;
 int22_ar[G][C][C][U][U][G][C][G] =  2.000;
 int22_ar[G][C][C][U][U][U][C][G] =  0.300;
 int22_ar[G][C][G][A][A][A][C][G] = -0.300;
 int22_ar[G][C][G][A][A][C][C][G] =  2.000;
 int22_ar[G][C][G][A][A][G][C][G] =  1.000;
 int22_ar[G][C][G][A][A][U][C][G] = -0.500;
 int22_ar[G][C][G][A][C][A][C][G] = -0.700;
 int22_ar[G][C][G][A][C][C][C][G] =  2.000;
 int22_ar[G][C][G][A][C][G][C][G] =  0.900;
 int22_ar[G][C][G][A][C][U][C][G] = -1.500;
 int22_ar[G][C][G][A][G][A][C][G] = -1.700;
 int22_ar[G][C][G][A][G][C][C][G] =  2.000;
 int22_ar[G][C][G][A][G][G][C][G] =  0.000;
 int22_ar[G][C][G][A][G][U][C][G] = -1.300;
 int22_ar[G][C][G][A][U][A][C][G] =  2.000;
 int22_ar[G][C][G][A][U][C][C][G] =  2.000;
 int22_ar[G][C][G][A][U][G][C][G] =  2.000;
 int22_ar[G][C][G][A][U][U][C][G] =  2.000;
 int22_ar[G][C][G][C][A][A][C][G] =  0.100;
 int22_ar[G][C][G][C][A][C][C][G] =  2.000;
 int22_ar[G][C][G][C][A][G][C][G] =  1.400;
 int22_ar[G][C][G][C][A][U][C][G] = -0.600;
 int22_ar[G][C][G][C][C][A][C][G] =  0.700;
 int22_ar[G][C][G][C][C][C][C][G] =  2.000;
 int22_ar[G][C][G][C][C][G][C][G] =  1.800;
 int22_ar[G][C][G][C][C][U][C][G] = -0.200;
 int22_ar[G][C][G][C][G][A][C][G] =  2.000;
 int22_ar[G][C][G][C][G][C][C][G] =  2.000;
 int22_ar[G][C][G][C][G][G][C][G] =  2.000;
 int22_ar[G][C][G][C][G][U][C][G] =  2.000;
 int22_ar[G][C][G][C][U][A][C][G] =  0.400;
 int22_ar[G][C][G][C][U][C][C][G] =  2.000;
 int22_ar[G][C][G][C][U][G][C][G] =  1.700;
 int22_ar[G][C][G][C][U][U][C][G] = -0.100;
 int22_ar[G][C][G][G][A][A][C][G] = -1.600;
 int22_ar[G][C][G][G][A][C][C][G] =  2.000;
 int22_ar[G][C][G][G][A][G][C][G] =  0.000;
 int22_ar[G][C][G][G][A][U][C][G] = -0.600;
 int22_ar[G][C][G][G][C][A][C][G] =  2.000;
 int22_ar[G][C][G][G][C][C][C][G] =  2.000;
 int22_ar[G][C][G][G][C][G][C][G] =  2.000;
 int22_ar[G][C][G][G][C][U][C][G] =  2.000;
 int22_ar[G][C][G][G][G][A][C][G] = -0.900;
 int22_ar[G][C][G][G][G][C][C][G] =  2.000;
 int22_ar[G][C][G][G][G][G][C][G] =  0.800;
 int22_ar[G][C][G][G][G][U][C][G] = -0.600;
 int22_ar[G][C][G][G][U][A][C][G] = -1.600;
 int22_ar[G][C][G][G][U][C][C][G] =  2.000;
 int22_ar[G][C][G][G][U][G][C][G] = -0.700;
 int22_ar[G][C][G][G][U][U][C][G] = -4.100;
 int22_ar[G][C][G][U][A][A][C][G] =  2.000;
 int22_ar[G][C][G][U][A][C][C][G] =  2.000;
 int22_ar[G][C][G][U][A][G][C][G] =  2.000;
 int22_ar[G][C][G][U][A][U][C][G] =  2.000;
 int22_ar[G][C][G][U][C][A][C][G] =  0.400;
 int22_ar[G][C][G][U][C][C][C][G] =  2.000;
 int22_ar[G][C][G][U][C][G][C][G] =  1.700;
 int22_ar[G][C][G][U][C][U][C][G] = -0.300;
 int22_ar[G][C][G][U][G][A][C][G] =  0.300;
 int22_ar[G][C][G][U][G][C][C][G] =  2.000;
 int22_ar[G][C][G][U][G][G][C][G] =  0.900;
 int22_ar[G][C][G][U][G][U][C][G] = -2.400;
 int22_ar[G][C][G][U][U][A][C][G] =  0.500;
 int22_ar[G][C][G][U][U][C][C][G] =  2.000;
 int22_ar[G][C][G][U][U][G][C][G] =  1.200;
 int22_ar[G][C][G][U][U][U][C][G] =  0.100;
 int22_ar[G][C][U][A][A][A][C][G] =  2.000;
 int22_ar[G][C][U][A][A][C][C][G] =  0.700;
 int22_ar[G][C][U][A][A][G][C][G] =  0.100;
 int22_ar[G][C][U][A][A][U][C][G] =  1.500;
 int22_ar[G][C][U][A][C][A][C][G] =  2.000;
 int22_ar[G][C][U][A][C][C][C][G] =  0.000;
 int22_ar[G][C][U][A][C][G][C][G] = -1.900;
 int22_ar[G][C][U][A][C][U][C][G] = -0.200;
 int22_ar[G][C][U][A][G][A][C][G] =  2.000;
 int22_ar[G][C][U][A][G][C][C][G] =  0.200;
 int22_ar[G][C][U][A][G][G][C][G] = -0.900;
 int22_ar[G][C][U][A][G][U][C][G] =  0.900;
 int22_ar[G][C][U][A][U][A][C][G] =  2.000;
 int22_ar[G][C][U][A][U][C][C][G] =  2.000;
 int22_ar[G][C][U][A][U][G][C][G] =  2.000;
 int22_ar[G][C][U][A][U][U][C][G] =  2.000;
 int22_ar[G][C][U][C][A][A][C][G] =  2.000;
 int22_ar[G][C][U][C][A][C][C][G] =  0.500;
 int22_ar[G][C][U][C][A][G][C][G] = -0.700;
 int22_ar[G][C][U][C][A][U][C][G] =  0.000;
 int22_ar[G][C][U][C][C][A][C][G] =  2.000;
 int22_ar[G][C][U][C][C][C][C][G] =  0.300;
 int22_ar[G][C][U][C][C][G][C][G] = -0.300;
 int22_ar[G][C][U][C][C][U][C][G] = -0.100;
 int22_ar[G][C][U][C][G][A][C][G] =  2.000;
 int22_ar[G][C][U][C][G][C][C][G] =  2.000;
 int22_ar[G][C][U][C][G][G][C][G] =  2.000;
 int22_ar[G][C][U][C][G][U][C][G] =  2.000;
 int22_ar[G][C][U][C][U][A][C][G] =  2.000;
 int22_ar[G][C][U][C][U][C][C][G] =  0.200;
 int22_ar[G][C][U][C][U][G][C][G] = -0.700;
 int22_ar[G][C][U][C][U][U][C][G] =  0.400;
 int22_ar[G][C][U][G][A][A][C][G] =  2.000;
 int22_ar[G][C][U][G][A][C][C][G] =  0.200;
 int22_ar[G][C][U][G][A][G][C][G] = -0.800;
 int22_ar[G][C][U][G][A][U][C][G] =  0.900;
 int22_ar[G][C][U][G][C][A][C][G] =  2.000;
 int22_ar[G][C][U][G][C][C][C][G] =  2.000;
 int22_ar[G][C][U][G][C][G][C][G] =  2.000;
 int22_ar[G][C][U][G][C][U][C][G] =  2.000;
 int22_ar[G][C][U][G][G][A][C][G] =  2.000;
 int22_ar[G][C][U][G][G][C][C][G] =  0.500;
 int22_ar[G][C][U][G][G][G][C][G] = -1.000;
 int22_ar[G][C][U][G][G][U][C][G] =  1.100;
 int22_ar[G][C][U][G][U][A][C][G] =  2.000;
 int22_ar[G][C][U][G][U][C][C][G] = -1.600;
 int22_ar[G][C][U][G][U][G][C][G] = -4.400;
 int22_ar[G][C][U][G][U][U][C][G] = -1.000;
 int22_ar[G][C][U][U][A][A][C][G] =  2.000;
 int22_ar[G][C][U][U][A][C][C][G] =  2.000;
 int22_ar[G][C][U][U][A][G][C][G] =  2.000;
 int22_ar[G][C][U][U][A][U][C][G] =  2.000;
 int22_ar[G][C][U][U][C][A][C][G] =  2.000;
 int22_ar[G][C][U][U][C][C][C][G] =  1.700;
 int22_ar[G][C][U][U][C][G][C][G] = -0.700;
 int22_ar[G][C][U][U][C][U][C][G] =  0.200;
 int22_ar[G][C][U][U][G][A][C][G] =  2.000;
 int22_ar[G][C][U][U][G][C][C][G] =  0.000;
 int22_ar[G][C][U][U][G][G][C][G] = -3.000;
 int22_ar[G][C][U][U][G][U][C][G] =  0.600;
 int22_ar[G][C][U][U][U][A][C][G] =  2.000;
 int22_ar[G][C][U][U][U][C][C][G] =  0.100;
 int22_ar[G][C][U][U][U][G][C][G] = -1.000;
 int22_ar[G][C][U][U][U][U][C][G] =  0.600;
 int22_ar[G][C][A][A][A][A][G][C] =  1.500;
 int22_ar[G][C][A][A][A][C][G][C] =  1.200;
 int22_ar[G][C][A][A][A][G][G][C] =  0.100;
 int22_ar[G][C][A][A][A][U][G][C] =  2.000;
 int22_ar[G][C][A][A][C][A][G][C] =  1.200;
 int22_ar[G][C][A][A][C][C][G][C] =  0.900;
 int22_ar[G][C][A][A][C][G][G][C] = -0.100;
 int22_ar[G][C][A][A][C][U][G][C] =  2.000;
 int22_ar[G][C][A][A][G][A][G][C] = -0.500;
 int22_ar[G][C][A][A][G][C][G][C] = -0.800;
 int22_ar[G][C][A][A][G][G][G][C] = -1.900;
 int22_ar[G][C][A][A][G][U][G][C] =  2.000;
 int22_ar[G][C][A][A][U][A][G][C] =  2.000;
 int22_ar[G][C][A][A][U][C][G][C] =  2.000;
 int22_ar[G][C][A][A][U][G][G][C] =  2.000;
 int22_ar[G][C][A][A][U][U][G][C] =  2.000;
 int22_ar[G][C][A][C][A][A][G][C] =  1.200;
 int22_ar[G][C][A][C][A][C][G][C] =  0.900;
 int22_ar[G][C][A][C][A][G][G][C] = -0.200;
 int22_ar[G][C][A][C][A][U][G][C] =  2.000;
 int22_ar[G][C][A][C][C][A][G][C] =  1.800;
 int22_ar[G][C][A][C][C][C][G][C] =  0.900;
 int22_ar[G][C][A][C][C][G][G][C] =  0.900;
 int22_ar[G][C][A][C][C][U][G][C] =  2.000;
 int22_ar[G][C][A][C][G][A][G][C] =  2.000;
 int22_ar[G][C][A][C][G][C][G][C] =  2.000;
 int22_ar[G][C][A][C][G][G][G][C] =  2.000;
 int22_ar[G][C][A][C][G][U][G][C] =  2.000;
 int22_ar[G][C][A][C][U][A][G][C] =  0.800;
 int22_ar[G][C][A][C][U][C][G][C] =  0.000;
 int22_ar[G][C][A][C][U][G][G][C] = -0.100;
 int22_ar[G][C][A][C][U][U][G][C] =  2.000;
 int22_ar[G][C][A][G][A][A][G][C] =  0.100;
 int22_ar[G][C][A][G][A][C][G][C] = -0.200;
 int22_ar[G][C][A][G][A][G][G][C] = -1.300;
 int22_ar[G][C][A][G][A][U][G][C] =  2.000;
 int22_ar[G][C][A][G][C][A][G][C] =  2.000;
 int22_ar[G][C][A][G][C][C][G][C] =  2.000;
 int22_ar[G][C][A][G][C][G][G][C] =  2.000;
 int22_ar[G][C][A][G][C][U][G][C] =  2.000;
 int22_ar[G][C][A][G][G][A][G][C] =  1.100;
 int22_ar[G][C][A][G][G][C][G][C] =  0.800;
 int22_ar[G][C][A][G][G][G][G][C] = -0.200;
 int22_ar[G][C][A][G][G][U][G][C] =  2.000;
 int22_ar[G][C][A][G][U][A][G][C] = -0.700;
 int22_ar[G][C][A][G][U][C][G][C] = -2.000;
 int22_ar[G][C][A][G][U][G][G][C] = -1.300;
 int22_ar[G][C][A][G][U][U][G][C] =  2.000;
 int22_ar[G][C][A][U][A][A][G][C] =  2.000;
 int22_ar[G][C][A][U][A][C][G][C] =  2.000;
 int22_ar[G][C][A][U][A][G][G][C] =  2.000;
 int22_ar[G][C][A][U][A][U][G][C] =  2.000;
 int22_ar[G][C][A][U][C][A][G][C] =  1.900;
 int22_ar[G][C][A][U][C][C][G][C] =  1.000;
 int22_ar[G][C][A][U][C][G][G][C] =  0.900;
 int22_ar[G][C][A][U][C][U][G][C] =  2.000;
 int22_ar[G][C][A][U][G][A][G][C] = -0.300;
 int22_ar[G][C][A][U][G][C][G][C] = -1.600;
 int22_ar[G][C][A][U][G][G][G][C] = -0.900;
 int22_ar[G][C][A][U][G][U][G][C] =  2.000;
 int22_ar[G][C][A][U][U][A][G][C] =  1.500;
 int22_ar[G][C][A][U][U][C][G][C] =  0.200;
 int22_ar[G][C][A][U][U][G][G][C] =  0.900;
 int22_ar[G][C][A][U][U][U][G][C] =  2.000;
 int22_ar[G][C][C][A][A][A][G][C] =  1.200;
 int22_ar[G][C][C][A][A][C][G][C] =  1.800;
 int22_ar[G][C][C][A][A][G][G][C] =  2.000;
 int22_ar[G][C][C][A][A][U][G][C] =  1.900;
 int22_ar[G][C][C][A][C][A][G][C] =  1.000;
 int22_ar[G][C][C][A][C][C][G][C] =  1.000;
 int22_ar[G][C][C][A][C][G][G][C] =  2.000;
 int22_ar[G][C][C][A][C][U][G][C] =  1.000;
 int22_ar[G][C][C][A][G][A][G][C] = -0.800;
 int22_ar[G][C][C][A][G][C][G][C] =  0.200;
 int22_ar[G][C][C][A][G][G][G][C] =  2.000;
 int22_ar[G][C][C][A][G][U][G][C] =  0.300;
 int22_ar[G][C][C][A][U][A][G][C] =  2.000;
 int22_ar[G][C][C][A][U][C][G][C] =  2.000;
 int22_ar[G][C][C][A][U][G][G][C] =  2.000;
 int22_ar[G][C][C][A][U][U][G][C] =  2.000;
 int22_ar[G][C][C][C][A][A][G][C] =  0.900;
 int22_ar[G][C][C][C][A][C][G][C] =  0.900;
 int22_ar[G][C][C][C][A][G][G][C] =  2.000;
 int22_ar[G][C][C][C][A][U][G][C] =  1.000;
 int22_ar[G][C][C][C][C][A][G][C] =  1.000;
 int22_ar[G][C][C][C][C][C][G][C] =  1.000;
 int22_ar[G][C][C][C][C][G][G][C] =  2.000;
 int22_ar[G][C][C][C][C][U][G][C] =  1.000;
 int22_ar[G][C][C][C][G][A][G][C] =  2.000;
 int22_ar[G][C][C][C][G][C][G][C] =  2.000;
 int22_ar[G][C][C][C][G][G][G][C] =  2.000;
 int22_ar[G][C][C][C][G][U][G][C] =  2.000;
 int22_ar[G][C][C][C][U][A][G][C] =  0.000;
 int22_ar[G][C][C][C][U][C][G][C] =  0.000;
 int22_ar[G][C][C][C][U][G][G][C] =  2.000;
 int22_ar[G][C][C][C][U][U][G][C] =  0.000;
 int22_ar[G][C][C][G][A][A][G][C] = -0.100;
 int22_ar[G][C][C][G][A][C][G][C] =  0.900;
 int22_ar[G][C][C][G][A][G][G][C] =  2.000;
 int22_ar[G][C][C][G][A][U][G][C] =  0.900;
 int22_ar[G][C][C][G][C][A][G][C] =  2.000;
 int22_ar[G][C][C][G][C][C][G][C] =  2.000;
 int22_ar[G][C][C][G][C][G][G][C] =  2.000;
 int22_ar[G][C][C][G][C][U][G][C] =  2.000;
 int22_ar[G][C][C][G][G][A][G][C] =  0.900;
 int22_ar[G][C][C][G][G][C][G][C] =  1.500;
 int22_ar[G][C][C][G][G][G][G][C] =  2.000;
 int22_ar[G][C][C][G][G][U][G][C] =  1.500;
 int22_ar[G][C][C][G][U][A][G][C] = -1.900;
 int22_ar[G][C][C][G][U][C][G][C] = -0.900;
 int22_ar[G][C][C][G][U][G][G][C] =  2.000;
 int22_ar[G][C][C][G][U][U][G][C] = -0.900;
 int22_ar[G][C][C][U][A][A][G][C] =  2.000;
 int22_ar[G][C][C][U][A][C][G][C] =  2.000;
 int22_ar[G][C][C][U][A][G][G][C] =  2.000;
 int22_ar[G][C][C][U][A][U][G][C] =  2.000;
 int22_ar[G][C][C][U][C][A][G][C] =  1.000;
 int22_ar[G][C][C][U][C][C][G][C] =  1.000;
 int22_ar[G][C][C][U][C][G][G][C] =  2.000;
 int22_ar[G][C][C][U][C][U][G][C] =  1.100;
 int22_ar[G][C][C][U][G][A][G][C] = -1.500;
 int22_ar[G][C][C][U][G][C][G][C] = -0.500;
 int22_ar[G][C][C][U][G][G][G][C] =  2.000;
 int22_ar[G][C][C][U][G][U][G][C] = -0.500;
 int22_ar[G][C][C][U][U][A][G][C] =  0.200;
 int22_ar[G][C][C][U][U][C][G][C] =  0.200;
 int22_ar[G][C][C][U][U][G][G][C] =  2.000;
 int22_ar[G][C][C][U][U][U][G][C] =  0.300;
 int22_ar[G][C][G][A][A][A][G][C] = -0.500;
 int22_ar[G][C][G][A][A][C][G][C] =  2.000;
 int22_ar[G][C][G][A][A][G][G][C] =  1.100;
 int22_ar[G][C][G][A][A][U][G][C] = -0.300;
 int22_ar[G][C][G][A][C][A][G][C] = -0.800;
 int22_ar[G][C][G][A][C][C][G][C] =  2.000;
 int22_ar[G][C][G][A][C][G][G][C] =  0.900;
 int22_ar[G][C][G][A][C][U][G][C] = -1.500;
 int22_ar[G][C][G][A][G][A][G][C] = -2.600;
 int22_ar[G][C][G][A][G][C][G][C] =  2.000;
 int22_ar[G][C][G][A][G][G][G][C] = -0.900;
 int22_ar[G][C][G][A][G][U][G][C] = -1.500;
 int22_ar[G][C][G][A][U][A][G][C] =  2.000;
 int22_ar[G][C][G][A][U][C][G][C] =  2.000;
 int22_ar[G][C][G][A][U][G][G][C] =  2.000;
 int22_ar[G][C][G][A][U][U][G][C] =  2.000;
 int22_ar[G][C][G][C][A][A][G][C] = -0.800;
 int22_ar[G][C][G][C][A][C][G][C] =  2.000;
 int22_ar[G][C][G][C][A][G][G][C] =  0.800;
 int22_ar[G][C][G][C][A][U][G][C] = -1.600;
 int22_ar[G][C][G][C][C][A][G][C] =  0.200;
 int22_ar[G][C][G][C][C][C][G][C] =  2.000;
 int22_ar[G][C][G][C][C][G][G][C] =  1.500;
 int22_ar[G][C][G][C][C][U][G][C] = -0.500;
 int22_ar[G][C][G][C][G][A][G][C] =  2.000;
 int22_ar[G][C][G][C][G][C][G][C] =  2.000;
 int22_ar[G][C][G][C][G][G][G][C] =  2.000;
 int22_ar[G][C][G][C][G][U][G][C] =  2.000;
 int22_ar[G][C][G][C][U][A][G][C] = -0.800;
 int22_ar[G][C][G][C][U][C][G][C] =  2.000;
 int22_ar[G][C][G][C][U][G][G][C] =  0.500;
 int22_ar[G][C][G][C][U][U][G][C] = -1.500;
 int22_ar[G][C][G][G][A][A][G][C] = -1.900;
 int22_ar[G][C][G][G][A][C][G][C] =  2.000;
 int22_ar[G][C][G][G][A][G][G][C] = -0.200;
 int22_ar[G][C][G][G][A][U][G][C] = -0.900;
 int22_ar[G][C][G][G][C][A][G][C] =  2.000;
 int22_ar[G][C][G][G][C][C][G][C] =  2.000;
 int22_ar[G][C][G][G][C][G][G][C] =  2.000;
 int22_ar[G][C][G][G][C][U][G][C] =  2.000;
 int22_ar[G][C][G][G][G][A][G][C] = -0.900;
 int22_ar[G][C][G][G][G][C][G][C] =  2.000;
 int22_ar[G][C][G][G][G][G][G][C] =  0.800;
 int22_ar[G][C][G][G][G][U][G][C] = -0.600;
 int22_ar[G][C][G][G][U][A][G][C] = -1.900;
 int22_ar[G][C][G][G][U][C][G][C] =  2.000;
 int22_ar[G][C][G][G][U][G][G][C] = -1.000;
 int22_ar[G][C][G][G][U][U][G][C] = -4.500;
 int22_ar[G][C][G][U][A][A][G][C] =  2.000;
 int22_ar[G][C][G][U][A][C][G][C] =  2.000;
 int22_ar[G][C][G][U][A][G][G][C] =  2.000;
 int22_ar[G][C][G][U][A][U][G][C] =  2.000;
 int22_ar[G][C][G][U][C][A][G][C] =  0.300;
 int22_ar[G][C][G][U][C][C][G][C] =  2.000;
 int22_ar[G][C][G][U][C][G][G][C] =  1.500;
 int22_ar[G][C][G][U][C][U][G][C] = -0.500;
 int22_ar[G][C][G][U][G][A][G][C] = -1.500;
 int22_ar[G][C][G][U][G][C][G][C] =  2.000;
 int22_ar[G][C][G][U][G][G][G][C] = -0.600;
 int22_ar[G][C][G][U][G][U][G][C] = -4.100;
 int22_ar[G][C][G][U][U][A][G][C] =  0.300;
 int22_ar[G][C][G][U][U][C][G][C] =  2.000;
 int22_ar[G][C][G][U][U][G][G][C] =  1.100;
 int22_ar[G][C][G][U][U][U][G][C] = -0.500;
 int22_ar[G][C][U][A][A][A][G][C] =  2.000;
 int22_ar[G][C][U][A][A][C][G][C] =  0.800;
 int22_ar[G][C][U][A][A][G][G][C] = -0.700;
 int22_ar[G][C][U][A][A][U][G][C] =  1.500;
 int22_ar[G][C][U][A][C][A][G][C] =  2.000;
 int22_ar[G][C][U][A][C][C][G][C] =  0.000;
 int22_ar[G][C][U][A][C][G][G][C] = -1.900;
 int22_ar[G][C][U][A][C][U][G][C] =  0.200;
 int22_ar[G][C][U][A][G][A][G][C] =  2.000;
 int22_ar[G][C][U][A][G][C][G][C] = -0.800;
 int22_ar[G][C][U][A][G][G][G][C] = -1.900;
 int22_ar[G][C][U][A][G][U][G][C] =  0.300;
 int22_ar[G][C][U][A][U][A][G][C] =  2.000;
 int22_ar[G][C][U][A][U][C][G][C] =  2.000;
 int22_ar[G][C][U][A][U][G][G][C] =  2.000;
 int22_ar[G][C][U][A][U][U][G][C] =  2.000;
 int22_ar[G][C][U][C][A][A][G][C] =  2.000;
 int22_ar[G][C][U][C][A][C][G][C] =  0.000;
 int22_ar[G][C][U][C][A][G][G][C] = -2.000;
 int22_ar[G][C][U][C][A][U][G][C] =  0.200;
 int22_ar[G][C][U][C][C][A][G][C] =  2.000;
 int22_ar[G][C][U][C][C][C][G][C] =  0.000;
 int22_ar[G][C][U][C][C][G][G][C] = -0.900;
 int22_ar[G][C][U][C][C][U][G][C] =  0.200;
 int22_ar[G][C][U][C][G][A][G][C] =  2.000;
 int22_ar[G][C][U][C][G][C][G][C] =  2.000;
 int22_ar[G][C][U][C][G][G][G][C] =  2.000;
 int22_ar[G][C][U][C][G][U][G][C] =  2.000;
 int22_ar[G][C][U][C][U][A][G][C] =  2.000;
 int22_ar[G][C][U][C][U][C][G][C] = -1.000;
 int22_ar[G][C][U][C][U][G][G][C] = -1.900;
 int22_ar[G][C][U][C][U][U][G][C] = -0.700;
 int22_ar[G][C][U][G][A][A][G][C] =  2.000;
 int22_ar[G][C][U][G][A][C][G][C] = -0.100;
 int22_ar[G][C][U][G][A][G][G][C] = -1.300;
 int22_ar[G][C][U][G][A][U][G][C] =  0.900;
 int22_ar[G][C][U][G][C][A][G][C] =  2.000;
 int22_ar[G][C][U][G][C][C][G][C] =  2.000;
 int22_ar[G][C][U][G][C][G][G][C] =  2.000;
 int22_ar[G][C][U][G][C][U][G][C] =  2.000;
 int22_ar[G][C][U][G][G][A][G][C] =  2.000;
 int22_ar[G][C][U][G][G][C][G][C] =  0.500;
 int22_ar[G][C][U][G][G][G][G][C] = -1.000;
 int22_ar[G][C][U][G][G][U][G][C] =  1.100;
 int22_ar[G][C][U][G][U][A][G][C] =  2.000;
 int22_ar[G][C][U][G][U][C][G][C] = -1.900;
 int22_ar[G][C][U][G][U][G][G][C] = -4.900;
 int22_ar[G][C][U][G][U][U][G][C] = -0.900;
 int22_ar[G][C][U][U][A][A][G][C] =  2.000;
 int22_ar[G][C][U][U][A][C][G][C] =  2.000;
 int22_ar[G][C][U][U][A][G][G][C] =  2.000;
 int22_ar[G][C][U][U][A][U][G][C] =  2.000;
 int22_ar[G][C][U][U][C][A][G][C] =  2.000;
 int22_ar[G][C][U][U][C][C][G][C] =  0.000;
 int22_ar[G][C][U][U][C][G][G][C] = -0.900;
 int22_ar[G][C][U][U][C][U][G][C] =  0.300;
 int22_ar[G][C][U][U][G][A][G][C] =  2.000;
 int22_ar[G][C][U][U][G][C][G][C] = -1.500;
 int22_ar[G][C][U][U][G][G][G][C] = -4.500;
 int22_ar[G][C][U][U][G][U][G][C] = -0.500;
 int22_ar[G][C][U][U][U][A][G][C] =  2.000;
 int22_ar[G][C][U][U][U][C][G][C] = -0.700;
 int22_ar[G][C][U][U][U][G][G][C] = -0.900;
 int22_ar[G][C][U][U][U][U][G][C] = -0.500;
 int22_ar[G][C][A][A][A][A][G][U] =  2.100;
 int22_ar[G][C][A][A][A][C][G][U] =  1.800;
 int22_ar[G][C][A][A][A][G][G][U] =  0.700;
 int22_ar[G][C][A][A][A][U][G][U] =  2.000;
 int22_ar[G][C][A][A][C][A][G][U] =  1.900;
 int22_ar[G][C][A][A][C][C][G][U] =  1.600;
 int22_ar[G][C][A][A][C][G][G][U] =  0.500;
 int22_ar[G][C][A][A][C][U][G][U] =  2.000;
 int22_ar[G][C][A][A][G][A][G][U] =  0.900;
 int22_ar[G][C][A][A][G][C][G][U] =  0.600;
 int22_ar[G][C][A][A][G][G][G][U] = -0.500;
 int22_ar[G][C][A][A][G][U][G][U] =  2.000;
 int22_ar[G][C][A][A][U][A][G][U] =  2.000;
 int22_ar[G][C][A][A][U][C][G][U] =  2.000;
 int22_ar[G][C][A][A][U][G][G][U] =  2.000;
 int22_ar[G][C][A][A][U][U][G][U] =  2.000;
 int22_ar[G][C][A][C][A][A][G][U] =  2.000;
 int22_ar[G][C][A][C][A][C][G][U] =  1.700;
 int22_ar[G][C][A][C][A][G][G][U] =  0.600;
 int22_ar[G][C][A][C][A][U][G][U] =  2.000;
 int22_ar[G][C][A][C][C][A][G][U] =  2.400;
 int22_ar[G][C][A][C][C][C][G][U] =  1.500;
 int22_ar[G][C][A][C][C][G][G][U] =  1.400;
 int22_ar[G][C][A][C][C][U][G][U] =  2.000;
 int22_ar[G][C][A][C][G][A][G][U] =  2.000;
 int22_ar[G][C][A][C][G][C][G][U] =  2.000;
 int22_ar[G][C][A][C][G][G][G][U] =  2.000;
 int22_ar[G][C][A][C][G][U][G][U] =  2.000;
 int22_ar[G][C][A][C][U][A][G][U] =  2.400;
 int22_ar[G][C][A][C][U][C][G][U] =  1.500;
 int22_ar[G][C][A][C][U][G][G][U] =  1.400;
 int22_ar[G][C][A][C][U][U][G][U] =  2.000;
 int22_ar[G][C][A][G][A][A][G][U] =  0.900;
 int22_ar[G][C][A][G][A][C][G][U] =  0.600;
 int22_ar[G][C][A][G][A][G][G][U] = -0.500;
 int22_ar[G][C][A][G][A][U][G][U] =  2.000;
 int22_ar[G][C][A][G][C][A][G][U] =  2.000;
 int22_ar[G][C][A][G][C][C][G][U] =  2.000;
 int22_ar[G][C][A][G][C][G][G][U] =  2.000;
 int22_ar[G][C][A][G][C][U][G][U] =  2.000;
 int22_ar[G][C][A][G][G][A][G][U] =  1.400;
 int22_ar[G][C][A][G][G][C][G][U] =  1.100;
 int22_ar[G][C][A][G][G][G][G][U] =  0.000;
 int22_ar[G][C][A][G][G][U][G][U] =  2.000;
 int22_ar[G][C][A][G][U][A][G][U] =  0.700;
 int22_ar[G][C][A][G][U][C][G][U] = -0.600;
 int22_ar[G][C][A][G][U][G][G][U] =  0.100;
 int22_ar[G][C][A][G][U][U][G][U] =  2.000;
 int22_ar[G][C][A][U][A][A][G][U] =  2.000;
 int22_ar[G][C][A][U][A][C][G][U] =  2.000;
 int22_ar[G][C][A][U][A][G][G][U] =  2.000;
 int22_ar[G][C][A][U][A][U][G][U] =  2.000;
 int22_ar[G][C][A][U][C][A][G][U] =  2.400;
 int22_ar[G][C][A][U][C][C][G][U] =  1.500;
 int22_ar[G][C][A][U][C][G][G][U] =  1.400;
 int22_ar[G][C][A][U][C][U][G][U] =  2.000;
 int22_ar[G][C][A][U][G][A][G][U] =  1.700;
 int22_ar[G][C][A][U][G][C][G][U] =  0.400;
 int22_ar[G][C][A][U][G][G][G][U] =  1.100;
 int22_ar[G][C][A][U][G][U][G][U] =  2.000;
 int22_ar[G][C][A][U][U][A][G][U] =  2.000;
 int22_ar[G][C][A][U][U][C][G][U] =  0.700;
 int22_ar[G][C][A][U][U][G][G][U] =  1.500;
 int22_ar[G][C][A][U][U][U][G][U] =  2.000;
 int22_ar[G][C][C][A][A][A][G][U] =  1.900;
 int22_ar[G][C][C][A][A][C][G][U] =  2.500;
 int22_ar[G][C][C][A][A][G][G][U] =  2.000;
 int22_ar[G][C][C][A][A][U][G][U] =  2.500;
 int22_ar[G][C][C][A][C][A][G][U] =  1.600;
 int22_ar[G][C][C][A][C][C][G][U] =  1.600;
 int22_ar[G][C][C][A][C][G][G][U] =  2.000;
 int22_ar[G][C][C][A][C][U][G][U] =  1.700;
 int22_ar[G][C][C][A][G][A][G][U] =  0.600;
 int22_ar[G][C][C][A][G][C][G][U] =  1.600;
 int22_ar[G][C][C][A][G][G][G][U] =  2.000;
 int22_ar[G][C][C][A][G][U][G][U] =  1.700;
 int22_ar[G][C][C][A][U][A][G][U] =  2.000;
 int22_ar[G][C][C][A][U][C][G][U] =  2.000;
 int22_ar[G][C][C][A][U][G][G][U] =  2.000;
 int22_ar[G][C][C][A][U][U][G][U] =  2.000;
 int22_ar[G][C][C][C][A][A][G][U] =  1.700;
 int22_ar[G][C][C][C][A][C][G][U] =  1.700;
 int22_ar[G][C][C][C][A][G][G][U] =  2.000;
 int22_ar[G][C][C][C][A][U][G][U] =  1.800;
 int22_ar[G][C][C][C][C][A][G][U] =  1.600;
 int22_ar[G][C][C][C][C][C][G][U] =  1.600;
 int22_ar[G][C][C][C][C][G][G][U] =  2.000;
 int22_ar[G][C][C][C][C][U][G][U] =  1.600;
 int22_ar[G][C][C][C][G][A][G][U] =  2.000;
 int22_ar[G][C][C][C][G][C][G][U] =  2.000;
 int22_ar[G][C][C][C][G][G][G][U] =  2.000;
 int22_ar[G][C][C][C][G][U][G][U] =  2.000;
 int22_ar[G][C][C][C][U][A][G][U] =  1.600;
 int22_ar[G][C][C][C][U][C][G][U] =  1.600;
 int22_ar[G][C][C][C][U][G][G][U] =  2.000;
 int22_ar[G][C][C][C][U][U][G][U] =  1.600;
 int22_ar[G][C][C][G][A][A][G][U] =  0.600;
 int22_ar[G][C][C][G][A][C][G][U] =  1.600;
 int22_ar[G][C][C][G][A][G][G][U] =  2.000;
 int22_ar[G][C][C][G][A][U][G][U] =  1.700;
 int22_ar[G][C][C][G][C][A][G][U] =  2.000;
 int22_ar[G][C][C][G][C][C][G][U] =  2.000;
 int22_ar[G][C][C][G][C][G][G][U] =  2.000;
 int22_ar[G][C][C][G][C][U][G][U] =  2.000;
 int22_ar[G][C][C][G][G][A][G][U] =  1.200;
 int22_ar[G][C][C][G][G][C][G][U] =  1.800;
 int22_ar[G][C][C][G][G][G][G][U] =  2.000;
 int22_ar[G][C][C][G][G][U][G][U] =  1.800;
 int22_ar[G][C][C][G][U][A][G][U] = -0.500;
 int22_ar[G][C][C][G][U][C][G][U] =  0.500;
 int22_ar[G][C][C][G][U][G][G][U] =  2.000;
 int22_ar[G][C][C][G][U][U][G][U] =  0.500;
 int22_ar[G][C][C][U][A][A][G][U] =  2.000;
 int22_ar[G][C][C][U][A][C][G][U] =  2.000;
 int22_ar[G][C][C][U][A][G][G][U] =  2.000;
 int22_ar[G][C][C][U][A][U][G][U] =  2.000;
 int22_ar[G][C][C][U][C][A][G][U] =  1.600;
 int22_ar[G][C][C][U][C][C][G][U] =  1.600;
 int22_ar[G][C][C][U][C][G][G][U] =  2.000;
 int22_ar[G][C][C][U][C][U][G][U] =  1.600;
 int22_ar[G][C][C][U][G][A][G][U] =  0.400;
 int22_ar[G][C][C][U][G][C][G][U] =  1.400;
 int22_ar[G][C][C][U][G][G][G][U] =  2.000;
 int22_ar[G][C][C][U][G][U][G][U] =  1.500;
 int22_ar[G][C][C][U][U][A][G][U] =  0.800;
 int22_ar[G][C][C][U][U][C][G][U] =  0.800;
 int22_ar[G][C][C][U][U][G][G][U] =  2.000;
 int22_ar[G][C][C][U][U][U][G][U] =  0.800;
 int22_ar[G][C][G][A][A][A][G][U] =  0.100;
 int22_ar[G][C][G][A][A][C][G][U] =  2.000;
 int22_ar[G][C][G][A][A][G][G][U] =  1.800;
 int22_ar[G][C][G][A][A][U][G][U] =  0.400;
 int22_ar[G][C][G][A][C][A][G][U] = -0.100;
 int22_ar[G][C][G][A][C][C][G][U] =  2.000;
 int22_ar[G][C][G][A][C][G][G][U] =  1.500;
 int22_ar[G][C][G][A][C][U][G][U] = -0.900;
 int22_ar[G][C][G][A][G][A][G][U] = -1.100;
 int22_ar[G][C][G][A][G][C][G][U] =  2.000;
 int22_ar[G][C][G][A][G][G][G][U] =  0.500;
 int22_ar[G][C][G][A][G][U][G][U] = -0.100;
 int22_ar[G][C][G][A][U][A][G][U] =  2.000;
 int22_ar[G][C][G][A][U][C][G][U] =  2.000;
 int22_ar[G][C][G][A][U][G][G][U] =  2.000;
 int22_ar[G][C][G][A][U][U][G][U] =  2.000;
 int22_ar[G][C][G][C][A][A][G][U] =  0.000;
 int22_ar[G][C][G][C][A][C][G][U] =  2.000;
 int22_ar[G][C][G][C][A][G][G][U] =  1.600;
 int22_ar[G][C][G][C][A][U][G][U] = -0.800;
 int22_ar[G][C][G][C][C][A][G][U] =  0.800;
 int22_ar[G][C][G][C][C][C][G][U] =  2.000;
 int22_ar[G][C][G][C][C][G][G][U] =  2.100;
 int22_ar[G][C][G][C][C][U][G][U] =  0.100;
 int22_ar[G][C][G][C][G][A][G][U] =  2.000;
 int22_ar[G][C][G][C][G][C][G][U] =  2.000;
 int22_ar[G][C][G][C][G][G][G][U] =  2.000;
 int22_ar[G][C][G][C][G][U][G][U] =  2.000;
 int22_ar[G][C][G][C][U][A][G][U] =  0.800;
 int22_ar[G][C][G][C][U][C][G][U] =  2.000;
 int22_ar[G][C][G][C][U][G][G][U] =  2.100;
 int22_ar[G][C][G][C][U][U][G][U] =  0.100;
 int22_ar[G][C][G][G][A][A][G][U] = -1.100;
 int22_ar[G][C][G][G][A][C][G][U] =  2.000;
 int22_ar[G][C][G][G][A][G][G][U] =  0.500;
 int22_ar[G][C][G][G][A][U][G][U] = -0.100;
 int22_ar[G][C][G][G][C][A][G][U] =  2.000;
 int22_ar[G][C][G][G][C][C][G][U] =  2.000;
 int22_ar[G][C][G][G][C][G][G][U] =  2.000;
 int22_ar[G][C][G][G][C][U][G][U] =  2.000;
 int22_ar[G][C][G][G][G][A][G][U] = -0.600;
 int22_ar[G][C][G][G][G][C][G][U] =  2.000;
 int22_ar[G][C][G][G][G][G][G][U] =  1.100;
 int22_ar[G][C][G][G][G][U][G][U] = -0.300;
 int22_ar[G][C][G][G][U][A][G][U] = -0.500;
 int22_ar[G][C][G][G][U][C][G][U] =  2.000;
 int22_ar[G][C][G][G][U][G][G][U] =  0.400;
 int22_ar[G][C][G][G][U][U][G][U] = -3.100;
 int22_ar[G][C][G][U][A][A][G][U] =  2.000;
 int22_ar[G][C][G][U][A][C][G][U] =  2.000;
 int22_ar[G][C][G][U][A][G][G][U] =  2.000;
 int22_ar[G][C][G][U][A][U][G][U] =  2.000;
 int22_ar[G][C][G][U][C][A][G][U] =  0.800;
 int22_ar[G][C][G][U][C][C][G][U] =  2.000;
 int22_ar[G][C][G][U][C][G][G][U] =  2.100;
 int22_ar[G][C][G][U][C][U][G][U] =  0.100;
 int22_ar[G][C][G][U][G][A][G][U] =  0.500;
 int22_ar[G][C][G][U][G][C][G][U] =  2.000;
 int22_ar[G][C][G][U][G][G][G][U] =  1.300;
 int22_ar[G][C][G][U][G][U][G][U] = -2.100;
 int22_ar[G][C][G][U][U][A][G][U] =  0.800;
 int22_ar[G][C][G][U][U][C][G][U] =  2.000;
 int22_ar[G][C][G][U][U][G][G][U] =  1.700;
 int22_ar[G][C][G][U][U][U][G][U] =  0.100;
 int22_ar[G][C][U][A][A][A][G][U] =  2.000;
 int22_ar[G][C][U][A][A][C][G][U] =  1.500;
 int22_ar[G][C][U][A][A][G][G][U] =  0.000;
 int22_ar[G][C][U][A][A][U][G][U] =  2.100;
 int22_ar[G][C][U][A][C][A][G][U] =  2.000;
 int22_ar[G][C][U][A][C][C][G][U] =  0.600;
 int22_ar[G][C][U][A][C][G][G][U] = -1.300;
 int22_ar[G][C][U][A][C][U][G][U] =  0.900;
 int22_ar[G][C][U][A][G][A][G][U] =  2.000;
 int22_ar[G][C][U][A][G][C][G][U] =  0.700;
 int22_ar[G][C][U][A][G][G][G][U] = -0.500;
 int22_ar[G][C][U][A][G][U][G][U] =  1.700;
 int22_ar[G][C][U][A][U][A][G][U] =  2.000;
 int22_ar[G][C][U][A][U][C][G][U] =  2.000;
 int22_ar[G][C][U][A][U][G][G][U] =  2.000;
 int22_ar[G][C][U][A][U][U][G][U] =  2.000;
 int22_ar[G][C][U][C][A][A][G][U] =  2.000;
 int22_ar[G][C][U][C][A][C][G][U] =  0.700;
 int22_ar[G][C][U][C][A][G][G][U] = -1.200;
 int22_ar[G][C][U][C][A][U][G][U] =  1.000;
 int22_ar[G][C][U][C][C][A][G][U] =  2.000;
 int22_ar[G][C][U][C][C][C][G][U] =  0.600;
 int22_ar[G][C][U][C][C][G][G][U] = -0.300;
 int22_ar[G][C][U][C][C][U][G][U] =  0.800;
 int22_ar[G][C][U][C][G][A][G][U] =  2.000;
 int22_ar[G][C][U][C][G][C][G][U] =  2.000;
 int22_ar[G][C][U][C][G][G][G][U] =  2.000;
 int22_ar[G][C][U][C][G][U][G][U] =  2.000;
 int22_ar[G][C][U][C][U][A][G][U] =  2.000;
 int22_ar[G][C][U][C][U][C][G][U] =  0.600;
 int22_ar[G][C][U][C][U][G][G][U] = -0.300;
 int22_ar[G][C][U][C][U][U][G][U] =  0.800;
 int22_ar[G][C][U][G][A][A][G][U] =  2.000;
 int22_ar[G][C][U][G][A][C][G][U] =  0.700;
 int22_ar[G][C][U][G][A][G][G][U] = -0.500;
 int22_ar[G][C][U][G][A][U][G][U] =  1.700;
 int22_ar[G][C][U][G][C][A][G][U] =  2.000;
 int22_ar[G][C][U][G][C][C][G][U] =  2.000;
 int22_ar[G][C][U][G][C][G][G][U] =  2.000;
 int22_ar[G][C][U][G][C][U][G][U] =  2.000;
 int22_ar[G][C][U][G][G][A][G][U] =  2.000;
 int22_ar[G][C][U][G][G][C][G][U] =  0.800;
 int22_ar[G][C][U][G][G][G][G][U] = -0.700;
 int22_ar[G][C][U][G][G][U][G][U] =  1.400;
 int22_ar[G][C][U][G][U][A][G][U] =  2.000;
 int22_ar[G][C][U][G][U][C][G][U] = -0.500;
 int22_ar[G][C][U][G][U][G][G][U] = -3.500;
 int22_ar[G][C][U][G][U][U][G][U] =  0.500;
 int22_ar[G][C][U][U][A][A][G][U] =  2.000;
 int22_ar[G][C][U][U][A][C][G][U] =  2.000;
 int22_ar[G][C][U][U][A][G][G][U] =  2.000;
 int22_ar[G][C][U][U][A][U][G][U] =  2.000;
 int22_ar[G][C][U][U][C][A][G][U] =  2.000;
 int22_ar[G][C][U][U][C][C][G][U] =  0.600;
 int22_ar[G][C][U][U][C][G][G][U] = -0.300;
 int22_ar[G][C][U][U][C][U][G][U] =  0.800;
 int22_ar[G][C][U][U][G][A][G][U] =  2.000;
 int22_ar[G][C][U][U][G][C][G][U] =  0.500;
 int22_ar[G][C][U][U][G][G][G][U] = -2.500;
 int22_ar[G][C][U][U][G][U][G][U] =  1.500;
 int22_ar[G][C][U][U][U][A][G][U] =  2.000;
 int22_ar[G][C][U][U][U][C][G][U] = -0.200;
 int22_ar[G][C][U][U][U][G][G][U] = -0.300;
 int22_ar[G][C][U][U][U][U][G][U] =  0.000;
 int22_ar[G][C][A][A][A][A][U][A] =  2.100;
 int22_ar[G][C][A][A][A][C][U][A] =  1.800;
 int22_ar[G][C][A][A][A][G][U][A] =  0.700;
 int22_ar[G][C][A][A][A][U][U][A] =  2.000;
 int22_ar[G][C][A][A][C][A][U][A] =  1.700;
 int22_ar[G][C][A][A][C][C][U][A] =  1.400;
 int22_ar[G][C][A][A][C][G][U][A] =  0.300;
 int22_ar[G][C][A][A][C][U][U][A] =  2.000;
 int22_ar[G][C][A][A][G][A][U][A] =  1.100;
 int22_ar[G][C][A][A][G][C][U][A] =  0.800;
 int22_ar[G][C][A][A][G][G][U][A] = -0.300;
 int22_ar[G][C][A][A][G][U][U][A] =  2.000;
 int22_ar[G][C][A][A][U][A][U][A] =  2.000;
 int22_ar[G][C][A][A][U][C][U][A] =  2.000;
 int22_ar[G][C][A][A][U][G][U][A] =  2.000;
 int22_ar[G][C][A][A][U][U][U][A] =  2.000;
 int22_ar[G][C][A][C][A][A][U][A] =  2.100;
 int22_ar[G][C][A][C][A][C][U][A] =  1.800;
 int22_ar[G][C][A][C][A][G][U][A] =  0.700;
 int22_ar[G][C][A][C][A][U][U][A] =  2.000;
 int22_ar[G][C][A][C][C][A][U][A] =  2.700;
 int22_ar[G][C][A][C][C][C][U][A] =  1.800;
 int22_ar[G][C][A][C][C][G][U][A] =  1.700;
 int22_ar[G][C][A][C][C][U][U][A] =  2.000;
 int22_ar[G][C][A][C][G][A][U][A] =  2.000;
 int22_ar[G][C][A][C][G][C][U][A] =  2.000;
 int22_ar[G][C][A][C][G][G][U][A] =  2.000;
 int22_ar[G][C][A][C][G][U][U][A] =  2.000;
 int22_ar[G][C][A][C][U][A][U][A] =  2.700;
 int22_ar[G][C][A][C][U][C][U][A] =  1.800;
 int22_ar[G][C][A][C][U][G][U][A] =  1.700;
 int22_ar[G][C][A][C][U][U][U][A] =  2.000;
 int22_ar[G][C][A][G][A][A][U][A] =  1.100;
 int22_ar[G][C][A][G][A][C][U][A] =  0.800;
 int22_ar[G][C][A][G][A][G][U][A] = -0.300;
 int22_ar[G][C][A][G][A][U][U][A] =  2.000;
 int22_ar[G][C][A][G][C][A][U][A] =  2.000;
 int22_ar[G][C][A][G][C][C][U][A] =  2.000;
 int22_ar[G][C][A][G][C][G][U][A] =  2.000;
 int22_ar[G][C][A][G][C][U][U][A] =  2.000;
 int22_ar[G][C][A][G][G][A][U][A] =  1.500;
 int22_ar[G][C][A][G][G][C][U][A] =  1.200;
 int22_ar[G][C][A][G][G][G][U][A] =  0.100;
 int22_ar[G][C][A][G][G][U][U][A] =  2.000;
 int22_ar[G][C][A][G][U][A][U][A] =  0.300;
 int22_ar[G][C][A][G][U][C][U][A] = -1.000;
 int22_ar[G][C][A][G][U][G][U][A] = -0.300;
 int22_ar[G][C][A][G][U][U][U][A] =  2.000;
 int22_ar[G][C][A][U][A][A][U][A] =  2.000;
 int22_ar[G][C][A][U][A][C][U][A] =  2.000;
 int22_ar[G][C][A][U][A][G][U][A] =  2.000;
 int22_ar[G][C][A][U][A][U][U][A] =  2.000;
 int22_ar[G][C][A][U][C][A][U][A] =  2.400;
 int22_ar[G][C][A][U][C][C][U][A] =  1.500;
 int22_ar[G][C][A][U][C][G][U][A] =  1.400;
 int22_ar[G][C][A][U][C][U][U][A] =  2.000;
 int22_ar[G][C][A][U][G][A][U][A] =  1.600;
 int22_ar[G][C][A][U][G][C][U][A] =  0.300;
 int22_ar[G][C][A][U][G][G][U][A] =  1.000;
 int22_ar[G][C][A][U][G][U][U][A] =  2.000;
 int22_ar[G][C][A][U][U][A][U][A] =  2.300;
 int22_ar[G][C][A][U][U][C][U][A] =  1.000;
 int22_ar[G][C][A][U][U][G][U][A] =  1.700;
 int22_ar[G][C][A][U][U][U][U][A] =  2.000;
 int22_ar[G][C][C][A][A][A][U][A] =  1.900;
 int22_ar[G][C][C][A][A][C][U][A] =  2.500;
 int22_ar[G][C][C][A][A][G][U][A] =  2.000;
 int22_ar[G][C][C][A][A][U][U][A] =  2.500;
 int22_ar[G][C][C][A][C][A][U][A] =  1.400;
 int22_ar[G][C][C][A][C][C][U][A] =  1.400;
 int22_ar[G][C][C][A][C][G][U][A] =  2.000;
 int22_ar[G][C][C][A][C][U][U][A] =  1.500;
 int22_ar[G][C][C][A][G][A][U][A] =  0.800;
 int22_ar[G][C][C][A][G][C][U][A] =  1.800;
 int22_ar[G][C][C][A][G][G][U][A] =  2.000;
 int22_ar[G][C][C][A][G][U][U][A] =  1.900;
 int22_ar[G][C][C][A][U][A][U][A] =  2.000;
 int22_ar[G][C][C][A][U][C][U][A] =  2.000;
 int22_ar[G][C][C][A][U][G][U][A] =  2.000;
 int22_ar[G][C][C][A][U][U][U][A] =  2.000;
 int22_ar[G][C][C][C][A][A][U][A] =  1.900;
 int22_ar[G][C][C][C][A][C][U][A] =  1.900;
 int22_ar[G][C][C][C][A][G][U][A] =  2.000;
 int22_ar[G][C][C][C][A][U][U][A] =  1.900;
 int22_ar[G][C][C][C][C][A][U][A] =  1.900;
 int22_ar[G][C][C][C][C][C][U][A] =  1.900;
 int22_ar[G][C][C][C][C][G][U][A] =  2.000;
 int22_ar[G][C][C][C][C][U][U][A] =  1.900;
 int22_ar[G][C][C][C][G][A][U][A] =  2.000;
 int22_ar[G][C][C][C][G][C][U][A] =  2.000;
 int22_ar[G][C][C][C][G][G][U][A] =  2.000;
 int22_ar[G][C][C][C][G][U][U][A] =  2.000;
 int22_ar[G][C][C][C][U][A][U][A] =  1.900;
 int22_ar[G][C][C][C][U][C][U][A] =  1.900;
 int22_ar[G][C][C][C][U][G][U][A] =  2.000;
 int22_ar[G][C][C][C][U][U][U][A] =  1.900;
 int22_ar[G][C][C][G][A][A][U][A] =  0.800;
 int22_ar[G][C][C][G][A][C][U][A] =  1.800;
 int22_ar[G][C][C][G][A][G][U][A] =  2.000;
 int22_ar[G][C][C][G][A][U][U][A] =  1.900;
 int22_ar[G][C][C][G][C][A][U][A] =  2.000;
 int22_ar[G][C][C][G][C][C][U][A] =  2.000;
 int22_ar[G][C][C][G][C][G][U][A] =  2.000;
 int22_ar[G][C][C][G][C][U][U][A] =  2.000;
 int22_ar[G][C][C][G][G][A][U][A] =  1.200;
 int22_ar[G][C][C][G][G][C][U][A] =  1.800;
 int22_ar[G][C][C][G][G][G][U][A] =  2.000;
 int22_ar[G][C][C][G][G][U][U][A] =  1.900;
 int22_ar[G][C][C][G][U][A][U][A] = -0.900;
 int22_ar[G][C][C][G][U][C][U][A] =  0.100;
 int22_ar[G][C][C][G][U][G][U][A] =  2.000;
 int22_ar[G][C][C][G][U][U][U][A] =  0.100;
 int22_ar[G][C][C][U][A][A][U][A] =  2.000;
 int22_ar[G][C][C][U][A][C][U][A] =  2.000;
 int22_ar[G][C][C][U][A][G][U][A] =  2.000;
 int22_ar[G][C][C][U][A][U][U][A] =  2.000;
 int22_ar[G][C][C][U][C][A][U][A] =  1.600;
 int22_ar[G][C][C][U][C][C][U][A] =  1.600;
 int22_ar[G][C][C][U][C][G][U][A] =  2.000;
 int22_ar[G][C][C][U][C][U][U][A] =  1.600;
 int22_ar[G][C][C][U][G][A][U][A] =  0.300;
 int22_ar[G][C][C][U][G][C][U][A] =  1.300;
 int22_ar[G][C][C][U][G][G][U][A] =  2.000;
 int22_ar[G][C][C][U][G][U][U][A] =  1.400;
 int22_ar[G][C][C][U][U][A][U][A] =  1.000;
 int22_ar[G][C][C][U][U][C][U][A] =  1.000;
 int22_ar[G][C][C][U][U][G][U][A] =  2.000;
 int22_ar[G][C][C][U][U][U][U][A] =  1.100;
 int22_ar[G][C][G][A][A][A][U][A] =  0.100;
 int22_ar[G][C][G][A][A][C][U][A] =  2.000;
 int22_ar[G][C][G][A][A][G][U][A] =  1.800;
 int22_ar[G][C][G][A][A][U][U][A] =  0.400;
 int22_ar[G][C][G][A][C][A][U][A] = -0.300;
 int22_ar[G][C][G][A][C][C][U][A] =  2.000;
 int22_ar[G][C][G][A][C][G][U][A] =  1.300;
 int22_ar[G][C][G][A][C][U][U][A] = -1.100;
 int22_ar[G][C][G][A][G][A][U][A] = -0.900;
 int22_ar[G][C][G][A][G][C][U][A] =  2.000;
 int22_ar[G][C][G][A][G][G][U][A] =  0.700;
 int22_ar[G][C][G][A][G][U][U][A] =  0.100;
 int22_ar[G][C][G][A][U][A][U][A] =  2.000;
 int22_ar[G][C][G][A][U][C][U][A] =  2.000;
 int22_ar[G][C][G][A][U][G][U][A] =  2.000;
 int22_ar[G][C][G][A][U][U][U][A] =  2.000;
 int22_ar[G][C][G][C][A][A][U][A] =  0.100;
 int22_ar[G][C][G][C][A][C][U][A] =  2.000;
 int22_ar[G][C][G][C][A][G][U][A] =  1.800;
 int22_ar[G][C][G][C][A][U][U][A] = -0.600;
 int22_ar[G][C][G][C][C][A][U][A] =  1.100;
 int22_ar[G][C][G][C][C][C][U][A] =  2.000;
 int22_ar[G][C][G][C][C][G][U][A] =  2.400;
 int22_ar[G][C][G][C][C][U][U][A] =  0.400;
 int22_ar[G][C][G][C][G][A][U][A] =  2.000;
 int22_ar[G][C][G][C][G][C][U][A] =  2.000;
 int22_ar[G][C][G][C][G][G][U][A] =  2.000;
 int22_ar[G][C][G][C][G][U][U][A] =  2.000;
 int22_ar[G][C][G][C][U][A][U][A] =  1.100;
 int22_ar[G][C][G][C][U][C][U][A] =  2.000;
 int22_ar[G][C][G][C][U][G][U][A] =  2.400;
 int22_ar[G][C][G][C][U][U][U][A] =  0.400;
 int22_ar[G][C][G][G][A][A][U][A] = -0.900;
 int22_ar[G][C][G][G][A][C][U][A] =  2.000;
 int22_ar[G][C][G][G][A][G][U][A] =  0.700;
 int22_ar[G][C][G][G][A][U][U][A] =  0.100;
 int22_ar[G][C][G][G][C][A][U][A] =  2.000;
 int22_ar[G][C][G][G][C][C][U][A] =  2.000;
 int22_ar[G][C][G][G][C][G][U][A] =  2.000;
 int22_ar[G][C][G][G][C][U][U][A] =  2.000;
 int22_ar[G][C][G][G][G][A][U][A] = -0.500;
 int22_ar[G][C][G][G][G][C][U][A] =  2.000;
 int22_ar[G][C][G][G][G][G][U][A] =  1.100;
 int22_ar[G][C][G][G][G][U][U][A] = -0.300;
 int22_ar[G][C][G][G][U][A][U][A] = -0.900;
 int22_ar[G][C][G][G][U][C][U][A] =  2.000;
 int22_ar[G][C][G][G][U][G][U][A] =  0.000;
 int22_ar[G][C][G][G][U][U][U][A] = -3.500;
 int22_ar[G][C][G][U][A][A][U][A] =  2.000;
 int22_ar[G][C][G][U][A][C][U][A] =  2.000;
 int22_ar[G][C][G][U][A][G][U][A] =  2.000;
 int22_ar[G][C][G][U][A][U][U][A] =  2.000;
 int22_ar[G][C][G][U][C][A][U][A] =  0.800;
 int22_ar[G][C][G][U][C][C][U][A] =  2.000;
 int22_ar[G][C][G][U][C][G][U][A] =  2.100;
 int22_ar[G][C][G][U][C][U][U][A] =  0.100;
 int22_ar[G][C][G][U][G][A][U][A] =  0.400;
 int22_ar[G][C][G][U][G][C][U][A] =  2.000;
 int22_ar[G][C][G][U][G][G][U][A] =  1.200;
 int22_ar[G][C][G][U][G][U][U][A] = -2.200;
 int22_ar[G][C][G][U][U][A][U][A] =  1.100;
 int22_ar[G][C][G][U][U][C][U][A] =  2.000;
 int22_ar[G][C][G][U][U][G][U][A] =  1.900;
 int22_ar[G][C][G][U][U][U][U][A] =  0.300;
 int22_ar[G][C][U][A][A][A][U][A] =  2.000;
 int22_ar[G][C][U][A][A][C][U][A] =  1.500;
 int22_ar[G][C][U][A][A][G][U][A] =  0.000;
 int22_ar[G][C][U][A][A][U][U][A] =  2.100;
 int22_ar[G][C][U][A][C][A][U][A] =  2.000;
 int22_ar[G][C][U][A][C][C][U][A] =  0.400;
 int22_ar[G][C][U][A][C][G][U][A] = -1.500;
 int22_ar[G][C][U][A][C][U][U][A] =  0.700;
 int22_ar[G][C][U][A][G][A][U][A] =  2.000;
 int22_ar[G][C][U][A][G][C][U][A] =  0.900;
 int22_ar[G][C][U][A][G][G][U][A] = -0.300;
 int22_ar[G][C][U][A][G][U][U][A] =  1.900;
 int22_ar[G][C][U][A][U][A][U][A] =  2.000;
 int22_ar[G][C][U][A][U][C][U][A] =  2.000;
 int22_ar[G][C][U][A][U][G][U][A] =  2.000;
 int22_ar[G][C][U][A][U][U][U][A] =  2.000;
 int22_ar[G][C][U][C][A][A][U][A] =  2.000;
 int22_ar[G][C][U][C][A][C][U][A] =  0.900;
 int22_ar[G][C][U][C][A][G][U][A] = -1.000;
 int22_ar[G][C][U][C][A][U][U][A] =  1.100;
 int22_ar[G][C][U][C][C][A][U][A] =  2.000;
 int22_ar[G][C][U][C][C][C][U][A] =  0.900;
 int22_ar[G][C][U][C][C][G][U][A] =  0.000;
 int22_ar[G][C][U][C][C][U][U][A] =  1.100;
 int22_ar[G][C][U][C][G][A][U][A] =  2.000;
 int22_ar[G][C][U][C][G][C][U][A] =  2.000;
 int22_ar[G][C][U][C][G][G][U][A] =  2.000;
 int22_ar[G][C][U][C][G][U][U][A] =  2.000;
 int22_ar[G][C][U][C][U][A][U][A] =  2.000;
 int22_ar[G][C][U][C][U][C][U][A] =  0.900;
 int22_ar[G][C][U][C][U][G][U][A] =  0.000;
 int22_ar[G][C][U][C][U][U][U][A] =  1.100;
 int22_ar[G][C][U][G][A][A][U][A] =  2.000;
 int22_ar[G][C][U][G][A][C][U][A] =  0.900;
 int22_ar[G][C][U][G][A][G][U][A] = -0.300;
 int22_ar[G][C][U][G][A][U][U][A] =  1.900;
 int22_ar[G][C][U][G][C][A][U][A] =  2.000;
 int22_ar[G][C][U][G][C][C][U][A] =  2.000;
 int22_ar[G][C][U][G][C][G][U][A] =  2.000;
 int22_ar[G][C][U][G][C][U][U][A] =  2.000;
 int22_ar[G][C][U][G][G][A][U][A] =  2.000;
 int22_ar[G][C][U][G][G][C][U][A] =  0.800;
 int22_ar[G][C][U][G][G][G][U][A] = -0.700;
 int22_ar[G][C][U][G][G][U][U][A] =  1.500;
 int22_ar[G][C][U][G][U][A][U][A] =  2.000;
 int22_ar[G][C][U][G][U][C][U][A] = -0.900;
 int22_ar[G][C][U][G][U][G][U][A] = -3.900;
 int22_ar[G][C][U][G][U][U][U][A] =  0.100;
 int22_ar[G][C][U][U][A][A][U][A] =  2.000;
 int22_ar[G][C][U][U][A][C][U][A] =  2.000;
 int22_ar[G][C][U][U][A][G][U][A] =  2.000;
 int22_ar[G][C][U][U][A][U][U][A] =  2.000;
 int22_ar[G][C][U][U][C][A][U][A] =  2.000;
 int22_ar[G][C][U][U][C][C][U][A] =  0.600;
 int22_ar[G][C][U][U][C][G][U][A] = -0.300;
 int22_ar[G][C][U][U][C][U][U][A] =  0.800;
 int22_ar[G][C][U][U][G][A][U][A] =  2.000;
 int22_ar[G][C][U][U][G][C][U][A] =  0.400;
 int22_ar[G][C][U][U][G][G][U][A] = -2.600;
 int22_ar[G][C][U][U][G][U][U][A] =  1.400;
 int22_ar[G][C][U][U][U][A][U][A] =  2.000;
 int22_ar[G][C][U][U][U][C][U][A] =  0.000;
 int22_ar[G][C][U][U][U][G][U][A] = -0.100;
 int22_ar[G][C][U][U][U][U][U][A] =  0.300;
 int22_ar[G][C][A][A][A][A][U][G] =  2.100;
 int22_ar[G][C][A][A][A][C][U][G] =  1.800;
 int22_ar[G][C][A][A][A][G][U][G] =  0.700;
 int22_ar[G][C][A][A][A][U][U][G] =  2.000;
 int22_ar[G][C][A][A][C][A][U][G] =  1.700;
 int22_ar[G][C][A][A][C][C][U][G] =  1.400;
 int22_ar[G][C][A][A][C][G][U][G] =  0.300;
 int22_ar[G][C][A][A][C][U][U][G] =  2.000;
 int22_ar[G][C][A][A][G][A][U][G] =  1.100;
 int22_ar[G][C][A][A][G][C][U][G] =  0.800;
 int22_ar[G][C][A][A][G][G][U][G] = -0.300;
 int22_ar[G][C][A][A][G][U][U][G] =  2.000;
 int22_ar[G][C][A][A][U][A][U][G] =  2.000;
 int22_ar[G][C][A][A][U][C][U][G] =  2.000;
 int22_ar[G][C][A][A][U][G][U][G] =  2.000;
 int22_ar[G][C][A][A][U][U][U][G] =  2.000;
 int22_ar[G][C][A][C][A][A][U][G] =  2.100;
 int22_ar[G][C][A][C][A][C][U][G] =  1.800;
 int22_ar[G][C][A][C][A][G][U][G] =  0.700;
 int22_ar[G][C][A][C][A][U][U][G] =  2.000;
 int22_ar[G][C][A][C][C][A][U][G] =  2.700;
 int22_ar[G][C][A][C][C][C][U][G] =  1.800;
 int22_ar[G][C][A][C][C][G][U][G] =  1.700;
 int22_ar[G][C][A][C][C][U][U][G] =  2.000;
 int22_ar[G][C][A][C][G][A][U][G] =  2.000;
 int22_ar[G][C][A][C][G][C][U][G] =  2.000;
 int22_ar[G][C][A][C][G][G][U][G] =  2.000;
 int22_ar[G][C][A][C][G][U][U][G] =  2.000;
 int22_ar[G][C][A][C][U][A][U][G] =  2.700;
 int22_ar[G][C][A][C][U][C][U][G] =  1.800;
 int22_ar[G][C][A][C][U][G][U][G] =  1.700;
 int22_ar[G][C][A][C][U][U][U][G] =  2.000;
 int22_ar[G][C][A][G][A][A][U][G] =  1.100;
 int22_ar[G][C][A][G][A][C][U][G] =  0.800;
 int22_ar[G][C][A][G][A][G][U][G] = -0.300;
 int22_ar[G][C][A][G][A][U][U][G] =  2.000;
 int22_ar[G][C][A][G][C][A][U][G] =  2.000;
 int22_ar[G][C][A][G][C][C][U][G] =  2.000;
 int22_ar[G][C][A][G][C][G][U][G] =  2.000;
 int22_ar[G][C][A][G][C][U][U][G] =  2.000;
 int22_ar[G][C][A][G][G][A][U][G] =  1.500;
 int22_ar[G][C][A][G][G][C][U][G] =  1.200;
 int22_ar[G][C][A][G][G][G][U][G] =  0.100;
 int22_ar[G][C][A][G][G][U][U][G] =  2.000;
 int22_ar[G][C][A][G][U][A][U][G] =  0.300;
 int22_ar[G][C][A][G][U][C][U][G] = -1.000;
 int22_ar[G][C][A][G][U][G][U][G] = -0.300;
 int22_ar[G][C][A][G][U][U][U][G] =  2.000;
 int22_ar[G][C][A][U][A][A][U][G] =  2.000;
 int22_ar[G][C][A][U][A][C][U][G] =  2.000;
 int22_ar[G][C][A][U][A][G][U][G] =  2.000;
 int22_ar[G][C][A][U][A][U][U][G] =  2.000;
 int22_ar[G][C][A][U][C][A][U][G] =  2.400;
 int22_ar[G][C][A][U][C][C][U][G] =  1.500;
 int22_ar[G][C][A][U][C][G][U][G] =  1.400;
 int22_ar[G][C][A][U][C][U][U][G] =  2.000;
 int22_ar[G][C][A][U][G][A][U][G] =  1.600;
 int22_ar[G][C][A][U][G][C][U][G] =  0.300;
 int22_ar[G][C][A][U][G][G][U][G] =  1.000;
 int22_ar[G][C][A][U][G][U][U][G] =  2.000;
 int22_ar[G][C][A][U][U][A][U][G] =  2.300;
 int22_ar[G][C][A][U][U][C][U][G] =  1.000;
 int22_ar[G][C][A][U][U][G][U][G] =  1.700;
 int22_ar[G][C][A][U][U][U][U][G] =  2.000;
 int22_ar[G][C][C][A][A][A][U][G] =  1.900;
 int22_ar[G][C][C][A][A][C][U][G] =  2.500;
 int22_ar[G][C][C][A][A][G][U][G] =  2.000;
 int22_ar[G][C][C][A][A][U][U][G] =  2.500;
 int22_ar[G][C][C][A][C][A][U][G] =  1.400;
 int22_ar[G][C][C][A][C][C][U][G] =  1.400;
 int22_ar[G][C][C][A][C][G][U][G] =  2.000;
 int22_ar[G][C][C][A][C][U][U][G] =  1.500;
 int22_ar[G][C][C][A][G][A][U][G] =  0.800;
 int22_ar[G][C][C][A][G][C][U][G] =  1.800;
 int22_ar[G][C][C][A][G][G][U][G] =  2.000;
 int22_ar[G][C][C][A][G][U][U][G] =  1.900;
 int22_ar[G][C][C][A][U][A][U][G] =  2.000;
 int22_ar[G][C][C][A][U][C][U][G] =  2.000;
 int22_ar[G][C][C][A][U][G][U][G] =  2.000;
 int22_ar[G][C][C][A][U][U][U][G] =  2.000;
 int22_ar[G][C][C][C][A][A][U][G] =  1.900;
 int22_ar[G][C][C][C][A][C][U][G] =  1.900;
 int22_ar[G][C][C][C][A][G][U][G] =  2.000;
 int22_ar[G][C][C][C][A][U][U][G] =  1.900;
 int22_ar[G][C][C][C][C][A][U][G] =  1.900;
 int22_ar[G][C][C][C][C][C][U][G] =  1.900;
 int22_ar[G][C][C][C][C][G][U][G] =  2.000;
 int22_ar[G][C][C][C][C][U][U][G] =  1.900;
 int22_ar[G][C][C][C][G][A][U][G] =  2.000;
 int22_ar[G][C][C][C][G][C][U][G] =  2.000;
 int22_ar[G][C][C][C][G][G][U][G] =  2.000;
 int22_ar[G][C][C][C][G][U][U][G] =  2.000;
 int22_ar[G][C][C][C][U][A][U][G] =  1.900;
 int22_ar[G][C][C][C][U][C][U][G] =  1.900;
 int22_ar[G][C][C][C][U][G][U][G] =  2.000;
 int22_ar[G][C][C][C][U][U][U][G] =  1.900;
 int22_ar[G][C][C][G][A][A][U][G] =  0.800;
 int22_ar[G][C][C][G][A][C][U][G] =  1.800;
 int22_ar[G][C][C][G][A][G][U][G] =  2.000;
 int22_ar[G][C][C][G][A][U][U][G] =  1.900;
 int22_ar[G][C][C][G][C][A][U][G] =  2.000;
 int22_ar[G][C][C][G][C][C][U][G] =  2.000;
 int22_ar[G][C][C][G][C][G][U][G] =  2.000;
 int22_ar[G][C][C][G][C][U][U][G] =  2.000;
 int22_ar[G][C][C][G][G][A][U][G] =  1.200;
 int22_ar[G][C][C][G][G][C][U][G] =  1.800;
 int22_ar[G][C][C][G][G][G][U][G] =  2.000;
 int22_ar[G][C][C][G][G][U][U][G] =  1.900;
 int22_ar[G][C][C][G][U][A][U][G] = -0.900;
 int22_ar[G][C][C][G][U][C][U][G] =  0.100;
 int22_ar[G][C][C][G][U][G][U][G] =  2.000;
 int22_ar[G][C][C][G][U][U][U][G] =  0.100;
 int22_ar[G][C][C][U][A][A][U][G] =  2.000;
 int22_ar[G][C][C][U][A][C][U][G] =  2.000;
 int22_ar[G][C][C][U][A][G][U][G] =  2.000;
 int22_ar[G][C][C][U][A][U][U][G] =  2.000;
 int22_ar[G][C][C][U][C][A][U][G] =  1.600;
 int22_ar[G][C][C][U][C][C][U][G] =  1.600;
 int22_ar[G][C][C][U][C][G][U][G] =  2.000;
 int22_ar[G][C][C][U][C][U][U][G] =  1.600;
 int22_ar[G][C][C][U][G][A][U][G] =  0.300;
 int22_ar[G][C][C][U][G][C][U][G] =  1.300;
 int22_ar[G][C][C][U][G][G][U][G] =  2.000;
 int22_ar[G][C][C][U][G][U][U][G] =  1.400;
 int22_ar[G][C][C][U][U][A][U][G] =  1.000;
 int22_ar[G][C][C][U][U][C][U][G] =  1.000;
 int22_ar[G][C][C][U][U][G][U][G] =  2.000;
 int22_ar[G][C][C][U][U][U][U][G] =  1.100;
 int22_ar[G][C][G][A][A][A][U][G] =  0.100;
 int22_ar[G][C][G][A][A][C][U][G] =  2.000;
 int22_ar[G][C][G][A][A][G][U][G] =  1.800;
 int22_ar[G][C][G][A][A][U][U][G] =  0.400;
 int22_ar[G][C][G][A][C][A][U][G] = -0.300;
 int22_ar[G][C][G][A][C][C][U][G] =  2.000;
 int22_ar[G][C][G][A][C][G][U][G] =  1.300;
 int22_ar[G][C][G][A][C][U][U][G] = -1.100;
 int22_ar[G][C][G][A][G][A][U][G] = -0.900;
 int22_ar[G][C][G][A][G][C][U][G] =  2.000;
 int22_ar[G][C][G][A][G][G][U][G] =  0.700;
 int22_ar[G][C][G][A][G][U][U][G] =  0.100;
 int22_ar[G][C][G][A][U][A][U][G] =  2.000;
 int22_ar[G][C][G][A][U][C][U][G] =  2.000;
 int22_ar[G][C][G][A][U][G][U][G] =  2.000;
 int22_ar[G][C][G][A][U][U][U][G] =  2.000;
 int22_ar[G][C][G][C][A][A][U][G] =  0.100;
 int22_ar[G][C][G][C][A][C][U][G] =  2.000;
 int22_ar[G][C][G][C][A][G][U][G] =  1.800;
 int22_ar[G][C][G][C][A][U][U][G] = -0.600;
 int22_ar[G][C][G][C][C][A][U][G] =  1.100;
 int22_ar[G][C][G][C][C][C][U][G] =  2.000;
 int22_ar[G][C][G][C][C][G][U][G] =  2.400;
 int22_ar[G][C][G][C][C][U][U][G] =  0.400;
 int22_ar[G][C][G][C][G][A][U][G] =  2.000;
 int22_ar[G][C][G][C][G][C][U][G] =  2.000;
 int22_ar[G][C][G][C][G][G][U][G] =  2.000;
 int22_ar[G][C][G][C][G][U][U][G] =  2.000;
 int22_ar[G][C][G][C][U][A][U][G] =  1.100;
 int22_ar[G][C][G][C][U][C][U][G] =  2.000;
 int22_ar[G][C][G][C][U][G][U][G] =  2.400;
 int22_ar[G][C][G][C][U][U][U][G] =  0.400;
 int22_ar[G][C][G][G][A][A][U][G] = -0.900;
 int22_ar[G][C][G][G][A][C][U][G] =  2.000;
 int22_ar[G][C][G][G][A][G][U][G] =  0.700;
 int22_ar[G][C][G][G][A][U][U][G] =  0.100;
 int22_ar[G][C][G][G][C][A][U][G] =  2.000;
 int22_ar[G][C][G][G][C][C][U][G] =  2.000;
 int22_ar[G][C][G][G][C][G][U][G] =  2.000;
 int22_ar[G][C][G][G][C][U][U][G] =  2.000;
 int22_ar[G][C][G][G][G][A][U][G] = -0.500;
 int22_ar[G][C][G][G][G][C][U][G] =  2.000;
 int22_ar[G][C][G][G][G][G][U][G] =  1.100;
 int22_ar[G][C][G][G][G][U][U][G] = -0.300;
 int22_ar[G][C][G][G][U][A][U][G] = -0.900;
 int22_ar[G][C][G][G][U][C][U][G] =  2.000;
 int22_ar[G][C][G][G][U][G][U][G] =  0.000;
 int22_ar[G][C][G][G][U][U][U][G] = -3.500;
 int22_ar[G][C][G][U][A][A][U][G] =  2.000;
 int22_ar[G][C][G][U][A][C][U][G] =  2.000;
 int22_ar[G][C][G][U][A][G][U][G] =  2.000;
 int22_ar[G][C][G][U][A][U][U][G] =  2.000;
 int22_ar[G][C][G][U][C][A][U][G] =  0.800;
 int22_ar[G][C][G][U][C][C][U][G] =  2.000;
 int22_ar[G][C][G][U][C][G][U][G] =  2.100;
 int22_ar[G][C][G][U][C][U][U][G] =  0.100;
 int22_ar[G][C][G][U][G][A][U][G] =  0.400;
 int22_ar[G][C][G][U][G][C][U][G] =  2.000;
 int22_ar[G][C][G][U][G][G][U][G] =  1.200;
 int22_ar[G][C][G][U][G][U][U][G] = -2.200;
 int22_ar[G][C][G][U][U][A][U][G] =  1.100;
 int22_ar[G][C][G][U][U][C][U][G] =  2.000;
 int22_ar[G][C][G][U][U][G][U][G] =  1.900;
 int22_ar[G][C][G][U][U][U][U][G] =  0.300;
 int22_ar[G][C][U][A][A][A][U][G] =  2.000;
 int22_ar[G][C][U][A][A][C][U][G] =  1.500;
 int22_ar[G][C][U][A][A][G][U][G] =  0.000;
 int22_ar[G][C][U][A][A][U][U][G] =  2.100;
 int22_ar[G][C][U][A][C][A][U][G] =  2.000;
 int22_ar[G][C][U][A][C][C][U][G] =  0.400;
 int22_ar[G][C][U][A][C][G][U][G] = -1.500;
 int22_ar[G][C][U][A][C][U][U][G] =  0.700;
 int22_ar[G][C][U][A][G][A][U][G] =  2.000;
 int22_ar[G][C][U][A][G][C][U][G] =  0.900;
 int22_ar[G][C][U][A][G][G][U][G] = -0.300;
 int22_ar[G][C][U][A][G][U][U][G] =  1.900;
 int22_ar[G][C][U][A][U][A][U][G] =  2.000;
 int22_ar[G][C][U][A][U][C][U][G] =  2.000;
 int22_ar[G][C][U][A][U][G][U][G] =  2.000;
 int22_ar[G][C][U][A][U][U][U][G] =  2.000;
 int22_ar[G][C][U][C][A][A][U][G] =  2.000;
 int22_ar[G][C][U][C][A][C][U][G] =  0.900;
 int22_ar[G][C][U][C][A][G][U][G] = -1.000;
 int22_ar[G][C][U][C][A][U][U][G] =  1.100;
 int22_ar[G][C][U][C][C][A][U][G] =  2.000;
 int22_ar[G][C][U][C][C][C][U][G] =  0.900;
 int22_ar[G][C][U][C][C][G][U][G] =  0.000;
 int22_ar[G][C][U][C][C][U][U][G] =  1.100;
 int22_ar[G][C][U][C][G][A][U][G] =  2.000;
 int22_ar[G][C][U][C][G][C][U][G] =  2.000;
 int22_ar[G][C][U][C][G][G][U][G] =  2.000;
 int22_ar[G][C][U][C][G][U][U][G] =  2.000;
 int22_ar[G][C][U][C][U][A][U][G] =  2.000;
 int22_ar[G][C][U][C][U][C][U][G] =  0.900;
 int22_ar[G][C][U][C][U][G][U][G] =  0.000;
 int22_ar[G][C][U][C][U][U][U][G] =  1.100;
 int22_ar[G][C][U][G][A][A][U][G] =  2.000;
 int22_ar[G][C][U][G][A][C][U][G] =  0.900;
 int22_ar[G][C][U][G][A][G][U][G] = -0.300;
 int22_ar[G][C][U][G][A][U][U][G] =  1.900;
 int22_ar[G][C][U][G][C][A][U][G] =  2.000;
 int22_ar[G][C][U][G][C][C][U][G] =  2.000;
 int22_ar[G][C][U][G][C][G][U][G] =  2.000;
 int22_ar[G][C][U][G][C][U][U][G] =  2.000;
 int22_ar[G][C][U][G][G][A][U][G] =  2.000;
 int22_ar[G][C][U][G][G][C][U][G] =  0.800;
 int22_ar[G][C][U][G][G][G][U][G] = -0.700;
 int22_ar[G][C][U][G][G][U][U][G] =  1.500;
 int22_ar[G][C][U][G][U][A][U][G] =  2.000;
 int22_ar[G][C][U][G][U][C][U][G] = -0.900;
 int22_ar[G][C][U][G][U][G][U][G] = -3.900;
 int22_ar[G][C][U][G][U][U][U][G] =  0.100;
 int22_ar[G][C][U][U][A][A][U][G] =  2.000;
 int22_ar[G][C][U][U][A][C][U][G] =  2.000;
 int22_ar[G][C][U][U][A][G][U][G] =  2.000;
 int22_ar[G][C][U][U][A][U][U][G] =  2.000;
 int22_ar[G][C][U][U][C][A][U][G] =  2.000;
 int22_ar[G][C][U][U][C][C][U][G] =  0.600;
 int22_ar[G][C][U][U][C][G][U][G] = -0.300;
 int22_ar[G][C][U][U][C][U][U][G] =  0.800;
 int22_ar[G][C][U][U][G][A][U][G] =  2.000;
 int22_ar[G][C][U][U][G][C][U][G] =  0.400;
 int22_ar[G][C][U][U][G][G][U][G] = -2.600;
 int22_ar[G][C][U][U][G][U][U][G] =  1.400;
 int22_ar[G][C][U][U][U][A][U][G] =  2.000;
 int22_ar[G][C][U][U][U][C][U][G] =  0.000;
 int22_ar[G][C][U][U][U][G][U][G] = -0.100;
 int22_ar[G][C][U][U][U][U][U][G] =  0.300;
 int22_ar[G][U][A][A][A][A][A][U] =  2.800;
 int22_ar[G][U][A][A][A][C][A][U] =  2.600;
 int22_ar[G][U][A][A][A][G][A][U] =  1.500;
 int22_ar[G][U][A][A][A][U][A][U] =  2.000;
 int22_ar[G][U][A][A][C][A][A][U] =  2.500;
 int22_ar[G][U][A][A][C][C][A][U] =  2.400;
 int22_ar[G][U][A][A][C][G][A][U] =  1.300;
 int22_ar[G][U][A][A][C][U][A][U] =  2.000;
 int22_ar[G][U][A][A][G][A][A][U] =  1.500;
 int22_ar[G][U][A][A][G][C][A][U] =  1.400;
 int22_ar[G][U][A][A][G][G][A][U] =  0.300;
 int22_ar[G][U][A][A][G][U][A][U] =  2.000;
 int22_ar[G][U][A][A][U][A][A][U] =  2.000;
 int22_ar[G][U][A][A][U][C][A][U] =  2.000;
 int22_ar[G][U][A][A][U][G][A][U] =  2.000;
 int22_ar[G][U][A][A][U][U][A][U] =  2.000;
 int22_ar[G][U][A][C][A][A][A][U] =  2.600;
 int22_ar[G][U][A][C][A][C][A][U] =  2.500;
 int22_ar[G][U][A][C][A][G][A][U] =  1.400;
 int22_ar[G][U][A][C][A][U][A][U] =  2.000;
 int22_ar[G][U][A][C][C][A][A][U] =  3.100;
 int22_ar[G][U][A][C][C][C][A][U] =  2.300;
 int22_ar[G][U][A][C][C][G][A][U] =  2.200;
 int22_ar[G][U][A][C][C][U][A][U] =  2.000;
 int22_ar[G][U][A][C][G][A][A][U] =  2.000;
 int22_ar[G][U][A][C][G][C][A][U] =  2.000;
 int22_ar[G][U][A][C][G][G][A][U] =  2.000;
 int22_ar[G][U][A][C][G][U][A][U] =  2.000;
 int22_ar[G][U][A][C][U][A][A][U] =  3.100;
 int22_ar[G][U][A][C][U][C][A][U] =  2.300;
 int22_ar[G][U][A][C][U][G][A][U] =  2.200;
 int22_ar[G][U][A][C][U][U][A][U] =  2.000;
 int22_ar[G][U][A][G][A][A][A][U] =  1.500;
 int22_ar[G][U][A][G][A][C][A][U] =  1.400;
 int22_ar[G][U][A][G][A][G][A][U] =  0.300;
 int22_ar[G][U][A][G][A][U][A][U] =  2.000;
 int22_ar[G][U][A][G][C][A][A][U] =  2.000;
 int22_ar[G][U][A][G][C][C][A][U] =  2.000;
 int22_ar[G][U][A][G][C][G][A][U] =  2.000;
 int22_ar[G][U][A][G][C][U][A][U] =  2.000;
 int22_ar[G][U][A][G][G][A][A][U] =  2.100;
 int22_ar[G][U][A][G][G][C][A][U] =  1.900;
 int22_ar[G][U][A][G][G][G][A][U] =  0.800;
 int22_ar[G][U][A][G][G][U][A][U] =  2.000;
 int22_ar[G][U][A][G][U][A][A][U] =  1.300;
 int22_ar[G][U][A][G][U][C][A][U] =  0.200;
 int22_ar[G][U][A][G][U][G][A][U] =  0.900;
 int22_ar[G][U][A][G][U][U][A][U] =  2.000;
 int22_ar[G][U][A][U][A][A][A][U] =  2.000;
 int22_ar[G][U][A][U][A][C][A][U] =  2.000;
 int22_ar[G][U][A][U][A][G][A][U] =  2.000;
 int22_ar[G][U][A][U][A][U][A][U] =  2.000;
 int22_ar[G][U][A][U][C][A][A][U] =  3.100;
 int22_ar[G][U][A][U][C][C][A][U] =  2.300;
 int22_ar[G][U][A][U][C][G][A][U] =  2.200;
 int22_ar[G][U][A][U][C][U][A][U] =  2.000;
 int22_ar[G][U][A][U][G][A][A][U] =  2.300;
 int22_ar[G][U][A][U][G][C][A][U] =  1.200;
 int22_ar[G][U][A][U][G][G][A][U] =  1.900;
 int22_ar[G][U][A][U][G][U][A][U] =  2.000;
 int22_ar[G][U][A][U][U][A][A][U] =  2.700;
 int22_ar[G][U][A][U][U][C][A][U] =  1.500;
 int22_ar[G][U][A][U][U][G][A][U] =  2.200;
 int22_ar[G][U][A][U][U][U][A][U] =  2.000;
 int22_ar[G][U][C][A][A][A][A][U] =  2.500;
 int22_ar[G][U][C][A][A][C][A][U] =  3.100;
 int22_ar[G][U][C][A][A][G][A][U] =  2.000;
 int22_ar[G][U][C][A][A][U][A][U] =  3.100;
 int22_ar[G][U][C][A][C][A][A][U] =  2.300;
 int22_ar[G][U][C][A][C][C][A][U] =  2.200;
 int22_ar[G][U][C][A][C][G][A][U] =  2.000;
 int22_ar[G][U][C][A][C][U][A][U] =  2.200;
 int22_ar[G][U][C][A][G][A][A][U] =  1.300;
 int22_ar[G][U][C][A][G][C][A][U] =  2.200;
 int22_ar[G][U][C][A][G][G][A][U] =  2.000;
 int22_ar[G][U][C][A][G][U][A][U] =  2.200;
 int22_ar[G][U][C][A][U][A][A][U] =  2.000;
 int22_ar[G][U][C][A][U][C][A][U] =  2.000;
 int22_ar[G][U][C][A][U][G][A][U] =  2.000;
 int22_ar[G][U][C][A][U][U][A][U] =  2.000;
 int22_ar[G][U][C][C][A][A][A][U] =  2.400;
 int22_ar[G][U][C][C][A][C][A][U] =  2.300;
 int22_ar[G][U][C][C][A][G][A][U] =  2.000;
 int22_ar[G][U][C][C][A][U][A][U] =  2.300;
 int22_ar[G][U][C][C][C][A][A][U] =  2.200;
 int22_ar[G][U][C][C][C][C][A][U] =  2.200;
 int22_ar[G][U][C][C][C][G][A][U] =  2.000;
 int22_ar[G][U][C][C][C][U][A][U] =  2.200;
 int22_ar[G][U][C][C][G][A][A][U] =  2.000;
 int22_ar[G][U][C][C][G][C][A][U] =  2.000;
 int22_ar[G][U][C][C][G][G][A][U] =  2.000;
 int22_ar[G][U][C][C][G][U][A][U] =  2.000;
 int22_ar[G][U][C][C][U][A][A][U] =  2.200;
 int22_ar[G][U][C][C][U][C][A][U] =  2.200;
 int22_ar[G][U][C][C][U][G][A][U] =  2.000;
 int22_ar[G][U][C][C][U][U][A][U] =  2.200;
 int22_ar[G][U][C][G][A][A][A][U] =  1.300;
 int22_ar[G][U][C][G][A][C][A][U] =  2.200;
 int22_ar[G][U][C][G][A][G][A][U] =  2.000;
 int22_ar[G][U][C][G][A][U][A][U] =  2.200;
 int22_ar[G][U][C][G][C][A][A][U] =  2.000;
 int22_ar[G][U][C][G][C][C][A][U] =  2.000;
 int22_ar[G][U][C][G][C][G][A][U] =  2.000;
 int22_ar[G][U][C][G][C][U][A][U] =  2.000;
 int22_ar[G][U][C][G][G][A][A][U] =  1.800;
 int22_ar[G][U][C][G][G][C][A][U] =  2.400;
 int22_ar[G][U][C][G][G][G][A][U] =  2.000;
 int22_ar[G][U][C][G][G][U][A][U] =  2.400;
 int22_ar[G][U][C][G][U][A][A][U] =  0.100;
 int22_ar[G][U][C][G][U][C][A][U] =  1.000;
 int22_ar[G][U][C][G][U][G][A][U] =  2.000;
 int22_ar[G][U][C][G][U][U][A][U] =  1.000;
 int22_ar[G][U][C][U][A][A][A][U] =  2.000;
 int22_ar[G][U][C][U][A][C][A][U] =  2.000;
 int22_ar[G][U][C][U][A][G][A][U] =  2.000;
 int22_ar[G][U][C][U][A][U][A][U] =  2.000;
 int22_ar[G][U][C][U][C][A][A][U] =  2.200;
 int22_ar[G][U][C][U][C][C][A][U] =  2.200;
 int22_ar[G][U][C][U][C][G][A][U] =  2.000;
 int22_ar[G][U][C][U][C][U][A][U] =  2.200;
 int22_ar[G][U][C][U][G][A][A][U] =  1.100;
 int22_ar[G][U][C][U][G][C][A][U] =  2.000;
 int22_ar[G][U][C][U][G][G][A][U] =  2.000;
 int22_ar[G][U][C][U][G][U][A][U] =  2.000;
 int22_ar[G][U][C][U][U][A][A][U] =  1.400;
 int22_ar[G][U][C][U][U][C][A][U] =  1.400;
 int22_ar[G][U][C][U][U][G][A][U] =  2.000;
 int22_ar[G][U][C][U][U][U][A][U] =  1.400;
 int22_ar[G][U][G][A][A][A][A][U] =  1.500;
 int22_ar[G][U][G][A][A][C][A][U] =  2.000;
 int22_ar[G][U][G][A][A][G][A][U] =  2.100;
 int22_ar[G][U][G][A][A][U][A][U] =  2.300;
 int22_ar[G][U][G][A][C][A][A][U] =  1.300;
 int22_ar[G][U][G][A][C][C][A][U] =  2.000;
 int22_ar[G][U][G][A][C][G][A][U] =  1.800;
 int22_ar[G][U][G][A][C][U][A][U] =  1.100;
 int22_ar[G][U][G][A][G][A][A][U] =  0.300;
 int22_ar[G][U][G][A][G][C][A][U] =  2.000;
 int22_ar[G][U][G][A][G][G][A][U] =  0.800;
 int22_ar[G][U][G][A][G][U][A][U] =  1.900;
 int22_ar[G][U][G][A][U][A][A][U] =  2.000;
 int22_ar[G][U][G][A][U][C][A][U] =  2.000;
 int22_ar[G][U][G][A][U][G][A][U] =  2.000;
 int22_ar[G][U][G][A][U][U][A][U] =  2.000;
 int22_ar[G][U][G][C][A][A][A][U] =  1.400;
 int22_ar[G][U][G][C][A][C][A][U] =  2.000;
 int22_ar[G][U][G][C][A][G][A][U] =  1.900;
 int22_ar[G][U][G][C][A][U][A][U] =  1.200;
 int22_ar[G][U][G][C][C][A][A][U] =  2.200;
 int22_ar[G][U][G][C][C][C][A][U] =  2.000;
 int22_ar[G][U][G][C][C][G][A][U] =  2.400;
 int22_ar[G][U][G][C][C][U][A][U] =  2.000;
 int22_ar[G][U][G][C][G][A][A][U] =  2.000;
 int22_ar[G][U][G][C][G][C][A][U] =  2.000;
 int22_ar[G][U][G][C][G][G][A][U] =  2.000;
 int22_ar[G][U][G][C][G][U][A][U] =  2.000;
 int22_ar[G][U][G][C][U][A][A][U] =  2.200;
 int22_ar[G][U][G][C][U][C][A][U] =  2.000;
 int22_ar[G][U][G][C][U][G][A][U] =  2.400;
 int22_ar[G][U][G][C][U][U][A][U] =  2.000;
 int22_ar[G][U][G][G][A][A][A][U] =  0.300;
 int22_ar[G][U][G][G][A][C][A][U] =  2.000;
 int22_ar[G][U][G][G][A][G][A][U] =  0.800;
 int22_ar[G][U][G][G][A][U][A][U] =  1.900;
 int22_ar[G][U][G][G][C][A][A][U] =  2.000;
 int22_ar[G][U][G][G][C][C][A][U] =  2.000;
 int22_ar[G][U][G][G][C][G][A][U] =  2.000;
 int22_ar[G][U][G][G][C][U][A][U] =  2.000;
 int22_ar[G][U][G][G][G][A][A][U] =  0.800;
 int22_ar[G][U][G][G][G][C][A][U] =  2.000;
 int22_ar[G][U][G][G][G][G][A][U] =  1.400;
 int22_ar[G][U][G][G][G][U][A][U] =  1.600;
 int22_ar[G][U][G][G][U][A][A][U] =  0.900;
 int22_ar[G][U][G][G][U][C][A][U] =  2.000;
 int22_ar[G][U][G][G][U][G][A][U] =  0.700;
 int22_ar[G][U][G][G][U][U][A][U] = -1.100;
 int22_ar[G][U][G][U][A][A][A][U] =  2.000;
 int22_ar[G][U][G][U][A][C][A][U] =  2.000;
 int22_ar[G][U][G][U][A][G][A][U] =  2.000;
 int22_ar[G][U][G][U][A][U][A][U] =  2.000;
 int22_ar[G][U][G][U][C][A][A][U] =  2.200;
 int22_ar[G][U][G][U][C][C][A][U] =  2.000;
 int22_ar[G][U][G][U][C][G][A][U] =  2.400;
 int22_ar[G][U][G][U][C][U][A][U] =  2.000;
 int22_ar[G][U][G][U][G][A][A][U] =  1.900;
 int22_ar[G][U][G][U][G][C][A][U] =  2.000;
 int22_ar[G][U][G][U][G][G][A][U] =  1.600;
 int22_ar[G][U][G][U][G][U][A][U] = -0.100;
 int22_ar[G][U][G][U][U][A][A][U] =  2.200;
 int22_ar[G][U][G][U][U][C][A][U] =  2.000;
 int22_ar[G][U][G][U][U][G][A][U] =  2.000;
 int22_ar[G][U][G][U][U][U][A][U] =  2.000;
 int22_ar[G][U][U][A][A][A][A][U] =  2.000;
 int22_ar[G][U][U][A][A][C][A][U] =  3.100;
 int22_ar[G][U][U][A][A][G][A][U] =  1.300;
 int22_ar[G][U][U][A][A][U][A][U] =  2.700;
 int22_ar[G][U][U][A][C][A][A][U] =  2.000;
 int22_ar[G][U][U][A][C][C][A][U] =  2.200;
 int22_ar[G][U][U][A][C][G][A][U] =  0.100;
 int22_ar[G][U][U][A][C][U][A][U] =  1.400;
 int22_ar[G][U][U][A][G][A][A][U] =  2.000;
 int22_ar[G][U][U][A][G][C][A][U] =  2.200;
 int22_ar[G][U][U][A][G][G][A][U] =  0.900;
 int22_ar[G][U][U][A][G][U][A][U] =  2.200;
 int22_ar[G][U][U][A][U][A][A][U] =  2.000;
 int22_ar[G][U][U][A][U][C][A][U] =  2.000;
 int22_ar[G][U][U][A][U][G][A][U] =  2.000;
 int22_ar[G][U][U][A][U][U][A][U] =  2.000;
 int22_ar[G][U][U][C][A][A][A][U] =  2.000;
 int22_ar[G][U][U][C][A][C][A][U] =  2.300;
 int22_ar[G][U][U][C][A][G][A][U] =  0.200;
 int22_ar[G][U][U][C][A][U][A][U] =  1.500;
 int22_ar[G][U][U][C][C][A][A][U] =  2.000;
 int22_ar[G][U][U][C][C][C][A][U] =  2.200;
 int22_ar[G][U][U][C][C][G][A][U] =  1.000;
 int22_ar[G][U][U][C][C][U][A][U] =  1.400;
 int22_ar[G][U][U][C][G][A][A][U] =  2.000;
 int22_ar[G][U][U][C][G][C][A][U] =  2.000;
 int22_ar[G][U][U][C][G][G][A][U] =  2.000;
 int22_ar[G][U][U][C][G][U][A][U] =  2.000;
 int22_ar[G][U][U][C][U][A][A][U] =  2.000;
 int22_ar[G][U][U][C][U][C][A][U] =  2.200;
 int22_ar[G][U][U][C][U][G][A][U] =  1.000;
 int22_ar[G][U][U][C][U][U][A][U] =  1.400;
 int22_ar[G][U][U][G][A][A][A][U] =  2.000;
 int22_ar[G][U][U][G][A][C][A][U] =  2.200;
 int22_ar[G][U][U][G][A][G][A][U] =  0.900;
 int22_ar[G][U][U][G][A][U][A][U] =  2.200;
 int22_ar[G][U][U][G][C][A][A][U] =  2.000;
 int22_ar[G][U][U][G][C][C][A][U] =  2.000;
 int22_ar[G][U][U][G][C][G][A][U] =  2.000;
 int22_ar[G][U][U][G][C][U][A][U] =  2.000;
 int22_ar[G][U][U][G][G][A][A][U] =  2.000;
 int22_ar[G][U][U][G][G][C][A][U] =  2.400;
 int22_ar[G][U][U][G][G][G][A][U] =  0.700;
 int22_ar[G][U][U][G][G][U][A][U] =  2.000;
 int22_ar[G][U][U][G][U][A][A][U] =  2.000;
 int22_ar[G][U][U][G][U][C][A][U] =  1.000;
 int22_ar[G][U][U][G][U][G][A][U] = -2.100;
 int22_ar[G][U][U][G][U][U][A][U] =  1.100;
 int22_ar[G][U][U][U][A][A][A][U] =  2.000;
 int22_ar[G][U][U][U][A][C][A][U] =  2.000;
 int22_ar[G][U][U][U][A][G][A][U] =  2.000;
 int22_ar[G][U][U][U][A][U][A][U] =  2.000;
 int22_ar[G][U][U][U][C][A][A][U] =  2.000;
 int22_ar[G][U][U][U][C][C][A][U] =  2.200;
 int22_ar[G][U][U][U][C][G][A][U] =  1.000;
 int22_ar[G][U][U][U][C][U][A][U] =  1.400;
 int22_ar[G][U][U][U][G][A][A][U] =  2.000;
 int22_ar[G][U][U][U][G][C][A][U] =  2.000;
 int22_ar[G][U][U][U][G][G][A][U] = -1.100;
 int22_ar[G][U][U][U][G][U][A][U] =  2.000;
 int22_ar[G][U][U][U][U][A][A][U] =  2.000;
 int22_ar[G][U][U][U][U][C][A][U] =  1.400;
 int22_ar[G][U][U][U][U][G][A][U] =  1.100;
 int22_ar[G][U][U][U][U][U][A][U] =  0.600;
 int22_ar[G][U][A][A][A][A][C][G] =  2.000;
 int22_ar[G][U][A][A][A][C][C][G] =  1.900;
 int22_ar[G][U][A][A][A][G][C][G] =  0.800;
 int22_ar[G][U][A][A][A][U][C][G] =  2.000;
 int22_ar[G][U][A][A][C][A][C][G] =  1.900;
 int22_ar[G][U][A][A][C][C][C][G] =  1.800;
 int22_ar[G][U][A][A][C][G][C][G] =  0.700;
 int22_ar[G][U][A][A][C][U][C][G] =  2.000;
 int22_ar[G][U][A][A][G][A][C][G] =  1.000;
 int22_ar[G][U][A][A][G][C][C][G] =  0.900;
 int22_ar[G][U][A][A][G][G][C][G] = -0.200;
 int22_ar[G][U][A][A][G][U][C][G] =  2.000;
 int22_ar[G][U][A][A][U][A][C][G] =  2.000;
 int22_ar[G][U][A][A][U][C][C][G] =  2.000;
 int22_ar[G][U][A][A][U][G][C][G] =  2.000;
 int22_ar[G][U][A][A][U][U][C][G] =  2.000;
 int22_ar[G][U][A][C][A][A][C][G] =  2.400;
 int22_ar[G][U][A][C][A][C][C][G] =  2.200;
 int22_ar[G][U][A][C][A][G][C][G] =  1.100;
 int22_ar[G][U][A][C][A][U][C][G] =  2.000;
 int22_ar[G][U][A][C][C][A][C][G] =  2.800;
 int22_ar[G][U][A][C][C][C][C][G] =  2.100;
 int22_ar[G][U][A][C][C][G][C][G] =  2.000;
 int22_ar[G][U][A][C][C][U][C][G] =  2.000;
 int22_ar[G][U][A][C][G][A][C][G] =  2.000;
 int22_ar[G][U][A][C][G][C][C][G] =  2.000;
 int22_ar[G][U][A][C][G][G][C][G] =  2.000;
 int22_ar[G][U][A][C][G][U][C][G] =  2.000;
 int22_ar[G][U][A][C][U][A][C][G] =  2.700;
 int22_ar[G][U][A][C][U][C][C][G] =  1.900;
 int22_ar[G][U][A][C][U][G][C][G] =  1.800;
 int22_ar[G][U][A][C][U][U][C][G] =  2.000;
 int22_ar[G][U][A][G][A][A][C][G] =  1.000;
 int22_ar[G][U][A][G][A][C][C][G] =  0.900;
 int22_ar[G][U][A][G][A][G][C][G] = -0.200;
 int22_ar[G][U][A][G][A][U][C][G] =  2.000;
 int22_ar[G][U][A][G][C][A][C][G] =  2.000;
 int22_ar[G][U][A][G][C][C][C][G] =  2.000;
 int22_ar[G][U][A][G][C][G][C][G] =  2.000;
 int22_ar[G][U][A][G][C][U][C][G] =  2.000;
 int22_ar[G][U][A][G][G][A][C][G] =  1.800;
 int22_ar[G][U][A][G][G][C][C][G] =  1.600;
 int22_ar[G][U][A][G][G][G][C][G] =  0.500;
 int22_ar[G][U][A][G][G][U][C][G] =  2.000;
 int22_ar[G][U][A][G][U][A][C][G] =  0.300;
 int22_ar[G][U][A][G][U][C][C][G] = -0.800;
 int22_ar[G][U][A][G][U][G][C][G] = -0.100;
 int22_ar[G][U][A][G][U][U][C][G] =  2.000;
 int22_ar[G][U][A][U][A][A][C][G] =  2.000;
 int22_ar[G][U][A][U][A][C][C][G] =  2.000;
 int22_ar[G][U][A][U][A][G][C][G] =  2.000;
 int22_ar[G][U][A][U][A][U][C][G] =  2.000;
 int22_ar[G][U][A][U][C][A][C][G] =  2.700;
 int22_ar[G][U][A][U][C][C][C][G] =  1.900;
 int22_ar[G][U][A][U][C][G][C][G] =  1.800;
 int22_ar[G][U][A][U][C][U][C][G] =  2.000;
 int22_ar[G][U][A][U][G][A][C][G] =  1.800;
 int22_ar[G][U][A][U][G][C][C][G] =  0.700;
 int22_ar[G][U][A][U][G][G][C][G] =  1.400;
 int22_ar[G][U][A][U][G][U][C][G] =  2.000;
 int22_ar[G][U][A][U][U][A][C][G] =  2.200;
 int22_ar[G][U][A][U][U][C][C][G] =  1.000;
 int22_ar[G][U][A][U][U][G][C][G] =  1.800;
 int22_ar[G][U][A][U][U][U][C][G] =  2.000;
 int22_ar[G][U][C][A][A][A][C][G] =  1.800;
 int22_ar[G][U][C][A][A][C][C][G] =  2.300;
 int22_ar[G][U][C][A][A][G][C][G] =  2.000;
 int22_ar[G][U][C][A][A][U][C][G] =  2.300;
 int22_ar[G][U][C][A][C][A][C][G] =  1.700;
 int22_ar[G][U][C][A][C][C][C][G] =  1.600;
 int22_ar[G][U][C][A][C][G][C][G] =  2.000;
 int22_ar[G][U][C][A][C][U][C][G] =  1.600;
 int22_ar[G][U][C][A][G][A][C][G] =  0.800;
 int22_ar[G][U][C][A][G][C][C][G] =  1.700;
 int22_ar[G][U][C][A][G][G][C][G] =  2.000;
 int22_ar[G][U][C][A][G][U][C][G] =  1.700;
 int22_ar[G][U][C][A][U][A][C][G] =  2.000;
 int22_ar[G][U][C][A][U][C][C][G] =  2.000;
 int22_ar[G][U][C][A][U][G][C][G] =  2.000;
 int22_ar[G][U][C][A][U][U][C][G] =  2.000;
 int22_ar[G][U][C][C][A][A][C][G] =  2.100;
 int22_ar[G][U][C][C][A][C][C][G] =  2.100;
 int22_ar[G][U][C][C][A][G][C][G] =  2.000;
 int22_ar[G][U][C][C][A][U][C][G] =  2.100;
 int22_ar[G][U][C][C][C][A][C][G] =  2.000;
 int22_ar[G][U][C][C][C][C][C][G] =  1.900;
 int22_ar[G][U][C][C][C][G][C][G] =  2.000;
 int22_ar[G][U][C][C][C][U][C][G] =  1.900;
 int22_ar[G][U][C][C][G][A][C][G] =  2.000;
 int22_ar[G][U][C][C][G][C][C][G] =  2.000;
 int22_ar[G][U][C][C][G][G][C][G] =  2.000;
 int22_ar[G][U][C][C][G][U][C][G] =  2.000;
 int22_ar[G][U][C][C][U][A][C][G] =  1.800;
 int22_ar[G][U][C][C][U][C][C][G] =  1.800;
 int22_ar[G][U][C][C][U][G][C][G] =  2.000;
 int22_ar[G][U][C][C][U][U][C][G] =  1.800;
 int22_ar[G][U][C][G][A][A][C][G] =  0.800;
 int22_ar[G][U][C][G][A][C][C][G] =  1.700;
 int22_ar[G][U][C][G][A][G][C][G] =  2.000;
 int22_ar[G][U][C][G][A][U][C][G] =  1.700;
 int22_ar[G][U][C][G][C][A][C][G] =  2.000;
 int22_ar[G][U][C][G][C][C][C][G] =  2.000;
 int22_ar[G][U][C][G][C][G][C][G] =  2.000;
 int22_ar[G][U][C][G][C][U][C][G] =  2.000;
 int22_ar[G][U][C][G][G][A][C][G] =  1.500;
 int22_ar[G][U][C][G][G][C][C][G] =  2.100;
 int22_ar[G][U][C][G][G][G][C][G] =  2.000;
 int22_ar[G][U][C][G][G][U][C][G] =  2.100;
 int22_ar[G][U][C][G][U][A][C][G] = -0.900;
 int22_ar[G][U][C][G][U][C][C][G] =  0.000;
 int22_ar[G][U][C][G][U][G][C][G] =  2.000;
 int22_ar[G][U][C][G][U][U][C][G] =  0.000;
 int22_ar[G][U][C][U][A][A][C][G] =  2.000;
 int22_ar[G][U][C][U][A][C][C][G] =  2.000;
 int22_ar[G][U][C][U][A][G][C][G] =  2.000;
 int22_ar[G][U][C][U][A][U][C][G] =  2.000;
 int22_ar[G][U][C][U][C][A][C][G] =  1.800;
 int22_ar[G][U][C][U][C][C][C][G] =  1.800;
 int22_ar[G][U][C][U][C][G][C][G] =  2.000;
 int22_ar[G][U][C][U][C][U][C][G] =  1.800;
 int22_ar[G][U][C][U][G][A][C][G] =  0.600;
 int22_ar[G][U][C][U][G][C][C][G] =  1.500;
 int22_ar[G][U][C][U][G][G][C][G] =  2.000;
 int22_ar[G][U][C][U][G][U][C][G] =  1.500;
 int22_ar[G][U][C][U][U][A][C][G] =  0.900;
 int22_ar[G][U][C][U][U][C][C][G] =  0.900;
 int22_ar[G][U][C][U][U][G][C][G] =  2.000;
 int22_ar[G][U][C][U][U][U][C][G] =  0.900;
 int22_ar[G][U][G][A][A][A][C][G] =  0.800;
 int22_ar[G][U][G][A][A][C][C][G] =  2.000;
 int22_ar[G][U][G][A][A][G][C][G] =  1.300;
 int22_ar[G][U][G][A][A][U][C][G] =  1.600;
 int22_ar[G][U][G][A][C][A][C][G] =  0.700;
 int22_ar[G][U][G][A][C][C][C][G] =  2.000;
 int22_ar[G][U][G][A][C][G][C][G] =  1.200;
 int22_ar[G][U][G][A][C][U][C][G] =  0.500;
 int22_ar[G][U][G][A][G][A][C][G] = -0.200;
 int22_ar[G][U][G][A][G][C][C][G] =  2.000;
 int22_ar[G][U][G][A][G][G][C][G] =  0.300;
 int22_ar[G][U][G][A][G][U][C][G] =  1.400;
 int22_ar[G][U][G][A][U][A][C][G] =  2.000;
 int22_ar[G][U][G][A][U][C][C][G] =  2.000;
 int22_ar[G][U][G][A][U][G][C][G] =  2.000;
 int22_ar[G][U][G][A][U][U][C][G] =  2.000;
 int22_ar[G][U][G][C][A][A][C][G] =  1.100;
 int22_ar[G][U][G][C][A][C][C][G] =  2.000;
 int22_ar[G][U][G][C][A][G][C][G] =  1.700;
 int22_ar[G][U][G][C][A][U][C][G] =  0.900;
 int22_ar[G][U][G][C][C][A][C][G] =  2.000;
 int22_ar[G][U][G][C][C][C][C][G] =  2.000;
 int22_ar[G][U][G][C][C][G][C][G] =  2.100;
 int22_ar[G][U][G][C][C][U][C][G] =  1.800;
 int22_ar[G][U][G][C][G][A][C][G] =  2.000;
 int22_ar[G][U][G][C][G][C][C][G] =  2.000;
 int22_ar[G][U][G][C][G][G][C][G] =  2.000;
 int22_ar[G][U][G][C][G][U][C][G] =  2.000;
 int22_ar[G][U][G][C][U][A][C][G] =  1.800;
 int22_ar[G][U][G][C][U][C][C][G] =  2.000;
 int22_ar[G][U][G][C][U][G][C][G] =  2.000;
 int22_ar[G][U][G][C][U][U][C][G] =  1.600;
 int22_ar[G][U][G][G][A][A][C][G] = -0.200;
 int22_ar[G][U][G][G][A][C][C][G] =  2.000;
 int22_ar[G][U][G][G][A][G][C][G] =  0.300;
 int22_ar[G][U][G][G][A][U][C][G] =  1.400;
 int22_ar[G][U][G][G][C][A][C][G] =  2.000;
 int22_ar[G][U][G][G][C][C][C][G] =  2.000;
 int22_ar[G][U][G][G][C][G][C][G] =  2.000;
 int22_ar[G][U][G][G][C][U][C][G] =  2.000;
 int22_ar[G][U][G][G][G][A][C][G] =  0.500;
 int22_ar[G][U][G][G][G][C][C][G] =  2.000;
 int22_ar[G][U][G][G][G][G][C][G] =  1.100;
 int22_ar[G][U][G][G][G][U][C][G] =  1.300;
 int22_ar[G][U][G][G][U][A][C][G] = -0.100;
 int22_ar[G][U][G][G][U][C][C][G] =  2.000;
 int22_ar[G][U][G][G][U][G][C][G] = -0.400;
 int22_ar[G][U][G][G][U][U][C][G] = -2.100;
 int22_ar[G][U][G][U][A][A][C][G] =  2.000;
 int22_ar[G][U][G][U][A][C][C][G] =  2.000;
 int22_ar[G][U][G][U][A][G][C][G] =  2.000;
 int22_ar[G][U][G][U][A][U][C][G] =  2.000;
 int22_ar[G][U][G][U][C][A][C][G] =  1.800;
 int22_ar[G][U][G][U][C][C][C][G] =  2.000;
 int22_ar[G][U][G][U][C][G][C][G] =  2.000;
 int22_ar[G][U][G][U][C][U][C][G] =  1.600;
 int22_ar[G][U][G][U][G][A][C][G] =  1.400;
 int22_ar[G][U][G][U][G][C][C][G] =  2.000;
 int22_ar[G][U][G][U][G][G][C][G] =  1.100;
 int22_ar[G][U][G][U][G][U][C][G] = -0.600;
 int22_ar[G][U][G][U][U][A][C][G] =  1.800;
 int22_ar[G][U][G][U][U][C][C][G] =  2.000;
 int22_ar[G][U][G][U][U][G][C][G] =  1.500;
 int22_ar[G][U][G][U][U][U][C][G] =  1.600;
 int22_ar[G][U][U][A][A][A][C][G] =  2.000;
 int22_ar[G][U][U][A][A][C][C][G] =  2.300;
 int22_ar[G][U][U][A][A][G][C][G] =  0.600;
 int22_ar[G][U][U][A][A][U][C][G] =  1.900;
 int22_ar[G][U][U][A][C][A][C][G] =  2.000;
 int22_ar[G][U][U][A][C][C][C][G] =  1.600;
 int22_ar[G][U][U][A][C][G][C][G] = -0.500;
 int22_ar[G][U][U][A][C][U][C][G] =  0.800;
 int22_ar[G][U][U][A][G][A][C][G] =  2.000;
 int22_ar[G][U][U][A][G][C][C][G] =  1.700;
 int22_ar[G][U][U][A][G][G][C][G] =  0.400;
 int22_ar[G][U][U][A][G][U][C][G] =  1.800;
 int22_ar[G][U][U][A][U][A][C][G] =  2.000;
 int22_ar[G][U][U][A][U][C][C][G] =  2.000;
 int22_ar[G][U][U][A][U][G][C][G] =  2.000;
 int22_ar[G][U][U][A][U][U][C][G] =  2.000;
 int22_ar[G][U][U][C][A][A][C][G] =  2.000;
 int22_ar[G][U][U][C][A][C][C][G] =  2.100;
 int22_ar[G][U][U][C][A][G][C][G] =  0.000;
 int22_ar[G][U][U][C][A][U][C][G] =  1.300;
 int22_ar[G][U][U][C][C][A][C][G] =  2.000;
 int22_ar[G][U][U][C][C][C][C][G] =  1.900;
 int22_ar[G][U][U][C][C][G][C][G] =  0.800;
 int22_ar[G][U][U][C][C][U][C][G] =  1.100;
 int22_ar[G][U][U][C][G][A][C][G] =  2.000;
 int22_ar[G][U][U][C][G][C][C][G] =  2.000;
 int22_ar[G][U][U][C][G][G][C][G] =  2.000;
 int22_ar[G][U][U][C][G][U][C][G] =  2.000;
 int22_ar[G][U][U][C][U][A][C][G] =  2.000;
 int22_ar[G][U][U][C][U][C][C][G] =  1.800;
 int22_ar[G][U][U][C][U][G][C][G] =  0.700;
 int22_ar[G][U][U][C][U][U][C][G] =  1.000;
 int22_ar[G][U][U][G][A][A][C][G] =  2.000;
 int22_ar[G][U][U][G][A][C][C][G] =  1.700;
 int22_ar[G][U][U][G][A][G][C][G] =  0.400;
 int22_ar[G][U][U][G][A][U][C][G] =  1.800;
 int22_ar[G][U][U][G][C][A][C][G] =  2.000;
 int22_ar[G][U][U][G][C][C][C][G] =  2.000;
 int22_ar[G][U][U][G][C][G][C][G] =  2.000;
 int22_ar[G][U][U][G][C][U][C][G] =  2.000;
 int22_ar[G][U][U][G][G][A][C][G] =  2.000;
 int22_ar[G][U][U][G][G][C][C][G] =  2.100;
 int22_ar[G][U][U][G][G][G][C][G] =  0.400;
 int22_ar[G][U][U][G][G][U][C][G] =  1.700;
 int22_ar[G][U][U][G][U][A][C][G] =  2.000;
 int22_ar[G][U][U][G][U][C][C][G] =  0.000;
 int22_ar[G][U][U][G][U][G][C][G] = -3.100;
 int22_ar[G][U][U][G][U][U][C][G] =  0.000;
 int22_ar[G][U][U][U][A][A][C][G] =  2.000;
 int22_ar[G][U][U][U][A][C][C][G] =  2.000;
 int22_ar[G][U][U][U][A][G][C][G] =  2.000;
 int22_ar[G][U][U][U][A][U][C][G] =  2.000;
 int22_ar[G][U][U][U][C][A][C][G] =  2.000;
 int22_ar[G][U][U][U][C][C][C][G] =  1.800;
 int22_ar[G][U][U][U][C][G][C][G] =  0.700;
 int22_ar[G][U][U][U][C][U][C][G] =  1.000;
 int22_ar[G][U][U][U][G][A][C][G] =  2.000;
 int22_ar[G][U][U][U][G][C][C][G] =  1.500;
 int22_ar[G][U][U][U][G][G][C][G] = -1.600;
 int22_ar[G][U][U][U][G][U][C][G] =  1.600;
 int22_ar[G][U][U][U][U][A][C][G] =  2.000;
 int22_ar[G][U][U][U][U][C][C][G] =  0.900;
 int22_ar[G][U][U][U][U][G][C][G] =  0.600;
 int22_ar[G][U][U][U][U][U][C][G] =  0.100;
 int22_ar[G][U][A][A][A][A][G][C] =  2.100;
 int22_ar[G][U][A][A][A][C][G][C] =  2.000;
 int22_ar[G][U][A][A][A][G][G][C] =  0.900;
 int22_ar[G][U][A][A][A][U][G][C] =  2.000;
 int22_ar[G][U][A][A][C][A][G][C] =  1.900;
 int22_ar[G][U][A][A][C][C][G][C] =  1.700;
 int22_ar[G][U][A][A][C][G][G][C] =  0.600;
 int22_ar[G][U][A][A][C][U][G][C] =  2.000;
 int22_ar[G][U][A][A][G][A][G][C] =  0.100;
 int22_ar[G][U][A][A][G][C][G][C] =  0.000;
 int22_ar[G][U][A][A][G][G][G][C] = -1.100;
 int22_ar[G][U][A][A][G][U][G][C] =  2.000;
 int22_ar[G][U][A][A][U][A][G][C] =  2.000;
 int22_ar[G][U][A][A][U][C][G][C] =  2.000;
 int22_ar[G][U][A][A][U][G][G][C] =  2.000;
 int22_ar[G][U][A][A][U][U][G][C] =  2.000;
 int22_ar[G][U][A][C][A][A][G][C] =  1.800;
 int22_ar[G][U][A][C][A][C][G][C] =  1.700;
 int22_ar[G][U][A][C][A][G][G][C] =  0.600;
 int22_ar[G][U][A][C][A][U][G][C] =  2.000;
 int22_ar[G][U][A][C][C][A][G][C] =  2.500;
 int22_ar[G][U][A][C][C][C][G][C] =  1.700;
 int22_ar[G][U][A][C][C][G][G][C] =  1.600;
 int22_ar[G][U][A][C][C][U][G][C] =  2.000;
 int22_ar[G][U][A][C][G][A][G][C] =  2.000;
 int22_ar[G][U][A][C][G][C][G][C] =  2.000;
 int22_ar[G][U][A][C][G][G][G][C] =  2.000;
 int22_ar[G][U][A][C][G][U][G][C] =  2.000;
 int22_ar[G][U][A][C][U][A][G][C] =  1.500;
 int22_ar[G][U][A][C][U][C][G][C] =  0.700;
 int22_ar[G][U][A][C][U][G][G][C] =  0.700;
 int22_ar[G][U][A][C][U][U][G][C] =  2.000;
 int22_ar[G][U][A][G][A][A][G][C] =  0.700;
 int22_ar[G][U][A][G][A][C][G][C] =  0.600;
 int22_ar[G][U][A][G][A][G][G][C] = -0.500;
 int22_ar[G][U][A][G][A][U][G][C] =  2.000;
 int22_ar[G][U][A][G][C][A][G][C] =  2.000;
 int22_ar[G][U][A][G][C][C][G][C] =  2.000;
 int22_ar[G][U][A][G][C][G][G][C] =  2.000;
 int22_ar[G][U][A][G][C][U][G][C] =  2.000;
 int22_ar[G][U][A][G][G][A][G][C] =  1.800;
 int22_ar[G][U][A][G][G][C][G][C] =  1.600;
 int22_ar[G][U][A][G][G][G][G][C] =  0.500;
 int22_ar[G][U][A][G][G][U][G][C] =  2.000;
 int22_ar[G][U][A][G][U][A][G][C] =  0.000;
 int22_ar[G][U][A][G][U][C][G][C] = -1.200;
 int22_ar[G][U][A][G][U][G][G][C] = -0.500;
 int22_ar[G][U][A][G][U][U][G][C] =  2.000;
 int22_ar[G][U][A][U][A][A][G][C] =  2.000;
 int22_ar[G][U][A][U][A][C][G][C] =  2.000;
 int22_ar[G][U][A][U][A][G][G][C] =  2.000;
 int22_ar[G][U][A][U][A][U][G][C] =  2.000;
 int22_ar[G][U][A][U][C][A][G][C] =  2.500;
 int22_ar[G][U][A][U][C][C][G][C] =  1.800;
 int22_ar[G][U][A][U][C][G][G][C] =  1.700;
 int22_ar[G][U][A][U][C][U][G][C] =  2.000;
 int22_ar[G][U][A][U][G][A][G][C] =  0.400;
 int22_ar[G][U][A][U][G][C][G][C] = -0.800;
 int22_ar[G][U][A][U][G][G][G][C] = -0.100;
 int22_ar[G][U][A][U][G][U][G][C] =  2.000;
 int22_ar[G][U][A][U][U][A][G][C] =  2.100;
 int22_ar[G][U][A][U][U][C][G][C] =  1.000;
 int22_ar[G][U][A][U][U][G][G][C] =  1.700;
 int22_ar[G][U][A][U][U][U][G][C] =  2.000;
 int22_ar[G][U][C][A][A][A][G][C] =  1.900;
 int22_ar[G][U][C][A][A][C][G][C] =  2.400;
 int22_ar[G][U][C][A][A][G][G][C] =  2.000;
 int22_ar[G][U][C][A][A][U][G][C] =  2.400;
 int22_ar[G][U][C][A][C][A][G][C] =  1.600;
 int22_ar[G][U][C][A][C][C][G][C] =  1.600;
 int22_ar[G][U][C][A][C][G][G][C] =  2.000;
 int22_ar[G][U][C][A][C][U][G][C] =  1.600;
 int22_ar[G][U][C][A][G][A][G][C] = -0.100;
 int22_ar[G][U][C][A][G][C][G][C] =  0.800;
 int22_ar[G][U][C][A][G][G][G][C] =  2.000;
 int22_ar[G][U][C][A][G][U][G][C] =  0.800;
 int22_ar[G][U][C][A][U][A][G][C] =  2.000;
 int22_ar[G][U][C][A][U][C][G][C] =  2.000;
 int22_ar[G][U][C][A][U][G][G][C] =  2.000;
 int22_ar[G][U][C][A][U][U][G][C] =  2.000;
 int22_ar[G][U][C][C][A][A][G][C] =  1.600;
 int22_ar[G][U][C][C][A][C][G][C] =  1.500;
 int22_ar[G][U][C][C][A][G][G][C] =  2.000;
 int22_ar[G][U][C][C][A][U][G][C] =  1.500;
 int22_ar[G][U][C][C][C][A][G][C] =  1.600;
 int22_ar[G][U][C][C][C][C][G][C] =  1.600;
 int22_ar[G][U][C][C][C][G][G][C] =  2.000;
 int22_ar[G][U][C][C][C][U][G][C] =  1.600;
 int22_ar[G][U][C][C][G][A][G][C] =  2.000;
 int22_ar[G][U][C][C][G][C][G][C] =  2.000;
 int22_ar[G][U][C][C][G][G][G][C] =  2.000;
 int22_ar[G][U][C][C][G][U][G][C] =  2.000;
 int22_ar[G][U][C][C][U][A][G][C] =  0.600;
 int22_ar[G][U][C][C][U][C][G][C] =  0.600;
 int22_ar[G][U][C][C][U][G][G][C] =  2.000;
 int22_ar[G][U][C][C][U][U][G][C] =  0.600;
 int22_ar[G][U][C][G][A][A][G][C] =  0.500;
 int22_ar[G][U][C][G][A][C][G][C] =  1.400;
 int22_ar[G][U][C][G][A][G][G][C] =  2.000;
 int22_ar[G][U][C][G][A][U][G][C] =  1.400;
 int22_ar[G][U][C][G][C][A][G][C] =  2.000;
 int22_ar[G][U][C][G][C][C][G][C] =  2.000;
 int22_ar[G][U][C][G][C][G][G][C] =  2.000;
 int22_ar[G][U][C][G][C][U][G][C] =  2.000;
 int22_ar[G][U][C][G][G][A][G][C] =  1.500;
 int22_ar[G][U][C][G][G][C][G][C] =  2.100;
 int22_ar[G][U][C][G][G][G][G][C] =  2.000;
 int22_ar[G][U][C][G][G][U][G][C] =  2.100;
 int22_ar[G][U][C][G][U][A][G][C] = -1.300;
 int22_ar[G][U][C][G][U][C][G][C] = -0.300;
 int22_ar[G][U][C][G][U][G][G][C] =  2.000;
 int22_ar[G][U][C][G][U][U][G][C] = -0.300;
 int22_ar[G][U][C][U][A][A][G][C] =  2.000;
 int22_ar[G][U][C][U][A][C][G][C] =  2.000;
 int22_ar[G][U][C][U][A][G][G][C] =  2.000;
 int22_ar[G][U][C][U][A][U][G][C] =  2.000;
 int22_ar[G][U][C][U][C][A][G][C] =  1.700;
 int22_ar[G][U][C][U][C][C][G][C] =  1.600;
 int22_ar[G][U][C][U][C][G][G][C] =  2.000;
 int22_ar[G][U][C][U][C][U][G][C] =  1.600;
 int22_ar[G][U][C][U][G][A][G][C] = -0.900;
 int22_ar[G][U][C][U][G][C][G][C] =  0.100;
 int22_ar[G][U][C][U][G][G][G][C] =  2.000;
 int22_ar[G][U][C][U][G][U][G][C] =  0.100;
 int22_ar[G][U][C][U][U][A][G][C] =  0.900;
 int22_ar[G][U][C][U][U][C][G][C] =  0.800;
 int22_ar[G][U][C][U][U][G][G][C] =  2.000;
 int22_ar[G][U][C][U][U][U][G][C] =  0.800;
 int22_ar[G][U][G][A][A][A][G][C] =  0.900;
 int22_ar[G][U][G][A][A][C][G][C] =  2.000;
 int22_ar[G][U][G][A][A][G][G][C] =  1.400;
 int22_ar[G][U][G][A][A][U][G][C] =  1.700;
 int22_ar[G][U][G][A][C][A][G][C] =  0.600;
 int22_ar[G][U][G][A][C][C][G][C] =  2.000;
 int22_ar[G][U][G][A][C][G][G][C] =  1.200;
 int22_ar[G][U][G][A][C][U][G][C] =  0.400;
 int22_ar[G][U][G][A][G][A][G][C] = -1.100;
 int22_ar[G][U][G][A][G][C][G][C] =  2.000;
 int22_ar[G][U][G][A][G][G][G][C] = -0.600;
 int22_ar[G][U][G][A][G][U][G][C] =  0.500;
 int22_ar[G][U][G][A][U][A][G][C] =  2.000;
 int22_ar[G][U][G][A][U][C][G][C] =  2.000;
 int22_ar[G][U][G][A][U][G][G][C] =  2.000;
 int22_ar[G][U][G][A][U][U][G][C] =  2.000;
 int22_ar[G][U][G][C][A][A][G][C] =  0.600;
 int22_ar[G][U][G][C][A][C][G][C] =  2.000;
 int22_ar[G][U][G][C][A][G][G][C] =  1.100;
 int22_ar[G][U][G][C][A][U][G][C] =  0.400;
 int22_ar[G][U][G][C][C][A][G][C] =  1.600;
 int22_ar[G][U][G][C][C][C][G][C] =  2.000;
 int22_ar[G][U][G][C][C][G][G][C] =  1.800;
 int22_ar[G][U][G][C][C][U][G][C] =  1.400;
 int22_ar[G][U][G][C][G][A][G][C] =  2.000;
 int22_ar[G][U][G][C][G][C][G][C] =  2.000;
 int22_ar[G][U][G][C][G][G][G][C] =  2.000;
 int22_ar[G][U][G][C][G][U][G][C] =  2.000;
 int22_ar[G][U][G][C][U][A][G][C] =  0.700;
 int22_ar[G][U][G][C][U][C][G][C] =  2.000;
 int22_ar[G][U][G][C][U][G][G][C] =  0.800;
 int22_ar[G][U][G][C][U][U][G][C] =  0.500;
 int22_ar[G][U][G][G][A][A][G][C] = -0.500;
 int22_ar[G][U][G][G][A][C][G][C] =  2.000;
 int22_ar[G][U][G][G][A][G][G][C] =  0.000;
 int22_ar[G][U][G][G][A][U][G][C] =  1.100;
 int22_ar[G][U][G][G][C][A][G][C] =  2.000;
 int22_ar[G][U][G][G][C][C][G][C] =  2.000;
 int22_ar[G][U][G][G][C][G][G][C] =  2.000;
 int22_ar[G][U][G][G][C][U][G][C] =  2.000;
 int22_ar[G][U][G][G][G][A][G][C] =  0.500;
 int22_ar[G][U][G][G][G][C][G][C] =  2.000;
 int22_ar[G][U][G][G][G][G][G][C] =  1.100;
 int22_ar[G][U][G][G][G][U][G][C] =  1.300;
 int22_ar[G][U][G][G][U][A][G][C] = -0.500;
 int22_ar[G][U][G][G][U][C][G][C] =  2.000;
 int22_ar[G][U][G][G][U][G][G][C] = -0.700;
 int22_ar[G][U][G][G][U][U][G][C] = -2.500;
 int22_ar[G][U][G][U][A][A][G][C] =  2.000;
 int22_ar[G][U][G][U][A][C][G][C] =  2.000;
 int22_ar[G][U][G][U][A][G][G][C] =  2.000;
 int22_ar[G][U][G][U][A][U][G][C] =  2.000;
 int22_ar[G][U][G][U][C][A][G][C] =  1.700;
 int22_ar[G][U][G][U][C][C][G][C] =  2.000;
 int22_ar[G][U][G][U][C][G][G][C] =  1.800;
 int22_ar[G][U][G][U][C][U][G][C] =  1.500;
 int22_ar[G][U][G][U][G][A][G][C] = -0.100;
 int22_ar[G][U][G][U][G][C][G][C] =  2.000;
 int22_ar[G][U][G][U][G][G][G][C] = -0.300;
 int22_ar[G][U][G][U][G][U][G][C] = -2.100;
 int22_ar[G][U][G][U][U][A][G][C] =  1.700;
 int22_ar[G][U][G][U][U][C][G][C] =  2.000;
 int22_ar[G][U][G][U][U][G][G][C] =  1.400;
 int22_ar[G][U][G][U][U][U][G][C] =  1.500;
 int22_ar[G][U][U][A][A][A][G][C] =  2.000;
 int22_ar[G][U][U][A][A][C][G][C] =  2.400;
 int22_ar[G][U][U][A][A][G][G][C] =  0.700;
 int22_ar[G][U][U][A][A][U][G][C] =  2.000;
 int22_ar[G][U][U][A][C][A][G][C] =  2.000;
 int22_ar[G][U][U][A][C][C][G][C] =  1.600;
 int22_ar[G][U][U][A][C][G][G][C] = -0.500;
 int22_ar[G][U][U][A][C][U][G][C] =  0.800;
 int22_ar[G][U][U][A][G][A][G][C] =  2.000;
 int22_ar[G][U][U][A][G][C][G][C] =  0.800;
 int22_ar[G][U][U][A][G][G][G][C] = -0.500;
 int22_ar[G][U][U][A][G][U][G][C] =  0.800;
 int22_ar[G][U][U][A][U][A][G][C] =  2.000;
 int22_ar[G][U][U][A][U][C][G][C] =  2.000;
 int22_ar[G][U][U][A][U][G][G][C] =  2.000;
 int22_ar[G][U][U][A][U][U][G][C] =  2.000;
 int22_ar[G][U][U][C][A][A][G][C] =  2.000;
 int22_ar[G][U][U][C][A][C][G][C] =  1.500;
 int22_ar[G][U][U][C][A][G][G][C] = -0.600;
 int22_ar[G][U][U][C][A][U][G][C] =  0.700;
 int22_ar[G][U][U][C][C][A][G][C] =  2.000;
 int22_ar[G][U][U][C][C][C][G][C] =  1.600;
 int22_ar[G][U][U][C][C][G][G][C] =  0.500;
 int22_ar[G][U][U][C][C][U][G][C] =  0.800;
 int22_ar[G][U][U][C][G][A][G][C] =  2.000;
 int22_ar[G][U][U][C][G][C][G][C] =  2.000;
 int22_ar[G][U][U][C][G][G][G][C] =  2.000;
 int22_ar[G][U][U][C][G][U][G][C] =  2.000;
 int22_ar[G][U][U][C][U][A][G][C] =  2.000;
 int22_ar[G][U][U][C][U][C][G][C] =  0.600;
 int22_ar[G][U][U][C][U][G][G][C] = -0.500;
 int22_ar[G][U][U][C][U][U][G][C] = -0.200;
 int22_ar[G][U][U][G][A][A][G][C] =  2.000;
 int22_ar[G][U][U][G][A][C][G][C] =  1.400;
 int22_ar[G][U][U][G][A][G][G][C] =  0.100;
 int22_ar[G][U][U][G][A][U][G][C] =  1.500;
 int22_ar[G][U][U][G][C][A][G][C] =  2.000;
 int22_ar[G][U][U][G][C][C][G][C] =  2.000;
 int22_ar[G][U][U][G][C][G][G][C] =  2.000;
 int22_ar[G][U][U][G][C][U][G][C] =  2.000;
 int22_ar[G][U][U][G][G][A][G][C] =  2.000;
 int22_ar[G][U][U][G][G][C][G][C] =  2.100;
 int22_ar[G][U][U][G][G][G][G][C] =  0.400;
 int22_ar[G][U][U][G][G][U][G][C] =  1.700;
 int22_ar[G][U][U][G][U][A][G][C] =  2.000;
 int22_ar[G][U][U][G][U][C][G][C] = -0.300;
 int22_ar[G][U][U][G][U][G][G][C] = -3.500;
 int22_ar[G][U][U][G][U][U][G][C] = -0.300;
 int22_ar[G][U][U][U][A][A][G][C] =  2.000;
 int22_ar[G][U][U][U][A][C][G][C] =  2.000;
 int22_ar[G][U][U][U][A][G][G][C] =  2.000;
 int22_ar[G][U][U][U][A][U][G][C] =  2.000;
 int22_ar[G][U][U][U][C][A][G][C] =  2.000;
 int22_ar[G][U][U][U][C][C][G][C] =  1.600;
 int22_ar[G][U][U][U][C][G][G][C] =  0.500;
 int22_ar[G][U][U][U][C][U][G][C] =  0.800;
 int22_ar[G][U][U][U][G][A][G][C] =  2.000;
 int22_ar[G][U][U][U][G][C][G][C] =  0.100;
 int22_ar[G][U][U][U][G][G][G][C] = -3.100;
 int22_ar[G][U][U][U][G][U][G][C] =  0.100;
 int22_ar[G][U][U][U][U][A][G][C] =  2.000;
 int22_ar[G][U][U][U][U][C][G][C] =  0.800;
 int22_ar[G][U][U][U][U][G][G][C] =  0.500;
 int22_ar[G][U][U][U][U][U][G][C] =  0.000;
 int22_ar[G][U][A][A][A][A][G][U] =  2.800;
 int22_ar[G][U][A][A][A][C][G][U] =  2.600;
 int22_ar[G][U][A][A][A][G][G][U] =  1.500;
 int22_ar[G][U][A][A][A][U][G][U] =  2.000;
 int22_ar[G][U][A][A][C][A][G][U] =  2.500;
 int22_ar[G][U][A][A][C][C][G][U] =  2.400;
 int22_ar[G][U][A][A][C][G][G][U] =  1.300;
 int22_ar[G][U][A][A][C][U][G][U] =  2.000;
 int22_ar[G][U][A][A][G][A][G][U] =  1.500;
 int22_ar[G][U][A][A][G][C][G][U] =  1.400;
 int22_ar[G][U][A][A][G][G][G][U] =  0.300;
 int22_ar[G][U][A][A][G][U][G][U] =  2.000;
 int22_ar[G][U][A][A][U][A][G][U] =  2.000;
 int22_ar[G][U][A][A][U][C][G][U] =  2.000;
 int22_ar[G][U][A][A][U][G][G][U] =  2.000;
 int22_ar[G][U][A][A][U][U][G][U] =  2.000;
 int22_ar[G][U][A][C][A][A][G][U] =  2.600;
 int22_ar[G][U][A][C][A][C][G][U] =  2.500;
 int22_ar[G][U][A][C][A][G][G][U] =  1.400;
 int22_ar[G][U][A][C][A][U][G][U] =  2.000;
 int22_ar[G][U][A][C][C][A][G][U] =  3.100;
 int22_ar[G][U][A][C][C][C][G][U] =  2.300;
 int22_ar[G][U][A][C][C][G][G][U] =  2.200;
 int22_ar[G][U][A][C][C][U][G][U] =  2.000;
 int22_ar[G][U][A][C][G][A][G][U] =  2.000;
 int22_ar[G][U][A][C][G][C][G][U] =  2.000;
 int22_ar[G][U][A][C][G][G][G][U] =  2.000;
 int22_ar[G][U][A][C][G][U][G][U] =  2.000;
 int22_ar[G][U][A][C][U][A][G][U] =  3.100;
 int22_ar[G][U][A][C][U][C][G][U] =  2.300;
 int22_ar[G][U][A][C][U][G][G][U] =  2.200;
 int22_ar[G][U][A][C][U][U][G][U] =  2.000;
 int22_ar[G][U][A][G][A][A][G][U] =  1.500;
 int22_ar[G][U][A][G][A][C][G][U] =  1.400;
 int22_ar[G][U][A][G][A][G][G][U] =  0.300;
 int22_ar[G][U][A][G][A][U][G][U] =  2.000;
 int22_ar[G][U][A][G][C][A][G][U] =  2.000;
 int22_ar[G][U][A][G][C][C][G][U] =  2.000;
 int22_ar[G][U][A][G][C][G][G][U] =  2.000;
 int22_ar[G][U][A][G][C][U][G][U] =  2.000;
 int22_ar[G][U][A][G][G][A][G][U] =  2.100;
 int22_ar[G][U][A][G][G][C][G][U] =  1.900;
 int22_ar[G][U][A][G][G][G][G][U] =  0.800;
 int22_ar[G][U][A][G][G][U][G][U] =  2.000;
 int22_ar[G][U][A][G][U][A][G][U] =  1.300;
 int22_ar[G][U][A][G][U][C][G][U] =  0.200;
 int22_ar[G][U][A][G][U][G][G][U] =  0.900;
 int22_ar[G][U][A][G][U][U][G][U] =  2.000;
 int22_ar[G][U][A][U][A][A][G][U] =  2.000;
 int22_ar[G][U][A][U][A][C][G][U] =  2.000;
 int22_ar[G][U][A][U][A][G][G][U] =  2.000;
 int22_ar[G][U][A][U][A][U][G][U] =  2.000;
 int22_ar[G][U][A][U][C][A][G][U] =  3.100;
 int22_ar[G][U][A][U][C][C][G][U] =  2.300;
 int22_ar[G][U][A][U][C][G][G][U] =  2.200;
 int22_ar[G][U][A][U][C][U][G][U] =  2.000;
 int22_ar[G][U][A][U][G][A][G][U] =  2.300;
 int22_ar[G][U][A][U][G][C][G][U] =  1.200;
 int22_ar[G][U][A][U][G][G][G][U] =  1.900;
 int22_ar[G][U][A][U][G][U][G][U] =  2.000;
 int22_ar[G][U][A][U][U][A][G][U] =  2.700;
 int22_ar[G][U][A][U][U][C][G][U] =  1.500;
 int22_ar[G][U][A][U][U][G][G][U] =  2.200;
 int22_ar[G][U][A][U][U][U][G][U] =  2.000;
 int22_ar[G][U][C][A][A][A][G][U] =  2.500;
 int22_ar[G][U][C][A][A][C][G][U] =  3.100;
 int22_ar[G][U][C][A][A][G][G][U] =  2.000;
 int22_ar[G][U][C][A][A][U][G][U] =  3.100;
 int22_ar[G][U][C][A][C][A][G][U] =  2.300;
 int22_ar[G][U][C][A][C][C][G][U] =  2.200;
 int22_ar[G][U][C][A][C][G][G][U] =  2.000;
 int22_ar[G][U][C][A][C][U][G][U] =  2.200;
 int22_ar[G][U][C][A][G][A][G][U] =  1.300;
 int22_ar[G][U][C][A][G][C][G][U] =  2.200;
 int22_ar[G][U][C][A][G][G][G][U] =  2.000;
 int22_ar[G][U][C][A][G][U][G][U] =  2.200;
 int22_ar[G][U][C][A][U][A][G][U] =  2.000;
 int22_ar[G][U][C][A][U][C][G][U] =  2.000;
 int22_ar[G][U][C][A][U][G][G][U] =  2.000;
 int22_ar[G][U][C][A][U][U][G][U] =  2.000;
 int22_ar[G][U][C][C][A][A][G][U] =  2.400;
 int22_ar[G][U][C][C][A][C][G][U] =  2.300;
 int22_ar[G][U][C][C][A][G][G][U] =  2.000;
 int22_ar[G][U][C][C][A][U][G][U] =  2.300;
 int22_ar[G][U][C][C][C][A][G][U] =  2.200;
 int22_ar[G][U][C][C][C][C][G][U] =  2.200;
 int22_ar[G][U][C][C][C][G][G][U] =  2.000;
 int22_ar[G][U][C][C][C][U][G][U] =  2.200;
 int22_ar[G][U][C][C][G][A][G][U] =  2.000;
 int22_ar[G][U][C][C][G][C][G][U] =  2.000;
 int22_ar[G][U][C][C][G][G][G][U] =  2.000;
 int22_ar[G][U][C][C][G][U][G][U] =  2.000;
 int22_ar[G][U][C][C][U][A][G][U] =  2.200;
 int22_ar[G][U][C][C][U][C][G][U] =  2.200;
 int22_ar[G][U][C][C][U][G][G][U] =  2.000;
 int22_ar[G][U][C][C][U][U][G][U] =  2.200;
 int22_ar[G][U][C][G][A][A][G][U] =  1.300;
 int22_ar[G][U][C][G][A][C][G][U] =  2.200;
 int22_ar[G][U][C][G][A][G][G][U] =  2.000;
 int22_ar[G][U][C][G][A][U][G][U] =  2.200;
 int22_ar[G][U][C][G][C][A][G][U] =  2.000;
 int22_ar[G][U][C][G][C][C][G][U] =  2.000;
 int22_ar[G][U][C][G][C][G][G][U] =  2.000;
 int22_ar[G][U][C][G][C][U][G][U] =  2.000;
 int22_ar[G][U][C][G][G][A][G][U] =  1.800;
 int22_ar[G][U][C][G][G][C][G][U] =  2.400;
 int22_ar[G][U][C][G][G][G][G][U] =  2.000;
 int22_ar[G][U][C][G][G][U][G][U] =  2.400;
 int22_ar[G][U][C][G][U][A][G][U] =  0.100;
 int22_ar[G][U][C][G][U][C][G][U] =  1.000;
 int22_ar[G][U][C][G][U][G][G][U] =  2.000;
 int22_ar[G][U][C][G][U][U][G][U] =  1.000;
 int22_ar[G][U][C][U][A][A][G][U] =  2.000;
 int22_ar[G][U][C][U][A][C][G][U] =  2.000;
 int22_ar[G][U][C][U][A][G][G][U] =  2.000;
 int22_ar[G][U][C][U][A][U][G][U] =  2.000;
 int22_ar[G][U][C][U][C][A][G][U] =  2.200;
 int22_ar[G][U][C][U][C][C][G][U] =  2.200;
 int22_ar[G][U][C][U][C][G][G][U] =  2.000;
 int22_ar[G][U][C][U][C][U][G][U] =  2.200;
 int22_ar[G][U][C][U][G][A][G][U] =  1.100;
 int22_ar[G][U][C][U][G][C][G][U] =  2.000;
 int22_ar[G][U][C][U][G][G][G][U] =  2.000;
 int22_ar[G][U][C][U][G][U][G][U] =  2.000;
 int22_ar[G][U][C][U][U][A][G][U] =  1.400;
 int22_ar[G][U][C][U][U][C][G][U] =  1.400;
 int22_ar[G][U][C][U][U][G][G][U] =  2.000;
 int22_ar[G][U][C][U][U][U][G][U] =  1.400;
 int22_ar[G][U][G][A][A][A][G][U] =  1.500;
 int22_ar[G][U][G][A][A][C][G][U] =  2.000;
 int22_ar[G][U][G][A][A][G][G][U] =  2.100;
 int22_ar[G][U][G][A][A][U][G][U] =  2.300;
 int22_ar[G][U][G][A][C][A][G][U] =  1.300;
 int22_ar[G][U][G][A][C][C][G][U] =  2.000;
 int22_ar[G][U][G][A][C][G][G][U] =  1.800;
 int22_ar[G][U][G][A][C][U][G][U] =  1.100;
 int22_ar[G][U][G][A][G][A][G][U] =  0.300;
 int22_ar[G][U][G][A][G][C][G][U] =  2.000;
 int22_ar[G][U][G][A][G][G][G][U] =  0.800;
 int22_ar[G][U][G][A][G][U][G][U] =  1.900;
 int22_ar[G][U][G][A][U][A][G][U] =  2.000;
 int22_ar[G][U][G][A][U][C][G][U] =  2.000;
 int22_ar[G][U][G][A][U][G][G][U] =  2.000;
 int22_ar[G][U][G][A][U][U][G][U] =  2.000;
 int22_ar[G][U][G][C][A][A][G][U] =  1.400;
 int22_ar[G][U][G][C][A][C][G][U] =  2.000;
 int22_ar[G][U][G][C][A][G][G][U] =  1.900;
 int22_ar[G][U][G][C][A][U][G][U] =  1.200;
 int22_ar[G][U][G][C][C][A][G][U] =  2.200;
 int22_ar[G][U][G][C][C][C][G][U] =  2.000;
 int22_ar[G][U][G][C][C][G][G][U] =  2.400;
 int22_ar[G][U][G][C][C][U][G][U] =  2.000;
 int22_ar[G][U][G][C][G][A][G][U] =  2.000;
 int22_ar[G][U][G][C][G][C][G][U] =  2.000;
 int22_ar[G][U][G][C][G][G][G][U] =  2.000;
 int22_ar[G][U][G][C][G][U][G][U] =  2.000;
 int22_ar[G][U][G][C][U][A][G][U] =  2.200;
 int22_ar[G][U][G][C][U][C][G][U] =  2.000;
 int22_ar[G][U][G][C][U][G][G][U] =  2.400;
 int22_ar[G][U][G][C][U][U][G][U] =  2.000;
 int22_ar[G][U][G][G][A][A][G][U] =  0.300;
 int22_ar[G][U][G][G][A][C][G][U] =  2.000;
 int22_ar[G][U][G][G][A][G][G][U] =  0.800;
 int22_ar[G][U][G][G][A][U][G][U] =  1.900;
 int22_ar[G][U][G][G][C][A][G][U] =  2.000;
 int22_ar[G][U][G][G][C][C][G][U] =  2.000;
 int22_ar[G][U][G][G][C][G][G][U] =  2.000;
 int22_ar[G][U][G][G][C][U][G][U] =  2.000;
 int22_ar[G][U][G][G][G][A][G][U] =  0.800;
 int22_ar[G][U][G][G][G][C][G][U] =  2.000;
 int22_ar[G][U][G][G][G][G][G][U] =  1.400;
 int22_ar[G][U][G][G][G][U][G][U] =  1.600;
 int22_ar[G][U][G][G][U][A][G][U] =  0.900;
 int22_ar[G][U][G][G][U][C][G][U] =  2.000;
 int22_ar[G][U][G][G][U][G][G][U] =  0.700;
 int22_ar[G][U][G][G][U][U][G][U] = -1.100;
 int22_ar[G][U][G][U][A][A][G][U] =  2.000;
 int22_ar[G][U][G][U][A][C][G][U] =  2.000;
 int22_ar[G][U][G][U][A][G][G][U] =  2.000;
 int22_ar[G][U][G][U][A][U][G][U] =  2.000;
 int22_ar[G][U][G][U][C][A][G][U] =  2.200;
 int22_ar[G][U][G][U][C][C][G][U] =  2.000;
 int22_ar[G][U][G][U][C][G][G][U] =  2.400;
 int22_ar[G][U][G][U][C][U][G][U] =  2.000;
 int22_ar[G][U][G][U][G][A][G][U] =  1.900;
 int22_ar[G][U][G][U][G][C][G][U] =  2.000;
 int22_ar[G][U][G][U][G][G][G][U] =  1.600;
 int22_ar[G][U][G][U][G][U][G][U] = -0.100;
 int22_ar[G][U][G][U][U][A][G][U] =  2.200;
 int22_ar[G][U][G][U][U][C][G][U] =  2.000;
 int22_ar[G][U][G][U][U][G][G][U] =  2.000;
 int22_ar[G][U][G][U][U][U][G][U] =  2.000;
 int22_ar[G][U][U][A][A][A][G][U] =  2.000;
 int22_ar[G][U][U][A][A][C][G][U] =  3.100;
 int22_ar[G][U][U][A][A][G][G][U] =  1.300;
 int22_ar[G][U][U][A][A][U][G][U] =  2.700;
 int22_ar[G][U][U][A][C][A][G][U] =  2.000;
 int22_ar[G][U][U][A][C][C][G][U] =  2.200;
 int22_ar[G][U][U][A][C][G][G][U] =  0.100;
 int22_ar[G][U][U][A][C][U][G][U] =  1.400;
 int22_ar[G][U][U][A][G][A][G][U] =  2.000;
 int22_ar[G][U][U][A][G][C][G][U] =  2.200;
 int22_ar[G][U][U][A][G][G][G][U] =  0.900;
 int22_ar[G][U][U][A][G][U][G][U] =  2.200;
 int22_ar[G][U][U][A][U][A][G][U] =  2.000;
 int22_ar[G][U][U][A][U][C][G][U] =  2.000;
 int22_ar[G][U][U][A][U][G][G][U] =  2.000;
 int22_ar[G][U][U][A][U][U][G][U] =  2.000;
 int22_ar[G][U][U][C][A][A][G][U] =  2.000;
 int22_ar[G][U][U][C][A][C][G][U] =  2.300;
 int22_ar[G][U][U][C][A][G][G][U] =  0.200;
 int22_ar[G][U][U][C][A][U][G][U] =  1.500;
 int22_ar[G][U][U][C][C][A][G][U] =  2.000;
 int22_ar[G][U][U][C][C][C][G][U] =  2.200;
 int22_ar[G][U][U][C][C][G][G][U] =  1.000;
 int22_ar[G][U][U][C][C][U][G][U] =  1.400;
 int22_ar[G][U][U][C][G][A][G][U] =  2.000;
 int22_ar[G][U][U][C][G][C][G][U] =  2.000;
 int22_ar[G][U][U][C][G][G][G][U] =  2.000;
 int22_ar[G][U][U][C][G][U][G][U] =  2.000;
 int22_ar[G][U][U][C][U][A][G][U] =  2.000;
 int22_ar[G][U][U][C][U][C][G][U] =  2.200;
 int22_ar[G][U][U][C][U][G][G][U] =  1.000;
 int22_ar[G][U][U][C][U][U][G][U] =  1.400;
 int22_ar[G][U][U][G][A][A][G][U] =  2.000;
 int22_ar[G][U][U][G][A][C][G][U] =  2.200;
 int22_ar[G][U][U][G][A][G][G][U] =  0.900;
 int22_ar[G][U][U][G][A][U][G][U] =  2.200;
 int22_ar[G][U][U][G][C][A][G][U] =  2.000;
 int22_ar[G][U][U][G][C][C][G][U] =  2.000;
 int22_ar[G][U][U][G][C][G][G][U] =  2.000;
 int22_ar[G][U][U][G][C][U][G][U] =  2.000;
 int22_ar[G][U][U][G][G][A][G][U] =  2.000;
 int22_ar[G][U][U][G][G][C][G][U] =  2.400;
 int22_ar[G][U][U][G][G][G][G][U] =  0.700;
 int22_ar[G][U][U][G][G][U][G][U] =  2.000;
 int22_ar[G][U][U][G][U][A][G][U] =  2.000;
 int22_ar[G][U][U][G][U][C][G][U] =  1.000;
 int22_ar[G][U][U][G][U][G][G][U] = -2.100;
 int22_ar[G][U][U][G][U][U][G][U] =  1.100;
 int22_ar[G][U][U][U][A][A][G][U] =  2.000;
 int22_ar[G][U][U][U][A][C][G][U] =  2.000;
 int22_ar[G][U][U][U][A][G][G][U] =  2.000;
 int22_ar[G][U][U][U][A][U][G][U] =  2.000;
 int22_ar[G][U][U][U][C][A][G][U] =  2.000;
 int22_ar[G][U][U][U][C][C][G][U] =  2.200;
 int22_ar[G][U][U][U][C][G][G][U] =  1.000;
 int22_ar[G][U][U][U][C][U][G][U] =  1.400;
 int22_ar[G][U][U][U][G][A][G][U] =  2.000;
 int22_ar[G][U][U][U][G][C][G][U] =  2.000;
 int22_ar[G][U][U][U][G][G][G][U] = -1.100;
 int22_ar[G][U][U][U][G][U][G][U] =  2.000;
 int22_ar[G][U][U][U][U][A][G][U] =  2.000;
 int22_ar[G][U][U][U][U][C][G][U] =  1.400;
 int22_ar[G][U][U][U][U][G][G][U] =  1.100;
 int22_ar[G][U][U][U][U][U][G][U] =  0.600;
 int22_ar[G][U][A][A][A][A][U][A] =  2.800;
 int22_ar[G][U][A][A][A][C][U][A] =  2.600;
 int22_ar[G][U][A][A][A][G][U][A] =  1.500;
 int22_ar[G][U][A][A][A][U][U][A] =  2.000;
 int22_ar[G][U][A][A][C][A][U][A] =  2.300;
 int22_ar[G][U][A][A][C][C][U][A] =  2.200;
 int22_ar[G][U][A][A][C][G][U][A] =  1.100;
 int22_ar[G][U][A][A][C][U][U][A] =  2.000;
 int22_ar[G][U][A][A][G][A][U][A] =  1.700;
 int22_ar[G][U][A][A][G][C][U][A] =  1.600;
 int22_ar[G][U][A][A][G][G][U][A] =  0.500;
 int22_ar[G][U][A][A][G][U][U][A] =  2.000;
 int22_ar[G][U][A][A][U][A][U][A] =  2.000;
 int22_ar[G][U][A][A][U][C][U][A] =  2.000;
 int22_ar[G][U][A][A][U][G][U][A] =  2.000;
 int22_ar[G][U][A][A][U][U][U][A] =  2.000;
 int22_ar[G][U][A][C][A][A][U][A] =  2.800;
 int22_ar[G][U][A][C][A][C][U][A] =  2.600;
 int22_ar[G][U][A][C][A][G][U][A] =  1.500;
 int22_ar[G][U][A][C][A][U][U][A] =  2.000;
 int22_ar[G][U][A][C][C][A][U][A] =  3.400;
 int22_ar[G][U][A][C][C][C][U][A] =  2.600;
 int22_ar[G][U][A][C][C][G][U][A] =  2.500;
 int22_ar[G][U][A][C][C][U][U][A] =  2.000;
 int22_ar[G][U][A][C][G][A][U][A] =  2.000;
 int22_ar[G][U][A][C][G][C][U][A] =  2.000;
 int22_ar[G][U][A][C][G][G][U][A] =  2.000;
 int22_ar[G][U][A][C][G][U][U][A] =  2.000;
 int22_ar[G][U][A][C][U][A][U][A] =  3.400;
 int22_ar[G][U][A][C][U][C][U][A] =  2.600;
 int22_ar[G][U][A][C][U][G][U][A] =  2.500;
 int22_ar[G][U][A][C][U][U][U][A] =  2.000;
 int22_ar[G][U][A][G][A][A][U][A] =  1.700;
 int22_ar[G][U][A][G][A][C][U][A] =  1.600;
 int22_ar[G][U][A][G][A][G][U][A] =  0.500;
 int22_ar[G][U][A][G][A][U][U][A] =  2.000;
 int22_ar[G][U][A][G][C][A][U][A] =  2.000;
 int22_ar[G][U][A][G][C][C][U][A] =  2.000;
 int22_ar[G][U][A][G][C][G][U][A] =  2.000;
 int22_ar[G][U][A][G][C][U][U][A] =  2.000;
 int22_ar[G][U][A][G][G][A][U][A] =  2.100;
 int22_ar[G][U][A][G][G][C][U][A] =  2.000;
 int22_ar[G][U][A][G][G][G][U][A] =  0.900;
 int22_ar[G][U][A][G][G][U][U][A] =  2.000;
 int22_ar[G][U][A][G][U][A][U][A] =  1.000;
 int22_ar[G][U][A][G][U][C][U][A] = -0.200;
 int22_ar[G][U][A][G][U][G][U][A] =  0.500;
 int22_ar[G][U][A][G][U][U][U][A] =  2.000;
 int22_ar[G][U][A][U][A][A][U][A] =  2.000;
 int22_ar[G][U][A][U][A][C][U][A] =  2.000;
 int22_ar[G][U][A][U][A][G][U][A] =  2.000;
 int22_ar[G][U][A][U][A][U][U][A] =  2.000;
 int22_ar[G][U][A][U][C][A][U][A] =  3.100;
 int22_ar[G][U][A][U][C][C][U][A] =  2.300;
 int22_ar[G][U][A][U][C][G][U][A] =  2.200;
 int22_ar[G][U][A][U][C][U][U][A] =  2.000;
 int22_ar[G][U][A][U][G][A][U][A] =  2.200;
 int22_ar[G][U][A][U][G][C][U][A] =  1.100;
 int22_ar[G][U][A][U][G][G][U][A] =  1.800;
 int22_ar[G][U][A][U][G][U][U][A] =  2.000;
 int22_ar[G][U][A][U][U][A][U][A] =  2.900;
 int22_ar[G][U][A][U][U][C][U][A] =  1.800;
 int22_ar[G][U][A][U][U][G][U][A] =  2.500;
 int22_ar[G][U][A][U][U][U][U][A] =  2.000;
 int22_ar[G][U][C][A][A][A][U][A] =  2.500;
 int22_ar[G][U][C][A][A][C][U][A] =  3.100;
 int22_ar[G][U][C][A][A][G][U][A] =  2.000;
 int22_ar[G][U][C][A][A][U][U][A] =  3.100;
 int22_ar[G][U][C][A][C][A][U][A] =  2.100;
 int22_ar[G][U][C][A][C][C][U][A] =  2.000;
 int22_ar[G][U][C][A][C][G][U][A] =  2.000;
 int22_ar[G][U][C][A][C][U][U][A] =  2.000;
 int22_ar[G][U][C][A][G][A][U][A] =  1.500;
 int22_ar[G][U][C][A][G][C][U][A] =  2.400;
 int22_ar[G][U][C][A][G][G][U][A] =  2.000;
 int22_ar[G][U][C][A][G][U][U][A] =  2.400;
 int22_ar[G][U][C][A][U][A][U][A] =  2.000;
 int22_ar[G][U][C][A][U][C][U][A] =  2.000;
 int22_ar[G][U][C][A][U][G][U][A] =  2.000;
 int22_ar[G][U][C][A][U][U][U][A] =  2.000;
 int22_ar[G][U][C][C][A][A][U][A] =  2.500;
 int22_ar[G][U][C][C][A][C][U][A] =  2.500;
 int22_ar[G][U][C][C][A][G][U][A] =  2.000;
 int22_ar[G][U][C][C][A][U][U][A] =  2.500;
 int22_ar[G][U][C][C][C][A][U][A] =  2.500;
 int22_ar[G][U][C][C][C][C][U][A] =  2.500;
 int22_ar[G][U][C][C][C][G][U][A] =  2.000;
 int22_ar[G][U][C][C][C][U][U][A] =  2.500;
 int22_ar[G][U][C][C][G][A][U][A] =  2.000;
 int22_ar[G][U][C][C][G][C][U][A] =  2.000;
 int22_ar[G][U][C][C][G][G][U][A] =  2.000;
 int22_ar[G][U][C][C][G][U][U][A] =  2.000;
 int22_ar[G][U][C][C][U][A][U][A] =  2.500;
 int22_ar[G][U][C][C][U][C][U][A] =  2.500;
 int22_ar[G][U][C][C][U][G][U][A] =  2.000;
 int22_ar[G][U][C][C][U][U][U][A] =  2.500;
 int22_ar[G][U][C][G][A][A][U][A] =  1.500;
 int22_ar[G][U][C][G][A][C][U][A] =  2.400;
 int22_ar[G][U][C][G][A][G][U][A] =  2.000;
 int22_ar[G][U][C][G][A][U][U][A] =  2.400;
 int22_ar[G][U][C][G][C][A][U][A] =  2.000;
 int22_ar[G][U][C][G][C][C][U][A] =  2.000;
 int22_ar[G][U][C][G][C][G][U][A] =  2.000;
 int22_ar[G][U][C][G][C][U][U][A] =  2.000;
 int22_ar[G][U][C][G][G][A][U][A] =  1.900;
 int22_ar[G][U][C][G][G][C][U][A] =  2.400;
 int22_ar[G][U][C][G][G][G][U][A] =  2.000;
 int22_ar[G][U][C][G][G][U][U][A] =  2.400;
 int22_ar[G][U][C][G][U][A][U][A] = -0.300;
 int22_ar[G][U][C][G][U][C][U][A] =  0.700;
 int22_ar[G][U][C][G][U][G][U][A] =  2.000;
 int22_ar[G][U][C][G][U][U][U][A] =  0.700;
 int22_ar[G][U][C][U][A][A][U][A] =  2.000;
 int22_ar[G][U][C][U][A][C][U][A] =  2.000;
 int22_ar[G][U][C][U][A][G][U][A] =  2.000;
 int22_ar[G][U][C][U][A][U][U][A] =  2.000;
 int22_ar[G][U][C][U][C][A][U][A] =  2.200;
 int22_ar[G][U][C][U][C][C][U][A] =  2.200;
 int22_ar[G][U][C][U][C][G][U][A] =  2.000;
 int22_ar[G][U][C][U][C][U][U][A] =  2.200;
 int22_ar[G][U][C][U][G][A][U][A] =  1.000;
 int22_ar[G][U][C][U][G][C][U][A] =  1.900;
 int22_ar[G][U][C][U][G][G][U][A] =  2.000;
 int22_ar[G][U][C][U][G][U][U][A] =  1.900;
 int22_ar[G][U][C][U][U][A][U][A] =  1.700;
 int22_ar[G][U][C][U][U][C][U][A] =  1.600;
 int22_ar[G][U][C][U][U][G][U][A] =  2.000;
 int22_ar[G][U][C][U][U][U][U][A] =  1.600;
 int22_ar[G][U][G][A][A][A][U][A] =  1.500;
 int22_ar[G][U][G][A][A][C][U][A] =  2.000;
 int22_ar[G][U][G][A][A][G][U][A] =  2.100;
 int22_ar[G][U][G][A][A][U][U][A] =  2.300;
 int22_ar[G][U][G][A][C][A][U][A] =  1.100;
 int22_ar[G][U][G][A][C][C][U][A] =  2.000;
 int22_ar[G][U][G][A][C][G][U][A] =  1.600;
 int22_ar[G][U][G][A][C][U][U][A] =  0.900;
 int22_ar[G][U][G][A][G][A][U][A] =  0.500;
 int22_ar[G][U][G][A][G][C][U][A] =  2.000;
 int22_ar[G][U][G][A][G][G][U][A] =  1.000;
 int22_ar[G][U][G][A][G][U][U][A] =  2.100;
 int22_ar[G][U][G][A][U][A][U][A] =  2.000;
 int22_ar[G][U][G][A][U][C][U][A] =  2.000;
 int22_ar[G][U][G][A][U][G][U][A] =  2.000;
 int22_ar[G][U][G][A][U][U][U][A] =  2.000;
 int22_ar[G][U][G][C][A][A][U][A] =  1.500;
 int22_ar[G][U][G][C][A][C][U][A] =  2.000;
 int22_ar[G][U][G][C][A][G][U][A] =  2.100;
 int22_ar[G][U][G][C][A][U][U][A] =  1.300;
 int22_ar[G][U][G][C][C][A][U][A] =  2.500;
 int22_ar[G][U][G][C][C][C][U][A] =  2.000;
 int22_ar[G][U][G][C][C][G][U][A] =  2.700;
 int22_ar[G][U][G][C][C][U][U][A] =  2.300;
 int22_ar[G][U][G][C][G][A][U][A] =  2.000;
 int22_ar[G][U][G][C][G][C][U][A] =  2.000;
 int22_ar[G][U][G][C][G][G][U][A] =  2.000;
 int22_ar[G][U][G][C][G][U][U][A] =  2.000;
 int22_ar[G][U][G][C][U][A][U][A] =  2.500;
 int22_ar[G][U][G][C][U][C][U][A] =  2.000;
 int22_ar[G][U][G][C][U][G][U][A] =  2.700;
 int22_ar[G][U][G][C][U][U][U][A] =  2.300;
 int22_ar[G][U][G][G][A][A][U][A] =  0.500;
 int22_ar[G][U][G][G][A][C][U][A] =  2.000;
 int22_ar[G][U][G][G][A][G][U][A] =  1.000;
 int22_ar[G][U][G][G][A][U][U][A] =  2.100;
 int22_ar[G][U][G][G][C][A][U][A] =  2.000;
 int22_ar[G][U][G][G][C][C][U][A] =  2.000;
 int22_ar[G][U][G][G][C][G][U][A] =  2.000;
 int22_ar[G][U][G][G][C][U][U][A] =  2.000;
 int22_ar[G][U][G][G][G][A][U][A] =  0.900;
 int22_ar[G][U][G][G][G][C][U][A] =  2.000;
 int22_ar[G][U][G][G][G][G][U][A] =  1.400;
 int22_ar[G][U][G][G][G][U][U][A] =  1.700;
 int22_ar[G][U][G][G][U][A][U][A] =  0.500;
 int22_ar[G][U][G][G][U][C][U][A] =  2.000;
 int22_ar[G][U][G][G][U][G][U][A] =  0.300;
 int22_ar[G][U][G][G][U][U][U][A] = -1.500;
 int22_ar[G][U][G][U][A][A][U][A] =  2.000;
 int22_ar[G][U][G][U][A][C][U][A] =  2.000;
 int22_ar[G][U][G][U][A][G][U][A] =  2.000;
 int22_ar[G][U][G][U][A][U][U][A] =  2.000;
 int22_ar[G][U][G][U][C][A][U][A] =  2.200;
 int22_ar[G][U][G][U][C][C][U][A] =  2.000;
 int22_ar[G][U][G][U][C][G][U][A] =  2.400;
 int22_ar[G][U][G][U][C][U][U][A] =  2.000;
 int22_ar[G][U][G][U][G][A][U][A] =  1.800;
 int22_ar[G][U][G][U][G][C][U][A] =  2.000;
 int22_ar[G][U][G][U][G][G][U][A] =  1.500;
 int22_ar[G][U][G][U][G][U][U][A] = -0.200;
 int22_ar[G][U][G][U][U][A][U][A] =  2.500;
 int22_ar[G][U][G][U][U][C][U][A] =  2.000;
 int22_ar[G][U][G][U][U][G][U][A] =  2.200;
 int22_ar[G][U][G][U][U][U][U][A] =  2.300;
 int22_ar[G][U][U][A][A][A][U][A] =  2.000;
 int22_ar[G][U][U][A][A][C][U][A] =  3.100;
 int22_ar[G][U][U][A][A][G][U][A] =  1.300;
 int22_ar[G][U][U][A][A][U][U][A] =  2.700;
 int22_ar[G][U][U][A][C][A][U][A] =  2.000;
 int22_ar[G][U][U][A][C][C][U][A] =  2.000;
 int22_ar[G][U][U][A][C][G][U][A] = -0.100;
 int22_ar[G][U][U][A][C][U][U][A] =  1.200;
 int22_ar[G][U][U][A][G][A][U][A] =  2.000;
 int22_ar[G][U][U][A][G][C][U][A] =  2.400;
 int22_ar[G][U][U][A][G][G][U][A] =  1.100;
 int22_ar[G][U][U][A][G][U][U][A] =  2.400;
 int22_ar[G][U][U][A][U][A][U][A] =  2.000;
 int22_ar[G][U][U][A][U][C][U][A] =  2.000;
 int22_ar[G][U][U][A][U][G][U][A] =  2.000;
 int22_ar[G][U][U][A][U][U][U][A] =  2.000;
 int22_ar[G][U][U][C][A][A][U][A] =  2.000;
 int22_ar[G][U][U][C][A][C][U][A] =  2.500;
 int22_ar[G][U][U][C][A][G][U][A] =  0.300;
 int22_ar[G][U][U][C][A][U][U][A] =  1.700;
 int22_ar[G][U][U][C][C][A][U][A] =  2.000;
 int22_ar[G][U][U][C][C][C][U][A] =  2.500;
 int22_ar[G][U][U][C][C][G][U][A] =  1.300;
 int22_ar[G][U][U][C][C][U][U][A] =  1.700;
 int22_ar[G][U][U][C][G][A][U][A] =  2.000;
 int22_ar[G][U][U][C][G][C][U][A] =  2.000;
 int22_ar[G][U][U][C][G][G][U][A] =  2.000;
 int22_ar[G][U][U][C][G][U][U][A] =  2.000;
 int22_ar[G][U][U][C][U][A][U][A] =  2.000;
 int22_ar[G][U][U][C][U][C][U][A] =  2.500;
 int22_ar[G][U][U][C][U][G][U][A] =  1.300;
 int22_ar[G][U][U][C][U][U][U][A] =  1.700;
 int22_ar[G][U][U][G][A][A][U][A] =  2.000;
 int22_ar[G][U][U][G][A][C][U][A] =  2.400;
 int22_ar[G][U][U][G][A][G][U][A] =  1.100;
 int22_ar[G][U][U][G][A][U][U][A] =  2.400;
 int22_ar[G][U][U][G][C][A][U][A] =  2.000;
 int22_ar[G][U][U][G][C][C][U][A] =  2.000;
 int22_ar[G][U][U][G][C][G][U][A] =  2.000;
 int22_ar[G][U][U][G][C][U][U][A] =  2.000;
 int22_ar[G][U][U][G][G][A][U][A] =  2.000;
 int22_ar[G][U][U][G][G][C][U][A] =  2.400;
 int22_ar[G][U][U][G][G][G][U][A] =  0.700;
 int22_ar[G][U][U][G][G][U][U][A] =  2.000;
 int22_ar[G][U][U][G][U][A][U][A] =  2.000;
 int22_ar[G][U][U][G][U][C][U][A] =  0.700;
 int22_ar[G][U][U][G][U][G][U][A] = -2.500;
 int22_ar[G][U][U][G][U][U][U][A] =  0.700;
 int22_ar[G][U][U][U][A][A][U][A] =  2.000;
 int22_ar[G][U][U][U][A][C][U][A] =  2.000;
 int22_ar[G][U][U][U][A][G][U][A] =  2.000;
 int22_ar[G][U][U][U][A][U][U][A] =  2.000;
 int22_ar[G][U][U][U][C][A][U][A] =  2.000;
 int22_ar[G][U][U][U][C][C][U][A] =  2.200;
 int22_ar[G][U][U][U][C][G][U][A] =  1.000;
 int22_ar[G][U][U][U][C][U][U][A] =  1.400;
 int22_ar[G][U][U][U][G][A][U][A] =  2.000;
 int22_ar[G][U][U][U][G][C][U][A] =  1.900;
 int22_ar[G][U][U][U][G][G][U][A] = -1.200;
 int22_ar[G][U][U][U][G][U][U][A] =  1.900;
 int22_ar[G][U][U][U][U][A][U][A] =  2.000;
 int22_ar[G][U][U][U][U][C][U][A] =  1.600;
 int22_ar[G][U][U][U][U][G][U][A] =  1.300;
 int22_ar[G][U][U][U][U][U][U][A] =  0.800;
 int22_ar[G][U][A][A][A][A][U][G] =  2.800;
 int22_ar[G][U][A][A][A][C][U][G] =  2.600;
 int22_ar[G][U][A][A][A][G][U][G] =  1.500;
 int22_ar[G][U][A][A][A][U][U][G] =  2.000;
 int22_ar[G][U][A][A][C][A][U][G] =  2.300;
 int22_ar[G][U][A][A][C][C][U][G] =  2.200;
 int22_ar[G][U][A][A][C][G][U][G] =  1.100;
 int22_ar[G][U][A][A][C][U][U][G] =  2.000;
 int22_ar[G][U][A][A][G][A][U][G] =  1.700;
 int22_ar[G][U][A][A][G][C][U][G] =  1.600;
 int22_ar[G][U][A][A][G][G][U][G] =  0.500;
 int22_ar[G][U][A][A][G][U][U][G] =  2.000;
 int22_ar[G][U][A][A][U][A][U][G] =  2.000;
 int22_ar[G][U][A][A][U][C][U][G] =  2.000;
 int22_ar[G][U][A][A][U][G][U][G] =  2.000;
 int22_ar[G][U][A][A][U][U][U][G] =  2.000;
 int22_ar[G][U][A][C][A][A][U][G] =  2.800;
 int22_ar[G][U][A][C][A][C][U][G] =  2.600;
 int22_ar[G][U][A][C][A][G][U][G] =  1.500;
 int22_ar[G][U][A][C][A][U][U][G] =  2.000;
 int22_ar[G][U][A][C][C][A][U][G] =  3.400;
 int22_ar[G][U][A][C][C][C][U][G] =  2.600;
 int22_ar[G][U][A][C][C][G][U][G] =  2.500;
 int22_ar[G][U][A][C][C][U][U][G] =  2.000;
 int22_ar[G][U][A][C][G][A][U][G] =  2.000;
 int22_ar[G][U][A][C][G][C][U][G] =  2.000;
 int22_ar[G][U][A][C][G][G][U][G] =  2.000;
 int22_ar[G][U][A][C][G][U][U][G] =  2.000;
 int22_ar[G][U][A][C][U][A][U][G] =  3.400;
 int22_ar[G][U][A][C][U][C][U][G] =  2.600;
 int22_ar[G][U][A][C][U][G][U][G] =  2.500;
 int22_ar[G][U][A][C][U][U][U][G] =  2.000;
 int22_ar[G][U][A][G][A][A][U][G] =  1.700;
 int22_ar[G][U][A][G][A][C][U][G] =  1.600;
 int22_ar[G][U][A][G][A][G][U][G] =  0.500;
 int22_ar[G][U][A][G][A][U][U][G] =  2.000;
 int22_ar[G][U][A][G][C][A][U][G] =  2.000;
 int22_ar[G][U][A][G][C][C][U][G] =  2.000;
 int22_ar[G][U][A][G][C][G][U][G] =  2.000;
 int22_ar[G][U][A][G][C][U][U][G] =  2.000;
 int22_ar[G][U][A][G][G][A][U][G] =  2.100;
 int22_ar[G][U][A][G][G][C][U][G] =  2.000;
 int22_ar[G][U][A][G][G][G][U][G] =  0.900;
 int22_ar[G][U][A][G][G][U][U][G] =  2.000;
 int22_ar[G][U][A][G][U][A][U][G] =  1.000;
 int22_ar[G][U][A][G][U][C][U][G] = -0.200;
 int22_ar[G][U][A][G][U][G][U][G] =  0.500;
 int22_ar[G][U][A][G][U][U][U][G] =  2.000;
 int22_ar[G][U][A][U][A][A][U][G] =  2.000;
 int22_ar[G][U][A][U][A][C][U][G] =  2.000;
 int22_ar[G][U][A][U][A][G][U][G] =  2.000;
 int22_ar[G][U][A][U][A][U][U][G] =  2.000;
 int22_ar[G][U][A][U][C][A][U][G] =  3.100;
 int22_ar[G][U][A][U][C][C][U][G] =  2.300;
 int22_ar[G][U][A][U][C][G][U][G] =  2.200;
 int22_ar[G][U][A][U][C][U][U][G] =  2.000;
 int22_ar[G][U][A][U][G][A][U][G] =  2.200;
 int22_ar[G][U][A][U][G][C][U][G] =  1.100;
 int22_ar[G][U][A][U][G][G][U][G] =  1.800;
 int22_ar[G][U][A][U][G][U][U][G] =  2.000;
 int22_ar[G][U][A][U][U][A][U][G] =  2.900;
 int22_ar[G][U][A][U][U][C][U][G] =  1.800;
 int22_ar[G][U][A][U][U][G][U][G] =  2.500;
 int22_ar[G][U][A][U][U][U][U][G] =  2.000;
 int22_ar[G][U][C][A][A][A][U][G] =  2.500;
 int22_ar[G][U][C][A][A][C][U][G] =  3.100;
 int22_ar[G][U][C][A][A][G][U][G] =  2.000;
 int22_ar[G][U][C][A][A][U][U][G] =  3.100;
 int22_ar[G][U][C][A][C][A][U][G] =  2.100;
 int22_ar[G][U][C][A][C][C][U][G] =  2.000;
 int22_ar[G][U][C][A][C][G][U][G] =  2.000;
 int22_ar[G][U][C][A][C][U][U][G] =  2.000;
 int22_ar[G][U][C][A][G][A][U][G] =  1.500;
 int22_ar[G][U][C][A][G][C][U][G] =  2.400;
 int22_ar[G][U][C][A][G][G][U][G] =  2.000;
 int22_ar[G][U][C][A][G][U][U][G] =  2.400;
 int22_ar[G][U][C][A][U][A][U][G] =  2.000;
 int22_ar[G][U][C][A][U][C][U][G] =  2.000;
 int22_ar[G][U][C][A][U][G][U][G] =  2.000;
 int22_ar[G][U][C][A][U][U][U][G] =  2.000;
 int22_ar[G][U][C][C][A][A][U][G] =  2.500;
 int22_ar[G][U][C][C][A][C][U][G] =  2.500;
 int22_ar[G][U][C][C][A][G][U][G] =  2.000;
 int22_ar[G][U][C][C][A][U][U][G] =  2.500;
 int22_ar[G][U][C][C][C][A][U][G] =  2.500;
 int22_ar[G][U][C][C][C][C][U][G] =  2.500;
 int22_ar[G][U][C][C][C][G][U][G] =  2.000;
 int22_ar[G][U][C][C][C][U][U][G] =  2.500;
 int22_ar[G][U][C][C][G][A][U][G] =  2.000;
 int22_ar[G][U][C][C][G][C][U][G] =  2.000;
 int22_ar[G][U][C][C][G][G][U][G] =  2.000;
 int22_ar[G][U][C][C][G][U][U][G] =  2.000;
 int22_ar[G][U][C][C][U][A][U][G] =  2.500;
 int22_ar[G][U][C][C][U][C][U][G] =  2.500;
 int22_ar[G][U][C][C][U][G][U][G] =  2.000;
 int22_ar[G][U][C][C][U][U][U][G] =  2.500;
 int22_ar[G][U][C][G][A][A][U][G] =  1.500;
 int22_ar[G][U][C][G][A][C][U][G] =  2.400;
 int22_ar[G][U][C][G][A][G][U][G] =  2.000;
 int22_ar[G][U][C][G][A][U][U][G] =  2.400;
 int22_ar[G][U][C][G][C][A][U][G] =  2.000;
 int22_ar[G][U][C][G][C][C][U][G] =  2.000;
 int22_ar[G][U][C][G][C][G][U][G] =  2.000;
 int22_ar[G][U][C][G][C][U][U][G] =  2.000;
 int22_ar[G][U][C][G][G][A][U][G] =  1.900;
 int22_ar[G][U][C][G][G][C][U][G] =  2.400;
 int22_ar[G][U][C][G][G][G][U][G] =  2.000;
 int22_ar[G][U][C][G][G][U][U][G] =  2.400;
 int22_ar[G][U][C][G][U][A][U][G] = -0.300;
 int22_ar[G][U][C][G][U][C][U][G] =  0.700;
 int22_ar[G][U][C][G][U][G][U][G] =  2.000;
 int22_ar[G][U][C][G][U][U][U][G] =  0.700;
 int22_ar[G][U][C][U][A][A][U][G] =  2.000;
 int22_ar[G][U][C][U][A][C][U][G] =  2.000;
 int22_ar[G][U][C][U][A][G][U][G] =  2.000;
 int22_ar[G][U][C][U][A][U][U][G] =  2.000;
 int22_ar[G][U][C][U][C][A][U][G] =  2.200;
 int22_ar[G][U][C][U][C][C][U][G] =  2.200;
 int22_ar[G][U][C][U][C][G][U][G] =  2.000;
 int22_ar[G][U][C][U][C][U][U][G] =  2.200;
 int22_ar[G][U][C][U][G][A][U][G] =  1.000;
 int22_ar[G][U][C][U][G][C][U][G] =  1.900;
 int22_ar[G][U][C][U][G][G][U][G] =  2.000;
 int22_ar[G][U][C][U][G][U][U][G] =  1.900;
 int22_ar[G][U][C][U][U][A][U][G] =  1.700;
 int22_ar[G][U][C][U][U][C][U][G] =  1.600;
 int22_ar[G][U][C][U][U][G][U][G] =  2.000;
 int22_ar[G][U][C][U][U][U][U][G] =  1.600;
 int22_ar[G][U][G][A][A][A][U][G] =  1.500;
 int22_ar[G][U][G][A][A][C][U][G] =  2.000;
 int22_ar[G][U][G][A][A][G][U][G] =  2.100;
 int22_ar[G][U][G][A][A][U][U][G] =  2.300;
 int22_ar[G][U][G][A][C][A][U][G] =  1.100;
 int22_ar[G][U][G][A][C][C][U][G] =  2.000;
 int22_ar[G][U][G][A][C][G][U][G] =  1.600;
 int22_ar[G][U][G][A][C][U][U][G] =  0.900;
 int22_ar[G][U][G][A][G][A][U][G] =  0.500;
 int22_ar[G][U][G][A][G][C][U][G] =  2.000;
 int22_ar[G][U][G][A][G][G][U][G] =  1.000;
 int22_ar[G][U][G][A][G][U][U][G] =  2.100;
 int22_ar[G][U][G][A][U][A][U][G] =  2.000;
 int22_ar[G][U][G][A][U][C][U][G] =  2.000;
 int22_ar[G][U][G][A][U][G][U][G] =  2.000;
 int22_ar[G][U][G][A][U][U][U][G] =  2.000;
 int22_ar[G][U][G][C][A][A][U][G] =  1.500;
 int22_ar[G][U][G][C][A][C][U][G] =  2.000;
 int22_ar[G][U][G][C][A][G][U][G] =  2.100;
 int22_ar[G][U][G][C][A][U][U][G] =  1.300;
 int22_ar[G][U][G][C][C][A][U][G] =  2.500;
 int22_ar[G][U][G][C][C][C][U][G] =  2.000;
 int22_ar[G][U][G][C][C][G][U][G] =  2.700;
 int22_ar[G][U][G][C][C][U][U][G] =  2.300;
 int22_ar[G][U][G][C][G][A][U][G] =  2.000;
 int22_ar[G][U][G][C][G][C][U][G] =  2.000;
 int22_ar[G][U][G][C][G][G][U][G] =  2.000;
 int22_ar[G][U][G][C][G][U][U][G] =  2.000;
 int22_ar[G][U][G][C][U][A][U][G] =  2.500;
 int22_ar[G][U][G][C][U][C][U][G] =  2.000;
 int22_ar[G][U][G][C][U][G][U][G] =  2.700;
 int22_ar[G][U][G][C][U][U][U][G] =  2.300;
 int22_ar[G][U][G][G][A][A][U][G] =  0.500;
 int22_ar[G][U][G][G][A][C][U][G] =  2.000;
 int22_ar[G][U][G][G][A][G][U][G] =  1.000;
 int22_ar[G][U][G][G][A][U][U][G] =  2.100;
 int22_ar[G][U][G][G][C][A][U][G] =  2.000;
 int22_ar[G][U][G][G][C][C][U][G] =  2.000;
 int22_ar[G][U][G][G][C][G][U][G] =  2.000;
 int22_ar[G][U][G][G][C][U][U][G] =  2.000;
 int22_ar[G][U][G][G][G][A][U][G] =  0.900;
 int22_ar[G][U][G][G][G][C][U][G] =  2.000;
 int22_ar[G][U][G][G][G][G][U][G] =  1.400;
 int22_ar[G][U][G][G][G][U][U][G] =  1.700;
 int22_ar[G][U][G][G][U][A][U][G] =  0.500;
 int22_ar[G][U][G][G][U][C][U][G] =  2.000;
 int22_ar[G][U][G][G][U][G][U][G] =  0.300;
 int22_ar[G][U][G][G][U][U][U][G] = -1.500;
 int22_ar[G][U][G][U][A][A][U][G] =  2.000;
 int22_ar[G][U][G][U][A][C][U][G] =  2.000;
 int22_ar[G][U][G][U][A][G][U][G] =  2.000;
 int22_ar[G][U][G][U][A][U][U][G] =  2.000;
 int22_ar[G][U][G][U][C][A][U][G] =  2.200;
 int22_ar[G][U][G][U][C][C][U][G] =  2.000;
 int22_ar[G][U][G][U][C][G][U][G] =  2.400;
 int22_ar[G][U][G][U][C][U][U][G] =  2.000;
 int22_ar[G][U][G][U][G][A][U][G] =  1.800;
 int22_ar[G][U][G][U][G][C][U][G] =  2.000;
 int22_ar[G][U][G][U][G][G][U][G] =  1.500;
 int22_ar[G][U][G][U][G][U][U][G] = -0.200;
 int22_ar[G][U][G][U][U][A][U][G] =  2.500;
 int22_ar[G][U][G][U][U][C][U][G] =  2.000;
 int22_ar[G][U][G][U][U][G][U][G] =  2.200;
 int22_ar[G][U][G][U][U][U][U][G] =  2.300;
 int22_ar[G][U][U][A][A][A][U][G] =  2.000;
 int22_ar[G][U][U][A][A][C][U][G] =  3.100;
 int22_ar[G][U][U][A][A][G][U][G] =  1.300;
 int22_ar[G][U][U][A][A][U][U][G] =  2.700;
 int22_ar[G][U][U][A][C][A][U][G] =  2.000;
 int22_ar[G][U][U][A][C][C][U][G] =  2.000;
 int22_ar[G][U][U][A][C][G][U][G] = -0.100;
 int22_ar[G][U][U][A][C][U][U][G] =  1.200;
 int22_ar[G][U][U][A][G][A][U][G] =  2.000;
 int22_ar[G][U][U][A][G][C][U][G] =  2.400;
 int22_ar[G][U][U][A][G][G][U][G] =  1.100;
 int22_ar[G][U][U][A][G][U][U][G] =  2.400;
 int22_ar[G][U][U][A][U][A][U][G] =  2.000;
 int22_ar[G][U][U][A][U][C][U][G] =  2.000;
 int22_ar[G][U][U][A][U][G][U][G] =  2.000;
 int22_ar[G][U][U][A][U][U][U][G] =  2.000;
 int22_ar[G][U][U][C][A][A][U][G] =  2.000;
 int22_ar[G][U][U][C][A][C][U][G] =  2.500;
 int22_ar[G][U][U][C][A][G][U][G] =  0.300;
 int22_ar[G][U][U][C][A][U][U][G] =  1.700;
 int22_ar[G][U][U][C][C][A][U][G] =  2.000;
 int22_ar[G][U][U][C][C][C][U][G] =  2.500;
 int22_ar[G][U][U][C][C][G][U][G] =  1.300;
 int22_ar[G][U][U][C][C][U][U][G] =  1.700;
 int22_ar[G][U][U][C][G][A][U][G] =  2.000;
 int22_ar[G][U][U][C][G][C][U][G] =  2.000;
 int22_ar[G][U][U][C][G][G][U][G] =  2.000;
 int22_ar[G][U][U][C][G][U][U][G] =  2.000;
 int22_ar[G][U][U][C][U][A][U][G] =  2.000;
 int22_ar[G][U][U][C][U][C][U][G] =  2.500;
 int22_ar[G][U][U][C][U][G][U][G] =  1.300;
 int22_ar[G][U][U][C][U][U][U][G] =  1.700;
 int22_ar[G][U][U][G][A][A][U][G] =  2.000;
 int22_ar[G][U][U][G][A][C][U][G] =  2.400;
 int22_ar[G][U][U][G][A][G][U][G] =  1.100;
 int22_ar[G][U][U][G][A][U][U][G] =  2.400;
 int22_ar[G][U][U][G][C][A][U][G] =  2.000;
 int22_ar[G][U][U][G][C][C][U][G] =  2.000;
 int22_ar[G][U][U][G][C][G][U][G] =  2.000;
 int22_ar[G][U][U][G][C][U][U][G] =  2.000;
 int22_ar[G][U][U][G][G][A][U][G] =  2.000;
 int22_ar[G][U][U][G][G][C][U][G] =  2.400;
 int22_ar[G][U][U][G][G][G][U][G] =  0.700;
 int22_ar[G][U][U][G][G][U][U][G] =  2.000;
 int22_ar[G][U][U][G][U][A][U][G] =  2.000;
 int22_ar[G][U][U][G][U][C][U][G] =  0.700;
 int22_ar[G][U][U][G][U][G][U][G] = -2.500;
 int22_ar[G][U][U][G][U][U][U][G] =  0.700;
 int22_ar[G][U][U][U][A][A][U][G] =  2.000;
 int22_ar[G][U][U][U][A][C][U][G] =  2.000;
 int22_ar[G][U][U][U][A][G][U][G] =  2.000;
 int22_ar[G][U][U][U][A][U][U][G] =  2.000;
 int22_ar[G][U][U][U][C][A][U][G] =  2.000;
 int22_ar[G][U][U][U][C][C][U][G] =  2.200;
 int22_ar[G][U][U][U][C][G][U][G] =  1.000;
 int22_ar[G][U][U][U][C][U][U][G] =  1.400;
 int22_ar[G][U][U][U][G][A][U][G] =  2.000;
 int22_ar[G][U][U][U][G][C][U][G] =  1.900;
 int22_ar[G][U][U][U][G][G][U][G] = -1.200;
 int22_ar[G][U][U][U][G][U][U][G] =  1.900;
 int22_ar[G][U][U][U][U][A][U][G] =  2.000;
 int22_ar[G][U][U][U][U][C][U][G] =  1.600;
 int22_ar[G][U][U][U][U][G][U][G] =  1.300;
 int22_ar[G][U][U][U][U][U][U][G] =  0.800;
 int22_ar[U][A][A][A][A][A][A][U] =  2.800;
 int22_ar[U][A][A][A][A][C][A][U] =  2.800;
 int22_ar[U][A][A][A][A][G][A][U] =  1.700;
 int22_ar[U][A][A][A][A][U][A][U] =  2.000;
 int22_ar[U][A][A][A][C][A][A][U] =  2.500;
 int22_ar[U][A][A][A][C][C][A][U] =  2.500;
 int22_ar[U][A][A][A][C][G][A][U] =  1.500;
 int22_ar[U][A][A][A][C][U][A][U] =  2.000;
 int22_ar[U][A][A][A][G][A][A][U] =  1.500;
 int22_ar[U][A][A][A][G][C][A][U] =  1.500;
 int22_ar[U][A][A][A][G][G][A][U] =  0.500;
 int22_ar[U][A][A][A][G][U][A][U] =  2.000;
 int22_ar[U][A][A][A][U][A][A][U] =  2.000;
 int22_ar[U][A][A][A][U][C][A][U] =  2.000;
 int22_ar[U][A][A][A][U][G][A][U] =  2.000;
 int22_ar[U][A][A][A][U][U][A][U] =  2.000;
 int22_ar[U][A][A][C][A][A][A][U] =  2.600;
 int22_ar[U][A][A][C][A][C][A][U] =  2.600;
 int22_ar[U][A][A][C][A][G][A][U] =  1.600;
 int22_ar[U][A][A][C][A][U][A][U] =  2.000;
 int22_ar[U][A][A][C][C][A][A][U] =  3.100;
 int22_ar[U][A][A][C][C][C][A][U] =  2.500;
 int22_ar[U][A][A][C][C][G][A][U] =  2.400;
 int22_ar[U][A][A][C][C][U][A][U] =  2.000;
 int22_ar[U][A][A][C][G][A][A][U] =  2.000;
 int22_ar[U][A][A][C][G][C][A][U] =  2.000;
 int22_ar[U][A][A][C][G][G][A][U] =  2.000;
 int22_ar[U][A][A][C][G][U][A][U] =  2.000;
 int22_ar[U][A][A][C][U][A][A][U] =  3.100;
 int22_ar[U][A][A][C][U][C][A][U] =  2.500;
 int22_ar[U][A][A][C][U][G][A][U] =  2.400;
 int22_ar[U][A][A][C][U][U][A][U] =  2.000;
 int22_ar[U][A][A][G][A][A][A][U] =  1.500;
 int22_ar[U][A][A][G][A][C][A][U] =  1.500;
 int22_ar[U][A][A][G][A][G][A][U] =  0.500;
 int22_ar[U][A][A][G][A][U][A][U] =  2.000;
 int22_ar[U][A][A][G][C][A][A][U] =  2.000;
 int22_ar[U][A][A][G][C][C][A][U] =  2.000;
 int22_ar[U][A][A][G][C][G][A][U] =  2.000;
 int22_ar[U][A][A][G][C][U][A][U] =  2.000;
 int22_ar[U][A][A][G][G][A][A][U] =  2.100;
 int22_ar[U][A][A][G][G][C][A][U] =  2.100;
 int22_ar[U][A][A][G][G][G][A][U] =  1.000;
 int22_ar[U][A][A][G][G][U][A][U] =  2.000;
 int22_ar[U][A][A][G][U][A][A][U] =  1.300;
 int22_ar[U][A][A][G][U][C][A][U] =  0.300;
 int22_ar[U][A][A][G][U][G][A][U] =  1.100;
 int22_ar[U][A][A][G][U][U][A][U] =  2.000;
 int22_ar[U][A][A][U][A][A][A][U] =  2.000;
 int22_ar[U][A][A][U][A][C][A][U] =  2.000;
 int22_ar[U][A][A][U][A][G][A][U] =  2.000;
 int22_ar[U][A][A][U][A][U][A][U] =  2.000;
 int22_ar[U][A][A][U][C][A][A][U] =  3.100;
 int22_ar[U][A][A][U][C][C][A][U] =  2.500;
 int22_ar[U][A][A][U][C][G][A][U] =  2.400;
 int22_ar[U][A][A][U][C][U][A][U] =  2.000;
 int22_ar[U][A][A][U][G][A][A][U] =  2.300;
 int22_ar[U][A][A][U][G][C][A][U] =  1.300;
 int22_ar[U][A][A][U][G][G][A][U] =  2.100;
 int22_ar[U][A][A][U][G][U][A][U] =  2.000;
 int22_ar[U][A][A][U][U][A][A][U] =  2.700;
 int22_ar[U][A][A][U][U][C][A][U] =  1.700;
 int22_ar[U][A][A][U][U][G][A][U] =  2.400;
 int22_ar[U][A][A][U][U][U][A][U] =  2.000;
 int22_ar[U][A][C][A][A][A][A][U] =  2.300;
 int22_ar[U][A][C][A][A][C][A][U] =  3.400;
 int22_ar[U][A][C][A][A][G][A][U] =  2.000;
 int22_ar[U][A][C][A][A][U][A][U] =  3.100;
 int22_ar[U][A][C][A][C][A][A][U] =  2.100;
 int22_ar[U][A][C][A][C][C][A][U] =  2.500;
 int22_ar[U][A][C][A][C][G][A][U] =  2.000;
 int22_ar[U][A][C][A][C][U][A][U] =  2.200;
 int22_ar[U][A][C][A][G][A][A][U] =  1.100;
 int22_ar[U][A][C][A][G][C][A][U] =  2.500;
 int22_ar[U][A][C][A][G][G][A][U] =  2.000;
 int22_ar[U][A][C][A][G][U][A][U] =  2.200;
 int22_ar[U][A][C][A][U][A][A][U] =  2.000;
 int22_ar[U][A][C][A][U][C][A][U] =  2.000;
 int22_ar[U][A][C][A][U][G][A][U] =  2.000;
 int22_ar[U][A][C][A][U][U][A][U] =  2.000;
 int22_ar[U][A][C][C][A][A][A][U] =  2.200;
 int22_ar[U][A][C][C][A][C][A][U] =  2.600;
 int22_ar[U][A][C][C][A][G][A][U] =  2.000;
 int22_ar[U][A][C][C][A][U][A][U] =  2.300;
 int22_ar[U][A][C][C][C][A][A][U] =  2.000;
 int22_ar[U][A][C][C][C][C][A][U] =  2.500;
 int22_ar[U][A][C][C][C][G][A][U] =  2.000;
 int22_ar[U][A][C][C][C][U][A][U] =  2.200;
 int22_ar[U][A][C][C][G][A][A][U] =  2.000;
 int22_ar[U][A][C][C][G][C][A][U] =  2.000;
 int22_ar[U][A][C][C][G][G][A][U] =  2.000;
 int22_ar[U][A][C][C][G][U][A][U] =  2.000;
 int22_ar[U][A][C][C][U][A][A][U] =  2.000;
 int22_ar[U][A][C][C][U][C][A][U] =  2.500;
 int22_ar[U][A][C][C][U][G][A][U] =  2.000;
 int22_ar[U][A][C][C][U][U][A][U] =  2.200;
 int22_ar[U][A][C][G][A][A][A][U] =  1.100;
 int22_ar[U][A][C][G][A][C][A][U] =  2.500;
 int22_ar[U][A][C][G][A][G][A][U] =  2.000;
 int22_ar[U][A][C][G][A][U][A][U] =  2.200;
 int22_ar[U][A][C][G][C][A][A][U] =  2.000;
 int22_ar[U][A][C][G][C][C][A][U] =  2.000;
 int22_ar[U][A][C][G][C][G][A][U] =  2.000;
 int22_ar[U][A][C][G][C][U][A][U] =  2.000;
 int22_ar[U][A][C][G][G][A][A][U] =  1.600;
 int22_ar[U][A][C][G][G][C][A][U] =  2.700;
 int22_ar[U][A][C][G][G][G][A][U] =  2.000;
 int22_ar[U][A][C][G][G][U][A][U] =  2.400;
 int22_ar[U][A][C][G][U][A][A][U] = -0.100;
 int22_ar[U][A][C][G][U][C][A][U] =  1.300;
 int22_ar[U][A][C][G][U][G][A][U] =  2.000;
 int22_ar[U][A][C][G][U][U][A][U] =  1.000;
 int22_ar[U][A][C][U][A][A][A][U] =  2.000;
 int22_ar[U][A][C][U][A][C][A][U] =  2.000;
 int22_ar[U][A][C][U][A][G][A][U] =  2.000;
 int22_ar[U][A][C][U][A][U][A][U] =  2.000;
 int22_ar[U][A][C][U][C][A][A][U] =  2.000;
 int22_ar[U][A][C][U][C][C][A][U] =  2.500;
 int22_ar[U][A][C][U][C][G][A][U] =  2.000;
 int22_ar[U][A][C][U][C][U][A][U] =  2.200;
 int22_ar[U][A][C][U][G][A][A][U] =  0.900;
 int22_ar[U][A][C][U][G][C][A][U] =  2.300;
 int22_ar[U][A][C][U][G][G][A][U] =  2.000;
 int22_ar[U][A][C][U][G][U][A][U] =  2.000;
 int22_ar[U][A][C][U][U][A][A][U] =  1.200;
 int22_ar[U][A][C][U][U][C][A][U] =  1.700;
 int22_ar[U][A][C][U][U][G][A][U] =  2.000;
 int22_ar[U][A][C][U][U][U][A][U] =  1.400;
 int22_ar[U][A][G][A][A][A][A][U] =  1.700;
 int22_ar[U][A][G][A][A][C][A][U] =  2.000;
 int22_ar[U][A][G][A][A][G][A][U] =  2.100;
 int22_ar[U][A][G][A][A][U][A][U] =  2.200;
 int22_ar[U][A][G][A][C][A][A][U] =  1.500;
 int22_ar[U][A][G][A][C][C][A][U] =  2.000;
 int22_ar[U][A][G][A][C][G][A][U] =  1.900;
 int22_ar[U][A][G][A][C][U][A][U] =  1.000;
 int22_ar[U][A][G][A][G][A][A][U] =  0.500;
 int22_ar[U][A][G][A][G][C][A][U] =  2.000;
 int22_ar[U][A][G][A][G][G][A][U] =  0.900;
 int22_ar[U][A][G][A][G][U][A][U] =  1.800;
 int22_ar[U][A][G][A][U][A][A][U] =  2.000;
 int22_ar[U][A][G][A][U][C][A][U] =  2.000;
 int22_ar[U][A][G][A][U][G][A][U] =  2.000;
 int22_ar[U][A][G][A][U][U][A][U] =  2.000;
 int22_ar[U][A][G][C][A][A][A][U] =  1.600;
 int22_ar[U][A][G][C][A][C][A][U] =  2.000;
 int22_ar[U][A][G][C][A][G][A][U] =  2.000;
 int22_ar[U][A][G][C][A][U][A][U] =  1.100;
 int22_ar[U][A][G][C][C][A][A][U] =  2.400;
 int22_ar[U][A][G][C][C][C][A][U] =  2.000;
 int22_ar[U][A][G][C][C][G][A][U] =  2.400;
 int22_ar[U][A][G][C][C][U][A][U] =  1.900;
 int22_ar[U][A][G][C][G][A][A][U] =  2.000;
 int22_ar[U][A][G][C][G][C][A][U] =  2.000;
 int22_ar[U][A][G][C][G][G][A][U] =  2.000;
 int22_ar[U][A][G][C][G][U][A][U] =  2.000;
 int22_ar[U][A][G][C][U][A][A][U] =  2.400;
 int22_ar[U][A][G][C][U][C][A][U] =  2.000;
 int22_ar[U][A][G][C][U][G][A][U] =  2.400;
 int22_ar[U][A][G][C][U][U][A][U] =  1.900;
 int22_ar[U][A][G][G][A][A][A][U] =  0.500;
 int22_ar[U][A][G][G][A][C][A][U] =  2.000;
 int22_ar[U][A][G][G][A][G][A][U] =  0.900;
 int22_ar[U][A][G][G][A][U][A][U] =  1.800;
 int22_ar[U][A][G][G][C][A][A][U] =  2.000;
 int22_ar[U][A][G][G][C][C][A][U] =  2.000;
 int22_ar[U][A][G][G][C][G][A][U] =  2.000;
 int22_ar[U][A][G][G][C][U][A][U] =  2.000;
 int22_ar[U][A][G][G][G][A][A][U] =  1.000;
 int22_ar[U][A][G][G][G][C][A][U] =  2.000;
 int22_ar[U][A][G][G][G][G][A][U] =  1.400;
 int22_ar[U][A][G][G][G][U][A][U] =  1.500;
 int22_ar[U][A][G][G][U][A][A][U] =  1.100;
 int22_ar[U][A][G][G][U][C][A][U] =  2.000;
 int22_ar[U][A][G][G][U][G][A][U] =  0.700;
 int22_ar[U][A][G][G][U][U][A][U] = -1.200;
 int22_ar[U][A][G][U][A][A][A][U] =  2.000;
 int22_ar[U][A][G][U][A][C][A][U] =  2.000;
 int22_ar[U][A][G][U][A][G][A][U] =  2.000;
 int22_ar[U][A][G][U][A][U][A][U] =  2.000;
 int22_ar[U][A][G][U][C][A][A][U] =  2.400;
 int22_ar[U][A][G][U][C][C][A][U] =  2.000;
 int22_ar[U][A][G][U][C][G][A][U] =  2.400;
 int22_ar[U][A][G][U][C][U][A][U] =  1.900;
 int22_ar[U][A][G][U][G][A][A][U] =  2.100;
 int22_ar[U][A][G][U][G][C][A][U] =  2.000;
 int22_ar[U][A][G][U][G][G][A][U] =  1.700;
 int22_ar[U][A][G][U][G][U][A][U] = -0.200;
 int22_ar[U][A][G][U][U][A][A][U] =  2.400;
 int22_ar[U][A][G][U][U][C][A][U] =  2.000;
 int22_ar[U][A][G][U][U][G][A][U] =  2.000;
 int22_ar[U][A][G][U][U][U][A][U] =  1.900;
 int22_ar[U][A][U][A][A][A][A][U] =  2.000;
 int22_ar[U][A][U][A][A][C][A][U] =  3.400;
 int22_ar[U][A][U][A][A][G][A][U] =  1.000;
 int22_ar[U][A][U][A][A][U][A][U] =  2.900;
 int22_ar[U][A][U][A][C][A][A][U] =  2.000;
 int22_ar[U][A][U][A][C][C][A][U] =  2.500;
 int22_ar[U][A][U][A][C][G][A][U] = -0.300;
 int22_ar[U][A][U][A][C][U][A][U] =  1.700;
 int22_ar[U][A][U][A][G][A][A][U] =  2.000;
 int22_ar[U][A][U][A][G][C][A][U] =  2.500;
 int22_ar[U][A][U][A][G][G][A][U] =  0.500;
 int22_ar[U][A][U][A][G][U][A][U] =  2.500;
 int22_ar[U][A][U][A][U][A][A][U] =  2.000;
 int22_ar[U][A][U][A][U][C][A][U] =  2.000;
 int22_ar[U][A][U][A][U][G][A][U] =  2.000;
 int22_ar[U][A][U][A][U][U][A][U] =  2.000;
 int22_ar[U][A][U][C][A][A][A][U] =  2.000;
 int22_ar[U][A][U][C][A][C][A][U] =  2.600;
 int22_ar[U][A][U][C][A][G][A][U] = -0.200;
 int22_ar[U][A][U][C][A][U][A][U] =  1.800;
 int22_ar[U][A][U][C][C][A][A][U] =  2.000;
 int22_ar[U][A][U][C][C][C][A][U] =  2.500;
 int22_ar[U][A][U][C][C][G][A][U] =  0.700;
 int22_ar[U][A][U][C][C][U][A][U] =  1.600;
 int22_ar[U][A][U][C][G][A][A][U] =  2.000;
 int22_ar[U][A][U][C][G][C][A][U] =  2.000;
 int22_ar[U][A][U][C][G][G][A][U] =  2.000;
 int22_ar[U][A][U][C][G][U][A][U] =  2.000;
 int22_ar[U][A][U][C][U][A][A][U] =  2.000;
 int22_ar[U][A][U][C][U][C][A][U] =  2.500;
 int22_ar[U][A][U][C][U][G][A][U] =  0.700;
 int22_ar[U][A][U][C][U][U][A][U] =  1.600;
 int22_ar[U][A][U][G][A][A][A][U] =  2.000;
 int22_ar[U][A][U][G][A][C][A][U] =  2.500;
 int22_ar[U][A][U][G][A][G][A][U] =  0.500;
 int22_ar[U][A][U][G][A][U][A][U] =  2.500;
 int22_ar[U][A][U][G][C][A][A][U] =  2.000;
 int22_ar[U][A][U][G][C][C][A][U] =  2.000;
 int22_ar[U][A][U][G][C][G][A][U] =  2.000;
 int22_ar[U][A][U][G][C][U][A][U] =  2.000;
 int22_ar[U][A][U][G][G][A][A][U] =  2.000;
 int22_ar[U][A][U][G][G][C][A][U] =  2.700;
 int22_ar[U][A][U][G][G][G][A][U] =  0.300;
 int22_ar[U][A][U][G][G][U][A][U] =  2.200;
 int22_ar[U][A][U][G][U][A][A][U] =  2.000;
 int22_ar[U][A][U][G][U][C][A][U] =  1.300;
 int22_ar[U][A][U][G][U][G][A][U] = -2.500;
 int22_ar[U][A][U][G][U][U][A][U] =  1.300;
 int22_ar[U][A][U][U][A][A][A][U] =  2.000;
 int22_ar[U][A][U][U][A][C][A][U] =  2.000;
 int22_ar[U][A][U][U][A][G][A][U] =  2.000;
 int22_ar[U][A][U][U][A][U][A][U] =  2.000;
 int22_ar[U][A][U][U][C][A][A][U] =  2.000;
 int22_ar[U][A][U][U][C][C][A][U] =  2.500;
 int22_ar[U][A][U][U][C][G][A][U] =  0.700;
 int22_ar[U][A][U][U][C][U][A][U] =  1.600;
 int22_ar[U][A][U][U][G][A][A][U] =  2.000;
 int22_ar[U][A][U][U][G][C][A][U] =  2.300;
 int22_ar[U][A][U][U][G][G][A][U] = -1.500;
 int22_ar[U][A][U][U][G][U][A][U] =  2.300;
 int22_ar[U][A][U][U][U][A][A][U] =  2.000;
 int22_ar[U][A][U][U][U][C][A][U] =  1.700;
 int22_ar[U][A][U][U][U][G][A][U] =  0.700;
 int22_ar[U][A][U][U][U][U][A][U] =  0.800;
 int22_ar[U][A][A][A][A][A][C][G] =  2.000;
 int22_ar[U][A][A][A][A][C][C][G] =  2.000;
 int22_ar[U][A][A][A][A][G][C][G] =  1.000;
 int22_ar[U][A][A][A][A][U][C][G] =  2.000;
 int22_ar[U][A][A][A][C][A][C][G] =  1.900;
 int22_ar[U][A][A][A][C][C][C][G] =  1.900;
 int22_ar[U][A][A][A][C][G][C][G] =  0.900;
 int22_ar[U][A][A][A][C][U][C][G] =  2.000;
 int22_ar[U][A][A][A][G][A][C][G] =  1.000;
 int22_ar[U][A][A][A][G][C][C][G] =  1.000;
 int22_ar[U][A][A][A][G][G][C][G] =  0.000;
 int22_ar[U][A][A][A][G][U][C][G] =  2.000;
 int22_ar[U][A][A][A][U][A][C][G] =  2.000;
 int22_ar[U][A][A][A][U][C][C][G] =  2.000;
 int22_ar[U][A][A][A][U][G][C][G] =  2.000;
 int22_ar[U][A][A][A][U][U][C][G] =  2.000;
 int22_ar[U][A][A][C][A][A][C][G] =  2.400;
 int22_ar[U][A][A][C][A][C][C][G] =  2.400;
 int22_ar[U][A][A][C][A][G][C][G] =  1.300;
 int22_ar[U][A][A][C][A][U][C][G] =  2.000;
 int22_ar[U][A][A][C][C][A][C][G] =  2.800;
 int22_ar[U][A][A][C][C][C][C][G] =  2.200;
 int22_ar[U][A][A][C][C][G][C][G] =  2.200;
 int22_ar[U][A][A][C][C][U][C][G] =  2.000;
 int22_ar[U][A][A][C][G][A][C][G] =  2.000;
 int22_ar[U][A][A][C][G][C][C][G] =  2.000;
 int22_ar[U][A][A][C][G][G][C][G] =  2.000;
 int22_ar[U][A][A][C][G][U][C][G] =  2.000;
 int22_ar[U][A][A][C][U][A][C][G] =  2.700;
 int22_ar[U][A][A][C][U][C][C][G] =  2.100;
 int22_ar[U][A][A][C][U][G][C][G] =  2.000;
 int22_ar[U][A][A][C][U][U][C][G] =  2.000;
 int22_ar[U][A][A][G][A][A][C][G] =  1.000;
 int22_ar[U][A][A][G][A][C][C][G] =  1.000;
 int22_ar[U][A][A][G][A][G][C][G] =  0.000;
 int22_ar[U][A][A][G][A][U][C][G] =  2.000;
 int22_ar[U][A][A][G][C][A][C][G] =  2.000;
 int22_ar[U][A][A][G][C][C][C][G] =  2.000;
 int22_ar[U][A][A][G][C][G][C][G] =  2.000;
 int22_ar[U][A][A][G][C][U][C][G] =  2.000;
 int22_ar[U][A][A][G][G][A][C][G] =  1.800;
 int22_ar[U][A][A][G][G][C][C][G] =  1.800;
 int22_ar[U][A][A][G][G][G][C][G] =  0.700;
 int22_ar[U][A][A][G][G][U][C][G] =  2.000;
 int22_ar[U][A][A][G][U][A][C][G] =  0.300;
 int22_ar[U][A][A][G][U][C][C][G] = -0.700;
 int22_ar[U][A][A][G][U][G][C][G] =  0.100;
 int22_ar[U][A][A][G][U][U][C][G] =  2.000;
 int22_ar[U][A][A][U][A][A][C][G] =  2.000;
 int22_ar[U][A][A][U][A][C][C][G] =  2.000;
 int22_ar[U][A][A][U][A][G][C][G] =  2.000;
 int22_ar[U][A][A][U][A][U][C][G] =  2.000;
 int22_ar[U][A][A][U][C][A][C][G] =  2.700;
 int22_ar[U][A][A][U][C][C][C][G] =  2.100;
 int22_ar[U][A][A][U][C][G][C][G] =  2.000;
 int22_ar[U][A][A][U][C][U][C][G] =  2.000;
 int22_ar[U][A][A][U][G][A][C][G] =  1.800;
 int22_ar[U][A][A][U][G][C][C][G] =  0.800;
 int22_ar[U][A][A][U][G][G][C][G] =  1.600;
 int22_ar[U][A][A][U][G][U][C][G] =  2.000;
 int22_ar[U][A][A][U][U][A][C][G] =  2.200;
 int22_ar[U][A][A][U][U][C][C][G] =  1.200;
 int22_ar[U][A][A][U][U][G][C][G] =  1.900;
 int22_ar[U][A][A][U][U][U][C][G] =  2.000;
 int22_ar[U][A][C][A][A][A][C][G] =  1.600;
 int22_ar[U][A][C][A][A][C][C][G] =  2.600;
 int22_ar[U][A][C][A][A][G][C][G] =  2.000;
 int22_ar[U][A][C][A][A][U][C][G] =  2.300;
 int22_ar[U][A][C][A][C][A][C][G] =  1.500;
 int22_ar[U][A][C][A][C][C][C][G] =  1.900;
 int22_ar[U][A][C][A][C][G][C][G] =  2.000;
 int22_ar[U][A][C][A][C][U][C][G] =  1.600;
 int22_ar[U][A][C][A][G][A][C][G] =  0.600;
 int22_ar[U][A][C][A][G][C][C][G] =  2.000;
 int22_ar[U][A][C][A][G][G][C][G] =  2.000;
 int22_ar[U][A][C][A][G][U][C][G] =  1.700;
 int22_ar[U][A][C][A][U][A][C][G] =  2.000;
 int22_ar[U][A][C][A][U][C][C][G] =  2.000;
 int22_ar[U][A][C][A][U][G][C][G] =  2.000;
 int22_ar[U][A][C][A][U][U][C][G] =  2.000;
 int22_ar[U][A][C][C][A][A][C][G] =  1.900;
 int22_ar[U][A][C][C][A][C][C][G] =  2.400;
 int22_ar[U][A][C][C][A][G][C][G] =  2.000;
 int22_ar[U][A][C][C][A][U][C][G] =  2.100;
 int22_ar[U][A][C][C][C][A][C][G] =  1.800;
 int22_ar[U][A][C][C][C][C][C][G] =  2.200;
 int22_ar[U][A][C][C][C][G][C][G] =  2.000;
 int22_ar[U][A][C][C][C][U][C][G] =  1.900;
 int22_ar[U][A][C][C][G][A][C][G] =  2.000;
 int22_ar[U][A][C][C][G][C][C][G] =  2.000;
 int22_ar[U][A][C][C][G][G][C][G] =  2.000;
 int22_ar[U][A][C][C][G][U][C][G] =  2.000;
 int22_ar[U][A][C][C][U][A][C][G] =  1.600;
 int22_ar[U][A][C][C][U][C][C][G] =  2.100;
 int22_ar[U][A][C][C][U][G][C][G] =  2.000;
 int22_ar[U][A][C][C][U][U][C][G] =  1.800;
 int22_ar[U][A][C][G][A][A][C][G] =  0.600;
 int22_ar[U][A][C][G][A][C][C][G] =  2.000;
 int22_ar[U][A][C][G][A][G][C][G] =  2.000;
 int22_ar[U][A][C][G][A][U][C][G] =  1.700;
 int22_ar[U][A][C][G][C][A][C][G] =  2.000;
 int22_ar[U][A][C][G][C][C][C][G] =  2.000;
 int22_ar[U][A][C][G][C][G][C][G] =  2.000;
 int22_ar[U][A][C][G][C][U][C][G] =  2.000;
 int22_ar[U][A][C][G][G][A][C][G] =  1.300;
 int22_ar[U][A][C][G][G][C][C][G] =  2.400;
 int22_ar[U][A][C][G][G][G][C][G] =  2.000;
 int22_ar[U][A][C][G][G][U][C][G] =  2.100;
 int22_ar[U][A][C][G][U][A][C][G] = -1.100;
 int22_ar[U][A][C][G][U][C][C][G] =  0.300;
 int22_ar[U][A][C][G][U][G][C][G] =  2.000;
 int22_ar[U][A][C][G][U][U][C][G] =  0.000;
 int22_ar[U][A][C][U][A][A][C][G] =  2.000;
 int22_ar[U][A][C][U][A][C][C][G] =  2.000;
 int22_ar[U][A][C][U][A][G][C][G] =  2.000;
 int22_ar[U][A][C][U][A][U][C][G] =  2.000;
 int22_ar[U][A][C][U][C][A][C][G] =  1.600;
 int22_ar[U][A][C][U][C][C][C][G] =  2.100;
 int22_ar[U][A][C][U][C][G][C][G] =  2.000;
 int22_ar[U][A][C][U][C][U][C][G] =  1.800;
 int22_ar[U][A][C][U][G][A][C][G] =  0.400;
 int22_ar[U][A][C][U][G][C][C][G] =  1.800;
 int22_ar[U][A][C][U][G][G][C][G] =  2.000;
 int22_ar[U][A][C][U][G][U][C][G] =  1.500;
 int22_ar[U][A][C][U][U][A][C][G] =  0.700;
 int22_ar[U][A][C][U][U][C][C][G] =  1.200;
 int22_ar[U][A][C][U][U][G][C][G] =  2.000;
 int22_ar[U][A][C][U][U][U][C][G] =  0.900;
 int22_ar[U][A][G][A][A][A][C][G] =  1.000;
 int22_ar[U][A][G][A][A][C][C][G] =  2.000;
 int22_ar[U][A][G][A][A][G][C][G] =  1.400;
 int22_ar[U][A][G][A][A][U][C][G] =  1.500;
 int22_ar[U][A][G][A][C][A][C][G] =  0.900;
 int22_ar[U][A][G][A][C][C][C][G] =  2.000;
 int22_ar[U][A][G][A][C][G][C][G] =  1.300;
 int22_ar[U][A][G][A][C][U][C][G] =  0.400;
 int22_ar[U][A][G][A][G][A][C][G] =  0.000;
 int22_ar[U][A][G][A][G][C][C][G] =  2.000;
 int22_ar[U][A][G][A][G][G][C][G] =  0.400;
 int22_ar[U][A][G][A][G][U][C][G] =  1.300;
 int22_ar[U][A][G][A][U][A][C][G] =  2.000;
 int22_ar[U][A][G][A][U][C][C][G] =  2.000;
 int22_ar[U][A][G][A][U][G][C][G] =  2.000;
 int22_ar[U][A][G][A][U][U][C][G] =  2.000;
 int22_ar[U][A][G][C][A][A][C][G] =  1.300;
 int22_ar[U][A][G][C][A][C][C][G] =  2.000;
 int22_ar[U][A][G][C][A][G][C][G] =  1.700;
 int22_ar[U][A][G][C][A][U][C][G] =  0.800;
 int22_ar[U][A][G][C][C][A][C][G] =  2.200;
 int22_ar[U][A][G][C][C][C][C][G] =  2.000;
 int22_ar[U][A][G][C][C][G][C][G] =  2.200;
 int22_ar[U][A][G][C][C][U][C][G] =  1.700;
 int22_ar[U][A][G][C][G][A][C][G] =  2.000;
 int22_ar[U][A][G][C][G][C][C][G] =  2.000;
 int22_ar[U][A][G][C][G][G][C][G] =  2.000;
 int22_ar[U][A][G][C][G][U][C][G] =  2.000;
 int22_ar[U][A][G][C][U][A][C][G] =  2.000;
 int22_ar[U][A][G][C][U][C][C][G] =  2.000;
 int22_ar[U][A][G][C][U][G][C][G] =  2.000;
 int22_ar[U][A][G][C][U][U][C][G] =  1.500;
 int22_ar[U][A][G][G][A][A][C][G] =  0.000;
 int22_ar[U][A][G][G][A][C][C][G] =  2.000;
 int22_ar[U][A][G][G][A][G][C][G] =  0.400;
 int22_ar[U][A][G][G][A][U][C][G] =  1.300;
 int22_ar[U][A][G][G][C][A][C][G] =  2.000;
 int22_ar[U][A][G][G][C][C][C][G] =  2.000;
 int22_ar[U][A][G][G][C][G][C][G] =  2.000;
 int22_ar[U][A][G][G][C][U][C][G] =  2.000;
 int22_ar[U][A][G][G][G][A][C][G] =  0.700;
 int22_ar[U][A][G][G][G][C][C][G] =  2.000;
 int22_ar[U][A][G][G][G][G][C][G] =  1.100;
 int22_ar[U][A][G][G][G][U][C][G] =  1.200;
 int22_ar[U][A][G][G][U][A][C][G] =  0.100;
 int22_ar[U][A][G][G][U][C][C][G] =  2.000;
 int22_ar[U][A][G][G][U][G][C][G] = -0.300;
 int22_ar[U][A][G][G][U][U][C][G] = -2.200;
 int22_ar[U][A][G][U][A][A][C][G] =  2.000;
 int22_ar[U][A][G][U][A][C][C][G] =  2.000;
 int22_ar[U][A][G][U][A][G][C][G] =  2.000;
 int22_ar[U][A][G][U][A][U][C][G] =  2.000;
 int22_ar[U][A][G][U][C][A][C][G] =  2.000;
 int22_ar[U][A][G][U][C][C][C][G] =  2.000;
 int22_ar[U][A][G][U][C][G][C][G] =  2.000;
 int22_ar[U][A][G][U][C][U][C][G] =  1.500;
 int22_ar[U][A][G][U][G][A][C][G] =  1.600;
 int22_ar[U][A][G][U][G][C][C][G] =  2.000;
 int22_ar[U][A][G][U][G][G][C][G] =  1.200;
 int22_ar[U][A][G][U][G][U][C][G] = -0.700;
 int22_ar[U][A][G][U][U][A][C][G] =  1.900;
 int22_ar[U][A][G][U][U][C][C][G] =  2.000;
 int22_ar[U][A][G][U][U][G][C][G] =  1.500;
 int22_ar[U][A][G][U][U][U][C][G] =  1.500;
 int22_ar[U][A][U][A][A][A][C][G] =  2.000;
 int22_ar[U][A][U][A][A][C][C][G] =  2.600;
 int22_ar[U][A][U][A][A][G][C][G] =  0.200;
 int22_ar[U][A][U][A][A][U][C][G] =  2.200;
 int22_ar[U][A][U][A][C][A][C][G] =  2.000;
 int22_ar[U][A][U][A][C][C][C][G] =  1.900;
 int22_ar[U][A][U][A][C][G][C][G] = -0.900;
 int22_ar[U][A][U][A][C][U][C][G] =  1.100;
 int22_ar[U][A][U][A][G][A][C][G] =  2.000;
 int22_ar[U][A][U][A][G][C][C][G] =  2.000;
 int22_ar[U][A][U][A][G][G][C][G] =  0.000;
 int22_ar[U][A][U][A][G][U][C][G] =  2.000;
 int22_ar[U][A][U][A][U][A][C][G] =  2.000;
 int22_ar[U][A][U][A][U][C][C][G] =  2.000;
 int22_ar[U][A][U][A][U][G][C][G] =  2.000;
 int22_ar[U][A][U][A][U][U][C][G] =  2.000;
 int22_ar[U][A][U][C][A][A][C][G] =  2.000;
 int22_ar[U][A][U][C][A][C][C][G] =  2.400;
 int22_ar[U][A][U][C][A][G][C][G] = -0.400;
 int22_ar[U][A][U][C][A][U][C][G] =  1.500;
 int22_ar[U][A][U][C][C][A][C][G] =  2.000;
 int22_ar[U][A][U][C][C][C][C][G] =  2.200;
 int22_ar[U][A][U][C][C][G][C][G] =  0.400;
 int22_ar[U][A][U][C][C][U][C][G] =  1.400;
 int22_ar[U][A][U][C][G][A][C][G] =  2.000;
 int22_ar[U][A][U][C][G][C][C][G] =  2.000;
 int22_ar[U][A][U][C][G][G][C][G] =  2.000;
 int22_ar[U][A][U][C][G][U][C][G] =  2.000;
 int22_ar[U][A][U][C][U][A][C][G] =  2.000;
 int22_ar[U][A][U][C][U][C][C][G] =  2.100;
 int22_ar[U][A][U][C][U][G][C][G] =  0.300;
 int22_ar[U][A][U][C][U][U][C][G] =  1.200;
 int22_ar[U][A][U][G][A][A][C][G] =  2.000;
 int22_ar[U][A][U][G][A][C][C][G] =  2.000;
 int22_ar[U][A][U][G][A][G][C][G] =  0.000;
 int22_ar[U][A][U][G][A][U][C][G] =  2.000;
 int22_ar[U][A][U][G][C][A][C][G] =  2.000;
 int22_ar[U][A][U][G][C][C][C][G] =  2.000;
 int22_ar[U][A][U][G][C][G][C][G] =  2.000;
 int22_ar[U][A][U][G][C][U][C][G] =  2.000;
 int22_ar[U][A][U][G][G][A][C][G] =  2.000;
 int22_ar[U][A][U][G][G][C][C][G] =  2.400;
 int22_ar[U][A][U][G][G][G][C][G] =  0.000;
 int22_ar[U][A][U][G][G][U][C][G] =  1.900;
 int22_ar[U][A][U][G][U][A][C][G] =  2.000;
 int22_ar[U][A][U][G][U][C][C][G] =  0.300;
 int22_ar[U][A][U][G][U][G][C][G] = -3.500;
 int22_ar[U][A][U][G][U][U][C][G] =  0.300;
 int22_ar[U][A][U][U][A][A][C][G] =  2.000;
 int22_ar[U][A][U][U][A][C][C][G] =  2.000;
 int22_ar[U][A][U][U][A][G][C][G] =  2.000;
 int22_ar[U][A][U][U][A][U][C][G] =  2.000;
 int22_ar[U][A][U][U][C][A][C][G] =  2.000;
 int22_ar[U][A][U][U][C][C][C][G] =  2.100;
 int22_ar[U][A][U][U][C][G][C][G] =  0.300;
 int22_ar[U][A][U][U][C][U][C][G] =  1.200;
 int22_ar[U][A][U][U][G][A][C][G] =  2.000;
 int22_ar[U][A][U][U][G][C][C][G] =  1.800;
 int22_ar[U][A][U][U][G][G][C][G] = -2.000;
 int22_ar[U][A][U][U][G][U][C][G] =  1.800;
 int22_ar[U][A][U][U][U][A][C][G] =  2.000;
 int22_ar[U][A][U][U][U][C][C][G] =  1.200;
 int22_ar[U][A][U][U][U][G][C][G] =  0.200;
 int22_ar[U][A][U][U][U][U][C][G] =  0.300;
 int22_ar[U][A][A][A][A][A][G][C] =  2.100;
 int22_ar[U][A][A][A][A][C][G][C] =  2.100;
 int22_ar[U][A][A][A][A][G][G][C] =  1.100;
 int22_ar[U][A][A][A][A][U][G][C] =  2.000;
 int22_ar[U][A][A][A][C][A][G][C] =  1.900;
 int22_ar[U][A][A][A][C][C][G][C] =  1.900;
 int22_ar[U][A][A][A][C][G][G][C] =  0.800;
 int22_ar[U][A][A][A][C][U][G][C] =  2.000;
 int22_ar[U][A][A][A][G][A][G][C] =  0.100;
 int22_ar[U][A][A][A][G][C][G][C] =  0.100;
 int22_ar[U][A][A][A][G][G][G][C] = -0.900;
 int22_ar[U][A][A][A][G][U][G][C] =  2.000;
 int22_ar[U][A][A][A][U][A][G][C] =  2.000;
 int22_ar[U][A][A][A][U][C][G][C] =  2.000;
 int22_ar[U][A][A][A][U][G][G][C] =  2.000;
 int22_ar[U][A][A][A][U][U][G][C] =  2.000;
 int22_ar[U][A][A][C][A][A][G][C] =  1.800;
 int22_ar[U][A][A][C][A][C][G][C] =  1.800;
 int22_ar[U][A][A][C][A][G][G][C] =  0.800;
 int22_ar[U][A][A][C][A][U][G][C] =  2.000;
 int22_ar[U][A][A][C][C][A][G][C] =  2.500;
 int22_ar[U][A][A][C][C][C][G][C] =  1.900;
 int22_ar[U][A][A][C][C][G][G][C] =  1.800;
 int22_ar[U][A][A][C][C][U][G][C] =  2.000;
 int22_ar[U][A][A][C][G][A][G][C] =  2.000;
 int22_ar[U][A][A][C][G][C][G][C] =  2.000;
 int22_ar[U][A][A][C][G][G][G][C] =  2.000;
 int22_ar[U][A][A][C][G][U][G][C] =  2.000;
 int22_ar[U][A][A][C][U][A][G][C] =  1.500;
 int22_ar[U][A][A][C][U][C][G][C] =  0.900;
 int22_ar[U][A][A][C][U][G][G][C] =  0.900;
 int22_ar[U][A][A][C][U][U][G][C] =  2.000;
 int22_ar[U][A][A][G][A][A][G][C] =  0.700;
 int22_ar[U][A][A][G][A][C][G][C] =  0.700;
 int22_ar[U][A][A][G][A][G][G][C] = -0.300;
 int22_ar[U][A][A][G][A][U][G][C] =  2.000;
 int22_ar[U][A][A][G][C][A][G][C] =  2.000;
 int22_ar[U][A][A][G][C][C][G][C] =  2.000;
 int22_ar[U][A][A][G][C][G][G][C] =  2.000;
 int22_ar[U][A][A][G][C][U][G][C] =  2.000;
 int22_ar[U][A][A][G][G][A][G][C] =  1.800;
 int22_ar[U][A][A][G][G][C][G][C] =  1.800;
 int22_ar[U][A][A][G][G][G][G][C] =  0.700;
 int22_ar[U][A][A][G][G][U][G][C] =  2.000;
 int22_ar[U][A][A][G][U][A][G][C] =  0.000;
 int22_ar[U][A][A][G][U][C][G][C] = -1.000;
 int22_ar[U][A][A][G][U][G][G][C] = -0.300;
 int22_ar[U][A][A][G][U][U][G][C] =  2.000;
 int22_ar[U][A][A][U][A][A][G][C] =  2.000;
 int22_ar[U][A][A][U][A][C][G][C] =  2.000;
 int22_ar[U][A][A][U][A][G][G][C] =  2.000;
 int22_ar[U][A][A][U][A][U][G][C] =  2.000;
 int22_ar[U][A][A][U][C][A][G][C] =  2.500;
 int22_ar[U][A][A][U][C][C][G][C] =  1.900;
 int22_ar[U][A][A][U][C][G][G][C] =  1.900;
 int22_ar[U][A][A][U][C][U][G][C] =  2.000;
 int22_ar[U][A][A][U][G][A][G][C] =  0.400;
 int22_ar[U][A][A][U][G][C][G][C] = -0.600;
 int22_ar[U][A][A][U][G][G][G][C] =  0.100;
 int22_ar[U][A][A][U][G][U][G][C] =  2.000;
 int22_ar[U][A][A][U][U][A][G][C] =  2.100;
 int22_ar[U][A][A][U][U][C][G][C] =  1.100;
 int22_ar[U][A][A][U][U][G][G][C] =  1.900;
 int22_ar[U][A][A][U][U][U][G][C] =  2.000;
 int22_ar[U][A][C][A][A][A][G][C] =  1.700;
 int22_ar[U][A][C][A][A][C][G][C] =  2.700;
 int22_ar[U][A][C][A][A][G][G][C] =  2.000;
 int22_ar[U][A][C][A][A][U][G][C] =  2.400;
 int22_ar[U][A][C][A][C][A][G][C] =  1.400;
 int22_ar[U][A][C][A][C][C][G][C] =  1.900;
 int22_ar[U][A][C][A][C][G][G][C] =  2.000;
 int22_ar[U][A][C][A][C][U][G][C] =  1.600;
 int22_ar[U][A][C][A][G][A][G][C] = -0.300;
 int22_ar[U][A][C][A][G][C][G][C] =  1.100;
 int22_ar[U][A][C][A][G][G][G][C] =  2.000;
 int22_ar[U][A][C][A][G][U][G][C] =  0.800;
 int22_ar[U][A][C][A][U][A][G][C] =  2.000;
 int22_ar[U][A][C][A][U][C][G][C] =  2.000;
 int22_ar[U][A][C][A][U][G][G][C] =  2.000;
 int22_ar[U][A][C][A][U][U][G][C] =  2.000;
 int22_ar[U][A][C][C][A][A][G][C] =  1.400;
 int22_ar[U][A][C][C][A][C][G][C] =  1.800;
 int22_ar[U][A][C][C][A][G][G][C] =  2.000;
 int22_ar[U][A][C][C][A][U][G][C] =  1.500;
 int22_ar[U][A][C][C][C][A][G][C] =  1.400;
 int22_ar[U][A][C][C][C][C][G][C] =  1.900;
 int22_ar[U][A][C][C][C][G][G][C] =  2.000;
 int22_ar[U][A][C][C][C][U][G][C] =  1.600;
 int22_ar[U][A][C][C][G][A][G][C] =  2.000;
 int22_ar[U][A][C][C][G][C][G][C] =  2.000;
 int22_ar[U][A][C][C][G][G][G][C] =  2.000;
 int22_ar[U][A][C][C][G][U][G][C] =  2.000;
 int22_ar[U][A][C][C][U][A][G][C] =  0.400;
 int22_ar[U][A][C][C][U][C][G][C] =  0.900;
 int22_ar[U][A][C][C][U][G][G][C] =  2.000;
 int22_ar[U][A][C][C][U][U][G][C] =  0.600;
 int22_ar[U][A][C][G][A][A][G][C] =  0.300;
 int22_ar[U][A][C][G][A][C][G][C] =  1.700;
 int22_ar[U][A][C][G][A][G][G][C] =  2.000;
 int22_ar[U][A][C][G][A][U][G][C] =  1.400;
 int22_ar[U][A][C][G][C][A][G][C] =  2.000;
 int22_ar[U][A][C][G][C][C][G][C] =  2.000;
 int22_ar[U][A][C][G][C][G][G][C] =  2.000;
 int22_ar[U][A][C][G][C][U][G][C] =  2.000;
 int22_ar[U][A][C][G][G][A][G][C] =  1.300;
 int22_ar[U][A][C][G][G][C][G][C] =  2.400;
 int22_ar[U][A][C][G][G][G][G][C] =  2.000;
 int22_ar[U][A][C][G][G][U][G][C] =  2.100;
 int22_ar[U][A][C][G][U][A][G][C] = -1.500;
 int22_ar[U][A][C][G][U][C][G][C] =  0.000;
 int22_ar[U][A][C][G][U][G][G][C] =  2.000;
 int22_ar[U][A][C][G][U][U][G][C] = -0.300;
 int22_ar[U][A][C][U][A][A][G][C] =  2.000;
 int22_ar[U][A][C][U][A][C][G][C] =  2.000;
 int22_ar[U][A][C][U][A][G][G][C] =  2.000;
 int22_ar[U][A][C][U][A][U][G][C] =  2.000;
 int22_ar[U][A][C][U][C][A][G][C] =  1.500;
 int22_ar[U][A][C][U][C][C][G][C] =  1.900;
 int22_ar[U][A][C][U][C][G][G][C] =  2.000;
 int22_ar[U][A][C][U][C][U][G][C] =  1.600;
 int22_ar[U][A][C][U][G][A][G][C] = -1.100;
 int22_ar[U][A][C][U][G][C][G][C] =  0.400;
 int22_ar[U][A][C][U][G][G][G][C] =  2.000;
 int22_ar[U][A][C][U][G][U][G][C] =  0.100;
 int22_ar[U][A][C][U][U][A][G][C] =  0.700;
 int22_ar[U][A][C][U][U][C][G][C] =  1.100;
 int22_ar[U][A][C][U][U][G][G][C] =  2.000;
 int22_ar[U][A][C][U][U][U][G][C] =  0.800;
 int22_ar[U][A][G][A][A][A][G][C] =  1.100;
 int22_ar[U][A][G][A][A][C][G][C] =  2.000;
 int22_ar[U][A][G][A][A][G][G][C] =  1.500;
 int22_ar[U][A][G][A][A][U][G][C] =  1.600;
 int22_ar[U][A][G][A][C][A][G][C] =  0.800;
 int22_ar[U][A][G][A][C][C][G][C] =  2.000;
 int22_ar[U][A][G][A][C][G][G][C] =  1.200;
 int22_ar[U][A][G][A][C][U][G][C] =  0.300;
 int22_ar[U][A][G][A][G][A][G][C] = -0.900;
 int22_ar[U][A][G][A][G][C][G][C] =  2.000;
 int22_ar[U][A][G][A][G][G][G][C] = -0.500;
 int22_ar[U][A][G][A][G][U][G][C] =  0.400;
 int22_ar[U][A][G][A][U][A][G][C] =  2.000;
 int22_ar[U][A][G][A][U][C][G][C] =  2.000;
 int22_ar[U][A][G][A][U][G][G][C] =  2.000;
 int22_ar[U][A][G][A][U][U][G][C] =  2.000;
 int22_ar[U][A][G][C][A][A][G][C] =  0.800;
 int22_ar[U][A][G][C][A][C][G][C] =  2.000;
 int22_ar[U][A][G][C][A][G][G][C] =  1.200;
 int22_ar[U][A][G][C][A][U][G][C] =  0.300;
 int22_ar[U][A][G][C][C][A][G][C] =  1.800;
 int22_ar[U][A][G][C][C][C][G][C] =  2.000;
 int22_ar[U][A][G][C][C][G][G][C] =  1.800;
 int22_ar[U][A][G][C][C][U][G][C] =  1.300;
 int22_ar[U][A][G][C][G][A][G][C] =  2.000;
 int22_ar[U][A][G][C][G][C][G][C] =  2.000;
 int22_ar[U][A][G][C][G][G][G][C] =  2.000;
 int22_ar[U][A][G][C][G][U][G][C] =  2.000;
 int22_ar[U][A][G][C][U][A][G][C] =  0.900;
 int22_ar[U][A][G][C][U][C][G][C] =  2.000;
 int22_ar[U][A][G][C][U][G][G][C] =  0.800;
 int22_ar[U][A][G][C][U][U][G][C] =  0.400;
 int22_ar[U][A][G][G][A][A][G][C] = -0.300;
 int22_ar[U][A][G][G][A][C][G][C] =  2.000;
 int22_ar[U][A][G][G][A][G][G][C] =  0.100;
 int22_ar[U][A][G][G][A][U][G][C] =  1.000;
 int22_ar[U][A][G][G][C][A][G][C] =  2.000;
 int22_ar[U][A][G][G][C][C][G][C] =  2.000;
 int22_ar[U][A][G][G][C][G][G][C] =  2.000;
 int22_ar[U][A][G][G][C][U][G][C] =  2.000;
 int22_ar[U][A][G][G][G][A][G][C] =  0.700;
 int22_ar[U][A][G][G][G][C][G][C] =  2.000;
 int22_ar[U][A][G][G][G][G][G][C] =  1.100;
 int22_ar[U][A][G][G][G][U][G][C] =  1.200;
 int22_ar[U][A][G][G][U][A][G][C] = -0.300;
 int22_ar[U][A][G][G][U][C][G][C] =  2.000;
 int22_ar[U][A][G][G][U][G][G][C] = -0.700;
 int22_ar[U][A][G][G][U][U][G][C] = -2.600;
 int22_ar[U][A][G][U][A][A][G][C] =  2.000;
 int22_ar[U][A][G][U][A][C][G][C] =  2.000;
 int22_ar[U][A][G][U][A][G][G][C] =  2.000;
 int22_ar[U][A][G][U][A][U][G][C] =  2.000;
 int22_ar[U][A][G][U][C][A][G][C] =  1.900;
 int22_ar[U][A][G][U][C][C][G][C] =  2.000;
 int22_ar[U][A][G][U][C][G][G][C] =  1.900;
 int22_ar[U][A][G][U][C][U][G][C] =  1.400;
 int22_ar[U][A][G][U][G][A][G][C] =  0.100;
 int22_ar[U][A][G][U][G][C][G][C] =  2.000;
 int22_ar[U][A][G][U][G][G][G][C] = -0.300;
 int22_ar[U][A][G][U][G][U][G][C] = -2.200;
 int22_ar[U][A][G][U][U][A][G][C] =  1.900;
 int22_ar[U][A][G][U][U][C][G][C] =  2.000;
 int22_ar[U][A][G][U][U][G][G][C] =  1.500;
 int22_ar[U][A][G][U][U][U][G][C] =  1.400;
 int22_ar[U][A][U][A][A][A][G][C] =  2.000;
 int22_ar[U][A][U][A][A][C][G][C] =  2.700;
 int22_ar[U][A][U][A][A][G][G][C] =  0.300;
 int22_ar[U][A][U][A][A][U][G][C] =  2.300;
 int22_ar[U][A][U][A][C][A][G][C] =  2.000;
 int22_ar[U][A][U][A][C][C][G][C] =  1.900;
 int22_ar[U][A][U][A][C][G][G][C] = -0.900;
 int22_ar[U][A][U][A][C][U][G][C] =  1.000;
 int22_ar[U][A][U][A][G][A][G][C] =  2.000;
 int22_ar[U][A][U][A][G][C][G][C] =  1.100;
 int22_ar[U][A][U][A][G][G][G][C] = -0.900;
 int22_ar[U][A][U][A][G][U][G][C] =  1.100;
 int22_ar[U][A][U][A][U][A][G][C] =  2.000;
 int22_ar[U][A][U][A][U][C][G][C] =  2.000;
 int22_ar[U][A][U][A][U][G][G][C] =  2.000;
 int22_ar[U][A][U][A][U][U][G][C] =  2.000;
 int22_ar[U][A][U][C][A][A][G][C] =  2.000;
 int22_ar[U][A][U][C][A][C][G][C] =  1.800;
 int22_ar[U][A][U][C][A][G][G][C] = -1.000;
 int22_ar[U][A][U][C][A][U][G][C] =  1.000;
 int22_ar[U][A][U][C][C][A][G][C] =  2.000;
 int22_ar[U][A][U][C][C][C][G][C] =  1.900;
 int22_ar[U][A][U][C][C][G][G][C] =  0.100;
 int22_ar[U][A][U][C][C][U][G][C] =  1.000;
 int22_ar[U][A][U][C][G][A][G][C] =  2.000;
 int22_ar[U][A][U][C][G][C][G][C] =  2.000;
 int22_ar[U][A][U][C][G][G][G][C] =  2.000;
 int22_ar[U][A][U][C][G][U][G][C] =  2.000;
 int22_ar[U][A][U][C][U][A][G][C] =  2.000;
 int22_ar[U][A][U][C][U][C][G][C] =  0.900;
 int22_ar[U][A][U][C][U][G][G][C] = -0.900;
 int22_ar[U][A][U][C][U][U][G][C] =  0.000;
 int22_ar[U][A][U][G][A][A][G][C] =  2.000;
 int22_ar[U][A][U][G][A][C][G][C] =  1.700;
 int22_ar[U][A][U][G][A][G][G][C] = -0.300;
 int22_ar[U][A][U][G][A][U][G][C] =  1.700;
 int22_ar[U][A][U][G][C][A][G][C] =  2.000;
 int22_ar[U][A][U][G][C][C][G][C] =  2.000;
 int22_ar[U][A][U][G][C][G][G][C] =  2.000;
 int22_ar[U][A][U][G][C][U][G][C] =  2.000;
 int22_ar[U][A][U][G][G][A][G][C] =  2.000;
 int22_ar[U][A][U][G][G][C][G][C] =  2.400;
 int22_ar[U][A][U][G][G][G][G][C] =  0.000;
 int22_ar[U][A][U][G][G][U][G][C] =  1.900;
 int22_ar[U][A][U][G][U][A][G][C] =  2.000;
 int22_ar[U][A][U][G][U][C][G][C] =  0.000;
 int22_ar[U][A][U][G][U][G][G][C] = -3.900;
 int22_ar[U][A][U][G][U][U][G][C] = -0.100;
 int22_ar[U][A][U][U][A][A][G][C] =  2.000;
 int22_ar[U][A][U][U][A][C][G][C] =  2.000;
 int22_ar[U][A][U][U][A][G][G][C] =  2.000;
 int22_ar[U][A][U][U][A][U][G][C] =  2.000;
 int22_ar[U][A][U][U][C][A][G][C] =  2.000;
 int22_ar[U][A][U][U][C][C][G][C] =  1.900;
 int22_ar[U][A][U][U][C][G][G][C] =  0.100;
 int22_ar[U][A][U][U][C][U][G][C] =  1.100;
 int22_ar[U][A][U][U][G][A][G][C] =  2.000;
 int22_ar[U][A][U][U][G][C][G][C] =  0.400;
 int22_ar[U][A][U][U][G][G][G][C] = -3.500;
 int22_ar[U][A][U][U][G][U][G][C] =  0.300;
 int22_ar[U][A][U][U][U][A][G][C] =  2.000;
 int22_ar[U][A][U][U][U][C][G][C] =  1.100;
 int22_ar[U][A][U][U][U][G][G][C] =  0.100;
 int22_ar[U][A][U][U][U][U][G][C] =  0.300;
 int22_ar[U][A][A][A][A][A][G][U] =  2.800;
 int22_ar[U][A][A][A][A][C][G][U] =  2.800;
 int22_ar[U][A][A][A][A][G][G][U] =  1.700;
 int22_ar[U][A][A][A][A][U][G][U] =  2.000;
 int22_ar[U][A][A][A][C][A][G][U] =  2.500;
 int22_ar[U][A][A][A][C][C][G][U] =  2.500;
 int22_ar[U][A][A][A][C][G][G][U] =  1.500;
 int22_ar[U][A][A][A][C][U][G][U] =  2.000;
 int22_ar[U][A][A][A][G][A][G][U] =  1.500;
 int22_ar[U][A][A][A][G][C][G][U] =  1.500;
 int22_ar[U][A][A][A][G][G][G][U] =  0.500;
 int22_ar[U][A][A][A][G][U][G][U] =  2.000;
 int22_ar[U][A][A][A][U][A][G][U] =  2.000;
 int22_ar[U][A][A][A][U][C][G][U] =  2.000;
 int22_ar[U][A][A][A][U][G][G][U] =  2.000;
 int22_ar[U][A][A][A][U][U][G][U] =  2.000;
 int22_ar[U][A][A][C][A][A][G][U] =  2.600;
 int22_ar[U][A][A][C][A][C][G][U] =  2.600;
 int22_ar[U][A][A][C][A][G][G][U] =  1.600;
 int22_ar[U][A][A][C][A][U][G][U] =  2.000;
 int22_ar[U][A][A][C][C][A][G][U] =  3.100;
 int22_ar[U][A][A][C][C][C][G][U] =  2.500;
 int22_ar[U][A][A][C][C][G][G][U] =  2.400;
 int22_ar[U][A][A][C][C][U][G][U] =  2.000;
 int22_ar[U][A][A][C][G][A][G][U] =  2.000;
 int22_ar[U][A][A][C][G][C][G][U] =  2.000;
 int22_ar[U][A][A][C][G][G][G][U] =  2.000;
 int22_ar[U][A][A][C][G][U][G][U] =  2.000;
 int22_ar[U][A][A][C][U][A][G][U] =  3.100;
 int22_ar[U][A][A][C][U][C][G][U] =  2.500;
 int22_ar[U][A][A][C][U][G][G][U] =  2.400;
 int22_ar[U][A][A][C][U][U][G][U] =  2.000;
 int22_ar[U][A][A][G][A][A][G][U] =  1.500;
 int22_ar[U][A][A][G][A][C][G][U] =  1.500;
 int22_ar[U][A][A][G][A][G][G][U] =  0.500;
 int22_ar[U][A][A][G][A][U][G][U] =  2.000;
 int22_ar[U][A][A][G][C][A][G][U] =  2.000;
 int22_ar[U][A][A][G][C][C][G][U] =  2.000;
 int22_ar[U][A][A][G][C][G][G][U] =  2.000;
 int22_ar[U][A][A][G][C][U][G][U] =  2.000;
 int22_ar[U][A][A][G][G][A][G][U] =  2.100;
 int22_ar[U][A][A][G][G][C][G][U] =  2.100;
 int22_ar[U][A][A][G][G][G][G][U] =  1.000;
 int22_ar[U][A][A][G][G][U][G][U] =  2.000;
 int22_ar[U][A][A][G][U][A][G][U] =  1.300;
 int22_ar[U][A][A][G][U][C][G][U] =  0.300;
 int22_ar[U][A][A][G][U][G][G][U] =  1.100;
 int22_ar[U][A][A][G][U][U][G][U] =  2.000;
 int22_ar[U][A][A][U][A][A][G][U] =  2.000;
 int22_ar[U][A][A][U][A][C][G][U] =  2.000;
 int22_ar[U][A][A][U][A][G][G][U] =  2.000;
 int22_ar[U][A][A][U][A][U][G][U] =  2.000;
 int22_ar[U][A][A][U][C][A][G][U] =  3.100;
 int22_ar[U][A][A][U][C][C][G][U] =  2.500;
 int22_ar[U][A][A][U][C][G][G][U] =  2.400;
 int22_ar[U][A][A][U][C][U][G][U] =  2.000;
 int22_ar[U][A][A][U][G][A][G][U] =  2.300;
 int22_ar[U][A][A][U][G][C][G][U] =  1.300;
 int22_ar[U][A][A][U][G][G][G][U] =  2.100;
 int22_ar[U][A][A][U][G][U][G][U] =  2.000;
 int22_ar[U][A][A][U][U][A][G][U] =  2.700;
 int22_ar[U][A][A][U][U][C][G][U] =  1.700;
 int22_ar[U][A][A][U][U][G][G][U] =  2.400;
 int22_ar[U][A][A][U][U][U][G][U] =  2.000;
 int22_ar[U][A][C][A][A][A][G][U] =  2.300;
 int22_ar[U][A][C][A][A][C][G][U] =  3.400;
 int22_ar[U][A][C][A][A][G][G][U] =  2.000;
 int22_ar[U][A][C][A][A][U][G][U] =  3.100;
 int22_ar[U][A][C][A][C][A][G][U] =  2.100;
 int22_ar[U][A][C][A][C][C][G][U] =  2.500;
 int22_ar[U][A][C][A][C][G][G][U] =  2.000;
 int22_ar[U][A][C][A][C][U][G][U] =  2.200;
 int22_ar[U][A][C][A][G][A][G][U] =  1.100;
 int22_ar[U][A][C][A][G][C][G][U] =  2.500;
 int22_ar[U][A][C][A][G][G][G][U] =  2.000;
 int22_ar[U][A][C][A][G][U][G][U] =  2.200;
 int22_ar[U][A][C][A][U][A][G][U] =  2.000;
 int22_ar[U][A][C][A][U][C][G][U] =  2.000;
 int22_ar[U][A][C][A][U][G][G][U] =  2.000;
 int22_ar[U][A][C][A][U][U][G][U] =  2.000;
 int22_ar[U][A][C][C][A][A][G][U] =  2.200;
 int22_ar[U][A][C][C][A][C][G][U] =  2.600;
 int22_ar[U][A][C][C][A][G][G][U] =  2.000;
 int22_ar[U][A][C][C][A][U][G][U] =  2.300;
 int22_ar[U][A][C][C][C][A][G][U] =  2.000;
 int22_ar[U][A][C][C][C][C][G][U] =  2.500;
 int22_ar[U][A][C][C][C][G][G][U] =  2.000;
 int22_ar[U][A][C][C][C][U][G][U] =  2.200;
 int22_ar[U][A][C][C][G][A][G][U] =  2.000;
 int22_ar[U][A][C][C][G][C][G][U] =  2.000;
 int22_ar[U][A][C][C][G][G][G][U] =  2.000;
 int22_ar[U][A][C][C][G][U][G][U] =  2.000;
 int22_ar[U][A][C][C][U][A][G][U] =  2.000;
 int22_ar[U][A][C][C][U][C][G][U] =  2.500;
 int22_ar[U][A][C][C][U][G][G][U] =  2.000;
 int22_ar[U][A][C][C][U][U][G][U] =  2.200;
 int22_ar[U][A][C][G][A][A][G][U] =  1.100;
 int22_ar[U][A][C][G][A][C][G][U] =  2.500;
 int22_ar[U][A][C][G][A][G][G][U] =  2.000;
 int22_ar[U][A][C][G][A][U][G][U] =  2.200;
 int22_ar[U][A][C][G][C][A][G][U] =  2.000;
 int22_ar[U][A][C][G][C][C][G][U] =  2.000;
 int22_ar[U][A][C][G][C][G][G][U] =  2.000;
 int22_ar[U][A][C][G][C][U][G][U] =  2.000;
 int22_ar[U][A][C][G][G][A][G][U] =  1.600;
 int22_ar[U][A][C][G][G][C][G][U] =  2.700;
 int22_ar[U][A][C][G][G][G][G][U] =  2.000;
 int22_ar[U][A][C][G][G][U][G][U] =  2.400;
 int22_ar[U][A][C][G][U][A][G][U] = -0.100;
 int22_ar[U][A][C][G][U][C][G][U] =  1.300;
 int22_ar[U][A][C][G][U][G][G][U] =  2.000;
 int22_ar[U][A][C][G][U][U][G][U] =  1.000;
 int22_ar[U][A][C][U][A][A][G][U] =  2.000;
 int22_ar[U][A][C][U][A][C][G][U] =  2.000;
 int22_ar[U][A][C][U][A][G][G][U] =  2.000;
 int22_ar[U][A][C][U][A][U][G][U] =  2.000;
 int22_ar[U][A][C][U][C][A][G][U] =  2.000;
 int22_ar[U][A][C][U][C][C][G][U] =  2.500;
 int22_ar[U][A][C][U][C][G][G][U] =  2.000;
 int22_ar[U][A][C][U][C][U][G][U] =  2.200;
 int22_ar[U][A][C][U][G][A][G][U] =  0.900;
 int22_ar[U][A][C][U][G][C][G][U] =  2.300;
 int22_ar[U][A][C][U][G][G][G][U] =  2.000;
 int22_ar[U][A][C][U][G][U][G][U] =  2.000;
 int22_ar[U][A][C][U][U][A][G][U] =  1.200;
 int22_ar[U][A][C][U][U][C][G][U] =  1.700;
 int22_ar[U][A][C][U][U][G][G][U] =  2.000;
 int22_ar[U][A][C][U][U][U][G][U] =  1.400;
 int22_ar[U][A][G][A][A][A][G][U] =  1.700;
 int22_ar[U][A][G][A][A][C][G][U] =  2.000;
 int22_ar[U][A][G][A][A][G][G][U] =  2.100;
 int22_ar[U][A][G][A][A][U][G][U] =  2.200;
 int22_ar[U][A][G][A][C][A][G][U] =  1.500;
 int22_ar[U][A][G][A][C][C][G][U] =  2.000;
 int22_ar[U][A][G][A][C][G][G][U] =  1.900;
 int22_ar[U][A][G][A][C][U][G][U] =  1.000;
 int22_ar[U][A][G][A][G][A][G][U] =  0.500;
 int22_ar[U][A][G][A][G][C][G][U] =  2.000;
 int22_ar[U][A][G][A][G][G][G][U] =  0.900;
 int22_ar[U][A][G][A][G][U][G][U] =  1.800;
 int22_ar[U][A][G][A][U][A][G][U] =  2.000;
 int22_ar[U][A][G][A][U][C][G][U] =  2.000;
 int22_ar[U][A][G][A][U][G][G][U] =  2.000;
 int22_ar[U][A][G][A][U][U][G][U] =  2.000;
 int22_ar[U][A][G][C][A][A][G][U] =  1.600;
 int22_ar[U][A][G][C][A][C][G][U] =  2.000;
 int22_ar[U][A][G][C][A][G][G][U] =  2.000;
 int22_ar[U][A][G][C][A][U][G][U] =  1.100;
 int22_ar[U][A][G][C][C][A][G][U] =  2.400;
 int22_ar[U][A][G][C][C][C][G][U] =  2.000;
 int22_ar[U][A][G][C][C][G][G][U] =  2.400;
 int22_ar[U][A][G][C][C][U][G][U] =  1.900;
 int22_ar[U][A][G][C][G][A][G][U] =  2.000;
 int22_ar[U][A][G][C][G][C][G][U] =  2.000;
 int22_ar[U][A][G][C][G][G][G][U] =  2.000;
 int22_ar[U][A][G][C][G][U][G][U] =  2.000;
 int22_ar[U][A][G][C][U][A][G][U] =  2.400;
 int22_ar[U][A][G][C][U][C][G][U] =  2.000;
 int22_ar[U][A][G][C][U][G][G][U] =  2.400;
 int22_ar[U][A][G][C][U][U][G][U] =  1.900;
 int22_ar[U][A][G][G][A][A][G][U] =  0.500;
 int22_ar[U][A][G][G][A][C][G][U] =  2.000;
 int22_ar[U][A][G][G][A][G][G][U] =  0.900;
 int22_ar[U][A][G][G][A][U][G][U] =  1.800;
 int22_ar[U][A][G][G][C][A][G][U] =  2.000;
 int22_ar[U][A][G][G][C][C][G][U] =  2.000;
 int22_ar[U][A][G][G][C][G][G][U] =  2.000;
 int22_ar[U][A][G][G][C][U][G][U] =  2.000;
 int22_ar[U][A][G][G][G][A][G][U] =  1.000;
 int22_ar[U][A][G][G][G][C][G][U] =  2.000;
 int22_ar[U][A][G][G][G][G][G][U] =  1.400;
 int22_ar[U][A][G][G][G][U][G][U] =  1.500;
 int22_ar[U][A][G][G][U][A][G][U] =  1.100;
 int22_ar[U][A][G][G][U][C][G][U] =  2.000;
 int22_ar[U][A][G][G][U][G][G][U] =  0.700;
 int22_ar[U][A][G][G][U][U][G][U] = -1.200;
 int22_ar[U][A][G][U][A][A][G][U] =  2.000;
 int22_ar[U][A][G][U][A][C][G][U] =  2.000;
 int22_ar[U][A][G][U][A][G][G][U] =  2.000;
 int22_ar[U][A][G][U][A][U][G][U] =  2.000;
 int22_ar[U][A][G][U][C][A][G][U] =  2.400;
 int22_ar[U][A][G][U][C][C][G][U] =  2.000;
 int22_ar[U][A][G][U][C][G][G][U] =  2.400;
 int22_ar[U][A][G][U][C][U][G][U] =  1.900;
 int22_ar[U][A][G][U][G][A][G][U] =  2.100;
 int22_ar[U][A][G][U][G][C][G][U] =  2.000;
 int22_ar[U][A][G][U][G][G][G][U] =  1.700;
 int22_ar[U][A][G][U][G][U][G][U] = -0.200;
 int22_ar[U][A][G][U][U][A][G][U] =  2.400;
 int22_ar[U][A][G][U][U][C][G][U] =  2.000;
 int22_ar[U][A][G][U][U][G][G][U] =  2.000;
 int22_ar[U][A][G][U][U][U][G][U] =  1.900;
 int22_ar[U][A][U][A][A][A][G][U] =  2.000;
 int22_ar[U][A][U][A][A][C][G][U] =  3.400;
 int22_ar[U][A][U][A][A][G][G][U] =  1.000;
 int22_ar[U][A][U][A][A][U][G][U] =  2.900;
 int22_ar[U][A][U][A][C][A][G][U] =  2.000;
 int22_ar[U][A][U][A][C][C][G][U] =  2.500;
 int22_ar[U][A][U][A][C][G][G][U] = -0.300;
 int22_ar[U][A][U][A][C][U][G][U] =  1.700;
 int22_ar[U][A][U][A][G][A][G][U] =  2.000;
 int22_ar[U][A][U][A][G][C][G][U] =  2.500;
 int22_ar[U][A][U][A][G][G][G][U] =  0.500;
 int22_ar[U][A][U][A][G][U][G][U] =  2.500;
 int22_ar[U][A][U][A][U][A][G][U] =  2.000;
 int22_ar[U][A][U][A][U][C][G][U] =  2.000;
 int22_ar[U][A][U][A][U][G][G][U] =  2.000;
 int22_ar[U][A][U][A][U][U][G][U] =  2.000;
 int22_ar[U][A][U][C][A][A][G][U] =  2.000;
 int22_ar[U][A][U][C][A][C][G][U] =  2.600;
 int22_ar[U][A][U][C][A][G][G][U] = -0.200;
 int22_ar[U][A][U][C][A][U][G][U] =  1.800;
 int22_ar[U][A][U][C][C][A][G][U] =  2.000;
 int22_ar[U][A][U][C][C][C][G][U] =  2.500;
 int22_ar[U][A][U][C][C][G][G][U] =  0.700;
 int22_ar[U][A][U][C][C][U][G][U] =  1.600;
 int22_ar[U][A][U][C][G][A][G][U] =  2.000;
 int22_ar[U][A][U][C][G][C][G][U] =  2.000;
 int22_ar[U][A][U][C][G][G][G][U] =  2.000;
 int22_ar[U][A][U][C][G][U][G][U] =  2.000;
 int22_ar[U][A][U][C][U][A][G][U] =  2.000;
 int22_ar[U][A][U][C][U][C][G][U] =  2.500;
 int22_ar[U][A][U][C][U][G][G][U] =  0.700;
 int22_ar[U][A][U][C][U][U][G][U] =  1.600;
 int22_ar[U][A][U][G][A][A][G][U] =  2.000;
 int22_ar[U][A][U][G][A][C][G][U] =  2.500;
 int22_ar[U][A][U][G][A][G][G][U] =  0.500;
 int22_ar[U][A][U][G][A][U][G][U] =  2.500;
 int22_ar[U][A][U][G][C][A][G][U] =  2.000;
 int22_ar[U][A][U][G][C][C][G][U] =  2.000;
 int22_ar[U][A][U][G][C][G][G][U] =  2.000;
 int22_ar[U][A][U][G][C][U][G][U] =  2.000;
 int22_ar[U][A][U][G][G][A][G][U] =  2.000;
 int22_ar[U][A][U][G][G][C][G][U] =  2.700;
 int22_ar[U][A][U][G][G][G][G][U] =  0.300;
 int22_ar[U][A][U][G][G][U][G][U] =  2.200;
 int22_ar[U][A][U][G][U][A][G][U] =  2.000;
 int22_ar[U][A][U][G][U][C][G][U] =  1.300;
 int22_ar[U][A][U][G][U][G][G][U] = -2.500;
 int22_ar[U][A][U][G][U][U][G][U] =  1.300;
 int22_ar[U][A][U][U][A][A][G][U] =  2.000;
 int22_ar[U][A][U][U][A][C][G][U] =  2.000;
 int22_ar[U][A][U][U][A][G][G][U] =  2.000;
 int22_ar[U][A][U][U][A][U][G][U] =  2.000;
 int22_ar[U][A][U][U][C][A][G][U] =  2.000;
 int22_ar[U][A][U][U][C][C][G][U] =  2.500;
 int22_ar[U][A][U][U][C][G][G][U] =  0.700;
 int22_ar[U][A][U][U][C][U][G][U] =  1.600;
 int22_ar[U][A][U][U][G][A][G][U] =  2.000;
 int22_ar[U][A][U][U][G][C][G][U] =  2.300;
 int22_ar[U][A][U][U][G][G][G][U] = -1.500;
 int22_ar[U][A][U][U][G][U][G][U] =  2.300;
 int22_ar[U][A][U][U][U][A][G][U] =  2.000;
 int22_ar[U][A][U][U][U][C][G][U] =  1.700;
 int22_ar[U][A][U][U][U][G][G][U] =  0.700;
 int22_ar[U][A][U][U][U][U][G][U] =  0.800;
 int22_ar[U][A][A][A][A][A][U][A] =  2.800;
 int22_ar[U][A][A][A][A][C][U][A] =  2.800;
 int22_ar[U][A][A][A][A][G][U][A] =  1.700;
 int22_ar[U][A][A][A][A][U][U][A] =  2.000;
 int22_ar[U][A][A][A][C][A][U][A] =  2.300;
 int22_ar[U][A][A][A][C][C][U][A] =  2.300;
 int22_ar[U][A][A][A][C][G][U][A] =  1.300;
 int22_ar[U][A][A][A][C][U][U][A] =  2.000;
 int22_ar[U][A][A][A][G][A][U][A] =  1.700;
 int22_ar[U][A][A][A][G][C][U][A] =  1.700;
 int22_ar[U][A][A][A][G][G][U][A] =  0.700;
 int22_ar[U][A][A][A][G][U][U][A] =  2.000;
 int22_ar[U][A][A][A][U][A][U][A] =  2.000;
 int22_ar[U][A][A][A][U][C][U][A] =  2.000;
 int22_ar[U][A][A][A][U][G][U][A] =  2.000;
 int22_ar[U][A][A][A][U][U][U][A] =  2.000;
 int22_ar[U][A][A][C][A][A][U][A] =  2.800;
 int22_ar[U][A][A][C][A][C][U][A] =  2.800;
 int22_ar[U][A][A][C][A][G][U][A] =  1.700;
 int22_ar[U][A][A][C][A][U][U][A] =  2.000;
 int22_ar[U][A][A][C][C][A][U][A] =  3.400;
 int22_ar[U][A][A][C][C][C][U][A] =  2.800;
 int22_ar[U][A][A][C][C][G][U][A] =  2.700;
 int22_ar[U][A][A][C][C][U][U][A] =  2.000;
 int22_ar[U][A][A][C][G][A][U][A] =  2.000;
 int22_ar[U][A][A][C][G][C][U][A] =  2.000;
 int22_ar[U][A][A][C][G][G][U][A] =  2.000;
 int22_ar[U][A][A][C][G][U][U][A] =  2.000;
 int22_ar[U][A][A][C][U][A][U][A] =  3.400;
 int22_ar[U][A][A][C][U][C][U][A] =  2.800;
 int22_ar[U][A][A][C][U][G][U][A] =  2.700;
 int22_ar[U][A][A][C][U][U][U][A] =  2.000;
 int22_ar[U][A][A][G][A][A][U][A] =  1.700;
 int22_ar[U][A][A][G][A][C][U][A] =  1.700;
 int22_ar[U][A][A][G][A][G][U][A] =  0.700;
 int22_ar[U][A][A][G][A][U][U][A] =  2.000;
 int22_ar[U][A][A][G][C][A][U][A] =  2.000;
 int22_ar[U][A][A][G][C][C][U][A] =  2.000;
 int22_ar[U][A][A][G][C][G][U][A] =  2.000;
 int22_ar[U][A][A][G][C][U][U][A] =  2.000;
 int22_ar[U][A][A][G][G][A][U][A] =  2.100;
 int22_ar[U][A][A][G][G][C][U][A] =  2.100;
 int22_ar[U][A][A][G][G][G][U][A] =  1.100;
 int22_ar[U][A][A][G][G][U][U][A] =  2.000;
 int22_ar[U][A][A][G][U][A][U][A] =  1.000;
 int22_ar[U][A][A][G][U][C][U][A] =  0.000;
 int22_ar[U][A][A][G][U][G][U][A] =  0.700;
 int22_ar[U][A][A][G][U][U][U][A] =  2.000;
 int22_ar[U][A][A][U][A][A][U][A] =  2.000;
 int22_ar[U][A][A][U][A][C][U][A] =  2.000;
 int22_ar[U][A][A][U][A][G][U][A] =  2.000;
 int22_ar[U][A][A][U][A][U][U][A] =  2.000;
 int22_ar[U][A][A][U][C][A][U][A] =  3.100;
 int22_ar[U][A][A][U][C][C][U][A] =  2.500;
 int22_ar[U][A][A][U][C][G][U][A] =  2.400;
 int22_ar[U][A][A][U][C][U][U][A] =  2.000;
 int22_ar[U][A][A][U][G][A][U][A] =  2.200;
 int22_ar[U][A][A][U][G][C][U][A] =  1.200;
 int22_ar[U][A][A][U][G][G][U][A] =  2.000;
 int22_ar[U][A][A][U][G][U][U][A] =  2.000;
 int22_ar[U][A][A][U][U][A][U][A] =  2.900;
 int22_ar[U][A][A][U][U][C][U][A] =  1.900;
 int22_ar[U][A][A][U][U][G][U][A] =  2.700;
 int22_ar[U][A][A][U][U][U][U][A] =  2.000;
 int22_ar[U][A][C][A][A][A][U][A] =  2.300;
 int22_ar[U][A][C][A][A][C][U][A] =  3.400;
 int22_ar[U][A][C][A][A][G][U][A] =  2.000;
 int22_ar[U][A][C][A][A][U][U][A] =  3.100;
 int22_ar[U][A][C][A][C][A][U][A] =  1.900;
 int22_ar[U][A][C][A][C][C][U][A] =  2.300;
 int22_ar[U][A][C][A][C][G][U][A] =  2.000;
 int22_ar[U][A][C][A][C][U][U][A] =  2.000;
 int22_ar[U][A][C][A][G][A][U][A] =  1.300;
 int22_ar[U][A][C][A][G][C][U][A] =  2.700;
 int22_ar[U][A][C][A][G][G][U][A] =  2.000;
 int22_ar[U][A][C][A][G][U][U][A] =  2.400;
 int22_ar[U][A][C][A][U][A][U][A] =  2.000;
 int22_ar[U][A][C][A][U][C][U][A] =  2.000;
 int22_ar[U][A][C][A][U][G][U][A] =  2.000;
 int22_ar[U][A][C][A][U][U][U][A] =  2.000;
 int22_ar[U][A][C][C][A][A][U][A] =  2.300;
 int22_ar[U][A][C][C][A][C][U][A] =  2.800;
 int22_ar[U][A][C][C][A][G][U][A] =  2.000;
 int22_ar[U][A][C][C][A][U][U][A] =  2.500;
 int22_ar[U][A][C][C][C][A][U][A] =  2.300;
 int22_ar[U][A][C][C][C][C][U][A] =  2.800;
 int22_ar[U][A][C][C][C][G][U][A] =  2.000;
 int22_ar[U][A][C][C][C][U][U][A] =  2.500;
 int22_ar[U][A][C][C][G][A][U][A] =  2.000;
 int22_ar[U][A][C][C][G][C][U][A] =  2.000;
 int22_ar[U][A][C][C][G][G][U][A] =  2.000;
 int22_ar[U][A][C][C][G][U][U][A] =  2.000;
 int22_ar[U][A][C][C][U][A][U][A] =  2.300;
 int22_ar[U][A][C][C][U][C][U][A] =  2.800;
 int22_ar[U][A][C][C][U][G][U][A] =  2.000;
 int22_ar[U][A][C][C][U][U][U][A] =  2.500;
 int22_ar[U][A][C][G][A][A][U][A] =  1.300;
 int22_ar[U][A][C][G][A][C][U][A] =  2.700;
 int22_ar[U][A][C][G][A][G][U][A] =  2.000;
 int22_ar[U][A][C][G][A][U][U][A] =  2.400;
 int22_ar[U][A][C][G][C][A][U][A] =  2.000;
 int22_ar[U][A][C][G][C][C][U][A] =  2.000;
 int22_ar[U][A][C][G][C][G][U][A] =  2.000;
 int22_ar[U][A][C][G][C][U][U][A] =  2.000;
 int22_ar[U][A][C][G][G][A][U][A] =  1.700;
 int22_ar[U][A][C][G][G][C][U][A] =  2.700;
 int22_ar[U][A][C][G][G][G][U][A] =  2.000;
 int22_ar[U][A][C][G][G][U][U][A] =  2.400;
 int22_ar[U][A][C][G][U][A][U][A] = -0.500;
 int22_ar[U][A][C][G][U][C][U][A] =  1.000;
 int22_ar[U][A][C][G][U][G][U][A] =  2.000;
 int22_ar[U][A][C][G][U][U][U][A] =  0.700;
 int22_ar[U][A][C][U][A][A][U][A] =  2.000;
 int22_ar[U][A][C][U][A][C][U][A] =  2.000;
 int22_ar[U][A][C][U][A][G][U][A] =  2.000;
 int22_ar[U][A][C][U][A][U][U][A] =  2.000;
 int22_ar[U][A][C][U][C][A][U][A] =  2.000;
 int22_ar[U][A][C][U][C][C][U][A] =  2.500;
 int22_ar[U][A][C][U][C][G][U][A] =  2.000;
 int22_ar[U][A][C][U][C][U][U][A] =  2.200;
 int22_ar[U][A][C][U][G][A][U][A] =  0.800;
 int22_ar[U][A][C][U][G][C][U][A] =  2.200;
 int22_ar[U][A][C][U][G][G][U][A] =  2.000;
 int22_ar[U][A][C][U][G][U][U][A] =  1.900;
 int22_ar[U][A][C][U][U][A][U][A] =  1.500;
 int22_ar[U][A][C][U][U][C][U][A] =  1.900;
 int22_ar[U][A][C][U][U][G][U][A] =  2.000;
 int22_ar[U][A][C][U][U][U][U][A] =  1.600;
 int22_ar[U][A][G][A][A][A][U][A] =  1.700;
 int22_ar[U][A][G][A][A][C][U][A] =  2.000;
 int22_ar[U][A][G][A][A][G][U][A] =  2.100;
 int22_ar[U][A][G][A][A][U][U][A] =  2.200;
 int22_ar[U][A][G][A][C][A][U][A] =  1.300;
 int22_ar[U][A][G][A][C][C][U][A] =  2.000;
 int22_ar[U][A][G][A][C][G][U][A] =  1.700;
 int22_ar[U][A][G][A][C][U][U][A] =  0.800;
 int22_ar[U][A][G][A][G][A][U][A] =  0.700;
 int22_ar[U][A][G][A][G][C][U][A] =  2.000;
 int22_ar[U][A][G][A][G][G][U][A] =  1.100;
 int22_ar[U][A][G][A][G][U][U][A] =  2.000;
 int22_ar[U][A][G][A][U][A][U][A] =  2.000;
 int22_ar[U][A][G][A][U][C][U][A] =  2.000;
 int22_ar[U][A][G][A][U][G][U][A] =  2.000;
 int22_ar[U][A][G][A][U][U][U][A] =  2.000;
 int22_ar[U][A][G][C][A][A][U][A] =  1.700;
 int22_ar[U][A][G][C][A][C][U][A] =  2.000;
 int22_ar[U][A][G][C][A][G][U][A] =  2.100;
 int22_ar[U][A][G][C][A][U][U][A] =  1.200;
 int22_ar[U][A][G][C][C][A][U][A] =  2.700;
 int22_ar[U][A][G][C][C][C][U][A] =  2.000;
 int22_ar[U][A][G][C][C][G][U][A] =  2.700;
 int22_ar[U][A][G][C][C][U][U][A] =  2.200;
 int22_ar[U][A][G][C][G][A][U][A] =  2.000;
 int22_ar[U][A][G][C][G][C][U][A] =  2.000;
 int22_ar[U][A][G][C][G][G][U][A] =  2.000;
 int22_ar[U][A][G][C][G][U][U][A] =  2.000;
 int22_ar[U][A][G][C][U][A][U][A] =  2.700;
 int22_ar[U][A][G][C][U][C][U][A] =  2.000;
 int22_ar[U][A][G][C][U][G][U][A] =  2.700;
 int22_ar[U][A][G][C][U][U][U][A] =  2.200;
 int22_ar[U][A][G][G][A][A][U][A] =  0.700;
 int22_ar[U][A][G][G][A][C][U][A] =  2.000;
 int22_ar[U][A][G][G][A][G][U][A] =  1.100;
 int22_ar[U][A][G][G][A][U][U][A] =  2.000;
 int22_ar[U][A][G][G][C][A][U][A] =  2.000;
 int22_ar[U][A][G][G][C][C][U][A] =  2.000;
 int22_ar[U][A][G][G][C][G][U][A] =  2.000;
 int22_ar[U][A][G][G][C][U][U][A] =  2.000;
 int22_ar[U][A][G][G][G][A][U][A] =  1.100;
 int22_ar[U][A][G][G][G][C][U][A] =  2.000;
 int22_ar[U][A][G][G][G][G][U][A] =  1.500;
 int22_ar[U][A][G][G][G][U][U][A] =  1.600;
 int22_ar[U][A][G][G][U][A][U][A] =  0.700;
 int22_ar[U][A][G][G][U][C][U][A] =  2.000;
 int22_ar[U][A][G][G][U][G][U][A] =  0.300;
 int22_ar[U][A][G][G][U][U][U][A] = -1.600;
 int22_ar[U][A][G][U][A][A][U][A] =  2.000;
 int22_ar[U][A][G][U][A][C][U][A] =  2.000;
 int22_ar[U][A][G][U][A][G][U][A] =  2.000;
 int22_ar[U][A][G][U][A][U][U][A] =  2.000;
 int22_ar[U][A][G][U][C][A][U][A] =  2.400;
 int22_ar[U][A][G][U][C][C][U][A] =  2.000;
 int22_ar[U][A][G][U][C][G][U][A] =  2.400;
 int22_ar[U][A][G][U][C][U][U][A] =  1.900;
 int22_ar[U][A][G][U][G][A][U][A] =  2.000;
 int22_ar[U][A][G][U][G][C][U][A] =  2.000;
 int22_ar[U][A][G][U][G][G][U][A] =  1.600;
 int22_ar[U][A][G][U][G][U][U][A] = -0.300;
 int22_ar[U][A][G][U][U][A][U][A] =  2.700;
 int22_ar[U][A][G][U][U][C][U][A] =  2.000;
 int22_ar[U][A][G][U][U][G][U][A] =  2.300;
 int22_ar[U][A][G][U][U][U][U][A] =  2.200;
 int22_ar[U][A][U][A][A][A][U][A] =  2.000;
 int22_ar[U][A][U][A][A][C][U][A] =  3.400;
 int22_ar[U][A][U][A][A][G][U][A] =  1.000;
 int22_ar[U][A][U][A][A][U][U][A] =  2.900;
 int22_ar[U][A][U][A][C][A][U][A] =  2.000;
 int22_ar[U][A][U][A][C][C][U][A] =  2.300;
 int22_ar[U][A][U][A][C][G][U][A] = -0.500;
 int22_ar[U][A][U][A][C][U][U][A] =  1.500;
 int22_ar[U][A][U][A][G][A][U][A] =  2.000;
 int22_ar[U][A][U][A][G][C][U][A] =  2.700;
 int22_ar[U][A][U][A][G][G][U][A] =  0.700;
 int22_ar[U][A][U][A][G][U][U][A] =  2.700;
 int22_ar[U][A][U][A][U][A][U][A] =  2.000;
 int22_ar[U][A][U][A][U][C][U][A] =  2.000;
 int22_ar[U][A][U][A][U][G][U][A] =  2.000;
 int22_ar[U][A][U][A][U][U][U][A] =  2.000;
 int22_ar[U][A][U][C][A][A][U][A] =  2.000;
 int22_ar[U][A][U][C][A][C][U][A] =  2.800;
 int22_ar[U][A][U][C][A][G][U][A] =  0.000;
 int22_ar[U][A][U][C][A][U][U][A] =  1.900;
 int22_ar[U][A][U][C][C][A][U][A] =  2.000;
 int22_ar[U][A][U][C][C][C][U][A] =  2.800;
 int22_ar[U][A][U][C][C][G][U][A] =  1.000;
 int22_ar[U][A][U][C][C][U][U][A] =  1.900;
 int22_ar[U][A][U][C][G][A][U][A] =  2.000;
 int22_ar[U][A][U][C][G][C][U][A] =  2.000;
 int22_ar[U][A][U][C][G][G][U][A] =  2.000;
 int22_ar[U][A][U][C][G][U][U][A] =  2.000;
 int22_ar[U][A][U][C][U][A][U][A] =  2.000;
 int22_ar[U][A][U][C][U][C][U][A] =  2.800;
 int22_ar[U][A][U][C][U][G][U][A] =  1.000;
 int22_ar[U][A][U][C][U][U][U][A] =  1.900;
 int22_ar[U][A][U][G][A][A][U][A] =  2.000;
 int22_ar[U][A][U][G][A][C][U][A] =  2.700;
 int22_ar[U][A][U][G][A][G][U][A] =  0.700;
 int22_ar[U][A][U][G][A][U][U][A] =  2.700;
 int22_ar[U][A][U][G][C][A][U][A] =  2.000;
 int22_ar[U][A][U][G][C][C][U][A] =  2.000;
 int22_ar[U][A][U][G][C][G][U][A] =  2.000;
 int22_ar[U][A][U][G][C][U][U][A] =  2.000;
 int22_ar[U][A][U][G][G][A][U][A] =  2.000;
 int22_ar[U][A][U][G][G][C][U][A] =  2.700;
 int22_ar[U][A][U][G][G][G][U][A] =  0.300;
 int22_ar[U][A][U][G][G][U][U][A] =  2.300;
 int22_ar[U][A][U][G][U][A][U][A] =  2.000;
 int22_ar[U][A][U][G][U][C][U][A] =  1.000;
 int22_ar[U][A][U][G][U][G][U][A] = -2.900;
 int22_ar[U][A][U][G][U][U][U][A] =  0.900;
 int22_ar[U][A][U][U][A][A][U][A] =  2.000;
 int22_ar[U][A][U][U][A][C][U][A] =  2.000;
 int22_ar[U][A][U][U][A][G][U][A] =  2.000;
 int22_ar[U][A][U][U][A][U][U][A] =  2.000;
 int22_ar[U][A][U][U][C][A][U][A] =  2.000;
 int22_ar[U][A][U][U][C][C][U][A] =  2.500;
 int22_ar[U][A][U][U][C][G][U][A] =  0.700;
 int22_ar[U][A][U][U][C][U][U][A] =  1.600;
 int22_ar[U][A][U][U][G][A][U][A] =  2.000;
 int22_ar[U][A][U][U][G][C][U][A] =  2.200;
 int22_ar[U][A][U][U][G][G][U][A] = -1.600;
 int22_ar[U][A][U][U][G][U][U][A] =  2.200;
 int22_ar[U][A][U][U][U][A][U][A] =  2.000;
 int22_ar[U][A][U][U][U][C][U][A] =  1.900;
 int22_ar[U][A][U][U][U][G][U][A] =  0.900;
 int22_ar[U][A][U][U][U][U][U][A] =  1.100;
 int22_ar[U][A][A][A][A][A][U][G] =  2.800;
 int22_ar[U][A][A][A][A][C][U][G] =  2.800;
 int22_ar[U][A][A][A][A][G][U][G] =  1.700;
 int22_ar[U][A][A][A][A][U][U][G] =  2.000;
 int22_ar[U][A][A][A][C][A][U][G] =  2.300;
 int22_ar[U][A][A][A][C][C][U][G] =  2.300;
 int22_ar[U][A][A][A][C][G][U][G] =  1.300;
 int22_ar[U][A][A][A][C][U][U][G] =  2.000;
 int22_ar[U][A][A][A][G][A][U][G] =  1.700;
 int22_ar[U][A][A][A][G][C][U][G] =  1.700;
 int22_ar[U][A][A][A][G][G][U][G] =  0.700;
 int22_ar[U][A][A][A][G][U][U][G] =  2.000;
 int22_ar[U][A][A][A][U][A][U][G] =  2.000;
 int22_ar[U][A][A][A][U][C][U][G] =  2.000;
 int22_ar[U][A][A][A][U][G][U][G] =  2.000;
 int22_ar[U][A][A][A][U][U][U][G] =  2.000;
 int22_ar[U][A][A][C][A][A][U][G] =  2.800;
 int22_ar[U][A][A][C][A][C][U][G] =  2.800;
 int22_ar[U][A][A][C][A][G][U][G] =  1.700;
 int22_ar[U][A][A][C][A][U][U][G] =  2.000;
 int22_ar[U][A][A][C][C][A][U][G] =  3.400;
 int22_ar[U][A][A][C][C][C][U][G] =  2.800;
 int22_ar[U][A][A][C][C][G][U][G] =  2.700;
 int22_ar[U][A][A][C][C][U][U][G] =  2.000;
 int22_ar[U][A][A][C][G][A][U][G] =  2.000;
 int22_ar[U][A][A][C][G][C][U][G] =  2.000;
 int22_ar[U][A][A][C][G][G][U][G] =  2.000;
 int22_ar[U][A][A][C][G][U][U][G] =  2.000;
 int22_ar[U][A][A][C][U][A][U][G] =  3.400;
 int22_ar[U][A][A][C][U][C][U][G] =  2.800;
 int22_ar[U][A][A][C][U][G][U][G] =  2.700;
 int22_ar[U][A][A][C][U][U][U][G] =  2.000;
 int22_ar[U][A][A][G][A][A][U][G] =  1.700;
 int22_ar[U][A][A][G][A][C][U][G] =  1.700;
 int22_ar[U][A][A][G][A][G][U][G] =  0.700;
 int22_ar[U][A][A][G][A][U][U][G] =  2.000;
 int22_ar[U][A][A][G][C][A][U][G] =  2.000;
 int22_ar[U][A][A][G][C][C][U][G] =  2.000;
 int22_ar[U][A][A][G][C][G][U][G] =  2.000;
 int22_ar[U][A][A][G][C][U][U][G] =  2.000;
 int22_ar[U][A][A][G][G][A][U][G] =  2.100;
 int22_ar[U][A][A][G][G][C][U][G] =  2.100;
 int22_ar[U][A][A][G][G][G][U][G] =  1.100;
 int22_ar[U][A][A][G][G][U][U][G] =  2.000;
 int22_ar[U][A][A][G][U][A][U][G] =  1.000;
 int22_ar[U][A][A][G][U][C][U][G] =  0.000;
 int22_ar[U][A][A][G][U][G][U][G] =  0.700;
 int22_ar[U][A][A][G][U][U][U][G] =  2.000;
 int22_ar[U][A][A][U][A][A][U][G] =  2.000;
 int22_ar[U][A][A][U][A][C][U][G] =  2.000;
 int22_ar[U][A][A][U][A][G][U][G] =  2.000;
 int22_ar[U][A][A][U][A][U][U][G] =  2.000;
 int22_ar[U][A][A][U][C][A][U][G] =  3.100;
 int22_ar[U][A][A][U][C][C][U][G] =  2.500;
 int22_ar[U][A][A][U][C][G][U][G] =  2.400;
 int22_ar[U][A][A][U][C][U][U][G] =  2.000;
 int22_ar[U][A][A][U][G][A][U][G] =  2.200;
 int22_ar[U][A][A][U][G][C][U][G] =  1.200;
 int22_ar[U][A][A][U][G][G][U][G] =  2.000;
 int22_ar[U][A][A][U][G][U][U][G] =  2.000;
 int22_ar[U][A][A][U][U][A][U][G] =  2.900;
 int22_ar[U][A][A][U][U][C][U][G] =  1.900;
 int22_ar[U][A][A][U][U][G][U][G] =  2.700;
 int22_ar[U][A][A][U][U][U][U][G] =  2.000;
 int22_ar[U][A][C][A][A][A][U][G] =  2.300;
 int22_ar[U][A][C][A][A][C][U][G] =  3.400;
 int22_ar[U][A][C][A][A][G][U][G] =  2.000;
 int22_ar[U][A][C][A][A][U][U][G] =  3.100;
 int22_ar[U][A][C][A][C][A][U][G] =  1.900;
 int22_ar[U][A][C][A][C][C][U][G] =  2.300;
 int22_ar[U][A][C][A][C][G][U][G] =  2.000;
 int22_ar[U][A][C][A][C][U][U][G] =  2.000;
 int22_ar[U][A][C][A][G][A][U][G] =  1.300;
 int22_ar[U][A][C][A][G][C][U][G] =  2.700;
 int22_ar[U][A][C][A][G][G][U][G] =  2.000;
 int22_ar[U][A][C][A][G][U][U][G] =  2.400;
 int22_ar[U][A][C][A][U][A][U][G] =  2.000;
 int22_ar[U][A][C][A][U][C][U][G] =  2.000;
 int22_ar[U][A][C][A][U][G][U][G] =  2.000;
 int22_ar[U][A][C][A][U][U][U][G] =  2.000;
 int22_ar[U][A][C][C][A][A][U][G] =  2.300;
 int22_ar[U][A][C][C][A][C][U][G] =  2.800;
 int22_ar[U][A][C][C][A][G][U][G] =  2.000;
 int22_ar[U][A][C][C][A][U][U][G] =  2.500;
 int22_ar[U][A][C][C][C][A][U][G] =  2.300;
 int22_ar[U][A][C][C][C][C][U][G] =  2.800;
 int22_ar[U][A][C][C][C][G][U][G] =  2.000;
 int22_ar[U][A][C][C][C][U][U][G] =  2.500;
 int22_ar[U][A][C][C][G][A][U][G] =  2.000;
 int22_ar[U][A][C][C][G][C][U][G] =  2.000;
 int22_ar[U][A][C][C][G][G][U][G] =  2.000;
 int22_ar[U][A][C][C][G][U][U][G] =  2.000;
 int22_ar[U][A][C][C][U][A][U][G] =  2.300;
 int22_ar[U][A][C][C][U][C][U][G] =  2.800;
 int22_ar[U][A][C][C][U][G][U][G] =  2.000;
 int22_ar[U][A][C][C][U][U][U][G] =  2.500;
 int22_ar[U][A][C][G][A][A][U][G] =  1.300;
 int22_ar[U][A][C][G][A][C][U][G] =  2.700;
 int22_ar[U][A][C][G][A][G][U][G] =  2.000;
 int22_ar[U][A][C][G][A][U][U][G] =  2.400;
 int22_ar[U][A][C][G][C][A][U][G] =  2.000;
 int22_ar[U][A][C][G][C][C][U][G] =  2.000;
 int22_ar[U][A][C][G][C][G][U][G] =  2.000;
 int22_ar[U][A][C][G][C][U][U][G] =  2.000;
 int22_ar[U][A][C][G][G][A][U][G] =  1.700;
 int22_ar[U][A][C][G][G][C][U][G] =  2.700;
 int22_ar[U][A][C][G][G][G][U][G] =  2.000;
 int22_ar[U][A][C][G][G][U][U][G] =  2.400;
 int22_ar[U][A][C][G][U][A][U][G] = -0.500;
 int22_ar[U][A][C][G][U][C][U][G] =  1.000;
 int22_ar[U][A][C][G][U][G][U][G] =  2.000;
 int22_ar[U][A][C][G][U][U][U][G] =  0.700;
 int22_ar[U][A][C][U][A][A][U][G] =  2.000;
 int22_ar[U][A][C][U][A][C][U][G] =  2.000;
 int22_ar[U][A][C][U][A][G][U][G] =  2.000;
 int22_ar[U][A][C][U][A][U][U][G] =  2.000;
 int22_ar[U][A][C][U][C][A][U][G] =  2.000;
 int22_ar[U][A][C][U][C][C][U][G] =  2.500;
 int22_ar[U][A][C][U][C][G][U][G] =  2.000;
 int22_ar[U][A][C][U][C][U][U][G] =  2.200;
 int22_ar[U][A][C][U][G][A][U][G] =  0.800;
 int22_ar[U][A][C][U][G][C][U][G] =  2.200;
 int22_ar[U][A][C][U][G][G][U][G] =  2.000;
 int22_ar[U][A][C][U][G][U][U][G] =  1.900;
 int22_ar[U][A][C][U][U][A][U][G] =  1.500;
 int22_ar[U][A][C][U][U][C][U][G] =  1.900;
 int22_ar[U][A][C][U][U][G][U][G] =  2.000;
 int22_ar[U][A][C][U][U][U][U][G] =  1.600;
 int22_ar[U][A][G][A][A][A][U][G] =  1.700;
 int22_ar[U][A][G][A][A][C][U][G] =  2.000;
 int22_ar[U][A][G][A][A][G][U][G] =  2.100;
 int22_ar[U][A][G][A][A][U][U][G] =  2.200;
 int22_ar[U][A][G][A][C][A][U][G] =  1.300;
 int22_ar[U][A][G][A][C][C][U][G] =  2.000;
 int22_ar[U][A][G][A][C][G][U][G] =  1.700;
 int22_ar[U][A][G][A][C][U][U][G] =  0.800;
 int22_ar[U][A][G][A][G][A][U][G] =  0.700;
 int22_ar[U][A][G][A][G][C][U][G] =  2.000;
 int22_ar[U][A][G][A][G][G][U][G] =  1.100;
 int22_ar[U][A][G][A][G][U][U][G] =  2.000;
 int22_ar[U][A][G][A][U][A][U][G] =  2.000;
 int22_ar[U][A][G][A][U][C][U][G] =  2.000;
 int22_ar[U][A][G][A][U][G][U][G] =  2.000;
 int22_ar[U][A][G][A][U][U][U][G] =  2.000;
 int22_ar[U][A][G][C][A][A][U][G] =  1.700;
 int22_ar[U][A][G][C][A][C][U][G] =  2.000;
 int22_ar[U][A][G][C][A][G][U][G] =  2.100;
 int22_ar[U][A][G][C][A][U][U][G] =  1.200;
 int22_ar[U][A][G][C][C][A][U][G] =  2.700;
 int22_ar[U][A][G][C][C][C][U][G] =  2.000;
 int22_ar[U][A][G][C][C][G][U][G] =  2.700;
 int22_ar[U][A][G][C][C][U][U][G] =  2.200;
 int22_ar[U][A][G][C][G][A][U][G] =  2.000;
 int22_ar[U][A][G][C][G][C][U][G] =  2.000;
 int22_ar[U][A][G][C][G][G][U][G] =  2.000;
 int22_ar[U][A][G][C][G][U][U][G] =  2.000;
 int22_ar[U][A][G][C][U][A][U][G] =  2.700;
 int22_ar[U][A][G][C][U][C][U][G] =  2.000;
 int22_ar[U][A][G][C][U][G][U][G] =  2.700;
 int22_ar[U][A][G][C][U][U][U][G] =  2.200;
 int22_ar[U][A][G][G][A][A][U][G] =  0.700;
 int22_ar[U][A][G][G][A][C][U][G] =  2.000;
 int22_ar[U][A][G][G][A][G][U][G] =  1.100;
 int22_ar[U][A][G][G][A][U][U][G] =  2.000;
 int22_ar[U][A][G][G][C][A][U][G] =  2.000;
 int22_ar[U][A][G][G][C][C][U][G] =  2.000;
 int22_ar[U][A][G][G][C][G][U][G] =  2.000;
 int22_ar[U][A][G][G][C][U][U][G] =  2.000;
 int22_ar[U][A][G][G][G][A][U][G] =  1.100;
 int22_ar[U][A][G][G][G][C][U][G] =  2.000;
 int22_ar[U][A][G][G][G][G][U][G] =  1.500;
 int22_ar[U][A][G][G][G][U][U][G] =  1.600;
 int22_ar[U][A][G][G][U][A][U][G] =  0.700;
 int22_ar[U][A][G][G][U][C][U][G] =  2.000;
 int22_ar[U][A][G][G][U][G][U][G] =  0.300;
 int22_ar[U][A][G][G][U][U][U][G] = -1.600;
 int22_ar[U][A][G][U][A][A][U][G] =  2.000;
 int22_ar[U][A][G][U][A][C][U][G] =  2.000;
 int22_ar[U][A][G][U][A][G][U][G] =  2.000;
 int22_ar[U][A][G][U][A][U][U][G] =  2.000;
 int22_ar[U][A][G][U][C][A][U][G] =  2.400;
 int22_ar[U][A][G][U][C][C][U][G] =  2.000;
 int22_ar[U][A][G][U][C][G][U][G] =  2.400;
 int22_ar[U][A][G][U][C][U][U][G] =  1.900;
 int22_ar[U][A][G][U][G][A][U][G] =  2.000;
 int22_ar[U][A][G][U][G][C][U][G] =  2.000;
 int22_ar[U][A][G][U][G][G][U][G] =  1.600;
 int22_ar[U][A][G][U][G][U][U][G] = -0.300;
 int22_ar[U][A][G][U][U][A][U][G] =  2.700;
 int22_ar[U][A][G][U][U][C][U][G] =  2.000;
 int22_ar[U][A][G][U][U][G][U][G] =  2.300;
 int22_ar[U][A][G][U][U][U][U][G] =  2.200;
 int22_ar[U][A][U][A][A][A][U][G] =  2.000;
 int22_ar[U][A][U][A][A][C][U][G] =  3.400;
 int22_ar[U][A][U][A][A][G][U][G] =  1.000;
 int22_ar[U][A][U][A][A][U][U][G] =  2.900;
 int22_ar[U][A][U][A][C][A][U][G] =  2.000;
 int22_ar[U][A][U][A][C][C][U][G] =  2.300;
 int22_ar[U][A][U][A][C][G][U][G] = -0.500;
 int22_ar[U][A][U][A][C][U][U][G] =  1.500;
 int22_ar[U][A][U][A][G][A][U][G] =  2.000;
 int22_ar[U][A][U][A][G][C][U][G] =  2.700;
 int22_ar[U][A][U][A][G][G][U][G] =  0.700;
 int22_ar[U][A][U][A][G][U][U][G] =  2.700;
 int22_ar[U][A][U][A][U][A][U][G] =  2.000;
 int22_ar[U][A][U][A][U][C][U][G] =  2.000;
 int22_ar[U][A][U][A][U][G][U][G] =  2.000;
 int22_ar[U][A][U][A][U][U][U][G] =  2.000;
 int22_ar[U][A][U][C][A][A][U][G] =  2.000;
 int22_ar[U][A][U][C][A][C][U][G] =  2.800;
 int22_ar[U][A][U][C][A][G][U][G] =  0.000;
 int22_ar[U][A][U][C][A][U][U][G] =  1.900;
 int22_ar[U][A][U][C][C][A][U][G] =  2.000;
 int22_ar[U][A][U][C][C][C][U][G] =  2.800;
 int22_ar[U][A][U][C][C][G][U][G] =  1.000;
 int22_ar[U][A][U][C][C][U][U][G] =  1.900;
 int22_ar[U][A][U][C][G][A][U][G] =  2.000;
 int22_ar[U][A][U][C][G][C][U][G] =  2.000;
 int22_ar[U][A][U][C][G][G][U][G] =  2.000;
 int22_ar[U][A][U][C][G][U][U][G] =  2.000;
 int22_ar[U][A][U][C][U][A][U][G] =  2.000;
 int22_ar[U][A][U][C][U][C][U][G] =  2.800;
 int22_ar[U][A][U][C][U][G][U][G] =  1.000;
 int22_ar[U][A][U][C][U][U][U][G] =  1.900;
 int22_ar[U][A][U][G][A][A][U][G] =  2.000;
 int22_ar[U][A][U][G][A][C][U][G] =  2.700;
 int22_ar[U][A][U][G][A][G][U][G] =  0.700;
 int22_ar[U][A][U][G][A][U][U][G] =  2.700;
 int22_ar[U][A][U][G][C][A][U][G] =  2.000;
 int22_ar[U][A][U][G][C][C][U][G] =  2.000;
 int22_ar[U][A][U][G][C][G][U][G] =  2.000;
 int22_ar[U][A][U][G][C][U][U][G] =  2.000;
 int22_ar[U][A][U][G][G][A][U][G] =  2.000;
 int22_ar[U][A][U][G][G][C][U][G] =  2.700;
 int22_ar[U][A][U][G][G][G][U][G] =  0.300;
 int22_ar[U][A][U][G][G][U][U][G] =  2.300;
 int22_ar[U][A][U][G][U][A][U][G] =  2.000;
 int22_ar[U][A][U][G][U][C][U][G] =  1.000;
 int22_ar[U][A][U][G][U][G][U][G] = -2.900;
 int22_ar[U][A][U][G][U][U][U][G] =  0.900;
 int22_ar[U][A][U][U][A][A][U][G] =  2.000;
 int22_ar[U][A][U][U][A][C][U][G] =  2.000;
 int22_ar[U][A][U][U][A][G][U][G] =  2.000;
 int22_ar[U][A][U][U][A][U][U][G] =  2.000;
 int22_ar[U][A][U][U][C][A][U][G] =  2.000;
 int22_ar[U][A][U][U][C][C][U][G] =  2.500;
 int22_ar[U][A][U][U][C][G][U][G] =  0.700;
 int22_ar[U][A][U][U][C][U][U][G] =  1.600;
 int22_ar[U][A][U][U][G][A][U][G] =  2.000;
 int22_ar[U][A][U][U][G][C][U][G] =  2.200;
 int22_ar[U][A][U][U][G][G][U][G] = -1.600;
 int22_ar[U][A][U][U][G][U][U][G] =  2.200;
 int22_ar[U][A][U][U][U][A][U][G] =  2.000;
 int22_ar[U][A][U][U][U][C][U][G] =  1.900;
 int22_ar[U][A][U][U][U][G][U][G] =  0.900;
 int22_ar[U][A][U][U][U][U][U][G] =  1.100;
 int22_ar[U][G][A][A][A][A][A][U] =  2.800;
 int22_ar[U][G][A][A][A][C][A][U] =  2.800;
 int22_ar[U][G][A][A][A][G][A][U] =  1.700;
 int22_ar[U][G][A][A][A][U][A][U] =  2.000;
 int22_ar[U][G][A][A][C][A][A][U] =  2.500;
 int22_ar[U][G][A][A][C][C][A][U] =  2.500;
 int22_ar[U][G][A][A][C][G][A][U] =  1.500;
 int22_ar[U][G][A][A][C][U][A][U] =  2.000;
 int22_ar[U][G][A][A][G][A][A][U] =  1.500;
 int22_ar[U][G][A][A][G][C][A][U] =  1.500;
 int22_ar[U][G][A][A][G][G][A][U] =  0.500;
 int22_ar[U][G][A][A][G][U][A][U] =  2.000;
 int22_ar[U][G][A][A][U][A][A][U] =  2.000;
 int22_ar[U][G][A][A][U][C][A][U] =  2.000;
 int22_ar[U][G][A][A][U][G][A][U] =  2.000;
 int22_ar[U][G][A][A][U][U][A][U] =  2.000;
 int22_ar[U][G][A][C][A][A][A][U] =  2.600;
 int22_ar[U][G][A][C][A][C][A][U] =  2.600;
 int22_ar[U][G][A][C][A][G][A][U] =  1.600;
 int22_ar[U][G][A][C][A][U][A][U] =  2.000;
 int22_ar[U][G][A][C][C][A][A][U] =  3.100;
 int22_ar[U][G][A][C][C][C][A][U] =  2.500;
 int22_ar[U][G][A][C][C][G][A][U] =  2.400;
 int22_ar[U][G][A][C][C][U][A][U] =  2.000;
 int22_ar[U][G][A][C][G][A][A][U] =  2.000;
 int22_ar[U][G][A][C][G][C][A][U] =  2.000;
 int22_ar[U][G][A][C][G][G][A][U] =  2.000;
 int22_ar[U][G][A][C][G][U][A][U] =  2.000;
 int22_ar[U][G][A][C][U][A][A][U] =  3.100;
 int22_ar[U][G][A][C][U][C][A][U] =  2.500;
 int22_ar[U][G][A][C][U][G][A][U] =  2.400;
 int22_ar[U][G][A][C][U][U][A][U] =  2.000;
 int22_ar[U][G][A][G][A][A][A][U] =  1.500;
 int22_ar[U][G][A][G][A][C][A][U] =  1.500;
 int22_ar[U][G][A][G][A][G][A][U] =  0.500;
 int22_ar[U][G][A][G][A][U][A][U] =  2.000;
 int22_ar[U][G][A][G][C][A][A][U] =  2.000;
 int22_ar[U][G][A][G][C][C][A][U] =  2.000;
 int22_ar[U][G][A][G][C][G][A][U] =  2.000;
 int22_ar[U][G][A][G][C][U][A][U] =  2.000;
 int22_ar[U][G][A][G][G][A][A][U] =  2.100;
 int22_ar[U][G][A][G][G][C][A][U] =  2.100;
 int22_ar[U][G][A][G][G][G][A][U] =  1.000;
 int22_ar[U][G][A][G][G][U][A][U] =  2.000;
 int22_ar[U][G][A][G][U][A][A][U] =  1.300;
 int22_ar[U][G][A][G][U][C][A][U] =  0.300;
 int22_ar[U][G][A][G][U][G][A][U] =  1.100;
 int22_ar[U][G][A][G][U][U][A][U] =  2.000;
 int22_ar[U][G][A][U][A][A][A][U] =  2.000;
 int22_ar[U][G][A][U][A][C][A][U] =  2.000;
 int22_ar[U][G][A][U][A][G][A][U] =  2.000;
 int22_ar[U][G][A][U][A][U][A][U] =  2.000;
 int22_ar[U][G][A][U][C][A][A][U] =  3.100;
 int22_ar[U][G][A][U][C][C][A][U] =  2.500;
 int22_ar[U][G][A][U][C][G][A][U] =  2.400;
 int22_ar[U][G][A][U][C][U][A][U] =  2.000;
 int22_ar[U][G][A][U][G][A][A][U] =  2.300;
 int22_ar[U][G][A][U][G][C][A][U] =  1.300;
 int22_ar[U][G][A][U][G][G][A][U] =  2.100;
 int22_ar[U][G][A][U][G][U][A][U] =  2.000;
 int22_ar[U][G][A][U][U][A][A][U] =  2.700;
 int22_ar[U][G][A][U][U][C][A][U] =  1.700;
 int22_ar[U][G][A][U][U][G][A][U] =  2.400;
 int22_ar[U][G][A][U][U][U][A][U] =  2.000;
 int22_ar[U][G][C][A][A][A][A][U] =  2.300;
 int22_ar[U][G][C][A][A][C][A][U] =  3.400;
 int22_ar[U][G][C][A][A][G][A][U] =  2.000;
 int22_ar[U][G][C][A][A][U][A][U] =  3.100;
 int22_ar[U][G][C][A][C][A][A][U] =  2.100;
 int22_ar[U][G][C][A][C][C][A][U] =  2.500;
 int22_ar[U][G][C][A][C][G][A][U] =  2.000;
 int22_ar[U][G][C][A][C][U][A][U] =  2.200;
 int22_ar[U][G][C][A][G][A][A][U] =  1.100;
 int22_ar[U][G][C][A][G][C][A][U] =  2.500;
 int22_ar[U][G][C][A][G][G][A][U] =  2.000;
 int22_ar[U][G][C][A][G][U][A][U] =  2.200;
 int22_ar[U][G][C][A][U][A][A][U] =  2.000;
 int22_ar[U][G][C][A][U][C][A][U] =  2.000;
 int22_ar[U][G][C][A][U][G][A][U] =  2.000;
 int22_ar[U][G][C][A][U][U][A][U] =  2.000;
 int22_ar[U][G][C][C][A][A][A][U] =  2.200;
 int22_ar[U][G][C][C][A][C][A][U] =  2.600;
 int22_ar[U][G][C][C][A][G][A][U] =  2.000;
 int22_ar[U][G][C][C][A][U][A][U] =  2.300;
 int22_ar[U][G][C][C][C][A][A][U] =  2.000;
 int22_ar[U][G][C][C][C][C][A][U] =  2.500;
 int22_ar[U][G][C][C][C][G][A][U] =  2.000;
 int22_ar[U][G][C][C][C][U][A][U] =  2.200;
 int22_ar[U][G][C][C][G][A][A][U] =  2.000;
 int22_ar[U][G][C][C][G][C][A][U] =  2.000;
 int22_ar[U][G][C][C][G][G][A][U] =  2.000;
 int22_ar[U][G][C][C][G][U][A][U] =  2.000;
 int22_ar[U][G][C][C][U][A][A][U] =  2.000;
 int22_ar[U][G][C][C][U][C][A][U] =  2.500;
 int22_ar[U][G][C][C][U][G][A][U] =  2.000;
 int22_ar[U][G][C][C][U][U][A][U] =  2.200;
 int22_ar[U][G][C][G][A][A][A][U] =  1.100;
 int22_ar[U][G][C][G][A][C][A][U] =  2.500;
 int22_ar[U][G][C][G][A][G][A][U] =  2.000;
 int22_ar[U][G][C][G][A][U][A][U] =  2.200;
 int22_ar[U][G][C][G][C][A][A][U] =  2.000;
 int22_ar[U][G][C][G][C][C][A][U] =  2.000;
 int22_ar[U][G][C][G][C][G][A][U] =  2.000;
 int22_ar[U][G][C][G][C][U][A][U] =  2.000;
 int22_ar[U][G][C][G][G][A][A][U] =  1.600;
 int22_ar[U][G][C][G][G][C][A][U] =  2.700;
 int22_ar[U][G][C][G][G][G][A][U] =  2.000;
 int22_ar[U][G][C][G][G][U][A][U] =  2.400;
 int22_ar[U][G][C][G][U][A][A][U] = -0.100;
 int22_ar[U][G][C][G][U][C][A][U] =  1.300;
 int22_ar[U][G][C][G][U][G][A][U] =  2.000;
 int22_ar[U][G][C][G][U][U][A][U] =  1.000;
 int22_ar[U][G][C][U][A][A][A][U] =  2.000;
 int22_ar[U][G][C][U][A][C][A][U] =  2.000;
 int22_ar[U][G][C][U][A][G][A][U] =  2.000;
 int22_ar[U][G][C][U][A][U][A][U] =  2.000;
 int22_ar[U][G][C][U][C][A][A][U] =  2.000;
 int22_ar[U][G][C][U][C][C][A][U] =  2.500;
 int22_ar[U][G][C][U][C][G][A][U] =  2.000;
 int22_ar[U][G][C][U][C][U][A][U] =  2.200;
 int22_ar[U][G][C][U][G][A][A][U] =  0.900;
 int22_ar[U][G][C][U][G][C][A][U] =  2.300;
 int22_ar[U][G][C][U][G][G][A][U] =  2.000;
 int22_ar[U][G][C][U][G][U][A][U] =  2.000;
 int22_ar[U][G][C][U][U][A][A][U] =  1.200;
 int22_ar[U][G][C][U][U][C][A][U] =  1.700;
 int22_ar[U][G][C][U][U][G][A][U] =  2.000;
 int22_ar[U][G][C][U][U][U][A][U] =  1.400;
 int22_ar[U][G][G][A][A][A][A][U] =  1.700;
 int22_ar[U][G][G][A][A][C][A][U] =  2.000;
 int22_ar[U][G][G][A][A][G][A][U] =  2.100;
 int22_ar[U][G][G][A][A][U][A][U] =  2.200;
 int22_ar[U][G][G][A][C][A][A][U] =  1.500;
 int22_ar[U][G][G][A][C][C][A][U] =  2.000;
 int22_ar[U][G][G][A][C][G][A][U] =  1.900;
 int22_ar[U][G][G][A][C][U][A][U] =  1.000;
 int22_ar[U][G][G][A][G][A][A][U] =  0.500;
 int22_ar[U][G][G][A][G][C][A][U] =  2.000;
 int22_ar[U][G][G][A][G][G][A][U] =  0.900;
 int22_ar[U][G][G][A][G][U][A][U] =  1.800;
 int22_ar[U][G][G][A][U][A][A][U] =  2.000;
 int22_ar[U][G][G][A][U][C][A][U] =  2.000;
 int22_ar[U][G][G][A][U][G][A][U] =  2.000;
 int22_ar[U][G][G][A][U][U][A][U] =  2.000;
 int22_ar[U][G][G][C][A][A][A][U] =  1.600;
 int22_ar[U][G][G][C][A][C][A][U] =  2.000;
 int22_ar[U][G][G][C][A][G][A][U] =  2.000;
 int22_ar[U][G][G][C][A][U][A][U] =  1.100;
 int22_ar[U][G][G][C][C][A][A][U] =  2.400;
 int22_ar[U][G][G][C][C][C][A][U] =  2.000;
 int22_ar[U][G][G][C][C][G][A][U] =  2.400;
 int22_ar[U][G][G][C][C][U][A][U] =  1.900;
 int22_ar[U][G][G][C][G][A][A][U] =  2.000;
 int22_ar[U][G][G][C][G][C][A][U] =  2.000;
 int22_ar[U][G][G][C][G][G][A][U] =  2.000;
 int22_ar[U][G][G][C][G][U][A][U] =  2.000;
 int22_ar[U][G][G][C][U][A][A][U] =  2.400;
 int22_ar[U][G][G][C][U][C][A][U] =  2.000;
 int22_ar[U][G][G][C][U][G][A][U] =  2.400;
 int22_ar[U][G][G][C][U][U][A][U] =  1.900;
 int22_ar[U][G][G][G][A][A][A][U] =  0.500;
 int22_ar[U][G][G][G][A][C][A][U] =  2.000;
 int22_ar[U][G][G][G][A][G][A][U] =  0.900;
 int22_ar[U][G][G][G][A][U][A][U] =  1.800;
 int22_ar[U][G][G][G][C][A][A][U] =  2.000;
 int22_ar[U][G][G][G][C][C][A][U] =  2.000;
 int22_ar[U][G][G][G][C][G][A][U] =  2.000;
 int22_ar[U][G][G][G][C][U][A][U] =  2.000;
 int22_ar[U][G][G][G][G][A][A][U] =  1.000;
 int22_ar[U][G][G][G][G][C][A][U] =  2.000;
 int22_ar[U][G][G][G][G][G][A][U] =  1.400;
 int22_ar[U][G][G][G][G][U][A][U] =  1.500;
 int22_ar[U][G][G][G][U][A][A][U] =  1.100;
 int22_ar[U][G][G][G][U][C][A][U] =  2.000;
 int22_ar[U][G][G][G][U][G][A][U] =  0.700;
 int22_ar[U][G][G][G][U][U][A][U] = -1.200;
 int22_ar[U][G][G][U][A][A][A][U] =  2.000;
 int22_ar[U][G][G][U][A][C][A][U] =  2.000;
 int22_ar[U][G][G][U][A][G][A][U] =  2.000;
 int22_ar[U][G][G][U][A][U][A][U] =  2.000;
 int22_ar[U][G][G][U][C][A][A][U] =  2.400;
 int22_ar[U][G][G][U][C][C][A][U] =  2.000;
 int22_ar[U][G][G][U][C][G][A][U] =  2.400;
 int22_ar[U][G][G][U][C][U][A][U] =  1.900;
 int22_ar[U][G][G][U][G][A][A][U] =  2.100;
 int22_ar[U][G][G][U][G][C][A][U] =  2.000;
 int22_ar[U][G][G][U][G][G][A][U] =  1.700;
 int22_ar[U][G][G][U][G][U][A][U] = -0.200;
 int22_ar[U][G][G][U][U][A][A][U] =  2.400;
 int22_ar[U][G][G][U][U][C][A][U] =  2.000;
 int22_ar[U][G][G][U][U][G][A][U] =  2.000;
 int22_ar[U][G][G][U][U][U][A][U] =  1.900;
 int22_ar[U][G][U][A][A][A][A][U] =  2.000;
 int22_ar[U][G][U][A][A][C][A][U] =  3.400;
 int22_ar[U][G][U][A][A][G][A][U] =  1.000;
 int22_ar[U][G][U][A][A][U][A][U] =  2.900;
 int22_ar[U][G][U][A][C][A][A][U] =  2.000;
 int22_ar[U][G][U][A][C][C][A][U] =  2.500;
 int22_ar[U][G][U][A][C][G][A][U] = -0.300;
 int22_ar[U][G][U][A][C][U][A][U] =  1.700;
 int22_ar[U][G][U][A][G][A][A][U] =  2.000;
 int22_ar[U][G][U][A][G][C][A][U] =  2.500;
 int22_ar[U][G][U][A][G][G][A][U] =  0.500;
 int22_ar[U][G][U][A][G][U][A][U] =  2.500;
 int22_ar[U][G][U][A][U][A][A][U] =  2.000;
 int22_ar[U][G][U][A][U][C][A][U] =  2.000;
 int22_ar[U][G][U][A][U][G][A][U] =  2.000;
 int22_ar[U][G][U][A][U][U][A][U] =  2.000;
 int22_ar[U][G][U][C][A][A][A][U] =  2.000;
 int22_ar[U][G][U][C][A][C][A][U] =  2.600;
 int22_ar[U][G][U][C][A][G][A][U] = -0.200;
 int22_ar[U][G][U][C][A][U][A][U] =  1.800;
 int22_ar[U][G][U][C][C][A][A][U] =  2.000;
 int22_ar[U][G][U][C][C][C][A][U] =  2.500;
 int22_ar[U][G][U][C][C][G][A][U] =  0.700;
 int22_ar[U][G][U][C][C][U][A][U] =  1.600;
 int22_ar[U][G][U][C][G][A][A][U] =  2.000;
 int22_ar[U][G][U][C][G][C][A][U] =  2.000;
 int22_ar[U][G][U][C][G][G][A][U] =  2.000;
 int22_ar[U][G][U][C][G][U][A][U] =  2.000;
 int22_ar[U][G][U][C][U][A][A][U] =  2.000;
 int22_ar[U][G][U][C][U][C][A][U] =  2.500;
 int22_ar[U][G][U][C][U][G][A][U] =  0.700;
 int22_ar[U][G][U][C][U][U][A][U] =  1.600;
 int22_ar[U][G][U][G][A][A][A][U] =  2.000;
 int22_ar[U][G][U][G][A][C][A][U] =  2.500;
 int22_ar[U][G][U][G][A][G][A][U] =  0.500;
 int22_ar[U][G][U][G][A][U][A][U] =  2.500;
 int22_ar[U][G][U][G][C][A][A][U] =  2.000;
 int22_ar[U][G][U][G][C][C][A][U] =  2.000;
 int22_ar[U][G][U][G][C][G][A][U] =  2.000;
 int22_ar[U][G][U][G][C][U][A][U] =  2.000;
 int22_ar[U][G][U][G][G][A][A][U] =  2.000;
 int22_ar[U][G][U][G][G][C][A][U] =  2.700;
 int22_ar[U][G][U][G][G][G][A][U] =  0.300;
 int22_ar[U][G][U][G][G][U][A][U] =  2.200;
 int22_ar[U][G][U][G][U][A][A][U] =  2.000;
 int22_ar[U][G][U][G][U][C][A][U] =  1.300;
 int22_ar[U][G][U][G][U][G][A][U] = -2.500;
 int22_ar[U][G][U][G][U][U][A][U] =  1.300;
 int22_ar[U][G][U][U][A][A][A][U] =  2.000;
 int22_ar[U][G][U][U][A][C][A][U] =  2.000;
 int22_ar[U][G][U][U][A][G][A][U] =  2.000;
 int22_ar[U][G][U][U][A][U][A][U] =  2.000;
 int22_ar[U][G][U][U][C][A][A][U] =  2.000;
 int22_ar[U][G][U][U][C][C][A][U] =  2.500;
 int22_ar[U][G][U][U][C][G][A][U] =  0.700;
 int22_ar[U][G][U][U][C][U][A][U] =  1.600;
 int22_ar[U][G][U][U][G][A][A][U] =  2.000;
 int22_ar[U][G][U][U][G][C][A][U] =  2.300;
 int22_ar[U][G][U][U][G][G][A][U] = -1.500;
 int22_ar[U][G][U][U][G][U][A][U] =  2.300;
 int22_ar[U][G][U][U][U][A][A][U] =  2.000;
 int22_ar[U][G][U][U][U][C][A][U] =  1.700;
 int22_ar[U][G][U][U][U][G][A][U] =  0.700;
 int22_ar[U][G][U][U][U][U][A][U] =  0.800;
 int22_ar[U][G][A][A][A][A][C][G] =  2.000;
 int22_ar[U][G][A][A][A][C][C][G] =  2.000;
 int22_ar[U][G][A][A][A][G][C][G] =  1.000;
 int22_ar[U][G][A][A][A][U][C][G] =  2.000;
 int22_ar[U][G][A][A][C][A][C][G] =  1.900;
 int22_ar[U][G][A][A][C][C][C][G] =  1.900;
 int22_ar[U][G][A][A][C][G][C][G] =  0.900;
 int22_ar[U][G][A][A][C][U][C][G] =  2.000;
 int22_ar[U][G][A][A][G][A][C][G] =  1.000;
 int22_ar[U][G][A][A][G][C][C][G] =  1.000;
 int22_ar[U][G][A][A][G][G][C][G] =  0.000;
 int22_ar[U][G][A][A][G][U][C][G] =  2.000;
 int22_ar[U][G][A][A][U][A][C][G] =  2.000;
 int22_ar[U][G][A][A][U][C][C][G] =  2.000;
 int22_ar[U][G][A][A][U][G][C][G] =  2.000;
 int22_ar[U][G][A][A][U][U][C][G] =  2.000;
 int22_ar[U][G][A][C][A][A][C][G] =  2.400;
 int22_ar[U][G][A][C][A][C][C][G] =  2.400;
 int22_ar[U][G][A][C][A][G][C][G] =  1.300;
 int22_ar[U][G][A][C][A][U][C][G] =  2.000;
 int22_ar[U][G][A][C][C][A][C][G] =  2.800;
 int22_ar[U][G][A][C][C][C][C][G] =  2.200;
 int22_ar[U][G][A][C][C][G][C][G] =  2.200;
 int22_ar[U][G][A][C][C][U][C][G] =  2.000;
 int22_ar[U][G][A][C][G][A][C][G] =  2.000;
 int22_ar[U][G][A][C][G][C][C][G] =  2.000;
 int22_ar[U][G][A][C][G][G][C][G] =  2.000;
 int22_ar[U][G][A][C][G][U][C][G] =  2.000;
 int22_ar[U][G][A][C][U][A][C][G] =  2.700;
 int22_ar[U][G][A][C][U][C][C][G] =  2.100;
 int22_ar[U][G][A][C][U][G][C][G] =  2.000;
 int22_ar[U][G][A][C][U][U][C][G] =  2.000;
 int22_ar[U][G][A][G][A][A][C][G] =  1.000;
 int22_ar[U][G][A][G][A][C][C][G] =  1.000;
 int22_ar[U][G][A][G][A][G][C][G] =  0.000;
 int22_ar[U][G][A][G][A][U][C][G] =  2.000;
 int22_ar[U][G][A][G][C][A][C][G] =  2.000;
 int22_ar[U][G][A][G][C][C][C][G] =  2.000;
 int22_ar[U][G][A][G][C][G][C][G] =  2.000;
 int22_ar[U][G][A][G][C][U][C][G] =  2.000;
 int22_ar[U][G][A][G][G][A][C][G] =  1.800;
 int22_ar[U][G][A][G][G][C][C][G] =  1.800;
 int22_ar[U][G][A][G][G][G][C][G] =  0.700;
 int22_ar[U][G][A][G][G][U][C][G] =  2.000;
 int22_ar[U][G][A][G][U][A][C][G] =  0.300;
 int22_ar[U][G][A][G][U][C][C][G] = -0.700;
 int22_ar[U][G][A][G][U][G][C][G] =  0.100;
 int22_ar[U][G][A][G][U][U][C][G] =  2.000;
 int22_ar[U][G][A][U][A][A][C][G] =  2.000;
 int22_ar[U][G][A][U][A][C][C][G] =  2.000;
 int22_ar[U][G][A][U][A][G][C][G] =  2.000;
 int22_ar[U][G][A][U][A][U][C][G] =  2.000;
 int22_ar[U][G][A][U][C][A][C][G] =  2.700;
 int22_ar[U][G][A][U][C][C][C][G] =  2.100;
 int22_ar[U][G][A][U][C][G][C][G] =  2.000;
 int22_ar[U][G][A][U][C][U][C][G] =  2.000;
 int22_ar[U][G][A][U][G][A][C][G] =  1.800;
 int22_ar[U][G][A][U][G][C][C][G] =  0.800;
 int22_ar[U][G][A][U][G][G][C][G] =  1.600;
 int22_ar[U][G][A][U][G][U][C][G] =  2.000;
 int22_ar[U][G][A][U][U][A][C][G] =  2.200;
 int22_ar[U][G][A][U][U][C][C][G] =  1.200;
 int22_ar[U][G][A][U][U][G][C][G] =  1.900;
 int22_ar[U][G][A][U][U][U][C][G] =  2.000;
 int22_ar[U][G][C][A][A][A][C][G] =  1.600;
 int22_ar[U][G][C][A][A][C][C][G] =  2.600;
 int22_ar[U][G][C][A][A][G][C][G] =  2.000;
 int22_ar[U][G][C][A][A][U][C][G] =  2.300;
 int22_ar[U][G][C][A][C][A][C][G] =  1.500;
 int22_ar[U][G][C][A][C][C][C][G] =  1.900;
 int22_ar[U][G][C][A][C][G][C][G] =  2.000;
 int22_ar[U][G][C][A][C][U][C][G] =  1.600;
 int22_ar[U][G][C][A][G][A][C][G] =  0.600;
 int22_ar[U][G][C][A][G][C][C][G] =  2.000;
 int22_ar[U][G][C][A][G][G][C][G] =  2.000;
 int22_ar[U][G][C][A][G][U][C][G] =  1.700;
 int22_ar[U][G][C][A][U][A][C][G] =  2.000;
 int22_ar[U][G][C][A][U][C][C][G] =  2.000;
 int22_ar[U][G][C][A][U][G][C][G] =  2.000;
 int22_ar[U][G][C][A][U][U][C][G] =  2.000;
 int22_ar[U][G][C][C][A][A][C][G] =  1.900;
 int22_ar[U][G][C][C][A][C][C][G] =  2.400;
 int22_ar[U][G][C][C][A][G][C][G] =  2.000;
 int22_ar[U][G][C][C][A][U][C][G] =  2.100;
 int22_ar[U][G][C][C][C][A][C][G] =  1.800;
 int22_ar[U][G][C][C][C][C][C][G] =  2.200;
 int22_ar[U][G][C][C][C][G][C][G] =  2.000;
 int22_ar[U][G][C][C][C][U][C][G] =  1.900;
 int22_ar[U][G][C][C][G][A][C][G] =  2.000;
 int22_ar[U][G][C][C][G][C][C][G] =  2.000;
 int22_ar[U][G][C][C][G][G][C][G] =  2.000;
 int22_ar[U][G][C][C][G][U][C][G] =  2.000;
 int22_ar[U][G][C][C][U][A][C][G] =  1.600;
 int22_ar[U][G][C][C][U][C][C][G] =  2.100;
 int22_ar[U][G][C][C][U][G][C][G] =  2.000;
 int22_ar[U][G][C][C][U][U][C][G] =  1.800;
 int22_ar[U][G][C][G][A][A][C][G] =  0.600;
 int22_ar[U][G][C][G][A][C][C][G] =  2.000;
 int22_ar[U][G][C][G][A][G][C][G] =  2.000;
 int22_ar[U][G][C][G][A][U][C][G] =  1.700;
 int22_ar[U][G][C][G][C][A][C][G] =  2.000;
 int22_ar[U][G][C][G][C][C][C][G] =  2.000;
 int22_ar[U][G][C][G][C][G][C][G] =  2.000;
 int22_ar[U][G][C][G][C][U][C][G] =  2.000;
 int22_ar[U][G][C][G][G][A][C][G] =  1.300;
 int22_ar[U][G][C][G][G][C][C][G] =  2.400;
 int22_ar[U][G][C][G][G][G][C][G] =  2.000;
 int22_ar[U][G][C][G][G][U][C][G] =  2.100;
 int22_ar[U][G][C][G][U][A][C][G] = -1.100;
 int22_ar[U][G][C][G][U][C][C][G] =  0.300;
 int22_ar[U][G][C][G][U][G][C][G] =  2.000;
 int22_ar[U][G][C][G][U][U][C][G] =  0.000;
 int22_ar[U][G][C][U][A][A][C][G] =  2.000;
 int22_ar[U][G][C][U][A][C][C][G] =  2.000;
 int22_ar[U][G][C][U][A][G][C][G] =  2.000;
 int22_ar[U][G][C][U][A][U][C][G] =  2.000;
 int22_ar[U][G][C][U][C][A][C][G] =  1.600;
 int22_ar[U][G][C][U][C][C][C][G] =  2.100;
 int22_ar[U][G][C][U][C][G][C][G] =  2.000;
 int22_ar[U][G][C][U][C][U][C][G] =  1.800;
 int22_ar[U][G][C][U][G][A][C][G] =  0.400;
 int22_ar[U][G][C][U][G][C][C][G] =  1.800;
 int22_ar[U][G][C][U][G][G][C][G] =  2.000;
 int22_ar[U][G][C][U][G][U][C][G] =  1.500;
 int22_ar[U][G][C][U][U][A][C][G] =  0.700;
 int22_ar[U][G][C][U][U][C][C][G] =  1.200;
 int22_ar[U][G][C][U][U][G][C][G] =  2.000;
 int22_ar[U][G][C][U][U][U][C][G] =  0.900;
 int22_ar[U][G][G][A][A][A][C][G] =  1.000;
 int22_ar[U][G][G][A][A][C][C][G] =  2.000;
 int22_ar[U][G][G][A][A][G][C][G] =  1.400;
 int22_ar[U][G][G][A][A][U][C][G] =  1.500;
 int22_ar[U][G][G][A][C][A][C][G] =  0.900;
 int22_ar[U][G][G][A][C][C][C][G] =  2.000;
 int22_ar[U][G][G][A][C][G][C][G] =  1.300;
 int22_ar[U][G][G][A][C][U][C][G] =  0.400;
 int22_ar[U][G][G][A][G][A][C][G] =  0.000;
 int22_ar[U][G][G][A][G][C][C][G] =  2.000;
 int22_ar[U][G][G][A][G][G][C][G] =  0.400;
 int22_ar[U][G][G][A][G][U][C][G] =  1.300;
 int22_ar[U][G][G][A][U][A][C][G] =  2.000;
 int22_ar[U][G][G][A][U][C][C][G] =  2.000;
 int22_ar[U][G][G][A][U][G][C][G] =  2.000;
 int22_ar[U][G][G][A][U][U][C][G] =  2.000;
 int22_ar[U][G][G][C][A][A][C][G] =  1.300;
 int22_ar[U][G][G][C][A][C][C][G] =  2.000;
 int22_ar[U][G][G][C][A][G][C][G] =  1.700;
 int22_ar[U][G][G][C][A][U][C][G] =  0.800;
 int22_ar[U][G][G][C][C][A][C][G] =  2.200;
 int22_ar[U][G][G][C][C][C][C][G] =  2.000;
 int22_ar[U][G][G][C][C][G][C][G] =  2.200;
 int22_ar[U][G][G][C][C][U][C][G] =  1.700;
 int22_ar[U][G][G][C][G][A][C][G] =  2.000;
 int22_ar[U][G][G][C][G][C][C][G] =  2.000;
 int22_ar[U][G][G][C][G][G][C][G] =  2.000;
 int22_ar[U][G][G][C][G][U][C][G] =  2.000;
 int22_ar[U][G][G][C][U][A][C][G] =  2.000;
 int22_ar[U][G][G][C][U][C][C][G] =  2.000;
 int22_ar[U][G][G][C][U][G][C][G] =  2.000;
 int22_ar[U][G][G][C][U][U][C][G] =  1.500;
 int22_ar[U][G][G][G][A][A][C][G] =  0.000;
 int22_ar[U][G][G][G][A][C][C][G] =  2.000;
 int22_ar[U][G][G][G][A][G][C][G] =  0.400;
 int22_ar[U][G][G][G][A][U][C][G] =  1.300;
 int22_ar[U][G][G][G][C][A][C][G] =  2.000;
 int22_ar[U][G][G][G][C][C][C][G] =  2.000;
 int22_ar[U][G][G][G][C][G][C][G] =  2.000;
 int22_ar[U][G][G][G][C][U][C][G] =  2.000;
 int22_ar[U][G][G][G][G][A][C][G] =  0.700;
 int22_ar[U][G][G][G][G][C][C][G] =  2.000;
 int22_ar[U][G][G][G][G][G][C][G] =  1.100;
 int22_ar[U][G][G][G][G][U][C][G] =  1.200;
 int22_ar[U][G][G][G][U][A][C][G] =  0.100;
 int22_ar[U][G][G][G][U][C][C][G] =  2.000;
 int22_ar[U][G][G][G][U][G][C][G] = -0.300;
 int22_ar[U][G][G][G][U][U][C][G] = -2.200;
 int22_ar[U][G][G][U][A][A][C][G] =  2.000;
 int22_ar[U][G][G][U][A][C][C][G] =  2.000;
 int22_ar[U][G][G][U][A][G][C][G] =  2.000;
 int22_ar[U][G][G][U][A][U][C][G] =  2.000;
 int22_ar[U][G][G][U][C][A][C][G] =  2.000;
 int22_ar[U][G][G][U][C][C][C][G] =  2.000;
 int22_ar[U][G][G][U][C][G][C][G] =  2.000;
 int22_ar[U][G][G][U][C][U][C][G] =  1.500;
 int22_ar[U][G][G][U][G][A][C][G] =  1.600;
 int22_ar[U][G][G][U][G][C][C][G] =  2.000;
 int22_ar[U][G][G][U][G][G][C][G] =  1.200;
 int22_ar[U][G][G][U][G][U][C][G] = -0.700;
 int22_ar[U][G][G][U][U][A][C][G] =  1.900;
 int22_ar[U][G][G][U][U][C][C][G] =  2.000;
 int22_ar[U][G][G][U][U][G][C][G] =  1.500;
 int22_ar[U][G][G][U][U][U][C][G] =  1.500;
 int22_ar[U][G][U][A][A][A][C][G] =  2.000;
 int22_ar[U][G][U][A][A][C][C][G] =  2.600;
 int22_ar[U][G][U][A][A][G][C][G] =  0.200;
 int22_ar[U][G][U][A][A][U][C][G] =  2.200;
 int22_ar[U][G][U][A][C][A][C][G] =  2.000;
 int22_ar[U][G][U][A][C][C][C][G] =  1.900;
 int22_ar[U][G][U][A][C][G][C][G] = -0.900;
 int22_ar[U][G][U][A][C][U][C][G] =  1.100;
 int22_ar[U][G][U][A][G][A][C][G] =  2.000;
 int22_ar[U][G][U][A][G][C][C][G] =  2.000;
 int22_ar[U][G][U][A][G][G][C][G] =  0.000;
 int22_ar[U][G][U][A][G][U][C][G] =  2.000;
 int22_ar[U][G][U][A][U][A][C][G] =  2.000;
 int22_ar[U][G][U][A][U][C][C][G] =  2.000;
 int22_ar[U][G][U][A][U][G][C][G] =  2.000;
 int22_ar[U][G][U][A][U][U][C][G] =  2.000;
 int22_ar[U][G][U][C][A][A][C][G] =  2.000;
 int22_ar[U][G][U][C][A][C][C][G] =  2.400;
 int22_ar[U][G][U][C][A][G][C][G] = -0.400;
 int22_ar[U][G][U][C][A][U][C][G] =  1.500;
 int22_ar[U][G][U][C][C][A][C][G] =  2.000;
 int22_ar[U][G][U][C][C][C][C][G] =  2.200;
 int22_ar[U][G][U][C][C][G][C][G] =  0.400;
 int22_ar[U][G][U][C][C][U][C][G] =  1.400;
 int22_ar[U][G][U][C][G][A][C][G] =  2.000;
 int22_ar[U][G][U][C][G][C][C][G] =  2.000;
 int22_ar[U][G][U][C][G][G][C][G] =  2.000;
 int22_ar[U][G][U][C][G][U][C][G] =  2.000;
 int22_ar[U][G][U][C][U][A][C][G] =  2.000;
 int22_ar[U][G][U][C][U][C][C][G] =  2.100;
 int22_ar[U][G][U][C][U][G][C][G] =  0.300;
 int22_ar[U][G][U][C][U][U][C][G] =  1.200;
 int22_ar[U][G][U][G][A][A][C][G] =  2.000;
 int22_ar[U][G][U][G][A][C][C][G] =  2.000;
 int22_ar[U][G][U][G][A][G][C][G] =  0.000;
 int22_ar[U][G][U][G][A][U][C][G] =  2.000;
 int22_ar[U][G][U][G][C][A][C][G] =  2.000;
 int22_ar[U][G][U][G][C][C][C][G] =  2.000;
 int22_ar[U][G][U][G][C][G][C][G] =  2.000;
 int22_ar[U][G][U][G][C][U][C][G] =  2.000;
 int22_ar[U][G][U][G][G][A][C][G] =  2.000;
 int22_ar[U][G][U][G][G][C][C][G] =  2.400;
 int22_ar[U][G][U][G][G][G][C][G] =  0.000;
 int22_ar[U][G][U][G][G][U][C][G] =  1.900;
 int22_ar[U][G][U][G][U][A][C][G] =  2.000;
 int22_ar[U][G][U][G][U][C][C][G] =  0.300;
 int22_ar[U][G][U][G][U][G][C][G] = -3.500;
 int22_ar[U][G][U][G][U][U][C][G] =  0.300;
 int22_ar[U][G][U][U][A][A][C][G] =  2.000;
 int22_ar[U][G][U][U][A][C][C][G] =  2.000;
 int22_ar[U][G][U][U][A][G][C][G] =  2.000;
 int22_ar[U][G][U][U][A][U][C][G] =  2.000;
 int22_ar[U][G][U][U][C][A][C][G] =  2.000;
 int22_ar[U][G][U][U][C][C][C][G] =  2.100;
 int22_ar[U][G][U][U][C][G][C][G] =  0.300;
 int22_ar[U][G][U][U][C][U][C][G] =  1.200;
 int22_ar[U][G][U][U][G][A][C][G] =  2.000;
 int22_ar[U][G][U][U][G][C][C][G] =  1.800;
 int22_ar[U][G][U][U][G][G][C][G] = -2.000;
 int22_ar[U][G][U][U][G][U][C][G] =  1.800;
 int22_ar[U][G][U][U][U][A][C][G] =  2.000;
 int22_ar[U][G][U][U][U][C][C][G] =  1.200;
 int22_ar[U][G][U][U][U][G][C][G] =  0.200;
 int22_ar[U][G][U][U][U][U][C][G] =  0.300;
 int22_ar[U][G][A][A][A][A][G][C] =  2.100;
 int22_ar[U][G][A][A][A][C][G][C] =  2.100;
 int22_ar[U][G][A][A][A][G][G][C] =  1.100;
 int22_ar[U][G][A][A][A][U][G][C] =  2.000;
 int22_ar[U][G][A][A][C][A][G][C] =  1.900;
 int22_ar[U][G][A][A][C][C][G][C] =  1.900;
 int22_ar[U][G][A][A][C][G][G][C] =  0.800;
 int22_ar[U][G][A][A][C][U][G][C] =  2.000;
 int22_ar[U][G][A][A][G][A][G][C] =  0.100;
 int22_ar[U][G][A][A][G][C][G][C] =  0.100;
 int22_ar[U][G][A][A][G][G][G][C] = -0.900;
 int22_ar[U][G][A][A][G][U][G][C] =  2.000;
 int22_ar[U][G][A][A][U][A][G][C] =  2.000;
 int22_ar[U][G][A][A][U][C][G][C] =  2.000;
 int22_ar[U][G][A][A][U][G][G][C] =  2.000;
 int22_ar[U][G][A][A][U][U][G][C] =  2.000;
 int22_ar[U][G][A][C][A][A][G][C] =  1.800;
 int22_ar[U][G][A][C][A][C][G][C] =  1.800;
 int22_ar[U][G][A][C][A][G][G][C] =  0.800;
 int22_ar[U][G][A][C][A][U][G][C] =  2.000;
 int22_ar[U][G][A][C][C][A][G][C] =  2.500;
 int22_ar[U][G][A][C][C][C][G][C] =  1.900;
 int22_ar[U][G][A][C][C][G][G][C] =  1.800;
 int22_ar[U][G][A][C][C][U][G][C] =  2.000;
 int22_ar[U][G][A][C][G][A][G][C] =  2.000;
 int22_ar[U][G][A][C][G][C][G][C] =  2.000;
 int22_ar[U][G][A][C][G][G][G][C] =  2.000;
 int22_ar[U][G][A][C][G][U][G][C] =  2.000;
 int22_ar[U][G][A][C][U][A][G][C] =  1.500;
 int22_ar[U][G][A][C][U][C][G][C] =  0.900;
 int22_ar[U][G][A][C][U][G][G][C] =  0.900;
 int22_ar[U][G][A][C][U][U][G][C] =  2.000;
 int22_ar[U][G][A][G][A][A][G][C] =  0.700;
 int22_ar[U][G][A][G][A][C][G][C] =  0.700;
 int22_ar[U][G][A][G][A][G][G][C] = -0.300;
 int22_ar[U][G][A][G][A][U][G][C] =  2.000;
 int22_ar[U][G][A][G][C][A][G][C] =  2.000;
 int22_ar[U][G][A][G][C][C][G][C] =  2.000;
 int22_ar[U][G][A][G][C][G][G][C] =  2.000;
 int22_ar[U][G][A][G][C][U][G][C] =  2.000;
 int22_ar[U][G][A][G][G][A][G][C] =  1.800;
 int22_ar[U][G][A][G][G][C][G][C] =  1.800;
 int22_ar[U][G][A][G][G][G][G][C] =  0.700;
 int22_ar[U][G][A][G][G][U][G][C] =  2.000;
 int22_ar[U][G][A][G][U][A][G][C] =  0.000;
 int22_ar[U][G][A][G][U][C][G][C] = -1.000;
 int22_ar[U][G][A][G][U][G][G][C] = -0.300;
 int22_ar[U][G][A][G][U][U][G][C] =  2.000;
 int22_ar[U][G][A][U][A][A][G][C] =  2.000;
 int22_ar[U][G][A][U][A][C][G][C] =  2.000;
 int22_ar[U][G][A][U][A][G][G][C] =  2.000;
 int22_ar[U][G][A][U][A][U][G][C] =  2.000;
 int22_ar[U][G][A][U][C][A][G][C] =  2.500;
 int22_ar[U][G][A][U][C][C][G][C] =  1.900;
 int22_ar[U][G][A][U][C][G][G][C] =  1.900;
 int22_ar[U][G][A][U][C][U][G][C] =  2.000;
 int22_ar[U][G][A][U][G][A][G][C] =  0.400;
 int22_ar[U][G][A][U][G][C][G][C] = -0.600;
 int22_ar[U][G][A][U][G][G][G][C] =  0.100;
 int22_ar[U][G][A][U][G][U][G][C] =  2.000;
 int22_ar[U][G][A][U][U][A][G][C] =  2.100;
 int22_ar[U][G][A][U][U][C][G][C] =  1.100;
 int22_ar[U][G][A][U][U][G][G][C] =  1.900;
 int22_ar[U][G][A][U][U][U][G][C] =  2.000;
 int22_ar[U][G][C][A][A][A][G][C] =  1.700;
 int22_ar[U][G][C][A][A][C][G][C] =  2.700;
 int22_ar[U][G][C][A][A][G][G][C] =  2.000;
 int22_ar[U][G][C][A][A][U][G][C] =  2.400;
 int22_ar[U][G][C][A][C][A][G][C] =  1.400;
 int22_ar[U][G][C][A][C][C][G][C] =  1.900;
 int22_ar[U][G][C][A][C][G][G][C] =  2.000;
 int22_ar[U][G][C][A][C][U][G][C] =  1.600;
 int22_ar[U][G][C][A][G][A][G][C] = -0.300;
 int22_ar[U][G][C][A][G][C][G][C] =  1.100;
 int22_ar[U][G][C][A][G][G][G][C] =  2.000;
 int22_ar[U][G][C][A][G][U][G][C] =  0.800;
 int22_ar[U][G][C][A][U][A][G][C] =  2.000;
 int22_ar[U][G][C][A][U][C][G][C] =  2.000;
 int22_ar[U][G][C][A][U][G][G][C] =  2.000;
 int22_ar[U][G][C][A][U][U][G][C] =  2.000;
 int22_ar[U][G][C][C][A][A][G][C] =  1.400;
 int22_ar[U][G][C][C][A][C][G][C] =  1.800;
 int22_ar[U][G][C][C][A][G][G][C] =  2.000;
 int22_ar[U][G][C][C][A][U][G][C] =  1.500;
 int22_ar[U][G][C][C][C][A][G][C] =  1.400;
 int22_ar[U][G][C][C][C][C][G][C] =  1.900;
 int22_ar[U][G][C][C][C][G][G][C] =  2.000;
 int22_ar[U][G][C][C][C][U][G][C] =  1.600;
 int22_ar[U][G][C][C][G][A][G][C] =  2.000;
 int22_ar[U][G][C][C][G][C][G][C] =  2.000;
 int22_ar[U][G][C][C][G][G][G][C] =  2.000;
 int22_ar[U][G][C][C][G][U][G][C] =  2.000;
 int22_ar[U][G][C][C][U][A][G][C] =  0.400;
 int22_ar[U][G][C][C][U][C][G][C] =  0.900;
 int22_ar[U][G][C][C][U][G][G][C] =  2.000;
 int22_ar[U][G][C][C][U][U][G][C] =  0.600;
 int22_ar[U][G][C][G][A][A][G][C] =  0.300;
 int22_ar[U][G][C][G][A][C][G][C] =  1.700;
 int22_ar[U][G][C][G][A][G][G][C] =  2.000;
 int22_ar[U][G][C][G][A][U][G][C] =  1.400;
 int22_ar[U][G][C][G][C][A][G][C] =  2.000;
 int22_ar[U][G][C][G][C][C][G][C] =  2.000;
 int22_ar[U][G][C][G][C][G][G][C] =  2.000;
 int22_ar[U][G][C][G][C][U][G][C] =  2.000;
 int22_ar[U][G][C][G][G][A][G][C] =  1.300;
 int22_ar[U][G][C][G][G][C][G][C] =  2.400;
 int22_ar[U][G][C][G][G][G][G][C] =  2.000;
 int22_ar[U][G][C][G][G][U][G][C] =  2.100;
 int22_ar[U][G][C][G][U][A][G][C] = -1.500;
 int22_ar[U][G][C][G][U][C][G][C] =  0.000;
 int22_ar[U][G][C][G][U][G][G][C] =  2.000;
 int22_ar[U][G][C][G][U][U][G][C] = -0.300;
 int22_ar[U][G][C][U][A][A][G][C] =  2.000;
 int22_ar[U][G][C][U][A][C][G][C] =  2.000;
 int22_ar[U][G][C][U][A][G][G][C] =  2.000;
 int22_ar[U][G][C][U][A][U][G][C] =  2.000;
 int22_ar[U][G][C][U][C][A][G][C] =  1.500;
 int22_ar[U][G][C][U][C][C][G][C] =  1.900;
 int22_ar[U][G][C][U][C][G][G][C] =  2.000;
 int22_ar[U][G][C][U][C][U][G][C] =  1.600;
 int22_ar[U][G][C][U][G][A][G][C] = -1.100;
 int22_ar[U][G][C][U][G][C][G][C] =  0.400;
 int22_ar[U][G][C][U][G][G][G][C] =  2.000;
 int22_ar[U][G][C][U][G][U][G][C] =  0.100;
 int22_ar[U][G][C][U][U][A][G][C] =  0.700;
 int22_ar[U][G][C][U][U][C][G][C] =  1.100;
 int22_ar[U][G][C][U][U][G][G][C] =  2.000;
 int22_ar[U][G][C][U][U][U][G][C] =  0.800;
 int22_ar[U][G][G][A][A][A][G][C] =  1.100;
 int22_ar[U][G][G][A][A][C][G][C] =  2.000;
 int22_ar[U][G][G][A][A][G][G][C] =  1.500;
 int22_ar[U][G][G][A][A][U][G][C] =  1.600;
 int22_ar[U][G][G][A][C][A][G][C] =  0.800;
 int22_ar[U][G][G][A][C][C][G][C] =  2.000;
 int22_ar[U][G][G][A][C][G][G][C] =  1.200;
 int22_ar[U][G][G][A][C][U][G][C] =  0.300;
 int22_ar[U][G][G][A][G][A][G][C] = -0.900;
 int22_ar[U][G][G][A][G][C][G][C] =  2.000;
 int22_ar[U][G][G][A][G][G][G][C] = -0.500;
 int22_ar[U][G][G][A][G][U][G][C] =  0.400;
 int22_ar[U][G][G][A][U][A][G][C] =  2.000;
 int22_ar[U][G][G][A][U][C][G][C] =  2.000;
 int22_ar[U][G][G][A][U][G][G][C] =  2.000;
 int22_ar[U][G][G][A][U][U][G][C] =  2.000;
 int22_ar[U][G][G][C][A][A][G][C] =  0.800;
 int22_ar[U][G][G][C][A][C][G][C] =  2.000;
 int22_ar[U][G][G][C][A][G][G][C] =  1.200;
 int22_ar[U][G][G][C][A][U][G][C] =  0.300;
 int22_ar[U][G][G][C][C][A][G][C] =  1.800;
 int22_ar[U][G][G][C][C][C][G][C] =  2.000;
 int22_ar[U][G][G][C][C][G][G][C] =  1.800;
 int22_ar[U][G][G][C][C][U][G][C] =  1.300;
 int22_ar[U][G][G][C][G][A][G][C] =  2.000;
 int22_ar[U][G][G][C][G][C][G][C] =  2.000;
 int22_ar[U][G][G][C][G][G][G][C] =  2.000;
 int22_ar[U][G][G][C][G][U][G][C] =  2.000;
 int22_ar[U][G][G][C][U][A][G][C] =  0.900;
 int22_ar[U][G][G][C][U][C][G][C] =  2.000;
 int22_ar[U][G][G][C][U][G][G][C] =  0.800;
 int22_ar[U][G][G][C][U][U][G][C] =  0.400;
 int22_ar[U][G][G][G][A][A][G][C] = -0.300;
 int22_ar[U][G][G][G][A][C][G][C] =  2.000;
 int22_ar[U][G][G][G][A][G][G][C] =  0.100;
 int22_ar[U][G][G][G][A][U][G][C] =  1.000;
 int22_ar[U][G][G][G][C][A][G][C] =  2.000;
 int22_ar[U][G][G][G][C][C][G][C] =  2.000;
 int22_ar[U][G][G][G][C][G][G][C] =  2.000;
 int22_ar[U][G][G][G][C][U][G][C] =  2.000;
 int22_ar[U][G][G][G][G][A][G][C] =  0.700;
 int22_ar[U][G][G][G][G][C][G][C] =  2.000;
 int22_ar[U][G][G][G][G][G][G][C] =  1.100;
 int22_ar[U][G][G][G][G][U][G][C] =  1.200;
 int22_ar[U][G][G][G][U][A][G][C] = -0.300;
 int22_ar[U][G][G][G][U][C][G][C] =  2.000;
 int22_ar[U][G][G][G][U][G][G][C] = -0.700;
 int22_ar[U][G][G][G][U][U][G][C] = -2.600;
 int22_ar[U][G][G][U][A][A][G][C] =  2.000;
 int22_ar[U][G][G][U][A][C][G][C] =  2.000;
 int22_ar[U][G][G][U][A][G][G][C] =  2.000;
 int22_ar[U][G][G][U][A][U][G][C] =  2.000;
 int22_ar[U][G][G][U][C][A][G][C] =  1.900;
 int22_ar[U][G][G][U][C][C][G][C] =  2.000;
 int22_ar[U][G][G][U][C][G][G][C] =  1.900;
 int22_ar[U][G][G][U][C][U][G][C] =  1.400;
 int22_ar[U][G][G][U][G][A][G][C] =  0.100;
 int22_ar[U][G][G][U][G][C][G][C] =  2.000;
 int22_ar[U][G][G][U][G][G][G][C] = -0.300;
 int22_ar[U][G][G][U][G][U][G][C] = -2.200;
 int22_ar[U][G][G][U][U][A][G][C] =  1.900;
 int22_ar[U][G][G][U][U][C][G][C] =  2.000;
 int22_ar[U][G][G][U][U][G][G][C] =  1.500;
 int22_ar[U][G][G][U][U][U][G][C] =  1.400;
 int22_ar[U][G][U][A][A][A][G][C] =  2.000;
 int22_ar[U][G][U][A][A][C][G][C] =  2.700;
 int22_ar[U][G][U][A][A][G][G][C] =  0.300;
 int22_ar[U][G][U][A][A][U][G][C] =  2.300;
 int22_ar[U][G][U][A][C][A][G][C] =  2.000;
 int22_ar[U][G][U][A][C][C][G][C] =  1.900;
 int22_ar[U][G][U][A][C][G][G][C] = -0.900;
 int22_ar[U][G][U][A][C][U][G][C] =  1.000;
 int22_ar[U][G][U][A][G][A][G][C] =  2.000;
 int22_ar[U][G][U][A][G][C][G][C] =  1.100;
 int22_ar[U][G][U][A][G][G][G][C] = -0.900;
 int22_ar[U][G][U][A][G][U][G][C] =  1.100;
 int22_ar[U][G][U][A][U][A][G][C] =  2.000;
 int22_ar[U][G][U][A][U][C][G][C] =  2.000;
 int22_ar[U][G][U][A][U][G][G][C] =  2.000;
 int22_ar[U][G][U][A][U][U][G][C] =  2.000;
 int22_ar[U][G][U][C][A][A][G][C] =  2.000;
 int22_ar[U][G][U][C][A][C][G][C] =  1.800;
 int22_ar[U][G][U][C][A][G][G][C] = -1.000;
 int22_ar[U][G][U][C][A][U][G][C] =  1.000;
 int22_ar[U][G][U][C][C][A][G][C] =  2.000;
 int22_ar[U][G][U][C][C][C][G][C] =  1.900;
 int22_ar[U][G][U][C][C][G][G][C] =  0.100;
 int22_ar[U][G][U][C][C][U][G][C] =  1.000;
 int22_ar[U][G][U][C][G][A][G][C] =  2.000;
 int22_ar[U][G][U][C][G][C][G][C] =  2.000;
 int22_ar[U][G][U][C][G][G][G][C] =  2.000;
 int22_ar[U][G][U][C][G][U][G][C] =  2.000;
 int22_ar[U][G][U][C][U][A][G][C] =  2.000;
 int22_ar[U][G][U][C][U][C][G][C] =  0.900;
 int22_ar[U][G][U][C][U][G][G][C] = -0.900;
 int22_ar[U][G][U][C][U][U][G][C] =  0.000;
 int22_ar[U][G][U][G][A][A][G][C] =  2.000;
 int22_ar[U][G][U][G][A][C][G][C] =  1.700;
 int22_ar[U][G][U][G][A][G][G][C] = -0.300;
 int22_ar[U][G][U][G][A][U][G][C] =  1.700;
 int22_ar[U][G][U][G][C][A][G][C] =  2.000;
 int22_ar[U][G][U][G][C][C][G][C] =  2.000;
 int22_ar[U][G][U][G][C][G][G][C] =  2.000;
 int22_ar[U][G][U][G][C][U][G][C] =  2.000;
 int22_ar[U][G][U][G][G][A][G][C] =  2.000;
 int22_ar[U][G][U][G][G][C][G][C] =  2.400;
 int22_ar[U][G][U][G][G][G][G][C] =  0.000;
 int22_ar[U][G][U][G][G][U][G][C] =  1.900;
 int22_ar[U][G][U][G][U][A][G][C] =  2.000;
 int22_ar[U][G][U][G][U][C][G][C] =  0.000;
 int22_ar[U][G][U][G][U][G][G][C] = -3.900;
 int22_ar[U][G][U][G][U][U][G][C] = -0.100;
 int22_ar[U][G][U][U][A][A][G][C] =  2.000;
 int22_ar[U][G][U][U][A][C][G][C] =  2.000;
 int22_ar[U][G][U][U][A][G][G][C] =  2.000;
 int22_ar[U][G][U][U][A][U][G][C] =  2.000;
 int22_ar[U][G][U][U][C][A][G][C] =  2.000;
 int22_ar[U][G][U][U][C][C][G][C] =  1.900;
 int22_ar[U][G][U][U][C][G][G][C] =  0.100;
 int22_ar[U][G][U][U][C][U][G][C] =  1.100;
 int22_ar[U][G][U][U][G][A][G][C] =  2.000;
 int22_ar[U][G][U][U][G][C][G][C] =  0.400;
 int22_ar[U][G][U][U][G][G][G][C] = -3.500;
 int22_ar[U][G][U][U][G][U][G][C] =  0.300;
 int22_ar[U][G][U][U][U][A][G][C] =  2.000;
 int22_ar[U][G][U][U][U][C][G][C] =  1.100;
 int22_ar[U][G][U][U][U][G][G][C] =  0.100;
 int22_ar[U][G][U][U][U][U][G][C] =  0.300;
 int22_ar[U][G][A][A][A][A][G][U] =  2.800;
 int22_ar[U][G][A][A][A][C][G][U] =  2.800;
 int22_ar[U][G][A][A][A][G][G][U] =  1.700;
 int22_ar[U][G][A][A][A][U][G][U] =  2.000;
 int22_ar[U][G][A][A][C][A][G][U] =  2.500;
 int22_ar[U][G][A][A][C][C][G][U] =  2.500;
 int22_ar[U][G][A][A][C][G][G][U] =  1.500;
 int22_ar[U][G][A][A][C][U][G][U] =  2.000;
 int22_ar[U][G][A][A][G][A][G][U] =  1.500;
 int22_ar[U][G][A][A][G][C][G][U] =  1.500;
 int22_ar[U][G][A][A][G][G][G][U] =  0.500;
 int22_ar[U][G][A][A][G][U][G][U] =  2.000;
 int22_ar[U][G][A][A][U][A][G][U] =  2.000;
 int22_ar[U][G][A][A][U][C][G][U] =  2.000;
 int22_ar[U][G][A][A][U][G][G][U] =  2.000;
 int22_ar[U][G][A][A][U][U][G][U] =  2.000;
 int22_ar[U][G][A][C][A][A][G][U] =  2.600;
 int22_ar[U][G][A][C][A][C][G][U] =  2.600;
 int22_ar[U][G][A][C][A][G][G][U] =  1.600;
 int22_ar[U][G][A][C][A][U][G][U] =  2.000;
 int22_ar[U][G][A][C][C][A][G][U] =  3.100;
 int22_ar[U][G][A][C][C][C][G][U] =  2.500;
 int22_ar[U][G][A][C][C][G][G][U] =  2.400;
 int22_ar[U][G][A][C][C][U][G][U] =  2.000;
 int22_ar[U][G][A][C][G][A][G][U] =  2.000;
 int22_ar[U][G][A][C][G][C][G][U] =  2.000;
 int22_ar[U][G][A][C][G][G][G][U] =  2.000;
 int22_ar[U][G][A][C][G][U][G][U] =  2.000;
 int22_ar[U][G][A][C][U][A][G][U] =  3.100;
 int22_ar[U][G][A][C][U][C][G][U] =  2.500;
 int22_ar[U][G][A][C][U][G][G][U] =  2.400;
 int22_ar[U][G][A][C][U][U][G][U] =  2.000;
 int22_ar[U][G][A][G][A][A][G][U] =  1.500;
 int22_ar[U][G][A][G][A][C][G][U] =  1.500;
 int22_ar[U][G][A][G][A][G][G][U] =  0.500;
 int22_ar[U][G][A][G][A][U][G][U] =  2.000;
 int22_ar[U][G][A][G][C][A][G][U] =  2.000;
 int22_ar[U][G][A][G][C][C][G][U] =  2.000;
 int22_ar[U][G][A][G][C][G][G][U] =  2.000;
 int22_ar[U][G][A][G][C][U][G][U] =  2.000;
 int22_ar[U][G][A][G][G][A][G][U] =  2.100;
 int22_ar[U][G][A][G][G][C][G][U] =  2.100;
 int22_ar[U][G][A][G][G][G][G][U] =  1.000;
 int22_ar[U][G][A][G][G][U][G][U] =  2.000;
 int22_ar[U][G][A][G][U][A][G][U] =  1.300;
 int22_ar[U][G][A][G][U][C][G][U] =  0.300;
 int22_ar[U][G][A][G][U][G][G][U] =  1.100;
 int22_ar[U][G][A][G][U][U][G][U] =  2.000;
 int22_ar[U][G][A][U][A][A][G][U] =  2.000;
 int22_ar[U][G][A][U][A][C][G][U] =  2.000;
 int22_ar[U][G][A][U][A][G][G][U] =  2.000;
 int22_ar[U][G][A][U][A][U][G][U] =  2.000;
 int22_ar[U][G][A][U][C][A][G][U] =  3.100;
 int22_ar[U][G][A][U][C][C][G][U] =  2.500;
 int22_ar[U][G][A][U][C][G][G][U] =  2.400;
 int22_ar[U][G][A][U][C][U][G][U] =  2.000;
 int22_ar[U][G][A][U][G][A][G][U] =  2.300;
 int22_ar[U][G][A][U][G][C][G][U] =  1.300;
 int22_ar[U][G][A][U][G][G][G][U] =  2.100;
 int22_ar[U][G][A][U][G][U][G][U] =  2.000;
 int22_ar[U][G][A][U][U][A][G][U] =  2.700;
 int22_ar[U][G][A][U][U][C][G][U] =  1.700;
 int22_ar[U][G][A][U][U][G][G][U] =  2.400;
 int22_ar[U][G][A][U][U][U][G][U] =  2.000;
 int22_ar[U][G][C][A][A][A][G][U] =  2.300;
 int22_ar[U][G][C][A][A][C][G][U] =  3.400;
 int22_ar[U][G][C][A][A][G][G][U] =  2.000;
 int22_ar[U][G][C][A][A][U][G][U] =  3.100;
 int22_ar[U][G][C][A][C][A][G][U] =  2.100;
 int22_ar[U][G][C][A][C][C][G][U] =  2.500;
 int22_ar[U][G][C][A][C][G][G][U] =  2.000;
 int22_ar[U][G][C][A][C][U][G][U] =  2.200;
 int22_ar[U][G][C][A][G][A][G][U] =  1.100;
 int22_ar[U][G][C][A][G][C][G][U] =  2.500;
 int22_ar[U][G][C][A][G][G][G][U] =  2.000;
 int22_ar[U][G][C][A][G][U][G][U] =  2.200;
 int22_ar[U][G][C][A][U][A][G][U] =  2.000;
 int22_ar[U][G][C][A][U][C][G][U] =  2.000;
 int22_ar[U][G][C][A][U][G][G][U] =  2.000;
 int22_ar[U][G][C][A][U][U][G][U] =  2.000;
 int22_ar[U][G][C][C][A][A][G][U] =  2.200;
 int22_ar[U][G][C][C][A][C][G][U] =  2.600;
 int22_ar[U][G][C][C][A][G][G][U] =  2.000;
 int22_ar[U][G][C][C][A][U][G][U] =  2.300;
 int22_ar[U][G][C][C][C][A][G][U] =  2.000;
 int22_ar[U][G][C][C][C][C][G][U] =  2.500;
 int22_ar[U][G][C][C][C][G][G][U] =  2.000;
 int22_ar[U][G][C][C][C][U][G][U] =  2.200;
 int22_ar[U][G][C][C][G][A][G][U] =  2.000;
 int22_ar[U][G][C][C][G][C][G][U] =  2.000;
 int22_ar[U][G][C][C][G][G][G][U] =  2.000;
 int22_ar[U][G][C][C][G][U][G][U] =  2.000;
 int22_ar[U][G][C][C][U][A][G][U] =  2.000;
 int22_ar[U][G][C][C][U][C][G][U] =  2.500;
 int22_ar[U][G][C][C][U][G][G][U] =  2.000;
 int22_ar[U][G][C][C][U][U][G][U] =  2.200;
 int22_ar[U][G][C][G][A][A][G][U] =  1.100;
 int22_ar[U][G][C][G][A][C][G][U] =  2.500;
 int22_ar[U][G][C][G][A][G][G][U] =  2.000;
 int22_ar[U][G][C][G][A][U][G][U] =  2.200;
 int22_ar[U][G][C][G][C][A][G][U] =  2.000;
 int22_ar[U][G][C][G][C][C][G][U] =  2.000;
 int22_ar[U][G][C][G][C][G][G][U] =  2.000;
 int22_ar[U][G][C][G][C][U][G][U] =  2.000;
 int22_ar[U][G][C][G][G][A][G][U] =  1.600;
 int22_ar[U][G][C][G][G][C][G][U] =  2.700;
 int22_ar[U][G][C][G][G][G][G][U] =  2.000;
 int22_ar[U][G][C][G][G][U][G][U] =  2.400;
 int22_ar[U][G][C][G][U][A][G][U] = -0.100;
 int22_ar[U][G][C][G][U][C][G][U] =  1.300;
 int22_ar[U][G][C][G][U][G][G][U] =  2.000;
 int22_ar[U][G][C][G][U][U][G][U] =  1.000;
 int22_ar[U][G][C][U][A][A][G][U] =  2.000;
 int22_ar[U][G][C][U][A][C][G][U] =  2.000;
 int22_ar[U][G][C][U][A][G][G][U] =  2.000;
 int22_ar[U][G][C][U][A][U][G][U] =  2.000;
 int22_ar[U][G][C][U][C][A][G][U] =  2.000;
 int22_ar[U][G][C][U][C][C][G][U] =  2.500;
 int22_ar[U][G][C][U][C][G][G][U] =  2.000;
 int22_ar[U][G][C][U][C][U][G][U] =  2.200;
 int22_ar[U][G][C][U][G][A][G][U] =  0.900;
 int22_ar[U][G][C][U][G][C][G][U] =  2.300;
 int22_ar[U][G][C][U][G][G][G][U] =  2.000;
 int22_ar[U][G][C][U][G][U][G][U] =  2.000;
 int22_ar[U][G][C][U][U][A][G][U] =  1.200;
 int22_ar[U][G][C][U][U][C][G][U] =  1.700;
 int22_ar[U][G][C][U][U][G][G][U] =  2.000;
 int22_ar[U][G][C][U][U][U][G][U] =  1.400;
 int22_ar[U][G][G][A][A][A][G][U] =  1.700;
 int22_ar[U][G][G][A][A][C][G][U] =  2.000;
 int22_ar[U][G][G][A][A][G][G][U] =  2.100;
 int22_ar[U][G][G][A][A][U][G][U] =  2.200;
 int22_ar[U][G][G][A][C][A][G][U] =  1.500;
 int22_ar[U][G][G][A][C][C][G][U] =  2.000;
 int22_ar[U][G][G][A][C][G][G][U] =  1.900;
 int22_ar[U][G][G][A][C][U][G][U] =  1.000;
 int22_ar[U][G][G][A][G][A][G][U] =  0.500;
 int22_ar[U][G][G][A][G][C][G][U] =  2.000;
 int22_ar[U][G][G][A][G][G][G][U] =  0.900;
 int22_ar[U][G][G][A][G][U][G][U] =  1.800;
 int22_ar[U][G][G][A][U][A][G][U] =  2.000;
 int22_ar[U][G][G][A][U][C][G][U] =  2.000;
 int22_ar[U][G][G][A][U][G][G][U] =  2.000;
 int22_ar[U][G][G][A][U][U][G][U] =  2.000;
 int22_ar[U][G][G][C][A][A][G][U] =  1.600;
 int22_ar[U][G][G][C][A][C][G][U] =  2.000;
 int22_ar[U][G][G][C][A][G][G][U] =  2.000;
 int22_ar[U][G][G][C][A][U][G][U] =  1.100;
 int22_ar[U][G][G][C][C][A][G][U] =  2.400;
 int22_ar[U][G][G][C][C][C][G][U] =  2.000;
 int22_ar[U][G][G][C][C][G][G][U] =  2.400;
 int22_ar[U][G][G][C][C][U][G][U] =  1.900;
 int22_ar[U][G][G][C][G][A][G][U] =  2.000;
 int22_ar[U][G][G][C][G][C][G][U] =  2.000;
 int22_ar[U][G][G][C][G][G][G][U] =  2.000;
 int22_ar[U][G][G][C][G][U][G][U] =  2.000;
 int22_ar[U][G][G][C][U][A][G][U] =  2.400;
 int22_ar[U][G][G][C][U][C][G][U] =  2.000;
 int22_ar[U][G][G][C][U][G][G][U] =  2.400;
 int22_ar[U][G][G][C][U][U][G][U] =  1.900;
 int22_ar[U][G][G][G][A][A][G][U] =  0.500;
 int22_ar[U][G][G][G][A][C][G][U] =  2.000;
 int22_ar[U][G][G][G][A][G][G][U] =  0.900;
 int22_ar[U][G][G][G][A][U][G][U] =  1.800;
 int22_ar[U][G][G][G][C][A][G][U] =  2.000;
 int22_ar[U][G][G][G][C][C][G][U] =  2.000;
 int22_ar[U][G][G][G][C][G][G][U] =  2.000;
 int22_ar[U][G][G][G][C][U][G][U] =  2.000;
 int22_ar[U][G][G][G][G][A][G][U] =  1.000;
 int22_ar[U][G][G][G][G][C][G][U] =  2.000;
 int22_ar[U][G][G][G][G][G][G][U] =  1.400;
 int22_ar[U][G][G][G][G][U][G][U] =  1.500;
 int22_ar[U][G][G][G][U][A][G][U] =  1.100;
 int22_ar[U][G][G][G][U][C][G][U] =  2.000;
 int22_ar[U][G][G][G][U][G][G][U] =  0.700;
 int22_ar[U][G][G][G][U][U][G][U] = -1.200;
 int22_ar[U][G][G][U][A][A][G][U] =  2.000;
 int22_ar[U][G][G][U][A][C][G][U] =  2.000;
 int22_ar[U][G][G][U][A][G][G][U] =  2.000;
 int22_ar[U][G][G][U][A][U][G][U] =  2.000;
 int22_ar[U][G][G][U][C][A][G][U] =  2.400;
 int22_ar[U][G][G][U][C][C][G][U] =  2.000;
 int22_ar[U][G][G][U][C][G][G][U] =  2.400;
 int22_ar[U][G][G][U][C][U][G][U] =  1.900;
 int22_ar[U][G][G][U][G][A][G][U] =  2.100;
 int22_ar[U][G][G][U][G][C][G][U] =  2.000;
 int22_ar[U][G][G][U][G][G][G][U] =  1.700;
 int22_ar[U][G][G][U][G][U][G][U] = -0.200;
 int22_ar[U][G][G][U][U][A][G][U] =  2.400;
 int22_ar[U][G][G][U][U][C][G][U] =  2.000;
 int22_ar[U][G][G][U][U][G][G][U] =  2.000;
 int22_ar[U][G][G][U][U][U][G][U] =  1.900;
 int22_ar[U][G][U][A][A][A][G][U] =  2.000;
 int22_ar[U][G][U][A][A][C][G][U] =  3.400;
 int22_ar[U][G][U][A][A][G][G][U] =  1.000;
 int22_ar[U][G][U][A][A][U][G][U] =  2.900;
 int22_ar[U][G][U][A][C][A][G][U] =  2.000;
 int22_ar[U][G][U][A][C][C][G][U] =  2.500;
 int22_ar[U][G][U][A][C][G][G][U] = -0.300;
 int22_ar[U][G][U][A][C][U][G][U] =  1.700;
 int22_ar[U][G][U][A][G][A][G][U] =  2.000;
 int22_ar[U][G][U][A][G][C][G][U] =  2.500;
 int22_ar[U][G][U][A][G][G][G][U] =  0.500;
 int22_ar[U][G][U][A][G][U][G][U] =  2.500;
 int22_ar[U][G][U][A][U][A][G][U] =  2.000;
 int22_ar[U][G][U][A][U][C][G][U] =  2.000;
 int22_ar[U][G][U][A][U][G][G][U] =  2.000;
 int22_ar[U][G][U][A][U][U][G][U] =  2.000;
 int22_ar[U][G][U][C][A][A][G][U] =  2.000;
 int22_ar[U][G][U][C][A][C][G][U] =  2.600;
 int22_ar[U][G][U][C][A][G][G][U] = -0.200;
 int22_ar[U][G][U][C][A][U][G][U] =  1.800;
 int22_ar[U][G][U][C][C][A][G][U] =  2.000;
 int22_ar[U][G][U][C][C][C][G][U] =  2.500;
 int22_ar[U][G][U][C][C][G][G][U] =  0.700;
 int22_ar[U][G][U][C][C][U][G][U] =  1.600;
 int22_ar[U][G][U][C][G][A][G][U] =  2.000;
 int22_ar[U][G][U][C][G][C][G][U] =  2.000;
 int22_ar[U][G][U][C][G][G][G][U] =  2.000;
 int22_ar[U][G][U][C][G][U][G][U] =  2.000;
 int22_ar[U][G][U][C][U][A][G][U] =  2.000;
 int22_ar[U][G][U][C][U][C][G][U] =  2.500;
 int22_ar[U][G][U][C][U][G][G][U] =  0.700;
 int22_ar[U][G][U][C][U][U][G][U] =  1.600;
 int22_ar[U][G][U][G][A][A][G][U] =  2.000;
 int22_ar[U][G][U][G][A][C][G][U] =  2.500;
 int22_ar[U][G][U][G][A][G][G][U] =  0.500;
 int22_ar[U][G][U][G][A][U][G][U] =  2.500;
 int22_ar[U][G][U][G][C][A][G][U] =  2.000;
 int22_ar[U][G][U][G][C][C][G][U] =  2.000;
 int22_ar[U][G][U][G][C][G][G][U] =  2.000;
 int22_ar[U][G][U][G][C][U][G][U] =  2.000;
 int22_ar[U][G][U][G][G][A][G][U] =  2.000;
 int22_ar[U][G][U][G][G][C][G][U] =  2.700;
 int22_ar[U][G][U][G][G][G][G][U] =  0.300;
 int22_ar[U][G][U][G][G][U][G][U] =  2.200;
 int22_ar[U][G][U][G][U][A][G][U] =  2.000;
 int22_ar[U][G][U][G][U][C][G][U] =  1.300;
 int22_ar[U][G][U][G][U][G][G][U] = -2.500;
 int22_ar[U][G][U][G][U][U][G][U] =  1.300;
 int22_ar[U][G][U][U][A][A][G][U] =  2.000;
 int22_ar[U][G][U][U][A][C][G][U] =  2.000;
 int22_ar[U][G][U][U][A][G][G][U] =  2.000;
 int22_ar[U][G][U][U][A][U][G][U] =  2.000;
 int22_ar[U][G][U][U][C][A][G][U] =  2.000;
 int22_ar[U][G][U][U][C][C][G][U] =  2.500;
 int22_ar[U][G][U][U][C][G][G][U] =  0.700;
 int22_ar[U][G][U][U][C][U][G][U] =  1.600;
 int22_ar[U][G][U][U][G][A][G][U] =  2.000;
 int22_ar[U][G][U][U][G][C][G][U] =  2.300;
 int22_ar[U][G][U][U][G][G][G][U] = -1.500;
 int22_ar[U][G][U][U][G][U][G][U] =  2.300;
 int22_ar[U][G][U][U][U][A][G][U] =  2.000;
 int22_ar[U][G][U][U][U][C][G][U] =  1.700;
 int22_ar[U][G][U][U][U][G][G][U] =  0.700;
 int22_ar[U][G][U][U][U][U][G][U] =  0.800;
 int22_ar[U][G][A][A][A][A][U][A] =  2.800;
 int22_ar[U][G][A][A][A][C][U][A] =  2.800;
 int22_ar[U][G][A][A][A][G][U][A] =  1.700;
 int22_ar[U][G][A][A][A][U][U][A] =  2.000;
 int22_ar[U][G][A][A][C][A][U][A] =  2.300;
 int22_ar[U][G][A][A][C][C][U][A] =  2.300;
 int22_ar[U][G][A][A][C][G][U][A] =  1.300;
 int22_ar[U][G][A][A][C][U][U][A] =  2.000;
 int22_ar[U][G][A][A][G][A][U][A] =  1.700;
 int22_ar[U][G][A][A][G][C][U][A] =  1.700;
 int22_ar[U][G][A][A][G][G][U][A] =  0.700;
 int22_ar[U][G][A][A][G][U][U][A] =  2.000;
 int22_ar[U][G][A][A][U][A][U][A] =  2.000;
 int22_ar[U][G][A][A][U][C][U][A] =  2.000;
 int22_ar[U][G][A][A][U][G][U][A] =  2.000;
 int22_ar[U][G][A][A][U][U][U][A] =  2.000;
 int22_ar[U][G][A][C][A][A][U][A] =  2.800;
 int22_ar[U][G][A][C][A][C][U][A] =  2.800;
 int22_ar[U][G][A][C][A][G][U][A] =  1.700;
 int22_ar[U][G][A][C][A][U][U][A] =  2.000;
 int22_ar[U][G][A][C][C][A][U][A] =  3.400;
 int22_ar[U][G][A][C][C][C][U][A] =  2.800;
 int22_ar[U][G][A][C][C][G][U][A] =  2.700;
 int22_ar[U][G][A][C][C][U][U][A] =  2.000;
 int22_ar[U][G][A][C][G][A][U][A] =  2.000;
 int22_ar[U][G][A][C][G][C][U][A] =  2.000;
 int22_ar[U][G][A][C][G][G][U][A] =  2.000;
 int22_ar[U][G][A][C][G][U][U][A] =  2.000;
 int22_ar[U][G][A][C][U][A][U][A] =  3.400;
 int22_ar[U][G][A][C][U][C][U][A] =  2.800;
 int22_ar[U][G][A][C][U][G][U][A] =  2.700;
 int22_ar[U][G][A][C][U][U][U][A] =  2.000;
 int22_ar[U][G][A][G][A][A][U][A] =  1.700;
 int22_ar[U][G][A][G][A][C][U][A] =  1.700;
 int22_ar[U][G][A][G][A][G][U][A] =  0.700;
 int22_ar[U][G][A][G][A][U][U][A] =  2.000;
 int22_ar[U][G][A][G][C][A][U][A] =  2.000;
 int22_ar[U][G][A][G][C][C][U][A] =  2.000;
 int22_ar[U][G][A][G][C][G][U][A] =  2.000;
 int22_ar[U][G][A][G][C][U][U][A] =  2.000;
 int22_ar[U][G][A][G][G][A][U][A] =  2.100;
 int22_ar[U][G][A][G][G][C][U][A] =  2.100;
 int22_ar[U][G][A][G][G][G][U][A] =  1.100;
 int22_ar[U][G][A][G][G][U][U][A] =  2.000;
 int22_ar[U][G][A][G][U][A][U][A] =  1.000;
 int22_ar[U][G][A][G][U][C][U][A] =  0.000;
 int22_ar[U][G][A][G][U][G][U][A] =  0.700;
 int22_ar[U][G][A][G][U][U][U][A] =  2.000;
 int22_ar[U][G][A][U][A][A][U][A] =  2.000;
 int22_ar[U][G][A][U][A][C][U][A] =  2.000;
 int22_ar[U][G][A][U][A][G][U][A] =  2.000;
 int22_ar[U][G][A][U][A][U][U][A] =  2.000;
 int22_ar[U][G][A][U][C][A][U][A] =  3.100;
 int22_ar[U][G][A][U][C][C][U][A] =  2.500;
 int22_ar[U][G][A][U][C][G][U][A] =  2.400;
 int22_ar[U][G][A][U][C][U][U][A] =  2.000;
 int22_ar[U][G][A][U][G][A][U][A] =  2.200;
 int22_ar[U][G][A][U][G][C][U][A] =  1.200;
 int22_ar[U][G][A][U][G][G][U][A] =  2.000;
 int22_ar[U][G][A][U][G][U][U][A] =  2.000;
 int22_ar[U][G][A][U][U][A][U][A] =  2.900;
 int22_ar[U][G][A][U][U][C][U][A] =  1.900;
 int22_ar[U][G][A][U][U][G][U][A] =  2.700;
 int22_ar[U][G][A][U][U][U][U][A] =  2.000;
 int22_ar[U][G][C][A][A][A][U][A] =  2.300;
 int22_ar[U][G][C][A][A][C][U][A] =  3.400;
 int22_ar[U][G][C][A][A][G][U][A] =  2.000;
 int22_ar[U][G][C][A][A][U][U][A] =  3.100;
 int22_ar[U][G][C][A][C][A][U][A] =  1.900;
 int22_ar[U][G][C][A][C][C][U][A] =  2.300;
 int22_ar[U][G][C][A][C][G][U][A] =  2.000;
 int22_ar[U][G][C][A][C][U][U][A] =  2.000;
 int22_ar[U][G][C][A][G][A][U][A] =  1.300;
 int22_ar[U][G][C][A][G][C][U][A] =  2.700;
 int22_ar[U][G][C][A][G][G][U][A] =  2.000;
 int22_ar[U][G][C][A][G][U][U][A] =  2.400;
 int22_ar[U][G][C][A][U][A][U][A] =  2.000;
 int22_ar[U][G][C][A][U][C][U][A] =  2.000;
 int22_ar[U][G][C][A][U][G][U][A] =  2.000;
 int22_ar[U][G][C][A][U][U][U][A] =  2.000;
 int22_ar[U][G][C][C][A][A][U][A] =  2.300;
 int22_ar[U][G][C][C][A][C][U][A] =  2.800;
 int22_ar[U][G][C][C][A][G][U][A] =  2.000;
 int22_ar[U][G][C][C][A][U][U][A] =  2.500;
 int22_ar[U][G][C][C][C][A][U][A] =  2.300;
 int22_ar[U][G][C][C][C][C][U][A] =  2.800;
 int22_ar[U][G][C][C][C][G][U][A] =  2.000;
 int22_ar[U][G][C][C][C][U][U][A] =  2.500;
 int22_ar[U][G][C][C][G][A][U][A] =  2.000;
 int22_ar[U][G][C][C][G][C][U][A] =  2.000;
 int22_ar[U][G][C][C][G][G][U][A] =  2.000;
 int22_ar[U][G][C][C][G][U][U][A] =  2.000;
 int22_ar[U][G][C][C][U][A][U][A] =  2.300;
 int22_ar[U][G][C][C][U][C][U][A] =  2.800;
 int22_ar[U][G][C][C][U][G][U][A] =  2.000;
 int22_ar[U][G][C][C][U][U][U][A] =  2.500;
 int22_ar[U][G][C][G][A][A][U][A] =  1.300;
 int22_ar[U][G][C][G][A][C][U][A] =  2.700;
 int22_ar[U][G][C][G][A][G][U][A] =  2.000;
 int22_ar[U][G][C][G][A][U][U][A] =  2.400;
 int22_ar[U][G][C][G][C][A][U][A] =  2.000;
 int22_ar[U][G][C][G][C][C][U][A] =  2.000;
 int22_ar[U][G][C][G][C][G][U][A] =  2.000;
 int22_ar[U][G][C][G][C][U][U][A] =  2.000;
 int22_ar[U][G][C][G][G][A][U][A] =  1.700;
 int22_ar[U][G][C][G][G][C][U][A] =  2.700;
 int22_ar[U][G][C][G][G][G][U][A] =  2.000;
 int22_ar[U][G][C][G][G][U][U][A] =  2.400;
 int22_ar[U][G][C][G][U][A][U][A] = -0.500;
 int22_ar[U][G][C][G][U][C][U][A] =  1.000;
 int22_ar[U][G][C][G][U][G][U][A] =  2.000;
 int22_ar[U][G][C][G][U][U][U][A] =  0.700;
 int22_ar[U][G][C][U][A][A][U][A] =  2.000;
 int22_ar[U][G][C][U][A][C][U][A] =  2.000;
 int22_ar[U][G][C][U][A][G][U][A] =  2.000;
 int22_ar[U][G][C][U][A][U][U][A] =  2.000;
 int22_ar[U][G][C][U][C][A][U][A] =  2.000;
 int22_ar[U][G][C][U][C][C][U][A] =  2.500;
 int22_ar[U][G][C][U][C][G][U][A] =  2.000;
 int22_ar[U][G][C][U][C][U][U][A] =  2.200;
 int22_ar[U][G][C][U][G][A][U][A] =  0.800;
 int22_ar[U][G][C][U][G][C][U][A] =  2.200;
 int22_ar[U][G][C][U][G][G][U][A] =  2.000;
 int22_ar[U][G][C][U][G][U][U][A] =  1.900;
 int22_ar[U][G][C][U][U][A][U][A] =  1.500;
 int22_ar[U][G][C][U][U][C][U][A] =  1.900;
 int22_ar[U][G][C][U][U][G][U][A] =  2.000;
 int22_ar[U][G][C][U][U][U][U][A] =  1.600;
 int22_ar[U][G][G][A][A][A][U][A] =  1.700;
 int22_ar[U][G][G][A][A][C][U][A] =  2.000;
 int22_ar[U][G][G][A][A][G][U][A] =  2.100;
 int22_ar[U][G][G][A][A][U][U][A] =  2.200;
 int22_ar[U][G][G][A][C][A][U][A] =  1.300;
 int22_ar[U][G][G][A][C][C][U][A] =  2.000;
 int22_ar[U][G][G][A][C][G][U][A] =  1.700;
 int22_ar[U][G][G][A][C][U][U][A] =  0.800;
 int22_ar[U][G][G][A][G][A][U][A] =  0.700;
 int22_ar[U][G][G][A][G][C][U][A] =  2.000;
 int22_ar[U][G][G][A][G][G][U][A] =  1.100;
 int22_ar[U][G][G][A][G][U][U][A] =  2.000;
 int22_ar[U][G][G][A][U][A][U][A] =  2.000;
 int22_ar[U][G][G][A][U][C][U][A] =  2.000;
 int22_ar[U][G][G][A][U][G][U][A] =  2.000;
 int22_ar[U][G][G][A][U][U][U][A] =  2.000;
 int22_ar[U][G][G][C][A][A][U][A] =  1.700;
 int22_ar[U][G][G][C][A][C][U][A] =  2.000;
 int22_ar[U][G][G][C][A][G][U][A] =  2.100;
 int22_ar[U][G][G][C][A][U][U][A] =  1.200;
 int22_ar[U][G][G][C][C][A][U][A] =  2.700;
 int22_ar[U][G][G][C][C][C][U][A] =  2.000;
 int22_ar[U][G][G][C][C][G][U][A] =  2.700;
 int22_ar[U][G][G][C][C][U][U][A] =  2.200;
 int22_ar[U][G][G][C][G][A][U][A] =  2.000;
 int22_ar[U][G][G][C][G][C][U][A] =  2.000;
 int22_ar[U][G][G][C][G][G][U][A] =  2.000;
 int22_ar[U][G][G][C][G][U][U][A] =  2.000;
 int22_ar[U][G][G][C][U][A][U][A] =  2.700;
 int22_ar[U][G][G][C][U][C][U][A] =  2.000;
 int22_ar[U][G][G][C][U][G][U][A] =  2.700;
 int22_ar[U][G][G][C][U][U][U][A] =  2.200;
 int22_ar[U][G][G][G][A][A][U][A] =  0.700;
 int22_ar[U][G][G][G][A][C][U][A] =  2.000;
 int22_ar[U][G][G][G][A][G][U][A] =  1.100;
 int22_ar[U][G][G][G][A][U][U][A] =  2.000;
 int22_ar[U][G][G][G][C][A][U][A] =  2.000;
 int22_ar[U][G][G][G][C][C][U][A] =  2.000;
 int22_ar[U][G][G][G][C][G][U][A] =  2.000;
 int22_ar[U][G][G][G][C][U][U][A] =  2.000;
 int22_ar[U][G][G][G][G][A][U][A] =  1.100;
 int22_ar[U][G][G][G][G][C][U][A] =  2.000;
 int22_ar[U][G][G][G][G][G][U][A] =  1.500;
 int22_ar[U][G][G][G][G][U][U][A] =  1.600;
 int22_ar[U][G][G][G][U][A][U][A] =  0.700;
 int22_ar[U][G][G][G][U][C][U][A] =  2.000;
 int22_ar[U][G][G][G][U][G][U][A] =  0.300;
 int22_ar[U][G][G][G][U][U][U][A] = -1.600;
 int22_ar[U][G][G][U][A][A][U][A] =  2.000;
 int22_ar[U][G][G][U][A][C][U][A] =  2.000;
 int22_ar[U][G][G][U][A][G][U][A] =  2.000;
 int22_ar[U][G][G][U][A][U][U][A] =  2.000;
 int22_ar[U][G][G][U][C][A][U][A] =  2.400;
 int22_ar[U][G][G][U][C][C][U][A] =  2.000;
 int22_ar[U][G][G][U][C][G][U][A] =  2.400;
 int22_ar[U][G][G][U][C][U][U][A] =  1.900;
 int22_ar[U][G][G][U][G][A][U][A] =  2.000;
 int22_ar[U][G][G][U][G][C][U][A] =  2.000;
 int22_ar[U][G][G][U][G][G][U][A] =  1.600;
 int22_ar[U][G][G][U][G][U][U][A] = -0.300;
 int22_ar[U][G][G][U][U][A][U][A] =  2.700;
 int22_ar[U][G][G][U][U][C][U][A] =  2.000;
 int22_ar[U][G][G][U][U][G][U][A] =  2.300;
 int22_ar[U][G][G][U][U][U][U][A] =  2.200;
 int22_ar[U][G][U][A][A][A][U][A] =  2.000;
 int22_ar[U][G][U][A][A][C][U][A] =  3.400;
 int22_ar[U][G][U][A][A][G][U][A] =  1.000;
 int22_ar[U][G][U][A][A][U][U][A] =  2.900;
 int22_ar[U][G][U][A][C][A][U][A] =  2.000;
 int22_ar[U][G][U][A][C][C][U][A] =  2.300;
 int22_ar[U][G][U][A][C][G][U][A] = -0.500;
 int22_ar[U][G][U][A][C][U][U][A] =  1.500;
 int22_ar[U][G][U][A][G][A][U][A] =  2.000;
 int22_ar[U][G][U][A][G][C][U][A] =  2.700;
 int22_ar[U][G][U][A][G][G][U][A] =  0.700;
 int22_ar[U][G][U][A][G][U][U][A] =  2.700;
 int22_ar[U][G][U][A][U][A][U][A] =  2.000;
 int22_ar[U][G][U][A][U][C][U][A] =  2.000;
 int22_ar[U][G][U][A][U][G][U][A] =  2.000;
 int22_ar[U][G][U][A][U][U][U][A] =  2.000;
 int22_ar[U][G][U][C][A][A][U][A] =  2.000;
 int22_ar[U][G][U][C][A][C][U][A] =  2.800;
 int22_ar[U][G][U][C][A][G][U][A] =  0.000;
 int22_ar[U][G][U][C][A][U][U][A] =  1.900;
 int22_ar[U][G][U][C][C][A][U][A] =  2.000;
 int22_ar[U][G][U][C][C][C][U][A] =  2.800;
 int22_ar[U][G][U][C][C][G][U][A] =  1.000;
 int22_ar[U][G][U][C][C][U][U][A] =  1.900;
 int22_ar[U][G][U][C][G][A][U][A] =  2.000;
 int22_ar[U][G][U][C][G][C][U][A] =  2.000;
 int22_ar[U][G][U][C][G][G][U][A] =  2.000;
 int22_ar[U][G][U][C][G][U][U][A] =  2.000;
 int22_ar[U][G][U][C][U][A][U][A] =  2.000;
 int22_ar[U][G][U][C][U][C][U][A] =  2.800;
 int22_ar[U][G][U][C][U][G][U][A] =  1.000;
 int22_ar[U][G][U][C][U][U][U][A] =  1.900;
 int22_ar[U][G][U][G][A][A][U][A] =  2.000;
 int22_ar[U][G][U][G][A][C][U][A] =  2.700;
 int22_ar[U][G][U][G][A][G][U][A] =  0.700;
 int22_ar[U][G][U][G][A][U][U][A] =  2.700;
 int22_ar[U][G][U][G][C][A][U][A] =  2.000;
 int22_ar[U][G][U][G][C][C][U][A] =  2.000;
 int22_ar[U][G][U][G][C][G][U][A] =  2.000;
 int22_ar[U][G][U][G][C][U][U][A] =  2.000;
 int22_ar[U][G][U][G][G][A][U][A] =  2.000;
 int22_ar[U][G][U][G][G][C][U][A] =  2.700;
 int22_ar[U][G][U][G][G][G][U][A] =  0.300;
 int22_ar[U][G][U][G][G][U][U][A] =  2.300;
 int22_ar[U][G][U][G][U][A][U][A] =  2.000;
 int22_ar[U][G][U][G][U][C][U][A] =  1.000;
 int22_ar[U][G][U][G][U][G][U][A] = -2.900;
 int22_ar[U][G][U][G][U][U][U][A] =  0.900;
 int22_ar[U][G][U][U][A][A][U][A] =  2.000;
 int22_ar[U][G][U][U][A][C][U][A] =  2.000;
 int22_ar[U][G][U][U][A][G][U][A] =  2.000;
 int22_ar[U][G][U][U][A][U][U][A] =  2.000;
 int22_ar[U][G][U][U][C][A][U][A] =  2.000;
 int22_ar[U][G][U][U][C][C][U][A] =  2.500;
 int22_ar[U][G][U][U][C][G][U][A] =  0.700;
 int22_ar[U][G][U][U][C][U][U][A] =  1.600;
 int22_ar[U][G][U][U][G][A][U][A] =  2.000;
 int22_ar[U][G][U][U][G][C][U][A] =  2.200;
 int22_ar[U][G][U][U][G][G][U][A] = -1.600;
 int22_ar[U][G][U][U][G][U][U][A] =  2.200;
 int22_ar[U][G][U][U][U][A][U][A] =  2.000;
 int22_ar[U][G][U][U][U][C][U][A] =  1.900;
 int22_ar[U][G][U][U][U][G][U][A] =  0.900;
 int22_ar[U][G][U][U][U][U][U][A] =  1.100;
 int22_ar[U][G][A][A][A][A][U][G] =  2.800;
 int22_ar[U][G][A][A][A][C][U][G] =  2.800;
 int22_ar[U][G][A][A][A][G][U][G] =  1.700;
 int22_ar[U][G][A][A][A][U][U][G] =  2.000;
 int22_ar[U][G][A][A][C][A][U][G] =  2.300;
 int22_ar[U][G][A][A][C][C][U][G] =  2.300;
 int22_ar[U][G][A][A][C][G][U][G] =  1.300;
 int22_ar[U][G][A][A][C][U][U][G] =  2.000;
 int22_ar[U][G][A][A][G][A][U][G] =  1.700;
 int22_ar[U][G][A][A][G][C][U][G] =  1.700;
 int22_ar[U][G][A][A][G][G][U][G] =  0.700;
 int22_ar[U][G][A][A][G][U][U][G] =  2.000;
 int22_ar[U][G][A][A][U][A][U][G] =  2.000;
 int22_ar[U][G][A][A][U][C][U][G] =  2.000;
 int22_ar[U][G][A][A][U][G][U][G] =  2.000;
 int22_ar[U][G][A][A][U][U][U][G] =  2.000;
 int22_ar[U][G][A][C][A][A][U][G] =  2.800;
 int22_ar[U][G][A][C][A][C][U][G] =  2.800;
 int22_ar[U][G][A][C][A][G][U][G] =  1.700;
 int22_ar[U][G][A][C][A][U][U][G] =  2.000;
 int22_ar[U][G][A][C][C][A][U][G] =  3.400;
 int22_ar[U][G][A][C][C][C][U][G] =  2.800;
 int22_ar[U][G][A][C][C][G][U][G] =  2.700;
 int22_ar[U][G][A][C][C][U][U][G] =  2.000;
 int22_ar[U][G][A][C][G][A][U][G] =  2.000;
 int22_ar[U][G][A][C][G][C][U][G] =  2.000;
 int22_ar[U][G][A][C][G][G][U][G] =  2.000;
 int22_ar[U][G][A][C][G][U][U][G] =  2.000;
 int22_ar[U][G][A][C][U][A][U][G] =  3.400;
 int22_ar[U][G][A][C][U][C][U][G] =  2.800;
 int22_ar[U][G][A][C][U][G][U][G] =  2.700;
 int22_ar[U][G][A][C][U][U][U][G] =  2.000;
 int22_ar[U][G][A][G][A][A][U][G] =  1.700;
 int22_ar[U][G][A][G][A][C][U][G] =  1.700;
 int22_ar[U][G][A][G][A][G][U][G] =  0.700;
 int22_ar[U][G][A][G][A][U][U][G] =  2.000;
 int22_ar[U][G][A][G][C][A][U][G] =  2.000;
 int22_ar[U][G][A][G][C][C][U][G] =  2.000;
 int22_ar[U][G][A][G][C][G][U][G] =  2.000;
 int22_ar[U][G][A][G][C][U][U][G] =  2.000;
 int22_ar[U][G][A][G][G][A][U][G] =  2.100;
 int22_ar[U][G][A][G][G][C][U][G] =  2.100;
 int22_ar[U][G][A][G][G][G][U][G] =  1.100;
 int22_ar[U][G][A][G][G][U][U][G] =  2.000;
 int22_ar[U][G][A][G][U][A][U][G] =  1.000;
 int22_ar[U][G][A][G][U][C][U][G] =  0.000;
 int22_ar[U][G][A][G][U][G][U][G] =  0.700;
 int22_ar[U][G][A][G][U][U][U][G] =  2.000;
 int22_ar[U][G][A][U][A][A][U][G] =  2.000;
 int22_ar[U][G][A][U][A][C][U][G] =  2.000;
 int22_ar[U][G][A][U][A][G][U][G] =  2.000;
 int22_ar[U][G][A][U][A][U][U][G] =  2.000;
 int22_ar[U][G][A][U][C][A][U][G] =  3.100;
 int22_ar[U][G][A][U][C][C][U][G] =  2.500;
 int22_ar[U][G][A][U][C][G][U][G] =  2.400;
 int22_ar[U][G][A][U][C][U][U][G] =  2.000;
 int22_ar[U][G][A][U][G][A][U][G] =  2.200;
 int22_ar[U][G][A][U][G][C][U][G] =  1.200;
 int22_ar[U][G][A][U][G][G][U][G] =  2.000;
 int22_ar[U][G][A][U][G][U][U][G] =  2.000;
 int22_ar[U][G][A][U][U][A][U][G] =  2.900;
 int22_ar[U][G][A][U][U][C][U][G] =  1.900;
 int22_ar[U][G][A][U][U][G][U][G] =  2.700;
 int22_ar[U][G][A][U][U][U][U][G] =  2.000;
 int22_ar[U][G][C][A][A][A][U][G] =  2.300;
 int22_ar[U][G][C][A][A][C][U][G] =  3.400;
 int22_ar[U][G][C][A][A][G][U][G] =  2.000;
 int22_ar[U][G][C][A][A][U][U][G] =  3.100;
 int22_ar[U][G][C][A][C][A][U][G] =  1.900;
 int22_ar[U][G][C][A][C][C][U][G] =  2.300;
 int22_ar[U][G][C][A][C][G][U][G] =  2.000;
 int22_ar[U][G][C][A][C][U][U][G] =  2.000;
 int22_ar[U][G][C][A][G][A][U][G] =  1.300;
 int22_ar[U][G][C][A][G][C][U][G] =  2.700;
 int22_ar[U][G][C][A][G][G][U][G] =  2.000;
 int22_ar[U][G][C][A][G][U][U][G] =  2.400;
 int22_ar[U][G][C][A][U][A][U][G] =  2.000;
 int22_ar[U][G][C][A][U][C][U][G] =  2.000;
 int22_ar[U][G][C][A][U][G][U][G] =  2.000;
 int22_ar[U][G][C][A][U][U][U][G] =  2.000;
 int22_ar[U][G][C][C][A][A][U][G] =  2.300;
 int22_ar[U][G][C][C][A][C][U][G] =  2.800;
 int22_ar[U][G][C][C][A][G][U][G] =  2.000;
 int22_ar[U][G][C][C][A][U][U][G] =  2.500;
 int22_ar[U][G][C][C][C][A][U][G] =  2.300;
 int22_ar[U][G][C][C][C][C][U][G] =  2.800;
 int22_ar[U][G][C][C][C][G][U][G] =  2.000;
 int22_ar[U][G][C][C][C][U][U][G] =  2.500;
 int22_ar[U][G][C][C][G][A][U][G] =  2.000;
 int22_ar[U][G][C][C][G][C][U][G] =  2.000;
 int22_ar[U][G][C][C][G][G][U][G] =  2.000;
 int22_ar[U][G][C][C][G][U][U][G] =  2.000;
 int22_ar[U][G][C][C][U][A][U][G] =  2.300;
 int22_ar[U][G][C][C][U][C][U][G] =  2.800;
 int22_ar[U][G][C][C][U][G][U][G] =  2.000;
 int22_ar[U][G][C][C][U][U][U][G] =  2.500;
 int22_ar[U][G][C][G][A][A][U][G] =  1.300;
 int22_ar[U][G][C][G][A][C][U][G] =  2.700;
 int22_ar[U][G][C][G][A][G][U][G] =  2.000;
 int22_ar[U][G][C][G][A][U][U][G] =  2.400;
 int22_ar[U][G][C][G][C][A][U][G] =  2.000;
 int22_ar[U][G][C][G][C][C][U][G] =  2.000;
 int22_ar[U][G][C][G][C][G][U][G] =  2.000;
 int22_ar[U][G][C][G][C][U][U][G] =  2.000;
 int22_ar[U][G][C][G][G][A][U][G] =  1.700;
 int22_ar[U][G][C][G][G][C][U][G] =  2.700;
 int22_ar[U][G][C][G][G][G][U][G] =  2.000;
 int22_ar[U][G][C][G][G][U][U][G] =  2.400;
 int22_ar[U][G][C][G][U][A][U][G] = -0.500;
 int22_ar[U][G][C][G][U][C][U][G] =  1.000;
 int22_ar[U][G][C][G][U][G][U][G] =  2.000;
 int22_ar[U][G][C][G][U][U][U][G] =  0.700;
 int22_ar[U][G][C][U][A][A][U][G] =  2.000;
 int22_ar[U][G][C][U][A][C][U][G] =  2.000;
 int22_ar[U][G][C][U][A][G][U][G] =  2.000;
 int22_ar[U][G][C][U][A][U][U][G] =  2.000;
 int22_ar[U][G][C][U][C][A][U][G] =  2.000;
 int22_ar[U][G][C][U][C][C][U][G] =  2.500;
 int22_ar[U][G][C][U][C][G][U][G] =  2.000;
 int22_ar[U][G][C][U][C][U][U][G] =  2.200;
 int22_ar[U][G][C][U][G][A][U][G] =  0.800;
 int22_ar[U][G][C][U][G][C][U][G] =  2.200;
 int22_ar[U][G][C][U][G][G][U][G] =  2.000;
 int22_ar[U][G][C][U][G][U][U][G] =  1.900;
 int22_ar[U][G][C][U][U][A][U][G] =  1.500;
 int22_ar[U][G][C][U][U][C][U][G] =  1.900;
 int22_ar[U][G][C][U][U][G][U][G] =  2.000;
 int22_ar[U][G][C][U][U][U][U][G] =  1.600;
 int22_ar[U][G][G][A][A][A][U][G] =  1.700;
 int22_ar[U][G][G][A][A][C][U][G] =  2.000;
 int22_ar[U][G][G][A][A][G][U][G] =  2.100;
 int22_ar[U][G][G][A][A][U][U][G] =  2.200;
 int22_ar[U][G][G][A][C][A][U][G] =  1.300;
 int22_ar[U][G][G][A][C][C][U][G] =  2.000;
 int22_ar[U][G][G][A][C][G][U][G] =  1.700;
 int22_ar[U][G][G][A][C][U][U][G] =  0.800;
 int22_ar[U][G][G][A][G][A][U][G] =  0.700;
 int22_ar[U][G][G][A][G][C][U][G] =  2.000;
 int22_ar[U][G][G][A][G][G][U][G] =  1.100;
 int22_ar[U][G][G][A][G][U][U][G] =  2.000;
 int22_ar[U][G][G][A][U][A][U][G] =  2.000;
 int22_ar[U][G][G][A][U][C][U][G] =  2.000;
 int22_ar[U][G][G][A][U][G][U][G] =  2.000;
 int22_ar[U][G][G][A][U][U][U][G] =  2.000;
 int22_ar[U][G][G][C][A][A][U][G] =  1.700;
 int22_ar[U][G][G][C][A][C][U][G] =  2.000;
 int22_ar[U][G][G][C][A][G][U][G] =  2.100;
 int22_ar[U][G][G][C][A][U][U][G] =  1.200;
 int22_ar[U][G][G][C][C][A][U][G] =  2.700;
 int22_ar[U][G][G][C][C][C][U][G] =  2.000;
 int22_ar[U][G][G][C][C][G][U][G] =  2.700;
 int22_ar[U][G][G][C][C][U][U][G] =  2.200;
 int22_ar[U][G][G][C][G][A][U][G] =  2.000;
 int22_ar[U][G][G][C][G][C][U][G] =  2.000;
 int22_ar[U][G][G][C][G][G][U][G] =  2.000;
 int22_ar[U][G][G][C][G][U][U][G] =  2.000;
 int22_ar[U][G][G][C][U][A][U][G] =  2.700;
 int22_ar[U][G][G][C][U][C][U][G] =  2.000;
 int22_ar[U][G][G][C][U][G][U][G] =  2.700;
 int22_ar[U][G][G][C][U][U][U][G] =  2.200;
 int22_ar[U][G][G][G][A][A][U][G] =  0.700;
 int22_ar[U][G][G][G][A][C][U][G] =  2.000;
 int22_ar[U][G][G][G][A][G][U][G] =  1.100;
 int22_ar[U][G][G][G][A][U][U][G] =  2.000;
 int22_ar[U][G][G][G][C][A][U][G] =  2.000;
 int22_ar[U][G][G][G][C][C][U][G] =  2.000;
 int22_ar[U][G][G][G][C][G][U][G] =  2.000;
 int22_ar[U][G][G][G][C][U][U][G] =  2.000;
 int22_ar[U][G][G][G][G][A][U][G] =  1.100;
 int22_ar[U][G][G][G][G][C][U][G] =  2.000;
 int22_ar[U][G][G][G][G][G][U][G] =  1.500;
 int22_ar[U][G][G][G][G][U][U][G] =  1.600;
 int22_ar[U][G][G][G][U][A][U][G] =  0.700;
 int22_ar[U][G][G][G][U][C][U][G] =  2.000;
 int22_ar[U][G][G][G][U][G][U][G] =  0.300;
 int22_ar[U][G][G][G][U][U][U][G] = -1.600;
 int22_ar[U][G][G][U][A][A][U][G] =  2.000;
 int22_ar[U][G][G][U][A][C][U][G] =  2.000;
 int22_ar[U][G][G][U][A][G][U][G] =  2.000;
 int22_ar[U][G][G][U][A][U][U][G] =  2.000;
 int22_ar[U][G][G][U][C][A][U][G] =  2.400;
 int22_ar[U][G][G][U][C][C][U][G] =  2.000;
 int22_ar[U][G][G][U][C][G][U][G] =  2.400;
 int22_ar[U][G][G][U][C][U][U][G] =  1.900;
 int22_ar[U][G][G][U][G][A][U][G] =  2.000;
 int22_ar[U][G][G][U][G][C][U][G] =  2.000;
 int22_ar[U][G][G][U][G][G][U][G] =  1.600;
 int22_ar[U][G][G][U][G][U][U][G] = -0.300;
 int22_ar[U][G][G][U][U][A][U][G] =  2.700;
 int22_ar[U][G][G][U][U][C][U][G] =  2.000;
 int22_ar[U][G][G][U][U][G][U][G] =  2.300;
 int22_ar[U][G][G][U][U][U][U][G] =  2.200;
 int22_ar[U][G][U][A][A][A][U][G] =  2.000;
 int22_ar[U][G][U][A][A][C][U][G] =  3.400;
 int22_ar[U][G][U][A][A][G][U][G] =  1.000;
 int22_ar[U][G][U][A][A][U][U][G] =  2.900;
 int22_ar[U][G][U][A][C][A][U][G] =  2.000;
 int22_ar[U][G][U][A][C][C][U][G] =  2.300;
 int22_ar[U][G][U][A][C][G][U][G] = -0.500;
 int22_ar[U][G][U][A][C][U][U][G] =  1.500;
 int22_ar[U][G][U][A][G][A][U][G] =  2.000;
 int22_ar[U][G][U][A][G][C][U][G] =  2.700;
 int22_ar[U][G][U][A][G][G][U][G] =  0.700;
 int22_ar[U][G][U][A][G][U][U][G] =  2.700;
 int22_ar[U][G][U][A][U][A][U][G] =  2.000;
 int22_ar[U][G][U][A][U][C][U][G] =  2.000;
 int22_ar[U][G][U][A][U][G][U][G] =  2.000;
 int22_ar[U][G][U][A][U][U][U][G] =  2.000;
 int22_ar[U][G][U][C][A][A][U][G] =  2.000;
 int22_ar[U][G][U][C][A][C][U][G] =  2.800;
 int22_ar[U][G][U][C][A][G][U][G] =  0.000;
 int22_ar[U][G][U][C][A][U][U][G] =  1.900;
 int22_ar[U][G][U][C][C][A][U][G] =  2.000;
 int22_ar[U][G][U][C][C][C][U][G] =  2.800;
 int22_ar[U][G][U][C][C][G][U][G] =  1.000;
 int22_ar[U][G][U][C][C][U][U][G] =  1.900;
 int22_ar[U][G][U][C][G][A][U][G] =  2.000;
 int22_ar[U][G][U][C][G][C][U][G] =  2.000;
 int22_ar[U][G][U][C][G][G][U][G] =  2.000;
 int22_ar[U][G][U][C][G][U][U][G] =  2.000;
 int22_ar[U][G][U][C][U][A][U][G] =  2.000;
 int22_ar[U][G][U][C][U][C][U][G] =  2.800;
 int22_ar[U][G][U][C][U][G][U][G] =  1.000;
 int22_ar[U][G][U][C][U][U][U][G] =  1.900;
 int22_ar[U][G][U][G][A][A][U][G] =  2.000;
 int22_ar[U][G][U][G][A][C][U][G] =  2.700;
 int22_ar[U][G][U][G][A][G][U][G] =  0.700;
 int22_ar[U][G][U][G][A][U][U][G] =  2.700;
 int22_ar[U][G][U][G][C][A][U][G] =  2.000;
 int22_ar[U][G][U][G][C][C][U][G] =  2.000;
 int22_ar[U][G][U][G][C][G][U][G] =  2.000;
 int22_ar[U][G][U][G][C][U][U][G] =  2.000;
 int22_ar[U][G][U][G][G][A][U][G] =  2.000;
 int22_ar[U][G][U][G][G][C][U][G] =  2.700;
 int22_ar[U][G][U][G][G][G][U][G] =  0.300;
 int22_ar[U][G][U][G][G][U][U][G] =  2.300;
 int22_ar[U][G][U][G][U][A][U][G] =  2.000;
 int22_ar[U][G][U][G][U][C][U][G] =  1.000;
 int22_ar[U][G][U][G][U][G][U][G] = -2.900;
 int22_ar[U][G][U][G][U][U][U][G] =  0.900;
 int22_ar[U][G][U][U][A][A][U][G] =  2.000;
 int22_ar[U][G][U][U][A][C][U][G] =  2.000;
 int22_ar[U][G][U][U][A][G][U][G] =  2.000;
 int22_ar[U][G][U][U][A][U][U][G] =  2.000;
 int22_ar[U][G][U][U][C][A][U][G] =  2.000;
 int22_ar[U][G][U][U][C][C][U][G] =  2.500;
 int22_ar[U][G][U][U][C][G][U][G] =  0.700;
 int22_ar[U][G][U][U][C][U][U][G] =  1.600;
 int22_ar[U][G][U][U][G][A][U][G] =  2.000;
 int22_ar[U][G][U][U][G][C][U][G] =  2.200;
 int22_ar[U][G][U][U][G][G][U][G] = -1.600;
 int22_ar[U][G][U][U][G][U][U][G] =  2.200;
 int22_ar[U][G][U][U][U][A][U][G] =  2.000;
 int22_ar[U][G][U][U][U][C][U][G] =  1.900;
 int22_ar[U][G][U][U][U][G][U][G] =  0.900;
 int22_ar[U][G][U][U][U][U][U][G] =  1.100;
}



void init_canPair(){
  int i,j;
  for (i=0;i<ALPHASIZE+1;i++)   /* +1 because of masking letter X */
    for(j=0;j<ALPHASIZE+1;j++)
      canPair[i][j]=0;
    
  canPair [A][U] = 1;
  canPair [U][A] = 1;
  canPair [C][G] = 1;
  canPair [G][C] = 1;
  canPair [G][U] = 1;
  canPair [U][G] = 1;
}


void init_energies()
{
  init_il_asym_ar();

   init_stack_dg_ar();
   init_tstackh_dg_ar();
   init_tstacki_dg_ar();
   init_hl_tetra_ar();

   init_hl_ent_ar();
   init_bl_ent_ar();
   init_il_ent_ar();

   init_dr_dangle_dg_ar();
   init_dl_dangle_dg_ar();

   init_int11_ar();
   init_int21_ar();
   init_int22_ar();

   init_canPair();
}




