/* -*- Mode: javascript; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

gTestfile = '13.4.4.31.js';

START("13.4.4.31 - XML removeNamespace()");

TEST(1, true, XML.prototype.hasOwnProperty("removeNamespace"));

x =
<alpha xmlns:foo="http://foo/">
    <bravo>one</bravo>
</alpha>;

correct =
<alpha>
    <bravo>one</bravo>
</alpha>;

x.removeNamespace("http://foo/");

TEST(2, correct, x);

// Shouldn't remove namespace if referenced
x =
<foo:alpha xmlns:foo="http://foo/">
    <bravo>one</bravo>
</foo:alpha>;

correct =
<foo:alpha xmlns:foo="http://foo/">
    <bravo>one</bravo>
</foo:alpha>;

x.removeNamespace("http://foo/");

TEST(3, correct, x);

END();