// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from testrpc.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.test {
  public class AuxSerial : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("test.AuxSerial:1.0.0", null);

    public AuxSerial(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public AuxSerial(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new AuxSerial StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new AuxSerial(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int OK = 0;

    public const int ERR_NO_TEST_MODE = 1;

    public const int ERR_INVAL_PORT_NUM = 2;

    public const int ERR_TEST_FAILED = 3;

    public class GetNumberOfPortsResult {
      public int _ret_;
      public int numPorts;
    }

    public GetNumberOfPortsResult getNumberOfPorts() {
      JsonObject _parameters = null;
      var _result = RpcCall("getNumberOfPorts", _parameters);
      var _ret = new GetNumberOfPortsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.numPorts = (int)_result["numPorts"];
      return _ret;
    }

    public AsyncRequest getNumberOfPorts(AsyncRpcResponse<GetNumberOfPortsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getNumberOfPorts(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getNumberOfPorts(AsyncRpcResponse<GetNumberOfPortsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getNumberOfPorts", _parameters,
        _result => {
          try {
            var _ret = new GetNumberOfPortsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.numPorts = (int)_result["numPorts"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestLoopResult {
      public int _ret_;
      public string errstr;
    }

    public TestLoopResult testLoop(int portNum) {
      var _parameters = new LightJson.JsonObject();
      _parameters["portNum"] = portNum;

      var _result = RpcCall("testLoop", _parameters);
      var _ret = new TestLoopResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.errstr = (string)_result["errstr"];
      return _ret;
    }

    public AsyncRequest testLoop(int portNum, AsyncRpcResponse<TestLoopResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testLoop(portNum, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testLoop(int portNum, AsyncRpcResponse<TestLoopResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["portNum"] = portNum;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testLoop", _parameters,
        _result => {
          try {
            var _ret = new TestLoopResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.errstr = (string)_result["errstr"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
