% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grd-tile.R
\name{grd_tile_template}
\alias{grd_tile_template}
\alias{grd_tile_summary}
\title{Compute overview grid tile}
\usage{
grd_tile_template(grid, level)

grd_tile_summary(grid, levels = NULL)
}
\arguments{
\item{grid}{A \code{\link[=grd_xy]{grd_xy()}}, \code{\link[=grd_rct]{grd_rct()}}, or other object
implementing \verb{grd_*()} methods.}

\item{level}{An integer describing the overview level. This is related to
the \code{step} value by a power of 2 (i.e., a level of \code{1} indicates a step of
\code{2}, a level of \code{2} indicates a step of \code{4}, etc.).}

\item{levels}{A vector of \code{level} values or \code{NULL} to use a sequence from
0 to the level that would result in a 1 x 1 grid.}
}
\value{
A \code{\link[=grd]{grd()}}
}
\description{
A useful workflow for raster data in a memory bounded environment is to
chunk a grid into sections or tiles. These functions compute tiles
suitable for such processing. Use \code{\link[=grd_tile_summary]{grd_tile_summary()}} to generate
statistics for \code{level} values to choose for your application.
}
\examples{
grid <- grd_rct(volcano)
grd_tile_summary(grid)
grd_tile_template(grid, 3)

}
