% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{build_install_test}
\alias{build_install_test}
\title{build, install and test}
\usage{
build_install_test(
  pkgdir = "./",
  testdir = "tinytest",
  pattern = "^test.*\\\\.[rR]$",
  at_home = TRUE,
  verbose = getOption("tt.verbose", 2),
  color = getOption("tt.pr.color", TRUE),
  ncpu = 1,
  remove_side_effects = TRUE,
  side_effects = FALSE,
  lc_collate = getOption("tt.collate", NA),
  keep_tempdir = FALSE,
  encoding = "unknown"
)
}
\arguments{
\item{pkgdir}{\code{[character]} Package directory}

\item{testdir}{\code{[character]} Name of directory under \code{pkgdir/inst}
containing test files.}

\item{pattern}{\code{[character]} A regular expression that is used to find
scripts in \code{dir} containing tests (by default \code{.R} or \code{.r}
files starting with \code{test}).}

\item{at_home}{\code{[logical]} toggle local tests.}

\item{verbose}{\code{[logical]} toggle verbosity during execution}

\item{color}{\code{[logical]} toggle colorize output}

\item{ncpu}{\code{[numeric]} number of CPUs to use during the testing phase.}

\item{remove_side_effects}{\code{[logical]} toggle remove user-defined side
effects? See section on side effects.}

\item{side_effects}{\code{[logical|list]} Either a logical,
or a list of arguments to pass to \code{\link{report_side_effects}}.}

\item{lc_collate}{\code{[character]} Locale setting used to sort the
test files into the order of execution. The default \code{NA} ensures
current locale is used. Set this e.g. to \code{"C"} to ensure bytewise
and more platform-independent sorting (see details in \code{\link{run_test_dir}}.}

\item{keep_tempdir}{\code{[logical]} keep directory where the pkg is
installed and where tests are run? If \code{TRUE}, the directory is not
deleted and it's location is printed.}

\item{encoding}{\code{[character]} Encoding parameter passed to \code{\link[base]{parse}}.}
}
\value{
A \code{tinytests} object.
}
\description{
Builds and installs the package in \code{pkgdir} under a temporary
directory.  Next, loads the package in a fresh R session and runs all the
tests. For this function to work the following system requirements are
necessary.
\itemize{
  \item{\code{R CMD build} is available on your system}
  \item{\code{Rscript} is available on your system}
}
}
\examples{
\dontrun{
  ## If your package source directory is "./pkg" you can run
  build_install_test("pkg")
}
}
\seealso{
Other test-files: 
\code{\link{exit_file}()},
\code{\link{run_test_dir}()},
\code{\link{run_test_file}()},
\code{\link{summary.tinytests}()},
\code{\link{test_package}()}
}
\concept{test-files}
