% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{addAuthorizedUser}
\alias{addAuthorizedUser}
\title{Add authorized user to application}
\usage{
addAuthorizedUser(
  email,
  appDir = getwd(),
  appName = NULL,
  account = NULL,
  server = NULL,
  sendEmail = NULL,
  emailMessage = NULL
)
}
\arguments{
\item{email}{Email address of user to add.}

\item{appDir}{Directory containing application. Defaults to
current working directory.}

\item{appName}{Name of application.}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{sendEmail}{Send an email letting the user know the application
has been shared with them.}

\item{emailMessage}{Optional character vector of length 1 containing a
custom message to send in email invitation. Defaults to NULL, which
will use default invitation message.}
}
\description{
Add authorized user to application
}
\note{
This function works only for ShinyApps servers.
}
\seealso{
\code{\link[=removeAuthorizedUser]{removeAuthorizedUser()}} and \code{\link[=showUsers]{showUsers()}}
}
