% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerpoint_presentation.R
\name{powerpoint_presentation}
\alias{powerpoint_presentation}
\title{Convert to a PowerPoint presentation}
\usage{
powerpoint_presentation(
  toc = FALSE,
  toc_depth = 2,
  number_sections = FALSE,
  fig_width = 5,
  fig_height = 4,
  fig_caption = TRUE,
  df_print = "default",
  keep_md = FALSE,
  md_extensions = NULL,
  slide_level = NULL,
  reference_doc = "default",
  pandoc_args = NULL
)
}
\arguments{
\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_depth}{Depth of headers to include in table of contents}

\item{number_sections}{\code{TRUE} to number section headings}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses a corresponding S3 method of \code{print}, typically
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}. See
\href{https://bookdown.org/yihui/rmarkdown/html-document.html#data-frame-printing}{Data
frame printing section} in bookdown book for examples.}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{slide_level}{The heading level which defines individual slides. By
default this is the highest header level in the hierarchy that is followed
immediately by content, and not another header, somewhere in the document.
This default can be overridden by specifying an explicit
\code{slide_level}.}

\item{reference_doc}{Path to a PowerPoint template.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to a PowerPoint presentation. Pandoc
v2.0.5 or above is required.
}
