% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-inject.R
\name{englue}
\alias{englue}
\title{Defuse function arguments with glue}
\usage{
englue(x)
}
\arguments{
\item{x}{A string to interpolate with glue operators.}
}
\description{
\code{englue()} creates a string with the \link[=glue-operators]{glue operators} \verb{\{} and \verb{\{\{}. These operators are
normally used to inject names within \link[=dyn-dots]{dynamic dots}.
\code{englue()} makes them available anywhere within a function.

\code{englue()} must be used inside a function. \code{englue("{{ var }}")}
\link[=topic-defuse]{defuses} the argument \code{var} and transforms it to a
string using the default name operation.
}
\details{
\code{englue("{{ var }}")} is equivalent to \code{as_label(enquo(var))}. It
\link[=topic-defuse]{defuses} \code{arg} and transforms the expression to a
string with \code{\link[=as_label]{as_label()}}.

In dynamic dots, using only \verb{\{} is allowed. In \code{englue()} you must
use \verb{\{\{} at least once. Use \code{glue::glue()} for simple
interpolation.

Before using \code{englue()} in a package, first ensure that glue is
installed by adding it to your \verb{Imports:} section.\if{html}{\out{<div class="sourceCode r">}}\preformatted{usethis::use_package("glue", "Imports")
}\if{html}{\out{</div>}}
}
\examples{
g <- function(var) englue("{{ var }}")
g(cyl)
g(1 + 1)
g(!!letters)

# These are equivalent to
as_label(quote(cyl))
as_label(quote(1 + 1))
as_label(letters)

}
\seealso{
\itemize{
\item \ifelse{html}{\link[=topic-inject]{Injecting with !!, !!!, and glue syntax}}{\link[=topic-inject]{Injecting with !!, !!!, and glue syntax}}
}
}
