% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_fields.R
\name{count_fields}
\alias{count_fields}
\title{Count the number of fields in each line of a file}
\usage{
count_fields(file, tokenizer, skip = 0, n_max = -1L)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path).}

\item{tokenizer}{A tokenizer that specifies how to break the \code{file}
up into fields, e.g., \code{\link[=tokenizer_csv]{tokenizer_csv()}},
\code{\link[=tokenizer_fwf]{tokenizer_fwf()}}}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Optionally, maximum number of rows to count fields for.}
}
\description{
This is useful for diagnosing problems with functions that fail
to parse correctly.
}
\examples{
count_fields(readr_example("mtcars.csv"), tokenizer_csv())
}
