% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_txtprogressbar.R
\name{handler_txtprogressbar}
\alias{handler_txtprogressbar}
\title{Progression Handler: Progress Reported as Plain Progress Bars (Text) in the Terminal}
\usage{
handler_txtprogressbar(
  style = 3L,
  file = stderr(),
  intrusiveness = getOption("progressr.intrusiveness.terminal", 1),
  target = "terminal",
  ...
)
}
\arguments{
\item{style}{(integer) The progress-bar style according to
\code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}.}

\item{file}{(connection) A \link[base:connections]{base::connection} to where output should be sent.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}.
}
\section{Appearance}{

Below is how this progress handler renders at 0\%, 30\% and 99\% progress
for the three different \code{style} values that \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}
supports.

With \code{handlers(handler_txtprogressbar(style = 1L))}:\if{html}{\out{<div class="sourceCode r">}}\preformatted{
====================================
==========================================================
}\if{html}{\out{</div>}}

With \code{handlers(handler_txtprogressbar(style = 2L))}:\if{html}{\out{<div class="sourceCode r">}}\preformatted{
====================================
==========================================================
}\if{html}{\out{</div>}}

With \code{handlers(handler_txtprogressbar(style = 3L))}:\if{html}{\out{<div class="sourceCode r">}}\preformatted{  |                                                 |   0\%
  |===============                                  |  30\%
  |=================================================|  99\%
}\if{html}{\out{</div>}}
}

\examples{
handlers("txtprogressbar")

with_progress({ y <- slow_sum(1:10) })
print(y)
}
