% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSeq.R
\name{simSeq}
\alias{simSeq}
\alias{simSeq.phylo}
\alias{simSeq.pml}
\title{Simulate sequences.}
\usage{
simSeq(x, ...)

\method{simSeq}{phylo}(x, l = 1000, Q = NULL, bf = NULL, rootseq = NULL,
  type = "DNA", model = NULL, levels = NULL, rate = 1,
  ancestral = FALSE, ...)

\method{simSeq}{pml}(x, ancestral = FALSE, ...)
}
\arguments{
\item{x}{a phylogenetic tree \code{tree}, i.e. an object of class
\code{phylo} or and object of class \code{pml}.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{l}{length of the sequence to simulate.}

\item{Q}{the rate matrix.}

\item{bf}{base frequencies.}

\item{rootseq}{a vector of length l containing the root sequence, other root
sequence is randomly generated.}

\item{type}{Type of sequences ("DNA", "AA" or "USER").}

\item{model}{Amino acid models: e.g. "WAG", "JTT", "Dayhoff" or "LG"}

\item{levels}{\code{levels} takes a character vector of the different bases,
default is for nucleotide sequences, only used when type = "USER".}

\item{rate}{mutation rate or scaler for the edge length, a numerical value
greater than zero.}

\item{ancestral}{Return ancestral sequences?}
}
\value{
\code{simSeq} returns an object of class phyDat.
}
\description{
Simulate sequences for a given evolutionary tree.
}
\details{
\code{simSeq} is now a generic function to simulate sequence alignments.  It
is quite flexible and allows to generate DNA, RNA, amino acids or binary
sequences.  It is possible to give a \code{pml} object as input simSeq
return a \code{phyDat} from these model.  There is also a more low level
version, which lacks rate variation, but one can combine different
alignments having their own rate (see example). The rate parameter acts like
a scaler for the edge lengths.
}
\examples{

\dontrun{
data(Laurasiatherian)
tree <- nj(dist.ml(Laurasiatherian))
fit <- pml(tree, Laurasiatherian, k=4)
fit <- optim.pml(fit, optNni=TRUE, model="GTR", optGamma=TRUE)
data <- simSeq(fit)
}

tree <- rtree(5)
plot(tree)
nodelabels()

# Example for simple DNA alignment
data <- simSeq(tree, l = 10, type="DNA", bf=c(.1,.2,.3,.4), Q=1:6)
as.character(data)

# Example to simulate discrete Gamma rate variation
rates <- discrete.gamma(1,4)
data1 <- simSeq(tree, l = 100, type="AA", model="WAG", rate=rates[1])
data2 <- simSeq(tree, l = 100, type="AA", model="WAG", rate=rates[2])
data3 <- simSeq(tree, l = 100, type="AA", model="WAG", rate=rates[3])
data4 <- simSeq(tree, l = 100, type="AA", model="WAG", rate=rates[4])
data <- c(data1,data2, data3, data4)

write.phyDat(data, file="temp.dat", format="sequential", nbcol = -1, 
  colsep = "")
unlink("temp.dat") 

}
\seealso{
\code{\link{phyDat}}, \code{\link{pml}}, \code{\link{SOWH.test}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
