% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{run_footnote}
\alias{run_footnote}
\title{Footnote for 'Word'}
\usage{
run_footnote(x, prop = NULL)
}
\arguments{
\item{x}{a set of blocks to be used as footnote content returned by
function \code{\link[=block_list]{block_list()}}.}

\item{prop}{formatting text properties returned by
\code{\link[=fp_text_lite]{fp_text_lite()}} or \code{\link[=fp_text]{fp_text()}}. It also can be NULL in
which case, no formatting is defined (the default is applied).}
}
\description{
Wraps a footnote in an object that can then be inserted
as a run/chunk with \code{\link[=fpar]{fpar()}} or within an R Markdown document.
}
\examples{
library(officer)

fp_bold <- fp_text_lite(bold = TRUE)
fp_refnote <- fp_text_lite(vertical.align = "superscript")

img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
bl <- block_list(
  fpar(ftext("hello", fp_bold)),
  fpar(
    ftext("hello world", fp_bold),
    external_img(src = img.file, height = 1.06, width = 1.39)
  )
)

a_par <- fpar(
  "this paragraph contains a note ",
  run_footnote(x = bl, prop = fp_refnote),
  "."
)

doc <- read_docx()
doc <- body_add_fpar(doc, value = a_par, style = "Normal")

print(doc, target = tempfile(fileext = ".docx"))
}
\seealso{
Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{ftext}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_comment}()},
\code{\link{run_footnoteref}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_word_field}()},
\code{\link{run_wordtext}()}
}
\concept{run functions for reporting}
