% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer.R
\name{nanoarrow_buffer_init}
\alias{nanoarrow_buffer_init}
\alias{nanoarrow_buffer_append}
\alias{convert_buffer}
\title{Create and modify nanoarrow buffers}
\usage{
nanoarrow_buffer_init()

nanoarrow_buffer_append(buffer, new_buffer)

convert_buffer(buffer, to = NULL)
}
\arguments{
\item{buffer, new_buffer}{\link[=as_nanoarrow_buffer]{nanoarrow_buffer}s.}

\item{to}{A target prototype object describing the type to which \code{array}
should be converted, or \code{NULL} to use the default conversion as
returned by \code{\link[=infer_nanoarrow_ptype]{infer_nanoarrow_ptype()}}. Alternatively, a function can be
passed to perform an alternative calculation of the default ptype as
a function of \code{array} and the default inference of the prototype.}
}
\value{
\itemize{
\item \code{nanoarrow_buffer_init()}: An object of class 'nanoarrow_buffer'
\item \code{nanoarrow_buffer_append()}: Returns \code{buffer}, invisibly. Note that
\code{buffer} is modified in place by reference.
}
}
\description{
Create and modify nanoarrow buffers
}
\examples{
buffer <- nanoarrow_buffer_init()
nanoarrow_buffer_append(buffer, 1:5)

array <- nanoarrow_array_modify(
  nanoarrow_array_init(na_int32()),
  list(length = 5, buffers = list(NULL, buffer))
)
as.vector(array)

}
