% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appenders.R
\name{appender_syslog}
\alias{appender_syslog}
\title{Send log messages to the POSIX system log}
\usage{
appender_syslog(identifier, ...)
}
\arguments{
\item{identifier}{A string identifying the process.}

\item{...}{Further arguments passed on to \code{\link[rsyslog:syslog]{rsyslog::open_syslog()}}.}
}
\value{
function taking \code{lines} argument
}
\description{
Send log messages to the POSIX system log
}
\note{
This functionality depends on the \pkg{rsyslog} package.
}
\examples{
\dontrun{
if (requireNamespace("rsyslog", quietly = TRUE)) {
  log_appender(appender_syslog("test"))
  log_info("Test message.")
}
}
}
\seealso{
Other log_appenders: 
\code{\link{appender_async}()},
\code{\link{appender_console}()},
\code{\link{appender_file}()},
\code{\link{appender_kinesis}()},
\code{\link{appender_pushbullet}()},
\code{\link{appender_slack}()},
\code{\link{appender_stdout}()},
\code{\link{appender_tee}()},
\code{\link{appender_telegram}()}
}
\concept{log_appenders}
