% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer64.R
\name{extract.replace.integer64}
\alias{extract.replace.integer64}
\alias{[.integer64}
\alias{[<-.integer64}
\alias{[[.integer64}
\alias{[[<-.integer64}
\title{Extract or Replace Parts of an integer64 vector}
\usage{
\method{[}{integer64}(x, i, ...)

\method{[}{integer64}(x, ...) <- value

\method{[[}{integer64}(x, ...)

\method{[[}{integer64}(x, ...) <- value
}
\arguments{
\item{x}{an atomic vector}

\item{i}{indices specifying elements to extract}

\item{...}{further arguments to the \code{\link[=NextMethod]{NextMethod()}}}

\item{value}{an atomic vector with values to be assigned}
}
\value{
A vector or scalar of class 'integer64'
}
\description{
Methods to extract and replace parts of an integer64 vector.
}
\note{
You should not subscript non-existing elements and not use \code{NA}s as subscripts.
The current implementation returns \code{9218868437227407266} instead of \code{NA}.
}
\examples{
  as.integer64(1:12)[1:3]
  x <- as.integer64(1:12)
  dim(x) <- c(3,4)
  x
  x[]
  x[,2:3]
}
\seealso{
\code{\link[base:Extract]{[}} \code{\link[=integer64]{integer64()}}
}
\keyword{classes}
\keyword{manip}
