context("List Formats")

test_that("Listing formats", {
  encoders <- av_encoders()
  decoders <- av_decoders()
  filters <- av_filters()
  muxers <- av_muxers()
  demuxers <- av_demuxers()
  expect_is(encoders, 'data.frame')
  expect_is(decoders, 'data.frame')
  expect_is(filters, 'data.frame')
  expect_is(muxers, 'data.frame')
  expect_is(demuxers, 'data.frame')
  expect_gt(nrow(encoders), 100)
  expect_gt(nrow(decoders), 400)
  expect_gt(nrow(filters), 300)
  expect_gt(nrow(muxers), 100)
  expect_gt(nrow(demuxers), 100)
  expect_equal(names(encoders), c("type", "name", "description", "format"))
  expect_equal(names(decoders), c("type", "name", "description", "format"))
  expect_equal(names(filters), c("name", "description"))
})
