% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateAverage.R
\name{calculateAverage}
\alias{calculateAverage}
\alias{calculateAverage,ANY-method}
\alias{calculateAverage,SummarizedExperiment-method}
\alias{calculateAverage,SingleCellExperiment-method}
\title{Calculate per-feature average counts}
\usage{
calculateAverage(x, ...)

\S4method{calculateAverage}{ANY}(
  x,
  size.factors = NULL,
  subset.row = NULL,
  BPPARAM = SerialParam(),
  size_factors = NULL,
  subset_row = NULL
)

\S4method{calculateAverage}{SummarizedExperiment}(x, ..., assay.type = "counts", exprs_values = NULL)

\S4method{calculateAverage}{SingleCellExperiment}(x, size.factors = NULL, ...)
}
\arguments{
\item{x}{A numeric matrix of counts where features are rows and columns are cells.

Alternatively, a \linkS4class{SummarizedExperiment} or a \linkS4class{SingleCellExperiment} containing such counts.}

\item{...}{For the generic, arguments to pass to specific methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.

For the SingleCellExperiment method, further arguments to pass to the SummarizedExperiment method.}

\item{size.factors}{A numeric vector containing size factors.
If \code{NULL}, these are calculated or extracted from \code{x}.}

\item{subset.row}{A vector specifying the subset of rows of \code{object} for which to return a result.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether the calculations should be parallelized.
Only relevant for parallelized \code{\link{rowSums}(x)}, e.g., for \linkS4class{DelayedMatrix} inputs.}

\item{size_factors, subset_row, exprs_values}{Soft-deprecated counterparts to the arguments above.}

\item{assay.type}{A string specifying the assay of \code{x} containing the count matrix.}
}
\value{
A numeric vector of average count values with same length as number of features 
(or the number of features in \code{subset_row} if supplied).
}
\description{
Calculate the average count for each feature after normalizing observations using per-cell size factors.
}
\details{
The size factor-adjusted average count is defined by dividing each count by the size factor and taking the average across cells.
All size factors are scaled so that the mean is 1 across all cells, to ensure that the averages are interpretable on the same scale of the raw counts. 

If no size factors are supplied, they are determined automatically:
\itemize{
\item For count matrices and \linkS4class{SummarizedExperiment} inputs,
the sum of counts for each cell is used to compute a size factor via the \code{\link{librarySizeFactors}} function.
\item For \linkS4class{SingleCellExperiment} instances, the function searches for \code{\link{sizeFactors}} from \code{x}.
If none are available, it defaults to library size-derived size factors.
}
If \code{size_factors} are supplied, they will override any size factors present in \code{x}.
}
\examples{
example_sce <- mockSCE()
ave_counts <- calculateAverage(example_sce)
summary(ave_counts)
}
\seealso{
\code{\link{librarySizeFactors}}, for the default calculation of size factors.

\code{\link{logNormCounts}}, for the calculation of normalized expression values.
}
\author{
Aaron Lun
}
