% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MairPBMCData.R
\name{MairPBMCData}
\alias{MairPBMCData}
\title{Obtain the Mair CITE-seq data}
\usage{
MairPBMCData(
  mode = c("rna", "adt"),
  ensembl = FALSE,
  location = TRUE,
  legacy = FALSE
)
}
\arguments{
\item{mode}{Character vector specifying whether to return either or both the RNA and ADT counts.}

\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of UMI counts corresponding to the first \code{mode},
with an optional alternative Experiment if there is a second \code{mode}.
}
\description{
Obtain the Mair PBMC targeted CITE-seq data from Mair et al. (2020).
}
\details{
Column metadata contains the donor identity and cartridge of origin.
Some libraries may also be classified as multiplets or have undeterminate origins after hash tag debarcoding.

If \code{ensembl=TRUE}, the gene symbols in the RNA data are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} for the RNA data.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/mair-pbmc}.
}
\examples{
sce <- MairPBMCData()

}
\references{
Mair C et al. (2020).
A targeted multi-omic analysis approach measures protein expression and low-abundance transcripts on the single-cell level.
\emph{Cell Rep.} 31, 107499
}
\author{
Stephany Orjuela,
with modifications from Aaron Lun
}
