\name{Saturation}
\alias{Saturation-class}
\alias{Saturation}
\alias{saturation}
\alias{explo.plot,Saturation-method}
\alias{show,Saturation-method}
\alias{dat2save,Saturation-method}
\docType{class}
\title{Saturation class}

\description{
Saturation class generated from dat() function with type="saturation". This object contains the number of detected features per biotype at 
increasing sequencing depths and also the new detections per each million of new sequencing reads.
}

\usage{
\S4method{explo.plot}{Saturation}(object, samples = NULL, toplot = 1, yleftlim = NULL, yrightlim = NULL, ...)
\S4method{dat2save}{Saturation}(object)
}

\arguments{
  \item{object}{
    Object generated from \code{dat()} function.
  }
   \item{toplot}{
    This parameter indicates which biological group is to be plotted.
    It may be a number or a text with the name of the biological group. 
    If toplot=1 (or "global"), a global plot considering features from all the biological groups will be generated.
  }
  \item{samples}{
    The samples to be plotted. If NULL, all the samples are plotted for Saturation object.
  }

  \item{yleftlim}{
    Range for Y left-axis (on the left-hand side of the plot) when new detections are plotted (this occurs when the number of samples to be plotted is 1 or 2). 
If NULL (default), an appropriate range is computed.    
    } 
  \item{yrightlim}{
    Range for Y right-axis (on the right-hand side of the plot) when new detections are plotted (this occurs when the number of samples to be plotted is 1 or 2). 
If NULL (default), an appropriate range is computed.    
    }
  \item{...}{
    Any argument from \code{par}.
  }     
}

\section{Slots/List Components}{
Objects of this class contain (at least) the following list components:

  \code{dat}: List containing the information generated by dat() function. This list has the following elements:
  
  \code{saturation}: List containing for all the biological classes (and also a global class with all of them together) the saturation data 
		     to be plotted for each sample (in Y left axis).

  \code{bionum}: Vector containing for all the biological classes (and also a global class with all of them together) the number of 
		 features for that group.
  
  \code{depth}: List containing for each selected sample the increasing values of sequencing depth to be plotted.

  \code{newdet}: List containing for all the biological classes (and also a global class with all of them together) the new detection data 
		 to be plotted for each selected sample (in Y right axis). 

  \code{real}: List with as many elements as the number of biological classes (plus one for the global). Each element contains the real sequencing depth for each sample and the corresponding number of detected features at that sequencing depth. 
}

\section{Methods}{
This class has an specific \code{show} method in order to work and print
a summary of the elements which are contained and a \code{dat2save} method
to save the relevant information in an object cleanly. It also has an
\code{explo.plot} method to plot the data contained in the object.
}

\author{Sonia Tarazona}

\keyword{classes}
