% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorModels.R
\name{getErrors}
\alias{getErrors}
\title{Extract already computed error rates.}
\usage{
getErrors(obj, detailed = FALSE, enforce = TRUE)
}
\arguments{
\item{obj}{(Required). An R object with error rates.
Supported objects: dada-class; list of dada-class; numeric matrix; named list with $err_out, $err_in, $trans.}

\item{detailed}{(Optional). Default FALSE.
If FALSE, an error rate matrix corresponding to $err_out is returned.
If TRUE, a named list with $err_out, $err_in and $trans. $err_in and $trans can be NULL.}

\item{enforce}{(Optional). Default TRUE.
If TRUE, will check validity of $err_out and error if invalid or NULL.}
}
\value{
A numeric matrix of error rates.
 Or, if detailed=TRUE, a named list with $err_out, $err_in and $trans.
}
\description{
Extract already computed error rates.
}
\examples{
 fl1 <- system.file("extdata", "sam1F.fastq.gz", package="dada2")
 drp <- derepFastq(fl1)
 dd <- dada(drp, err=NULL, selfConsist=TRUE)
 err <- getErrors(dd)

}
