% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AffinityParam.R
\docType{class}
\name{AffinityParam-class}
\alias{AffinityParam-class}
\alias{show,AffinityParam-method}
\alias{AffinityParam}
\alias{clusterRows,ANY,AffinityParam-method}
\title{Affinity propogation}
\usage{
AffinityParam(
  s = NULL,
  p = NA,
  q = NA,
  maxits = 1000,
  convits = 100,
  lam = 0.9,
  nonoise = FALSE
)

\S4method{clusterRows}{ANY,AffinityParam}(x, BLUSPARAM, full = FALSE)
}
\arguments{
\item{s}{A function that accepts a matrix of observations by dimensions and returns a similarity matrix.
If \code{NULL}, defaults to the output of \code{\link[apcluster]{negDistMat}} with \code{r=2}.}

\item{p, q}{Numeric scalars controlling the input preference, i.e., the resolution of the clustering.
These are passed to the \code{\link[apcluster]{apcluster}} function, where values of \code{NA} are the default.}

\item{maxits, convits, lam, nonoise}{Further arguments to pass to the \code{\link[apcluster]{apcluster}} function.}

\item{x}{A numeric matrix-like object where rows represent observations and columns represent variables.}

\item{BLUSPARAM}{A \linkS4class{AffinityParam} object.}

\item{full}{Logical scalar indicating whether the full affinity propagation statistics should be returned.}
}
\value{
The \code{AffinityParam} constructor will return a \linkS4class{AffinityParam} object with the specified parameters.

The \code{clusterRows} method will return a factor of length equal to \code{nrow(x)} containing the cluster assignments.
If \code{full=TRUE}, a list is returned with \code{clusters} (the factor, as above) and \code{objects}
(a list containing \code{similarity}, the similarity matrix; and \code{apcluster}, the direct output of \code{\link[apcluster]{apcluster}}).
}
\description{
Use affinity propagation from the \pkg{apcluster} package to cluster observations.
Note that this requires the installation of the \pkg{apcluster} package.
}
\details{
To modify an existing AffinityParam object \code{x},
users can simply call \code{x[[i]]} or \code{x[[i]] <- value} where \code{i} is any argument used in the constructor.

Setting \code{q} (and less typically, \code{p}) allows us to tune the resolution of the clustering.
In particular, when \code{p=NA}, it is computed based on the setting of \code{q}:
\itemize{
\item If the specified \code{q} lies in [0, 1], \code{p} is defined as the \code{q}-quantile of the finite similarities across all pairs of observations.
When \code{q=NA}, it defaults to 0.5.
\item If \code{q} is negative, \code{p} is defined as the \code{M + abs(M) * q} where \code{M} is the smallest finite similarity across all pairs.
This yields smaller \code{p} values while still responding to the scale of the similarities. 
}
The resulting value is used as the self-preference, i.e., the diagonal of the availability matrix.
Larger values yield more clusters as each data point is more inclined to form its own cluster.
}
\examples{
clusterRows(iris[,1:4], AffinityParam())
clusterRows(iris[,1:4], AffinityParam(q=0.9))
clusterRows(iris[,1:4], AffinityParam(s=apcluster::expSimMat()))

}
\seealso{
\code{\link[apcluster]{apcluster}} from the \pkg{apcluster} package, which does all of the heavy lifting.
}
\author{
Aaron Lun
}
