TEMPLATE = subdirs

isEmpty(JSONWIZARD_TR_H): JSONWIZARD_TR_H = $$OUT_PWD/jsonwizard_tr.h
isEmpty(TOP_LEVEL): TOP_LEVEL = "."

for(dir, $$list($$files($$TOP_LEVEL/*, true))): \
    JSONWIZARD_FILES += $$files($$dir/wizard.json)

defineReplace(findToTranslate) {
    ROOTKEY = $$1
    OUTPUT = ""
    for (KEY, $${ROOTKEY}._KEYS_) {
        SUBKEY = $${ROOTKEY}.$${KEY}
        MATCHED = $$find(KEY, ^tr[A-Z])
        !isEmpty(MATCHED) {
            VALUE = $$replace($${SUBKEY}, "\\n", "\\n")
            VALUE ~= s,\",\\\",
            OUTPUT += "QT_TRANSLATE_NOOP(\"ProjectExplorer::JsonWizard\", \"$${VALUE}\");"
        }
        OUTPUT += $$findToTranslate($${SUBKEY})
    }
    return($$OUTPUT)
}

WIZ_TRANS_FILE_CONT= \
    "// This file is autogenerated by qmake."

for (FILE, JSONWIZARD_FILES) {
    exists($$FILE) {
        JSON = $$cat($$FILE, blob)
        parseJson(JSON, WIZ)
        WIZ_TRANS_FILE_CONT += $$findToTranslate(WIZ)
    }
}

write_file($$JSONWIZARD_TR_H, WIZ_TRANS_FILE_CONT)|error("Aborting")
