# iCal export

[Home](index.md) / [Basic usage](basic.md) / [Advanced usage](advanced.md) / [Class options](class-options.md) / [ISO Registry](iso-registry.md) / [Contributing](contributing.md)

As of v11.0.0, you can export holidays generated by any Workalendar class to the iCal file format.

## Export and retrieve the content

In this example, we export all the public holidays for France from the year 2019 to the year 2022 (inclusive).

```python
>>> from workalendar.europe import France
>>> cal = France()
>>> ical_content = cal.export_to_ical(period=[2019, 2022])
>>> print(ical_content)
BEGIN:VCALENDAR
VERSION:2.0
PRODID:-//workalendar//ical 9.0.0//EN
BEGIN:VEVENT
SUMMARY:New year
DTSTART;VALUE=DATE:20190101
DTSTAMP;VALUE=DATE-TIME:20200828T152009Z
UID:2019-01-01New year@peopledoc.github.io/workalendar
END:VEVENT
BEGIN:VEVENT
SUMMARY:Easter Monday
DTSTART;VALUE=DATE:20190422
DTSTAMP;VALUE=DATE-TIME:20200828T152009Z
UID:2019-04-22Easter Monday@peopledoc.github.io/workalendar
END:VEVENT
BEGIN:VEVENT
SUMMARY:Labour Day
DTSTART;VALUE=DATE:20190501
DTSTAMP;VALUE=DATE-TIME:20200828T152009Z
UID:2019-05-01Labour Day@peopledoc.github.io/workalendar
END:VEVENT
# ...
```

You may store this content into a file, or do anything else you want with it.

If you don't provide any period, it defaults to [2000, 2030].

## Export and save it to a file

You can also directly save your ical export to a file. The following example writes a ``france.ics`` file to your disk, with the holidays between 2019 and 2022.

```python
>>> from workalendar.europe import France
>>> cal = France()
>>> cal.export_to_ical(period=[2019, 2022], target_path="france.ics")
```

**Note:** Please note that the export function won't work if the path is unwriteable or if it points at an existing directory.

### Known file extensions

The `target_path` argument may be provided with or without a file extension. For example, it can be either:

| `target_path` argument | filename generated |
|:-----------------------|:-------------------|
| `france`               | `france.ics`       |
| `france.ics`           | `france.ics`       |
| `france.ical`          | `france.ical`      |
| `france.ifb`           | `france.ifb`       |
| `france.icalendar`     | `france.icalendar` |
| `france.txt`           | `france.txt.ics`   |

As you see, we only add the `.ics` extension if the current `target_path` extension is not known.

[Home](index.md) / [Basic usage](basic.md) / [Advanced usage](advanced.md) / [Class options](class-options.md) / [ISO Registry](iso-registry.md) / [Contributing](contributing.md)
