# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of possible statuses for job or document."""

    NOT_STARTED = "NotStarted"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    CANCELLING = "Cancelling"
    VALIDATION_FAILED = "ValidationFailed"


class StorageInputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage type of the input documents source string."""

    FOLDER = "Folder"
    FILE = "File"


class StorageSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage Source."""

    AZURE_BLOB = "AzureBlob"


class TranslationErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enums containing high level error codes."""

    INVALID_REQUEST = "InvalidRequest"
    INVALID_ARGUMENT = "InvalidArgument"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    RESOURCE_NOT_FOUND = "ResourceNotFound"
    UNAUTHORIZED = "Unauthorized"
    REQUEST_RATE_TOO_HIGH = "RequestRateTooHigh"
