# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.streamanalytics import StreamAnalyticsManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-streamanalytics
# USAGE
    python create_a_complete_streaming_job_(a_streaming_job_with_a_transformation,_at_least_1_input_and_at_least_1_output).py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = StreamAnalyticsManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="56b5e0a9-b645-407d-99b0-c64f86013e3d",
    )

    response = client.streaming_jobs.begin_create_or_replace(
        resource_group_name="sjrg3276",
        job_name="sj7804",
        streaming_job={
            "location": "West US",
            "properties": {
                "compatibilityLevel": "1.0",
                "dataLocale": "en-US",
                "eventsLateArrivalMaxDelayInSeconds": 5,
                "eventsOutOfOrderMaxDelayInSeconds": 0,
                "eventsOutOfOrderPolicy": "Drop",
                "externals": {
                    "container": "mycontainer",
                    "path": "UserCustomCode.zip",
                    "refreshConfiguration": {
                        "dateFormat": "yyyy-dd-MM",
                        "pathPattern": "{date}\\\\{time}",
                        "refreshInterval": "00:01:00",
                        "refreshType": "Nonblocking",
                        "timeFormat": "HH",
                    },
                    "storageAccount": {"accountKey": "mykey", "accountName": "mystorageaccount"},
                },
                "functions": [],
                "inputs": [
                    {
                        "name": "inputtest",
                        "properties": {
                            "datasource": {
                                "properties": {
                                    "container": "containerName",
                                    "pathPattern": "",
                                    "storageAccounts": [
                                        {"accountKey": "yourAccountKey==", "accountName": "yourAccountName"}
                                    ],
                                },
                                "type": "Microsoft.Storage/Blob",
                            },
                            "serialization": {"properties": {"encoding": "UTF8"}, "type": "Json"},
                            "type": "Stream",
                        },
                    }
                ],
                "outputErrorPolicy": "Drop",
                "outputs": [
                    {
                        "name": "outputtest",
                        "properties": {
                            "datasource": {
                                "properties": {
                                    "database": "databaseName",
                                    "password": "userPassword",
                                    "server": "serverName",
                                    "table": "tableName",
                                    "user": "<user>",
                                },
                                "type": "Microsoft.Sql/Server/Database",
                            }
                        },
                    }
                ],
                "sku": {"name": "Standard"},
                "transformation": {
                    "name": "transformationtest",
                    "properties": {"query": "Select Id, Name from inputtest", "streamingUnits": 1},
                },
            },
            "tags": {"key1": "value1", "key3": "value3", "randomKey": "randomValue"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_Create_CompleteJob.json
if __name__ == "__main__":
    main()
