# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AddDisksProviderSpecificInput(_serialization.Model):
    """Add Disks provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AAddDisksInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"A2A": "A2AAddDisksInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AAddDisksInput(AddDisksProviderSpecificInput):
    """A2A add disk(s) input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar vm_disks: The list of vm disk details.
    :vartype vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
    :ivar vm_managed_disks: The list of vm managed disk details.
    :vartype vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "vm_disks": {"key": "vmDisks", "type": "[A2AVmDiskInputDetails]"},
        "vm_managed_disks": {"key": "vmManagedDisks", "type": "[A2AVmManagedDiskInputDetails]"},
    }

    def __init__(
        self,
        *,
        vm_disks: Optional[List["_models.A2AVmDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["_models.A2AVmManagedDiskInputDetails"]] = None,
        **kwargs
    ):
        """
        :keyword vm_disks: The list of vm disk details.
        :paramtype vm_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
        :keyword vm_managed_disks: The list of vm managed disk details.
        :paramtype vm_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks


class ApplyRecoveryPointProviderSpecificInput(_serialization.Model):
    """Provider specific input for apply recovery point.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AApplyRecoveryPointInput, A2ACrossClusterMigrationApplyRecoveryPointInput,
    HyperVReplicaAzureApplyRecoveryPointInput, InMageAzureV2ApplyRecoveryPointInput,
    InMageRcmApplyRecoveryPointInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AApplyRecoveryPointInput",
            "A2ACrossClusterMigration": "A2ACrossClusterMigrationApplyRecoveryPointInput",
            "HyperVReplicaAzure": "HyperVReplicaAzureApplyRecoveryPointInput",
            "InMageAzureV2": "InMageAzureV2ApplyRecoveryPointInput",
            "InMageRcm": "InMageRcmApplyRecoveryPointInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to A2A provider.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"


class ReplicationProviderSpecificContainerCreationInput(_serialization.Model):
    """Provider specific input for container creation operation.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AContainerCreationInput, A2ACrossClusterMigrationContainerCreationInput,
    VMwareCbtContainerCreationInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AContainerCreationInput",
            "A2ACrossClusterMigration": "A2ACrossClusterMigrationContainerCreationInput",
            "VMwareCbt": "VMwareCbtContainerCreationInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AContainerCreationInput(ReplicationProviderSpecificContainerCreationInput):
    """A2A cloud creation input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"


class ReplicationProviderSpecificContainerMappingInput(_serialization.Model):
    """Provider specific input for pairing operations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AContainerMappingInput, VMwareCbtContainerMappingInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"A2A": "A2AContainerMappingInput", "VMwareCbt": "VMwareCbtContainerMappingInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AContainerMappingInput(ReplicationProviderSpecificContainerMappingInput):
    """A2A container mapping input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar agent_auto_update_status: A value indicating whether the auto update is enabled. Known
     values are: "Disabled" and "Enabled".
    :vartype agent_auto_update_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
    :ivar automation_account_arm_id: The automation account arm id.
    :vartype automation_account_arm_id: str
    :ivar automation_account_authentication_type: A value indicating the type authentication to use
     for automation Account. Known values are: "RunAsAccount" and "SystemAssignedIdentity".
    :vartype automation_account_authentication_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "agent_auto_update_status": {"key": "agentAutoUpdateStatus", "type": "str"},
        "automation_account_arm_id": {"key": "automationAccountArmId", "type": "str"},
        "automation_account_authentication_type": {"key": "automationAccountAuthenticationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        agent_auto_update_status: Optional[Union[str, "_models.AgentAutoUpdateStatus"]] = None,
        automation_account_arm_id: Optional[str] = None,
        automation_account_authentication_type: Optional[
            Union[str, "_models.AutomationAccountAuthenticationType"]
        ] = None,
        **kwargs
    ):
        """
        :keyword agent_auto_update_status: A value indicating whether the auto update is enabled. Known
         values are: "Disabled" and "Enabled".
        :paramtype agent_auto_update_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
        :keyword automation_account_arm_id: The automation account arm id.
        :paramtype automation_account_arm_id: str
        :keyword automation_account_authentication_type: A value indicating the type authentication to
         use for automation Account. Known values are: "RunAsAccount" and "SystemAssignedIdentity".
        :paramtype automation_account_authentication_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.agent_auto_update_status = agent_auto_update_status
        self.automation_account_arm_id = automation_account_arm_id
        self.automation_account_authentication_type = automation_account_authentication_type


class CreateProtectionIntentProviderSpecificDetails(_serialization.Model):
    """Create protection intent provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2ACreateProtectionIntentInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"A2A": "A2ACreateProtectionIntentInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2ACreateProtectionIntentInput(
    CreateProtectionIntentProviderSpecificDetails
):  # pylint: disable=too-many-instance-attributes
    """A2A create protection intent input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar fabric_object_id: The fabric specific object Id of the virtual machine. Required.
    :vartype fabric_object_id: str
    :ivar primary_location: The primary location for the virtual machine. Required.
    :vartype primary_location: str
    :ivar recovery_location: The recovery location for the virtual machine. Required.
    :vartype recovery_location: str
    :ivar recovery_subscription_id: The recovery subscription Id of the virtual machine. Required.
    :vartype recovery_subscription_id: str
    :ivar recovery_availability_type: The recovery availability type of the virtual machine.
     Required. Known values are: "Single", "AvailabilitySet", and "AvailabilityZone".
    :vartype recovery_availability_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.A2ARecoveryAvailabilityType
    :ivar protection_profile_custom_input: The protection profile custom inputs.
    :vartype protection_profile_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionProfileCustomDetails
    :ivar recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
     Required.
    :vartype recovery_resource_group_id: str
    :ivar primary_staging_storage_account_custom_input: The primary staging storage account input.
    :vartype primary_staging_storage_account_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :ivar recovery_availability_set_custom_input: The recovery availability set input.
    :vartype recovery_availability_set_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryAvailabilitySetCustomDetails
    :ivar recovery_virtual_network_custom_input: The recovery virtual network input.
    :vartype recovery_virtual_network_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryVirtualNetworkCustomDetails
    :ivar recovery_proximity_placement_group_custom_input: The recovery proximity placement group
     custom input.
    :vartype recovery_proximity_placement_group_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryProximityPlacementGroupCustomDetails
    :ivar auto_protection_of_data_disk: A value indicating whether the auto protection is enabled.
     Known values are: "Disabled" and "Enabled".
    :vartype auto_protection_of_data_disk: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
    :ivar vm_disks: The list of vm disk inputs.
    :vartype vm_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentDiskInputDetails]
    :ivar vm_managed_disks: The list of vm managed disk inputs.
    :vartype vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentManagedDiskInputDetails]
    :ivar multi_vm_group_name: The multi vm group name.
    :vartype multi_vm_group_name: str
    :ivar multi_vm_group_id: The multi vm group id.
    :vartype multi_vm_group_id: str
    :ivar recovery_boot_diag_storage_account: The boot diagnostic storage account.
    :vartype recovery_boot_diag_storage_account:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :ivar disk_encryption_info: The recovery disk encryption information (for two pass flows).
    :vartype disk_encryption_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :ivar recovery_availability_zone: The recovery availability zone.
    :vartype recovery_availability_zone: str
    :ivar agent_auto_update_status: A value indicating whether the auto update is enabled. Known
     values are: "Disabled" and "Enabled".
    :vartype agent_auto_update_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
    :ivar automation_account_authentication_type: A value indicating the authentication type for
     automation account. The default value is "RunAsAccount". Known values are: "RunAsAccount" and
     "SystemAssignedIdentity".
    :vartype automation_account_authentication_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
    :ivar automation_account_arm_id: The automation account arm id.
    :vartype automation_account_arm_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "fabric_object_id": {"required": True},
        "primary_location": {"required": True},
        "recovery_location": {"required": True},
        "recovery_subscription_id": {"required": True},
        "recovery_availability_type": {"required": True},
        "recovery_resource_group_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "primary_location": {"key": "primaryLocation", "type": "str"},
        "recovery_location": {"key": "recoveryLocation", "type": "str"},
        "recovery_subscription_id": {"key": "recoverySubscriptionId", "type": "str"},
        "recovery_availability_type": {"key": "recoveryAvailabilityType", "type": "str"},
        "protection_profile_custom_input": {
            "key": "protectionProfileCustomInput",
            "type": "ProtectionProfileCustomDetails",
        },
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
        "primary_staging_storage_account_custom_input": {
            "key": "primaryStagingStorageAccountCustomInput",
            "type": "StorageAccountCustomDetails",
        },
        "recovery_availability_set_custom_input": {
            "key": "recoveryAvailabilitySetCustomInput",
            "type": "RecoveryAvailabilitySetCustomDetails",
        },
        "recovery_virtual_network_custom_input": {
            "key": "recoveryVirtualNetworkCustomInput",
            "type": "RecoveryVirtualNetworkCustomDetails",
        },
        "recovery_proximity_placement_group_custom_input": {
            "key": "recoveryProximityPlacementGroupCustomInput",
            "type": "RecoveryProximityPlacementGroupCustomDetails",
        },
        "auto_protection_of_data_disk": {"key": "autoProtectionOfDataDisk", "type": "str"},
        "vm_disks": {"key": "vmDisks", "type": "[A2AProtectionIntentDiskInputDetails]"},
        "vm_managed_disks": {"key": "vmManagedDisks", "type": "[A2AProtectionIntentManagedDiskInputDetails]"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "multi_vm_group_id": {"key": "multiVmGroupId", "type": "str"},
        "recovery_boot_diag_storage_account": {
            "key": "recoveryBootDiagStorageAccount",
            "type": "StorageAccountCustomDetails",
        },
        "disk_encryption_info": {"key": "diskEncryptionInfo", "type": "DiskEncryptionInfo"},
        "recovery_availability_zone": {"key": "recoveryAvailabilityZone", "type": "str"},
        "agent_auto_update_status": {"key": "agentAutoUpdateStatus", "type": "str"},
        "automation_account_authentication_type": {"key": "automationAccountAuthenticationType", "type": "str"},
        "automation_account_arm_id": {"key": "automationAccountArmId", "type": "str"},
    }

    def __init__(
        self,
        *,
        fabric_object_id: str,
        primary_location: str,
        recovery_location: str,
        recovery_subscription_id: str,
        recovery_availability_type: Union[str, "_models.A2ARecoveryAvailabilityType"],
        recovery_resource_group_id: str,
        protection_profile_custom_input: Optional["_models.ProtectionProfileCustomDetails"] = None,
        primary_staging_storage_account_custom_input: Optional["_models.StorageAccountCustomDetails"] = None,
        recovery_availability_set_custom_input: Optional["_models.RecoveryAvailabilitySetCustomDetails"] = None,
        recovery_virtual_network_custom_input: Optional["_models.RecoveryVirtualNetworkCustomDetails"] = None,
        recovery_proximity_placement_group_custom_input: Optional[
            "_models.RecoveryProximityPlacementGroupCustomDetails"
        ] = None,
        auto_protection_of_data_disk: Optional[Union[str, "_models.AutoProtectionOfDataDisk"]] = None,
        vm_disks: Optional[List["_models.A2AProtectionIntentDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["_models.A2AProtectionIntentManagedDiskInputDetails"]] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        recovery_boot_diag_storage_account: Optional["_models.StorageAccountCustomDetails"] = None,
        disk_encryption_info: Optional["_models.DiskEncryptionInfo"] = None,
        recovery_availability_zone: Optional[str] = None,
        agent_auto_update_status: Optional[Union[str, "_models.AgentAutoUpdateStatus"]] = None,
        automation_account_authentication_type: Optional[
            Union[str, "_models.AutomationAccountAuthenticationType"]
        ] = None,
        automation_account_arm_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword fabric_object_id: The fabric specific object Id of the virtual machine. Required.
        :paramtype fabric_object_id: str
        :keyword primary_location: The primary location for the virtual machine. Required.
        :paramtype primary_location: str
        :keyword recovery_location: The recovery location for the virtual machine. Required.
        :paramtype recovery_location: str
        :keyword recovery_subscription_id: The recovery subscription Id of the virtual machine.
         Required.
        :paramtype recovery_subscription_id: str
        :keyword recovery_availability_type: The recovery availability type of the virtual machine.
         Required. Known values are: "Single", "AvailabilitySet", and "AvailabilityZone".
        :paramtype recovery_availability_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.A2ARecoveryAvailabilityType
        :keyword protection_profile_custom_input: The protection profile custom inputs.
        :paramtype protection_profile_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionProfileCustomDetails
        :keyword recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
         Required.
        :paramtype recovery_resource_group_id: str
        :keyword primary_staging_storage_account_custom_input: The primary staging storage account
         input.
        :paramtype primary_staging_storage_account_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
        :keyword recovery_availability_set_custom_input: The recovery availability set input.
        :paramtype recovery_availability_set_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryAvailabilitySetCustomDetails
        :keyword recovery_virtual_network_custom_input: The recovery virtual network input.
        :paramtype recovery_virtual_network_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryVirtualNetworkCustomDetails
        :keyword recovery_proximity_placement_group_custom_input: The recovery proximity placement
         group custom input.
        :paramtype recovery_proximity_placement_group_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryProximityPlacementGroupCustomDetails
        :keyword auto_protection_of_data_disk: A value indicating whether the auto protection is
         enabled. Known values are: "Disabled" and "Enabled".
        :paramtype auto_protection_of_data_disk: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
        :keyword vm_disks: The list of vm disk inputs.
        :paramtype vm_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentDiskInputDetails]
        :keyword vm_managed_disks: The list of vm managed disk inputs.
        :paramtype vm_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentManagedDiskInputDetails]
        :keyword multi_vm_group_name: The multi vm group name.
        :paramtype multi_vm_group_name: str
        :keyword multi_vm_group_id: The multi vm group id.
        :paramtype multi_vm_group_id: str
        :keyword recovery_boot_diag_storage_account: The boot diagnostic storage account.
        :paramtype recovery_boot_diag_storage_account:
         ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
        :keyword disk_encryption_info: The recovery disk encryption information (for two pass flows).
        :paramtype disk_encryption_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
        :keyword recovery_availability_zone: The recovery availability zone.
        :paramtype recovery_availability_zone: str
        :keyword agent_auto_update_status: A value indicating whether the auto update is enabled. Known
         values are: "Disabled" and "Enabled".
        :paramtype agent_auto_update_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
        :keyword automation_account_authentication_type: A value indicating the authentication type for
         automation account. The default value is "RunAsAccount". Known values are: "RunAsAccount" and
         "SystemAssignedIdentity".
        :paramtype automation_account_authentication_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
        :keyword automation_account_arm_id: The automation account arm id.
        :paramtype automation_account_arm_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.fabric_object_id = fabric_object_id
        self.primary_location = primary_location
        self.recovery_location = recovery_location
        self.recovery_subscription_id = recovery_subscription_id
        self.recovery_availability_type = recovery_availability_type
        self.protection_profile_custom_input = protection_profile_custom_input
        self.recovery_resource_group_id = recovery_resource_group_id
        self.primary_staging_storage_account_custom_input = primary_staging_storage_account_custom_input
        self.recovery_availability_set_custom_input = recovery_availability_set_custom_input
        self.recovery_virtual_network_custom_input = recovery_virtual_network_custom_input
        self.recovery_proximity_placement_group_custom_input = recovery_proximity_placement_group_custom_input
        self.auto_protection_of_data_disk = auto_protection_of_data_disk
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_group_id = multi_vm_group_id
        self.recovery_boot_diag_storage_account = recovery_boot_diag_storage_account
        self.disk_encryption_info = disk_encryption_info
        self.recovery_availability_zone = recovery_availability_zone
        self.agent_auto_update_status = agent_auto_update_status
        self.automation_account_authentication_type = automation_account_authentication_type
        self.automation_account_arm_id = automation_account_arm_id


class A2ACrossClusterMigrationApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to A2ACrossClusterMigration provider.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "A2ACrossClusterMigration"


class A2ACrossClusterMigrationContainerCreationInput(ReplicationProviderSpecificContainerCreationInput):
    """A2ACrossClusterMigration cloud creation input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "A2ACrossClusterMigration"


class EnableProtectionProviderSpecificInput(_serialization.Model):
    """Enable protection provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AEnableProtectionInput, A2ACrossClusterMigrationEnableProtectionInput,
    HyperVReplicaAzureEnableProtectionInput, InMageEnableProtectionInput,
    InMageAzureV2EnableProtectionInput, InMageRcmEnableProtectionInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AEnableProtectionInput",
            "A2ACrossClusterMigration": "A2ACrossClusterMigrationEnableProtectionInput",
            "HyperVReplicaAzure": "HyperVReplicaAzureEnableProtectionInput",
            "InMage": "InMageEnableProtectionInput",
            "InMageAzureV2": "InMageAzureV2EnableProtectionInput",
            "InMageRcm": "InMageRcmEnableProtectionInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2ACrossClusterMigrationEnableProtectionInput(EnableProtectionProviderSpecificInput):
    """A2A Cross-Cluster Migration enable protection input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar fabric_object_id: The fabric specific object Id of the virtual machine.
    :vartype fabric_object_id: str
    :ivar recovery_container_id: The recovery container Id.
    :vartype recovery_container_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "recovery_container_id": {"key": "recoveryContainerId", "type": "str"},
    }

    def __init__(
        self, *, fabric_object_id: Optional[str] = None, recovery_container_id: Optional[str] = None, **kwargs
    ):
        """
        :keyword fabric_object_id: The fabric specific object Id of the virtual machine.
        :paramtype fabric_object_id: str
        :keyword recovery_container_id: The recovery container Id.
        :paramtype recovery_container_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2ACrossClusterMigration"
        self.fabric_object_id = fabric_object_id
        self.recovery_container_id = recovery_container_id


class PolicyProviderSpecificInput(_serialization.Model):
    """Base class for provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2APolicyCreationInput, A2ACrossClusterMigrationPolicyCreationInput, HyperVReplicaPolicyInput,
    HyperVReplicaAzurePolicyInput, InMagePolicyInput, InMageAzureV2PolicyInput,
    InMageRcmPolicyCreationInput, InMageRcmFailbackPolicyCreationInput,
    VMwareCbtPolicyCreationInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2APolicyCreationInput",
            "A2ACrossClusterMigration": "A2ACrossClusterMigrationPolicyCreationInput",
            "HyperVReplica2012": "HyperVReplicaPolicyInput",
            "HyperVReplicaAzure": "HyperVReplicaAzurePolicyInput",
            "InMage": "InMagePolicyInput",
            "InMageAzureV2": "InMageAzureV2PolicyInput",
            "InMageRcm": "InMageRcmPolicyCreationInput",
            "InMageRcmFailback": "InMageRcmFailbackPolicyCreationInput",
            "VMwareCbt": "VMwareCbtPolicyCreationInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2ACrossClusterMigrationPolicyCreationInput(PolicyProviderSpecificInput):
    """A2A Cross-Cluster Migration Policy creation input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "A2ACrossClusterMigration"


class ReplicationProviderSpecificSettings(_serialization.Model):
    """Replication provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AReplicationDetails, A2ACrossClusterMigrationReplicationDetails,
    HyperVReplicaReplicationDetails, HyperVReplicaBlueReplicationDetails,
    HyperVReplicaAzureReplicationDetails, HyperVReplicaBaseReplicationDetails,
    InMageReplicationDetails, InMageAzureV2ReplicationDetails, InMageRcmReplicationDetails,
    InMageRcmFailbackReplicationDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AReplicationDetails",
            "A2ACrossClusterMigration": "A2ACrossClusterMigrationReplicationDetails",
            "HyperVReplica2012": "HyperVReplicaReplicationDetails",
            "HyperVReplica2012R2": "HyperVReplicaBlueReplicationDetails",
            "HyperVReplicaAzure": "HyperVReplicaAzureReplicationDetails",
            "HyperVReplicaBaseReplicationDetails": "HyperVReplicaBaseReplicationDetails",
            "InMage": "InMageReplicationDetails",
            "InMageAzureV2": "InMageAzureV2ReplicationDetails",
            "InMageRcm": "InMageRcmReplicationDetails",
            "InMageRcmFailback": "InMageRcmFailbackReplicationDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2ACrossClusterMigrationReplicationDetails(ReplicationProviderSpecificSettings):
    """A2A provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar fabric_object_id: The fabric specific object Id of the virtual machine.
    :vartype fabric_object_id: str
    :ivar primary_fabric_location: Primary fabric location.
    :vartype primary_fabric_location: str
    :ivar os_type: The type of operating system.
    :vartype os_type: str
    :ivar vm_protection_state: The protection state for the vm.
    :vartype vm_protection_state: str
    :ivar vm_protection_state_description: The protection state description for the vm.
    :vartype vm_protection_state_description: str
    :ivar lifecycle_id: An id associated with the PE that survives actions like switch protection
     which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to
     have a link/continuity in being able to have an Id that denotes the "same" protected item even
     though other internal Ids/ARM Id might be changing.
    :vartype lifecycle_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "primary_fabric_location": {"key": "primaryFabricLocation", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "vm_protection_state": {"key": "vmProtectionState", "type": "str"},
        "vm_protection_state_description": {"key": "vmProtectionStateDescription", "type": "str"},
        "lifecycle_id": {"key": "lifecycleId", "type": "str"},
    }

    def __init__(
        self,
        *,
        fabric_object_id: Optional[str] = None,
        primary_fabric_location: Optional[str] = None,
        os_type: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        lifecycle_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword fabric_object_id: The fabric specific object Id of the virtual machine.
        :paramtype fabric_object_id: str
        :keyword primary_fabric_location: Primary fabric location.
        :paramtype primary_fabric_location: str
        :keyword os_type: The type of operating system.
        :paramtype os_type: str
        :keyword vm_protection_state: The protection state for the vm.
        :paramtype vm_protection_state: str
        :keyword vm_protection_state_description: The protection state description for the vm.
        :paramtype vm_protection_state_description: str
        :keyword lifecycle_id: An id associated with the PE that survives actions like switch
         protection which change the backing PE/CPE objects internally.The lifecycle id gets carried
         forward to have a link/continuity in being able to have an Id that denotes the "same" protected
         item even though other internal Ids/ARM Id might be changing.
        :paramtype lifecycle_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2ACrossClusterMigration"
        self.fabric_object_id = fabric_object_id
        self.primary_fabric_location = primary_fabric_location
        self.os_type = os_type
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.lifecycle_id = lifecycle_id


class A2AEnableProtectionInput(EnableProtectionProviderSpecificInput):  # pylint: disable=too-many-instance-attributes
    """A2A enable protection input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar fabric_object_id: The fabric specific object Id of the virtual machine. Required.
    :vartype fabric_object_id: str
    :ivar recovery_container_id: The recovery container Id.
    :vartype recovery_container_id: str
    :ivar recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
    :vartype recovery_resource_group_id: str
    :ivar recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
    :vartype recovery_cloud_service_id: str
    :ivar recovery_availability_set_id: The recovery availability set Id.
    :vartype recovery_availability_set_id: str
    :ivar recovery_proximity_placement_group_id: The recovery proximity placement group Id.
    :vartype recovery_proximity_placement_group_id: str
    :ivar vm_disks: The list of vm disk details.
    :vartype vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
    :ivar vm_managed_disks: The list of vm managed disk details.
    :vartype vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
    :ivar multi_vm_group_name: The multi vm group name.
    :vartype multi_vm_group_name: str
    :ivar multi_vm_group_id: The multi vm group id.
    :vartype multi_vm_group_id: str
    :ivar recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
    :vartype recovery_boot_diag_storage_account_id: str
    :ivar disk_encryption_info: The recovery disk encryption information (for two pass flows).
    :vartype disk_encryption_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :ivar recovery_availability_zone: The recovery availability zone.
    :vartype recovery_availability_zone: str
    :ivar recovery_extended_location: The recovery extended location.
    :vartype recovery_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    :ivar recovery_azure_network_id: The recovery Azure virtual network ARM id.
    :vartype recovery_azure_network_id: str
    :ivar recovery_subnet_name: The recovery subnet name.
    :vartype recovery_subnet_name: str
    :ivar recovery_virtual_machine_scale_set_id: The virtual machine scale set Id.
    :vartype recovery_virtual_machine_scale_set_id: str
    :ivar recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
    :vartype recovery_capacity_reservation_group_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "fabric_object_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "recovery_container_id": {"key": "recoveryContainerId", "type": "str"},
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
        "recovery_cloud_service_id": {"key": "recoveryCloudServiceId", "type": "str"},
        "recovery_availability_set_id": {"key": "recoveryAvailabilitySetId", "type": "str"},
        "recovery_proximity_placement_group_id": {"key": "recoveryProximityPlacementGroupId", "type": "str"},
        "vm_disks": {"key": "vmDisks", "type": "[A2AVmDiskInputDetails]"},
        "vm_managed_disks": {"key": "vmManagedDisks", "type": "[A2AVmManagedDiskInputDetails]"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "multi_vm_group_id": {"key": "multiVmGroupId", "type": "str"},
        "recovery_boot_diag_storage_account_id": {"key": "recoveryBootDiagStorageAccountId", "type": "str"},
        "disk_encryption_info": {"key": "diskEncryptionInfo", "type": "DiskEncryptionInfo"},
        "recovery_availability_zone": {"key": "recoveryAvailabilityZone", "type": "str"},
        "recovery_extended_location": {"key": "recoveryExtendedLocation", "type": "ExtendedLocation"},
        "recovery_azure_network_id": {"key": "recoveryAzureNetworkId", "type": "str"},
        "recovery_subnet_name": {"key": "recoverySubnetName", "type": "str"},
        "recovery_virtual_machine_scale_set_id": {"key": "recoveryVirtualMachineScaleSetId", "type": "str"},
        "recovery_capacity_reservation_group_id": {"key": "recoveryCapacityReservationGroupId", "type": "str"},
    }

    def __init__(
        self,
        *,
        fabric_object_id: str,
        recovery_container_id: Optional[str] = None,
        recovery_resource_group_id: Optional[str] = None,
        recovery_cloud_service_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        recovery_proximity_placement_group_id: Optional[str] = None,
        vm_disks: Optional[List["_models.A2AVmDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["_models.A2AVmManagedDiskInputDetails"]] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        recovery_boot_diag_storage_account_id: Optional[str] = None,
        disk_encryption_info: Optional["_models.DiskEncryptionInfo"] = None,
        recovery_availability_zone: Optional[str] = None,
        recovery_extended_location: Optional["_models.ExtendedLocation"] = None,
        recovery_azure_network_id: Optional[str] = None,
        recovery_subnet_name: Optional[str] = None,
        recovery_virtual_machine_scale_set_id: Optional[str] = None,
        recovery_capacity_reservation_group_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword fabric_object_id: The fabric specific object Id of the virtual machine. Required.
        :paramtype fabric_object_id: str
        :keyword recovery_container_id: The recovery container Id.
        :paramtype recovery_container_id: str
        :keyword recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
        :paramtype recovery_resource_group_id: str
        :keyword recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
        :paramtype recovery_cloud_service_id: str
        :keyword recovery_availability_set_id: The recovery availability set Id.
        :paramtype recovery_availability_set_id: str
        :keyword recovery_proximity_placement_group_id: The recovery proximity placement group Id.
        :paramtype recovery_proximity_placement_group_id: str
        :keyword vm_disks: The list of vm disk details.
        :paramtype vm_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
        :keyword vm_managed_disks: The list of vm managed disk details.
        :paramtype vm_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
        :keyword multi_vm_group_name: The multi vm group name.
        :paramtype multi_vm_group_name: str
        :keyword multi_vm_group_id: The multi vm group id.
        :paramtype multi_vm_group_id: str
        :keyword recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
        :paramtype recovery_boot_diag_storage_account_id: str
        :keyword disk_encryption_info: The recovery disk encryption information (for two pass flows).
        :paramtype disk_encryption_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
        :keyword recovery_availability_zone: The recovery availability zone.
        :paramtype recovery_availability_zone: str
        :keyword recovery_extended_location: The recovery extended location.
        :paramtype recovery_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        :keyword recovery_azure_network_id: The recovery Azure virtual network ARM id.
        :paramtype recovery_azure_network_id: str
        :keyword recovery_subnet_name: The recovery subnet name.
        :paramtype recovery_subnet_name: str
        :keyword recovery_virtual_machine_scale_set_id: The virtual machine scale set Id.
        :paramtype recovery_virtual_machine_scale_set_id: str
        :keyword recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
        :paramtype recovery_capacity_reservation_group_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.fabric_object_id = fabric_object_id
        self.recovery_container_id = recovery_container_id
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_cloud_service_id = recovery_cloud_service_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_group_id = multi_vm_group_id
        self.recovery_boot_diag_storage_account_id = recovery_boot_diag_storage_account_id
        self.disk_encryption_info = disk_encryption_info
        self.recovery_availability_zone = recovery_availability_zone
        self.recovery_extended_location = recovery_extended_location
        self.recovery_azure_network_id = recovery_azure_network_id
        self.recovery_subnet_name = recovery_subnet_name
        self.recovery_virtual_machine_scale_set_id = recovery_virtual_machine_scale_set_id
        self.recovery_capacity_reservation_group_id = recovery_capacity_reservation_group_id


class EventProviderSpecificDetails(_serialization.Model):
    """Model class for provider specific details for an event.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AEventDetails, HyperVReplica2012EventDetails, HyperVReplica2012R2EventDetails,
    HyperVReplicaAzureEventDetails, HyperVReplicaBaseEventDetails, InMageAzureV2EventDetails,
    InMageRcmEventDetails, InMageRcmFailbackEventDetails, VMwareCbtEventDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AEventDetails",
            "HyperVReplica2012": "HyperVReplica2012EventDetails",
            "HyperVReplica2012R2": "HyperVReplica2012R2EventDetails",
            "HyperVReplicaAzure": "HyperVReplicaAzureEventDetails",
            "HyperVReplicaBaseEventDetails": "HyperVReplicaBaseEventDetails",
            "InMageAzureV2": "InMageAzureV2EventDetails",
            "InMageRcm": "InMageRcmEventDetails",
            "InMageRcmFailback": "InMageRcmFailbackEventDetails",
            "VMwareCbt": "VMwareCbtEventDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AEventDetails(EventProviderSpecificDetails):
    """Model class for event details of a A2A event.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar protected_item_name: The protected item arm name.
    :vartype protected_item_name: str
    :ivar fabric_object_id: The azure vm arm id.
    :vartype fabric_object_id: str
    :ivar fabric_name: Fabric arm name.
    :vartype fabric_name: str
    :ivar fabric_location: The fabric location.
    :vartype fabric_location: str
    :ivar remote_fabric_name: Remote fabric arm name.
    :vartype remote_fabric_name: str
    :ivar remote_fabric_location: Remote fabric location.
    :vartype remote_fabric_location: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "protected_item_name": {"key": "protectedItemName", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "fabric_location": {"key": "fabricLocation", "type": "str"},
        "remote_fabric_name": {"key": "remoteFabricName", "type": "str"},
        "remote_fabric_location": {"key": "remoteFabricLocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        protected_item_name: Optional[str] = None,
        fabric_object_id: Optional[str] = None,
        fabric_name: Optional[str] = None,
        fabric_location: Optional[str] = None,
        remote_fabric_name: Optional[str] = None,
        remote_fabric_location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword protected_item_name: The protected item arm name.
        :paramtype protected_item_name: str
        :keyword fabric_object_id: The azure vm arm id.
        :paramtype fabric_object_id: str
        :keyword fabric_name: Fabric arm name.
        :paramtype fabric_name: str
        :keyword fabric_location: The fabric location.
        :paramtype fabric_location: str
        :keyword remote_fabric_name: Remote fabric arm name.
        :paramtype remote_fabric_name: str
        :keyword remote_fabric_location: Remote fabric location.
        :paramtype remote_fabric_location: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.protected_item_name = protected_item_name
        self.fabric_object_id = fabric_object_id
        self.fabric_name = fabric_name
        self.fabric_location = fabric_location
        self.remote_fabric_name = remote_fabric_name
        self.remote_fabric_location = remote_fabric_location


class A2AExtendedLocationDetails(_serialization.Model):
    """ExtendedLocation details data.

    :ivar primary_extended_location: The primary ExtendedLocation.
    :vartype primary_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    :ivar recovery_extended_location: The recovery ExtendedLocation.
    :vartype recovery_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    """

    _attribute_map = {
        "primary_extended_location": {"key": "primaryExtendedLocation", "type": "ExtendedLocation"},
        "recovery_extended_location": {"key": "recoveryExtendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        primary_extended_location: Optional["_models.ExtendedLocation"] = None,
        recovery_extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs
    ):
        """
        :keyword primary_extended_location: The primary ExtendedLocation.
        :paramtype primary_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        :keyword recovery_extended_location: The recovery ExtendedLocation.
        :paramtype recovery_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        """
        super().__init__(**kwargs)
        self.primary_extended_location = primary_extended_location
        self.recovery_extended_location = recovery_extended_location


class A2APolicyCreationInput(PolicyProviderSpecificInput):
    """A2A Policy creation input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :vartype recovery_point_history: int
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :vartype app_consistent_frequency_in_minutes: int
    :ivar multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled. Value
     should be 'Enabled' or 'Disabled'. Required. Known values are: "Enable" and "Disable".
    :vartype multi_vm_sync_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
    """

    _validation = {
        "instance_type": {"required": True},
        "multi_vm_sync_status": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_history": {"key": "recoveryPointHistory", "type": "int"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        multi_vm_sync_status: Union[str, "_models.SetMultiVmSyncStatus"],
        recovery_point_history: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_history: The duration in minutes until which the recovery points need
         to be stored.
        :paramtype recovery_point_history: int
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
         minutes).
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in
         minutes).
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
         Value should be 'Enabled' or 'Disabled'. Required. Known values are: "Enable" and "Disable".
        :paramtype multi_vm_sync_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_point_history = recovery_point_history
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class PolicyProviderSpecificDetails(_serialization.Model):
    """Base class for Provider specific details for policies.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2APolicyDetails, HyperVReplicaPolicyDetails, HyperVReplicaBluePolicyDetails,
    HyperVReplicaAzurePolicyDetails, HyperVReplicaBasePolicyDetails, InMagePolicyDetails,
    InMageAzureV2PolicyDetails, InMageBasePolicyDetails, InMageRcmPolicyDetails,
    InMageRcmFailbackPolicyDetails, VmwareCbtPolicyDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2APolicyDetails",
            "HyperVReplica2012": "HyperVReplicaPolicyDetails",
            "HyperVReplica2012R2": "HyperVReplicaBluePolicyDetails",
            "HyperVReplicaAzure": "HyperVReplicaAzurePolicyDetails",
            "HyperVReplicaBasePolicyDetails": "HyperVReplicaBasePolicyDetails",
            "InMage": "InMagePolicyDetails",
            "InMageAzureV2": "InMageAzureV2PolicyDetails",
            "InMageBasePolicyDetails": "InMageBasePolicyDetails",
            "InMageRcm": "InMageRcmPolicyDetails",
            "InMageRcmFailback": "InMageRcmFailbackPolicyDetails",
            "VMwareCbt": "VmwareCbtPolicyDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2APolicyDetails(PolicyProviderSpecificDetails):
    """A2A specific policy details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :vartype recovery_point_threshold_in_minutes: int
    :ivar recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :vartype recovery_point_history: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :vartype app_consistent_frequency_in_minutes: int
    :ivar multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
    :vartype multi_vm_sync_status: str
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :vartype crash_consistent_frequency_in_minutes: int
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_threshold_in_minutes": {"key": "recoveryPointThresholdInMinutes", "type": "int"},
        "recovery_point_history": {"key": "recoveryPointHistory", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        multi_vm_sync_status: Optional[str] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        :paramtype recovery_point_threshold_in_minutes: int
        :keyword recovery_point_history: The duration in minutes until which the recovery points need
         to be stored.
        :paramtype recovery_point_history: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
        :paramtype multi_vm_sync_status: str
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
         minutes.
        :paramtype crash_consistent_frequency_in_minutes: int
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes


class A2AProtectedDiskDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A2A protected disk details.

    :ivar disk_uri: The disk uri.
    :vartype disk_uri: str
    :ivar recovery_azure_storage_account_id: The recovery disk storage account.
    :vartype recovery_azure_storage_account_id: str
    :ivar primary_disk_azure_storage_account_id: The primary disk storage account.
    :vartype primary_disk_azure_storage_account_id: str
    :ivar recovery_disk_uri: Recovery disk uri.
    :vartype recovery_disk_uri: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar disk_capacity_in_bytes: The disk capacity in bytes.
    :vartype disk_capacity_in_bytes: int
    :ivar primary_staging_azure_storage_account_id: The primary staging storage account.
    :vartype primary_staging_azure_storage_account_id: str
    :ivar disk_type: The type of disk.
    :vartype disk_type: str
    :ivar resync_required: A value indicating whether resync is required for this disk.
    :vartype resync_required: bool
    :ivar monitoring_percentage_completion: The percentage of the monitoring job. The type of the
     monitoring job is defined by MonitoringJobType property.
    :vartype monitoring_percentage_completion: int
    :ivar monitoring_job_type: The type of the monitoring job. The progress is contained in
     MonitoringPercentageCompletion property.
    :vartype monitoring_job_type: str
    :ivar data_pending_in_staging_storage_account_in_mb: The data pending for replication in MB at
     staging account.
    :vartype data_pending_in_staging_storage_account_in_mb: float
    :ivar data_pending_at_source_agent_in_mb: The data pending at source virtual machine in MB.
    :vartype data_pending_at_source_agent_in_mb: float
    :ivar disk_state: The disk state.
    :vartype disk_state: str
    :ivar allowed_disk_level_operation: The disk level operations list.
    :vartype allowed_disk_level_operation: list[str]
    :ivar is_disk_encrypted: A value indicating whether vm has encrypted os disk or not.
    :vartype is_disk_encrypted: bool
    :ivar secret_identifier: The secret URL / identifier (BEK).
    :vartype secret_identifier: str
    :ivar dek_key_vault_arm_id: The KeyVault resource id for secret (BEK).
    :vartype dek_key_vault_arm_id: str
    :ivar is_disk_key_encrypted: A value indicating whether disk key got encrypted or not.
    :vartype is_disk_key_encrypted: bool
    :ivar key_identifier: The key URL / identifier (KEK).
    :vartype key_identifier: str
    :ivar kek_key_vault_arm_id: The KeyVault resource id for key (KEK).
    :vartype kek_key_vault_arm_id: str
    :ivar failover_disk_name: The failover name for the managed disk.
    :vartype failover_disk_name: str
    :ivar tfo_disk_name: The test failover name for the managed disk.
    :vartype tfo_disk_name: str
    """

    _attribute_map = {
        "disk_uri": {"key": "diskUri", "type": "str"},
        "recovery_azure_storage_account_id": {"key": "recoveryAzureStorageAccountId", "type": "str"},
        "primary_disk_azure_storage_account_id": {"key": "primaryDiskAzureStorageAccountId", "type": "str"},
        "recovery_disk_uri": {"key": "recoveryDiskUri", "type": "str"},
        "disk_name": {"key": "diskName", "type": "str"},
        "disk_capacity_in_bytes": {"key": "diskCapacityInBytes", "type": "int"},
        "primary_staging_azure_storage_account_id": {"key": "primaryStagingAzureStorageAccountId", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "resync_required": {"key": "resyncRequired", "type": "bool"},
        "monitoring_percentage_completion": {"key": "monitoringPercentageCompletion", "type": "int"},
        "monitoring_job_type": {"key": "monitoringJobType", "type": "str"},
        "data_pending_in_staging_storage_account_in_mb": {
            "key": "dataPendingInStagingStorageAccountInMB",
            "type": "float",
        },
        "data_pending_at_source_agent_in_mb": {"key": "dataPendingAtSourceAgentInMB", "type": "float"},
        "disk_state": {"key": "diskState", "type": "str"},
        "allowed_disk_level_operation": {"key": "allowedDiskLevelOperation", "type": "[str]"},
        "is_disk_encrypted": {"key": "isDiskEncrypted", "type": "bool"},
        "secret_identifier": {"key": "secretIdentifier", "type": "str"},
        "dek_key_vault_arm_id": {"key": "dekKeyVaultArmId", "type": "str"},
        "is_disk_key_encrypted": {"key": "isDiskKeyEncrypted", "type": "bool"},
        "key_identifier": {"key": "keyIdentifier", "type": "str"},
        "kek_key_vault_arm_id": {"key": "kekKeyVaultArmId", "type": "str"},
        "failover_disk_name": {"key": "failoverDiskName", "type": "str"},
        "tfo_disk_name": {"key": "tfoDiskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_uri: Optional[str] = None,
        recovery_azure_storage_account_id: Optional[str] = None,
        primary_disk_azure_storage_account_id: Optional[str] = None,
        recovery_disk_uri: Optional[str] = None,
        disk_name: Optional[str] = None,
        disk_capacity_in_bytes: Optional[int] = None,
        primary_staging_azure_storage_account_id: Optional[str] = None,
        disk_type: Optional[str] = None,
        resync_required: Optional[bool] = None,
        monitoring_percentage_completion: Optional[int] = None,
        monitoring_job_type: Optional[str] = None,
        data_pending_in_staging_storage_account_in_mb: Optional[float] = None,
        data_pending_at_source_agent_in_mb: Optional[float] = None,
        disk_state: Optional[str] = None,
        allowed_disk_level_operation: Optional[List[str]] = None,
        is_disk_encrypted: Optional[bool] = None,
        secret_identifier: Optional[str] = None,
        dek_key_vault_arm_id: Optional[str] = None,
        is_disk_key_encrypted: Optional[bool] = None,
        key_identifier: Optional[str] = None,
        kek_key_vault_arm_id: Optional[str] = None,
        failover_disk_name: Optional[str] = None,
        tfo_disk_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_uri: The disk uri.
        :paramtype disk_uri: str
        :keyword recovery_azure_storage_account_id: The recovery disk storage account.
        :paramtype recovery_azure_storage_account_id: str
        :keyword primary_disk_azure_storage_account_id: The primary disk storage account.
        :paramtype primary_disk_azure_storage_account_id: str
        :keyword recovery_disk_uri: Recovery disk uri.
        :paramtype recovery_disk_uri: str
        :keyword disk_name: The disk name.
        :paramtype disk_name: str
        :keyword disk_capacity_in_bytes: The disk capacity in bytes.
        :paramtype disk_capacity_in_bytes: int
        :keyword primary_staging_azure_storage_account_id: The primary staging storage account.
        :paramtype primary_staging_azure_storage_account_id: str
        :keyword disk_type: The type of disk.
        :paramtype disk_type: str
        :keyword resync_required: A value indicating whether resync is required for this disk.
        :paramtype resync_required: bool
        :keyword monitoring_percentage_completion: The percentage of the monitoring job. The type of
         the monitoring job is defined by MonitoringJobType property.
        :paramtype monitoring_percentage_completion: int
        :keyword monitoring_job_type: The type of the monitoring job. The progress is contained in
         MonitoringPercentageCompletion property.
        :paramtype monitoring_job_type: str
        :keyword data_pending_in_staging_storage_account_in_mb: The data pending for replication in MB
         at staging account.
        :paramtype data_pending_in_staging_storage_account_in_mb: float
        :keyword data_pending_at_source_agent_in_mb: The data pending at source virtual machine in MB.
        :paramtype data_pending_at_source_agent_in_mb: float
        :keyword disk_state: The disk state.
        :paramtype disk_state: str
        :keyword allowed_disk_level_operation: The disk level operations list.
        :paramtype allowed_disk_level_operation: list[str]
        :keyword is_disk_encrypted: A value indicating whether vm has encrypted os disk or not.
        :paramtype is_disk_encrypted: bool
        :keyword secret_identifier: The secret URL / identifier (BEK).
        :paramtype secret_identifier: str
        :keyword dek_key_vault_arm_id: The KeyVault resource id for secret (BEK).
        :paramtype dek_key_vault_arm_id: str
        :keyword is_disk_key_encrypted: A value indicating whether disk key got encrypted or not.
        :paramtype is_disk_key_encrypted: bool
        :keyword key_identifier: The key URL / identifier (KEK).
        :paramtype key_identifier: str
        :keyword kek_key_vault_arm_id: The KeyVault resource id for key (KEK).
        :paramtype kek_key_vault_arm_id: str
        :keyword failover_disk_name: The failover name for the managed disk.
        :paramtype failover_disk_name: str
        :keyword tfo_disk_name: The test failover name for the managed disk.
        :paramtype tfo_disk_name: str
        """
        super().__init__(**kwargs)
        self.disk_uri = disk_uri
        self.recovery_azure_storage_account_id = recovery_azure_storage_account_id
        self.primary_disk_azure_storage_account_id = primary_disk_azure_storage_account_id
        self.recovery_disk_uri = recovery_disk_uri
        self.disk_name = disk_name
        self.disk_capacity_in_bytes = disk_capacity_in_bytes
        self.primary_staging_azure_storage_account_id = primary_staging_azure_storage_account_id
        self.disk_type = disk_type
        self.resync_required = resync_required
        self.monitoring_percentage_completion = monitoring_percentage_completion
        self.monitoring_job_type = monitoring_job_type
        self.data_pending_in_staging_storage_account_in_mb = data_pending_in_staging_storage_account_in_mb
        self.data_pending_at_source_agent_in_mb = data_pending_at_source_agent_in_mb
        self.disk_state = disk_state
        self.allowed_disk_level_operation = allowed_disk_level_operation
        self.is_disk_encrypted = is_disk_encrypted
        self.secret_identifier = secret_identifier
        self.dek_key_vault_arm_id = dek_key_vault_arm_id
        self.is_disk_key_encrypted = is_disk_key_encrypted
        self.key_identifier = key_identifier
        self.kek_key_vault_arm_id = kek_key_vault_arm_id
        self.failover_disk_name = failover_disk_name
        self.tfo_disk_name = tfo_disk_name


class A2AProtectedManagedDiskDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A2A protected managed disk details.

    :ivar disk_id: The managed disk Arm id.
    :vartype disk_id: str
    :ivar recovery_resource_group_id: The recovery disk resource group Arm Id.
    :vartype recovery_resource_group_id: str
    :ivar recovery_target_disk_id: Recovery target disk Arm Id.
    :vartype recovery_target_disk_id: str
    :ivar recovery_replica_disk_id: Recovery replica disk Arm Id.
    :vartype recovery_replica_disk_id: str
    :ivar recovery_orignal_target_disk_id: Recovery original target disk Arm Id.
    :vartype recovery_orignal_target_disk_id: str
    :ivar recovery_replica_disk_account_type: The replica disk type. Its an optional value and will
     be same as source disk type if not user provided.
    :vartype recovery_replica_disk_account_type: str
    :ivar recovery_target_disk_account_type: The target disk type after failover. Its an optional
     value and will be same as source disk type if not user provided.
    :vartype recovery_target_disk_account_type: str
    :ivar recovery_disk_encryption_set_id: The recovery disk encryption set Id.
    :vartype recovery_disk_encryption_set_id: str
    :ivar primary_disk_encryption_set_id: The primary disk encryption set Id.
    :vartype primary_disk_encryption_set_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar disk_capacity_in_bytes: The disk capacity in bytes.
    :vartype disk_capacity_in_bytes: int
    :ivar primary_staging_azure_storage_account_id: The primary staging storage account.
    :vartype primary_staging_azure_storage_account_id: str
    :ivar disk_type: The type of disk.
    :vartype disk_type: str
    :ivar resync_required: A value indicating whether resync is required for this disk.
    :vartype resync_required: bool
    :ivar monitoring_percentage_completion: The percentage of the monitoring job. The type of the
     monitoring job is defined by MonitoringJobType property.
    :vartype monitoring_percentage_completion: int
    :ivar monitoring_job_type: The type of the monitoring job. The progress is contained in
     MonitoringPercentageCompletion property.
    :vartype monitoring_job_type: str
    :ivar data_pending_in_staging_storage_account_in_mb: The data pending for replication in MB at
     staging account.
    :vartype data_pending_in_staging_storage_account_in_mb: float
    :ivar data_pending_at_source_agent_in_mb: The data pending at source virtual machine in MB.
    :vartype data_pending_at_source_agent_in_mb: float
    :ivar disk_state: The disk state.
    :vartype disk_state: str
    :ivar allowed_disk_level_operation: The disk level operations list.
    :vartype allowed_disk_level_operation: list[str]
    :ivar is_disk_encrypted: A value indicating whether vm has encrypted os disk or not.
    :vartype is_disk_encrypted: bool
    :ivar secret_identifier: The secret URL / identifier (BEK).
    :vartype secret_identifier: str
    :ivar dek_key_vault_arm_id: The KeyVault resource id for secret (BEK).
    :vartype dek_key_vault_arm_id: str
    :ivar is_disk_key_encrypted: A value indicating whether disk key got encrypted or not.
    :vartype is_disk_key_encrypted: bool
    :ivar key_identifier: The key URL / identifier (KEK).
    :vartype key_identifier: str
    :ivar kek_key_vault_arm_id: The KeyVault resource id for key (KEK).
    :vartype kek_key_vault_arm_id: str
    :ivar failover_disk_name: The failover name for the managed disk.
    :vartype failover_disk_name: str
    :ivar tfo_disk_name: The test failover name for the managed disk.
    :vartype tfo_disk_name: str
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
        "recovery_target_disk_id": {"key": "recoveryTargetDiskId", "type": "str"},
        "recovery_replica_disk_id": {"key": "recoveryReplicaDiskId", "type": "str"},
        "recovery_orignal_target_disk_id": {"key": "recoveryOrignalTargetDiskId", "type": "str"},
        "recovery_replica_disk_account_type": {"key": "recoveryReplicaDiskAccountType", "type": "str"},
        "recovery_target_disk_account_type": {"key": "recoveryTargetDiskAccountType", "type": "str"},
        "recovery_disk_encryption_set_id": {"key": "recoveryDiskEncryptionSetId", "type": "str"},
        "primary_disk_encryption_set_id": {"key": "primaryDiskEncryptionSetId", "type": "str"},
        "disk_name": {"key": "diskName", "type": "str"},
        "disk_capacity_in_bytes": {"key": "diskCapacityInBytes", "type": "int"},
        "primary_staging_azure_storage_account_id": {"key": "primaryStagingAzureStorageAccountId", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "resync_required": {"key": "resyncRequired", "type": "bool"},
        "monitoring_percentage_completion": {"key": "monitoringPercentageCompletion", "type": "int"},
        "monitoring_job_type": {"key": "monitoringJobType", "type": "str"},
        "data_pending_in_staging_storage_account_in_mb": {
            "key": "dataPendingInStagingStorageAccountInMB",
            "type": "float",
        },
        "data_pending_at_source_agent_in_mb": {"key": "dataPendingAtSourceAgentInMB", "type": "float"},
        "disk_state": {"key": "diskState", "type": "str"},
        "allowed_disk_level_operation": {"key": "allowedDiskLevelOperation", "type": "[str]"},
        "is_disk_encrypted": {"key": "isDiskEncrypted", "type": "bool"},
        "secret_identifier": {"key": "secretIdentifier", "type": "str"},
        "dek_key_vault_arm_id": {"key": "dekKeyVaultArmId", "type": "str"},
        "is_disk_key_encrypted": {"key": "isDiskKeyEncrypted", "type": "bool"},
        "key_identifier": {"key": "keyIdentifier", "type": "str"},
        "kek_key_vault_arm_id": {"key": "kekKeyVaultArmId", "type": "str"},
        "failover_disk_name": {"key": "failoverDiskName", "type": "str"},
        "tfo_disk_name": {"key": "tfoDiskName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        disk_id: Optional[str] = None,
        recovery_resource_group_id: Optional[str] = None,
        recovery_target_disk_id: Optional[str] = None,
        recovery_replica_disk_id: Optional[str] = None,
        recovery_orignal_target_disk_id: Optional[str] = None,
        recovery_replica_disk_account_type: Optional[str] = None,
        recovery_target_disk_account_type: Optional[str] = None,
        recovery_disk_encryption_set_id: Optional[str] = None,
        primary_disk_encryption_set_id: Optional[str] = None,
        disk_name: Optional[str] = None,
        disk_capacity_in_bytes: Optional[int] = None,
        primary_staging_azure_storage_account_id: Optional[str] = None,
        disk_type: Optional[str] = None,
        resync_required: Optional[bool] = None,
        monitoring_percentage_completion: Optional[int] = None,
        monitoring_job_type: Optional[str] = None,
        data_pending_in_staging_storage_account_in_mb: Optional[float] = None,
        data_pending_at_source_agent_in_mb: Optional[float] = None,
        disk_state: Optional[str] = None,
        allowed_disk_level_operation: Optional[List[str]] = None,
        is_disk_encrypted: Optional[bool] = None,
        secret_identifier: Optional[str] = None,
        dek_key_vault_arm_id: Optional[str] = None,
        is_disk_key_encrypted: Optional[bool] = None,
        key_identifier: Optional[str] = None,
        kek_key_vault_arm_id: Optional[str] = None,
        failover_disk_name: Optional[str] = None,
        tfo_disk_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The managed disk Arm id.
        :paramtype disk_id: str
        :keyword recovery_resource_group_id: The recovery disk resource group Arm Id.
        :paramtype recovery_resource_group_id: str
        :keyword recovery_target_disk_id: Recovery target disk Arm Id.
        :paramtype recovery_target_disk_id: str
        :keyword recovery_replica_disk_id: Recovery replica disk Arm Id.
        :paramtype recovery_replica_disk_id: str
        :keyword recovery_orignal_target_disk_id: Recovery original target disk Arm Id.
        :paramtype recovery_orignal_target_disk_id: str
        :keyword recovery_replica_disk_account_type: The replica disk type. Its an optional value and
         will be same as source disk type if not user provided.
        :paramtype recovery_replica_disk_account_type: str
        :keyword recovery_target_disk_account_type: The target disk type after failover. Its an
         optional value and will be same as source disk type if not user provided.
        :paramtype recovery_target_disk_account_type: str
        :keyword recovery_disk_encryption_set_id: The recovery disk encryption set Id.
        :paramtype recovery_disk_encryption_set_id: str
        :keyword primary_disk_encryption_set_id: The primary disk encryption set Id.
        :paramtype primary_disk_encryption_set_id: str
        :keyword disk_name: The disk name.
        :paramtype disk_name: str
        :keyword disk_capacity_in_bytes: The disk capacity in bytes.
        :paramtype disk_capacity_in_bytes: int
        :keyword primary_staging_azure_storage_account_id: The primary staging storage account.
        :paramtype primary_staging_azure_storage_account_id: str
        :keyword disk_type: The type of disk.
        :paramtype disk_type: str
        :keyword resync_required: A value indicating whether resync is required for this disk.
        :paramtype resync_required: bool
        :keyword monitoring_percentage_completion: The percentage of the monitoring job. The type of
         the monitoring job is defined by MonitoringJobType property.
        :paramtype monitoring_percentage_completion: int
        :keyword monitoring_job_type: The type of the monitoring job. The progress is contained in
         MonitoringPercentageCompletion property.
        :paramtype monitoring_job_type: str
        :keyword data_pending_in_staging_storage_account_in_mb: The data pending for replication in MB
         at staging account.
        :paramtype data_pending_in_staging_storage_account_in_mb: float
        :keyword data_pending_at_source_agent_in_mb: The data pending at source virtual machine in MB.
        :paramtype data_pending_at_source_agent_in_mb: float
        :keyword disk_state: The disk state.
        :paramtype disk_state: str
        :keyword allowed_disk_level_operation: The disk level operations list.
        :paramtype allowed_disk_level_operation: list[str]
        :keyword is_disk_encrypted: A value indicating whether vm has encrypted os disk or not.
        :paramtype is_disk_encrypted: bool
        :keyword secret_identifier: The secret URL / identifier (BEK).
        :paramtype secret_identifier: str
        :keyword dek_key_vault_arm_id: The KeyVault resource id for secret (BEK).
        :paramtype dek_key_vault_arm_id: str
        :keyword is_disk_key_encrypted: A value indicating whether disk key got encrypted or not.
        :paramtype is_disk_key_encrypted: bool
        :keyword key_identifier: The key URL / identifier (KEK).
        :paramtype key_identifier: str
        :keyword kek_key_vault_arm_id: The KeyVault resource id for key (KEK).
        :paramtype kek_key_vault_arm_id: str
        :keyword failover_disk_name: The failover name for the managed disk.
        :paramtype failover_disk_name: str
        :keyword tfo_disk_name: The test failover name for the managed disk.
        :paramtype tfo_disk_name: str
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_target_disk_id = recovery_target_disk_id
        self.recovery_replica_disk_id = recovery_replica_disk_id
        self.recovery_orignal_target_disk_id = recovery_orignal_target_disk_id
        self.recovery_replica_disk_account_type = recovery_replica_disk_account_type
        self.recovery_target_disk_account_type = recovery_target_disk_account_type
        self.recovery_disk_encryption_set_id = recovery_disk_encryption_set_id
        self.primary_disk_encryption_set_id = primary_disk_encryption_set_id
        self.disk_name = disk_name
        self.disk_capacity_in_bytes = disk_capacity_in_bytes
        self.primary_staging_azure_storage_account_id = primary_staging_azure_storage_account_id
        self.disk_type = disk_type
        self.resync_required = resync_required
        self.monitoring_percentage_completion = monitoring_percentage_completion
        self.monitoring_job_type = monitoring_job_type
        self.data_pending_in_staging_storage_account_in_mb = data_pending_in_staging_storage_account_in_mb
        self.data_pending_at_source_agent_in_mb = data_pending_at_source_agent_in_mb
        self.disk_state = disk_state
        self.allowed_disk_level_operation = allowed_disk_level_operation
        self.is_disk_encrypted = is_disk_encrypted
        self.secret_identifier = secret_identifier
        self.dek_key_vault_arm_id = dek_key_vault_arm_id
        self.is_disk_key_encrypted = is_disk_key_encrypted
        self.key_identifier = key_identifier
        self.kek_key_vault_arm_id = kek_key_vault_arm_id
        self.failover_disk_name = failover_disk_name
        self.tfo_disk_name = tfo_disk_name


class ProtectionContainerMappingProviderSpecificDetails(_serialization.Model):
    """Container mapping provider specific details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AProtectionContainerMappingDetails, InMageRcmProtectionContainerMappingDetails,
    VMwareCbtProtectionContainerMappingDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AProtectionContainerMappingDetails",
            "InMageRcm": "InMageRcmProtectionContainerMappingDetails",
            "VMwareCbt": "VMwareCbtProtectionContainerMappingDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AProtectionContainerMappingDetails(ProtectionContainerMappingProviderSpecificDetails):
    """A2A provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar agent_auto_update_status: A value indicating whether the auto update is enabled. Known
     values are: "Disabled" and "Enabled".
    :vartype agent_auto_update_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
    :ivar automation_account_arm_id: The automation account arm id.
    :vartype automation_account_arm_id: str
    :ivar automation_account_authentication_type: A value indicating the type authentication to use
     for automation Account. Known values are: "RunAsAccount" and "SystemAssignedIdentity".
    :vartype automation_account_authentication_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
    :ivar schedule_name: The schedule arm name.
    :vartype schedule_name: str
    :ivar job_schedule_name: The job schedule arm name.
    :vartype job_schedule_name: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "agent_auto_update_status": {"key": "agentAutoUpdateStatus", "type": "str"},
        "automation_account_arm_id": {"key": "automationAccountArmId", "type": "str"},
        "automation_account_authentication_type": {"key": "automationAccountAuthenticationType", "type": "str"},
        "schedule_name": {"key": "scheduleName", "type": "str"},
        "job_schedule_name": {"key": "jobScheduleName", "type": "str"},
    }

    def __init__(
        self,
        *,
        agent_auto_update_status: Optional[Union[str, "_models.AgentAutoUpdateStatus"]] = None,
        automation_account_arm_id: Optional[str] = None,
        automation_account_authentication_type: Optional[
            Union[str, "_models.AutomationAccountAuthenticationType"]
        ] = None,
        schedule_name: Optional[str] = None,
        job_schedule_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword agent_auto_update_status: A value indicating whether the auto update is enabled. Known
         values are: "Disabled" and "Enabled".
        :paramtype agent_auto_update_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
        :keyword automation_account_arm_id: The automation account arm id.
        :paramtype automation_account_arm_id: str
        :keyword automation_account_authentication_type: A value indicating the type authentication to
         use for automation Account. Known values are: "RunAsAccount" and "SystemAssignedIdentity".
        :paramtype automation_account_authentication_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
        :keyword schedule_name: The schedule arm name.
        :paramtype schedule_name: str
        :keyword job_schedule_name: The job schedule arm name.
        :paramtype job_schedule_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.agent_auto_update_status = agent_auto_update_status
        self.automation_account_arm_id = automation_account_arm_id
        self.automation_account_authentication_type = automation_account_authentication_type
        self.schedule_name = schedule_name
        self.job_schedule_name = job_schedule_name


class A2AProtectionIntentDiskInputDetails(_serialization.Model):
    """Azure VM unmanaged disk input details.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_uri: The disk Uri. Required.
    :vartype disk_uri: str
    :ivar recovery_azure_storage_account_custom_input: The recovery VHD storage account input.
    :vartype recovery_azure_storage_account_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :ivar primary_staging_storage_account_custom_input: The primary staging storage account input.
    :vartype primary_staging_storage_account_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    """

    _validation = {
        "disk_uri": {"required": True},
    }

    _attribute_map = {
        "disk_uri": {"key": "diskUri", "type": "str"},
        "recovery_azure_storage_account_custom_input": {
            "key": "recoveryAzureStorageAccountCustomInput",
            "type": "StorageAccountCustomDetails",
        },
        "primary_staging_storage_account_custom_input": {
            "key": "primaryStagingStorageAccountCustomInput",
            "type": "StorageAccountCustomDetails",
        },
    }

    def __init__(
        self,
        *,
        disk_uri: str,
        recovery_azure_storage_account_custom_input: Optional["_models.StorageAccountCustomDetails"] = None,
        primary_staging_storage_account_custom_input: Optional["_models.StorageAccountCustomDetails"] = None,
        **kwargs
    ):
        """
        :keyword disk_uri: The disk Uri. Required.
        :paramtype disk_uri: str
        :keyword recovery_azure_storage_account_custom_input: The recovery VHD storage account input.
        :paramtype recovery_azure_storage_account_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
        :keyword primary_staging_storage_account_custom_input: The primary staging storage account
         input.
        :paramtype primary_staging_storage_account_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
        """
        super().__init__(**kwargs)
        self.disk_uri = disk_uri
        self.recovery_azure_storage_account_custom_input = recovery_azure_storage_account_custom_input
        self.primary_staging_storage_account_custom_input = primary_staging_storage_account_custom_input


class A2AProtectionIntentManagedDiskInputDetails(_serialization.Model):
    """Azure VM managed disk input details.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_id: The disk Id. Required.
    :vartype disk_id: str
    :ivar primary_staging_storage_account_custom_input: The primary staging storage account input.
    :vartype primary_staging_storage_account_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :ivar recovery_resource_group_custom_input: The recovery resource group input.
    :vartype recovery_resource_group_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryResourceGroupCustomDetails
    :ivar recovery_replica_disk_account_type: The replica disk type. Its an optional value and will
     be same as source disk type if not user provided.
    :vartype recovery_replica_disk_account_type: str
    :ivar recovery_target_disk_account_type: The target disk type after failover. Its an optional
     value and will be same as source disk type if not user provided.
    :vartype recovery_target_disk_account_type: str
    :ivar recovery_disk_encryption_set_id: The recovery disk encryption set Id.
    :vartype recovery_disk_encryption_set_id: str
    :ivar disk_encryption_info: The recovery disk encryption information (for one / single pass
     flows).
    :vartype disk_encryption_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    """

    _validation = {
        "disk_id": {"required": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "primary_staging_storage_account_custom_input": {
            "key": "primaryStagingStorageAccountCustomInput",
            "type": "StorageAccountCustomDetails",
        },
        "recovery_resource_group_custom_input": {
            "key": "recoveryResourceGroupCustomInput",
            "type": "RecoveryResourceGroupCustomDetails",
        },
        "recovery_replica_disk_account_type": {"key": "recoveryReplicaDiskAccountType", "type": "str"},
        "recovery_target_disk_account_type": {"key": "recoveryTargetDiskAccountType", "type": "str"},
        "recovery_disk_encryption_set_id": {"key": "recoveryDiskEncryptionSetId", "type": "str"},
        "disk_encryption_info": {"key": "diskEncryptionInfo", "type": "DiskEncryptionInfo"},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        primary_staging_storage_account_custom_input: Optional["_models.StorageAccountCustomDetails"] = None,
        recovery_resource_group_custom_input: Optional["_models.RecoveryResourceGroupCustomDetails"] = None,
        recovery_replica_disk_account_type: Optional[str] = None,
        recovery_target_disk_account_type: Optional[str] = None,
        recovery_disk_encryption_set_id: Optional[str] = None,
        disk_encryption_info: Optional["_models.DiskEncryptionInfo"] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk Id. Required.
        :paramtype disk_id: str
        :keyword primary_staging_storage_account_custom_input: The primary staging storage account
         input.
        :paramtype primary_staging_storage_account_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
        :keyword recovery_resource_group_custom_input: The recovery resource group input.
        :paramtype recovery_resource_group_custom_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryResourceGroupCustomDetails
        :keyword recovery_replica_disk_account_type: The replica disk type. Its an optional value and
         will be same as source disk type if not user provided.
        :paramtype recovery_replica_disk_account_type: str
        :keyword recovery_target_disk_account_type: The target disk type after failover. Its an
         optional value and will be same as source disk type if not user provided.
        :paramtype recovery_target_disk_account_type: str
        :keyword recovery_disk_encryption_set_id: The recovery disk encryption set Id.
        :paramtype recovery_disk_encryption_set_id: str
        :keyword disk_encryption_info: The recovery disk encryption information (for one / single pass
         flows).
        :paramtype disk_encryption_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.primary_staging_storage_account_custom_input = primary_staging_storage_account_custom_input
        self.recovery_resource_group_custom_input = recovery_resource_group_custom_input
        self.recovery_replica_disk_account_type = recovery_replica_disk_account_type
        self.recovery_target_disk_account_type = recovery_target_disk_account_type
        self.recovery_disk_encryption_set_id = recovery_disk_encryption_set_id
        self.disk_encryption_info = disk_encryption_info


class ProviderSpecificRecoveryPointDetails(_serialization.Model):
    """Replication provider specific recovery point details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2ARecoveryPointDetails, InMageAzureV2RecoveryPointDetails, InMageRcmRecoveryPointDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the provider type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2ARecoveryPointDetails",
            "InMageAzureV2": "InMageAzureV2RecoveryPointDetails",
            "InMageRcm": "InMageRcmRecoveryPointDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2ARecoveryPointDetails(ProviderSpecificRecoveryPointDetails):
    """A2A provider specific recovery point details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the provider type. Required.
    :vartype instance_type: str
    :ivar recovery_point_sync_type: A value indicating whether the recovery point is multi VM
     consistent. Known values are: "MultiVmSyncRecoveryPoint" and "PerVmRecoveryPoint".
    :vartype recovery_point_sync_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointSyncType
    :ivar disks: List of disk ids representing a recovery point.
    :vartype disks: list[str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_sync_type": {"key": "recoveryPointSyncType", "type": "str"},
        "disks": {"key": "disks", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        recovery_point_sync_type: Optional[Union[str, "_models.RecoveryPointSyncType"]] = None,
        disks: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_sync_type: A value indicating whether the recovery point is multi VM
         consistent. Known values are: "MultiVmSyncRecoveryPoint" and "PerVmRecoveryPoint".
        :paramtype recovery_point_sync_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointSyncType
        :keyword disks: List of disk ids representing a recovery point.
        :paramtype disks: list[str]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_point_sync_type = recovery_point_sync_type
        self.disks = disks


class RemoveDisksProviderSpecificInput(_serialization.Model):
    """Remove Disk provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2ARemoveDisksInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"A2A": "A2ARemoveDisksInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2ARemoveDisksInput(RemoveDisksProviderSpecificInput):
    """A2A remove disk(s) input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar vm_disks_uris: The list of vm disk vhd URIs.
    :vartype vm_disks_uris: list[str]
    :ivar vm_managed_disks_ids: The list of vm managed disk Ids.
    :vartype vm_managed_disks_ids: list[str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "vm_disks_uris": {"key": "vmDisksUris", "type": "[str]"},
        "vm_managed_disks_ids": {"key": "vmManagedDisksIds", "type": "[str]"},
    }

    def __init__(
        self, *, vm_disks_uris: Optional[List[str]] = None, vm_managed_disks_ids: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword vm_disks_uris: The list of vm disk vhd URIs.
        :paramtype vm_disks_uris: list[str]
        :keyword vm_managed_disks_ids: The list of vm managed disk Ids.
        :paramtype vm_managed_disks_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.vm_disks_uris = vm_disks_uris
        self.vm_managed_disks_ids = vm_managed_disks_ids


class A2AReplicationDetails(ReplicationProviderSpecificSettings):  # pylint: disable=too-many-instance-attributes
    """A2A provider specific settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar fabric_object_id: The fabric specific object Id of the virtual machine.
    :vartype fabric_object_id: str
    :ivar initial_primary_zone: The initial primary availability zone.
    :vartype initial_primary_zone: str
    :ivar initial_primary_fabric_location: The initial primary fabric location.
    :vartype initial_primary_fabric_location: str
    :ivar initial_recovery_zone: The initial recovery availability zone.
    :vartype initial_recovery_zone: str
    :ivar initial_primary_extended_location: The initial primary extended location.
    :vartype initial_primary_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    :ivar initial_recovery_extended_location: The initial recovery extended location.
    :vartype initial_recovery_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    :ivar initial_recovery_fabric_location: The initial recovery fabric location.
    :vartype initial_recovery_fabric_location: str
    :ivar multi_vm_group_id: The multi vm group Id.
    :vartype multi_vm_group_id: str
    :ivar multi_vm_group_name: The multi vm group name.
    :vartype multi_vm_group_name: str
    :ivar multi_vm_group_create_option: Whether Multi VM group is auto created or specified by
     user. Known values are: "AutoCreated" and "UserSpecified".
    :vartype multi_vm_group_create_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmGroupCreateOption
    :ivar management_id: The management Id.
    :vartype management_id: str
    :ivar protected_disks: The list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectedDiskDetails]
    :ivar unprotected_disks: The list of unprotected disks.
    :vartype unprotected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AUnprotectedDiskDetails]
    :ivar protected_managed_disks: The list of protected managed disks.
    :vartype protected_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectedManagedDiskDetails]
    :ivar recovery_boot_diag_storage_account_id: The recovery boot diagnostic storage account Arm
     Id.
    :vartype recovery_boot_diag_storage_account_id: str
    :ivar primary_fabric_location: Primary fabric location.
    :vartype primary_fabric_location: str
    :ivar recovery_fabric_location: The recovery fabric location.
    :vartype recovery_fabric_location: str
    :ivar os_type: The type of operating system.
    :vartype os_type: str
    :ivar recovery_azure_vm_size: The size of recovery virtual machine.
    :vartype recovery_azure_vm_size: str
    :ivar recovery_azure_vm_name: The name of recovery virtual machine.
    :vartype recovery_azure_vm_name: str
    :ivar recovery_azure_resource_group_id: The recovery resource group.
    :vartype recovery_azure_resource_group_id: str
    :ivar recovery_cloud_service: The recovery cloud service.
    :vartype recovery_cloud_service: str
    :ivar recovery_availability_set: The recovery availability set.
    :vartype recovery_availability_set: str
    :ivar selected_recovery_azure_network_id: The recovery virtual network.
    :vartype selected_recovery_azure_network_id: str
    :ivar selected_tfo_azure_network_id: The test failover virtual network.
    :vartype selected_tfo_azure_network_id: str
    :ivar vm_nics: The virtual machine nic details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :ivar vm_synced_config_details: The synced configuration details.
    :vartype vm_synced_config_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.AzureToAzureVmSyncedConfigDetails
    :ivar monitoring_percentage_completion: The percentage of the monitoring job. The type of the
     monitoring job is defined by MonitoringJobType property.
    :vartype monitoring_percentage_completion: int
    :ivar monitoring_job_type: The type of the monitoring job. The progress is contained in
     MonitoringPercentageCompletion property.
    :vartype monitoring_job_type: str
    :ivar last_heartbeat: The last heartbeat received from the source server.
    :vartype last_heartbeat: ~datetime.datetime
    :ivar agent_version: The agent version.
    :vartype agent_version: str
    :ivar agent_expiry_date: Agent expiry date.
    :vartype agent_expiry_date: ~datetime.datetime
    :ivar is_replication_agent_update_required: A value indicating whether replication agent update
     is required.
    :vartype is_replication_agent_update_required: bool
    :ivar agent_certificate_expiry_date: Agent certificate expiry date.
    :vartype agent_certificate_expiry_date: ~datetime.datetime
    :ivar is_replication_agent_certificate_update_required: A value indicating whether agent
     certificate update is required.
    :vartype is_replication_agent_certificate_update_required: bool
    :ivar recovery_fabric_object_id: The recovery fabric object Id.
    :vartype recovery_fabric_object_id: str
    :ivar vm_protection_state: The protection state for the vm.
    :vartype vm_protection_state: str
    :ivar vm_protection_state_description: The protection state description for the vm.
    :vartype vm_protection_state_description: str
    :ivar lifecycle_id: An id associated with the PE that survives actions like switch protection
     which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to
     have a link/continuity in being able to have an Id that denotes the "same" protected item even
     though other internal Ids/ARM Id might be changing.
    :vartype lifecycle_id: str
    :ivar test_failover_recovery_fabric_object_id: The test failover fabric object Id.
    :vartype test_failover_recovery_fabric_object_id: str
    :ivar rpo_in_seconds: The last RPO value in seconds.
    :vartype rpo_in_seconds: int
    :ivar last_rpo_calculated_time: The time (in UTC) when the last RPO value was calculated by
     Protection Service.
    :vartype last_rpo_calculated_time: ~datetime.datetime
    :ivar primary_availability_zone: The primary availability zone.
    :vartype primary_availability_zone: str
    :ivar recovery_availability_zone: The recovery availability zone.
    :vartype recovery_availability_zone: str
    :ivar primary_extended_location: The primary Extended Location.
    :vartype primary_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    :ivar recovery_extended_location: The recovery Extended Location.
    :vartype recovery_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    :ivar vm_encryption_type: The encryption type of the VM. Known values are: "NotEncrypted",
     "OnePassEncrypted", and "TwoPassEncrypted".
    :vartype vm_encryption_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmEncryptionType
    :ivar tfo_azure_vm_name: The test failover vm name.
    :vartype tfo_azure_vm_name: str
    :ivar recovery_azure_generation: The recovery azure generation.
    :vartype recovery_azure_generation: str
    :ivar recovery_proximity_placement_group_id: The recovery proximity placement group Id.
    :vartype recovery_proximity_placement_group_id: str
    :ivar auto_protection_of_data_disk: A value indicating whether the auto protection is enabled.
     Known values are: "Disabled" and "Enabled".
    :vartype auto_protection_of_data_disk: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
    :ivar recovery_virtual_machine_scale_set_id: The recovery virtual machine scale set id.
    :vartype recovery_virtual_machine_scale_set_id: str
    :ivar recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
    :vartype recovery_capacity_reservation_group_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "initial_primary_zone": {"readonly": True},
        "initial_primary_fabric_location": {"readonly": True},
        "initial_recovery_zone": {"readonly": True},
        "initial_recovery_fabric_location": {"readonly": True},
        "agent_certificate_expiry_date": {"readonly": True},
        "vm_encryption_type": {"readonly": True},
        "recovery_azure_generation": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "initial_primary_zone": {"key": "initialPrimaryZone", "type": "str"},
        "initial_primary_fabric_location": {"key": "initialPrimaryFabricLocation", "type": "str"},
        "initial_recovery_zone": {"key": "initialRecoveryZone", "type": "str"},
        "initial_primary_extended_location": {"key": "initialPrimaryExtendedLocation", "type": "ExtendedLocation"},
        "initial_recovery_extended_location": {"key": "initialRecoveryExtendedLocation", "type": "ExtendedLocation"},
        "initial_recovery_fabric_location": {"key": "initialRecoveryFabricLocation", "type": "str"},
        "multi_vm_group_id": {"key": "multiVmGroupId", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "multi_vm_group_create_option": {"key": "multiVmGroupCreateOption", "type": "str"},
        "management_id": {"key": "managementId", "type": "str"},
        "protected_disks": {"key": "protectedDisks", "type": "[A2AProtectedDiskDetails]"},
        "unprotected_disks": {"key": "unprotectedDisks", "type": "[A2AUnprotectedDiskDetails]"},
        "protected_managed_disks": {"key": "protectedManagedDisks", "type": "[A2AProtectedManagedDiskDetails]"},
        "recovery_boot_diag_storage_account_id": {"key": "recoveryBootDiagStorageAccountId", "type": "str"},
        "primary_fabric_location": {"key": "primaryFabricLocation", "type": "str"},
        "recovery_fabric_location": {"key": "recoveryFabricLocation", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "recovery_azure_vm_size": {"key": "recoveryAzureVMSize", "type": "str"},
        "recovery_azure_vm_name": {"key": "recoveryAzureVMName", "type": "str"},
        "recovery_azure_resource_group_id": {"key": "recoveryAzureResourceGroupId", "type": "str"},
        "recovery_cloud_service": {"key": "recoveryCloudService", "type": "str"},
        "recovery_availability_set": {"key": "recoveryAvailabilitySet", "type": "str"},
        "selected_recovery_azure_network_id": {"key": "selectedRecoveryAzureNetworkId", "type": "str"},
        "selected_tfo_azure_network_id": {"key": "selectedTfoAzureNetworkId", "type": "str"},
        "vm_nics": {"key": "vmNics", "type": "[VMNicDetails]"},
        "vm_synced_config_details": {"key": "vmSyncedConfigDetails", "type": "AzureToAzureVmSyncedConfigDetails"},
        "monitoring_percentage_completion": {"key": "monitoringPercentageCompletion", "type": "int"},
        "monitoring_job_type": {"key": "monitoringJobType", "type": "str"},
        "last_heartbeat": {"key": "lastHeartbeat", "type": "iso-8601"},
        "agent_version": {"key": "agentVersion", "type": "str"},
        "agent_expiry_date": {"key": "agentExpiryDate", "type": "iso-8601"},
        "is_replication_agent_update_required": {"key": "isReplicationAgentUpdateRequired", "type": "bool"},
        "agent_certificate_expiry_date": {"key": "agentCertificateExpiryDate", "type": "iso-8601"},
        "is_replication_agent_certificate_update_required": {
            "key": "isReplicationAgentCertificateUpdateRequired",
            "type": "bool",
        },
        "recovery_fabric_object_id": {"key": "recoveryFabricObjectId", "type": "str"},
        "vm_protection_state": {"key": "vmProtectionState", "type": "str"},
        "vm_protection_state_description": {"key": "vmProtectionStateDescription", "type": "str"},
        "lifecycle_id": {"key": "lifecycleId", "type": "str"},
        "test_failover_recovery_fabric_object_id": {"key": "testFailoverRecoveryFabricObjectId", "type": "str"},
        "rpo_in_seconds": {"key": "rpoInSeconds", "type": "int"},
        "last_rpo_calculated_time": {"key": "lastRpoCalculatedTime", "type": "iso-8601"},
        "primary_availability_zone": {"key": "primaryAvailabilityZone", "type": "str"},
        "recovery_availability_zone": {"key": "recoveryAvailabilityZone", "type": "str"},
        "primary_extended_location": {"key": "primaryExtendedLocation", "type": "ExtendedLocation"},
        "recovery_extended_location": {"key": "recoveryExtendedLocation", "type": "ExtendedLocation"},
        "vm_encryption_type": {"key": "vmEncryptionType", "type": "str"},
        "tfo_azure_vm_name": {"key": "tfoAzureVMName", "type": "str"},
        "recovery_azure_generation": {"key": "recoveryAzureGeneration", "type": "str"},
        "recovery_proximity_placement_group_id": {"key": "recoveryProximityPlacementGroupId", "type": "str"},
        "auto_protection_of_data_disk": {"key": "autoProtectionOfDataDisk", "type": "str"},
        "recovery_virtual_machine_scale_set_id": {"key": "recoveryVirtualMachineScaleSetId", "type": "str"},
        "recovery_capacity_reservation_group_id": {"key": "recoveryCapacityReservationGroupId", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        fabric_object_id: Optional[str] = None,
        initial_primary_extended_location: Optional["_models.ExtendedLocation"] = None,
        initial_recovery_extended_location: Optional["_models.ExtendedLocation"] = None,
        multi_vm_group_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_group_create_option: Optional[Union[str, "_models.MultiVmGroupCreateOption"]] = None,
        management_id: Optional[str] = None,
        protected_disks: Optional[List["_models.A2AProtectedDiskDetails"]] = None,
        unprotected_disks: Optional[List["_models.A2AUnprotectedDiskDetails"]] = None,
        protected_managed_disks: Optional[List["_models.A2AProtectedManagedDiskDetails"]] = None,
        recovery_boot_diag_storage_account_id: Optional[str] = None,
        primary_fabric_location: Optional[str] = None,
        recovery_fabric_location: Optional[str] = None,
        os_type: Optional[str] = None,
        recovery_azure_vm_size: Optional[str] = None,
        recovery_azure_vm_name: Optional[str] = None,
        recovery_azure_resource_group_id: Optional[str] = None,
        recovery_cloud_service: Optional[str] = None,
        recovery_availability_set: Optional[str] = None,
        selected_recovery_azure_network_id: Optional[str] = None,
        selected_tfo_azure_network_id: Optional[str] = None,
        vm_nics: Optional[List["_models.VMNicDetails"]] = None,
        vm_synced_config_details: Optional["_models.AzureToAzureVmSyncedConfigDetails"] = None,
        monitoring_percentage_completion: Optional[int] = None,
        monitoring_job_type: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        agent_version: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        is_replication_agent_update_required: Optional[bool] = None,
        is_replication_agent_certificate_update_required: Optional[bool] = None,
        recovery_fabric_object_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        lifecycle_id: Optional[str] = None,
        test_failover_recovery_fabric_object_id: Optional[str] = None,
        rpo_in_seconds: Optional[int] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        primary_availability_zone: Optional[str] = None,
        recovery_availability_zone: Optional[str] = None,
        primary_extended_location: Optional["_models.ExtendedLocation"] = None,
        recovery_extended_location: Optional["_models.ExtendedLocation"] = None,
        tfo_azure_vm_name: Optional[str] = None,
        recovery_proximity_placement_group_id: Optional[str] = None,
        auto_protection_of_data_disk: Optional[Union[str, "_models.AutoProtectionOfDataDisk"]] = None,
        recovery_virtual_machine_scale_set_id: Optional[str] = None,
        recovery_capacity_reservation_group_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword fabric_object_id: The fabric specific object Id of the virtual machine.
        :paramtype fabric_object_id: str
        :keyword initial_primary_extended_location: The initial primary extended location.
        :paramtype initial_primary_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        :keyword initial_recovery_extended_location: The initial recovery extended location.
        :paramtype initial_recovery_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        :keyword multi_vm_group_id: The multi vm group Id.
        :paramtype multi_vm_group_id: str
        :keyword multi_vm_group_name: The multi vm group name.
        :paramtype multi_vm_group_name: str
        :keyword multi_vm_group_create_option: Whether Multi VM group is auto created or specified by
         user. Known values are: "AutoCreated" and "UserSpecified".
        :paramtype multi_vm_group_create_option: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmGroupCreateOption
        :keyword management_id: The management Id.
        :paramtype management_id: str
        :keyword protected_disks: The list of protected disks.
        :paramtype protected_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectedDiskDetails]
        :keyword unprotected_disks: The list of unprotected disks.
        :paramtype unprotected_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AUnprotectedDiskDetails]
        :keyword protected_managed_disks: The list of protected managed disks.
        :paramtype protected_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectedManagedDiskDetails]
        :keyword recovery_boot_diag_storage_account_id: The recovery boot diagnostic storage account
         Arm Id.
        :paramtype recovery_boot_diag_storage_account_id: str
        :keyword primary_fabric_location: Primary fabric location.
        :paramtype primary_fabric_location: str
        :keyword recovery_fabric_location: The recovery fabric location.
        :paramtype recovery_fabric_location: str
        :keyword os_type: The type of operating system.
        :paramtype os_type: str
        :keyword recovery_azure_vm_size: The size of recovery virtual machine.
        :paramtype recovery_azure_vm_size: str
        :keyword recovery_azure_vm_name: The name of recovery virtual machine.
        :paramtype recovery_azure_vm_name: str
        :keyword recovery_azure_resource_group_id: The recovery resource group.
        :paramtype recovery_azure_resource_group_id: str
        :keyword recovery_cloud_service: The recovery cloud service.
        :paramtype recovery_cloud_service: str
        :keyword recovery_availability_set: The recovery availability set.
        :paramtype recovery_availability_set: str
        :keyword selected_recovery_azure_network_id: The recovery virtual network.
        :paramtype selected_recovery_azure_network_id: str
        :keyword selected_tfo_azure_network_id: The test failover virtual network.
        :paramtype selected_tfo_azure_network_id: str
        :keyword vm_nics: The virtual machine nic details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
        :keyword vm_synced_config_details: The synced configuration details.
        :paramtype vm_synced_config_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.AzureToAzureVmSyncedConfigDetails
        :keyword monitoring_percentage_completion: The percentage of the monitoring job. The type of
         the monitoring job is defined by MonitoringJobType property.
        :paramtype monitoring_percentage_completion: int
        :keyword monitoring_job_type: The type of the monitoring job. The progress is contained in
         MonitoringPercentageCompletion property.
        :paramtype monitoring_job_type: str
        :keyword last_heartbeat: The last heartbeat received from the source server.
        :paramtype last_heartbeat: ~datetime.datetime
        :keyword agent_version: The agent version.
        :paramtype agent_version: str
        :keyword agent_expiry_date: Agent expiry date.
        :paramtype agent_expiry_date: ~datetime.datetime
        :keyword is_replication_agent_update_required: A value indicating whether replication agent
         update is required.
        :paramtype is_replication_agent_update_required: bool
        :keyword is_replication_agent_certificate_update_required: A value indicating whether agent
         certificate update is required.
        :paramtype is_replication_agent_certificate_update_required: bool
        :keyword recovery_fabric_object_id: The recovery fabric object Id.
        :paramtype recovery_fabric_object_id: str
        :keyword vm_protection_state: The protection state for the vm.
        :paramtype vm_protection_state: str
        :keyword vm_protection_state_description: The protection state description for the vm.
        :paramtype vm_protection_state_description: str
        :keyword lifecycle_id: An id associated with the PE that survives actions like switch
         protection which change the backing PE/CPE objects internally.The lifecycle id gets carried
         forward to have a link/continuity in being able to have an Id that denotes the "same" protected
         item even though other internal Ids/ARM Id might be changing.
        :paramtype lifecycle_id: str
        :keyword test_failover_recovery_fabric_object_id: The test failover fabric object Id.
        :paramtype test_failover_recovery_fabric_object_id: str
        :keyword rpo_in_seconds: The last RPO value in seconds.
        :paramtype rpo_in_seconds: int
        :keyword last_rpo_calculated_time: The time (in UTC) when the last RPO value was calculated by
         Protection Service.
        :paramtype last_rpo_calculated_time: ~datetime.datetime
        :keyword primary_availability_zone: The primary availability zone.
        :paramtype primary_availability_zone: str
        :keyword recovery_availability_zone: The recovery availability zone.
        :paramtype recovery_availability_zone: str
        :keyword primary_extended_location: The primary Extended Location.
        :paramtype primary_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        :keyword recovery_extended_location: The recovery Extended Location.
        :paramtype recovery_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        :keyword tfo_azure_vm_name: The test failover vm name.
        :paramtype tfo_azure_vm_name: str
        :keyword recovery_proximity_placement_group_id: The recovery proximity placement group Id.
        :paramtype recovery_proximity_placement_group_id: str
        :keyword auto_protection_of_data_disk: A value indicating whether the auto protection is
         enabled. Known values are: "Disabled" and "Enabled".
        :paramtype auto_protection_of_data_disk: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
        :keyword recovery_virtual_machine_scale_set_id: The recovery virtual machine scale set id.
        :paramtype recovery_virtual_machine_scale_set_id: str
        :keyword recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
        :paramtype recovery_capacity_reservation_group_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.fabric_object_id = fabric_object_id
        self.initial_primary_zone = None
        self.initial_primary_fabric_location = None
        self.initial_recovery_zone = None
        self.initial_primary_extended_location = initial_primary_extended_location
        self.initial_recovery_extended_location = initial_recovery_extended_location
        self.initial_recovery_fabric_location = None
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_group_create_option = multi_vm_group_create_option
        self.management_id = management_id
        self.protected_disks = protected_disks
        self.unprotected_disks = unprotected_disks
        self.protected_managed_disks = protected_managed_disks
        self.recovery_boot_diag_storage_account_id = recovery_boot_diag_storage_account_id
        self.primary_fabric_location = primary_fabric_location
        self.recovery_fabric_location = recovery_fabric_location
        self.os_type = os_type
        self.recovery_azure_vm_size = recovery_azure_vm_size
        self.recovery_azure_vm_name = recovery_azure_vm_name
        self.recovery_azure_resource_group_id = recovery_azure_resource_group_id
        self.recovery_cloud_service = recovery_cloud_service
        self.recovery_availability_set = recovery_availability_set
        self.selected_recovery_azure_network_id = selected_recovery_azure_network_id
        self.selected_tfo_azure_network_id = selected_tfo_azure_network_id
        self.vm_nics = vm_nics
        self.vm_synced_config_details = vm_synced_config_details
        self.monitoring_percentage_completion = monitoring_percentage_completion
        self.monitoring_job_type = monitoring_job_type
        self.last_heartbeat = last_heartbeat
        self.agent_version = agent_version
        self.agent_expiry_date = agent_expiry_date
        self.is_replication_agent_update_required = is_replication_agent_update_required
        self.agent_certificate_expiry_date = None
        self.is_replication_agent_certificate_update_required = is_replication_agent_certificate_update_required
        self.recovery_fabric_object_id = recovery_fabric_object_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.lifecycle_id = lifecycle_id
        self.test_failover_recovery_fabric_object_id = test_failover_recovery_fabric_object_id
        self.rpo_in_seconds = rpo_in_seconds
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.primary_availability_zone = primary_availability_zone
        self.recovery_availability_zone = recovery_availability_zone
        self.primary_extended_location = primary_extended_location
        self.recovery_extended_location = recovery_extended_location
        self.vm_encryption_type = None
        self.tfo_azure_vm_name = tfo_azure_vm_name
        self.recovery_azure_generation = None
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id
        self.auto_protection_of_data_disk = auto_protection_of_data_disk
        self.recovery_virtual_machine_scale_set_id = recovery_virtual_machine_scale_set_id
        self.recovery_capacity_reservation_group_id = recovery_capacity_reservation_group_id


class ReplicationProtectionIntentProviderSpecificSettings(_serialization.Model):
    """Replication provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AReplicationIntentDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"A2A": "A2AReplicationIntentDetails"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AReplicationIntentDetails(
    ReplicationProtectionIntentProviderSpecificSettings
):  # pylint: disable=too-many-instance-attributes
    """A2A provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar fabric_object_id: The fabric specific object Id of the virtual machine.
    :vartype fabric_object_id: str
    :ivar primary_location: The primary location for the virtual machine.
    :vartype primary_location: str
    :ivar recovery_location: The recovery location for the virtual machine.
    :vartype recovery_location: str
    :ivar recovery_subscription_id: The recovery subscription Id of the virtual machine.
    :vartype recovery_subscription_id: str
    :ivar vm_disks: The list of vm disk details.
    :vartype vm_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentDiskInputDetails]
    :ivar vm_managed_disks: The list of vm managed disk details.
    :vartype vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentManagedDiskInputDetails]
    :ivar recovery_resource_group_id: The recovery resource group id.
    :vartype recovery_resource_group_id: str
    :ivar protection_profile: The protection profile custom details.
    :vartype protection_profile:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionProfileCustomDetails
    :ivar primary_staging_storage_account: The primary staging storage account details.
    :vartype primary_staging_storage_account:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :ivar recovery_availability_set: The recovery availability set details.
    :vartype recovery_availability_set:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryAvailabilitySetCustomDetails
    :ivar recovery_virtual_network: The recovery virtual network details.
    :vartype recovery_virtual_network:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryVirtualNetworkCustomDetails
    :ivar recovery_proximity_placement_group: The recovery proximity placement group custom
     details.
    :vartype recovery_proximity_placement_group:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryProximityPlacementGroupCustomDetails
    :ivar auto_protection_of_data_disk: A value indicating whether the auto protection is enabled.
     Known values are: "Disabled" and "Enabled".
    :vartype auto_protection_of_data_disk: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
    :ivar multi_vm_group_name: The multi vm group name.
    :vartype multi_vm_group_name: str
    :ivar multi_vm_group_id: The multi vm group id.
    :vartype multi_vm_group_id: str
    :ivar recovery_boot_diag_storage_account: The boot diagnostic storage account.
    :vartype recovery_boot_diag_storage_account:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :ivar disk_encryption_info: The recovery disk encryption information (for two pass flows).
    :vartype disk_encryption_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :ivar recovery_availability_zone: The recovery availability zone.
    :vartype recovery_availability_zone: str
    :ivar recovery_availability_type: The recovery availability type of the virtual machine.
     Required.
    :vartype recovery_availability_type: str
    :ivar agent_auto_update_status: A value indicating whether the auto update is enabled. Known
     values are: "Disabled" and "Enabled".
    :vartype agent_auto_update_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
    :ivar automation_account_arm_id: The automation account arm id.
    :vartype automation_account_arm_id: str
    :ivar automation_account_authentication_type: A value indicating the type authentication to use
     for automation Account. Known values are: "RunAsAccount" and "SystemAssignedIdentity".
    :vartype automation_account_authentication_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
    """

    _validation = {
        "instance_type": {"required": True},
        "recovery_availability_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "primary_location": {"key": "primaryLocation", "type": "str"},
        "recovery_location": {"key": "recoveryLocation", "type": "str"},
        "recovery_subscription_id": {"key": "recoverySubscriptionId", "type": "str"},
        "vm_disks": {"key": "vmDisks", "type": "[A2AProtectionIntentDiskInputDetails]"},
        "vm_managed_disks": {"key": "vmManagedDisks", "type": "[A2AProtectionIntentManagedDiskInputDetails]"},
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
        "protection_profile": {"key": "protectionProfile", "type": "ProtectionProfileCustomDetails"},
        "primary_staging_storage_account": {
            "key": "primaryStagingStorageAccount",
            "type": "StorageAccountCustomDetails",
        },
        "recovery_availability_set": {"key": "recoveryAvailabilitySet", "type": "RecoveryAvailabilitySetCustomDetails"},
        "recovery_virtual_network": {"key": "recoveryVirtualNetwork", "type": "RecoveryVirtualNetworkCustomDetails"},
        "recovery_proximity_placement_group": {
            "key": "recoveryProximityPlacementGroup",
            "type": "RecoveryProximityPlacementGroupCustomDetails",
        },
        "auto_protection_of_data_disk": {"key": "autoProtectionOfDataDisk", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "multi_vm_group_id": {"key": "multiVmGroupId", "type": "str"},
        "recovery_boot_diag_storage_account": {
            "key": "recoveryBootDiagStorageAccount",
            "type": "StorageAccountCustomDetails",
        },
        "disk_encryption_info": {"key": "diskEncryptionInfo", "type": "DiskEncryptionInfo"},
        "recovery_availability_zone": {"key": "recoveryAvailabilityZone", "type": "str"},
        "recovery_availability_type": {"key": "recoveryAvailabilityType", "type": "str"},
        "agent_auto_update_status": {"key": "agentAutoUpdateStatus", "type": "str"},
        "automation_account_arm_id": {"key": "automationAccountArmId", "type": "str"},
        "automation_account_authentication_type": {"key": "automationAccountAuthenticationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_availability_type: str,
        fabric_object_id: Optional[str] = None,
        primary_location: Optional[str] = None,
        recovery_location: Optional[str] = None,
        recovery_subscription_id: Optional[str] = None,
        vm_disks: Optional[List["_models.A2AProtectionIntentDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["_models.A2AProtectionIntentManagedDiskInputDetails"]] = None,
        recovery_resource_group_id: Optional[str] = None,
        protection_profile: Optional["_models.ProtectionProfileCustomDetails"] = None,
        primary_staging_storage_account: Optional["_models.StorageAccountCustomDetails"] = None,
        recovery_availability_set: Optional["_models.RecoveryAvailabilitySetCustomDetails"] = None,
        recovery_virtual_network: Optional["_models.RecoveryVirtualNetworkCustomDetails"] = None,
        recovery_proximity_placement_group: Optional["_models.RecoveryProximityPlacementGroupCustomDetails"] = None,
        auto_protection_of_data_disk: Optional[Union[str, "_models.AutoProtectionOfDataDisk"]] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        recovery_boot_diag_storage_account: Optional["_models.StorageAccountCustomDetails"] = None,
        disk_encryption_info: Optional["_models.DiskEncryptionInfo"] = None,
        recovery_availability_zone: Optional[str] = None,
        agent_auto_update_status: Optional[Union[str, "_models.AgentAutoUpdateStatus"]] = None,
        automation_account_arm_id: Optional[str] = None,
        automation_account_authentication_type: Optional[
            Union[str, "_models.AutomationAccountAuthenticationType"]
        ] = None,
        **kwargs
    ):
        """
        :keyword fabric_object_id: The fabric specific object Id of the virtual machine.
        :paramtype fabric_object_id: str
        :keyword primary_location: The primary location for the virtual machine.
        :paramtype primary_location: str
        :keyword recovery_location: The recovery location for the virtual machine.
        :paramtype recovery_location: str
        :keyword recovery_subscription_id: The recovery subscription Id of the virtual machine.
        :paramtype recovery_subscription_id: str
        :keyword vm_disks: The list of vm disk details.
        :paramtype vm_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentDiskInputDetails]
        :keyword vm_managed_disks: The list of vm managed disk details.
        :paramtype vm_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentManagedDiskInputDetails]
        :keyword recovery_resource_group_id: The recovery resource group id.
        :paramtype recovery_resource_group_id: str
        :keyword protection_profile: The protection profile custom details.
        :paramtype protection_profile:
         ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionProfileCustomDetails
        :keyword primary_staging_storage_account: The primary staging storage account details.
        :paramtype primary_staging_storage_account:
         ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
        :keyword recovery_availability_set: The recovery availability set details.
        :paramtype recovery_availability_set:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryAvailabilitySetCustomDetails
        :keyword recovery_virtual_network: The recovery virtual network details.
        :paramtype recovery_virtual_network:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryVirtualNetworkCustomDetails
        :keyword recovery_proximity_placement_group: The recovery proximity placement group custom
         details.
        :paramtype recovery_proximity_placement_group:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryProximityPlacementGroupCustomDetails
        :keyword auto_protection_of_data_disk: A value indicating whether the auto protection is
         enabled. Known values are: "Disabled" and "Enabled".
        :paramtype auto_protection_of_data_disk: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
        :keyword multi_vm_group_name: The multi vm group name.
        :paramtype multi_vm_group_name: str
        :keyword multi_vm_group_id: The multi vm group id.
        :paramtype multi_vm_group_id: str
        :keyword recovery_boot_diag_storage_account: The boot diagnostic storage account.
        :paramtype recovery_boot_diag_storage_account:
         ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
        :keyword disk_encryption_info: The recovery disk encryption information (for two pass flows).
        :paramtype disk_encryption_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
        :keyword recovery_availability_zone: The recovery availability zone.
        :paramtype recovery_availability_zone: str
        :keyword recovery_availability_type: The recovery availability type of the virtual machine.
         Required.
        :paramtype recovery_availability_type: str
        :keyword agent_auto_update_status: A value indicating whether the auto update is enabled. Known
         values are: "Disabled" and "Enabled".
        :paramtype agent_auto_update_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
        :keyword automation_account_arm_id: The automation account arm id.
        :paramtype automation_account_arm_id: str
        :keyword automation_account_authentication_type: A value indicating the type authentication to
         use for automation Account. Known values are: "RunAsAccount" and "SystemAssignedIdentity".
        :paramtype automation_account_authentication_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.fabric_object_id = fabric_object_id
        self.primary_location = primary_location
        self.recovery_location = recovery_location
        self.recovery_subscription_id = recovery_subscription_id
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks
        self.recovery_resource_group_id = recovery_resource_group_id
        self.protection_profile = protection_profile
        self.primary_staging_storage_account = primary_staging_storage_account
        self.recovery_availability_set = recovery_availability_set
        self.recovery_virtual_network = recovery_virtual_network
        self.recovery_proximity_placement_group = recovery_proximity_placement_group
        self.auto_protection_of_data_disk = auto_protection_of_data_disk
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_group_id = multi_vm_group_id
        self.recovery_boot_diag_storage_account = recovery_boot_diag_storage_account
        self.disk_encryption_info = disk_encryption_info
        self.recovery_availability_zone = recovery_availability_zone
        self.recovery_availability_type = recovery_availability_type
        self.agent_auto_update_status = agent_auto_update_status
        self.automation_account_arm_id = automation_account_arm_id
        self.automation_account_authentication_type = automation_account_authentication_type


class ReverseReplicationProviderSpecificInput(_serialization.Model):
    """Provider specific reverse replication input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AReprotectInput, HyperVReplicaAzureReprotectInput, InMageReprotectInput,
    InMageAzureV2ReprotectInput, InMageRcmReprotectInput, InMageRcmFailbackReprotectInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AReprotectInput",
            "HyperVReplicaAzure": "HyperVReplicaAzureReprotectInput",
            "InMage": "InMageReprotectInput",
            "InMageAzureV2": "InMageAzureV2ReprotectInput",
            "InMageRcm": "InMageRcmReprotectInput",
            "InMageRcmFailback": "InMageRcmFailbackReprotectInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AReprotectInput(ReverseReplicationProviderSpecificInput):
    """Azure specific reprotect input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_container_id: The recovery container Id.
    :vartype recovery_container_id: str
    :ivar vm_disks: The list of vm disk details.
    :vartype vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
    :ivar recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
    :vartype recovery_resource_group_id: str
    :ivar recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
    :vartype recovery_cloud_service_id: str
    :ivar recovery_availability_set_id: The recovery availability set.
    :vartype recovery_availability_set_id: str
    :ivar policy_id: The Policy Id.
    :vartype policy_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_container_id": {"key": "recoveryContainerId", "type": "str"},
        "vm_disks": {"key": "vmDisks", "type": "[A2AVmDiskInputDetails]"},
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
        "recovery_cloud_service_id": {"key": "recoveryCloudServiceId", "type": "str"},
        "recovery_availability_set_id": {"key": "recoveryAvailabilitySetId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_container_id: Optional[str] = None,
        vm_disks: Optional[List["_models.A2AVmDiskInputDetails"]] = None,
        recovery_resource_group_id: Optional[str] = None,
        recovery_cloud_service_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_container_id: The recovery container Id.
        :paramtype recovery_container_id: str
        :keyword vm_disks: The list of vm disk details.
        :paramtype vm_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
        :keyword recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
        :paramtype recovery_resource_group_id: str
        :keyword recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
        :paramtype recovery_cloud_service_id: str
        :keyword recovery_availability_set_id: The recovery availability set.
        :paramtype recovery_availability_set_id: str
        :keyword policy_id: The Policy Id.
        :paramtype policy_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_container_id = recovery_container_id
        self.vm_disks = vm_disks
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_cloud_service_id = recovery_cloud_service_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.policy_id = policy_id


class SwitchProtectionProviderSpecificInput(_serialization.Model):
    """Provider specific switch protection input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2ASwitchProtectionInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"A2A": "A2ASwitchProtectionInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2ASwitchProtectionInput(SwitchProtectionProviderSpecificInput):  # pylint: disable=too-many-instance-attributes
    """A2A specific switch protection input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar recovery_container_id: The recovery container Id.
    :vartype recovery_container_id: str
    :ivar vm_disks: The list of vm disk details.
    :vartype vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
    :ivar vm_managed_disks: The list of vm managed disk details.
    :vartype vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
    :ivar recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
    :vartype recovery_resource_group_id: str
    :ivar recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
    :vartype recovery_cloud_service_id: str
    :ivar recovery_availability_set_id: The recovery availability set.
    :vartype recovery_availability_set_id: str
    :ivar policy_id: The Policy Id.
    :vartype policy_id: str
    :ivar recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
    :vartype recovery_boot_diag_storage_account_id: str
    :ivar recovery_availability_zone: The recovery availability zone.
    :vartype recovery_availability_zone: str
    :ivar recovery_proximity_placement_group_id: The recovery proximity placement group Id.
    :vartype recovery_proximity_placement_group_id: str
    :ivar recovery_virtual_machine_scale_set_id: The virtual machine scale set id.
    :vartype recovery_virtual_machine_scale_set_id: str
    :ivar recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
    :vartype recovery_capacity_reservation_group_id: str
    :ivar disk_encryption_info: The recovery disk encryption information.
    :vartype disk_encryption_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_container_id": {"key": "recoveryContainerId", "type": "str"},
        "vm_disks": {"key": "vmDisks", "type": "[A2AVmDiskInputDetails]"},
        "vm_managed_disks": {"key": "vmManagedDisks", "type": "[A2AVmManagedDiskInputDetails]"},
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
        "recovery_cloud_service_id": {"key": "recoveryCloudServiceId", "type": "str"},
        "recovery_availability_set_id": {"key": "recoveryAvailabilitySetId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "recovery_boot_diag_storage_account_id": {"key": "recoveryBootDiagStorageAccountId", "type": "str"},
        "recovery_availability_zone": {"key": "recoveryAvailabilityZone", "type": "str"},
        "recovery_proximity_placement_group_id": {"key": "recoveryProximityPlacementGroupId", "type": "str"},
        "recovery_virtual_machine_scale_set_id": {"key": "recoveryVirtualMachineScaleSetId", "type": "str"},
        "recovery_capacity_reservation_group_id": {"key": "recoveryCapacityReservationGroupId", "type": "str"},
        "disk_encryption_info": {"key": "diskEncryptionInfo", "type": "DiskEncryptionInfo"},
    }

    def __init__(
        self,
        *,
        recovery_container_id: Optional[str] = None,
        vm_disks: Optional[List["_models.A2AVmDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["_models.A2AVmManagedDiskInputDetails"]] = None,
        recovery_resource_group_id: Optional[str] = None,
        recovery_cloud_service_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        recovery_boot_diag_storage_account_id: Optional[str] = None,
        recovery_availability_zone: Optional[str] = None,
        recovery_proximity_placement_group_id: Optional[str] = None,
        recovery_virtual_machine_scale_set_id: Optional[str] = None,
        recovery_capacity_reservation_group_id: Optional[str] = None,
        disk_encryption_info: Optional["_models.DiskEncryptionInfo"] = None,
        **kwargs
    ):
        """
        :keyword recovery_container_id: The recovery container Id.
        :paramtype recovery_container_id: str
        :keyword vm_disks: The list of vm disk details.
        :paramtype vm_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
        :keyword vm_managed_disks: The list of vm managed disk details.
        :paramtype vm_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
        :keyword recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
        :paramtype recovery_resource_group_id: str
        :keyword recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
        :paramtype recovery_cloud_service_id: str
        :keyword recovery_availability_set_id: The recovery availability set.
        :paramtype recovery_availability_set_id: str
        :keyword policy_id: The Policy Id.
        :paramtype policy_id: str
        :keyword recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
        :paramtype recovery_boot_diag_storage_account_id: str
        :keyword recovery_availability_zone: The recovery availability zone.
        :paramtype recovery_availability_zone: str
        :keyword recovery_proximity_placement_group_id: The recovery proximity placement group Id.
        :paramtype recovery_proximity_placement_group_id: str
        :keyword recovery_virtual_machine_scale_set_id: The virtual machine scale set id.
        :paramtype recovery_virtual_machine_scale_set_id: str
        :keyword recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
        :paramtype recovery_capacity_reservation_group_id: str
        :keyword disk_encryption_info: The recovery disk encryption information.
        :paramtype disk_encryption_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_container_id = recovery_container_id
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_cloud_service_id = recovery_cloud_service_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.policy_id = policy_id
        self.recovery_boot_diag_storage_account_id = recovery_boot_diag_storage_account_id
        self.recovery_availability_zone = recovery_availability_zone
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id
        self.recovery_virtual_machine_scale_set_id = recovery_virtual_machine_scale_set_id
        self.recovery_capacity_reservation_group_id = recovery_capacity_reservation_group_id
        self.disk_encryption_info = disk_encryption_info


class TestFailoverProviderSpecificInput(_serialization.Model):
    """Provider specific test failover input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2ATestFailoverInput, HyperVReplicaAzureTestFailoverInput, InMageTestFailoverInput,
    InMageAzureV2TestFailoverInput, InMageRcmTestFailoverInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2ATestFailoverInput",
            "HyperVReplicaAzure": "HyperVReplicaAzureTestFailoverInput",
            "InMage": "InMageTestFailoverInput",
            "InMageAzureV2": "InMageAzureV2TestFailoverInput",
            "InMageRcm": "InMageRcmTestFailoverInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2ATestFailoverInput(TestFailoverProviderSpecificInput):
    """A2A provider specific input for test failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    :ivar cloud_service_creation_option: A value indicating whether to use recovery cloud service
     for TFO or not.
    :vartype cloud_service_creation_option: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "cloud_service_creation_option": {"key": "cloudServiceCreationOption", "type": "str"},
    }

    def __init__(
        self, *, recovery_point_id: Optional[str] = None, cloud_service_creation_option: Optional[str] = None, **kwargs
    ):
        """
        :keyword recovery_point_id: The recovery point id to be passed to test failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        :keyword cloud_service_creation_option: A value indicating whether to use recovery cloud
         service for TFO or not.
        :paramtype cloud_service_creation_option: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_point_id = recovery_point_id
        self.cloud_service_creation_option = cloud_service_creation_option


class UnplannedFailoverProviderSpecificInput(_serialization.Model):
    """Provider specific unplanned failover input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AUnplannedFailoverInput, HyperVReplicaAzureUnplannedFailoverInput,
    InMageUnplannedFailoverInput, InMageAzureV2UnplannedFailoverInput,
    InMageRcmUnplannedFailoverInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AUnplannedFailoverInput",
            "HyperVReplicaAzure": "HyperVReplicaAzureUnplannedFailoverInput",
            "InMage": "InMageUnplannedFailoverInput",
            "InMageAzureV2": "InMageAzureV2UnplannedFailoverInput",
            "InMageRcm": "InMageRcmUnplannedFailoverInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AUnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """A2A provider specific input for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    :ivar cloud_service_creation_option: A value indicating whether to use recovery cloud service
     for failover or not.
    :vartype cloud_service_creation_option: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "cloud_service_creation_option": {"key": "cloudServiceCreationOption", "type": "str"},
    }

    def __init__(
        self, *, recovery_point_id: Optional[str] = None, cloud_service_creation_option: Optional[str] = None, **kwargs
    ):
        """
        :keyword recovery_point_id: The recovery point id to be passed to failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        :keyword cloud_service_creation_option: A value indicating whether to use recovery cloud
         service for failover or not.
        :paramtype cloud_service_creation_option: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_point_id = recovery_point_id
        self.cloud_service_creation_option = cloud_service_creation_option


class A2AUnprotectedDiskDetails(_serialization.Model):
    """A2A unprotected disk details.

    :ivar disk_lun_id: The source lun Id for the data disk.
    :vartype disk_lun_id: int
    :ivar disk_auto_protection_status: A value indicating whether the disk auto protection is
     enabled. Known values are: "Disabled" and "Enabled".
    :vartype disk_auto_protection_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
    """

    _attribute_map = {
        "disk_lun_id": {"key": "diskLunId", "type": "int"},
        "disk_auto_protection_status": {"key": "diskAutoProtectionStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_lun_id: Optional[int] = None,
        disk_auto_protection_status: Optional[Union[str, "_models.AutoProtectionOfDataDisk"]] = None,
        **kwargs
    ):
        """
        :keyword disk_lun_id: The source lun Id for the data disk.
        :paramtype disk_lun_id: int
        :keyword disk_auto_protection_status: A value indicating whether the disk auto protection is
         enabled. Known values are: "Disabled" and "Enabled".
        :paramtype disk_auto_protection_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
        """
        super().__init__(**kwargs)
        self.disk_lun_id = disk_lun_id
        self.disk_auto_protection_status = disk_auto_protection_status


class ReplicationProviderSpecificUpdateContainerMappingInput(_serialization.Model):
    """Provider specific input for update pairing operations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AUpdateContainerMappingInput, InMageRcmUpdateContainerMappingInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {"A2A": "A2AUpdateContainerMappingInput", "InMageRcm": "InMageRcmUpdateContainerMappingInput"}
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AUpdateContainerMappingInput(ReplicationProviderSpecificUpdateContainerMappingInput):
    """A2A update protection container mapping.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar agent_auto_update_status: A value indicating whether the auto update is enabled. Known
     values are: "Disabled" and "Enabled".
    :vartype agent_auto_update_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
    :ivar automation_account_arm_id: The automation account arm id.
    :vartype automation_account_arm_id: str
    :ivar automation_account_authentication_type: A value indicating the type authentication to use
     for automation Account. Known values are: "RunAsAccount" and "SystemAssignedIdentity".
    :vartype automation_account_authentication_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "agent_auto_update_status": {"key": "agentAutoUpdateStatus", "type": "str"},
        "automation_account_arm_id": {"key": "automationAccountArmId", "type": "str"},
        "automation_account_authentication_type": {"key": "automationAccountAuthenticationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        agent_auto_update_status: Optional[Union[str, "_models.AgentAutoUpdateStatus"]] = None,
        automation_account_arm_id: Optional[str] = None,
        automation_account_authentication_type: Optional[
            Union[str, "_models.AutomationAccountAuthenticationType"]
        ] = None,
        **kwargs
    ):
        """
        :keyword agent_auto_update_status: A value indicating whether the auto update is enabled. Known
         values are: "Disabled" and "Enabled".
        :paramtype agent_auto_update_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
        :keyword automation_account_arm_id: The automation account arm id.
        :paramtype automation_account_arm_id: str
        :keyword automation_account_authentication_type: A value indicating the type authentication to
         use for automation Account. Known values are: "RunAsAccount" and "SystemAssignedIdentity".
        :paramtype automation_account_authentication_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AutomationAccountAuthenticationType
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.agent_auto_update_status = agent_auto_update_status
        self.automation_account_arm_id = automation_account_arm_id
        self.automation_account_authentication_type = automation_account_authentication_type


class UpdateReplicationProtectedItemProviderInput(_serialization.Model):
    """Update replication protected item provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2AUpdateReplicationProtectedItemInput, HyperVReplicaAzureUpdateReplicationProtectedItemInput,
    InMageAzureV2UpdateReplicationProtectedItemInput, InMageRcmUpdateReplicationProtectedItemInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "A2AUpdateReplicationProtectedItemInput",
            "HyperVReplicaAzure": "HyperVReplicaAzureUpdateReplicationProtectedItemInput",
            "InMageAzureV2": "InMageAzureV2UpdateReplicationProtectedItemInput",
            "InMageRcm": "InMageRcmUpdateReplicationProtectedItemInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class A2AUpdateReplicationProtectedItemInput(UpdateReplicationProtectedItemProviderInput):
    """InMage Azure V2 input to update replication protected item.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_cloud_service_id: The target cloud service ARM Id (for V1).
    :vartype recovery_cloud_service_id: str
    :ivar recovery_resource_group_id: The target resource group ARM Id (for V2).
    :vartype recovery_resource_group_id: str
    :ivar managed_disk_update_details: Managed disk update details.
    :vartype managed_disk_update_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskUpdateDetails]
    :ivar recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
    :vartype recovery_boot_diag_storage_account_id: str
    :ivar disk_encryption_info: The recovery os disk encryption information.
    :vartype disk_encryption_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :ivar tfo_azure_vm_name: The user given name for Test Failover VM.
    :vartype tfo_azure_vm_name: str
    :ivar recovery_proximity_placement_group_id: The recovery proximity placement group Id.
    :vartype recovery_proximity_placement_group_id: str
    :ivar recovery_virtual_machine_scale_set_id: The recovery virtual machine scale set Id.
    :vartype recovery_virtual_machine_scale_set_id: str
    :ivar recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
    :vartype recovery_capacity_reservation_group_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_cloud_service_id": {"key": "recoveryCloudServiceId", "type": "str"},
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
        "managed_disk_update_details": {"key": "managedDiskUpdateDetails", "type": "[A2AVmManagedDiskUpdateDetails]"},
        "recovery_boot_diag_storage_account_id": {"key": "recoveryBootDiagStorageAccountId", "type": "str"},
        "disk_encryption_info": {"key": "diskEncryptionInfo", "type": "DiskEncryptionInfo"},
        "tfo_azure_vm_name": {"key": "tfoAzureVMName", "type": "str"},
        "recovery_proximity_placement_group_id": {"key": "recoveryProximityPlacementGroupId", "type": "str"},
        "recovery_virtual_machine_scale_set_id": {"key": "recoveryVirtualMachineScaleSetId", "type": "str"},
        "recovery_capacity_reservation_group_id": {"key": "recoveryCapacityReservationGroupId", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_cloud_service_id: Optional[str] = None,
        recovery_resource_group_id: Optional[str] = None,
        managed_disk_update_details: Optional[List["_models.A2AVmManagedDiskUpdateDetails"]] = None,
        recovery_boot_diag_storage_account_id: Optional[str] = None,
        disk_encryption_info: Optional["_models.DiskEncryptionInfo"] = None,
        tfo_azure_vm_name: Optional[str] = None,
        recovery_proximity_placement_group_id: Optional[str] = None,
        recovery_virtual_machine_scale_set_id: Optional[str] = None,
        recovery_capacity_reservation_group_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_cloud_service_id: The target cloud service ARM Id (for V1).
        :paramtype recovery_cloud_service_id: str
        :keyword recovery_resource_group_id: The target resource group ARM Id (for V2).
        :paramtype recovery_resource_group_id: str
        :keyword managed_disk_update_details: Managed disk update details.
        :paramtype managed_disk_update_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskUpdateDetails]
        :keyword recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
        :paramtype recovery_boot_diag_storage_account_id: str
        :keyword disk_encryption_info: The recovery os disk encryption information.
        :paramtype disk_encryption_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
        :keyword tfo_azure_vm_name: The user given name for Test Failover VM.
        :paramtype tfo_azure_vm_name: str
        :keyword recovery_proximity_placement_group_id: The recovery proximity placement group Id.
        :paramtype recovery_proximity_placement_group_id: str
        :keyword recovery_virtual_machine_scale_set_id: The recovery virtual machine scale set Id.
        :paramtype recovery_virtual_machine_scale_set_id: str
        :keyword recovery_capacity_reservation_group_id: The recovery capacity reservation group Id.
        :paramtype recovery_capacity_reservation_group_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_cloud_service_id = recovery_cloud_service_id
        self.recovery_resource_group_id = recovery_resource_group_id
        self.managed_disk_update_details = managed_disk_update_details
        self.recovery_boot_diag_storage_account_id = recovery_boot_diag_storage_account_id
        self.disk_encryption_info = disk_encryption_info
        self.tfo_azure_vm_name = tfo_azure_vm_name
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id
        self.recovery_virtual_machine_scale_set_id = recovery_virtual_machine_scale_set_id
        self.recovery_capacity_reservation_group_id = recovery_capacity_reservation_group_id


class A2AVmDiskInputDetails(_serialization.Model):
    """A2A disk input details.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_uri: The disk Uri. Required.
    :vartype disk_uri: str
    :ivar recovery_azure_storage_account_id: The recovery VHD storage account Id. Required.
    :vartype recovery_azure_storage_account_id: str
    :ivar primary_staging_azure_storage_account_id: The primary staging storage account Id.
     Required.
    :vartype primary_staging_azure_storage_account_id: str
    """

    _validation = {
        "disk_uri": {"required": True},
        "recovery_azure_storage_account_id": {"required": True},
        "primary_staging_azure_storage_account_id": {"required": True},
    }

    _attribute_map = {
        "disk_uri": {"key": "diskUri", "type": "str"},
        "recovery_azure_storage_account_id": {"key": "recoveryAzureStorageAccountId", "type": "str"},
        "primary_staging_azure_storage_account_id": {"key": "primaryStagingAzureStorageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_uri: str,
        recovery_azure_storage_account_id: str,
        primary_staging_azure_storage_account_id: str,
        **kwargs
    ):
        """
        :keyword disk_uri: The disk Uri. Required.
        :paramtype disk_uri: str
        :keyword recovery_azure_storage_account_id: The recovery VHD storage account Id. Required.
        :paramtype recovery_azure_storage_account_id: str
        :keyword primary_staging_azure_storage_account_id: The primary staging storage account Id.
         Required.
        :paramtype primary_staging_azure_storage_account_id: str
        """
        super().__init__(**kwargs)
        self.disk_uri = disk_uri
        self.recovery_azure_storage_account_id = recovery_azure_storage_account_id
        self.primary_staging_azure_storage_account_id = primary_staging_azure_storage_account_id


class A2AVmManagedDiskInputDetails(_serialization.Model):
    """A2A managed disk input details.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_id: The disk Id. Required.
    :vartype disk_id: str
    :ivar primary_staging_azure_storage_account_id: The primary staging storage account Arm Id.
     Required.
    :vartype primary_staging_azure_storage_account_id: str
    :ivar recovery_resource_group_id: The target resource group Arm Id. Required.
    :vartype recovery_resource_group_id: str
    :ivar recovery_replica_disk_account_type: The replica disk type. Its an optional value and will
     be same as source disk type if not user provided.
    :vartype recovery_replica_disk_account_type: str
    :ivar recovery_target_disk_account_type: The target disk type after failover. Its an optional
     value and will be same as source disk type if not user provided.
    :vartype recovery_target_disk_account_type: str
    :ivar recovery_disk_encryption_set_id: The recovery disk encryption set Id.
    :vartype recovery_disk_encryption_set_id: str
    :ivar disk_encryption_info: The recovery disk encryption information (for one / single pass
     flows).
    :vartype disk_encryption_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    """

    _validation = {
        "disk_id": {"required": True},
        "primary_staging_azure_storage_account_id": {"required": True},
        "recovery_resource_group_id": {"required": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "primary_staging_azure_storage_account_id": {"key": "primaryStagingAzureStorageAccountId", "type": "str"},
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
        "recovery_replica_disk_account_type": {"key": "recoveryReplicaDiskAccountType", "type": "str"},
        "recovery_target_disk_account_type": {"key": "recoveryTargetDiskAccountType", "type": "str"},
        "recovery_disk_encryption_set_id": {"key": "recoveryDiskEncryptionSetId", "type": "str"},
        "disk_encryption_info": {"key": "diskEncryptionInfo", "type": "DiskEncryptionInfo"},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        primary_staging_azure_storage_account_id: str,
        recovery_resource_group_id: str,
        recovery_replica_disk_account_type: Optional[str] = None,
        recovery_target_disk_account_type: Optional[str] = None,
        recovery_disk_encryption_set_id: Optional[str] = None,
        disk_encryption_info: Optional["_models.DiskEncryptionInfo"] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk Id. Required.
        :paramtype disk_id: str
        :keyword primary_staging_azure_storage_account_id: The primary staging storage account Arm Id.
         Required.
        :paramtype primary_staging_azure_storage_account_id: str
        :keyword recovery_resource_group_id: The target resource group Arm Id. Required.
        :paramtype recovery_resource_group_id: str
        :keyword recovery_replica_disk_account_type: The replica disk type. Its an optional value and
         will be same as source disk type if not user provided.
        :paramtype recovery_replica_disk_account_type: str
        :keyword recovery_target_disk_account_type: The target disk type after failover. Its an
         optional value and will be same as source disk type if not user provided.
        :paramtype recovery_target_disk_account_type: str
        :keyword recovery_disk_encryption_set_id: The recovery disk encryption set Id.
        :paramtype recovery_disk_encryption_set_id: str
        :keyword disk_encryption_info: The recovery disk encryption information (for one / single pass
         flows).
        :paramtype disk_encryption_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.primary_staging_azure_storage_account_id = primary_staging_azure_storage_account_id
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_replica_disk_account_type = recovery_replica_disk_account_type
        self.recovery_target_disk_account_type = recovery_target_disk_account_type
        self.recovery_disk_encryption_set_id = recovery_disk_encryption_set_id
        self.disk_encryption_info = disk_encryption_info


class A2AVmManagedDiskUpdateDetails(_serialization.Model):
    """A2A Vm managed disk update details.

    :ivar disk_id: The disk Id.
    :vartype disk_id: str
    :ivar recovery_target_disk_account_type: The target disk type before failover.
    :vartype recovery_target_disk_account_type: str
    :ivar recovery_replica_disk_account_type: The replica disk type before failover.
    :vartype recovery_replica_disk_account_type: str
    :ivar disk_encryption_info: The recovery os disk encryption information.
    :vartype disk_encryption_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :ivar failover_disk_name: The target disk name for unplanned failover operation.
    :vartype failover_disk_name: str
    :ivar tfo_disk_name: The target disk name for test failover operation.
    :vartype tfo_disk_name: str
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "recovery_target_disk_account_type": {"key": "recoveryTargetDiskAccountType", "type": "str"},
        "recovery_replica_disk_account_type": {"key": "recoveryReplicaDiskAccountType", "type": "str"},
        "disk_encryption_info": {"key": "diskEncryptionInfo", "type": "DiskEncryptionInfo"},
        "failover_disk_name": {"key": "failoverDiskName", "type": "str"},
        "tfo_disk_name": {"key": "tfoDiskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        recovery_target_disk_account_type: Optional[str] = None,
        recovery_replica_disk_account_type: Optional[str] = None,
        disk_encryption_info: Optional["_models.DiskEncryptionInfo"] = None,
        failover_disk_name: Optional[str] = None,
        tfo_disk_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk Id.
        :paramtype disk_id: str
        :keyword recovery_target_disk_account_type: The target disk type before failover.
        :paramtype recovery_target_disk_account_type: str
        :keyword recovery_replica_disk_account_type: The replica disk type before failover.
        :paramtype recovery_replica_disk_account_type: str
        :keyword disk_encryption_info: The recovery os disk encryption information.
        :paramtype disk_encryption_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
        :keyword failover_disk_name: The target disk name for unplanned failover operation.
        :paramtype failover_disk_name: str
        :keyword tfo_disk_name: The target disk name for test failover operation.
        :paramtype tfo_disk_name: str
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.recovery_target_disk_account_type = recovery_target_disk_account_type
        self.recovery_replica_disk_account_type = recovery_replica_disk_account_type
        self.disk_encryption_info = disk_encryption_info
        self.failover_disk_name = failover_disk_name
        self.tfo_disk_name = tfo_disk_name


class A2AZoneDetails(_serialization.Model):
    """Zone details data.

    :ivar source: Source zone info.
    :vartype source: str
    :ivar target: The target zone info.
    :vartype target: str
    """

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, *, source: Optional[str] = None, target: Optional[str] = None, **kwargs):
        """
        :keyword source: Source zone info.
        :paramtype source: str
        :keyword target: The target zone info.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.source = source
        self.target = target


class AddDisksInput(_serialization.Model):
    """Input for add disk(s) operation.

    :ivar properties: Add disks input properties.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksInputProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "AddDisksInputProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AddDisksInputProperties"] = None, **kwargs):
        """
        :keyword properties: Add disks input properties.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AddDisksInputProperties(_serialization.Model):
    """Add Disks input properties.

    All required parameters must be populated in order to send to Azure.

    :ivar provider_specific_details: The ReplicationProviderInput. For HyperVReplicaAzure provider,
     it will be AzureEnableProtectionInput object. For San provider, it will be
     SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null. Required.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksProviderSpecificInput
    """

    _validation = {
        "provider_specific_details": {"required": True},
    }

    _attribute_map = {
        "provider_specific_details": {"key": "providerSpecificDetails", "type": "AddDisksProviderSpecificInput"},
    }

    def __init__(self, *, provider_specific_details: "_models.AddDisksProviderSpecificInput", **kwargs):
        """
        :keyword provider_specific_details: The ReplicationProviderInput. For HyperVReplicaAzure
         provider, it will be AzureEnableProtectionInput object. For San provider, it will be
         SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null. Required.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksProviderSpecificInput
        """
        super().__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class AddRecoveryServicesProviderInput(_serialization.Model):
    """Input required to add a provider.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: The properties of an add provider request. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.AddRecoveryServicesProviderInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "AddRecoveryServicesProviderInputProperties"},
    }

    def __init__(self, *, properties: "_models.AddRecoveryServicesProviderInputProperties", **kwargs):
        """
        :keyword properties: The properties of an add provider request. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.AddRecoveryServicesProviderInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AddRecoveryServicesProviderInputProperties(_serialization.Model):
    """The properties of an add provider request.

    All required parameters must be populated in order to send to Azure.

    :ivar machine_name: The name of the machine where the provider is getting added. Required.
    :vartype machine_name: str
    :ivar machine_id: The Id of the machine where the provider is getting added.
    :vartype machine_id: str
    :ivar bios_id: The Bios Id of the machine.
    :vartype bios_id: str
    :ivar authentication_identity_input: The identity provider input for DRA authentication.
     Required.
    :vartype authentication_identity_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
    :ivar resource_access_identity_input: The identity provider input for resource access.
     Required.
    :vartype resource_access_identity_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
    :ivar data_plane_authentication_identity_input: The identity provider input for data plane
     authentication.
    :vartype data_plane_authentication_identity_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
    """

    _validation = {
        "machine_name": {"required": True},
        "authentication_identity_input": {"required": True},
        "resource_access_identity_input": {"required": True},
    }

    _attribute_map = {
        "machine_name": {"key": "machineName", "type": "str"},
        "machine_id": {"key": "machineId", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "authentication_identity_input": {"key": "authenticationIdentityInput", "type": "IdentityProviderInput"},
        "resource_access_identity_input": {"key": "resourceAccessIdentityInput", "type": "IdentityProviderInput"},
        "data_plane_authentication_identity_input": {
            "key": "dataPlaneAuthenticationIdentityInput",
            "type": "IdentityProviderInput",
        },
    }

    def __init__(
        self,
        *,
        machine_name: str,
        authentication_identity_input: "_models.IdentityProviderInput",
        resource_access_identity_input: "_models.IdentityProviderInput",
        machine_id: Optional[str] = None,
        bios_id: Optional[str] = None,
        data_plane_authentication_identity_input: Optional["_models.IdentityProviderInput"] = None,
        **kwargs
    ):
        """
        :keyword machine_name: The name of the machine where the provider is getting added. Required.
        :paramtype machine_name: str
        :keyword machine_id: The Id of the machine where the provider is getting added.
        :paramtype machine_id: str
        :keyword bios_id: The Bios Id of the machine.
        :paramtype bios_id: str
        :keyword authentication_identity_input: The identity provider input for DRA authentication.
         Required.
        :paramtype authentication_identity_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
        :keyword resource_access_identity_input: The identity provider input for resource access.
         Required.
        :paramtype resource_access_identity_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
        :keyword data_plane_authentication_identity_input: The identity provider input for data plane
         authentication.
        :paramtype data_plane_authentication_identity_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
        """
        super().__init__(**kwargs)
        self.machine_name = machine_name
        self.machine_id = machine_id
        self.bios_id = bios_id
        self.authentication_identity_input = authentication_identity_input
        self.resource_access_identity_input = resource_access_identity_input
        self.data_plane_authentication_identity_input = data_plane_authentication_identity_input


class AddVCenterRequest(_serialization.Model):
    """Input required to add vCenter.

    :ivar properties: The properties of an add vCenter request.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.AddVCenterRequestProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "AddVCenterRequestProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AddVCenterRequestProperties"] = None, **kwargs):
        """
        :keyword properties: The properties of an add vCenter request.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.AddVCenterRequestProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AddVCenterRequestProperties(_serialization.Model):
    """The properties of an add vCenter request.

    :ivar friendly_name: The friendly name of the vCenter.
    :vartype friendly_name: str
    :ivar ip_address: The IP address of the vCenter to be discovered.
    :vartype ip_address: str
    :ivar process_server_id: The process server Id from where the discovery is orchestrated.
    :vartype process_server_id: str
    :ivar port: The port number for discovery.
    :vartype port: str
    :ivar run_as_account_id: The account Id which has privileges to discover the vCenter.
    :vartype run_as_account_id: str
    """

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "port": {"key": "port", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        ip_address: Optional[str] = None,
        process_server_id: Optional[str] = None,
        port: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword friendly_name: The friendly name of the vCenter.
        :paramtype friendly_name: str
        :keyword ip_address: The IP address of the vCenter to be discovered.
        :paramtype ip_address: str
        :keyword process_server_id: The process server Id from where the discovery is orchestrated.
        :paramtype process_server_id: str
        :keyword port: The port number for discovery.
        :paramtype port: str
        :keyword run_as_account_id: The account Id which has privileges to discover the vCenter.
        :paramtype run_as_account_id: str
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.ip_address = ip_address
        self.process_server_id = process_server_id
        self.port = port
        self.run_as_account_id = run_as_account_id


class AgentDetails(_serialization.Model):
    """Agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar agent_id: The Id of the agent running on the server.
    :vartype agent_id: str
    :ivar machine_id: The Id of the machine to which the agent is registered.
    :vartype machine_id: str
    :ivar bios_id: The machine BIOS Id.
    :vartype bios_id: str
    :ivar fqdn: The machine FQDN.
    :vartype fqdn: str
    :ivar disks: The disks.
    :vartype disks: list[~azure.mgmt.recoveryservicessiterecovery.models.AgentDiskDetails]
    """

    _validation = {
        "agent_id": {"readonly": True},
        "machine_id": {"readonly": True},
        "bios_id": {"readonly": True},
        "fqdn": {"readonly": True},
        "disks": {"readonly": True},
    }

    _attribute_map = {
        "agent_id": {"key": "agentId", "type": "str"},
        "machine_id": {"key": "machineId", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "disks": {"key": "disks", "type": "[AgentDiskDetails]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.agent_id = None
        self.machine_id = None
        self.bios_id = None
        self.fqdn = None
        self.disks = None


class AgentDiskDetails(_serialization.Model):
    """Agent disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_id: The disk Id.
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar is_os_disk: A value indicating whether the disk is the OS disk.
    :vartype is_os_disk: str
    :ivar capacity_in_bytes: The disk capacity in bytes.
    :vartype capacity_in_bytes: int
    :ivar lun_id: The lun of disk.
    :vartype lun_id: int
    """

    _validation = {
        "disk_id": {"readonly": True},
        "disk_name": {"readonly": True},
        "is_os_disk": {"readonly": True},
        "capacity_in_bytes": {"readonly": True},
        "lun_id": {"readonly": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_name": {"key": "diskName", "type": "str"},
        "is_os_disk": {"key": "isOSDisk", "type": "str"},
        "capacity_in_bytes": {"key": "capacityInBytes", "type": "int"},
        "lun_id": {"key": "lunId", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.disk_id = None
        self.disk_name = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.lun_id = None


class Resource(_serialization.Model):
    """Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location


class Alert(Resource):
    """Implements the Alert class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: Alert related data.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.AlertProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AlertProperties"},
    }

    def __init__(
        self, *, location: Optional[str] = None, properties: Optional["_models.AlertProperties"] = None, **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: Alert related data.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.AlertProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class AlertCollection(_serialization.Model):
    """Collection of alerts.

    :ivar value: The list of alerts.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Alert]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Alert]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Alert"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of alerts.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Alert]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AlertProperties(_serialization.Model):
    """The properties of an alert.

    :ivar send_to_owners: A value indicating whether to send email to subscription administrator.
    :vartype send_to_owners: str
    :ivar custom_email_addresses: The custom email address for sending emails.
    :vartype custom_email_addresses: list[str]
    :ivar locale: The locale for the email notification.
    :vartype locale: str
    """

    _attribute_map = {
        "send_to_owners": {"key": "sendToOwners", "type": "str"},
        "custom_email_addresses": {"key": "customEmailAddresses", "type": "[str]"},
        "locale": {"key": "locale", "type": "str"},
    }

    def __init__(
        self,
        *,
        send_to_owners: Optional[str] = None,
        custom_email_addresses: Optional[List[str]] = None,
        locale: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword send_to_owners: A value indicating whether to send email to subscription
         administrator.
        :paramtype send_to_owners: str
        :keyword custom_email_addresses: The custom email address for sending emails.
        :paramtype custom_email_addresses: list[str]
        :keyword locale: The locale for the email notification.
        :paramtype locale: str
        """
        super().__init__(**kwargs)
        self.send_to_owners = send_to_owners
        self.custom_email_addresses = custom_email_addresses
        self.locale = locale


class ApplianceCollection(_serialization.Model):
    """Collection of appliance details.

    :ivar value: The appliance details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationAppliance]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ReplicationAppliance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ReplicationAppliance"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The appliance details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationAppliance]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplianceQueryParameter(_serialization.Model):
    """Query parameter to get appliance.

    :ivar provider_type: The providerType to be used for fetching appliance details.
    :vartype provider_type: str
    """

    _attribute_map = {
        "provider_type": {"key": "providerType", "type": "str"},
    }

    def __init__(self, *, provider_type: Optional[str] = None, **kwargs):
        """
        :keyword provider_type: The providerType to be used for fetching appliance details.
        :paramtype provider_type: str
        """
        super().__init__(**kwargs)
        self.provider_type = provider_type


class ApplianceSpecificDetails(_serialization.Model):
    """Appliance specific details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InMageRcmApplianceSpecificDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"InMageRcm": "InMageRcmApplianceSpecificDetails"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class ApplyRecoveryPointInput(_serialization.Model):
    """Input to apply recovery point.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: The input properties to apply recovery point. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ApplyRecoveryPointInputProperties"},
    }

    def __init__(self, *, properties: "_models.ApplyRecoveryPointInputProperties", **kwargs):
        """
        :keyword properties: The input properties to apply recovery point. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ApplyRecoveryPointInputProperties(_serialization.Model):
    """Input properties to apply recovery point.

    All required parameters must be populated in order to send to Azure.

    :ivar recovery_point_id: The recovery point Id.
    :vartype recovery_point_id: str
    :ivar provider_specific_details: Provider specific input for applying recovery point. Required.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointProviderSpecificInput
    """

    _validation = {
        "provider_specific_details": {"required": True},
    }

    _attribute_map = {
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "ApplyRecoveryPointProviderSpecificInput",
        },
    }

    def __init__(
        self,
        *,
        provider_specific_details: "_models.ApplyRecoveryPointProviderSpecificInput",
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_id: The recovery point Id.
        :paramtype recovery_point_id: str
        :keyword provider_specific_details: Provider specific input for applying recovery point.
         Required.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointProviderSpecificInput
        """
        super().__init__(**kwargs)
        self.recovery_point_id = recovery_point_id
        self.provider_specific_details = provider_specific_details


class JobDetails(_serialization.Model):
    """Job details based on specific job type.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AsrJobDetails, ExportJobDetails, FailoverJobDetails, SwitchProtectionJobDetails,
    TestFailoverJobDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the type of job details (see JobDetailsTypes enum for possible
     values). Required.
    :vartype instance_type: str
    :ivar affected_object_details: The affected object properties like source server, source cloud,
     target server, target cloud etc. based on the workflow object details.
    :vartype affected_object_details: dict[str, str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "affected_object_details": {"key": "affectedObjectDetails", "type": "{str}"},
    }

    _subtype_map = {
        "instance_type": {
            "AsrJobDetails": "AsrJobDetails",
            "ExportJobDetails": "ExportJobDetails",
            "FailoverJobDetails": "FailoverJobDetails",
            "SwitchProtectionJobDetails": "SwitchProtectionJobDetails",
            "TestFailoverJobDetails": "TestFailoverJobDetails",
        }
    }

    def __init__(self, *, affected_object_details: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword affected_object_details: The affected object properties like source server, source
         cloud, target server, target cloud etc. based on the workflow object details.
        :paramtype affected_object_details: dict[str, str]
        """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None
        self.affected_object_details = affected_object_details


class AsrJobDetails(JobDetails):
    """This class represents job details based on specific job type.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the type of job details (see JobDetailsTypes enum for possible
     values). Required.
    :vartype instance_type: str
    :ivar affected_object_details: The affected object properties like source server, source cloud,
     target server, target cloud etc. based on the workflow object details.
    :vartype affected_object_details: dict[str, str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "affected_object_details": {"key": "affectedObjectDetails", "type": "{str}"},
    }

    def __init__(self, *, affected_object_details: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword affected_object_details: The affected object properties like source server, source
         cloud, target server, target cloud etc. based on the workflow object details.
        :paramtype affected_object_details: dict[str, str]
        """
        super().__init__(affected_object_details=affected_object_details, **kwargs)
        self.instance_type: str = "AsrJobDetails"


class ASRTask(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Task of the Job.

    :ivar task_id: The Id.
    :vartype task_id: str
    :ivar name: The unique Task name.
    :vartype name: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar allowed_actions: The state/actions applicable on this task.
    :vartype allowed_actions: list[str]
    :ivar friendly_name: The name.
    :vartype friendly_name: str
    :ivar state: The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed,
     Cancelled, Suspended or Other.
    :vartype state: str
    :ivar state_description: The description of the task state. For example - For Succeeded state,
     description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
    :vartype state_description: str
    :ivar task_type: The type of task. Details in CustomDetails property depend on this type.
    :vartype task_type: str
    :ivar custom_details: The custom task details based on the task type.
    :vartype custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.TaskTypeDetails
    :ivar group_task_custom_details: The custom task details based on the task type, if the task
     type is GroupTaskDetails or one of the types derived from it.
    :vartype group_task_custom_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.GroupTaskDetails
    :ivar errors: The task error details.
    :vartype errors: list[~azure.mgmt.recoveryservicessiterecovery.models.JobErrorDetails]
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "allowed_actions": {"key": "allowedActions", "type": "[str]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_description": {"key": "stateDescription", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "custom_details": {"key": "customDetails", "type": "TaskTypeDetails"},
        "group_task_custom_details": {"key": "groupTaskCustomDetails", "type": "GroupTaskDetails"},
        "errors": {"key": "errors", "type": "[JobErrorDetails]"},
    }

    def __init__(
        self,
        *,
        task_id: Optional[str] = None,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        allowed_actions: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        state: Optional[str] = None,
        state_description: Optional[str] = None,
        task_type: Optional[str] = None,
        custom_details: Optional["_models.TaskTypeDetails"] = None,
        group_task_custom_details: Optional["_models.GroupTaskDetails"] = None,
        errors: Optional[List["_models.JobErrorDetails"]] = None,
        **kwargs
    ):
        """
        :keyword task_id: The Id.
        :paramtype task_id: str
        :keyword name: The unique Task name.
        :paramtype name: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword allowed_actions: The state/actions applicable on this task.
        :paramtype allowed_actions: list[str]
        :keyword friendly_name: The name.
        :paramtype friendly_name: str
        :keyword state: The State. It is one of these values - NotStarted, InProgress, Succeeded,
         Failed, Cancelled, Suspended or Other.
        :paramtype state: str
        :keyword state_description: The description of the task state. For example - For Succeeded
         state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
        :paramtype state_description: str
        :keyword task_type: The type of task. Details in CustomDetails property depend on this type.
        :paramtype task_type: str
        :keyword custom_details: The custom task details based on the task type.
        :paramtype custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.TaskTypeDetails
        :keyword group_task_custom_details: The custom task details based on the task type, if the task
         type is GroupTaskDetails or one of the types derived from it.
        :paramtype group_task_custom_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.GroupTaskDetails
        :keyword errors: The task error details.
        :paramtype errors: list[~azure.mgmt.recoveryservicessiterecovery.models.JobErrorDetails]
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.allowed_actions = allowed_actions
        self.friendly_name = friendly_name
        self.state = state
        self.state_description = state_description
        self.task_type = task_type
        self.custom_details = custom_details
        self.group_task_custom_details = group_task_custom_details
        self.errors = errors


class TaskTypeDetails(_serialization.Model):
    """Task details based on specific task type.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutomationRunbookTaskDetails, ConsistencyCheckTaskDetails, JobTaskDetails,
    ManualActionTaskDetails, ScriptActionTaskDetails, VmNicUpdatesTaskDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "AutomationRunbookTaskDetails": "AutomationRunbookTaskDetails",
            "ConsistencyCheckTaskDetails": "ConsistencyCheckTaskDetails",
            "JobTaskDetails": "JobTaskDetails",
            "ManualActionTaskDetails": "ManualActionTaskDetails",
            "ScriptActionTaskDetails": "ScriptActionTaskDetails",
            "VmNicUpdatesTaskDetails": "VmNicUpdatesTaskDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class AutomationRunbookTaskDetails(TaskTypeDetails):
    """This class represents the task details for an automation runbook.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar name: The recovery plan task name.
    :vartype name: str
    :ivar cloud_service_name: The cloud service of the automation runbook account.
    :vartype cloud_service_name: str
    :ivar subscription_id: The subscription Id of the automation runbook account.
    :vartype subscription_id: str
    :ivar account_name: The automation account name of the runbook.
    :vartype account_name: str
    :ivar runbook_id: The runbook Id.
    :vartype runbook_id: str
    :ivar runbook_name: The runbook name.
    :vartype runbook_name: str
    :ivar job_id: The job Id of the runbook execution.
    :vartype job_id: str
    :ivar job_output: The execution output of the runbook.
    :vartype job_output: str
    :ivar is_primary_side_script: A value indicating whether it is a primary side script or not.
    :vartype is_primary_side_script: bool
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "cloud_service_name": {"key": "cloudServiceName", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "runbook_id": {"key": "runbookId", "type": "str"},
        "runbook_name": {"key": "runbookName", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "job_output": {"key": "jobOutput", "type": "str"},
        "is_primary_side_script": {"key": "isPrimarySideScript", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        cloud_service_name: Optional[str] = None,
        subscription_id: Optional[str] = None,
        account_name: Optional[str] = None,
        runbook_id: Optional[str] = None,
        runbook_name: Optional[str] = None,
        job_id: Optional[str] = None,
        job_output: Optional[str] = None,
        is_primary_side_script: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: The recovery plan task name.
        :paramtype name: str
        :keyword cloud_service_name: The cloud service of the automation runbook account.
        :paramtype cloud_service_name: str
        :keyword subscription_id: The subscription Id of the automation runbook account.
        :paramtype subscription_id: str
        :keyword account_name: The automation account name of the runbook.
        :paramtype account_name: str
        :keyword runbook_id: The runbook Id.
        :paramtype runbook_id: str
        :keyword runbook_name: The runbook name.
        :paramtype runbook_name: str
        :keyword job_id: The job Id of the runbook execution.
        :paramtype job_id: str
        :keyword job_output: The execution output of the runbook.
        :paramtype job_output: str
        :keyword is_primary_side_script: A value indicating whether it is a primary side script or not.
        :paramtype is_primary_side_script: bool
        """
        super().__init__(**kwargs)
        self.instance_type: str = "AutomationRunbookTaskDetails"
        self.name = name
        self.cloud_service_name = cloud_service_name
        self.subscription_id = subscription_id
        self.account_name = account_name
        self.runbook_id = runbook_id
        self.runbook_name = runbook_name
        self.job_id = job_id
        self.job_output = job_output
        self.is_primary_side_script = is_primary_side_script


class FabricSpecificCreationInput(_serialization.Model):
    """Fabric provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFabricCreationInput, InMageRcmFabricCreationInput, VMwareV2FabricCreationInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "Azure": "AzureFabricCreationInput",
            "InMageRcm": "InMageRcmFabricCreationInput",
            "VMwareV2": "VMwareV2FabricCreationInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class AzureFabricCreationInput(FabricSpecificCreationInput):
    """Fabric provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Required.
    :vartype instance_type: str
    :ivar location: The Location.
    :vartype location: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs):
        """
        :keyword location: The Location.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "Azure"
        self.location = location


class FabricSpecificDetails(_serialization.Model):
    """Fabric specific details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFabricSpecificDetails, HyperVSiteDetails, InMageRcmFabricSpecificDetails, VmmDetails,
    VMwareDetails, VMwareV2FabricSpecificDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "Azure": "AzureFabricSpecificDetails",
            "HyperVSite": "HyperVSiteDetails",
            "InMageRcm": "InMageRcmFabricSpecificDetails",
            "VMM": "VmmDetails",
            "VMware": "VMwareDetails",
            "VMwareV2": "VMwareV2FabricSpecificDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class AzureFabricSpecificDetails(FabricSpecificDetails):
    """Azure Fabric Specific Details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar location: The Location for the Azure fabric.
    :vartype location: str
    :ivar container_ids: The container Ids for the Azure fabric.
    :vartype container_ids: list[str]
    :ivar zones: The zones.
    :vartype zones: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AZoneDetails]
    :ivar extended_locations: The ExtendedLocations.
    :vartype extended_locations:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AExtendedLocationDetails]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "container_ids": {"key": "containerIds", "type": "[str]"},
        "zones": {"key": "zones", "type": "[A2AZoneDetails]"},
        "extended_locations": {"key": "extendedLocations", "type": "[A2AExtendedLocationDetails]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        container_ids: Optional[List[str]] = None,
        zones: Optional[List["_models.A2AZoneDetails"]] = None,
        extended_locations: Optional[List["_models.A2AExtendedLocationDetails"]] = None,
        **kwargs
    ):
        """
        :keyword location: The Location for the Azure fabric.
        :paramtype location: str
        :keyword container_ids: The container Ids for the Azure fabric.
        :paramtype container_ids: list[str]
        :keyword zones: The zones.
        :paramtype zones: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AZoneDetails]
        :keyword extended_locations: The ExtendedLocations.
        :paramtype extended_locations:
         list[~azure.mgmt.recoveryservicessiterecovery.models.A2AExtendedLocationDetails]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "Azure"
        self.location = location
        self.container_ids = container_ids
        self.zones = zones
        self.extended_locations = extended_locations


class FabricSpecificCreateNetworkMappingInput(_serialization.Model):
    """Input details specific to fabrics during Network Mapping.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureToAzureCreateNetworkMappingInput, VmmToAzureCreateNetworkMappingInput,
    VmmToVmmCreateNetworkMappingInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "AzureToAzure": "AzureToAzureCreateNetworkMappingInput",
            "VmmToAzure": "VmmToAzureCreateNetworkMappingInput",
            "VmmToVmm": "VmmToVmmCreateNetworkMappingInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class AzureToAzureCreateNetworkMappingInput(FabricSpecificCreateNetworkMappingInput):
    """Create network mappings input properties/behavior specific to Azure to Azure Network mapping.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The instance type. Required.
    :vartype instance_type: str
    :ivar primary_network_id: The primary azure vnet Id. Required.
    :vartype primary_network_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "primary_network_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_network_id": {"key": "primaryNetworkId", "type": "str"},
    }

    def __init__(self, *, primary_network_id: str, **kwargs):
        """
        :keyword primary_network_id: The primary azure vnet Id. Required.
        :paramtype primary_network_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "AzureToAzure"
        self.primary_network_id = primary_network_id


class NetworkMappingFabricSpecificSettings(_serialization.Model):
    """Network Mapping fabric specific settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureToAzureNetworkMappingSettings, VmmToAzureNetworkMappingSettings,
    VmmToVmmNetworkMappingSettings

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "AzureToAzure": "AzureToAzureNetworkMappingSettings",
            "VmmToAzure": "VmmToAzureNetworkMappingSettings",
            "VmmToVmm": "VmmToVmmNetworkMappingSettings",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class AzureToAzureNetworkMappingSettings(NetworkMappingFabricSpecificSettings):
    """A2A Network Mapping fabric specific settings.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar primary_fabric_location: The primary fabric location.
    :vartype primary_fabric_location: str
    :ivar recovery_fabric_location: The recovery fabric location.
    :vartype recovery_fabric_location: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_fabric_location": {"key": "primaryFabricLocation", "type": "str"},
        "recovery_fabric_location": {"key": "recoveryFabricLocation", "type": "str"},
    }

    def __init__(
        self, *, primary_fabric_location: Optional[str] = None, recovery_fabric_location: Optional[str] = None, **kwargs
    ):
        """
        :keyword primary_fabric_location: The primary fabric location.
        :paramtype primary_fabric_location: str
        :keyword recovery_fabric_location: The recovery fabric location.
        :paramtype recovery_fabric_location: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "AzureToAzure"
        self.primary_fabric_location = primary_fabric_location
        self.recovery_fabric_location = recovery_fabric_location


class FabricSpecificUpdateNetworkMappingInput(_serialization.Model):
    """Input details specific to fabrics during Network Mapping.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureToAzureUpdateNetworkMappingInput, VmmToAzureUpdateNetworkMappingInput,
    VmmToVmmUpdateNetworkMappingInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "AzureToAzure": "AzureToAzureUpdateNetworkMappingInput",
            "VmmToAzure": "VmmToAzureUpdateNetworkMappingInput",
            "VmmToVmm": "VmmToVmmUpdateNetworkMappingInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class AzureToAzureUpdateNetworkMappingInput(FabricSpecificUpdateNetworkMappingInput):
    """Updates network mappings input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The instance type. Required.
    :vartype instance_type: str
    :ivar primary_network_id: The primary azure vnet Id.
    :vartype primary_network_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_network_id": {"key": "primaryNetworkId", "type": "str"},
    }

    def __init__(self, *, primary_network_id: Optional[str] = None, **kwargs):
        """
        :keyword primary_network_id: The primary azure vnet Id.
        :paramtype primary_network_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "AzureToAzure"
        self.primary_network_id = primary_network_id


class AzureToAzureVmSyncedConfigDetails(_serialization.Model):
    """Azure to Azure VM synced configuration details.

    :ivar tags: The Azure VM tags.
    :vartype tags: dict[str, str]
    :ivar input_endpoints: The Azure VM input endpoints.
    :vartype input_endpoints: list[~azure.mgmt.recoveryservicessiterecovery.models.InputEndpoint]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "input_endpoints": {"key": "inputEndpoints", "type": "[InputEndpoint]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        input_endpoints: Optional[List["_models.InputEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword tags: The Azure VM tags.
        :paramtype tags: dict[str, str]
        :keyword input_endpoints: The Azure VM input endpoints.
        :paramtype input_endpoints: list[~azure.mgmt.recoveryservicessiterecovery.models.InputEndpoint]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.input_endpoints = input_endpoints


class AzureVmDiskDetails(_serialization.Model):
    """Disk details for E2A provider.

    :ivar vhd_type: VHD type.
    :vartype vhd_type: str
    :ivar vhd_id: The VHD id.
    :vartype vhd_id: str
    :ivar disk_id: The disk resource id.
    :vartype disk_id: str
    :ivar vhd_name: VHD name.
    :vartype vhd_name: str
    :ivar max_size_mb: Max side in MB.
    :vartype max_size_mb: str
    :ivar target_disk_location: Blob uri of the Azure disk.
    :vartype target_disk_location: str
    :ivar target_disk_name: The target Azure disk name.
    :vartype target_disk_name: str
    :ivar lun_id: Ordinal\LunId of the disk for the Azure VM.
    :vartype lun_id: str
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM ID.
    :vartype disk_encryption_set_id: str
    :ivar custom_target_disk_name: The custom target Azure disk name.
    :vartype custom_target_disk_name: str
    """

    _attribute_map = {
        "vhd_type": {"key": "vhdType", "type": "str"},
        "vhd_id": {"key": "vhdId", "type": "str"},
        "disk_id": {"key": "diskId", "type": "str"},
        "vhd_name": {"key": "vhdName", "type": "str"},
        "max_size_mb": {"key": "maxSizeMB", "type": "str"},
        "target_disk_location": {"key": "targetDiskLocation", "type": "str"},
        "target_disk_name": {"key": "targetDiskName", "type": "str"},
        "lun_id": {"key": "lunId", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "custom_target_disk_name": {"key": "customTargetDiskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        vhd_type: Optional[str] = None,
        vhd_id: Optional[str] = None,
        disk_id: Optional[str] = None,
        vhd_name: Optional[str] = None,
        max_size_mb: Optional[str] = None,
        target_disk_location: Optional[str] = None,
        target_disk_name: Optional[str] = None,
        lun_id: Optional[str] = None,
        disk_encryption_set_id: Optional[str] = None,
        custom_target_disk_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword vhd_type: VHD type.
        :paramtype vhd_type: str
        :keyword vhd_id: The VHD id.
        :paramtype vhd_id: str
        :keyword disk_id: The disk resource id.
        :paramtype disk_id: str
        :keyword vhd_name: VHD name.
        :paramtype vhd_name: str
        :keyword max_size_mb: Max side in MB.
        :paramtype max_size_mb: str
        :keyword target_disk_location: Blob uri of the Azure disk.
        :paramtype target_disk_location: str
        :keyword target_disk_name: The target Azure disk name.
        :paramtype target_disk_name: str
        :keyword lun_id: Ordinal\LunId of the disk for the Azure VM.
        :paramtype lun_id: str
        :keyword disk_encryption_set_id: The DiskEncryptionSet ARM ID.
        :paramtype disk_encryption_set_id: str
        :keyword custom_target_disk_name: The custom target Azure disk name.
        :paramtype custom_target_disk_name: str
        """
        super().__init__(**kwargs)
        self.vhd_type = vhd_type
        self.vhd_id = vhd_id
        self.disk_id = disk_id
        self.vhd_name = vhd_name
        self.max_size_mb = max_size_mb
        self.target_disk_location = target_disk_location
        self.target_disk_name = target_disk_name
        self.lun_id = lun_id
        self.disk_encryption_set_id = disk_encryption_set_id
        self.custom_target_disk_name = custom_target_disk_name


class ComputeSizeErrorDetails(_serialization.Model):
    """Represents the error used to indicate why the target compute size is not applicable.

    :ivar message: The error message.
    :vartype message: str
    :ivar severity: The severity of the error.
    :vartype severity: str
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(self, *, message: Optional[str] = None, severity: Optional[str] = None, **kwargs):
        """
        :keyword message: The error message.
        :paramtype message: str
        :keyword severity: The severity of the error.
        :paramtype severity: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.severity = severity


class ConfigurationSettings(_serialization.Model):
    """Replication provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVVirtualMachineDetails, ReplicationGroupDetails, VMwareVirtualMachineDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "HyperVVirtualMachine": "HyperVVirtualMachineDetails",
            "ReplicationGroupDetails": "ReplicationGroupDetails",
            "VMwareVirtualMachine": "VMwareVirtualMachineDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class ConfigureAlertRequest(_serialization.Model):
    """Request to configure alerts for the system.

    :ivar properties: The properties of a configure alert request.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ConfigureAlertRequestProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ConfigureAlertRequestProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ConfigureAlertRequestProperties"] = None, **kwargs):
        """
        :keyword properties: The properties of a configure alert request.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.ConfigureAlertRequestProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ConfigureAlertRequestProperties(_serialization.Model):
    """Properties of a configure alert request.

    :ivar send_to_owners: A value indicating whether to send email to subscription administrator.
    :vartype send_to_owners: str
    :ivar custom_email_addresses: The custom email address for sending emails.
    :vartype custom_email_addresses: list[str]
    :ivar locale: The locale for the email notification.
    :vartype locale: str
    """

    _attribute_map = {
        "send_to_owners": {"key": "sendToOwners", "type": "str"},
        "custom_email_addresses": {"key": "customEmailAddresses", "type": "[str]"},
        "locale": {"key": "locale", "type": "str"},
    }

    def __init__(
        self,
        *,
        send_to_owners: Optional[str] = None,
        custom_email_addresses: Optional[List[str]] = None,
        locale: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword send_to_owners: A value indicating whether to send email to subscription
         administrator.
        :paramtype send_to_owners: str
        :keyword custom_email_addresses: The custom email address for sending emails.
        :paramtype custom_email_addresses: list[str]
        :keyword locale: The locale for the email notification.
        :paramtype locale: str
        """
        super().__init__(**kwargs)
        self.send_to_owners = send_to_owners
        self.custom_email_addresses = custom_email_addresses
        self.locale = locale


class ConsistencyCheckTaskDetails(TaskTypeDetails):
    """This class contains monitoring details of all the inconsistent Protected Entities in Vmm.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar vm_details: The list of inconsistent Vm details.
    :vartype vm_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InconsistentVmDetails]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "vm_details": {"key": "vmDetails", "type": "[InconsistentVmDetails]"},
    }

    def __init__(self, *, vm_details: Optional[List["_models.InconsistentVmDetails"]] = None, **kwargs):
        """
        :keyword vm_details: The list of inconsistent Vm details.
        :paramtype vm_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InconsistentVmDetails]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "ConsistencyCheckTaskDetails"
        self.vm_details = vm_details


class CreateNetworkMappingInput(_serialization.Model):
    """Create network mappings input.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Input properties for creating network mapping. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateNetworkMappingInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "CreateNetworkMappingInputProperties"},
    }

    def __init__(self, *, properties: "_models.CreateNetworkMappingInputProperties", **kwargs):
        """
        :keyword properties: Input properties for creating network mapping. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.CreateNetworkMappingInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CreateNetworkMappingInputProperties(_serialization.Model):
    """Common input details for network mapping operation.

    All required parameters must be populated in order to send to Azure.

    :ivar recovery_fabric_name: Recovery fabric Name.
    :vartype recovery_fabric_name: str
    :ivar recovery_network_id: Recovery network Id. Required.
    :vartype recovery_network_id: str
    :ivar fabric_specific_details: Fabric specific input properties.
    :vartype fabric_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificCreateNetworkMappingInput
    """

    _validation = {
        "recovery_network_id": {"required": True},
    }

    _attribute_map = {
        "recovery_fabric_name": {"key": "recoveryFabricName", "type": "str"},
        "recovery_network_id": {"key": "recoveryNetworkId", "type": "str"},
        "fabric_specific_details": {"key": "fabricSpecificDetails", "type": "FabricSpecificCreateNetworkMappingInput"},
    }

    def __init__(
        self,
        *,
        recovery_network_id: str,
        recovery_fabric_name: Optional[str] = None,
        fabric_specific_details: Optional["_models.FabricSpecificCreateNetworkMappingInput"] = None,
        **kwargs
    ):
        """
        :keyword recovery_fabric_name: Recovery fabric Name.
        :paramtype recovery_fabric_name: str
        :keyword recovery_network_id: Recovery network Id. Required.
        :paramtype recovery_network_id: str
        :keyword fabric_specific_details: Fabric specific input properties.
        :paramtype fabric_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificCreateNetworkMappingInput
        """
        super().__init__(**kwargs)
        self.recovery_fabric_name = recovery_fabric_name
        self.recovery_network_id = recovery_network_id
        self.fabric_specific_details = fabric_specific_details


class CreatePolicyInput(_serialization.Model):
    """Protection Policy input.

    :ivar properties: Policy creation properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreatePolicyInputProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "CreatePolicyInputProperties"},
    }

    def __init__(self, *, properties: Optional["_models.CreatePolicyInputProperties"] = None, **kwargs):
        """
        :keyword properties: Policy creation properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.CreatePolicyInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CreatePolicyInputProperties(_serialization.Model):
    """Policy creation properties.

    :ivar provider_specific_input: The ReplicationProviderSettings.
    :vartype provider_specific_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProviderSpecificInput
    """

    _attribute_map = {
        "provider_specific_input": {"key": "providerSpecificInput", "type": "PolicyProviderSpecificInput"},
    }

    def __init__(self, *, provider_specific_input: Optional["_models.PolicyProviderSpecificInput"] = None, **kwargs):
        """
        :keyword provider_specific_input: The ReplicationProviderSettings.
        :paramtype provider_specific_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProviderSpecificInput
        """
        super().__init__(**kwargs)
        self.provider_specific_input = provider_specific_input


class CreateProtectionContainerInput(_serialization.Model):
    """Create protection container input.

    :ivar properties: Create protection container input properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionContainerInputProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "CreateProtectionContainerInputProperties"},
    }

    def __init__(self, *, properties: Optional["_models.CreateProtectionContainerInputProperties"] = None, **kwargs):
        """
        :keyword properties: Create protection container input properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionContainerInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CreateProtectionContainerInputProperties(_serialization.Model):
    """Create protection container input properties.

    :ivar provider_specific_input: Provider specific inputs for container creation.
    :vartype provider_specific_input:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderSpecificContainerCreationInput]
    """

    _attribute_map = {
        "provider_specific_input": {
            "key": "providerSpecificInput",
            "type": "[ReplicationProviderSpecificContainerCreationInput]",
        },
    }

    def __init__(
        self,
        *,
        provider_specific_input: Optional[List["_models.ReplicationProviderSpecificContainerCreationInput"]] = None,
        **kwargs
    ):
        """
        :keyword provider_specific_input: Provider specific inputs for container creation.
        :paramtype provider_specific_input:
         list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderSpecificContainerCreationInput]
        """
        super().__init__(**kwargs)
        self.provider_specific_input = provider_specific_input


class CreateProtectionContainerMappingInput(_serialization.Model):
    """Configure pairing input.

    :ivar properties: Configure protection input properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionContainerMappingInputProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "CreateProtectionContainerMappingInputProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.CreateProtectionContainerMappingInputProperties"] = None, **kwargs
    ):
        """
        :keyword properties: Configure protection input properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionContainerMappingInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CreateProtectionContainerMappingInputProperties(_serialization.Model):
    """Configure pairing input properties.

    :ivar target_protection_container_id: The target unique protection container name.
    :vartype target_protection_container_id: str
    :ivar policy_id: Applicable policy.
    :vartype policy_id: str
    :ivar provider_specific_input: Provider specific input for pairing.
    :vartype provider_specific_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderSpecificContainerMappingInput
    """

    _attribute_map = {
        "target_protection_container_id": {"key": "targetProtectionContainerId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "provider_specific_input": {
            "key": "providerSpecificInput",
            "type": "ReplicationProviderSpecificContainerMappingInput",
        },
    }

    def __init__(
        self,
        *,
        target_protection_container_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        provider_specific_input: Optional["_models.ReplicationProviderSpecificContainerMappingInput"] = None,
        **kwargs
    ):
        """
        :keyword target_protection_container_id: The target unique protection container name.
        :paramtype target_protection_container_id: str
        :keyword policy_id: Applicable policy.
        :paramtype policy_id: str
        :keyword provider_specific_input: Provider specific input for pairing.
        :paramtype provider_specific_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderSpecificContainerMappingInput
        """
        super().__init__(**kwargs)
        self.target_protection_container_id = target_protection_container_id
        self.policy_id = policy_id
        self.provider_specific_input = provider_specific_input


class CreateProtectionIntentInput(_serialization.Model):
    """Create protection intent input.

    :ivar properties: Create protection intent input properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionIntentProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "CreateProtectionIntentProperties"},
    }

    def __init__(self, *, properties: Optional["_models.CreateProtectionIntentProperties"] = None, **kwargs):
        """
        :keyword properties: Create protection intent input properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionIntentProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CreateProtectionIntentProperties(_serialization.Model):
    """Create protection intent input properties.

    :ivar provider_specific_details: The ReplicationProviderInput. For A2A provider, it will be
     A2ACreateProtectionIntentInput object.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionIntentProviderSpecificDetails
    """

    _attribute_map = {
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "CreateProtectionIntentProviderSpecificDetails",
        },
    }

    def __init__(
        self,
        *,
        provider_specific_details: Optional["_models.CreateProtectionIntentProviderSpecificDetails"] = None,
        **kwargs
    ):
        """
        :keyword provider_specific_details: The ReplicationProviderInput. For A2A provider, it will be
         A2ACreateProtectionIntentInput object.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionIntentProviderSpecificDetails
        """
        super().__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class CreateRecoveryPlanInput(_serialization.Model):
    """Create recovery plan input class.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Recovery plan creation properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateRecoveryPlanInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "CreateRecoveryPlanInputProperties"},
    }

    def __init__(self, *, properties: "_models.CreateRecoveryPlanInputProperties", **kwargs):
        """
        :keyword properties: Recovery plan creation properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.CreateRecoveryPlanInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CreateRecoveryPlanInputProperties(_serialization.Model):
    """Recovery plan creation properties.

    All required parameters must be populated in order to send to Azure.

    :ivar primary_fabric_id: The primary fabric Id. Required.
    :vartype primary_fabric_id: str
    :ivar recovery_fabric_id: The recovery fabric Id. Required.
    :vartype recovery_fabric_id: str
    :ivar failover_deployment_model: The failover deployment model. Known values are:
     "NotApplicable", "Classic", and "ResourceManager".
    :vartype failover_deployment_model: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.FailoverDeploymentModel
    :ivar groups: The recovery plan groups. Required.
    :vartype groups: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroup]
    :ivar provider_specific_input: The provider specific input.
    :vartype provider_specific_input:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificInput]
    """

    _validation = {
        "primary_fabric_id": {"required": True},
        "recovery_fabric_id": {"required": True},
        "groups": {"required": True},
    }

    _attribute_map = {
        "primary_fabric_id": {"key": "primaryFabricId", "type": "str"},
        "recovery_fabric_id": {"key": "recoveryFabricId", "type": "str"},
        "failover_deployment_model": {"key": "failoverDeploymentModel", "type": "str"},
        "groups": {"key": "groups", "type": "[RecoveryPlanGroup]"},
        "provider_specific_input": {"key": "providerSpecificInput", "type": "[RecoveryPlanProviderSpecificInput]"},
    }

    def __init__(
        self,
        *,
        primary_fabric_id: str,
        recovery_fabric_id: str,
        groups: List["_models.RecoveryPlanGroup"],
        failover_deployment_model: Optional[Union[str, "_models.FailoverDeploymentModel"]] = None,
        provider_specific_input: Optional[List["_models.RecoveryPlanProviderSpecificInput"]] = None,
        **kwargs
    ):
        """
        :keyword primary_fabric_id: The primary fabric Id. Required.
        :paramtype primary_fabric_id: str
        :keyword recovery_fabric_id: The recovery fabric Id. Required.
        :paramtype recovery_fabric_id: str
        :keyword failover_deployment_model: The failover deployment model. Known values are:
         "NotApplicable", "Classic", and "ResourceManager".
        :paramtype failover_deployment_model: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.FailoverDeploymentModel
        :keyword groups: The recovery plan groups. Required.
        :paramtype groups: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroup]
        :keyword provider_specific_input: The provider specific input.
        :paramtype provider_specific_input:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificInput]
        """
        super().__init__(**kwargs)
        self.primary_fabric_id = primary_fabric_id
        self.recovery_fabric_id = recovery_fabric_id
        self.failover_deployment_model = failover_deployment_model
        self.groups = groups
        self.provider_specific_input = provider_specific_input


class CriticalJobHistoryDetails(_serialization.Model):
    """Critical past job details of the migration item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_name: The job name.
    :vartype job_name: str
    :ivar job_id: The ARM Id of the job being executed.
    :vartype job_id: str
    :ivar start_time: The start time of the job.
    :vartype start_time: ~datetime.datetime
    :ivar job_status: The job state.
    :vartype job_status: str
    """

    _validation = {
        "job_name": {"readonly": True},
        "job_id": {"readonly": True},
        "start_time": {"readonly": True},
        "job_status": {"readonly": True},
    }

    _attribute_map = {
        "job_name": {"key": "jobName", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "job_status": {"key": "jobStatus", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.job_name = None
        self.job_id = None
        self.start_time = None
        self.job_status = None


class CurrentJobDetails(_serialization.Model):
    """Current job details of the migration item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_name: The job name.
    :vartype job_name: str
    :ivar job_id: The ARM Id of the job being executed.
    :vartype job_id: str
    :ivar start_time: The start time of the job.
    :vartype start_time: ~datetime.datetime
    """

    _validation = {
        "job_name": {"readonly": True},
        "job_id": {"readonly": True},
        "start_time": {"readonly": True},
    }

    _attribute_map = {
        "job_name": {"key": "jobName", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.job_name = None
        self.job_id = None
        self.start_time = None


class CurrentScenarioDetails(_serialization.Model):
    """Current scenario details of the protected entity.

    :ivar scenario_name: Scenario name.
    :vartype scenario_name: str
    :ivar job_id: ARM Id of the job being executed.
    :vartype job_id: str
    :ivar start_time: Start time of the workflow.
    :vartype start_time: ~datetime.datetime
    """

    _attribute_map = {
        "scenario_name": {"key": "scenarioName", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        scenario_name: Optional[str] = None,
        job_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword scenario_name: Scenario name.
        :paramtype scenario_name: str
        :keyword job_id: ARM Id of the job being executed.
        :paramtype job_id: str
        :keyword start_time: Start time of the workflow.
        :paramtype start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.scenario_name = scenario_name
        self.job_id = job_id
        self.start_time = start_time


class DataStore(_serialization.Model):
    """The datastore details of the MT.

    :ivar symbolic_name: The symbolic name of data store.
    :vartype symbolic_name: str
    :ivar uuid: The uuid of data store.
    :vartype uuid: str
    :ivar capacity: The capacity of data store in GBs.
    :vartype capacity: str
    :ivar free_space: The free space of data store in GBs.
    :vartype free_space: str
    :ivar type: The type of data store.
    :vartype type: str
    """

    _attribute_map = {
        "symbolic_name": {"key": "symbolicName", "type": "str"},
        "uuid": {"key": "uuid", "type": "str"},
        "capacity": {"key": "capacity", "type": "str"},
        "free_space": {"key": "freeSpace", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        symbolic_name: Optional[str] = None,
        uuid: Optional[str] = None,
        capacity: Optional[str] = None,
        free_space: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword symbolic_name: The symbolic name of data store.
        :paramtype symbolic_name: str
        :keyword uuid: The uuid of data store.
        :paramtype uuid: str
        :keyword capacity: The capacity of data store in GBs.
        :paramtype capacity: str
        :keyword free_space: The free space of data store in GBs.
        :paramtype free_space: str
        :keyword type: The type of data store.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.symbolic_name = symbolic_name
        self.uuid = uuid
        self.capacity = capacity
        self.free_space = free_space
        self.type = type


class DisableProtectionInput(_serialization.Model):
    """Disable protection input.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Disable protection input properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "DisableProtectionInputProperties"},
    }

    def __init__(self, *, properties: "_models.DisableProtectionInputProperties", **kwargs):
        """
        :keyword properties: Disable protection input properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DisableProtectionInputProperties(_serialization.Model):
    """Disable protection input properties.

    :ivar disable_protection_reason: Disable protection reason. It can have values
     NotSpecified/MigrationComplete. Known values are: "NotSpecified" and "MigrationComplete".
    :vartype disable_protection_reason: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionReason
    :ivar replication_provider_input: Replication provider specific input.
    :vartype replication_provider_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionProviderSpecificInput
    """

    _attribute_map = {
        "disable_protection_reason": {"key": "disableProtectionReason", "type": "str"},
        "replication_provider_input": {
            "key": "replicationProviderInput",
            "type": "DisableProtectionProviderSpecificInput",
        },
    }

    def __init__(
        self,
        *,
        disable_protection_reason: Optional[Union[str, "_models.DisableProtectionReason"]] = None,
        replication_provider_input: Optional["_models.DisableProtectionProviderSpecificInput"] = None,
        **kwargs
    ):
        """
        :keyword disable_protection_reason: Disable protection reason. It can have values
         NotSpecified/MigrationComplete. Known values are: "NotSpecified" and "MigrationComplete".
        :paramtype disable_protection_reason: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionReason
        :keyword replication_provider_input: Replication provider specific input.
        :paramtype replication_provider_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionProviderSpecificInput
        """
        super().__init__(**kwargs)
        self.disable_protection_reason = disable_protection_reason
        self.replication_provider_input = replication_provider_input


class DisableProtectionProviderSpecificInput(_serialization.Model):
    """Disable protection provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InMageDisableProtectionProviderSpecificInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"InMage": "InMageDisableProtectionProviderSpecificInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class DiscoverProtectableItemRequest(_serialization.Model):
    """Request to add a physical machine as a protectable item in a container.

    :ivar properties: The properties of a discover protectable item request.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiscoverProtectableItemRequestProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "DiscoverProtectableItemRequestProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DiscoverProtectableItemRequestProperties"] = None, **kwargs):
        """
        :keyword properties: The properties of a discover protectable item request.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiscoverProtectableItemRequestProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DiscoverProtectableItemRequestProperties(_serialization.Model):
    """Discover protectable item properties.

    :ivar friendly_name: The friendly name of the physical machine.
    :vartype friendly_name: str
    :ivar ip_address: The IP address of the physical machine to be discovered.
    :vartype ip_address: str
    :ivar os_type: The OS type on the physical machine.
    :vartype os_type: str
    """

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        ip_address: Optional[str] = None,
        os_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword friendly_name: The friendly name of the physical machine.
        :paramtype friendly_name: str
        :keyword ip_address: The IP address of the physical machine to be discovered.
        :paramtype ip_address: str
        :keyword os_type: The OS type on the physical machine.
        :paramtype os_type: str
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.ip_address = ip_address
        self.os_type = os_type


class DiskDetails(_serialization.Model):
    """Onprem disk details data.

    :ivar max_size_mb: The hard disk max size in MB.
    :vartype max_size_mb: int
    :ivar vhd_type: The type of the volume.
    :vartype vhd_type: str
    :ivar vhd_id: The VHD Id.
    :vartype vhd_id: str
    :ivar vhd_name: The VHD name.
    :vartype vhd_name: str
    """

    _attribute_map = {
        "max_size_mb": {"key": "maxSizeMB", "type": "int"},
        "vhd_type": {"key": "vhdType", "type": "str"},
        "vhd_id": {"key": "vhdId", "type": "str"},
        "vhd_name": {"key": "vhdName", "type": "str"},
    }

    def __init__(
        self,
        *,
        max_size_mb: Optional[int] = None,
        vhd_type: Optional[str] = None,
        vhd_id: Optional[str] = None,
        vhd_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword max_size_mb: The hard disk max size in MB.
        :paramtype max_size_mb: int
        :keyword vhd_type: The type of the volume.
        :paramtype vhd_type: str
        :keyword vhd_id: The VHD Id.
        :paramtype vhd_id: str
        :keyword vhd_name: The VHD name.
        :paramtype vhd_name: str
        """
        super().__init__(**kwargs)
        self.max_size_mb = max_size_mb
        self.vhd_type = vhd_type
        self.vhd_id = vhd_id
        self.vhd_name = vhd_name


class DiskEncryptionInfo(_serialization.Model):
    """Recovery disk encryption info (BEK and KEK).

    :ivar disk_encryption_key_info: The recovery KeyVault reference for secret.
    :vartype disk_encryption_key_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionKeyInfo
    :ivar key_encryption_key_info: The recovery KeyVault reference for key.
    :vartype key_encryption_key_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.KeyEncryptionKeyInfo
    """

    _attribute_map = {
        "disk_encryption_key_info": {"key": "diskEncryptionKeyInfo", "type": "DiskEncryptionKeyInfo"},
        "key_encryption_key_info": {"key": "keyEncryptionKeyInfo", "type": "KeyEncryptionKeyInfo"},
    }

    def __init__(
        self,
        *,
        disk_encryption_key_info: Optional["_models.DiskEncryptionKeyInfo"] = None,
        key_encryption_key_info: Optional["_models.KeyEncryptionKeyInfo"] = None,
        **kwargs
    ):
        """
        :keyword disk_encryption_key_info: The recovery KeyVault reference for secret.
        :paramtype disk_encryption_key_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionKeyInfo
        :keyword key_encryption_key_info: The recovery KeyVault reference for key.
        :paramtype key_encryption_key_info:
         ~azure.mgmt.recoveryservicessiterecovery.models.KeyEncryptionKeyInfo
        """
        super().__init__(**kwargs)
        self.disk_encryption_key_info = disk_encryption_key_info
        self.key_encryption_key_info = key_encryption_key_info


class DiskEncryptionKeyInfo(_serialization.Model):
    """Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows).

    :ivar secret_identifier: The secret url / identifier.
    :vartype secret_identifier: str
    :ivar key_vault_resource_arm_id: The KeyVault resource ARM id for secret.
    :vartype key_vault_resource_arm_id: str
    """

    _attribute_map = {
        "secret_identifier": {"key": "secretIdentifier", "type": "str"},
        "key_vault_resource_arm_id": {"key": "keyVaultResourceArmId", "type": "str"},
    }

    def __init__(
        self, *, secret_identifier: Optional[str] = None, key_vault_resource_arm_id: Optional[str] = None, **kwargs
    ):
        """
        :keyword secret_identifier: The secret url / identifier.
        :paramtype secret_identifier: str
        :keyword key_vault_resource_arm_id: The KeyVault resource ARM id for secret.
        :paramtype key_vault_resource_arm_id: str
        """
        super().__init__(**kwargs)
        self.secret_identifier = secret_identifier
        self.key_vault_resource_arm_id = key_vault_resource_arm_id


class DiskVolumeDetails(_serialization.Model):
    """Volume details.

    :ivar label: The volume label.
    :vartype label: str
    :ivar name: The volume name.
    :vartype name: str
    """

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, label: Optional[str] = None, name: Optional[str] = None, **kwargs):
        """
        :keyword label: The volume label.
        :paramtype label: str
        :keyword name: The volume name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.label = label
        self.name = name


class Display(_serialization.Model):
    """Contains the localized display information for this particular operation / action. These value will be used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for the event service; and (3) audit history / records for management operations.

    :ivar provider: The provider. The localized friendly form of the resource provider name - it is
     expected to also include the publisher/company responsible. It should use Title Casing and
     begin with "Microsoft" for 1st party services. e.g. "Microsoft Monitoring Insights" or
     "Microsoft Compute.".
    :vartype provider: str
    :ivar resource: The resource. The localized friendly form of the resource related to this
     action/operation - it should match the public documentation for the resource provider. It
     should use Title Casing. This value should be unique for a particular URL type (e.g. nested
     types should *not* reuse their parent's display.resource field). e.g. "Virtual Machines" or
     "Scheduler Job Collections", or "Virtual Machine VM Sizes" or "Scheduler Jobs".
    :vartype resource: str
    :ivar operation: The operation. The localized friendly name for the operation, as it should be
     shown to the user. It should be concise (to fit in drop downs) but clear (i.e.
     self-documenting). It should use Title Casing. Prescriptive guidance: Read Create or Update
     Delete 'ActionName'.
    :vartype operation: str
    :ivar description: The description. The localized friendly description for the operation, as it
     should be shown to the user. It should be thorough, yet concise - it will be used in tool tips
     and detailed views. Prescriptive guidance for namespaces: Read any 'display.provider' resource
     Create or Update any 'display.provider' resource Delete any 'display.provider' resource Perform
     any other action on any 'display.provider' resource Prescriptive guidance for namespaces: Read
     any 'display.resource' Create or Update any 'display.resource' Delete any 'display.resource'
     'ActionName' any 'display.resources'.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The provider. The localized friendly form of the resource provider name - it
         is expected to also include the publisher/company responsible. It should use Title Casing and
         begin with "Microsoft" for 1st party services. e.g. "Microsoft Monitoring Insights" or
         "Microsoft Compute.".
        :paramtype provider: str
        :keyword resource: The resource. The localized friendly form of the resource related to this
         action/operation - it should match the public documentation for the resource provider. It
         should use Title Casing. This value should be unique for a particular URL type (e.g. nested
         types should *not* reuse their parent's display.resource field). e.g. "Virtual Machines" or
         "Scheduler Job Collections", or "Virtual Machine VM Sizes" or "Scheduler Jobs".
        :paramtype resource: str
        :keyword operation: The operation. The localized friendly name for the operation, as it should
         be shown to the user. It should be concise (to fit in drop downs) but clear (i.e.
         self-documenting). It should use Title Casing. Prescriptive guidance: Read Create or Update
         Delete 'ActionName'.
        :paramtype operation: str
        :keyword description: The description. The localized friendly description for the operation, as
         it should be shown to the user. It should be thorough, yet concise - it will be used in tool
         tips and detailed views. Prescriptive guidance for namespaces: Read any 'display.provider'
         resource Create or Update any 'display.provider' resource Delete any 'display.provider'
         resource Perform any other action on any 'display.provider' resource Prescriptive guidance for
         namespaces: Read any 'display.resource' Create or Update any 'display.resource' Delete any
         'display.resource' 'ActionName' any 'display.resources'.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class DraDetails(_serialization.Model):
    """DRA details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The DRA Id.
    :vartype id: str
    :ivar name: The DRA name.
    :vartype name: str
    :ivar bios_id: The DRA Bios Id.
    :vartype bios_id: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the DRA.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health. Known values are: "None", "Normal", "Warning", and "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar forward_protected_item_count: The count of protected items which are protected in forward
     direction.
    :vartype forward_protected_item_count: int
    :ivar reverse_protected_item_count: The count of protected items which are protected in reverse
     direction.
    :vartype reverse_protected_item_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "bios_id": {"readonly": True},
        "version": {"readonly": True},
        "last_heartbeat_utc": {"readonly": True},
        "health": {"readonly": True},
        "health_errors": {"readonly": True},
        "forward_protected_item_count": {"readonly": True},
        "reverse_protected_item_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "last_heartbeat_utc": {"key": "lastHeartbeatUtc", "type": "iso-8601"},
        "health": {"key": "health", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
        "forward_protected_item_count": {"key": "forwardProtectedItemCount", "type": "int"},
        "reverse_protected_item_count": {"key": "reverseProtectedItemCount", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None
        self.forward_protected_item_count = None
        self.reverse_protected_item_count = None


class EnableMigrationInput(_serialization.Model):
    """Enable migration input.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Enable migration input properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.EnableMigrationInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "EnableMigrationInputProperties"},
    }

    def __init__(self, *, properties: "_models.EnableMigrationInputProperties", **kwargs):
        """
        :keyword properties: Enable migration input properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.EnableMigrationInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class EnableMigrationInputProperties(_serialization.Model):
    """Enable migration input properties.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_id: The policy Id. Required.
    :vartype policy_id: str
    :ivar provider_specific_details: The provider specific details. Required.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EnableMigrationProviderSpecificInput
    """

    _validation = {
        "policy_id": {"required": True},
        "provider_specific_details": {"required": True},
    }

    _attribute_map = {
        "policy_id": {"key": "policyId", "type": "str"},
        "provider_specific_details": {"key": "providerSpecificDetails", "type": "EnableMigrationProviderSpecificInput"},
    }

    def __init__(
        self, *, policy_id: str, provider_specific_details: "_models.EnableMigrationProviderSpecificInput", **kwargs
    ):
        """
        :keyword policy_id: The policy Id. Required.
        :paramtype policy_id: str
        :keyword provider_specific_details: The provider specific details. Required.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.EnableMigrationProviderSpecificInput
        """
        super().__init__(**kwargs)
        self.policy_id = policy_id
        self.provider_specific_details = provider_specific_details


class EnableMigrationProviderSpecificInput(_serialization.Model):
    """Enable migration provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VMwareCbtEnableMigrationInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"VMwareCbt": "VMwareCbtEnableMigrationInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class EnableProtectionInput(_serialization.Model):
    """Enable protection input.

    :ivar properties: Enable protection input properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionInputProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "EnableProtectionInputProperties"},
    }

    def __init__(self, *, properties: Optional["_models.EnableProtectionInputProperties"] = None, **kwargs):
        """
        :keyword properties: Enable protection input properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class EnableProtectionInputProperties(_serialization.Model):
    """Enable protection input properties.

    :ivar policy_id: The Policy Id.
    :vartype policy_id: str
    :ivar protectable_item_id: The protectable item Id.
    :vartype protectable_item_id: str
    :ivar provider_specific_details: The ReplicationProviderInput. For HyperVReplicaAzure provider,
     it will be AzureEnableProtectionInput object. For San provider, it will be
     SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionProviderSpecificInput
    """

    _attribute_map = {
        "policy_id": {"key": "policyId", "type": "str"},
        "protectable_item_id": {"key": "protectableItemId", "type": "str"},
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "EnableProtectionProviderSpecificInput",
        },
    }

    def __init__(
        self,
        *,
        policy_id: Optional[str] = None,
        protectable_item_id: Optional[str] = None,
        provider_specific_details: Optional["_models.EnableProtectionProviderSpecificInput"] = None,
        **kwargs
    ):
        """
        :keyword policy_id: The Policy Id.
        :paramtype policy_id: str
        :keyword protectable_item_id: The protectable item Id.
        :paramtype protectable_item_id: str
        :keyword provider_specific_details: The ReplicationProviderInput. For HyperVReplicaAzure
         provider, it will be AzureEnableProtectionInput object. For San provider, it will be
         SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionProviderSpecificInput
        """
        super().__init__(**kwargs)
        self.policy_id = policy_id
        self.protectable_item_id = protectable_item_id
        self.provider_specific_details = provider_specific_details


class EncryptionDetails(_serialization.Model):
    """Encryption details for the fabric.

    :ivar kek_state: The key encryption key state for the Vmm.
    :vartype kek_state: str
    :ivar kek_cert_thumbprint: The key encryption key certificate thumbprint.
    :vartype kek_cert_thumbprint: str
    :ivar kek_cert_expiry_date: The key encryption key certificate expiry date.
    :vartype kek_cert_expiry_date: ~datetime.datetime
    """

    _attribute_map = {
        "kek_state": {"key": "kekState", "type": "str"},
        "kek_cert_thumbprint": {"key": "kekCertThumbprint", "type": "str"},
        "kek_cert_expiry_date": {"key": "kekCertExpiryDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        kek_state: Optional[str] = None,
        kek_cert_thumbprint: Optional[str] = None,
        kek_cert_expiry_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword kek_state: The key encryption key state for the Vmm.
        :paramtype kek_state: str
        :keyword kek_cert_thumbprint: The key encryption key certificate thumbprint.
        :paramtype kek_cert_thumbprint: str
        :keyword kek_cert_expiry_date: The key encryption key certificate expiry date.
        :paramtype kek_cert_expiry_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.kek_state = kek_state
        self.kek_cert_thumbprint = kek_cert_thumbprint
        self.kek_cert_expiry_date = kek_cert_expiry_date


class Event(Resource):
    """Implements the Event class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: Event related data.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.EventProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "EventProperties"},
    }

    def __init__(
        self, *, location: Optional[str] = None, properties: Optional["_models.EventProperties"] = None, **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: Event related data.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.EventProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class EventCollection(_serialization.Model):
    """Collection of fabric details.

    :ivar value: The list of events.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Event]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Event]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Event"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of events.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Event]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The properties of a monitoring event.

    :ivar event_code: The Id of the monitoring event.
    :vartype event_code: str
    :ivar description: The event name.
    :vartype description: str
    :ivar event_type: The type of the event. for example: VM Health, Server Health, Job Failure
     etc.
    :vartype event_type: str
    :ivar affected_object_friendly_name: The friendly name of the source of the event on which it
     is raised (for example, VM, VMM etc).
    :vartype affected_object_friendly_name: str
    :ivar affected_object_correlation_id: The affected object correlationId for the event.
    :vartype affected_object_correlation_id: str
    :ivar severity: The severity of the event.
    :vartype severity: str
    :ivar time_of_occurrence: The time of occurrence of the event.
    :vartype time_of_occurrence: ~datetime.datetime
    :ivar fabric_id: The ARM ID of the fabric.
    :vartype fabric_id: str
    :ivar provider_specific_details: The provider specific settings.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EventProviderSpecificDetails
    :ivar event_specific_details: The event specific settings.
    :vartype event_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EventSpecificDetails
    :ivar health_errors: The list of errors / warnings capturing details associated with the
     issue(s).
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _attribute_map = {
        "event_code": {"key": "eventCode", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "event_type": {"key": "eventType", "type": "str"},
        "affected_object_friendly_name": {"key": "affectedObjectFriendlyName", "type": "str"},
        "affected_object_correlation_id": {"key": "affectedObjectCorrelationId", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "time_of_occurrence": {"key": "timeOfOccurrence", "type": "iso-8601"},
        "fabric_id": {"key": "fabricId", "type": "str"},
        "provider_specific_details": {"key": "providerSpecificDetails", "type": "EventProviderSpecificDetails"},
        "event_specific_details": {"key": "eventSpecificDetails", "type": "EventSpecificDetails"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
    }

    def __init__(
        self,
        *,
        event_code: Optional[str] = None,
        description: Optional[str] = None,
        event_type: Optional[str] = None,
        affected_object_friendly_name: Optional[str] = None,
        affected_object_correlation_id: Optional[str] = None,
        severity: Optional[str] = None,
        time_of_occurrence: Optional[datetime.datetime] = None,
        fabric_id: Optional[str] = None,
        provider_specific_details: Optional["_models.EventProviderSpecificDetails"] = None,
        event_specific_details: Optional["_models.EventSpecificDetails"] = None,
        health_errors: Optional[List["_models.HealthError"]] = None,
        **kwargs
    ):
        """
        :keyword event_code: The Id of the monitoring event.
        :paramtype event_code: str
        :keyword description: The event name.
        :paramtype description: str
        :keyword event_type: The type of the event. for example: VM Health, Server Health, Job Failure
         etc.
        :paramtype event_type: str
        :keyword affected_object_friendly_name: The friendly name of the source of the event on which
         it is raised (for example, VM, VMM etc).
        :paramtype affected_object_friendly_name: str
        :keyword affected_object_correlation_id: The affected object correlationId for the event.
        :paramtype affected_object_correlation_id: str
        :keyword severity: The severity of the event.
        :paramtype severity: str
        :keyword time_of_occurrence: The time of occurrence of the event.
        :paramtype time_of_occurrence: ~datetime.datetime
        :keyword fabric_id: The ARM ID of the fabric.
        :paramtype fabric_id: str
        :keyword provider_specific_details: The provider specific settings.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.EventProviderSpecificDetails
        :keyword event_specific_details: The event specific settings.
        :paramtype event_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.EventSpecificDetails
        :keyword health_errors: The list of errors / warnings capturing details associated with the
         issue(s).
        :paramtype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
        """
        super().__init__(**kwargs)
        self.event_code = event_code
        self.description = description
        self.event_type = event_type
        self.affected_object_friendly_name = affected_object_friendly_name
        self.affected_object_correlation_id = affected_object_correlation_id
        self.severity = severity
        self.time_of_occurrence = time_of_occurrence
        self.fabric_id = fabric_id
        self.provider_specific_details = provider_specific_details
        self.event_specific_details = event_specific_details
        self.health_errors = health_errors


class EventQueryParameter(_serialization.Model):
    """Implements the event query parameter.

    :ivar event_code: The source id of the events to be queried.
    :vartype event_code: str
    :ivar severity: The severity of the events to be queried.
    :vartype severity: str
    :ivar event_type: The type of the events to be queried.
    :vartype event_type: str
    :ivar fabric_name: The affected object server id of the events to be queried.
    :vartype fabric_name: str
    :ivar affected_object_friendly_name: The affected object name of the events to be queried.
    :vartype affected_object_friendly_name: str
    :ivar affected_object_correlation_id: The affected object correlationId for the events to be
     queried.
    :vartype affected_object_correlation_id: str
    :ivar start_time: The start time of the time range within which the events are to be queried.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the time range within which the events are to be queried.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        "event_code": {"key": "eventCode", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "event_type": {"key": "eventType", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "affected_object_friendly_name": {"key": "affectedObjectFriendlyName", "type": "str"},
        "affected_object_correlation_id": {"key": "affectedObjectCorrelationId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        event_code: Optional[str] = None,
        severity: Optional[str] = None,
        event_type: Optional[str] = None,
        fabric_name: Optional[str] = None,
        affected_object_friendly_name: Optional[str] = None,
        affected_object_correlation_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword event_code: The source id of the events to be queried.
        :paramtype event_code: str
        :keyword severity: The severity of the events to be queried.
        :paramtype severity: str
        :keyword event_type: The type of the events to be queried.
        :paramtype event_type: str
        :keyword fabric_name: The affected object server id of the events to be queried.
        :paramtype fabric_name: str
        :keyword affected_object_friendly_name: The affected object name of the events to be queried.
        :paramtype affected_object_friendly_name: str
        :keyword affected_object_correlation_id: The affected object correlationId for the events to be
         queried.
        :paramtype affected_object_correlation_id: str
        :keyword start_time: The start time of the time range within which the events are to be
         queried.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the time range within which the events are to be queried.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.event_code = event_code
        self.severity = severity
        self.event_type = event_type
        self.fabric_name = fabric_name
        self.affected_object_friendly_name = affected_object_friendly_name
        self.affected_object_correlation_id = affected_object_correlation_id
        self.start_time = start_time
        self.end_time = end_time


class EventSpecificDetails(_serialization.Model):
    """Model class for event specific details for an event.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JobStatusEventDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"JobStatus": "JobStatusEventDetails"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class ProtectionProfileCustomDetails(_serialization.Model):
    """Protection Profile custom input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExistingProtectionProfile, NewProtectionProfile

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    _subtype_map = {"resource_type": {"Existing": "ExistingProtectionProfile", "New": "NewProtectionProfile"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None


class ExistingProtectionProfile(ProtectionProfileCustomDetails):
    """Existing storage account input.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    :ivar protection_profile_id: The protection profile Arm Id. Throw error, if resource does not
     exists. Required.
    :vartype protection_profile_id: str
    """

    _validation = {
        "resource_type": {"required": True},
        "protection_profile_id": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "protection_profile_id": {"key": "protectionProfileId", "type": "str"},
    }

    def __init__(self, *, protection_profile_id: str, **kwargs):
        """
        :keyword protection_profile_id: The protection profile Arm Id. Throw error, if resource does
         not exists. Required.
        :paramtype protection_profile_id: str
        """
        super().__init__(**kwargs)
        self.resource_type: str = "Existing"
        self.protection_profile_id = protection_profile_id


class RecoveryAvailabilitySetCustomDetails(_serialization.Model):
    """Recovery Availability Set custom input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExistingRecoveryAvailabilitySet

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    _subtype_map = {"resource_type": {"Existing": "ExistingRecoveryAvailabilitySet"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None


class ExistingRecoveryAvailabilitySet(RecoveryAvailabilitySetCustomDetails):
    """Existing recovery availability set input.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    :ivar recovery_availability_set_id: The recovery availability set Id. Will throw error, if
     resource does not exist.
    :vartype recovery_availability_set_id: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "recovery_availability_set_id": {"key": "recoveryAvailabilitySetId", "type": "str"},
    }

    def __init__(self, *, recovery_availability_set_id: Optional[str] = None, **kwargs):
        """
        :keyword recovery_availability_set_id: The recovery availability set Id. Will throw error, if
         resource does not exist.
        :paramtype recovery_availability_set_id: str
        """
        super().__init__(**kwargs)
        self.resource_type: str = "Existing"
        self.recovery_availability_set_id = recovery_availability_set_id


class RecoveryProximityPlacementGroupCustomDetails(_serialization.Model):
    """Recovery Proximity placement group custom input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExistingRecoveryProximityPlacementGroup

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    _subtype_map = {"resource_type": {"Existing": "ExistingRecoveryProximityPlacementGroup"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None


class ExistingRecoveryProximityPlacementGroup(RecoveryProximityPlacementGroupCustomDetails):
    """Existing recovery proximity placement group input.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    :ivar recovery_proximity_placement_group_id: The recovery proximity placement group Id. Will
     throw error, if resource does not exist.
    :vartype recovery_proximity_placement_group_id: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "recovery_proximity_placement_group_id": {"key": "recoveryProximityPlacementGroupId", "type": "str"},
    }

    def __init__(self, *, recovery_proximity_placement_group_id: Optional[str] = None, **kwargs):
        """
        :keyword recovery_proximity_placement_group_id: The recovery proximity placement group Id. Will
         throw error, if resource does not exist.
        :paramtype recovery_proximity_placement_group_id: str
        """
        super().__init__(**kwargs)
        self.resource_type: str = "Existing"
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id


class RecoveryResourceGroupCustomDetails(_serialization.Model):
    """Recovery Resource Group custom input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExistingRecoveryResourceGroup

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    _subtype_map = {"resource_type": {"Existing": "ExistingRecoveryResourceGroup"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None


class ExistingRecoveryResourceGroup(RecoveryResourceGroupCustomDetails):
    """Existing recovery resource group input.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    :ivar recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
    :vartype recovery_resource_group_id: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "recovery_resource_group_id": {"key": "recoveryResourceGroupId", "type": "str"},
    }

    def __init__(self, *, recovery_resource_group_id: Optional[str] = None, **kwargs):
        """
        :keyword recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
        :paramtype recovery_resource_group_id: str
        """
        super().__init__(**kwargs)
        self.resource_type: str = "Existing"
        self.recovery_resource_group_id = recovery_resource_group_id


class RecoveryVirtualNetworkCustomDetails(_serialization.Model):
    """Recovery Virtual network custom input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExistingRecoveryVirtualNetwork, NewRecoveryVirtualNetwork

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    _subtype_map = {"resource_type": {"Existing": "ExistingRecoveryVirtualNetwork", "New": "NewRecoveryVirtualNetwork"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None


class ExistingRecoveryVirtualNetwork(RecoveryVirtualNetworkCustomDetails):
    """Existing recovery virtual network input.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    :ivar recovery_virtual_network_id: The recovery virtual network Id. Will throw error, if
     resource does not exist. Required.
    :vartype recovery_virtual_network_id: str
    :ivar recovery_subnet_name: The recovery subnet name.
    :vartype recovery_subnet_name: str
    """

    _validation = {
        "resource_type": {"required": True},
        "recovery_virtual_network_id": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "recovery_virtual_network_id": {"key": "recoveryVirtualNetworkId", "type": "str"},
        "recovery_subnet_name": {"key": "recoverySubnetName", "type": "str"},
    }

    def __init__(self, *, recovery_virtual_network_id: str, recovery_subnet_name: Optional[str] = None, **kwargs):
        """
        :keyword recovery_virtual_network_id: The recovery virtual network Id. Will throw error, if
         resource does not exist. Required.
        :paramtype recovery_virtual_network_id: str
        :keyword recovery_subnet_name: The recovery subnet name.
        :paramtype recovery_subnet_name: str
        """
        super().__init__(**kwargs)
        self.resource_type: str = "Existing"
        self.recovery_virtual_network_id = recovery_virtual_network_id
        self.recovery_subnet_name = recovery_subnet_name


class StorageAccountCustomDetails(_serialization.Model):
    """Storage account custom input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExistingStorageAccount

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    _subtype_map = {"resource_type": {"Existing": "ExistingStorageAccount"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None


class ExistingStorageAccount(StorageAccountCustomDetails):
    """Existing storage account input.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    :ivar azure_storage_account_id: The storage account Arm Id. Throw error, if resource does not
     exists. Required.
    :vartype azure_storage_account_id: str
    """

    _validation = {
        "resource_type": {"required": True},
        "azure_storage_account_id": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "azure_storage_account_id": {"key": "azureStorageAccountId", "type": "str"},
    }

    def __init__(self, *, azure_storage_account_id: str, **kwargs):
        """
        :keyword azure_storage_account_id: The storage account Arm Id. Throw error, if resource does
         not exists. Required.
        :paramtype azure_storage_account_id: str
        """
        super().__init__(**kwargs)
        self.resource_type: str = "Existing"
        self.azure_storage_account_id = azure_storage_account_id


class ExportJobDetails(JobDetails):
    """This class represents details for export jobs workflow.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the type of job details (see JobDetailsTypes enum for possible
     values). Required.
    :vartype instance_type: str
    :ivar affected_object_details: The affected object properties like source server, source cloud,
     target server, target cloud etc. based on the workflow object details.
    :vartype affected_object_details: dict[str, str]
    :ivar blob_uri: BlobUri of the exported jobs.
    :vartype blob_uri: str
    :ivar sas_token: The sas token to access blob.
    :vartype sas_token: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "affected_object_details": {"key": "affectedObjectDetails", "type": "{str}"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "sas_token": {"key": "sasToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        affected_object_details: Optional[Dict[str, str]] = None,
        blob_uri: Optional[str] = None,
        sas_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword affected_object_details: The affected object properties like source server, source
         cloud, target server, target cloud etc. based on the workflow object details.
        :paramtype affected_object_details: dict[str, str]
        :keyword blob_uri: BlobUri of the exported jobs.
        :paramtype blob_uri: str
        :keyword sas_token: The sas token to access blob.
        :paramtype sas_token: str
        """
        super().__init__(affected_object_details=affected_object_details, **kwargs)
        self.instance_type: str = "ExportJobDetails"
        self.blob_uri = blob_uri
        self.sas_token = sas_token


class ExtendedLocation(_serialization.Model):
    """Extended location of the resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the extended location. Required.
    :vartype name: str
    :ivar type: The extended location type. Required. "EdgeZone"
    :vartype type: str or ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocationType
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: Union[str, "_models.ExtendedLocationType"], **kwargs):
        """
        :keyword name: The name of the extended location. Required.
        :paramtype name: str
        :keyword type: The extended location type. Required. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocationType
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Fabric(Resource):
    """Fabric definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: Fabric related data.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.FabricProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "FabricProperties"},
    }

    def __init__(
        self, *, location: Optional[str] = None, properties: Optional["_models.FabricProperties"] = None, **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: Fabric related data.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.FabricProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class FabricCollection(_serialization.Model):
    """Collection of fabric details.

    :ivar value: The fabric details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Fabric]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Fabric]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Fabric"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The fabric details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Fabric]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FabricCreationInput(_serialization.Model):
    """Site details provided during the time of site creation.

    :ivar properties: Fabric creation input.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.FabricCreationInputProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "FabricCreationInputProperties"},
    }

    def __init__(self, *, properties: Optional["_models.FabricCreationInputProperties"] = None, **kwargs):
        """
        :keyword properties: Fabric creation input.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.FabricCreationInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FabricCreationInputProperties(_serialization.Model):
    """Properties of site details provided during the time of site creation.

    :ivar custom_details: Fabric provider specific creation input.
    :vartype custom_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificCreationInput
    """

    _attribute_map = {
        "custom_details": {"key": "customDetails", "type": "FabricSpecificCreationInput"},
    }

    def __init__(self, *, custom_details: Optional["_models.FabricSpecificCreationInput"] = None, **kwargs):
        """
        :keyword custom_details: Fabric provider specific creation input.
        :paramtype custom_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificCreationInput
        """
        super().__init__(**kwargs)
        self.custom_details = custom_details


class FabricProperties(_serialization.Model):
    """Fabric properties.

    :ivar friendly_name: Friendly name of the fabric.
    :vartype friendly_name: str
    :ivar encryption_details: Encryption details for the fabric.
    :vartype encryption_details: ~azure.mgmt.recoveryservicessiterecovery.models.EncryptionDetails
    :ivar rollover_encryption_details: Rollover encryption details for the fabric.
    :vartype rollover_encryption_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EncryptionDetails
    :ivar internal_identifier: Dra Registration Id.
    :vartype internal_identifier: str
    :ivar bcdr_state: BCDR state of the fabric.
    :vartype bcdr_state: str
    :ivar custom_details: Fabric specific settings.
    :vartype custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificDetails
    :ivar health_error_details: Fabric health error details.
    :vartype health_error_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar health: Health of fabric.
    :vartype health: str
    """

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "encryption_details": {"key": "encryptionDetails", "type": "EncryptionDetails"},
        "rollover_encryption_details": {"key": "rolloverEncryptionDetails", "type": "EncryptionDetails"},
        "internal_identifier": {"key": "internalIdentifier", "type": "str"},
        "bcdr_state": {"key": "bcdrState", "type": "str"},
        "custom_details": {"key": "customDetails", "type": "FabricSpecificDetails"},
        "health_error_details": {"key": "healthErrorDetails", "type": "[HealthError]"},
        "health": {"key": "health", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        encryption_details: Optional["_models.EncryptionDetails"] = None,
        rollover_encryption_details: Optional["_models.EncryptionDetails"] = None,
        internal_identifier: Optional[str] = None,
        bcdr_state: Optional[str] = None,
        custom_details: Optional["_models.FabricSpecificDetails"] = None,
        health_error_details: Optional[List["_models.HealthError"]] = None,
        health: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword friendly_name: Friendly name of the fabric.
        :paramtype friendly_name: str
        :keyword encryption_details: Encryption details for the fabric.
        :paramtype encryption_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.EncryptionDetails
        :keyword rollover_encryption_details: Rollover encryption details for the fabric.
        :paramtype rollover_encryption_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.EncryptionDetails
        :keyword internal_identifier: Dra Registration Id.
        :paramtype internal_identifier: str
        :keyword bcdr_state: BCDR state of the fabric.
        :paramtype bcdr_state: str
        :keyword custom_details: Fabric specific settings.
        :paramtype custom_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificDetails
        :keyword health_error_details: Fabric health error details.
        :paramtype health_error_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
        :keyword health: Health of fabric.
        :paramtype health: str
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.encryption_details = encryption_details
        self.rollover_encryption_details = rollover_encryption_details
        self.internal_identifier = internal_identifier
        self.bcdr_state = bcdr_state
        self.custom_details = custom_details
        self.health_error_details = health_error_details
        self.health = health


class FabricQueryParameter(_serialization.Model):
    """Query parameter to get fabric.

    :ivar zone_to_zone_mappings: A value indicating whether the zone to zone mappings are to be
     returned.
    :vartype zone_to_zone_mappings: str
    :ivar fetch_agent_details: A value indicating whether the agent details are to be fetched.
    :vartype fetch_agent_details: str
    :ivar bios_id: The BIOS Id to be used for fetching agent details.
    :vartype bios_id: str
    :ivar fqdn: The FQDN to be used for fetching agent details.
    :vartype fqdn: str
    :ivar discovery_type: The type of the discovered machine to be used for fetching agent details.
    :vartype discovery_type: str
    :ivar os_type: The OS type to be used for fetching agent details.
    :vartype os_type: str
    """

    _attribute_map = {
        "zone_to_zone_mappings": {"key": "zoneToZoneMappings", "type": "str"},
        "fetch_agent_details": {"key": "fetchAgentDetails", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "discovery_type": {"key": "discoveryType", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
    }

    def __init__(
        self,
        *,
        zone_to_zone_mappings: Optional[str] = None,
        fetch_agent_details: Optional[str] = None,
        bios_id: Optional[str] = None,
        fqdn: Optional[str] = None,
        discovery_type: Optional[str] = None,
        os_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword zone_to_zone_mappings: A value indicating whether the zone to zone mappings are to be
         returned.
        :paramtype zone_to_zone_mappings: str
        :keyword fetch_agent_details: A value indicating whether the agent details are to be fetched.
        :paramtype fetch_agent_details: str
        :keyword bios_id: The BIOS Id to be used for fetching agent details.
        :paramtype bios_id: str
        :keyword fqdn: The FQDN to be used for fetching agent details.
        :paramtype fqdn: str
        :keyword discovery_type: The type of the discovered machine to be used for fetching agent
         details.
        :paramtype discovery_type: str
        :keyword os_type: The OS type to be used for fetching agent details.
        :paramtype os_type: str
        """
        super().__init__(**kwargs)
        self.zone_to_zone_mappings = zone_to_zone_mappings
        self.fetch_agent_details = fetch_agent_details
        self.bios_id = bios_id
        self.fqdn = fqdn
        self.discovery_type = discovery_type
        self.os_type = os_type


class JobTaskDetails(TaskTypeDetails):
    """This class represents a task which is actually a workflow so that one can navigate to its individual drill down.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FabricReplicationGroupTaskDetails, VirtualMachineTaskDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar job_task: The job entity.
    :vartype job_task: ~azure.mgmt.recoveryservicessiterecovery.models.JobEntity
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "job_task": {"key": "jobTask", "type": "JobEntity"},
    }

    _subtype_map = {
        "instance_type": {
            "FabricReplicationGroupTaskDetails": "FabricReplicationGroupTaskDetails",
            "VirtualMachineTaskDetails": "VirtualMachineTaskDetails",
        }
    }

    def __init__(self, *, job_task: Optional["_models.JobEntity"] = None, **kwargs):
        """
        :keyword job_task: The job entity.
        :paramtype job_task: ~azure.mgmt.recoveryservicessiterecovery.models.JobEntity
        """
        super().__init__(**kwargs)
        self.instance_type: str = "JobTaskDetails"
        self.job_task = job_task


class FabricReplicationGroupTaskDetails(JobTaskDetails):
    """This class represents the fabric replication group task details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar job_task: The job entity.
    :vartype job_task: ~azure.mgmt.recoveryservicessiterecovery.models.JobEntity
    :ivar skipped_reason: The skipped reason.
    :vartype skipped_reason: str
    :ivar skipped_reason_string: The skipped reason string.
    :vartype skipped_reason_string: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "job_task": {"key": "jobTask", "type": "JobEntity"},
        "skipped_reason": {"key": "skippedReason", "type": "str"},
        "skipped_reason_string": {"key": "skippedReasonString", "type": "str"},
    }

    def __init__(
        self,
        *,
        job_task: Optional["_models.JobEntity"] = None,
        skipped_reason: Optional[str] = None,
        skipped_reason_string: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword job_task: The job entity.
        :paramtype job_task: ~azure.mgmt.recoveryservicessiterecovery.models.JobEntity
        :keyword skipped_reason: The skipped reason.
        :paramtype skipped_reason: str
        :keyword skipped_reason_string: The skipped reason string.
        :paramtype skipped_reason_string: str
        """
        super().__init__(job_task=job_task, **kwargs)
        self.instance_type: str = "FabricReplicationGroupTaskDetails"
        self.skipped_reason = skipped_reason
        self.skipped_reason_string = skipped_reason_string


class FailoverJobDetails(JobDetails):
    """This class represents the details for a failover job.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the type of job details (see JobDetailsTypes enum for possible
     values). Required.
    :vartype instance_type: str
    :ivar affected_object_details: The affected object properties like source server, source cloud,
     target server, target cloud etc. based on the workflow object details.
    :vartype affected_object_details: dict[str, str]
    :ivar protected_item_details: The test VM details.
    :vartype protected_item_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.FailoverReplicationProtectedItemDetails]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "affected_object_details": {"key": "affectedObjectDetails", "type": "{str}"},
        "protected_item_details": {"key": "protectedItemDetails", "type": "[FailoverReplicationProtectedItemDetails]"},
    }

    def __init__(
        self,
        *,
        affected_object_details: Optional[Dict[str, str]] = None,
        protected_item_details: Optional[List["_models.FailoverReplicationProtectedItemDetails"]] = None,
        **kwargs
    ):
        """
        :keyword affected_object_details: The affected object properties like source server, source
         cloud, target server, target cloud etc. based on the workflow object details.
        :paramtype affected_object_details: dict[str, str]
        :keyword protected_item_details: The test VM details.
        :paramtype protected_item_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.FailoverReplicationProtectedItemDetails]
        """
        super().__init__(affected_object_details=affected_object_details, **kwargs)
        self.instance_type: str = "FailoverJobDetails"
        self.protected_item_details = protected_item_details


class FailoverProcessServerRequest(_serialization.Model):
    """Request to failover a process server.

    :ivar properties: The properties of the PS Failover request.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.FailoverProcessServerRequestProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "FailoverProcessServerRequestProperties"},
    }

    def __init__(self, *, properties: Optional["_models.FailoverProcessServerRequestProperties"] = None, **kwargs):
        """
        :keyword properties: The properties of the PS Failover request.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.FailoverProcessServerRequestProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FailoverProcessServerRequestProperties(_serialization.Model):
    """The properties of the Failover Process Server request.

    :ivar container_name: The container identifier.
    :vartype container_name: str
    :ivar source_process_server_id: The source process server.
    :vartype source_process_server_id: str
    :ivar target_process_server_id: The new process server.
    :vartype target_process_server_id: str
    :ivar vms_to_migrate: The VMS to migrate.
    :vartype vms_to_migrate: list[str]
    :ivar update_type: A value for failover type. It can be systemlevel/serverlevel.
    :vartype update_type: str
    """

    _attribute_map = {
        "container_name": {"key": "containerName", "type": "str"},
        "source_process_server_id": {"key": "sourceProcessServerId", "type": "str"},
        "target_process_server_id": {"key": "targetProcessServerId", "type": "str"},
        "vms_to_migrate": {"key": "vmsToMigrate", "type": "[str]"},
        "update_type": {"key": "updateType", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        source_process_server_id: Optional[str] = None,
        target_process_server_id: Optional[str] = None,
        vms_to_migrate: Optional[List[str]] = None,
        update_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword container_name: The container identifier.
        :paramtype container_name: str
        :keyword source_process_server_id: The source process server.
        :paramtype source_process_server_id: str
        :keyword target_process_server_id: The new process server.
        :paramtype target_process_server_id: str
        :keyword vms_to_migrate: The VMS to migrate.
        :paramtype vms_to_migrate: list[str]
        :keyword update_type: A value for failover type. It can be systemlevel/serverlevel.
        :paramtype update_type: str
        """
        super().__init__(**kwargs)
        self.container_name = container_name
        self.source_process_server_id = source_process_server_id
        self.target_process_server_id = target_process_server_id
        self.vms_to_migrate = vms_to_migrate
        self.update_type = update_type


class FailoverReplicationProtectedItemDetails(_serialization.Model):
    """Failover details for a replication protected item.

    :ivar name: The name.
    :vartype name: str
    :ivar friendly_name: The friendly name.
    :vartype friendly_name: str
    :ivar test_vm_name: The test Vm name.
    :vartype test_vm_name: str
    :ivar test_vm_friendly_name: The test Vm friendly name.
    :vartype test_vm_friendly_name: str
    :ivar network_connection_status: The network connection status.
    :vartype network_connection_status: str
    :ivar network_friendly_name: The network friendly name.
    :vartype network_friendly_name: str
    :ivar subnet: The network subnet.
    :vartype subnet: str
    :ivar recovery_point_id: The recovery point Id.
    :vartype recovery_point_id: str
    :ivar recovery_point_time: The recovery point time.
    :vartype recovery_point_time: ~datetime.datetime
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "test_vm_name": {"key": "testVmName", "type": "str"},
        "test_vm_friendly_name": {"key": "testVmFriendlyName", "type": "str"},
        "network_connection_status": {"key": "networkConnectionStatus", "type": "str"},
        "network_friendly_name": {"key": "networkFriendlyName", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        test_vm_name: Optional[str] = None,
        test_vm_friendly_name: Optional[str] = None,
        network_connection_status: Optional[str] = None,
        network_friendly_name: Optional[str] = None,
        subnet: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        recovery_point_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword name: The name.
        :paramtype name: str
        :keyword friendly_name: The friendly name.
        :paramtype friendly_name: str
        :keyword test_vm_name: The test Vm name.
        :paramtype test_vm_name: str
        :keyword test_vm_friendly_name: The test Vm friendly name.
        :paramtype test_vm_friendly_name: str
        :keyword network_connection_status: The network connection status.
        :paramtype network_connection_status: str
        :keyword network_friendly_name: The network friendly name.
        :paramtype network_friendly_name: str
        :keyword subnet: The network subnet.
        :paramtype subnet: str
        :keyword recovery_point_id: The recovery point Id.
        :paramtype recovery_point_id: str
        :keyword recovery_point_time: The recovery point time.
        :paramtype recovery_point_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.name = name
        self.friendly_name = friendly_name
        self.test_vm_name = test_vm_name
        self.test_vm_friendly_name = test_vm_friendly_name
        self.network_connection_status = network_connection_status
        self.network_friendly_name = network_friendly_name
        self.subnet = subnet
        self.recovery_point_id = recovery_point_id
        self.recovery_point_time = recovery_point_time


class GroupTaskDetails(_serialization.Model):
    """This class represents the group task details when parent child relationship exists in the drill down.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InlineWorkflowTaskDetails, RecoveryPlanGroupTaskDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar child_tasks: The child tasks.
    :vartype child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "child_tasks": {"key": "childTasks", "type": "[ASRTask]"},
    }

    _subtype_map = {
        "instance_type": {
            "InlineWorkflowTaskDetails": "InlineWorkflowTaskDetails",
            "RecoveryPlanGroupTaskDetails": "RecoveryPlanGroupTaskDetails",
        }
    }

    def __init__(self, *, child_tasks: Optional[List["_models.ASRTask"]] = None, **kwargs):
        """
        :keyword child_tasks: The child tasks.
        :paramtype child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
        """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None
        self.child_tasks = child_tasks


class HealthError(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Health Error.

    :ivar inner_health_errors: The inner health errors. HealthError having a list of HealthError as
     child errors is problematic. InnerHealthError is used because this will prevent an infinite
     loop of structures when Hydra tries to auto-generate the contract. We are exposing the related
     health errors as inner health errors and all API consumers can utilize this in the same fashion
     as Exception -&gt; InnerException.
    :vartype inner_health_errors:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InnerHealthError]
    :ivar error_source: Source of error.
    :vartype error_source: str
    :ivar error_type: Type of error.
    :vartype error_type: str
    :ivar error_level: Level of error.
    :vartype error_level: str
    :ivar error_category: Category of error.
    :vartype error_category: str
    :ivar error_code: Error code.
    :vartype error_code: str
    :ivar summary_message: Summary message of the entity.
    :vartype summary_message: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar possible_causes: Possible causes of error.
    :vartype possible_causes: str
    :ivar recommended_action: Recommended action to resolve error.
    :vartype recommended_action: str
    :ivar creation_time_utc: Error creation time (UTC).
    :vartype creation_time_utc: ~datetime.datetime
    :ivar recovery_provider_error_message: DRA error message.
    :vartype recovery_provider_error_message: str
    :ivar entity_id: ID of the entity.
    :vartype entity_id: str
    :ivar error_id: The health error unique id.
    :vartype error_id: str
    :ivar customer_resolvability: Value indicating whether the health error is customer resolvable.
     Known values are: "Allowed" and "NotAllowed".
    :vartype customer_resolvability: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCustomerResolvability
    """

    _attribute_map = {
        "inner_health_errors": {"key": "innerHealthErrors", "type": "[InnerHealthError]"},
        "error_source": {"key": "errorSource", "type": "str"},
        "error_type": {"key": "errorType", "type": "str"},
        "error_level": {"key": "errorLevel", "type": "str"},
        "error_category": {"key": "errorCategory", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "summary_message": {"key": "summaryMessage", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "creation_time_utc": {"key": "creationTimeUtc", "type": "iso-8601"},
        "recovery_provider_error_message": {"key": "recoveryProviderErrorMessage", "type": "str"},
        "entity_id": {"key": "entityId", "type": "str"},
        "error_id": {"key": "errorId", "type": "str"},
        "customer_resolvability": {"key": "customerResolvability", "type": "str"},
    }

    def __init__(
        self,
        *,
        inner_health_errors: Optional[List["_models.InnerHealthError"]] = None,
        error_source: Optional[str] = None,
        error_type: Optional[str] = None,
        error_level: Optional[str] = None,
        error_category: Optional[str] = None,
        error_code: Optional[str] = None,
        summary_message: Optional[str] = None,
        error_message: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        creation_time_utc: Optional[datetime.datetime] = None,
        recovery_provider_error_message: Optional[str] = None,
        entity_id: Optional[str] = None,
        error_id: Optional[str] = None,
        customer_resolvability: Optional[Union[str, "_models.HealthErrorCustomerResolvability"]] = None,
        **kwargs
    ):
        """
        :keyword inner_health_errors: The inner health errors. HealthError having a list of HealthError
         as child errors is problematic. InnerHealthError is used because this will prevent an infinite
         loop of structures when Hydra tries to auto-generate the contract. We are exposing the related
         health errors as inner health errors and all API consumers can utilize this in the same fashion
         as Exception -&gt; InnerException.
        :paramtype inner_health_errors:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InnerHealthError]
        :keyword error_source: Source of error.
        :paramtype error_source: str
        :keyword error_type: Type of error.
        :paramtype error_type: str
        :keyword error_level: Level of error.
        :paramtype error_level: str
        :keyword error_category: Category of error.
        :paramtype error_category: str
        :keyword error_code: Error code.
        :paramtype error_code: str
        :keyword summary_message: Summary message of the entity.
        :paramtype summary_message: str
        :keyword error_message: Error message.
        :paramtype error_message: str
        :keyword possible_causes: Possible causes of error.
        :paramtype possible_causes: str
        :keyword recommended_action: Recommended action to resolve error.
        :paramtype recommended_action: str
        :keyword creation_time_utc: Error creation time (UTC).
        :paramtype creation_time_utc: ~datetime.datetime
        :keyword recovery_provider_error_message: DRA error message.
        :paramtype recovery_provider_error_message: str
        :keyword entity_id: ID of the entity.
        :paramtype entity_id: str
        :keyword error_id: The health error unique id.
        :paramtype error_id: str
        :keyword customer_resolvability: Value indicating whether the health error is customer
         resolvable. Known values are: "Allowed" and "NotAllowed".
        :paramtype customer_resolvability: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCustomerResolvability
        """
        super().__init__(**kwargs)
        self.inner_health_errors = inner_health_errors
        self.error_source = error_source
        self.error_type = error_type
        self.error_level = error_level
        self.error_category = error_category
        self.error_code = error_code
        self.summary_message = summary_message
        self.error_message = error_message
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action
        self.creation_time_utc = creation_time_utc
        self.recovery_provider_error_message = recovery_provider_error_message
        self.entity_id = entity_id
        self.error_id = error_id
        self.customer_resolvability = customer_resolvability


class HealthErrorSummary(_serialization.Model):
    """class to define the summary of the health error details.

    :ivar summary_code: The code of the health error.
    :vartype summary_code: str
    :ivar category: The category of the health error. Known values are: "None", "Replication",
     "TestFailover", "Configuration", "FabricInfrastructure", "VersionExpiry",
     "AgentAutoUpdateInfra", "AgentAutoUpdateArtifactDeleted", "AgentAutoUpdateRunAsAccount",
     "AgentAutoUpdateRunAsAccountExpiry", and "AgentAutoUpdateRunAsAccountExpired".
    :vartype category: str or ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCategory
    :ivar severity: Severity of error. Known values are: "NONE", "Warning", "Error", and "Info".
    :vartype severity: str or ~azure.mgmt.recoveryservicessiterecovery.models.Severity
    :ivar summary_message: The summary message of the health error.
    :vartype summary_message: str
    :ivar affected_resource_type: The type of affected ARM resource.
    :vartype affected_resource_type: str
    :ivar affected_resource_subtype: The sub type of any subcomponent within the ARM resource that
     this might be applicable. Value remains null if not applicable.
    :vartype affected_resource_subtype: str
    :ivar affected_resource_correlation_ids: The list of affected resource correlation Ids. This
     can be used to uniquely identify the count of items affected by a specific category and
     severity as well as count of item affected by an specific issue.
    :vartype affected_resource_correlation_ids: list[str]
    """

    _attribute_map = {
        "summary_code": {"key": "summaryCode", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "summary_message": {"key": "summaryMessage", "type": "str"},
        "affected_resource_type": {"key": "affectedResourceType", "type": "str"},
        "affected_resource_subtype": {"key": "affectedResourceSubtype", "type": "str"},
        "affected_resource_correlation_ids": {"key": "affectedResourceCorrelationIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        summary_code: Optional[str] = None,
        category: Optional[Union[str, "_models.HealthErrorCategory"]] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        summary_message: Optional[str] = None,
        affected_resource_type: Optional[str] = None,
        affected_resource_subtype: Optional[str] = None,
        affected_resource_correlation_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword summary_code: The code of the health error.
        :paramtype summary_code: str
        :keyword category: The category of the health error. Known values are: "None", "Replication",
         "TestFailover", "Configuration", "FabricInfrastructure", "VersionExpiry",
         "AgentAutoUpdateInfra", "AgentAutoUpdateArtifactDeleted", "AgentAutoUpdateRunAsAccount",
         "AgentAutoUpdateRunAsAccountExpiry", and "AgentAutoUpdateRunAsAccountExpired".
        :paramtype category: str or ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCategory
        :keyword severity: Severity of error. Known values are: "NONE", "Warning", "Error", and "Info".
        :paramtype severity: str or ~azure.mgmt.recoveryservicessiterecovery.models.Severity
        :keyword summary_message: The summary message of the health error.
        :paramtype summary_message: str
        :keyword affected_resource_type: The type of affected ARM resource.
        :paramtype affected_resource_type: str
        :keyword affected_resource_subtype: The sub type of any subcomponent within the ARM resource
         that this might be applicable. Value remains null if not applicable.
        :paramtype affected_resource_subtype: str
        :keyword affected_resource_correlation_ids: The list of affected resource correlation Ids. This
         can be used to uniquely identify the count of items affected by a specific category and
         severity as well as count of item affected by an specific issue.
        :paramtype affected_resource_correlation_ids: list[str]
        """
        super().__init__(**kwargs)
        self.summary_code = summary_code
        self.category = category
        self.severity = severity
        self.summary_message = summary_message
        self.affected_resource_type = affected_resource_type
        self.affected_resource_subtype = affected_resource_subtype
        self.affected_resource_correlation_ids = affected_resource_correlation_ids


class HyperVHostDetails(_serialization.Model):
    """Hyper-V host details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Hyper-V host Id.
    :vartype id: str
    :ivar name: The Hyper-V host name.
    :vartype name: str
    :ivar mars_agent_version: The Mars agent version.
    :vartype mars_agent_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "mars_agent_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "mars_agent_version": {"key": "marsAgentVersion", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.mars_agent_version = None


class HyperVReplica2012EventDetails(EventProviderSpecificDetails):
    """Model class for event details of a HyperVReplica E2E event.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar container_name: The container friendly name.
    :vartype container_name: str
    :ivar fabric_name: The fabric friendly name.
    :vartype fabric_name: str
    :ivar remote_container_name: The remote container name.
    :vartype remote_container_name: str
    :ivar remote_fabric_name: The remote fabric name.
    :vartype remote_fabric_name: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "remote_container_name": {"key": "remoteContainerName", "type": "str"},
        "remote_fabric_name": {"key": "remoteFabricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        remote_container_name: Optional[str] = None,
        remote_fabric_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword container_name: The container friendly name.
        :paramtype container_name: str
        :keyword fabric_name: The fabric friendly name.
        :paramtype fabric_name: str
        :keyword remote_container_name: The remote container name.
        :paramtype remote_container_name: str
        :keyword remote_fabric_name: The remote fabric name.
        :paramtype remote_fabric_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplica2012"
        self.container_name = container_name
        self.fabric_name = fabric_name
        self.remote_container_name = remote_container_name
        self.remote_fabric_name = remote_fabric_name


class HyperVReplica2012R2EventDetails(EventProviderSpecificDetails):
    """Model class for event details of a HyperVReplica blue E2E event.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar container_name: The container friendly name.
    :vartype container_name: str
    :ivar fabric_name: The fabric friendly name.
    :vartype fabric_name: str
    :ivar remote_container_name: The remote container name.
    :vartype remote_container_name: str
    :ivar remote_fabric_name: The remote fabric name.
    :vartype remote_fabric_name: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "remote_container_name": {"key": "remoteContainerName", "type": "str"},
        "remote_fabric_name": {"key": "remoteFabricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        remote_container_name: Optional[str] = None,
        remote_fabric_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword container_name: The container friendly name.
        :paramtype container_name: str
        :keyword fabric_name: The fabric friendly name.
        :paramtype fabric_name: str
        :keyword remote_container_name: The remote container name.
        :paramtype remote_container_name: str
        :keyword remote_fabric_name: The remote fabric name.
        :paramtype remote_fabric_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplica2012R2"
        self.container_name = container_name
        self.fabric_name = fabric_name
        self.remote_container_name = remote_container_name
        self.remote_fabric_name = remote_fabric_name


class HyperVReplicaAzureApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to HyperVReplicaAzure provider.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar primary_kek_certificate_pfx: The primary kek certificate pfx.
    :vartype primary_kek_certificate_pfx: str
    :ivar secondary_kek_certificate_pfx: The secondary kek certificate pfx.
    :vartype secondary_kek_certificate_pfx: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_kek_certificate_pfx": {"key": "primaryKekCertificatePfx", "type": "str"},
        "secondary_kek_certificate_pfx": {"key": "secondaryKekCertificatePfx", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary_kek_certificate_pfx: The primary kek certificate pfx.
        :paramtype primary_kek_certificate_pfx: str
        :keyword secondary_kek_certificate_pfx: The secondary kek certificate pfx.
        :paramtype secondary_kek_certificate_pfx: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx


class HyperVReplicaAzureDiskInputDetails(_serialization.Model):
    """Disk input details.

    :ivar disk_id: The DiskId.
    :vartype disk_id: str
    :ivar log_storage_account_id: The LogStorageAccountId.
    :vartype log_storage_account_id: str
    :ivar disk_type: The DiskType. Known values are: "Standard_LRS", "Premium_LRS", and
     "StandardSSD_LRS".
    :vartype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM ID.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        disk_type: Optional[Union[str, "_models.DiskAccountType"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The DiskId.
        :paramtype disk_id: str
        :keyword log_storage_account_id: The LogStorageAccountId.
        :paramtype log_storage_account_id: str
        :keyword disk_type: The DiskType. Known values are: "Standard_LRS", "Premium_LRS", and
         "StandardSSD_LRS".
        :paramtype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
        :keyword disk_encryption_set_id: The DiskEncryptionSet ARM ID.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.log_storage_account_id = log_storage_account_id
        self.disk_type = disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class HyperVReplicaAzureEnableProtectionInput(
    EnableProtectionProviderSpecificInput
):  # pylint: disable=too-many-instance-attributes
    """HyperVReplicaAzure specific enable protection input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar hv_host_vm_id: The Hyper-V host VM Id.
    :vartype hv_host_vm_id: str
    :ivar vm_name: The VM Name.
    :vartype vm_name: str
    :ivar os_type: The OS type associated with VM.
    :vartype os_type: str
    :ivar vhd_id: The OS disk VHD id associated with VM.
    :vartype vhd_id: str
    :ivar target_storage_account_id: The storage account Id.
    :vartype target_storage_account_id: str
    :ivar target_azure_network_id: The selected target Azure network Id.
    :vartype target_azure_network_id: str
    :ivar target_azure_subnet_id: The selected target Azure subnet Id.
    :vartype target_azure_subnet_id: str
    :ivar enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :vartype enable_rdp_on_target_option: str
    :ivar target_azure_vm_name: The target azure VM Name.
    :vartype target_azure_vm_name: str
    :ivar log_storage_account_id: The storage account to be used for logging during replication.
    :vartype log_storage_account_id: str
    :ivar disks_to_include: The list of VHD Ids of disks to be protected.
    :vartype disks_to_include: list[str]
    :ivar target_azure_v1_resource_group_id: The Id of the target resource group (for classic
     deployment) in which the failover VM is to be created.
    :vartype target_azure_v1_resource_group_id: str
    :ivar target_azure_v2_resource_group_id: The Id of the target resource group (for resource
     manager deployment) in which the failover VM is to be created.
    :vartype target_azure_v2_resource_group_id: str
    :ivar use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :vartype use_managed_disks: str
    :ivar target_availability_set_id: The target availability set ARM Id for resource manager
     deployment.
    :vartype target_availability_set_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar license_type: License type. Known values are: "NotSpecified", "NoLicenseType", and
     "WindowsServer".
    :vartype license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :ivar sql_server_license_type: The SQL Server license type. Known values are: "NotSpecified",
     "NoLicenseType", "PAYG", and "AHUB".
    :vartype sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :ivar target_vm_size: The target VM size.
    :vartype target_vm_size: str
    :ivar target_proximity_placement_group_id: The proximity placement group ARM Id.
    :vartype target_proximity_placement_group_id: str
    :ivar use_managed_disks_for_replication: A value indicating whether managed disks should be
     used during replication.
    :vartype use_managed_disks_for_replication: str
    :ivar disk_type: The DiskType. Known values are: "Standard_LRS", "Premium_LRS", and
     "StandardSSD_LRS".
    :vartype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar disks_to_include_for_managed_disks: The disks to include list for managed disks.
    :vartype disks_to_include_for_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureDiskInputDetails]
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :vartype disk_encryption_set_id: str
    :ivar target_vm_tags: The target VM tags.
    :vartype target_vm_tags: dict[str, str]
    :ivar seed_managed_disk_tags: The tags for the seed managed disks.
    :vartype seed_managed_disk_tags: dict[str, str]
    :ivar target_managed_disk_tags: The tags for the target managed disks.
    :vartype target_managed_disk_tags: dict[str, str]
    :ivar target_nic_tags: The tags for the target NICs.
    :vartype target_nic_tags: dict[str, str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "hv_host_vm_id": {"key": "hvHostVmId", "type": "str"},
        "vm_name": {"key": "vmName", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "vhd_id": {"key": "vhdId", "type": "str"},
        "target_storage_account_id": {"key": "targetStorageAccountId", "type": "str"},
        "target_azure_network_id": {"key": "targetAzureNetworkId", "type": "str"},
        "target_azure_subnet_id": {"key": "targetAzureSubnetId", "type": "str"},
        "enable_rdp_on_target_option": {"key": "enableRdpOnTargetOption", "type": "str"},
        "target_azure_vm_name": {"key": "targetAzureVmName", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "disks_to_include": {"key": "disksToInclude", "type": "[str]"},
        "target_azure_v1_resource_group_id": {"key": "targetAzureV1ResourceGroupId", "type": "str"},
        "target_azure_v2_resource_group_id": {"key": "targetAzureV2ResourceGroupId", "type": "str"},
        "use_managed_disks": {"key": "useManagedDisks", "type": "str"},
        "target_availability_set_id": {"key": "targetAvailabilitySetId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "sql_server_license_type": {"key": "sqlServerLicenseType", "type": "str"},
        "target_vm_size": {"key": "targetVmSize", "type": "str"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "use_managed_disks_for_replication": {"key": "useManagedDisksForReplication", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "disks_to_include_for_managed_disks": {
            "key": "disksToIncludeForManagedDisks",
            "type": "[HyperVReplicaAzureDiskInputDetails]",
        },
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "target_vm_tags": {"key": "targetVmTags", "type": "{str}"},
        "seed_managed_disk_tags": {"key": "seedManagedDiskTags", "type": "{str}"},
        "target_managed_disk_tags": {"key": "targetManagedDiskTags", "type": "{str}"},
        "target_nic_tags": {"key": "targetNicTags", "type": "{str}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        hv_host_vm_id: Optional[str] = None,
        vm_name: Optional[str] = None,
        os_type: Optional[str] = None,
        vhd_id: Optional[str] = None,
        target_storage_account_id: Optional[str] = None,
        target_azure_network_id: Optional[str] = None,
        target_azure_subnet_id: Optional[str] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        target_azure_vm_name: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        disks_to_include: Optional[List[str]] = None,
        target_azure_v1_resource_group_id: Optional[str] = None,
        target_azure_v2_resource_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        sql_server_license_type: Optional[Union[str, "_models.SqlServerLicenseType"]] = None,
        target_vm_size: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        use_managed_disks_for_replication: Optional[str] = None,
        disk_type: Optional[Union[str, "_models.DiskAccountType"]] = None,
        disks_to_include_for_managed_disks: Optional[List["_models.HyperVReplicaAzureDiskInputDetails"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword hv_host_vm_id: The Hyper-V host VM Id.
        :paramtype hv_host_vm_id: str
        :keyword vm_name: The VM Name.
        :paramtype vm_name: str
        :keyword os_type: The OS type associated with VM.
        :paramtype os_type: str
        :keyword vhd_id: The OS disk VHD id associated with VM.
        :paramtype vhd_id: str
        :keyword target_storage_account_id: The storage account Id.
        :paramtype target_storage_account_id: str
        :keyword target_azure_network_id: The selected target Azure network Id.
        :paramtype target_azure_network_id: str
        :keyword target_azure_subnet_id: The selected target Azure subnet Id.
        :paramtype target_azure_subnet_id: str
        :keyword enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
         failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
        :paramtype enable_rdp_on_target_option: str
        :keyword target_azure_vm_name: The target azure VM Name.
        :paramtype target_azure_vm_name: str
        :keyword log_storage_account_id: The storage account to be used for logging during replication.
        :paramtype log_storage_account_id: str
        :keyword disks_to_include: The list of VHD Ids of disks to be protected.
        :paramtype disks_to_include: list[str]
        :keyword target_azure_v1_resource_group_id: The Id of the target resource group (for classic
         deployment) in which the failover VM is to be created.
        :paramtype target_azure_v1_resource_group_id: str
        :keyword target_azure_v2_resource_group_id: The Id of the target resource group (for resource
         manager deployment) in which the failover VM is to be created.
        :paramtype target_azure_v2_resource_group_id: str
        :keyword use_managed_disks: A value indicating whether managed disks should be used during
         failover.
        :paramtype use_managed_disks: str
        :keyword target_availability_set_id: The target availability set ARM Id for resource manager
         deployment.
        :paramtype target_availability_set_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword license_type: License type. Known values are: "NotSpecified", "NoLicenseType", and
         "WindowsServer".
        :paramtype license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
        :keyword sql_server_license_type: The SQL Server license type. Known values are:
         "NotSpecified", "NoLicenseType", "PAYG", and "AHUB".
        :paramtype sql_server_license_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
        :keyword target_vm_size: The target VM size.
        :paramtype target_vm_size: str
        :keyword target_proximity_placement_group_id: The proximity placement group ARM Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword use_managed_disks_for_replication: A value indicating whether managed disks should be
         used during replication.
        :paramtype use_managed_disks_for_replication: str
        :keyword disk_type: The DiskType. Known values are: "Standard_LRS", "Premium_LRS", and
         "StandardSSD_LRS".
        :paramtype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
        :keyword disks_to_include_for_managed_disks: The disks to include list for managed disks.
        :paramtype disks_to_include_for_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureDiskInputDetails]
        :keyword disk_encryption_set_id: The DiskEncryptionSet ARM Id.
        :paramtype disk_encryption_set_id: str
        :keyword target_vm_tags: The target VM tags.
        :paramtype target_vm_tags: dict[str, str]
        :keyword seed_managed_disk_tags: The tags for the seed managed disks.
        :paramtype seed_managed_disk_tags: dict[str, str]
        :keyword target_managed_disk_tags: The tags for the target managed disks.
        :paramtype target_managed_disk_tags: dict[str, str]
        :keyword target_nic_tags: The tags for the target NICs.
        :paramtype target_nic_tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.hv_host_vm_id = hv_host_vm_id
        self.vm_name = vm_name
        self.os_type = os_type
        self.vhd_id = vhd_id
        self.target_storage_account_id = target_storage_account_id
        self.target_azure_network_id = target_azure_network_id
        self.target_azure_subnet_id = target_azure_subnet_id
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.target_azure_vm_name = target_azure_vm_name
        self.log_storage_account_id = log_storage_account_id
        self.disks_to_include = disks_to_include
        self.target_azure_v1_resource_group_id = target_azure_v1_resource_group_id
        self.target_azure_v2_resource_group_id = target_azure_v2_resource_group_id
        self.use_managed_disks = use_managed_disks
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.target_vm_size = target_vm_size
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.use_managed_disks_for_replication = use_managed_disks_for_replication
        self.disk_type = disk_type
        self.disks_to_include_for_managed_disks = disks_to_include_for_managed_disks
        self.disk_encryption_set_id = disk_encryption_set_id
        self.target_vm_tags = target_vm_tags
        self.seed_managed_disk_tags = seed_managed_disk_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags


class HyperVReplicaAzureEventDetails(EventProviderSpecificDetails):
    """Model class for event details of a HyperVReplica E2A event.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar container_name: The container friendly name.
    :vartype container_name: str
    :ivar fabric_name: The fabric friendly name.
    :vartype fabric_name: str
    :ivar remote_container_name: The remote container name.
    :vartype remote_container_name: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "remote_container_name": {"key": "remoteContainerName", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        remote_container_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword container_name: The container friendly name.
        :paramtype container_name: str
        :keyword fabric_name: The fabric friendly name.
        :paramtype fabric_name: str
        :keyword remote_container_name: The remote container name.
        :paramtype remote_container_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.container_name = container_name
        self.fabric_name = fabric_name
        self.remote_container_name = remote_container_name


class PlannedFailoverProviderSpecificFailoverInput(_serialization.Model):
    """Provider specific failover input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVReplicaAzurePlannedFailoverProviderInput, HyperVReplicaAzureFailbackProviderInput,
    InMageRcmFailbackPlannedFailoverProviderInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "HyperVReplicaAzure": "HyperVReplicaAzurePlannedFailoverProviderInput",
            "HyperVReplicaAzureFailback": "HyperVReplicaAzureFailbackProviderInput",
            "InMageRcmFailback": "InMageRcmFailbackPlannedFailoverProviderInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class HyperVReplicaAzureFailbackProviderInput(PlannedFailoverProviderSpecificFailoverInput):
    """HyperVReplicaAzureFailback specific planned failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar data_sync_option: Data sync option.
    :vartype data_sync_option: str
    :ivar recovery_vm_creation_option: ALR options to create alternate recovery.
    :vartype recovery_vm_creation_option: str
    :ivar provider_id_for_alternate_recovery: Provider Id for alternate location.
    :vartype provider_id_for_alternate_recovery: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "data_sync_option": {"key": "dataSyncOption", "type": "str"},
        "recovery_vm_creation_option": {"key": "recoveryVmCreationOption", "type": "str"},
        "provider_id_for_alternate_recovery": {"key": "providerIdForAlternateRecovery", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_sync_option: Optional[str] = None,
        recovery_vm_creation_option: Optional[str] = None,
        provider_id_for_alternate_recovery: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_sync_option: Data sync option.
        :paramtype data_sync_option: str
        :keyword recovery_vm_creation_option: ALR options to create alternate recovery.
        :paramtype recovery_vm_creation_option: str
        :keyword provider_id_for_alternate_recovery: Provider Id for alternate location.
        :paramtype provider_id_for_alternate_recovery: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzureFailback"
        self.data_sync_option = data_sync_option
        self.recovery_vm_creation_option = recovery_vm_creation_option
        self.provider_id_for_alternate_recovery = provider_id_for_alternate_recovery


class HyperVReplicaAzureManagedDiskDetails(_serialization.Model):
    """Hyper-V Managed disk details.

    :ivar disk_id: The disk Id.
    :vartype disk_id: str
    :ivar seed_managed_disk_id: Seed managed disk Id.
    :vartype seed_managed_disk_id: str
    :ivar replica_disk_type: The replica disk type.
    :vartype replica_disk_type: str
    :ivar disk_encryption_set_id: The disk encryption set ARM Id.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "seed_managed_disk_id": {"key": "seedManagedDiskId", "type": "str"},
        "replica_disk_type": {"key": "replicaDiskType", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        seed_managed_disk_id: Optional[str] = None,
        replica_disk_type: Optional[str] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk Id.
        :paramtype disk_id: str
        :keyword seed_managed_disk_id: Seed managed disk Id.
        :paramtype seed_managed_disk_id: str
        :keyword replica_disk_type: The replica disk type.
        :paramtype replica_disk_type: str
        :keyword disk_encryption_set_id: The disk encryption set ARM Id.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.seed_managed_disk_id = seed_managed_disk_id
        self.replica_disk_type = replica_disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class HyperVReplicaAzurePlannedFailoverProviderInput(PlannedFailoverProviderSpecificFailoverInput):
    """HyperVReplicaAzure specific planned failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar primary_kek_certificate_pfx: Primary kek certificate pfx.
    :vartype primary_kek_certificate_pfx: str
    :ivar secondary_kek_certificate_pfx: Secondary kek certificate pfx.
    :vartype secondary_kek_certificate_pfx: str
    :ivar recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_kek_certificate_pfx": {"key": "primaryKekCertificatePfx", "type": "str"},
        "secondary_kek_certificate_pfx": {"key": "secondaryKekCertificatePfx", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary_kek_certificate_pfx: Primary kek certificate pfx.
        :paramtype primary_kek_certificate_pfx: str
        :keyword secondary_kek_certificate_pfx: Secondary kek certificate pfx.
        :paramtype secondary_kek_certificate_pfx: str
        :keyword recovery_point_id: The recovery point id to be passed to failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx
        self.recovery_point_id = recovery_point_id


class HyperVReplicaAzurePolicyDetails(PolicyProviderSpecificDetails):
    """Hyper-V Replica Azure specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar recovery_point_history_duration_in_hours: The duration (in hours) to which point the
     recovery history needs to be maintained.
    :vartype recovery_point_history_duration_in_hours: int
    :ivar application_consistent_snapshot_frequency_in_hours: The interval (in hours) at which
     Hyper-V Replica should create an application consistent snapshot within the VM.
    :vartype application_consistent_snapshot_frequency_in_hours: int
    :ivar replication_interval: The replication interval.
    :vartype replication_interval: int
    :ivar online_replication_start_time: The scheduled start time for the initial replication. If
     this parameter is Null, the initial replication starts immediately.
    :vartype online_replication_start_time: str
    :ivar encryption: A value indicating whether encryption is enabled for virtual machines in this
     cloud.
    :vartype encryption: str
    :ivar active_storage_account_id: The active storage account Id.
    :vartype active_storage_account_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_history_duration_in_hours": {"key": "recoveryPointHistoryDurationInHours", "type": "int"},
        "application_consistent_snapshot_frequency_in_hours": {
            "key": "applicationConsistentSnapshotFrequencyInHours",
            "type": "int",
        },
        "replication_interval": {"key": "replicationInterval", "type": "int"},
        "online_replication_start_time": {"key": "onlineReplicationStartTime", "type": "str"},
        "encryption": {"key": "encryption", "type": "str"},
        "active_storage_account_id": {"key": "activeStorageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_history_duration_in_hours: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        replication_interval: Optional[int] = None,
        online_replication_start_time: Optional[str] = None,
        encryption: Optional[str] = None,
        active_storage_account_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_history_duration_in_hours: The duration (in hours) to which point the
         recovery history needs to be maintained.
        :paramtype recovery_point_history_duration_in_hours: int
        :keyword application_consistent_snapshot_frequency_in_hours: The interval (in hours) at which
         Hyper-V Replica should create an application consistent snapshot within the VM.
        :paramtype application_consistent_snapshot_frequency_in_hours: int
        :keyword replication_interval: The replication interval.
        :paramtype replication_interval: int
        :keyword online_replication_start_time: The scheduled start time for the initial replication.
         If this parameter is Null, the initial replication starts immediately.
        :paramtype online_replication_start_time: str
        :keyword encryption: A value indicating whether encryption is enabled for virtual machines in
         this cloud.
        :paramtype encryption: str
        :keyword active_storage_account_id: The active storage account Id.
        :paramtype active_storage_account_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.recovery_point_history_duration_in_hours = recovery_point_history_duration_in_hours
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.replication_interval = replication_interval
        self.online_replication_start_time = online_replication_start_time
        self.encryption = encryption
        self.active_storage_account_id = active_storage_account_id


class HyperVReplicaAzurePolicyInput(PolicyProviderSpecificInput):
    """Hyper-V Replica Azure specific input for creating a protection profile.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_history_duration: The duration (in hours) to which point the recovery
     history needs to be maintained.
    :vartype recovery_point_history_duration: int
    :ivar application_consistent_snapshot_frequency_in_hours: The interval (in hours) at which
     Hyper-V Replica should create an application consistent snapshot within the VM.
    :vartype application_consistent_snapshot_frequency_in_hours: int
    :ivar replication_interval: The replication interval.
    :vartype replication_interval: int
    :ivar online_replication_start_time: The scheduled start time for the initial replication. If
     this parameter is Null, the initial replication starts immediately.
    :vartype online_replication_start_time: str
    :ivar storage_accounts: The list of storage accounts to which the VMs in the primary cloud can
     replicate to.
    :vartype storage_accounts: list[str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_history_duration": {"key": "recoveryPointHistoryDuration", "type": "int"},
        "application_consistent_snapshot_frequency_in_hours": {
            "key": "applicationConsistentSnapshotFrequencyInHours",
            "type": "int",
        },
        "replication_interval": {"key": "replicationInterval", "type": "int"},
        "online_replication_start_time": {"key": "onlineReplicationStartTime", "type": "str"},
        "storage_accounts": {"key": "storageAccounts", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        recovery_point_history_duration: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        replication_interval: Optional[int] = None,
        online_replication_start_time: Optional[str] = None,
        storage_accounts: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_history_duration: The duration (in hours) to which point the recovery
         history needs to be maintained.
        :paramtype recovery_point_history_duration: int
        :keyword application_consistent_snapshot_frequency_in_hours: The interval (in hours) at which
         Hyper-V Replica should create an application consistent snapshot within the VM.
        :paramtype application_consistent_snapshot_frequency_in_hours: int
        :keyword replication_interval: The replication interval.
        :paramtype replication_interval: int
        :keyword online_replication_start_time: The scheduled start time for the initial replication.
         If this parameter is Null, the initial replication starts immediately.
        :paramtype online_replication_start_time: str
        :keyword storage_accounts: The list of storage accounts to which the VMs in the primary cloud
         can replicate to.
        :paramtype storage_accounts: list[str]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.recovery_point_history_duration = recovery_point_history_duration
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.replication_interval = replication_interval
        self.online_replication_start_time = online_replication_start_time
        self.storage_accounts = storage_accounts


class HyperVReplicaAzureReplicationDetails(
    ReplicationProviderSpecificSettings
):  # pylint: disable=too-many-instance-attributes
    """Hyper V Replica Azure provider specific settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar azure_vm_disk_details: Azure VM Disk details.
    :vartype azure_vm_disk_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.AzureVmDiskDetails]
    :ivar recovery_azure_vm_name: Recovery Azure given name.
    :vartype recovery_azure_vm_name: str
    :ivar recovery_azure_vm_size: The Recovery Azure VM size.
    :vartype recovery_azure_vm_size: str
    :ivar recovery_azure_storage_account: The recovery Azure storage account.
    :vartype recovery_azure_storage_account: str
    :ivar recovery_azure_log_storage_account_id: The ARM id of the log storage account used for
     replication. This will be set to null if no log storage account was provided during enable
     protection.
    :vartype recovery_azure_log_storage_account_id: str
    :ivar last_replicated_time: The Last replication time.
    :vartype last_replicated_time: ~datetime.datetime
    :ivar rpo_in_seconds: Last RPO value.
    :vartype rpo_in_seconds: int
    :ivar last_rpo_calculated_time: The last RPO calculated time.
    :vartype last_rpo_calculated_time: ~datetime.datetime
    :ivar vm_id: The virtual machine Id.
    :vartype vm_id: str
    :ivar vm_protection_state: The protection state for the vm.
    :vartype vm_protection_state: str
    :ivar vm_protection_state_description: The protection state description for the vm.
    :vartype vm_protection_state_description: str
    :ivar initial_replication_details: Initial replication details.
    :vartype initial_replication_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :ivar vm_nics: The PE Network details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :ivar selected_recovery_azure_network_id: The selected recovery azure network Id.
    :vartype selected_recovery_azure_network_id: str
    :ivar selected_source_nic_id: The selected source nic Id which will be used as the primary nic
     during failover.
    :vartype selected_source_nic_id: str
    :ivar encryption: The encryption info.
    :vartype encryption: str
    :ivar o_s_details: The operating system info.
    :vartype o_s_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDetails
    :ivar source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
    :vartype source_vm_ram_size_in_mb: int
    :ivar source_vm_cpu_count: The CPU count of the VM on the primary side.
    :vartype source_vm_cpu_count: int
    :ivar enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :vartype enable_rdp_on_target_option: str
    :ivar recovery_azure_resource_group_id: The target resource group Id.
    :vartype recovery_azure_resource_group_id: str
    :ivar recovery_availability_set_id: The recovery availability set Id.
    :vartype recovery_availability_set_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar target_proximity_placement_group_id: The target proximity placement group Id.
    :vartype target_proximity_placement_group_id: str
    :ivar use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :vartype use_managed_disks: str
    :ivar license_type: License Type of the VM to be used.
    :vartype license_type: str
    :ivar sql_server_license_type: The SQL Server license type.
    :vartype sql_server_license_type: str
    :ivar last_recovery_point_received: The last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar target_vm_tags: The target VM tags.
    :vartype target_vm_tags: dict[str, str]
    :ivar seed_managed_disk_tags: The tags for the seed managed disks.
    :vartype seed_managed_disk_tags: dict[str, str]
    :ivar target_managed_disk_tags: The tags for the target managed disks.
    :vartype target_managed_disk_tags: dict[str, str]
    :ivar target_nic_tags: The tags for the target NICs.
    :vartype target_nic_tags: dict[str, str]
    :ivar protected_managed_disks: The list of protected managed disks.
    :vartype protected_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureManagedDiskDetails]
    """

    _validation = {
        "instance_type": {"required": True},
        "last_recovery_point_received": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "azure_vm_disk_details": {"key": "azureVmDiskDetails", "type": "[AzureVmDiskDetails]"},
        "recovery_azure_vm_name": {"key": "recoveryAzureVmName", "type": "str"},
        "recovery_azure_vm_size": {"key": "recoveryAzureVMSize", "type": "str"},
        "recovery_azure_storage_account": {"key": "recoveryAzureStorageAccount", "type": "str"},
        "recovery_azure_log_storage_account_id": {"key": "recoveryAzureLogStorageAccountId", "type": "str"},
        "last_replicated_time": {"key": "lastReplicatedTime", "type": "iso-8601"},
        "rpo_in_seconds": {"key": "rpoInSeconds", "type": "int"},
        "last_rpo_calculated_time": {"key": "lastRpoCalculatedTime", "type": "iso-8601"},
        "vm_id": {"key": "vmId", "type": "str"},
        "vm_protection_state": {"key": "vmProtectionState", "type": "str"},
        "vm_protection_state_description": {"key": "vmProtectionStateDescription", "type": "str"},
        "initial_replication_details": {"key": "initialReplicationDetails", "type": "InitialReplicationDetails"},
        "vm_nics": {"key": "vmNics", "type": "[VMNicDetails]"},
        "selected_recovery_azure_network_id": {"key": "selectedRecoveryAzureNetworkId", "type": "str"},
        "selected_source_nic_id": {"key": "selectedSourceNicId", "type": "str"},
        "encryption": {"key": "encryption", "type": "str"},
        "o_s_details": {"key": "oSDetails", "type": "OSDetails"},
        "source_vm_ram_size_in_mb": {"key": "sourceVmRamSizeInMB", "type": "int"},
        "source_vm_cpu_count": {"key": "sourceVmCpuCount", "type": "int"},
        "enable_rdp_on_target_option": {"key": "enableRdpOnTargetOption", "type": "str"},
        "recovery_azure_resource_group_id": {"key": "recoveryAzureResourceGroupId", "type": "str"},
        "recovery_availability_set_id": {"key": "recoveryAvailabilitySetId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "use_managed_disks": {"key": "useManagedDisks", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "sql_server_license_type": {"key": "sqlServerLicenseType", "type": "str"},
        "last_recovery_point_received": {"key": "lastRecoveryPointReceived", "type": "iso-8601"},
        "target_vm_tags": {"key": "targetVmTags", "type": "{str}"},
        "seed_managed_disk_tags": {"key": "seedManagedDiskTags", "type": "{str}"},
        "target_managed_disk_tags": {"key": "targetManagedDiskTags", "type": "{str}"},
        "target_nic_tags": {"key": "targetNicTags", "type": "{str}"},
        "protected_managed_disks": {"key": "protectedManagedDisks", "type": "[HyperVReplicaAzureManagedDiskDetails]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        azure_vm_disk_details: Optional[List["_models.AzureVmDiskDetails"]] = None,
        recovery_azure_vm_name: Optional[str] = None,
        recovery_azure_vm_size: Optional[str] = None,
        recovery_azure_storage_account: Optional[str] = None,
        recovery_azure_log_storage_account_id: Optional[str] = None,
        last_replicated_time: Optional[datetime.datetime] = None,
        rpo_in_seconds: Optional[int] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        initial_replication_details: Optional["_models.InitialReplicationDetails"] = None,
        vm_nics: Optional[List["_models.VMNicDetails"]] = None,
        selected_recovery_azure_network_id: Optional[str] = None,
        selected_source_nic_id: Optional[str] = None,
        encryption: Optional[str] = None,
        o_s_details: Optional["_models.OSDetails"] = None,
        source_vm_ram_size_in_mb: Optional[int] = None,
        source_vm_cpu_count: Optional[int] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        recovery_azure_resource_group_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        license_type: Optional[str] = None,
        sql_server_license_type: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        protected_managed_disks: Optional[List["_models.HyperVReplicaAzureManagedDiskDetails"]] = None,
        **kwargs
    ):
        """
        :keyword azure_vm_disk_details: Azure VM Disk details.
        :paramtype azure_vm_disk_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.AzureVmDiskDetails]
        :keyword recovery_azure_vm_name: Recovery Azure given name.
        :paramtype recovery_azure_vm_name: str
        :keyword recovery_azure_vm_size: The Recovery Azure VM size.
        :paramtype recovery_azure_vm_size: str
        :keyword recovery_azure_storage_account: The recovery Azure storage account.
        :paramtype recovery_azure_storage_account: str
        :keyword recovery_azure_log_storage_account_id: The ARM id of the log storage account used for
         replication. This will be set to null if no log storage account was provided during enable
         protection.
        :paramtype recovery_azure_log_storage_account_id: str
        :keyword last_replicated_time: The Last replication time.
        :paramtype last_replicated_time: ~datetime.datetime
        :keyword rpo_in_seconds: Last RPO value.
        :paramtype rpo_in_seconds: int
        :keyword last_rpo_calculated_time: The last RPO calculated time.
        :paramtype last_rpo_calculated_time: ~datetime.datetime
        :keyword vm_id: The virtual machine Id.
        :paramtype vm_id: str
        :keyword vm_protection_state: The protection state for the vm.
        :paramtype vm_protection_state: str
        :keyword vm_protection_state_description: The protection state description for the vm.
        :paramtype vm_protection_state_description: str
        :keyword initial_replication_details: Initial replication details.
        :paramtype initial_replication_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
        :keyword vm_nics: The PE Network details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
        :keyword selected_recovery_azure_network_id: The selected recovery azure network Id.
        :paramtype selected_recovery_azure_network_id: str
        :keyword selected_source_nic_id: The selected source nic Id which will be used as the primary
         nic during failover.
        :paramtype selected_source_nic_id: str
        :keyword encryption: The encryption info.
        :paramtype encryption: str
        :keyword o_s_details: The operating system info.
        :paramtype o_s_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDetails
        :keyword source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
        :paramtype source_vm_ram_size_in_mb: int
        :keyword source_vm_cpu_count: The CPU count of the VM on the primary side.
        :paramtype source_vm_cpu_count: int
        :keyword enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
         failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
        :paramtype enable_rdp_on_target_option: str
        :keyword recovery_azure_resource_group_id: The target resource group Id.
        :paramtype recovery_azure_resource_group_id: str
        :keyword recovery_availability_set_id: The recovery availability set Id.
        :paramtype recovery_availability_set_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword target_proximity_placement_group_id: The target proximity placement group Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword use_managed_disks: A value indicating whether managed disks should be used during
         failover.
        :paramtype use_managed_disks: str
        :keyword license_type: License Type of the VM to be used.
        :paramtype license_type: str
        :keyword sql_server_license_type: The SQL Server license type.
        :paramtype sql_server_license_type: str
        :keyword target_vm_tags: The target VM tags.
        :paramtype target_vm_tags: dict[str, str]
        :keyword seed_managed_disk_tags: The tags for the seed managed disks.
        :paramtype seed_managed_disk_tags: dict[str, str]
        :keyword target_managed_disk_tags: The tags for the target managed disks.
        :paramtype target_managed_disk_tags: dict[str, str]
        :keyword target_nic_tags: The tags for the target NICs.
        :paramtype target_nic_tags: dict[str, str]
        :keyword protected_managed_disks: The list of protected managed disks.
        :paramtype protected_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureManagedDiskDetails]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.azure_vm_disk_details = azure_vm_disk_details
        self.recovery_azure_vm_name = recovery_azure_vm_name
        self.recovery_azure_vm_size = recovery_azure_vm_size
        self.recovery_azure_storage_account = recovery_azure_storage_account
        self.recovery_azure_log_storage_account_id = recovery_azure_log_storage_account_id
        self.last_replicated_time = last_replicated_time
        self.rpo_in_seconds = rpo_in_seconds
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.initial_replication_details = initial_replication_details
        self.vm_nics = vm_nics
        self.selected_recovery_azure_network_id = selected_recovery_azure_network_id
        self.selected_source_nic_id = selected_source_nic_id
        self.encryption = encryption
        self.o_s_details = o_s_details
        self.source_vm_ram_size_in_mb = source_vm_ram_size_in_mb
        self.source_vm_cpu_count = source_vm_cpu_count
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.recovery_azure_resource_group_id = recovery_azure_resource_group_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.use_managed_disks = use_managed_disks
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.last_recovery_point_received = None
        self.target_vm_tags = target_vm_tags
        self.seed_managed_disk_tags = seed_managed_disk_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags
        self.protected_managed_disks = protected_managed_disks


class HyperVReplicaAzureReprotectInput(ReverseReplicationProviderSpecificInput):
    """Azure specific reprotect input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar hv_host_vm_id: The Hyper-V host Vm Id.
    :vartype hv_host_vm_id: str
    :ivar vm_name: The Vm Name.
    :vartype vm_name: str
    :ivar os_type: The OS type associated with vm.
    :vartype os_type: str
    :ivar v_hd_id: The OS disk VHD id associated with vm.
    :vartype v_hd_id: str
    :ivar storage_account_id: The storage account name.
    :vartype storage_account_id: str
    :ivar log_storage_account_id: The storage account to be used for logging during replication.
    :vartype log_storage_account_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "hv_host_vm_id": {"key": "hvHostVmId", "type": "str"},
        "vm_name": {"key": "vmName", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "v_hd_id": {"key": "vHDId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        hv_host_vm_id: Optional[str] = None,
        vm_name: Optional[str] = None,
        os_type: Optional[str] = None,
        v_hd_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword hv_host_vm_id: The Hyper-V host Vm Id.
        :paramtype hv_host_vm_id: str
        :keyword vm_name: The Vm Name.
        :paramtype vm_name: str
        :keyword os_type: The OS type associated with vm.
        :paramtype os_type: str
        :keyword v_hd_id: The OS disk VHD id associated with vm.
        :paramtype v_hd_id: str
        :keyword storage_account_id: The storage account name.
        :paramtype storage_account_id: str
        :keyword log_storage_account_id: The storage account to be used for logging during replication.
        :paramtype log_storage_account_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.hv_host_vm_id = hv_host_vm_id
        self.vm_name = vm_name
        self.os_type = os_type
        self.v_hd_id = v_hd_id
        self.storage_account_id = storage_account_id
        self.log_storage_account_id = log_storage_account_id


class HyperVReplicaAzureTestFailoverInput(TestFailoverProviderSpecificInput):
    """HvrA provider specific input for test failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar primary_kek_certificate_pfx: Primary kek certificate pfx.
    :vartype primary_kek_certificate_pfx: str
    :ivar secondary_kek_certificate_pfx: Secondary kek certificate pfx.
    :vartype secondary_kek_certificate_pfx: str
    :ivar recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_kek_certificate_pfx": {"key": "primaryKekCertificatePfx", "type": "str"},
        "secondary_kek_certificate_pfx": {"key": "secondaryKekCertificatePfx", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary_kek_certificate_pfx: Primary kek certificate pfx.
        :paramtype primary_kek_certificate_pfx: str
        :keyword secondary_kek_certificate_pfx: Secondary kek certificate pfx.
        :paramtype secondary_kek_certificate_pfx: str
        :keyword recovery_point_id: The recovery point id to be passed to test failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx
        self.recovery_point_id = recovery_point_id


class HyperVReplicaAzureUnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """HvrA provider specific input for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar primary_kek_certificate_pfx: Primary kek certificate pfx.
    :vartype primary_kek_certificate_pfx: str
    :ivar secondary_kek_certificate_pfx: Secondary kek certificate pfx.
    :vartype secondary_kek_certificate_pfx: str
    :ivar recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_kek_certificate_pfx": {"key": "primaryKekCertificatePfx", "type": "str"},
        "secondary_kek_certificate_pfx": {"key": "secondaryKekCertificatePfx", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword primary_kek_certificate_pfx: Primary kek certificate pfx.
        :paramtype primary_kek_certificate_pfx: str
        :keyword secondary_kek_certificate_pfx: Secondary kek certificate pfx.
        :paramtype secondary_kek_certificate_pfx: str
        :keyword recovery_point_id: The recovery point id to be passed to failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx
        self.recovery_point_id = recovery_point_id


class HyperVReplicaAzureUpdateReplicationProtectedItemInput(
    UpdateReplicationProtectedItemProviderInput
):  # pylint: disable=too-many-instance-attributes
    """HyperV replica Azure input to update replication protected item.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_azure_v1_resource_group_id: The recovery Azure resource group Id for classic
     deployment.
    :vartype recovery_azure_v1_resource_group_id: str
    :ivar recovery_azure_v2_resource_group_id: The recovery Azure resource group Id for resource
     manager deployment.
    :vartype recovery_azure_v2_resource_group_id: str
    :ivar use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :vartype use_managed_disks: str
    :ivar disk_id_to_disk_encryption_map: The dictionary of disk resource Id to disk encryption set
     ARM Id.
    :vartype disk_id_to_disk_encryption_map: dict[str, str]
    :ivar target_proximity_placement_group_id: The target proximity placement group Id.
    :vartype target_proximity_placement_group_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar target_vm_tags: The target VM tags.
    :vartype target_vm_tags: dict[str, str]
    :ivar target_managed_disk_tags: The tags for the target managed disks.
    :vartype target_managed_disk_tags: dict[str, str]
    :ivar target_nic_tags: The tags for the target NICs.
    :vartype target_nic_tags: dict[str, str]
    :ivar sql_server_license_type: The SQL Server license type. Known values are: "NotSpecified",
     "NoLicenseType", "PAYG", and "AHUB".
    :vartype sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :ivar vm_disks: The list of disk update properties.
    :vartype vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.UpdateDiskInput]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_azure_v1_resource_group_id": {"key": "recoveryAzureV1ResourceGroupId", "type": "str"},
        "recovery_azure_v2_resource_group_id": {"key": "recoveryAzureV2ResourceGroupId", "type": "str"},
        "use_managed_disks": {"key": "useManagedDisks", "type": "str"},
        "disk_id_to_disk_encryption_map": {"key": "diskIdToDiskEncryptionMap", "type": "{str}"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "target_vm_tags": {"key": "targetVmTags", "type": "{str}"},
        "target_managed_disk_tags": {"key": "targetManagedDiskTags", "type": "{str}"},
        "target_nic_tags": {"key": "targetNicTags", "type": "{str}"},
        "sql_server_license_type": {"key": "sqlServerLicenseType", "type": "str"},
        "vm_disks": {"key": "vmDisks", "type": "[UpdateDiskInput]"},
    }

    def __init__(
        self,
        *,
        recovery_azure_v1_resource_group_id: Optional[str] = None,
        recovery_azure_v2_resource_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        disk_id_to_disk_encryption_map: Optional[Dict[str, str]] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        sql_server_license_type: Optional[Union[str, "_models.SqlServerLicenseType"]] = None,
        vm_disks: Optional[List["_models.UpdateDiskInput"]] = None,
        **kwargs
    ):
        """
        :keyword recovery_azure_v1_resource_group_id: The recovery Azure resource group Id for classic
         deployment.
        :paramtype recovery_azure_v1_resource_group_id: str
        :keyword recovery_azure_v2_resource_group_id: The recovery Azure resource group Id for resource
         manager deployment.
        :paramtype recovery_azure_v2_resource_group_id: str
        :keyword use_managed_disks: A value indicating whether managed disks should be used during
         failover.
        :paramtype use_managed_disks: str
        :keyword disk_id_to_disk_encryption_map: The dictionary of disk resource Id to disk encryption
         set ARM Id.
        :paramtype disk_id_to_disk_encryption_map: dict[str, str]
        :keyword target_proximity_placement_group_id: The target proximity placement group Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword target_vm_tags: The target VM tags.
        :paramtype target_vm_tags: dict[str, str]
        :keyword target_managed_disk_tags: The tags for the target managed disks.
        :paramtype target_managed_disk_tags: dict[str, str]
        :keyword target_nic_tags: The tags for the target NICs.
        :paramtype target_nic_tags: dict[str, str]
        :keyword sql_server_license_type: The SQL Server license type. Known values are:
         "NotSpecified", "NoLicenseType", "PAYG", and "AHUB".
        :paramtype sql_server_license_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
        :keyword vm_disks: The list of disk update properties.
        :paramtype vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.UpdateDiskInput]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.recovery_azure_v1_resource_group_id = recovery_azure_v1_resource_group_id
        self.recovery_azure_v2_resource_group_id = recovery_azure_v2_resource_group_id
        self.use_managed_disks = use_managed_disks
        self.disk_id_to_disk_encryption_map = disk_id_to_disk_encryption_map
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_availability_zone = target_availability_zone
        self.target_vm_tags = target_vm_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags
        self.sql_server_license_type = sql_server_license_type
        self.vm_disks = vm_disks


class HyperVReplicaBaseEventDetails(EventProviderSpecificDetails):
    """Abstract model class for event details of a HyperVReplica E2E event.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar container_name: The container friendly name.
    :vartype container_name: str
    :ivar fabric_name: The fabric friendly name.
    :vartype fabric_name: str
    :ivar remote_container_name: The remote container name.
    :vartype remote_container_name: str
    :ivar remote_fabric_name: The remote fabric name.
    :vartype remote_fabric_name: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "remote_container_name": {"key": "remoteContainerName", "type": "str"},
        "remote_fabric_name": {"key": "remoteFabricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        remote_container_name: Optional[str] = None,
        remote_fabric_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword container_name: The container friendly name.
        :paramtype container_name: str
        :keyword fabric_name: The fabric friendly name.
        :paramtype fabric_name: str
        :keyword remote_container_name: The remote container name.
        :paramtype remote_container_name: str
        :keyword remote_fabric_name: The remote fabric name.
        :paramtype remote_fabric_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaBaseEventDetails"
        self.container_name = container_name
        self.fabric_name = fabric_name
        self.remote_container_name = remote_container_name
        self.remote_fabric_name = remote_fabric_name


class HyperVReplicaBasePolicyDetails(PolicyProviderSpecificDetails):  # pylint: disable=too-many-instance-attributes
    """Base class for HyperVReplica policy details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar recovery_points: A value indicating the number of recovery points.
    :vartype recovery_points: int
    :ivar application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :vartype application_consistent_snapshot_frequency_in_hours: int
    :ivar compression: A value indicating whether compression has to be enabled.
    :vartype compression: str
    :ivar initial_replication_method: A value indicating whether IR is online.
    :vartype initial_replication_method: str
    :ivar online_replication_start_time: A value indicating the online IR start time.
    :vartype online_replication_start_time: str
    :ivar offline_replication_import_path: A value indicating the offline IR import path.
    :vartype offline_replication_import_path: str
    :ivar offline_replication_export_path: A value indicating the offline IR export path.
    :vartype offline_replication_export_path: str
    :ivar replication_port: A value indicating the recovery HTTPS port.
    :vartype replication_port: int
    :ivar allowed_authentication_type: A value indicating the authentication type.
    :vartype allowed_authentication_type: int
    :ivar replica_deletion_option: A value indicating whether the VM has to be auto deleted.
     Supported Values: String.Empty, None, OnRecoveryCloud.
    :vartype replica_deletion_option: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_points": {"key": "recoveryPoints", "type": "int"},
        "application_consistent_snapshot_frequency_in_hours": {
            "key": "applicationConsistentSnapshotFrequencyInHours",
            "type": "int",
        },
        "compression": {"key": "compression", "type": "str"},
        "initial_replication_method": {"key": "initialReplicationMethod", "type": "str"},
        "online_replication_start_time": {"key": "onlineReplicationStartTime", "type": "str"},
        "offline_replication_import_path": {"key": "offlineReplicationImportPath", "type": "str"},
        "offline_replication_export_path": {"key": "offlineReplicationExportPath", "type": "str"},
        "replication_port": {"key": "replicationPort", "type": "int"},
        "allowed_authentication_type": {"key": "allowedAuthenticationType", "type": "int"},
        "replica_deletion_option": {"key": "replicaDeletionOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion_option: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_points: A value indicating the number of recovery points.
        :paramtype recovery_points: int
        :keyword application_consistent_snapshot_frequency_in_hours: A value indicating the application
         consistent frequency.
        :paramtype application_consistent_snapshot_frequency_in_hours: int
        :keyword compression: A value indicating whether compression has to be enabled.
        :paramtype compression: str
        :keyword initial_replication_method: A value indicating whether IR is online.
        :paramtype initial_replication_method: str
        :keyword online_replication_start_time: A value indicating the online IR start time.
        :paramtype online_replication_start_time: str
        :keyword offline_replication_import_path: A value indicating the offline IR import path.
        :paramtype offline_replication_import_path: str
        :keyword offline_replication_export_path: A value indicating the offline IR export path.
        :paramtype offline_replication_export_path: str
        :keyword replication_port: A value indicating the recovery HTTPS port.
        :paramtype replication_port: int
        :keyword allowed_authentication_type: A value indicating the authentication type.
        :paramtype allowed_authentication_type: int
        :keyword replica_deletion_option: A value indicating whether the VM has to be auto deleted.
         Supported Values: String.Empty, None, OnRecoveryCloud.
        :paramtype replica_deletion_option: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaBasePolicyDetails"
        self.recovery_points = recovery_points
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.compression = compression
        self.initial_replication_method = initial_replication_method
        self.online_replication_start_time = online_replication_start_time
        self.offline_replication_import_path = offline_replication_import_path
        self.offline_replication_export_path = offline_replication_export_path
        self.replication_port = replication_port
        self.allowed_authentication_type = allowed_authentication_type
        self.replica_deletion_option = replica_deletion_option


class HyperVReplicaBaseReplicationDetails(ReplicationProviderSpecificSettings):
    """Hyper V replica provider specific settings base class.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar last_replicated_time: The Last replication time.
    :vartype last_replicated_time: ~datetime.datetime
    :ivar vm_nics: The PE Network details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :ivar vm_id: The virtual machine Id.
    :vartype vm_id: str
    :ivar vm_protection_state: The protection state for the vm.
    :vartype vm_protection_state: str
    :ivar vm_protection_state_description: The protection state description for the vm.
    :vartype vm_protection_state_description: str
    :ivar initial_replication_details: Initial replication details.
    :vartype initial_replication_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :ivar v_m_disk_details: VM disk details.
    :vartype v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "last_replicated_time": {"key": "lastReplicatedTime", "type": "iso-8601"},
        "vm_nics": {"key": "vmNics", "type": "[VMNicDetails]"},
        "vm_id": {"key": "vmId", "type": "str"},
        "vm_protection_state": {"key": "vmProtectionState", "type": "str"},
        "vm_protection_state_description": {"key": "vmProtectionStateDescription", "type": "str"},
        "initial_replication_details": {"key": "initialReplicationDetails", "type": "InitialReplicationDetails"},
        "v_m_disk_details": {"key": "vMDiskDetails", "type": "[DiskDetails]"},
    }

    def __init__(
        self,
        *,
        last_replicated_time: Optional[datetime.datetime] = None,
        vm_nics: Optional[List["_models.VMNicDetails"]] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        initial_replication_details: Optional["_models.InitialReplicationDetails"] = None,
        v_m_disk_details: Optional[List["_models.DiskDetails"]] = None,
        **kwargs
    ):
        """
        :keyword last_replicated_time: The Last replication time.
        :paramtype last_replicated_time: ~datetime.datetime
        :keyword vm_nics: The PE Network details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
        :keyword vm_id: The virtual machine Id.
        :paramtype vm_id: str
        :keyword vm_protection_state: The protection state for the vm.
        :paramtype vm_protection_state: str
        :keyword vm_protection_state_description: The protection state description for the vm.
        :paramtype vm_protection_state_description: str
        :keyword initial_replication_details: Initial replication details.
        :paramtype initial_replication_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
        :keyword v_m_disk_details: VM disk details.
        :paramtype v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaBaseReplicationDetails"
        self.last_replicated_time = last_replicated_time
        self.vm_nics = vm_nics
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.initial_replication_details = initial_replication_details
        self.v_m_disk_details = v_m_disk_details


class HyperVReplicaBluePolicyDetails(PolicyProviderSpecificDetails):  # pylint: disable=too-many-instance-attributes
    """Hyper-V Replica Blue specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar replication_frequency_in_seconds: A value indicating the replication interval.
    :vartype replication_frequency_in_seconds: int
    :ivar recovery_points: A value indicating the number of recovery points.
    :vartype recovery_points: int
    :ivar application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :vartype application_consistent_snapshot_frequency_in_hours: int
    :ivar compression: A value indicating whether compression has to be enabled.
    :vartype compression: str
    :ivar initial_replication_method: A value indicating whether IR is online.
    :vartype initial_replication_method: str
    :ivar online_replication_start_time: A value indicating the online IR start time.
    :vartype online_replication_start_time: str
    :ivar offline_replication_import_path: A value indicating the offline IR import path.
    :vartype offline_replication_import_path: str
    :ivar offline_replication_export_path: A value indicating the offline IR export path.
    :vartype offline_replication_export_path: str
    :ivar replication_port: A value indicating the recovery HTTPS port.
    :vartype replication_port: int
    :ivar allowed_authentication_type: A value indicating the authentication type.
    :vartype allowed_authentication_type: int
    :ivar replica_deletion_option: A value indicating whether the VM has to be auto deleted.
     Supported Values: String.Empty, None, OnRecoveryCloud.
    :vartype replica_deletion_option: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "replication_frequency_in_seconds": {"key": "replicationFrequencyInSeconds", "type": "int"},
        "recovery_points": {"key": "recoveryPoints", "type": "int"},
        "application_consistent_snapshot_frequency_in_hours": {
            "key": "applicationConsistentSnapshotFrequencyInHours",
            "type": "int",
        },
        "compression": {"key": "compression", "type": "str"},
        "initial_replication_method": {"key": "initialReplicationMethod", "type": "str"},
        "online_replication_start_time": {"key": "onlineReplicationStartTime", "type": "str"},
        "offline_replication_import_path": {"key": "offlineReplicationImportPath", "type": "str"},
        "offline_replication_export_path": {"key": "offlineReplicationExportPath", "type": "str"},
        "replication_port": {"key": "replicationPort", "type": "int"},
        "allowed_authentication_type": {"key": "allowedAuthenticationType", "type": "int"},
        "replica_deletion_option": {"key": "replicaDeletionOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        replication_frequency_in_seconds: Optional[int] = None,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion_option: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword replication_frequency_in_seconds: A value indicating the replication interval.
        :paramtype replication_frequency_in_seconds: int
        :keyword recovery_points: A value indicating the number of recovery points.
        :paramtype recovery_points: int
        :keyword application_consistent_snapshot_frequency_in_hours: A value indicating the application
         consistent frequency.
        :paramtype application_consistent_snapshot_frequency_in_hours: int
        :keyword compression: A value indicating whether compression has to be enabled.
        :paramtype compression: str
        :keyword initial_replication_method: A value indicating whether IR is online.
        :paramtype initial_replication_method: str
        :keyword online_replication_start_time: A value indicating the online IR start time.
        :paramtype online_replication_start_time: str
        :keyword offline_replication_import_path: A value indicating the offline IR import path.
        :paramtype offline_replication_import_path: str
        :keyword offline_replication_export_path: A value indicating the offline IR export path.
        :paramtype offline_replication_export_path: str
        :keyword replication_port: A value indicating the recovery HTTPS port.
        :paramtype replication_port: int
        :keyword allowed_authentication_type: A value indicating the authentication type.
        :paramtype allowed_authentication_type: int
        :keyword replica_deletion_option: A value indicating whether the VM has to be auto deleted.
         Supported Values: String.Empty, None, OnRecoveryCloud.
        :paramtype replica_deletion_option: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplica2012R2"
        self.replication_frequency_in_seconds = replication_frequency_in_seconds
        self.recovery_points = recovery_points
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.compression = compression
        self.initial_replication_method = initial_replication_method
        self.online_replication_start_time = online_replication_start_time
        self.offline_replication_import_path = offline_replication_import_path
        self.offline_replication_export_path = offline_replication_export_path
        self.replication_port = replication_port
        self.allowed_authentication_type = allowed_authentication_type
        self.replica_deletion_option = replica_deletion_option


class HyperVReplicaPolicyInput(PolicyProviderSpecificInput):  # pylint: disable=too-many-instance-attributes
    """Hyper-V Replica specific policy Input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HyperVReplicaBluePolicyInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_points: A value indicating the number of recovery points.
    :vartype recovery_points: int
    :ivar application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :vartype application_consistent_snapshot_frequency_in_hours: int
    :ivar compression: A value indicating whether compression has to be enabled.
    :vartype compression: str
    :ivar initial_replication_method: A value indicating whether IR is online.
    :vartype initial_replication_method: str
    :ivar online_replication_start_time: A value indicating the online IR start time.
    :vartype online_replication_start_time: str
    :ivar offline_replication_import_path: A value indicating the offline IR import path.
    :vartype offline_replication_import_path: str
    :ivar offline_replication_export_path: A value indicating the offline IR export path.
    :vartype offline_replication_export_path: str
    :ivar replication_port: A value indicating the recovery HTTPS port.
    :vartype replication_port: int
    :ivar allowed_authentication_type: A value indicating the authentication type.
    :vartype allowed_authentication_type: int
    :ivar replica_deletion: A value indicating whether the VM has to be auto deleted.
    :vartype replica_deletion: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_points": {"key": "recoveryPoints", "type": "int"},
        "application_consistent_snapshot_frequency_in_hours": {
            "key": "applicationConsistentSnapshotFrequencyInHours",
            "type": "int",
        },
        "compression": {"key": "compression", "type": "str"},
        "initial_replication_method": {"key": "initialReplicationMethod", "type": "str"},
        "online_replication_start_time": {"key": "onlineReplicationStartTime", "type": "str"},
        "offline_replication_import_path": {"key": "offlineReplicationImportPath", "type": "str"},
        "offline_replication_export_path": {"key": "offlineReplicationExportPath", "type": "str"},
        "replication_port": {"key": "replicationPort", "type": "int"},
        "allowed_authentication_type": {"key": "allowedAuthenticationType", "type": "int"},
        "replica_deletion": {"key": "replicaDeletion", "type": "str"},
    }

    _subtype_map = {"instance_type": {"HyperVReplica2012R2": "HyperVReplicaBluePolicyInput"}}

    def __init__(
        self,
        *,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_points: A value indicating the number of recovery points.
        :paramtype recovery_points: int
        :keyword application_consistent_snapshot_frequency_in_hours: A value indicating the application
         consistent frequency.
        :paramtype application_consistent_snapshot_frequency_in_hours: int
        :keyword compression: A value indicating whether compression has to be enabled.
        :paramtype compression: str
        :keyword initial_replication_method: A value indicating whether IR is online.
        :paramtype initial_replication_method: str
        :keyword online_replication_start_time: A value indicating the online IR start time.
        :paramtype online_replication_start_time: str
        :keyword offline_replication_import_path: A value indicating the offline IR import path.
        :paramtype offline_replication_import_path: str
        :keyword offline_replication_export_path: A value indicating the offline IR export path.
        :paramtype offline_replication_export_path: str
        :keyword replication_port: A value indicating the recovery HTTPS port.
        :paramtype replication_port: int
        :keyword allowed_authentication_type: A value indicating the authentication type.
        :paramtype allowed_authentication_type: int
        :keyword replica_deletion: A value indicating whether the VM has to be auto deleted.
        :paramtype replica_deletion: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplica2012"
        self.recovery_points = recovery_points
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.compression = compression
        self.initial_replication_method = initial_replication_method
        self.online_replication_start_time = online_replication_start_time
        self.offline_replication_import_path = offline_replication_import_path
        self.offline_replication_export_path = offline_replication_export_path
        self.replication_port = replication_port
        self.allowed_authentication_type = allowed_authentication_type
        self.replica_deletion = replica_deletion


class HyperVReplicaBluePolicyInput(HyperVReplicaPolicyInput):  # pylint: disable=too-many-instance-attributes
    """HyperV Replica Blue policy input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_points: A value indicating the number of recovery points.
    :vartype recovery_points: int
    :ivar application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :vartype application_consistent_snapshot_frequency_in_hours: int
    :ivar compression: A value indicating whether compression has to be enabled.
    :vartype compression: str
    :ivar initial_replication_method: A value indicating whether IR is online.
    :vartype initial_replication_method: str
    :ivar online_replication_start_time: A value indicating the online IR start time.
    :vartype online_replication_start_time: str
    :ivar offline_replication_import_path: A value indicating the offline IR import path.
    :vartype offline_replication_import_path: str
    :ivar offline_replication_export_path: A value indicating the offline IR export path.
    :vartype offline_replication_export_path: str
    :ivar replication_port: A value indicating the recovery HTTPS port.
    :vartype replication_port: int
    :ivar allowed_authentication_type: A value indicating the authentication type.
    :vartype allowed_authentication_type: int
    :ivar replica_deletion: A value indicating whether the VM has to be auto deleted.
    :vartype replica_deletion: str
    :ivar replication_frequency_in_seconds: A value indicating the replication interval.
    :vartype replication_frequency_in_seconds: int
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_points": {"key": "recoveryPoints", "type": "int"},
        "application_consistent_snapshot_frequency_in_hours": {
            "key": "applicationConsistentSnapshotFrequencyInHours",
            "type": "int",
        },
        "compression": {"key": "compression", "type": "str"},
        "initial_replication_method": {"key": "initialReplicationMethod", "type": "str"},
        "online_replication_start_time": {"key": "onlineReplicationStartTime", "type": "str"},
        "offline_replication_import_path": {"key": "offlineReplicationImportPath", "type": "str"},
        "offline_replication_export_path": {"key": "offlineReplicationExportPath", "type": "str"},
        "replication_port": {"key": "replicationPort", "type": "int"},
        "allowed_authentication_type": {"key": "allowedAuthenticationType", "type": "int"},
        "replica_deletion": {"key": "replicaDeletion", "type": "str"},
        "replication_frequency_in_seconds": {"key": "replicationFrequencyInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion: Optional[str] = None,
        replication_frequency_in_seconds: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword recovery_points: A value indicating the number of recovery points.
        :paramtype recovery_points: int
        :keyword application_consistent_snapshot_frequency_in_hours: A value indicating the application
         consistent frequency.
        :paramtype application_consistent_snapshot_frequency_in_hours: int
        :keyword compression: A value indicating whether compression has to be enabled.
        :paramtype compression: str
        :keyword initial_replication_method: A value indicating whether IR is online.
        :paramtype initial_replication_method: str
        :keyword online_replication_start_time: A value indicating the online IR start time.
        :paramtype online_replication_start_time: str
        :keyword offline_replication_import_path: A value indicating the offline IR import path.
        :paramtype offline_replication_import_path: str
        :keyword offline_replication_export_path: A value indicating the offline IR export path.
        :paramtype offline_replication_export_path: str
        :keyword replication_port: A value indicating the recovery HTTPS port.
        :paramtype replication_port: int
        :keyword allowed_authentication_type: A value indicating the authentication type.
        :paramtype allowed_authentication_type: int
        :keyword replica_deletion: A value indicating whether the VM has to be auto deleted.
        :paramtype replica_deletion: str
        :keyword replication_frequency_in_seconds: A value indicating the replication interval.
        :paramtype replication_frequency_in_seconds: int
        """
        super().__init__(
            recovery_points=recovery_points,
            application_consistent_snapshot_frequency_in_hours=application_consistent_snapshot_frequency_in_hours,
            compression=compression,
            initial_replication_method=initial_replication_method,
            online_replication_start_time=online_replication_start_time,
            offline_replication_import_path=offline_replication_import_path,
            offline_replication_export_path=offline_replication_export_path,
            replication_port=replication_port,
            allowed_authentication_type=allowed_authentication_type,
            replica_deletion=replica_deletion,
            **kwargs
        )
        self.instance_type: str = "HyperVReplica2012R2"
        self.replication_frequency_in_seconds = replication_frequency_in_seconds


class HyperVReplicaBlueReplicationDetails(ReplicationProviderSpecificSettings):
    """HyperV replica 2012 R2 (Blue) replication details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar last_replicated_time: The Last replication time.
    :vartype last_replicated_time: ~datetime.datetime
    :ivar vm_nics: The PE Network details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :ivar vm_id: The virtual machine Id.
    :vartype vm_id: str
    :ivar vm_protection_state: The protection state for the vm.
    :vartype vm_protection_state: str
    :ivar vm_protection_state_description: The protection state description for the vm.
    :vartype vm_protection_state_description: str
    :ivar initial_replication_details: Initial replication details.
    :vartype initial_replication_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :ivar v_m_disk_details: VM disk details.
    :vartype v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "last_replicated_time": {"key": "lastReplicatedTime", "type": "iso-8601"},
        "vm_nics": {"key": "vmNics", "type": "[VMNicDetails]"},
        "vm_id": {"key": "vmId", "type": "str"},
        "vm_protection_state": {"key": "vmProtectionState", "type": "str"},
        "vm_protection_state_description": {"key": "vmProtectionStateDescription", "type": "str"},
        "initial_replication_details": {"key": "initialReplicationDetails", "type": "InitialReplicationDetails"},
        "v_m_disk_details": {"key": "vMDiskDetails", "type": "[DiskDetails]"},
    }

    def __init__(
        self,
        *,
        last_replicated_time: Optional[datetime.datetime] = None,
        vm_nics: Optional[List["_models.VMNicDetails"]] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        initial_replication_details: Optional["_models.InitialReplicationDetails"] = None,
        v_m_disk_details: Optional[List["_models.DiskDetails"]] = None,
        **kwargs
    ):
        """
        :keyword last_replicated_time: The Last replication time.
        :paramtype last_replicated_time: ~datetime.datetime
        :keyword vm_nics: The PE Network details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
        :keyword vm_id: The virtual machine Id.
        :paramtype vm_id: str
        :keyword vm_protection_state: The protection state for the vm.
        :paramtype vm_protection_state: str
        :keyword vm_protection_state_description: The protection state description for the vm.
        :paramtype vm_protection_state_description: str
        :keyword initial_replication_details: Initial replication details.
        :paramtype initial_replication_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
        :keyword v_m_disk_details: VM disk details.
        :paramtype v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplica2012R2"
        self.last_replicated_time = last_replicated_time
        self.vm_nics = vm_nics
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.initial_replication_details = initial_replication_details
        self.v_m_disk_details = v_m_disk_details


class HyperVReplicaPolicyDetails(PolicyProviderSpecificDetails):  # pylint: disable=too-many-instance-attributes
    """Hyper-V Replica Blue specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar recovery_points: A value indicating the number of recovery points.
    :vartype recovery_points: int
    :ivar application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :vartype application_consistent_snapshot_frequency_in_hours: int
    :ivar compression: A value indicating whether compression has to be enabled.
    :vartype compression: str
    :ivar initial_replication_method: A value indicating whether IR is online.
    :vartype initial_replication_method: str
    :ivar online_replication_start_time: A value indicating the online IR start time.
    :vartype online_replication_start_time: str
    :ivar offline_replication_import_path: A value indicating the offline IR import path.
    :vartype offline_replication_import_path: str
    :ivar offline_replication_export_path: A value indicating the offline IR export path.
    :vartype offline_replication_export_path: str
    :ivar replication_port: A value indicating the recovery HTTPS port.
    :vartype replication_port: int
    :ivar allowed_authentication_type: A value indicating the authentication type.
    :vartype allowed_authentication_type: int
    :ivar replica_deletion_option: A value indicating whether the VM has to be auto deleted.
     Supported Values: String.Empty, None, OnRecoveryCloud.
    :vartype replica_deletion_option: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_points": {"key": "recoveryPoints", "type": "int"},
        "application_consistent_snapshot_frequency_in_hours": {
            "key": "applicationConsistentSnapshotFrequencyInHours",
            "type": "int",
        },
        "compression": {"key": "compression", "type": "str"},
        "initial_replication_method": {"key": "initialReplicationMethod", "type": "str"},
        "online_replication_start_time": {"key": "onlineReplicationStartTime", "type": "str"},
        "offline_replication_import_path": {"key": "offlineReplicationImportPath", "type": "str"},
        "offline_replication_export_path": {"key": "offlineReplicationExportPath", "type": "str"},
        "replication_port": {"key": "replicationPort", "type": "int"},
        "allowed_authentication_type": {"key": "allowedAuthenticationType", "type": "int"},
        "replica_deletion_option": {"key": "replicaDeletionOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion_option: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_points: A value indicating the number of recovery points.
        :paramtype recovery_points: int
        :keyword application_consistent_snapshot_frequency_in_hours: A value indicating the application
         consistent frequency.
        :paramtype application_consistent_snapshot_frequency_in_hours: int
        :keyword compression: A value indicating whether compression has to be enabled.
        :paramtype compression: str
        :keyword initial_replication_method: A value indicating whether IR is online.
        :paramtype initial_replication_method: str
        :keyword online_replication_start_time: A value indicating the online IR start time.
        :paramtype online_replication_start_time: str
        :keyword offline_replication_import_path: A value indicating the offline IR import path.
        :paramtype offline_replication_import_path: str
        :keyword offline_replication_export_path: A value indicating the offline IR export path.
        :paramtype offline_replication_export_path: str
        :keyword replication_port: A value indicating the recovery HTTPS port.
        :paramtype replication_port: int
        :keyword allowed_authentication_type: A value indicating the authentication type.
        :paramtype allowed_authentication_type: int
        :keyword replica_deletion_option: A value indicating whether the VM has to be auto deleted.
         Supported Values: String.Empty, None, OnRecoveryCloud.
        :paramtype replica_deletion_option: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplica2012"
        self.recovery_points = recovery_points
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.compression = compression
        self.initial_replication_method = initial_replication_method
        self.online_replication_start_time = online_replication_start_time
        self.offline_replication_import_path = offline_replication_import_path
        self.offline_replication_export_path = offline_replication_export_path
        self.replication_port = replication_port
        self.allowed_authentication_type = allowed_authentication_type
        self.replica_deletion_option = replica_deletion_option


class HyperVReplicaReplicationDetails(ReplicationProviderSpecificSettings):
    """HyperV replica 2012 replication details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar last_replicated_time: The Last replication time.
    :vartype last_replicated_time: ~datetime.datetime
    :ivar vm_nics: The PE Network details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :ivar vm_id: The virtual machine Id.
    :vartype vm_id: str
    :ivar vm_protection_state: The protection state for the vm.
    :vartype vm_protection_state: str
    :ivar vm_protection_state_description: The protection state description for the vm.
    :vartype vm_protection_state_description: str
    :ivar initial_replication_details: Initial replication details.
    :vartype initial_replication_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :ivar v_m_disk_details: VM disk details.
    :vartype v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "last_replicated_time": {"key": "lastReplicatedTime", "type": "iso-8601"},
        "vm_nics": {"key": "vmNics", "type": "[VMNicDetails]"},
        "vm_id": {"key": "vmId", "type": "str"},
        "vm_protection_state": {"key": "vmProtectionState", "type": "str"},
        "vm_protection_state_description": {"key": "vmProtectionStateDescription", "type": "str"},
        "initial_replication_details": {"key": "initialReplicationDetails", "type": "InitialReplicationDetails"},
        "v_m_disk_details": {"key": "vMDiskDetails", "type": "[DiskDetails]"},
    }

    def __init__(
        self,
        *,
        last_replicated_time: Optional[datetime.datetime] = None,
        vm_nics: Optional[List["_models.VMNicDetails"]] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        initial_replication_details: Optional["_models.InitialReplicationDetails"] = None,
        v_m_disk_details: Optional[List["_models.DiskDetails"]] = None,
        **kwargs
    ):
        """
        :keyword last_replicated_time: The Last replication time.
        :paramtype last_replicated_time: ~datetime.datetime
        :keyword vm_nics: The PE Network details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
        :keyword vm_id: The virtual machine Id.
        :paramtype vm_id: str
        :keyword vm_protection_state: The protection state for the vm.
        :paramtype vm_protection_state: str
        :keyword vm_protection_state_description: The protection state description for the vm.
        :paramtype vm_protection_state_description: str
        :keyword initial_replication_details: Initial replication details.
        :paramtype initial_replication_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
        :keyword v_m_disk_details: VM disk details.
        :paramtype v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplica2012"
        self.last_replicated_time = last_replicated_time
        self.vm_nics = vm_nics
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.initial_replication_details = initial_replication_details
        self.v_m_disk_details = v_m_disk_details


class HyperVSiteDetails(FabricSpecificDetails):
    """HyperVSite fabric specific details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar hyper_v_hosts: The list of Hyper-V hosts associated with the fabric.
    :vartype hyper_v_hosts: list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVHostDetails]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "hyper_v_hosts": {"key": "hyperVHosts", "type": "[HyperVHostDetails]"},
    }

    def __init__(self, *, hyper_v_hosts: Optional[List["_models.HyperVHostDetails"]] = None, **kwargs):
        """
        :keyword hyper_v_hosts: The list of Hyper-V hosts associated with the fabric.
        :paramtype hyper_v_hosts:
         list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVHostDetails]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVSite"
        self.hyper_v_hosts = hyper_v_hosts


class HyperVVirtualMachineDetails(ConfigurationSettings):
    """Single Host fabric provider specific VM settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VmmVirtualMachineDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar source_item_id: The source id of the object.
    :vartype source_item_id: str
    :ivar generation: The id of the object in fabric.
    :vartype generation: str
    :ivar os_details: The Last replication time.
    :vartype os_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDetails
    :ivar disk_details: The Last successful failover time.
    :vartype disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    :ivar has_physical_disk: A value indicating whether the VM has a physical disk attached. String
     value of SrsDataContract.PresenceStatus enum. Known values are: "Unknown", "Present", and
     "NotPresent".
    :vartype has_physical_disk: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    :ivar has_fibre_channel_adapter: A value indicating whether the VM has a fibre channel adapter
     attached. String value of SrsDataContract.PresenceStatus enum. Known values are: "Unknown",
     "Present", and "NotPresent".
    :vartype has_fibre_channel_adapter: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    :ivar has_shared_vhd: A value indicating whether the VM has a shared VHD attached. String value
     of SrsDataContract.PresenceStatus enum. Known values are: "Unknown", "Present", and
     "NotPresent".
    :vartype has_shared_vhd: str or ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    :ivar hyper_v_host_id: The Id of the hyper-v host in fabric.
    :vartype hyper_v_host_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "source_item_id": {"key": "sourceItemId", "type": "str"},
        "generation": {"key": "generation", "type": "str"},
        "os_details": {"key": "osDetails", "type": "OSDetails"},
        "disk_details": {"key": "diskDetails", "type": "[DiskDetails]"},
        "has_physical_disk": {"key": "hasPhysicalDisk", "type": "str"},
        "has_fibre_channel_adapter": {"key": "hasFibreChannelAdapter", "type": "str"},
        "has_shared_vhd": {"key": "hasSharedVhd", "type": "str"},
        "hyper_v_host_id": {"key": "hyperVHostId", "type": "str"},
    }

    _subtype_map = {"instance_type": {"VmmVirtualMachine": "VmmVirtualMachineDetails"}}

    def __init__(
        self,
        *,
        source_item_id: Optional[str] = None,
        generation: Optional[str] = None,
        os_details: Optional["_models.OSDetails"] = None,
        disk_details: Optional[List["_models.DiskDetails"]] = None,
        has_physical_disk: Optional[Union[str, "_models.PresenceStatus"]] = None,
        has_fibre_channel_adapter: Optional[Union[str, "_models.PresenceStatus"]] = None,
        has_shared_vhd: Optional[Union[str, "_models.PresenceStatus"]] = None,
        hyper_v_host_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_item_id: The source id of the object.
        :paramtype source_item_id: str
        :keyword generation: The id of the object in fabric.
        :paramtype generation: str
        :keyword os_details: The Last replication time.
        :paramtype os_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDetails
        :keyword disk_details: The Last successful failover time.
        :paramtype disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
        :keyword has_physical_disk: A value indicating whether the VM has a physical disk attached.
         String value of SrsDataContract.PresenceStatus enum. Known values are: "Unknown", "Present",
         and "NotPresent".
        :paramtype has_physical_disk: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
        :keyword has_fibre_channel_adapter: A value indicating whether the VM has a fibre channel
         adapter attached. String value of SrsDataContract.PresenceStatus enum. Known values are:
         "Unknown", "Present", and "NotPresent".
        :paramtype has_fibre_channel_adapter: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
        :keyword has_shared_vhd: A value indicating whether the VM has a shared VHD attached. String
         value of SrsDataContract.PresenceStatus enum. Known values are: "Unknown", "Present", and
         "NotPresent".
        :paramtype has_shared_vhd: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
        :keyword hyper_v_host_id: The Id of the hyper-v host in fabric.
        :paramtype hyper_v_host_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVVirtualMachine"
        self.source_item_id = source_item_id
        self.generation = generation
        self.os_details = os_details
        self.disk_details = disk_details
        self.has_physical_disk = has_physical_disk
        self.has_fibre_channel_adapter = has_fibre_channel_adapter
        self.has_shared_vhd = has_shared_vhd
        self.hyper_v_host_id = hyper_v_host_id


class IdentityProviderDetails(_serialization.Model):
    """Identity provider details.

    :ivar tenant_id: The tenant Id for the service principal with which the on-premise
     management/data plane components would communicate with our Azure services.
    :vartype tenant_id: str
    :ivar application_id: The application/client Id for the service principal with which the
     on-premise management/data plane components would communicate with our Azure services.
    :vartype application_id: str
    :ivar object_id: The object Id of the service principal with which the on-premise
     management/data plane components would communicate with our Azure services.
    :vartype object_id: str
    :ivar audience: The intended Audience of the service principal with which the on-premise
     management/data plane components would communicate with our Azure services.
    :vartype audience: str
    :ivar aad_authority: The base authority for Azure Active Directory authentication.
    :vartype aad_authority: str
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "audience": {"key": "audience", "type": "str"},
        "aad_authority": {"key": "aadAuthority", "type": "str"},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        application_id: Optional[str] = None,
        object_id: Optional[str] = None,
        audience: Optional[str] = None,
        aad_authority: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant Id for the service principal with which the on-premise
         management/data plane components would communicate with our Azure services.
        :paramtype tenant_id: str
        :keyword application_id: The application/client Id for the service principal with which the
         on-premise management/data plane components would communicate with our Azure services.
        :paramtype application_id: str
        :keyword object_id: The object Id of the service principal with which the on-premise
         management/data plane components would communicate with our Azure services.
        :paramtype object_id: str
        :keyword audience: The intended Audience of the service principal with which the on-premise
         management/data plane components would communicate with our Azure services.
        :paramtype audience: str
        :keyword aad_authority: The base authority for Azure Active Directory authentication.
        :paramtype aad_authority: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.application_id = application_id
        self.object_id = object_id
        self.audience = audience
        self.aad_authority = aad_authority


class IdentityProviderInput(_serialization.Model):
    """Identity provider input.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant Id for the service principal with which the on-premise
     management/data plane components would communicate with our Azure services. Required.
    :vartype tenant_id: str
    :ivar application_id: The application/client Id for the service principal with which the
     on-premise management/data plane components would communicate with our Azure services.
     Required.
    :vartype application_id: str
    :ivar object_id: The object Id of the service principal with which the on-premise
     management/data plane components would communicate with our Azure services. Required.
    :vartype object_id: str
    :ivar audience: The intended Audience of the service principal with which the on-premise
     management/data plane components would communicate with our Azure services. Required.
    :vartype audience: str
    :ivar aad_authority: The base authority for Azure Active Directory authentication. Required.
    :vartype aad_authority: str
    """

    _validation = {
        "tenant_id": {"required": True},
        "application_id": {"required": True},
        "object_id": {"required": True},
        "audience": {"required": True},
        "aad_authority": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "audience": {"key": "audience", "type": "str"},
        "aad_authority": {"key": "aadAuthority", "type": "str"},
    }

    def __init__(
        self, *, tenant_id: str, application_id: str, object_id: str, audience: str, aad_authority: str, **kwargs
    ):
        """
        :keyword tenant_id: The tenant Id for the service principal with which the on-premise
         management/data plane components would communicate with our Azure services. Required.
        :paramtype tenant_id: str
        :keyword application_id: The application/client Id for the service principal with which the
         on-premise management/data plane components would communicate with our Azure services.
         Required.
        :paramtype application_id: str
        :keyword object_id: The object Id of the service principal with which the on-premise
         management/data plane components would communicate with our Azure services. Required.
        :paramtype object_id: str
        :keyword audience: The intended Audience of the service principal with which the on-premise
         management/data plane components would communicate with our Azure services. Required.
        :paramtype audience: str
        :keyword aad_authority: The base authority for Azure Active Directory authentication. Required.
        :paramtype aad_authority: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.application_id = application_id
        self.object_id = object_id
        self.audience = audience
        self.aad_authority = aad_authority


class InconsistentVmDetails(_serialization.Model):
    """This class stores the monitoring details for consistency check of inconsistent Protected Entity.

    :ivar vm_name: The Vm name.
    :vartype vm_name: str
    :ivar cloud_name: The Cloud name.
    :vartype cloud_name: str
    :ivar details: The list of details regarding state of the Protected Entity in SRS and On prem.
    :vartype details: list[str]
    :ivar error_ids: The list of error ids.
    :vartype error_ids: list[str]
    """

    _attribute_map = {
        "vm_name": {"key": "vmName", "type": "str"},
        "cloud_name": {"key": "cloudName", "type": "str"},
        "details": {"key": "details", "type": "[str]"},
        "error_ids": {"key": "errorIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        vm_name: Optional[str] = None,
        cloud_name: Optional[str] = None,
        details: Optional[List[str]] = None,
        error_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword vm_name: The Vm name.
        :paramtype vm_name: str
        :keyword cloud_name: The Cloud name.
        :paramtype cloud_name: str
        :keyword details: The list of details regarding state of the Protected Entity in SRS and On
         prem.
        :paramtype details: list[str]
        :keyword error_ids: The list of error ids.
        :paramtype error_ids: list[str]
        """
        super().__init__(**kwargs)
        self.vm_name = vm_name
        self.cloud_name = cloud_name
        self.details = details
        self.error_ids = error_ids


class InitialReplicationDetails(_serialization.Model):
    """Initial replication details.

    :ivar initial_replication_type: Initial replication type.
    :vartype initial_replication_type: str
    :ivar initial_replication_progress_percentage: The initial replication progress percentage.
    :vartype initial_replication_progress_percentage: str
    """

    _attribute_map = {
        "initial_replication_type": {"key": "initialReplicationType", "type": "str"},
        "initial_replication_progress_percentage": {"key": "initialReplicationProgressPercentage", "type": "str"},
    }

    def __init__(
        self,
        *,
        initial_replication_type: Optional[str] = None,
        initial_replication_progress_percentage: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword initial_replication_type: Initial replication type.
        :paramtype initial_replication_type: str
        :keyword initial_replication_progress_percentage: The initial replication progress percentage.
        :paramtype initial_replication_progress_percentage: str
        """
        super().__init__(**kwargs)
        self.initial_replication_type = initial_replication_type
        self.initial_replication_progress_percentage = initial_replication_progress_percentage


class InlineWorkflowTaskDetails(GroupTaskDetails):
    """This class represents the inline workflow task details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar child_tasks: The child tasks.
    :vartype child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    :ivar workflow_ids: The list of child workflow ids.
    :vartype workflow_ids: list[str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "child_tasks": {"key": "childTasks", "type": "[ASRTask]"},
        "workflow_ids": {"key": "workflowIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        child_tasks: Optional[List["_models.ASRTask"]] = None,
        workflow_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword child_tasks: The child tasks.
        :paramtype child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
        :keyword workflow_ids: The list of child workflow ids.
        :paramtype workflow_ids: list[str]
        """
        super().__init__(child_tasks=child_tasks, **kwargs)
        self.instance_type: str = "InlineWorkflowTaskDetails"
        self.workflow_ids = workflow_ids


class InMageAgentDetails(_serialization.Model):
    """The details of the InMage agent.

    :ivar agent_version: The agent version.
    :vartype agent_version: str
    :ivar agent_update_status: A value indicating whether installed agent needs to be updated.
    :vartype agent_update_status: str
    :ivar post_update_reboot_status: A value indicating whether reboot is required after update is
     applied.
    :vartype post_update_reboot_status: str
    :ivar agent_expiry_date: Agent expiry date.
    :vartype agent_expiry_date: ~datetime.datetime
    """

    _attribute_map = {
        "agent_version": {"key": "agentVersion", "type": "str"},
        "agent_update_status": {"key": "agentUpdateStatus", "type": "str"},
        "post_update_reboot_status": {"key": "postUpdateRebootStatus", "type": "str"},
        "agent_expiry_date": {"key": "agentExpiryDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        agent_version: Optional[str] = None,
        agent_update_status: Optional[str] = None,
        post_update_reboot_status: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword agent_version: The agent version.
        :paramtype agent_version: str
        :keyword agent_update_status: A value indicating whether installed agent needs to be updated.
        :paramtype agent_update_status: str
        :keyword post_update_reboot_status: A value indicating whether reboot is required after update
         is applied.
        :paramtype post_update_reboot_status: str
        :keyword agent_expiry_date: Agent expiry date.
        :paramtype agent_expiry_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.agent_version = agent_version
        self.agent_update_status = agent_update_status
        self.post_update_reboot_status = post_update_reboot_status
        self.agent_expiry_date = agent_expiry_date


class InMageAzureV2ApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to InMageAzureV2 provider.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"


class InMageAzureV2DiskInputDetails(_serialization.Model):
    """Disk input details.

    :ivar disk_id: The DiskId.
    :vartype disk_id: str
    :ivar log_storage_account_id: The LogStorageAccountId.
    :vartype log_storage_account_id: str
    :ivar disk_type: The DiskType. Known values are: "Standard_LRS", "Premium_LRS", and
     "StandardSSD_LRS".
    :vartype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM ID.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        disk_type: Optional[Union[str, "_models.DiskAccountType"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The DiskId.
        :paramtype disk_id: str
        :keyword log_storage_account_id: The LogStorageAccountId.
        :paramtype log_storage_account_id: str
        :keyword disk_type: The DiskType. Known values are: "Standard_LRS", "Premium_LRS", and
         "StandardSSD_LRS".
        :paramtype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
        :keyword disk_encryption_set_id: The DiskEncryptionSet ARM ID.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.log_storage_account_id = log_storage_account_id
        self.disk_type = disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class InMageAzureV2EnableProtectionInput(
    EnableProtectionProviderSpecificInput
):  # pylint: disable=too-many-instance-attributes
    """VMware Azure specific enable protection input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar master_target_id: The Master target Id.
    :vartype master_target_id: str
    :ivar process_server_id: The Process Server Id.
    :vartype process_server_id: str
    :ivar storage_account_id: The storage account Id.
    :vartype storage_account_id: str
    :ivar run_as_account_id: The CS account Id.
    :vartype run_as_account_id: str
    :ivar multi_vm_group_id: The multi VM group Id.
    :vartype multi_vm_group_id: str
    :ivar multi_vm_group_name: The multi VM group name.
    :vartype multi_vm_group_name: str
    :ivar disks_to_include: The disks to include list.
    :vartype disks_to_include:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2DiskInputDetails]
    :ivar target_azure_network_id: The selected target Azure network Id.
    :vartype target_azure_network_id: str
    :ivar target_azure_subnet_id: The selected target Azure subnet Id.
    :vartype target_azure_subnet_id: str
    :ivar enable_rdp_on_target_option: The selected option to enable RDP\SSH on target VM after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :vartype enable_rdp_on_target_option: str
    :ivar target_azure_vm_name: The target azure VM Name.
    :vartype target_azure_vm_name: str
    :ivar log_storage_account_id: The storage account to be used for logging during replication.
    :vartype log_storage_account_id: str
    :ivar target_azure_v1_resource_group_id: The Id of the target resource group (for classic
     deployment) in which the failover VM is to be created.
    :vartype target_azure_v1_resource_group_id: str
    :ivar target_azure_v2_resource_group_id: The Id of the target resource group (for resource
     manager deployment) in which the failover VM is to be created.
    :vartype target_azure_v2_resource_group_id: str
    :ivar disk_type: The DiskType. Known values are: "Standard_LRS", "Premium_LRS", and
     "StandardSSD_LRS".
    :vartype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar target_availability_set_id: The target availability set ARM Id for resource manager
     deployment.
    :vartype target_availability_set_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar target_proximity_placement_group_id: The proximity placement group ARM Id.
    :vartype target_proximity_placement_group_id: str
    :ivar license_type: License type. Known values are: "NotSpecified", "NoLicenseType", and
     "WindowsServer".
    :vartype license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :ivar sql_server_license_type: The SQL Server license type. Known values are: "NotSpecified",
     "NoLicenseType", "PAYG", and "AHUB".
    :vartype sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :ivar target_vm_size: The target VM size.
    :vartype target_vm_size: str
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :vartype disk_encryption_set_id: str
    :ivar target_vm_tags: The target VM tags.
    :vartype target_vm_tags: dict[str, str]
    :ivar seed_managed_disk_tags: The tags for the seed managed disks.
    :vartype seed_managed_disk_tags: dict[str, str]
    :ivar target_managed_disk_tags: The tags for the target managed disks.
    :vartype target_managed_disk_tags: dict[str, str]
    :ivar target_nic_tags: The tags for the target NICs.
    :vartype target_nic_tags: dict[str, str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "master_target_id": {"key": "masterTargetId", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "multi_vm_group_id": {"key": "multiVmGroupId", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "disks_to_include": {"key": "disksToInclude", "type": "[InMageAzureV2DiskInputDetails]"},
        "target_azure_network_id": {"key": "targetAzureNetworkId", "type": "str"},
        "target_azure_subnet_id": {"key": "targetAzureSubnetId", "type": "str"},
        "enable_rdp_on_target_option": {"key": "enableRdpOnTargetOption", "type": "str"},
        "target_azure_vm_name": {"key": "targetAzureVmName", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "target_azure_v1_resource_group_id": {"key": "targetAzureV1ResourceGroupId", "type": "str"},
        "target_azure_v2_resource_group_id": {"key": "targetAzureV2ResourceGroupId", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "target_availability_set_id": {"key": "targetAvailabilitySetId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "sql_server_license_type": {"key": "sqlServerLicenseType", "type": "str"},
        "target_vm_size": {"key": "targetVmSize", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "target_vm_tags": {"key": "targetVmTags", "type": "{str}"},
        "seed_managed_disk_tags": {"key": "seedManagedDiskTags", "type": "{str}"},
        "target_managed_disk_tags": {"key": "targetManagedDiskTags", "type": "{str}"},
        "target_nic_tags": {"key": "targetNicTags", "type": "{str}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        master_target_id: Optional[str] = None,
        process_server_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        disks_to_include: Optional[List["_models.InMageAzureV2DiskInputDetails"]] = None,
        target_azure_network_id: Optional[str] = None,
        target_azure_subnet_id: Optional[str] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        target_azure_vm_name: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        target_azure_v1_resource_group_id: Optional[str] = None,
        target_azure_v2_resource_group_id: Optional[str] = None,
        disk_type: Optional[Union[str, "_models.DiskAccountType"]] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        sql_server_license_type: Optional[Union[str, "_models.SqlServerLicenseType"]] = None,
        target_vm_size: Optional[str] = None,
        disk_encryption_set_id: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword master_target_id: The Master target Id.
        :paramtype master_target_id: str
        :keyword process_server_id: The Process Server Id.
        :paramtype process_server_id: str
        :keyword storage_account_id: The storage account Id.
        :paramtype storage_account_id: str
        :keyword run_as_account_id: The CS account Id.
        :paramtype run_as_account_id: str
        :keyword multi_vm_group_id: The multi VM group Id.
        :paramtype multi_vm_group_id: str
        :keyword multi_vm_group_name: The multi VM group name.
        :paramtype multi_vm_group_name: str
        :keyword disks_to_include: The disks to include list.
        :paramtype disks_to_include:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2DiskInputDetails]
        :keyword target_azure_network_id: The selected target Azure network Id.
        :paramtype target_azure_network_id: str
        :keyword target_azure_subnet_id: The selected target Azure subnet Id.
        :paramtype target_azure_subnet_id: str
        :keyword enable_rdp_on_target_option: The selected option to enable RDP\SSH on target VM after
         failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
        :paramtype enable_rdp_on_target_option: str
        :keyword target_azure_vm_name: The target azure VM Name.
        :paramtype target_azure_vm_name: str
        :keyword log_storage_account_id: The storage account to be used for logging during replication.
        :paramtype log_storage_account_id: str
        :keyword target_azure_v1_resource_group_id: The Id of the target resource group (for classic
         deployment) in which the failover VM is to be created.
        :paramtype target_azure_v1_resource_group_id: str
        :keyword target_azure_v2_resource_group_id: The Id of the target resource group (for resource
         manager deployment) in which the failover VM is to be created.
        :paramtype target_azure_v2_resource_group_id: str
        :keyword disk_type: The DiskType. Known values are: "Standard_LRS", "Premium_LRS", and
         "StandardSSD_LRS".
        :paramtype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
        :keyword target_availability_set_id: The target availability set ARM Id for resource manager
         deployment.
        :paramtype target_availability_set_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword target_proximity_placement_group_id: The proximity placement group ARM Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword license_type: License type. Known values are: "NotSpecified", "NoLicenseType", and
         "WindowsServer".
        :paramtype license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
        :keyword sql_server_license_type: The SQL Server license type. Known values are:
         "NotSpecified", "NoLicenseType", "PAYG", and "AHUB".
        :paramtype sql_server_license_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
        :keyword target_vm_size: The target VM size.
        :paramtype target_vm_size: str
        :keyword disk_encryption_set_id: The DiskEncryptionSet ARM Id.
        :paramtype disk_encryption_set_id: str
        :keyword target_vm_tags: The target VM tags.
        :paramtype target_vm_tags: dict[str, str]
        :keyword seed_managed_disk_tags: The tags for the seed managed disks.
        :paramtype seed_managed_disk_tags: dict[str, str]
        :keyword target_managed_disk_tags: The tags for the target managed disks.
        :paramtype target_managed_disk_tags: dict[str, str]
        :keyword target_nic_tags: The tags for the target NICs.
        :paramtype target_nic_tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.master_target_id = master_target_id
        self.process_server_id = process_server_id
        self.storage_account_id = storage_account_id
        self.run_as_account_id = run_as_account_id
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.disks_to_include = disks_to_include
        self.target_azure_network_id = target_azure_network_id
        self.target_azure_subnet_id = target_azure_subnet_id
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.target_azure_vm_name = target_azure_vm_name
        self.log_storage_account_id = log_storage_account_id
        self.target_azure_v1_resource_group_id = target_azure_v1_resource_group_id
        self.target_azure_v2_resource_group_id = target_azure_v2_resource_group_id
        self.disk_type = disk_type
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.target_vm_size = target_vm_size
        self.disk_encryption_set_id = disk_encryption_set_id
        self.target_vm_tags = target_vm_tags
        self.seed_managed_disk_tags = seed_managed_disk_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags


class InMageAzureV2EventDetails(EventProviderSpecificDetails):
    """Model class for event details of a VMwareAzureV2 event.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar event_type: InMage Event type. Takes one of the values of
     InMageDataContract.InMageMonitoringEventType.
    :vartype event_type: str
    :ivar category: InMage Event Category.
    :vartype category: str
    :ivar component: InMage Event Component.
    :vartype component: str
    :ivar corrective_action: Corrective Action string for the event.
    :vartype corrective_action: str
    :ivar details: InMage Event Details.
    :vartype details: str
    :ivar summary: InMage Event Summary.
    :vartype summary: str
    :ivar site_name: VMware Site name.
    :vartype site_name: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "event_type": {"key": "eventType", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "component": {"key": "component", "type": "str"},
        "corrective_action": {"key": "correctiveAction", "type": "str"},
        "details": {"key": "details", "type": "str"},
        "summary": {"key": "summary", "type": "str"},
        "site_name": {"key": "siteName", "type": "str"},
    }

    def __init__(
        self,
        *,
        event_type: Optional[str] = None,
        category: Optional[str] = None,
        component: Optional[str] = None,
        corrective_action: Optional[str] = None,
        details: Optional[str] = None,
        summary: Optional[str] = None,
        site_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword event_type: InMage Event type. Takes one of the values of
         InMageDataContract.InMageMonitoringEventType.
        :paramtype event_type: str
        :keyword category: InMage Event Category.
        :paramtype category: str
        :keyword component: InMage Event Component.
        :paramtype component: str
        :keyword corrective_action: Corrective Action string for the event.
        :paramtype corrective_action: str
        :keyword details: InMage Event Details.
        :paramtype details: str
        :keyword summary: InMage Event Summary.
        :paramtype summary: str
        :keyword site_name: VMware Site name.
        :paramtype site_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.event_type = event_type
        self.category = category
        self.component = component
        self.corrective_action = corrective_action
        self.details = details
        self.summary = summary
        self.site_name = site_name


class InMageAzureV2ManagedDiskDetails(_serialization.Model):
    """InMageAzureV2 Managed disk details.

    :ivar disk_id: The disk id.
    :vartype disk_id: str
    :ivar seed_managed_disk_id: Seed managed disk Id.
    :vartype seed_managed_disk_id: str
    :ivar replica_disk_type: The replica disk type.
    :vartype replica_disk_type: str
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM ID.
    :vartype disk_encryption_set_id: str
    :ivar target_disk_name: The target disk name.
    :vartype target_disk_name: str
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "seed_managed_disk_id": {"key": "seedManagedDiskId", "type": "str"},
        "replica_disk_type": {"key": "replicaDiskType", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "target_disk_name": {"key": "targetDiskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        seed_managed_disk_id: Optional[str] = None,
        replica_disk_type: Optional[str] = None,
        disk_encryption_set_id: Optional[str] = None,
        target_disk_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk id.
        :paramtype disk_id: str
        :keyword seed_managed_disk_id: Seed managed disk Id.
        :paramtype seed_managed_disk_id: str
        :keyword replica_disk_type: The replica disk type.
        :paramtype replica_disk_type: str
        :keyword disk_encryption_set_id: The DiskEncryptionSet ARM ID.
        :paramtype disk_encryption_set_id: str
        :keyword target_disk_name: The target disk name.
        :paramtype target_disk_name: str
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.seed_managed_disk_id = seed_managed_disk_id
        self.replica_disk_type = replica_disk_type
        self.disk_encryption_set_id = disk_encryption_set_id
        self.target_disk_name = target_disk_name


class InMageAzureV2PolicyDetails(PolicyProviderSpecificDetails):
    """InMage Azure v2 specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :vartype recovery_point_threshold_in_minutes: int
    :ivar recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :vartype recovery_point_history: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :vartype app_consistent_frequency_in_minutes: int
    :ivar multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
    :vartype multi_vm_sync_status: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "recovery_point_threshold_in_minutes": {"key": "recoveryPointThresholdInMinutes", "type": "int"},
        "recovery_point_history": {"key": "recoveryPointHistory", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        multi_vm_sync_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
         minutes.
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        :paramtype recovery_point_threshold_in_minutes: int
        :keyword recovery_point_history: The duration in minutes until which the recovery points need
         to be stored.
        :paramtype recovery_point_history: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
        :paramtype multi_vm_sync_status: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMageAzureV2PolicyInput(PolicyProviderSpecificInput):
    """VMWare Azure specific policy Input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :vartype recovery_point_threshold_in_minutes: int
    :ivar recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :vartype recovery_point_history: int
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :vartype app_consistent_frequency_in_minutes: int
    :ivar multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled. Value
     should be 'Enabled' or 'Disabled'. Required. Known values are: "Enable" and "Disable".
    :vartype multi_vm_sync_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
    """

    _validation = {
        "instance_type": {"required": True},
        "multi_vm_sync_status": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_threshold_in_minutes": {"key": "recoveryPointThresholdInMinutes", "type": "int"},
        "recovery_point_history": {"key": "recoveryPointHistory", "type": "int"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        multi_vm_sync_status: Union[str, "_models.SetMultiVmSyncStatus"],
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        :paramtype recovery_point_threshold_in_minutes: int
        :keyword recovery_point_history: The duration in minutes until which the recovery points need
         to be stored.
        :paramtype recovery_point_history: int
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
         minutes).
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in
         minutes).
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
         Value should be 'Enabled' or 'Disabled'. Required. Known values are: "Enable" and "Disable".
        :paramtype multi_vm_sync_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMageAzureV2ProtectedDiskDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """InMageAzureV2 protected disk details.

    :ivar disk_id: The disk id.
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar protection_stage: The protection stage.
    :vartype protection_stage: str
    :ivar health_error_code: The health error code for the disk.
    :vartype health_error_code: str
    :ivar rpo_in_seconds: The RPO in seconds.
    :vartype rpo_in_seconds: int
    :ivar resync_required: A value indicating whether resync is required for this disk.
    :vartype resync_required: str
    :ivar resync_progress_percentage: The resync progress percentage.
    :vartype resync_progress_percentage: int
    :ivar resync_duration_in_seconds: The resync duration in seconds.
    :vartype resync_duration_in_seconds: int
    :ivar disk_capacity_in_bytes: The disk capacity in bytes.
    :vartype disk_capacity_in_bytes: int
    :ivar file_system_capacity_in_bytes: The disk file system capacity in bytes.
    :vartype file_system_capacity_in_bytes: int
    :ivar source_data_in_mega_bytes: The source data transit in MB.
    :vartype source_data_in_mega_bytes: float
    :ivar ps_data_in_mega_bytes: The PS data transit in MB.
    :vartype ps_data_in_mega_bytes: float
    :ivar target_data_in_mega_bytes: The target data transit in MB.
    :vartype target_data_in_mega_bytes: float
    :ivar disk_resized: A value indicating whether disk is resized.
    :vartype disk_resized: str
    :ivar last_rpo_calculated_time: The last RPO calculated time.
    :vartype last_rpo_calculated_time: ~datetime.datetime
    :ivar resync_processed_bytes: The resync processed bytes.
    :vartype resync_processed_bytes: int
    :ivar resync_total_transferred_bytes: The resync total transferred bytes.
    :vartype resync_total_transferred_bytes: int
    :ivar resync_last15_minutes_transferred_bytes: The resync last 15 minutes transferred bytes.
    :vartype resync_last15_minutes_transferred_bytes: int
    :ivar resync_last_data_transfer_time_utc: The last data transfer time in UTC.
    :vartype resync_last_data_transfer_time_utc: ~datetime.datetime
    :ivar resync_start_time: The resync start time.
    :vartype resync_start_time: ~datetime.datetime
    :ivar progress_health: The Progress Health.
    :vartype progress_health: str
    :ivar progress_status: The Progress Status.
    :vartype progress_status: str
    :ivar seconds_to_take_switch_provider: The seconds to take for switch provider.
    :vartype seconds_to_take_switch_provider: int
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_name": {"key": "diskName", "type": "str"},
        "protection_stage": {"key": "protectionStage", "type": "str"},
        "health_error_code": {"key": "healthErrorCode", "type": "str"},
        "rpo_in_seconds": {"key": "rpoInSeconds", "type": "int"},
        "resync_required": {"key": "resyncRequired", "type": "str"},
        "resync_progress_percentage": {"key": "resyncProgressPercentage", "type": "int"},
        "resync_duration_in_seconds": {"key": "resyncDurationInSeconds", "type": "int"},
        "disk_capacity_in_bytes": {"key": "diskCapacityInBytes", "type": "int"},
        "file_system_capacity_in_bytes": {"key": "fileSystemCapacityInBytes", "type": "int"},
        "source_data_in_mega_bytes": {"key": "sourceDataInMegaBytes", "type": "float"},
        "ps_data_in_mega_bytes": {"key": "psDataInMegaBytes", "type": "float"},
        "target_data_in_mega_bytes": {"key": "targetDataInMegaBytes", "type": "float"},
        "disk_resized": {"key": "diskResized", "type": "str"},
        "last_rpo_calculated_time": {"key": "lastRpoCalculatedTime", "type": "iso-8601"},
        "resync_processed_bytes": {"key": "resyncProcessedBytes", "type": "int"},
        "resync_total_transferred_bytes": {"key": "resyncTotalTransferredBytes", "type": "int"},
        "resync_last15_minutes_transferred_bytes": {"key": "resyncLast15MinutesTransferredBytes", "type": "int"},
        "resync_last_data_transfer_time_utc": {"key": "resyncLastDataTransferTimeUTC", "type": "iso-8601"},
        "resync_start_time": {"key": "resyncStartTime", "type": "iso-8601"},
        "progress_health": {"key": "progressHealth", "type": "str"},
        "progress_status": {"key": "progressStatus", "type": "str"},
        "seconds_to_take_switch_provider": {"key": "secondsToTakeSwitchProvider", "type": "int"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        disk_name: Optional[str] = None,
        protection_stage: Optional[str] = None,
        health_error_code: Optional[str] = None,
        rpo_in_seconds: Optional[int] = None,
        resync_required: Optional[str] = None,
        resync_progress_percentage: Optional[int] = None,
        resync_duration_in_seconds: Optional[int] = None,
        disk_capacity_in_bytes: Optional[int] = None,
        file_system_capacity_in_bytes: Optional[int] = None,
        source_data_in_mega_bytes: Optional[float] = None,
        ps_data_in_mega_bytes: Optional[float] = None,
        target_data_in_mega_bytes: Optional[float] = None,
        disk_resized: Optional[str] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        resync_processed_bytes: Optional[int] = None,
        resync_total_transferred_bytes: Optional[int] = None,
        resync_last15_minutes_transferred_bytes: Optional[int] = None,
        resync_last_data_transfer_time_utc: Optional[datetime.datetime] = None,
        resync_start_time: Optional[datetime.datetime] = None,
        progress_health: Optional[str] = None,
        progress_status: Optional[str] = None,
        seconds_to_take_switch_provider: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk id.
        :paramtype disk_id: str
        :keyword disk_name: The disk name.
        :paramtype disk_name: str
        :keyword protection_stage: The protection stage.
        :paramtype protection_stage: str
        :keyword health_error_code: The health error code for the disk.
        :paramtype health_error_code: str
        :keyword rpo_in_seconds: The RPO in seconds.
        :paramtype rpo_in_seconds: int
        :keyword resync_required: A value indicating whether resync is required for this disk.
        :paramtype resync_required: str
        :keyword resync_progress_percentage: The resync progress percentage.
        :paramtype resync_progress_percentage: int
        :keyword resync_duration_in_seconds: The resync duration in seconds.
        :paramtype resync_duration_in_seconds: int
        :keyword disk_capacity_in_bytes: The disk capacity in bytes.
        :paramtype disk_capacity_in_bytes: int
        :keyword file_system_capacity_in_bytes: The disk file system capacity in bytes.
        :paramtype file_system_capacity_in_bytes: int
        :keyword source_data_in_mega_bytes: The source data transit in MB.
        :paramtype source_data_in_mega_bytes: float
        :keyword ps_data_in_mega_bytes: The PS data transit in MB.
        :paramtype ps_data_in_mega_bytes: float
        :keyword target_data_in_mega_bytes: The target data transit in MB.
        :paramtype target_data_in_mega_bytes: float
        :keyword disk_resized: A value indicating whether disk is resized.
        :paramtype disk_resized: str
        :keyword last_rpo_calculated_time: The last RPO calculated time.
        :paramtype last_rpo_calculated_time: ~datetime.datetime
        :keyword resync_processed_bytes: The resync processed bytes.
        :paramtype resync_processed_bytes: int
        :keyword resync_total_transferred_bytes: The resync total transferred bytes.
        :paramtype resync_total_transferred_bytes: int
        :keyword resync_last15_minutes_transferred_bytes: The resync last 15 minutes transferred bytes.
        :paramtype resync_last15_minutes_transferred_bytes: int
        :keyword resync_last_data_transfer_time_utc: The last data transfer time in UTC.
        :paramtype resync_last_data_transfer_time_utc: ~datetime.datetime
        :keyword resync_start_time: The resync start time.
        :paramtype resync_start_time: ~datetime.datetime
        :keyword progress_health: The Progress Health.
        :paramtype progress_health: str
        :keyword progress_status: The Progress Status.
        :paramtype progress_status: str
        :keyword seconds_to_take_switch_provider: The seconds to take for switch provider.
        :paramtype seconds_to_take_switch_provider: int
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.disk_name = disk_name
        self.protection_stage = protection_stage
        self.health_error_code = health_error_code
        self.rpo_in_seconds = rpo_in_seconds
        self.resync_required = resync_required
        self.resync_progress_percentage = resync_progress_percentage
        self.resync_duration_in_seconds = resync_duration_in_seconds
        self.disk_capacity_in_bytes = disk_capacity_in_bytes
        self.file_system_capacity_in_bytes = file_system_capacity_in_bytes
        self.source_data_in_mega_bytes = source_data_in_mega_bytes
        self.ps_data_in_mega_bytes = ps_data_in_mega_bytes
        self.target_data_in_mega_bytes = target_data_in_mega_bytes
        self.disk_resized = disk_resized
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.resync_processed_bytes = resync_processed_bytes
        self.resync_total_transferred_bytes = resync_total_transferred_bytes
        self.resync_last15_minutes_transferred_bytes = resync_last15_minutes_transferred_bytes
        self.resync_last_data_transfer_time_utc = resync_last_data_transfer_time_utc
        self.resync_start_time = resync_start_time
        self.progress_health = progress_health
        self.progress_status = progress_status
        self.seconds_to_take_switch_provider = seconds_to_take_switch_provider


class InMageAzureV2RecoveryPointDetails(ProviderSpecificRecoveryPointDetails):
    """InMage Azure V2 provider specific recovery point details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the provider type. Required.
    :vartype instance_type: str
    :ivar is_multi_vm_sync_point: A value indicating whether the recovery point is multi VM
     consistent.
    :vartype is_multi_vm_sync_point: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "is_multi_vm_sync_point": {"key": "isMultiVmSyncPoint", "type": "str"},
    }

    def __init__(self, *, is_multi_vm_sync_point: Optional[str] = None, **kwargs):
        """
        :keyword is_multi_vm_sync_point: A value indicating whether the recovery point is multi VM
         consistent.
        :paramtype is_multi_vm_sync_point: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.is_multi_vm_sync_point = is_multi_vm_sync_point


class InMageAzureV2ReplicationDetails(
    ReplicationProviderSpecificSettings
):  # pylint: disable=too-many-instance-attributes
    """InMageAzureV2 provider specific settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar infrastructure_vm_id: The infrastructure VM Id.
    :vartype infrastructure_vm_id: str
    :ivar v_center_infrastructure_id: The vCenter infrastructure Id.
    :vartype v_center_infrastructure_id: str
    :ivar protection_stage: The protection stage.
    :vartype protection_stage: str
    :ivar vm_id: The virtual machine Id.
    :vartype vm_id: str
    :ivar vm_protection_state: The protection state for the vm.
    :vartype vm_protection_state: str
    :ivar vm_protection_state_description: The protection state description for the vm.
    :vartype vm_protection_state_description: str
    :ivar resync_progress_percentage: The resync progress percentage.
    :vartype resync_progress_percentage: int
    :ivar rpo_in_seconds: The RPO in seconds.
    :vartype rpo_in_seconds: int
    :ivar compressed_data_rate_in_mb: The compressed data change rate in MB.
    :vartype compressed_data_rate_in_mb: float
    :ivar uncompressed_data_rate_in_mb: The uncompressed data change rate in MB.
    :vartype uncompressed_data_rate_in_mb: float
    :ivar ip_address: The source IP address.
    :vartype ip_address: str
    :ivar agent_version: The agent version.
    :vartype agent_version: str
    :ivar agent_expiry_date: Agent expiry date.
    :vartype agent_expiry_date: ~datetime.datetime
    :ivar is_agent_update_required: A value indicating whether installed agent needs to be updated.
    :vartype is_agent_update_required: str
    :ivar is_reboot_after_update_required: A value indicating whether the source server requires a
     restart after update.
    :vartype is_reboot_after_update_required: str
    :ivar last_heartbeat: The last heartbeat received from the source server.
    :vartype last_heartbeat: ~datetime.datetime
    :ivar process_server_id: The process server Id.
    :vartype process_server_id: str
    :ivar process_server_name: The process server name.
    :vartype process_server_name: str
    :ivar multi_vm_group_id: The multi vm group Id.
    :vartype multi_vm_group_id: str
    :ivar multi_vm_group_name: The multi vm group name.
    :vartype multi_vm_group_name: str
    :ivar multi_vm_sync_status: A value indicating whether multi vm sync is enabled or disabled.
    :vartype multi_vm_sync_status: str
    :ivar protected_disks: The list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2ProtectedDiskDetails]
    :ivar disk_resized: A value indicating whether any disk is resized for this VM.
    :vartype disk_resized: str
    :ivar master_target_id: The master target Id.
    :vartype master_target_id: str
    :ivar source_vm_cpu_count: The CPU count of the VM on the primary side.
    :vartype source_vm_cpu_count: int
    :ivar source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
    :vartype source_vm_ram_size_in_mb: int
    :ivar os_type: The type of the OS on the VM.
    :vartype os_type: str
    :ivar vhd_name: The OS disk VHD name.
    :vartype vhd_name: str
    :ivar os_disk_id: The id of the disk containing the OS.
    :vartype os_disk_id: str
    :ivar azure_vm_disk_details: Azure VM Disk details.
    :vartype azure_vm_disk_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.AzureVmDiskDetails]
    :ivar recovery_azure_vm_name: Recovery Azure given name.
    :vartype recovery_azure_vm_name: str
    :ivar recovery_azure_vm_size: The Recovery Azure VM size.
    :vartype recovery_azure_vm_size: str
    :ivar recovery_azure_storage_account: The recovery Azure storage account.
    :vartype recovery_azure_storage_account: str
    :ivar recovery_azure_log_storage_account_id: The ARM id of the log storage account used for
     replication. This will be set to null if no log storage account was provided during enable
     protection.
    :vartype recovery_azure_log_storage_account_id: str
    :ivar vm_nics: The PE Network details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :ivar selected_recovery_azure_network_id: The selected recovery azure network Id.
    :vartype selected_recovery_azure_network_id: str
    :ivar selected_tfo_azure_network_id: The test failover virtual network.
    :vartype selected_tfo_azure_network_id: str
    :ivar selected_source_nic_id: The selected source nic Id which will be used as the primary nic
     during failover.
    :vartype selected_source_nic_id: str
    :ivar discovery_type: A value indicating the discovery type of the machine. Value can be
     vCenter or physical.
    :vartype discovery_type: str
    :ivar enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :vartype enable_rdp_on_target_option: str
    :ivar datastores: The datastores of the on-premise machine. Value can be list of strings that
     contain datastore names.
    :vartype datastores: list[str]
    :ivar target_vm_id: The ARM Id of the target Azure VM. This value will be null until the VM is
     failed over. Only after failure it will be populated with the ARM Id of the Azure VM.
    :vartype target_vm_id: str
    :ivar recovery_azure_resource_group_id: The target resource group Id.
    :vartype recovery_azure_resource_group_id: str
    :ivar recovery_availability_set_id: The recovery availability set Id.
    :vartype recovery_availability_set_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar target_proximity_placement_group_id: The target proximity placement group Id.
    :vartype target_proximity_placement_group_id: str
    :ivar use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :vartype use_managed_disks: str
    :ivar license_type: License Type of the VM to be used.
    :vartype license_type: str
    :ivar sql_server_license_type: The SQL Server license type.
    :vartype sql_server_license_type: str
    :ivar validation_errors: The validation errors of the on-premise machine Value can be list of
     validation errors.
    :vartype validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar last_rpo_calculated_time: The last RPO calculated time.
    :vartype last_rpo_calculated_time: ~datetime.datetime
    :ivar last_update_received_time: The last update time received from on-prem components.
    :vartype last_update_received_time: ~datetime.datetime
    :ivar replica_id: The replica id of the protected item.
    :vartype replica_id: str
    :ivar os_version: The OS Version of the protected item.
    :vartype os_version: str
    :ivar protected_managed_disks: The list of protected managed disks.
    :vartype protected_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2ManagedDiskDetails]
    :ivar last_recovery_point_received: The last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar firmware_type: The firmware type of this protected item.
    :vartype firmware_type: str
    :ivar azure_vm_generation: The target generation for this protected item.
    :vartype azure_vm_generation: str
    :ivar is_additional_stats_available: A value indicating whether additional IR stats are
     available or not.
    :vartype is_additional_stats_available: bool
    :ivar total_data_transferred: The total transferred data in bytes.
    :vartype total_data_transferred: int
    :ivar total_progress_health: The progress health.
    :vartype total_progress_health: str
    :ivar target_vm_tags: The target VM tags.
    :vartype target_vm_tags: dict[str, str]
    :ivar seed_managed_disk_tags: The tags for the seed managed disks.
    :vartype seed_managed_disk_tags: dict[str, str]
    :ivar target_managed_disk_tags: The tags for the target managed disks.
    :vartype target_managed_disk_tags: dict[str, str]
    :ivar target_nic_tags: The tags for the target NICs.
    :vartype target_nic_tags: dict[str, str]
    :ivar switch_provider_blocking_error_details: The switch provider blocking error information.
    :vartype switch_provider_blocking_error_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2SwitchProviderBlockingErrorDetails]
    :ivar switch_provider_details: The switch provider blocking error information.
    :vartype switch_provider_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2SwitchProviderDetails
    """

    _validation = {
        "instance_type": {"required": True},
        "last_recovery_point_received": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "infrastructure_vm_id": {"key": "infrastructureVmId", "type": "str"},
        "v_center_infrastructure_id": {"key": "vCenterInfrastructureId", "type": "str"},
        "protection_stage": {"key": "protectionStage", "type": "str"},
        "vm_id": {"key": "vmId", "type": "str"},
        "vm_protection_state": {"key": "vmProtectionState", "type": "str"},
        "vm_protection_state_description": {"key": "vmProtectionStateDescription", "type": "str"},
        "resync_progress_percentage": {"key": "resyncProgressPercentage", "type": "int"},
        "rpo_in_seconds": {"key": "rpoInSeconds", "type": "int"},
        "compressed_data_rate_in_mb": {"key": "compressedDataRateInMB", "type": "float"},
        "uncompressed_data_rate_in_mb": {"key": "uncompressedDataRateInMB", "type": "float"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "agent_version": {"key": "agentVersion", "type": "str"},
        "agent_expiry_date": {"key": "agentExpiryDate", "type": "iso-8601"},
        "is_agent_update_required": {"key": "isAgentUpdateRequired", "type": "str"},
        "is_reboot_after_update_required": {"key": "isRebootAfterUpdateRequired", "type": "str"},
        "last_heartbeat": {"key": "lastHeartbeat", "type": "iso-8601"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "process_server_name": {"key": "processServerName", "type": "str"},
        "multi_vm_group_id": {"key": "multiVmGroupId", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
        "protected_disks": {"key": "protectedDisks", "type": "[InMageAzureV2ProtectedDiskDetails]"},
        "disk_resized": {"key": "diskResized", "type": "str"},
        "master_target_id": {"key": "masterTargetId", "type": "str"},
        "source_vm_cpu_count": {"key": "sourceVmCpuCount", "type": "int"},
        "source_vm_ram_size_in_mb": {"key": "sourceVmRamSizeInMB", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "vhd_name": {"key": "vhdName", "type": "str"},
        "os_disk_id": {"key": "osDiskId", "type": "str"},
        "azure_vm_disk_details": {"key": "azureVMDiskDetails", "type": "[AzureVmDiskDetails]"},
        "recovery_azure_vm_name": {"key": "recoveryAzureVMName", "type": "str"},
        "recovery_azure_vm_size": {"key": "recoveryAzureVMSize", "type": "str"},
        "recovery_azure_storage_account": {"key": "recoveryAzureStorageAccount", "type": "str"},
        "recovery_azure_log_storage_account_id": {"key": "recoveryAzureLogStorageAccountId", "type": "str"},
        "vm_nics": {"key": "vmNics", "type": "[VMNicDetails]"},
        "selected_recovery_azure_network_id": {"key": "selectedRecoveryAzureNetworkId", "type": "str"},
        "selected_tfo_azure_network_id": {"key": "selectedTfoAzureNetworkId", "type": "str"},
        "selected_source_nic_id": {"key": "selectedSourceNicId", "type": "str"},
        "discovery_type": {"key": "discoveryType", "type": "str"},
        "enable_rdp_on_target_option": {"key": "enableRdpOnTargetOption", "type": "str"},
        "datastores": {"key": "datastores", "type": "[str]"},
        "target_vm_id": {"key": "targetVmId", "type": "str"},
        "recovery_azure_resource_group_id": {"key": "recoveryAzureResourceGroupId", "type": "str"},
        "recovery_availability_set_id": {"key": "recoveryAvailabilitySetId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "use_managed_disks": {"key": "useManagedDisks", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "sql_server_license_type": {"key": "sqlServerLicenseType", "type": "str"},
        "validation_errors": {"key": "validationErrors", "type": "[HealthError]"},
        "last_rpo_calculated_time": {"key": "lastRpoCalculatedTime", "type": "iso-8601"},
        "last_update_received_time": {"key": "lastUpdateReceivedTime", "type": "iso-8601"},
        "replica_id": {"key": "replicaId", "type": "str"},
        "os_version": {"key": "osVersion", "type": "str"},
        "protected_managed_disks": {"key": "protectedManagedDisks", "type": "[InMageAzureV2ManagedDiskDetails]"},
        "last_recovery_point_received": {"key": "lastRecoveryPointReceived", "type": "iso-8601"},
        "firmware_type": {"key": "firmwareType", "type": "str"},
        "azure_vm_generation": {"key": "azureVmGeneration", "type": "str"},
        "is_additional_stats_available": {"key": "isAdditionalStatsAvailable", "type": "bool"},
        "total_data_transferred": {"key": "totalDataTransferred", "type": "int"},
        "total_progress_health": {"key": "totalProgressHealth", "type": "str"},
        "target_vm_tags": {"key": "targetVmTags", "type": "{str}"},
        "seed_managed_disk_tags": {"key": "seedManagedDiskTags", "type": "{str}"},
        "target_managed_disk_tags": {"key": "targetManagedDiskTags", "type": "{str}"},
        "target_nic_tags": {"key": "targetNicTags", "type": "{str}"},
        "switch_provider_blocking_error_details": {
            "key": "switchProviderBlockingErrorDetails",
            "type": "[InMageAzureV2SwitchProviderBlockingErrorDetails]",
        },
        "switch_provider_details": {"key": "switchProviderDetails", "type": "InMageAzureV2SwitchProviderDetails"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        infrastructure_vm_id: Optional[str] = None,
        v_center_infrastructure_id: Optional[str] = None,
        protection_stage: Optional[str] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        resync_progress_percentage: Optional[int] = None,
        rpo_in_seconds: Optional[int] = None,
        compressed_data_rate_in_mb: Optional[float] = None,
        uncompressed_data_rate_in_mb: Optional[float] = None,
        ip_address: Optional[str] = None,
        agent_version: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        is_agent_update_required: Optional[str] = None,
        is_reboot_after_update_required: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        process_server_id: Optional[str] = None,
        process_server_name: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_sync_status: Optional[str] = None,
        protected_disks: Optional[List["_models.InMageAzureV2ProtectedDiskDetails"]] = None,
        disk_resized: Optional[str] = None,
        master_target_id: Optional[str] = None,
        source_vm_cpu_count: Optional[int] = None,
        source_vm_ram_size_in_mb: Optional[int] = None,
        os_type: Optional[str] = None,
        vhd_name: Optional[str] = None,
        os_disk_id: Optional[str] = None,
        azure_vm_disk_details: Optional[List["_models.AzureVmDiskDetails"]] = None,
        recovery_azure_vm_name: Optional[str] = None,
        recovery_azure_vm_size: Optional[str] = None,
        recovery_azure_storage_account: Optional[str] = None,
        recovery_azure_log_storage_account_id: Optional[str] = None,
        vm_nics: Optional[List["_models.VMNicDetails"]] = None,
        selected_recovery_azure_network_id: Optional[str] = None,
        selected_tfo_azure_network_id: Optional[str] = None,
        selected_source_nic_id: Optional[str] = None,
        discovery_type: Optional[str] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        datastores: Optional[List[str]] = None,
        target_vm_id: Optional[str] = None,
        recovery_azure_resource_group_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        license_type: Optional[str] = None,
        sql_server_license_type: Optional[str] = None,
        validation_errors: Optional[List["_models.HealthError"]] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        last_update_received_time: Optional[datetime.datetime] = None,
        replica_id: Optional[str] = None,
        os_version: Optional[str] = None,
        protected_managed_disks: Optional[List["_models.InMageAzureV2ManagedDiskDetails"]] = None,
        firmware_type: Optional[str] = None,
        azure_vm_generation: Optional[str] = None,
        is_additional_stats_available: Optional[bool] = None,
        total_data_transferred: Optional[int] = None,
        total_progress_health: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        switch_provider_blocking_error_details: Optional[
            List["_models.InMageAzureV2SwitchProviderBlockingErrorDetails"]
        ] = None,
        switch_provider_details: Optional["_models.InMageAzureV2SwitchProviderDetails"] = None,
        **kwargs
    ):
        """
        :keyword infrastructure_vm_id: The infrastructure VM Id.
        :paramtype infrastructure_vm_id: str
        :keyword v_center_infrastructure_id: The vCenter infrastructure Id.
        :paramtype v_center_infrastructure_id: str
        :keyword protection_stage: The protection stage.
        :paramtype protection_stage: str
        :keyword vm_id: The virtual machine Id.
        :paramtype vm_id: str
        :keyword vm_protection_state: The protection state for the vm.
        :paramtype vm_protection_state: str
        :keyword vm_protection_state_description: The protection state description for the vm.
        :paramtype vm_protection_state_description: str
        :keyword resync_progress_percentage: The resync progress percentage.
        :paramtype resync_progress_percentage: int
        :keyword rpo_in_seconds: The RPO in seconds.
        :paramtype rpo_in_seconds: int
        :keyword compressed_data_rate_in_mb: The compressed data change rate in MB.
        :paramtype compressed_data_rate_in_mb: float
        :keyword uncompressed_data_rate_in_mb: The uncompressed data change rate in MB.
        :paramtype uncompressed_data_rate_in_mb: float
        :keyword ip_address: The source IP address.
        :paramtype ip_address: str
        :keyword agent_version: The agent version.
        :paramtype agent_version: str
        :keyword agent_expiry_date: Agent expiry date.
        :paramtype agent_expiry_date: ~datetime.datetime
        :keyword is_agent_update_required: A value indicating whether installed agent needs to be
         updated.
        :paramtype is_agent_update_required: str
        :keyword is_reboot_after_update_required: A value indicating whether the source server requires
         a restart after update.
        :paramtype is_reboot_after_update_required: str
        :keyword last_heartbeat: The last heartbeat received from the source server.
        :paramtype last_heartbeat: ~datetime.datetime
        :keyword process_server_id: The process server Id.
        :paramtype process_server_id: str
        :keyword process_server_name: The process server name.
        :paramtype process_server_name: str
        :keyword multi_vm_group_id: The multi vm group Id.
        :paramtype multi_vm_group_id: str
        :keyword multi_vm_group_name: The multi vm group name.
        :paramtype multi_vm_group_name: str
        :keyword multi_vm_sync_status: A value indicating whether multi vm sync is enabled or disabled.
        :paramtype multi_vm_sync_status: str
        :keyword protected_disks: The list of protected disks.
        :paramtype protected_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2ProtectedDiskDetails]
        :keyword disk_resized: A value indicating whether any disk is resized for this VM.
        :paramtype disk_resized: str
        :keyword master_target_id: The master target Id.
        :paramtype master_target_id: str
        :keyword source_vm_cpu_count: The CPU count of the VM on the primary side.
        :paramtype source_vm_cpu_count: int
        :keyword source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
        :paramtype source_vm_ram_size_in_mb: int
        :keyword os_type: The type of the OS on the VM.
        :paramtype os_type: str
        :keyword vhd_name: The OS disk VHD name.
        :paramtype vhd_name: str
        :keyword os_disk_id: The id of the disk containing the OS.
        :paramtype os_disk_id: str
        :keyword azure_vm_disk_details: Azure VM Disk details.
        :paramtype azure_vm_disk_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.AzureVmDiskDetails]
        :keyword recovery_azure_vm_name: Recovery Azure given name.
        :paramtype recovery_azure_vm_name: str
        :keyword recovery_azure_vm_size: The Recovery Azure VM size.
        :paramtype recovery_azure_vm_size: str
        :keyword recovery_azure_storage_account: The recovery Azure storage account.
        :paramtype recovery_azure_storage_account: str
        :keyword recovery_azure_log_storage_account_id: The ARM id of the log storage account used for
         replication. This will be set to null if no log storage account was provided during enable
         protection.
        :paramtype recovery_azure_log_storage_account_id: str
        :keyword vm_nics: The PE Network details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
        :keyword selected_recovery_azure_network_id: The selected recovery azure network Id.
        :paramtype selected_recovery_azure_network_id: str
        :keyword selected_tfo_azure_network_id: The test failover virtual network.
        :paramtype selected_tfo_azure_network_id: str
        :keyword selected_source_nic_id: The selected source nic Id which will be used as the primary
         nic during failover.
        :paramtype selected_source_nic_id: str
        :keyword discovery_type: A value indicating the discovery type of the machine. Value can be
         vCenter or physical.
        :paramtype discovery_type: str
        :keyword enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
         failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
        :paramtype enable_rdp_on_target_option: str
        :keyword datastores: The datastores of the on-premise machine. Value can be list of strings
         that contain datastore names.
        :paramtype datastores: list[str]
        :keyword target_vm_id: The ARM Id of the target Azure VM. This value will be null until the VM
         is failed over. Only after failure it will be populated with the ARM Id of the Azure VM.
        :paramtype target_vm_id: str
        :keyword recovery_azure_resource_group_id: The target resource group Id.
        :paramtype recovery_azure_resource_group_id: str
        :keyword recovery_availability_set_id: The recovery availability set Id.
        :paramtype recovery_availability_set_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword target_proximity_placement_group_id: The target proximity placement group Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword use_managed_disks: A value indicating whether managed disks should be used during
         failover.
        :paramtype use_managed_disks: str
        :keyword license_type: License Type of the VM to be used.
        :paramtype license_type: str
        :keyword sql_server_license_type: The SQL Server license type.
        :paramtype sql_server_license_type: str
        :keyword validation_errors: The validation errors of the on-premise machine Value can be list
         of validation errors.
        :paramtype validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
        :keyword last_rpo_calculated_time: The last RPO calculated time.
        :paramtype last_rpo_calculated_time: ~datetime.datetime
        :keyword last_update_received_time: The last update time received from on-prem components.
        :paramtype last_update_received_time: ~datetime.datetime
        :keyword replica_id: The replica id of the protected item.
        :paramtype replica_id: str
        :keyword os_version: The OS Version of the protected item.
        :paramtype os_version: str
        :keyword protected_managed_disks: The list of protected managed disks.
        :paramtype protected_managed_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2ManagedDiskDetails]
        :keyword firmware_type: The firmware type of this protected item.
        :paramtype firmware_type: str
        :keyword azure_vm_generation: The target generation for this protected item.
        :paramtype azure_vm_generation: str
        :keyword is_additional_stats_available: A value indicating whether additional IR stats are
         available or not.
        :paramtype is_additional_stats_available: bool
        :keyword total_data_transferred: The total transferred data in bytes.
        :paramtype total_data_transferred: int
        :keyword total_progress_health: The progress health.
        :paramtype total_progress_health: str
        :keyword target_vm_tags: The target VM tags.
        :paramtype target_vm_tags: dict[str, str]
        :keyword seed_managed_disk_tags: The tags for the seed managed disks.
        :paramtype seed_managed_disk_tags: dict[str, str]
        :keyword target_managed_disk_tags: The tags for the target managed disks.
        :paramtype target_managed_disk_tags: dict[str, str]
        :keyword target_nic_tags: The tags for the target NICs.
        :paramtype target_nic_tags: dict[str, str]
        :keyword switch_provider_blocking_error_details: The switch provider blocking error
         information.
        :paramtype switch_provider_blocking_error_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2SwitchProviderBlockingErrorDetails]
        :keyword switch_provider_details: The switch provider blocking error information.
        :paramtype switch_provider_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2SwitchProviderDetails
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.infrastructure_vm_id = infrastructure_vm_id
        self.v_center_infrastructure_id = v_center_infrastructure_id
        self.protection_stage = protection_stage
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.resync_progress_percentage = resync_progress_percentage
        self.rpo_in_seconds = rpo_in_seconds
        self.compressed_data_rate_in_mb = compressed_data_rate_in_mb
        self.uncompressed_data_rate_in_mb = uncompressed_data_rate_in_mb
        self.ip_address = ip_address
        self.agent_version = agent_version
        self.agent_expiry_date = agent_expiry_date
        self.is_agent_update_required = is_agent_update_required
        self.is_reboot_after_update_required = is_reboot_after_update_required
        self.last_heartbeat = last_heartbeat
        self.process_server_id = process_server_id
        self.process_server_name = process_server_name
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_sync_status = multi_vm_sync_status
        self.protected_disks = protected_disks
        self.disk_resized = disk_resized
        self.master_target_id = master_target_id
        self.source_vm_cpu_count = source_vm_cpu_count
        self.source_vm_ram_size_in_mb = source_vm_ram_size_in_mb
        self.os_type = os_type
        self.vhd_name = vhd_name
        self.os_disk_id = os_disk_id
        self.azure_vm_disk_details = azure_vm_disk_details
        self.recovery_azure_vm_name = recovery_azure_vm_name
        self.recovery_azure_vm_size = recovery_azure_vm_size
        self.recovery_azure_storage_account = recovery_azure_storage_account
        self.recovery_azure_log_storage_account_id = recovery_azure_log_storage_account_id
        self.vm_nics = vm_nics
        self.selected_recovery_azure_network_id = selected_recovery_azure_network_id
        self.selected_tfo_azure_network_id = selected_tfo_azure_network_id
        self.selected_source_nic_id = selected_source_nic_id
        self.discovery_type = discovery_type
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.datastores = datastores
        self.target_vm_id = target_vm_id
        self.recovery_azure_resource_group_id = recovery_azure_resource_group_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.use_managed_disks = use_managed_disks
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.validation_errors = validation_errors
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.last_update_received_time = last_update_received_time
        self.replica_id = replica_id
        self.os_version = os_version
        self.protected_managed_disks = protected_managed_disks
        self.last_recovery_point_received = None
        self.firmware_type = firmware_type
        self.azure_vm_generation = azure_vm_generation
        self.is_additional_stats_available = is_additional_stats_available
        self.total_data_transferred = total_data_transferred
        self.total_progress_health = total_progress_health
        self.target_vm_tags = target_vm_tags
        self.seed_managed_disk_tags = seed_managed_disk_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags
        self.switch_provider_blocking_error_details = switch_provider_blocking_error_details
        self.switch_provider_details = switch_provider_details


class InMageAzureV2ReprotectInput(ReverseReplicationProviderSpecificInput):
    """InMageAzureV2 specific provider input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar master_target_id: The Master target Id.
    :vartype master_target_id: str
    :ivar process_server_id: The Process Server Id.
    :vartype process_server_id: str
    :ivar storage_account_id: The storage account id.
    :vartype storage_account_id: str
    :ivar run_as_account_id: The CS account Id.
    :vartype run_as_account_id: str
    :ivar policy_id: The Policy Id.
    :vartype policy_id: str
    :ivar log_storage_account_id: The storage account to be used for logging during replication.
    :vartype log_storage_account_id: str
    :ivar disks_to_include: The disks to include list.
    :vartype disks_to_include: list[str]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "master_target_id": {"key": "masterTargetId", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "disks_to_include": {"key": "disksToInclude", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        master_target_id: Optional[str] = None,
        process_server_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        disks_to_include: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword master_target_id: The Master target Id.
        :paramtype master_target_id: str
        :keyword process_server_id: The Process Server Id.
        :paramtype process_server_id: str
        :keyword storage_account_id: The storage account id.
        :paramtype storage_account_id: str
        :keyword run_as_account_id: The CS account Id.
        :paramtype run_as_account_id: str
        :keyword policy_id: The Policy Id.
        :paramtype policy_id: str
        :keyword log_storage_account_id: The storage account to be used for logging during replication.
        :paramtype log_storage_account_id: str
        :keyword disks_to_include: The disks to include list.
        :paramtype disks_to_include: list[str]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.master_target_id = master_target_id
        self.process_server_id = process_server_id
        self.storage_account_id = storage_account_id
        self.run_as_account_id = run_as_account_id
        self.policy_id = policy_id
        self.log_storage_account_id = log_storage_account_id
        self.disks_to_include = disks_to_include


class InMageAzureV2SwitchProviderBlockingErrorDetails(_serialization.Model):
    """InMageAzureV2 switch provider blocking error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar possible_causes: The possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: The recommended action.
    :vartype recommended_action: str
    :ivar error_message_parameters: The error message parameters.
    :vartype error_message_parameters: dict[str, str]
    :ivar error_tags: The error tags.
    :vartype error_tags: dict[str, str]
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_message": {"readonly": True},
        "possible_causes": {"readonly": True},
        "recommended_action": {"readonly": True},
        "error_message_parameters": {"readonly": True},
        "error_tags": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "error_message_parameters": {"key": "errorMessageParameters", "type": "{str}"},
        "error_tags": {"key": "errorTags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.possible_causes = None
        self.recommended_action = None
        self.error_message_parameters = None
        self.error_tags = None


class InMageAzureV2SwitchProviderDetails(_serialization.Model):
    """InMageAzureV2 switch provider details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_vault_id: The target vault Id.
    :vartype target_vault_id: str
    :ivar target_resource_id: The target resource Id.
    :vartype target_resource_id: str
    :ivar target_fabric_id: The target fabric Id.
    :vartype target_fabric_id: str
    :ivar target_appliance_id: The target appliance Id.
    :vartype target_appliance_id: str
    """

    _validation = {
        "target_vault_id": {"readonly": True},
        "target_resource_id": {"readonly": True},
        "target_fabric_id": {"readonly": True},
        "target_appliance_id": {"readonly": True},
    }

    _attribute_map = {
        "target_vault_id": {"key": "targetVaultId", "type": "str"},
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "target_fabric_id": {"key": "targetFabricId", "type": "str"},
        "target_appliance_id": {"key": "targetApplianceId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.target_vault_id = None
        self.target_resource_id = None
        self.target_fabric_id = None
        self.target_appliance_id = None


class SwitchProviderSpecificInput(_serialization.Model):
    """Provider specific switch provider input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InMageAzureV2SwitchProviderInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"InMageAzureV2": "InMageAzureV2SwitchProviderInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class InMageAzureV2SwitchProviderInput(SwitchProviderSpecificInput):
    """Provider specific input for InMageAzureV2 switch provider.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar target_vault_id: The target vault Id. Required.
    :vartype target_vault_id: str
    :ivar target_fabric_id: The target fabric Id. Required.
    :vartype target_fabric_id: str
    :ivar target_appliance_id: The target appliance Id. Required.
    :vartype target_appliance_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "target_vault_id": {"required": True},
        "target_fabric_id": {"required": True},
        "target_appliance_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "target_vault_id": {"key": "targetVaultID", "type": "str"},
        "target_fabric_id": {"key": "targetFabricID", "type": "str"},
        "target_appliance_id": {"key": "targetApplianceID", "type": "str"},
    }

    def __init__(self, *, target_vault_id: str, target_fabric_id: str, target_appliance_id: str, **kwargs):
        """
        :keyword target_vault_id: The target vault Id. Required.
        :paramtype target_vault_id: str
        :keyword target_fabric_id: The target fabric Id. Required.
        :paramtype target_fabric_id: str
        :keyword target_appliance_id: The target appliance Id. Required.
        :paramtype target_appliance_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.target_vault_id = target_vault_id
        self.target_fabric_id = target_fabric_id
        self.target_appliance_id = target_appliance_id


class InMageAzureV2TestFailoverInput(TestFailoverProviderSpecificInput):
    """InMageAzureV2 provider specific input for test failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(self, *, recovery_point_id: Optional[str] = None, **kwargs):
        """
        :keyword recovery_point_id: The recovery point id to be passed to test failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.recovery_point_id = recovery_point_id


class InMageAzureV2UnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """InMageAzureV2 provider specific input for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(self, *, recovery_point_id: Optional[str] = None, **kwargs):
        """
        :keyword recovery_point_id: The recovery point id to be passed to failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.recovery_point_id = recovery_point_id


class InMageAzureV2UpdateReplicationProtectedItemInput(
    UpdateReplicationProtectedItemProviderInput
):  # pylint: disable=too-many-instance-attributes
    """InMage Azure V2 input to update replication protected item.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_azure_v1_resource_group_id: The recovery Azure resource group Id for classic
     deployment.
    :vartype recovery_azure_v1_resource_group_id: str
    :ivar recovery_azure_v2_resource_group_id: The recovery Azure resource group Id for resource
     manager deployment.
    :vartype recovery_azure_v2_resource_group_id: str
    :ivar use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :vartype use_managed_disks: str
    :ivar target_proximity_placement_group_id: The target proximity placement group Id.
    :vartype target_proximity_placement_group_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar target_vm_tags: The target VM tags.
    :vartype target_vm_tags: dict[str, str]
    :ivar target_managed_disk_tags: The tags for the target managed disks.
    :vartype target_managed_disk_tags: dict[str, str]
    :ivar target_nic_tags: The tags for the target NICs.
    :vartype target_nic_tags: dict[str, str]
    :ivar sql_server_license_type: The SQL Server license type. Known values are: "NotSpecified",
     "NoLicenseType", "PAYG", and "AHUB".
    :vartype sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :ivar vm_disks: The list of disk update properties.
    :vartype vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.UpdateDiskInput]
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_azure_v1_resource_group_id": {"key": "recoveryAzureV1ResourceGroupId", "type": "str"},
        "recovery_azure_v2_resource_group_id": {"key": "recoveryAzureV2ResourceGroupId", "type": "str"},
        "use_managed_disks": {"key": "useManagedDisks", "type": "str"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "target_vm_tags": {"key": "targetVmTags", "type": "{str}"},
        "target_managed_disk_tags": {"key": "targetManagedDiskTags", "type": "{str}"},
        "target_nic_tags": {"key": "targetNicTags", "type": "{str}"},
        "sql_server_license_type": {"key": "sqlServerLicenseType", "type": "str"},
        "vm_disks": {"key": "vmDisks", "type": "[UpdateDiskInput]"},
    }

    def __init__(
        self,
        *,
        recovery_azure_v1_resource_group_id: Optional[str] = None,
        recovery_azure_v2_resource_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        sql_server_license_type: Optional[Union[str, "_models.SqlServerLicenseType"]] = None,
        vm_disks: Optional[List["_models.UpdateDiskInput"]] = None,
        **kwargs
    ):
        """
        :keyword recovery_azure_v1_resource_group_id: The recovery Azure resource group Id for classic
         deployment.
        :paramtype recovery_azure_v1_resource_group_id: str
        :keyword recovery_azure_v2_resource_group_id: The recovery Azure resource group Id for resource
         manager deployment.
        :paramtype recovery_azure_v2_resource_group_id: str
        :keyword use_managed_disks: A value indicating whether managed disks should be used during
         failover.
        :paramtype use_managed_disks: str
        :keyword target_proximity_placement_group_id: The target proximity placement group Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword target_vm_tags: The target VM tags.
        :paramtype target_vm_tags: dict[str, str]
        :keyword target_managed_disk_tags: The tags for the target managed disks.
        :paramtype target_managed_disk_tags: dict[str, str]
        :keyword target_nic_tags: The tags for the target NICs.
        :paramtype target_nic_tags: dict[str, str]
        :keyword sql_server_license_type: The SQL Server license type. Known values are:
         "NotSpecified", "NoLicenseType", "PAYG", and "AHUB".
        :paramtype sql_server_license_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
        :keyword vm_disks: The list of disk update properties.
        :paramtype vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.UpdateDiskInput]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.recovery_azure_v1_resource_group_id = recovery_azure_v1_resource_group_id
        self.recovery_azure_v2_resource_group_id = recovery_azure_v2_resource_group_id
        self.use_managed_disks = use_managed_disks
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_availability_zone = target_availability_zone
        self.target_vm_tags = target_vm_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags
        self.sql_server_license_type = sql_server_license_type
        self.vm_disks = vm_disks


class InMageBasePolicyDetails(PolicyProviderSpecificDetails):
    """Base class for the policies of providers using InMage replication.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :vartype recovery_point_threshold_in_minutes: int
    :ivar recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :vartype recovery_point_history: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :vartype app_consistent_frequency_in_minutes: int
    :ivar multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
    :vartype multi_vm_sync_status: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_threshold_in_minutes": {"key": "recoveryPointThresholdInMinutes", "type": "int"},
        "recovery_point_history": {"key": "recoveryPointHistory", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        multi_vm_sync_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        :paramtype recovery_point_threshold_in_minutes: int
        :keyword recovery_point_history: The duration in minutes until which the recovery points need
         to be stored.
        :paramtype recovery_point_history: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
        :paramtype multi_vm_sync_status: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageBasePolicyDetails"
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMageDisableProtectionProviderSpecificInput(DisableProtectionProviderSpecificInput):
    """InMage disable protection provider specific input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar replica_vm_deletion_status: A value indicating whether the replica VM should be destroyed
     or retained. Values from Delete and Retain.
    :vartype replica_vm_deletion_status: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "replica_vm_deletion_status": {"key": "replicaVmDeletionStatus", "type": "str"},
    }

    def __init__(self, *, replica_vm_deletion_status: Optional[str] = None, **kwargs):
        """
        :keyword replica_vm_deletion_status: A value indicating whether the replica VM should be
         destroyed or retained. Values from Delete and Retain.
        :paramtype replica_vm_deletion_status: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.replica_vm_deletion_status = replica_vm_deletion_status


class InMageDiskDetails(_serialization.Model):
    """VMware/Physical specific Disk Details.

    :ivar disk_id: The disk Id.
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar disk_size_in_mb: The disk size in MB.
    :vartype disk_size_in_mb: str
    :ivar disk_type: Whether disk is system disk or data disk.
    :vartype disk_type: str
    :ivar disk_configuration: Whether disk is dynamic disk or basic disk.
    :vartype disk_configuration: str
    :ivar volume_list: Volumes of the disk.
    :vartype volume_list: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskVolumeDetails]
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_name": {"key": "diskName", "type": "str"},
        "disk_size_in_mb": {"key": "diskSizeInMB", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "disk_configuration": {"key": "diskConfiguration", "type": "str"},
        "volume_list": {"key": "volumeList", "type": "[DiskVolumeDetails]"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        disk_name: Optional[str] = None,
        disk_size_in_mb: Optional[str] = None,
        disk_type: Optional[str] = None,
        disk_configuration: Optional[str] = None,
        volume_list: Optional[List["_models.DiskVolumeDetails"]] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk Id.
        :paramtype disk_id: str
        :keyword disk_name: The disk name.
        :paramtype disk_name: str
        :keyword disk_size_in_mb: The disk size in MB.
        :paramtype disk_size_in_mb: str
        :keyword disk_type: Whether disk is system disk or data disk.
        :paramtype disk_type: str
        :keyword disk_configuration: Whether disk is dynamic disk or basic disk.
        :paramtype disk_configuration: str
        :keyword volume_list: Volumes of the disk.
        :paramtype volume_list: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskVolumeDetails]
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.disk_name = disk_name
        self.disk_size_in_mb = disk_size_in_mb
        self.disk_type = disk_type
        self.disk_configuration = disk_configuration
        self.volume_list = volume_list


class InMageDiskExclusionInput(_serialization.Model):
    """DiskExclusionInput when doing enable protection of virtual machine in InMage provider.

    :ivar volume_options: The volume label based option for disk exclusion.
    :vartype volume_options:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageVolumeExclusionOptions]
    :ivar disk_signature_options: The guest disk signature based option for disk exclusion.
    :vartype disk_signature_options:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskSignatureExclusionOptions]
    """

    _attribute_map = {
        "volume_options": {"key": "volumeOptions", "type": "[InMageVolumeExclusionOptions]"},
        "disk_signature_options": {"key": "diskSignatureOptions", "type": "[InMageDiskSignatureExclusionOptions]"},
    }

    def __init__(
        self,
        *,
        volume_options: Optional[List["_models.InMageVolumeExclusionOptions"]] = None,
        disk_signature_options: Optional[List["_models.InMageDiskSignatureExclusionOptions"]] = None,
        **kwargs
    ):
        """
        :keyword volume_options: The volume label based option for disk exclusion.
        :paramtype volume_options:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageVolumeExclusionOptions]
        :keyword disk_signature_options: The guest disk signature based option for disk exclusion.
        :paramtype disk_signature_options:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskSignatureExclusionOptions]
        """
        super().__init__(**kwargs)
        self.volume_options = volume_options
        self.disk_signature_options = disk_signature_options


class InMageDiskSignatureExclusionOptions(_serialization.Model):
    """Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider.

    :ivar disk_signature: The guest signature of disk to be excluded from replication.
    :vartype disk_signature: str
    """

    _attribute_map = {
        "disk_signature": {"key": "diskSignature", "type": "str"},
    }

    def __init__(self, *, disk_signature: Optional[str] = None, **kwargs):
        """
        :keyword disk_signature: The guest signature of disk to be excluded from replication.
        :paramtype disk_signature: str
        """
        super().__init__(**kwargs)
        self.disk_signature = disk_signature


class InMageEnableProtectionInput(
    EnableProtectionProviderSpecificInput
):  # pylint: disable=too-many-instance-attributes
    """VMware Azure specific enable protection input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar vm_friendly_name: The VM Name.
    :vartype vm_friendly_name: str
    :ivar master_target_id: The Master Target Id. Required.
    :vartype master_target_id: str
    :ivar process_server_id: The Process Server Id. Required.
    :vartype process_server_id: str
    :ivar retention_drive: The retention drive to use on the MT. Required.
    :vartype retention_drive: str
    :ivar run_as_account_id: The CS account Id.
    :vartype run_as_account_id: str
    :ivar multi_vm_group_id: The multi VM group Id. Required.
    :vartype multi_vm_group_id: str
    :ivar multi_vm_group_name: The multi VM group name. Required.
    :vartype multi_vm_group_name: str
    :ivar datastore_name: The target datastore name.
    :vartype datastore_name: str
    :ivar disk_exclusion_input: The enable disk exclusion input.
    :vartype disk_exclusion_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskExclusionInput
    :ivar disks_to_include: The disks to include list.
    :vartype disks_to_include: list[str]
    """

    _validation = {
        "instance_type": {"required": True},
        "master_target_id": {"required": True},
        "process_server_id": {"required": True},
        "retention_drive": {"required": True},
        "multi_vm_group_id": {"required": True},
        "multi_vm_group_name": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "vm_friendly_name": {"key": "vmFriendlyName", "type": "str"},
        "master_target_id": {"key": "masterTargetId", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "retention_drive": {"key": "retentionDrive", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "multi_vm_group_id": {"key": "multiVmGroupId", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "datastore_name": {"key": "datastoreName", "type": "str"},
        "disk_exclusion_input": {"key": "diskExclusionInput", "type": "InMageDiskExclusionInput"},
        "disks_to_include": {"key": "disksToInclude", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        master_target_id: str,
        process_server_id: str,
        retention_drive: str,
        multi_vm_group_id: str,
        multi_vm_group_name: str,
        vm_friendly_name: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        datastore_name: Optional[str] = None,
        disk_exclusion_input: Optional["_models.InMageDiskExclusionInput"] = None,
        disks_to_include: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword vm_friendly_name: The VM Name.
        :paramtype vm_friendly_name: str
        :keyword master_target_id: The Master Target Id. Required.
        :paramtype master_target_id: str
        :keyword process_server_id: The Process Server Id. Required.
        :paramtype process_server_id: str
        :keyword retention_drive: The retention drive to use on the MT. Required.
        :paramtype retention_drive: str
        :keyword run_as_account_id: The CS account Id.
        :paramtype run_as_account_id: str
        :keyword multi_vm_group_id: The multi VM group Id. Required.
        :paramtype multi_vm_group_id: str
        :keyword multi_vm_group_name: The multi VM group name. Required.
        :paramtype multi_vm_group_name: str
        :keyword datastore_name: The target datastore name.
        :paramtype datastore_name: str
        :keyword disk_exclusion_input: The enable disk exclusion input.
        :paramtype disk_exclusion_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskExclusionInput
        :keyword disks_to_include: The disks to include list.
        :paramtype disks_to_include: list[str]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.vm_friendly_name = vm_friendly_name
        self.master_target_id = master_target_id
        self.process_server_id = process_server_id
        self.retention_drive = retention_drive
        self.run_as_account_id = run_as_account_id
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.datastore_name = datastore_name
        self.disk_exclusion_input = disk_exclusion_input
        self.disks_to_include = disks_to_include


class InMageFabricSwitchProviderBlockingErrorDetails(_serialization.Model):
    """InMageFabric switch provider blocking error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar possible_causes: The possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: The recommended action.
    :vartype recommended_action: str
    :ivar error_message_parameters: The error message parameters.
    :vartype error_message_parameters: dict[str, str]
    :ivar error_tags: The error tags.
    :vartype error_tags: dict[str, str]
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_message": {"readonly": True},
        "possible_causes": {"readonly": True},
        "recommended_action": {"readonly": True},
        "error_message_parameters": {"readonly": True},
        "error_tags": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "error_message_parameters": {"key": "errorMessageParameters", "type": "{str}"},
        "error_tags": {"key": "errorTags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.possible_causes = None
        self.recommended_action = None
        self.error_message_parameters = None
        self.error_tags = None


class InMagePolicyDetails(PolicyProviderSpecificDetails):
    """InMage specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :vartype recovery_point_threshold_in_minutes: int
    :ivar recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :vartype recovery_point_history: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :vartype app_consistent_frequency_in_minutes: int
    :ivar multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
    :vartype multi_vm_sync_status: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_threshold_in_minutes": {"key": "recoveryPointThresholdInMinutes", "type": "int"},
        "recovery_point_history": {"key": "recoveryPointHistory", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        multi_vm_sync_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        :paramtype recovery_point_threshold_in_minutes: int
        :keyword recovery_point_history: The duration in minutes until which the recovery points need
         to be stored.
        :paramtype recovery_point_history: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
        :paramtype multi_vm_sync_status: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMagePolicyInput(PolicyProviderSpecificInput):
    """VMWare Azure specific protection profile Input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :vartype recovery_point_threshold_in_minutes: int
    :ivar recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :vartype recovery_point_history: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :vartype app_consistent_frequency_in_minutes: int
    :ivar multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled. Value
     should be 'Enabled' or 'Disabled'. Required. Known values are: "Enable" and "Disable".
    :vartype multi_vm_sync_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
    """

    _validation = {
        "instance_type": {"required": True},
        "multi_vm_sync_status": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_threshold_in_minutes": {"key": "recoveryPointThresholdInMinutes", "type": "int"},
        "recovery_point_history": {"key": "recoveryPointHistory", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        multi_vm_sync_status: Union[str, "_models.SetMultiVmSyncStatus"],
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
        :paramtype recovery_point_threshold_in_minutes: int
        :keyword recovery_point_history: The duration in minutes until which the recovery points need
         to be stored.
        :paramtype recovery_point_history: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in
         minutes).
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
         Value should be 'Enabled' or 'Disabled'. Required. Known values are: "Enable" and "Disable".
        :paramtype multi_vm_sync_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMageProtectedDiskDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """InMage protected disk details.

    :ivar disk_id: The disk id.
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar protection_stage: The protection stage.
    :vartype protection_stage: str
    :ivar health_error_code: The health error code for the disk.
    :vartype health_error_code: str
    :ivar rpo_in_seconds: The RPO in seconds.
    :vartype rpo_in_seconds: int
    :ivar resync_required: A value indicating whether resync is required for this disk.
    :vartype resync_required: str
    :ivar resync_progress_percentage: The resync progress percentage.
    :vartype resync_progress_percentage: int
    :ivar resync_duration_in_seconds: The resync duration in seconds.
    :vartype resync_duration_in_seconds: int
    :ivar disk_capacity_in_bytes: The disk capacity in bytes.
    :vartype disk_capacity_in_bytes: int
    :ivar file_system_capacity_in_bytes: The file system capacity in bytes.
    :vartype file_system_capacity_in_bytes: int
    :ivar source_data_in_mb: The source data transit in MB.
    :vartype source_data_in_mb: float
    :ivar ps_data_in_mb: The PS data transit in MB.
    :vartype ps_data_in_mb: float
    :ivar target_data_in_mb: The target data transit in MB.
    :vartype target_data_in_mb: float
    :ivar disk_resized: A value indicating whether disk is resized.
    :vartype disk_resized: str
    :ivar last_rpo_calculated_time: The last RPO calculated time.
    :vartype last_rpo_calculated_time: ~datetime.datetime
    :ivar resync_processed_bytes: The resync processed bytes.
    :vartype resync_processed_bytes: int
    :ivar resync_total_transferred_bytes: The resync total transferred bytes.
    :vartype resync_total_transferred_bytes: int
    :ivar resync_last15_minutes_transferred_bytes: The resync last 15 minutes transferred bytes.
    :vartype resync_last15_minutes_transferred_bytes: int
    :ivar resync_last_data_transfer_time_utc: The last data transfer time in UTC.
    :vartype resync_last_data_transfer_time_utc: ~datetime.datetime
    :ivar resync_start_time: The resync start time.
    :vartype resync_start_time: ~datetime.datetime
    :ivar progress_health: The Progress Health.
    :vartype progress_health: str
    :ivar progress_status: The Progress Status.
    :vartype progress_status: str
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_name": {"key": "diskName", "type": "str"},
        "protection_stage": {"key": "protectionStage", "type": "str"},
        "health_error_code": {"key": "healthErrorCode", "type": "str"},
        "rpo_in_seconds": {"key": "rpoInSeconds", "type": "int"},
        "resync_required": {"key": "resyncRequired", "type": "str"},
        "resync_progress_percentage": {"key": "resyncProgressPercentage", "type": "int"},
        "resync_duration_in_seconds": {"key": "resyncDurationInSeconds", "type": "int"},
        "disk_capacity_in_bytes": {"key": "diskCapacityInBytes", "type": "int"},
        "file_system_capacity_in_bytes": {"key": "fileSystemCapacityInBytes", "type": "int"},
        "source_data_in_mb": {"key": "sourceDataInMB", "type": "float"},
        "ps_data_in_mb": {"key": "psDataInMB", "type": "float"},
        "target_data_in_mb": {"key": "targetDataInMB", "type": "float"},
        "disk_resized": {"key": "diskResized", "type": "str"},
        "last_rpo_calculated_time": {"key": "lastRpoCalculatedTime", "type": "iso-8601"},
        "resync_processed_bytes": {"key": "resyncProcessedBytes", "type": "int"},
        "resync_total_transferred_bytes": {"key": "resyncTotalTransferredBytes", "type": "int"},
        "resync_last15_minutes_transferred_bytes": {"key": "resyncLast15MinutesTransferredBytes", "type": "int"},
        "resync_last_data_transfer_time_utc": {"key": "resyncLastDataTransferTimeUTC", "type": "iso-8601"},
        "resync_start_time": {"key": "resyncStartTime", "type": "iso-8601"},
        "progress_health": {"key": "progressHealth", "type": "str"},
        "progress_status": {"key": "progressStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        disk_name: Optional[str] = None,
        protection_stage: Optional[str] = None,
        health_error_code: Optional[str] = None,
        rpo_in_seconds: Optional[int] = None,
        resync_required: Optional[str] = None,
        resync_progress_percentage: Optional[int] = None,
        resync_duration_in_seconds: Optional[int] = None,
        disk_capacity_in_bytes: Optional[int] = None,
        file_system_capacity_in_bytes: Optional[int] = None,
        source_data_in_mb: Optional[float] = None,
        ps_data_in_mb: Optional[float] = None,
        target_data_in_mb: Optional[float] = None,
        disk_resized: Optional[str] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        resync_processed_bytes: Optional[int] = None,
        resync_total_transferred_bytes: Optional[int] = None,
        resync_last15_minutes_transferred_bytes: Optional[int] = None,
        resync_last_data_transfer_time_utc: Optional[datetime.datetime] = None,
        resync_start_time: Optional[datetime.datetime] = None,
        progress_health: Optional[str] = None,
        progress_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk id.
        :paramtype disk_id: str
        :keyword disk_name: The disk name.
        :paramtype disk_name: str
        :keyword protection_stage: The protection stage.
        :paramtype protection_stage: str
        :keyword health_error_code: The health error code for the disk.
        :paramtype health_error_code: str
        :keyword rpo_in_seconds: The RPO in seconds.
        :paramtype rpo_in_seconds: int
        :keyword resync_required: A value indicating whether resync is required for this disk.
        :paramtype resync_required: str
        :keyword resync_progress_percentage: The resync progress percentage.
        :paramtype resync_progress_percentage: int
        :keyword resync_duration_in_seconds: The resync duration in seconds.
        :paramtype resync_duration_in_seconds: int
        :keyword disk_capacity_in_bytes: The disk capacity in bytes.
        :paramtype disk_capacity_in_bytes: int
        :keyword file_system_capacity_in_bytes: The file system capacity in bytes.
        :paramtype file_system_capacity_in_bytes: int
        :keyword source_data_in_mb: The source data transit in MB.
        :paramtype source_data_in_mb: float
        :keyword ps_data_in_mb: The PS data transit in MB.
        :paramtype ps_data_in_mb: float
        :keyword target_data_in_mb: The target data transit in MB.
        :paramtype target_data_in_mb: float
        :keyword disk_resized: A value indicating whether disk is resized.
        :paramtype disk_resized: str
        :keyword last_rpo_calculated_time: The last RPO calculated time.
        :paramtype last_rpo_calculated_time: ~datetime.datetime
        :keyword resync_processed_bytes: The resync processed bytes.
        :paramtype resync_processed_bytes: int
        :keyword resync_total_transferred_bytes: The resync total transferred bytes.
        :paramtype resync_total_transferred_bytes: int
        :keyword resync_last15_minutes_transferred_bytes: The resync last 15 minutes transferred bytes.
        :paramtype resync_last15_minutes_transferred_bytes: int
        :keyword resync_last_data_transfer_time_utc: The last data transfer time in UTC.
        :paramtype resync_last_data_transfer_time_utc: ~datetime.datetime
        :keyword resync_start_time: The resync start time.
        :paramtype resync_start_time: ~datetime.datetime
        :keyword progress_health: The Progress Health.
        :paramtype progress_health: str
        :keyword progress_status: The Progress Status.
        :paramtype progress_status: str
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.disk_name = disk_name
        self.protection_stage = protection_stage
        self.health_error_code = health_error_code
        self.rpo_in_seconds = rpo_in_seconds
        self.resync_required = resync_required
        self.resync_progress_percentage = resync_progress_percentage
        self.resync_duration_in_seconds = resync_duration_in_seconds
        self.disk_capacity_in_bytes = disk_capacity_in_bytes
        self.file_system_capacity_in_bytes = file_system_capacity_in_bytes
        self.source_data_in_mb = source_data_in_mb
        self.ps_data_in_mb = ps_data_in_mb
        self.target_data_in_mb = target_data_in_mb
        self.disk_resized = disk_resized
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.resync_processed_bytes = resync_processed_bytes
        self.resync_total_transferred_bytes = resync_total_transferred_bytes
        self.resync_last15_minutes_transferred_bytes = resync_last15_minutes_transferred_bytes
        self.resync_last_data_transfer_time_utc = resync_last_data_transfer_time_utc
        self.resync_start_time = resync_start_time
        self.progress_health = progress_health
        self.progress_status = progress_status


class InMageRcmAgentUpgradeBlockingErrorDetails(_serialization.Model):
    """InMageRcm source agent upgrade blocking error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar possible_causes: The possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: The recommended action.
    :vartype recommended_action: str
    :ivar error_message_parameters: The error message parameters.
    :vartype error_message_parameters: dict[str, str]
    :ivar error_tags: The error tags.
    :vartype error_tags: dict[str, str]
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_message": {"readonly": True},
        "possible_causes": {"readonly": True},
        "recommended_action": {"readonly": True},
        "error_message_parameters": {"readonly": True},
        "error_tags": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "error_message_parameters": {"key": "errorMessageParameters", "type": "{str}"},
        "error_tags": {"key": "errorTags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.possible_causes = None
        self.recommended_action = None
        self.error_message_parameters = None
        self.error_tags = None


class InMageRcmApplianceDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """InMageRcm appliance details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The appliance Id.
    :vartype id: str
    :ivar name: The appliance name.
    :vartype name: str
    :ivar fabric_arm_id: The fabric ARM Id.
    :vartype fabric_arm_id: str
    :ivar process_server: The process server.
    :vartype process_server: ~azure.mgmt.recoveryservicessiterecovery.models.ProcessServerDetails
    :ivar rcm_proxy: The of RCM proxy.
    :vartype rcm_proxy: ~azure.mgmt.recoveryservicessiterecovery.models.RcmProxyDetails
    :ivar push_installer: The push installer.
    :vartype push_installer: ~azure.mgmt.recoveryservicessiterecovery.models.PushInstallerDetails
    :ivar replication_agent: The replication agent.
    :vartype replication_agent:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationAgentDetails
    :ivar reprotect_agent: The reprotect agent.
    :vartype reprotect_agent: ~azure.mgmt.recoveryservicessiterecovery.models.ReprotectAgentDetails
    :ivar mars_agent: The Mars agent.
    :vartype mars_agent: ~azure.mgmt.recoveryservicessiterecovery.models.MarsAgentDetails
    :ivar dra: The DRA.
    :vartype dra: ~azure.mgmt.recoveryservicessiterecovery.models.DraDetails
    :ivar switch_provider_blocking_error_details: The switch provider blocking error information.
    :vartype switch_provider_blocking_error_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFabricSwitchProviderBlockingErrorDetails]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "fabric_arm_id": {"readonly": True},
        "process_server": {"readonly": True},
        "rcm_proxy": {"readonly": True},
        "push_installer": {"readonly": True},
        "replication_agent": {"readonly": True},
        "reprotect_agent": {"readonly": True},
        "mars_agent": {"readonly": True},
        "dra": {"readonly": True},
        "switch_provider_blocking_error_details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "fabric_arm_id": {"key": "fabricArmId", "type": "str"},
        "process_server": {"key": "processServer", "type": "ProcessServerDetails"},
        "rcm_proxy": {"key": "rcmProxy", "type": "RcmProxyDetails"},
        "push_installer": {"key": "pushInstaller", "type": "PushInstallerDetails"},
        "replication_agent": {"key": "replicationAgent", "type": "ReplicationAgentDetails"},
        "reprotect_agent": {"key": "reprotectAgent", "type": "ReprotectAgentDetails"},
        "mars_agent": {"key": "marsAgent", "type": "MarsAgentDetails"},
        "dra": {"key": "dra", "type": "DraDetails"},
        "switch_provider_blocking_error_details": {
            "key": "switchProviderBlockingErrorDetails",
            "type": "[InMageRcmFabricSwitchProviderBlockingErrorDetails]",
        },
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.fabric_arm_id = None
        self.process_server = None
        self.rcm_proxy = None
        self.push_installer = None
        self.replication_agent = None
        self.reprotect_agent = None
        self.mars_agent = None
        self.dra = None
        self.switch_provider_blocking_error_details = None


class InMageRcmApplianceSpecificDetails(ApplianceSpecificDetails):
    """InMageRcm appliance specific details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar appliances: The list of appliances.
    :vartype appliances:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmApplianceDetails]
    """

    _validation = {
        "instance_type": {"required": True},
        "appliances": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "appliances": {"key": "appliances", "type": "[InMageRcmApplianceDetails]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.appliances = None


class InMageRcmApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to InMageRcm provider.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_id: The recovery point Id. Required.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "recovery_point_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(self, *, recovery_point_id: str, **kwargs):
        """
        :keyword recovery_point_id: The recovery point Id. Required.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.recovery_point_id = recovery_point_id


class InMageRcmDiscoveredProtectedVmDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """InMageRcm discovered protected VM details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar v_center_id: The VCenter Id.
    :vartype v_center_id: str
    :ivar v_center_fqdn: The VCenter fqdn.
    :vartype v_center_fqdn: str
    :ivar datastores: The list of datastores.
    :vartype datastores: list[str]
    :ivar ip_addresses: The list of IP addresses.
    :vartype ip_addresses: list[str]
    :ivar vmware_tools_status: The VMware tools status.
    :vartype vmware_tools_status: str
    :ivar power_status: The VM power status.
    :vartype power_status: str
    :ivar vm_fqdn: The VM fqdn.
    :vartype vm_fqdn: str
    :ivar os_name: The VM's OS name.
    :vartype os_name: str
    :ivar created_timestamp: The SDS created timestamp.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: The SDS updated timestamp.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar is_deleted: A value indicating whether the VM is deleted.
    :vartype is_deleted: bool
    :ivar last_discovery_time_in_utc: The last time when SDS information discovered in SRS.
    :vartype last_discovery_time_in_utc: ~datetime.datetime
    """

    _validation = {
        "v_center_id": {"readonly": True},
        "v_center_fqdn": {"readonly": True},
        "datastores": {"readonly": True},
        "ip_addresses": {"readonly": True},
        "vmware_tools_status": {"readonly": True},
        "power_status": {"readonly": True},
        "vm_fqdn": {"readonly": True},
        "os_name": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "is_deleted": {"readonly": True},
        "last_discovery_time_in_utc": {"readonly": True},
    }

    _attribute_map = {
        "v_center_id": {"key": "vCenterId", "type": "str"},
        "v_center_fqdn": {"key": "vCenterFqdn", "type": "str"},
        "datastores": {"key": "datastores", "type": "[str]"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "vmware_tools_status": {"key": "vmwareToolsStatus", "type": "str"},
        "power_status": {"key": "powerStatus", "type": "str"},
        "vm_fqdn": {"key": "vmFqdn", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "is_deleted": {"key": "isDeleted", "type": "bool"},
        "last_discovery_time_in_utc": {"key": "lastDiscoveryTimeInUtc", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.v_center_id = None
        self.v_center_fqdn = None
        self.datastores = None
        self.ip_addresses = None
        self.vmware_tools_status = None
        self.power_status = None
        self.vm_fqdn = None
        self.os_name = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.is_deleted = None
        self.last_discovery_time_in_utc = None


class InMageRcmDiskInput(_serialization.Model):
    """InMageRcm disk input.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_id: The disk Id. Required.
    :vartype disk_id: str
    :ivar log_storage_account_id: The log storage account ARM Id. Required.
    :vartype log_storage_account_id: str
    :ivar disk_type: The disk type. Required. Known values are: "Standard_LRS", "Premium_LRS", and
     "StandardSSD_LRS".
    :vartype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :vartype disk_encryption_set_id: str
    """

    _validation = {
        "disk_id": {"required": True},
        "log_storage_account_id": {"required": True},
        "disk_type": {"required": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        log_storage_account_id: str,
        disk_type: Union[str, "_models.DiskAccountType"],
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_id: The disk Id. Required.
        :paramtype disk_id: str
        :keyword log_storage_account_id: The log storage account ARM Id. Required.
        :paramtype log_storage_account_id: str
        :keyword disk_type: The disk type. Required. Known values are: "Standard_LRS", "Premium_LRS",
         and "StandardSSD_LRS".
        :paramtype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
        :keyword disk_encryption_set_id: The DiskEncryptionSet ARM Id.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.log_storage_account_id = log_storage_account_id
        self.disk_type = disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class InMageRcmDisksDefaultInput(_serialization.Model):
    """InMageRcm disk input.

    All required parameters must be populated in order to send to Azure.

    :ivar log_storage_account_id: The log storage account ARM Id. Required.
    :vartype log_storage_account_id: str
    :ivar disk_type: The disk type. Required. Known values are: "Standard_LRS", "Premium_LRS", and
     "StandardSSD_LRS".
    :vartype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :vartype disk_encryption_set_id: str
    """

    _validation = {
        "log_storage_account_id": {"required": True},
        "disk_type": {"required": True},
    }

    _attribute_map = {
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        log_storage_account_id: str,
        disk_type: Union[str, "_models.DiskAccountType"],
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword log_storage_account_id: The log storage account ARM Id. Required.
        :paramtype log_storage_account_id: str
        :keyword disk_type: The disk type. Required. Known values are: "Standard_LRS", "Premium_LRS",
         and "StandardSSD_LRS".
        :paramtype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
        :keyword disk_encryption_set_id: The DiskEncryptionSet ARM Id.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.log_storage_account_id = log_storage_account_id
        self.disk_type = disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class InMageRcmEnableProtectionInput(
    EnableProtectionProviderSpecificInput
):  # pylint: disable=too-many-instance-attributes
    """InMageRcm specific enable protection input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar fabric_discovery_machine_id: The ARM Id of discovered machine. Required.
    :vartype fabric_discovery_machine_id: str
    :ivar disks_to_include: The disks to include list.
    :vartype disks_to_include:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDiskInput]
    :ivar disks_default: The default disk input.
    :vartype disks_default:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDisksDefaultInput
    :ivar target_resource_group_id: The target resource group ARM Id. Required.
    :vartype target_resource_group_id: str
    :ivar target_network_id: The selected target network ARM Id.
    :vartype target_network_id: str
    :ivar test_network_id: The selected test network ARM Id.
    :vartype test_network_id: str
    :ivar target_subnet_name: The selected target subnet name.
    :vartype target_subnet_name: str
    :ivar test_subnet_name: The selected test subnet name.
    :vartype test_subnet_name: str
    :ivar target_vm_name: The target VM name.
    :vartype target_vm_name: str
    :ivar target_vm_size: The target VM size.
    :vartype target_vm_size: str
    :ivar license_type: The license type. Known values are: "NotSpecified", "NoLicenseType", and
     "WindowsServer".
    :vartype license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :ivar target_availability_set_id: The target availability set ARM Id.
    :vartype target_availability_set_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar target_proximity_placement_group_id: The target proximity placement group Id.
    :vartype target_proximity_placement_group_id: str
    :ivar target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :vartype target_boot_diagnostics_storage_account_id: str
    :ivar run_as_account_id: The run-as account Id.
    :vartype run_as_account_id: str
    :ivar process_server_id: The process server Id. Required.
    :vartype process_server_id: str
    :ivar multi_vm_group_name: The multi VM group name.
    :vartype multi_vm_group_name: str
    """

    _validation = {
        "instance_type": {"required": True},
        "fabric_discovery_machine_id": {"required": True},
        "target_resource_group_id": {"required": True},
        "process_server_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "fabric_discovery_machine_id": {"key": "fabricDiscoveryMachineId", "type": "str"},
        "disks_to_include": {"key": "disksToInclude", "type": "[InMageRcmDiskInput]"},
        "disks_default": {"key": "disksDefault", "type": "InMageRcmDisksDefaultInput"},
        "target_resource_group_id": {"key": "targetResourceGroupId", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "target_subnet_name": {"key": "targetSubnetName", "type": "str"},
        "test_subnet_name": {"key": "testSubnetName", "type": "str"},
        "target_vm_name": {"key": "targetVmName", "type": "str"},
        "target_vm_size": {"key": "targetVmSize", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "target_availability_set_id": {"key": "targetAvailabilitySetId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "target_boot_diagnostics_storage_account_id": {"key": "targetBootDiagnosticsStorageAccountId", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
    }

    def __init__(
        self,
        *,
        fabric_discovery_machine_id: str,
        target_resource_group_id: str,
        process_server_id: str,
        disks_to_include: Optional[List["_models.InMageRcmDiskInput"]] = None,
        disks_default: Optional["_models.InMageRcmDisksDefaultInput"] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        target_subnet_name: Optional[str] = None,
        test_subnet_name: Optional[str] = None,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword fabric_discovery_machine_id: The ARM Id of discovered machine. Required.
        :paramtype fabric_discovery_machine_id: str
        :keyword disks_to_include: The disks to include list.
        :paramtype disks_to_include:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDiskInput]
        :keyword disks_default: The default disk input.
        :paramtype disks_default:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDisksDefaultInput
        :keyword target_resource_group_id: The target resource group ARM Id. Required.
        :paramtype target_resource_group_id: str
        :keyword target_network_id: The selected target network ARM Id.
        :paramtype target_network_id: str
        :keyword test_network_id: The selected test network ARM Id.
        :paramtype test_network_id: str
        :keyword target_subnet_name: The selected target subnet name.
        :paramtype target_subnet_name: str
        :keyword test_subnet_name: The selected test subnet name.
        :paramtype test_subnet_name: str
        :keyword target_vm_name: The target VM name.
        :paramtype target_vm_name: str
        :keyword target_vm_size: The target VM size.
        :paramtype target_vm_size: str
        :keyword license_type: The license type. Known values are: "NotSpecified", "NoLicenseType", and
         "WindowsServer".
        :paramtype license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
        :keyword target_availability_set_id: The target availability set ARM Id.
        :paramtype target_availability_set_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword target_proximity_placement_group_id: The target proximity placement group Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword target_boot_diagnostics_storage_account_id: The target boot diagnostics storage
         account ARM Id.
        :paramtype target_boot_diagnostics_storage_account_id: str
        :keyword run_as_account_id: The run-as account Id.
        :paramtype run_as_account_id: str
        :keyword process_server_id: The process server Id. Required.
        :paramtype process_server_id: str
        :keyword multi_vm_group_name: The multi VM group name.
        :paramtype multi_vm_group_name: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.fabric_discovery_machine_id = fabric_discovery_machine_id
        self.disks_to_include = disks_to_include
        self.disks_default = disks_default
        self.target_resource_group_id = target_resource_group_id
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.target_subnet_name = target_subnet_name
        self.test_subnet_name = test_subnet_name
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.license_type = license_type
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.run_as_account_id = run_as_account_id
        self.process_server_id = process_server_id
        self.multi_vm_group_name = multi_vm_group_name


class InMageRcmEventDetails(EventProviderSpecificDetails):
    """Event details for InMageRcm provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar protected_item_name: The protected item name.
    :vartype protected_item_name: str
    :ivar vm_name: The protected item name.
    :vartype vm_name: str
    :ivar latest_agent_version: The latest agent version.
    :vartype latest_agent_version: str
    :ivar job_id: The job Id.
    :vartype job_id: str
    :ivar fabric_name: The fabric name.
    :vartype fabric_name: str
    :ivar appliance_name: The appliance name.
    :vartype appliance_name: str
    :ivar server_type: The server type.
    :vartype server_type: str
    :ivar component_display_name: The component display name.
    :vartype component_display_name: str
    """

    _validation = {
        "instance_type": {"required": True},
        "protected_item_name": {"readonly": True},
        "vm_name": {"readonly": True},
        "latest_agent_version": {"readonly": True},
        "job_id": {"readonly": True},
        "fabric_name": {"readonly": True},
        "appliance_name": {"readonly": True},
        "server_type": {"readonly": True},
        "component_display_name": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "protected_item_name": {"key": "protectedItemName", "type": "str"},
        "vm_name": {"key": "vmName", "type": "str"},
        "latest_agent_version": {"key": "latestAgentVersion", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "appliance_name": {"key": "applianceName", "type": "str"},
        "server_type": {"key": "serverType", "type": "str"},
        "component_display_name": {"key": "componentDisplayName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.protected_item_name = None
        self.vm_name = None
        self.latest_agent_version = None
        self.job_id = None
        self.fabric_name = None
        self.appliance_name = None
        self.server_type = None
        self.component_display_name = None


class InMageRcmFabricCreationInput(FabricSpecificCreationInput):
    """InMageRcm fabric provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Required.
    :vartype instance_type: str
    :ivar vmware_site_id: The ARM Id of the VMware site. Required.
    :vartype vmware_site_id: str
    :ivar physical_site_id: The ARM Id of the physical site. Required.
    :vartype physical_site_id: str
    :ivar source_agent_identity: The identity provider input for source agent authentication.
     Required.
    :vartype source_agent_identity:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
    """

    _validation = {
        "instance_type": {"required": True},
        "vmware_site_id": {"required": True},
        "physical_site_id": {"required": True},
        "source_agent_identity": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "vmware_site_id": {"key": "vmwareSiteId", "type": "str"},
        "physical_site_id": {"key": "physicalSiteId", "type": "str"},
        "source_agent_identity": {"key": "sourceAgentIdentity", "type": "IdentityProviderInput"},
    }

    def __init__(
        self,
        *,
        vmware_site_id: str,
        physical_site_id: str,
        source_agent_identity: "_models.IdentityProviderInput",
        **kwargs
    ):
        """
        :keyword vmware_site_id: The ARM Id of the VMware site. Required.
        :paramtype vmware_site_id: str
        :keyword physical_site_id: The ARM Id of the physical site. Required.
        :paramtype physical_site_id: str
        :keyword source_agent_identity: The identity provider input for source agent authentication.
         Required.
        :paramtype source_agent_identity:
         ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.vmware_site_id = vmware_site_id
        self.physical_site_id = physical_site_id
        self.source_agent_identity = source_agent_identity


class InMageRcmFabricSpecificDetails(FabricSpecificDetails):  # pylint: disable=too-many-instance-attributes
    """InMageRcm fabric specific details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar vmware_site_id: The ARM Id of the VMware site.
    :vartype vmware_site_id: str
    :ivar physical_site_id: The ARM Id of the physical site.
    :vartype physical_site_id: str
    :ivar service_endpoint: The service endpoint.
    :vartype service_endpoint: str
    :ivar service_resource_id: The service resource Id.
    :vartype service_resource_id: str
    :ivar service_container_id: The service container Id.
    :vartype service_container_id: str
    :ivar data_plane_uri: The data plane Uri.
    :vartype data_plane_uri: str
    :ivar control_plane_uri: The control plane Uri.
    :vartype control_plane_uri: str
    :ivar source_agent_identity_details: The source agent identity details.
    :vartype source_agent_identity_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderDetails
    :ivar process_servers: The list of process servers.
    :vartype process_servers:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ProcessServerDetails]
    :ivar rcm_proxies: The list of RCM proxies.
    :vartype rcm_proxies: list[~azure.mgmt.recoveryservicessiterecovery.models.RcmProxyDetails]
    :ivar push_installers: The list of push installers.
    :vartype push_installers:
     list[~azure.mgmt.recoveryservicessiterecovery.models.PushInstallerDetails]
    :ivar replication_agents: The list of replication agents.
    :vartype replication_agents:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationAgentDetails]
    :ivar reprotect_agents: The list of reprotect agents.
    :vartype reprotect_agents:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ReprotectAgentDetails]
    :ivar mars_agents: The list of Mars agents.
    :vartype mars_agents: list[~azure.mgmt.recoveryservicessiterecovery.models.MarsAgentDetails]
    :ivar dras: The list of DRAs.
    :vartype dras: list[~azure.mgmt.recoveryservicessiterecovery.models.DraDetails]
    :ivar agent_details: The list of agent details.
    :vartype agent_details: list[~azure.mgmt.recoveryservicessiterecovery.models.AgentDetails]
    """

    _validation = {
        "instance_type": {"required": True},
        "vmware_site_id": {"readonly": True},
        "physical_site_id": {"readonly": True},
        "service_endpoint": {"readonly": True},
        "service_resource_id": {"readonly": True},
        "service_container_id": {"readonly": True},
        "data_plane_uri": {"readonly": True},
        "control_plane_uri": {"readonly": True},
        "process_servers": {"readonly": True},
        "rcm_proxies": {"readonly": True},
        "push_installers": {"readonly": True},
        "replication_agents": {"readonly": True},
        "reprotect_agents": {"readonly": True},
        "mars_agents": {"readonly": True},
        "dras": {"readonly": True},
        "agent_details": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "vmware_site_id": {"key": "vmwareSiteId", "type": "str"},
        "physical_site_id": {"key": "physicalSiteId", "type": "str"},
        "service_endpoint": {"key": "serviceEndpoint", "type": "str"},
        "service_resource_id": {"key": "serviceResourceId", "type": "str"},
        "service_container_id": {"key": "serviceContainerId", "type": "str"},
        "data_plane_uri": {"key": "dataPlaneUri", "type": "str"},
        "control_plane_uri": {"key": "controlPlaneUri", "type": "str"},
        "source_agent_identity_details": {"key": "sourceAgentIdentityDetails", "type": "IdentityProviderDetails"},
        "process_servers": {"key": "processServers", "type": "[ProcessServerDetails]"},
        "rcm_proxies": {"key": "rcmProxies", "type": "[RcmProxyDetails]"},
        "push_installers": {"key": "pushInstallers", "type": "[PushInstallerDetails]"},
        "replication_agents": {"key": "replicationAgents", "type": "[ReplicationAgentDetails]"},
        "reprotect_agents": {"key": "reprotectAgents", "type": "[ReprotectAgentDetails]"},
        "mars_agents": {"key": "marsAgents", "type": "[MarsAgentDetails]"},
        "dras": {"key": "dras", "type": "[DraDetails]"},
        "agent_details": {"key": "agentDetails", "type": "[AgentDetails]"},
    }

    def __init__(self, *, source_agent_identity_details: Optional["_models.IdentityProviderDetails"] = None, **kwargs):
        """
        :keyword source_agent_identity_details: The source agent identity details.
        :paramtype source_agent_identity_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderDetails
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.vmware_site_id = None
        self.physical_site_id = None
        self.service_endpoint = None
        self.service_resource_id = None
        self.service_container_id = None
        self.data_plane_uri = None
        self.control_plane_uri = None
        self.source_agent_identity_details = source_agent_identity_details
        self.process_servers = None
        self.rcm_proxies = None
        self.push_installers = None
        self.replication_agents = None
        self.reprotect_agents = None
        self.mars_agents = None
        self.dras = None
        self.agent_details = None


class InMageRcmFabricSwitchProviderBlockingErrorDetails(_serialization.Model):
    """InMageRcmFabric switch provider blocking error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar possible_causes: The possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: The recommended action.
    :vartype recommended_action: str
    :ivar error_message_parameters: The error message parameters.
    :vartype error_message_parameters: dict[str, str]
    :ivar error_tags: The error tags.
    :vartype error_tags: dict[str, str]
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_message": {"readonly": True},
        "possible_causes": {"readonly": True},
        "recommended_action": {"readonly": True},
        "error_message_parameters": {"readonly": True},
        "error_tags": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "error_message_parameters": {"key": "errorMessageParameters", "type": "{str}"},
        "error_tags": {"key": "errorTags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.possible_causes = None
        self.recommended_action = None
        self.error_message_parameters = None
        self.error_tags = None


class InMageRcmFailbackDiscoveredProtectedVmDetails(
    _serialization.Model
):  # pylint: disable=too-many-instance-attributes
    """InMageRcmFailback discovered VM details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar v_center_id: The VCenter Id.
    :vartype v_center_id: str
    :ivar v_center_fqdn: The VCenter fqdn.
    :vartype v_center_fqdn: str
    :ivar datastores: The list of datastores.
    :vartype datastores: list[str]
    :ivar ip_addresses: The list of IP addresses.
    :vartype ip_addresses: list[str]
    :ivar vmware_tools_status: The VMware tools status.
    :vartype vmware_tools_status: str
    :ivar power_status: The VM power status.
    :vartype power_status: str
    :ivar vm_fqdn: The VM fqdn.
    :vartype vm_fqdn: str
    :ivar os_name: The VM's OS name.
    :vartype os_name: str
    :ivar created_timestamp: The SDS created timestamp.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: The SDS updated timestamp.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar is_deleted: A value indicating whether the VM is deleted.
    :vartype is_deleted: bool
    :ivar last_discovery_time_in_utc: The last time when SDS information discovered in SRS.
    :vartype last_discovery_time_in_utc: ~datetime.datetime
    """

    _validation = {
        "v_center_id": {"readonly": True},
        "v_center_fqdn": {"readonly": True},
        "datastores": {"readonly": True},
        "ip_addresses": {"readonly": True},
        "vmware_tools_status": {"readonly": True},
        "power_status": {"readonly": True},
        "vm_fqdn": {"readonly": True},
        "os_name": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "is_deleted": {"readonly": True},
        "last_discovery_time_in_utc": {"readonly": True},
    }

    _attribute_map = {
        "v_center_id": {"key": "vCenterId", "type": "str"},
        "v_center_fqdn": {"key": "vCenterFqdn", "type": "str"},
        "datastores": {"key": "datastores", "type": "[str]"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "vmware_tools_status": {"key": "vmwareToolsStatus", "type": "str"},
        "power_status": {"key": "powerStatus", "type": "str"},
        "vm_fqdn": {"key": "vmFqdn", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "is_deleted": {"key": "isDeleted", "type": "bool"},
        "last_discovery_time_in_utc": {"key": "lastDiscoveryTimeInUtc", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.v_center_id = None
        self.v_center_fqdn = None
        self.datastores = None
        self.ip_addresses = None
        self.vmware_tools_status = None
        self.power_status = None
        self.vm_fqdn = None
        self.os_name = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.is_deleted = None
        self.last_discovery_time_in_utc = None


class InMageRcmFailbackEventDetails(EventProviderSpecificDetails):
    """Event details for InMageRcmFailback provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar protected_item_name: The protected item name.
    :vartype protected_item_name: str
    :ivar vm_name: The protected item name.
    :vartype vm_name: str
    :ivar appliance_name: The appliance name.
    :vartype appliance_name: str
    :ivar server_type: The server type.
    :vartype server_type: str
    :ivar component_display_name: The component display name.
    :vartype component_display_name: str
    """

    _validation = {
        "instance_type": {"required": True},
        "protected_item_name": {"readonly": True},
        "vm_name": {"readonly": True},
        "appliance_name": {"readonly": True},
        "server_type": {"readonly": True},
        "component_display_name": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "protected_item_name": {"key": "protectedItemName", "type": "str"},
        "vm_name": {"key": "vmName", "type": "str"},
        "appliance_name": {"key": "applianceName", "type": "str"},
        "server_type": {"key": "serverType", "type": "str"},
        "component_display_name": {"key": "componentDisplayName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcmFailback"
        self.protected_item_name = None
        self.vm_name = None
        self.appliance_name = None
        self.server_type = None
        self.component_display_name = None


class InMageRcmFailbackMobilityAgentDetails(_serialization.Model):
    """InMageRcmFailback mobility agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The agent version.
    :vartype version: str
    :ivar latest_version: The latest agent version available.
    :vartype latest_version: str
    :ivar driver_version: The driver version.
    :vartype driver_version: str
    :ivar latest_upgradable_version_without_reboot: The latest upgradeable version available
     without reboot.
    :vartype latest_upgradable_version_without_reboot: str
    :ivar agent_version_expiry_date: The agent version expiry date.
    :vartype agent_version_expiry_date: ~datetime.datetime
    :ivar driver_version_expiry_date: The driver version expiry date.
    :vartype driver_version_expiry_date: ~datetime.datetime
    :ivar last_heartbeat_utc: The time of the last heartbeat received from the agent.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar reasons_blocking_upgrade: The whether update is possible or not.
    :vartype reasons_blocking_upgrade: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentUpgradeBlockedReason]
    :ivar is_upgradeable: A value indicating whether agent is upgradeable or not.
    :vartype is_upgradeable: str
    """

    _validation = {
        "version": {"readonly": True},
        "latest_version": {"readonly": True},
        "driver_version": {"readonly": True},
        "latest_upgradable_version_without_reboot": {"readonly": True},
        "agent_version_expiry_date": {"readonly": True},
        "driver_version_expiry_date": {"readonly": True},
        "last_heartbeat_utc": {"readonly": True},
        "reasons_blocking_upgrade": {"readonly": True},
        "is_upgradeable": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "driver_version": {"key": "driverVersion", "type": "str"},
        "latest_upgradable_version_without_reboot": {"key": "latestUpgradableVersionWithoutReboot", "type": "str"},
        "agent_version_expiry_date": {"key": "agentVersionExpiryDate", "type": "iso-8601"},
        "driver_version_expiry_date": {"key": "driverVersionExpiryDate", "type": "iso-8601"},
        "last_heartbeat_utc": {"key": "lastHeartbeatUtc", "type": "iso-8601"},
        "reasons_blocking_upgrade": {"key": "reasonsBlockingUpgrade", "type": "[str]"},
        "is_upgradeable": {"key": "isUpgradeable", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.latest_version = None
        self.driver_version = None
        self.latest_upgradable_version_without_reboot = None
        self.agent_version_expiry_date = None
        self.driver_version_expiry_date = None
        self.last_heartbeat_utc = None
        self.reasons_blocking_upgrade = None
        self.is_upgradeable = None


class InMageRcmFailbackNicDetails(_serialization.Model):
    """InMageRcmFailback NIC details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mac_address: The mac address.
    :vartype mac_address: str
    :ivar network_name: The network name.
    :vartype network_name: str
    :ivar adapter_type: The adapter type.
    :vartype adapter_type: str
    :ivar source_ip_address: The IP address.
    :vartype source_ip_address: str
    """

    _validation = {
        "mac_address": {"readonly": True},
        "network_name": {"readonly": True},
        "adapter_type": {"readonly": True},
        "source_ip_address": {"readonly": True},
    }

    _attribute_map = {
        "mac_address": {"key": "macAddress", "type": "str"},
        "network_name": {"key": "networkName", "type": "str"},
        "adapter_type": {"key": "adapterType", "type": "str"},
        "source_ip_address": {"key": "sourceIpAddress", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.mac_address = None
        self.network_name = None
        self.adapter_type = None
        self.source_ip_address = None


class InMageRcmFailbackPlannedFailoverProviderInput(PlannedFailoverProviderSpecificFailoverInput):
    """Provider specific input for InMageRcmFailback failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_type: The recovery point type. Required. Known values are:
     "ApplicationConsistent" and "CrashConsistent".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackRecoveryPointType
    """

    _validation = {
        "instance_type": {"required": True},
        "recovery_point_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
    }

    def __init__(self, *, recovery_point_type: Union[str, "_models.InMageRcmFailbackRecoveryPointType"], **kwargs):
        """
        :keyword recovery_point_type: The recovery point type. Required. Known values are:
         "ApplicationConsistent" and "CrashConsistent".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackRecoveryPointType
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcmFailback"
        self.recovery_point_type = recovery_point_type


class InMageRcmFailbackPolicyCreationInput(PolicyProviderSpecificInput):
    """InMageRcmFailback policy creation input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :vartype app_consistent_frequency_in_minutes: int
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
         minutes).
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in
         minutes).
        :paramtype app_consistent_frequency_in_minutes: int
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcmFailback"
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes


class InMageRcmFailbackPolicyDetails(PolicyProviderSpecificDetails):
    """InMageRcm failback specific policy details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :vartype app_consistent_frequency_in_minutes: int
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :vartype crash_consistent_frequency_in_minutes: int
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
         minutes.
        :paramtype crash_consistent_frequency_in_minutes: int
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcmFailback"
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes


class InMageRcmFailbackProtectedDiskDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """InMageRcmFailback protected disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_id: The disk Id (reported by source agent).
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar is_os_disk: A value indicating whether the disk is the OS disk.
    :vartype is_os_disk: str
    :ivar capacity_in_bytes: The disk capacity in bytes.
    :vartype capacity_in_bytes: int
    :ivar disk_uuid: The disk Uuid (reported by vCenter).
    :vartype disk_uuid: str
    :ivar data_pending_in_log_data_store_in_mb: The data pending in log data store in MB.
    :vartype data_pending_in_log_data_store_in_mb: float
    :ivar data_pending_at_source_agent_in_mb: The data pending at source agent in MB.
    :vartype data_pending_at_source_agent_in_mb: float
    :ivar is_initial_replication_complete: A value indicating whether initial replication is
     complete or not.
    :vartype is_initial_replication_complete: str
    :ivar ir_details: The initial replication details.
    :vartype ir_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackSyncDetails
    :ivar resync_details: The resync details.
    :vartype resync_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackSyncDetails
    :ivar last_sync_time: The last sync time.
    :vartype last_sync_time: ~datetime.datetime
    """

    _validation = {
        "disk_id": {"readonly": True},
        "disk_name": {"readonly": True},
        "is_os_disk": {"readonly": True},
        "capacity_in_bytes": {"readonly": True},
        "disk_uuid": {"readonly": True},
        "data_pending_in_log_data_store_in_mb": {"readonly": True},
        "data_pending_at_source_agent_in_mb": {"readonly": True},
        "is_initial_replication_complete": {"readonly": True},
        "last_sync_time": {"readonly": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_name": {"key": "diskName", "type": "str"},
        "is_os_disk": {"key": "isOSDisk", "type": "str"},
        "capacity_in_bytes": {"key": "capacityInBytes", "type": "int"},
        "disk_uuid": {"key": "diskUuid", "type": "str"},
        "data_pending_in_log_data_store_in_mb": {"key": "dataPendingInLogDataStoreInMB", "type": "float"},
        "data_pending_at_source_agent_in_mb": {"key": "dataPendingAtSourceAgentInMB", "type": "float"},
        "is_initial_replication_complete": {"key": "isInitialReplicationComplete", "type": "str"},
        "ir_details": {"key": "irDetails", "type": "InMageRcmFailbackSyncDetails"},
        "resync_details": {"key": "resyncDetails", "type": "InMageRcmFailbackSyncDetails"},
        "last_sync_time": {"key": "lastSyncTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        ir_details: Optional["_models.InMageRcmFailbackSyncDetails"] = None,
        resync_details: Optional["_models.InMageRcmFailbackSyncDetails"] = None,
        **kwargs
    ):
        """
        :keyword ir_details: The initial replication details.
        :paramtype ir_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackSyncDetails
        :keyword resync_details: The resync details.
        :paramtype resync_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackSyncDetails
        """
        super().__init__(**kwargs)
        self.disk_id = None
        self.disk_name = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.disk_uuid = None
        self.data_pending_in_log_data_store_in_mb = None
        self.data_pending_at_source_agent_in_mb = None
        self.is_initial_replication_complete = None
        self.ir_details = ir_details
        self.resync_details = resync_details
        self.last_sync_time = None


class InMageRcmFailbackReplicationDetails(
    ReplicationProviderSpecificSettings
):  # pylint: disable=too-many-instance-attributes
    """InMageRcmFailback provider specific details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar internal_identifier: The virtual machine internal identifier.
    :vartype internal_identifier: str
    :ivar azure_virtual_machine_id: The ARM Id of the azure VM.
    :vartype azure_virtual_machine_id: str
    :ivar multi_vm_group_name: The multi VM group name.
    :vartype multi_vm_group_name: str
    :ivar reprotect_agent_id: The reprotect agent Id.
    :vartype reprotect_agent_id: str
    :ivar reprotect_agent_name: The reprotect agent name.
    :vartype reprotect_agent_name: str
    :ivar os_type: The type of the OS on the VM.
    :vartype os_type: str
    :ivar log_storage_account_id: The log storage account ARM Id.
    :vartype log_storage_account_id: str
    :ivar targetv_center_id: The target vCenter Id.
    :vartype targetv_center_id: str
    :ivar target_data_store_name: The target datastore name.
    :vartype target_data_store_name: str
    :ivar target_vm_name: The target VM name.
    :vartype target_vm_name: str
    :ivar initial_replication_progress_percentage: The initial replication progress percentage.
    :vartype initial_replication_progress_percentage: int
    :ivar initial_replication_processed_bytes: The initial replication processed bytes. This
     includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
    :vartype initial_replication_processed_bytes: int
    :ivar initial_replication_transferred_bytes: The initial replication transferred bytes from
     source VM to target for all selected disks on source VM.
    :vartype initial_replication_transferred_bytes: int
    :ivar initial_replication_progress_health: The initial replication progress health. Known
     values are: "None", "InProgress", "SlowProgress", and "NoProgress".
    :vartype initial_replication_progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmReplicationProgressHealth
    :ivar resync_progress_percentage: The resync progress percentage.
    :vartype resync_progress_percentage: int
    :ivar resync_processed_bytes: The resync processed bytes. This includes sum of total bytes
     transferred and matched bytes on all selected disks in source VM.
    :vartype resync_processed_bytes: int
    :ivar resync_transferred_bytes: The resync transferred bytes from source VM to target for all
     selected disks on source VM.
    :vartype resync_transferred_bytes: int
    :ivar resync_progress_health: The resync progress health. Known values are: "None",
     "InProgress", "SlowProgress", and "NoProgress".
    :vartype resync_progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmReplicationProgressHealth
    :ivar resync_required: A value indicating whether resync is required.
    :vartype resync_required: str
    :ivar resync_state: The resync state. Known values are: "None", "PreparedForResynchronization",
     and "StartedResynchronization".
    :vartype resync_state: str or ~azure.mgmt.recoveryservicessiterecovery.models.ResyncState
    :ivar protected_disks: The list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackProtectedDiskDetails]
    :ivar mobility_agent_details: The mobility agent information.
    :vartype mobility_agent_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackMobilityAgentDetails
    :ivar vm_nics: The network details.
    :vartype vm_nics:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackNicDetails]
    :ivar last_planned_failover_start_time: The last planned failover start time.
    :vartype last_planned_failover_start_time: ~datetime.datetime
    :ivar last_planned_failover_status: The last planned failover status. Known values are:
     "Succeeded", "Failed", "Cancelled", and "Unknown".
    :vartype last_planned_failover_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverStatus
    :ivar discovered_vm_details: The discovered VM information.
    :vartype discovered_vm_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackDiscoveredProtectedVmDetails
    :ivar last_used_policy_id: The policy Id used by the forward replication.
    :vartype last_used_policy_id: str
    :ivar last_used_policy_friendly_name: The policy friendly name used by the forward replication.
    :vartype last_used_policy_friendly_name: str
    :ivar is_agent_registration_successful_after_failover: A value indicating whether agent
     registration was successful after failover.
    :vartype is_agent_registration_successful_after_failover: bool
    """

    _validation = {
        "instance_type": {"required": True},
        "internal_identifier": {"readonly": True},
        "azure_virtual_machine_id": {"readonly": True},
        "multi_vm_group_name": {"readonly": True},
        "reprotect_agent_id": {"readonly": True},
        "reprotect_agent_name": {"readonly": True},
        "os_type": {"readonly": True},
        "log_storage_account_id": {"readonly": True},
        "targetv_center_id": {"readonly": True},
        "target_data_store_name": {"readonly": True},
        "target_vm_name": {"readonly": True},
        "initial_replication_progress_percentage": {"readonly": True},
        "initial_replication_processed_bytes": {"readonly": True},
        "initial_replication_transferred_bytes": {"readonly": True},
        "initial_replication_progress_health": {"readonly": True},
        "resync_progress_percentage": {"readonly": True},
        "resync_processed_bytes": {"readonly": True},
        "resync_transferred_bytes": {"readonly": True},
        "resync_progress_health": {"readonly": True},
        "resync_required": {"readonly": True},
        "resync_state": {"readonly": True},
        "last_planned_failover_start_time": {"readonly": True},
        "last_planned_failover_status": {"readonly": True},
        "last_used_policy_id": {"readonly": True},
        "last_used_policy_friendly_name": {"readonly": True},
        "is_agent_registration_successful_after_failover": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "internal_identifier": {"key": "internalIdentifier", "type": "str"},
        "azure_virtual_machine_id": {"key": "azureVirtualMachineId", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "reprotect_agent_id": {"key": "reprotectAgentId", "type": "str"},
        "reprotect_agent_name": {"key": "reprotectAgentName", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "targetv_center_id": {"key": "targetvCenterId", "type": "str"},
        "target_data_store_name": {"key": "targetDataStoreName", "type": "str"},
        "target_vm_name": {"key": "targetVmName", "type": "str"},
        "initial_replication_progress_percentage": {"key": "initialReplicationProgressPercentage", "type": "int"},
        "initial_replication_processed_bytes": {"key": "initialReplicationProcessedBytes", "type": "int"},
        "initial_replication_transferred_bytes": {"key": "initialReplicationTransferredBytes", "type": "int"},
        "initial_replication_progress_health": {"key": "initialReplicationProgressHealth", "type": "str"},
        "resync_progress_percentage": {"key": "resyncProgressPercentage", "type": "int"},
        "resync_processed_bytes": {"key": "resyncProcessedBytes", "type": "int"},
        "resync_transferred_bytes": {"key": "resyncTransferredBytes", "type": "int"},
        "resync_progress_health": {"key": "resyncProgressHealth", "type": "str"},
        "resync_required": {"key": "resyncRequired", "type": "str"},
        "resync_state": {"key": "resyncState", "type": "str"},
        "protected_disks": {"key": "protectedDisks", "type": "[InMageRcmFailbackProtectedDiskDetails]"},
        "mobility_agent_details": {"key": "mobilityAgentDetails", "type": "InMageRcmFailbackMobilityAgentDetails"},
        "vm_nics": {"key": "vmNics", "type": "[InMageRcmFailbackNicDetails]"},
        "last_planned_failover_start_time": {"key": "lastPlannedFailoverStartTime", "type": "iso-8601"},
        "last_planned_failover_status": {"key": "lastPlannedFailoverStatus", "type": "str"},
        "discovered_vm_details": {
            "key": "discoveredVmDetails",
            "type": "InMageRcmFailbackDiscoveredProtectedVmDetails",
        },
        "last_used_policy_id": {"key": "lastUsedPolicyId", "type": "str"},
        "last_used_policy_friendly_name": {"key": "lastUsedPolicyFriendlyName", "type": "str"},
        "is_agent_registration_successful_after_failover": {
            "key": "isAgentRegistrationSuccessfulAfterFailover",
            "type": "bool",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        protected_disks: Optional[List["_models.InMageRcmFailbackProtectedDiskDetails"]] = None,
        mobility_agent_details: Optional["_models.InMageRcmFailbackMobilityAgentDetails"] = None,
        vm_nics: Optional[List["_models.InMageRcmFailbackNicDetails"]] = None,
        discovered_vm_details: Optional["_models.InMageRcmFailbackDiscoveredProtectedVmDetails"] = None,
        **kwargs
    ):
        """
        :keyword protected_disks: The list of protected disks.
        :paramtype protected_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackProtectedDiskDetails]
        :keyword mobility_agent_details: The mobility agent information.
        :paramtype mobility_agent_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackMobilityAgentDetails
        :keyword vm_nics: The network details.
        :paramtype vm_nics:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackNicDetails]
        :keyword discovered_vm_details: The discovered VM information.
        :paramtype discovered_vm_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackDiscoveredProtectedVmDetails
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcmFailback"
        self.internal_identifier = None
        self.azure_virtual_machine_id = None
        self.multi_vm_group_name = None
        self.reprotect_agent_id = None
        self.reprotect_agent_name = None
        self.os_type = None
        self.log_storage_account_id = None
        self.targetv_center_id = None
        self.target_data_store_name = None
        self.target_vm_name = None
        self.initial_replication_progress_percentage = None
        self.initial_replication_processed_bytes = None
        self.initial_replication_transferred_bytes = None
        self.initial_replication_progress_health = None
        self.resync_progress_percentage = None
        self.resync_processed_bytes = None
        self.resync_transferred_bytes = None
        self.resync_progress_health = None
        self.resync_required = None
        self.resync_state = None
        self.protected_disks = protected_disks
        self.mobility_agent_details = mobility_agent_details
        self.vm_nics = vm_nics
        self.last_planned_failover_start_time = None
        self.last_planned_failover_status = None
        self.discovered_vm_details = discovered_vm_details
        self.last_used_policy_id = None
        self.last_used_policy_friendly_name = None
        self.is_agent_registration_successful_after_failover = None


class InMageRcmFailbackReprotectInput(ReverseReplicationProviderSpecificInput):
    """InMageRcmFailback specific provider input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar process_server_id: The process server Id. Required.
    :vartype process_server_id: str
    :ivar run_as_account_id: The run as account Id.
    :vartype run_as_account_id: str
    :ivar policy_id: The Policy Id. Required.
    :vartype policy_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "process_server_id": {"required": True},
        "policy_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
    }

    def __init__(self, *, process_server_id: str, policy_id: str, run_as_account_id: Optional[str] = None, **kwargs):
        """
        :keyword process_server_id: The process server Id. Required.
        :paramtype process_server_id: str
        :keyword run_as_account_id: The run as account Id.
        :paramtype run_as_account_id: str
        :keyword policy_id: The Policy Id. Required.
        :paramtype policy_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcmFailback"
        self.process_server_id = process_server_id
        self.run_as_account_id = run_as_account_id
        self.policy_id = policy_id


class InMageRcmFailbackSyncDetails(_serialization.Model):
    """InMageRcmFailback disk level sync details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar progress_health: The progress health. Known values are: "None", "InProgress",
     "SlowProgress", "NoProgress", and "Queued".
    :vartype progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskReplicationProgressHealth
    :ivar transferred_bytes: The transferred bytes from source VM to azure for the disk.
    :vartype transferred_bytes: int
    :ivar last15_minutes_transferred_bytes: The bytes transferred in last 15 minutes from source VM
     to target.
    :vartype last15_minutes_transferred_bytes: int
    :ivar last_data_transfer_time_utc: The time of the last data transfer from source VM to target.
    :vartype last_data_transfer_time_utc: str
    :ivar processed_bytes: The total processed bytes. This includes bytes that are transferred from
     source VM to target and matched bytes.
    :vartype processed_bytes: int
    :ivar start_time: The start time.
    :vartype start_time: str
    :ivar last_refresh_time: The last refresh time.
    :vartype last_refresh_time: str
    :ivar progress_percentage: Progress in percentage. Progress percentage is calculated based on
     processed bytes.
    :vartype progress_percentage: int
    """

    _validation = {
        "progress_health": {"readonly": True},
        "transferred_bytes": {"readonly": True},
        "last15_minutes_transferred_bytes": {"readonly": True},
        "last_data_transfer_time_utc": {"readonly": True},
        "processed_bytes": {"readonly": True},
        "start_time": {"readonly": True},
        "last_refresh_time": {"readonly": True},
        "progress_percentage": {"readonly": True},
    }

    _attribute_map = {
        "progress_health": {"key": "progressHealth", "type": "str"},
        "transferred_bytes": {"key": "transferredBytes", "type": "int"},
        "last15_minutes_transferred_bytes": {"key": "last15MinutesTransferredBytes", "type": "int"},
        "last_data_transfer_time_utc": {"key": "lastDataTransferTimeUtc", "type": "str"},
        "processed_bytes": {"key": "processedBytes", "type": "int"},
        "start_time": {"key": "startTime", "type": "str"},
        "last_refresh_time": {"key": "lastRefreshTime", "type": "str"},
        "progress_percentage": {"key": "progressPercentage", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.progress_health = None
        self.transferred_bytes = None
        self.last15_minutes_transferred_bytes = None
        self.last_data_transfer_time_utc = None
        self.processed_bytes = None
        self.start_time = None
        self.last_refresh_time = None
        self.progress_percentage = None


class InMageRcmLastAgentUpgradeErrorDetails(_serialization.Model):
    """InMageRcm last source agent upgrade error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar possible_causes: The possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: The recommended action.
    :vartype recommended_action: str
    :ivar error_message_parameters: The error message parameters.
    :vartype error_message_parameters: dict[str, str]
    :ivar error_tags: The error tags.
    :vartype error_tags: dict[str, str]
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_message": {"readonly": True},
        "possible_causes": {"readonly": True},
        "recommended_action": {"readonly": True},
        "error_message_parameters": {"readonly": True},
        "error_tags": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "error_message_parameters": {"key": "errorMessageParameters", "type": "{str}"},
        "error_tags": {"key": "errorTags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.possible_causes = None
        self.recommended_action = None
        self.error_message_parameters = None
        self.error_tags = None


class InMageRcmMobilityAgentDetails(_serialization.Model):
    """InMageRcm mobility agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The agent version.
    :vartype version: str
    :ivar latest_version: The latest agent version available.
    :vartype latest_version: str
    :ivar latest_agent_release_date: The latest agent version release date.
    :vartype latest_agent_release_date: str
    :ivar driver_version: The driver version.
    :vartype driver_version: str
    :ivar latest_upgradable_version_without_reboot: The latest upgradeable version available
     without reboot.
    :vartype latest_upgradable_version_without_reboot: str
    :ivar agent_version_expiry_date: The agent version expiry date.
    :vartype agent_version_expiry_date: ~datetime.datetime
    :ivar driver_version_expiry_date: The driver version expiry date.
    :vartype driver_version_expiry_date: ~datetime.datetime
    :ivar last_heartbeat_utc: The time of the last heartbeat received from the agent.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar reasons_blocking_upgrade: The whether update is possible or not.
    :vartype reasons_blocking_upgrade: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentUpgradeBlockedReason]
    :ivar is_upgradeable: A value indicating whether agent is upgradeable or not.
    :vartype is_upgradeable: str
    """

    _validation = {
        "version": {"readonly": True},
        "latest_version": {"readonly": True},
        "latest_agent_release_date": {"readonly": True},
        "driver_version": {"readonly": True},
        "latest_upgradable_version_without_reboot": {"readonly": True},
        "agent_version_expiry_date": {"readonly": True},
        "driver_version_expiry_date": {"readonly": True},
        "last_heartbeat_utc": {"readonly": True},
        "reasons_blocking_upgrade": {"readonly": True},
        "is_upgradeable": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "latest_agent_release_date": {"key": "latestAgentReleaseDate", "type": "str"},
        "driver_version": {"key": "driverVersion", "type": "str"},
        "latest_upgradable_version_without_reboot": {"key": "latestUpgradableVersionWithoutReboot", "type": "str"},
        "agent_version_expiry_date": {"key": "agentVersionExpiryDate", "type": "iso-8601"},
        "driver_version_expiry_date": {"key": "driverVersionExpiryDate", "type": "iso-8601"},
        "last_heartbeat_utc": {"key": "lastHeartbeatUtc", "type": "iso-8601"},
        "reasons_blocking_upgrade": {"key": "reasonsBlockingUpgrade", "type": "[str]"},
        "is_upgradeable": {"key": "isUpgradeable", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.latest_version = None
        self.latest_agent_release_date = None
        self.driver_version = None
        self.latest_upgradable_version_without_reboot = None
        self.agent_version_expiry_date = None
        self.driver_version_expiry_date = None
        self.last_heartbeat_utc = None
        self.reasons_blocking_upgrade = None
        self.is_upgradeable = None


class InMageRcmNicDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """InMageRcm NIC details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nic_id: The NIC Id.
    :vartype nic_id: str
    :ivar is_primary_nic: A value indicating whether this is the primary NIC.
    :vartype is_primary_nic: str
    :ivar is_selected_for_failover: A value indicating whether this NIC is selected for failover.
    :vartype is_selected_for_failover: str
    :ivar source_ip_address: The source IP address.
    :vartype source_ip_address: str
    :ivar source_ip_address_type: The source IP address type. Known values are: "Dynamic" and
     "Static".
    :vartype source_ip_address_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
    :ivar source_network_id: Source network Id.
    :vartype source_network_id: str
    :ivar source_subnet_name: Source subnet name.
    :vartype source_subnet_name: str
    :ivar target_ip_address: The target IP address.
    :vartype target_ip_address: str
    :ivar target_ip_address_type: The target IP address type. Known values are: "Dynamic" and
     "Static".
    :vartype target_ip_address_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
    :ivar target_subnet_name: Target subnet name.
    :vartype target_subnet_name: str
    :ivar test_subnet_name: Test subnet name.
    :vartype test_subnet_name: str
    :ivar test_ip_address: The test IP address.
    :vartype test_ip_address: str
    :ivar test_ip_address_type: The test IP address type. Known values are: "Dynamic" and "Static".
    :vartype test_ip_address_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
    """

    _validation = {
        "nic_id": {"readonly": True},
        "source_ip_address": {"readonly": True},
        "source_ip_address_type": {"readonly": True},
        "source_network_id": {"readonly": True},
        "source_subnet_name": {"readonly": True},
    }

    _attribute_map = {
        "nic_id": {"key": "nicId", "type": "str"},
        "is_primary_nic": {"key": "isPrimaryNic", "type": "str"},
        "is_selected_for_failover": {"key": "isSelectedForFailover", "type": "str"},
        "source_ip_address": {"key": "sourceIPAddress", "type": "str"},
        "source_ip_address_type": {"key": "sourceIPAddressType", "type": "str"},
        "source_network_id": {"key": "sourceNetworkId", "type": "str"},
        "source_subnet_name": {"key": "sourceSubnetName", "type": "str"},
        "target_ip_address": {"key": "targetIPAddress", "type": "str"},
        "target_ip_address_type": {"key": "targetIPAddressType", "type": "str"},
        "target_subnet_name": {"key": "targetSubnetName", "type": "str"},
        "test_subnet_name": {"key": "testSubnetName", "type": "str"},
        "test_ip_address": {"key": "testIPAddress", "type": "str"},
        "test_ip_address_type": {"key": "testIPAddressType", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_primary_nic: Optional[str] = None,
        is_selected_for_failover: Optional[str] = None,
        target_ip_address: Optional[str] = None,
        target_ip_address_type: Optional[Union[str, "_models.EthernetAddressType"]] = None,
        target_subnet_name: Optional[str] = None,
        test_subnet_name: Optional[str] = None,
        test_ip_address: Optional[str] = None,
        test_ip_address_type: Optional[Union[str, "_models.EthernetAddressType"]] = None,
        **kwargs
    ):
        """
        :keyword is_primary_nic: A value indicating whether this is the primary NIC.
        :paramtype is_primary_nic: str
        :keyword is_selected_for_failover: A value indicating whether this NIC is selected for
         failover.
        :paramtype is_selected_for_failover: str
        :keyword target_ip_address: The target IP address.
        :paramtype target_ip_address: str
        :keyword target_ip_address_type: The target IP address type. Known values are: "Dynamic" and
         "Static".
        :paramtype target_ip_address_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
        :keyword target_subnet_name: Target subnet name.
        :paramtype target_subnet_name: str
        :keyword test_subnet_name: Test subnet name.
        :paramtype test_subnet_name: str
        :keyword test_ip_address: The test IP address.
        :paramtype test_ip_address: str
        :keyword test_ip_address_type: The test IP address type. Known values are: "Dynamic" and
         "Static".
        :paramtype test_ip_address_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
        """
        super().__init__(**kwargs)
        self.nic_id = None
        self.is_primary_nic = is_primary_nic
        self.is_selected_for_failover = is_selected_for_failover
        self.source_ip_address = None
        self.source_ip_address_type = None
        self.source_network_id = None
        self.source_subnet_name = None
        self.target_ip_address = target_ip_address
        self.target_ip_address_type = target_ip_address_type
        self.target_subnet_name = target_subnet_name
        self.test_subnet_name = test_subnet_name
        self.test_ip_address = test_ip_address
        self.test_ip_address_type = test_ip_address_type


class InMageRcmNicInput(_serialization.Model):
    """InMageRcm NIC input.

    All required parameters must be populated in order to send to Azure.

    :ivar nic_id: The NIC Id. Required.
    :vartype nic_id: str
    :ivar is_primary_nic: A value indicating whether this is the primary NIC. Required.
    :vartype is_primary_nic: str
    :ivar is_selected_for_failover: A value indicating whether this NIC is selected for failover.
    :vartype is_selected_for_failover: str
    :ivar target_subnet_name: Target subnet name.
    :vartype target_subnet_name: str
    :ivar target_static_ip_address: The target static IP address.
    :vartype target_static_ip_address: str
    :ivar test_subnet_name: The test subnet name.
    :vartype test_subnet_name: str
    :ivar test_static_ip_address: The test static IP address.
    :vartype test_static_ip_address: str
    """

    _validation = {
        "nic_id": {"required": True},
        "is_primary_nic": {"required": True},
    }

    _attribute_map = {
        "nic_id": {"key": "nicId", "type": "str"},
        "is_primary_nic": {"key": "isPrimaryNic", "type": "str"},
        "is_selected_for_failover": {"key": "isSelectedForFailover", "type": "str"},
        "target_subnet_name": {"key": "targetSubnetName", "type": "str"},
        "target_static_ip_address": {"key": "targetStaticIPAddress", "type": "str"},
        "test_subnet_name": {"key": "testSubnetName", "type": "str"},
        "test_static_ip_address": {"key": "testStaticIPAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        nic_id: str,
        is_primary_nic: str,
        is_selected_for_failover: Optional[str] = None,
        target_subnet_name: Optional[str] = None,
        target_static_ip_address: Optional[str] = None,
        test_subnet_name: Optional[str] = None,
        test_static_ip_address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword nic_id: The NIC Id. Required.
        :paramtype nic_id: str
        :keyword is_primary_nic: A value indicating whether this is the primary NIC. Required.
        :paramtype is_primary_nic: str
        :keyword is_selected_for_failover: A value indicating whether this NIC is selected for
         failover.
        :paramtype is_selected_for_failover: str
        :keyword target_subnet_name: Target subnet name.
        :paramtype target_subnet_name: str
        :keyword target_static_ip_address: The target static IP address.
        :paramtype target_static_ip_address: str
        :keyword test_subnet_name: The test subnet name.
        :paramtype test_subnet_name: str
        :keyword test_static_ip_address: The test static IP address.
        :paramtype test_static_ip_address: str
        """
        super().__init__(**kwargs)
        self.nic_id = nic_id
        self.is_primary_nic = is_primary_nic
        self.is_selected_for_failover = is_selected_for_failover
        self.target_subnet_name = target_subnet_name
        self.target_static_ip_address = target_static_ip_address
        self.test_subnet_name = test_subnet_name
        self.test_static_ip_address = test_static_ip_address


class InMageRcmPolicyCreationInput(PolicyProviderSpecificInput):
    """InMageRcm policy creation input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_history_in_minutes: The duration in minutes until which the recovery
     points need to be stored.
    :vartype recovery_point_history_in_minutes: int
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :vartype app_consistent_frequency_in_minutes: int
    :ivar enable_multi_vm_sync: A value indicating whether multi-VM sync has to be enabled.
    :vartype enable_multi_vm_sync: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_history_in_minutes": {"key": "recoveryPointHistoryInMinutes", "type": "int"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "enable_multi_vm_sync": {"key": "enableMultiVmSync", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        enable_multi_vm_sync: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_history_in_minutes: The duration in minutes until which the recovery
         points need to be stored.
        :paramtype recovery_point_history_in_minutes: int
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
         minutes).
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in
         minutes).
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword enable_multi_vm_sync: A value indicating whether multi-VM sync has to be enabled.
        :paramtype enable_multi_vm_sync: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.recovery_point_history_in_minutes = recovery_point_history_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.enable_multi_vm_sync = enable_multi_vm_sync


class InMageRcmPolicyDetails(PolicyProviderSpecificDetails):
    """InMageRcm specific policy details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar recovery_point_history_in_minutes: The duration in minutes until which the recovery
     points need to be stored.
    :vartype recovery_point_history_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :vartype app_consistent_frequency_in_minutes: int
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar enable_multi_vm_sync: A value indicating whether multi-VM sync has to be enabled.
    :vartype enable_multi_vm_sync: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_history_in_minutes": {"key": "recoveryPointHistoryInMinutes", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "enable_multi_vm_sync": {"key": "enableMultiVmSync", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        enable_multi_vm_sync: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_history_in_minutes: The duration in minutes until which the recovery
         points need to be stored.
        :paramtype recovery_point_history_in_minutes: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
         minutes.
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword enable_multi_vm_sync: A value indicating whether multi-VM sync has to be enabled.
        :paramtype enable_multi_vm_sync: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.recovery_point_history_in_minutes = recovery_point_history_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.enable_multi_vm_sync = enable_multi_vm_sync


class InMageRcmProtectedDiskDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """InMageRcm protected disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_id: The disk Id.
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar is_os_disk: A value indicating whether the disk is the OS disk.
    :vartype is_os_disk: str
    :ivar capacity_in_bytes: The disk capacity in bytes.
    :vartype capacity_in_bytes: int
    :ivar log_storage_account_id: The log storage account ARM Id.
    :vartype log_storage_account_id: str
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :vartype disk_encryption_set_id: str
    :ivar seed_managed_disk_id: The ARM Id of the seed managed disk.
    :vartype seed_managed_disk_id: str
    :ivar seed_blob_uri: The uri of the seed blob.
    :vartype seed_blob_uri: str
    :ivar target_managed_disk_id: The ARM Id of the target managed disk.
    :vartype target_managed_disk_id: str
    :ivar disk_type: The disk type. Known values are: "Standard_LRS", "Premium_LRS", and
     "StandardSSD_LRS".
    :vartype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar data_pending_in_log_data_store_in_mb: The data pending in log data store in MB.
    :vartype data_pending_in_log_data_store_in_mb: float
    :ivar data_pending_at_source_agent_in_mb: The data pending at source agent in MB.
    :vartype data_pending_at_source_agent_in_mb: float
    :ivar is_initial_replication_complete: A value indicating whether initial replication is
     complete or not.
    :vartype is_initial_replication_complete: str
    :ivar ir_details: The initial replication details.
    :vartype ir_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmSyncDetails
    :ivar resync_details: The resync details.
    :vartype resync_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmSyncDetails
    """

    _validation = {
        "disk_id": {"readonly": True},
        "disk_name": {"readonly": True},
        "is_os_disk": {"readonly": True},
        "capacity_in_bytes": {"readonly": True},
        "log_storage_account_id": {"readonly": True},
        "disk_encryption_set_id": {"readonly": True},
        "seed_managed_disk_id": {"readonly": True},
        "seed_blob_uri": {"readonly": True},
        "target_managed_disk_id": {"readonly": True},
        "data_pending_in_log_data_store_in_mb": {"readonly": True},
        "data_pending_at_source_agent_in_mb": {"readonly": True},
        "is_initial_replication_complete": {"readonly": True},
    }

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_name": {"key": "diskName", "type": "str"},
        "is_os_disk": {"key": "isOSDisk", "type": "str"},
        "capacity_in_bytes": {"key": "capacityInBytes", "type": "int"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "seed_managed_disk_id": {"key": "seedManagedDiskId", "type": "str"},
        "seed_blob_uri": {"key": "seedBlobUri", "type": "str"},
        "target_managed_disk_id": {"key": "targetManagedDiskId", "type": "str"},
        "disk_type": {"key": "diskType", "type": "str"},
        "data_pending_in_log_data_store_in_mb": {"key": "dataPendingInLogDataStoreInMB", "type": "float"},
        "data_pending_at_source_agent_in_mb": {"key": "dataPendingAtSourceAgentInMB", "type": "float"},
        "is_initial_replication_complete": {"key": "isInitialReplicationComplete", "type": "str"},
        "ir_details": {"key": "irDetails", "type": "InMageRcmSyncDetails"},
        "resync_details": {"key": "resyncDetails", "type": "InMageRcmSyncDetails"},
    }

    def __init__(
        self,
        *,
        disk_type: Optional[Union[str, "_models.DiskAccountType"]] = None,
        ir_details: Optional["_models.InMageRcmSyncDetails"] = None,
        resync_details: Optional["_models.InMageRcmSyncDetails"] = None,
        **kwargs
    ):
        """
        :keyword disk_type: The disk type. Known values are: "Standard_LRS", "Premium_LRS", and
         "StandardSSD_LRS".
        :paramtype disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
        :keyword ir_details: The initial replication details.
        :paramtype ir_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmSyncDetails
        :keyword resync_details: The resync details.
        :paramtype resync_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmSyncDetails
        """
        super().__init__(**kwargs)
        self.disk_id = None
        self.disk_name = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.log_storage_account_id = None
        self.disk_encryption_set_id = None
        self.seed_managed_disk_id = None
        self.seed_blob_uri = None
        self.target_managed_disk_id = None
        self.disk_type = disk_type
        self.data_pending_in_log_data_store_in_mb = None
        self.data_pending_at_source_agent_in_mb = None
        self.is_initial_replication_complete = None
        self.ir_details = ir_details
        self.resync_details = resync_details


class InMageRcmProtectionContainerMappingDetails(ProtectionContainerMappingProviderSpecificDetails):
    """InMageRcm provider specific container mapping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar enable_agent_auto_upgrade: A value indicating whether the flag for enable agent auto
     upgrade.
    :vartype enable_agent_auto_upgrade: str
    """

    _validation = {
        "instance_type": {"required": True},
        "enable_agent_auto_upgrade": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "enable_agent_auto_upgrade": {"key": "enableAgentAutoUpgrade", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.enable_agent_auto_upgrade = None


class InMageRcmRecoveryPointDetails(ProviderSpecificRecoveryPointDetails):
    """InMageRcm provider specific recovery point details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the provider type. Required.
    :vartype instance_type: str
    :ivar is_multi_vm_sync_point: A value indicating whether the recovery point is multi VM
     consistent.
    :vartype is_multi_vm_sync_point: str
    """

    _validation = {
        "instance_type": {"required": True},
        "is_multi_vm_sync_point": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "is_multi_vm_sync_point": {"key": "isMultiVmSyncPoint", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.is_multi_vm_sync_point = None


class InMageRcmReplicationDetails(ReplicationProviderSpecificSettings):  # pylint: disable=too-many-instance-attributes
    """InMageRcm provider specific details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar internal_identifier: The virtual machine internal identifier.
    :vartype internal_identifier: str
    :ivar fabric_discovery_machine_id: The ARM Id of the discovered VM.
    :vartype fabric_discovery_machine_id: str
    :ivar multi_vm_group_name: The multi VM group name.
    :vartype multi_vm_group_name: str
    :ivar discovery_type: The type of the discovered VM.
    :vartype discovery_type: str
    :ivar process_server_id: The process server Id.
    :vartype process_server_id: str
    :ivar processor_core_count: The processor core count.
    :vartype processor_core_count: int
    :ivar allocated_memory_in_mb: The allocated memory in MB.
    :vartype allocated_memory_in_mb: float
    :ivar process_server_name: The process server name.
    :vartype process_server_name: str
    :ivar run_as_account_id: The run-as account Id.
    :vartype run_as_account_id: str
    :ivar os_type: The type of the OS on the VM.
    :vartype os_type: str
    :ivar firmware_type: The firmware type.
    :vartype firmware_type: str
    :ivar primary_nic_ip_address: The IP address of the primary network interface.
    :vartype primary_nic_ip_address: str
    :ivar target_generation: The target generation.
    :vartype target_generation: str
    :ivar license_type: License Type of the VM to be used.
    :vartype license_type: str
    :ivar storage_account_id: The replication storage account ARM Id. This is applicable only for
     the blob based replication test hook.
    :vartype storage_account_id: str
    :ivar target_vm_name: Target VM name.
    :vartype target_vm_name: str
    :ivar target_vm_size: The target VM size.
    :vartype target_vm_size: str
    :ivar target_resource_group_id: The target resource group Id.
    :vartype target_resource_group_id: str
    :ivar target_location: The target location.
    :vartype target_location: str
    :ivar target_availability_set_id: The target availability set Id.
    :vartype target_availability_set_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar target_proximity_placement_group_id: The target proximity placement group Id.
    :vartype target_proximity_placement_group_id: str
    :ivar target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :vartype target_boot_diagnostics_storage_account_id: str
    :ivar target_network_id: The target network Id.
    :vartype target_network_id: str
    :ivar test_network_id: The test network Id.
    :vartype test_network_id: str
    :ivar failover_recovery_point_id: The recovery point Id to which the VM was failed over.
    :vartype failover_recovery_point_id: str
    :ivar last_recovery_point_received: The last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar last_rpo_in_seconds: The last recovery point objective value.
    :vartype last_rpo_in_seconds: int
    :ivar last_rpo_calculated_time: The last recovery point objective calculated time.
    :vartype last_rpo_calculated_time: ~datetime.datetime
    :ivar last_recovery_point_id: The last recovery point Id.
    :vartype last_recovery_point_id: str
    :ivar initial_replication_progress_percentage: The initial replication progress percentage.
     This is calculated based on total bytes processed for all disks in the source VM.
    :vartype initial_replication_progress_percentage: int
    :ivar initial_replication_processed_bytes: The initial replication processed bytes. This
     includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
    :vartype initial_replication_processed_bytes: int
    :ivar initial_replication_transferred_bytes: The initial replication transferred bytes from
     source VM to azure for all selected disks on source VM.
    :vartype initial_replication_transferred_bytes: int
    :ivar initial_replication_progress_health: The initial replication progress health. Known
     values are: "None", "InProgress", "SlowProgress", and "NoProgress".
    :vartype initial_replication_progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmReplicationProgressHealth
    :ivar resync_progress_percentage: The resync progress percentage. This is calculated based on
     total bytes processed for all disks in the source VM.
    :vartype resync_progress_percentage: int
    :ivar resync_processed_bytes: The resync processed bytes. This includes sum of total bytes
     transferred and matched bytes on all selected disks in source VM.
    :vartype resync_processed_bytes: int
    :ivar resync_transferred_bytes: The resync transferred bytes from source VM to azure for all
     selected disks on source VM.
    :vartype resync_transferred_bytes: int
    :ivar resync_progress_health: The resync progress health. Known values are: "None",
     "InProgress", "SlowProgress", and "NoProgress".
    :vartype resync_progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmReplicationProgressHealth
    :ivar resync_required: A value indicating whether resync is required.
    :vartype resync_required: str
    :ivar resync_state: The resync state. Known values are: "None", "PreparedForResynchronization",
     and "StartedResynchronization".
    :vartype resync_state: str or ~azure.mgmt.recoveryservicessiterecovery.models.ResyncState
    :ivar agent_upgrade_state: The agent auto upgrade state. Known values are: "None", "Started",
     "Completed", and "Commit".
    :vartype agent_upgrade_state: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MobilityAgentUpgradeState
    :ivar last_agent_upgrade_type: The last agent upgrade type.
    :vartype last_agent_upgrade_type: str
    :ivar agent_upgrade_job_id: The agent upgrade job Id.
    :vartype agent_upgrade_job_id: str
    :ivar agent_upgrade_attempt_to_version: The agent version to which last agent upgrade was
     attempted.
    :vartype agent_upgrade_attempt_to_version: str
    :ivar protected_disks: The list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmProtectedDiskDetails]
    :ivar is_last_upgrade_successful: A value indicating whether last agent upgrade was successful
     or not.
    :vartype is_last_upgrade_successful: str
    :ivar is_agent_registration_successful_after_failover: A value indicating whether agent
     registration was successful after failover.
    :vartype is_agent_registration_successful_after_failover: bool
    :ivar mobility_agent_details: The mobility agent information.
    :vartype mobility_agent_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmMobilityAgentDetails
    :ivar last_agent_upgrade_error_details: The last agent upgrade error information.
    :vartype last_agent_upgrade_error_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmLastAgentUpgradeErrorDetails]
    :ivar agent_upgrade_blocking_error_details: The agent upgrade blocking error information.
    :vartype agent_upgrade_blocking_error_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmAgentUpgradeBlockingErrorDetails]
    :ivar vm_nics: The network details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmNicDetails]
    :ivar discovered_vm_details: The discovered VM details.
    :vartype discovered_vm_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDiscoveredProtectedVmDetails
    """

    _validation = {
        "instance_type": {"required": True},
        "internal_identifier": {"readonly": True},
        "fabric_discovery_machine_id": {"readonly": True},
        "multi_vm_group_name": {"readonly": True},
        "discovery_type": {"readonly": True},
        "process_server_id": {"readonly": True},
        "processor_core_count": {"readonly": True},
        "allocated_memory_in_mb": {"readonly": True},
        "process_server_name": {"readonly": True},
        "run_as_account_id": {"readonly": True},
        "os_type": {"readonly": True},
        "firmware_type": {"readonly": True},
        "primary_nic_ip_address": {"readonly": True},
        "target_generation": {"readonly": True},
        "storage_account_id": {"readonly": True},
        "failover_recovery_point_id": {"readonly": True},
        "last_recovery_point_received": {"readonly": True},
        "last_rpo_in_seconds": {"readonly": True},
        "last_rpo_calculated_time": {"readonly": True},
        "last_recovery_point_id": {"readonly": True},
        "initial_replication_progress_percentage": {"readonly": True},
        "initial_replication_processed_bytes": {"readonly": True},
        "initial_replication_transferred_bytes": {"readonly": True},
        "initial_replication_progress_health": {"readonly": True},
        "resync_progress_percentage": {"readonly": True},
        "resync_processed_bytes": {"readonly": True},
        "resync_transferred_bytes": {"readonly": True},
        "resync_progress_health": {"readonly": True},
        "resync_required": {"readonly": True},
        "resync_state": {"readonly": True},
        "agent_upgrade_state": {"readonly": True},
        "last_agent_upgrade_type": {"readonly": True},
        "agent_upgrade_job_id": {"readonly": True},
        "agent_upgrade_attempt_to_version": {"readonly": True},
        "is_last_upgrade_successful": {"readonly": True},
        "is_agent_registration_successful_after_failover": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "internal_identifier": {"key": "internalIdentifier", "type": "str"},
        "fabric_discovery_machine_id": {"key": "fabricDiscoveryMachineId", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "discovery_type": {"key": "discoveryType", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "processor_core_count": {"key": "processorCoreCount", "type": "int"},
        "allocated_memory_in_mb": {"key": "allocatedMemoryInMB", "type": "float"},
        "process_server_name": {"key": "processServerName", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "firmware_type": {"key": "firmwareType", "type": "str"},
        "primary_nic_ip_address": {"key": "primaryNicIpAddress", "type": "str"},
        "target_generation": {"key": "targetGeneration", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "target_vm_name": {"key": "targetVmName", "type": "str"},
        "target_vm_size": {"key": "targetVmSize", "type": "str"},
        "target_resource_group_id": {"key": "targetResourceGroupId", "type": "str"},
        "target_location": {"key": "targetLocation", "type": "str"},
        "target_availability_set_id": {"key": "targetAvailabilitySetId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "target_boot_diagnostics_storage_account_id": {"key": "targetBootDiagnosticsStorageAccountId", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "failover_recovery_point_id": {"key": "failoverRecoveryPointId", "type": "str"},
        "last_recovery_point_received": {"key": "lastRecoveryPointReceived", "type": "iso-8601"},
        "last_rpo_in_seconds": {"key": "lastRpoInSeconds", "type": "int"},
        "last_rpo_calculated_time": {"key": "lastRpoCalculatedTime", "type": "iso-8601"},
        "last_recovery_point_id": {"key": "lastRecoveryPointId", "type": "str"},
        "initial_replication_progress_percentage": {"key": "initialReplicationProgressPercentage", "type": "int"},
        "initial_replication_processed_bytes": {"key": "initialReplicationProcessedBytes", "type": "int"},
        "initial_replication_transferred_bytes": {"key": "initialReplicationTransferredBytes", "type": "int"},
        "initial_replication_progress_health": {"key": "initialReplicationProgressHealth", "type": "str"},
        "resync_progress_percentage": {"key": "resyncProgressPercentage", "type": "int"},
        "resync_processed_bytes": {"key": "resyncProcessedBytes", "type": "int"},
        "resync_transferred_bytes": {"key": "resyncTransferredBytes", "type": "int"},
        "resync_progress_health": {"key": "resyncProgressHealth", "type": "str"},
        "resync_required": {"key": "resyncRequired", "type": "str"},
        "resync_state": {"key": "resyncState", "type": "str"},
        "agent_upgrade_state": {"key": "agentUpgradeState", "type": "str"},
        "last_agent_upgrade_type": {"key": "lastAgentUpgradeType", "type": "str"},
        "agent_upgrade_job_id": {"key": "agentUpgradeJobId", "type": "str"},
        "agent_upgrade_attempt_to_version": {"key": "agentUpgradeAttemptToVersion", "type": "str"},
        "protected_disks": {"key": "protectedDisks", "type": "[InMageRcmProtectedDiskDetails]"},
        "is_last_upgrade_successful": {"key": "isLastUpgradeSuccessful", "type": "str"},
        "is_agent_registration_successful_after_failover": {
            "key": "isAgentRegistrationSuccessfulAfterFailover",
            "type": "bool",
        },
        "mobility_agent_details": {"key": "mobilityAgentDetails", "type": "InMageRcmMobilityAgentDetails"},
        "last_agent_upgrade_error_details": {
            "key": "lastAgentUpgradeErrorDetails",
            "type": "[InMageRcmLastAgentUpgradeErrorDetails]",
        },
        "agent_upgrade_blocking_error_details": {
            "key": "agentUpgradeBlockingErrorDetails",
            "type": "[InMageRcmAgentUpgradeBlockingErrorDetails]",
        },
        "vm_nics": {"key": "vmNics", "type": "[InMageRcmNicDetails]"},
        "discovered_vm_details": {"key": "discoveredVmDetails", "type": "InMageRcmDiscoveredProtectedVmDetails"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        license_type: Optional[str] = None,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        target_location: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        protected_disks: Optional[List["_models.InMageRcmProtectedDiskDetails"]] = None,
        mobility_agent_details: Optional["_models.InMageRcmMobilityAgentDetails"] = None,
        last_agent_upgrade_error_details: Optional[List["_models.InMageRcmLastAgentUpgradeErrorDetails"]] = None,
        agent_upgrade_blocking_error_details: Optional[
            List["_models.InMageRcmAgentUpgradeBlockingErrorDetails"]
        ] = None,
        vm_nics: Optional[List["_models.InMageRcmNicDetails"]] = None,
        discovered_vm_details: Optional["_models.InMageRcmDiscoveredProtectedVmDetails"] = None,
        **kwargs
    ):
        """
        :keyword license_type: License Type of the VM to be used.
        :paramtype license_type: str
        :keyword target_vm_name: Target VM name.
        :paramtype target_vm_name: str
        :keyword target_vm_size: The target VM size.
        :paramtype target_vm_size: str
        :keyword target_resource_group_id: The target resource group Id.
        :paramtype target_resource_group_id: str
        :keyword target_location: The target location.
        :paramtype target_location: str
        :keyword target_availability_set_id: The target availability set Id.
        :paramtype target_availability_set_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword target_proximity_placement_group_id: The target proximity placement group Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword target_boot_diagnostics_storage_account_id: The target boot diagnostics storage
         account ARM Id.
        :paramtype target_boot_diagnostics_storage_account_id: str
        :keyword target_network_id: The target network Id.
        :paramtype target_network_id: str
        :keyword test_network_id: The test network Id.
        :paramtype test_network_id: str
        :keyword protected_disks: The list of protected disks.
        :paramtype protected_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmProtectedDiskDetails]
        :keyword mobility_agent_details: The mobility agent information.
        :paramtype mobility_agent_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmMobilityAgentDetails
        :keyword last_agent_upgrade_error_details: The last agent upgrade error information.
        :paramtype last_agent_upgrade_error_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmLastAgentUpgradeErrorDetails]
        :keyword agent_upgrade_blocking_error_details: The agent upgrade blocking error information.
        :paramtype agent_upgrade_blocking_error_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmAgentUpgradeBlockingErrorDetails]
        :keyword vm_nics: The network details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmNicDetails]
        :keyword discovered_vm_details: The discovered VM details.
        :paramtype discovered_vm_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDiscoveredProtectedVmDetails
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.internal_identifier = None
        self.fabric_discovery_machine_id = None
        self.multi_vm_group_name = None
        self.discovery_type = None
        self.process_server_id = None
        self.processor_core_count = None
        self.allocated_memory_in_mb = None
        self.process_server_name = None
        self.run_as_account_id = None
        self.os_type = None
        self.firmware_type = None
        self.primary_nic_ip_address = None
        self.target_generation = None
        self.license_type = license_type
        self.storage_account_id = None
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.target_resource_group_id = target_resource_group_id
        self.target_location = target_location
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.failover_recovery_point_id = None
        self.last_recovery_point_received = None
        self.last_rpo_in_seconds = None
        self.last_rpo_calculated_time = None
        self.last_recovery_point_id = None
        self.initial_replication_progress_percentage = None
        self.initial_replication_processed_bytes = None
        self.initial_replication_transferred_bytes = None
        self.initial_replication_progress_health = None
        self.resync_progress_percentage = None
        self.resync_processed_bytes = None
        self.resync_transferred_bytes = None
        self.resync_progress_health = None
        self.resync_required = None
        self.resync_state = None
        self.agent_upgrade_state = None
        self.last_agent_upgrade_type = None
        self.agent_upgrade_job_id = None
        self.agent_upgrade_attempt_to_version = None
        self.protected_disks = protected_disks
        self.is_last_upgrade_successful = None
        self.is_agent_registration_successful_after_failover = None
        self.mobility_agent_details = mobility_agent_details
        self.last_agent_upgrade_error_details = last_agent_upgrade_error_details
        self.agent_upgrade_blocking_error_details = agent_upgrade_blocking_error_details
        self.vm_nics = vm_nics
        self.discovered_vm_details = discovered_vm_details


class InMageRcmReprotectInput(ReverseReplicationProviderSpecificInput):
    """InMageRcm specific provider input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar reprotect_agent_id: The reprotect agent Id. Required.
    :vartype reprotect_agent_id: str
    :ivar datastore_name: The target datastore name. Required.
    :vartype datastore_name: str
    :ivar log_storage_account_id: The log storage account ARM Id. Required.
    :vartype log_storage_account_id: str
    :ivar policy_id: The Policy Id.
    :vartype policy_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "reprotect_agent_id": {"required": True},
        "datastore_name": {"required": True},
        "log_storage_account_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "reprotect_agent_id": {"key": "reprotectAgentId", "type": "str"},
        "datastore_name": {"key": "datastoreName", "type": "str"},
        "log_storage_account_id": {"key": "logStorageAccountId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        reprotect_agent_id: str,
        datastore_name: str,
        log_storage_account_id: str,
        policy_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword reprotect_agent_id: The reprotect agent Id. Required.
        :paramtype reprotect_agent_id: str
        :keyword datastore_name: The target datastore name. Required.
        :paramtype datastore_name: str
        :keyword log_storage_account_id: The log storage account ARM Id. Required.
        :paramtype log_storage_account_id: str
        :keyword policy_id: The Policy Id.
        :paramtype policy_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.reprotect_agent_id = reprotect_agent_id
        self.datastore_name = datastore_name
        self.log_storage_account_id = log_storage_account_id
        self.policy_id = policy_id


class InMageRcmSyncDetails(_serialization.Model):
    """InMageRcm disk level sync details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar progress_health: The progress health. Known values are: "None", "InProgress",
     "SlowProgress", "NoProgress", and "Queued".
    :vartype progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskReplicationProgressHealth
    :ivar transferred_bytes: The transferred bytes from source VM to azure for the disk.
    :vartype transferred_bytes: int
    :ivar last15_minutes_transferred_bytes: The bytes transferred in last 15 minutes from source VM
     to azure.
    :vartype last15_minutes_transferred_bytes: int
    :ivar last_data_transfer_time_utc: The time of the last data transfer from source VM to azure.
    :vartype last_data_transfer_time_utc: str
    :ivar processed_bytes: The total processed bytes. This includes bytes that are transferred from
     source VM to azure and matched bytes.
    :vartype processed_bytes: int
    :ivar start_time: The start time.
    :vartype start_time: str
    :ivar last_refresh_time: The last refresh time.
    :vartype last_refresh_time: str
    :ivar progress_percentage: Progress in percentage. Progress percentage is calculated based on
     processed bytes.
    :vartype progress_percentage: int
    """

    _validation = {
        "progress_health": {"readonly": True},
        "transferred_bytes": {"readonly": True},
        "last15_minutes_transferred_bytes": {"readonly": True},
        "last_data_transfer_time_utc": {"readonly": True},
        "processed_bytes": {"readonly": True},
        "start_time": {"readonly": True},
        "last_refresh_time": {"readonly": True},
        "progress_percentage": {"readonly": True},
    }

    _attribute_map = {
        "progress_health": {"key": "progressHealth", "type": "str"},
        "transferred_bytes": {"key": "transferredBytes", "type": "int"},
        "last15_minutes_transferred_bytes": {"key": "last15MinutesTransferredBytes", "type": "int"},
        "last_data_transfer_time_utc": {"key": "lastDataTransferTimeUtc", "type": "str"},
        "processed_bytes": {"key": "processedBytes", "type": "int"},
        "start_time": {"key": "startTime", "type": "str"},
        "last_refresh_time": {"key": "lastRefreshTime", "type": "str"},
        "progress_percentage": {"key": "progressPercentage", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.progress_health = None
        self.transferred_bytes = None
        self.last15_minutes_transferred_bytes = None
        self.last_data_transfer_time_utc = None
        self.processed_bytes = None
        self.start_time = None
        self.last_refresh_time = None
        self.progress_percentage = None


class InMageRcmTestFailoverInput(TestFailoverProviderSpecificInput):
    """InMageRcm provider specific input for test failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar network_id: The test network Id.
    :vartype network_id: str
    :ivar recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "network_id": {"key": "networkId", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(self, *, network_id: Optional[str] = None, recovery_point_id: Optional[str] = None, **kwargs):
        """
        :keyword network_id: The test network Id.
        :paramtype network_id: str
        :keyword recovery_point_id: The recovery point id to be passed to test failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.network_id = network_id
        self.recovery_point_id = recovery_point_id


class InMageRcmUnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """InMageRcm provider specific input for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar perform_shutdown: A value indicating whether VM is to be shutdown. Required.
    :vartype perform_shutdown: str
    :ivar recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
        "perform_shutdown": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "perform_shutdown": {"key": "performShutdown", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(self, *, perform_shutdown: str, recovery_point_id: Optional[str] = None, **kwargs):
        """
        :keyword perform_shutdown: A value indicating whether VM is to be shutdown. Required.
        :paramtype perform_shutdown: str
        :keyword recovery_point_id: The recovery point id to be passed to failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.perform_shutdown = perform_shutdown
        self.recovery_point_id = recovery_point_id


class UpdateApplianceForReplicationProtectedItemProviderSpecificInput(_serialization.Model):
    """Update replication protected item provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InMageRcmUpdateApplianceForReplicationProtectedItemInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"InMageRcm": "InMageRcmUpdateApplianceForReplicationProtectedItemInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class InMageRcmUpdateApplianceForReplicationProtectedItemInput(
    UpdateApplianceForReplicationProtectedItemProviderSpecificInput
):
    """InMageRcm provider specific input to update appliance for replication protected item.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar run_as_account_id: The run as account Id.
    :vartype run_as_account_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
    }

    def __init__(self, *, run_as_account_id: Optional[str] = None, **kwargs):
        """
        :keyword run_as_account_id: The run as account Id.
        :paramtype run_as_account_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.run_as_account_id = run_as_account_id


class InMageRcmUpdateContainerMappingInput(ReplicationProviderSpecificUpdateContainerMappingInput):
    """InMageRcm update protection container mapping.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar enable_agent_auto_upgrade: A value indicating whether agent auto upgrade has to be
     enabled. Required.
    :vartype enable_agent_auto_upgrade: str
    """

    _validation = {
        "instance_type": {"required": True},
        "enable_agent_auto_upgrade": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "enable_agent_auto_upgrade": {"key": "enableAgentAutoUpgrade", "type": "str"},
    }

    def __init__(self, *, enable_agent_auto_upgrade: str, **kwargs):
        """
        :keyword enable_agent_auto_upgrade: A value indicating whether agent auto upgrade has to be
         enabled. Required.
        :paramtype enable_agent_auto_upgrade: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.enable_agent_auto_upgrade = enable_agent_auto_upgrade


class InMageRcmUpdateReplicationProtectedItemInput(
    UpdateReplicationProtectedItemProviderInput
):  # pylint: disable=too-many-instance-attributes
    """InMageRcm provider specific input to update replication protected item.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar target_vm_name: The target VM name.
    :vartype target_vm_name: str
    :ivar target_vm_size: The target VM size.
    :vartype target_vm_size: str
    :ivar target_resource_group_id: The target resource group ARM Id.
    :vartype target_resource_group_id: str
    :ivar target_availability_set_id: The target availability set ARM Id.
    :vartype target_availability_set_id: str
    :ivar target_availability_zone: The target availability zone.
    :vartype target_availability_zone: str
    :ivar target_proximity_placement_group_id: The target proximity placement group Id.
    :vartype target_proximity_placement_group_id: str
    :ivar target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :vartype target_boot_diagnostics_storage_account_id: str
    :ivar target_network_id: The target network ARM Id.
    :vartype target_network_id: str
    :ivar test_network_id: The test network ARM Id.
    :vartype test_network_id: str
    :ivar vm_nics: The list of NIC details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmNicInput]
    :ivar license_type: The license type. Known values are: "NotSpecified", "NoLicenseType", and
     "WindowsServer".
    :vartype license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "target_vm_name": {"key": "targetVmName", "type": "str"},
        "target_vm_size": {"key": "targetVmSize", "type": "str"},
        "target_resource_group_id": {"key": "targetResourceGroupId", "type": "str"},
        "target_availability_set_id": {"key": "targetAvailabilitySetId", "type": "str"},
        "target_availability_zone": {"key": "targetAvailabilityZone", "type": "str"},
        "target_proximity_placement_group_id": {"key": "targetProximityPlacementGroupId", "type": "str"},
        "target_boot_diagnostics_storage_account_id": {"key": "targetBootDiagnosticsStorageAccountId", "type": "str"},
        "target_network_id": {"key": "targetNetworkId", "type": "str"},
        "test_network_id": {"key": "testNetworkId", "type": "str"},
        "vm_nics": {"key": "vmNics", "type": "[InMageRcmNicInput]"},
        "license_type": {"key": "licenseType", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        vm_nics: Optional[List["_models.InMageRcmNicInput"]] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        **kwargs
    ):
        """
        :keyword target_vm_name: The target VM name.
        :paramtype target_vm_name: str
        :keyword target_vm_size: The target VM size.
        :paramtype target_vm_size: str
        :keyword target_resource_group_id: The target resource group ARM Id.
        :paramtype target_resource_group_id: str
        :keyword target_availability_set_id: The target availability set ARM Id.
        :paramtype target_availability_set_id: str
        :keyword target_availability_zone: The target availability zone.
        :paramtype target_availability_zone: str
        :keyword target_proximity_placement_group_id: The target proximity placement group Id.
        :paramtype target_proximity_placement_group_id: str
        :keyword target_boot_diagnostics_storage_account_id: The target boot diagnostics storage
         account ARM Id.
        :paramtype target_boot_diagnostics_storage_account_id: str
        :keyword target_network_id: The target network ARM Id.
        :paramtype target_network_id: str
        :keyword test_network_id: The test network ARM Id.
        :paramtype test_network_id: str
        :keyword vm_nics: The list of NIC details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmNicInput]
        :keyword license_type: The license type. Known values are: "NotSpecified", "NoLicenseType", and
         "WindowsServer".
        :paramtype license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.target_resource_group_id = target_resource_group_id
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.vm_nics = vm_nics
        self.license_type = license_type


class InMageReplicationDetails(ReplicationProviderSpecificSettings):  # pylint: disable=too-many-instance-attributes
    """InMage provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar active_site_type: The active location of the VM. If the VM is being protected from Azure,
     this field will take values from { Azure, OnPrem }. If the VM is being protected between two
     data-centers, this field will be OnPrem always.
    :vartype active_site_type: str
    :ivar source_vm_cpu_count: The CPU count of the VM on the primary side.
    :vartype source_vm_cpu_count: int
    :ivar source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
    :vartype source_vm_ram_size_in_mb: int
    :ivar os_details: The OS details.
    :vartype os_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDiskDetails
    :ivar protection_stage: The protection stage.
    :vartype protection_stage: str
    :ivar vm_id: The virtual machine Id.
    :vartype vm_id: str
    :ivar vm_protection_state: The protection state for the vm.
    :vartype vm_protection_state: str
    :ivar vm_protection_state_description: The protection state description for the vm.
    :vartype vm_protection_state_description: str
    :ivar resync_details: The resync details of the machine.
    :vartype resync_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :ivar retention_window_start: The retention window start time.
    :vartype retention_window_start: ~datetime.datetime
    :ivar retention_window_end: The retention window end time.
    :vartype retention_window_end: ~datetime.datetime
    :ivar compressed_data_rate_in_mb: The compressed data change rate in MB.
    :vartype compressed_data_rate_in_mb: float
    :ivar uncompressed_data_rate_in_mb: The uncompressed data change rate in MB.
    :vartype uncompressed_data_rate_in_mb: float
    :ivar rpo_in_seconds: The RPO in seconds.
    :vartype rpo_in_seconds: int
    :ivar protected_disks: The list of protected disks.
    :vartype protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageProtectedDiskDetails]
    :ivar ip_address: The source IP address.
    :vartype ip_address: str
    :ivar last_heartbeat: The last heartbeat received from the source server.
    :vartype last_heartbeat: ~datetime.datetime
    :ivar process_server_id: The process server Id.
    :vartype process_server_id: str
    :ivar master_target_id: The master target Id.
    :vartype master_target_id: str
    :ivar consistency_points: The collection of Consistency points.
    :vartype consistency_points: dict[str, ~datetime.datetime]
    :ivar disk_resized: A value indicating whether any disk is resized for this VM.
    :vartype disk_resized: str
    :ivar reboot_after_update_status: A value indicating whether the source server requires a
     restart after update.
    :vartype reboot_after_update_status: str
    :ivar multi_vm_group_id: The multi vm group Id, if any.
    :vartype multi_vm_group_id: str
    :ivar multi_vm_group_name: The multi vm group name, if any.
    :vartype multi_vm_group_name: str
    :ivar multi_vm_sync_status: A value indicating whether the multi vm sync is enabled or
     disabled.
    :vartype multi_vm_sync_status: str
    :ivar agent_details: The agent details.
    :vartype agent_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageAgentDetails
    :ivar v_center_infrastructure_id: The vCenter infrastructure Id.
    :vartype v_center_infrastructure_id: str
    :ivar infrastructure_vm_id: The infrastructure VM Id.
    :vartype infrastructure_vm_id: str
    :ivar vm_nics: The PE Network details.
    :vartype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :ivar discovery_type: A value indicating the discovery type of the machine.
    :vartype discovery_type: str
    :ivar azure_storage_account_id: A value indicating the underlying Azure storage account. If the
     VM is not running in Azure, this value shall be set to null.
    :vartype azure_storage_account_id: str
    :ivar datastores: The datastores of the on-premise machine Value can be list of strings that
     contain datastore names.
    :vartype datastores: list[str]
    :ivar validation_errors: The validation errors of the on-premise machine Value can be list of
     validation errors.
    :vartype validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar last_rpo_calculated_time: The last RPO calculated time.
    :vartype last_rpo_calculated_time: ~datetime.datetime
    :ivar last_update_received_time: The last update time received from on-prem components.
    :vartype last_update_received_time: ~datetime.datetime
    :ivar replica_id: The replica id of the protected item.
    :vartype replica_id: str
    :ivar os_version: The OS Version of the protected item.
    :vartype os_version: str
    :ivar is_additional_stats_available: A value indicating whether additional IR stats are
     available or not.
    :vartype is_additional_stats_available: bool
    :ivar total_data_transferred: The total transferred data in bytes.
    :vartype total_data_transferred: int
    :ivar total_progress_health: The progress health.
    :vartype total_progress_health: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "active_site_type": {"key": "activeSiteType", "type": "str"},
        "source_vm_cpu_count": {"key": "sourceVmCpuCount", "type": "int"},
        "source_vm_ram_size_in_mb": {"key": "sourceVmRamSizeInMB", "type": "int"},
        "os_details": {"key": "osDetails", "type": "OSDiskDetails"},
        "protection_stage": {"key": "protectionStage", "type": "str"},
        "vm_id": {"key": "vmId", "type": "str"},
        "vm_protection_state": {"key": "vmProtectionState", "type": "str"},
        "vm_protection_state_description": {"key": "vmProtectionStateDescription", "type": "str"},
        "resync_details": {"key": "resyncDetails", "type": "InitialReplicationDetails"},
        "retention_window_start": {"key": "retentionWindowStart", "type": "iso-8601"},
        "retention_window_end": {"key": "retentionWindowEnd", "type": "iso-8601"},
        "compressed_data_rate_in_mb": {"key": "compressedDataRateInMB", "type": "float"},
        "uncompressed_data_rate_in_mb": {"key": "uncompressedDataRateInMB", "type": "float"},
        "rpo_in_seconds": {"key": "rpoInSeconds", "type": "int"},
        "protected_disks": {"key": "protectedDisks", "type": "[InMageProtectedDiskDetails]"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "last_heartbeat": {"key": "lastHeartbeat", "type": "iso-8601"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "master_target_id": {"key": "masterTargetId", "type": "str"},
        "consistency_points": {"key": "consistencyPoints", "type": "{iso-8601}"},
        "disk_resized": {"key": "diskResized", "type": "str"},
        "reboot_after_update_status": {"key": "rebootAfterUpdateStatus", "type": "str"},
        "multi_vm_group_id": {"key": "multiVmGroupId", "type": "str"},
        "multi_vm_group_name": {"key": "multiVmGroupName", "type": "str"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
        "agent_details": {"key": "agentDetails", "type": "InMageAgentDetails"},
        "v_center_infrastructure_id": {"key": "vCenterInfrastructureId", "type": "str"},
        "infrastructure_vm_id": {"key": "infrastructureVmId", "type": "str"},
        "vm_nics": {"key": "vmNics", "type": "[VMNicDetails]"},
        "discovery_type": {"key": "discoveryType", "type": "str"},
        "azure_storage_account_id": {"key": "azureStorageAccountId", "type": "str"},
        "datastores": {"key": "datastores", "type": "[str]"},
        "validation_errors": {"key": "validationErrors", "type": "[HealthError]"},
        "last_rpo_calculated_time": {"key": "lastRpoCalculatedTime", "type": "iso-8601"},
        "last_update_received_time": {"key": "lastUpdateReceivedTime", "type": "iso-8601"},
        "replica_id": {"key": "replicaId", "type": "str"},
        "os_version": {"key": "osVersion", "type": "str"},
        "is_additional_stats_available": {"key": "isAdditionalStatsAvailable", "type": "bool"},
        "total_data_transferred": {"key": "totalDataTransferred", "type": "int"},
        "total_progress_health": {"key": "totalProgressHealth", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        active_site_type: Optional[str] = None,
        source_vm_cpu_count: Optional[int] = None,
        source_vm_ram_size_in_mb: Optional[int] = None,
        os_details: Optional["_models.OSDiskDetails"] = None,
        protection_stage: Optional[str] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        resync_details: Optional["_models.InitialReplicationDetails"] = None,
        retention_window_start: Optional[datetime.datetime] = None,
        retention_window_end: Optional[datetime.datetime] = None,
        compressed_data_rate_in_mb: Optional[float] = None,
        uncompressed_data_rate_in_mb: Optional[float] = None,
        rpo_in_seconds: Optional[int] = None,
        protected_disks: Optional[List["_models.InMageProtectedDiskDetails"]] = None,
        ip_address: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        process_server_id: Optional[str] = None,
        master_target_id: Optional[str] = None,
        consistency_points: Optional[Dict[str, datetime.datetime]] = None,
        disk_resized: Optional[str] = None,
        reboot_after_update_status: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_sync_status: Optional[str] = None,
        agent_details: Optional["_models.InMageAgentDetails"] = None,
        v_center_infrastructure_id: Optional[str] = None,
        infrastructure_vm_id: Optional[str] = None,
        vm_nics: Optional[List["_models.VMNicDetails"]] = None,
        discovery_type: Optional[str] = None,
        azure_storage_account_id: Optional[str] = None,
        datastores: Optional[List[str]] = None,
        validation_errors: Optional[List["_models.HealthError"]] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        last_update_received_time: Optional[datetime.datetime] = None,
        replica_id: Optional[str] = None,
        os_version: Optional[str] = None,
        is_additional_stats_available: Optional[bool] = None,
        total_data_transferred: Optional[int] = None,
        total_progress_health: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword active_site_type: The active location of the VM. If the VM is being protected from
         Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between
         two data-centers, this field will be OnPrem always.
        :paramtype active_site_type: str
        :keyword source_vm_cpu_count: The CPU count of the VM on the primary side.
        :paramtype source_vm_cpu_count: int
        :keyword source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
        :paramtype source_vm_ram_size_in_mb: int
        :keyword os_details: The OS details.
        :paramtype os_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDiskDetails
        :keyword protection_stage: The protection stage.
        :paramtype protection_stage: str
        :keyword vm_id: The virtual machine Id.
        :paramtype vm_id: str
        :keyword vm_protection_state: The protection state for the vm.
        :paramtype vm_protection_state: str
        :keyword vm_protection_state_description: The protection state description for the vm.
        :paramtype vm_protection_state_description: str
        :keyword resync_details: The resync details of the machine.
        :paramtype resync_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
        :keyword retention_window_start: The retention window start time.
        :paramtype retention_window_start: ~datetime.datetime
        :keyword retention_window_end: The retention window end time.
        :paramtype retention_window_end: ~datetime.datetime
        :keyword compressed_data_rate_in_mb: The compressed data change rate in MB.
        :paramtype compressed_data_rate_in_mb: float
        :keyword uncompressed_data_rate_in_mb: The uncompressed data change rate in MB.
        :paramtype uncompressed_data_rate_in_mb: float
        :keyword rpo_in_seconds: The RPO in seconds.
        :paramtype rpo_in_seconds: int
        :keyword protected_disks: The list of protected disks.
        :paramtype protected_disks:
         list[~azure.mgmt.recoveryservicessiterecovery.models.InMageProtectedDiskDetails]
        :keyword ip_address: The source IP address.
        :paramtype ip_address: str
        :keyword last_heartbeat: The last heartbeat received from the source server.
        :paramtype last_heartbeat: ~datetime.datetime
        :keyword process_server_id: The process server Id.
        :paramtype process_server_id: str
        :keyword master_target_id: The master target Id.
        :paramtype master_target_id: str
        :keyword consistency_points: The collection of Consistency points.
        :paramtype consistency_points: dict[str, ~datetime.datetime]
        :keyword disk_resized: A value indicating whether any disk is resized for this VM.
        :paramtype disk_resized: str
        :keyword reboot_after_update_status: A value indicating whether the source server requires a
         restart after update.
        :paramtype reboot_after_update_status: str
        :keyword multi_vm_group_id: The multi vm group Id, if any.
        :paramtype multi_vm_group_id: str
        :keyword multi_vm_group_name: The multi vm group name, if any.
        :paramtype multi_vm_group_name: str
        :keyword multi_vm_sync_status: A value indicating whether the multi vm sync is enabled or
         disabled.
        :paramtype multi_vm_sync_status: str
        :keyword agent_details: The agent details.
        :paramtype agent_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageAgentDetails
        :keyword v_center_infrastructure_id: The vCenter infrastructure Id.
        :paramtype v_center_infrastructure_id: str
        :keyword infrastructure_vm_id: The infrastructure VM Id.
        :paramtype infrastructure_vm_id: str
        :keyword vm_nics: The PE Network details.
        :paramtype vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
        :keyword discovery_type: A value indicating the discovery type of the machine.
        :paramtype discovery_type: str
        :keyword azure_storage_account_id: A value indicating the underlying Azure storage account. If
         the VM is not running in Azure, this value shall be set to null.
        :paramtype azure_storage_account_id: str
        :keyword datastores: The datastores of the on-premise machine Value can be list of strings that
         contain datastore names.
        :paramtype datastores: list[str]
        :keyword validation_errors: The validation errors of the on-premise machine Value can be list
         of validation errors.
        :paramtype validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
        :keyword last_rpo_calculated_time: The last RPO calculated time.
        :paramtype last_rpo_calculated_time: ~datetime.datetime
        :keyword last_update_received_time: The last update time received from on-prem components.
        :paramtype last_update_received_time: ~datetime.datetime
        :keyword replica_id: The replica id of the protected item.
        :paramtype replica_id: str
        :keyword os_version: The OS Version of the protected item.
        :paramtype os_version: str
        :keyword is_additional_stats_available: A value indicating whether additional IR stats are
         available or not.
        :paramtype is_additional_stats_available: bool
        :keyword total_data_transferred: The total transferred data in bytes.
        :paramtype total_data_transferred: int
        :keyword total_progress_health: The progress health.
        :paramtype total_progress_health: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.active_site_type = active_site_type
        self.source_vm_cpu_count = source_vm_cpu_count
        self.source_vm_ram_size_in_mb = source_vm_ram_size_in_mb
        self.os_details = os_details
        self.protection_stage = protection_stage
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.resync_details = resync_details
        self.retention_window_start = retention_window_start
        self.retention_window_end = retention_window_end
        self.compressed_data_rate_in_mb = compressed_data_rate_in_mb
        self.uncompressed_data_rate_in_mb = uncompressed_data_rate_in_mb
        self.rpo_in_seconds = rpo_in_seconds
        self.protected_disks = protected_disks
        self.ip_address = ip_address
        self.last_heartbeat = last_heartbeat
        self.process_server_id = process_server_id
        self.master_target_id = master_target_id
        self.consistency_points = consistency_points
        self.disk_resized = disk_resized
        self.reboot_after_update_status = reboot_after_update_status
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_sync_status = multi_vm_sync_status
        self.agent_details = agent_details
        self.v_center_infrastructure_id = v_center_infrastructure_id
        self.infrastructure_vm_id = infrastructure_vm_id
        self.vm_nics = vm_nics
        self.discovery_type = discovery_type
        self.azure_storage_account_id = azure_storage_account_id
        self.datastores = datastores
        self.validation_errors = validation_errors
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.last_update_received_time = last_update_received_time
        self.replica_id = replica_id
        self.os_version = os_version
        self.is_additional_stats_available = is_additional_stats_available
        self.total_data_transferred = total_data_transferred
        self.total_progress_health = total_progress_health


class InMageReprotectInput(ReverseReplicationProviderSpecificInput):
    """InMageAzureV2 specific provider input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar master_target_id: The Master Target Id. Required.
    :vartype master_target_id: str
    :ivar process_server_id: The Process Server Id. Required.
    :vartype process_server_id: str
    :ivar retention_drive: The retention drive to use on the MT. Required.
    :vartype retention_drive: str
    :ivar run_as_account_id: The CS account Id.
    :vartype run_as_account_id: str
    :ivar datastore_name: The target datastore name.
    :vartype datastore_name: str
    :ivar disk_exclusion_input: The enable disk exclusion input.
    :vartype disk_exclusion_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskExclusionInput
    :ivar profile_id: The Policy Id. Required.
    :vartype profile_id: str
    :ivar disks_to_include: The disks to include list.
    :vartype disks_to_include: list[str]
    """

    _validation = {
        "instance_type": {"required": True},
        "master_target_id": {"required": True},
        "process_server_id": {"required": True},
        "retention_drive": {"required": True},
        "profile_id": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "master_target_id": {"key": "masterTargetId", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
        "retention_drive": {"key": "retentionDrive", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "datastore_name": {"key": "datastoreName", "type": "str"},
        "disk_exclusion_input": {"key": "diskExclusionInput", "type": "InMageDiskExclusionInput"},
        "profile_id": {"key": "profileId", "type": "str"},
        "disks_to_include": {"key": "disksToInclude", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        master_target_id: str,
        process_server_id: str,
        retention_drive: str,
        profile_id: str,
        run_as_account_id: Optional[str] = None,
        datastore_name: Optional[str] = None,
        disk_exclusion_input: Optional["_models.InMageDiskExclusionInput"] = None,
        disks_to_include: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword master_target_id: The Master Target Id. Required.
        :paramtype master_target_id: str
        :keyword process_server_id: The Process Server Id. Required.
        :paramtype process_server_id: str
        :keyword retention_drive: The retention drive to use on the MT. Required.
        :paramtype retention_drive: str
        :keyword run_as_account_id: The CS account Id.
        :paramtype run_as_account_id: str
        :keyword datastore_name: The target datastore name.
        :paramtype datastore_name: str
        :keyword disk_exclusion_input: The enable disk exclusion input.
        :paramtype disk_exclusion_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskExclusionInput
        :keyword profile_id: The Policy Id. Required.
        :paramtype profile_id: str
        :keyword disks_to_include: The disks to include list.
        :paramtype disks_to_include: list[str]
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.master_target_id = master_target_id
        self.process_server_id = process_server_id
        self.retention_drive = retention_drive
        self.run_as_account_id = run_as_account_id
        self.datastore_name = datastore_name
        self.disk_exclusion_input = disk_exclusion_input
        self.profile_id = profile_id
        self.disks_to_include = disks_to_include


class InMageTestFailoverInput(TestFailoverProviderSpecificInput):
    """Provider specific input for InMage test failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_type: The recovery point type. Values from LatestTime, LatestTag or
     Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In
     the other two cases, recovery point id will be ignored. Known values are: "LatestTime",
     "LatestTag", and "Custom".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointType
    :ivar recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Optional[Union[str, "_models.RecoveryPointType"]] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_type: The recovery point type. Values from LatestTime, LatestTag or
         Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In
         the other two cases, recovery point id will be ignored. Known values are: "LatestTime",
         "LatestTag", and "Custom".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointType
        :keyword recovery_point_id: The recovery point id to be passed to test failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.recovery_point_type = recovery_point_type
        self.recovery_point_id = recovery_point_id


class InMageUnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """Provider specific input for InMage unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_type: The recovery point type. Values from LatestTime, LatestTag or
     Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In
     the other two cases, recovery point id will be ignored. Known values are: "LatestTime",
     "LatestTag", and "Custom".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointType
    :ivar recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :vartype recovery_point_id: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Optional[Union[str, "_models.RecoveryPointType"]] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_type: The recovery point type. Values from LatestTime, LatestTag or
         Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In
         the other two cases, recovery point id will be ignored. Known values are: "LatestTime",
         "LatestTag", and "Custom".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointType
        :keyword recovery_point_id: The recovery point id to be passed to failover to a particular
         recovery point. In case of latest recovery point, null should be passed.
        :paramtype recovery_point_id: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.recovery_point_type = recovery_point_type
        self.recovery_point_id = recovery_point_id


class InMageVolumeExclusionOptions(_serialization.Model):
    """Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider.

    :ivar volume_label: The volume label. The disk having any volume with this label will be
     excluded from replication.
    :vartype volume_label: str
    :ivar only_exclude_if_single_volume: The value indicating whether to exclude multi volume disk
     or not. If a disk has multiple volumes and one of the volume has label matching with
     VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
    :vartype only_exclude_if_single_volume: str
    """

    _attribute_map = {
        "volume_label": {"key": "volumeLabel", "type": "str"},
        "only_exclude_if_single_volume": {"key": "onlyExcludeIfSingleVolume", "type": "str"},
    }

    def __init__(
        self, *, volume_label: Optional[str] = None, only_exclude_if_single_volume: Optional[str] = None, **kwargs
    ):
        """
        :keyword volume_label: The volume label. The disk having any volume with this label will be
         excluded from replication.
        :paramtype volume_label: str
        :keyword only_exclude_if_single_volume: The value indicating whether to exclude multi volume
         disk or not. If a disk has multiple volumes and one of the volume has label matching with
         VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
        :paramtype only_exclude_if_single_volume: str
        """
        super().__init__(**kwargs)
        self.volume_label = volume_label
        self.only_exclude_if_single_volume = only_exclude_if_single_volume


class InnerHealthError(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Implements InnerHealthError class. HealthError object has a list of InnerHealthErrors as child errors. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.

    :ivar error_source: Source of error.
    :vartype error_source: str
    :ivar error_type: Type of error.
    :vartype error_type: str
    :ivar error_level: Level of error.
    :vartype error_level: str
    :ivar error_category: Category of error.
    :vartype error_category: str
    :ivar error_code: Error code.
    :vartype error_code: str
    :ivar summary_message: Summary message of the entity.
    :vartype summary_message: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar possible_causes: Possible causes of error.
    :vartype possible_causes: str
    :ivar recommended_action: Recommended action to resolve error.
    :vartype recommended_action: str
    :ivar creation_time_utc: Error creation time (UTC).
    :vartype creation_time_utc: ~datetime.datetime
    :ivar recovery_provider_error_message: DRA error message.
    :vartype recovery_provider_error_message: str
    :ivar entity_id: ID of the entity.
    :vartype entity_id: str
    :ivar error_id: The health error unique id.
    :vartype error_id: str
    :ivar customer_resolvability: Value indicating whether the health error is customer resolvable.
     Known values are: "Allowed" and "NotAllowed".
    :vartype customer_resolvability: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCustomerResolvability
    """

    _attribute_map = {
        "error_source": {"key": "errorSource", "type": "str"},
        "error_type": {"key": "errorType", "type": "str"},
        "error_level": {"key": "errorLevel", "type": "str"},
        "error_category": {"key": "errorCategory", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "summary_message": {"key": "summaryMessage", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "creation_time_utc": {"key": "creationTimeUtc", "type": "iso-8601"},
        "recovery_provider_error_message": {"key": "recoveryProviderErrorMessage", "type": "str"},
        "entity_id": {"key": "entityId", "type": "str"},
        "error_id": {"key": "errorId", "type": "str"},
        "customer_resolvability": {"key": "customerResolvability", "type": "str"},
    }

    def __init__(
        self,
        *,
        error_source: Optional[str] = None,
        error_type: Optional[str] = None,
        error_level: Optional[str] = None,
        error_category: Optional[str] = None,
        error_code: Optional[str] = None,
        summary_message: Optional[str] = None,
        error_message: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        creation_time_utc: Optional[datetime.datetime] = None,
        recovery_provider_error_message: Optional[str] = None,
        entity_id: Optional[str] = None,
        error_id: Optional[str] = None,
        customer_resolvability: Optional[Union[str, "_models.HealthErrorCustomerResolvability"]] = None,
        **kwargs
    ):
        """
        :keyword error_source: Source of error.
        :paramtype error_source: str
        :keyword error_type: Type of error.
        :paramtype error_type: str
        :keyword error_level: Level of error.
        :paramtype error_level: str
        :keyword error_category: Category of error.
        :paramtype error_category: str
        :keyword error_code: Error code.
        :paramtype error_code: str
        :keyword summary_message: Summary message of the entity.
        :paramtype summary_message: str
        :keyword error_message: Error message.
        :paramtype error_message: str
        :keyword possible_causes: Possible causes of error.
        :paramtype possible_causes: str
        :keyword recommended_action: Recommended action to resolve error.
        :paramtype recommended_action: str
        :keyword creation_time_utc: Error creation time (UTC).
        :paramtype creation_time_utc: ~datetime.datetime
        :keyword recovery_provider_error_message: DRA error message.
        :paramtype recovery_provider_error_message: str
        :keyword entity_id: ID of the entity.
        :paramtype entity_id: str
        :keyword error_id: The health error unique id.
        :paramtype error_id: str
        :keyword customer_resolvability: Value indicating whether the health error is customer
         resolvable. Known values are: "Allowed" and "NotAllowed".
        :paramtype customer_resolvability: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCustomerResolvability
        """
        super().__init__(**kwargs)
        self.error_source = error_source
        self.error_type = error_type
        self.error_level = error_level
        self.error_category = error_category
        self.error_code = error_code
        self.summary_message = summary_message
        self.error_message = error_message
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action
        self.creation_time_utc = creation_time_utc
        self.recovery_provider_error_message = recovery_provider_error_message
        self.entity_id = entity_id
        self.error_id = error_id
        self.customer_resolvability = customer_resolvability


class InputEndpoint(_serialization.Model):
    """InputEndpoint.

    :ivar endpoint_name:
    :vartype endpoint_name: str
    :ivar private_port:
    :vartype private_port: int
    :ivar public_port:
    :vartype public_port: int
    :ivar protocol:
    :vartype protocol: str
    """

    _attribute_map = {
        "endpoint_name": {"key": "endpointName", "type": "str"},
        "private_port": {"key": "privatePort", "type": "int"},
        "public_port": {"key": "publicPort", "type": "int"},
        "protocol": {"key": "protocol", "type": "str"},
    }

    def __init__(
        self,
        *,
        endpoint_name: Optional[str] = None,
        private_port: Optional[int] = None,
        public_port: Optional[int] = None,
        protocol: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword endpoint_name:
        :paramtype endpoint_name: str
        :keyword private_port:
        :paramtype private_port: int
        :keyword public_port:
        :paramtype public_port: int
        :keyword protocol:
        :paramtype protocol: str
        """
        super().__init__(**kwargs)
        self.endpoint_name = endpoint_name
        self.private_port = private_port
        self.public_port = public_port
        self.protocol = protocol


class IPConfigDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """IPConfigDetails.

    :ivar name:
    :vartype name: str
    :ivar is_primary:
    :vartype is_primary: bool
    :ivar subnet_name:
    :vartype subnet_name: str
    :ivar static_ip_address:
    :vartype static_ip_address: str
    :ivar ip_address_type:
    :vartype ip_address_type: str
    :ivar is_seleted_for_failover:
    :vartype is_seleted_for_failover: bool
    :ivar recovery_subnet_name:
    :vartype recovery_subnet_name: str
    :ivar recovery_static_ip_address:
    :vartype recovery_static_ip_address: str
    :ivar recovery_ip_address_type:
    :vartype recovery_ip_address_type: str
    :ivar recovery_public_ip_address_id:
    :vartype recovery_public_ip_address_id: str
    :ivar recovery_lb_backend_address_pool_ids:
    :vartype recovery_lb_backend_address_pool_ids: list[str]
    :ivar tfo_subnet_name:
    :vartype tfo_subnet_name: str
    :ivar tfo_static_ip_address:
    :vartype tfo_static_ip_address: str
    :ivar tfo_public_ip_address_id:
    :vartype tfo_public_ip_address_id: str
    :ivar tfo_lb_backend_address_pool_ids:
    :vartype tfo_lb_backend_address_pool_ids: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_primary": {"key": "isPrimary", "type": "bool"},
        "subnet_name": {"key": "subnetName", "type": "str"},
        "static_ip_address": {"key": "staticIPAddress", "type": "str"},
        "ip_address_type": {"key": "ipAddressType", "type": "str"},
        "is_seleted_for_failover": {"key": "isSeletedForFailover", "type": "bool"},
        "recovery_subnet_name": {"key": "recoverySubnetName", "type": "str"},
        "recovery_static_ip_address": {"key": "recoveryStaticIPAddress", "type": "str"},
        "recovery_ip_address_type": {"key": "recoveryIPAddressType", "type": "str"},
        "recovery_public_ip_address_id": {"key": "recoveryPublicIPAddressId", "type": "str"},
        "recovery_lb_backend_address_pool_ids": {"key": "recoveryLBBackendAddressPoolIds", "type": "[str]"},
        "tfo_subnet_name": {"key": "tfoSubnetName", "type": "str"},
        "tfo_static_ip_address": {"key": "tfoStaticIPAddress", "type": "str"},
        "tfo_public_ip_address_id": {"key": "tfoPublicIPAddressId", "type": "str"},
        "tfo_lb_backend_address_pool_ids": {"key": "tfoLBBackendAddressPoolIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_primary: Optional[bool] = None,
        subnet_name: Optional[str] = None,
        static_ip_address: Optional[str] = None,
        ip_address_type: Optional[str] = None,
        is_seleted_for_failover: Optional[bool] = None,
        recovery_subnet_name: Optional[str] = None,
        recovery_static_ip_address: Optional[str] = None,
        recovery_ip_address_type: Optional[str] = None,
        recovery_public_ip_address_id: Optional[str] = None,
        recovery_lb_backend_address_pool_ids: Optional[List[str]] = None,
        tfo_subnet_name: Optional[str] = None,
        tfo_static_ip_address: Optional[str] = None,
        tfo_public_ip_address_id: Optional[str] = None,
        tfo_lb_backend_address_pool_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword is_primary:
        :paramtype is_primary: bool
        :keyword subnet_name:
        :paramtype subnet_name: str
        :keyword static_ip_address:
        :paramtype static_ip_address: str
        :keyword ip_address_type:
        :paramtype ip_address_type: str
        :keyword is_seleted_for_failover:
        :paramtype is_seleted_for_failover: bool
        :keyword recovery_subnet_name:
        :paramtype recovery_subnet_name: str
        :keyword recovery_static_ip_address:
        :paramtype recovery_static_ip_address: str
        :keyword recovery_ip_address_type:
        :paramtype recovery_ip_address_type: str
        :keyword recovery_public_ip_address_id:
        :paramtype recovery_public_ip_address_id: str
        :keyword recovery_lb_backend_address_pool_ids:
        :paramtype recovery_lb_backend_address_pool_ids: list[str]
        :keyword tfo_subnet_name:
        :paramtype tfo_subnet_name: str
        :keyword tfo_static_ip_address:
        :paramtype tfo_static_ip_address: str
        :keyword tfo_public_ip_address_id:
        :paramtype tfo_public_ip_address_id: str
        :keyword tfo_lb_backend_address_pool_ids:
        :paramtype tfo_lb_backend_address_pool_ids: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_primary = is_primary
        self.subnet_name = subnet_name
        self.static_ip_address = static_ip_address
        self.ip_address_type = ip_address_type
        self.is_seleted_for_failover = is_seleted_for_failover
        self.recovery_subnet_name = recovery_subnet_name
        self.recovery_static_ip_address = recovery_static_ip_address
        self.recovery_ip_address_type = recovery_ip_address_type
        self.recovery_public_ip_address_id = recovery_public_ip_address_id
        self.recovery_lb_backend_address_pool_ids = recovery_lb_backend_address_pool_ids
        self.tfo_subnet_name = tfo_subnet_name
        self.tfo_static_ip_address = tfo_static_ip_address
        self.tfo_public_ip_address_id = tfo_public_ip_address_id
        self.tfo_lb_backend_address_pool_ids = tfo_lb_backend_address_pool_ids


class IPConfigInputDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """IPConfigInputDetails.

    :ivar ip_config_name:
    :vartype ip_config_name: str
    :ivar is_primary:
    :vartype is_primary: bool
    :ivar is_seleted_for_failover:
    :vartype is_seleted_for_failover: bool
    :ivar recovery_subnet_name:
    :vartype recovery_subnet_name: str
    :ivar recovery_static_ip_address:
    :vartype recovery_static_ip_address: str
    :ivar recovery_public_ip_address_id:
    :vartype recovery_public_ip_address_id: str
    :ivar recovery_lb_backend_address_pool_ids:
    :vartype recovery_lb_backend_address_pool_ids: list[str]
    :ivar tfo_subnet_name:
    :vartype tfo_subnet_name: str
    :ivar tfo_static_ip_address:
    :vartype tfo_static_ip_address: str
    :ivar tfo_public_ip_address_id:
    :vartype tfo_public_ip_address_id: str
    :ivar tfo_lb_backend_address_pool_ids:
    :vartype tfo_lb_backend_address_pool_ids: list[str]
    """

    _attribute_map = {
        "ip_config_name": {"key": "ipConfigName", "type": "str"},
        "is_primary": {"key": "isPrimary", "type": "bool"},
        "is_seleted_for_failover": {"key": "isSeletedForFailover", "type": "bool"},
        "recovery_subnet_name": {"key": "recoverySubnetName", "type": "str"},
        "recovery_static_ip_address": {"key": "recoveryStaticIPAddress", "type": "str"},
        "recovery_public_ip_address_id": {"key": "recoveryPublicIPAddressId", "type": "str"},
        "recovery_lb_backend_address_pool_ids": {"key": "recoveryLBBackendAddressPoolIds", "type": "[str]"},
        "tfo_subnet_name": {"key": "tfoSubnetName", "type": "str"},
        "tfo_static_ip_address": {"key": "tfoStaticIPAddress", "type": "str"},
        "tfo_public_ip_address_id": {"key": "tfoPublicIPAddressId", "type": "str"},
        "tfo_lb_backend_address_pool_ids": {"key": "tfoLBBackendAddressPoolIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        ip_config_name: Optional[str] = None,
        is_primary: Optional[bool] = None,
        is_seleted_for_failover: Optional[bool] = None,
        recovery_subnet_name: Optional[str] = None,
        recovery_static_ip_address: Optional[str] = None,
        recovery_public_ip_address_id: Optional[str] = None,
        recovery_lb_backend_address_pool_ids: Optional[List[str]] = None,
        tfo_subnet_name: Optional[str] = None,
        tfo_static_ip_address: Optional[str] = None,
        tfo_public_ip_address_id: Optional[str] = None,
        tfo_lb_backend_address_pool_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword ip_config_name:
        :paramtype ip_config_name: str
        :keyword is_primary:
        :paramtype is_primary: bool
        :keyword is_seleted_for_failover:
        :paramtype is_seleted_for_failover: bool
        :keyword recovery_subnet_name:
        :paramtype recovery_subnet_name: str
        :keyword recovery_static_ip_address:
        :paramtype recovery_static_ip_address: str
        :keyword recovery_public_ip_address_id:
        :paramtype recovery_public_ip_address_id: str
        :keyword recovery_lb_backend_address_pool_ids:
        :paramtype recovery_lb_backend_address_pool_ids: list[str]
        :keyword tfo_subnet_name:
        :paramtype tfo_subnet_name: str
        :keyword tfo_static_ip_address:
        :paramtype tfo_static_ip_address: str
        :keyword tfo_public_ip_address_id:
        :paramtype tfo_public_ip_address_id: str
        :keyword tfo_lb_backend_address_pool_ids:
        :paramtype tfo_lb_backend_address_pool_ids: list[str]
        """
        super().__init__(**kwargs)
        self.ip_config_name = ip_config_name
        self.is_primary = is_primary
        self.is_seleted_for_failover = is_seleted_for_failover
        self.recovery_subnet_name = recovery_subnet_name
        self.recovery_static_ip_address = recovery_static_ip_address
        self.recovery_public_ip_address_id = recovery_public_ip_address_id
        self.recovery_lb_backend_address_pool_ids = recovery_lb_backend_address_pool_ids
        self.tfo_subnet_name = tfo_subnet_name
        self.tfo_static_ip_address = tfo_static_ip_address
        self.tfo_public_ip_address_id = tfo_public_ip_address_id
        self.tfo_lb_backend_address_pool_ids = tfo_lb_backend_address_pool_ids


class Job(Resource):
    """Job details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The custom data.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.JobProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "JobProperties"},
    }

    def __init__(
        self, *, location: Optional[str] = None, properties: Optional["_models.JobProperties"] = None, **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The custom data.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.JobProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class JobCollection(_serialization.Model):
    """Collection of jobs.

    :ivar value: The list of jobs.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Job]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Job]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Job"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of jobs.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Job]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JobEntity(_serialization.Model):
    """This class contains the minimal job details required to navigate to the desired drill down.

    :ivar job_id: The job id.
    :vartype job_id: str
    :ivar job_friendly_name: The job display name.
    :vartype job_friendly_name: str
    :ivar target_object_id: The object id.
    :vartype target_object_id: str
    :ivar target_object_name: The object name.
    :vartype target_object_name: str
    :ivar target_instance_type: The workflow affected object type.
    :vartype target_instance_type: str
    :ivar job_scenario_name: The job name. Enum type ScenarioName.
    :vartype job_scenario_name: str
    """

    _attribute_map = {
        "job_id": {"key": "jobId", "type": "str"},
        "job_friendly_name": {"key": "jobFriendlyName", "type": "str"},
        "target_object_id": {"key": "targetObjectId", "type": "str"},
        "target_object_name": {"key": "targetObjectName", "type": "str"},
        "target_instance_type": {"key": "targetInstanceType", "type": "str"},
        "job_scenario_name": {"key": "jobScenarioName", "type": "str"},
    }

    def __init__(
        self,
        *,
        job_id: Optional[str] = None,
        job_friendly_name: Optional[str] = None,
        target_object_id: Optional[str] = None,
        target_object_name: Optional[str] = None,
        target_instance_type: Optional[str] = None,
        job_scenario_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword job_id: The job id.
        :paramtype job_id: str
        :keyword job_friendly_name: The job display name.
        :paramtype job_friendly_name: str
        :keyword target_object_id: The object id.
        :paramtype target_object_id: str
        :keyword target_object_name: The object name.
        :paramtype target_object_name: str
        :keyword target_instance_type: The workflow affected object type.
        :paramtype target_instance_type: str
        :keyword job_scenario_name: The job name. Enum type ScenarioName.
        :paramtype job_scenario_name: str
        """
        super().__init__(**kwargs)
        self.job_id = job_id
        self.job_friendly_name = job_friendly_name
        self.target_object_id = target_object_id
        self.target_object_name = target_object_name
        self.target_instance_type = target_instance_type
        self.job_scenario_name = job_scenario_name


class JobErrorDetails(_serialization.Model):
    """This class contains the error details per object.

    :ivar service_error_details: The Service error details.
    :vartype service_error_details: ~azure.mgmt.recoveryservicessiterecovery.models.ServiceError
    :ivar provider_error_details: The Provider error details.
    :vartype provider_error_details: ~azure.mgmt.recoveryservicessiterecovery.models.ProviderError
    :ivar error_level: Error level of error.
    :vartype error_level: str
    :ivar creation_time: The creation time of job error.
    :vartype creation_time: ~datetime.datetime
    :ivar task_id: The Id of the task.
    :vartype task_id: str
    """

    _attribute_map = {
        "service_error_details": {"key": "serviceErrorDetails", "type": "ServiceError"},
        "provider_error_details": {"key": "providerErrorDetails", "type": "ProviderError"},
        "error_level": {"key": "errorLevel", "type": "str"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "task_id": {"key": "taskId", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_error_details: Optional["_models.ServiceError"] = None,
        provider_error_details: Optional["_models.ProviderError"] = None,
        error_level: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        task_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword service_error_details: The Service error details.
        :paramtype service_error_details: ~azure.mgmt.recoveryservicessiterecovery.models.ServiceError
        :keyword provider_error_details: The Provider error details.
        :paramtype provider_error_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.ProviderError
        :keyword error_level: Error level of error.
        :paramtype error_level: str
        :keyword creation_time: The creation time of job error.
        :paramtype creation_time: ~datetime.datetime
        :keyword task_id: The Id of the task.
        :paramtype task_id: str
        """
        super().__init__(**kwargs)
        self.service_error_details = service_error_details
        self.provider_error_details = provider_error_details
        self.error_level = error_level
        self.creation_time = creation_time
        self.task_id = task_id


class JobProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Job custom data details.

    :ivar activity_id: The activity id.
    :vartype activity_id: str
    :ivar scenario_name: The ScenarioName.
    :vartype scenario_name: str
    :ivar friendly_name: The DisplayName.
    :vartype friendly_name: str
    :ivar state: The status of the Job. It is one of these values - NotStarted, InProgress,
     Succeeded, Failed, Cancelled, Suspended or Other.
    :vartype state: str
    :ivar state_description: The description of the state of the Job. For e.g. - For Succeeded
     state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
    :vartype state_description: str
    :ivar tasks: The tasks.
    :vartype tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    :ivar errors: The errors.
    :vartype errors: list[~azure.mgmt.recoveryservicessiterecovery.models.JobErrorDetails]
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar allowed_actions: The Allowed action the job.
    :vartype allowed_actions: list[str]
    :ivar target_object_id: The affected Object Id.
    :vartype target_object_id: str
    :ivar target_object_name: The name of the affected object.
    :vartype target_object_name: str
    :ivar target_instance_type: The type of the affected object which is of
     Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType class.
    :vartype target_instance_type: str
    :ivar custom_details: The custom job details like test failover job details.
    :vartype custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.JobDetails
    """

    _attribute_map = {
        "activity_id": {"key": "activityId", "type": "str"},
        "scenario_name": {"key": "scenarioName", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_description": {"key": "stateDescription", "type": "str"},
        "tasks": {"key": "tasks", "type": "[ASRTask]"},
        "errors": {"key": "errors", "type": "[JobErrorDetails]"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "allowed_actions": {"key": "allowedActions", "type": "[str]"},
        "target_object_id": {"key": "targetObjectId", "type": "str"},
        "target_object_name": {"key": "targetObjectName", "type": "str"},
        "target_instance_type": {"key": "targetInstanceType", "type": "str"},
        "custom_details": {"key": "customDetails", "type": "JobDetails"},
    }

    def __init__(
        self,
        *,
        activity_id: Optional[str] = None,
        scenario_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        state: Optional[str] = None,
        state_description: Optional[str] = None,
        tasks: Optional[List["_models.ASRTask"]] = None,
        errors: Optional[List["_models.JobErrorDetails"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        allowed_actions: Optional[List[str]] = None,
        target_object_id: Optional[str] = None,
        target_object_name: Optional[str] = None,
        target_instance_type: Optional[str] = None,
        custom_details: Optional["_models.JobDetails"] = None,
        **kwargs
    ):
        """
        :keyword activity_id: The activity id.
        :paramtype activity_id: str
        :keyword scenario_name: The ScenarioName.
        :paramtype scenario_name: str
        :keyword friendly_name: The DisplayName.
        :paramtype friendly_name: str
        :keyword state: The status of the Job. It is one of these values - NotStarted, InProgress,
         Succeeded, Failed, Cancelled, Suspended or Other.
        :paramtype state: str
        :keyword state_description: The description of the state of the Job. For e.g. - For Succeeded
         state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
        :paramtype state_description: str
        :keyword tasks: The tasks.
        :paramtype tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
        :keyword errors: The errors.
        :paramtype errors: list[~azure.mgmt.recoveryservicessiterecovery.models.JobErrorDetails]
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword allowed_actions: The Allowed action the job.
        :paramtype allowed_actions: list[str]
        :keyword target_object_id: The affected Object Id.
        :paramtype target_object_id: str
        :keyword target_object_name: The name of the affected object.
        :paramtype target_object_name: str
        :keyword target_instance_type: The type of the affected object which is of
         Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType class.
        :paramtype target_instance_type: str
        :keyword custom_details: The custom job details like test failover job details.
        :paramtype custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.JobDetails
        """
        super().__init__(**kwargs)
        self.activity_id = activity_id
        self.scenario_name = scenario_name
        self.friendly_name = friendly_name
        self.state = state
        self.state_description = state_description
        self.tasks = tasks
        self.errors = errors
        self.start_time = start_time
        self.end_time = end_time
        self.allowed_actions = allowed_actions
        self.target_object_id = target_object_id
        self.target_object_name = target_object_name
        self.target_instance_type = target_instance_type
        self.custom_details = custom_details


class JobQueryParameter(_serialization.Model):
    """Query parameter to enumerate jobs.

    :ivar start_time: Date time to get jobs from.
    :vartype start_time: str
    :ivar end_time: Date time to get jobs upto.
    :vartype end_time: str
    :ivar fabric_id: The Id of the fabric to search jobs under.
    :vartype fabric_id: str
    :ivar affected_object_types: The type of objects.
    :vartype affected_object_types: str
    :ivar job_status: The states of the job to be filtered can be in.
    :vartype job_status: str
    :ivar job_output_type: The output type of the jobs. Known values are: "Json", "Xml", and
     "Excel".
    :vartype job_output_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.ExportJobOutputSerializationType
    :ivar job_name: The job Name.
    :vartype job_name: str
    :ivar timezone_offset: The timezone offset for the location of the request (in minutes).
    :vartype timezone_offset: float
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "fabric_id": {"key": "fabricId", "type": "str"},
        "affected_object_types": {"key": "affectedObjectTypes", "type": "str"},
        "job_status": {"key": "jobStatus", "type": "str"},
        "job_output_type": {"key": "jobOutputType", "type": "str"},
        "job_name": {"key": "jobName", "type": "str"},
        "timezone_offset": {"key": "timezoneOffset", "type": "float"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        fabric_id: Optional[str] = None,
        affected_object_types: Optional[str] = None,
        job_status: Optional[str] = None,
        job_output_type: Optional[Union[str, "_models.ExportJobOutputSerializationType"]] = None,
        job_name: Optional[str] = None,
        timezone_offset: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword start_time: Date time to get jobs from.
        :paramtype start_time: str
        :keyword end_time: Date time to get jobs upto.
        :paramtype end_time: str
        :keyword fabric_id: The Id of the fabric to search jobs under.
        :paramtype fabric_id: str
        :keyword affected_object_types: The type of objects.
        :paramtype affected_object_types: str
        :keyword job_status: The states of the job to be filtered can be in.
        :paramtype job_status: str
        :keyword job_output_type: The output type of the jobs. Known values are: "Json", "Xml", and
         "Excel".
        :paramtype job_output_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.ExportJobOutputSerializationType
        :keyword job_name: The job Name.
        :paramtype job_name: str
        :keyword timezone_offset: The timezone offset for the location of the request (in minutes).
        :paramtype timezone_offset: float
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.fabric_id = fabric_id
        self.affected_object_types = affected_object_types
        self.job_status = job_status
        self.job_output_type = job_output_type
        self.job_name = job_name
        self.timezone_offset = timezone_offset


class JobStatusEventDetails(EventSpecificDetails):
    """Model class for event details of a job status event.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the class type. Overridden in derived classes. Required.
    :vartype instance_type: str
    :ivar job_id: Job arm id for the event.
    :vartype job_id: str
    :ivar job_friendly_name: JobName for the Event.
    :vartype job_friendly_name: str
    :ivar job_status: JobStatus for the Event.
    :vartype job_status: str
    :ivar affected_object_type: AffectedObjectType for the event.
    :vartype affected_object_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "job_friendly_name": {"key": "jobFriendlyName", "type": "str"},
        "job_status": {"key": "jobStatus", "type": "str"},
        "affected_object_type": {"key": "affectedObjectType", "type": "str"},
    }

    def __init__(
        self,
        *,
        job_id: Optional[str] = None,
        job_friendly_name: Optional[str] = None,
        job_status: Optional[str] = None,
        affected_object_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword job_id: Job arm id for the event.
        :paramtype job_id: str
        :keyword job_friendly_name: JobName for the Event.
        :paramtype job_friendly_name: str
        :keyword job_status: JobStatus for the Event.
        :paramtype job_status: str
        :keyword affected_object_type: AffectedObjectType for the event.
        :paramtype affected_object_type: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "JobStatus"
        self.job_id = job_id
        self.job_friendly_name = job_friendly_name
        self.job_status = job_status
        self.affected_object_type = affected_object_type


class KeyEncryptionKeyInfo(_serialization.Model):
    """Key Encryption Key (KEK) information.

    :ivar key_identifier: The key URL / identifier.
    :vartype key_identifier: str
    :ivar key_vault_resource_arm_id: The KeyVault resource ARM Id for key.
    :vartype key_vault_resource_arm_id: str
    """

    _attribute_map = {
        "key_identifier": {"key": "keyIdentifier", "type": "str"},
        "key_vault_resource_arm_id": {"key": "keyVaultResourceArmId", "type": "str"},
    }

    def __init__(
        self, *, key_identifier: Optional[str] = None, key_vault_resource_arm_id: Optional[str] = None, **kwargs
    ):
        """
        :keyword key_identifier: The key URL / identifier.
        :paramtype key_identifier: str
        :keyword key_vault_resource_arm_id: The KeyVault resource ARM Id for key.
        :paramtype key_vault_resource_arm_id: str
        """
        super().__init__(**kwargs)
        self.key_identifier = key_identifier
        self.key_vault_resource_arm_id = key_vault_resource_arm_id


class LogicalNetwork(Resource):
    """Logical network data model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The Logical Network Properties.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.LogicalNetworkProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "LogicalNetworkProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.LogicalNetworkProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The Logical Network Properties.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.LogicalNetworkProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class LogicalNetworkCollection(_serialization.Model):
    """List of logical networks.

    :ivar value: The Logical Networks list details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.LogicalNetwork]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LogicalNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.LogicalNetwork"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The Logical Networks list details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.LogicalNetwork]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogicalNetworkProperties(_serialization.Model):
    """Logical Network Properties.

    :ivar friendly_name: The Friendly Name.
    :vartype friendly_name: str
    :ivar network_virtualization_status: A value indicating whether Network Virtualization is
     enabled for the logical network.
    :vartype network_virtualization_status: str
    :ivar logical_network_usage: A value indicating whether logical network is used as private test
     network by test failover.
    :vartype logical_network_usage: str
    :ivar logical_network_definitions_status: A value indicating whether logical network
     definitions are isolated.
    :vartype logical_network_definitions_status: str
    """

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "network_virtualization_status": {"key": "networkVirtualizationStatus", "type": "str"},
        "logical_network_usage": {"key": "logicalNetworkUsage", "type": "str"},
        "logical_network_definitions_status": {"key": "logicalNetworkDefinitionsStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        network_virtualization_status: Optional[str] = None,
        logical_network_usage: Optional[str] = None,
        logical_network_definitions_status: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword friendly_name: The Friendly Name.
        :paramtype friendly_name: str
        :keyword network_virtualization_status: A value indicating whether Network Virtualization is
         enabled for the logical network.
        :paramtype network_virtualization_status: str
        :keyword logical_network_usage: A value indicating whether logical network is used as private
         test network by test failover.
        :paramtype logical_network_usage: str
        :keyword logical_network_definitions_status: A value indicating whether logical network
         definitions are isolated.
        :paramtype logical_network_definitions_status: str
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.network_virtualization_status = network_virtualization_status
        self.logical_network_usage = logical_network_usage
        self.logical_network_definitions_status = logical_network_definitions_status


class ManualActionTaskDetails(TaskTypeDetails):
    """This class represents the manual action task details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar name: The name.
    :vartype name: str
    :ivar instructions: The instructions.
    :vartype instructions: str
    :ivar observation: The observation.
    :vartype observation: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "instructions": {"key": "instructions", "type": "str"},
        "observation": {"key": "observation", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        instructions: Optional[str] = None,
        observation: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name.
        :paramtype name: str
        :keyword instructions: The instructions.
        :paramtype instructions: str
        :keyword observation: The observation.
        :paramtype observation: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "ManualActionTaskDetails"
        self.name = name
        self.instructions = instructions
        self.observation = observation


class MarsAgentDetails(_serialization.Model):
    """Mars agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Mars agent Id.
    :vartype id: str
    :ivar name: The Mars agent name.
    :vartype name: str
    :ivar bios_id: The Mars agent Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The Mars agent Fqdn.
    :vartype fqdn: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the Mars agent.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health of the Mars agent. Known values are: "None", "Normal", "Warning", and
     "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "bios_id": {"readonly": True},
        "fabric_object_id": {"readonly": True},
        "fqdn": {"readonly": True},
        "version": {"readonly": True},
        "last_heartbeat_utc": {"readonly": True},
        "health": {"readonly": True},
        "health_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "last_heartbeat_utc": {"key": "lastHeartbeatUtc", "type": "iso-8601"},
        "health": {"key": "health", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None


class MasterTargetServer(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Details of a Master Target Server.

    :ivar id: The server Id.
    :vartype id: str
    :ivar ip_address: The IP address of the server.
    :vartype ip_address: str
    :ivar name: The server name.
    :vartype name: str
    :ivar os_type: The OS type of the server.
    :vartype os_type: str
    :ivar agent_version: The version of the scout component on the server.
    :vartype agent_version: str
    :ivar last_heartbeat: The last heartbeat received from the server.
    :vartype last_heartbeat: ~datetime.datetime
    :ivar version_status: Version status.
    :vartype version_status: str
    :ivar retention_volumes: The retention volumes of Master target Server.
    :vartype retention_volumes:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RetentionVolume]
    :ivar data_stores: The list of data stores in the fabric.
    :vartype data_stores: list[~azure.mgmt.recoveryservicessiterecovery.models.DataStore]
    :ivar validation_errors: Validation errors.
    :vartype validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar health_errors: Health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar disk_count: Disk count of the master target.
    :vartype disk_count: int
    :ivar os_version: OS Version of the master target.
    :vartype os_version: str
    :ivar agent_expiry_date: Agent expiry date.
    :vartype agent_expiry_date: ~datetime.datetime
    :ivar mars_agent_version: MARS agent version.
    :vartype mars_agent_version: str
    :ivar mars_agent_expiry_date: MARS agent expiry date.
    :vartype mars_agent_expiry_date: ~datetime.datetime
    :ivar agent_version_details: Agent version details.
    :vartype agent_version_details: ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
    :ivar mars_agent_version_details: Mars agent version details.
    :vartype mars_agent_version_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "agent_version": {"key": "agentVersion", "type": "str"},
        "last_heartbeat": {"key": "lastHeartbeat", "type": "iso-8601"},
        "version_status": {"key": "versionStatus", "type": "str"},
        "retention_volumes": {"key": "retentionVolumes", "type": "[RetentionVolume]"},
        "data_stores": {"key": "dataStores", "type": "[DataStore]"},
        "validation_errors": {"key": "validationErrors", "type": "[HealthError]"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
        "disk_count": {"key": "diskCount", "type": "int"},
        "os_version": {"key": "osVersion", "type": "str"},
        "agent_expiry_date": {"key": "agentExpiryDate", "type": "iso-8601"},
        "mars_agent_version": {"key": "marsAgentVersion", "type": "str"},
        "mars_agent_expiry_date": {"key": "marsAgentExpiryDate", "type": "iso-8601"},
        "agent_version_details": {"key": "agentVersionDetails", "type": "VersionDetails"},
        "mars_agent_version_details": {"key": "marsAgentVersionDetails", "type": "VersionDetails"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        ip_address: Optional[str] = None,
        name: Optional[str] = None,
        os_type: Optional[str] = None,
        agent_version: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        version_status: Optional[str] = None,
        retention_volumes: Optional[List["_models.RetentionVolume"]] = None,
        data_stores: Optional[List["_models.DataStore"]] = None,
        validation_errors: Optional[List["_models.HealthError"]] = None,
        health_errors: Optional[List["_models.HealthError"]] = None,
        disk_count: Optional[int] = None,
        os_version: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        mars_agent_version: Optional[str] = None,
        mars_agent_expiry_date: Optional[datetime.datetime] = None,
        agent_version_details: Optional["_models.VersionDetails"] = None,
        mars_agent_version_details: Optional["_models.VersionDetails"] = None,
        **kwargs
    ):
        """
        :keyword id: The server Id.
        :paramtype id: str
        :keyword ip_address: The IP address of the server.
        :paramtype ip_address: str
        :keyword name: The server name.
        :paramtype name: str
        :keyword os_type: The OS type of the server.
        :paramtype os_type: str
        :keyword agent_version: The version of the scout component on the server.
        :paramtype agent_version: str
        :keyword last_heartbeat: The last heartbeat received from the server.
        :paramtype last_heartbeat: ~datetime.datetime
        :keyword version_status: Version status.
        :paramtype version_status: str
        :keyword retention_volumes: The retention volumes of Master target Server.
        :paramtype retention_volumes:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RetentionVolume]
        :keyword data_stores: The list of data stores in the fabric.
        :paramtype data_stores: list[~azure.mgmt.recoveryservicessiterecovery.models.DataStore]
        :keyword validation_errors: Validation errors.
        :paramtype validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
        :keyword health_errors: Health errors.
        :paramtype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
        :keyword disk_count: Disk count of the master target.
        :paramtype disk_count: int
        :keyword os_version: OS Version of the master target.
        :paramtype os_version: str
        :keyword agent_expiry_date: Agent expiry date.
        :paramtype agent_expiry_date: ~datetime.datetime
        :keyword mars_agent_version: MARS agent version.
        :paramtype mars_agent_version: str
        :keyword mars_agent_expiry_date: MARS agent expiry date.
        :paramtype mars_agent_expiry_date: ~datetime.datetime
        :keyword agent_version_details: Agent version details.
        :paramtype agent_version_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
        :keyword mars_agent_version_details: Mars agent version details.
        :paramtype mars_agent_version_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
        """
        super().__init__(**kwargs)
        self.id = id
        self.ip_address = ip_address
        self.name = name
        self.os_type = os_type
        self.agent_version = agent_version
        self.last_heartbeat = last_heartbeat
        self.version_status = version_status
        self.retention_volumes = retention_volumes
        self.data_stores = data_stores
        self.validation_errors = validation_errors
        self.health_errors = health_errors
        self.disk_count = disk_count
        self.os_version = os_version
        self.agent_expiry_date = agent_expiry_date
        self.mars_agent_version = mars_agent_version
        self.mars_agent_expiry_date = mars_agent_expiry_date
        self.agent_version_details = agent_version_details
        self.mars_agent_version_details = mars_agent_version_details


class MigrateInput(_serialization.Model):
    """Input for migrate.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Migrate input properties. Required.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.MigrateInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "MigrateInputProperties"},
    }

    def __init__(self, *, properties: "_models.MigrateInputProperties", **kwargs):
        """
        :keyword properties: Migrate input properties. Required.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.MigrateInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class MigrateInputProperties(_serialization.Model):
    """Migrate input properties.

    All required parameters must be populated in order to send to Azure.

    :ivar provider_specific_details: The provider specific details. Required.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrateProviderSpecificInput
    """

    _validation = {
        "provider_specific_details": {"required": True},
    }

    _attribute_map = {
        "provider_specific_details": {"key": "providerSpecificDetails", "type": "MigrateProviderSpecificInput"},
    }

    def __init__(self, *, provider_specific_details: "_models.MigrateProviderSpecificInput", **kwargs):
        """
        :keyword provider_specific_details: The provider specific details. Required.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.MigrateProviderSpecificInput
        """
        super().__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class MigrateProviderSpecificInput(_serialization.Model):
    """Migrate provider specific input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VMwareCbtMigrateInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"VMwareCbt": "VMwareCbtMigrateInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class MigrationItem(Resource):
    """Migration item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The migration item properties.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.MigrationItemProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "MigrationItemProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.MigrationItemProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The migration item properties.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.MigrationItemProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class MigrationItemCollection(_serialization.Model):
    """Migration item collection.

    :ivar value: The list of migration items.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.MigrationItem]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MigrationItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.MigrationItem"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of migration items.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.MigrationItem]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MigrationItemProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Migration item properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar machine_name: The on-premise virtual machine name.
    :vartype machine_name: str
    :ivar policy_id: The ARM Id of policy governing this item.
    :vartype policy_id: str
    :ivar policy_friendly_name: The name of policy governing this item.
    :vartype policy_friendly_name: str
    :ivar recovery_services_provider_id: The recovery services provider ARM Id.
    :vartype recovery_services_provider_id: str
    :ivar replication_status: The replication status.
    :vartype replication_status: str
    :ivar migration_state: The migration status. Known values are: "None",
     "EnableMigrationInProgress", "EnableMigrationFailed", "DisableMigrationInProgress",
     "DisableMigrationFailed", "InitialSeedingInProgress", "InitialSeedingFailed", "Replicating",
     "MigrationInProgress", "MigrationSucceeded", "MigrationFailed", "ResumeInProgress",
     "ResumeInitiated", "SuspendingProtection", "ProtectionSuspended",
     "MigrationCompletedWithInformation", and "MigrationPartiallySucceeded".
    :vartype migration_state: str or ~azure.mgmt.recoveryservicessiterecovery.models.MigrationState
    :ivar migration_state_description: The migration state description.
    :vartype migration_state_description: str
    :ivar last_test_migration_time: The last test migration time.
    :vartype last_test_migration_time: ~datetime.datetime
    :ivar last_test_migration_status: The status of the last test migration.
    :vartype last_test_migration_status: str
    :ivar last_migration_time: The last migration time.
    :vartype last_migration_time: ~datetime.datetime
    :ivar last_migration_status: The status of the last migration.
    :vartype last_migration_status: str
    :ivar test_migrate_state: The test migrate state. Known values are: "None",
     "TestMigrationInProgress", "TestMigrationSucceeded", "TestMigrationFailed",
     "TestMigrationCleanupInProgress", "TestMigrationCompletedWithInformation", and
     "TestMigrationPartiallySucceeded".
    :vartype test_migrate_state: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.TestMigrationState
    :ivar test_migrate_state_description: The test migrate state description.
    :vartype test_migrate_state_description: str
    :ivar health: The consolidated health. Known values are: "None", "Normal", "Warning", and
     "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The list of health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar allowed_operations: The allowed operations on the migration item based on the current
     migration state of the item.
    :vartype allowed_operations: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrationItemOperation]
    :ivar current_job: The current job details.
    :vartype current_job: ~azure.mgmt.recoveryservicessiterecovery.models.CurrentJobDetails
    :ivar critical_job_history: The critical past job details.
    :vartype critical_job_history:
     list[~azure.mgmt.recoveryservicessiterecovery.models.CriticalJobHistoryDetails]
    :ivar event_correlation_id: The correlation Id for events associated with this migration item.
    :vartype event_correlation_id: str
    :ivar provider_specific_details: The migration provider custom settings.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrationProviderSpecificSettings
    """

    _validation = {
        "machine_name": {"readonly": True},
        "policy_id": {"readonly": True},
        "policy_friendly_name": {"readonly": True},
        "recovery_services_provider_id": {"readonly": True},
        "replication_status": {"readonly": True},
        "migration_state": {"readonly": True},
        "migration_state_description": {"readonly": True},
        "last_test_migration_time": {"readonly": True},
        "last_test_migration_status": {"readonly": True},
        "last_migration_time": {"readonly": True},
        "last_migration_status": {"readonly": True},
        "test_migrate_state": {"readonly": True},
        "test_migrate_state_description": {"readonly": True},
        "health": {"readonly": True},
        "health_errors": {"readonly": True},
        "allowed_operations": {"readonly": True},
        "current_job": {"readonly": True},
        "critical_job_history": {"readonly": True},
        "event_correlation_id": {"readonly": True},
    }

    _attribute_map = {
        "machine_name": {"key": "machineName", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "policy_friendly_name": {"key": "policyFriendlyName", "type": "str"},
        "recovery_services_provider_id": {"key": "recoveryServicesProviderId", "type": "str"},
        "replication_status": {"key": "replicationStatus", "type": "str"},
        "migration_state": {"key": "migrationState", "type": "str"},
        "migration_state_description": {"key": "migrationStateDescription", "type": "str"},
        "last_test_migration_time": {"key": "lastTestMigrationTime", "type": "iso-8601"},
        "last_test_migration_status": {"key": "lastTestMigrationStatus", "type": "str"},
        "last_migration_time": {"key": "lastMigrationTime", "type": "iso-8601"},
        "last_migration_status": {"key": "lastMigrationStatus", "type": "str"},
        "test_migrate_state": {"key": "testMigrateState", "type": "str"},
        "test_migrate_state_description": {"key": "testMigrateStateDescription", "type": "str"},
        "health": {"key": "health", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
        "allowed_operations": {"key": "allowedOperations", "type": "[str]"},
        "current_job": {"key": "currentJob", "type": "CurrentJobDetails"},
        "critical_job_history": {"key": "criticalJobHistory", "type": "[CriticalJobHistoryDetails]"},
        "event_correlation_id": {"key": "eventCorrelationId", "type": "str"},
        "provider_specific_details": {"key": "providerSpecificDetails", "type": "MigrationProviderSpecificSettings"},
    }

    def __init__(
        self, *, provider_specific_details: Optional["_models.MigrationProviderSpecificSettings"] = None, **kwargs
    ):
        """
        :keyword provider_specific_details: The migration provider custom settings.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.MigrationProviderSpecificSettings
        """
        super().__init__(**kwargs)
        self.machine_name = None
        self.policy_id = None
        self.policy_friendly_name = None
        self.recovery_services_provider_id = None
        self.replication_status = None
        self.migration_state = None
        self.migration_state_description = None
        self.last_test_migration_time = None
        self.last_test_migration_status = None
        self.last_migration_time = None
        self.last_migration_status = None
        self.test_migrate_state = None
        self.test_migrate_state_description = None
        self.health = None
        self.health_errors = None
        self.allowed_operations = None
        self.current_job = None
        self.critical_job_history = None
        self.event_correlation_id = None
        self.provider_specific_details = provider_specific_details


class MigrationItemsQueryParameter(_serialization.Model):
    """Query parameter to enumerate migration items.

    :ivar source_fabric_name: The source fabric name filter.
    :vartype source_fabric_name: str
    :ivar source_container_name: The source container name filter.
    :vartype source_container_name: str
    :ivar instance_type: The replication provider type.
    :vartype instance_type: str
    """

    _attribute_map = {
        "source_fabric_name": {"key": "sourceFabricName", "type": "str"},
        "source_container_name": {"key": "sourceContainerName", "type": "str"},
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_fabric_name: Optional[str] = None,
        source_container_name: Optional[str] = None,
        instance_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_fabric_name: The source fabric name filter.
        :paramtype source_fabric_name: str
        :keyword source_container_name: The source container name filter.
        :paramtype source_container_name: str
        :keyword instance_type: The replication provider type.
        :paramtype instance_type: str
        """
        super().__init__(**kwargs)
        self.source_fabric_name = source_fabric_name
        self.source_container_name = source_container_name
        self.instance_type = instance_type


class MigrationProviderSpecificSettings(_serialization.Model):
    """Migration provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VMwareCbtMigrationDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"VMwareCbt": "VMwareCbtMigrationDetails"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class MigrationRecoveryPoint(Resource):
    """Recovery point for a migration item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: Recovery point properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrationRecoveryPointProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "MigrationRecoveryPointProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.MigrationRecoveryPointProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: Recovery point properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.MigrationRecoveryPointProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class MigrationRecoveryPointCollection(_serialization.Model):
    """Collection of migration recovery points.

    :ivar value: The migration recovery point details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.MigrationRecoveryPoint]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MigrationRecoveryPoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.MigrationRecoveryPoint"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The migration recovery point details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.MigrationRecoveryPoint]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MigrationRecoveryPointProperties(_serialization.Model):
    """Migration item recovery point properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recovery_point_time: The recovery point time.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_type: The recovery point type. Known values are: "NotSpecified",
     "ApplicationConsistent", and "CrashConsistent".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrationRecoveryPointType
    """

    _validation = {
        "recovery_point_time": {"readonly": True},
        "recovery_point_type": {"readonly": True},
    }

    _attribute_map = {
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.recovery_point_time = None
        self.recovery_point_type = None


class MobilityServiceUpdate(_serialization.Model):
    """The Mobility Service update details.

    :ivar version: The version of the latest update.
    :vartype version: str
    :ivar reboot_status: The reboot status of the update - whether it is required or not.
    :vartype reboot_status: str
    :ivar os_type: The OS type.
    :vartype os_type: str
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "reboot_status": {"key": "rebootStatus", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        reboot_status: Optional[str] = None,
        os_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword version: The version of the latest update.
        :paramtype version: str
        :keyword reboot_status: The reboot status of the update - whether it is required or not.
        :paramtype reboot_status: str
        :keyword os_type: The OS type.
        :paramtype os_type: str
        """
        super().__init__(**kwargs)
        self.version = version
        self.reboot_status = reboot_status
        self.os_type = os_type


class Network(Resource):
    """Network model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The Network Properties.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.NetworkProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "NetworkProperties"},
    }

    def __init__(
        self, *, location: Optional[str] = None, properties: Optional["_models.NetworkProperties"] = None, **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The Network Properties.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.NetworkProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class NetworkCollection(_serialization.Model):
    """List of networks.

    :ivar value: The Networks list details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Network]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Network]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Network"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The Networks list details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Network]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkMapping(Resource):
    """Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The Network Mapping Properties.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.NetworkMappingProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "NetworkMappingProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.NetworkMappingProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The Network Mapping Properties.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.NetworkMappingProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class NetworkMappingCollection(_serialization.Model):
    """List of network mappings. As with NetworkMapping, it should be possible to reuse a prev version of this class. It doesn't seem likely this class could be anything more than a slightly bespoke collection of NetworkMapping. Hence it makes sense to override Load with Base.NetworkMapping instead of existing CurrentVersion.NetworkMapping.

    :ivar value: The Network Mappings list.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.NetworkMapping]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkMapping]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkMapping"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The Network Mappings list.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.NetworkMapping]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkMappingProperties(_serialization.Model):
    """Network Mapping Properties.

    :ivar state: The pairing state for network mapping.
    :vartype state: str
    :ivar primary_network_friendly_name: The primary network friendly name.
    :vartype primary_network_friendly_name: str
    :ivar primary_network_id: The primary network id for network mapping.
    :vartype primary_network_id: str
    :ivar primary_fabric_friendly_name: The primary fabric friendly name.
    :vartype primary_fabric_friendly_name: str
    :ivar recovery_network_friendly_name: The recovery network friendly name.
    :vartype recovery_network_friendly_name: str
    :ivar recovery_network_id: The recovery network id for network mapping.
    :vartype recovery_network_id: str
    :ivar recovery_fabric_arm_id: The recovery fabric ARM id.
    :vartype recovery_fabric_arm_id: str
    :ivar recovery_fabric_friendly_name: The recovery fabric friendly name.
    :vartype recovery_fabric_friendly_name: str
    :ivar fabric_specific_settings: The fabric specific settings.
    :vartype fabric_specific_settings:
     ~azure.mgmt.recoveryservicessiterecovery.models.NetworkMappingFabricSpecificSettings
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "primary_network_friendly_name": {"key": "primaryNetworkFriendlyName", "type": "str"},
        "primary_network_id": {"key": "primaryNetworkId", "type": "str"},
        "primary_fabric_friendly_name": {"key": "primaryFabricFriendlyName", "type": "str"},
        "recovery_network_friendly_name": {"key": "recoveryNetworkFriendlyName", "type": "str"},
        "recovery_network_id": {"key": "recoveryNetworkId", "type": "str"},
        "recovery_fabric_arm_id": {"key": "recoveryFabricArmId", "type": "str"},
        "recovery_fabric_friendly_name": {"key": "recoveryFabricFriendlyName", "type": "str"},
        "fabric_specific_settings": {"key": "fabricSpecificSettings", "type": "NetworkMappingFabricSpecificSettings"},
    }

    def __init__(
        self,
        *,
        state: Optional[str] = None,
        primary_network_friendly_name: Optional[str] = None,
        primary_network_id: Optional[str] = None,
        primary_fabric_friendly_name: Optional[str] = None,
        recovery_network_friendly_name: Optional[str] = None,
        recovery_network_id: Optional[str] = None,
        recovery_fabric_arm_id: Optional[str] = None,
        recovery_fabric_friendly_name: Optional[str] = None,
        fabric_specific_settings: Optional["_models.NetworkMappingFabricSpecificSettings"] = None,
        **kwargs
    ):
        """
        :keyword state: The pairing state for network mapping.
        :paramtype state: str
        :keyword primary_network_friendly_name: The primary network friendly name.
        :paramtype primary_network_friendly_name: str
        :keyword primary_network_id: The primary network id for network mapping.
        :paramtype primary_network_id: str
        :keyword primary_fabric_friendly_name: The primary fabric friendly name.
        :paramtype primary_fabric_friendly_name: str
        :keyword recovery_network_friendly_name: The recovery network friendly name.
        :paramtype recovery_network_friendly_name: str
        :keyword recovery_network_id: The recovery network id for network mapping.
        :paramtype recovery_network_id: str
        :keyword recovery_fabric_arm_id: The recovery fabric ARM id.
        :paramtype recovery_fabric_arm_id: str
        :keyword recovery_fabric_friendly_name: The recovery fabric friendly name.
        :paramtype recovery_fabric_friendly_name: str
        :keyword fabric_specific_settings: The fabric specific settings.
        :paramtype fabric_specific_settings:
         ~azure.mgmt.recoveryservicessiterecovery.models.NetworkMappingFabricSpecificSettings
        """
        super().__init__(**kwargs)
        self.state = state
        self.primary_network_friendly_name = primary_network_friendly_name
        self.primary_network_id = primary_network_id
        self.primary_fabric_friendly_name = primary_fabric_friendly_name
        self.recovery_network_friendly_name = recovery_network_friendly_name
        self.recovery_network_id = recovery_network_id
        self.recovery_fabric_arm_id = recovery_fabric_arm_id
        self.recovery_fabric_friendly_name = recovery_fabric_friendly_name
        self.fabric_specific_settings = fabric_specific_settings


class NetworkProperties(_serialization.Model):
    """Network Properties.

    :ivar fabric_type: The Fabric Type.
    :vartype fabric_type: str
    :ivar subnets: The List of subnets.
    :vartype subnets: list[~azure.mgmt.recoveryservicessiterecovery.models.Subnet]
    :ivar friendly_name: The Friendly Name.
    :vartype friendly_name: str
    :ivar network_type: The Network Type.
    :vartype network_type: str
    """

    _attribute_map = {
        "fabric_type": {"key": "fabricType", "type": "str"},
        "subnets": {"key": "subnets", "type": "[Subnet]"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "network_type": {"key": "networkType", "type": "str"},
    }

    def __init__(
        self,
        *,
        fabric_type: Optional[str] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        friendly_name: Optional[str] = None,
        network_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword fabric_type: The Fabric Type.
        :paramtype fabric_type: str
        :keyword subnets: The List of subnets.
        :paramtype subnets: list[~azure.mgmt.recoveryservicessiterecovery.models.Subnet]
        :keyword friendly_name: The Friendly Name.
        :paramtype friendly_name: str
        :keyword network_type: The Network Type.
        :paramtype network_type: str
        """
        super().__init__(**kwargs)
        self.fabric_type = fabric_type
        self.subnets = subnets
        self.friendly_name = friendly_name
        self.network_type = network_type


class NewProtectionProfile(ProtectionProfileCustomDetails):
    """New Protection profile input.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    :ivar policy_name: The protection profile input. Required.
    :vartype policy_name: str
    :ivar recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :vartype recovery_point_history: int
    :ivar crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :vartype crash_consistent_frequency_in_minutes: int
    :ivar app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :vartype app_consistent_frequency_in_minutes: int
    :ivar multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled. Value
     should be 'Enabled' or 'Disabled'. Required. Known values are: "Enable" and "Disable".
    :vartype multi_vm_sync_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
    """

    _validation = {
        "resource_type": {"required": True},
        "policy_name": {"required": True},
        "multi_vm_sync_status": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "recovery_point_history": {"key": "recoveryPointHistory", "type": "int"},
        "crash_consistent_frequency_in_minutes": {"key": "crashConsistentFrequencyInMinutes", "type": "int"},
        "app_consistent_frequency_in_minutes": {"key": "appConsistentFrequencyInMinutes", "type": "int"},
        "multi_vm_sync_status": {"key": "multiVmSyncStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        policy_name: str,
        multi_vm_sync_status: Union[str, "_models.SetMultiVmSyncStatus"],
        recovery_point_history: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword policy_name: The protection profile input. Required.
        :paramtype policy_name: str
        :keyword recovery_point_history: The duration in minutes until which the recovery points need
         to be stored.
        :paramtype recovery_point_history: int
        :keyword crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
         minutes).
        :paramtype crash_consistent_frequency_in_minutes: int
        :keyword app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in
         minutes).
        :paramtype app_consistent_frequency_in_minutes: int
        :keyword multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
         Value should be 'Enabled' or 'Disabled'. Required. Known values are: "Enable" and "Disable".
        :paramtype multi_vm_sync_status: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
        """
        super().__init__(**kwargs)
        self.resource_type: str = "New"
        self.policy_name = policy_name
        self.recovery_point_history = recovery_point_history
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class NewRecoveryVirtualNetwork(RecoveryVirtualNetworkCustomDetails):
    """Recovery virtual network input to create new virtual network from given source network.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The class type. Required.
    :vartype resource_type: str
    :ivar recovery_virtual_network_resource_group_name: The name of the resource group to be used
     to create the recovery virtual network. If absent, target network would be created in the same
     resource group as target VM.
    :vartype recovery_virtual_network_resource_group_name: str
    :ivar recovery_virtual_network_name: The recovery virtual network name.
    :vartype recovery_virtual_network_name: str
    """

    _validation = {
        "resource_type": {"required": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "recovery_virtual_network_resource_group_name": {
            "key": "recoveryVirtualNetworkResourceGroupName",
            "type": "str",
        },
        "recovery_virtual_network_name": {"key": "recoveryVirtualNetworkName", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_virtual_network_resource_group_name: Optional[str] = None,
        recovery_virtual_network_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_virtual_network_resource_group_name: The name of the resource group to be
         used to create the recovery virtual network. If absent, target network would be created in the
         same resource group as target VM.
        :paramtype recovery_virtual_network_resource_group_name: str
        :keyword recovery_virtual_network_name: The recovery virtual network name.
        :paramtype recovery_virtual_network_name: str
        """
        super().__init__(**kwargs)
        self.resource_type: str = "New"
        self.recovery_virtual_network_resource_group_name = recovery_virtual_network_resource_group_name
        self.recovery_virtual_network_name = recovery_virtual_network_name


class OperationsDiscovery(_serialization.Model):
    """Operations discovery class.

    :ivar name: Name of the API. The name of the operation being performed on this particular
     object. It should match the action name that appears in RBAC / the event service. Examples of
     operations include: * Microsoft.Compute/virtualMachine/capture/action *
     Microsoft.Compute/virtualMachine/restart/action * Microsoft.Compute/virtualMachine/write *
     Microsoft.Compute/virtualMachine/read * Microsoft.Compute/virtualMachine/delete Each action
     should include, in order: (1) Resource Provider Namespace (2) Type hierarchy for which the
     action applies (e.g. server/databases for a SQL Azure database) (3) Read, Write, Action or
     Delete indicating which type applies. If it is a PUT/PATCH on a collection or named value,
     Write should be used. If it is a GET, Read should be used. If it is a DELETE, Delete should be
     used. If it is a POST, Action should be used. As a note: all resource providers would need to
     include the "{Resource Provider Namespace}/register/action" operation in their response. This
     API is used to register for their service, and should include details about the operation (e.g.
     a localized name for the resource provider + any special considerations like PII release).
    :vartype name: str
    :ivar display: Object type.
    :vartype display: ~azure.mgmt.recoveryservicessiterecovery.models.Display
    :ivar origin: Origin. The intended executor of the operation; governs the display of the
     operation in the RBAC UX and the audit logs UX. Default value is "user,system".
    :vartype origin: str
    :ivar properties: Properties. Reserved for future use.
    :vartype properties: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "Display"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.Display"] = None,
        origin: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the API. The name of the operation being performed on this particular
         object. It should match the action name that appears in RBAC / the event service. Examples of
         operations include: * Microsoft.Compute/virtualMachine/capture/action *
         Microsoft.Compute/virtualMachine/restart/action * Microsoft.Compute/virtualMachine/write *
         Microsoft.Compute/virtualMachine/read * Microsoft.Compute/virtualMachine/delete Each action
         should include, in order: (1) Resource Provider Namespace (2) Type hierarchy for which the
         action applies (e.g. server/databases for a SQL Azure database) (3) Read, Write, Action or
         Delete indicating which type applies. If it is a PUT/PATCH on a collection or named value,
         Write should be used. If it is a GET, Read should be used. If it is a DELETE, Delete should be
         used. If it is a POST, Action should be used. As a note: all resource providers would need to
         include the "{Resource Provider Namespace}/register/action" operation in their response. This
         API is used to register for their service, and should include details about the operation (e.g.
         a localized name for the resource provider + any special considerations like PII release).
        :paramtype name: str
        :keyword display: Object type.
        :paramtype display: ~azure.mgmt.recoveryservicessiterecovery.models.Display
        :keyword origin: Origin. The intended executor of the operation; governs the display of the
         operation in the RBAC UX and the audit logs UX. Default value is "user,system".
        :paramtype origin: str
        :keyword properties: Properties. Reserved for future use.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationsDiscoveryCollection(_serialization.Model):
    """Collection of ClientDiscovery details.

    :ivar value: The ClientDiscovery details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.OperationsDiscovery]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationsDiscovery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationsDiscovery"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The ClientDiscovery details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.OperationsDiscovery]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSDetails(_serialization.Model):
    """Disk Details.

    :ivar os_type: VM Disk details.
    :vartype os_type: str
    :ivar product_type: Product type.
    :vartype product_type: str
    :ivar os_edition: The OSEdition.
    :vartype os_edition: str
    :ivar o_s_version: The OS Version.
    :vartype o_s_version: str
    :ivar o_s_major_version: The OS Major Version.
    :vartype o_s_major_version: str
    :ivar o_s_minor_version: The OS Minor Version.
    :vartype o_s_minor_version: str
    """

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "product_type": {"key": "productType", "type": "str"},
        "os_edition": {"key": "osEdition", "type": "str"},
        "o_s_version": {"key": "oSVersion", "type": "str"},
        "o_s_major_version": {"key": "oSMajorVersion", "type": "str"},
        "o_s_minor_version": {"key": "oSMinorVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_type: Optional[str] = None,
        product_type: Optional[str] = None,
        os_edition: Optional[str] = None,
        o_s_version: Optional[str] = None,
        o_s_major_version: Optional[str] = None,
        o_s_minor_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword os_type: VM Disk details.
        :paramtype os_type: str
        :keyword product_type: Product type.
        :paramtype product_type: str
        :keyword os_edition: The OSEdition.
        :paramtype os_edition: str
        :keyword o_s_version: The OS Version.
        :paramtype o_s_version: str
        :keyword o_s_major_version: The OS Major Version.
        :paramtype o_s_major_version: str
        :keyword o_s_minor_version: The OS Minor Version.
        :paramtype o_s_minor_version: str
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.product_type = product_type
        self.os_edition = os_edition
        self.o_s_version = o_s_version
        self.o_s_major_version = o_s_major_version
        self.o_s_minor_version = o_s_minor_version


class OSDiskDetails(_serialization.Model):
    """Details of the OS Disk.

    :ivar os_vhd_id: The id of the disk containing the OS.
    :vartype os_vhd_id: str
    :ivar os_type: The type of the OS on the VM.
    :vartype os_type: str
    :ivar vhd_name: The OS disk VHD name.
    :vartype vhd_name: str
    """

    _attribute_map = {
        "os_vhd_id": {"key": "osVhdId", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "vhd_name": {"key": "vhdName", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_vhd_id: Optional[str] = None,
        os_type: Optional[str] = None,
        vhd_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword os_vhd_id: The id of the disk containing the OS.
        :paramtype os_vhd_id: str
        :keyword os_type: The type of the OS on the VM.
        :paramtype os_type: str
        :keyword vhd_name: The OS disk VHD name.
        :paramtype vhd_name: str
        """
        super().__init__(**kwargs)
        self.os_vhd_id = os_vhd_id
        self.os_type = os_type
        self.vhd_name = vhd_name


class OSVersionWrapper(_serialization.Model):
    """Wrapper model for OSVersion to include version and service pack info.

    :ivar version: The version.
    :vartype version: str
    :ivar service_pack: The service pack.
    :vartype service_pack: str
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "service_pack": {"key": "servicePack", "type": "str"},
    }

    def __init__(self, *, version: Optional[str] = None, service_pack: Optional[str] = None, **kwargs):
        """
        :keyword version: The version.
        :paramtype version: str
        :keyword service_pack: The service pack.
        :paramtype service_pack: str
        """
        super().__init__(**kwargs)
        self.version = version
        self.service_pack = service_pack


class PauseReplicationInput(_serialization.Model):
    """Pause replication input.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Pause replication input properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.PauseReplicationInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "PauseReplicationInputProperties"},
    }

    def __init__(self, *, properties: "_models.PauseReplicationInputProperties", **kwargs):
        """
        :keyword properties: Pause replication input properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.PauseReplicationInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PauseReplicationInputProperties(_serialization.Model):
    """Pause replication input properties.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, *, instance_type: str, **kwargs):
        """
        :keyword instance_type: The class type. Required.
        :paramtype instance_type: str
        """
        super().__init__(**kwargs)
        self.instance_type = instance_type


class PlannedFailoverInput(_serialization.Model):
    """Input definition for planned failover.

    :ivar properties: Planned failover input properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverInputProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "PlannedFailoverInputProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PlannedFailoverInputProperties"] = None, **kwargs):
        """
        :keyword properties: Planned failover input properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PlannedFailoverInputProperties(_serialization.Model):
    """Input definition for planned failover input properties.

    :ivar failover_direction: Failover direction.
    :vartype failover_direction: str
    :ivar provider_specific_details: Provider specific settings.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverProviderSpecificFailoverInput
    """

    _attribute_map = {
        "failover_direction": {"key": "failoverDirection", "type": "str"},
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "PlannedFailoverProviderSpecificFailoverInput",
        },
    }

    def __init__(
        self,
        *,
        failover_direction: Optional[str] = None,
        provider_specific_details: Optional["_models.PlannedFailoverProviderSpecificFailoverInput"] = None,
        **kwargs
    ):
        """
        :keyword failover_direction: Failover direction.
        :paramtype failover_direction: str
        :keyword provider_specific_details: Provider specific settings.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverProviderSpecificFailoverInput
        """
        super().__init__(**kwargs)
        self.failover_direction = failover_direction
        self.provider_specific_details = provider_specific_details


class Policy(Resource):
    """Protection profile details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The custom data.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "PolicyProperties"},
    }

    def __init__(
        self, *, location: Optional[str] = None, properties: Optional["_models.PolicyProperties"] = None, **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The custom data.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class PolicyCollection(_serialization.Model):
    """Protection Profile Collection details.

    :ivar value: The policy details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Policy]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Policy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Policy"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The policy details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.Policy]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyProperties(_serialization.Model):
    """Protection profile custom data details.

    :ivar friendly_name: The FriendlyName.
    :vartype friendly_name: str
    :ivar provider_specific_details: The ReplicationChannelSetting.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProviderSpecificDetails
    """

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "provider_specific_details": {"key": "providerSpecificDetails", "type": "PolicyProviderSpecificDetails"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        provider_specific_details: Optional["_models.PolicyProviderSpecificDetails"] = None,
        **kwargs
    ):
        """
        :keyword friendly_name: The FriendlyName.
        :paramtype friendly_name: str
        :keyword provider_specific_details: The ReplicationChannelSetting.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProviderSpecificDetails
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.provider_specific_details = provider_specific_details


class ProcessServer(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Details of the Process Server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar friendly_name: The Process Server's friendly name.
    :vartype friendly_name: str
    :ivar id: The Process Server Id.
    :vartype id: str
    :ivar ip_address: The IP address of the server.
    :vartype ip_address: str
    :ivar os_type: The OS type of the server.
    :vartype os_type: str
    :ivar agent_version: The version of the scout component on the server.
    :vartype agent_version: str
    :ivar last_heartbeat: The last heartbeat received from the server.
    :vartype last_heartbeat: ~datetime.datetime
    :ivar version_status: Version status.
    :vartype version_status: str
    :ivar mobility_service_updates: The list of the mobility service updates available on the
     Process Server.
    :vartype mobility_service_updates:
     list[~azure.mgmt.recoveryservicessiterecovery.models.MobilityServiceUpdate]
    :ivar host_id: The agent generated Id.
    :vartype host_id: str
    :ivar machine_count: The servers configured with this PS.
    :vartype machine_count: str
    :ivar replication_pair_count: The number of replication pairs configured in this PS.
    :vartype replication_pair_count: str
    :ivar system_load: The percentage of the system load.
    :vartype system_load: str
    :ivar system_load_status: The system load status.
    :vartype system_load_status: str
    :ivar cpu_load: The percentage of the CPU load.
    :vartype cpu_load: str
    :ivar cpu_load_status: The CPU load status.
    :vartype cpu_load_status: str
    :ivar total_memory_in_bytes: The total memory.
    :vartype total_memory_in_bytes: int
    :ivar available_memory_in_bytes: The available memory.
    :vartype available_memory_in_bytes: int
    :ivar memory_usage_status: The memory usage status.
    :vartype memory_usage_status: str
    :ivar total_space_in_bytes: The total space.
    :vartype total_space_in_bytes: int
    :ivar available_space_in_bytes: The available space.
    :vartype available_space_in_bytes: int
    :ivar space_usage_status: The space usage status.
    :vartype space_usage_status: str
    :ivar ps_service_status: The PS service status.
    :vartype ps_service_status: str
    :ivar ssl_cert_expiry_date: The PS SSL cert expiry date.
    :vartype ssl_cert_expiry_date: ~datetime.datetime
    :ivar ssl_cert_expiry_remaining_days: CS SSL cert expiry date.
    :vartype ssl_cert_expiry_remaining_days: int
    :ivar os_version: OS Version of the process server. Note: This will get populated if user has
     CS version greater than 9.12.0.0.
    :vartype os_version: str
    :ivar health_errors: Health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar agent_expiry_date: Agent expiry date.
    :vartype agent_expiry_date: ~datetime.datetime
    :ivar agent_version_details: The agent version details.
    :vartype agent_version_details: ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
    :ivar health: The health of Process Server. Known values are: "None", "Normal", "Warning", and
     "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar ps_stats_refresh_time: The process server stats refresh time.
    :vartype ps_stats_refresh_time: ~datetime.datetime
    :ivar throughput_upload_pending_data_in_bytes: The uploading pending data in bytes.
    :vartype throughput_upload_pending_data_in_bytes: int
    :ivar throughput_in_m_bps: The throughput in MBps.
    :vartype throughput_in_m_bps: int
    :ivar throughput_in_bytes: The throughput in bytes.
    :vartype throughput_in_bytes: int
    :ivar throughput_status: The throughput status.
    :vartype throughput_status: str
    :ivar mars_communication_status: The MARS communication status.
    :vartype mars_communication_status: str
    :ivar mars_registration_status: The MARS registration status.
    :vartype mars_registration_status: str
    """

    _validation = {
        "health": {"readonly": True},
        "ps_stats_refresh_time": {"readonly": True},
        "throughput_upload_pending_data_in_bytes": {"readonly": True},
        "throughput_in_m_bps": {"readonly": True},
        "throughput_in_bytes": {"readonly": True},
        "throughput_status": {"readonly": True},
        "mars_communication_status": {"readonly": True},
        "mars_registration_status": {"readonly": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "agent_version": {"key": "agentVersion", "type": "str"},
        "last_heartbeat": {"key": "lastHeartbeat", "type": "iso-8601"},
        "version_status": {"key": "versionStatus", "type": "str"},
        "mobility_service_updates": {"key": "mobilityServiceUpdates", "type": "[MobilityServiceUpdate]"},
        "host_id": {"key": "hostId", "type": "str"},
        "machine_count": {"key": "machineCount", "type": "str"},
        "replication_pair_count": {"key": "replicationPairCount", "type": "str"},
        "system_load": {"key": "systemLoad", "type": "str"},
        "system_load_status": {"key": "systemLoadStatus", "type": "str"},
        "cpu_load": {"key": "cpuLoad", "type": "str"},
        "cpu_load_status": {"key": "cpuLoadStatus", "type": "str"},
        "total_memory_in_bytes": {"key": "totalMemoryInBytes", "type": "int"},
        "available_memory_in_bytes": {"key": "availableMemoryInBytes", "type": "int"},
        "memory_usage_status": {"key": "memoryUsageStatus", "type": "str"},
        "total_space_in_bytes": {"key": "totalSpaceInBytes", "type": "int"},
        "available_space_in_bytes": {"key": "availableSpaceInBytes", "type": "int"},
        "space_usage_status": {"key": "spaceUsageStatus", "type": "str"},
        "ps_service_status": {"key": "psServiceStatus", "type": "str"},
        "ssl_cert_expiry_date": {"key": "sslCertExpiryDate", "type": "iso-8601"},
        "ssl_cert_expiry_remaining_days": {"key": "sslCertExpiryRemainingDays", "type": "int"},
        "os_version": {"key": "osVersion", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
        "agent_expiry_date": {"key": "agentExpiryDate", "type": "iso-8601"},
        "agent_version_details": {"key": "agentVersionDetails", "type": "VersionDetails"},
        "health": {"key": "health", "type": "str"},
        "ps_stats_refresh_time": {"key": "psStatsRefreshTime", "type": "iso-8601"},
        "throughput_upload_pending_data_in_bytes": {"key": "throughputUploadPendingDataInBytes", "type": "int"},
        "throughput_in_m_bps": {"key": "throughputInMBps", "type": "int"},
        "throughput_in_bytes": {"key": "throughputInBytes", "type": "int"},
        "throughput_status": {"key": "throughputStatus", "type": "str"},
        "mars_communication_status": {"key": "marsCommunicationStatus", "type": "str"},
        "mars_registration_status": {"key": "marsRegistrationStatus", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        friendly_name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        ip_address: Optional[str] = None,
        os_type: Optional[str] = None,
        agent_version: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        version_status: Optional[str] = None,
        mobility_service_updates: Optional[List["_models.MobilityServiceUpdate"]] = None,
        host_id: Optional[str] = None,
        machine_count: Optional[str] = None,
        replication_pair_count: Optional[str] = None,
        system_load: Optional[str] = None,
        system_load_status: Optional[str] = None,
        cpu_load: Optional[str] = None,
        cpu_load_status: Optional[str] = None,
        total_memory_in_bytes: Optional[int] = None,
        available_memory_in_bytes: Optional[int] = None,
        memory_usage_status: Optional[str] = None,
        total_space_in_bytes: Optional[int] = None,
        available_space_in_bytes: Optional[int] = None,
        space_usage_status: Optional[str] = None,
        ps_service_status: Optional[str] = None,
        ssl_cert_expiry_date: Optional[datetime.datetime] = None,
        ssl_cert_expiry_remaining_days: Optional[int] = None,
        os_version: Optional[str] = None,
        health_errors: Optional[List["_models.HealthError"]] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        agent_version_details: Optional["_models.VersionDetails"] = None,
        **kwargs
    ):
        """
        :keyword friendly_name: The Process Server's friendly name.
        :paramtype friendly_name: str
        :keyword id: The Process Server Id.
        :paramtype id: str
        :keyword ip_address: The IP address of the server.
        :paramtype ip_address: str
        :keyword os_type: The OS type of the server.
        :paramtype os_type: str
        :keyword agent_version: The version of the scout component on the server.
        :paramtype agent_version: str
        :keyword last_heartbeat: The last heartbeat received from the server.
        :paramtype last_heartbeat: ~datetime.datetime
        :keyword version_status: Version status.
        :paramtype version_status: str
        :keyword mobility_service_updates: The list of the mobility service updates available on the
         Process Server.
        :paramtype mobility_service_updates:
         list[~azure.mgmt.recoveryservicessiterecovery.models.MobilityServiceUpdate]
        :keyword host_id: The agent generated Id.
        :paramtype host_id: str
        :keyword machine_count: The servers configured with this PS.
        :paramtype machine_count: str
        :keyword replication_pair_count: The number of replication pairs configured in this PS.
        :paramtype replication_pair_count: str
        :keyword system_load: The percentage of the system load.
        :paramtype system_load: str
        :keyword system_load_status: The system load status.
        :paramtype system_load_status: str
        :keyword cpu_load: The percentage of the CPU load.
        :paramtype cpu_load: str
        :keyword cpu_load_status: The CPU load status.
        :paramtype cpu_load_status: str
        :keyword total_memory_in_bytes: The total memory.
        :paramtype total_memory_in_bytes: int
        :keyword available_memory_in_bytes: The available memory.
        :paramtype available_memory_in_bytes: int
        :keyword memory_usage_status: The memory usage status.
        :paramtype memory_usage_status: str
        :keyword total_space_in_bytes: The total space.
        :paramtype total_space_in_bytes: int
        :keyword available_space_in_bytes: The available space.
        :paramtype available_space_in_bytes: int
        :keyword space_usage_status: The space usage status.
        :paramtype space_usage_status: str
        :keyword ps_service_status: The PS service status.
        :paramtype ps_service_status: str
        :keyword ssl_cert_expiry_date: The PS SSL cert expiry date.
        :paramtype ssl_cert_expiry_date: ~datetime.datetime
        :keyword ssl_cert_expiry_remaining_days: CS SSL cert expiry date.
        :paramtype ssl_cert_expiry_remaining_days: int
        :keyword os_version: OS Version of the process server. Note: This will get populated if user
         has CS version greater than 9.12.0.0.
        :paramtype os_version: str
        :keyword health_errors: Health errors.
        :paramtype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
        :keyword agent_expiry_date: Agent expiry date.
        :paramtype agent_expiry_date: ~datetime.datetime
        :keyword agent_version_details: The agent version details.
        :paramtype agent_version_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.id = id
        self.ip_address = ip_address
        self.os_type = os_type
        self.agent_version = agent_version
        self.last_heartbeat = last_heartbeat
        self.version_status = version_status
        self.mobility_service_updates = mobility_service_updates
        self.host_id = host_id
        self.machine_count = machine_count
        self.replication_pair_count = replication_pair_count
        self.system_load = system_load
        self.system_load_status = system_load_status
        self.cpu_load = cpu_load
        self.cpu_load_status = cpu_load_status
        self.total_memory_in_bytes = total_memory_in_bytes
        self.available_memory_in_bytes = available_memory_in_bytes
        self.memory_usage_status = memory_usage_status
        self.total_space_in_bytes = total_space_in_bytes
        self.available_space_in_bytes = available_space_in_bytes
        self.space_usage_status = space_usage_status
        self.ps_service_status = ps_service_status
        self.ssl_cert_expiry_date = ssl_cert_expiry_date
        self.ssl_cert_expiry_remaining_days = ssl_cert_expiry_remaining_days
        self.os_version = os_version
        self.health_errors = health_errors
        self.agent_expiry_date = agent_expiry_date
        self.agent_version_details = agent_version_details
        self.health = None
        self.ps_stats_refresh_time = None
        self.throughput_upload_pending_data_in_bytes = None
        self.throughput_in_m_bps = None
        self.throughput_in_bytes = None
        self.throughput_status = None
        self.mars_communication_status = None
        self.mars_registration_status = None


class ProcessServerDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Process server details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The process server Id.
    :vartype id: str
    :ivar name: The process server name.
    :vartype name: str
    :ivar bios_id: The process server Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The process server Fqdn.
    :vartype fqdn: str
    :ivar ip_addresses: The list of IP addresses for communicating with the RCM component.
    :vartype ip_addresses: list[str]
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the process server.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar total_memory_in_bytes: The total memory.
    :vartype total_memory_in_bytes: int
    :ivar available_memory_in_bytes: The available memory.
    :vartype available_memory_in_bytes: int
    :ivar used_memory_in_bytes: The used memory.
    :vartype used_memory_in_bytes: int
    :ivar memory_usage_percentage: The memory usage percentage.
    :vartype memory_usage_percentage: float
    :ivar total_space_in_bytes: The total disk space.
    :vartype total_space_in_bytes: int
    :ivar available_space_in_bytes: The available disk space.
    :vartype available_space_in_bytes: int
    :ivar used_space_in_bytes: The used disk space.
    :vartype used_space_in_bytes: int
    :ivar free_space_percentage: The free disk space percentage.
    :vartype free_space_percentage: float
    :ivar throughput_upload_pending_data_in_bytes: The uploading pending data in bytes.
    :vartype throughput_upload_pending_data_in_bytes: int
    :ivar throughput_in_bytes: The throughput in bytes.
    :vartype throughput_in_bytes: int
    :ivar processor_usage_percentage: The processor usage percentage.
    :vartype processor_usage_percentage: float
    :ivar throughput_status: The throughput status. Known values are: "Healthy", "Warning",
     "Critical", and "Unknown".
    :vartype throughput_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar system_load: The system load.
    :vartype system_load: int
    :ivar system_load_status: The system load status. Known values are: "Healthy", "Warning",
     "Critical", and "Unknown".
    :vartype system_load_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar disk_usage_status: The disk usage status. Known values are: "Healthy", "Warning",
     "Critical", and "Unknown".
    :vartype disk_usage_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar memory_usage_status: The memory usage status. Known values are: "Healthy", "Warning",
     "Critical", and "Unknown".
    :vartype memory_usage_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar processor_usage_status: The processor usage status. Known values are: "Healthy",
     "Warning", "Critical", and "Unknown".
    :vartype processor_usage_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar health: The health of the process server. Known values are: "None", "Normal", "Warning",
     and "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar protected_item_count: The protected item count.
    :vartype protected_item_count: int
    :ivar historic_health: The historic health of the process server based on the health in last 24
     hours. Known values are: "None", "Normal", "Warning", and "Critical".
    :vartype historic_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "bios_id": {"readonly": True},
        "fabric_object_id": {"readonly": True},
        "fqdn": {"readonly": True},
        "ip_addresses": {"readonly": True},
        "version": {"readonly": True},
        "last_heartbeat_utc": {"readonly": True},
        "total_memory_in_bytes": {"readonly": True},
        "available_memory_in_bytes": {"readonly": True},
        "used_memory_in_bytes": {"readonly": True},
        "memory_usage_percentage": {"readonly": True},
        "total_space_in_bytes": {"readonly": True},
        "available_space_in_bytes": {"readonly": True},
        "used_space_in_bytes": {"readonly": True},
        "free_space_percentage": {"readonly": True},
        "throughput_upload_pending_data_in_bytes": {"readonly": True},
        "throughput_in_bytes": {"readonly": True},
        "processor_usage_percentage": {"readonly": True},
        "throughput_status": {"readonly": True},
        "system_load": {"readonly": True},
        "system_load_status": {"readonly": True},
        "disk_usage_status": {"readonly": True},
        "memory_usage_status": {"readonly": True},
        "processor_usage_status": {"readonly": True},
        "health": {"readonly": True},
        "health_errors": {"readonly": True},
        "protected_item_count": {"readonly": True},
        "historic_health": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "version": {"key": "version", "type": "str"},
        "last_heartbeat_utc": {"key": "lastHeartbeatUtc", "type": "iso-8601"},
        "total_memory_in_bytes": {"key": "totalMemoryInBytes", "type": "int"},
        "available_memory_in_bytes": {"key": "availableMemoryInBytes", "type": "int"},
        "used_memory_in_bytes": {"key": "usedMemoryInBytes", "type": "int"},
        "memory_usage_percentage": {"key": "memoryUsagePercentage", "type": "float"},
        "total_space_in_bytes": {"key": "totalSpaceInBytes", "type": "int"},
        "available_space_in_bytes": {"key": "availableSpaceInBytes", "type": "int"},
        "used_space_in_bytes": {"key": "usedSpaceInBytes", "type": "int"},
        "free_space_percentage": {"key": "freeSpacePercentage", "type": "float"},
        "throughput_upload_pending_data_in_bytes": {"key": "throughputUploadPendingDataInBytes", "type": "int"},
        "throughput_in_bytes": {"key": "throughputInBytes", "type": "int"},
        "processor_usage_percentage": {"key": "processorUsagePercentage", "type": "float"},
        "throughput_status": {"key": "throughputStatus", "type": "str"},
        "system_load": {"key": "systemLoad", "type": "int"},
        "system_load_status": {"key": "systemLoadStatus", "type": "str"},
        "disk_usage_status": {"key": "diskUsageStatus", "type": "str"},
        "memory_usage_status": {"key": "memoryUsageStatus", "type": "str"},
        "processor_usage_status": {"key": "processorUsageStatus", "type": "str"},
        "health": {"key": "health", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
        "protected_item_count": {"key": "protectedItemCount", "type": "int"},
        "historic_health": {"key": "historicHealth", "type": "str"},
    }

    def __init__(self, **kwargs):  # pylint: disable=too-many-locals
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.ip_addresses = None
        self.version = None
        self.last_heartbeat_utc = None
        self.total_memory_in_bytes = None
        self.available_memory_in_bytes = None
        self.used_memory_in_bytes = None
        self.memory_usage_percentage = None
        self.total_space_in_bytes = None
        self.available_space_in_bytes = None
        self.used_space_in_bytes = None
        self.free_space_percentage = None
        self.throughput_upload_pending_data_in_bytes = None
        self.throughput_in_bytes = None
        self.processor_usage_percentage = None
        self.throughput_status = None
        self.system_load = None
        self.system_load_status = None
        self.disk_usage_status = None
        self.memory_usage_status = None
        self.processor_usage_status = None
        self.health = None
        self.health_errors = None
        self.protected_item_count = None
        self.historic_health = None


class ProtectableItem(Resource):
    """Replication protected item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The custom data.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.ProtectableItemProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectableItemProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.ProtectableItemProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The custom data.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.ProtectableItemProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class ProtectableItemCollection(_serialization.Model):
    """Protectable item collection.

    :ivar value: The Protectable item details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectableItem]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProtectableItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ProtectableItem"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The Protectable item details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectableItem]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProtectableItemProperties(_serialization.Model):
    """Replication protected item custom data details.

    :ivar friendly_name: The name.
    :vartype friendly_name: str
    :ivar protection_status: The protection status.
    :vartype protection_status: str
    :ivar replication_protected_item_id: The ARM resource of protected items.
    :vartype replication_protected_item_id: str
    :ivar recovery_services_provider_id: The recovery provider ARM Id.
    :vartype recovery_services_provider_id: str
    :ivar protection_readiness_errors: The Current protection readiness errors.
    :vartype protection_readiness_errors: list[str]
    :ivar supported_replication_providers: The list of replication providers supported for the
     protectable item.
    :vartype supported_replication_providers: list[str]
    :ivar custom_details: The Replication provider custom settings.
    :vartype custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.ConfigurationSettings
    """

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "replication_protected_item_id": {"key": "replicationProtectedItemId", "type": "str"},
        "recovery_services_provider_id": {"key": "recoveryServicesProviderId", "type": "str"},
        "protection_readiness_errors": {"key": "protectionReadinessErrors", "type": "[str]"},
        "supported_replication_providers": {"key": "supportedReplicationProviders", "type": "[str]"},
        "custom_details": {"key": "customDetails", "type": "ConfigurationSettings"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        protection_status: Optional[str] = None,
        replication_protected_item_id: Optional[str] = None,
        recovery_services_provider_id: Optional[str] = None,
        protection_readiness_errors: Optional[List[str]] = None,
        supported_replication_providers: Optional[List[str]] = None,
        custom_details: Optional["_models.ConfigurationSettings"] = None,
        **kwargs
    ):
        """
        :keyword friendly_name: The name.
        :paramtype friendly_name: str
        :keyword protection_status: The protection status.
        :paramtype protection_status: str
        :keyword replication_protected_item_id: The ARM resource of protected items.
        :paramtype replication_protected_item_id: str
        :keyword recovery_services_provider_id: The recovery provider ARM Id.
        :paramtype recovery_services_provider_id: str
        :keyword protection_readiness_errors: The Current protection readiness errors.
        :paramtype protection_readiness_errors: list[str]
        :keyword supported_replication_providers: The list of replication providers supported for the
         protectable item.
        :paramtype supported_replication_providers: list[str]
        :keyword custom_details: The Replication provider custom settings.
        :paramtype custom_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.ConfigurationSettings
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.protection_status = protection_status
        self.replication_protected_item_id = replication_protected_item_id
        self.recovery_services_provider_id = recovery_services_provider_id
        self.protection_readiness_errors = protection_readiness_errors
        self.supported_replication_providers = supported_replication_providers
        self.custom_details = custom_details


class ProtectableItemQueryParameter(_serialization.Model):
    """Query parameter to enumerate Protectable items.

    :ivar state: State of the Protectable item query filter.
    :vartype state: str
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Optional[str] = None, **kwargs):
        """
        :keyword state: State of the Protectable item query filter.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.state = state


class ProtectedItemsQueryParameter(_serialization.Model):
    """Query parameter to enumerate protected items.

    :ivar source_fabric_name: The source fabric name filter.
    :vartype source_fabric_name: str
    :ivar recovery_plan_name: The recovery plan filter.
    :vartype recovery_plan_name: str
    :ivar source_fabric_location: The source fabric location filter.
    :vartype source_fabric_location: str
    :ivar fabric_object_id: The fabric object Id filter.
    :vartype fabric_object_id: str
    :ivar v_center_name: The vCenter name filter.
    :vartype v_center_name: str
    :ivar instance_type: The replication provider type.
    :vartype instance_type: str
    :ivar multi_vm_group_create_option: Whether Multi VM group is auto created or specified by
     user. Known values are: "AutoCreated" and "UserSpecified".
    :vartype multi_vm_group_create_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmGroupCreateOption
    :ivar process_server_id: The process server Id filter.
    :vartype process_server_id: str
    """

    _attribute_map = {
        "source_fabric_name": {"key": "sourceFabricName", "type": "str"},
        "recovery_plan_name": {"key": "recoveryPlanName", "type": "str"},
        "source_fabric_location": {"key": "sourceFabricLocation", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "v_center_name": {"key": "vCenterName", "type": "str"},
        "instance_type": {"key": "instanceType", "type": "str"},
        "multi_vm_group_create_option": {"key": "multiVmGroupCreateOption", "type": "str"},
        "process_server_id": {"key": "processServerId", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_fabric_name: Optional[str] = None,
        recovery_plan_name: Optional[str] = None,
        source_fabric_location: Optional[str] = None,
        fabric_object_id: Optional[str] = None,
        v_center_name: Optional[str] = None,
        instance_type: Optional[str] = None,
        multi_vm_group_create_option: Optional[Union[str, "_models.MultiVmGroupCreateOption"]] = None,
        process_server_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_fabric_name: The source fabric name filter.
        :paramtype source_fabric_name: str
        :keyword recovery_plan_name: The recovery plan filter.
        :paramtype recovery_plan_name: str
        :keyword source_fabric_location: The source fabric location filter.
        :paramtype source_fabric_location: str
        :keyword fabric_object_id: The fabric object Id filter.
        :paramtype fabric_object_id: str
        :keyword v_center_name: The vCenter name filter.
        :paramtype v_center_name: str
        :keyword instance_type: The replication provider type.
        :paramtype instance_type: str
        :keyword multi_vm_group_create_option: Whether Multi VM group is auto created or specified by
         user. Known values are: "AutoCreated" and "UserSpecified".
        :paramtype multi_vm_group_create_option: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmGroupCreateOption
        :keyword process_server_id: The process server Id filter.
        :paramtype process_server_id: str
        """
        super().__init__(**kwargs)
        self.source_fabric_name = source_fabric_name
        self.recovery_plan_name = recovery_plan_name
        self.source_fabric_location = source_fabric_location
        self.fabric_object_id = fabric_object_id
        self.v_center_name = v_center_name
        self.instance_type = instance_type
        self.multi_vm_group_create_option = multi_vm_group_create_option
        self.process_server_id = process_server_id


class ProtectionContainer(Resource):
    """Protection container details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The custom data.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectionContainerProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.ProtectionContainerProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The custom data.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class ProtectionContainerCollection(_serialization.Model):
    """Protection Container collection.

    :ivar value: The Protection Container details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainer]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProtectionContainer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ProtectionContainer"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The Protection Container details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainer]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProtectionContainerFabricSpecificDetails(_serialization.Model):
    """Base class for fabric specific details of container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar instance_type: Gets the class type. Overridden in derived classes.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"readonly": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type = None


class ProtectionContainerMapping(Resource):
    """Protection container mapping object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The custom data.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMappingProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectionContainerMappingProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.ProtectionContainerMappingProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The custom data.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMappingProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class ProtectionContainerMappingCollection(_serialization.Model):
    """Protection container mapping collection class.

    :ivar value: List of container mappings.
    :vartype value:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMapping]
    :ivar next_link: Link to fetch rest of the data.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProtectionContainerMapping]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ProtectionContainerMapping"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of container mappings.
        :paramtype value:
         list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMapping]
        :keyword next_link: Link to fetch rest of the data.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProtectionContainerMappingProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Protection container mapping properties.

    :ivar target_protection_container_id: Paired protection container ARM ID.
    :vartype target_protection_container_id: str
    :ivar target_protection_container_friendly_name: Friendly name of paired container.
    :vartype target_protection_container_friendly_name: str
    :ivar provider_specific_details: Provider specific provider details.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMappingProviderSpecificDetails
    :ivar health: Health of pairing.
    :vartype health: str
    :ivar health_error_details: Health error.
    :vartype health_error_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar policy_id: Policy ARM Id.
    :vartype policy_id: str
    :ivar state: Association Status.
    :vartype state: str
    :ivar source_protection_container_friendly_name: Friendly name of source protection container.
    :vartype source_protection_container_friendly_name: str
    :ivar source_fabric_friendly_name: Friendly name of source fabric.
    :vartype source_fabric_friendly_name: str
    :ivar target_fabric_friendly_name: Friendly name of target fabric.
    :vartype target_fabric_friendly_name: str
    :ivar policy_friendly_name: Friendly name of replication policy.
    :vartype policy_friendly_name: str
    """

    _attribute_map = {
        "target_protection_container_id": {"key": "targetProtectionContainerId", "type": "str"},
        "target_protection_container_friendly_name": {"key": "targetProtectionContainerFriendlyName", "type": "str"},
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "ProtectionContainerMappingProviderSpecificDetails",
        },
        "health": {"key": "health", "type": "str"},
        "health_error_details": {"key": "healthErrorDetails", "type": "[HealthError]"},
        "policy_id": {"key": "policyId", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "source_protection_container_friendly_name": {"key": "sourceProtectionContainerFriendlyName", "type": "str"},
        "source_fabric_friendly_name": {"key": "sourceFabricFriendlyName", "type": "str"},
        "target_fabric_friendly_name": {"key": "targetFabricFriendlyName", "type": "str"},
        "policy_friendly_name": {"key": "policyFriendlyName", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_protection_container_id: Optional[str] = None,
        target_protection_container_friendly_name: Optional[str] = None,
        provider_specific_details: Optional["_models.ProtectionContainerMappingProviderSpecificDetails"] = None,
        health: Optional[str] = None,
        health_error_details: Optional[List["_models.HealthError"]] = None,
        policy_id: Optional[str] = None,
        state: Optional[str] = None,
        source_protection_container_friendly_name: Optional[str] = None,
        source_fabric_friendly_name: Optional[str] = None,
        target_fabric_friendly_name: Optional[str] = None,
        policy_friendly_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_protection_container_id: Paired protection container ARM ID.
        :paramtype target_protection_container_id: str
        :keyword target_protection_container_friendly_name: Friendly name of paired container.
        :paramtype target_protection_container_friendly_name: str
        :keyword provider_specific_details: Provider specific provider details.
        :paramtype provider_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMappingProviderSpecificDetails
        :keyword health: Health of pairing.
        :paramtype health: str
        :keyword health_error_details: Health error.
        :paramtype health_error_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
        :keyword policy_id: Policy ARM Id.
        :paramtype policy_id: str
        :keyword state: Association Status.
        :paramtype state: str
        :keyword source_protection_container_friendly_name: Friendly name of source protection
         container.
        :paramtype source_protection_container_friendly_name: str
        :keyword source_fabric_friendly_name: Friendly name of source fabric.
        :paramtype source_fabric_friendly_name: str
        :keyword target_fabric_friendly_name: Friendly name of target fabric.
        :paramtype target_fabric_friendly_name: str
        :keyword policy_friendly_name: Friendly name of replication policy.
        :paramtype policy_friendly_name: str
        """
        super().__init__(**kwargs)
        self.target_protection_container_id = target_protection_container_id
        self.target_protection_container_friendly_name = target_protection_container_friendly_name
        self.provider_specific_details = provider_specific_details
        self.health = health
        self.health_error_details = health_error_details
        self.policy_id = policy_id
        self.state = state
        self.source_protection_container_friendly_name = source_protection_container_friendly_name
        self.source_fabric_friendly_name = source_fabric_friendly_name
        self.target_fabric_friendly_name = target_fabric_friendly_name
        self.policy_friendly_name = policy_friendly_name


class ProtectionContainerProperties(_serialization.Model):
    """Protection profile custom data details.

    :ivar fabric_friendly_name: Fabric friendly name.
    :vartype fabric_friendly_name: str
    :ivar friendly_name: The name.
    :vartype friendly_name: str
    :ivar fabric_type: The fabric type.
    :vartype fabric_type: str
    :ivar protected_item_count: Number of protected PEs.
    :vartype protected_item_count: int
    :ivar pairing_status: The pairing status of this cloud.
    :vartype pairing_status: str
    :ivar role: The role of this cloud.
    :vartype role: str
    :ivar fabric_specific_details: Fabric specific details.
    :vartype fabric_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerFabricSpecificDetails
    """

    _attribute_map = {
        "fabric_friendly_name": {"key": "fabricFriendlyName", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "fabric_type": {"key": "fabricType", "type": "str"},
        "protected_item_count": {"key": "protectedItemCount", "type": "int"},
        "pairing_status": {"key": "pairingStatus", "type": "str"},
        "role": {"key": "role", "type": "str"},
        "fabric_specific_details": {"key": "fabricSpecificDetails", "type": "ProtectionContainerFabricSpecificDetails"},
    }

    def __init__(
        self,
        *,
        fabric_friendly_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        fabric_type: Optional[str] = None,
        protected_item_count: Optional[int] = None,
        pairing_status: Optional[str] = None,
        role: Optional[str] = None,
        fabric_specific_details: Optional["_models.ProtectionContainerFabricSpecificDetails"] = None,
        **kwargs
    ):
        """
        :keyword fabric_friendly_name: Fabric friendly name.
        :paramtype fabric_friendly_name: str
        :keyword friendly_name: The name.
        :paramtype friendly_name: str
        :keyword fabric_type: The fabric type.
        :paramtype fabric_type: str
        :keyword protected_item_count: Number of protected PEs.
        :paramtype protected_item_count: int
        :keyword pairing_status: The pairing status of this cloud.
        :paramtype pairing_status: str
        :keyword role: The role of this cloud.
        :paramtype role: str
        :keyword fabric_specific_details: Fabric specific details.
        :paramtype fabric_specific_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerFabricSpecificDetails
        """
        super().__init__(**kwargs)
        self.fabric_friendly_name = fabric_friendly_name
        self.friendly_name = friendly_name
        self.fabric_type = fabric_type
        self.protected_item_count = protected_item_count
        self.pairing_status = pairing_status
        self.role = role
        self.fabric_specific_details = fabric_specific_details


class ProviderError(_serialization.Model):
    """This class contains the error details per object.

    :ivar error_code: The Error code.
    :vartype error_code: int
    :ivar error_message: The Error message.
    :vartype error_message: str
    :ivar error_id: The Provider error Id.
    :vartype error_id: str
    :ivar possible_causes: The possible causes for the error.
    :vartype possible_causes: str
    :ivar recommended_action: The recommended action to resolve the error.
    :vartype recommended_action: str
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "int"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "error_id": {"key": "errorId", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[int] = None,
        error_message: Optional[str] = None,
        error_id: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword error_code: The Error code.
        :paramtype error_code: int
        :keyword error_message: The Error message.
        :paramtype error_message: str
        :keyword error_id: The Provider error Id.
        :paramtype error_id: str
        :keyword possible_causes: The possible causes for the error.
        :paramtype possible_causes: str
        :keyword recommended_action: The recommended action to resolve the error.
        :paramtype recommended_action: str
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.error_id = error_id
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action


class PushInstallerDetails(_serialization.Model):
    """Push installer details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The push installer Id.
    :vartype id: str
    :ivar name: The push installer name.
    :vartype name: str
    :ivar bios_id: The push installer Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The push installer Fqdn.
    :vartype fqdn: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the push installer.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health of the push installer. Known values are: "None", "Normal", "Warning",
     and "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "bios_id": {"readonly": True},
        "fabric_object_id": {"readonly": True},
        "fqdn": {"readonly": True},
        "version": {"readonly": True},
        "last_heartbeat_utc": {"readonly": True},
        "health": {"readonly": True},
        "health_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "last_heartbeat_utc": {"key": "lastHeartbeatUtc", "type": "iso-8601"},
        "health": {"key": "health", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None


class RcmProxyDetails(_serialization.Model):
    """RCM proxy details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The RCM proxy Id.
    :vartype id: str
    :ivar name: The RCM proxy name.
    :vartype name: str
    :ivar bios_id: The RCM proxy Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The RCM proxy Fqdn.
    :vartype fqdn: str
    :ivar client_authentication_type: The client authentication type.
    :vartype client_authentication_type: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the RCM proxy.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health of the RCM proxy. Known values are: "None", "Normal", "Warning", and
     "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "bios_id": {"readonly": True},
        "fabric_object_id": {"readonly": True},
        "fqdn": {"readonly": True},
        "client_authentication_type": {"readonly": True},
        "version": {"readonly": True},
        "last_heartbeat_utc": {"readonly": True},
        "health": {"readonly": True},
        "health_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "bios_id": {"key": "biosId", "type": "str"},
        "fabric_object_id": {"key": "fabricObjectId", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "client_authentication_type": {"key": "clientAuthenticationType", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "last_heartbeat_utc": {"key": "lastHeartbeatUtc", "type": "iso-8601"},
        "health": {"key": "health", "type": "str"},
        "health_errors": {"key": "healthErrors", "type": "[HealthError]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.client_authentication_type = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None


class RecoveryPlan(Resource):
    """Recovery plan details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The custom details.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "RecoveryPlanProperties"},
    }

    def __init__(
        self, *, location: Optional[str] = None, properties: Optional["_models.RecoveryPlanProperties"] = None, **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The custom details.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class RecoveryPlanProviderSpecificDetails(_serialization.Model):
    """Recovery plan provider specific details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RecoveryPlanA2ADetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"A2A": "RecoveryPlanA2ADetails"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class RecoveryPlanA2ADetails(RecoveryPlanProviderSpecificDetails):
    """Recovery plan A2A specific details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar primary_zone: The primary zone.
    :vartype primary_zone: str
    :ivar recovery_zone: The recovery zone.
    :vartype recovery_zone: str
    :ivar primary_extended_location: The primary extended location.
    :vartype primary_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    :ivar recovery_extended_location: The recovery extended location.
    :vartype recovery_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_zone": {"key": "primaryZone", "type": "str"},
        "recovery_zone": {"key": "recoveryZone", "type": "str"},
        "primary_extended_location": {"key": "primaryExtendedLocation", "type": "ExtendedLocation"},
        "recovery_extended_location": {"key": "recoveryExtendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        primary_zone: Optional[str] = None,
        recovery_zone: Optional[str] = None,
        primary_extended_location: Optional["_models.ExtendedLocation"] = None,
        recovery_extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs
    ):
        """
        :keyword primary_zone: The primary zone.
        :paramtype primary_zone: str
        :keyword recovery_zone: The recovery zone.
        :paramtype recovery_zone: str
        :keyword primary_extended_location: The primary extended location.
        :paramtype primary_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        :keyword recovery_extended_location: The recovery extended location.
        :paramtype recovery_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.primary_zone = primary_zone
        self.recovery_zone = recovery_zone
        self.primary_extended_location = primary_extended_location
        self.recovery_extended_location = recovery_extended_location


class RecoveryPlanProviderSpecificFailoverInput(_serialization.Model):
    """Recovery plan provider specific failover input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RecoveryPlanA2AFailoverInput, RecoveryPlanHyperVReplicaAzureFailoverInput,
    RecoveryPlanHyperVReplicaAzureFailbackInput, RecoveryPlanInMageFailoverInput,
    RecoveryPlanInMageAzureV2FailoverInput, RecoveryPlanInMageRcmFailoverInput,
    RecoveryPlanInMageRcmFailbackFailoverInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "A2A": "RecoveryPlanA2AFailoverInput",
            "HyperVReplicaAzure": "RecoveryPlanHyperVReplicaAzureFailoverInput",
            "HyperVReplicaAzureFailback": "RecoveryPlanHyperVReplicaAzureFailbackInput",
            "InMage": "RecoveryPlanInMageFailoverInput",
            "InMageAzureV2": "RecoveryPlanInMageAzureV2FailoverInput",
            "InMageRcm": "RecoveryPlanInMageRcmFailoverInput",
            "InMageRcmFailback": "RecoveryPlanInMageRcmFailbackFailoverInput",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class RecoveryPlanA2AFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan A2A failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_type: The recovery point type. Required. Known values are: "Latest",
     "LatestApplicationConsistent", "LatestCrashConsistent", and "LatestProcessed".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.A2ARpRecoveryPointType
    :ivar cloud_service_creation_option: A value indicating whether to use recovery cloud service
     for TFO or not.
    :vartype cloud_service_creation_option: str
    :ivar multi_vm_sync_point_option: A value indicating whether multi VM sync enabled VMs should
     use multi VM sync points for failover. Known values are: "UseMultiVmSyncRecoveryPoint" and
     "UsePerVmRecoveryPoint".
    :vartype multi_vm_sync_point_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmSyncPointOption
    """

    _validation = {
        "instance_type": {"required": True},
        "recovery_point_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "cloud_service_creation_option": {"key": "cloudServiceCreationOption", "type": "str"},
        "multi_vm_sync_point_option": {"key": "multiVmSyncPointOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "_models.A2ARpRecoveryPointType"],
        cloud_service_creation_option: Optional[str] = None,
        multi_vm_sync_point_option: Optional[Union[str, "_models.MultiVmSyncPointOption"]] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_type: The recovery point type. Required. Known values are: "Latest",
         "LatestApplicationConsistent", "LatestCrashConsistent", and "LatestProcessed".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.A2ARpRecoveryPointType
        :keyword cloud_service_creation_option: A value indicating whether to use recovery cloud
         service for TFO or not.
        :paramtype cloud_service_creation_option: str
        :keyword multi_vm_sync_point_option: A value indicating whether multi VM sync enabled VMs
         should use multi VM sync points for failover. Known values are: "UseMultiVmSyncRecoveryPoint"
         and "UsePerVmRecoveryPoint".
        :paramtype multi_vm_sync_point_option: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmSyncPointOption
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.recovery_point_type = recovery_point_type
        self.cloud_service_creation_option = cloud_service_creation_option
        self.multi_vm_sync_point_option = multi_vm_sync_point_option


class RecoveryPlanProviderSpecificInput(_serialization.Model):
    """Recovery plan provider specific input base class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RecoveryPlanA2AInput

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"A2A": "RecoveryPlanA2AInput"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class RecoveryPlanA2AInput(RecoveryPlanProviderSpecificInput):
    """Recovery plan A2A input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the Instance type. Required.
    :vartype instance_type: str
    :ivar primary_zone: The primary zone.
    :vartype primary_zone: str
    :ivar recovery_zone: The recovery zone.
    :vartype recovery_zone: str
    :ivar primary_extended_location: The primary extended location.
    :vartype primary_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    :ivar recovery_extended_location: The recovery extended location.
    :vartype recovery_extended_location:
     ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_zone": {"key": "primaryZone", "type": "str"},
        "recovery_zone": {"key": "recoveryZone", "type": "str"},
        "primary_extended_location": {"key": "primaryExtendedLocation", "type": "ExtendedLocation"},
        "recovery_extended_location": {"key": "recoveryExtendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        primary_zone: Optional[str] = None,
        recovery_zone: Optional[str] = None,
        primary_extended_location: Optional["_models.ExtendedLocation"] = None,
        recovery_extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs
    ):
        """
        :keyword primary_zone: The primary zone.
        :paramtype primary_zone: str
        :keyword recovery_zone: The recovery zone.
        :paramtype recovery_zone: str
        :keyword primary_extended_location: The primary extended location.
        :paramtype primary_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        :keyword recovery_extended_location: The recovery extended location.
        :paramtype recovery_extended_location:
         ~azure.mgmt.recoveryservicessiterecovery.models.ExtendedLocation
        """
        super().__init__(**kwargs)
        self.instance_type: str = "A2A"
        self.primary_zone = primary_zone
        self.recovery_zone = recovery_zone
        self.primary_extended_location = primary_extended_location
        self.recovery_extended_location = recovery_extended_location


class RecoveryPlanAction(_serialization.Model):
    """Recovery plan action details.

    All required parameters must be populated in order to send to Azure.

    :ivar action_name: The action name. Required.
    :vartype action_name: str
    :ivar failover_types: The list of failover types. Required.
    :vartype failover_types: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItemOperation]
    :ivar failover_directions: The list of failover directions. Required.
    :vartype failover_directions: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections]
    :ivar custom_details: The custom details. Required.
    :vartype custom_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionDetails
    """

    _validation = {
        "action_name": {"required": True},
        "failover_types": {"required": True},
        "failover_directions": {"required": True},
        "custom_details": {"required": True},
    }

    _attribute_map = {
        "action_name": {"key": "actionName", "type": "str"},
        "failover_types": {"key": "failoverTypes", "type": "[str]"},
        "failover_directions": {"key": "failoverDirections", "type": "[str]"},
        "custom_details": {"key": "customDetails", "type": "RecoveryPlanActionDetails"},
    }

    def __init__(
        self,
        *,
        action_name: str,
        failover_types: List[Union[str, "_models.ReplicationProtectedItemOperation"]],
        failover_directions: List[Union[str, "_models.PossibleOperationsDirections"]],
        custom_details: "_models.RecoveryPlanActionDetails",
        **kwargs
    ):
        """
        :keyword action_name: The action name. Required.
        :paramtype action_name: str
        :keyword failover_types: The list of failover types. Required.
        :paramtype failover_types: list[str or
         ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItemOperation]
        :keyword failover_directions: The list of failover directions. Required.
        :paramtype failover_directions: list[str or
         ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections]
        :keyword custom_details: The custom details. Required.
        :paramtype custom_details:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionDetails
        """
        super().__init__(**kwargs)
        self.action_name = action_name
        self.failover_types = failover_types
        self.failover_directions = failover_directions
        self.custom_details = custom_details


class RecoveryPlanActionDetails(_serialization.Model):
    """Recovery plan action custom details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RecoveryPlanAutomationRunbookActionDetails, RecoveryPlanManualActionDetails,
    RecoveryPlanScriptActionDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the type of action details (see RecoveryPlanActionDetailsTypes enum
     for possible values). Required.
    :vartype instance_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    _subtype_map = {
        "instance_type": {
            "AutomationRunbookActionDetails": "RecoveryPlanAutomationRunbookActionDetails",
            "ManualActionDetails": "RecoveryPlanManualActionDetails",
            "ScriptActionDetails": "RecoveryPlanScriptActionDetails",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instance_type: Optional[str] = None


class RecoveryPlanAutomationRunbookActionDetails(RecoveryPlanActionDetails):
    """Recovery plan Automation runbook action details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the type of action details (see RecoveryPlanActionDetailsTypes enum
     for possible values). Required.
    :vartype instance_type: str
    :ivar runbook_id: The runbook ARM Id.
    :vartype runbook_id: str
    :ivar timeout: The runbook timeout.
    :vartype timeout: str
    :ivar fabric_location: The fabric location. Required. Known values are: "Primary" and
     "Recovery".
    :vartype fabric_location: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionLocation
    """

    _validation = {
        "instance_type": {"required": True},
        "fabric_location": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "runbook_id": {"key": "runbookId", "type": "str"},
        "timeout": {"key": "timeout", "type": "str"},
        "fabric_location": {"key": "fabricLocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        fabric_location: Union[str, "_models.RecoveryPlanActionLocation"],
        runbook_id: Optional[str] = None,
        timeout: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword runbook_id: The runbook ARM Id.
        :paramtype runbook_id: str
        :keyword timeout: The runbook timeout.
        :paramtype timeout: str
        :keyword fabric_location: The fabric location. Required. Known values are: "Primary" and
         "Recovery".
        :paramtype fabric_location: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionLocation
        """
        super().__init__(**kwargs)
        self.instance_type: str = "AutomationRunbookActionDetails"
        self.runbook_id = runbook_id
        self.timeout = timeout
        self.fabric_location = fabric_location


class RecoveryPlanCollection(_serialization.Model):
    """Recovery plan collection details.

    :ivar value: The list of recovery plans.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlan]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RecoveryPlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RecoveryPlan"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of recovery plans.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlan]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RecoveryPlanGroup(_serialization.Model):
    """Recovery plan group details.

    All required parameters must be populated in order to send to Azure.

    :ivar group_type: The group type. Required. Known values are: "Shutdown", "Boot", and
     "Failover".
    :vartype group_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroupType
    :ivar replication_protected_items: The list of protected items.
    :vartype replication_protected_items:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProtectedItem]
    :ivar start_group_actions: The start group actions.
    :vartype start_group_actions:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanAction]
    :ivar end_group_actions: The end group actions.
    :vartype end_group_actions:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanAction]
    """

    _validation = {
        "group_type": {"required": True},
    }

    _attribute_map = {
        "group_type": {"key": "groupType", "type": "str"},
        "replication_protected_items": {"key": "replicationProtectedItems", "type": "[RecoveryPlanProtectedItem]"},
        "start_group_actions": {"key": "startGroupActions", "type": "[RecoveryPlanAction]"},
        "end_group_actions": {"key": "endGroupActions", "type": "[RecoveryPlanAction]"},
    }

    def __init__(
        self,
        *,
        group_type: Union[str, "_models.RecoveryPlanGroupType"],
        replication_protected_items: Optional[List["_models.RecoveryPlanProtectedItem"]] = None,
        start_group_actions: Optional[List["_models.RecoveryPlanAction"]] = None,
        end_group_actions: Optional[List["_models.RecoveryPlanAction"]] = None,
        **kwargs
    ):
        """
        :keyword group_type: The group type. Required. Known values are: "Shutdown", "Boot", and
         "Failover".
        :paramtype group_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroupType
        :keyword replication_protected_items: The list of protected items.
        :paramtype replication_protected_items:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProtectedItem]
        :keyword start_group_actions: The start group actions.
        :paramtype start_group_actions:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanAction]
        :keyword end_group_actions: The end group actions.
        :paramtype end_group_actions:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanAction]
        """
        super().__init__(**kwargs)
        self.group_type = group_type
        self.replication_protected_items = replication_protected_items
        self.start_group_actions = start_group_actions
        self.end_group_actions = end_group_actions


class RecoveryPlanGroupTaskDetails(GroupTaskDetails):
    """This class represents the recovery plan group task.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RecoveryPlanShutdownGroupTaskDetails

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar child_tasks: The child tasks.
    :vartype child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    :ivar name: The name.
    :vartype name: str
    :ivar group_id: The group identifier.
    :vartype group_id: str
    :ivar rp_group_type: The group type.
    :vartype rp_group_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "child_tasks": {"key": "childTasks", "type": "[ASRTask]"},
        "name": {"key": "name", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "rp_group_type": {"key": "rpGroupType", "type": "str"},
    }

    _subtype_map = {"instance_type": {"RecoveryPlanShutdownGroupTaskDetails": "RecoveryPlanShutdownGroupTaskDetails"}}

    def __init__(
        self,
        *,
        child_tasks: Optional[List["_models.ASRTask"]] = None,
        name: Optional[str] = None,
        group_id: Optional[str] = None,
        rp_group_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword child_tasks: The child tasks.
        :paramtype child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
        :keyword name: The name.
        :paramtype name: str
        :keyword group_id: The group identifier.
        :paramtype group_id: str
        :keyword rp_group_type: The group type.
        :paramtype rp_group_type: str
        """
        super().__init__(child_tasks=child_tasks, **kwargs)
        self.instance_type: str = "RecoveryPlanGroupTaskDetails"
        self.name = name
        self.group_id = group_id
        self.rp_group_type = rp_group_type


class RecoveryPlanHyperVReplicaAzureFailbackInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan HVR Azure failback input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar data_sync_option: The data sync option. Required. Known values are: "ForDownTime" and
     "ForSynchronization".
    :vartype data_sync_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.DataSyncStatus
    :ivar recovery_vm_creation_option: The ALR option. Required. Known values are:
     "CreateVmIfNotFound" and "NoAction".
    :vartype recovery_vm_creation_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AlternateLocationRecoveryOption
    """

    _validation = {
        "instance_type": {"required": True},
        "data_sync_option": {"required": True},
        "recovery_vm_creation_option": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "data_sync_option": {"key": "dataSyncOption", "type": "str"},
        "recovery_vm_creation_option": {"key": "recoveryVmCreationOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_sync_option: Union[str, "_models.DataSyncStatus"],
        recovery_vm_creation_option: Union[str, "_models.AlternateLocationRecoveryOption"],
        **kwargs
    ):
        """
        :keyword data_sync_option: The data sync option. Required. Known values are: "ForDownTime" and
         "ForSynchronization".
        :paramtype data_sync_option: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.DataSyncStatus
        :keyword recovery_vm_creation_option: The ALR option. Required. Known values are:
         "CreateVmIfNotFound" and "NoAction".
        :paramtype recovery_vm_creation_option: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.AlternateLocationRecoveryOption
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzureFailback"
        self.data_sync_option = data_sync_option
        self.recovery_vm_creation_option = recovery_vm_creation_option


class RecoveryPlanHyperVReplicaAzureFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan HVR Azure failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar primary_kek_certificate_pfx: The primary KEK certificate PFX.
    :vartype primary_kek_certificate_pfx: str
    :ivar secondary_kek_certificate_pfx: The secondary KEK certificate PFX.
    :vartype secondary_kek_certificate_pfx: str
    :ivar recovery_point_type: The recovery point type. Known values are: "Latest",
     "LatestApplicationConsistent", and "LatestProcessed".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureRpRecoveryPointType
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "primary_kek_certificate_pfx": {"key": "primaryKekCertificatePfx", "type": "str"},
        "secondary_kek_certificate_pfx": {"key": "secondaryKekCertificatePfx", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        recovery_point_type: Optional[Union[str, "_models.HyperVReplicaAzureRpRecoveryPointType"]] = None,
        **kwargs
    ):
        """
        :keyword primary_kek_certificate_pfx: The primary KEK certificate PFX.
        :paramtype primary_kek_certificate_pfx: str
        :keyword secondary_kek_certificate_pfx: The secondary KEK certificate PFX.
        :paramtype secondary_kek_certificate_pfx: str
        :keyword recovery_point_type: The recovery point type. Known values are: "Latest",
         "LatestApplicationConsistent", and "LatestProcessed".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureRpRecoveryPointType
        """
        super().__init__(**kwargs)
        self.instance_type: str = "HyperVReplicaAzure"
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx
        self.recovery_point_type = recovery_point_type


class RecoveryPlanInMageAzureV2FailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan InMageAzureV2 failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_type: The recovery point type. Required. Known values are: "Latest",
     "LatestApplicationConsistent", "LatestCrashConsistent", and "LatestProcessed".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageV2RpRecoveryPointType
    :ivar use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should use
     multi VM sync points for failover.
    :vartype use_multi_vm_sync_point: str
    """

    _validation = {
        "instance_type": {"required": True},
        "recovery_point_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "use_multi_vm_sync_point": {"key": "useMultiVmSyncPoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "_models.InMageV2RpRecoveryPointType"],
        use_multi_vm_sync_point: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_type: The recovery point type. Required. Known values are: "Latest",
         "LatestApplicationConsistent", "LatestCrashConsistent", and "LatestProcessed".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageV2RpRecoveryPointType
        :keyword use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should
         use multi VM sync points for failover.
        :paramtype use_multi_vm_sync_point: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageAzureV2"
        self.recovery_point_type = recovery_point_type
        self.use_multi_vm_sync_point = use_multi_vm_sync_point


class RecoveryPlanInMageFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan InMage failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_type: The recovery point type. Required. Known values are: "LatestTime",
     "LatestTag", and "Custom".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RpInMageRecoveryPointType
    """

    _validation = {
        "instance_type": {"required": True},
        "recovery_point_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
    }

    def __init__(self, *, recovery_point_type: Union[str, "_models.RpInMageRecoveryPointType"], **kwargs):
        """
        :keyword recovery_point_type: The recovery point type. Required. Known values are:
         "LatestTime", "LatestTag", and "Custom".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.RpInMageRecoveryPointType
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMage"
        self.recovery_point_type = recovery_point_type


class RecoveryPlanInMageRcmFailbackFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan InMageRcmFailback failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_type: The recovery point type. Required. Known values are:
     "ApplicationConsistent" and "CrashConsistent".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackRecoveryPointType
    :ivar use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should use
     multi VM sync points for failover.
    :vartype use_multi_vm_sync_point: str
    """

    _validation = {
        "instance_type": {"required": True},
        "recovery_point_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "use_multi_vm_sync_point": {"key": "useMultiVmSyncPoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "_models.InMageRcmFailbackRecoveryPointType"],
        use_multi_vm_sync_point: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_type: The recovery point type. Required. Known values are:
         "ApplicationConsistent" and "CrashConsistent".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackRecoveryPointType
        :keyword use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should
         use multi VM sync points for failover.
        :paramtype use_multi_vm_sync_point: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcmFailback"
        self.recovery_point_type = recovery_point_type
        self.use_multi_vm_sync_point = use_multi_vm_sync_point


class RecoveryPlanInMageRcmFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan InMageRcm failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The class type. Required.
    :vartype instance_type: str
    :ivar recovery_point_type: The recovery point type. Required. Known values are: "Latest",
     "LatestApplicationConsistent", "LatestCrashConsistent", and "LatestProcessed".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanPointType
    :ivar use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should use
     multi VM sync points for failover.
    :vartype use_multi_vm_sync_point: str
    """

    _validation = {
        "instance_type": {"required": True},
        "recovery_point_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "use_multi_vm_sync_point": {"key": "useMultiVmSyncPoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "_models.RecoveryPlanPointType"],
        use_multi_vm_sync_point: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_type: The recovery point type. Required. Known values are: "Latest",
         "LatestApplicationConsistent", "LatestCrashConsistent", and "LatestProcessed".
        :paramtype recovery_point_type: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanPointType
        :keyword use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should
         use multi VM sync points for failover.
        :paramtype use_multi_vm_sync_point: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "InMageRcm"
        self.recovery_point_type = recovery_point_type
        self.use_multi_vm_sync_point = use_multi_vm_sync_point


class RecoveryPlanManualActionDetails(RecoveryPlanActionDetails):
    """Recovery plan manual action details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the type of action details (see RecoveryPlanActionDetailsTypes enum
     for possible values). Required.
    :vartype instance_type: str
    :ivar description: The manual action description.
    :vartype description: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs):
        """
        :keyword description: The manual action description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.instance_type: str = "ManualActionDetails"
        self.description = description


class RecoveryPlanPlannedFailoverInput(_serialization.Model):
    """Recovery plan planned failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: The recovery plan planned failover input properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanPlannedFailoverInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "RecoveryPlanPlannedFailoverInputProperties"},
    }

    def __init__(self, *, properties: "_models.RecoveryPlanPlannedFailoverInputProperties", **kwargs):
        """
        :keyword properties: The recovery plan planned failover input properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanPlannedFailoverInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RecoveryPlanPlannedFailoverInputProperties(_serialization.Model):
    """Recovery plan planned failover input properties.

    All required parameters must be populated in order to send to Azure.

    :ivar failover_direction: The failover direction. Required. Known values are:
     "PrimaryToRecovery" and "RecoveryToPrimary".
    :vartype failover_direction: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
    :ivar provider_specific_details: The provider specific properties.
    :vartype provider_specific_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
    """

    _validation = {
        "failover_direction": {"required": True},
    }

    _attribute_map = {
        "failover_direction": {"key": "failoverDirection", "type": "str"},
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "[RecoveryPlanProviderSpecificFailoverInput]",
        },
    }

    def __init__(
        self,
        *,
        failover_direction: Union[str, "_models.PossibleOperationsDirections"],
        provider_specific_details: Optional[List["_models.RecoveryPlanProviderSpecificFailoverInput"]] = None,
        **kwargs
    ):
        """
        :keyword failover_direction: The failover direction. Required. Known values are:
         "PrimaryToRecovery" and "RecoveryToPrimary".
        :paramtype failover_direction: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
        :keyword provider_specific_details: The provider specific properties.
        :paramtype provider_specific_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
        """
        super().__init__(**kwargs)
        self.failover_direction = failover_direction
        self.provider_specific_details = provider_specific_details


class RecoveryPlanProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Recovery plan properties.

    :ivar friendly_name: The friendly name.
    :vartype friendly_name: str
    :ivar primary_fabric_id: The primary fabric Id.
    :vartype primary_fabric_id: str
    :ivar primary_fabric_friendly_name: The primary fabric friendly name.
    :vartype primary_fabric_friendly_name: str
    :ivar recovery_fabric_id: The recovery fabric Id.
    :vartype recovery_fabric_id: str
    :ivar recovery_fabric_friendly_name: The recovery fabric friendly name.
    :vartype recovery_fabric_friendly_name: str
    :ivar failover_deployment_model: The failover deployment model.
    :vartype failover_deployment_model: str
    :ivar replication_providers: The list of replication providers.
    :vartype replication_providers: list[str]
    :ivar allowed_operations: The list of allowed operations.
    :vartype allowed_operations: list[str]
    :ivar last_planned_failover_time: The start time of the last planned failover.
    :vartype last_planned_failover_time: ~datetime.datetime
    :ivar last_unplanned_failover_time: The start time of the last unplanned failover.
    :vartype last_unplanned_failover_time: ~datetime.datetime
    :ivar last_test_failover_time: The start time of the last test failover.
    :vartype last_test_failover_time: ~datetime.datetime
    :ivar current_scenario: The current scenario details.
    :vartype current_scenario:
     ~azure.mgmt.recoveryservicessiterecovery.models.CurrentScenarioDetails
    :ivar current_scenario_status: The recovery plan status.
    :vartype current_scenario_status: str
    :ivar current_scenario_status_description: The recovery plan status description.
    :vartype current_scenario_status_description: str
    :ivar groups: The recovery plan groups.
    :vartype groups: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroup]
    :ivar provider_specific_details: The provider id and provider specific details.
    :vartype provider_specific_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificDetails]
    """

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "primary_fabric_id": {"key": "primaryFabricId", "type": "str"},
        "primary_fabric_friendly_name": {"key": "primaryFabricFriendlyName", "type": "str"},
        "recovery_fabric_id": {"key": "recoveryFabricId", "type": "str"},
        "recovery_fabric_friendly_name": {"key": "recoveryFabricFriendlyName", "type": "str"},
        "failover_deployment_model": {"key": "failoverDeploymentModel", "type": "str"},
        "replication_providers": {"key": "replicationProviders", "type": "[str]"},
        "allowed_operations": {"key": "allowedOperations", "type": "[str]"},
        "last_planned_failover_time": {"key": "lastPlannedFailoverTime", "type": "iso-8601"},
        "last_unplanned_failover_time": {"key": "lastUnplannedFailoverTime", "type": "iso-8601"},
        "last_test_failover_time": {"key": "lastTestFailoverTime", "type": "iso-8601"},
        "current_scenario": {"key": "currentScenario", "type": "CurrentScenarioDetails"},
        "current_scenario_status": {"key": "currentScenarioStatus", "type": "str"},
        "current_scenario_status_description": {"key": "currentScenarioStatusDescription", "type": "str"},
        "groups": {"key": "groups", "type": "[RecoveryPlanGroup]"},
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "[RecoveryPlanProviderSpecificDetails]",
        },
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        primary_fabric_id: Optional[str] = None,
        primary_fabric_friendly_name: Optional[str] = None,
        recovery_fabric_id: Optional[str] = None,
        recovery_fabric_friendly_name: Optional[str] = None,
        failover_deployment_model: Optional[str] = None,
        replication_providers: Optional[List[str]] = None,
        allowed_operations: Optional[List[str]] = None,
        last_planned_failover_time: Optional[datetime.datetime] = None,
        last_unplanned_failover_time: Optional[datetime.datetime] = None,
        last_test_failover_time: Optional[datetime.datetime] = None,
        current_scenario: Optional["_models.CurrentScenarioDetails"] = None,
        current_scenario_status: Optional[str] = None,
        current_scenario_status_description: Optional[str] = None,
        groups: Optional[List["_models.RecoveryPlanGroup"]] = None,
        provider_specific_details: Optional[List["_models.RecoveryPlanProviderSpecificDetails"]] = None,
        **kwargs
    ):
        """
        :keyword friendly_name: The friendly name.
        :paramtype friendly_name: str
        :keyword primary_fabric_id: The primary fabric Id.
        :paramtype primary_fabric_id: str
        :keyword primary_fabric_friendly_name: The primary fabric friendly name.
        :paramtype primary_fabric_friendly_name: str
        :keyword recovery_fabric_id: The recovery fabric Id.
        :paramtype recovery_fabric_id: str
        :keyword recovery_fabric_friendly_name: The recovery fabric friendly name.
        :paramtype recovery_fabric_friendly_name: str
        :keyword failover_deployment_model: The failover deployment model.
        :paramtype failover_deployment_model: str
        :keyword replication_providers: The list of replication providers.
        :paramtype replication_providers: list[str]
        :keyword allowed_operations: The list of allowed operations.
        :paramtype allowed_operations: list[str]
        :keyword last_planned_failover_time: The start time of the last planned failover.
        :paramtype last_planned_failover_time: ~datetime.datetime
        :keyword last_unplanned_failover_time: The start time of the last unplanned failover.
        :paramtype last_unplanned_failover_time: ~datetime.datetime
        :keyword last_test_failover_time: The start time of the last test failover.
        :paramtype last_test_failover_time: ~datetime.datetime
        :keyword current_scenario: The current scenario details.
        :paramtype current_scenario:
         ~azure.mgmt.recoveryservicessiterecovery.models.CurrentScenarioDetails
        :keyword current_scenario_status: The recovery plan status.
        :paramtype current_scenario_status: str
        :keyword current_scenario_status_description: The recovery plan status description.
        :paramtype current_scenario_status_description: str
        :keyword groups: The recovery plan groups.
        :paramtype groups: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroup]
        :keyword provider_specific_details: The provider id and provider specific details.
        :paramtype provider_specific_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificDetails]
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.primary_fabric_id = primary_fabric_id
        self.primary_fabric_friendly_name = primary_fabric_friendly_name
        self.recovery_fabric_id = recovery_fabric_id
        self.recovery_fabric_friendly_name = recovery_fabric_friendly_name
        self.failover_deployment_model = failover_deployment_model
        self.replication_providers = replication_providers
        self.allowed_operations = allowed_operations
        self.last_planned_failover_time = last_planned_failover_time
        self.last_unplanned_failover_time = last_unplanned_failover_time
        self.last_test_failover_time = last_test_failover_time
        self.current_scenario = current_scenario
        self.current_scenario_status = current_scenario_status
        self.current_scenario_status_description = current_scenario_status_description
        self.groups = groups
        self.provider_specific_details = provider_specific_details


class RecoveryPlanProtectedItem(_serialization.Model):
    """Recovery plan protected item.

    :ivar id: The ARM Id of the recovery plan protected item.
    :vartype id: str
    :ivar virtual_machine_id: The virtual machine Id.
    :vartype virtual_machine_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        virtual_machine_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The ARM Id of the recovery plan protected item.
        :paramtype id: str
        :keyword virtual_machine_id: The virtual machine Id.
        :paramtype virtual_machine_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.virtual_machine_id = virtual_machine_id


class RecoveryPlanScriptActionDetails(RecoveryPlanActionDetails):
    """Recovery plan script action details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: Gets the type of action details (see RecoveryPlanActionDetailsTypes enum
     for possible values). Required.
    :vartype instance_type: str
    :ivar path: The script path. Required.
    :vartype path: str
    :ivar timeout: The script timeout.
    :vartype timeout: str
    :ivar fabric_location: The fabric location. Required. Known values are: "Primary" and
     "Recovery".
    :vartype fabric_location: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionLocation
    """

    _validation = {
        "instance_type": {"required": True},
        "path": {"required": True},
        "fabric_location": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "timeout": {"key": "timeout", "type": "str"},
        "fabric_location": {"key": "fabricLocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        path: str,
        fabric_location: Union[str, "_models.RecoveryPlanActionLocation"],
        timeout: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword path: The script path. Required.
        :paramtype path: str
        :keyword timeout: The script timeout.
        :paramtype timeout: str
        :keyword fabric_location: The fabric location. Required. Known values are: "Primary" and
         "Recovery".
        :paramtype fabric_location: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionLocation
        """
        super().__init__(**kwargs)
        self.instance_type: str = "ScriptActionDetails"
        self.path = path
        self.timeout = timeout
        self.fabric_location = fabric_location


class RecoveryPlanShutdownGroupTaskDetails(RecoveryPlanGroupTaskDetails):
    """This class represents the recovery plan shutdown group task details.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_type: The type of task details. Required.
    :vartype instance_type: str
    :ivar child_tasks: The child tasks.
    :vartype child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    :ivar name: The name.
    :vartype name: str
    :ivar group_id: The group identifier.
    :vartype group_id: str
    :ivar rp_group_type: The group type.
    :vartype rp_group_type: str
    """

    _validation = {
        "instance_type": {"required": True},
    }

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
        "child_tasks": {"key": "childTasks", "type": "[ASRTask]"},
        "name": {"key": "name", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "rp_group_type": {"key": "rpGroupType", "type": "str"},
    }

    def __init__(
        self,
        *,
        child_tasks: Optional[List["_models.ASRTask"]] = None,
        name: Optional[str] = None,
        group_id: Optional[str] = None,
        rp_group_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword child_tasks: The child tasks.
        :paramtype child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
        :keyword name: The name.
        :paramtype name: str
        :keyword group_id: The group identifier.
        :paramtype group_id: str
        :keyword rp_group_type: The group type.
        :paramtype rp_group_type: str
        """
        super().__init__(child_tasks=child_tasks, name=name, group_id=group_id, rp_group_type=rp_group_type, **kwargs)
        self.instance_type: str = "RecoveryPlanShutdownGroupTaskDetails"


class RecoveryPlanTestFailoverCleanupInput(_serialization.Model):
    """Recovery plan test failover cleanup input.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: The recovery plan test failover cleanup input properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanTestFailoverCleanupInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "RecoveryPlanTestFailoverCleanupInputProperties"},
    }

    def __init__(self, *, properties: "_models.RecoveryPlanTestFailoverCleanupInputProperties", **kwargs):
        """
        :keyword properties: The recovery plan test failover cleanup input properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanTestFailoverCleanupInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RecoveryPlanTestFailoverCleanupInputProperties(_serialization.Model):
    """Recovery plan test failover cleanup input properties.

    :ivar comments: The test failover cleanup comments.
    :vartype comments: str
    """

    _validation = {
        "comments": {"max_length": 1024},
    }

    _attribute_map = {
        "comments": {"key": "comments", "type": "str"},
    }

    def __init__(self, *, comments: Optional[str] = None, **kwargs):
        """
        :keyword comments: The test failover cleanup comments.
        :paramtype comments: str
        """
        super().__init__(**kwargs)
        self.comments = comments


class RecoveryPlanTestFailoverInput(_serialization.Model):
    """Recovery plan test failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: The recovery plan test failover input properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanTestFailoverInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "RecoveryPlanTestFailoverInputProperties"},
    }

    def __init__(self, *, properties: "_models.RecoveryPlanTestFailoverInputProperties", **kwargs):
        """
        :keyword properties: The recovery plan test failover input properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanTestFailoverInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RecoveryPlanTestFailoverInputProperties(_serialization.Model):
    """Recovery plan test failover input properties.

    All required parameters must be populated in order to send to Azure.

    :ivar failover_direction: The failover direction. Required. Known values are:
     "PrimaryToRecovery" and "RecoveryToPrimary".
    :vartype failover_direction: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
    :ivar network_type: The network type to be used for test failover. Required.
    :vartype network_type: str
    :ivar network_id: The Id of the network to be used for test failover.
    :vartype network_id: str
    :ivar provider_specific_details: The provider specific properties.
    :vartype provider_specific_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
    """

    _validation = {
        "failover_direction": {"required": True},
        "network_type": {"required": True},
    }

    _attribute_map = {
        "failover_direction": {"key": "failoverDirection", "type": "str"},
        "network_type": {"key": "networkType", "type": "str"},
        "network_id": {"key": "networkId", "type": "str"},
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "[RecoveryPlanProviderSpecificFailoverInput]",
        },
    }

    def __init__(
        self,
        *,
        failover_direction: Union[str, "_models.PossibleOperationsDirections"],
        network_type: str,
        network_id: Optional[str] = None,
        provider_specific_details: Optional[List["_models.RecoveryPlanProviderSpecificFailoverInput"]] = None,
        **kwargs
    ):
        """
        :keyword failover_direction: The failover direction. Required. Known values are:
         "PrimaryToRecovery" and "RecoveryToPrimary".
        :paramtype failover_direction: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
        :keyword network_type: The network type to be used for test failover. Required.
        :paramtype network_type: str
        :keyword network_id: The Id of the network to be used for test failover.
        :paramtype network_id: str
        :keyword provider_specific_details: The provider specific properties.
        :paramtype provider_specific_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
        """
        super().__init__(**kwargs)
        self.failover_direction = failover_direction
        self.network_type = network_type
        self.network_id = network_id
        self.provider_specific_details = provider_specific_details


class RecoveryPlanUnplannedFailoverInput(_serialization.Model):
    """Recovery plan unplanned failover input.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: The recovery plan unplanned failover input properties. Required.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanUnplannedFailoverInputProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "RecoveryPlanUnplannedFailoverInputProperties"},
    }

    def __init__(self, *, properties: "_models.RecoveryPlanUnplannedFailoverInputProperties", **kwargs):
        """
        :keyword properties: The recovery plan unplanned failover input properties. Required.
        :paramtype properties:
         ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanUnplannedFailoverInputProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RecoveryPlanUnplannedFailoverInputProperties(_serialization.Model):
    """Recovery plan unplanned failover input properties.

    All required parameters must be populated in order to send to Azure.

    :ivar failover_direction: The failover direction. Required. Known values are:
     "PrimaryToRecovery" and "RecoveryToPrimary".
    :vartype failover_direction: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
    :ivar source_site_operations: A value indicating whether source site operations are required.
     Required. Known values are: "Required" and "NotRequired".
    :vartype source_site_operations: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SourceSiteOperations
    :ivar provider_specific_details: The provider specific properties.
    :vartype provider_specific_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
    """

    _validation = {
        "failover_direction": {"required": True},
        "source_site_operations": {"required": True},
    }

    _attribute_map = {
        "failover_direction": {"key": "failoverDirection", "type": "str"},
        "source_site_operations": {"key": "sourceSiteOperations", "type": "str"},
        "provider_specific_details": {
            "key": "providerSpecificDetails",
            "type": "[RecoveryPlanProviderSpecificFailoverInput]",
        },
    }

    def __init__(
        self,
        *,
        failover_direction: Union[str, "_models.PossibleOperationsDirections"],
        source_site_operations: Union[str, "_models.SourceSiteOperations"],
        provider_specific_details: Optional[List["_models.RecoveryPlanProviderSpecificFailoverInput"]] = None,
        **kwargs
    ):
        """
        :keyword failover_direction: The failover direction. Required. Known values are:
         "PrimaryToRecovery" and "RecoveryToPrimary".
        :paramtype failover_direction: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
        :keyword source_site_operations: A value indicating whether source site operations are
         required. Required. Known values are: "Required" and "NotRequired".
        :paramtype source_site_operations: str or
         ~azure.mgmt.recoveryservicessiterecovery.models.SourceSiteOperations
        :keyword provider_specific_details: The provider specific properties.
        :paramtype provider_specific_details:
         list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
        """
        super().__init__(**kwargs)
        self.failover_direction = failover_direction
        self.source_site_operations = source_site_operations
        self.provider_specific_details = provider_specific_details


class RecoveryPoint(Resource):
    """Recovery point.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar properties: The recovery point properties.
    :vartype properties: ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "RecoveryPointProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.RecoveryPointProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource Location.
        :paramtype location: str
        :keyword properties: The recovery point properties.
        :paramtype properties: ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointProperties
        """
        super().__init__(location=location, **kwargs)
        self.properties = properties


class RecoveryPointCollection(_serialization.Model):
    """Collection of recovery point details.

    :ivar value: The recovery point details.
    :vartype value: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPoint]
    :ivar next_link: The value of next link.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RecoveryPoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RecoveryPoint"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The recovery point details.
        :paramtype value: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPoint]
        :keyword next_link: The value of next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RecoveryPointProperties(_serialization.Model):
    """Recovery point properties.

    :ivar recovery_point_time: The recovery point time.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_type: The recovery point type: ApplicationConsistent, CrashConsistent.
    :vartype recovery_point_type: str
    :ivar provider_specific_details: The provider specific details for the recovery point.
    :vartype provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProviderSpecificRecoveryPointDetails
    """

    _attribute_map = {
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "provider_specific_details": {"key": "providerSpecificDetails", "type": "ProviderSpecificRecoveryPointDetails"},
    }

    def __init__(
        self,
        *,
        recovery_point_time: Optional[datetime.datetime] = None,
        recovery_point_type: Optional[str] = None,
        provider_specific_details: Optional["_models.ProviderSpecificRecoveryPointDetails"] = None,
        **kwargs
    ):
        """
        :keyword recovery_point_time: The recovery point time.
        :paramtype recovery_point_time: ~datetime.datetime
        :keyword recovery_point_type: The recovery point type: ApplicationConsistent, CrashConsistent.
        :paramtype recovery_point_type: str
        :keyword provider_specific_details: The provider specific details for the re