# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class LastModifiedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that last modified the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class Name(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the sku name."""

    STANDARD = "Standard"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the state of the provisioning."""

    UNKNOWN = "Unknown"
    CREATING = "Creating"
    MOVING = "Moving"
    DELETING = "Deleting"
    SOFT_DELETING = "SoftDeleting"
    SOFT_DELETED = "SoftDeleted"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the public network access."""

    NOT_SPECIFIED = "NotSpecified"
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class Reason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason the name is not available."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class ScopeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scope where the default account is set."""

    TENANT = "Tenant"
    SUBSCRIPTION = "Subscription"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status."""

    UNKNOWN = "Unknown"
    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identity Type."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
