# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import NetworkCloudMgmtClientConfiguration
from .operations import (
    BareMetalMachineKeySetsOperations,
    BareMetalMachinesOperations,
    BmcKeySetsOperations,
    CloudServicesNetworksOperations,
    ClusterManagersOperations,
    ClustersOperations,
    ConsolesOperations,
    DefaultCniNetworksOperations,
    HybridAksClustersOperations,
    L2NetworksOperations,
    L3NetworksOperations,
    MetricsConfigurationsOperations,
    Operations,
    RackSkusOperations,
    RacksOperations,
    StorageAppliancesOperations,
    TrunkedNetworksOperations,
    VirtualMachinesOperations,
    VolumesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class NetworkCloudMgmtClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """The Network Cloud APIs provide management of the on-premises clusters and their resources, such
    as, racks, bare metal hosts, virtual machines, workload networks and more.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.networkcloud.aio.operations.Operations
    :ivar bare_metal_machines: BareMetalMachinesOperations operations
    :vartype bare_metal_machines:
     azure.mgmt.networkcloud.aio.operations.BareMetalMachinesOperations
    :ivar cloud_services_networks: CloudServicesNetworksOperations operations
    :vartype cloud_services_networks:
     azure.mgmt.networkcloud.aio.operations.CloudServicesNetworksOperations
    :ivar cluster_managers: ClusterManagersOperations operations
    :vartype cluster_managers: azure.mgmt.networkcloud.aio.operations.ClusterManagersOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.networkcloud.aio.operations.ClustersOperations
    :ivar default_cni_networks: DefaultCniNetworksOperations operations
    :vartype default_cni_networks:
     azure.mgmt.networkcloud.aio.operations.DefaultCniNetworksOperations
    :ivar hybrid_aks_clusters: HybridAksClustersOperations operations
    :vartype hybrid_aks_clusters:
     azure.mgmt.networkcloud.aio.operations.HybridAksClustersOperations
    :ivar l2_networks: L2NetworksOperations operations
    :vartype l2_networks: azure.mgmt.networkcloud.aio.operations.L2NetworksOperations
    :ivar l3_networks: L3NetworksOperations operations
    :vartype l3_networks: azure.mgmt.networkcloud.aio.operations.L3NetworksOperations
    :ivar rack_skus: RackSkusOperations operations
    :vartype rack_skus: azure.mgmt.networkcloud.aio.operations.RackSkusOperations
    :ivar racks: RacksOperations operations
    :vartype racks: azure.mgmt.networkcloud.aio.operations.RacksOperations
    :ivar storage_appliances: StorageAppliancesOperations operations
    :vartype storage_appliances: azure.mgmt.networkcloud.aio.operations.StorageAppliancesOperations
    :ivar trunked_networks: TrunkedNetworksOperations operations
    :vartype trunked_networks: azure.mgmt.networkcloud.aio.operations.TrunkedNetworksOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.networkcloud.aio.operations.VirtualMachinesOperations
    :ivar volumes: VolumesOperations operations
    :vartype volumes: azure.mgmt.networkcloud.aio.operations.VolumesOperations
    :ivar bare_metal_machine_key_sets: BareMetalMachineKeySetsOperations operations
    :vartype bare_metal_machine_key_sets:
     azure.mgmt.networkcloud.aio.operations.BareMetalMachineKeySetsOperations
    :ivar bmc_key_sets: BmcKeySetsOperations operations
    :vartype bmc_key_sets: azure.mgmt.networkcloud.aio.operations.BmcKeySetsOperations
    :ivar metrics_configurations: MetricsConfigurationsOperations operations
    :vartype metrics_configurations:
     azure.mgmt.networkcloud.aio.operations.MetricsConfigurationsOperations
    :ivar consoles: ConsolesOperations operations
    :vartype consoles: azure.mgmt.networkcloud.aio.operations.ConsolesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-12-12-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = NetworkCloudMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.bare_metal_machines = BareMetalMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_services_networks = CloudServicesNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cluster_managers = ClusterManagersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.clusters = ClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.default_cni_networks = DefaultCniNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.hybrid_aks_clusters = HybridAksClustersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.l2_networks = L2NetworksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.l3_networks = L3NetworksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.rack_skus = RackSkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.racks = RacksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.storage_appliances = StorageAppliancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.trunked_networks = TrunkedNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.volumes = VolumesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.bare_metal_machine_key_sets = BareMetalMachineKeySetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.bmc_key_sets = BmcKeySetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.metrics_configurations = MetricsConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.consoles = ConsolesOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "NetworkCloudMgmtClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
