# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class NameUnavailableReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """reason of name unavailable."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class Serial(int, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Serial of key to be regenerated."""

    #: The Primary Key
    PRIMARY = 1
    #: The Secondary Key
    SECONDARY = 2


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
