# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._workflow_version_triggers_operations import build_list_callback_url_request

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class WorkflowVersionTriggersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.logic.aio.LogicManagementClient`'s
        :attr:`workflow_version_triggers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def list_callback_url(
        self,
        resource_group_name: str,
        workflow_name: str,
        version_id: str,
        trigger_name: str,
        parameters: Optional[_models.GetCallbackUrlParameters] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.WorkflowTriggerCallbackUrl:
        """Get the callback url for a trigger of a workflow version.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param workflow_name: The workflow name. Required.
        :type workflow_name: str
        :param version_id: The workflow versionId. Required.
        :type version_id: str
        :param trigger_name: The workflow trigger name. Required.
        :type trigger_name: str
        :param parameters: The callback URL parameters. Default value is None.
        :type parameters: ~azure.mgmt.logic.models.GetCallbackUrlParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkflowTriggerCallbackUrl or the result of cls(response)
        :rtype: ~azure.mgmt.logic.models.WorkflowTriggerCallbackUrl
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_callback_url(
        self,
        resource_group_name: str,
        workflow_name: str,
        version_id: str,
        trigger_name: str,
        parameters: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.WorkflowTriggerCallbackUrl:
        """Get the callback url for a trigger of a workflow version.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param workflow_name: The workflow name. Required.
        :type workflow_name: str
        :param version_id: The workflow versionId. Required.
        :type version_id: str
        :param trigger_name: The workflow trigger name. Required.
        :type trigger_name: str
        :param parameters: The callback URL parameters. Default value is None.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkflowTriggerCallbackUrl or the result of cls(response)
        :rtype: ~azure.mgmt.logic.models.WorkflowTriggerCallbackUrl
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_callback_url(
        self,
        resource_group_name: str,
        workflow_name: str,
        version_id: str,
        trigger_name: str,
        parameters: Optional[Union[_models.GetCallbackUrlParameters, IO]] = None,
        **kwargs: Any
    ) -> _models.WorkflowTriggerCallbackUrl:
        """Get the callback url for a trigger of a workflow version.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param workflow_name: The workflow name. Required.
        :type workflow_name: str
        :param version_id: The workflow versionId. Required.
        :type version_id: str
        :param trigger_name: The workflow trigger name. Required.
        :type trigger_name: str
        :param parameters: The callback URL parameters. Is either a model type or a IO type. Default
         value is None.
        :type parameters: ~azure.mgmt.logic.models.GetCallbackUrlParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkflowTriggerCallbackUrl or the result of cls(response)
        :rtype: ~azure.mgmt.logic.models.WorkflowTriggerCallbackUrl
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2019-05-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.WorkflowTriggerCallbackUrl]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "GetCallbackUrlParameters")
            else:
                _json = None

        request = build_list_callback_url_request(
            resource_group_name=resource_group_name,
            workflow_name=workflow_name,
            version_id=version_id,
            trigger_name=trigger_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_callback_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("WorkflowTriggerCallbackUrl", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_callback_url.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/versions/{versionId}/triggers/{triggerName}/listCallbackUrl"}  # type: ignore
